//
// Automatically generated by ipdlc.
// Edit at your own risk
//

#ifndef PrefsTypes_h
#define PrefsTypes_h

#include "mozilla/Attributes.h"
#include "IPCMessageStart.h"
#include "mozilla/RefPtr.h"
#include "nsString.h"
#include "nsTArray.h"
#include "nsTHashtable.h"
#include "mozilla/MozPromise.h"
#include "mozilla/OperatorNewExtensions.h"
#include "mozilla/UniquePtr.h"
#include "mozilla/ipc/ByteBuf.h"
#include "mozilla/ipc/FileDescriptor.h"
#include "mozilla/ipc/IPCForwards.h"
#include "mozilla/ipc/Shmem.h"

// Headers for typedefs
#include "mozilla/ipc/IPDLStructMember.h"


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |union PrefValue|
//
namespace mozilla {
namespace dom {
class PrefValue final
{
public:
    enum Type {
        T__None,
        TnsCString = 1,
        Tint32_t,
        Tbool,
        T__Last = Tbool
    };

private:
    typedef ::nsCString nsCString;
    typedef ::int32_t int32_t;
    typedef nsCString nsCString__tdef;
    typedef int32_t int32_t__tdef;
    typedef bool bool__tdef;

    nsCString*
    ptr_nsCString()
    {
        return (&(mVnsCString));
    }
    const nsCString*
    constptr_nsCString() const
    {
        return (&(mVnsCString));
    }
    int32_t*
    ptr_int32_t()
    {
        return (&(mVint32_t));
    }
    const int32_t*
    constptr_int32_t() const
    {
        return (&(mVint32_t));
    }
    bool*
    ptr_bool()
    {
        return (&(mVbool));
    }
    const bool*
    constptr_bool() const
    {
        return (&(mVbool));
    }

    void
    MaybeDestroy();

    void
    AssertSanity() const
    {
        MOZ_RELEASE_ASSERT((T__None) <= (mType), "invalid type tag");
        MOZ_RELEASE_ASSERT((mType) <= (T__Last), "invalid type tag");
    }
    void
    AssertSanity(Type aType) const
    {
        AssertSanity();
        MOZ_RELEASE_ASSERT((mType) == (aType), "unexpected type tag");
    }

public:
    MOZ_IMPLICIT PrefValue() :
        mType(T__None)
    {
    }

    MOZ_IMPLICIT PrefValue(const nsCString& aOther);

    MOZ_IMPLICIT PrefValue(nsCString&& aOther);

    MOZ_IMPLICIT PrefValue(const int32_t& aOther);

    MOZ_IMPLICIT PrefValue(int32_t&& aOther);

    MOZ_IMPLICIT PrefValue(const bool& aOther);

    MOZ_IMPLICIT PrefValue(bool&& aOther);

    MOZ_IMPLICIT PrefValue(const PrefValue& aOther);

    MOZ_IMPLICIT PrefValue(PrefValue&& aOther);

    ~PrefValue();

    Type
    type() const
    {
        return mType;
    }

    PrefValue&
    operator=(const nsCString& aRhs);

    PrefValue&
    operator=(nsCString&& aRhs);

    PrefValue&
    operator=(const int32_t& aRhs);

    PrefValue&
    operator=(int32_t&& aRhs);

    PrefValue&
    operator=(const bool& aRhs);

    PrefValue&
    operator=(bool&& aRhs);

    PrefValue&
    operator=(const PrefValue& aRhs);

    PrefValue&
    operator=(PrefValue&& aRhs);

    nsCString&
    get_nsCString()
    {
        AssertSanity(TnsCString);
        return (*(ptr_nsCString()));
    }
    const nsCString&
    get_nsCString() const
    {
        AssertSanity(TnsCString);
        return (*(constptr_nsCString()));
    }
    operator nsCString&()
    {
        return get_nsCString();
    }
    operator const nsCString&() const
    {
        return get_nsCString();
    }

    int32_t&
    get_int32_t()
    {
        AssertSanity(Tint32_t);
        return (*(ptr_int32_t()));
    }
    const int32_t&
    get_int32_t() const
    {
        AssertSanity(Tint32_t);
        return (*(constptr_int32_t()));
    }
    operator int32_t&()
    {
        return get_int32_t();
    }
    operator const int32_t&() const
    {
        return get_int32_t();
    }

    bool&
    get_bool()
    {
        AssertSanity(Tbool);
        return (*(ptr_bool()));
    }
    const bool&
    get_bool() const
    {
        AssertSanity(Tbool);
        return (*(constptr_bool()));
    }
    operator bool&()
    {
        return get_bool();
    }
    operator const bool&() const
    {
        return get_bool();
    }

private:
    union {
        nsCString mVnsCString;
        int32_t mVint32_t;
        bool mVbool;
    };
    Type mType;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::PrefValue>
{
    typedef ::mozilla::dom::PrefValue paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC


//-----------------------------------------------------------------------------
// Declaration of the IPDL type |struct Pref|
//
namespace mozilla {
namespace dom {
class Pref final
{
private:
    typedef ::nsCString nsCString;
    typedef ::mozilla::dom::PrefValue PrefValue;

public:
#ifdef __clang__
#  pragma clang diagnostic push
#  if __has_warning("-Wdefaulted-function-deleted")
#    pragma clang diagnostic ignored "-Wdefaulted-function-deleted"
#  endif
#endif
    Pref() = default;
#ifdef __clang__
#  pragma clang diagnostic pop
#endif

    MOZ_IMPLICIT Pref(
            const nsCString& _name,
            const bool& _isLocked,
            const bool& _isSanitized,
            const mozilla::Maybe<PrefValue>& _defaultValue,
            const mozilla::Maybe<PrefValue>& _userValue) :
        name_(_name),
        isLocked_(_isLocked),
        isSanitized_(_isSanitized),
        defaultValue_(_defaultValue),
        userValue_(_userValue)
    {
    }

    MOZ_IMPLICIT Pref(
            nsCString&& _name,
            bool&& _isLocked,
            bool&& _isSanitized,
            mozilla::Maybe<PrefValue>&& _defaultValue,
            mozilla::Maybe<PrefValue>&& _userValue) :
        name_(std::move(_name)),
        isLocked_(std::move(_isLocked)),
        isSanitized_(std::move(_isSanitized)),
        defaultValue_(std::move(_defaultValue)),
        userValue_(std::move(_userValue))
    {
    }

    nsCString&
    name()
    {
        return name_;
    }
    const nsCString&
    name() const
    {
        return name_;
    }

    bool&
    isLocked()
    {
        return isLocked_;
    }
    const bool&
    isLocked() const
    {
        return isLocked_;
    }

    bool&
    isSanitized()
    {
        return isSanitized_;
    }
    const bool&
    isSanitized() const
    {
        return isSanitized_;
    }

    mozilla::Maybe<PrefValue>&
    defaultValue()
    {
        return defaultValue_;
    }
    const mozilla::Maybe<PrefValue>&
    defaultValue() const
    {
        return defaultValue_;
    }

    mozilla::Maybe<PrefValue>&
    userValue()
    {
        return userValue_;
    }
    const mozilla::Maybe<PrefValue>&
    userValue() const
    {
        return userValue_;
    }

private:
    ::mozilla::ipc::IPDLStructMember<nsCString> name_;
    ::mozilla::ipc::IPDLStructMember<bool> isLocked_;
    ::mozilla::ipc::IPDLStructMember<bool> isSanitized_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<PrefValue>> defaultValue_;
    ::mozilla::ipc::IPDLStructMember<mozilla::Maybe<PrefValue>> userValue_;
};
} // namespace dom
} // namespace mozilla

namespace IPC {
template<>
struct ParamTraits <::mozilla::dom::Pref>
{
    typedef ::mozilla::dom::Pref paramType;
    static void
    Write(
            IPC::MessageWriter* aWriter,
            const paramType& aVar);
    static IPC::ReadResult<paramType>
    Read(IPC::MessageReader* aReader);
};
} // namespace IPC

#endif // ifndef PrefsTypes_h
