// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanNetwerkCache2Metrics_h
#define mozilla_GleanNetwerkCache2Metrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace network {
  /**
   * generated from network.cache_entry_count
   */
  enum class CacheEntryCountLabel: uint16_t {
    eSmartsize = 0,
    eUserdefinedsize = 1,
    e__Other__,
  };
  /**
   * Number of entries in the cache keyed by cache capacity calculation type. Numbers are sampled periodically, every time 2GB of data is written to the cache.
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram NETWORK_CACHE_ENTRY_COUNT.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, CacheEntryCountLabel> cache_entry_count(4182);

  /**
   * generated from network.cache_entry_count_share
   */
  enum class CacheEntryCountShareLabel: uint16_t {
    eUnknown = 0,
    eOther = 1,
    eJavascript = 2,
    eImage = 3,
    eMedia = 4,
    eStylesheet = 5,
    eWasm = 6,
    e__Other__,
  };
  /**
   * Percentage of the entries with the given content type. Numbers are sampled periodically, every time 2GB of data is written to the cache.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram NETWORK_CACHE_ENTRY_COUNT_SHARE.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, CacheEntryCountShareLabel> cache_entry_count_share(4183);

  /**
   * generated from network.cache_size
   */
  enum class CacheSizeLabel: uint16_t {
    eSmartsize = 0,
    eUserdefinedsize = 1,
    e__Other__,
  };
  /**
   * Cache size in megabytes keyed by cache capacity calculation type. Numbers are sampled periodically, every time 2GB of data is written to the cache.
   * This metric was generated to correspond to the Legacy Telemetry linear histogram NETWORK_CACHE_SIZE.
   */
  constexpr impl::Labeled<impl::MemoryDistributionMetric, CacheSizeLabel> cache_size(4184);

  /**
   * generated from network.cache_size_share
   */
  enum class CacheSizeShareLabel: uint16_t {
    eUnknown = 0,
    eOther = 1,
    eJavascript = 2,
    eImage = 3,
    eMedia = 4,
    eStylesheet = 5,
    eWasm = 6,
    e__Other__,
  };
  /**
   * Percentage of the cache size occupied by given content type. Numbers are sampled periodically, every time 2GB of data is written to the cache.
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram NETWORK_CACHE_SIZE_SHARE.
   */
  constexpr impl::Labeled<impl::CustomDistributionMetric, CacheSizeShareLabel> cache_size_share(4185);

  /**
   * generated from network.cache_v2_input_stream_status
   * Final status of the CacheFileInputStream (0=ok, 1=other error, 2=out of memory, 3=disk full, 4=file corrupted, 5=file not found, 6=binding aborted)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram NETWORK_CACHE_V2_INPUT_STREAM_STATUS.
   */
  constexpr impl::CustomDistributionMetric cache_v2_input_stream_status(4186);

  /**
   * generated from network.cache_v2_output_stream_status
   * Final status of the CacheFileOutputStream (0=ok, 1=other error, 2=out of memory, 3=disk full, 4=file corrupted, 5=file not found, 6=binding aborted)
   * This metric was generated to correspond to the Legacy Telemetry enumerated histogram NETWORK_CACHE_V2_OUTPUT_STREAM_STATUS.
   */
  constexpr impl::CustomDistributionMetric cache_v2_output_stream_status(4187);

  /**
   * generated from network.disk_cache2_shutdown_clear_private
   * Time spent (ms) during shutdown deleting disk cache v2 for 'clear private data' option
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram NETWORK_DISK_CACHE2_SHUTDOWN_CLEAR_PRIVATE.
   */
  constexpr impl::TimingDistributionMetric disk_cache2_shutdown_clear_private(4188);

  /**
   * generated from network.disk_cache_shutdown_v2
   * Total Time spent (ms) during disk cache shutdown [cache2]
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram NETWORK_DISK_CACHE_SHUTDOWN_V2.
   */
  constexpr impl::TimingDistributionMetric disk_cache_shutdown_v2(4189);

  /**
   * generated from network.http_cache_entry_alive_time
   * Time for which an HTTP cache entry is kept warmed in memory
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HTTP_CACHE_ENTRY_ALIVE_TIME.
   */
  constexpr impl::TimingDistributionMetric http_cache_entry_alive_time(4190);

  /**
   * generated from network.http_cache_entry_reload_time
   * Time before we reload an HTTP cache entry again to memory
   * This metric was generated to correspond to the Legacy Telemetry exponential histogram HTTP_CACHE_ENTRY_RELOAD_TIME.
   */
  constexpr impl::TimingDistributionMetric http_cache_entry_reload_time(4191);

  /**
   * generated from network.http_cache_entry_reuse_count
   * Reuse count of an HTTP cache entry warmed in memory
   * This metric was generated to correspond to the Legacy Telemetry linear histogram HTTP_CACHE_ENTRY_REUSE_COUNT.
   */
  constexpr impl::CustomDistributionMetric http_cache_entry_reuse_count(4192);
}

} // namespace mozilla::glean

#endif // mozilla_GleanNetwerkCache2Metrics_h
