
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "webinspector_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_WebInspector_Type = nullptr;
static PyTypeObject *Sbk_WebInspector_TypeF(void)
{
    return _Sbk_WebInspector_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void WebInspectorWrapper::pysideInitQtMetaTypes()
{
}

void WebInspectorWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

WebInspectorWrapper::WebInspectorWrapper(::QWebEngineProfile * profile, ::QWidget * parent) : WebInspector(profile, parent)
{
}

WebInspectorWrapper::WebInspectorWrapper(::QWidget * parent) : WebInspector(parent)
{
}

void WebInspectorWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    WebViewWrapper::sbk_o_actionEvent("WebInspector", funcName, gil, pyOverride, event);
}

void WebInspectorWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    WebViewWrapper::sbk_o_changeEvent("WebInspector", funcName, gil, pyOverride, event);
}

void WebInspectorWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("WebInspector", funcName, gil, pyOverride, event);
}

void WebInspectorWrapper::closeEvent(::QCloseEvent * arg__1)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEngineView::closeEvent(arg__1);
    }
    WebViewWrapper::sbk_o_closeEvent("WebInspector", funcName, gil, pyOverride, arg__1);
}

void WebInspectorWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("WebInspector", funcName, gil, pyOverride, signal);
}

void WebInspectorWrapper::contextMenuEvent(::QContextMenuEvent * arg__1)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEngineView::contextMenuEvent(arg__1);
    }
    WebViewWrapper::sbk_o_contextMenuEvent("WebInspector", funcName, gil, pyOverride, arg__1);
}

::QWebEngineView * WebInspectorWrapper::createWindow(::QWebEnginePage::WebWindowType type)
{
    static const char *funcName = "createWindow";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEngineView::createWindow(type);
    }
    return WebViewWrapper::sbk_o_createWindow("WebInspector", funcName, gil, pyOverride, type);
}

void WebInspectorWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("WebInspector", funcName, gil, pyOverride, event);
}

int WebInspectorWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return WebViewWrapper::sbk_o_devType("WebInspector", funcName, gil, pyOverride);
}

void WebInspectorWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("WebInspector", funcName, gil, pyOverride, signal);
}

void WebInspectorWrapper::dragEnterEvent(::QDragEnterEvent * e)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEngineView::dragEnterEvent(e);
    }
    WebViewWrapper::sbk_o_dragEnterEvent("WebInspector", funcName, gil, pyOverride, e);
}

void WebInspectorWrapper::dragLeaveEvent(::QDragLeaveEvent * e)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEngineView::dragLeaveEvent(e);
    }
    WebViewWrapper::sbk_o_dragLeaveEvent("WebInspector", funcName, gil, pyOverride, e);
}

void WebInspectorWrapper::dragMoveEvent(::QDragMoveEvent * e)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEngineView::dragMoveEvent(e);
    }
    WebViewWrapper::sbk_o_dragMoveEvent("WebInspector", funcName, gil, pyOverride, e);
}

void WebInspectorWrapper::dropEvent(::QDropEvent * e)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEngineView::dropEvent(e);
    }
    WebViewWrapper::sbk_o_dropEvent("WebInspector", funcName, gil, pyOverride, e);
}

void WebInspectorWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    WebViewWrapper::sbk_o_enterEvent("WebInspector", funcName, gil, pyOverride, event);
}

bool WebInspectorWrapper::event(::QEvent * arg__1)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEngineView::event(arg__1);
    }
    return WebViewWrapper::sbk_o_event("WebInspector", funcName, gil, pyOverride, arg__1);
}

bool WebInspectorWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("WebInspector", funcName, gil, pyOverride, watched, event);
}

void WebInspectorWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    WebViewWrapper::sbk_o_focusInEvent("WebInspector", funcName, gil, pyOverride, event);
}

bool WebInspectorWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return WebViewWrapper::sbk_o_focusNextPrevChild("WebInspector", funcName, gil, pyOverride, next);
}

void WebInspectorWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    WebViewWrapper::sbk_o_focusOutEvent("WebInspector", funcName, gil, pyOverride, event);
}

bool WebInspectorWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("WebInspector", funcName, gil, pyOverride);
}

int WebInspectorWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return WebViewWrapper::sbk_o_heightForWidth("WebInspector", funcName, gil, pyOverride, arg__1);
}

void WebInspectorWrapper::hideEvent(::QHideEvent * arg__1)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEngineView::hideEvent(arg__1);
    }
    WebViewWrapper::sbk_o_hideEvent("WebInspector", funcName, gil, pyOverride, arg__1);
}

void WebInspectorWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    WebViewWrapper::sbk_o_initPainter("WebInspector", funcName, gil, pyOverride, painter);
}

void WebInspectorWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    WebViewWrapper::sbk_o_inputMethodEvent("WebInspector", funcName, gil, pyOverride, event);
}

::QVariant WebInspectorWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return WebViewWrapper::sbk_o_inputMethodQuery("WebInspector", funcName, gil, pyOverride, arg__1);
}

void WebInspectorWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    WebViewWrapper::sbk_o_leaveEvent("WebInspector", funcName, gil, pyOverride, event);
}

int WebInspectorWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return WebViewWrapper::sbk_o_metric("WebInspector", funcName, gil, pyOverride, arg__1);
}

::QSize WebInspectorWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("WebInspector", funcName, gil, pyOverride);
}

void WebInspectorWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    WebViewWrapper::sbk_o_mouseDoubleClickEvent("WebInspector", funcName, gil, pyOverride, event);
}

void WebInspectorWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    WebViewWrapper::sbk_o_mouseMoveEvent("WebInspector", funcName, gil, pyOverride, event);
}

void WebInspectorWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    WebViewWrapper::sbk_o_mousePressEvent("WebInspector", funcName, gil, pyOverride, event);
}

void WebInspectorWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_mouseReleaseEvent("WebInspector", funcName, gil, pyOverride, event);
}

void WebInspectorWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    WebViewWrapper::sbk_o_moveEvent("WebInspector", funcName, gil, pyOverride, event);
}

bool WebInspectorWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return WebViewWrapper::sbk_o_nativeEvent("WebInspector", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * WebInspectorWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return WebViewWrapper::sbk_o_paintEngine("WebInspector", funcName, gil, pyOverride);
}

void WebInspectorWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    WebViewWrapper::sbk_o_paintEvent("WebInspector", funcName, gil, pyOverride, event);
}

::QPaintDevice * WebInspectorWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return WebViewWrapper::sbk_o_redirected("WebInspector", funcName, gil, pyOverride, offset);
}

void WebInspectorWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    WebViewWrapper::sbk_o_resizeEvent("WebInspector", funcName, gil, pyOverride, event);
}

void WebInspectorWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    WebViewWrapper::sbk_o_requestFullScreen("WebInspector", funcName, gil, pyOverride, visible);
}

::QPainter * WebInspectorWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return WebViewWrapper::sbk_o_sharedPainter("WebInspector", funcName, gil, pyOverride);
}

void WebInspectorWrapper::showEvent(::QShowEvent * arg__1)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWebEngineView::showEvent(arg__1);
    }
    WebViewWrapper::sbk_o_showEvent("WebInspector", funcName, gil, pyOverride, arg__1);
}

::QSize WebInspectorWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::WebInspector::sizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("WebInspector", funcName, gil, pyOverride);
}

void WebInspectorWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    WebViewWrapper::sbk_o_tabletEvent("WebInspector", funcName, gil, pyOverride, event);
}

void WebInspectorWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("WebInspector", funcName, gil, pyOverride, event);
}

void WebInspectorWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_WebInspector_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    WebViewWrapper::sbk_o_wheelEvent("WebInspector", funcName, gil, pyOverride, event);
}

const QMetaObject *WebInspectorWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return WebInspector::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int WebInspectorWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = WebInspector::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *WebInspectorWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< WebInspectorWrapper *>(this));
    }
    return WebInspector::qt_metacast(_clname);
}

WebInspectorWrapper::~WebInspectorWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_WebInspector_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_WebInspector_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::WebInspector >()))
        return -1;

    WebInspectorWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OO:WebInspector", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: WebInspector::WebInspector(QWebEngineProfile*,QWidget*=)
    // 1: WebInspector::WebInspector(QWidget*=)
    if (numArgs == 0) {
        overloadId = 1; // WebInspector(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))) {
        overloadId = 1; // WebInspector(QWidget*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineProfile_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // WebInspector(QWebEngineProfile*,QWidget*)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1])))) {
            overloadId = 0; // WebInspector(QWebEngineProfile*,QWidget*)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_WebInspector_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_WebInspector_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // WebInspector(QWebEngineProfile *profile, QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 1}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[1]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_WebInspector_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWebEngineProfile *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QWidget *cppArg1 = nullptr;
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // WebInspector(QWebEngineProfile*,QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) WebInspectorWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new WebInspectorWrapper(cppArg0, cppArg1);
                }

                // Ownership transferences (constructor heuristics).
                Shiboken::Object::setParent(pyArgs[1], self);
            }
            break;
        }
        case 1: // WebInspector(QWidget *parent)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
                if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_WebInspector_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0 = nullptr;
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // WebInspector(QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr != nullptr) {
                    cptr = new (addr) WebInspectorWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(nullptr);
                } else {
                    cptr = new WebInspectorWrapper(cppArg0);
                }

                // Ownership transferences (constructor heuristics).
                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< WebInspector >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_WebInspector_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_WebInspector_IDX]);
    };


    return 1;
}

static PyObject *Sbk_WebInspectorFunc_inspectElement(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebInspectorWrapper *>(reinterpret_cast< ::WebInspector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebInspector_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // inspectElement()
        cppSelf->inspectElement();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebInspectorFunc_isEnabled(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isEnabled()
        bool cppResult = ::WebInspector::isEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebInspectorFunc_keyPressEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebInspectorWrapper *>(reinterpret_cast< ::WebInspector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebInspector_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::keyPressEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeyEvent_IDX]), (pyArg)))) {
        overloadId = 0; // keyPressEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "keyPressEvent", errInfo, SbkPyFalkonTypeStructs[SBK_WebInspector_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("keyPressEvent(QKeyEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebInspectorFunc_keyReleaseEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebInspectorWrapper *>(reinterpret_cast< ::WebInspector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebInspector_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::keyReleaseEvent(QKeyEvent*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QKeyEvent_IDX]), (pyArg)))) {
        overloadId = 0; // keyReleaseEvent(QKeyEvent*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "keyReleaseEvent", errInfo, SbkPyFalkonTypeStructs[SBK_WebInspector_IDX]);

    // Call function/method
    {
        Shiboken::Errors::setPrivateMethod("keyReleaseEvent(QKeyEvent *event)");
        return {};
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebInspectorFunc_pushView(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static WebInspector::pushView(QWebEngineView*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWebEngineWidgetsTypeStructs[SBK_QWebEngineView_IDX]), (pyArg)))) {
        overloadId = 0; // pushView(QWebEngineView*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "pushView", errInfo, SbkPyFalkonTypeStructs[SBK_WebInspector_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWebEngineView *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // pushView(QWebEngineView*)
            ::WebInspector::pushView(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebInspectorFunc_registerView(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static WebInspector::registerView(QWebEngineView*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWebEngineWidgetsTypeStructs[SBK_QWebEngineView_IDX]), (pyArg)))) {
        overloadId = 0; // registerView(QWebEngineView*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "registerView", errInfo, SbkPyFalkonTypeStructs[SBK_WebInspector_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWebEngineView *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // registerView(QWebEngineView*)
            ::WebInspector::registerView(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebInspectorFunc_setView(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebInspectorWrapper *>(reinterpret_cast< ::WebInspector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebInspector_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: WebInspector::setView(WebView*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebView_IDX]), (pyArg)))) {
        overloadId = 0; // setView(WebView*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setView", errInfo, SbkPyFalkonTypeStructs[SBK_WebInspector_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::WebView *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setView(WebView*)
            cppSelf->setView(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_WebInspectorFunc_sizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<WebInspectorWrapper *>(reinterpret_cast< ::WebInspector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebInspector_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // sizeHint()const
        QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const WebInspectorWrapper *>(cppSelf)->::WebInspector::sizeHint()
            : const_cast<const WebInspectorWrapper *>(cppSelf)->sizeHint();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QSize_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_WebInspectorFunc_unregisterView(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static WebInspector::unregisterView(QWebEngineView*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWebEngineWidgetsTypeStructs[SBK_QWebEngineView_IDX]), (pyArg)))) {
        overloadId = 0; // unregisterView(QWebEngineView*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "unregisterView", errInfo, SbkPyFalkonTypeStructs[SBK_WebInspector_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWebEngineView *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // unregisterView(QWebEngineView*)
            ::WebInspector::unregisterView(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_WebInspector_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_WebInspector_methods[] = {
    {"inspectElement", reinterpret_cast<PyCFunction>(Sbk_WebInspectorFunc_inspectElement), METH_NOARGS, nullptr},
    {"isEnabled", reinterpret_cast<PyCFunction>(Sbk_WebInspectorFunc_isEnabled), METH_NOARGS|METH_STATIC, nullptr},
    {"keyPressEvent", reinterpret_cast<PyCFunction>(Sbk_WebInspectorFunc_keyPressEvent), METH_O, nullptr},
    {"keyReleaseEvent", reinterpret_cast<PyCFunction>(Sbk_WebInspectorFunc_keyReleaseEvent), METH_O, nullptr},
    {"pushView", reinterpret_cast<PyCFunction>(Sbk_WebInspectorFunc_pushView), METH_O|METH_STATIC, nullptr},
    {"registerView", reinterpret_cast<PyCFunction>(Sbk_WebInspectorFunc_registerView), METH_O|METH_STATIC, nullptr},
    {"setView", reinterpret_cast<PyCFunction>(Sbk_WebInspectorFunc_setView), METH_O, nullptr},
    {"sizeHint", reinterpret_cast<PyCFunction>(Sbk_WebInspectorFunc_sizeHint), METH_NOARGS, nullptr},
    {"unregisterView", reinterpret_cast<PyCFunction>(Sbk_WebInspectorFunc_unregisterView), METH_O|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_WebInspector_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::WebInspector *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_WebInspector_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<WebInspectorWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_WebInspector_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_WebInspector_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_WebInspectorSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::WebInspector *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWebEngineWidgetsTypeStructs[SBK_QWebEngineView_IDX]))
        return static_cast< ::QWebEngineView *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_WebInspector_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_WebInspector_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_WebInspector_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_WebInspector_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_WebInspector_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_WebInspector_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_WebInspector_spec = {
    "1:PyFalkon.WebInspector",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_WebInspector_slots
};

} //extern "C"

static void *Sbk_WebInspector_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::WebInspector *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::WebInspector *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::WebInspector *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void WebInspector_PythonToCpp_WebInspector_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_WebInspector_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_WebInspector_PythonToCpp_WebInspector_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_WebInspector_TypeF()))
        return WebInspector_PythonToCpp_WebInspector_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *WebInspector_PTR_CppToPython_WebInspector(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::WebInspector *>(const_cast<void *>(cppIn)), Sbk_WebInspector_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *WebInspector_SignatureStrings[] = {
    "1:PyFalkon.WebInspector(self,profile:PySide6.QtWebEngineCore.QWebEngineProfile,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "0:PyFalkon.WebInspector(self,parent:PySide6.QtWidgets.QWidget=nullptr)",
    "PyFalkon.WebInspector.inspectElement(self)",
    "PyFalkon.WebInspector.isEnabled()->bool",
    "PyFalkon.WebInspector.keyPressEvent(self,event:PySide6.QtGui.QKeyEvent)",
    "PyFalkon.WebInspector.keyReleaseEvent(self,event:PySide6.QtGui.QKeyEvent)",
    "PyFalkon.WebInspector.pushView(view:PySide6.QtWebEngineWidgets.QWebEngineView)",
    "PyFalkon.WebInspector.registerView(view:PySide6.QtWebEngineWidgets.QWebEngineView)",
    "PyFalkon.WebInspector.setView(self,view:PyFalkon.WebView)",
    "PyFalkon.WebInspector.sizeHint(self)->PySide6.QtCore.QSize",
    "PyFalkon.WebInspector.unregisterView(view:PySide6.QtWebEngineWidgets.QWebEngineView)",
    nullptr}; // Sentinel
#else
static constexpr size_t WebInspector_SignatureByteSize = 238;
static constexpr uint8_t WebInspector_SignatureBytes[238] = {
    0x78, 0xda, 0xad, 0x92, 0x3d, 0x4f, 0xc3, 0x30, 0x10, 0x86, 0x77, 0x7e, 0x49, 0x22, 0xa5, 0x16,
    0x2c, 0x1d, 0x2a, 0xb5, 0x0b, 0x0a, 0x1f, 0x62, 0x49, 0xa8, 0x04, 0x73, 0x42, 0xde, 0x86, 0x53,
    0x8d, 0x6d, 0xf9, 0x9c, 0xa0, 0xf4, 0xd7, 0x63, 0x1c, 0x42, 0x40, 0xaa, 0x2b, 0xa4, 0xb2, 0x58,
    0x67, 0xfb, 0xb9, 0xc7, 0x77, 0xb6, 0xaf, 0x56, 0xc5, 0x70, 0x53, 0xc9, 0xbd, 0x56, 0xe2, 0x19,
    0xf5, 0xbd, 0x62, 0x83, 0x17, 0xa7, 0x6d, 0xc2, 0x90, 0xbb, 0xcc, 0x58, 0xbd, 0x23, 0x09, 0x8f,
    0x6c, 0xa9, 0xc1, 0x52, 0x94, 0xce, 0x33, 0xb9, 0x6a, 0x49, 0xe1, 0x5a, 0x5b, 0x88, 0xf2, 0x7b,
    0x5a, 0x8c, 0x64, 0x66, 0x2a, 0x0b, 0xe5, 0x7e, 0x26, 0x50, 0xd3, 0xc2, 0xb1, 0x47, 0x43, 0xb0,
    0x56, 0x9d, 0x94, 0xc6, 0xd9, 0xf4, 0xe2, 0xf2, 0xe4, 0xc1, 0x7f, 0xd6, 0x1c, 0x95, 0x08, 0x1a,
    0xa3, 0x5c, 0xe2, 0xcd, 0x7b, 0x82, 0x33, 0x8a, 0x72, 0xae, 0xaa, 0x5a, 0xa2, 0x49, 0xd2, 0xc5,
    0xa6, 0xd6, 0x5a, 0x46, 0xb8, 0x3d, 0x86, 0xc2, 0x82, 0x39, 0xef, 0x27, 0x63, 0x86, 0xfe, 0x77,
    0x91, 0xb7, 0x1d, 0x89, 0xf2, 0x01, 0x43, 0x40, 0xd2, 0xb8, 0xe7, 0x11, 0x12, 0x15, 0xe3, 0x5c,
    0x93, 0xe9, 0xf8, 0xf5, 0x89, 0xf0, 0x9e, 0xf4, 0x7e, 0x38, 0xf6, 0x46, 0xf3, 0xa5, 0x4d, 0x2b,
    0x9f, 0x78, 0x4c, 0x67, 0xd1, 0x12, 0x3b, 0xd8, 0x7f, 0x54, 0x32, 0x5c, 0xb0, 0x85, 0x1e, 0xbf,
    0x94, 0x33, 0x77, 0x32, 0x93, 0x0e, 0xb8, 0xa3, 0xe9, 0xe9, 0x16, 0x9b, 0xb9, 0x94, 0xf1, 0xe3,
    0x6d, 0xfd, 0x7e, 0x24, 0xb5, 0x53, 0x67, 0x75, 0xf2, 0x01, 0x8e, 0xea, 0x21, 0x7d
};
#endif

PyTypeObject *init_WebInspector(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_WebInspector_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_WebInspector_IDX].type;

    Shiboken::AutoDecRef Sbk_WebInspector_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWebEngineWidgetsTypeStructs[SBK_QWebEngineView_IDX]))));

    _Sbk_WebInspector_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "WebInspector",
        "WebInspector*",
        &Sbk_WebInspector_spec,
        &Shiboken::callCppDestructor< WebInspector >,
        Sbk_WebInspector_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_WebInspector_Type; // references _Sbk_WebInspector_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, WebInspector_SignatureStrings);
#else
    InitSignatureBytes(pyType, WebInspector_SignatureBytes, WebInspector_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_WebInspector_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_WebInspector_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        WebInspector_PythonToCpp_WebInspector_PTR,
        is_WebInspector_PythonToCpp_WebInspector_PTR_Convertible,
        WebInspector_PTR_CppToPython_WebInspector);

    Shiboken::Conversions::registerConverterName(converter, "WebInspector");
    Shiboken::Conversions::registerConverterName(converter, "WebInspector*");
    Shiboken::Conversions::registerConverterName(converter, "WebInspector&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::WebInspector).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(WebInspectorWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_WebInspector_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_WebInspector_TypeF(), &Sbk_WebInspectorSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_WebInspector_TypeF(), &Sbk_WebInspector_typeDiscovery);

    WebInspectorWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::WebInspector::staticMetaObject, sizeof(WebInspectorWrapper));

    return pyType;
}
