/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSPushSubscriptionOptionsInit.h"

#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertBufferSource.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMConvertUnion.h"
#include <JavaScriptCore/JSCInlines.h>
#include <wtf/Variant.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<PushSubscriptionOptionsInit>> convertDictionary<PushSubscriptionOptionsInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    PushSubscriptionOptionsInit result;
    JSValue applicationServerKeyValue;
    if (isNullOrUndefined)
        applicationServerKeyValue = jsUndefined();
    else {
        applicationServerKeyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "applicationServerKey"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto applicationServerKeyConversionResult = convertOptionalWithDefault<IDLNullable<IDLUnion<IDLArrayBufferView, IDLArrayBuffer, IDLDOMString>>>(lexicalGlobalObject, applicationServerKeyValue, [&]() -> ConversionResult<IDLNullable<IDLUnion<IDLArrayBufferView, IDLArrayBuffer, IDLDOMString>>> { return typename Converter<IDLNullable<IDLUnion<IDLArrayBufferView, IDLArrayBuffer, IDLDOMString>>>::ReturnType { std::nullopt }; });
    if (applicationServerKeyConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.applicationServerKey = applicationServerKeyConversionResult.releaseReturnValue();
    JSValue userVisibleOnlyValue;
    if (isNullOrUndefined)
        userVisibleOnlyValue = jsUndefined();
    else {
        userVisibleOnlyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "userVisibleOnly"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto userVisibleOnlyConversionResult = convertOptionalWithDefault<IDLBoolean>(lexicalGlobalObject, userVisibleOnlyValue, [&]() -> ConversionResult<IDLBoolean> { return Converter<IDLBoolean>::ReturnType { false }; });
    if (userVisibleOnlyConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.userVisibleOnly = userVisibleOnlyConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

