/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNavigation.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "DOMPromiseProxy.h"
#include "EventNames.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMAttribute.h"
#include "JSDOMBinding.h"
#include "JSDOMConstructorNotConstructable.h"
#include "JSDOMConvertAny.h"
#include "JSDOMConvertBase.h"
#include "JSDOMConvertBoolean.h"
#include "JSDOMConvertInterface.h"
#include "JSDOMConvertNullable.h"
#include "JSDOMConvertOptional.h"
#include "JSDOMConvertPromise.h"
#include "JSDOMConvertSequences.h"
#include "JSDOMConvertStrings.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMGlobalObject.h"
#include "JSDOMGlobalObjectInlines.h"
#include "JSDOMOperation.h"
#include "JSDOMOperationReturningPromise.h"
#include "JSDOMWrapperCache.h"
#include "JSEventListener.h"
#include "JSNavigationActivation.h"
#include "JSNavigationHistoryEntry.h"
#include "JSNavigationTransition.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSArray.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/JSString.h>
#include <JavaScriptCore/ObjectConstructor.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/SortedArrayMap.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

String convertEnumerationToString(Navigation::HistoryBehavior enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 3> values {
        MAKE_STATIC_STRING_IMPL("auto"),
        MAKE_STATIC_STRING_IMPL("push"),
        MAKE_STATIC_STRING_IMPL("replace"),
    };
    static_assert(static_cast<size_t>(Navigation::HistoryBehavior::Auto) == 0, "Navigation::HistoryBehavior::Auto is not 0 as expected");
    static_assert(static_cast<size_t>(Navigation::HistoryBehavior::Push) == 1, "Navigation::HistoryBehavior::Push is not 1 as expected");
    static_assert(static_cast<size_t>(Navigation::HistoryBehavior::Replace) == 2, "Navigation::HistoryBehavior::Replace is not 2 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, Navigation::HistoryBehavior enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<Navigation::HistoryBehavior> parseEnumerationFromString<Navigation::HistoryBehavior>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, Navigation::HistoryBehavior>, 3> mappings {
        std::pair<ComparableASCIILiteral, Navigation::HistoryBehavior> { "auto"_s, Navigation::HistoryBehavior::Auto },
        std::pair<ComparableASCIILiteral, Navigation::HistoryBehavior> { "push"_s, Navigation::HistoryBehavior::Push },
        std::pair<ComparableASCIILiteral, Navigation::HistoryBehavior> { "replace"_s, Navigation::HistoryBehavior::Replace },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<Navigation::HistoryBehavior> parseEnumeration<Navigation::HistoryBehavior>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<Navigation::HistoryBehavior>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<Navigation::HistoryBehavior>()
{
    return "\"auto\", \"push\", \"replace\""_s;
}

template<> ConversionResult<IDLDictionary<Navigation::UpdateCurrentEntryOptions>> convertDictionary<Navigation::UpdateCurrentEntryOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    Navigation::UpdateCurrentEntryOptions result;
    JSValue stateValue;
    if (isNullOrUndefined)
        stateValue = jsUndefined();
    else {
        stateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "state"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (stateValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "state"_s, "NavigationUpdateCurrentEntryOptions"_s, "any"_s);
        return ConversionResultException { };
    }
    auto stateConversionResult = convert<IDLAny>(lexicalGlobalObject, stateValue);
    if (stateConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.state = stateConversionResult.releaseReturnValue();
    return result;
}

template<> ConversionResult<IDLDictionary<Navigation::Options>> convertDictionary<Navigation::Options>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    Navigation::Options result;
    JSValue infoValue;
    if (isNullOrUndefined)
        infoValue = jsUndefined();
    else {
        infoValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "info"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto infoConversionResult = convertOptionalWithDefault<IDLAny>(lexicalGlobalObject, infoValue, [&]() -> ConversionResult<IDLAny> { return Converter<IDLAny>::ReturnType { jsUndefined() }; });
    if (infoConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.info = infoConversionResult.releaseReturnValue();
    return result;
}

template<> ConversionResult<IDLDictionary<Navigation::NavigateOptions>> convertDictionary<Navigation::NavigateOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    Navigation::NavigateOptions result;
    JSValue infoValue;
    if (isNullOrUndefined)
        infoValue = jsUndefined();
    else {
        infoValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "info"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto infoConversionResult = convertOptionalWithDefault<IDLAny>(lexicalGlobalObject, infoValue, [&]() -> ConversionResult<IDLAny> { return Converter<IDLAny>::ReturnType { jsUndefined() }; });
    if (infoConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.info = infoConversionResult.releaseReturnValue();
    JSValue historyValue;
    if (isNullOrUndefined)
        historyValue = jsUndefined();
    else {
        historyValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "history"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto historyConversionResult = convertOptionalWithDefault<IDLEnumeration<Navigation::HistoryBehavior>>(lexicalGlobalObject, historyValue, [&]() -> ConversionResult<IDLEnumeration<Navigation::HistoryBehavior>> { return Converter<IDLEnumeration<Navigation::HistoryBehavior>>::ReturnType { Navigation::HistoryBehavior::Auto }; });
    if (historyConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.history = historyConversionResult.releaseReturnValue();
    JSValue stateValue;
    if (isNullOrUndefined)
        stateValue = jsUndefined();
    else {
        stateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "state"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto stateConversionResult = convertOptionalWithDefault<IDLAny>(lexicalGlobalObject, stateValue, [&]() -> ConversionResult<IDLAny> { return Converter<IDLAny>::ReturnType { jsUndefined() }; });
    if (stateConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.state = stateConversionResult.releaseReturnValue();
    return result;
}

template<> ConversionResult<IDLDictionary<Navigation::ReloadOptions>> convertDictionary<Navigation::ReloadOptions>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    Navigation::ReloadOptions result;
    JSValue infoValue;
    if (isNullOrUndefined)
        infoValue = jsUndefined();
    else {
        infoValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "info"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto infoConversionResult = convertOptionalWithDefault<IDLAny>(lexicalGlobalObject, infoValue, [&]() -> ConversionResult<IDLAny> { return Converter<IDLAny>::ReturnType { jsUndefined() }; });
    if (infoConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.info = infoConversionResult.releaseReturnValue();
    JSValue stateValue;
    if (isNullOrUndefined)
        stateValue = jsUndefined();
    else {
        stateValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "state"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    auto stateConversionResult = convertOptionalWithDefault<IDLAny>(lexicalGlobalObject, stateValue, [&]() -> ConversionResult<IDLAny> { return Converter<IDLAny>::ReturnType { jsUndefined() }; });
    if (stateConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.state = stateConversionResult.releaseReturnValue();
    return result;
}

JSC::JSObject* convertDictionaryToJS(JSC::JSGlobalObject& lexicalGlobalObject, JSDOMGlobalObject& globalObject, const Navigation::Result& dictionary)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);

    auto result = constructEmptyObject(&lexicalGlobalObject, globalObject.objectPrototype());

    if (!IDLPromiseIgnoringSuspension<IDLInterface<NavigationHistoryEntry>>::isNullValue(dictionary.committed)) {
        auto committedValue = toJS<IDLPromiseIgnoringSuspension<IDLInterface<NavigationHistoryEntry>>>(lexicalGlobalObject, globalObject, throwScope, [&]() -> decltype(auto) { return IDLPromiseIgnoringSuspension<IDLInterface<NavigationHistoryEntry>>::extractValueFromNullable(dictionary.committed); });
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "committed"_s), committedValue);
    }
    if (!IDLPromiseIgnoringSuspension<IDLInterface<NavigationHistoryEntry>>::isNullValue(dictionary.finished)) {
        auto finishedValue = toJS<IDLPromiseIgnoringSuspension<IDLInterface<NavigationHistoryEntry>>>(lexicalGlobalObject, globalObject, throwScope, [&]() -> decltype(auto) { return IDLPromiseIgnoringSuspension<IDLInterface<NavigationHistoryEntry>>::extractValueFromNullable(dictionary.finished); });
        RETURN_IF_EXCEPTION(throwScope, { });
        result->putDirect(vm, JSC::Identifier::fromString(vm, "finished"_s), finishedValue);
    }
    return result;
}

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsNavigationPrototypeFunction_entries);
static JSC_DECLARE_HOST_FUNCTION(jsNavigationPrototypeFunction_updateCurrentEntry);
static JSC_DECLARE_HOST_FUNCTION(jsNavigationPrototypeFunction_navigate);
static JSC_DECLARE_HOST_FUNCTION(jsNavigationPrototypeFunction_reload);
static JSC_DECLARE_HOST_FUNCTION(jsNavigationPrototypeFunction_traverseTo);
static JSC_DECLARE_HOST_FUNCTION(jsNavigationPrototypeFunction_back);
static JSC_DECLARE_HOST_FUNCTION(jsNavigationPrototypeFunction_forward);

// Attributes

static JSC_DECLARE_CUSTOM_GETTER(jsNavigationConstructor);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigation_currentEntry);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigation_transition);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigation_activation);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigation_canGoBack);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigation_canGoForward);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigation_onnavigate);
static JSC_DECLARE_CUSTOM_SETTER(setJSNavigation_onnavigate);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigation_onnavigatesuccess);
static JSC_DECLARE_CUSTOM_SETTER(setJSNavigation_onnavigatesuccess);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigation_onnavigateerror);
static JSC_DECLARE_CUSTOM_SETTER(setJSNavigation_onnavigateerror);
static JSC_DECLARE_CUSTOM_GETTER(jsNavigation_oncurrententrychange);
static JSC_DECLARE_CUSTOM_SETTER(setJSNavigation_oncurrententrychange);

class JSNavigationPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSNavigationPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSNavigationPrototype* ptr = new (NotNull, JSC::allocateCell<JSNavigationPrototype>(vm)) JSNavigationPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNavigationPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSNavigationPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSNavigationPrototype, JSNavigationPrototype::Base);

using JSNavigationDOMConstructor = JSDOMConstructorNotConstructable<JSNavigation>;

template<> const ClassInfo JSNavigationDOMConstructor::s_info = { "Navigation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigationDOMConstructor) };

template<> JSValue JSNavigationDOMConstructor::prototypeForStructure(JSC::VM& vm, const JSDOMGlobalObject& globalObject)
{
    return JSEventTarget::getConstructor(vm, &globalObject);
}

template<> void JSNavigationDOMConstructor::initializeProperties(VM& vm, JSDOMGlobalObject& globalObject)
{
    putDirect(vm, vm.propertyNames->length, jsNumber(0), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    JSString* nameString = jsNontrivialString(vm, "Navigation"_s);
    m_originalName.set(vm, this, nameString);
    putDirect(vm, vm.propertyNames->name, nameString, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum);
    putDirect(vm, vm.propertyNames->prototype, JSNavigation::prototype(vm, globalObject), JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::DontEnum | JSC::PropertyAttribute::DontDelete);
}

/* Hash table for prototype */

static const std::array<HashTableValue, 17> JSNavigationPrototypeTableValues {
    HashTableValue { "constructor"_s, static_cast<unsigned>(PropertyAttribute::DontEnum), NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigationConstructor, 0 } },
    HashTableValue { "currentEntry"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigation_currentEntry, 0 } },
    HashTableValue { "transition"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigation_transition, 0 } },
    HashTableValue { "activation"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigation_activation, 0 } },
    HashTableValue { "canGoBack"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigation_canGoBack, 0 } },
    HashTableValue { "canGoForward"_s, JSC::PropertyAttribute::ReadOnly | JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigation_canGoForward, 0 } },
    HashTableValue { "onnavigate"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigation_onnavigate, setJSNavigation_onnavigate } },
    HashTableValue { "onnavigatesuccess"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigation_onnavigatesuccess, setJSNavigation_onnavigatesuccess } },
    HashTableValue { "onnavigateerror"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigation_onnavigateerror, setJSNavigation_onnavigateerror } },
    HashTableValue { "oncurrententrychange"_s, JSC::PropertyAttribute::CustomAccessor | JSC::PropertyAttribute::DOMAttribute, NoIntrinsic, { HashTableValue::GetterSetterType, jsNavigation_oncurrententrychange, setJSNavigation_oncurrententrychange } },
    HashTableValue { "entries"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNavigationPrototypeFunction_entries, 0 } },
    HashTableValue { "updateCurrentEntry"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNavigationPrototypeFunction_updateCurrentEntry, 1 } },
    HashTableValue { "navigate"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNavigationPrototypeFunction_navigate, 1 } },
    HashTableValue { "reload"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNavigationPrototypeFunction_reload, 0 } },
    HashTableValue { "traverseTo"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNavigationPrototypeFunction_traverseTo, 1 } },
    HashTableValue { "back"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNavigationPrototypeFunction_back, 0 } },
    HashTableValue { "forward"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsNavigationPrototypeFunction_forward, 0 } },
};

const ClassInfo JSNavigationPrototype::s_info = { "Navigation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigationPrototype) };

void JSNavigationPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSNavigation::info(), JSNavigationPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSNavigation::s_info = { "Navigation"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSNavigation) };

JSNavigation::JSNavigation(Structure* structure, JSDOMGlobalObject& globalObject, Ref<Navigation>&& impl)
    : JSEventTarget(structure, globalObject, WTFMove(impl))
{
}

Ref<Navigation> JSNavigation::protectedWrapped() const
{
    return wrapped();
}

static_assert(!std::is_base_of<ActiveDOMObject, Navigation>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSNavigation::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSNavigationPrototype::createStructure(vm, &globalObject, JSEventTarget::prototype(vm, globalObject));
    structure->setMayBePrototype(true);
    return JSNavigationPrototype::create(vm, &globalObject, structure);
}

JSObject* JSNavigation::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSNavigation>(vm, globalObject);
}

JSValue JSNavigation::getConstructor(VM& vm, const JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSNavigationDOMConstructor, DOMConstructorID::Navigation>(vm, *jsCast<const JSDOMGlobalObject*>(globalObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigationConstructor, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName))
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    auto* prototype = jsDynamicCast<JSNavigationPrototype*>(JSValue::decode(thisValue));
    if (!prototype) [[unlikely]]
        return throwVMTypeError(lexicalGlobalObject, throwScope);
    return JSValue::encode(JSNavigation::getConstructor(vm, prototype->globalObject()));
}

static inline JSValue jsNavigation_currentEntryGetter(JSGlobalObject& lexicalGlobalObject, JSNavigation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<NavigationHistoryEntry>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.currentEntry())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigation_currentEntry, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigation>::get<jsNavigation_currentEntryGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigation_transitionGetter(JSGlobalObject& lexicalGlobalObject, JSNavigation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<NavigationTransition>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.transition())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigation_transition, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigation>::get<jsNavigation_transitionGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigation_activationGetter(JSGlobalObject& lexicalGlobalObject, JSNavigation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLNullable<IDLInterface<NavigationActivation>>>(lexicalGlobalObject, *thisObject.globalObject(), throwScope, impl.activation())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigation_activation, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigation>::get<jsNavigation_activationGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigation_canGoBackGetter(JSGlobalObject& lexicalGlobalObject, JSNavigation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.canGoBack())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigation_canGoBack, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigation>::get<jsNavigation_canGoBackGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigation_canGoForwardGetter(JSGlobalObject& lexicalGlobalObject, JSNavigation& thisObject)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = thisObject.wrapped();
    RELEASE_AND_RETURN(throwScope, (toJS<IDLBoolean>(lexicalGlobalObject, throwScope, impl.canGoForward())));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigation_canGoForward, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigation>::get<jsNavigation_canGoForwardGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline JSValue jsNavigation_onnavigateGetter(JSGlobalObject& lexicalGlobalObject, JSNavigation& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().navigateEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigation_onnavigate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigation>::get<jsNavigation_onnavigateGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSNavigation_onnavigateSetter(JSGlobalObject& lexicalGlobalObject, JSNavigation& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().navigateEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSNavigation_onnavigate, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigation>::set<setJSNavigation_onnavigateSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsNavigation_onnavigatesuccessGetter(JSGlobalObject& lexicalGlobalObject, JSNavigation& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().navigatesuccessEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigation_onnavigatesuccess, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigation>::get<jsNavigation_onnavigatesuccessGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSNavigation_onnavigatesuccessSetter(JSGlobalObject& lexicalGlobalObject, JSNavigation& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().navigatesuccessEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSNavigation_onnavigatesuccess, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigation>::set<setJSNavigation_onnavigatesuccessSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsNavigation_onnavigateerrorGetter(JSGlobalObject& lexicalGlobalObject, JSNavigation& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().navigateerrorEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigation_onnavigateerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigation>::get<jsNavigation_onnavigateerrorGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSNavigation_onnavigateerrorSetter(JSGlobalObject& lexicalGlobalObject, JSNavigation& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().navigateerrorEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSNavigation_onnavigateerror, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigation>::set<setJSNavigation_onnavigateerrorSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSValue jsNavigation_oncurrententrychangeGetter(JSGlobalObject& lexicalGlobalObject, JSNavigation& thisObject)
{
    UNUSED_PARAM(lexicalGlobalObject);
    return eventHandlerAttribute(thisObject.protectedWrapped(), eventNames().currententrychangeEvent, worldForDOMObject(thisObject));
}

JSC_DEFINE_CUSTOM_GETTER(jsNavigation_oncurrententrychange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigation>::get<jsNavigation_oncurrententrychangeGetter, CastedThisErrorBehavior::Assert>(*lexicalGlobalObject, thisValue, attributeName);
}

static inline bool setJSNavigation_oncurrententrychangeSetter(JSGlobalObject& lexicalGlobalObject, JSNavigation& thisObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    UNUSED_PARAM(vm);
    setEventHandlerAttribute<JSEventListener>(thisObject.protectedWrapped(), eventNames().currententrychangeEvent, value, thisObject);
    vm.writeBarrier(&thisObject, value);
    ensureStillAliveHere(value);

    return true;
}

JSC_DEFINE_CUSTOM_SETTER(setJSNavigation_oncurrententrychange, (JSGlobalObject* lexicalGlobalObject, EncodedJSValue thisValue, EncodedJSValue encodedValue, PropertyName attributeName))
{
    return IDLAttribute<JSNavigation>::set<setJSNavigation_oncurrententrychangeSetter>(*lexicalGlobalObject, thisValue, encodedValue, attributeName);
}

static inline JSC::EncodedJSValue jsNavigationPrototypeFunction_entriesBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNavigation>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLSequence<IDLInterface<NavigationHistoryEntry>>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, impl.entries())));
}

JSC_DEFINE_HOST_FUNCTION(jsNavigationPrototypeFunction_entries, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNavigation>::call<jsNavigationPrototypeFunction_entriesBody>(*lexicalGlobalObject, *callFrame, "entries");
}

static inline JSC::EncodedJSValue jsNavigationPrototypeFunction_updateCurrentEntryBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSNavigation>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto optionsConversionResult = convert<IDLDictionary<Navigation::UpdateCurrentEntryOptions>>(*lexicalGlobalObject, argument0.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.updateCurrentEntry(optionsConversionResult.releaseReturnValue()); })));
}

JSC_DEFINE_HOST_FUNCTION(jsNavigationPrototypeFunction_updateCurrentEntry, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSNavigation>::call<jsNavigationPrototypeFunction_updateCurrentEntryBody>(*lexicalGlobalObject, *callFrame, "updateCurrentEntry");
}

static inline JSC::EncodedJSValue jsNavigationPrototypeFunction_navigateBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSNavigation>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, Ref<DeferredPromise>&& promise2)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto urlConversionResult = convert<IDLUSVString>(*lexicalGlobalObject, argument0.value());
    if (urlConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto optionsConversionResult = convert<IDLDictionary<Navigation::NavigateOptions>>(*lexicalGlobalObject, argument1.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDictionary<Navigation::Result>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.navigate(urlConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue(), WTFMove(promise), WTFMove(promise2)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsNavigationPrototypeFunction_navigate, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSNavigation>::callReturningPromisePair<jsNavigationPrototypeFunction_navigateBody>(*lexicalGlobalObject, *callFrame, "navigate");
}

static inline JSC::EncodedJSValue jsNavigationPrototypeFunction_reloadBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSNavigation>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, Ref<DeferredPromise>&& promise2)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto optionsConversionResult = convert<IDLDictionary<Navigation::ReloadOptions>>(*lexicalGlobalObject, argument0.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDictionary<Navigation::Result>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.reload(optionsConversionResult.releaseReturnValue(), WTFMove(promise), WTFMove(promise2)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsNavigationPrototypeFunction_reload, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSNavigation>::callReturningPromisePair<jsNavigationPrototypeFunction_reloadBody>(*lexicalGlobalObject, *callFrame, "reload");
}

static inline JSC::EncodedJSValue jsNavigationPrototypeFunction_traverseToBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSNavigation>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, Ref<DeferredPromise>&& promise2)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    if (callFrame->argumentCount() < 1) [[unlikely]]
        return throwVMError(lexicalGlobalObject, throwScope, createNotEnoughArgumentsError(lexicalGlobalObject));
    EnsureStillAliveScope argument0 = callFrame->uncheckedArgument(0);
    auto keyConversionResult = convert<IDLDOMString>(*lexicalGlobalObject, argument0.value());
    if (keyConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    EnsureStillAliveScope argument1 = callFrame->argument(1);
    auto optionsConversionResult = convert<IDLDictionary<Navigation::Options>>(*lexicalGlobalObject, argument1.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDictionary<Navigation::Result>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.traverseTo(keyConversionResult.releaseReturnValue(), optionsConversionResult.releaseReturnValue(), WTFMove(promise), WTFMove(promise2)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsNavigationPrototypeFunction_traverseTo, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSNavigation>::callReturningPromisePair<jsNavigationPrototypeFunction_traverseToBody>(*lexicalGlobalObject, *callFrame, "traverseTo");
}

static inline JSC::EncodedJSValue jsNavigationPrototypeFunction_backBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSNavigation>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, Ref<DeferredPromise>&& promise2)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto optionsConversionResult = convert<IDLDictionary<Navigation::Options>>(*lexicalGlobalObject, argument0.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDictionary<Navigation::Result>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.back(optionsConversionResult.releaseReturnValue(), WTFMove(promise), WTFMove(promise2)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsNavigationPrototypeFunction_back, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSNavigation>::callReturningPromisePair<jsNavigationPrototypeFunction_backBody>(*lexicalGlobalObject, *callFrame, "back");
}

static inline JSC::EncodedJSValue jsNavigationPrototypeFunction_forwardBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperationReturningPromise<JSNavigation>::ClassParameter castedThis, Ref<DeferredPromise>&& promise, Ref<DeferredPromise>&& promise2)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    EnsureStillAliveScope argument0 = callFrame->argument(0);
    auto optionsConversionResult = convert<IDLDictionary<Navigation::Options>>(*lexicalGlobalObject, argument0.value());
    if (optionsConversionResult.hasException(throwScope)) [[unlikely]]
       return encodedJSValue();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLDictionary<Navigation::Result>>(*lexicalGlobalObject, *castedThis->globalObject(), throwScope, [&]() -> decltype(auto) { return impl.forward(optionsConversionResult.releaseReturnValue(), WTFMove(promise), WTFMove(promise2)); })));
}

JSC_DEFINE_HOST_FUNCTION(jsNavigationPrototypeFunction_forward, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperationReturningPromise<JSNavigation>::callReturningPromisePair<jsNavigationPrototypeFunction_forwardBody>(*lexicalGlobalObject, *callFrame, "forward");
}

JSC::GCClient::IsoSubspace* JSNavigation::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSNavigation, UseCustomHeapCellType::No>(vm, "JSNavigation"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForNavigation.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForNavigation = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForNavigation.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForNavigation = std::forward<decltype(space)>(space); }
    );
}

void JSNavigation::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSNavigation*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSNavigationOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsNavigation = jsCast<JSNavigation*>(handle.slot()->asCell());
    auto* owner = WTF::getPtr(jsNavigation->wrapped().window());
    if (!owner)
        return false;
    if (reason) [[unlikely]]
        *reason = "Reachable from Window"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSNavigationOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsNavigation = static_cast<JSNavigation*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsNavigation->protectedWrapped().ptr(), jsNavigation);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7Navigation@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore10NavigationE[]; }
#endif
template<std::same_as<Navigation> T>
static inline void verifyVTable(Navigation* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7Navigation@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore10NavigationE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // Navigation has subclasses. If Navigation has subclasses that get passed
        // to toJS() we currently require Navigation you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<Navigation>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<Navigation>(impl.ptr());
#endif
    return createWrapper<Navigation>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, Navigation& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

Navigation* JSNavigation::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSNavigation*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}
