/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUBlendState.h"

#include "JSGPUBlendComponent.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<GPUBlendState>> convertDictionary<GPUBlendState>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    GPUBlendState result;
    JSValue alphaValue;
    if (isNullOrUndefined)
        alphaValue = jsUndefined();
    else {
        alphaValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "alpha"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (alphaValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "alpha"_s, "GPUBlendState"_s, "GPUBlendComponent"_s);
        return ConversionResultException { };
    }
    auto alphaConversionResult = convert<IDLDictionary<GPUBlendComponent>>(lexicalGlobalObject, alphaValue);
    if (alphaConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.alpha = alphaConversionResult.releaseReturnValue();
    JSValue colorValue;
    if (isNullOrUndefined)
        colorValue = jsUndefined();
    else {
        colorValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "color"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (colorValue.isUndefined()) {
        throwRequiredMemberTypeError(lexicalGlobalObject, throwScope, "color"_s, "GPUBlendState"_s, "GPUBlendComponent"_s);
        return ConversionResultException { };
    }
    auto colorConversionResult = convert<IDLDictionary<GPUBlendComponent>>(lexicalGlobalObject, colorValue);
    if (colorConversionResult.hasException(throwScope)) [[unlikely]]
        return ConversionResultException { };
    result.color = colorConversionResult.releaseReturnValue();
    return result;
}

} // namespace WebCore

