// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator. DO NOT EDIT.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armmsi

import "time"

// FederatedIdentityCredential - Describes a federated identity credential.
type FederatedIdentityCredential struct {
	// The properties associated with the federated identity credential.
	Properties *FederatedIdentityCredentialProperties

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// FederatedIdentityCredentialProperties - The properties associated with a federated identity credential.
type FederatedIdentityCredentialProperties struct {
	// REQUIRED; The list of audiences that can appear in the issued token.
	Audiences []*string

	// REQUIRED; The URL of the issuer to be trusted.
	Issuer *string

	// REQUIRED; The identifier of the external identity.
	Subject *string
}

// FederatedIdentityCredentialsListResult - Values returned by the List operation for federated identity credentials.
type FederatedIdentityCredentialsListResult struct {
	// The url to get the next page of results, if any.
	NextLink *string

	// The collection of federated identity credentials returned by the listing operation.
	Value []*FederatedIdentityCredential
}

// Identity - Describes an identity resource.
type Identity struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags.
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The properties associated with the identity.
	Properties *UserAssignedIdentityProperties

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// IdentityUpdate - Describes an identity resource.
type IdentityUpdate struct {
	// The geo-location where the resource lives
	Location *string

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The properties associated with the identity.
	Properties *UserAssignedIdentityProperties

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// Operation supported by the Microsoft.ManagedIdentity REST API.
type Operation struct {
	// The object that describes the operation.
	Display *OperationDisplay

	// The name of the REST Operation. This is of the format {provider}/{resource}/{operation}.
	Name *string
}

// OperationDisplay - The object that describes the operation.
type OperationDisplay struct {
	// A description of the operation.
	Description *string

	// The type of operation. For example: read, write, delete.
	Operation *string

	// Friendly name of the resource provider.
	Provider *string

	// The resource type on which the operation is performed.
	Resource *string
}

// OperationListResult - A list of operations supported by Microsoft.ManagedIdentity Resource Provider.
type OperationListResult struct {
	// The url to get the next page of results, if any.
	NextLink *string

	// A list of operations supported by Microsoft.ManagedIdentity Resource Provider.
	Value []*Operation
}

// SystemAssignedIdentity - Describes a system assigned identity resource.
type SystemAssignedIdentity struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string

	// Resource tags
	Tags map[string]*string

	// READ-ONLY; Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
	ID *string

	// READ-ONLY; The name of the resource
	Name *string

	// READ-ONLY; The properties associated with the identity.
	Properties *SystemAssignedIdentityProperties

	// READ-ONLY; Azure Resource Manager metadata containing createdBy and modifiedBy information.
	SystemData *SystemData

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string
}

// SystemAssignedIdentityProperties - The properties associated with the system assigned identity.
type SystemAssignedIdentityProperties struct {
	// READ-ONLY; The id of the app associated with the identity. This is a random generated UUID by MSI.
	ClientID *string

	// READ-ONLY; The ManagedServiceIdentity DataPlane URL that can be queried to obtain the identity credentials.
	ClientSecretURL *string

	// READ-ONLY; The id of the service principal object associated with the created identity.
	PrincipalID *string

	// READ-ONLY; The id of the tenant which the identity belongs to.
	TenantID *string
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time

	// The identity that created the resource.
	CreatedBy *string

	// The type of identity that created the resource.
	CreatedByType *CreatedByType

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time

	// The identity that last modified the resource.
	LastModifiedBy *string

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType
}

// UserAssignedIdentitiesListResult - Values returned by the List operation.
type UserAssignedIdentitiesListResult struct {
	// The url to get the next page of results, if any.
	NextLink *string

	// The collection of userAssignedIdentities returned by the listing operation.
	Value []*Identity
}

// UserAssignedIdentityProperties - The properties associated with the user assigned identity.
type UserAssignedIdentityProperties struct {
	// Enum to configure regional restrictions on identity assignment, as necessary.
	IsolationScope *IsolationScope

	// READ-ONLY; The id of the app associated with the identity. This is a random generated UUID by MSI.
	ClientID *string

	// READ-ONLY; The id of the service principal object associated with the created identity.
	PrincipalID *string

	// READ-ONLY; The id of the tenant which the identity belongs to.
	TenantID *string
}
