/* Plug.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Plug.vala, do not modify */

/*-
 * Copyright (c) 2015-2016 elementary LLC.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */
/* Strings */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "network.h"
#include <switchboard.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <gmodule.h>

#define SUFFIX " "
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	NETWORK_PLUG_0_PROPERTY,
	NETWORK_PLUG_NUM_PROPERTIES
};
static GParamSpec* network_plug_properties[NETWORK_PLUG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _NetworkPlugSearchData NetworkPlugSearchData;

struct _NetworkPlugPrivate {
	NetworkMainView* main_view;
};

struct _NetworkPlugSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	NetworkPlug* self;
	gchar* search;
	GeeTreeMap* result;
	GeeTreeMap* search_results;
	GCompareFunc _tmp0_;
	GEqualFunc _tmp1_;
	GeeTreeMap* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	const gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar* _tmp37_;
	gchar* _tmp38_;
	const gchar* _tmp39_;
	const gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
};

static gint NetworkPlug_private_offset;
static gpointer network_plug_parent_class = NULL;
GSettings* network_plug_proxy_settings = NULL;

static GtkWidget* network_plug_real_get_widget (SwitchboardPlug* base);
static void network_plug_real_shown (SwitchboardPlug* base);
static void network_plug_real_hidden (SwitchboardPlug* base);
static void network_plug_real_search_callback (SwitchboardPlug* base,
                                        const gchar* location);
static void network_plug_real_search_data_free (gpointer _data);
static void network_plug_real_search (SwitchboardPlug* base,
                               const gchar* search,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_);
static gboolean network_plug_real_search_co (NetworkPlugSearchData* _data_);
static void network_plug_finalize (GObject * obj);
static GType network_plug_get_type_once (void);

static inline gpointer
network_plug_get_instance_private (NetworkPlug* self)
{
	return G_STRUCT_MEMBER_P (self, NetworkPlug_private_offset);
}

NetworkPlug*
network_plug_construct (GType object_type)
{
	NetworkPlug * self = NULL;
	GeeTreeMap* settings = NULL;
	GeeTreeMap* _tmp0_;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	settings = _tmp0_;
	gee_abstract_map_set ((GeeAbstractMap*) settings, "network", NULL);
	self = (NetworkPlug*) g_object_new (object_type, "category", SWITCHBOARD_PLUG_CATEGORY_NETWORK, "code-name", "io.elementary.settings.network", "display-name", _ ("Network"), "description", _ ("Manage network devices and connectivity"), "icon", "preferences-system-network", "supported-settings", settings, NULL);
	_g_object_unref0 (settings);
	return self;
}

NetworkPlug*
network_plug_new (void)
{
	return network_plug_construct (NETWORK_TYPE_PLUG);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GtkWidget*
network_plug_real_get_widget (SwitchboardPlug* base)
{
	NetworkPlug * self;
	NetworkMainView* _tmp0_;
	NetworkMainView* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* result;
	self = (NetworkPlug*) base;
	_tmp0_ = self->priv->main_view;
	if (_tmp0_ == NULL) {
		NetworkMainView* _tmp1_;
		_tmp1_ = network_main_view_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->main_view);
		self->priv->main_view = _tmp1_;
	}
	_tmp2_ = self->priv->main_view;
	_tmp3_ = _g_object_ref0 ((GtkWidget*) _tmp2_);
	result = _tmp3_;
	return result;
}

static void
network_plug_real_shown (SwitchboardPlug* base)
{
	NetworkPlug * self;
	self = (NetworkPlug*) base;
}

static void
network_plug_real_hidden (SwitchboardPlug* base)
{
	NetworkPlug * self;
	self = (NetworkPlug*) base;
}

static void
network_plug_real_search_callback (SwitchboardPlug* base,
                                   const gchar* location)
{
	NetworkPlug * self;
	self = (NetworkPlug*) base;
	g_return_if_fail (location != NULL);
}

static void
network_plug_real_search_data_free (gpointer _data)
{
	NetworkPlugSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (NetworkPlugSearchData, _data_);
}

static void
network_plug_real_search (SwitchboardPlug* base,
                          const gchar* search,
                          GAsyncReadyCallback _callback_,
                          gpointer _user_data_)
{
	NetworkPlug * self;
	NetworkPlugSearchData* _data_;
	NetworkPlug* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (search != NULL);
	self = (NetworkPlug*) base;
	_data_ = g_slice_new0 (NetworkPlugSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, network_plug_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (search);
	_g_free0 (_data_->search);
	_data_->search = _tmp1_;
	network_plug_real_search_co (_data_);
}

static GeeTreeMap*
network_plug_search_finish (SwitchboardPlug* base,
                            GAsyncResult* _res_)
{
	GeeTreeMap* result;
	NetworkPlugSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
network_plug_real_search_co (NetworkPlugSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((GCompareFunc) g_strcmp0);
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, (GCompareDataFunc) _data_->_tmp0_, NULL, NULL, (GeeEqualDataFunc) _data_->_tmp1_, NULL, NULL);
	_data_->search_results = _data_->_tmp2_;
	_data_->_tmp3_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = g_strdup_printf ("%s → %s", _data_->_tmp4_, _ ("Ethernet"));
	_data_->_tmp6_ = _data_->_tmp5_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp6_, "");
	_g_free0 (_data_->_tmp6_);
	_data_->_tmp7_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = g_strdup_printf ("%s → %s", _data_->_tmp8_, _ ("LAN"));
	_data_->_tmp10_ = _data_->_tmp9_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp10_, "");
	_g_free0 (_data_->_tmp10_);
	_data_->_tmp11_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp12_ = _data_->_tmp11_;
	_data_->_tmp13_ = g_strdup_printf ("%s → %s", _data_->_tmp12_, _ ("Wireless"));
	_data_->_tmp14_ = _data_->_tmp13_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp14_, "");
	_g_free0 (_data_->_tmp14_);
	_data_->_tmp15_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = g_strdup_printf ("%s → %s", _data_->_tmp16_, _ ("Wi-Fi"));
	_data_->_tmp18_ = _data_->_tmp17_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp18_, "");
	_g_free0 (_data_->_tmp18_);
	_data_->_tmp19_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp20_ = _data_->_tmp19_;
	_data_->_tmp21_ = g_strdup_printf ("%s → %s", _data_->_tmp20_, _ ("WLAN"));
	_data_->_tmp22_ = _data_->_tmp21_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp22_, "");
	_g_free0 (_data_->_tmp22_);
	_data_->_tmp23_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp24_ = _data_->_tmp23_;
	_data_->_tmp25_ = g_strdup_printf ("%s → %s", _data_->_tmp24_, _ ("Proxy"));
	_data_->_tmp26_ = _data_->_tmp25_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp26_, "");
	_g_free0 (_data_->_tmp26_);
	_data_->_tmp27_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp28_ = _data_->_tmp27_;
	_data_->_tmp29_ = g_strdup_printf ("%s → %s", _data_->_tmp28_, _ ("Airplane Mode"));
	_data_->_tmp30_ = _data_->_tmp29_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp30_, "");
	_g_free0 (_data_->_tmp30_);
	_data_->_tmp31_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp32_ = _data_->_tmp31_;
	_data_->_tmp33_ = g_strdup_printf ("%s → %s", _data_->_tmp32_, _ ("IP Address"));
	_data_->_tmp34_ = _data_->_tmp33_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp34_, "");
	_g_free0 (_data_->_tmp34_);
	_data_->_tmp35_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp36_ = _data_->_tmp35_;
	_data_->_tmp37_ = g_strdup_printf ("%s → %s", _data_->_tmp36_, _ ("Hotspot"));
	_data_->_tmp38_ = _data_->_tmp37_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp38_, "");
	_g_free0 (_data_->_tmp38_);
	_data_->_tmp39_ = switchboard_plug_get_display_name ((SwitchboardPlug*) _data_->self);
	_data_->_tmp40_ = _data_->_tmp39_;
	_data_->_tmp41_ = g_strdup_printf ("%s → %s", _data_->_tmp40_, _ ("VPN"));
	_data_->_tmp42_ = _data_->_tmp41_;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->search_results, _data_->_tmp42_, "");
	_g_free0 (_data_->_tmp42_);
	_data_->result = _data_->search_results;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
network_plug_class_init (NetworkPlugClass * klass,
                         gpointer klass_data)
{
	GSettings* _tmp0_;
	network_plug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NetworkPlug_private_offset);
	((SwitchboardPlugClass *) klass)->get_widget = (GtkWidget* (*) (SwitchboardPlug*)) network_plug_real_get_widget;
	((SwitchboardPlugClass *) klass)->shown = (void (*) (SwitchboardPlug*)) network_plug_real_shown;
	((SwitchboardPlugClass *) klass)->hidden = (void (*) (SwitchboardPlug*)) network_plug_real_hidden;
	((SwitchboardPlugClass *) klass)->search_callback = (void (*) (SwitchboardPlug*, const gchar*)) network_plug_real_search_callback;
	((SwitchboardPlugClass *) klass)->search = (void (*) (SwitchboardPlug*, const gchar*, GAsyncReadyCallback, gpointer)) network_plug_real_search;
	((SwitchboardPlugClass *) klass)->search_finish = (GeeTreeMap* (*) (SwitchboardPlug*, GAsyncResult*)) network_plug_search_finish;
	G_OBJECT_CLASS (klass)->finalize = network_plug_finalize;
	_tmp0_ = g_settings_new ("org.gnome.system.proxy");
	_g_object_unref0 (network_plug_proxy_settings);
	network_plug_proxy_settings = _tmp0_;
}

static void
network_plug_instance_init (NetworkPlug * self,
                            gpointer klass)
{
	self->priv = network_plug_get_instance_private (self);
	self->priv->main_view = NULL;
}

static void
network_plug_finalize (GObject * obj)
{
	NetworkPlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, NETWORK_TYPE_PLUG, NetworkPlug);
	_g_object_unref0 (self->priv->main_view);
	G_OBJECT_CLASS (network_plug_parent_class)->finalize (obj);
}

static GType
network_plug_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NetworkPlugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) network_plug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NetworkPlug), 0, (GInstanceInitFunc) network_plug_instance_init, NULL };
	GType network_plug_type_id;
	network_plug_type_id = g_type_register_static (SWITCHBOARD_TYPE_PLUG, "NetworkPlug", &g_define_type_info, 0);
	NetworkPlug_private_offset = g_type_add_instance_private (network_plug_type_id, sizeof (NetworkPlugPrivate));
	return network_plug_type_id;
}

GType
network_plug_get_type (void)
{
	static volatile gsize network_plug_type_id__once = 0;
	if (g_once_init_enter (&network_plug_type_id__once)) {
		GType network_plug_type_id;
		network_plug_type_id = network_plug_get_type_once ();
		g_once_init_leave (&network_plug_type_id__once, network_plug_type_id);
	}
	return network_plug_type_id__once;
}

SwitchboardPlug*
get_plug (GModule* module)
{
	NetworkPlug* plug = NULL;
	NetworkPlug* _tmp0_;
	SwitchboardPlug* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Plug.vala:86: Activating Network plug");
	_tmp0_ = network_plug_new ();
	plug = _tmp0_;
	result = (SwitchboardPlug*) plug;
	return result;
}

