#ifndef __SOURCE4_LIBRPC_RPC_DCERPC_PROTO_H__
#define __SOURCE4_LIBRPC_RPC_DCERPC_PROTO_H__

#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2) PRINTF_ATTRIBUTE(a1, a2)
/* This file was automatically generated by mkproto.pl. DO NOT EDIT */

/* this file contains prototypes for functions that are private 
 * to this subsystem or library. These functions should not be 
 * used outside this particular subsystem! */


/* The following definitions come from ../../source4/librpc/rpc/dcerpc.c  */

struct dcerpc_binding_handle *dcerpc_pipe_binding_handle(struct dcerpc_pipe *p,
							 const struct GUID *object,
							 const struct ndr_interface_table *table);

/**
  setup for a ndr pull, also setting up any flags from the binding string
*/
struct tevent_req *dcerpc_bind_send(TALLOC_CTX *mem_ctx,
				    struct tevent_context *ev,
				    struct dcerpc_pipe *p,
				    const struct ndr_syntax_id *syntax,
				    const struct ndr_syntax_id *transfer_syntax);
NTSTATUS dcerpc_bind_recv(struct tevent_req *req);
NTSTATUS dcerpc_auth3(struct dcerpc_pipe *p,
		      TALLOC_CTX *mem_ctx);
uint32_t dcerpc_auth_level(struct dcecli_connection *c) ;
struct tevent_req *dcerpc_alter_context_send(TALLOC_CTX *mem_ctx,
					     struct tevent_context *ev,
					     struct dcerpc_pipe *p,
					     const struct ndr_syntax_id *syntax,
					     const struct ndr_syntax_id *transfer_syntax);
NTSTATUS dcerpc_alter_context_recv(struct tevent_req *req);

/* The following definitions come from ../../source4/librpc/rpc/dcerpc_auth.c  */

struct composite_context *dcerpc_bind_auth_none_send(TALLOC_CTX *mem_ctx,
						     struct dcerpc_pipe *p,
						     const struct ndr_interface_table *table);
NTSTATUS dcerpc_bind_auth_none_recv(struct composite_context *ctx);

/**
   Bind to a DCE/RPC pipe, send async request
   @param mem_ctx TALLOC_CTX for the allocation of the composite_context
   @param p The dcerpc_pipe to bind (must already be connected)
   @param table The interface table to use (the DCE/RPC bind both selects and interface and authenticates)
   @param credentials The credentials of the account to connect with 
   @param auth_type Select the authentication scheme to use
   @param auth_level Chooses between unprotected (connect), signed or sealed
   @param service The service (used by Kerberos to select the service principal to contact)
   @retval A composite context describing the partial state of the bind
*/
struct composite_context *dcerpc_bind_auth_send(TALLOC_CTX *mem_ctx,
						struct dcerpc_pipe *p,
						const struct ndr_interface_table *table,
						struct cli_credentials *credentials,
						struct gensec_settings *gensec_settings,
						uint8_t auth_type, uint8_t auth_level,
						const char *service);

/**
   Bind to a DCE/RPC pipe, receive result
   @param creq A composite context describing state of async call
   @retval NTSTATUS code
*/
NTSTATUS dcerpc_bind_auth_recv(struct composite_context *creq);

/* The following definitions come from ../../source4/librpc/rpc/dcerpc_schannel.c  */

struct composite_context *dcerpc_bind_auth_schannel_send(TALLOC_CTX *tmp_ctx, 
							 struct dcerpc_pipe *p,
							 const struct ndr_interface_table *table,
							 struct cli_credentials *credentials,
							 struct loadparm_context *lp_ctx,
							 uint8_t auth_level);
NTSTATUS dcerpc_bind_auth_schannel_recv(struct composite_context *c);

/* The following definitions come from ../../source4/librpc/rpc/dcerpc_util.c  */

const struct ndr_interface_call *dcerpc_iface_find_call(const struct ndr_interface_table *iface,
							const char *name);
struct composite_context *dcerpc_epm_map_binding_send(TALLOC_CTX *mem_ctx,
						      struct dcerpc_binding *binding,
						      const struct ndr_interface_table *table,
						      struct cli_credentials *creds,
						      struct tevent_context *ev,
						      struct loadparm_context *lp_ctx);
NTSTATUS dcerpc_epm_map_binding_recv(struct composite_context *c);
struct composite_context *dcerpc_pipe_auth_send(struct dcerpc_pipe *p, 
						const struct dcerpc_binding *binding,
						const struct ndr_interface_table *table,
						struct cli_credentials *credentials,
						struct loadparm_context *lp_ctx);
NTSTATUS dcerpc_pipe_auth_recv(struct composite_context *c, TALLOC_CTX *mem_ctx, 
			       struct dcerpc_pipe **p);
NTSTATUS dcecli_generic_session_key(struct dcecli_connection *c,
				    DATA_BLOB *session_key);

/* The following definitions come from ../../source4/librpc/rpc/dcerpc_smb.c  */

struct composite_context *dcerpc_pipe_open_smb_send(struct dcecli_connection *c,
						struct smbXcli_conn *conn,
						struct smbXcli_session *session,
						struct smbXcli_tcon *tcon,
						uint32_t timeout_msec,
						const char *pipe_name);
NTSTATUS dcerpc_pipe_open_smb_recv(struct composite_context *c);
struct composite_context *dcerpc_secondary_smb_send(struct dcecli_connection *c1,
						    struct dcecli_connection *c2,
						    const char *pipe_name);
NTSTATUS dcerpc_secondary_smb_recv(struct composite_context *c);

/* The following definitions come from ../../source4/librpc/rpc/dcerpc_sock.c  */

struct composite_context* dcerpc_pipe_open_tcp_send(struct dcecli_connection *conn,
						    const char *localaddr,
						    const char *server,
						    const char *target_hostname,
						    uint32_t port,
						    struct resolve_context *resolve_ctx);
NTSTATUS dcerpc_pipe_open_tcp_recv(struct composite_context *c,
				   TALLOC_CTX *mem_ctx,
				   char **localaddr,
				   char **remoteaddr);
struct composite_context *dcerpc_pipe_open_unix_stream_send(struct dcecli_connection *conn,
							    const char *path);
NTSTATUS dcerpc_pipe_open_unix_stream_recv(struct composite_context *c);
struct composite_context* dcerpc_pipe_open_pipe_send(struct dcecli_connection *conn,
						     const char *ncalrpc_dir,
						     const char *identifier);
NTSTATUS dcerpc_pipe_open_pipe_recv(struct composite_context *c);
NTSTATUS dcerpc_pipe_open_pipe(struct dcecli_connection *conn, const char *ncalrpc_dir, const char *identifier);

/* The following definitions come from ../../source4/librpc/rpc/dcerpc_roh_channel_in.c  */

struct tevent_req *roh_send_RPC_DATA_IN_send(TALLOC_CTX *mem_ctx,
					     struct loadparm_context *lp_ctx,
					     struct tevent_context *ev,
					     struct cli_credentials *credentials,
					     struct roh_connection *roh,
					     const char *rpc_server,
					     uint32_t rpc_server_port,
					     const char *rpc_proxy,
					     uint8_t http_auth);
NTSTATUS roh_send_RPC_DATA_IN_recv(struct tevent_req *req);
struct tevent_req *roh_send_CONN_B1_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct roh_connection *roh);
NTSTATUS roh_send_CONN_B1_recv(struct tevent_req *req);

/* The following definitions come from ../../source4/librpc/rpc/dcerpc_roh_channel_out.c  */

struct tevent_req *roh_send_RPC_DATA_OUT_send(TALLOC_CTX *mem_ctx,
					      struct loadparm_context *lp_ctx,
					      struct tevent_context *ev,
					      struct cli_credentials *credentials,
					      struct roh_connection *roh,
					      const char *rpc_server,
					      uint32_t rpc_server_port,
					      const char *rpc_proxy,
					      uint8_t http_auth);
NTSTATUS roh_send_RPC_DATA_OUT_recv(struct tevent_req *req);
struct tevent_req *roh_send_CONN_A1_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct roh_connection *roh);
NTSTATUS roh_send_CONN_A1_recv(struct tevent_req *req);
struct tevent_req *roh_recv_out_channel_response_send(TALLOC_CTX *mem_ctx,
						      struct tevent_context *ev,
						      struct roh_connection *roh);
NTSTATUS roh_recv_out_channel_response_recv(struct tevent_req *req,
		TALLOC_CTX *mem_ctx,
		char **response_msg);
struct tevent_req *roh_recv_CONN_A3_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct roh_connection *roh);
NTSTATUS roh_recv_CONN_A3_recv(struct tevent_req *req,
			       unsigned int *connection_timeout);
struct tevent_req *roh_recv_CONN_C2_send(TALLOC_CTX *mem_ctx,
					 struct tevent_context *ev,
					 struct roh_connection *roh);
NTSTATUS roh_recv_CONN_C2_recv(struct tevent_req *req,
			       unsigned int *version,
			       unsigned int *recv_window_size,
			       unsigned int *connection_timeout);

/* The following definitions come from ../../source4/librpc/rpc/dcerpc_roh.c  */

NTSTATUS dcerpc_pipe_open_roh_recv(struct tevent_req *req,
				   TALLOC_CTX *mem_ctx,
				   struct tstream_context **stream,
				   struct tevent_queue **queue);

/**
 * Send rpc pipe open request to given host:port using http transport
 */
struct tevent_req *dcerpc_pipe_open_roh_send(struct dcecli_connection *conn,
					     const char *localaddr,
					     const char *rpc_server,
					     uint32_t rpc_server_port,
					     const char *rpc_proxy,
					     uint32_t rpc_proxy_port,
					     const char *http_proxy,
					     uint32_t http_proxy_port,
					     bool use_tls,
					     bool use_proxy,
					     struct cli_credentials *credentials,
					     struct resolve_context *resolve_ctx,
					     struct loadparm_context *lp_ctx,
					     uint8_t http_auth);

/* The following definitions come from ../../source4/librpc/rpc/dcerpc_connect.c  */

NTSTATUS dcerpc_pipe_connect_recv(struct composite_context *c,
				  TALLOC_CTX *mem_ctx,
				  struct dcerpc_pipe **pp);

/* The following definitions come from ../../source4/librpc/rpc/dcerpc_secondary.c  */

#undef _PRINTF_ATTRIBUTE
#define _PRINTF_ATTRIBUTE(a1, a2)

#endif /* __SOURCE4_LIBRPC_RPC_DCERPC_PROTO_H__ */

