// MIT License
//
// Copyright (c) 2023-2025 Advanced Micro Devices, Inc. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.

#pragma once

#include <rocprofiler-sdk/registration.h>
#include "lib/common/defines.hpp"
#include "rocprofiler-sdk/fwd.h"

#include <cstdint>
#include <string>
#include <vector>

extern "C" {
// this is the "hidden" function that rocprofiler-register invokes to pass
// the API tables to rocprofiler
int
rocprofiler_set_api_table(const char* name,
                          uint64_t    lib_version,
                          uint64_t    lib_instance,
                          void**      tables,
                          uint64_t    num_tables) ROCPROFILER_PUBLIC_API;

// functions for dynamic attach/detach control
void
rocprofiler_call_client_reattach() ROCPROFILER_PUBLIC_API;

void
rocprofiler_call_client_detach() ROCPROFILER_PUBLIC_API;
}

namespace rocprofiler
{
namespace registration
{
// initialize google logging
void
init_logging();

// initialize the clients
void
initialize();

// finalize the clients
void
finalize();

// get the randomly generated client offset number
uint32_t
get_client_offset();

int
get_init_status();

int
get_fini_status();

void
set_init_status(int);

void
set_fini_status(int);

bool
supports_attachment();

// call tool_reattach function for all registered clients
rocprofiler_status_t
attach();

// call tool_detach function for all registered clients
rocprofiler_status_t
detach();
}  // namespace registration
}  // namespace rocprofiler
