// ui/accessibility/mojom/ax_tree_id.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_TREE_ID_MOJOM_SHARED_H_
#define UI_ACCESSIBILITY_MOJOM_AX_TREE_ID_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "ui/accessibility/mojom/ax_tree_id.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"







namespace ax {
namespace mojom {
class AXTreeIDDataView;


}  // namespace mojom
}  // namespace ax

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::ax::mojom::AXTreeIDDataView> {
  using Data = ::ax::mojom::internal::AXTreeID_Data;
  using DataAsArrayElement = Data;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kUnion;
};

}  // namespace internal
}  // namespace mojo


namespace ax {
namespace mojom {


class AXTreeIDDataView {
 public:
  using Tag = internal::AXTreeID_Data::AXTreeID_Tag;

  AXTreeIDDataView() {}

  AXTreeIDDataView(
      internal::AXTreeID_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const {
    // For inlined unions, |data_| is always non-null. In that case we need to
    // check |data_->is_null()|.
    return !data_ || data_->is_null();
  }

  Tag tag() const { return data_->tag; }
  bool is_unknown() const { return data_->tag == Tag::UNKNOWN; }
  uint8_t unknown() const {
    DCHECK(is_unknown());
    return data_->data.f_unknown;
  }
  bool is_token() const { return data_->tag == Tag::TOKEN; }
  inline void GetTokenDataView(
      ::mojo_base::mojom::UnguessableTokenDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadToken(UserType* output) {
    
    DCHECK(is_token());
    return mojo::internal::Deserialize<::mojo_base::mojom::UnguessableTokenDataView>(
        data_->data.f_token.Get(), output, context_);
  }

 private:
  internal::AXTreeID_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace ax

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::AXTreeIDDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::ax::mojom::AXTreeIDDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::ax::mojom::internal::AXTreeID_Data::BufferWriter* writer,
                        bool inlined,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
         writer->data()->set_null();
      return;
    }
    if (!inlined)
      writer->Allocate(buffer);

    ::ax::mojom::internal::AXTreeID_Data::BufferWriter& result = *writer;
    ALLOW_UNUSED_LOCAL(result);
    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
    result->size = kUnionDataSize;
    result->tag = Traits::GetTag(input);
    switch (result->tag) {
      case ::ax::mojom::AXTreeIDDataView::Tag::UNKNOWN: {
        decltype(Traits::unknown(input))
            in_unknown = Traits::unknown(input);
        result->data.f_unknown = in_unknown;
        break;
      }
      case ::ax::mojom::AXTreeIDDataView::Tag::TOKEN: {
        decltype(Traits::token(input))
            in_token = Traits::token(input);
        typename decltype(result->data.f_token)::BaseType::BufferWriter
            value_writer;
        mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
            in_token, buffer, &value_writer, context);
        MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
            value_writer.is_null(),
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
            "null token in AXTreeID union");
        result->data.f_token.Set(
            value_writer.is_null() ? nullptr : value_writer.data());
        break;
      }
    }
  }

  static bool Deserialize(::ax::mojom::internal::AXTreeID_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::ax::mojom::AXTreeIDDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ax {
namespace mojom {

inline void AXTreeIDDataView::GetTokenDataView(
    ::mojo_base::mojom::UnguessableTokenDataView* output) {
  DCHECK(is_token());
  *output = ::mojo_base::mojom::UnguessableTokenDataView(data_->data.f_token.Get(), context_);
}


}  // namespace mojom
}  // namespace ax

#endif  // UI_ACCESSIBILITY_MOJOM_AX_TREE_ID_MOJOM_SHARED_H_