// third_party/blink/public/mojom/cache_storage/cache_storage.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-params-data.h"
#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/cache_storage/cache_storage.mojom-blink-import-headers.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_CACHE_STORAGE_CACHE_STORAGE_MOJOM_BLINK_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_CACHE_STORAGE_CACHE_STORAGE_MOJOM_BLINK_JUMBO_H_
#include "third_party/blink/renderer/platform/loader/fetch/fetch_api_request_body_mojom_traits.h"
#endif
namespace blink {
namespace mojom {
namespace blink {
CacheStorageVerboseError::CacheStorageVerboseError()
    : value(),
      message() {}

CacheStorageVerboseError::CacheStorageVerboseError(
    CacheStorageError value_in,
    const WTF::String& message_in)
    : value(std::move(value_in)),
      message(std::move(message_in)) {}

CacheStorageVerboseError::~CacheStorageVerboseError() = default;

void CacheStorageVerboseError::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("value", base::trace_event::ValueToString(this->value));
  value->SetString("message", this->message.Utf8());
}

bool CacheStorageVerboseError::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CacheQueryOptions::CacheQueryOptions()
    : ignore_search(false),
      ignore_method(false),
      ignore_vary(false) {}

CacheQueryOptions::CacheQueryOptions(
    bool ignore_search_in,
    bool ignore_method_in,
    bool ignore_vary_in)
    : ignore_search(std::move(ignore_search_in)),
      ignore_method(std::move(ignore_method_in)),
      ignore_vary(std::move(ignore_vary_in)) {}

CacheQueryOptions::~CacheQueryOptions() = default;
size_t CacheQueryOptions::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->ignore_search);
  seed = mojo::internal::WTFHash(seed, this->ignore_method);
  seed = mojo::internal::WTFHash(seed, this->ignore_vary);
  return seed;
}

void CacheQueryOptions::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("ignore_search", this->ignore_search);
  value->SetBoolean("ignore_method", this->ignore_method);
  value->SetBoolean("ignore_vary", this->ignore_vary);
}

bool CacheQueryOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
MultiCacheQueryOptions::MultiCacheQueryOptions()
    : query_options(),
      cache_name() {}

MultiCacheQueryOptions::MultiCacheQueryOptions(
    CacheQueryOptionsPtr query_options_in,
    const ::WTF::String& cache_name_in)
    : query_options(std::move(query_options_in)),
      cache_name(std::move(cache_name_in)) {}

MultiCacheQueryOptions::~MultiCacheQueryOptions() = default;

void MultiCacheQueryOptions::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->query_options.is_null()) {
    value->SetString("query_options", "nullptr");
  } else {
    value->BeginDictionary("query_options");
    this->query_options->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetString("cache_name", base::trace_event::ValueToString(this->cache_name, "<value of type const ::WTF::String&>"));
}

bool MultiCacheQueryOptions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
BatchOperation::BatchOperation()
    : operation_type(),
      request(),
      response(),
      match_options() {}

BatchOperation::BatchOperation(
    OperationType operation_type_in,
    ::blink::mojom::blink::FetchAPIRequestPtr request_in,
    ::blink::mojom::blink::FetchAPIResponsePtr response_in,
    CacheQueryOptionsPtr match_options_in)
    : operation_type(std::move(operation_type_in)),
      request(std::move(request_in)),
      response(std::move(response_in)),
      match_options(std::move(match_options_in)) {}

BatchOperation::~BatchOperation() = default;

void BatchOperation::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("operation_type", base::trace_event::ValueToString(this->operation_type));
  if (this->request.is_null()) {
    value->SetString("request", "nullptr");
  } else {
    value->BeginDictionary("request");
    this->request->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->response.is_null()) {
    value->SetString("response", "nullptr");
  } else {
    value->BeginDictionary("response");
    this->response->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->match_options.is_null()) {
    value->SetString("match_options", "nullptr");
  } else {
    value->BeginDictionary("match_options");
    this->match_options->AsValueInto(value);
    value->EndDictionary();
  }
}

bool BatchOperation::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
EagerResponse::EagerResponse()
    : response(),
      pipe(),
      client_receiver() {}

EagerResponse::EagerResponse(
    ::blink::mojom::blink::FetchAPIResponsePtr response_in,
    ::mojo::ScopedDataPipeConsumerHandle pipe_in,
    ::mojo::PendingReceiver<::blink::mojom::blink::BlobReaderClient> client_receiver_in)
    : response(std::move(response_in)),
      pipe(std::move(pipe_in)),
      client_receiver(std::move(client_receiver_in)) {}

EagerResponse::~EagerResponse() = default;

void EagerResponse::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->response.is_null()) {
    value->SetString("response", "nullptr");
  } else {
    value->BeginDictionary("response");
    this->response->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetBoolean("pipe", this->pipe.is_valid());
  value->SetBoolean("client_receiver", this->client_receiver.is_valid());
}

bool EagerResponse::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
OpenResult::OpenResult() : tag_(Tag::STATUS) {
  data_.status = CacheStorageError();
}

OpenResult::~OpenResult() {
  DestroyActive();
}


void OpenResult::set_status(
    CacheStorageError status) {
  if (tag_ != Tag::STATUS) {
    DestroyActive();
    tag_ = Tag::STATUS;
  }
  data_.status = status;
}
void OpenResult::set_cache(
    ::mojo::PendingAssociatedRemote<CacheStorageCache> cache) {
  if (tag_ == Tag::CACHE) {
    *(data_.cache) = std::move(cache);
  } else {
    DestroyActive();
    tag_ = Tag::CACHE;
    data_.cache = new ::mojo::PendingAssociatedRemote<CacheStorageCache>(
        std::move(cache));
  }
}

void OpenResult::DestroyActive() {
  switch (tag_) {

    case Tag::STATUS:

      break;
    case Tag::CACHE:

      delete data_.cache;
      break;
  }
}

bool OpenResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
MatchResult::MatchResult() : tag_(Tag::STATUS) {
  data_.status = CacheStorageError();
}

MatchResult::~MatchResult() {
  DestroyActive();
}


void MatchResult::set_status(
    CacheStorageError status) {
  if (tag_ != Tag::STATUS) {
    DestroyActive();
    tag_ = Tag::STATUS;
  }
  data_.status = status;
}
void MatchResult::set_response(
    ::blink::mojom::blink::FetchAPIResponsePtr response) {
  if (tag_ == Tag::RESPONSE) {
    *(data_.response) = std::move(response);
  } else {
    DestroyActive();
    tag_ = Tag::RESPONSE;
    data_.response = new ::blink::mojom::blink::FetchAPIResponsePtr(
        std::move(response));
  }
}
void MatchResult::set_eager_response(
    EagerResponsePtr eager_response) {
  if (tag_ == Tag::EAGER_RESPONSE) {
    *(data_.eager_response) = std::move(eager_response);
  } else {
    DestroyActive();
    tag_ = Tag::EAGER_RESPONSE;
    data_.eager_response = new EagerResponsePtr(
        std::move(eager_response));
  }
}

void MatchResult::DestroyActive() {
  switch (tag_) {

    case Tag::STATUS:

      break;
    case Tag::RESPONSE:

      delete data_.response;
      break;
    case Tag::EAGER_RESPONSE:

      delete data_.eager_response;
      break;
  }
}

bool MatchResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
MatchAllResult::MatchAllResult() : tag_(Tag::STATUS) {
  data_.status = CacheStorageError();
}

MatchAllResult::~MatchAllResult() {
  DestroyActive();
}


void MatchAllResult::set_status(
    CacheStorageError status) {
  if (tag_ != Tag::STATUS) {
    DestroyActive();
    tag_ = Tag::STATUS;
  }
  data_.status = status;
}
void MatchAllResult::set_responses(
    WTF::Vector<::blink::mojom::blink::FetchAPIResponsePtr> responses) {
  if (tag_ == Tag::RESPONSES) {
    *(data_.responses) = std::move(responses);
  } else {
    DestroyActive();
    tag_ = Tag::RESPONSES;
    data_.responses = new WTF::Vector<::blink::mojom::blink::FetchAPIResponsePtr>(
        std::move(responses));
  }
}

void MatchAllResult::DestroyActive() {
  switch (tag_) {

    case Tag::STATUS:

      break;
    case Tag::RESPONSES:

      delete data_.responses;
      break;
  }
}

bool MatchAllResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
CacheKeysResult::CacheKeysResult() : tag_(Tag::STATUS) {
  data_.status = CacheStorageError();
}

CacheKeysResult::~CacheKeysResult() {
  DestroyActive();
}


void CacheKeysResult::set_status(
    CacheStorageError status) {
  if (tag_ != Tag::STATUS) {
    DestroyActive();
    tag_ = Tag::STATUS;
  }
  data_.status = status;
}
void CacheKeysResult::set_keys(
    WTF::Vector<::blink::mojom::blink::FetchAPIRequestPtr> keys) {
  if (tag_ == Tag::KEYS) {
    *(data_.keys) = std::move(keys);
  } else {
    DestroyActive();
    tag_ = Tag::KEYS;
    data_.keys = new WTF::Vector<::blink::mojom::blink::FetchAPIRequestPtr>(
        std::move(keys));
  }
}

void CacheKeysResult::DestroyActive() {
  switch (tag_) {

    case Tag::STATUS:

      break;
    case Tag::KEYS:

      delete data_.keys;
      break;
  }
}

bool CacheKeysResult::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char CacheStorageCache::Name_[] = "blink.mojom.CacheStorageCache";

class CacheStorageCache_Match_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CacheStorageCache_Match_ForwardToCallback(
      CacheStorageCache::MatchCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CacheStorageCache::MatchCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CacheStorageCache_Match_ForwardToCallback);
};

class CacheStorageCache_MatchAll_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CacheStorageCache_MatchAll_ForwardToCallback(
      CacheStorageCache::MatchAllCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CacheStorageCache::MatchAllCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CacheStorageCache_MatchAll_ForwardToCallback);
};

class CacheStorageCache_Keys_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CacheStorageCache_Keys_ForwardToCallback(
      CacheStorageCache::KeysCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CacheStorageCache::KeysCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CacheStorageCache_Keys_ForwardToCallback);
};

class CacheStorageCache_Batch_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CacheStorageCache_Batch_ForwardToCallback(
      CacheStorageCache::BatchCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CacheStorageCache::BatchCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CacheStorageCache_Batch_ForwardToCallback);
};

CacheStorageCacheProxy::CacheStorageCacheProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CacheStorageCacheProxy::Match(
    ::blink::mojom::blink::FetchAPIRequestPtr in_request, CacheQueryOptionsPtr in_query_options, bool in_in_related_fetch_event, int64_t in_trace_id, MatchCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::CacheStorageCache::Match", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_request.is_null()) {
        raw_value->SetString("request", "nullptr");
      } else {
        raw_value->BeginDictionary("request");
        in_request->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      if (in_query_options.is_null()) {
        raw_value->SetString("query_options", "nullptr");
      } else {
        raw_value->BeginDictionary("query_options");
        in_query_options->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("in_related_fetch_event", in_in_related_fetch_event);
      raw_value->SetString("trace_id", base::NumberToString(in_trace_id));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCacheStorageCache_Match_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::CacheStorageCache_Match_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->request)::BaseType::BufferWriter
      request_writer;
  mojo::internal::Serialize<::blink::mojom::FetchAPIRequestDataView>(
      in_request, buffer, &request_writer, &serialization_context);
  params->request.Set(
      request_writer.is_null() ? nullptr : request_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request in CacheStorageCache.Match request");
  typename decltype(params->query_options)::BaseType::BufferWriter
      query_options_writer;
  mojo::internal::Serialize<::blink::mojom::CacheQueryOptionsDataView>(
      in_query_options, buffer, &query_options_writer, &serialization_context);
  params->query_options.Set(
      query_options_writer.is_null() ? nullptr : query_options_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->query_options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null query_options in CacheStorageCache.Match request");
  params->in_related_fetch_event = in_in_related_fetch_event;
  params->trace_id = in_trace_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageCache::Name_);
  message.set_method_name("Match");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CacheStorageCache_Match_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CacheStorageCacheProxy::MatchAll(
    ::blink::mojom::blink::FetchAPIRequestPtr in_request, CacheQueryOptionsPtr in_query_options, int64_t in_trace_id, MatchAllCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::CacheStorageCache::MatchAll", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_request.is_null()) {
        raw_value->SetString("request", "nullptr");
      } else {
        raw_value->BeginDictionary("request");
        in_request->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      if (in_query_options.is_null()) {
        raw_value->SetString("query_options", "nullptr");
      } else {
        raw_value->BeginDictionary("query_options");
        in_query_options->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetString("trace_id", base::NumberToString(in_trace_id));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCacheStorageCache_MatchAll_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::CacheStorageCache_MatchAll_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->request)::BaseType::BufferWriter
      request_writer;
  mojo::internal::Serialize<::blink::mojom::FetchAPIRequestDataView>(
      in_request, buffer, &request_writer, &serialization_context);
  params->request.Set(
      request_writer.is_null() ? nullptr : request_writer.data());
  typename decltype(params->query_options)::BaseType::BufferWriter
      query_options_writer;
  mojo::internal::Serialize<::blink::mojom::CacheQueryOptionsDataView>(
      in_query_options, buffer, &query_options_writer, &serialization_context);
  params->query_options.Set(
      query_options_writer.is_null() ? nullptr : query_options_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->query_options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null query_options in CacheStorageCache.MatchAll request");
  params->trace_id = in_trace_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageCache::Name_);
  message.set_method_name("MatchAll");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CacheStorageCache_MatchAll_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CacheStorageCacheProxy::Keys(
    ::blink::mojom::blink::FetchAPIRequestPtr in_request, CacheQueryOptionsPtr in_query_options, int64_t in_trace_id, KeysCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::CacheStorageCache::Keys", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_request.is_null()) {
        raw_value->SetString("request", "nullptr");
      } else {
        raw_value->BeginDictionary("request");
        in_request->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      if (in_query_options.is_null()) {
        raw_value->SetString("query_options", "nullptr");
      } else {
        raw_value->BeginDictionary("query_options");
        in_query_options->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetString("trace_id", base::NumberToString(in_trace_id));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCacheStorageCache_Keys_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::CacheStorageCache_Keys_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->request)::BaseType::BufferWriter
      request_writer;
  mojo::internal::Serialize<::blink::mojom::FetchAPIRequestDataView>(
      in_request, buffer, &request_writer, &serialization_context);
  params->request.Set(
      request_writer.is_null() ? nullptr : request_writer.data());
  typename decltype(params->query_options)::BaseType::BufferWriter
      query_options_writer;
  mojo::internal::Serialize<::blink::mojom::CacheQueryOptionsDataView>(
      in_query_options, buffer, &query_options_writer, &serialization_context);
  params->query_options.Set(
      query_options_writer.is_null() ? nullptr : query_options_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->query_options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null query_options in CacheStorageCache.Keys request");
  params->trace_id = in_trace_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageCache::Name_);
  message.set_method_name("Keys");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CacheStorageCache_Keys_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CacheStorageCacheProxy::Batch(
    WTF::Vector<BatchOperationPtr> in_batch_operations, int64_t in_trace_id, BatchCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::CacheStorageCache::Batch", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("batch_operations");
      for (const auto& item0 : in_batch_operations) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      raw_value->SetString("trace_id", base::NumberToString(in_trace_id));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCacheStorageCache_Batch_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::CacheStorageCache_Batch_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->batch_operations)::BaseType::BufferWriter
      batch_operations_writer;
  const mojo::internal::ContainerValidateParams batch_operations_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::blink::mojom::BatchOperationDataView>>(
      in_batch_operations, buffer, &batch_operations_writer, &batch_operations_validate_params,
      &serialization_context);
  params->batch_operations.Set(
      batch_operations_writer.is_null() ? nullptr : batch_operations_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->batch_operations.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null batch_operations in CacheStorageCache.Batch request");
  params->trace_id = in_trace_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageCache::Name_);
  message.set_method_name("Batch");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CacheStorageCache_Batch_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class CacheStorageCache_Match_ProxyToResponder {
 public:
  static CacheStorageCache::MatchCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CacheStorageCache_Match_ProxyToResponder> proxy(
        new CacheStorageCache_Match_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CacheStorageCache_Match_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CacheStorageCache_Match_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CacheStorageCache_Match_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CacheStorageCache::MatchCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      MatchResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CacheStorageCache_Match_ProxyToResponder);
};

bool CacheStorageCache_Match_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::CacheStorageCache::MatchCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::CacheStorageCache_Match_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CacheStorageCache_Match_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  MatchResultPtr p_result{};
  CacheStorageCache_Match_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CacheStorageCache::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void CacheStorageCache_Match_ProxyToResponder::Run(
    MatchResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::CacheStorageCache::MatchCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result, "<value of type MatchResultPtr>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCacheStorageCache_Match_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::CacheStorageCache_Match_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BufferWriter result_writer;
  result_writer.AllocateInline(buffer, &params->result);
  mojo::internal::Serialize<::blink::mojom::MatchResultDataView>(
      in_result, buffer, &result_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::CacheStorageCache::MatchCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageCache::Name_);
  message.set_method_name("Match");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CacheStorageCache_MatchAll_ProxyToResponder {
 public:
  static CacheStorageCache::MatchAllCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CacheStorageCache_MatchAll_ProxyToResponder> proxy(
        new CacheStorageCache_MatchAll_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CacheStorageCache_MatchAll_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CacheStorageCache_MatchAll_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CacheStorageCache_MatchAll_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CacheStorageCache::MatchAllCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      MatchAllResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CacheStorageCache_MatchAll_ProxyToResponder);
};

bool CacheStorageCache_MatchAll_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::CacheStorageCache::MatchAllCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::CacheStorageCache_MatchAll_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CacheStorageCache_MatchAll_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  MatchAllResultPtr p_result{};
  CacheStorageCache_MatchAll_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CacheStorageCache::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void CacheStorageCache_MatchAll_ProxyToResponder::Run(
    MatchAllResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::CacheStorageCache::MatchAllCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result, "<value of type MatchAllResultPtr>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCacheStorageCache_MatchAll_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::CacheStorageCache_MatchAll_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BufferWriter result_writer;
  result_writer.AllocateInline(buffer, &params->result);
  mojo::internal::Serialize<::blink::mojom::MatchAllResultDataView>(
      in_result, buffer, &result_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::CacheStorageCache::MatchAllCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageCache::Name_);
  message.set_method_name("MatchAll");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CacheStorageCache_Keys_ProxyToResponder {
 public:
  static CacheStorageCache::KeysCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CacheStorageCache_Keys_ProxyToResponder> proxy(
        new CacheStorageCache_Keys_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CacheStorageCache_Keys_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CacheStorageCache_Keys_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CacheStorageCache_Keys_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CacheStorageCache::KeysCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CacheKeysResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CacheStorageCache_Keys_ProxyToResponder);
};

bool CacheStorageCache_Keys_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::CacheStorageCache::KeysCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::CacheStorageCache_Keys_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CacheStorageCache_Keys_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  CacheKeysResultPtr p_result{};
  CacheStorageCache_Keys_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CacheStorageCache::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void CacheStorageCache_Keys_ProxyToResponder::Run(
    CacheKeysResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::CacheStorageCache::KeysCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result, "<value of type CacheKeysResultPtr>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCacheStorageCache_Keys_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::CacheStorageCache_Keys_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BufferWriter result_writer;
  result_writer.AllocateInline(buffer, &params->result);
  mojo::internal::Serialize<::blink::mojom::CacheKeysResultDataView>(
      in_result, buffer, &result_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::CacheStorageCache::KeysCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageCache::Name_);
  message.set_method_name("Keys");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CacheStorageCache_Batch_ProxyToResponder {
 public:
  static CacheStorageCache::BatchCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CacheStorageCache_Batch_ProxyToResponder> proxy(
        new CacheStorageCache_Batch_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CacheStorageCache_Batch_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CacheStorageCache_Batch_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CacheStorageCache_Batch_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CacheStorageCache::BatchCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CacheStorageVerboseErrorPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CacheStorageCache_Batch_ProxyToResponder);
};

bool CacheStorageCache_Batch_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::CacheStorageCache::BatchCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::CacheStorageCache_Batch_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CacheStorageCache_Batch_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  CacheStorageVerboseErrorPtr p_result{};
  CacheStorageCache_Batch_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CacheStorageCache::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void CacheStorageCache_Batch_ProxyToResponder::Run(
    CacheStorageVerboseErrorPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::CacheStorageCache::BatchCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_result.is_null()) {
        raw_value->SetString("result", "nullptr");
      } else {
        raw_value->BeginDictionary("result");
        in_result->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCacheStorageCache_Batch_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::CacheStorageCache_Batch_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BaseType::BufferWriter
      result_writer;
  mojo::internal::Serialize<::blink::mojom::CacheStorageVerboseErrorDataView>(
      in_result, buffer, &result_writer, &serialization_context);
  params->result.Set(
      result_writer.is_null() ? nullptr : result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::CacheStorageCache::BatchCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorageCache::Name_);
  message.set_method_name("Batch");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CacheStorageCacheStubDispatch::Accept(
    CacheStorageCache* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kCacheStorageCache_Match_Name: {
      break;
    }
    case internal::kCacheStorageCache_MatchAll_Name: {
      break;
    }
    case internal::kCacheStorageCache_Keys_Name: {
      break;
    }
    case internal::kCacheStorageCache_Batch_Name: {
      break;
    }
  }
  return false;
}

// static
bool CacheStorageCacheStubDispatch::AcceptWithResponder(
    CacheStorageCache* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCacheStorageCache_Match_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::CacheStorageCache::Match",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::CacheStorageCache::Match");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CacheStorageCache_Match_Params_Data* params =
          reinterpret_cast<
              internal::CacheStorageCache_Match_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::FetchAPIRequestPtr p_request{};
      CacheQueryOptionsPtr p_query_options{};
      bool p_in_related_fetch_event{};
      int64_t p_trace_id{};
      CacheStorageCache_Match_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (success && !input_data_view.ReadQueryOptions(&p_query_options))
        success = false;
      if (success)
        p_in_related_fetch_event = input_data_view.in_related_fetch_event();
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorageCache::Name_, 0, false);
        return false;
      }
      CacheStorageCache::MatchCallback callback =
          CacheStorageCache_Match_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Match(
std::move(p_request), 
std::move(p_query_options), 
std::move(p_in_related_fetch_event), 
std::move(p_trace_id), std::move(callback));
      return true;
    }
    case internal::kCacheStorageCache_MatchAll_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::CacheStorageCache::MatchAll",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::CacheStorageCache::MatchAll");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CacheStorageCache_MatchAll_Params_Data* params =
          reinterpret_cast<
              internal::CacheStorageCache_MatchAll_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::FetchAPIRequestPtr p_request{};
      CacheQueryOptionsPtr p_query_options{};
      int64_t p_trace_id{};
      CacheStorageCache_MatchAll_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (success && !input_data_view.ReadQueryOptions(&p_query_options))
        success = false;
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorageCache::Name_, 1, false);
        return false;
      }
      CacheStorageCache::MatchAllCallback callback =
          CacheStorageCache_MatchAll_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MatchAll(
std::move(p_request), 
std::move(p_query_options), 
std::move(p_trace_id), std::move(callback));
      return true;
    }
    case internal::kCacheStorageCache_Keys_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::CacheStorageCache::Keys",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::CacheStorageCache::Keys");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CacheStorageCache_Keys_Params_Data* params =
          reinterpret_cast<
              internal::CacheStorageCache_Keys_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::FetchAPIRequestPtr p_request{};
      CacheQueryOptionsPtr p_query_options{};
      int64_t p_trace_id{};
      CacheStorageCache_Keys_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (success && !input_data_view.ReadQueryOptions(&p_query_options))
        success = false;
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorageCache::Name_, 2, false);
        return false;
      }
      CacheStorageCache::KeysCallback callback =
          CacheStorageCache_Keys_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Keys(
std::move(p_request), 
std::move(p_query_options), 
std::move(p_trace_id), std::move(callback));
      return true;
    }
    case internal::kCacheStorageCache_Batch_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::CacheStorageCache::Batch",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::CacheStorageCache::Batch");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CacheStorageCache_Batch_Params_Data* params =
          reinterpret_cast<
              internal::CacheStorageCache_Batch_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WTF::Vector<BatchOperationPtr> p_batch_operations{};
      int64_t p_trace_id{};
      CacheStorageCache_Batch_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadBatchOperations(&p_batch_operations))
        success = false;
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorageCache::Name_, 3, false);
        return false;
      }
      CacheStorageCache::BatchCallback callback =
          CacheStorageCache_Batch_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Batch(
std::move(p_batch_operations), 
std::move(p_trace_id), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kCacheStorageCacheValidationInfo[] = {
    {&internal::CacheStorageCache_Match_Params_Data::Validate,
     &internal::CacheStorageCache_Match_ResponseParams_Data::Validate},
    {&internal::CacheStorageCache_MatchAll_Params_Data::Validate,
     &internal::CacheStorageCache_MatchAll_ResponseParams_Data::Validate},
    {&internal::CacheStorageCache_Keys_Params_Data::Validate,
     &internal::CacheStorageCache_Keys_ResponseParams_Data::Validate},
    {&internal::CacheStorageCache_Batch_Params_Data::Validate,
     &internal::CacheStorageCache_Batch_ResponseParams_Data::Validate},
};

bool CacheStorageCacheRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::CacheStorageCache::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kCacheStorageCacheValidationInfo);
}

bool CacheStorageCacheResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::CacheStorageCache::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kCacheStorageCacheValidationInfo);
}
const char CacheStorage::Name_[] = "blink.mojom.CacheStorage";

class CacheStorage_Has_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CacheStorage_Has_ForwardToCallback(
      CacheStorage::HasCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CacheStorage::HasCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CacheStorage_Has_ForwardToCallback);
};

class CacheStorage_Delete_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CacheStorage_Delete_ForwardToCallback(
      CacheStorage::DeleteCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CacheStorage::DeleteCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CacheStorage_Delete_ForwardToCallback);
};

class CacheStorage_Keys_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CacheStorage_Keys_ForwardToCallback(
      CacheStorage::KeysCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CacheStorage::KeysCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CacheStorage_Keys_ForwardToCallback);
};

class CacheStorage_Match_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CacheStorage_Match_ForwardToCallback(
      CacheStorage::MatchCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CacheStorage::MatchCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CacheStorage_Match_ForwardToCallback);
};

class CacheStorage_Open_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CacheStorage_Open_ForwardToCallback(
      CacheStorage::OpenCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CacheStorage::OpenCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CacheStorage_Open_ForwardToCallback);
};

CacheStorageProxy::CacheStorageProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CacheStorageProxy::Has(
    const ::WTF::String& in_cache_name, int64_t in_trace_id, HasCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::CacheStorage::Has", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("cache_name", base::trace_event::ValueToString(in_cache_name, "<value of type const ::WTF::String&>"));
      raw_value->SetString("trace_id", base::NumberToString(in_trace_id));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCacheStorage_Has_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::CacheStorage_Has_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->cache_name)::BaseType::BufferWriter
      cache_name_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_cache_name, buffer, &cache_name_writer, &serialization_context);
  params->cache_name.Set(
      cache_name_writer.is_null() ? nullptr : cache_name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cache_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cache_name in CacheStorage.Has request");
  params->trace_id = in_trace_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorage::Name_);
  message.set_method_name("Has");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CacheStorage_Has_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CacheStorageProxy::Delete(
    const ::WTF::String& in_cache_name, int64_t in_trace_id, DeleteCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::CacheStorage::Delete", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("cache_name", base::trace_event::ValueToString(in_cache_name, "<value of type const ::WTF::String&>"));
      raw_value->SetString("trace_id", base::NumberToString(in_trace_id));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCacheStorage_Delete_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::CacheStorage_Delete_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->cache_name)::BaseType::BufferWriter
      cache_name_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_cache_name, buffer, &cache_name_writer, &serialization_context);
  params->cache_name.Set(
      cache_name_writer.is_null() ? nullptr : cache_name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cache_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cache_name in CacheStorage.Delete request");
  params->trace_id = in_trace_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorage::Name_);
  message.set_method_name("Delete");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CacheStorage_Delete_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CacheStorageProxy::Keys(
    int64_t in_trace_id, KeysCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::CacheStorage::Keys", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("trace_id", base::NumberToString(in_trace_id));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCacheStorage_Keys_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::CacheStorage_Keys_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->trace_id = in_trace_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorage::Name_);
  message.set_method_name("Keys");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CacheStorage_Keys_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CacheStorageProxy::Match(
    ::blink::mojom::blink::FetchAPIRequestPtr in_request, MultiCacheQueryOptionsPtr in_match_options, bool in_in_related_fetch_event, int64_t in_trace_id, MatchCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::CacheStorage::Match", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_request.is_null()) {
        raw_value->SetString("request", "nullptr");
      } else {
        raw_value->BeginDictionary("request");
        in_request->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      if (in_match_options.is_null()) {
        raw_value->SetString("match_options", "nullptr");
      } else {
        raw_value->BeginDictionary("match_options");
        in_match_options->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("in_related_fetch_event", in_in_related_fetch_event);
      raw_value->SetString("trace_id", base::NumberToString(in_trace_id));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCacheStorage_Match_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::CacheStorage_Match_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->request)::BaseType::BufferWriter
      request_writer;
  mojo::internal::Serialize<::blink::mojom::FetchAPIRequestDataView>(
      in_request, buffer, &request_writer, &serialization_context);
  params->request.Set(
      request_writer.is_null() ? nullptr : request_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request in CacheStorage.Match request");
  typename decltype(params->match_options)::BaseType::BufferWriter
      match_options_writer;
  mojo::internal::Serialize<::blink::mojom::MultiCacheQueryOptionsDataView>(
      in_match_options, buffer, &match_options_writer, &serialization_context);
  params->match_options.Set(
      match_options_writer.is_null() ? nullptr : match_options_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->match_options.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null match_options in CacheStorage.Match request");
  params->in_related_fetch_event = in_in_related_fetch_event;
  params->trace_id = in_trace_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorage::Name_);
  message.set_method_name("Match");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CacheStorage_Match_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CacheStorageProxy::Open(
    const ::WTF::String& in_cache_name, int64_t in_trace_id, OpenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::CacheStorage::Open", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("cache_name", base::trace_event::ValueToString(in_cache_name, "<value of type const ::WTF::String&>"));
      raw_value->SetString("trace_id", base::NumberToString(in_trace_id));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCacheStorage_Open_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::CacheStorage_Open_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->cache_name)::BaseType::BufferWriter
      cache_name_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_cache_name, buffer, &cache_name_writer, &serialization_context);
  params->cache_name.Set(
      cache_name_writer.is_null() ? nullptr : cache_name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cache_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cache_name in CacheStorage.Open request");
  params->trace_id = in_trace_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorage::Name_);
  message.set_method_name("Open");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CacheStorage_Open_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class CacheStorage_Has_ProxyToResponder {
 public:
  static CacheStorage::HasCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CacheStorage_Has_ProxyToResponder> proxy(
        new CacheStorage_Has_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CacheStorage_Has_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CacheStorage_Has_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CacheStorage_Has_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CacheStorage::HasCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CacheStorageError in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CacheStorage_Has_ProxyToResponder);
};

bool CacheStorage_Has_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::CacheStorage::HasCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::CacheStorage_Has_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CacheStorage_Has_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  CacheStorageError p_result{};
  CacheStorage_Has_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CacheStorage::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void CacheStorage_Has_ProxyToResponder::Run(
    CacheStorageError in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::CacheStorage::HasCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCacheStorage_Has_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::CacheStorage_Has_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::CacheStorageError>(
      in_result, &params->result);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::CacheStorage::HasCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorage::Name_);
  message.set_method_name("Has");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CacheStorage_Delete_ProxyToResponder {
 public:
  static CacheStorage::DeleteCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CacheStorage_Delete_ProxyToResponder> proxy(
        new CacheStorage_Delete_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CacheStorage_Delete_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CacheStorage_Delete_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CacheStorage_Delete_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CacheStorage::DeleteCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      CacheStorageError in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CacheStorage_Delete_ProxyToResponder);
};

bool CacheStorage_Delete_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::CacheStorage::DeleteCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::CacheStorage_Delete_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CacheStorage_Delete_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  CacheStorageError p_result{};
  CacheStorage_Delete_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CacheStorage::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void CacheStorage_Delete_ProxyToResponder::Run(
    CacheStorageError in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::CacheStorage::DeleteCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCacheStorage_Delete_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::CacheStorage_Delete_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::CacheStorageError>(
      in_result, &params->result);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::CacheStorage::DeleteCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorage::Name_);
  message.set_method_name("Delete");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CacheStorage_Keys_ProxyToResponder {
 public:
  static CacheStorage::KeysCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CacheStorage_Keys_ProxyToResponder> proxy(
        new CacheStorage_Keys_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CacheStorage_Keys_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CacheStorage_Keys_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CacheStorage_Keys_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CacheStorage::KeysCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const WTF::Vector<::WTF::String>& in_keys);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CacheStorage_Keys_ProxyToResponder);
};

bool CacheStorage_Keys_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::CacheStorage::KeysCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::CacheStorage_Keys_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CacheStorage_Keys_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  WTF::Vector<::WTF::String> p_keys{};
  CacheStorage_Keys_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadKeys(&p_keys))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CacheStorage::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_keys));
  return true;
}

void CacheStorage_Keys_ProxyToResponder::Run(
    const WTF::Vector<::WTF::String>& in_keys) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::CacheStorage::KeysCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("keys");
      for (const auto& item0 : in_keys) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::WTF::String&>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCacheStorage_Keys_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::CacheStorage_Keys_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->keys)::BaseType::BufferWriter
      keys_writer;
  const mojo::internal::ContainerValidateParams keys_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::String16DataView>>(
      in_keys, buffer, &keys_writer, &keys_validate_params,
      &serialization_context);
  params->keys.Set(
      keys_writer.is_null() ? nullptr : keys_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->keys.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null keys in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::CacheStorage::KeysCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorage::Name_);
  message.set_method_name("Keys");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CacheStorage_Match_ProxyToResponder {
 public:
  static CacheStorage::MatchCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CacheStorage_Match_ProxyToResponder> proxy(
        new CacheStorage_Match_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CacheStorage_Match_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CacheStorage_Match_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CacheStorage_Match_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CacheStorage::MatchCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      MatchResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CacheStorage_Match_ProxyToResponder);
};

bool CacheStorage_Match_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::CacheStorage::MatchCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::CacheStorage_Match_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CacheStorage_Match_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  MatchResultPtr p_result{};
  CacheStorage_Match_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CacheStorage::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void CacheStorage_Match_ProxyToResponder::Run(
    MatchResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::CacheStorage::MatchCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result, "<value of type MatchResultPtr>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCacheStorage_Match_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::CacheStorage_Match_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BufferWriter result_writer;
  result_writer.AllocateInline(buffer, &params->result);
  mojo::internal::Serialize<::blink::mojom::MatchResultDataView>(
      in_result, buffer, &result_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::CacheStorage::MatchCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorage::Name_);
  message.set_method_name("Match");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class CacheStorage_Open_ProxyToResponder {
 public:
  static CacheStorage::OpenCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CacheStorage_Open_ProxyToResponder> proxy(
        new CacheStorage_Open_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CacheStorage_Open_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CacheStorage_Open_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CacheStorage_Open_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CacheStorage::OpenCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      OpenResultPtr in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CacheStorage_Open_ProxyToResponder);
};

bool CacheStorage_Open_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::CacheStorage::OpenCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::CacheStorage_Open_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CacheStorage_Open_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  OpenResultPtr p_result{};
  CacheStorage_Open_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadResult(&p_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CacheStorage::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void CacheStorage_Open_ProxyToResponder::Run(
    OpenResultPtr in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::CacheStorage::OpenCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("result", base::trace_event::ValueToString(in_result, "<value of type OpenResultPtr>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCacheStorage_Open_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::CacheStorage_Open_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->result)::BufferWriter result_writer;
  result_writer.AllocateInline(buffer, &params->result);
  mojo::internal::Serialize<::blink::mojom::OpenResultDataView>(
      in_result, buffer, &result_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::CacheStorage::OpenCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CacheStorage::Name_);
  message.set_method_name("Open");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CacheStorageStubDispatch::Accept(
    CacheStorage* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kCacheStorage_Has_Name: {
      break;
    }
    case internal::kCacheStorage_Delete_Name: {
      break;
    }
    case internal::kCacheStorage_Keys_Name: {
      break;
    }
    case internal::kCacheStorage_Match_Name: {
      break;
    }
    case internal::kCacheStorage_Open_Name: {
      break;
    }
  }
  return false;
}

// static
bool CacheStorageStubDispatch::AcceptWithResponder(
    CacheStorage* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCacheStorage_Has_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::CacheStorage::Has",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::CacheStorage::Has");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CacheStorage_Has_Params_Data* params =
          reinterpret_cast<
              internal::CacheStorage_Has_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::WTF::String p_cache_name{};
      int64_t p_trace_id{};
      CacheStorage_Has_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCacheName(&p_cache_name))
        success = false;
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorage::Name_, 0, false);
        return false;
      }
      CacheStorage::HasCallback callback =
          CacheStorage_Has_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Has(
std::move(p_cache_name), 
std::move(p_trace_id), std::move(callback));
      return true;
    }
    case internal::kCacheStorage_Delete_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::CacheStorage::Delete",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::CacheStorage::Delete");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CacheStorage_Delete_Params_Data* params =
          reinterpret_cast<
              internal::CacheStorage_Delete_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::WTF::String p_cache_name{};
      int64_t p_trace_id{};
      CacheStorage_Delete_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCacheName(&p_cache_name))
        success = false;
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorage::Name_, 1, false);
        return false;
      }
      CacheStorage::DeleteCallback callback =
          CacheStorage_Delete_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Delete(
std::move(p_cache_name), 
std::move(p_trace_id), std::move(callback));
      return true;
    }
    case internal::kCacheStorage_Keys_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::CacheStorage::Keys",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::CacheStorage::Keys");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CacheStorage_Keys_Params_Data* params =
          reinterpret_cast<
              internal::CacheStorage_Keys_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int64_t p_trace_id{};
      CacheStorage_Keys_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorage::Name_, 2, false);
        return false;
      }
      CacheStorage::KeysCallback callback =
          CacheStorage_Keys_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Keys(
std::move(p_trace_id), std::move(callback));
      return true;
    }
    case internal::kCacheStorage_Match_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::CacheStorage::Match",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::CacheStorage::Match");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CacheStorage_Match_Params_Data* params =
          reinterpret_cast<
              internal::CacheStorage_Match_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::blink::FetchAPIRequestPtr p_request{};
      MultiCacheQueryOptionsPtr p_match_options{};
      bool p_in_related_fetch_event{};
      int64_t p_trace_id{};
      CacheStorage_Match_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (success && !input_data_view.ReadMatchOptions(&p_match_options))
        success = false;
      if (success)
        p_in_related_fetch_event = input_data_view.in_related_fetch_event();
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorage::Name_, 3, false);
        return false;
      }
      CacheStorage::MatchCallback callback =
          CacheStorage_Match_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Match(
std::move(p_request), 
std::move(p_match_options), 
std::move(p_in_related_fetch_event), 
std::move(p_trace_id), std::move(callback));
      return true;
    }
    case internal::kCacheStorage_Open_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::CacheStorage::Open",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::CacheStorage::Open");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CacheStorage_Open_Params_Data* params =
          reinterpret_cast<
              internal::CacheStorage_Open_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::WTF::String p_cache_name{};
      int64_t p_trace_id{};
      CacheStorage_Open_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCacheName(&p_cache_name))
        success = false;
      if (success)
        p_trace_id = input_data_view.trace_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CacheStorage::Name_, 4, false);
        return false;
      }
      CacheStorage::OpenCallback callback =
          CacheStorage_Open_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Open(
std::move(p_cache_name), 
std::move(p_trace_id), std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kCacheStorageValidationInfo[] = {
    {&internal::CacheStorage_Has_Params_Data::Validate,
     &internal::CacheStorage_Has_ResponseParams_Data::Validate},
    {&internal::CacheStorage_Delete_Params_Data::Validate,
     &internal::CacheStorage_Delete_ResponseParams_Data::Validate},
    {&internal::CacheStorage_Keys_Params_Data::Validate,
     &internal::CacheStorage_Keys_ResponseParams_Data::Validate},
    {&internal::CacheStorage_Match_Params_Data::Validate,
     &internal::CacheStorage_Match_ResponseParams_Data::Validate},
    {&internal::CacheStorage_Open_Params_Data::Validate,
     &internal::CacheStorage_Open_ResponseParams_Data::Validate},
};

bool CacheStorageRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::CacheStorage::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kCacheStorageValidationInfo);
}

bool CacheStorageResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::blink::CacheStorage::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kCacheStorageValidationInfo);
}
}  // namespace blink
}  // namespace mojom
}  // namespace blink

namespace mojo {


// static
bool StructTraits<::blink::mojom::blink::CacheStorageVerboseError::DataView, ::blink::mojom::blink::CacheStorageVerboseErrorPtr>::Read(
    ::blink::mojom::blink::CacheStorageVerboseError::DataView input,
    ::blink::mojom::blink::CacheStorageVerboseErrorPtr* output) {
  bool success = true;
  ::blink::mojom::blink::CacheStorageVerboseErrorPtr result(::blink::mojom::blink::CacheStorageVerboseError::New());
  
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadMessage(&result->message))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::CacheQueryOptions::DataView, ::blink::mojom::blink::CacheQueryOptionsPtr>::Read(
    ::blink::mojom::blink::CacheQueryOptions::DataView input,
    ::blink::mojom::blink::CacheQueryOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::CacheQueryOptionsPtr result(::blink::mojom::blink::CacheQueryOptions::New());
  
      if (success)
        result->ignore_search = input.ignore_search();
      if (success)
        result->ignore_method = input.ignore_method();
      if (success)
        result->ignore_vary = input.ignore_vary();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::MultiCacheQueryOptions::DataView, ::blink::mojom::blink::MultiCacheQueryOptionsPtr>::Read(
    ::blink::mojom::blink::MultiCacheQueryOptions::DataView input,
    ::blink::mojom::blink::MultiCacheQueryOptionsPtr* output) {
  bool success = true;
  ::blink::mojom::blink::MultiCacheQueryOptionsPtr result(::blink::mojom::blink::MultiCacheQueryOptions::New());
  
      if (success && !input.ReadQueryOptions(&result->query_options))
        success = false;
      if (success && !input.ReadCacheName(&result->cache_name))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::BatchOperation::DataView, ::blink::mojom::blink::BatchOperationPtr>::Read(
    ::blink::mojom::blink::BatchOperation::DataView input,
    ::blink::mojom::blink::BatchOperationPtr* output) {
  bool success = true;
  ::blink::mojom::blink::BatchOperationPtr result(::blink::mojom::blink::BatchOperation::New());
  
      if (success && !input.ReadOperationType(&result->operation_type))
        success = false;
      if (success && !input.ReadRequest(&result->request))
        success = false;
      if (success && !input.ReadResponse(&result->response))
        success = false;
      if (success && !input.ReadMatchOptions(&result->match_options))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::blink::mojom::blink::EagerResponse::DataView, ::blink::mojom::blink::EagerResponsePtr>::Read(
    ::blink::mojom::blink::EagerResponse::DataView input,
    ::blink::mojom::blink::EagerResponsePtr* output) {
  bool success = true;
  ::blink::mojom::blink::EagerResponsePtr result(::blink::mojom::blink::EagerResponse::New());
  
      if (success && !input.ReadResponse(&result->response))
        success = false;
      if (success)
        result->pipe = input.TakePipe();
      if (success) {
        result->client_receiver =
            input.TakeClientReceiver<decltype(result->client_receiver)>();
      }
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::blink::mojom::blink::OpenResult::DataView, ::blink::mojom::blink::OpenResultPtr>::Read(
    ::blink::mojom::blink::OpenResult::DataView input,
    ::blink::mojom::blink::OpenResultPtr* output) {
  using UnionType = ::blink::mojom::blink::OpenResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::STATUS: {
      ::blink::mojom::blink::CacheStorageError result_status;
      if (!input.ReadStatus(&result_status))
        return false;

      *output = UnionType::NewStatus(result_status);
      break;
    }
    case Tag::CACHE: {
      *output = UnionType::NewCache(
          input.TakeCache<::mojo::PendingAssociatedRemote<::blink::mojom::blink::CacheStorageCache>>());
      break;
    }
    default:
      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::MatchResult::DataView, ::blink::mojom::blink::MatchResultPtr>::Read(
    ::blink::mojom::blink::MatchResult::DataView input,
    ::blink::mojom::blink::MatchResultPtr* output) {
  using UnionType = ::blink::mojom::blink::MatchResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::STATUS: {
      ::blink::mojom::blink::CacheStorageError result_status;
      if (!input.ReadStatus(&result_status))
        return false;

      *output = UnionType::NewStatus(result_status);
      break;
    }
    case Tag::RESPONSE: {
      ::blink::mojom::blink::FetchAPIResponsePtr result_response;
      if (!input.ReadResponse(&result_response))
        return false;

      *output = UnionType::NewResponse(
          std::move(result_response));
      break;
    }
    case Tag::EAGER_RESPONSE: {
      ::blink::mojom::blink::EagerResponsePtr result_eager_response;
      if (!input.ReadEagerResponse(&result_eager_response))
        return false;

      *output = UnionType::NewEagerResponse(
          std::move(result_eager_response));
      break;
    }
    default:
      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::MatchAllResult::DataView, ::blink::mojom::blink::MatchAllResultPtr>::Read(
    ::blink::mojom::blink::MatchAllResult::DataView input,
    ::blink::mojom::blink::MatchAllResultPtr* output) {
  using UnionType = ::blink::mojom::blink::MatchAllResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::STATUS: {
      ::blink::mojom::blink::CacheStorageError result_status;
      if (!input.ReadStatus(&result_status))
        return false;

      *output = UnionType::NewStatus(result_status);
      break;
    }
    case Tag::RESPONSES: {
      WTF::Vector<::blink::mojom::blink::FetchAPIResponsePtr> result_responses;
      if (!input.ReadResponses(&result_responses))
        return false;

      *output = UnionType::NewResponses(
          std::move(result_responses));
      break;
    }
    default:
      return false;
  }
  return true;
}

// static
bool UnionTraits<::blink::mojom::blink::CacheKeysResult::DataView, ::blink::mojom::blink::CacheKeysResultPtr>::Read(
    ::blink::mojom::blink::CacheKeysResult::DataView input,
    ::blink::mojom::blink::CacheKeysResultPtr* output) {
  using UnionType = ::blink::mojom::blink::CacheKeysResult;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::STATUS: {
      ::blink::mojom::blink::CacheStorageError result_status;
      if (!input.ReadStatus(&result_status))
        return false;

      *output = UnionType::NewStatus(result_status);
      break;
    }
    case Tag::KEYS: {
      WTF::Vector<::blink::mojom::blink::FetchAPIRequestPtr> result_keys;
      if (!input.ReadKeys(&result_keys))
        return false;

      *output = UnionType::NewKeys(
          std::move(result_keys));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif