// services/video_capture/public/mojom/video_frame_handler.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_FRAME_HANDLER_MOJOM_H_
#define SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_FRAME_HANDLER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/video_capture/public/mojom/video_frame_handler.mojom-shared.h"
#include "services/video_capture/public/mojom/video_frame_handler.mojom-forward.h"
#include "media/capture/mojom/video_capture_types.mojom.h"
#include "services/video_capture/public/mojom/scoped_access_permission.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace video_capture {
namespace mojom {

class VideoFrameHandlerProxy;

template <typename ImplRefTraits>
class VideoFrameHandlerStub;

class VideoFrameHandlerRequestValidator;


class  VideoFrameHandler
    : public VideoFrameHandlerInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = VideoFrameHandlerInterfaceBase;
  using Proxy_ = VideoFrameHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = VideoFrameHandlerStub<ImplRefTraits>;

  using RequestValidator_ = VideoFrameHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnNewBufferMinVersion = 0,
    kOnFrameReadyInBufferMinVersion = 0,
    kOnBufferRetiredMinVersion = 0,
    kOnErrorMinVersion = 0,
    kOnFrameDroppedMinVersion = 0,
    kOnLogMinVersion = 0,
    kOnStartedMinVersion = 0,
    kOnStartedUsingGpuDecodeMinVersion = 0,
    kOnStoppedMinVersion = 0,
  };
  virtual ~VideoFrameHandler() {}

  
  virtual void OnNewBuffer(int32_t buffer_id, ::media::mojom::VideoBufferHandlePtr buffer_handle) = 0;

  
  virtual void OnFrameReadyInBuffer(int32_t buffer_id, int32_t frame_feedback_id, ::mojo::PendingRemote<::video_capture::mojom::ScopedAccessPermission> access_permission, ::media::mojom::VideoFrameInfoPtr frame_info) = 0;

  
  virtual void OnBufferRetired(int32_t buffer_id) = 0;

  
  virtual void OnError(::media::VideoCaptureError error) = 0;

  
  virtual void OnFrameDropped(::media::VideoCaptureFrameDropReason reason) = 0;

  
  virtual void OnLog(const std::string& message) = 0;

  
  virtual void OnStarted() = 0;

  
  virtual void OnStartedUsingGpuDecode() = 0;

  
  virtual void OnStopped() = 0;
};



class  VideoFrameHandlerProxy
    : public VideoFrameHandler {
 public:
  using InterfaceType = VideoFrameHandler;

  explicit VideoFrameHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnNewBuffer(int32_t buffer_id, ::media::mojom::VideoBufferHandlePtr buffer_handle) final;
  
  void OnFrameReadyInBuffer(int32_t buffer_id, int32_t frame_feedback_id, ::mojo::PendingRemote<::video_capture::mojom::ScopedAccessPermission> access_permission, ::media::mojom::VideoFrameInfoPtr frame_info) final;
  
  void OnBufferRetired(int32_t buffer_id) final;
  
  void OnError(::media::VideoCaptureError error) final;
  
  void OnFrameDropped(::media::VideoCaptureFrameDropReason reason) final;
  
  void OnLog(const std::string& message) final;
  
  void OnStarted() final;
  
  void OnStartedUsingGpuDecode() final;
  
  void OnStopped() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  VideoFrameHandlerStubDispatch {
 public:
  static bool Accept(VideoFrameHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      VideoFrameHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<VideoFrameHandler>>
class VideoFrameHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  VideoFrameHandlerStub() {}
  ~VideoFrameHandlerStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoFrameHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return VideoFrameHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  VideoFrameHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace video_capture

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_VIDEO_CAPTURE_PUBLIC_MOJOM_VIDEO_FRAME_HANDLER_MOJOM_H_