// services/data_decoder/public/mojom/resource_snapshot_for_web_bundle.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_RESOURCE_SNAPSHOT_FOR_WEB_BUNDLE_MOJOM_BLINK_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_RESOURCE_SNAPSHOT_FOR_WEB_BUNDLE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/data_decoder/public/mojom/resource_snapshot_for_web_bundle.mojom-shared.h"
#include "services/data_decoder/public/mojom/resource_snapshot_for_web_bundle.mojom-blink-forward.h"
#include "mojo/public/mojom/base/big_buffer.mojom-blink.h"
#include "url/mojom/url.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/public/platform/web_common.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace data_decoder {
namespace mojom {
namespace blink {

class ResourceSnapshotForWebBundleProxy;

template <typename ImplRefTraits>
class ResourceSnapshotForWebBundleStub;

class ResourceSnapshotForWebBundleRequestValidator;
class ResourceSnapshotForWebBundleResponseValidator;


class BLINK_PLATFORM_EXPORT ResourceSnapshotForWebBundle
    : public ResourceSnapshotForWebBundleInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ResourceSnapshotForWebBundleInterfaceBase;
  using Proxy_ = ResourceSnapshotForWebBundleProxy;

  template <typename ImplRefTraits>
  using Stub_ = ResourceSnapshotForWebBundleStub<ImplRefTraits>;

  using RequestValidator_ = ResourceSnapshotForWebBundleRequestValidator;
  using ResponseValidator_ = ResourceSnapshotForWebBundleResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetResourceCountMinVersion = 0,
    kGetResourceInfoMinVersion = 0,
    kGetResourceBodyMinVersion = 0,
  };
  virtual ~ResourceSnapshotForWebBundle() {}


  using GetResourceCountCallback = base::OnceCallback<void(uint64_t)>;
  
  virtual void GetResourceCount(GetResourceCountCallback callback) = 0;


  using GetResourceInfoCallback = base::OnceCallback<void(SerializedResourceInfoPtr)>;
  
  virtual void GetResourceInfo(uint64_t index, GetResourceInfoCallback callback) = 0;


  using GetResourceBodyCallback = base::OnceCallback<void(base::Optional<::mojo_base::BigBuffer>)>;
  
  virtual void GetResourceBody(uint64_t index, GetResourceBodyCallback callback) = 0;
};



class BLINK_PLATFORM_EXPORT ResourceSnapshotForWebBundleProxy
    : public ResourceSnapshotForWebBundle {
 public:
  using InterfaceType = ResourceSnapshotForWebBundle;

  explicit ResourceSnapshotForWebBundleProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetResourceCount(GetResourceCountCallback callback) final;
  
  void GetResourceInfo(uint64_t index, GetResourceInfoCallback callback) final;
  
  void GetResourceBody(uint64_t index, GetResourceBodyCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT ResourceSnapshotForWebBundleStubDispatch {
 public:
  static bool Accept(ResourceSnapshotForWebBundle* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ResourceSnapshotForWebBundle* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ResourceSnapshotForWebBundle>>
class ResourceSnapshotForWebBundleStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ResourceSnapshotForWebBundleStub() {}
  ~ResourceSnapshotForWebBundleStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ResourceSnapshotForWebBundleStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ResourceSnapshotForWebBundleStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT ResourceSnapshotForWebBundleRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT ResourceSnapshotForWebBundleResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class BLINK_PLATFORM_EXPORT SerializedResourceInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SerializedResourceInfo, T>::value>;
  using DataView = SerializedResourceInfoDataView;
  using Data_ = internal::SerializedResourceInfo_Data;

  template <typename... Args>
  static SerializedResourceInfoPtr New(Args&&... args) {
    return SerializedResourceInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SerializedResourceInfoPtr From(const U& u) {
    return mojo::TypeConverter<SerializedResourceInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SerializedResourceInfo>::Convert(*this);
  }


  SerializedResourceInfo();

  SerializedResourceInfo(
      const ::blink::KURL& url,
      const WTF::String& mime_type,
      uint64_t size);

  ~SerializedResourceInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SerializedResourceInfoPtr>
  SerializedResourceInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SerializedResourceInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SerializedResourceInfo::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SerializedResourceInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SerializedResourceInfo_UnserializedMessageContext<
            UserType, SerializedResourceInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SerializedResourceInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return SerializedResourceInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SerializedResourceInfo_UnserializedMessageContext<
            UserType, SerializedResourceInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SerializedResourceInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::blink::KURL url;
  
  WTF::String mime_type;
  
  uint64_t size;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SerializedResourceInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SerializedResourceInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SerializedResourceInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SerializedResourceInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
SerializedResourceInfoPtr SerializedResourceInfo::Clone() const {
  return New(
      mojo::Clone(url),
      mojo::Clone(mime_type),
      mojo::Clone(size)
  );
}

template <typename T, SerializedResourceInfo::EnableIfSame<T>*>
bool SerializedResourceInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->mime_type, other_struct.mime_type))
    return false;
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  return true;
}

template <typename T, SerializedResourceInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.url, rhs.url))
    return true;
  if (std::less<>{}(rhs.url, lhs.url))
    return false;
  if (std::less<>{}(lhs.mime_type, rhs.mime_type))
    return true;
  if (std::less<>{}(rhs.mime_type, lhs.mime_type))
    return false;
  if (std::less<>{}(lhs.size, rhs.size))
    return true;
  if (std::less<>{}(rhs.size, lhs.size))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace data_decoder

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::data_decoder::mojom::blink::SerializedResourceInfo::DataView,
                                         ::data_decoder::mojom::blink::SerializedResourceInfoPtr> {
  static bool IsNull(const ::data_decoder::mojom::blink::SerializedResourceInfoPtr& input) { return !input; }
  static void SetToNull(::data_decoder::mojom::blink::SerializedResourceInfoPtr* output) { output->reset(); }

  static const decltype(::data_decoder::mojom::blink::SerializedResourceInfo::url)& url(
      const ::data_decoder::mojom::blink::SerializedResourceInfoPtr& input) {
    return input->url;
  }

  static const decltype(::data_decoder::mojom::blink::SerializedResourceInfo::mime_type)& mime_type(
      const ::data_decoder::mojom::blink::SerializedResourceInfoPtr& input) {
    return input->mime_type;
  }

  static decltype(::data_decoder::mojom::blink::SerializedResourceInfo::size) size(
      const ::data_decoder::mojom::blink::SerializedResourceInfoPtr& input) {
    return input->size;
  }

  static bool Read(::data_decoder::mojom::blink::SerializedResourceInfo::DataView input, ::data_decoder::mojom::blink::SerializedResourceInfoPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_DATA_DECODER_PUBLIC_MOJOM_RESOURCE_SNAPSHOT_FOR_WEB_BUNDLE_MOJOM_BLINK_H_