// media/mojo/mojom/frame_interface_factory.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/frame_interface_factory.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "media/mojo/mojom/frame_interface_factory.mojom-params-data.h"
#include "media/mojo/mojom/frame_interface_factory.mojom-shared-message-ids.h"

#include "media/mojo/mojom/frame_interface_factory.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_FRAME_INTERFACE_FACTORY_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_FRAME_INTERFACE_FACTORY_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
const char FrameInterfaceFactory::Name_[] = "media.mojom.FrameInterfaceFactory";
bool FrameInterfaceFactory::GetCdmOrigin(::url::Origin* out_cdm_origin) {
  NOTREACHED();
  return false;
}
class FrameInterfaceFactory_GetCdmOrigin_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  FrameInterfaceFactory_GetCdmOrigin_HandleSyncResponse(
      bool* result, ::url::Origin* out_cdm_origin)
      : result_(result), out_cdm_origin_(out_cdm_origin) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  ::url::Origin* out_cdm_origin_;DISALLOW_COPY_AND_ASSIGN(FrameInterfaceFactory_GetCdmOrigin_HandleSyncResponse);
};

class FrameInterfaceFactory_GetCdmOrigin_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameInterfaceFactory_GetCdmOrigin_ForwardToCallback(
      FrameInterfaceFactory::GetCdmOriginCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FrameInterfaceFactory::GetCdmOriginCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FrameInterfaceFactory_GetCdmOrigin_ForwardToCallback);
};

FrameInterfaceFactoryProxy::FrameInterfaceFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameInterfaceFactoryProxy::CreateProvisionFetcher(
    ::mojo::PendingReceiver<::media::mojom::ProvisionFetcher> in_provision_fetcher) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::FrameInterfaceFactory::CreateProvisionFetcher", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("provision_fetcher", in_provision_fetcher.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameInterfaceFactory_CreateProvisionFetcher_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::FrameInterfaceFactory_CreateProvisionFetcher_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::ProvisionFetcherInterfaceBase>>(
      in_provision_fetcher, &params->provision_fetcher, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->provision_fetcher),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid provision_fetcher in FrameInterfaceFactory.CreateProvisionFetcher request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameInterfaceFactory::Name_);
  message.set_method_name("CreateProvisionFetcher");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameInterfaceFactoryProxy::CreateCdmStorage(
    ::mojo::PendingReceiver<::media::mojom::CdmStorage> in_cdm_storage) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::FrameInterfaceFactory::CreateCdmStorage", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("cdm_storage", in_cdm_storage.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameInterfaceFactory_CreateCdmStorage_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::FrameInterfaceFactory_CreateCdmStorage_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::CdmStorageInterfaceBase>>(
      in_cdm_storage, &params->cdm_storage, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->cdm_storage),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid cdm_storage in FrameInterfaceFactory.CreateCdmStorage request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameInterfaceFactory::Name_);
  message.set_method_name("CreateCdmStorage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
bool FrameInterfaceFactoryProxy::GetCdmOrigin(
    ::url::Origin* out_param_cdm_origin) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "media::mojom::FrameInterfaceFactory::GetCdmOrigin");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameInterfaceFactory_GetCdmOrigin_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::FrameInterfaceFactory_GetCdmOrigin_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameInterfaceFactory::Name_);
  message.set_method_name("GetCdmOrigin");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameInterfaceFactory_GetCdmOrigin_HandleSyncResponse(
          &result, out_param_cdm_origin));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "media::mojom::FrameInterfaceFactory::GetCdmOrigin", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_cdm_origin) {
        raw_value->SetString("cdm_origin", base::trace_event::ValueToString((*out_param_cdm_origin), "<value of type const ::url::Origin&>"));
      } else {
        raw_value->SetString("cdm_origin", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void FrameInterfaceFactoryProxy::GetCdmOrigin(
    GetCdmOriginCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "media::mojom::FrameInterfaceFactory::GetCdmOrigin");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameInterfaceFactory_GetCdmOrigin_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::FrameInterfaceFactory_GetCdmOrigin_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameInterfaceFactory::Name_);
  message.set_method_name("GetCdmOrigin");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameInterfaceFactory_GetCdmOrigin_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FrameInterfaceFactoryProxy::BindEmbedderReceiver(
    ::mojo::GenericPendingReceiver in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::FrameInterfaceFactory::BindEmbedderReceiver", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("receiver", base::trace_event::ValueToString(in_receiver, "<value of type ::mojo::GenericPendingReceiver>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameInterfaceFactory_BindEmbedderReceiver_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::FrameInterfaceFactory_BindEmbedderReceiver_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->receiver)::BaseType::BufferWriter
      receiver_writer;
  mojo::internal::Serialize<::mojo_base::mojom::GenericPendingReceiverDataView>(
      in_receiver, buffer, &receiver_writer, &serialization_context);
  params->receiver.Set(
      receiver_writer.is_null() ? nullptr : receiver_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->receiver.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null receiver in FrameInterfaceFactory.BindEmbedderReceiver request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameInterfaceFactory::Name_);
  message.set_method_name("BindEmbedderReceiver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class FrameInterfaceFactory_GetCdmOrigin_ProxyToResponder {
 public:
  static FrameInterfaceFactory::GetCdmOriginCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FrameInterfaceFactory_GetCdmOrigin_ProxyToResponder> proxy(
        new FrameInterfaceFactory_GetCdmOrigin_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FrameInterfaceFactory_GetCdmOrigin_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameInterfaceFactory_GetCdmOrigin_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FrameInterfaceFactory_GetCdmOrigin_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameInterfaceFactory::GetCdmOriginCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::url::Origin& in_cdm_origin);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FrameInterfaceFactory_GetCdmOrigin_ProxyToResponder);
};

bool FrameInterfaceFactory_GetCdmOrigin_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "media::mojom::FrameInterfaceFactory::GetCdmOriginCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::FrameInterfaceFactory_GetCdmOrigin_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameInterfaceFactory_GetCdmOrigin_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::url::Origin p_cdm_origin{};
  FrameInterfaceFactory_GetCdmOrigin_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadCdmOrigin(&p_cdm_origin))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameInterfaceFactory::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_cdm_origin));
  return true;
}

void FrameInterfaceFactory_GetCdmOrigin_ProxyToResponder::Run(
    const ::url::Origin& in_cdm_origin) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)media::mojom::FrameInterfaceFactory::GetCdmOriginCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("cdm_origin", base::trace_event::ValueToString(in_cdm_origin, "<value of type const ::url::Origin&>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameInterfaceFactory_GetCdmOrigin_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::FrameInterfaceFactory_GetCdmOrigin_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->cdm_origin)::BaseType::BufferWriter
      cdm_origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_cdm_origin, buffer, &cdm_origin_writer, &serialization_context);
  params->cdm_origin.Set(
      cdm_origin_writer.is_null() ? nullptr : cdm_origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cdm_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cdm_origin in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)media::mojom::FrameInterfaceFactory::GetCdmOriginCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameInterfaceFactory::Name_);
  message.set_method_name("GetCdmOrigin");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool FrameInterfaceFactory_GetCdmOrigin_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::FrameInterfaceFactory_GetCdmOrigin_ResponseParams_Data* params =
      reinterpret_cast<internal::FrameInterfaceFactory_GetCdmOrigin_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::url::Origin p_cdm_origin{};
  FrameInterfaceFactory_GetCdmOrigin_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadCdmOrigin(&p_cdm_origin))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameInterfaceFactory::Name_, 2, true);
    return false;
  }
  *out_cdm_origin_ = std::move(p_cdm_origin);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

// static
bool FrameInterfaceFactoryStubDispatch::Accept(
    FrameInterfaceFactory* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kFrameInterfaceFactory_CreateProvisionFetcher_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::FrameInterfaceFactory::CreateProvisionFetcher",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::FrameInterfaceFactory::CreateProvisionFetcher");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameInterfaceFactory_CreateProvisionFetcher_Params_Data* params =
          reinterpret_cast<internal::FrameInterfaceFactory_CreateProvisionFetcher_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::ProvisionFetcher> p_provision_fetcher{};
      FrameInterfaceFactory_CreateProvisionFetcher_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_provision_fetcher =
            input_data_view.TakeProvisionFetcher<decltype(p_provision_fetcher)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameInterfaceFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateProvisionFetcher(
std::move(p_provision_fetcher));
      return true;
    }
    case internal::kFrameInterfaceFactory_CreateCdmStorage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::FrameInterfaceFactory::CreateCdmStorage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::FrameInterfaceFactory::CreateCdmStorage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameInterfaceFactory_CreateCdmStorage_Params_Data* params =
          reinterpret_cast<internal::FrameInterfaceFactory_CreateCdmStorage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::CdmStorage> p_cdm_storage{};
      FrameInterfaceFactory_CreateCdmStorage_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_cdm_storage =
            input_data_view.TakeCdmStorage<decltype(p_cdm_storage)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameInterfaceFactory::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCdmStorage(
std::move(p_cdm_storage));
      return true;
    }
    case internal::kFrameInterfaceFactory_GetCdmOrigin_Name: {
      break;
    }
    case internal::kFrameInterfaceFactory_BindEmbedderReceiver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::FrameInterfaceFactory::BindEmbedderReceiver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::FrameInterfaceFactory::BindEmbedderReceiver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameInterfaceFactory_BindEmbedderReceiver_Params_Data* params =
          reinterpret_cast<internal::FrameInterfaceFactory_BindEmbedderReceiver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::GenericPendingReceiver p_receiver{};
      FrameInterfaceFactory_BindEmbedderReceiver_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadReceiver(&p_receiver))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameInterfaceFactory::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindEmbedderReceiver(
std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool FrameInterfaceFactoryStubDispatch::AcceptWithResponder(
    FrameInterfaceFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrameInterfaceFactory_CreateProvisionFetcher_Name: {
      break;
    }
    case internal::kFrameInterfaceFactory_CreateCdmStorage_Name: {
      break;
    }
    case internal::kFrameInterfaceFactory_GetCdmOrigin_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::FrameInterfaceFactory::GetCdmOrigin",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::FrameInterfaceFactory::GetCdmOrigin");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FrameInterfaceFactory_GetCdmOrigin_Params_Data* params =
          reinterpret_cast<
              internal::FrameInterfaceFactory_GetCdmOrigin_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      FrameInterfaceFactory_GetCdmOrigin_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameInterfaceFactory::Name_, 2, false);
        return false;
      }
      FrameInterfaceFactory::GetCdmOriginCallback callback =
          FrameInterfaceFactory_GetCdmOrigin_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCdmOrigin(std::move(callback));
      return true;
    }
    case internal::kFrameInterfaceFactory_BindEmbedderReceiver_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kFrameInterfaceFactoryValidationInfo[] = {
    {internal::kFrameInterfaceFactory_CreateProvisionFetcher_Name,
     {&internal::FrameInterfaceFactory_CreateProvisionFetcher_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameInterfaceFactory_CreateCdmStorage_Name,
     {&internal::FrameInterfaceFactory_CreateCdmStorage_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kFrameInterfaceFactory_GetCdmOrigin_Name,
     {&internal::FrameInterfaceFactory_GetCdmOrigin_Params_Data::Validate,
      &internal::FrameInterfaceFactory_GetCdmOrigin_ResponseParams_Data::Validate}},
    {internal::kFrameInterfaceFactory_BindEmbedderReceiver_Name,
     {&internal::FrameInterfaceFactory_BindEmbedderReceiver_Params_Data::Validate,
      nullptr /* no response */}},
};

bool FrameInterfaceFactoryRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::FrameInterfaceFactory::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kFrameInterfaceFactoryValidationInfo);
}

bool FrameInterfaceFactoryResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::FrameInterfaceFactory::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kFrameInterfaceFactoryValidationInfo);

}
}  // namespace mojom
}  // namespace media

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif