// content/common/navigation_params.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/common/navigation_params.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "content/common/navigation_params.mojom-params-data.h"
namespace content {
namespace mojom {

std::ostream& operator<<(std::ostream& os, NavigationType value) {
  switch(value) {
    case NavigationType::RELOAD:
      return os << "NavigationType::RELOAD";
    case NavigationType::RELOAD_BYPASSING_CACHE:
      return os << "NavigationType::RELOAD_BYPASSING_CACHE";
    case NavigationType::RELOAD_ORIGINAL_REQUEST_URL:
      return os << "NavigationType::RELOAD_ORIGINAL_REQUEST_URL";
    case NavigationType::RESTORE:
      return os << "NavigationType::RESTORE";
    case NavigationType::RESTORE_WITH_POST:
      return os << "NavigationType::RESTORE_WITH_POST";
    case NavigationType::HISTORY_SAME_DOCUMENT:
      return os << "NavigationType::HISTORY_SAME_DOCUMENT";
    case NavigationType::HISTORY_DIFFERENT_DOCUMENT:
      return os << "NavigationType::HISTORY_DIFFERENT_DOCUMENT";
    case NavigationType::SAME_DOCUMENT:
      return os << "NavigationType::SAME_DOCUMENT";
    case NavigationType::DIFFERENT_DOCUMENT:
      return os << "NavigationType::DIFFERENT_DOCUMENT";
    default:
      return os << "Unknown NavigationType value: " << static_cast<int32_t>(value);
  }
}

namespace internal {


// static
bool InitiatorCSPInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const InitiatorCSPInfo_Data* object = static_cast<const InitiatorCSPInfo_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::network::mojom::internal::CSPDisposition_Data
        ::Validate(object->should_check_main_world_csp, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initiator_csp, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams initiator_csp_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->initiator_csp, validation_context,
                                         &initiator_csp_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->initiator_self_source, validation_context))
    return false;

  return true;
}

InitiatorCSPInfo_Data::InitiatorCSPInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool BeginNavigationParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const BeginNavigationParams_Data* object = static_cast<const BeginNavigationParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 104 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams headers_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->headers, validation_context,
                                         &headers_validate_params)) {
    return false;
  }


  if (!::blink::mojom::internal::RequestContextType_Data
        ::Validate(object->request_context_type, validation_context))
    return false;


  if (!::network::mojom::internal::RequestDestination_Data
        ::Validate(object->request_destination, validation_context))
    return false;


  if (!::content::mojom::internal::MixedContentContextType_Data
        ::Validate(object->mixed_content_context_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->searchable_form_url, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->searchable_form_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->searchable_form_encoding, 11, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams searchable_form_encoding_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->searchable_form_encoding, validation_context,
                                         &searchable_form_encoding_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_side_redirect_url, 12, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->client_side_redirect_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->devtools_initiator, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->trust_token_params, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->impression, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->before_unload_start, 17, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->before_unload_start, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->before_unload_end, 18, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->before_unload_end, validation_context))
    return false;

  return true;
}

BeginNavigationParams_Data::BeginNavigationParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommonNavigationParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CommonNavigationParams_Data* object = static_cast<const CommonNavigationParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 136 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->initiator_origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->referrer, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->referrer, validation_context))
    return false;


  if (!::content::mojom::internal::PageTransition_Data
        ::Validate(object->transition, validation_context))
    return false;


  if (!::content::mojom::internal::NavigationType_Data
        ::Validate(object->navigation_type, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->download_policy, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->download_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->base_url_for_data_url, 8, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->base_url_for_data_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->history_url_for_data_url, 9, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->history_url_for_data_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->navigation_start, 11, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->navigation_start, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method, 12, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams method_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->method, validation_context,
                                         &method_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->post_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_location, 14, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_location, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initiator_csp_info, 18, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->initiator_csp_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initiator_origin_trial_features, 19, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams initiator_origin_trial_features_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->initiator_origin_trial_features, validation_context,
                                         &initiator_origin_trial_features_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->href_translate, 20, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams href_translate_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->href_translate, validation_context,
                                         &href_translate_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_start, 22, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_start, validation_context))
    return false;

  return true;
}

CommonNavigationParams_Data::CommonNavigationParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NavigationTiming_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const NavigationTiming_Data* object = static_cast<const NavigationTiming_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->redirect_start, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->redirect_start, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->redirect_end, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->redirect_end, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->fetch_start, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->fetch_start, validation_context))
    return false;

  return true;
}

NavigationTiming_Data::NavigationTiming_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OldPageInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const OldPageInfo_Data* object = static_cast<const OldPageInfo_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->new_lifecycle_state_for_old_page, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->new_lifecycle_state_for_old_page, validation_context))
    return false;

  return true;
}

OldPageInfo_Data::OldPageInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool CommitNavigationParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const CommitNavigationParams_Data* object = static_cast<const CommitNavigationParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 208 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->origin_to_commit, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->redirects, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams redirects_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->redirects, validation_context,
                                         &redirects_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->redirect_response, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams redirect_response_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->redirect_response, validation_context,
                                         &redirect_response_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->redirect_infos, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams redirect_infos_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->redirect_infos, validation_context,
                                         &redirect_infos_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->post_content_type, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams post_content_type_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->post_content_type, validation_context,
                                         &post_content_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->original_url, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->original_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->original_method, 8, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams original_method_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->original_method, validation_context,
                                         &original_method_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->page_state, 10, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->page_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->subframe_unique_names, 12, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams subframe_unique_names_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)), new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->subframe_unique_names, validation_context,
                                         &subframe_unique_names_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->navigation_timing, 20, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->navigation_timing, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->appcache_host_id, validation_context))
    return false;


  if (!::content::mojom::internal::WasActivatedOption_Data
        ::Validate(object->was_activated, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->navigation_token, 23, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->navigation_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->prefetched_signed_exchanges, 24, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams prefetched_signed_exchanges_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->prefetched_signed_exchanges, validation_context,
                                         &prefetched_signed_exchanges_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::IPAddressSpace_Data
        ::Validate(object->ip_address_space, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->web_bundle_physical_url, 27, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->web_bundle_physical_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->web_bundle_claimed_url, 28, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->web_bundle_claimed_url, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->frame_policy, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->force_enabled_origin_trials, 31, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams force_enabled_origin_trials_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->force_enabled_origin_trials, validation_context,
                                         &force_enabled_origin_trials_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->enabled_client_hints, 33, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams enabled_client_hints_validate_params(
      0, ::network::mojom::internal::WebClientHintsType_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->enabled_client_hints, validation_context,
                                         &enabled_client_hints_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->forced_content_security_policies, 35, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams forced_content_security_policies_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->forced_content_security_policies, validation_context,
                                         &forced_content_security_policies_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->old_page_info, validation_context))
    return false;

  return true;
}

CommitNavigationParams_Data::CommitNavigationParams_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace content