#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkAbstractGridConnectivity_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkAttributeSmoothingFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkCompositeDataGeometryFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDataSetRegionSurfaceFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkDataSetSurfaceFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkExplicitStructuredGridSurfaceFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkGeometryFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkHierarchicalDataSetGeometryFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageDataGeometryFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageDataToUniformGrid_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkLinearToQuadraticCellsFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMarkBoundaryFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkProjectSphereFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkRecoverGeometryWireframe_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkRectilinearGridGeometryFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkRectilinearGridPartitioner_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStructuredAMRGridConnectivity_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStructuredAMRNeighbor_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStructuredGridConnectivity_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStructuredGridGeometryFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStructuredGridPartitioner_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStructuredNeighbor_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkStructuredPointsGeometryFilter_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkUnstructuredGridGeometryFilter_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkFiltersGeometryCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkAbstractGridConnectivity_Init(csi);
  vtkAttributeSmoothingFilter_Init(csi);
  vtkCompositeDataGeometryFilter_Init(csi);
  vtkDataSetRegionSurfaceFilter_Init(csi);
  vtkDataSetSurfaceFilter_Init(csi);
  vtkExplicitStructuredGridSurfaceFilter_Init(csi);
  vtkGeometryFilter_Init(csi);
  vtkHierarchicalDataSetGeometryFilter_Init(csi);
  vtkImageDataGeometryFilter_Init(csi);
  vtkImageDataToUniformGrid_Init(csi);
  vtkLinearToQuadraticCellsFilter_Init(csi);
  vtkMarkBoundaryFilter_Init(csi);
  vtkProjectSphereFilter_Init(csi);
  vtkRecoverGeometryWireframe_Init(csi);
  vtkRectilinearGridGeometryFilter_Init(csi);
  vtkRectilinearGridPartitioner_Init(csi);
  vtkStructuredAMRGridConnectivity_Init(csi);
  vtkStructuredAMRNeighbor_Init(csi);
  vtkStructuredGridConnectivity_Init(csi);
  vtkStructuredGridGeometryFilter_Init(csi);
  vtkStructuredGridPartitioner_Init(csi);
  vtkStructuredNeighbor_Init(csi);
  vtkStructuredPointsGeometryFilter_Init(csi);
  vtkUnstructuredGridGeometryFilter_Init(csi);
}
