
#include "env-inl.h"
#include "node_builtins.h"
#include "node_external_reference.h"
#include "node_internals.h"

namespace node {

namespace builtins {

static const uint8_t *internal_deps_acorn_acorn_walk_dist_walk_raw = reinterpret_cast<const uint8_t*>(R"JS2C1b732aee((function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory((global.acorn = global.acorn || {}, global.acorn.walk = {})));
})(this, (function (exports) { 'use strict';

  // AST walker module for ESTree compatible trees

  // A simple walk is one where you simply specify callbacks to be
  // called on specific nodes. The last two arguments are optional. A
  // simple use would be
  //
  //     walk.simple(myTree, {
  //         Expression: function(node) { ... }
  //     });
  //
  // to do something with all expressions. All ESTree node types
  // can be used to identify node types, as well as Expression and
  // Statement, which denote categories of nodes.
  //
  // The base argument can be used to pass a custom (recursive)
  // walker, and state can be used to give this walked an initial
  // state.

  function simple(node, visitors, baseVisitor, state, override) {
    if (!baseVisitor) { baseVisitor = base
    ; }(function c(node, st, override) {
      var type = override || node.type;
      baseVisitor[type](node, st, c);
      if (visitors[type]) { visitors[type](node, st); }
    })(node, state, override);
  }

  // An ancestor walk keeps an array of ancestor nodes (including the
  // current node) and passes them to the callback as third parameter
  // (and also as state parameter when no other state is present).
  function ancestor(node, visitors, baseVisitor, state, override) {
    var ancestors = [];
    if (!baseVisitor) { baseVisitor = base
    ; }(function c(node, st, override) {
      var type = override || node.type;
      var isNew = node !== ancestors[ancestors.length - 1];
      if (isNew) { ancestors.push(node); }
      baseVisitor[type](node, st, c);
      if (visitors[type]) { visitors[type](node, st || ancestors, ancestors); }
      if (isNew) { ancestors.pop(); }
    })(node, state, override);
  }

  // A recursive walk is one where your functions override the default
  // walkers. They can modify and replace the state parameter that's
  // threaded through the walk, and can opt how and whether to walk
  // their child nodes (by calling their third argument on these
  // nodes).
  function recursive(node, state, funcs, baseVisitor, override) {
    var visitor = funcs ? make(funcs, baseVisitor || undefined) : baseVisitor
    ;(function c(node, st, override) {
      visitor[override || node.type](node, st, c);
    })(node, state, override);
  }

  function makeTest(test) {
    if (typeof test === "string")
      { return function (type) { return type === test; } }
    else if (!test)
      { return function () { return true; } }
    else
      { return test }
  }

  var Found = function Found(node, state) { this.node = node; this.state = state; };

  // A full walk triggers the callback on each node
  function full(node, callback, baseVisitor, state, override) {
    if (!baseVisitor) { baseVisitor = base; }
    var last
    ;(function c(node, st, override) {
      var type = override || node.type;
      baseVisitor[type](node, st, c);
      if (last !== node) {
        callback(node, st, type);
        last = node;
      }
    })(node, state, override);
  }

  // An fullAncestor walk is like an ancestor walk, but triggers
  // the callback on each node
  function fullAncestor(node, callback, baseVisitor, state) {
    if (!baseVisitor) { baseVisitor = base; }
    var ancestors = [], last
    ;(function c(node, st, override) {
      var type = override || node.type;
      var isNew = node !== ancestors[ancestors.length - 1];
      if (isNew) { ancestors.push(node); }
      baseVisitor[type](node, st, c);
      if (last !== node) {
        callback(node, st || ancestors, ancestors, type);
        last = node;
      }
      if (isNew) { ancestors.pop(); }
    })(node, state);
  }

  // Find a node with a given start, end, and type (all are optional,
  // null can be used as wildcard). Returns a {node, state} object, or
  // undefined when it doesn't find a matching node.
  function findNodeAt(node, start, end, test, baseVisitor, state) {
    if (!baseVisitor) { baseVisitor = base; }
    test = makeTest(test);
    try {
      (function c(node, st, override) {
        var type = override || node.type;
        if ((start == null || node.start <= start) &&
            (end == null || node.end >= end))
          { baseVisitor[type](node, st, c); }
        if ((start == null || node.start === start) &&
            (end == null || node.end === end) &&
            test(type, node))
          { throw new Found(node, st) }
      })(node, state);
    } catch (e) {
      if (e instanceof Found) { return e }
      throw e
    }
  }

  // Find the innermost node of a given type that contains the given
  // position. Interface similar to findNodeAt.
  function findNodeAround(node, pos, test, baseVisitor, state) {
    test = makeTest(test);
    if (!baseVisitor) { baseVisitor = base; }
    try {
      (function c(node, st, override) {
        var type = override || node.type;
        if (node.start > pos || node.end < pos) { return }
        baseVisitor[type](node, st, c);
        if (test(type, node)) { throw new Found(node, st) }
      })(node, state);
    } catch (e) {
      if (e instanceof Found) { return e }
      throw e
    }
  }

  // Find the outermost matching node after a given position.
  function findNodeAfter(node, pos, test, baseVisitor, state) {
    test = makeTest(test);
    if (!baseVisitor) { baseVisitor = base; }
    try {
      (function c(node, st, override) {
        if (node.end < pos) { return }
        var type = override || node.type;
        if (node.start >= pos && test(type, node)) { throw new Found(node, st) }
        baseVisitor[type](node, st, c);
      })(node, state);
    } catch (e) {
      if (e instanceof Found) { return e }
      throw e
    }
  }

  // Find the outermost matching node before a given position.
  function findNodeBefore(node, pos, test, baseVisitor, state) {
    test = makeTest(test);
    if (!baseVisitor) { baseVisitor = base; }
    var max
    ;(function c(node, st, override) {
      if (node.start > pos) { return }
      var type = override || node.type;
      if (node.end <= pos && (!max || max.node.end < node.end) && test(type, node))
        { max = new Found(node, st); }
      baseVisitor[type](node, st, c);
    })(node, state);
    return max
  }

  // Used to create a custom walker. Will fill in all missing node
  // type properties with the defaults.
  function make(funcs, baseVisitor) {
    var visitor = Object.create(baseVisitor || base);
    for (var type in funcs) { visitor[type] = funcs[type]; }
    return visitor
  }

  function skipThrough(node, st, c) { c(node, st); }
  function ignore(_node, _st, _c) {}

  // Node walkers.

  var base = {};

  base.Program = base.BlockStatement = base.StaticBlock = function (node, st, c) {
    for (var i = 0, list = node.body; i < list.length; i += 1)
      {
      var stmt = list[i];

      c(stmt, st, "Statement");
    }
  };
  base.Statement = skipThrough;
  base.EmptyStatement = ignore;
  base.ExpressionStatement = base.ParenthesizedExpression = base.ChainExpression =
    function (node, st, c) { return c(node.expression, st, "Expression"); };
  base.IfStatement = function (node, st, c) {
    c(node.test, st, "Expression");
    c(node.consequent, st, "Statement");
    if (node.alternate) { c(node.alternate, st, "Statement"); }
  };
  base.LabeledStatement = function (node, st, c) { return c(node.body, st, "Statement"); };
  base.BreakStatement = base.ContinueStatement = ignore;
  base.WithStatement = function (node, st, c) {
    c(node.object, st, "Expression");
    c(node.body, st, "Statement");
  };
  base.SwitchStatement = function (node, st, c) {
    c(node.discriminant, st, "Expression");
    for (var i = 0, list = node.cases; i < list.length; i += 1) {
      var cs = list[i];

      c(cs, st);
    }
  };
  base.SwitchCase = function (node, st, c) {
    if (node.test) { c(node.test, st, "Expression"); }
    for (var i = 0, list = node.consequent; i < list.length; i += 1)
      {
      var cons = list[i];

      c(cons, st, "Statement");
    }
  };
  base.ReturnStatement = base.YieldExpression = base.AwaitExpression = function (node, st, c) {
    if (node.argument) { c(node.argument, st, "Expression"); }
  };
  base.ThrowStatement = base.SpreadElement =
    function (node, st, c) { return c(node.argument, st, "Expression"); };
  base.TryStatement = function (node, st, c) {
    c(node.block, st, "Statement");
    if (node.handler) { c(node.handler, st); }
    if (node.finalizer) { c(node.finalizer, st, "Statement"); }
  };
  base.CatchClause = function (node, st, c) {
    if (node.param) { c(node.param, st, "Pattern"); }
    c(node.body, st, "Statement");
  };
  base.WhileStatement = base.DoWhileStatement = function (node, st, c) {
    c(node.test, st, "Expression");
    c(node.body, st, "Statement");
  };
  base.ForStatement = function (node, st, c) {
    if (node.init) { c(node.init, st, "ForInit"); }
    if (node.test) { c(node.test, st, "Expression"); }
    if (node.update) { c(node.update, st, "Expression"); }
    c(node.body, st, "Statement");
  };
  base.ForInStatement = base.ForOfStatement = function (node, st, c) {
    c(node.left, st, "ForInit");
    c(node.right, st, "Expression");
    c(node.body, st, "Statement");
  };
  base.ForInit = function (node, st, c) {
    if (node.type === "VariableDeclaration") { c(node, st); }
    else { c(node, st, "Expression"); }
  };
  base.DebuggerStatement = ignore;

  base.FunctionDeclaration = function (node, st, c) { return c(node, st, "Function"); };
  base.VariableDeclaration = function (node, st, c) {
    for (var i = 0, list = node.declarations; i < list.length; i += 1)
      {
      var decl = list[i];

      c(decl, st);
    }
  };
  base.VariableDeclarator = function (node, st, c) {
    c(node.id, st, "Pattern");
    if (node.init) { c(node.init, st, "Expression"); }
  };

  base.Function = function (node, st, c) {
    if (node.id) { c(node.id, st, "Pattern"); }
    for (var i = 0, list = node.params; i < list.length; i += 1)
      {
      var param = list[i];

      c(param, st, "Pattern");
    }
    c(node.body, st, node.expression ? "Expression" : "Statement");
  };

  base.Pattern = function (node, st, c) {
    if (node.type === "Identifier")
      { c(node, st, "VariablePattern"); }
    else if (node.type === "MemberExpression")
      { c(node, st, "MemberPattern"); }
    else
      { c(node, st); }
  };
  base.VariablePattern = ignore;
  base.MemberPattern = skipThrough;
  base.RestElement = function (node, st, c) { return c(node.argument, st, "Pattern"); };
  base.ArrayPattern = function (node, st, c) {
    for (var i = 0, list = node.elements; i < list.length; i += 1) {
      var elt = list[i];

      if (elt) { c(elt, st, "Pattern"); }
    }
  };
  base.ObjectPattern = function (node, st, c) {
    for (var i = 0, list = node.properties; i < list.length; i += 1) {
      var prop = list[i];

      if (prop.type === "Property") {
        if (prop.computed) { c(prop.key, st, "Expression"); }
        c(prop.value, st, "Pattern");
      } else if (prop.type === "RestElement") {
        c(prop.argument, st, "Pattern");
      }
    }
  };

  base.Expression = skipThrough;
  base.ThisExpression = base.Super = base.MetaProperty = ignore;
  base.ArrayExpression = function (node, st, c) {
    for (var i = 0, list = node.elements; i < list.length; i += 1) {
      var elt = list[i];

      if (elt) { c(elt, st, "Expression"); }
    }
  };
  base.ObjectExpression = function (node, st, c) {
    for (var i = 0, list = node.properties; i < list.length; i += 1)
      {
      var prop = list[i];

      c(prop, st);
    }
  };
  base.FunctionExpression = base.ArrowFunctionExpression = base.FunctionDeclaration;
  base.SequenceExpression = function (node, st, c) {
    for (var i = 0, list = node.expressions; i < list.length; i += 1)
      {
      var expr = list[i];

      c(expr, st, "Expression");
    }
  };
  base.TemplateLiteral = function (node, st, c) {
    for (var i = 0, list = node.quasis; i < list.length; i += 1)
      {
      var quasi = list[i];

      c(quasi, st);
    }

    for (var i$1 = 0, list$1 = node.expressions; i$1 < list$1.length; i$1 += 1)
      {
      var expr = list$1[i$1];

      c(expr, st, "Expression");
    }
  };
  base.TemplateElement = ignore;
  base.UnaryExpression = base.UpdateExpression = function (node, st, c) {
    c(node.argument, st, "Expression");
  };
  base.BinaryExpression = base.LogicalExpression = function (node, st, c) {
    c(node.left, st, "Expression");
    c(node.right, st, "Expression");
  };
  base.AssignmentExpression = base.AssignmentPattern = function (node, st, c) {
    c(node.left, st, "Pattern");
    c(node.right, st, "Expression");
  };
  base.ConditionalExpression = function (node, st, c) {
    c(node.test, st, "Expression");
    c(node.consequent, st, "Expression");
    c(node.alternate, st, "Expression");
  };
  base.NewExpression = base.CallExpression = function (node, st, c) {
    c(node.callee, st, "Expression");
    if (node.arguments)
      { for (var i = 0, list = node.arguments; i < list.length; i += 1)
        {
          var arg = list[i];

          c(arg, st, "Expression");
        } }
  };
  base.MemberExpression = function (node, st, c) {
    c(node.object, st, "Expression");
    if (node.computed) { c(node.property, st, "Expression"); }
  };
  base.ExportNamedDeclaration = base.ExportDefaultDeclaration = function (node, st, c) {
    if (node.declaration)
      { c(node.declaration, st, node.type === "ExportNamedDeclaration" || node.declaration.id ? "Statement" : "Expression"); }
    if (node.source) { c(node.source, st, "Expression"); }
  };
  base.ExportAllDeclaration = function (node, st, c) {
    if (node.exported)
      { c(node.exported, st); }
    c(node.source, st, "Expression");
  };
  base.ImportDeclaration = function (node, st, c) {
    for (var i = 0, list = node.specifiers; i < list.length; i += 1)
      {
      var spec = list[i];

      c(spec, st);
    }
    c(node.source, st, "Expression");
  };
  base.ImportExpression = function (node, st, c) {
    c(node.source, st, "Expression");
  };
  base.ImportSpecifier = base.ImportDefaultSpecifier = base.ImportNamespaceSpecifier = base.Identifier = base.PrivateIdentifier = base.Literal = ignore;

  base.TaggedTemplateExpression = function (node, st, c) {
    c(node.tag, st, "Expression");
    c(node.quasi, st, "Expression");
  };
  base.ClassDeclaration = base.ClassExpression = function (node, st, c) { return c(node, st, "Class"); };
  base.Class = function (node, st, c) {
    if (node.id) { c(node.id, st, "Pattern"); }
    if (node.superClass) { c(node.superClass, st, "Expression"); }
    c(node.body, st);
  };
  base.ClassBody = function (node, st, c) {
    for (var i = 0, list = node.body; i < list.length; i += 1)
      {
      var elt = list[i];

      c(elt, st);
    }
  };
  base.MethodDefinition = base.PropertyDefinition = base.Property = function (node, st, c) {
    if (node.computed) { c(node.key, st, "Expression"); }
    if (node.value) { c(node.value, st, "Expression"); }
  };

  exports.ancestor = ancestor;
  exports.base = base;
  exports.findNodeAfter = findNodeAfter;
  exports.findNodeAround = findNodeAround;
  exports.findNodeAt = findNodeAt;
  exports.findNodeBefore = findNodeBefore;
  exports.full = full;
  exports.fullAncestor = fullAncestor;
  exports.make = make;
  exports.recursive = recursive;
  exports.simple = simple;

}));
)JS2C1b732aee");static StaticExternalOneByteResource internal_deps_acorn_acorn_walk_dist_walk_resource(internal_deps_acorn_acorn_walk_dist_walk_raw, 15757, nullptr);

static const uint16_t *internal_deps_acorn_acorn_dist_acorn_raw = reinterpret_cast<const uint16_t*>(uR"JS2C1b732aee((function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.acorn = {}));
})(this, (function (exports) { 'use strict';

  // This file was generated. Do not modify manually!
  var astralIdentifierCodes = [509, 0, 227, 0, 150, 4, 294, 9, 1368, 2, 2, 1, 6, 3, 41, 2, 5, 0, 166, 1, 574, 3, 9, 9, 7, 9, 32, 4, 318, 1, 80, 3, 71, 10, 50, 3, 123, 2, 54, 14, 32, 10, 3, 1, 11, 3, 46, 10, 8, 0, 46, 9, 7, 2, 37, 13, 2, 9, 6, 1, 45, 0, 13, 2, 49, 13, 9, 3, 2, 11, 83, 11, 7, 0, 3, 0, 158, 11, 6, 9, 7, 3, 56, 1, 2, 6, 3, 1, 3, 2, 10, 0, 11, 1, 3, 6, 4, 4, 68, 8, 2, 0, 3, 0, 2, 3, 2, 4, 2, 0, 15, 1, 83, 17, 10, 9, 5, 0, 82, 19, 13, 9, 214, 6, 3, 8, 28, 1, 83, 16, 16, 9, 82, 12, 9, 9, 7, 19, 58, 14, 5, 9, 243, 14, 166, 9, 71, 5, 2, 1, 3, 3, 2, 0, 2, 1, 13, 9, 120, 6, 3, 6, 4, 0, 29, 9, 41, 6, 2, 3, 9, 0, 10, 10, 47, 15, 343, 9, 54, 7, 2, 7, 17, 9, 57, 21, 2, 13, 123, 5, 4, 0, 2, 1, 2, 6, 2, 0, 9, 9, 49, 4, 2, 1, 2, 4, 9, 9, 330, 3, 10, 1, 2, 0, 49, 6, 4, 4, 14, 10, 5350, 0, 7, 14, 11465, 27, 2343, 9, 87, 9, 39, 4, 60, 6, 26, 9, 535, 9, 470, 0, 2, 54, 8, 3, 82, 0, 12, 1, 19628, 1, 4178, 9, 519, 45, 3, 22, 543, 4, 4, 5, 9, 7, 3, 6, 31, 3, 149, 2, 1418, 49, 513, 54, 5, 49, 9, 0, 15, 0, 23, 4, 2, 14, 1361, 6, 2, 16, 3, 6, 2, 1, 2, 4, 101, 0, 161, 6, 10, 9, 357, 0, 62, 13, 499, 13, 245, 1, 2, 9, 726, 6, 110, 6, 6, 9, 4759, 9, 787719, 239];

  // This file was generated. Do not modify manually!
  var astralIdentifierStartCodes = [0, 11, 2, 25, 2, 18, 2, 1, 2, 14, 3, 13, 35, 122, 70, 52, 268, 28, 4, 48, 48, 31, 14, 29, 6, 37, 11, 29, 3, 35, 5, 7, 2, 4, 43, 157, 19, 35, 5, 35, 5, 39, 9, 51, 13, 10, 2, 14, 2, 6, 2, 1, 2, 10, 2, 14, 2, 6, 2, 1, 4, 51, 13, 310, 10, 21, 11, 7, 25, 5, 2, 41, 2, 8, 70, 5, 3, 0, 2, 43, 2, 1, 4, 0, 3, 22, 11, 22, 10, 30, 66, 18, 2, 1, 11, 21, 11, 25, 71, 55, 7, 1, 65, 0, 16, 3, 2, 2, 2, 28, 43, 28, 4, 28, 36, 7, 2, 27, 28, 53, 11, 21, 11, 18, 14, 17, 111, 72, 56, 50, 14, 50, 14, 35, 39, 27, 10, 22, 251, 41, 7, 1, 17, 2, 60, 28, 11, 0, 9, 21, 43, 17, 47, 20, 28, 22, 13, 52, 58, 1, 3, 0, 14, 44, 33, 24, 27, 35, 30, 0, 3, 0, 9, 34, 4, 0, 13, 47, 15, 3, 22, 0, 2, 0, 36, 17, 2, 24, 20, 1, 64, 6, 2, 0, 2, 3, 2, 14, 2, 9, 8, 46, 39, 7, 3, 1, 3, 21, 2, 6, 2, 1, 2, 4, 4, 0, 19, 0, 13, 4, 31, 9, 2, 0, 3, 0, 2, 37, 2, 0, 26, 0, 2, 0, 45, 52, 19, 3, 21, 2, 31, 47, 21, 1, 2, 0, 185, 46, 42, 3, 37, 47, 21, 0, 60, 42, 14, 0, 72, 26, 38, 6, 186, 43, 117, 63, 32, 7, 3, 0, 3, 7, 2, 1, 2, 23, 16, 0, 2, 0, 95, 7, 3, 38, 17, 0, 2, 0, 29, 0, 11, 39, 8, 0, 22, 0, 12, 45, 20, 0, 19, 72, 200, 32, 32, 8, 2, 36, 18, 0, 50, 29, 113, 6, 2, 1, 2, 37, 22, 0, 26, 5, 2, 1, 2, 31, 15, 0, 328, 18, 16, 0, 2, 12, 2, 33, 125, 0, 80, 921, 103, 110, 18, 195, 2637, 96, 16, 1071, 18, 5, 26, 3994, 6, 582, 6842, 29, 1763, 568, 8, 30, 18, 78, 18, 29, 19, 47, 17, 3, 32, 20, 6, 18, 433, 44, 212, 63, 129, 74, 6, 0, 67, 12, 65, 1, 2, 0, 29, 6135, 9, 1237, 42, 9, 8936, 3, 2, 6, 2, 1, 2, 290, 16, 0, 30, 2, 3, 0, 15, 3, 9, 395, 2309, 106, 6, 12, 4, 8, 8, 9, 5991, 84, 2, 70, 2, 1, 3, 0, 3, 1, 3, 3, 2, 11, 2, 0, 2, 6, 2, 64, 2, 3, 3, 7, 2, 6, 2, 27, 2, 3, 2, 4, 2, 0, 4, 6, 2, 339, 3, 24, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 7, 1845, 30, 7, 5, 262, 61, 147, 44, 11, 6, 17, 0, 322, 29, 19, 43, 485, 27, 229, 29, 3, 0, 496, 6, 2, 3, 2, 1, 2, 14, 2, 196, 60, 67, 8, 0, 1205, 3, 2, 26, 2, 1, 2, 0, 3, 0, 2, 9, 2, 3, 2, 0, 2, 0, 7, 0, 5, 0, 2, 0, 2, 0, 2, 2, 2, 1, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 1, 2, 0, 3, 3, 2, 6, 2, 3, 2, 3, 2, 0, 2, 9, 2, 16, 6, 2, 2, 4, 2, 16, 4421, 42719, 33, 4153, 7, 221, 3, 5761, 15, 7472, 16, 621, 2467, 541, 1507, 4938, 6, 4191];

  // This file was generated. Do not modify manually!
  var nonASCIIidentifierChars = "\u200c\u200d\xb7\u0300-\u036f\u0387\u0483-\u0487\u0591-\u05bd\u05bf\u05c1\u05c2\u05c4\u05c5\u05c7\u0610-\u061a\u064b-\u0669\u0670\u06d6-\u06dc\u06df-\u06e4\u06e7\u06e8\u06ea-\u06ed\u06f0-\u06f9\u0711\u0730-\u074a\u07a6-\u07b0\u07c0-\u07c9\u07eb-\u07f3\u07fd\u0816-\u0819\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0859-\u085b\u0897-\u089f\u08ca-\u08e1\u08e3-\u0903\u093a-\u093c\u093e-\u094f\u0951-\u0957\u0962\u0963\u0966-\u096f\u0981-\u0983\u09bc\u09be-\u09c4\u09c7\u09c8\u09cb-\u09cd\u09d7\u09e2\u09e3\u09e6-\u09ef\u09fe\u0a01-\u0a03\u0a3c\u0a3e-\u0a42\u0a47\u0a48\u0a4b-\u0a4d\u0a51\u0a66-\u0a71\u0a75\u0a81-\u0a83\u0abc\u0abe-\u0ac5\u0ac7-\u0ac9\u0acb-\u0acd\u0ae2\u0ae3\u0ae6-\u0aef\u0afa-\u0aff\u0b01-\u0b03\u0b3c\u0b3e-\u0b44\u0b47\u0b48\u0b4b-\u0b4d\u0b55-\u0b57\u0b62\u0b63\u0b66-\u0b6f\u0b82\u0bbe-\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcd\u0bd7\u0be6-\u0bef\u0c00-\u0c04\u0c3c\u0c3e-\u0c44\u0c46-\u0c48\u0c4a-\u0c4d\u0c55\u0c56\u0c62\u0c63\u0c66-\u0c6f\u0c81-\u0c83\u0cbc\u0cbe-\u0cc4\u0cc6-\u0cc8\u0cca-\u0ccd\u0cd5\u0cd6\u0ce2\u0ce3\u0ce6-\u0cef\u0cf3\u0d00-\u0d03\u0d3b\u0d3c\u0d3e-\u0d44\u0d46-\u0d48\u0d4a-\u0d4d\u0d57\u0d62\u0d63\u0d66-\u0d6f\u0d81-\u0d83\u0dca\u0dcf-\u0dd4\u0dd6\u0dd8-\u0ddf\u0de6-\u0def\u0df2\u0df3\u0e31\u0e34-\u0e3a\u0e47-\u0e4e\u0e50-\u0e59\u0eb1\u0eb4-\u0ebc\u0ec8-\u0ece\u0ed0-\u0ed9\u0f18\u0f19\u0f20-\u0f29\u0f35\u0f37\u0f39\u0f3e\u0f3f\u0f71-\u0f84\u0f86\u0f87\u0f8d-\u0f97\u0f99-\u0fbc\u0fc6\u102b-\u103e\u1040-\u1049\u1056-\u1059\u105e-\u1060\u1062-\u1064\u1067-\u106d\u1071-\u1074\u1082-\u108d\u108f-\u109d\u135d-\u135f\u1369-\u1371\u1712-\u1715\u1732-\u1734\u1752\u1753\u1772\u1773\u17b4-\u17d3\u17dd\u17e0-\u17e9\u180b-\u180d\u180f-\u1819\u18a9\u1920-\u192b\u1930-\u193b\u1946-\u194f\u19d0-\u19da\u1a17-\u1a1b\u1a55-\u1a5e\u1a60-\u1a7c\u1a7f-\u1a89\u1a90-\u1a99\u1ab0-\u1abd\u1abf-\u1ace\u1b00-\u1b04\u1b34-\u1b44\u1b50-\u1b59\u1b6b-\u1b73\u1b80-\u1b82\u1ba1-\u1bad\u1bb0-\u1bb9\u1be6-\u1bf3\u1c24-\u1c37\u1c40-\u1c49\u1c50-\u1c59\u1cd0-\u1cd2\u1cd4-\u1ce8\u1ced\u1cf4\u1cf7-\u1cf9\u1dc0-\u1dff\u200c\u200d\u203f\u2040\u2054\u20d0-\u20dc\u20e1\u20e5-\u20f0\u2cef-\u2cf1\u2d7f\u2de0-\u2dff\u302a-\u302f\u3099\u309a\u30fb\ua620-\ua629\ua66f\ua674-\ua67d\ua69e\ua69f\ua6f0\ua6f1\ua802\ua806\ua80b\ua823-\ua827\ua82c\ua880\ua881\ua8b4-\ua8c5\ua8d0-\ua8d9\ua8e0-\ua8f1\ua8ff-\ua909\ua926-\ua92d\ua947-\ua953\ua980-\ua983\ua9b3-\ua9c0\ua9d0-\ua9d9\ua9e5\ua9f0-\ua9f9\uaa29-\uaa36\uaa43\uaa4c\uaa4d\uaa50-\uaa59\uaa7b-\uaa7d\uaab0\uaab2-\uaab4\uaab7\uaab8\uaabe\uaabf\uaac1\uaaeb-\uaaef\uaaf5\uaaf6\uabe3-\uabea\uabec\uabed\uabf0-\uabf9\ufb1e\ufe00-\ufe0f\ufe20-\ufe2f\ufe33\ufe34\ufe4d-\ufe4f\uff10-\uff19\uff3f\uff65";

  // This file was generated. Do not modify manually!
  var nonASCIIidentifierStartChars = "\xaa\xb5\xba\xc0-\xd6\xd8-\xf6\xf8-\u02c1\u02c6-\u02d1\u02e0-\u02e4\u02ec\u02ee\u0370-\u0374\u0376\u0377\u037a-\u037d\u037f\u0386\u0388-\u038a\u038c\u038e-\u03a1\u03a3-\u03f5\u03f7-\u0481\u048a-\u052f\u0531-\u0556\u0559\u0560-\u0588\u05d0-\u05ea\u05ef-\u05f2\u0620-\u064a\u066e\u066f\u0671-\u06d3\u06d5\u06e5\u06e6\u06ee\u06ef\u06fa-\u06fc\u06ff\u0710\u0712-\u072f\u074d-\u07a5\u07b1\u07ca-\u07ea\u07f4\u07f5\u07fa\u0800-\u0815\u081a\u0824\u0828\u0840-\u0858\u0860-\u086a\u0870-\u0887\u0889-\u088e\u08a0-\u08c9\u0904-\u0939\u093d\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098c\u098f\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09bd\u09ce\u09dc\u09dd\u09df-\u09e1\u09f0\u09f1\u09fc\u0a05-\u0a0a\u0a0f\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32\u0a33\u0a35\u0a36\u0a38\u0a39\u0a59-\u0a5c\u0a5e\u0a72-\u0a74\u0a85-\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2\u0ab3\u0ab5-\u0ab9\u0abd\u0ad0\u0ae0\u0ae1\u0af9\u0b05-\u0b0c\u0b0f\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32\u0b33\u0b35-\u0b39\u0b3d\u0b5c\u0b5d\u0b5f-\u0b61\u0b71\u0b83\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99\u0b9a\u0b9c\u0b9e\u0b9f\u0ba3\u0ba4\u0ba8-\u0baa\u0bae-\u0bb9\u0bd0\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c39\u0c3d\u0c58-\u0c5a\u0c5d\u0c60\u0c61\u0c80\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cbd\u0cdd\u0cde\u0ce0\u0ce1\u0cf1\u0cf2\u0d04-\u0d0c\u0d0e-\u0d10\u0d12-\u0d3a\u0d3d\u0d4e\u0d54-\u0d56\u0d5f-\u0d61\u0d7a-\u0d7f\u0d85-\u0d96\u0d9a-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0e01-\u0e30\u0e32\u0e33\u0e40-\u0e46\u0e81\u0e82\u0e84\u0e86-\u0e8a\u0e8c-\u0ea3\u0ea5\u0ea7-\u0eb0\u0eb2\u0eb3\u0ebd\u0ec0-\u0ec4\u0ec6\u0edc-\u0edf\u0f00\u0f40-\u0f47\u0f49-\u0f6c\u0f88-\u0f8c\u1000-\u102a\u103f\u1050-\u1055\u105a-\u105d\u1061\u1065\u1066\u106e-\u1070\u1075-\u1081\u108e\u10a0-\u10c5\u10c7\u10cd\u10d0-\u10fa\u10fc-\u1248\u124a-\u124d\u1250-\u1256\u1258\u125a-\u125d\u1260-\u1288\u128a-\u128d\u1290-\u12b0\u12b2-\u12b5\u12b8-\u12be\u12c0\u12c2-\u12c5\u12c8-\u12d6\u12d8-\u1310\u1312-\u1315\u1318-\u135a\u1380-\u138f\u13a0-\u13f5\u13f8-\u13fd\u1401-\u166c\u166f-\u167f\u1681-\u169a\u16a0-\u16ea\u16ee-\u16f8\u1700-\u1711\u171f-\u1731\u1740-\u1751\u1760-\u176c\u176e-\u1770\u1780-\u17b3\u17d7\u17dc\u1820-\u1878\u1880-\u18a8\u18aa\u18b0-\u18f5\u1900-\u191e\u1950-\u196d\u1970-\u1974\u1980-\u19ab\u19b0-\u19c9\u1a00-\u1a16\u1a20-\u1a54\u1aa7\u1b05-\u1b33\u1b45-\u1b4c\u1b83-\u1ba0\u1bae\u1baf\u1bba-\u1be5\u1c00-\u1c23\u1c4d-\u1c4f\u1c5a-\u1c7d\u1c80-\u1c8a\u1c90-\u1cba\u1cbd-\u1cbf\u1ce9-\u1cec\u1cee-\u1cf3\u1cf5\u1cf6\u1cfa\u1d00-\u1dbf\u1e00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc2-\u1fc4\u1fc6-\u1fcc\u1fd0-\u1fd3\u1fd6-\u1fdb\u1fe0-\u1fec\u1ff2-\u1ff4\u1ff6-\u1ffc\u2071\u207f\u2090-\u209c\u2102\u2107\u210a-\u2113\u2115\u2118-\u211d\u2124\u2126\u2128\u212a-\u2139\u213c-\u213f\u2145-\u2149\u214e\u2160-\u2188\u2c00-\u2ce4\u2ceb-\u2cee\u2cf2\u2cf3\u2d00-\u2d25\u2d27\u2d2d\u2d30-\u2d67\u2d6f\u2d80-\u2d96\u2da0-\u2da6\u2da8-\u2dae\u2db0-\u2db6\u2db8-\u2dbe\u2dc0-\u2dc6\u2dc8-\u2dce\u2dd0-\u2dd6\u2dd8-\u2dde\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303c\u3041-\u3096\u309b-\u309f\u30a1-\u30fa\u30fc-\u30ff\u3105-\u312f\u3131-\u318e\u31a0-\u31bf\u31f0-\u31ff\u3400-\u4dbf\u4e00-\ua48c\ua4d0-\ua4fd\ua500-\ua60c\ua610-\ua61f\ua62a\ua62b\ua640-\ua66e\ua67f-\ua69d\ua6a0-\ua6ef\ua717-\ua71f\ua722-\ua788\ua78b-\ua7cd\ua7d0\ua7d1\ua7d3\ua7d5-\ua7dc\ua7f2-\ua801\ua803-\ua805\ua807-\ua80a\ua80c-\ua822\ua840-\ua873\ua882-\ua8b3\ua8f2-\ua8f7\ua8fb\ua8fd\ua8fe\ua90a-\ua925\ua930-\ua946\ua960-\ua97c\ua984-\ua9b2\ua9cf\ua9e0-\ua9e4\ua9e6-\ua9ef\ua9fa-\ua9fe\uaa00-\uaa28\uaa40-\uaa42\uaa44-\uaa4b\uaa60-\uaa76\uaa7a\uaa7e-\uaaaf\uaab1\uaab5\uaab6\uaab9-\uaabd\uaac0\uaac2\uaadb-\uaadd\uaae0-\uaaea\uaaf2-\uaaf4\uab01-\uab06\uab09-\uab0e\uab11-\uab16\uab20-\uab26\uab28-\uab2e\uab30-\uab5a\uab5c-\uab69\uab70-\uabe2\uac00-\ud7a3\ud7b0-\ud7c6\ud7cb-\ud7fb\uf900-\ufa6d\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\ufb1d\ufb1f-\ufb28\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40\ufb41\ufb43\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfb\ufe70-\ufe74\ufe76-\ufefc\uff21-\uff3a\uff41-\uff5a\uff66-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc";

  // These are a run-length and offset encoded representation of the
  // >0xffff code points that are a valid part of identifiers. The
  // offset starts at 0x10000, and each pair of numbers represents an
  // offset to the next range, and then a size of the range.

  // Reserved word lists for various dialects of the language

  var reservedWords = {
    3: "abstract boolean byte char class double enum export extends final float goto implements import int interface long native package private protected public short static super synchronized throws transient volatile",
    5: "class enum extends super const export import",
    6: "enum",
    strict: "implements interface let package private protected public static yield",
    strictBind: "eval arguments"
  };

  // And the keywords

  var ecma5AndLessKeywords = "break case catch continue debugger default do else finally for function if return switch throw try var while with null true false instanceof typeof void delete new in this";

  var keywords$1 = {
    5: ecma5AndLessKeywords,
    "5module": ecma5AndLessKeywords + " export import",
    6: ecma5AndLessKeywords + " const class extends export import super"
  };

  var keywordRelationalOperator = /^in(stanceof)?$/;

  // ## Character categories

  var nonASCIIidentifierStart = new RegExp("[" + nonASCIIidentifierStartChars + "]");
  var nonASCIIidentifier = new RegExp("[" + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "]");

  // This has a complexity linear to the value of the code. The
  // assumption is that looking up astral identifier characters is
  // rare.
  function isInAstralSet(code, set) {
    var pos = 0x10000;
    for (var i = 0; i < set.length; i += 2) {
      pos += set[i];
      if (pos > code) { return false }
      pos += set[i + 1];
      if (pos >= code) { return true }
    }
    return false
  }

  // Test whether a given character code starts an identifier.

  function isIdentifierStart(code, astral) {
    if (code < 65) { return code === 36 }
    if (code < 91) { return true }
    if (code < 97) { return code === 95 }
    if (code < 123) { return true }
    if (code <= 0xffff) { return code >= 0xaa && nonASCIIidentifierStart.test(String.fromCharCode(code)) }
    if (astral === false) { return false }
    return isInAstralSet(code, astralIdentifierStartCodes)
  }

  // Test whether a given character is part of an identifier.

  function isIdentifierChar(code, astral) {
    if (code < 48) { return code === 36 }
    if (code < 58) { return true }
    if (code < 65) { return false }
    if (code < 91) { return true }
    if (code < 97) { return code === 95 }
    if (code < 123) { return true }
    if (code <= 0xffff) { return code >= 0xaa && nonASCIIidentifier.test(String.fromCharCode(code)) }
    if (astral === false) { return false }
    return isInAstralSet(code, astralIdentifierStartCodes) || isInAstralSet(code, astralIdentifierCodes)
  }

  // ## Token types

  // The assignment of fine-grained, information-carrying type objects
  // allows the tokenizer to store the information it has about a
  // token in a way that is very cheap for the parser to look up.

  // All token type variables start with an underscore, to make them
  // easy to recognize.

  // The `beforeExpr` property is used to disambiguate between regular
  // expressions and divisions. It is set on all token types that can
  // be followed by an expression (thus, a slash after them would be a
  // regular expression).
  //
  // The `startsExpr` property is used to check if the token ends a
  // `yield` expression. It is set on all token types that either can
  // directly start an expression (like a quotation mark) or can
  // continue an expression (like the body of a string).
  //
  // `isLoop` marks a keyword as starting a loop, which is important
  // to know when parsing a label, in order to allow or disallow
  // continue jumps to that label.

  var TokenType = function TokenType(label, conf) {
    if ( conf === void 0 ) conf = {};

    this.label = label;
    this.keyword = conf.keyword;
    this.beforeExpr = !!conf.beforeExpr;
    this.startsExpr = !!conf.startsExpr;
    this.isLoop = !!conf.isLoop;
    this.isAssign = !!conf.isAssign;
    this.prefix = !!conf.prefix;
    this.postfix = !!conf.postfix;
    this.binop = conf.binop || null;
    this.updateContext = null;
  };

  function binop(name, prec) {
    return new TokenType(name, {beforeExpr: true, binop: prec})
  }
  var beforeExpr = {beforeExpr: true}, startsExpr = {startsExpr: true};

  // Map keyword names to token types.

  var keywords = {};

  // Succinct definitions of keyword token types
  function kw(name, options) {
    if ( options === void 0 ) options = {};

    options.keyword = name;
    return keywords[name] = new TokenType(name, options)
  }

  var types$1 = {
    num: new TokenType("num", startsExpr),
    regexp: new TokenType("regexp", startsExpr),
    string: new TokenType("string", startsExpr),
    name: new TokenType("name", startsExpr),
    privateId: new TokenType("privateId", startsExpr),
    eof: new TokenType("eof"),

    // Punctuation token types.
    bracketL: new TokenType("[", {beforeExpr: true, startsExpr: true}),
    bracketR: new TokenType("]"),
    braceL: new TokenType("{", {beforeExpr: true, startsExpr: true}),
    braceR: new TokenType("}"),
    parenL: new TokenType("(", {beforeExpr: true, startsExpr: true}),
    parenR: new TokenType(")"),
    comma: new TokenType(",", beforeExpr),
    semi: new TokenType(";", beforeExpr),
    colon: new TokenType(":", beforeExpr),
    dot: new TokenType("."),
    question: new TokenType("?", beforeExpr),
    questionDot: new TokenType("?."),
    arrow: new TokenType("=>", beforeExpr),
    template: new TokenType("template"),
    invalidTemplate: new TokenType("invalidTemplate"),
    ellipsis: new TokenType("...", beforeExpr),
    backQuote: new TokenType("`", startsExpr),
    dollarBraceL: new TokenType("${", {beforeExpr: true, startsExpr: true}),

    // Operators. These carry several kinds of properties to help the
    // parser use them properly (the presence of these properties is
    // what categorizes them as operators).
    //
    // `binop`, when present, specifies that this operator is a binary
    // operator, and will refer to its precedence.
    //
    // `prefix` and `postfix` mark the operator as a prefix or postfix
    // unary operator.
    //
    // `isAssign` marks all of `=`, `+=`, `-=` etcetera, which act as
    // binary operators with a very low precedence, that should result
    // in AssignmentExpression nodes.

    eq: new TokenType("=", {beforeExpr: true, isAssign: true}),
    assign: new TokenType("_=", {beforeExpr: true, isAssign: true}),
    incDec: new TokenType("++/--", {prefix: true, postfix: true, startsExpr: true}),
    prefix: new TokenType("!/~", {beforeExpr: true, prefix: true, startsExpr: true}),
    logicalOR: binop("||", 1),
    logicalAND: binop("&&", 2),
    bitwiseOR: binop("|", 3),
    bitwiseXOR: binop("^", 4),
    bitwiseAND: binop("&", 5),
    equality: binop("==/!=/===/!==", 6),
    relational: binop("</>/<=/>=", 7),
    bitShift: binop("<</>>/>>>", 8),
    plusMin: new TokenType("+/-", {beforeExpr: true, binop: 9, prefix: true, startsExpr: true}),
    modulo: binop("%", 10),
    star: binop("*", 10),
    slash: binop("/", 10),
    starstar: new TokenType("**", {beforeExpr: true}),
    coalesce: binop("??", 1),

    // Keyword token types.
    _break: kw("break"),
    _case: kw("case", beforeExpr),
    _catch: kw("catch"),
    _continue: kw("continue"),
    _debugger: kw("debugger"),
    _default: kw("default", beforeExpr),
    _do: kw("do", {isLoop: true, beforeExpr: true}),
    _else: kw("else", beforeExpr),
    _finally: kw("finally"),
    _for: kw("for", {isLoop: true}),
    _function: kw("function", startsExpr),
    _if: kw("if"),
    _return: kw("return", beforeExpr),
    _switch: kw("switch"),
    _throw: kw("throw", beforeExpr),
    _try: kw("try"),
    _var: kw("var"),
    _const: kw("const"),
    _while: kw("while", {isLoop: true}),
    _with: kw("with"),
    _new: kw("new", {beforeExpr: true, startsExpr: true}),
    _this: kw("this", startsExpr),
    _super: kw("super", startsExpr),
    _class: kw("class", startsExpr),
    _extends: kw("extends", beforeExpr),
    _export: kw("export"),
    _import: kw("import", startsExpr),
    _null: kw("null", startsExpr),
    _true: kw("true", startsExpr),
    _false: kw("false", startsExpr),
    _in: kw("in", {beforeExpr: true, binop: 7}),
    _instanceof: kw("instanceof", {beforeExpr: true, binop: 7}),
    _typeof: kw("typeof", {beforeExpr: true, prefix: true, startsExpr: true}),
    _void: kw("void", {beforeExpr: true, prefix: true, startsExpr: true}),
    _delete: kw("delete", {beforeExpr: true, prefix: true, startsExpr: true})
  };

  // Matches a whole line break (where CRLF is considered a single
  // line break). Used to count lines.

  var lineBreak = /\r\n?|\n|\u2028|\u2029/;
  var lineBreakG = new RegExp(lineBreak.source, "g");

  function isNewLine(code) {
    return code === 10 || code === 13 || code === 0x2028 || code === 0x2029
  }

  function nextLineBreak(code, from, end) {
    if ( end === void 0 ) end = code.length;

    for (var i = from; i < end; i++) {
      var next = code.charCodeAt(i);
      if (isNewLine(next))
        { return i < end - 1 && next === 13 && code.charCodeAt(i + 1) === 10 ? i + 2 : i + 1 }
    }
    return -1
  }

  var nonASCIIwhitespace = /[\u1680\u2000-\u200a\u202f\u205f\u3000\ufeff]/;

  var skipWhiteSpace = /(?:\s|\/\/.*|\/\*[^]*?\*\/)*/g;

  var ref = Object.prototype;
  var hasOwnProperty = ref.hasOwnProperty;
  var toString = ref.toString;

  var hasOwn = Object.hasOwn || (function (obj, propName) { return (
    hasOwnProperty.call(obj, propName)
  ); });

  var isArray = Array.isArray || (function (obj) { return (
    toString.call(obj) === "[object Array]"
  ); });

  var regexpCache = Object.create(null);

  function wordsRegexp(words) {
    return regexpCache[words] || (regexpCache[words] = new RegExp("^(?:" + words.replace(/ /g, "|") + ")$"))
  }

  function codePointToString(code) {
    // UTF-16 Decoding
    if (code <= 0xFFFF) { return String.fromCharCode(code) }
    code -= 0x10000;
    return String.fromCharCode((code >> 10) + 0xD800, (code & 1023) + 0xDC00)
  }

  var loneSurrogate = /(?:[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])/;

  // These are used when `options.locations` is on, for the
  // `startLoc` and `endLoc` properties.

  var Position = function Position(line, col) {
    this.line = line;
    this.column = col;
  };

  Position.prototype.offset = function offset (n) {
    return new Position(this.line, this.column + n)
  };

  var SourceLocation = function SourceLocation(p, start, end) {
    this.start = start;
    this.end = end;
    if (p.sourceFile !== null) { this.source = p.sourceFile; }
  };

  // The `getLineInfo` function is mostly useful when the
  // `locations` option is off (for performance reasons) and you
  // want to find the line/column position for a given character
  // offset. `input` should be the code string that the offset refers
  // into.

  function getLineInfo(input, offset) {
    for (var line = 1, cur = 0;;) {
      var nextBreak = nextLineBreak(input, cur, offset);
      if (nextBreak < 0) { return new Position(line, offset - cur) }
      ++line;
      cur = nextBreak;
    }
  }

  // A second argument must be given to configure the parser process.
  // These options are recognized (only `ecmaVersion` is required):

  var defaultOptions = {
    // `ecmaVersion` indicates the ECMAScript version to parse. Must be
    // either 3, 5, 6 (or 2015), 7 (2016), 8 (2017), 9 (2018), 10
    // (2019), 11 (2020), 12 (2021), 13 (2022), 14 (2023), or `"latest"`
    // (the latest version the library supports). This influences
    // support for strict mode, the set of reserved words, and support
    // for new syntax features.
    ecmaVersion: null,
    // `sourceType` indicates the mode the code should be parsed in.
    // Can be either `"script"` or `"module"`. This influences global
    // strict mode and parsing of `import` and `export` declarations.
    sourceType: "script",
    // `onInsertedSemicolon` can be a callback that will be called when
    // a semicolon is automatically inserted. It will be passed the
    // position of the inserted semicolon as an offset, and if
    // `locations` is enabled, it is given the location as a `{line,
    // column}` object as second argument.
    onInsertedSemicolon: null,
    // `onTrailingComma` is similar to `onInsertedSemicolon`, but for
    // trailing commas.
    onTrailingComma: null,
    // By default, reserved words are only enforced if ecmaVersion >= 5.
    // Set `allowReserved` to a boolean value to explicitly turn this on
    // an off. When this option has the value "never", reserved words
    // and keywords can also not be used as property names.
    allowReserved: null,
    // When enabled, a return at the top level is not considered an
    // error.
    allowReturnOutsideFunction: false,
    // When enabled, import/export statements are not constrained to
    // appearing at the top of the program, and an import.meta expression
    // in a script isn't considered an error.
    allowImportExportEverywhere: false,
    // By default, await identifiers are allowed to appear at the top-level scope only if ecmaVersion >= 2022.
    // When enabled, await identifiers are allowed to appear at the top-level scope,
    // but they are still not allowed in non-async functions.
    allowAwaitOutsideFunction: null,
    // When enabled, super identifiers are not constrained to
    // appearing in methods and do not raise an error when they appear elsewhere.
    allowSuperOutsideMethod: null,
    // When enabled, hashbang directive in the beginning of file is
    // allowed and treated as a line comment. Enabled by default when
    // `ecmaVersion` >= 2023.
    allowHashBang: false,
    // By default, the parser will verify that private properties are
    // only used in places where they are valid and have been declared.
    // Set this to false to turn such checks off.
    checkPrivateFields: true,
    // When `locations` is on, `loc` properties holding objects with
    // `start` and `end` properties in `{line, column}` form (with
    // line being 1-based and column 0-based) will be attached to the
    // nodes.
    locations: false,
    // A function can be passed as `onToken` option, which will
    // cause Acorn to call that function with object in the same
    // format as tokens returned from `tokenizer().getToken()`. Note
    // that you are not allowed to call the parser from the
    // callback—that will corrupt its internal state.
    onToken: null,
    // A function can be passed as `onComment` option, which will
    // cause Acorn to call that function with `(block, text, start,
    // end)` parameters whenever a comment is skipped. `block` is a
    // boolean indicating whether this is a block (`/* */`) comment,
    // `text` is the content of the comment, and `start` and `end` are
    // character offsets that denote the start and end of the comment.
    // When the `locations` option is on, two more parameters are
    // passed, the full `{line, column}` locations of the start and
    // end of the comments. Note that you are not allowed to call the
    // parser from the callback—that will corrupt its internal state.
    // When this option has an array as value, objects representing the
    // comments are pushed to it.
    onComment: null,
    // Nodes have their start and end characters offsets recorded in
    // `start` and `end` properties (directly on the node, rather than
    // the `loc` object, which holds line/column data. To also add a
    // [semi-standardized][range] `range` property holding a `[start,
    // end]` array with the same numbers, set the `ranges` option to
    // `true`.
    //
    // [range]: https://bugzilla.mozilla.org/show_bug.cgi?id=745678
    ranges: false,
    // It is possible to parse multiple files into a single AST by
    // passing the tree produced by parsing the first file as
    // `program` option in subsequent parses. This will add the
    // toplevel forms of the parsed file to the `Program` (top) node
    // of an existing parse tree.
    program: null,
    // When `locations` is on, you can pass this to record the source
    // file in every node's `loc` object.
    sourceFile: null,
    // This value, if given, is stored in every node, whether
    // `locations` is on or off.
    directSourceFile: null,
    // When enabled, parenthesized expressions are represented by
    // (non-standard) ParenthesizedExpression nodes
    preserveParens: false
  };

  // Interpret and default an options object

  var warnedAboutEcmaVersion = false;

  function getOptions(opts) {
    var options = {};

    for (var opt in defaultOptions)
      { options[opt] = opts && hasOwn(opts, opt) ? opts[opt] : defaultOptions[opt]; }

    if (options.ecmaVersion === "latest") {
      options.ecmaVersion = 1e8;
    } else if (options.ecmaVersion == null) {
      if (!warnedAboutEcmaVersion && typeof console === "object" && console.warn) {
        warnedAboutEcmaVersion = true;
        console.warn("Since Acorn 8.0.0, options.ecmaVersion is required.\nDefaulting to 2020, but this will stop working in the future.");
      }
      options.ecmaVersion = 11;
    } else if (options.ecmaVersion >= 2015) {
      options.ecmaVersion -= 2009;
    }

    if (options.allowReserved == null)
      { options.allowReserved = options.ecmaVersion < 5; }

    if (!opts || opts.allowHashBang == null)
      { options.allowHashBang = options.ecmaVersion >= 14; }

    if (isArray(options.onToken)) {
      var tokens = options.onToken;
      options.onToken = function (token) { return tokens.push(token); };
    }
    if (isArray(options.onComment))
      { options.onComment = pushComment(options, options.onComment); }

    return options
  }

  function pushComment(options, array) {
    return function(block, text, start, end, startLoc, endLoc) {
      var comment = {
        type: block ? "Block" : "Line",
        value: text,
        start: start,
        end: end
      };
      if (options.locations)
        { comment.loc = new SourceLocation(this, startLoc, endLoc); }
      if (options.ranges)
        { comment.range = [start, end]; }
      array.push(comment);
    }
  }

  // Each scope gets a bitset that may contain these flags
  var
      SCOPE_TOP = 1,
      SCOPE_FUNCTION = 2,
      SCOPE_ASYNC = 4,
      SCOPE_GENERATOR = 8,
      SCOPE_ARROW = 16,
      SCOPE_SIMPLE_CATCH = 32,
      SCOPE_SUPER = 64,
      SCOPE_DIRECT_SUPER = 128,
      SCOPE_CLASS_STATIC_BLOCK = 256,
      SCOPE_CLASS_FIELD_INIT = 512,
      SCOPE_VAR = SCOPE_TOP | SCOPE_FUNCTION | SCOPE_CLASS_STATIC_BLOCK;

  function functionFlags(async, generator) {
    return SCOPE_FUNCTION | (async ? SCOPE_ASYNC : 0) | (generator ? SCOPE_GENERATOR : 0)
  }

  // Used in checkLVal* and declareName to determine the type of a binding
  var
      BIND_NONE = 0, // Not a binding
      BIND_VAR = 1, // Var-style binding
      BIND_LEXICAL = 2, // Let- or const-style binding
      BIND_FUNCTION = 3, // Function declaration
      BIND_SIMPLE_CATCH = 4, // Simple (identifier pattern) catch binding
      BIND_OUTSIDE = 5; // Special case for function names as bound inside the function

  var Parser = function Parser(options, input, startPos) {
    this.options = options = getOptions(options);
    this.sourceFile = options.sourceFile;
    this.keywords = wordsRegexp(keywords$1[options.ecmaVersion >= 6 ? 6 : options.sourceType === "module" ? "5module" : 5]);
    var reserved = "";
    if (options.allowReserved !== true) {
      reserved = reservedWords[options.ecmaVersion >= 6 ? 6 : options.ecmaVersion === 5 ? 5 : 3];
      if (options.sourceType === "module") { reserved += " await"; }
    }
    this.reservedWords = wordsRegexp(reserved);
    var reservedStrict = (reserved ? reserved + " " : "") + reservedWords.strict;
    this.reservedWordsStrict = wordsRegexp(reservedStrict);
    this.reservedWordsStrictBind = wordsRegexp(reservedStrict + " " + reservedWords.strictBind);
    this.input = String(input);

    // Used to signal to callers of `readWord1` whether the word
    // contained any escape sequences. This is needed because words with
    // escape sequences must not be interpreted as keywords.
    this.containsEsc = false;

    // Set up token state

    // The current position of the tokenizer in the input.
    if (startPos) {
      this.pos = startPos;
      this.lineStart = this.input.lastIndexOf("\n", startPos - 1) + 1;
      this.curLine = this.input.slice(0, this.lineStart).split(lineBreak).length;
    } else {
      this.pos = this.lineStart = 0;
      this.curLine = 1;
    }

    // Properties of the current token:
    // Its type
    this.type = types$1.eof;
    // For tokens that include more information than their type, the value
    this.value = null;
    // Its start and end offset
    this.start = this.end = this.pos;
    // And, if locations are used, the {line, column} object
    // corresponding to those offsets
    this.startLoc = this.endLoc = this.curPosition();

    // Position information for the previous token
    this.lastTokEndLoc = this.lastTokStartLoc = null;
    this.lastTokStart = this.lastTokEnd = this.pos;

    // The context stack is used to superficially track syntactic
    // context to predict whether a regular expression is allowed in a
    // given position.
    this.context = this.initialContext();
    this.exprAllowed = true;

    // Figure out if it's a module code.
    this.inModule = options.sourceType === "module";
    this.strict = this.inModule || this.strictDirective(this.pos);

    // Used to signify the start of a potential arrow function
    this.potentialArrowAt = -1;
    this.potentialArrowInForAwait = false;

    // Positions to delayed-check that yield/await does not exist in default parameters.
    this.yieldPos = this.awaitPos = this.awaitIdentPos = 0;
    // Labels in scope.
    this.labels = [];
    // Thus-far undefined exports.
    this.undefinedExports = Object.create(null);

    // If enabled, skip leading hashbang line.
    if (this.pos === 0 && options.allowHashBang && this.input.slice(0, 2) === "#!")
      { this.skipLineComment(2); }

    // Scope tracking for duplicate variable names (see scope.js)
    this.scopeStack = [];
    this.enterScope(SCOPE_TOP);

    // For RegExp validation
    this.regexpState = null;

    // The stack of private names.
    // Each element has two properties: 'declared' and 'used'.
    // When it exited from the outermost class definition, all used private names must be declared.
    this.privateNameStack = [];
  };

  var prototypeAccessors = { inFunction: { configurable: true },inGenerator: { configurable: true },inAsync: { configurable: true },canAwait: { configurable: true },allowSuper: { configurable: true },allowDirectSuper: { configurable: true },treatFunctionsAsVar: { configurable: true },allowNewDotTarget: { configurable: true },inClassStaticBlock: { configurable: true } };

  Parser.prototype.parse = function parse () {
    var node = this.options.program || this.startNode();
    this.nextToken();
    return this.parseTopLevel(node)
  };

  prototypeAccessors.inFunction.get = function () { return (this.currentVarScope().flags & SCOPE_FUNCTION) > 0 };

  prototypeAccessors.inGenerator.get = function () { return (this.currentVarScope().flags & SCOPE_GENERATOR) > 0 };

  prototypeAccessors.inAsync.get = function () { return (this.currentVarScope().flags & SCOPE_ASYNC) > 0 };

  prototypeAccessors.canAwait.get = function () {
    for (var i = this.scopeStack.length - 1; i >= 0; i--) {
      var ref = this.scopeStack[i];
        var flags = ref.flags;
      if (flags & (SCOPE_CLASS_STATIC_BLOCK | SCOPE_CLASS_FIELD_INIT)) { return false }
      if (flags & SCOPE_FUNCTION) { return (flags & SCOPE_ASYNC) > 0 }
    }
    return (this.inModule && this.options.ecmaVersion >= 13) || this.options.allowAwaitOutsideFunction
  };

  prototypeAccessors.allowSuper.get = function () {
    var ref = this.currentThisScope();
      var flags = ref.flags;
    return (flags & SCOPE_SUPER) > 0 || this.options.allowSuperOutsideMethod
  };

  prototypeAccessors.allowDirectSuper.get = function () { return (this.currentThisScope().flags & SCOPE_DIRECT_SUPER) > 0 };

  prototypeAccessors.treatFunctionsAsVar.get = function () { return this.treatFunctionsAsVarInScope(this.currentScope()) };

  prototypeAccessors.allowNewDotTarget.get = function () {
    for (var i = this.scopeStack.length - 1; i >= 0; i--) {
      var ref = this.scopeStack[i];
        var flags = ref.flags;
      if (flags & (SCOPE_CLASS_STATIC_BLOCK | SCOPE_CLASS_FIELD_INIT) ||
          ((flags & SCOPE_FUNCTION) && !(flags & SCOPE_ARROW))) { return true }
    }
    return false
  };

  prototypeAccessors.inClassStaticBlock.get = function () {
    return (this.currentVarScope().flags & SCOPE_CLASS_STATIC_BLOCK) > 0
  };

  Parser.extend = function extend () {
      var plugins = [], len = arguments.length;
      while ( len-- ) plugins[ len ] = arguments[ len ];

    var cls = this;
    for (var i = 0; i < plugins.length; i++) { cls = plugins[i](cls); }
    return cls
  };

  Parser.parse = function parse (input, options) {
    return new this(options, input).parse()
  };

  Parser.parseExpressionAt = function parseExpressionAt (input, pos, options) {
    var parser = new this(options, input, pos);
    parser.nextToken();
    return parser.parseExpression()
  };

  Parser.tokenizer = function tokenizer (input, options) {
    return new this(options, input)
  };

  Object.defineProperties( Parser.prototype, prototypeAccessors );

  var pp$9 = Parser.prototype;

  // ## Parser utilities

  var literal = /^(?:'((?:\\[^]|[^'\\])*?)'|"((?:\\[^]|[^"\\])*?)")/;
  pp$9.strictDirective = function(start) {
    if (this.options.ecmaVersion < 5) { return false }
    for (;;) {
      // Try to find string literal.
      skipWhiteSpace.lastIndex = start;
      start += skipWhiteSpace.exec(this.input)[0].length;
      var match = literal.exec(this.input.slice(start));
      if (!match) { return false }
      if ((match[1] || match[2]) === "use strict") {
        skipWhiteSpace.lastIndex = start + match[0].length;
        var spaceAfter = skipWhiteSpace.exec(this.input), end = spaceAfter.index + spaceAfter[0].length;
        var next = this.input.charAt(end);
        return next === ";" || next === "}" ||
          (lineBreak.test(spaceAfter[0]) &&
           !(/[(`.[+\-/*%<>=,?^&]/.test(next) || next === "!" && this.input.charAt(end + 1) === "="))
      }
      start += match[0].length;

      // Skip semicolon, if any.
      skipWhiteSpace.lastIndex = start;
      start += skipWhiteSpace.exec(this.input)[0].length;
      if (this.input[start] === ";")
        { start++; }
    }
  };

  // Predicate that tests whether the next token is of the given
  // type, and if yes, consumes it as a side effect.

  pp$9.eat = function(type) {
    if (this.type === type) {
      this.next();
      return true
    } else {
      return false
    }
  };

  // Tests whether parsed token is a contextual keyword.

  pp$9.isContextual = function(name) {
    return this.type === types$1.name && this.value === name && !this.containsEsc
  };

  // Consumes contextual keyword if possible.

  pp$9.eatContextual = function(name) {
    if (!this.isContextual(name)) { return false }
    this.next();
    return true
  };

  // Asserts that following token is given contextual keyword.

  pp$9.expectContextual = function(name) {
    if (!this.eatContextual(name)) { this.unexpected(); }
  };

  // Test whether a semicolon can be inserted at the current position.

  pp$9.canInsertSemicolon = function() {
    return this.type === types$1.eof ||
      this.type === types$1.braceR ||
      lineBreak.test(this.input.slice(this.lastTokEnd, this.start))
  };

  pp$9.insertSemicolon = function() {
    if (this.canInsertSemicolon()) {
      if (this.options.onInsertedSemicolon)
        { this.options.onInsertedSemicolon(this.lastTokEnd, this.lastTokEndLoc); }
      return true
    }
  };

  // Consume a semicolon, or, failing that, see if we are allowed to
  // pretend that there is a semicolon at this position.

  pp$9.semicolon = function() {
    if (!this.eat(types$1.semi) && !this.insertSemicolon()) { this.unexpected(); }
  };

  pp$9.afterTrailingComma = function(tokType, notNext) {
    if (this.type === tokType) {
      if (this.options.onTrailingComma)
        { this.options.onTrailingComma(this.lastTokStart, this.lastTokStartLoc); }
      if (!notNext)
        { this.next(); }
      return true
    }
  };

  // Expect a token of a given type. If found, consume it, otherwise,
  // raise an unexpected token error.

  pp$9.expect = function(type) {
    this.eat(type) || this.unexpected();
  };

  // Raise an unexpected token error.

  pp$9.unexpected = function(pos) {
    this.raise(pos != null ? pos : this.start, "Unexpected token");
  };

  var DestructuringErrors = function DestructuringErrors() {
    this.shorthandAssign =
    this.trailingComma =
    this.parenthesizedAssign =
    this.parenthesizedBind =
    this.doubleProto =
      -1;
  };

  pp$9.checkPatternErrors = function(refDestructuringErrors, isAssign) {
    if (!refDestructuringErrors) { return }
    if (refDestructuringErrors.trailingComma > -1)
      { this.raiseRecoverable(refDestructuringErrors.trailingComma, "Comma is not permitted after the rest element"); }
    var parens = isAssign ? refDestructuringErrors.parenthesizedAssign : refDestructuringErrors.parenthesizedBind;
    if (parens > -1) { this.raiseRecoverable(parens, isAssign ? "Assigning to rvalue" : "Parenthesized pattern"); }
  };

  pp$9.checkExpressionErrors = function(refDestructuringErrors, andThrow) {
    if (!refDestructuringErrors) { return false }
    var shorthandAssign = refDestructuringErrors.shorthandAssign;
    var doubleProto = refDestructuringErrors.doubleProto;
    if (!andThrow) { return shorthandAssign >= 0 || doubleProto >= 0 }
    if (shorthandAssign >= 0)
      { this.raise(shorthandAssign, "Shorthand property assignments are valid only in destructuring patterns"); }
    if (doubleProto >= 0)
      { this.raiseRecoverable(doubleProto, "Redefinition of __proto__ property"); }
  };

  pp$9.checkYieldAwaitInDefaultParams = function() {
    if (this.yieldPos && (!this.awaitPos || this.yieldPos < this.awaitPos))
      { this.raise(this.yieldPos, "Yield expression cannot be a default value"); }
    if (this.awaitPos)
      { this.raise(this.awaitPos, "Await expression cannot be a default value"); }
  };

  pp$9.isSimpleAssignTarget = function(expr) {
    if (expr.type === "ParenthesizedExpression")
      { return this.isSimpleAssignTarget(expr.expression) }
    return expr.type === "Identifier" || expr.type === "MemberExpression"
  };

  var pp$8 = Parser.prototype;

  // ### Statement parsing

  // Parse a program. Initializes the parser, reads any number of
  // statements, and wraps them in a Program node.  Optionally takes a
  // `program` argument.  If present, the statements will be appended
  // to its body instead of creating a new node.

  pp$8.parseTopLevel = function(node) {
    var exports = Object.create(null);
    if (!node.body) { node.body = []; }
    while (this.type !== types$1.eof) {
      var stmt = this.parseStatement(null, true, exports);
      node.body.push(stmt);
    }
    if (this.inModule)
      { for (var i = 0, list = Object.keys(this.undefinedExports); i < list.length; i += 1)
        {
          var name = list[i];

          this.raiseRecoverable(this.undefinedExports[name].start, ("Export '" + name + "' is not defined"));
        } }
    this.adaptDirectivePrologue(node.body);
    this.next();
    node.sourceType = this.options.sourceType;
    return this.finishNode(node, "Program")
  };

  var loopLabel = {kind: "loop"}, switchLabel = {kind: "switch"};

  pp$8.isLet = function(context) {
    if (this.options.ecmaVersion < 6 || !this.isContextual("let")) { return false }
    skipWhiteSpace.lastIndex = this.pos;
    var skip = skipWhiteSpace.exec(this.input);
    var next = this.pos + skip[0].length, nextCh = this.input.charCodeAt(next);
    // For ambiguous cases, determine if a LexicalDeclaration (or only a
    // Statement) is allowed here. If context is not empty then only a Statement
    // is allowed. However, `let [` is an explicit negative lookahead for
    // ExpressionStatement, so special-case it first.
    if (nextCh === 91 || nextCh === 92) { return true } // '[', '\'
    if (context) { return false }

    if (nextCh === 123 || nextCh > 0xd7ff && nextCh < 0xdc00) { return true } // '{', astral
    if (isIdentifierStart(nextCh, true)) {
      var pos = next + 1;
      while (isIdentifierChar(nextCh = this.input.charCodeAt(pos), true)) { ++pos; }
      if (nextCh === 92 || nextCh > 0xd7ff && nextCh < 0xdc00) { return true }
      var ident = this.input.slice(next, pos);
      if (!keywordRelationalOperator.test(ident)) { return true }
    }
    return false
  };

  // check 'async [no LineTerminator here] function'
  // - 'async /*foo*/ function' is OK.
  // - 'async /*\n*/ function' is invalid.
  pp$8.isAsyncFunction = function() {
    if (this.options.ecmaVersion < 8 || !this.isContextual("async"))
      { return false }

    skipWhiteSpace.lastIndex = this.pos;
    var skip = skipWhiteSpace.exec(this.input);
    var next = this.pos + skip[0].length, after;
    return !lineBreak.test(this.input.slice(this.pos, next)) &&
      this.input.slice(next, next + 8) === "function" &&
      (next + 8 === this.input.length ||
       !(isIdentifierChar(after = this.input.charCodeAt(next + 8)) || after > 0xd7ff && after < 0xdc00))
  };

  pp$8.isUsingKeyword = function(isAwaitUsing, isFor) {
    if (this.options.ecmaVersion < 17 || !this.isContextual(isAwaitUsing ? "await" : "using"))
      { return false }

    skipWhiteSpace.lastIndex = this.pos;
    var skip = skipWhiteSpace.exec(this.input);
    var next = this.pos + skip[0].length;

    if (lineBreak.test(this.input.slice(this.pos, next))) { return false }

    if (isAwaitUsing) {
      var awaitEndPos = next + 5 /* await */, after;
      if (this.input.slice(next, awaitEndPos) !== "using" ||
        awaitEndPos === this.input.length ||
        isIdentifierChar(after = this.input.charCodeAt(awaitEndPos)) ||
        (after > 0xd7ff && after < 0xdc00)
      ) { return false }

      skipWhiteSpace.lastIndex = awaitEndPos;
      var skipAfterUsing = skipWhiteSpace.exec(this.input);
      if (skipAfterUsing && lineBreak.test(this.input.slice(awaitEndPos, awaitEndPos + skipAfterUsing[0].length))) { return false }
    }

    if (isFor) {
      var ofEndPos = next + 2 /* of */, after$1;
      if (this.input.slice(next, ofEndPos) === "of") {
        if (ofEndPos === this.input.length ||
          (!isIdentifierChar(after$1 = this.input.charCodeAt(ofEndPos)) && !(after$1 > 0xd7ff && after$1 < 0xdc00))) { return false }
      }
    }

    var ch = this.input.charCodeAt(next);
    return isIdentifierStart(ch, true) || ch === 92 // '\'
  };

  pp$8.isAwaitUsing = function(isFor) {
    return this.isUsingKeyword(true, isFor)
  };

  pp$8.isUsing = function(isFor) {
    return this.isUsingKeyword(false, isFor)
  };

  // Parse a single statement.
  //
  // If expecting a statement and finding a slash operator, parse a
  // regular expression literal. This is to handle cases like
  // `if (foo) /blah/.exec(foo)`, where looking at the previous token
  // does not help.

  pp$8.parseStatement = function(context, topLevel, exports) {
    var starttype = this.type, node = this.startNode(), kind;

    if (this.isLet(context)) {
      starttype = types$1._var;
      kind = "let";
    }

    // Most types of statements are recognized by the keyword they
    // start with. Many are trivial to parse, some require a bit of
    // complexity.

    switch (starttype) {
    case types$1._break: case types$1._continue: return this.parseBreakContinueStatement(node, starttype.keyword)
    case types$1._debugger: return this.parseDebuggerStatement(node)
    case types$1._do: return this.parseDoStatement(node)
    case types$1._for: return this.parseForStatement(node)
    case types$1._function:
      // Function as sole body of either an if statement or a labeled statement
      // works, but not when it is part of a labeled statement that is the sole
      // body of an if statement.
      if ((context && (this.strict || context !== "if" && context !== "label")) && this.options.ecmaVersion >= 6) { this.unexpected(); }
      return this.parseFunctionStatement(node, false, !context)
    case types$1._class:
      if (context) { this.unexpected(); }
      return this.parseClass(node, true)
    case types$1._if: return this.parseIfStatement(node)
    case types$1._return: return this.parseReturnStatement(node)
    case types$1._switch: return this.parseSwitchStatement(node)
    case types$1._throw: return this.parseThrowStatement(node)
    case types$1._try: return this.parseTryStatement(node)
    case types$1._const: case types$1._var:
      kind = kind || this.value;
      if (context && kind !== "var") { this.unexpected(); }
      return this.parseVarStatement(node, kind)
    case types$1._while: return this.parseWhileStatement(node)
    case types$1._with: return this.parseWithStatement(node)
    case types$1.braceL: return this.parseBlock(true, node)
    case types$1.semi: return this.parseEmptyStatement(node)
    case types$1._export:
    case types$1._import:
      if (this.options.ecmaVersion > 10 && starttype === types$1._import) {
        skipWhiteSpace.lastIndex = this.pos;
        var skip = skipWhiteSpace.exec(this.input);
        var next = this.pos + skip[0].length, nextCh = this.input.charCodeAt(next);
        if (nextCh === 40 || nextCh === 46) // '(' or '.'
          { return this.parseExpressionStatement(node, this.parseExpression()) }
      }

      if (!this.options.allowImportExportEverywhere) {
        if (!topLevel)
          { this.raise(this.start, "'import' and 'export' may only appear at the top level"); }
        if (!this.inModule)
          { this.raise(this.start, "'import' and 'export' may appear only with 'sourceType: module'"); }
      }
      return starttype === types$1._import ? this.parseImport(node) : this.parseExport(node, exports)

      // If the statement does not start with a statement keyword or a
      // brace, it's an ExpressionStatement or LabeledStatement. We
      // simply start parsing an expression, and afterwards, if the
      // next token is a colon and the expression was a simple
      // Identifier node, we switch to interpreting it as a label.
    default:
      if (this.isAsyncFunction()) {
        if (context) { this.unexpected(); }
        this.next();
        return this.parseFunctionStatement(node, true, !context)
      }

      var usingKind = this.isAwaitUsing(false) ? "await using" : this.isUsing(false) ? "using" : null;
      if (usingKind) {
        if (topLevel && this.options.sourceType === "script") {
          this.raise(this.start, "Using declaration cannot appear in the top level when source type is `script`");
        }
        if (usingKind === "await using") {
          if (!this.canAwait) {
            this.raise(this.start, "Await using cannot appear outside of async function");
          }
          this.next();
        }
        this.next();
        this.parseVar(node, false, usingKind);
        this.semicolon();
        return this.finishNode(node, "VariableDeclaration")
      }

      var maybeName = this.value, expr = this.parseExpression();
      if (starttype === types$1.name && expr.type === "Identifier" && this.eat(types$1.colon))
        { return this.parseLabeledStatement(node, maybeName, expr, context) }
      else { return this.parseExpressionStatement(node, expr) }
    }
  };

  pp$8.parseBreakContinueStatement = function(node, keyword) {
    var isBreak = keyword === "break";
    this.next();
    if (this.eat(types$1.semi) || this.insertSemicolon()) { node.label = null; }
    else if (this.type !== types$1.name) { this.unexpected(); }
    else {
      node.label = this.parseIdent();
      this.semicolon();
    }

    // Verify that there is an actual destination to break or
    // continue to.
    var i = 0;
    for (; i < this.labels.length; ++i) {
      var lab = this.labels[i];
      if (node.label == null || lab.name === node.label.name) {
        if (lab.kind != null && (isBreak || lab.kind === "loop")) { break }
        if (node.label && isBreak) { break }
      }
    }
    if (i === this.labels.length) { this.raise(node.start, "Unsyntactic " + keyword); }
    return this.finishNode(node, isBreak ? "BreakStatement" : "ContinueStatement")
  };

  pp$8.parseDebuggerStatement = function(node) {
    this.next();
    this.semicolon();
    return this.finishNode(node, "DebuggerStatement")
  };

  pp$8.parseDoStatement = function(node) {
    this.next();
    this.labels.push(loopLabel);
    node.body = this.parseStatement("do");
    this.labels.pop();
    this.expect(types$1._while);
    node.test = this.parseParenExpression();
    if (this.options.ecmaVersion >= 6)
      { this.eat(types$1.semi); }
    else
      { this.semicolon(); }
    return this.finishNode(node, "DoWhileStatement")
  };

  // Disambiguating between a `for` and a `for`/`in` or `for`/`of`
  // loop is non-trivial. Basically, we have to parse the init `var`
  // statement or expression, disallowing the `in` operator (see
  // the second parameter to `parseExpression`), and then check
  // whether the next token is `in` or `of`. When there is no init
  // part (semicolon immediately after the opening parenthesis), it
  // is a regular `for` loop.

  pp$8.parseForStatement = function(node) {
    this.next();
    var awaitAt = (this.options.ecmaVersion >= 9 && this.canAwait && this.eatContextual("await")) ? this.lastTokStart : -1;
    this.labels.push(loopLabel);
    this.enterScope(0);
    this.expect(types$1.parenL);
    if (this.type === types$1.semi) {
      if (awaitAt > -1) { this.unexpected(awaitAt); }
      return this.parseFor(node, null)
    }
    var isLet = this.isLet();
    if (this.type === types$1._var || this.type === types$1._const || isLet) {
      var init$1 = this.startNode(), kind = isLet ? "let" : this.value;
      this.next();
      this.parseVar(init$1, true, kind);
      this.finishNode(init$1, "VariableDeclaration");
      return this.parseForAfterInit(node, init$1, awaitAt)
    }
    var startsWithLet = this.isContextual("let"), isForOf = false;

    var usingKind = this.isUsing(true) ? "using" : this.isAwaitUsing(true) ? "await using" : null;
    if (usingKind) {
      var init$2 = this.startNode();
      this.next();
      if (usingKind === "await using") { this.next(); }
      this.parseVar(init$2, true, usingKind);
      this.finishNode(init$2, "VariableDeclaration");
      return this.parseForAfterInit(node, init$2, awaitAt)
    }
    var containsEsc = this.containsEsc;
    var refDestructuringErrors = new DestructuringErrors;
    var initPos = this.start;
    var init = awaitAt > -1
      ? this.parseExprSubscripts(refDestructuringErrors, "await")
      : this.parseExpression(true, refDestructuringErrors);
    if (this.type === types$1._in || (isForOf = this.options.ecmaVersion >= 6 && this.isContextual("of"))) {
      if (awaitAt > -1) { // implies `ecmaVersion >= 9` (see declaration of awaitAt)
        if (this.type === types$1._in) { this.unexpected(awaitAt); }
        node.await = true;
      } else if (isForOf && this.options.ecmaVersion >= 8) {
        if (init.start === initPos && !containsEsc && init.type === "Identifier" && init.name === "async") { this.unexpected(); }
        else if (this.options.ecmaVersion >= 9) { node.await = false; }
      }
      if (startsWithLet && isForOf) { this.raise(init.start, "The left-hand side of a for-of loop may not start with 'let'."); }
      this.toAssignable(init, false, refDestructuringErrors);
      this.checkLValPattern(init);
      return this.parseForIn(node, init)
    } else {
      this.checkExpressionErrors(refDestructuringErrors, true);
    }
    if (awaitAt > -1) { this.unexpected(awaitAt); }
    return this.parseFor(node, init)
  };

  // Helper method to parse for loop after variable initialization
  pp$8.parseForAfterInit = function(node, init, awaitAt) {
    if ((this.type === types$1._in || (this.options.ecmaVersion >= 6 && this.isContextual("of"))) && init.declarations.length === 1) {
      if (this.options.ecmaVersion >= 9) {
        if (this.type === types$1._in) {
          if (awaitAt > -1) { this.unexpected(awaitAt); }
        } else { node.await = awaitAt > -1; }
      }
      return this.parseForIn(node, init)
    }
    if (awaitAt > -1) { this.unexpected(awaitAt); }
    return this.parseFor(node, init)
  };

  pp$8.parseFunctionStatement = function(node, isAsync, declarationPosition) {
    this.next();
    return this.parseFunction(node, FUNC_STATEMENT | (declarationPosition ? 0 : FUNC_HANGING_STATEMENT), false, isAsync)
  };

  pp$8.parseIfStatement = function(node) {
    this.next();
    node.test = this.parseParenExpression();
    // allow function declarations in branches, but only in non-strict mode
    node.consequent = this.parseStatement("if");
    node.alternate = this.eat(types$1._else) ? this.parseStatement("if") : null;
    return this.finishNode(node, "IfStatement")
  };

  pp$8.parseReturnStatement = function(node) {
    if (!this.inFunction && !this.options.allowReturnOutsideFunction)
      { this.raise(this.start, "'return' outside of function"); }
    this.next();

    // In `return` (and `break`/`continue`), the keywords with
    // optional arguments, we eagerly look for a semicolon or the
    // possibility to insert one.

    if (this.eat(types$1.semi) || this.insertSemicolon()) { node.argument = null; }
    else { node.argument = this.parseExpression(); this.semicolon(); }
    return this.finishNode(node, "ReturnStatement")
  };

  pp$8.parseSwitchStatement = function(node) {
    this.next();
    node.discriminant = this.parseParenExpression();
    node.cases = [];
    this.expect(types$1.braceL);
    this.labels.push(switchLabel);
    this.enterScope(0);

    // Statements under must be grouped (by label) in SwitchCase
    // nodes. `cur` is used to keep the node that we are currently
    // adding statements to.

    var cur;
    for (var sawDefault = false; this.type !== types$1.braceR;) {
      if (this.type === types$1._case || this.type === types$1._default) {
        var isCase = this.type === types$1._case;
        if (cur) { this.finishNode(cur, "SwitchCase"); }
        node.cases.push(cur = this.startNode());
        cur.consequent = [];
        this.next();
        if (isCase) {
          cur.test = this.parseExpression();
        } else {
          if (sawDefault) { this.raiseRecoverable(this.lastTokStart, "Multiple default clauses"); }
          sawDefault = true;
          cur.test = null;
        }
        this.expect(types$1.colon);
      } else {
        if (!cur) { this.unexpected(); }
        cur.consequent.push(this.parseStatement(null));
      }
    }
    this.exitScope();
    if (cur) { this.finishNode(cur, "SwitchCase"); }
    this.next(); // Closing brace
    this.labels.pop();
    return this.finishNode(node, "SwitchStatement")
  };

  pp$8.parseThrowStatement = function(node) {
    this.next();
    if (lineBreak.test(this.input.slice(this.lastTokEnd, this.start)))
      { this.raise(this.lastTokEnd, "Illegal newline after throw"); }
    node.argument = this.parseExpression();
    this.semicolon();
    return this.finishNode(node, "ThrowStatement")
  };

  // Reused empty array added for node fields that are always empty.

  var empty$1 = [];

  pp$8.parseCatchClauseParam = function() {
    var param = this.parseBindingAtom();
    var simple = param.type === "Identifier";
    this.enterScope(simple ? SCOPE_SIMPLE_CATCH : 0);
    this.checkLValPattern(param, simple ? BIND_SIMPLE_CATCH : BIND_LEXICAL);
    this.expect(types$1.parenR);

    return param
  };

  pp$8.parseTryStatement = function(node) {
    this.next();
    node.block = this.parseBlock();
    node.handler = null;
    if (this.type === types$1._catch) {
      var clause = this.startNode();
      this.next();
      if (this.eat(types$1.parenL)) {
        clause.param = this.parseCatchClauseParam();
      } else {
        if (this.options.ecmaVersion < 10) { this.unexpected(); }
        clause.param = null;
        this.enterScope(0);
      }
      clause.body = this.parseBlock(false);
      this.exitScope();
      node.handler = this.finishNode(clause, "CatchClause");
    }
    node.finalizer = this.eat(types$1._finally) ? this.parseBlock() : null;
    if (!node.handler && !node.finalizer)
      { this.raise(node.start, "Missing catch or finally clause"); }
    return this.finishNode(node, "TryStatement")
  };

  pp$8.parseVarStatement = function(node, kind, allowMissingInitializer) {
    this.next();
    this.parseVar(node, false, kind, allowMissingInitializer);
    this.semicolon();
    return this.finishNode(node, "VariableDeclaration")
  };

  pp$8.parseWhileStatement = function(node) {
    this.next();
    node.test = this.parseParenExpression();
    this.labels.push(loopLabel);
    node.body = this.parseStatement("while");
    this.labels.pop();
    return this.finishNode(node, "WhileStatement")
  };

  pp$8.parseWithStatement = function(node) {
    if (this.strict) { this.raise(this.start, "'with' in strict mode"); }
    this.next();
    node.object = this.parseParenExpression();
    node.body = this.parseStatement("with");
    return this.finishNode(node, "WithStatement")
  };

  pp$8.parseEmptyStatement = function(node) {
    this.next();
    return this.finishNode(node, "EmptyStatement")
  };

  pp$8.parseLabeledStatement = function(node, maybeName, expr, context) {
    for (var i$1 = 0, list = this.labels; i$1 < list.length; i$1 += 1)
      {
      var label = list[i$1];

      if (label.name === maybeName)
        { this.raise(expr.start, "Label '" + maybeName + "' is already declared");
    } }
    var kind = this.type.isLoop ? "loop" : this.type === types$1._switch ? "switch" : null;
    for (var i = this.labels.length - 1; i >= 0; i--) {
      var label$1 = this.labels[i];
      if (label$1.statementStart === node.start) {
        // Update information about previous labels on this node
        label$1.statementStart = this.start;
        label$1.kind = kind;
      } else { break }
    }
    this.labels.push({name: maybeName, kind: kind, statementStart: this.start});
    node.body = this.parseStatement(context ? context.indexOf("label") === -1 ? context + "label" : context : "label");
    this.labels.pop();
    node.label = expr;
    return this.finishNode(node, "LabeledStatement")
  };

  pp$8.parseExpressionStatement = function(node, expr) {
    node.expression = expr;
    this.semicolon();
    return this.finishNode(node, "ExpressionStatement")
  };

  // Parse a semicolon-enclosed block of statements, handling `"use
  // strict"` declarations when `allowStrict` is true (used for
  // function bodies).

  pp$8.parseBlock = function(createNewLexicalScope, node, exitStrict) {
    if ( createNewLexicalScope === void 0 ) createNewLexicalScope = true;
    if ( node === void 0 ) node = this.startNode();

    node.body = [];
    this.expect(types$1.braceL);
    if (createNewLexicalScope) { this.enterScope(0); }
    while (this.type !== types$1.braceR) {
      var stmt = this.parseStatement(null);
      node.body.push(stmt);
    }
    if (exitStrict) { this.strict = false; }
    this.next();
    if (createNewLexicalScope) { this.exitScope(); }
    return this.finishNode(node, "BlockStatement")
  };

  // Parse a regular `for` loop. The disambiguation code in
  // `parseStatement` will already have parsed the init statement or
  // expression.

  pp$8.parseFor = function(node, init) {
    node.init = init;
    this.expect(types$1.semi);
    node.test = this.type === types$1.semi ? null : this.parseExpression();
    this.expect(types$1.semi);
    node.update = this.type === types$1.parenR ? null : this.parseExpression();
    this.expect(types$1.parenR);
    node.body = this.parseStatement("for");
    this.exitScope();
    this.labels.pop();
    return this.finishNode(node, "ForStatement")
  };

  // Parse a `for`/`in` and `for`/`of` loop, which are almost
  // same from parser's perspective.

  pp$8.parseForIn = function(node, init) {
    var isForIn = this.type === types$1._in;
    this.next();

    if (
      init.type === "VariableDeclaration" &&
      init.declarations[0].init != null &&
      (
        !isForIn ||
        this.options.ecmaVersion < 8 ||
        this.strict ||
        init.kind !== "var" ||
        init.declarations[0].id.type !== "Identifier"
      )
    ) {
      this.raise(
        init.start,
        ((isForIn ? "for-in" : "for-of") + " loop variable declaration may not have an initializer")
      );
    }
    node.left = init;
    node.right = isForIn ? this.parseExpression() : this.parseMaybeAssign();
    this.expect(types$1.parenR);
    node.body = this.parseStatement("for");
    this.exitScope();
    this.labels.pop();
    return this.finishNode(node, isForIn ? "ForInStatement" : "ForOfStatement")
  };

  // Parse a list of variable declarations.

  pp$8.parseVar = function(node, isFor, kind, allowMissingInitializer) {
    node.declarations = [];
    node.kind = kind;
    for (;;) {
      var decl = this.startNode();
      this.parseVarId(decl, kind);
      if (this.eat(types$1.eq)) {
        decl.init = this.parseMaybeAssign(isFor);
      } else if (!allowMissingInitializer && kind === "const" && !(this.type === types$1._in || (this.options.ecmaVersion >= 6 && this.isContextual("of")))) {
        this.unexpected();
      } else if (!allowMissingInitializer && (kind === "using" || kind === "await using") && this.options.ecmaVersion >= 17 && this.type !== types$1._in && !this.isContextual("of")) {
        this.raise(this.lastTokEnd, ("Missing initializer in " + kind + " declaration"));
      } else if (!allowMissingInitializer && decl.id.type !== "Identifier" && !(isFor && (this.type === types$1._in || this.isContextual("of")))) {
        this.raise(this.lastTokEnd, "Complex binding patterns require an initialization value");
      } else {
        decl.init = null;
      }
      node.declarations.push(this.finishNode(decl, "VariableDeclarator"));
      if (!this.eat(types$1.comma)) { break }
    }
    return node
  };

  pp$8.parseVarId = function(decl, kind) {
    decl.id = kind === "using" || kind === "await using"
      ? this.parseIdent()
      : this.parseBindingAtom();

    this.checkLValPattern(decl.id, kind === "var" ? BIND_VAR : BIND_LEXICAL, false);
  };

  var FUNC_STATEMENT = 1, FUNC_HANGING_STATEMENT = 2, FUNC_NULLABLE_ID = 4;

  // Parse a function declaration or literal (depending on the
  // `statement & FUNC_STATEMENT`).

  // Remove `allowExpressionBody` for 7.0.0, as it is only called with false
  pp$8.parseFunction = function(node, statement, allowExpressionBody, isAsync, forInit) {
    this.initFunction(node);
    if (this.options.ecmaVersion >= 9 || this.options.ecmaVersion >= 6 && !isAsync) {
      if (this.type === types$1.star && (statement & FUNC_HANGING_STATEMENT))
        { this.unexpected(); }
      node.generator = this.eat(types$1.star);
    }
    if (this.options.ecmaVersion >= 8)
      { node.async = !!isAsync; }

    if (statement & FUNC_STATEMENT) {
      node.id = (statement & FUNC_NULLABLE_ID) && this.type !== types$1.name ? null : this.parseIdent();
      if (node.id && !(statement & FUNC_HANGING_STATEMENT))
        // If it is a regular function declaration in sloppy mode, then it is
        // subject to Annex B semantics (BIND_FUNCTION). Otherwise, the binding
        // mode depends on properties of the current scope (see
        // treatFunctionsAsVar).
        { this.checkLValSimple(node.id, (this.strict || node.generator || node.async) ? this.treatFunctionsAsVar ? BIND_VAR : BIND_LEXICAL : BIND_FUNCTION); }
    }

    var oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
    this.yieldPos = 0;
    this.awaitPos = 0;
    this.awaitIdentPos = 0;
    this.enterScope(functionFlags(node.async, node.generator));

    if (!(statement & FUNC_STATEMENT))
      { node.id = this.type === types$1.name ? this.parseIdent() : null; }

    this.parseFunctionParams(node);
    this.parseFunctionBody(node, allowExpressionBody, false, forInit);

    this.yieldPos = oldYieldPos;
    this.awaitPos = oldAwaitPos;
    this.awaitIdentPos = oldAwaitIdentPos;
    return this.finishNode(node, (statement & FUNC_STATEMENT) ? "FunctionDeclaration" : "FunctionExpression")
  };

  pp$8.parseFunctionParams = function(node) {
    this.expect(types$1.parenL);
    node.params = this.parseBindingList(types$1.parenR, false, this.options.ecmaVersion >= 8);
    this.checkYieldAwaitInDefaultParams();
  };

  // Parse a class declaration or literal (depending on the
  // `isStatement` parameter).

  pp$8.parseClass = function(node, isStatement) {
    this.next();

    // ecma-262 14.6 Class Definitions
    // A class definition is always strict mode code.
    var oldStrict = this.strict;
    this.strict = true;

    this.parseClassId(node, isStatement);
    this.parseClassSuper(node);
    var privateNameMap = this.enterClassBody();
    var classBody = this.startNode();
    var hadConstructor = false;
    classBody.body = [];
    this.expect(types$1.braceL);
    while (this.type !== types$1.braceR) {
      var element = this.parseClassElement(node.superClass !== null);
      if (element) {
        classBody.body.push(element);
        if (element.type === "MethodDefinition" && element.kind === "constructor") {
          if (hadConstructor) { this.raiseRecoverable(element.start, "Duplicate constructor in the same class"); }
          hadConstructor = true;
        } else if (element.key && element.key.type === "PrivateIdentifier" && isPrivateNameConflicted(privateNameMap, element)) {
          this.raiseRecoverable(element.key.start, ("Identifier '#" + (element.key.name) + "' has already been declared"));
        }
      }
    }
    this.strict = oldStrict;
    this.next();
    node.body = this.finishNode(classBody, "ClassBody");
    this.exitClassBody();
    return this.finishNode(node, isStatement ? "ClassDeclaration" : "ClassExpression")
  };

  pp$8.parseClassElement = function(constructorAllowsSuper) {
    if (this.eat(types$1.semi)) { return null }

    var ecmaVersion = this.options.ecmaVersion;
    var node = this.startNode();
    var keyName = "";
    var isGenerator = false;
    var isAsync = false;
    var kind = "method";
    var isStatic = false;

    if (this.eatContextual("static")) {
      // Parse static init block
      if (ecmaVersion >= 13 && this.eat(types$1.braceL)) {
        this.parseClassStaticBlock(node);
        return node
      }
      if (this.isClassElementNameStart() || this.type === types$1.star) {
        isStatic = true;
      } else {
        keyName = "static";
      }
    }
    node.static = isStatic;
    if (!keyName && ecmaVersion >= 8 && this.eatContextual("async")) {
      if ((this.isClassElementNameStart() || this.type === types$1.star) && !this.canInsertSemicolon()) {
        isAsync = true;
      } else {
        keyName = "async";
      }
    }
    if (!keyName && (ecmaVersion >= 9 || !isAsync) && this.eat(types$1.star)) {
      isGenerator = true;
    }
    if (!keyName && !isAsync && !isGenerator) {
      var lastValue = this.value;
      if (this.eatContextual("get") || this.eatContextual("set")) {
        if (this.isClassElementNameStart()) {
          kind = lastValue;
        } else {
          keyName = lastValue;
        }
      }
    }

    // Parse element name
    if (keyName) {
      // 'async', 'get', 'set', or 'static' were not a keyword contextually.
      // The last token is any of those. Make it the element name.
      node.computed = false;
      node.key = this.startNodeAt(this.lastTokStart, this.lastTokStartLoc);
      node.key.name = keyName;
      this.finishNode(node.key, "Identifier");
    } else {
      this.parseClassElementName(node);
    }

    // Parse element value
    if (ecmaVersion < 13 || this.type === types$1.parenL || kind !== "method" || isGenerator || isAsync) {
      var isConstructor = !node.static && checkKeyName(node, "constructor");
      var allowsDirectSuper = isConstructor && constructorAllowsSuper;
      // Couldn't move this check into the 'parseClassMethod' method for backward compatibility.
      if (isConstructor && kind !== "method") { this.raise(node.key.start, "Constructor can't have get/set modifier"); }
      node.kind = isConstructor ? "constructor" : kind;
      this.parseClassMethod(node, isGenerator, isAsync, allowsDirectSuper);
    } else {
      this.parseClassField(node);
    }

    return node
  };

  pp$8.isClassElementNameStart = function() {
    return (
      this.type === types$1.name ||
      this.type === types$1.privateId ||
      this.type === types$1.num ||
      this.type === types$1.string ||
      this.type === types$1.bracketL ||
      this.type.keyword
    )
  };

  pp$8.parseClassElementName = function(element) {
    if (this.type === types$1.privateId) {
      if (this.value === "constructor") {
        this.raise(this.start, "Classes can't have an element named '#constructor'");
      }
      element.computed = false;
      element.key = this.parsePrivateIdent();
    } else {
      this.parsePropertyName(element);
    }
  };

  pp$8.parseClassMethod = function(method, isGenerator, isAsync, allowsDirectSuper) {
    // Check key and flags
    var key = method.key;
    if (method.kind === "constructor") {
      if (isGenerator) { this.raise(key.start, "Constructor can't be a generator"); }
      if (isAsync) { this.raise(key.start, "Constructor can't be an async method"); }
    } else if (method.static && checkKeyName(method, "prototype")) {
      this.raise(key.start, "Classes may not have a static property named prototype");
    }

    // Parse value
    var value = method.value = this.parseMethod(isGenerator, isAsync, allowsDirectSuper);

    // Check value
    if (method.kind === "get" && value.params.length !== 0)
      { this.raiseRecoverable(value.start, "getter should have no params"); }
    if (method.kind === "set" && value.params.length !== 1)
      { this.raiseRecoverable(value.start, "setter should have exactly one param"); }
    if (method.kind === "set" && value.params[0].type === "RestElement")
      { this.raiseRecoverable(value.params[0].start, "Setter cannot use rest params"); }

    return this.finishNode(method, "MethodDefinition")
  };

  pp$8.parseClassField = function(field) {
    if (checkKeyName(field, "constructor")) {
      this.raise(field.key.start, "Classes can't have a field named 'constructor'");
    } else if (field.static && checkKeyName(field, "prototype")) {
      this.raise(field.key.start, "Classes can't have a static field named 'prototype'");
    }

    if (this.eat(types$1.eq)) {
      // To raise SyntaxError if 'arguments' exists in the initializer.
      this.enterScope(SCOPE_CLASS_FIELD_INIT | SCOPE_SUPER);
      field.value = this.parseMaybeAssign();
      this.exitScope();
    } else {
      field.value = null;
    }
    this.semicolon();

    return this.finishNode(field, "PropertyDefinition")
  };

  pp$8.parseClassStaticBlock = function(node) {
    node.body = [];

    var oldLabels = this.labels;
    this.labels = [];
    this.enterScope(SCOPE_CLASS_STATIC_BLOCK | SCOPE_SUPER);
    while (this.type !== types$1.braceR) {
      var stmt = this.parseStatement(null);
      node.body.push(stmt);
    }
    this.next();
    this.exitScope();
    this.labels = oldLabels;

    return this.finishNode(node, "StaticBlock")
  };

  pp$8.parseClassId = function(node, isStatement) {
    if (this.type === types$1.name) {
      node.id = this.parseIdent();
      if (isStatement)
        { this.checkLValSimple(node.id, BIND_LEXICAL, false); }
    } else {
      if (isStatement === true)
        { this.unexpected(); }
      node.id = null;
    }
  };

  pp$8.parseClassSuper = function(node) {
    node.superClass = this.eat(types$1._extends) ? this.parseExprSubscripts(null, false) : null;
  };

  pp$8.enterClassBody = function() {
    var element = {declared: Object.create(null), used: []};
    this.privateNameStack.push(element);
    return element.declared
  };

  pp$8.exitClassBody = function() {
    var ref = this.privateNameStack.pop();
    var declared = ref.declared;
    var used = ref.used;
    if (!this.options.checkPrivateFields) { return }
    var len = this.privateNameStack.length;
    var parent = len === 0 ? null : this.privateNameStack[len - 1];
    for (var i = 0; i < used.length; ++i) {
      var id = used[i];
      if (!hasOwn(declared, id.name)) {
        if (parent) {
          parent.used.push(id);
        } else {
          this.raiseRecoverable(id.start, ("Private field '#" + (id.name) + "' must be declared in an enclosing class"));
        }
      }
    }
  };

  function isPrivateNameConflicted(privateNameMap, element) {
    var name = element.key.name;
    var curr = privateNameMap[name];

    var next = "true";
    if (element.type === "MethodDefinition" && (element.kind === "get" || element.kind === "set")) {
      next = (element.static ? "s" : "i") + element.kind;
    }

    // `class { get #a(){}; static set #a(_){} }` is also conflict.
    if (
      curr === "iget" && next === "iset" ||
      curr === "iset" && next === "iget" ||
      curr === "sget" && next === "sset" ||
      curr === "sset" && next === "sget"
    ) {
      privateNameMap[name] = "true";
      return false
    } else if (!curr) {
      privateNameMap[name] = next;
      return false
    } else {
      return true
    }
  }

  function checkKeyName(node, name) {
    var computed = node.computed;
    var key = node.key;
    return !computed && (
      key.type === "Identifier" && key.name === name ||
      key.type === "Literal" && key.value === name
    )
  }

  // Parses module export declaration.

  pp$8.parseExportAllDeclaration = function(node, exports) {
    if (this.options.ecmaVersion >= 11) {
      if (this.eatContextual("as")) {
        node.exported = this.parseModuleExportName();
        this.checkExport(exports, node.exported, this.lastTokStart);
      } else {
        node.exported = null;
      }
    }
    this.expectContextual("from");
    if (this.type !== types$1.string) { this.unexpected(); }
    node.source = this.parseExprAtom();
    if (this.options.ecmaVersion >= 16)
      { node.attributes = this.parseWithClause(); }
    this.semicolon();
    return this.finishNode(node, "ExportAllDeclaration")
  };

  pp$8.parseExport = function(node, exports) {
    this.next();
    // export * from '...'
    if (this.eat(types$1.star)) {
      return this.parseExportAllDeclaration(node, exports)
    }
    if (this.eat(types$1._default)) { // export default ...
      this.checkExport(exports, "default", this.lastTokStart);
      node.declaration = this.parseExportDefaultDeclaration();
      return this.finishNode(node, "ExportDefaultDeclaration")
    }
    // export var|const|let|function|class ...
    if (this.shouldParseExportStatement()) {
      node.declaration = this.parseExportDeclaration(node);
      if (node.declaration.type === "VariableDeclaration")
        { this.checkVariableExport(exports, node.declaration.declarations); }
      else
        { this.checkExport(exports, node.declaration.id, node.declaration.id.start); }
      node.specifiers = [];
      node.source = null;
      if (this.options.ecmaVersion >= 16)
        { node.attributes = []; }
    } else { // export { x, y as z } [from '...']
      node.declaration = null;
      node.specifiers = this.parseExportSpecifiers(exports);
      if (this.eatContextual("from")) {
        if (this.type !== types$1.string) { this.unexpected(); }
        node.source = this.parseExprAtom();
        if (this.options.ecmaVersion >= 16)
          { node.attributes = this.parseWithClause(); }
      } else {
        for (var i = 0, list = node.specifiers; i < list.length; i += 1) {
          // check for keywords used as local names
          var spec = list[i];

          this.checkUnreserved(spec.local);
          // check if export is defined
          this.checkLocalExport(spec.local);

          if (spec.local.type === "Literal") {
            this.raise(spec.local.start, "A string literal cannot be used as an exported binding without `from`.");
          }
        }

        node.source = null;
        if (this.options.ecmaVersion >= 16)
          { node.attributes = []; }
      }
      this.semicolon();
    }
    return this.finishNode(node, "ExportNamedDeclaration")
  };

  pp$8.parseExportDeclaration = function(node) {
    return this.parseStatement(null)
  };

  pp$8.parseExportDefaultDeclaration = function() {
    var isAsync;
    if (this.type === types$1._function || (isAsync = this.isAsyncFunction())) {
      var fNode = this.startNode();
      this.next();
      if (isAsync) { this.next(); }
      return this.parseFunction(fNode, FUNC_STATEMENT | FUNC_NULLABLE_ID, false, isAsync)
    } else if (this.type === types$1._class) {
      var cNode = this.startNode();
      return this.parseClass(cNode, "nullableID")
    } else {
      var declaration = this.parseMaybeAssign();
      this.semicolon();
      return declaration
    }
  };

  pp$8.checkExport = function(exports, name, pos) {
    if (!exports) { return }
    if (typeof name !== "string")
      { name = name.type === "Identifier" ? name.name : name.value; }
    if (hasOwn(exports, name))
      { this.raiseRecoverable(pos, "Duplicate export '" + name + "'"); }
    exports[name] = true;
  };

  pp$8.checkPatternExport = function(exports, pat) {
    var type = pat.type;
    if (type === "Identifier")
      { this.checkExport(exports, pat, pat.start); }
    else if (type === "ObjectPattern")
      { for (var i = 0, list = pat.properties; i < list.length; i += 1)
        {
          var prop = list[i];

          this.checkPatternExport(exports, prop);
        } }
    else if (type === "ArrayPattern")
      { for (var i$1 = 0, list$1 = pat.elements; i$1 < list$1.length; i$1 += 1) {
        var elt = list$1[i$1];

          if (elt) { this.checkPatternExport(exports, elt); }
      } }
    else if (type === "Property")
      { this.checkPatternExport(exports, pat.value); }
    else if (type === "AssignmentPattern")
      { this.checkPatternExport(exports, pat.left); }
    else if (type === "RestElement")
      { this.checkPatternExport(exports, pat.argument); }
  };

  pp$8.checkVariableExport = function(exports, decls) {
    if (!exports) { return }
    for (var i = 0, list = decls; i < list.length; i += 1)
      {
      var decl = list[i];

      this.checkPatternExport(exports, decl.id);
    }
  };

  pp$8.shouldParseExportStatement = function() {
    return this.type.keyword === "var" ||
      this.type.keyword === "const" ||
      this.type.keyword === "class" ||
      this.type.keyword === "function" ||
      this.isLet() ||
      this.isAsyncFunction()
  };

  // Parses a comma-separated list of module exports.

  pp$8.parseExportSpecifier = function(exports) {
    var node = this.startNode();
    node.local = this.parseModuleExportName();

    node.exported = this.eatContextual("as") ? this.parseModuleExportName() : node.local;
    this.checkExport(
      exports,
      node.exported,
      node.exported.start
    );

    return this.finishNode(node, "ExportSpecifier")
  };

  pp$8.parseExportSpecifiers = function(exports) {
    var nodes = [], first = true;
    // export { x, y as z } [from '...']
    this.expect(types$1.braceL);
    while (!this.eat(types$1.braceR)) {
      if (!first) {
        this.expect(types$1.comma);
        if (this.afterTrailingComma(types$1.braceR)) { break }
      } else { first = false; }

      nodes.push(this.parseExportSpecifier(exports));
    }
    return nodes
  };

  // Parses import declaration.

  pp$8.parseImport = function(node) {
    this.next();

    // import '...'
    if (this.type === types$1.string) {
      node.specifiers = empty$1;
      node.source = this.parseExprAtom();
    } else {
      node.specifiers = this.parseImportSpecifiers();
      this.expectContextual("from");
      node.source = this.type === types$1.string ? this.parseExprAtom() : this.unexpected();
    }
    if (this.options.ecmaVersion >= 16)
      { node.attributes = this.parseWithClause(); }
    this.semicolon();
    return this.finishNode(node, "ImportDeclaration")
  };

  // Parses a comma-separated list of module imports.

  pp$8.parseImportSpecifier = function() {
    var node = this.startNode();
    node.imported = this.parseModuleExportName();

    if (this.eatContextual("as")) {
      node.local = this.parseIdent();
    } else {
      this.checkUnreserved(node.imported);
      node.local = node.imported;
    }
    this.checkLValSimple(node.local, BIND_LEXICAL);

    return this.finishNode(node, "ImportSpecifier")
  };

  pp$8.parseImportDefaultSpecifier = function() {
    // import defaultObj, { x, y as z } from '...'
    var node = this.startNode();
    node.local = this.parseIdent();
    this.checkLValSimple(node.local, BIND_LEXICAL);
    return this.finishNode(node, "ImportDefaultSpecifier")
  };

  pp$8.parseImportNamespaceSpecifier = function() {
    var node = this.startNode();
    this.next();
    this.expectContextual("as");
    node.local = this.parseIdent();
    this.checkLValSimple(node.local, BIND_LEXICAL);
    return this.finishNode(node, "ImportNamespaceSpecifier")
  };

  pp$8.parseImportSpecifiers = function() {
    var nodes = [], first = true;
    if (this.type === types$1.name) {
      nodes.push(this.parseImportDefaultSpecifier());
      if (!this.eat(types$1.comma)) { return nodes }
    }
    if (this.type === types$1.star) {
      nodes.push(this.parseImportNamespaceSpecifier());
      return nodes
    }
    this.expect(types$1.braceL);
    while (!this.eat(types$1.braceR)) {
      if (!first) {
        this.expect(types$1.comma);
        if (this.afterTrailingComma(types$1.braceR)) { break }
      } else { first = false; }

      nodes.push(this.parseImportSpecifier());
    }
    return nodes
  };

  pp$8.parseWithClause = function() {
    var nodes = [];
    if (!this.eat(types$1._with)) {
      return nodes
    }
    this.expect(types$1.braceL);
    var attributeKeys = {};
    var first = true;
    while (!this.eat(types$1.braceR)) {
      if (!first) {
        this.expect(types$1.comma);
        if (this.afterTrailingComma(types$1.braceR)) { break }
      } else { first = false; }

      var attr = this.parseImportAttribute();
      var keyName = attr.key.type === "Identifier" ? attr.key.name : attr.key.value;
      if (hasOwn(attributeKeys, keyName))
        { this.raiseRecoverable(attr.key.start, "Duplicate attribute key '" + keyName + "'"); }
      attributeKeys[keyName] = true;
      nodes.push(attr);
    }
    return nodes
  };

  pp$8.parseImportAttribute = function() {
    var node = this.startNode();
    node.key = this.type === types$1.string ? this.parseExprAtom() : this.parseIdent(this.options.allowReserved !== "never");
    this.expect(types$1.colon);
    if (this.type !== types$1.string) {
      this.unexpected();
    }
    node.value = this.parseExprAtom();
    return this.finishNode(node, "ImportAttribute")
  };

  pp$8.parseModuleExportName = function() {
    if (this.options.ecmaVersion >= 13 && this.type === types$1.string) {
      var stringLiteral = this.parseLiteral(this.value);
      if (loneSurrogate.test(stringLiteral.value)) {
        this.raise(stringLiteral.start, "An export name cannot include a lone surrogate.");
      }
      return stringLiteral
    }
    return this.parseIdent(true)
  };

  // Set `ExpressionStatement#directive` property for directive prologues.
  pp$8.adaptDirectivePrologue = function(statements) {
    for (var i = 0; i < statements.length && this.isDirectiveCandidate(statements[i]); ++i) {
      statements[i].directive = statements[i].expression.raw.slice(1, -1);
    }
  };
  pp$8.isDirectiveCandidate = function(statement) {
    return (
      this.options.ecmaVersion >= 5 &&
      statement.type === "ExpressionStatement" &&
      statement.expression.type === "Literal" &&
      typeof statement.expression.value === "string" &&
      // Reject parenthesized strings.
      (this.input[statement.start] === "\"" || this.input[statement.start] === "'")
    )
  };

  var pp$7 = Parser.prototype;

  // Convert existing expression atom to assignable pattern
  // if possible.

  pp$7.toAssignable = function(node, isBinding, refDestructuringErrors) {
    if (this.options.ecmaVersion >= 6 && node) {
      switch (node.type) {
      case "Identifier":
        if (this.inAsync && node.name === "await")
          { this.raise(node.start, "Cannot use 'await' as identifier inside an async function"); }
        break

      case "ObjectPattern":
      case "ArrayPattern":
      case "AssignmentPattern":
      case "RestElement":
        break

      case "ObjectExpression":
        node.type = "ObjectPattern";
        if (refDestructuringErrors) { this.checkPatternErrors(refDestructuringErrors, true); }
        for (var i = 0, list = node.properties; i < list.length; i += 1) {
          var prop = list[i];

        this.toAssignable(prop, isBinding);
          // Early error:
          //   AssignmentRestProperty[Yield, Await] :
          //     `...` DestructuringAssignmentTarget[Yield, Await]
          //
          //   It is a Syntax Error if |DestructuringAssignmentTarget| is an |ArrayLiteral| or an |ObjectLiteral|.
          if (
            prop.type === "RestElement" &&
            (prop.argument.type === "ArrayPattern" || prop.argument.type === "ObjectPattern")
          ) {
            this.raise(prop.argument.start, "Unexpected token");
          }
        }
        break

      case "Property":
        // AssignmentProperty has type === "Property"
        if (node.kind !== "init") { this.raise(node.key.start, "Object pattern can't contain getter or setter"); }
        this.toAssignable(node.value, isBinding);
        break

      case "ArrayExpression":
        node.type = "ArrayPattern";
        if (refDestructuringErrors) { this.checkPatternErrors(refDestructuringErrors, true); }
        this.toAssignableList(node.elements, isBinding);
        break

      case "SpreadElement":
        node.type = "RestElement";
        this.toAssignable(node.argument, isBinding);
        if (node.argument.type === "AssignmentPattern")
          { this.raise(node.argument.start, "Rest elements cannot have a default value"); }
        break

      case "AssignmentExpression":
        if (node.operator !== "=") { this.raise(node.left.end, "Only '=' operator can be used for specifying default value."); }
        node.type = "AssignmentPattern";
        delete node.operator;
        this.toAssignable(node.left, isBinding);
        break

      case "ParenthesizedExpression":
        this.toAssignable(node.expression, isBinding, refDestructuringErrors);
        break

      case "ChainExpression":
        this.raiseRecoverable(node.start, "Optional chaining cannot appear in left-hand side");
        break

      case "MemberExpression":
        if (!isBinding) { break }

      default:
        this.raise(node.start, "Assigning to rvalue");
      }
    } else if (refDestructuringErrors) { this.checkPatternErrors(refDestructuringErrors, true); }
    return node
  };

  // Convert list of expression atoms to binding list.

  pp$7.toAssignableList = function(exprList, isBinding) {
    var end = exprList.length;
    for (var i = 0; i < end; i++) {
      var elt = exprList[i];
      if (elt) { this.toAssignable(elt, isBinding); }
    }
    if (end) {
      var last = exprList[end - 1];
      if (this.options.ecmaVersion === 6 && isBinding && last && last.type === "RestElement" && last.argument.type !== "Identifier")
        { this.unexpected(last.argument.start); }
    }
    return exprList
  };

  // Parses spread element.

  pp$7.parseSpread = function(refDestructuringErrors) {
    var node = this.startNode();
    this.next();
    node.argument = this.parseMaybeAssign(false, refDestructuringErrors);
    return this.finishNode(node, "SpreadElement")
  };

  pp$7.parseRestBinding = function() {
    var node = this.startNode();
    this.next();

    // RestElement inside of a function parameter must be an identifier
    if (this.options.ecmaVersion === 6 && this.type !== types$1.name)
      { this.unexpected(); }

    node.argument = this.parseBindingAtom();

    return this.finishNode(node, "RestElement")
  };

  // Parses lvalue (assignable) atom.

  pp$7.parseBindingAtom = function() {
    if (this.options.ecmaVersion >= 6) {
      switch (this.type) {
      case types$1.bracketL:
        var node = this.startNode();
        this.next();
        node.elements = this.parseBindingList(types$1.bracketR, true, true);
        return this.finishNode(node, "ArrayPattern")

      case types$1.braceL:
        return this.parseObj(true)
      }
    }
    return this.parseIdent()
  };

  pp$7.parseBindingList = function(close, allowEmpty, allowTrailingComma, allowModifiers) {
    var elts = [], first = true;
    while (!this.eat(close)) {
      if (first) { first = false; }
      else { this.expect(types$1.comma); }
      if (allowEmpty && this.type === types$1.comma) {
        elts.push(null);
      } else if (allowTrailingComma && this.afterTrailingComma(close)) {
        break
      } else if (this.type === types$1.ellipsis) {
        var rest = this.parseRestBinding();
        this.parseBindingListItem(rest);
        elts.push(rest);
        if (this.type === types$1.comma) { this.raiseRecoverable(this.start, "Comma is not permitted after the rest element"); }
        this.expect(close);
        break
      } else {
        elts.push(this.parseAssignableListItem(allowModifiers));
      }
    }
    return elts
  };

  pp$7.parseAssignableListItem = function(allowModifiers) {
    var elem = this.parseMaybeDefault(this.start, this.startLoc);
    this.parseBindingListItem(elem);
    return elem
  };

  pp$7.parseBindingListItem = function(param) {
    return param
  };

  // Parses assignment pattern around given atom if possible.

  pp$7.parseMaybeDefault = function(startPos, startLoc, left) {
    left = left || this.parseBindingAtom();
    if (this.options.ecmaVersion < 6 || !this.eat(types$1.eq)) { return left }
    var node = this.startNodeAt(startPos, startLoc);
    node.left = left;
    node.right = this.parseMaybeAssign();
    return this.finishNode(node, "AssignmentPattern")
  };

  // The following three functions all verify that a node is an lvalue —
  // something that can be bound, or assigned to. In order to do so, they perform
  // a variety of checks:
  //
  // - Check that none of the bound/assigned-to identifiers are reserved words.
  // - Record name declarations for bindings in the appropriate scope.
  // - Check duplicate argument names, if checkClashes is set.
  //
  // If a complex binding pattern is encountered (e.g., object and array
  // destructuring), the entire pattern is recursively checked.
  //
  // There are three versions of checkLVal*() appropriate for different
  // circumstances:
  //
  // - checkLValSimple() shall be used if the syntactic construct supports
  //   nothing other than identifiers and member expressions. Parenthesized
  //   expressions are also correctly handled. This is generally appropriate for
  //   constructs for which the spec says
  //
  //   > It is a Syntax Error if AssignmentTargetType of [the production] is not
  //   > simple.
  //
  //   It is also appropriate for checking if an identifier is valid and not
  //   defined elsewhere, like import declarations or function/class identifiers.
  //
  //   Examples where this is used include:
  //     a += …;
  //     import a from '…';
  //   where a is the node to be checked.
  //
  // - checkLValPattern() shall be used if the syntactic construct supports
  //   anything checkLValSimple() supports, as well as object and array
  //   destructuring patterns. This is generally appropriate for constructs for
  //   which the spec says
  //
  //   > It is a Syntax Error if [the production] is neither an ObjectLiteral nor
  //   > an ArrayLiteral and AssignmentTargetType of [the production] is not
  //   > simple.
  //
  //   Examples where this is used include:
  //     (a = …);
  //     const a = …;
  //     try { … } catch (a) { … }
  //   where a is the node to be checked.
  //
  // - checkLValInnerPattern() shall be used if the syntactic construct supports
  //   anything checkLValPattern() supports, as well as default assignment
  //   patterns, rest elements, and other constructs that may appear within an
  //   object or array destructuring pattern.
  //
  //   As a special case, function parameters also use checkLValInnerPattern(),
  //   as they also support defaults and rest constructs.
  //
  // These functions deliberately support both assignment and binding constructs,
  // as the logic for both is exceedingly similar. If the node is the target of
  // an assignment, then bindingType should be set to BIND_NONE. Otherwise, it
  // should be set to the appropriate BIND_* constant, like BIND_VAR or
  // BIND_LEXICAL.
  //
  // If the function is called with a non-BIND_NONE bindingType, then
  // additionally a checkClashes object may be specified to allow checking for
  // duplicate argument names. checkClashes is ignored if the provided construct
  // is an assignment (i.e., bindingType is BIND_NONE).

  pp$7.checkLValSimple = function(expr, bindingType, checkClashes) {
    if ( bindingType === void 0 ) bindingType = BIND_NONE;

    var isBind = bindingType !== BIND_NONE;

    switch (expr.type) {
    case "Identifier":
      if (this.strict && this.reservedWordsStrictBind.test(expr.name))
        { this.raiseRecoverable(expr.start, (isBind ? "Binding " : "Assigning to ") + expr.name + " in strict mode"); }
      if (isBind) {
        if (bindingType === BIND_LEXICAL && expr.name === "let")
          { this.raiseRecoverable(expr.start, "let is disallowed as a lexically bound name"); }
        if (checkClashes) {
          if (hasOwn(checkClashes, expr.name))
            { this.raiseRecoverable(expr.start, "Argument name clash"); }
          checkClashes[expr.name] = true;
        }
        if (bindingType !== BIND_OUTSIDE) { this.declareName(expr.name, bindingType, expr.start); }
      }
      break

    case "ChainExpression":
      this.raiseRecoverable(expr.start, "Optional chaining cannot appear in left-hand side");
      break

    case "MemberExpression":
      if (isBind) { this.raiseRecoverable(expr.start, "Binding member expression"); }
      break

    case "ParenthesizedExpression":
      if (isBind) { this.raiseRecoverable(expr.start, "Binding parenthesized expression"); }
      return this.checkLValSimple(expr.expression, bindingType, checkClashes)

    default:
      this.raise(expr.start, (isBind ? "Binding" : "Assigning to") + " rvalue");
    }
  };

  pp$7.checkLValPattern = function(expr, bindingType, checkClashes) {
    if ( bindingType === void 0 ) bindingType = BIND_NONE;

    switch (expr.type) {
    case "ObjectPattern":
      for (var i = 0, list = expr.properties; i < list.length; i += 1) {
        var prop = list[i];

      this.checkLValInnerPattern(prop, bindingType, checkClashes);
      }
      break

    case "ArrayPattern":
      for (var i$1 = 0, list$1 = expr.elements; i$1 < list$1.length; i$1 += 1) {
        var elem = list$1[i$1];

      if (elem) { this.checkLValInnerPattern(elem, bindingType, checkClashes); }
      }
      break

    default:
      this.checkLValSimple(expr, bindingType, checkClashes);
    }
  };

  pp$7.checkLValInnerPattern = function(expr, bindingType, checkClashes) {
    if ( bindingType === void 0 ) bindingType = BIND_NONE;

    switch (expr.type) {
    case "Property":
      // AssignmentProperty has type === "Property"
      this.checkLValInnerPattern(expr.value, bindingType, checkClashes);
      break

    case "AssignmentPattern":
      this.checkLValPattern(expr.left, bindingType, checkClashes);
      break

    case "RestElement":
      this.checkLValPattern(expr.argument, bindingType, checkClashes);
      break

    default:
      this.checkLValPattern(expr, bindingType, checkClashes);
    }
  };

  // The algorithm used to determine whether a regexp can appear at a
  // given point in the program is loosely based on sweet.js' approach.
  // See https://github.com/mozilla/sweet.js/wiki/design


  var TokContext = function TokContext(token, isExpr, preserveSpace, override, generator) {
    this.token = token;
    this.isExpr = !!isExpr;
    this.preserveSpace = !!preserveSpace;
    this.override = override;
    this.generator = !!generator;
  };

  var types = {
    b_stat: new TokContext("{", false),
    b_expr: new TokContext("{", true),
    b_tmpl: new TokContext("${", false),
    p_stat: new TokContext("(", false),
    p_expr: new TokContext("(", true),
    q_tmpl: new TokContext("`", true, true, function (p) { return p.tryReadTemplateToken(); }),
    f_stat: new TokContext("function", false),
    f_expr: new TokContext("function", true),
    f_expr_gen: new TokContext("function", true, false, null, true),
    f_gen: new TokContext("function", false, false, null, true)
  };

  var pp$6 = Parser.prototype;

  pp$6.initialContext = function() {
    return [types.b_stat]
  };

  pp$6.curContext = function() {
    return this.context[this.context.length - 1]
  };

  pp$6.braceIsBlock = function(prevType) {
    var parent = this.curContext();
    if (parent === types.f_expr || parent === types.f_stat)
      { return true }
    if (prevType === types$1.colon && (parent === types.b_stat || parent === types.b_expr))
      { return !parent.isExpr }

    // The check for `tt.name && exprAllowed` detects whether we are
    // after a `yield` or `of` construct. See the `updateContext` for
    // `tt.name`.
    if (prevType === types$1._return || prevType === types$1.name && this.exprAllowed)
      { return lineBreak.test(this.input.slice(this.lastTokEnd, this.start)) }
    if (prevType === types$1._else || prevType === types$1.semi || prevType === types$1.eof || prevType === types$1.parenR || prevType === types$1.arrow)
      { return true }
    if (prevType === types$1.braceL)
      { return parent === types.b_stat }
    if (prevType === types$1._var || prevType === types$1._const || prevType === types$1.name)
      { return false }
    return !this.exprAllowed
  };

  pp$6.inGeneratorContext = function() {
    for (var i = this.context.length - 1; i >= 1; i--) {
      var context = this.context[i];
      if (context.token === "function")
        { return context.generator }
    }
    return false
  };

  pp$6.updateContext = function(prevType) {
    var update, type = this.type;
    if (type.keyword && prevType === types$1.dot)
      { this.exprAllowed = false; }
    else if (update = type.updateContext)
      { update.call(this, prevType); }
    else
      { this.exprAllowed = type.beforeExpr; }
  };

  // Used to handle edge cases when token context could not be inferred correctly during tokenization phase

  pp$6.overrideContext = function(tokenCtx) {
    if (this.curContext() !== tokenCtx) {
      this.context[this.context.length - 1] = tokenCtx;
    }
  };

  // Token-specific context update code

  types$1.parenR.updateContext = types$1.braceR.updateContext = function() {
    if (this.context.length === 1) {
      this.exprAllowed = true;
      return
    }
    var out = this.context.pop();
    if (out === types.b_stat && this.curContext().token === "function") {
      out = this.context.pop();
    }
    this.exprAllowed = !out.isExpr;
  };

  types$1.braceL.updateContext = function(prevType) {
    this.context.push(this.braceIsBlock(prevType) ? types.b_stat : types.b_expr);
    this.exprAllowed = true;
  };

  types$1.dollarBraceL.updateContext = function() {
    this.context.push(types.b_tmpl);
    this.exprAllowed = true;
  };

  types$1.parenL.updateContext = function(prevType) {
    var statementParens = prevType === types$1._if || prevType === types$1._for || prevType === types$1._with || prevType === types$1._while;
    this.context.push(statementParens ? types.p_stat : types.p_expr);
    this.exprAllowed = true;
  };

  types$1.incDec.updateContext = function() {
    // tokExprAllowed stays unchanged
  };

  types$1._function.updateContext = types$1._class.updateContext = function(prevType) {
    if (prevType.beforeExpr && prevType !== types$1._else &&
        !(prevType === types$1.semi && this.curContext() !== types.p_stat) &&
        !(prevType === types$1._return && lineBreak.test(this.input.slice(this.lastTokEnd, this.start))) &&
        !((prevType === types$1.colon || prevType === types$1.braceL) && this.curContext() === types.b_stat))
      { this.context.push(types.f_expr); }
    else
      { this.context.push(types.f_stat); }
    this.exprAllowed = false;
  };

  types$1.colon.updateContext = function() {
    if (this.curContext().token === "function") { this.context.pop(); }
    this.exprAllowed = true;
  };

  types$1.backQuote.updateContext = function() {
    if (this.curContext() === types.q_tmpl)
      { this.context.pop(); }
    else
      { this.context.push(types.q_tmpl); }
    this.exprAllowed = false;
  };

  types$1.star.updateContext = function(prevType) {
    if (prevType === types$1._function) {
      var index = this.context.length - 1;
      if (this.context[index] === types.f_expr)
        { this.context[index] = types.f_expr_gen; }
      else
        { this.context[index] = types.f_gen; }
    }
    this.exprAllowed = true;
  };

  types$1.name.updateContext = function(prevType) {
    var allowed = false;
    if (this.options.ecmaVersion >= 6 && prevType !== types$1.dot) {
      if (this.value === "of" && !this.exprAllowed ||
          this.value === "yield" && this.inGeneratorContext())
        { allowed = true; }
    }
    this.exprAllowed = allowed;
  };

  // A recursive descent parser operates by defining functions for all
  // syntactic elements, and recursively calling those, each function
  // advancing the input stream and returning an AST node. Precedence
  // of constructs (for example, the fact that `!x[1]` means `!(x[1])`
  // instead of `(!x)[1]` is handled by the fact that the parser
  // function that parses unary prefix operators is called first, and
  // in turn calls the function that parses `[]` subscripts — that
  // way, it'll receive the node for `x[1]` already parsed, and wraps
  // *that* in the unary operator node.
  //
  // Acorn uses an [operator precedence parser][opp] to handle binary
  // operator precedence, because it is much more compact than using
  // the technique outlined above, which uses different, nesting
  // functions to specify precedence, for all of the ten binary
  // precedence levels that JavaScript defines.
  //
  // [opp]: http://en.wikipedia.org/wiki/Operator-precedence_parser


  var pp$5 = Parser.prototype;

  // Check if property name clashes with already added.
  // Object/class getters and setters are not allowed to clash —
  // either with each other or with an init property — and in
  // strict mode, init properties are also not allowed to be repeated.

  pp$5.checkPropClash = function(prop, propHash, refDestructuringErrors) {
    if (this.options.ecmaVersion >= 9 && prop.type === "SpreadElement")
      { return }
    if (this.options.ecmaVersion >= 6 && (prop.computed || prop.method || prop.shorthand))
      { return }
    var key = prop.key;
    var name;
    switch (key.type) {
    case "Identifier": name = key.name; break
    case "Literal": name = String(key.value); break
    default: return
    }
    var kind = prop.kind;
    if (this.options.ecmaVersion >= 6) {
      if (name === "__proto__" && kind === "init") {
        if (propHash.proto) {
          if (refDestructuringErrors) {
            if (refDestructuringErrors.doubleProto < 0) {
              refDestructuringErrors.doubleProto = key.start;
            }
          } else {
            this.raiseRecoverable(key.start, "Redefinition of __proto__ property");
          }
        }
        propHash.proto = true;
      }
      return
    }
    name = "$" + name;
    var other = propHash[name];
    if (other) {
      var redefinition;
      if (kind === "init") {
        redefinition = this.strict && other.init || other.get || other.set;
      } else {
        redefinition = other.init || other[kind];
      }
      if (redefinition)
        { this.raiseRecoverable(key.start, "Redefinition of property"); }
    } else {
      other = propHash[name] = {
        init: false,
        get: false,
        set: false
      };
    }
    other[kind] = true;
  };

  // ### Expression parsing

  // These nest, from the most general expression type at the top to
  // 'atomic', nondivisible expression types at the bottom. Most of
  // the functions will simply let the function(s) below them parse,
  // and, *if* the syntactic construct they handle is present, wrap
  // the AST node that the inner parser gave them in another node.

  // Parse a full expression. The optional arguments are used to
  // forbid the `in` operator (in for loops initalization expressions)
  // and provide reference for storing '=' operator inside shorthand
  // property assignment in contexts where both object expression
  // and object pattern might appear (so it's possible to raise
  // delayed syntax error at correct position).

  pp$5.parseExpression = function(forInit, refDestructuringErrors) {
    var startPos = this.start, startLoc = this.startLoc;
    var expr = this.parseMaybeAssign(forInit, refDestructuringErrors);
    if (this.type === types$1.comma) {
      var node = this.startNodeAt(startPos, startLoc);
      node.expressions = [expr];
      while (this.eat(types$1.comma)) { node.expressions.push(this.parseMaybeAssign(forInit, refDestructuringErrors)); }
      return this.finishNode(node, "SequenceExpression")
    }
    return expr
  };

  // Parse an assignment expression. This includes applications of
  // operators like `+=`.

  pp$5.parseMaybeAssign = function(forInit, refDestructuringErrors, afterLeftParse) {
    if (this.isContextual("yield")) {
      if (this.inGenerator) { return this.parseYield(forInit) }
      // The tokenizer will assume an expression is allowed after
      // `yield`, but this isn't that kind of yield
      else { this.exprAllowed = false; }
    }

    var ownDestructuringErrors = false, oldParenAssign = -1, oldTrailingComma = -1, oldDoubleProto = -1;
    if (refDestructuringErrors) {
      oldParenAssign = refDestructuringErrors.parenthesizedAssign;
      oldTrailingComma = refDestructuringErrors.trailingComma;
      oldDoubleProto = refDestructuringErrors.doubleProto;
      refDestructuringErrors.parenthesizedAssign = refDestructuringErrors.trailingComma = -1;
    } else {
      refDestructuringErrors = new DestructuringErrors;
      ownDestructuringErrors = true;
    }

    var startPos = this.start, startLoc = this.startLoc;
    if (this.type === types$1.parenL || this.type === types$1.name) {
      this.potentialArrowAt = this.start;
      this.potentialArrowInForAwait = forInit === "await";
    }
    var left = this.parseMaybeConditional(forInit, refDestructuringErrors);
    if (afterLeftParse) { left = afterLeftParse.call(this, left, startPos, startLoc); }
    if (this.type.isAssign) {
      var node = this.startNodeAt(startPos, startLoc);
      node.operator = this.value;
      if (this.type === types$1.eq)
        { left = this.toAssignable(left, false, refDestructuringErrors); }
      if (!ownDestructuringErrors) {
        refDestructuringErrors.parenthesizedAssign = refDestructuringErrors.trailingComma = refDestructuringErrors.doubleProto = -1;
      }
      if (refDestructuringErrors.shorthandAssign >= left.start)
        { refDestructuringErrors.shorthandAssign = -1; } // reset because shorthand default was used correctly
      if (this.type === types$1.eq)
        { this.checkLValPattern(left); }
      else
        { this.checkLValSimple(left); }
      node.left = left;
      this.next();
      node.right = this.parseMaybeAssign(forInit);
      if (oldDoubleProto > -1) { refDestructuringErrors.doubleProto = oldDoubleProto; }
      return this.finishNode(node, "AssignmentExpression")
    } else {
      if (ownDestructuringErrors) { this.checkExpressionErrors(refDestructuringErrors, true); }
    }
    if (oldParenAssign > -1) { refDestructuringErrors.parenthesizedAssign = oldParenAssign; }
    if (oldTrailingComma > -1) { refDestructuringErrors.trailingComma = oldTrailingComma; }
    return left
  };

  // Parse a ternary conditional (`?:`) operator.

  pp$5.parseMaybeConditional = function(forInit, refDestructuringErrors) {
    var startPos = this.start, startLoc = this.startLoc;
    var expr = this.parseExprOps(forInit, refDestructuringErrors);
    if (this.checkExpressionErrors(refDestructuringErrors)) { return expr }
    if (this.eat(types$1.question)) {
      var node = this.startNodeAt(startPos, startLoc);
      node.test = expr;
      node.consequent = this.parseMaybeAssign();
      this.expect(types$1.colon);
      node.alternate = this.parseMaybeAssign(forInit);
      return this.finishNode(node, "ConditionalExpression")
    }
    return expr
  };

  // Start the precedence parser.

  pp$5.parseExprOps = function(forInit, refDestructuringErrors) {
    var startPos = this.start, startLoc = this.startLoc;
    var expr = this.parseMaybeUnary(refDestructuringErrors, false, false, forInit);
    if (this.checkExpressionErrors(refDestructuringErrors)) { return expr }
    return expr.start === startPos && expr.type === "ArrowFunctionExpression" ? expr : this.parseExprOp(expr, startPos, startLoc, -1, forInit)
  };

  // Parse binary operators with the operator precedence parsing
  // algorithm. `left` is the left-hand side of the operator.
  // `minPrec` provides context that allows the function to stop and
  // defer further parser to one of its callers when it encounters an
  // operator that has a lower precedence than the set it is parsing.

  pp$5.parseExprOp = function(left, leftStartPos, leftStartLoc, minPrec, forInit) {
    var prec = this.type.binop;
    if (prec != null && (!forInit || this.type !== types$1._in)) {
      if (prec > minPrec) {
        var logical = this.type === types$1.logicalOR || this.type === types$1.logicalAND;
        var coalesce = this.type === types$1.coalesce;
        if (coalesce) {
          // Handle the precedence of `tt.coalesce` as equal to the range of logical expressions.
          // In other words, `node.right` shouldn't contain logical expressions in order to check the mixed error.
          prec = types$1.logicalAND.binop;
        }
        var op = this.value;
        this.next();
        var startPos = this.start, startLoc = this.startLoc;
        var right = this.parseExprOp(this.parseMaybeUnary(null, false, false, forInit), startPos, startLoc, prec, forInit);
        var node = this.buildBinary(leftStartPos, leftStartLoc, left, right, op, logical || coalesce);
        if ((logical && this.type === types$1.coalesce) || (coalesce && (this.type === types$1.logicalOR || this.type === types$1.logicalAND))) {
          this.raiseRecoverable(this.start, "Logical expressions and coalesce expressions cannot be mixed. Wrap either by parentheses");
        }
        return this.parseExprOp(node, leftStartPos, leftStartLoc, minPrec, forInit)
      }
    }
    return left
  };

  pp$5.buildBinary = function(startPos, startLoc, left, right, op, logical) {
    if (right.type === "PrivateIdentifier") { this.raise(right.start, "Private identifier can only be left side of binary expression"); }
    var node = this.startNodeAt(startPos, startLoc);
    node.left = left;
    node.operator = op;
    node.right = right;
    return this.finishNode(node, logical ? "LogicalExpression" : "BinaryExpression")
  };

  // Parse unary operators, both prefix and postfix.

  pp$5.parseMaybeUnary = function(refDestructuringErrors, sawUnary, incDec, forInit) {
    var startPos = this.start, startLoc = this.startLoc, expr;
    if (this.isContextual("await") && this.canAwait) {
      expr = this.parseAwait(forInit);
      sawUnary = true;
    } else if (this.type.prefix) {
      var node = this.startNode(), update = this.type === types$1.incDec;
      node.operator = this.value;
      node.prefix = true;
      this.next();
      node.argument = this.parseMaybeUnary(null, true, update, forInit);
      this.checkExpressionErrors(refDestructuringErrors, true);
      if (update) { this.checkLValSimple(node.argument); }
      else if (this.strict && node.operator === "delete" && isLocalVariableAccess(node.argument))
        { this.raiseRecoverable(node.start, "Deleting local variable in strict mode"); }
      else if (node.operator === "delete" && isPrivateFieldAccess(node.argument))
        { this.raiseRecoverable(node.start, "Private fields can not be deleted"); }
      else { sawUnary = true; }
      expr = this.finishNode(node, update ? "UpdateExpression" : "UnaryExpression");
    } else if (!sawUnary && this.type === types$1.privateId) {
      if ((forInit || this.privateNameStack.length === 0) && this.options.checkPrivateFields) { this.unexpected(); }
      expr = this.parsePrivateIdent();
      // only could be private fields in 'in', such as #x in obj
      if (this.type !== types$1._in) { this.unexpected(); }
    } else {
      expr = this.parseExprSubscripts(refDestructuringErrors, forInit);
      if (this.checkExpressionErrors(refDestructuringErrors)) { return expr }
      while (this.type.postfix && !this.canInsertSemicolon()) {
        var node$1 = this.startNodeAt(startPos, startLoc);
        node$1.operator = this.value;
        node$1.prefix = false;
        node$1.argument = expr;
        this.checkLValSimple(expr);
        this.next();
        expr = this.finishNode(node$1, "UpdateExpression");
      }
    }

    if (!incDec && this.eat(types$1.starstar)) {
      if (sawUnary)
        { this.unexpected(this.lastTokStart); }
      else
        { return this.buildBinary(startPos, startLoc, expr, this.parseMaybeUnary(null, false, false, forInit), "**", false) }
    } else {
      return expr
    }
  };

  function isLocalVariableAccess(node) {
    return (
      node.type === "Identifier" ||
      node.type === "ParenthesizedExpression" && isLocalVariableAccess(node.expression)
    )
  }

  function isPrivateFieldAccess(node) {
    return (
      node.type === "MemberExpression" && node.property.type === "PrivateIdentifier" ||
      node.type === "ChainExpression" && isPrivateFieldAccess(node.expression) ||
      node.type === "ParenthesizedExpression" && isPrivateFieldAccess(node.expression)
    )
  }

  // Parse call, dot, and `[]`-subscript expressions.

  pp$5.parseExprSubscripts = function(refDestructuringErrors, forInit) {
    var startPos = this.start, startLoc = this.startLoc;
    var expr = this.parseExprAtom(refDestructuringErrors, forInit);
    if (expr.type === "ArrowFunctionExpression" && this.input.slice(this.lastTokStart, this.lastTokEnd) !== ")")
      { return expr }
    var result = this.parseSubscripts(expr, startPos, startLoc, false, forInit);
    if (refDestructuringErrors && result.type === "MemberExpression") {
      if (refDestructuringErrors.parenthesizedAssign >= result.start) { refDestructuringErrors.parenthesizedAssign = -1; }
      if (refDestructuringErrors.parenthesizedBind >= result.start) { refDestructuringErrors.parenthesizedBind = -1; }
      if (refDestructuringErrors.trailingComma >= result.start) { refDestructuringErrors.trailingComma = -1; }
    }
    return result
  };

  pp$5.parseSubscripts = function(base, startPos, startLoc, noCalls, forInit) {
    var maybeAsyncArrow = this.options.ecmaVersion >= 8 && base.type === "Identifier" && base.name === "async" &&
        this.lastTokEnd === base.end && !this.canInsertSemicolon() && base.end - base.start === 5 &&
        this.potentialArrowAt === base.start;
    var optionalChained = false;

    while (true) {
      var element = this.parseSubscript(base, startPos, startLoc, noCalls, maybeAsyncArrow, optionalChained, forInit);

      if (element.optional) { optionalChained = true; }
      if (element === base || element.type === "ArrowFunctionExpression") {
        if (optionalChained) {
          var chainNode = this.startNodeAt(startPos, startLoc);
          chainNode.expression = element;
          element = this.finishNode(chainNode, "ChainExpression");
        }
        return element
      }

      base = element;
    }
  };

  pp$5.shouldParseAsyncArrow = function() {
    return !this.canInsertSemicolon() && this.eat(types$1.arrow)
  };

  pp$5.parseSubscriptAsyncArrow = function(startPos, startLoc, exprList, forInit) {
    return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), exprList, true, forInit)
  };

  pp$5.parseSubscript = function(base, startPos, startLoc, noCalls, maybeAsyncArrow, optionalChained, forInit) {
    var optionalSupported = this.options.ecmaVersion >= 11;
    var optional = optionalSupported && this.eat(types$1.questionDot);
    if (noCalls && optional) { this.raise(this.lastTokStart, "Optional chaining cannot appear in the callee of new expressions"); }

    var computed = this.eat(types$1.bracketL);
    if (computed || (optional && this.type !== types$1.parenL && this.type !== types$1.backQuote) || this.eat(types$1.dot)) {
      var node = this.startNodeAt(startPos, startLoc);
      node.object = base;
      if (computed) {
        node.property = this.parseExpression();
        this.expect(types$1.bracketR);
      } else if (this.type === types$1.privateId && base.type !== "Super") {
        node.property = this.parsePrivateIdent();
      } else {
        node.property = this.parseIdent(this.options.allowReserved !== "never");
      }
      node.computed = !!computed;
      if (optionalSupported) {
        node.optional = optional;
      }
      base = this.finishNode(node, "MemberExpression");
    } else if (!noCalls && this.eat(types$1.parenL)) {
      var refDestructuringErrors = new DestructuringErrors, oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
      this.yieldPos = 0;
      this.awaitPos = 0;
      this.awaitIdentPos = 0;
      var exprList = this.parseExprList(types$1.parenR, this.options.ecmaVersion >= 8, false, refDestructuringErrors);
      if (maybeAsyncArrow && !optional && this.shouldParseAsyncArrow()) {
        this.checkPatternErrors(refDestructuringErrors, false);
        this.checkYieldAwaitInDefaultParams();
        if (this.awaitIdentPos > 0)
          { this.raise(this.awaitIdentPos, "Cannot use 'await' as identifier inside an async function"); }
        this.yieldPos = oldYieldPos;
        this.awaitPos = oldAwaitPos;
        this.awaitIdentPos = oldAwaitIdentPos;
        return this.parseSubscriptAsyncArrow(startPos, startLoc, exprList, forInit)
      }
      this.checkExpressionErrors(refDestructuringErrors, true);
      this.yieldPos = oldYieldPos || this.yieldPos;
      this.awaitPos = oldAwaitPos || this.awaitPos;
      this.awaitIdentPos = oldAwaitIdentPos || this.awaitIdentPos;
      var node$1 = this.startNodeAt(startPos, startLoc);
      node$1.callee = base;
      node$1.arguments = exprList;
      if (optionalSupported) {
        node$1.optional = optional;
      }
      base = this.finishNode(node$1, "CallExpression");
    } else if (this.type === types$1.backQuote) {
      if (optional || optionalChained) {
        this.raise(this.start, "Optional chaining cannot appear in the tag of tagged template expressions");
      }
      var node$2 = this.startNodeAt(startPos, startLoc);
      node$2.tag = base;
      node$2.quasi = this.parseTemplate({isTagged: true});
      base = this.finishNode(node$2, "TaggedTemplateExpression");
    }
    return base
  };

  // Parse an atomic expression — either a single token that is an
  // expression, an expression started by a keyword like `function` or
  // `new`, or an expression wrapped in punctuation like `()`, `[]`,
  // or `{}`.

  pp$5.parseExprAtom = function(refDestructuringErrors, forInit, forNew) {
    // If a division operator appears in an expression position, the
    // tokenizer got confused, and we force it to read a regexp instead.
    if (this.type === types$1.slash) { this.readRegexp(); }

    var node, canBeArrow = this.potentialArrowAt === this.start;
    switch (this.type) {
    case types$1._super:
      if (!this.allowSuper)
        { this.raise(this.start, "'super' keyword outside a method"); }
      node = this.startNode();
      this.next();
      if (this.type === types$1.parenL && !this.allowDirectSuper)
        { this.raise(node.start, "super() call outside constructor of a subclass"); }
      // The `super` keyword can appear at below:
      // SuperProperty:
      //     super [ Expression ]
      //     super . IdentifierName
      // SuperCall:
      //     super ( Arguments )
      if (this.type !== types$1.dot && this.type !== types$1.bracketL && this.type !== types$1.parenL)
        { this.unexpected(); }
      return this.finishNode(node, "Super")

    case types$1._this:
      node = this.startNode();
      this.next();
      return this.finishNode(node, "ThisExpression")

    case types$1.name:
      var startPos = this.start, startLoc = this.startLoc, containsEsc = this.containsEsc;
      var id = this.parseIdent(false);
      if (this.options.ecmaVersion >= 8 && !containsEsc && id.name === "async" && !this.canInsertSemicolon() && this.eat(types$1._function)) {
        this.overrideContext(types.f_expr);
        return this.parseFunction(this.startNodeAt(startPos, startLoc), 0, false, true, forInit)
      }
      if (canBeArrow && !this.canInsertSemicolon()) {
        if (this.eat(types$1.arrow))
          { return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), [id], false, forInit) }
        if (this.options.ecmaVersion >= 8 && id.name === "async" && this.type === types$1.name && !containsEsc &&
            (!this.potentialArrowInForAwait || this.value !== "of" || this.containsEsc)) {
          id = this.parseIdent(false);
          if (this.canInsertSemicolon() || !this.eat(types$1.arrow))
            { this.unexpected(); }
          return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), [id], true, forInit)
        }
      }
      return id

    case types$1.regexp:
      var value = this.value;
      node = this.parseLiteral(value.value);
      node.regex = {pattern: value.pattern, flags: value.flags};
      return node

    case types$1.num: case types$1.string:
      return this.parseLiteral(this.value)

    case types$1._null: case types$1._true: case types$1._false:
      node = this.startNode();
      node.value = this.type === types$1._null ? null : this.type === types$1._true;
      node.raw = this.type.keyword;
      this.next();
      return this.finishNode(node, "Literal")

    case types$1.parenL:
      var start = this.start, expr = this.parseParenAndDistinguishExpression(canBeArrow, forInit);
      if (refDestructuringErrors) {
        if (refDestructuringErrors.parenthesizedAssign < 0 && !this.isSimpleAssignTarget(expr))
          { refDestructuringErrors.parenthesizedAssign = start; }
        if (refDestructuringErrors.parenthesizedBind < 0)
          { refDestructuringErrors.parenthesizedBind = start; }
      }
      return expr

    case types$1.bracketL:
      node = this.startNode();
      this.next();
      node.elements = this.parseExprList(types$1.bracketR, true, true, refDestructuringErrors);
      return this.finishNode(node, "ArrayExpression")

    case types$1.braceL:
      this.overrideContext(types.b_expr);
      return this.parseObj(false, refDestructuringErrors)

    case types$1._function:
      node = this.startNode();
      this.next();
      return this.parseFunction(node, 0)

    case types$1._class:
      return this.parseClass(this.startNode(), false)

    case types$1._new:
      return this.parseNew()

    case types$1.backQuote:
      return this.parseTemplate()

    case types$1._import:
      if (this.options.ecmaVersion >= 11) {
        return this.parseExprImport(forNew)
      } else {
        return this.unexpected()
      }

    default:
      return this.parseExprAtomDefault()
    }
  };

  pp$5.parseExprAtomDefault = function() {
    this.unexpected();
  };

  pp$5.parseExprImport = function(forNew) {
    var node = this.startNode();

    // Consume `import` as an identifier for `import.meta`.
    // Because `this.parseIdent(true)` doesn't check escape sequences, it needs the check of `this.containsEsc`.
    if (this.containsEsc) { this.raiseRecoverable(this.start, "Escape sequence in keyword import"); }
    this.next();

    if (this.type === types$1.parenL && !forNew) {
      return this.parseDynamicImport(node)
    } else if (this.type === types$1.dot) {
      var meta = this.startNodeAt(node.start, node.loc && node.loc.start);
      meta.name = "import";
      node.meta = this.finishNode(meta, "Identifier");
      return this.parseImportMeta(node)
    } else {
      this.unexpected();
    }
  };

  pp$5.parseDynamicImport = function(node) {
    this.next(); // skip `(`

    // Parse node.source.
    node.source = this.parseMaybeAssign();

    if (this.options.ecmaVersion >= 16) {
      if (!this.eat(types$1.parenR)) {
        this.expect(types$1.comma);
        if (!this.afterTrailingComma(types$1.parenR)) {
          node.options = this.parseMaybeAssign();
          if (!this.eat(types$1.parenR)) {
            this.expect(types$1.comma);
            if (!this.afterTrailingComma(types$1.parenR)) {
              this.unexpected();
            }
          }
        } else {
          node.options = null;
        }
      } else {
        node.options = null;
      }
    } else {
      // Verify ending.
      if (!this.eat(types$1.parenR)) {
        var errorPos = this.start;
        if (this.eat(types$1.comma) && this.eat(types$1.parenR)) {
          this.raiseRecoverable(errorPos, "Trailing comma is not allowed in import()");
        } else {
          this.unexpected(errorPos);
        }
      }
    }

    return this.finishNode(node, "ImportExpression")
  };

  pp$5.parseImportMeta = function(node) {
    this.next(); // skip `.`

    var containsEsc = this.containsEsc;
    node.property = this.parseIdent(true);

    if (node.property.name !== "meta")
      { this.raiseRecoverable(node.property.start, "The only valid meta property for import is 'import.meta'"); }
    if (containsEsc)
      { this.raiseRecoverable(node.start, "'import.meta' must not contain escaped characters"); }
    if (this.options.sourceType !== "module" && !this.options.allowImportExportEverywhere)
      { this.raiseRecoverable(node.start, "Cannot use 'import.meta' outside a module"); }

    return this.finishNode(node, "MetaProperty")
  };

  pp$5.parseLiteral = function(value) {
    var node = this.startNode();
    node.value = value;
    node.raw = this.input.slice(this.start, this.end);
    if (node.raw.charCodeAt(node.raw.length - 1) === 110)
      { node.bigint = node.value != null ? node.value.toString() : node.raw.slice(0, -1).replace(/_/g, ""); }
    this.next();
    return this.finishNode(node, "Literal")
  };

  pp$5.parseParenExpression = function() {
    this.expect(types$1.parenL);
    var val = this.parseExpression();
    this.expect(types$1.parenR);
    return val
  };

  pp$5.shouldParseArrow = function(exprList) {
    return !this.canInsertSemicolon()
  };

  pp$5.parseParenAndDistinguishExpression = function(canBeArrow, forInit) {
    var startPos = this.start, startLoc = this.startLoc, val, allowTrailingComma = this.options.ecmaVersion >= 8;
    if (this.options.ecmaVersion >= 6) {
      this.next();

      var innerStartPos = this.start, innerStartLoc = this.startLoc;
      var exprList = [], first = true, lastIsComma = false;
      var refDestructuringErrors = new DestructuringErrors, oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, spreadStart;
      this.yieldPos = 0;
      this.awaitPos = 0;
      // Do not save awaitIdentPos to allow checking awaits nested in parameters
      while (this.type !== types$1.parenR) {
        first ? first = false : this.expect(types$1.comma);
        if (allowTrailingComma && this.afterTrailingComma(types$1.parenR, true)) {
          lastIsComma = true;
          break
        } else if (this.type === types$1.ellipsis) {
          spreadStart = this.start;
          exprList.push(this.parseParenItem(this.parseRestBinding()));
          if (this.type === types$1.comma) {
            this.raiseRecoverable(
              this.start,
              "Comma is not permitted after the rest element"
            );
          }
          break
        } else {
          exprList.push(this.parseMaybeAssign(false, refDestructuringErrors, this.parseParenItem));
        }
      }
      var innerEndPos = this.lastTokEnd, innerEndLoc = this.lastTokEndLoc;
      this.expect(types$1.parenR);

      if (canBeArrow && this.shouldParseArrow(exprList) && this.eat(types$1.arrow)) {
        this.checkPatternErrors(refDestructuringErrors, false);
        this.checkYieldAwaitInDefaultParams();
        this.yieldPos = oldYieldPos;
        this.awaitPos = oldAwaitPos;
        return this.parseParenArrowList(startPos, startLoc, exprList, forInit)
      }

      if (!exprList.length || lastIsComma) { this.unexpected(this.lastTokStart); }
      if (spreadStart) { this.unexpected(spreadStart); }
      this.checkExpressionErrors(refDestructuringErrors, true);
      this.yieldPos = oldYieldPos || this.yieldPos;
      this.awaitPos = oldAwaitPos || this.awaitPos;

      if (exprList.length > 1) {
        val = this.startNodeAt(innerStartPos, innerStartLoc);
        val.expressions = exprList;
        this.finishNodeAt(val, "SequenceExpression", innerEndPos, innerEndLoc);
      } else {
        val = exprList[0];
      }
    } else {
      val = this.parseParenExpression();
    }

    if (this.options.preserveParens) {
      var par = this.startNodeAt(startPos, startLoc);
      par.expression = val;
      return this.finishNode(par, "ParenthesizedExpression")
    } else {
      return val
    }
  };

  pp$5.parseParenItem = function(item) {
    return item
  };

  pp$5.parseParenArrowList = function(startPos, startLoc, exprList, forInit) {
    return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), exprList, false, forInit)
  };

  // New's precedence is slightly tricky. It must allow its argument to
  // be a `[]` or dot subscript expression, but not a call — at least,
  // not without wrapping it in parentheses. Thus, it uses the noCalls
  // argument to parseSubscripts to prevent it from consuming the
  // argument list.

  var empty = [];

  pp$5.parseNew = function() {
    if (this.containsEsc) { this.raiseRecoverable(this.start, "Escape sequence in keyword new"); }
    var node = this.startNode();
    this.next();
    if (this.options.ecmaVersion >= 6 && this.type === types$1.dot) {
      var meta = this.startNodeAt(node.start, node.loc && node.loc.start);
      meta.name = "new";
      node.meta = this.finishNode(meta, "Identifier");
      this.next();
      var containsEsc = this.containsEsc;
      node.property = this.parseIdent(true);
      if (node.property.name !== "target")
        { this.raiseRecoverable(node.property.start, "The only valid meta property for new is 'new.target'"); }
      if (containsEsc)
        { this.raiseRecoverable(node.start, "'new.target' must not contain escaped characters"); }
      if (!this.allowNewDotTarget)
        { this.raiseRecoverable(node.start, "'new.target' can only be used in functions and class static block"); }
      return this.finishNode(node, "MetaProperty")
    }
    var startPos = this.start, startLoc = this.startLoc;
    node.callee = this.parseSubscripts(this.parseExprAtom(null, false, true), startPos, startLoc, true, false);
    if (this.eat(types$1.parenL)) { node.arguments = this.parseExprList(types$1.parenR, this.options.ecmaVersion >= 8, false); }
    else { node.arguments = empty; }
    return this.finishNode(node, "NewExpression")
  };

  // Parse template expression.

  pp$5.parseTemplateElement = function(ref) {
    var isTagged = ref.isTagged;

    var elem = this.startNode();
    if (this.type === types$1.invalidTemplate) {
      if (!isTagged) {
        this.raiseRecoverable(this.start, "Bad escape sequence in untagged template literal");
      }
      elem.value = {
        raw: this.value.replace(/\r\n?/g, "\n"),
        cooked: null
      };
    } else {
      elem.value = {
        raw: this.input.slice(this.start, this.end).replace(/\r\n?/g, "\n"),
        cooked: this.value
      };
    }
    this.next();
    elem.tail = this.type === types$1.backQuote;
    return this.finishNode(elem, "TemplateElement")
  };

  pp$5.parseTemplate = function(ref) {
    if ( ref === void 0 ) ref = {};
    var isTagged = ref.isTagged; if ( isTagged === void 0 ) isTagged = false;

    var node = this.startNode();
    this.next();
    node.expressions = [];
    var curElt = this.parseTemplateElement({isTagged: isTagged});
    node.quasis = [curElt];
    while (!curElt.tail) {
      if (this.type === types$1.eof) { this.raise(this.pos, "Unterminated template literal"); }
      this.expect(types$1.dollarBraceL);
      node.expressions.push(this.parseExpression());
      this.expect(types$1.braceR);
      node.quasis.push(curElt = this.parseTemplateElement({isTagged: isTagged}));
    }
    this.next();
    return this.finishNode(node, "TemplateLiteral")
  };

  pp$5.isAsyncProp = function(prop) {
    return !prop.computed && prop.key.type === "Identifier" && prop.key.name === "async" &&
      (this.type === types$1.name || this.type === types$1.num || this.type === types$1.string || this.type === types$1.bracketL || this.type.keyword || (this.options.ecmaVersion >= 9 && this.type === types$1.star)) &&
      !lineBreak.test(this.input.slice(this.lastTokEnd, this.start))
  };

  // Parse an object literal or binding pattern.

  pp$5.parseObj = function(isPattern, refDestructuringErrors) {
    var node = this.startNode(), first = true, propHash = {};
    node.properties = [];
    this.next();
    while (!this.eat(types$1.braceR)) {
      if (!first) {
        this.expect(types$1.comma);
        if (this.options.ecmaVersion >= 5 && this.afterTrailingComma(types$1.braceR)) { break }
      } else { first = false; }

      var prop = this.parseProperty(isPattern, refDestructuringErrors);
      if (!isPattern) { this.checkPropClash(prop, propHash, refDestructuringErrors); }
      node.properties.push(prop);
    }
    return this.finishNode(node, isPattern ? "ObjectPattern" : "ObjectExpression")
  };

  pp$5.parseProperty = function(isPattern, refDestructuringErrors) {
    var prop = this.startNode(), isGenerator, isAsync, startPos, startLoc;
    if (this.options.ecmaVersion >= 9 && this.eat(types$1.ellipsis)) {
      if (isPattern) {
        prop.argument = this.parseIdent(false);
        if (this.type === types$1.comma) {
          this.raiseRecoverable(this.start, "Comma is not permitted after the rest element");
        }
        return this.finishNode(prop, "RestElement")
      }
      // Parse argument.
      prop.argument = this.parseMaybeAssign(false, refDestructuringErrors);
      // To disallow trailing comma via `this.toAssignable()`.
      if (this.type === types$1.comma && refDestructuringErrors && refDestructuringErrors.trailingComma < 0) {
        refDestructuringErrors.trailingComma = this.start;
      }
      // Finish
      return this.finishNode(prop, "SpreadElement")
    }
    if (this.options.ecmaVersion >= 6) {
      prop.method = false;
      prop.shorthand = false;
      if (isPattern || refDestructuringErrors) {
        startPos = this.start;
        startLoc = this.startLoc;
      }
      if (!isPattern)
        { isGenerator = this.eat(types$1.star); }
    }
    var containsEsc = this.containsEsc;
    this.parsePropertyName(prop);
    if (!isPattern && !containsEsc && this.options.ecmaVersion >= 8 && !isGenerator && this.isAsyncProp(prop)) {
      isAsync = true;
      isGenerator = this.options.ecmaVersion >= 9 && this.eat(types$1.star);
      this.parsePropertyName(prop);
    } else {
      isAsync = false;
    }
    this.parsePropertyValue(prop, isPattern, isGenerator, isAsync, startPos, startLoc, refDestructuringErrors, containsEsc);
    return this.finishNode(prop, "Property")
  };

  pp$5.parseGetterSetter = function(prop) {
    var kind = prop.key.name;
    this.parsePropertyName(prop);
    prop.value = this.parseMethod(false);
    prop.kind = kind;
    var paramCount = prop.kind === "get" ? 0 : 1;
    if (prop.value.params.length !== paramCount) {
      var start = prop.value.start;
      if (prop.kind === "get")
        { this.raiseRecoverable(start, "getter should have no params"); }
      else
        { this.raiseRecoverable(start, "setter should have exactly one param"); }
    } else {
      if (prop.kind === "set" && prop.value.params[0].type === "RestElement")
        { this.raiseRecoverable(prop.value.params[0].start, "Setter cannot use rest params"); }
    }
  };

  pp$5.parsePropertyValue = function(prop, isPattern, isGenerator, isAsync, startPos, startLoc, refDestructuringErrors, containsEsc) {
    if ((isGenerator || isAsync) && this.type === types$1.colon)
      { this.unexpected(); }

    if (this.eat(types$1.colon)) {
      prop.value = isPattern ? this.parseMaybeDefault(this.start, this.startLoc) : this.parseMaybeAssign(false, refDestructuringErrors);
      prop.kind = "init";
    } else if (this.options.ecmaVersion >= 6 && this.type === types$1.parenL) {
      if (isPattern) { this.unexpected(); }
      prop.method = true;
      prop.value = this.parseMethod(isGenerator, isAsync);
      prop.kind = "init";
    } else if (!isPattern && !containsEsc &&
               this.options.ecmaVersion >= 5 && !prop.computed && prop.key.type === "Identifier" &&
               (prop.key.name === "get" || prop.key.name === "set") &&
               (this.type !== types$1.comma && this.type !== types$1.braceR && this.type !== types$1.eq)) {
      if (isGenerator || isAsync) { this.unexpected(); }
      this.parseGetterSetter(prop);
    } else if (this.options.ecmaVersion >= 6 && !prop.computed && prop.key.type === "Identifier") {
      if (isGenerator || isAsync) { this.unexpected(); }
      this.checkUnreserved(prop.key);
      if (prop.key.name === "await" && !this.awaitIdentPos)
        { this.awaitIdentPos = startPos; }
      if (isPattern) {
        prop.value = this.parseMaybeDefault(startPos, startLoc, this.copyNode(prop.key));
      } else if (this.type === types$1.eq && refDestructuringErrors) {
        if (refDestructuringErrors.shorthandAssign < 0)
          { refDestructuringErrors.shorthandAssign = this.start; }
        prop.value = this.parseMaybeDefault(startPos, startLoc, this.copyNode(prop.key));
      } else {
        prop.value = this.copyNode(prop.key);
      }
      prop.kind = "init";
      prop.shorthand = true;
    } else { this.unexpected(); }
  };

  pp$5.parsePropertyName = function(prop) {
    if (this.options.ecmaVersion >= 6) {
      if (this.eat(types$1.bracketL)) {
        prop.computed = true;
        prop.key = this.parseMaybeAssign();
        this.expect(types$1.bracketR);
        return prop.key
      } else {
        prop.computed = false;
      }
    }
    return prop.key = this.type === types$1.num || this.type === types$1.string ? this.parseExprAtom() : this.parseIdent(this.options.allowReserved !== "never")
  };

  // Initialize empty function node.

  pp$5.initFunction = function(node) {
    node.id = null;
    if (this.options.ecmaVersion >= 6) { node.generator = node.expression = false; }
    if (this.options.ecmaVersion >= 8) { node.async = false; }
  };

  // Parse object or class method.

  pp$5.parseMethod = function(isGenerator, isAsync, allowDirectSuper) {
    var node = this.startNode(), oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;

    this.initFunction(node);
    if (this.options.ecmaVersion >= 6)
      { node.generator = isGenerator; }
    if (this.options.ecmaVersion >= 8)
      { node.async = !!isAsync; }

    this.yieldPos = 0;
    this.awaitPos = 0;
    this.awaitIdentPos = 0;
    this.enterScope(functionFlags(isAsync, node.generator) | SCOPE_SUPER | (allowDirectSuper ? SCOPE_DIRECT_SUPER : 0));

    this.expect(types$1.parenL);
    node.params = this.parseBindingList(types$1.parenR, false, this.options.ecmaVersion >= 8);
    this.checkYieldAwaitInDefaultParams();
    this.parseFunctionBody(node, false, true, false);

    this.yieldPos = oldYieldPos;
    this.awaitPos = oldAwaitPos;
    this.awaitIdentPos = oldAwaitIdentPos;
    return this.finishNode(node, "FunctionExpression")
  };

  // Parse arrow function expression with given parameters.

  pp$5.parseArrowExpression = function(node, params, isAsync, forInit) {
    var oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;

    this.enterScope(functionFlags(isAsync, false) | SCOPE_ARROW);
    this.initFunction(node);
    if (this.options.ecmaVersion >= 8) { node.async = !!isAsync; }

    this.yieldPos = 0;
    this.awaitPos = 0;
    this.awaitIdentPos = 0;

    node.params = this.toAssignableList(params, true);
    this.parseFunctionBody(node, true, false, forInit);

    this.yieldPos = oldYieldPos;
    this.awaitPos = oldAwaitPos;
    this.awaitIdentPos = oldAwaitIdentPos;
    return this.finishNode(node, "ArrowFunctionExpression")
  };

  // Parse function body and check parameters.

  pp$5.parseFunctionBody = function(node, isArrowFunction, isMethod, forInit) {
    var isExpression = isArrowFunction && this.type !== types$1.braceL;
    var oldStrict = this.strict, useStrict = false;

    if (isExpression) {
      node.body = this.parseMaybeAssign(forInit);
      node.expression = true;
      this.checkParams(node, false);
    } else {
      var nonSimple = this.options.ecmaVersion >= 7 && !this.isSimpleParamList(node.params);
      if (!oldStrict || nonSimple) {
        useStrict = this.strictDirective(this.end);
        // If this is a strict mode function, verify that argument names
        // are not repeated, and it does not try to bind the words `eval`
        // or `arguments`.
        if (useStrict && nonSimple)
          { this.raiseRecoverable(node.start, "Illegal 'use strict' directive in function with non-simple parameter list"); }
      }
      // Start a new scope with regard to labels and the `inFunction`
      // flag (restore them to their old value afterwards).
      var oldLabels = this.labels;
      this.labels = [];
      if (useStrict) { this.strict = true; }

      // Add the params to varDeclaredNames to ensure that an error is thrown
      // if a let/const declaration in the function clashes with one of the params.
      this.checkParams(node, !oldStrict && !useStrict && !isArrowFunction && !isMethod && this.isSimpleParamList(node.params));
      // Ensure the function name isn't a forbidden identifier in strict mode, e.g. 'eval'
      if (this.strict && node.id) { this.checkLValSimple(node.id, BIND_OUTSIDE); }
      node.body = this.parseBlock(false, undefined, useStrict && !oldStrict);
      node.expression = false;
      this.adaptDirectivePrologue(node.body.body);
      this.labels = oldLabels;
    }
    this.exitScope();
  };

  pp$5.isSimpleParamList = function(params) {
    for (var i = 0, list = params; i < list.length; i += 1)
      {
      var param = list[i];

      if (param.type !== "Identifier") { return false
    } }
    return true
  };

  // Checks function params for various disallowed patterns such as using "eval"
  // or "arguments" and duplicate parameters.

  pp$5.checkParams = function(node, allowDuplicates) {
    var nameHash = Object.create(null);
    for (var i = 0, list = node.params; i < list.length; i += 1)
      {
      var param = list[i];

      this.checkLValInnerPattern(param, BIND_VAR, allowDuplicates ? null : nameHash);
    }
  };

  // Parses a comma-separated list of expressions, and returns them as
  // an array. `close` is the token type that ends the list, and
  // `allowEmpty` can be turned on to allow subsequent commas with
  // nothing in between them to be parsed as `null` (which is needed
  // for array literals).

  pp$5.parseExprList = function(close, allowTrailingComma, allowEmpty, refDestructuringErrors) {
    var elts = [], first = true;
    while (!this.eat(close)) {
      if (!first) {
        this.expect(types$1.comma);
        if (allowTrailingComma && this.afterTrailingComma(close)) { break }
      } else { first = false; }

      var elt = (void 0);
      if (allowEmpty && this.type === types$1.comma)
        { elt = null; }
      else if (this.type === types$1.ellipsis) {
        elt = this.parseSpread(refDestructuringErrors);
        if (refDestructuringErrors && this.type === types$1.comma && refDestructuringErrors.trailingComma < 0)
          { refDestructuringErrors.trailingComma = this.start; }
      } else {
        elt = this.parseMaybeAssign(false, refDestructuringErrors);
      }
      elts.push(elt);
    }
    return elts
  };

  pp$5.checkUnreserved = function(ref) {
    var start = ref.start;
    var end = ref.end;
    var name = ref.name;

    if (this.inGenerator && name === "yield")
      { this.raiseRecoverable(start, "Cannot use 'yield' as identifier inside a generator"); }
    if (this.inAsync && name === "await")
      { this.raiseRecoverable(start, "Cannot use 'await' as identifier inside an async function"); }
    if (!(this.currentThisScope().flags & SCOPE_VAR) && name === "arguments")
      { this.raiseRecoverable(start, "Cannot use 'arguments' in class field initializer"); }
    if (this.inClassStaticBlock && (name === "arguments" || name === "await"))
      { this.raise(start, ("Cannot use " + name + " in class static initialization block")); }
    if (this.keywords.test(name))
      { this.raise(start, ("Unexpected keyword '" + name + "'")); }
    if (this.options.ecmaVersion < 6 &&
      this.input.slice(start, end).indexOf("\\") !== -1) { return }
    var re = this.strict ? this.reservedWordsStrict : this.reservedWords;
    if (re.test(name)) {
      if (!this.inAsync && name === "await")
        { this.raiseRecoverable(start, "Cannot use keyword 'await' outside an async function"); }
      this.raiseRecoverable(start, ("The keyword '" + name + "' is reserved"));
    }
  };

  // Parse the next token as an identifier. If `liberal` is true (used
  // when parsing properties), it will also convert keywords into
  // identifiers.

  pp$5.parseIdent = function(liberal) {
    var node = this.parseIdentNode();
    this.next(!!liberal);
    this.finishNode(node, "Identifier");
    if (!liberal) {
      this.checkUnreserved(node);
      if (node.name === "await" && !this.awaitIdentPos)
        { this.awaitIdentPos = node.start; }
    }
    return node
  };

  pp$5.parseIdentNode = function() {
    var node = this.startNode();
    if (this.type === types$1.name) {
      node.name = this.value;
    } else if (this.type.keyword) {
      node.name = this.type.keyword;

      // To fix https://github.com/acornjs/acorn/issues/575
      // `class` and `function` keywords push new context into this.context.
      // But there is no chance to pop the context if the keyword is consumed as an identifier such as a property name.
      // If the previous token is a dot, this does not apply because the context-managing code already ignored the keyword
      if ((node.name === "class" || node.name === "function") &&
        (this.lastTokEnd !== this.lastTokStart + 1 || this.input.charCodeAt(this.lastTokStart) !== 46)) {
        this.context.pop();
      }
      this.type = types$1.name;
    } else {
      this.unexpected();
    }
    return node
  };

  pp$5.parsePrivateIdent = function() {
    var node = this.startNode();
    if (this.type === types$1.privateId) {
      node.name = this.value;
    } else {
      this.unexpected();
    }
    this.next();
    this.finishNode(node, "PrivateIdentifier");

    // For validating existence
    if (this.options.checkPrivateFields) {
      if (this.privateNameStack.length === 0) {
        this.raise(node.start, ("Private field '#" + (node.name) + "' must be declared in an enclosing class"));
      } else {
        this.privateNameStack[this.privateNameStack.length - 1].used.push(node);
      }
    }

    return node
  };

  // Parses yield expression inside generator.

  pp$5.parseYield = function(forInit) {
    if (!this.yieldPos) { this.yieldPos = this.start; }

    var node = this.startNode();
    this.next();
    if (this.type === types$1.semi || this.canInsertSemicolon() || (this.type !== types$1.star && !this.type.startsExpr)) {
      node.delegate = false;
      node.argument = null;
    } else {
      node.delegate = this.eat(types$1.star);
      node.argument = this.parseMaybeAssign(forInit);
    }
    return this.finishNode(node, "YieldExpression")
  };

  pp$5.parseAwait = function(forInit) {
    if (!this.awaitPos) { this.awaitPos = this.start; }

    var node = this.startNode();
    this.next();
    node.argument = this.parseMaybeUnary(null, true, false, forInit);
    return this.finishNode(node, "AwaitExpression")
  };

  var pp$4 = Parser.prototype;

  // This function is used to raise exceptions on parse errors. It
  // takes an offset integer (into the current `input`) to indicate
  // the location of the error, attaches the position to the end
  // of the error message, and then raises a `SyntaxError` with that
  // message.

  pp$4.raise = function(pos, message) {
    var loc = getLineInfo(this.input, pos);
    message += " (" + loc.line + ":" + loc.column + ")";
    if (this.sourceFile) {
      message += " in " + this.sourceFile;
    }
    var err = new SyntaxError(message);
    err.pos = pos; err.loc = loc; err.raisedAt = this.pos;
    throw err
  };

  pp$4.raiseRecoverable = pp$4.raise;

  pp$4.curPosition = function() {
    if (this.options.locations) {
      return new Position(this.curLine, this.pos - this.lineStart)
    }
  };

  var pp$3 = Parser.prototype;

  var Scope = function Scope(flags) {
    this.flags = flags;
    // A list of var-declared names in the current lexical scope
    this.var = [];
    // A list of lexically-declared names in the current lexical scope
    this.lexical = [];
    // A list of lexically-declared FunctionDeclaration names in the current lexical scope
    this.functions = [];
  };

  // The functions in this module keep track of declared variables in the current scope in order to detect duplicate variable names.

  pp$3.enterScope = function(flags) {
    this.scopeStack.push(new Scope(flags));
  };

  pp$3.exitScope = function() {
    this.scopeStack.pop();
  };

  // The spec says:
  // > At the top level of a function, or script, function declarations are
  // > treated like var declarations rather than like lexical declarations.
  pp$3.treatFunctionsAsVarInScope = function(scope) {
    return (scope.flags & SCOPE_FUNCTION) || !this.inModule && (scope.flags & SCOPE_TOP)
  };

  pp$3.declareName = function(name, bindingType, pos) {
    var redeclared = false;
    if (bindingType === BIND_LEXICAL) {
      var scope = this.currentScope();
      redeclared = scope.lexical.indexOf(name) > -1 || scope.functions.indexOf(name) > -1 || scope.var.indexOf(name) > -1;
      scope.lexical.push(name);
      if (this.inModule && (scope.flags & SCOPE_TOP))
        { delete this.undefinedExports[name]; }
    } else if (bindingType === BIND_SIMPLE_CATCH) {
      var scope$1 = this.currentScope();
      scope$1.lexical.push(name);
    } else if (bindingType === BIND_FUNCTION) {
      var scope$2 = this.currentScope();
      if (this.treatFunctionsAsVar)
        { redeclared = scope$2.lexical.indexOf(name) > -1; }
      else
        { redeclared = scope$2.lexical.indexOf(name) > -1 || scope$2.var.indexOf(name) > -1; }
      scope$2.functions.push(name);
    } else {
      for (var i = this.scopeStack.length - 1; i >= 0; --i) {
        var scope$3 = this.scopeStack[i];
        if (scope$3.lexical.indexOf(name) > -1 && !((scope$3.flags & SCOPE_SIMPLE_CATCH) && scope$3.lexical[0] === name) ||
            !this.treatFunctionsAsVarInScope(scope$3) && scope$3.functions.indexOf(name) > -1) {
          redeclared = true;
          break
        }
        scope$3.var.push(name);
        if (this.inModule && (scope$3.flags & SCOPE_TOP))
          { delete this.undefinedExports[name]; }
        if (scope$3.flags & SCOPE_VAR) { break }
      }
    }
    if (redeclared) { this.raiseRecoverable(pos, ("Identifier '" + name + "' has already been declared")); }
  };

  pp$3.checkLocalExport = function(id) {
    // scope.functions must be empty as Module code is always strict.
    if (this.scopeStack[0].lexical.indexOf(id.name) === -1 &&
        this.scopeStack[0].var.indexOf(id.name) === -1) {
      this.undefinedExports[id.name] = id;
    }
  };

  pp$3.currentScope = function() {
    return this.scopeStack[this.scopeStack.length - 1]
  };

  pp$3.currentVarScope = function() {
    for (var i = this.scopeStack.length - 1;; i--) {
      var scope = this.scopeStack[i];
      if (scope.flags & (SCOPE_VAR | SCOPE_CLASS_FIELD_INIT | SCOPE_CLASS_STATIC_BLOCK)) { return scope }
    }
  };

  // Could be useful for `this`, `new.target`, `super()`, `super.property`, and `super[property]`.
  pp$3.currentThisScope = function() {
    for (var i = this.scopeStack.length - 1;; i--) {
      var scope = this.scopeStack[i];
      if (scope.flags & (SCOPE_VAR | SCOPE_CLASS_FIELD_INIT | SCOPE_CLASS_STATIC_BLOCK) &&
          !(scope.flags & SCOPE_ARROW)) { return scope }
    }
  };

  var Node = function Node(parser, pos, loc) {
    this.type = "";
    this.start = pos;
    this.end = 0;
    if (parser.options.locations)
      { this.loc = new SourceLocation(parser, loc); }
    if (parser.options.directSourceFile)
      { this.sourceFile = parser.options.directSourceFile; }
    if (parser.options.ranges)
      { this.range = [pos, 0]; }
  };

  // Start an AST node, attaching a start offset.

  var pp$2 = Parser.prototype;

  pp$2.startNode = function() {
    return new Node(this, this.start, this.startLoc)
  };

  pp$2.startNodeAt = function(pos, loc) {
    return new Node(this, pos, loc)
  };

  // Finish an AST node, adding `type` and `end` properties.

  function finishNodeAt(node, type, pos, loc) {
    node.type = type;
    node.end = pos;
    if (this.options.locations)
      { node.loc.end = loc; }
    if (this.options.ranges)
      { node.range[1] = pos; }
    return node
  }

  pp$2.finishNode = function(node, type) {
    return finishNodeAt.call(this, node, type, this.lastTokEnd, this.lastTokEndLoc)
  };

  // Finish node at given position

  pp$2.finishNodeAt = function(node, type, pos, loc) {
    return finishNodeAt.call(this, node, type, pos, loc)
  };

  pp$2.copyNode = function(node) {
    var newNode = new Node(this, node.start, this.startLoc);
    for (var prop in node) { newNode[prop] = node[prop]; }
    return newNode
  };

  // This file was generated by "bin/generate-unicode-script-values.js". Do not modify manually!
  var scriptValuesAddedInUnicode = "Gara Garay Gukh Gurung_Khema Hrkt Katakana_Or_Hiragana Kawi Kirat_Rai Krai Nag_Mundari Nagm Ol_Onal Onao Sunu Sunuwar Todhri Todr Tulu_Tigalari Tutg Unknown Zzzz";

  // This file contains Unicode properties extracted from the ECMAScript specification.
  // The lists are extracted like so:
  // $$('#table-binary-unicode-properties > figure > table > tbody > tr > td:nth-child(1) code').map(el => el.innerText)

  // #table-binary-unicode-properties
  var ecma9BinaryProperties = "ASCII ASCII_Hex_Digit AHex Alphabetic Alpha Any Assigned Bidi_Control Bidi_C Bidi_Mirrored Bidi_M Case_Ignorable CI Cased Changes_When_Casefolded CWCF Changes_When_Casemapped CWCM Changes_When_Lowercased CWL Changes_When_NFKC_Casefolded CWKCF Changes_When_Titlecased CWT Changes_When_Uppercased CWU Dash Default_Ignorable_Code_Point DI Deprecated Dep Diacritic Dia Emoji Emoji_Component Emoji_Modifier Emoji_Modifier_Base Emoji_Presentation Extender Ext Grapheme_Base Gr_Base Grapheme_Extend Gr_Ext Hex_Digit Hex IDS_Binary_Operator IDSB IDS_Trinary_Operator IDST ID_Continue IDC ID_Start IDS Ideographic Ideo Join_Control Join_C Logical_Order_Exception LOE Lowercase Lower Math Noncharacter_Code_Point NChar Pattern_Syntax Pat_Syn Pattern_White_Space Pat_WS Quotation_Mark QMark Radical Regional_Indicator RI Sentence_Terminal STerm Soft_Dotted SD Terminal_Punctuation Term Unified_Ideograph UIdeo Uppercase Upper Variation_Selector VS White_Space space XID_Continue XIDC XID_Start XIDS";
  var ecma10BinaryProperties = ecma9BinaryProperties + " Extended_Pictographic";
  var ecma11BinaryProperties = ecma10BinaryProperties;
  var ecma12BinaryProperties = ecma11BinaryProperties + " EBase EComp EMod EPres ExtPict";
  var ecma13BinaryProperties = ecma12BinaryProperties;
  var ecma14BinaryProperties = ecma13BinaryProperties;

  var unicodeBinaryProperties = {
    9: ecma9BinaryProperties,
    10: ecma10BinaryProperties,
    11: ecma11BinaryProperties,
    12: ecma12BinaryProperties,
    13: ecma13BinaryProperties,
    14: ecma14BinaryProperties
  };

  // #table-binary-unicode-properties-of-strings
  var ecma14BinaryPropertiesOfStrings = "Basic_Emoji Emoji_Keycap_Sequence RGI_Emoji_Modifier_Sequence RGI_Emoji_Flag_Sequence RGI_Emoji_Tag_Sequence RGI_Emoji_ZWJ_Sequence RGI_Emoji";

  var unicodeBinaryPropertiesOfStrings = {
    9: "",
    10: "",
    11: "",
    12: "",
    13: "",
    14: ecma14BinaryPropertiesOfStrings
  };

  // #table-unicode-general-category-values
  var unicodeGeneralCategoryValues = "Cased_Letter LC Close_Punctuation Pe Connector_Punctuation Pc Control Cc cntrl Currency_Symbol Sc Dash_Punctuation Pd Decimal_Number Nd digit Enclosing_Mark Me Final_Punctuation Pf Format Cf Initial_Punctuation Pi Letter L Letter_Number Nl Line_Separator Zl Lowercase_Letter Ll Mark M Combining_Mark Math_Symbol Sm Modifier_Letter Lm Modifier_Symbol Sk Nonspacing_Mark Mn Number N Open_Punctuation Ps Other C Other_Letter Lo Other_Number No Other_Punctuation Po Other_Symbol So Paragraph_Separator Zp Private_Use Co Punctuation P punct Separator Z Space_Separator Zs Spacing_Mark Mc Surrogate Cs Symbol S Titlecase_Letter Lt Unassigned Cn Uppercase_Letter Lu";

  // #table-unicode-script-values
  var ecma9ScriptValues = "Adlam Adlm Ahom Anatolian_Hieroglyphs Hluw Arabic Arab Armenian Armn Avestan Avst Balinese Bali Bamum Bamu Bassa_Vah Bass Batak Batk Bengali Beng Bhaiksuki Bhks Bopomofo Bopo Brahmi Brah Braille Brai Buginese Bugi Buhid Buhd Canadian_Aboriginal Cans Carian Cari Caucasian_Albanian Aghb Chakma Cakm Cham Cham Cherokee Cher Common Zyyy Coptic Copt Qaac Cuneiform Xsux Cypriot Cprt Cyrillic Cyrl Deseret Dsrt Devanagari Deva Duployan Dupl Egyptian_Hieroglyphs Egyp Elbasan Elba Ethiopic Ethi Georgian Geor Glagolitic Glag Gothic Goth Grantha Gran Greek Grek Gujarati Gujr Gurmukhi Guru Han Hani Hangul Hang Hanunoo Hano Hatran Hatr Hebrew Hebr Hiragana Hira Imperial_Aramaic Armi Inherited Zinh Qaai Inscriptional_Pahlavi Phli Inscriptional_Parthian Prti Javanese Java Kaithi Kthi Kannada Knda Katakana Kana Kayah_Li Kali Kharoshthi Khar Khmer Khmr Khojki Khoj Khudawadi Sind Lao Laoo Latin Latn Lepcha Lepc Limbu Limb Linear_A Lina Linear_B Linb Lisu Lisu Lycian Lyci Lydian Lydi Mahajani Mahj Malayalam Mlym Mandaic Mand Manichaean Mani Marchen Marc Masaram_Gondi Gonm Meetei_Mayek Mtei Mende_Kikakui Mend Meroitic_Cursive Merc Meroitic_Hieroglyphs Mero Miao Plrd Modi Mongolian Mong Mro Mroo Multani Mult Myanmar Mymr Nabataean Nbat New_Tai_Lue Talu Newa Newa Nko Nkoo Nushu Nshu Ogham Ogam Ol_Chiki Olck Old_Hungarian Hung Old_Italic Ital Old_North_Arabian Narb Old_Permic Perm Old_Persian Xpeo Old_South_Arabian Sarb Old_Turkic Orkh Oriya Orya Osage Osge Osmanya Osma Pahawh_Hmong Hmng Palmyrene Palm Pau_Cin_Hau Pauc Phags_Pa Phag Phoenician Phnx Psalter_Pahlavi Phlp Rejang Rjng Runic Runr Samaritan Samr Saurashtra Saur Sharada Shrd Shavian Shaw Siddham Sidd SignWriting Sgnw Sinhala Sinh Sora_Sompeng Sora Soyombo Soyo Sundanese Sund Syloti_Nagri Sylo Syriac Syrc Tagalog Tglg Tagbanwa Tagb Tai_Le Tale Tai_Tham Lana Tai_Viet Tavt Takri Takr Tamil Taml Tangut Tang Telugu Telu Thaana Thaa Thai Thai Tibetan Tibt Tifinagh Tfng Tirhuta Tirh Ugaritic Ugar Vai Vaii Warang_Citi Wara Yi Yiii Zanabazar_Square Zanb";
  var ecma10ScriptValues = ecma9ScriptValues + " Dogra Dogr Gunjala_Gondi Gong Hanifi_Rohingya Rohg Makasar Maka Medefaidrin Medf Old_Sogdian Sogo Sogdian Sogd";
  var ecma11ScriptValues = ecma10ScriptValues + " Elymaic Elym Nandinagari Nand Nyiakeng_Puachue_Hmong Hmnp Wancho Wcho";
  var ecma12ScriptValues = ecma11ScriptValues + " Chorasmian Chrs Diak Dives_Akuru Khitan_Small_Script Kits Yezi Yezidi";
  var ecma13ScriptValues = ecma12ScriptValues + " Cypro_Minoan Cpmn Old_Uyghur Ougr Tangsa Tnsa Toto Vithkuqi Vith";
  var ecma14ScriptValues = ecma13ScriptValues + " " + scriptValuesAddedInUnicode;

  var unicodeScriptValues = {
    9: ecma9ScriptValues,
    10: ecma10ScriptValues,
    11: ecma11ScriptValues,
    12: ecma12ScriptValues,
    13: ecma13ScriptValues,
    14: ecma14ScriptValues
  };

  var data = {};
  function buildUnicodeData(ecmaVersion) {
    var d = data[ecmaVersion] = {
      binary: wordsRegexp(unicodeBinaryProperties[ecmaVersion] + " " + unicodeGeneralCategoryValues),
      binaryOfStrings: wordsRegexp(unicodeBinaryPropertiesOfStrings[ecmaVersion]),
      nonBinary: {
        General_Category: wordsRegexp(unicodeGeneralCategoryValues),
        Script: wordsRegexp(unicodeScriptValues[ecmaVersion])
      }
    };
    d.nonBinary.Script_Extensions = d.nonBinary.Script;

    d.nonBinary.gc = d.nonBinary.General_Category;
    d.nonBinary.sc = d.nonBinary.Script;
    d.nonBinary.scx = d.nonBinary.Script_Extensions;
  }

  for (var i = 0, list = [9, 10, 11, 12, 13, 14]; i < list.length; i += 1) {
    var ecmaVersion = list[i];

    buildUnicodeData(ecmaVersion);
  }

  var pp$1 = Parser.prototype;

  // Track disjunction structure to determine whether a duplicate
  // capture group name is allowed because it is in a separate branch.
  var BranchID = function BranchID(parent, base) {
    // Parent disjunction branch
    this.parent = parent;
    // Identifies this set of sibling branches
    this.base = base || this;
  };

  BranchID.prototype.separatedFrom = function separatedFrom (alt) {
    // A branch is separate from another branch if they or any of
    // their parents are siblings in a given disjunction
    for (var self = this; self; self = self.parent) {
      for (var other = alt; other; other = other.parent) {
        if (self.base === other.base && self !== other) { return true }
      }
    }
    return false
  };

  BranchID.prototype.sibling = function sibling () {
    return new BranchID(this.parent, this.base)
  };

  var RegExpValidationState = function RegExpValidationState(parser) {
    this.parser = parser;
    this.validFlags = "gim" + (parser.options.ecmaVersion >= 6 ? "uy" : "") + (parser.options.ecmaVersion >= 9 ? "s" : "") + (parser.options.ecmaVersion >= 13 ? "d" : "") + (parser.options.ecmaVersion >= 15 ? "v" : "");
    this.unicodeProperties = data[parser.options.ecmaVersion >= 14 ? 14 : parser.options.ecmaVersion];
    this.source = "";
    this.flags = "";
    this.start = 0;
    this.switchU = false;
    this.switchV = false;
    this.switchN = false;
    this.pos = 0;
    this.lastIntValue = 0;
    this.lastStringValue = "";
    this.lastAssertionIsQuantifiable = false;
    this.numCapturingParens = 0;
    this.maxBackReference = 0;
    this.groupNames = Object.create(null);
    this.backReferenceNames = [];
    this.branchID = null;
  };

  RegExpValidationState.prototype.reset = function reset (start, pattern, flags) {
    var unicodeSets = flags.indexOf("v") !== -1;
    var unicode = flags.indexOf("u") !== -1;
    this.start = start | 0;
    this.source = pattern + "";
    this.flags = flags;
    if (unicodeSets && this.parser.options.ecmaVersion >= 15) {
      this.switchU = true;
      this.switchV = true;
      this.switchN = true;
    } else {
      this.switchU = unicode && this.parser.options.ecmaVersion >= 6;
      this.switchV = false;
      this.switchN = unicode && this.parser.options.ecmaVersion >= 9;
    }
  };

  RegExpValidationState.prototype.raise = function raise (message) {
    this.parser.raiseRecoverable(this.start, ("Invalid regular expression: /" + (this.source) + "/: " + message));
  };

  // If u flag is given, this returns the code point at the index (it combines a surrogate pair).
  // Otherwise, this returns the code unit of the index (can be a part of a surrogate pair).
  RegExpValidationState.prototype.at = function at (i, forceU) {
      if ( forceU === void 0 ) forceU = false;

    var s = this.source;
    var l = s.length;
    if (i >= l) {
      return -1
    }
    var c = s.charCodeAt(i);
    if (!(forceU || this.switchU) || c <= 0xD7FF || c >= 0xE000 || i + 1 >= l) {
      return c
    }
    var next = s.charCodeAt(i + 1);
    return next >= 0xDC00 && next <= 0xDFFF ? (c << 10) + next - 0x35FDC00 : c
  };

  RegExpValidationState.prototype.nextIndex = function nextIndex (i, forceU) {
      if ( forceU === void 0 ) forceU = false;

    var s = this.source;
    var l = s.length;
    if (i >= l) {
      return l
    }
    var c = s.charCodeAt(i), next;
    if (!(forceU || this.switchU) || c <= 0xD7FF || c >= 0xE000 || i + 1 >= l ||
        (next = s.charCodeAt(i + 1)) < 0xDC00 || next > 0xDFFF) {
      return i + 1
    }
    return i + 2
  };

  RegExpValidationState.prototype.current = function current (forceU) {
      if ( forceU === void 0 ) forceU = false;

    return this.at(this.pos, forceU)
  };

  RegExpValidationState.prototype.lookahead = function lookahead (forceU) {
      if ( forceU === void 0 ) forceU = false;

    return this.at(this.nextIndex(this.pos, forceU), forceU)
  };

  RegExpValidationState.prototype.advance = function advance (forceU) {
      if ( forceU === void 0 ) forceU = false;

    this.pos = this.nextIndex(this.pos, forceU);
  };

  RegExpValidationState.prototype.eat = function eat (ch, forceU) {
      if ( forceU === void 0 ) forceU = false;

    if (this.current(forceU) === ch) {
      this.advance(forceU);
      return true
    }
    return false
  };

  RegExpValidationState.prototype.eatChars = function eatChars (chs, forceU) {
      if ( forceU === void 0 ) forceU = false;

    var pos = this.pos;
    for (var i = 0, list = chs; i < list.length; i += 1) {
      var ch = list[i];

        var current = this.at(pos, forceU);
      if (current === -1 || current !== ch) {
        return false
      }
      pos = this.nextIndex(pos, forceU);
    }
    this.pos = pos;
    return true
  };

  /**
   * Validate the flags part of a given RegExpLiteral.
   *
   * @param {RegExpValidationState} state The state to validate RegExp.
   * @returns {void}
   */
  pp$1.validateRegExpFlags = function(state) {
    var validFlags = state.validFlags;
    var flags = state.flags;

    var u = false;
    var v = false;

    for (var i = 0; i < flags.length; i++) {
      var flag = flags.charAt(i);
      if (validFlags.indexOf(flag) === -1) {
        this.raise(state.start, "Invalid regular expression flag");
      }
      if (flags.indexOf(flag, i + 1) > -1) {
        this.raise(state.start, "Duplicate regular expression flag");
      }
      if (flag === "u") { u = true; }
      if (flag === "v") { v = true; }
    }
    if (this.options.ecmaVersion >= 15 && u && v) {
      this.raise(state.start, "Invalid regular expression flag");
    }
  };

  function hasProp(obj) {
    for (var _ in obj) { return true }
    return false
  }

  /**
   * Validate the pattern part of a given RegExpLiteral.
   *
   * @param {RegExpValidationState} state The state to validate RegExp.
   * @returns {void}
   */
  pp$1.validateRegExpPattern = function(state) {
    this.regexp_pattern(state);

    // The goal symbol for the parse is |Pattern[~U, ~N]|. If the result of
    // parsing contains a |GroupName|, reparse with the goal symbol
    // |Pattern[~U, +N]| and use this result instead. Throw a *SyntaxError*
    // exception if _P_ did not conform to the grammar, if any elements of _P_
    // were not matched by the parse, or if any Early Error conditions exist.
    if (!state.switchN && this.options.ecmaVersion >= 9 && hasProp(state.groupNames)) {
      state.switchN = true;
      this.regexp_pattern(state);
    }
  };

  // https://www.ecma-international.org/ecma-262/8.0/#prod-Pattern
  pp$1.regexp_pattern = function(state) {
    state.pos = 0;
    state.lastIntValue = 0;
    state.lastStringValue = "";
    state.lastAssertionIsQuantifiable = false;
    state.numCapturingParens = 0;
    state.maxBackReference = 0;
    state.groupNames = Object.create(null);
    state.backReferenceNames.length = 0;
    state.branchID = null;

    this.regexp_disjunction(state);

    if (state.pos !== state.source.length) {
      // Make the same messages as V8.
      if (state.eat(0x29 /* ) */)) {
        state.raise("Unmatched ')'");
      }
      if (state.eat(0x5D /* ] */) || state.eat(0x7D /* } */)) {
        state.raise("Lone quantifier brackets");
      }
    }
    if (state.maxBackReference > state.numCapturingParens) {
      state.raise("Invalid escape");
    }
    for (var i = 0, list = state.backReferenceNames; i < list.length; i += 1) {
      var name = list[i];

      if (!state.groupNames[name]) {
        state.raise("Invalid named capture referenced");
      }
    }
  };

  // https://www.ecma-international.org/ecma-262/8.0/#prod-Disjunction
  pp$1.regexp_disjunction = function(state) {
    var trackDisjunction = this.options.ecmaVersion >= 16;
    if (trackDisjunction) { state.branchID = new BranchID(state.branchID, null); }
    this.regexp_alternative(state);
    while (state.eat(0x7C /* | */)) {
      if (trackDisjunction) { state.branchID = state.branchID.sibling(); }
      this.regexp_alternative(state);
    }
    if (trackDisjunction) { state.branchID = state.branchID.parent; }

    // Make the same message as V8.
    if (this.regexp_eatQuantifier(state, true)) {
      state.raise("Nothing to repeat");
    }
    if (state.eat(0x7B /* { */)) {
      state.raise("Lone quantifier brackets");
    }
  };

  // https://www.ecma-international.org/ecma-262/8.0/#prod-Alternative
  pp$1.regexp_alternative = function(state) {
    while (state.pos < state.source.length && this.regexp_eatTerm(state)) {}
  };

  // https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-Term
  pp$1.regexp_eatTerm = function(state) {
    if (this.regexp_eatAssertion(state)) {
      // Handle `QuantifiableAssertion Quantifier` alternative.
      // `state.lastAssertionIsQuantifiable` is true if the last eaten Assertion
      // is a QuantifiableAssertion.
      if (state.lastAssertionIsQuantifiable && this.regexp_eatQuantifier(state)) {
        // Make the same message as V8.
        if (state.switchU) {
          state.raise("Invalid quantifier");
        }
      }
      return true
    }

    if (state.switchU ? this.regexp_eatAtom(state) : this.regexp_eatExtendedAtom(state)) {
      this.regexp_eatQuantifier(state);
      return true
    }

    return false
  };

  // https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-Assertion
  pp$1.regexp_eatAssertion = function(state) {
    var start = state.pos;
    state.lastAssertionIsQuantifiable = false;

    // ^, $
    if (state.eat(0x5E /* ^ */) || state.eat(0x24 /* $ */)) {
      return true
    }

    // \b \B
    if (state.eat(0x5C /* \ */)) {
      if (state.eat(0x42 /* B */) || state.eat(0x62 /* b */)) {
        return true
      }
      state.pos = start;
    }

    // Lookahead / Lookbehind
    if (state.eat(0x28 /* ( */) && state.eat(0x3F /* ? */)) {
      var lookbehind = false;
      if (this.options.ecmaVersion >= 9) {
        lookbehind = state.eat(0x3C /* < */);
      }
      if (state.eat(0x3D /* = */) || state.eat(0x21 /* ! */)) {
        this.regexp_disjunction(state);
        if (!state.eat(0x29 /* ) */)) {
          state.raise("Unterminated group");
        }
        state.lastAssertionIsQuantifiable = !lookbehind;
        return true
      }
    }

    state.pos = start;
    return false
  };

  // https://www.ecma-international.org/ecma-262/8.0/#prod-Quantifier
  pp$1.regexp_eatQuantifier = function(state, noError) {
    if ( noError === void 0 ) noError = false;

    if (this.regexp_eatQuantifierPrefix(state, noError)) {
      state.eat(0x3F /* ? */);
      return true
    }
    return false
  };

  // https://www.ecma-international.org/ecma-262/8.0/#prod-QuantifierPrefix
  pp$1.regexp_eatQuantifierPrefix = function(state, noError) {
    return (
      state.eat(0x2A /* * */) ||
      state.eat(0x2B /* + */) ||
      state.eat(0x3F /* ? */) ||
      this.regexp_eatBracedQuantifier(state, noError)
    )
  };
  pp$1.regexp_eatBracedQuantifier = function(state, noError) {
    var start = state.pos;
    if (state.eat(0x7B /* { */)) {
      var min = 0, max = -1;
      if (this.regexp_eatDecimalDigits(state)) {
        min = state.lastIntValue;
        if (state.eat(0x2C /* , */) && this.regexp_eatDecimalDigits(state)) {
          max = state.lastIntValue;
        }
        if (state.eat(0x7D /* } */)) {
          // SyntaxError in https://www.ecma-international.org/ecma-262/8.0/#sec-term
          if (max !== -1 && max < min && !noError) {
            state.raise("numbers out of order in {} quantifier");
          }
          return true
        }
      }
      if (state.switchU && !noError) {
        state.raise("Incomplete quantifier");
      }
      state.pos = start;
    }
    return false
  };

  // https://www.ecma-international.org/ecma-262/8.0/#prod-Atom
  pp$1.regexp_eatAtom = function(state) {
    return (
      this.regexp_eatPatternCharacters(state) ||
      state.eat(0x2E /* . */) ||
      this.regexp_eatReverseSolidusAtomEscape(state) ||
      this.regexp_eatCharacterClass(state) ||
      this.regexp_eatUncapturingGroup(state) ||
      this.regexp_eatCapturingGroup(state)
    )
  };
  pp$1.regexp_eatReverseSolidusAtomEscape = function(state) {
    var start = state.pos;
    if (state.eat(0x5C /* \ */)) {
      if (this.regexp_eatAtomEscape(state)) {
        return true
      }
      state.pos = start;
    }
    return false
  };
  pp$1.regexp_eatUncapturingGroup = function(state) {
    var start = state.pos;
    if (state.eat(0x28 /* ( */)) {
      if (state.eat(0x3F /* ? */)) {
        if (this.options.ecmaVersion >= 16) {
          var addModifiers = this.regexp_eatModifiers(state);
          var hasHyphen = state.eat(0x2D /* - */);
          if (addModifiers || hasHyphen) {
            for (var i = 0; i < addModifiers.length; i++) {
              var modifier = addModifiers.charAt(i);
              if (addModifiers.indexOf(modifier, i + 1) > -1) {
                state.raise("Duplicate regular expression modifiers");
              }
            }
            if (hasHyphen) {
              var removeModifiers = this.regexp_eatModifiers(state);
              if (!addModifiers && !removeModifiers && state.current() === 0x3A /* : */) {
                state.raise("Invalid regular expression modifiers");
              }
              for (var i$1 = 0; i$1 < removeModifiers.length; i$1++) {
                var modifier$1 = removeModifiers.charAt(i$1);
                if (
                  removeModifiers.indexOf(modifier$1, i$1 + 1) > -1 ||
                  addModifiers.indexOf(modifier$1) > -1
                ) {
                  state.raise("Duplicate regular expression modifiers");
                }
              }
            }
          }
        }
        if (state.eat(0x3A /* : */)) {
          this.regexp_disjunction(state);
          if (state.eat(0x29 /* ) */)) {
            return true
          }
          state.raise("Unterminated group");
        }
      }
      state.pos = start;
    }
    return false
  };
  pp$1.regexp_eatCapturingGroup = function(state) {
    if (state.eat(0x28 /* ( */)) {
      if (this.options.ecmaVersion >= 9) {
        this.regexp_groupSpecifier(state);
      } else if (state.current() === 0x3F /* ? */) {
        state.raise("Invalid group");
      }
      this.regexp_disjunction(state);
      if (state.eat(0x29 /* ) */)) {
        state.numCapturingParens += 1;
        return true
      }
      state.raise("Unterminated group");
    }
    return false
  };
  // RegularExpressionModifiers ::
  //   [empty]
  //   RegularExpressionModifiers RegularExpressionModifier
  pp$1.regexp_eatModifiers = function(state) {
    var modifiers = "";
    var ch = 0;
    while ((ch = state.current()) !== -1 && isRegularExpressionModifier(ch)) {
      modifiers += codePointToString(ch);
      state.advance();
    }
    return modifiers
  };
  // RegularExpressionModifier :: one of
  //   `i` `m` `s`
  function isRegularExpressionModifier(ch) {
    return ch === 0x69 /* i */ || ch === 0x6d /* m */ || ch === 0x73 /* s */
  }

  // https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-ExtendedAtom
  pp$1.regexp_eatExtendedAtom = function(state) {
    return (
      state.eat(0x2E /* . */) ||
      this.regexp_eatReverseSolidusAtomEscape(state) ||
      this.regexp_eatCharacterClass(state) ||
      this.regexp_eatUncapturingGroup(state) ||
      this.regexp_eatCapturingGroup(state) ||
      this.regexp_eatInvalidBracedQuantifier(state) ||
      this.regexp_eatExtendedPatternCharacter(state)
    )
  };

  // https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-InvalidBracedQuantifier
  pp$1.regexp_eatInvalidBracedQuantifier = function(state) {
    if (this.regexp_eatBracedQuantifier(state, true)) {
      state.raise("Nothing to repeat");
    }
    return false
  };

  // https://www.ecma-international.org/ecma-262/8.0/#prod-SyntaxCharacter
  pp$1.regexp_eatSyntaxCharacter = function(state) {
    var ch = state.current();
    if (isSyntaxCharacter(ch)) {
      state.lastIntValue = ch;
      state.advance();
      return true
    }
    return false
  };
  function isSyntaxCharacter(ch) {
    return (
      ch === 0x24 /* $ */ ||
      ch >= 0x28 /* ( */ && ch <= 0x2B /* + */ ||
      ch === 0x2E /* . */ ||
      ch === 0x3F /* ? */ ||
      ch >= 0x5B /* [ */ && ch <= 0x5E /* ^ */ ||
      ch >= 0x7B /* { */ && ch <= 0x7D /* } */
    )
  }

  // https://www.ecma-international.org/ecma-262/8.0/#prod-PatternCharacter
  // But eat eager.
  pp$1.regexp_eatPatternCharacters = function(state) {
    var start = state.pos;
    var ch = 0;
    while ((ch = state.current()) !== -1 && !isSyntaxCharacter(ch)) {
      state.advance();
    }
    return state.pos !== start
  };

  // https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-ExtendedPatternCharacter
  pp$1.regexp_eatExtendedPatternCharacter = function(state) {
    var ch = state.current();
    if (
      ch !== -1 &&
      ch !== 0x24 /* $ */ &&
      !(ch >= 0x28 /* ( */ && ch <= 0x2B /* + */) &&
      ch !== 0x2E /* . */ &&
      ch !== 0x3F /* ? */ &&
      ch !== 0x5B /* [ */ &&
      ch !== 0x5E /* ^ */ &&
      ch !== 0x7C /* | */
    ) {
      state.advance();
      return true
    }
    return false
  };

  // GroupSpecifier ::
  //   [empty]
  //   `?` GroupName
  pp$1.regexp_groupSpecifier = function(state) {
    if (state.eat(0x3F /* ? */)) {
      if (!this.regexp_eatGroupName(state)) { state.raise("Invalid group"); }
      var trackDisjunction = this.options.ecmaVersion >= 16;
      var known = state.groupNames[state.lastStringValue];
      if (known) {
        if (trackDisjunction) {
          for (var i = 0, list = known; i < list.length; i += 1) {
            var altID = list[i];

            if (!altID.separatedFrom(state.branchID))
              { state.raise("Duplicate capture group name"); }
          }
        } else {
          state.raise("Duplicate capture group name");
        }
      }
      if (trackDisjunction) {
        (known || (state.groupNames[state.lastStringValue] = [])).push(state.branchID);
      } else {
        state.groupNames[state.lastStringValue] = true;
      }
    }
  };

  // GroupName ::
  //   `<` RegExpIdentifierName `>`
  // Note: this updates `state.lastStringValue` property with the eaten name.
  pp$1.regexp_eatGroupName = function(state) {
    state.lastStringValue = "";
    if (state.eat(0x3C /* < */)) {
      if (this.regexp_eatRegExpIdentifierName(state) && state.eat(0x3E /* > */)) {
        return true
      }
      state.raise("Invalid capture group name");
    }
    return false
  };

  // RegExpIdentifierName ::
  //   RegExpIdentifierStart
  //   RegExpIdentifierName RegExpIdentifierPart
  // Note: this updates `state.lastStringValue` property with the eaten name.
  pp$1.regexp_eatRegExpIdentifierName = function(state) {
    state.lastStringValue = "";
    if (this.regexp_eatRegExpIdentifierStart(state)) {
      state.lastStringValue += codePointToString(state.lastIntValue);
      while (this.regexp_eatRegExpIdentifierPart(state)) {
        state.lastStringValue += codePointToString(state.lastIntValue);
      }
      return true
    }
    return false
  };

  // RegExpIdentifierStart ::
  //   UnicodeIDStart
  //   `$`
  //   `_`
  //   `\` RegExpUnicodeEscapeSequence[+U]
  pp$1.regexp_eatRegExpIdentifierStart = function(state) {
    var start = state.pos;
    var forceU = this.options.ecmaVersion >= 11;
    var ch = state.current(forceU);
    state.advance(forceU);

    if (ch === 0x5C /* \ */ && this.regexp_eatRegExpUnicodeEscapeSequence(state, forceU)) {
      ch = state.lastIntValue;
    }
    if (isRegExpIdentifierStart(ch)) {
      state.lastIntValue = ch;
      return true
    }

    state.pos = start;
    return false
  };
  function isRegExpIdentifierStart(ch) {
    return isIdentifierStart(ch, true) || ch === 0x24 /* $ */ || ch === 0x5F /* _ */
  }

  // RegExpIdentifierPart ::
  //   UnicodeIDContinue
  //   `$`
  //   `_`
  //   `\` RegExpUnicodeEscapeSequence[+U]
  //   <ZWNJ>
  //   <ZWJ>
  pp$1.regexp_eatRegExpIdentifierPart = function(state) {
    var start = state.pos;
    var forceU = this.options.ecmaVersion >= 11;
    var ch = state.current(forceU);
    state.advance(forceU);

    if (ch === 0x5C /* \ */ && this.regexp_eatRegExpUnicodeEscapeSequence(state, forceU)) {
      ch = state.lastIntValue;
    }
    if (isRegExpIdentifierPart(ch)) {
      state.lastIntValue = ch;
      return true
    }

    state.pos = start;
    return false
  };
  function isRegExpIdentifierPart(ch) {
    return isIdentifierChar(ch, true) || ch === 0x24 /* $ */ || ch === 0x5F /* _ */ || ch === 0x200C /* <ZWNJ> */ || ch === 0x200D /* <ZWJ> */
  }

  // https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-AtomEscape
  pp$1.regexp_eatAtomEscape = function(state) {
    if (
      this.regexp_eatBackReference(state) ||
      this.regexp_eatCharacterClassEscape(state) ||
      this.regexp_eatCharacterEscape(state) ||
      (state.switchN && this.regexp_eatKGroupName(state))
    ) {
      return true
    }
    if (state.switchU) {
      // Make the same message as V8.
      if (state.current() === 0x63 /* c */) {
        state.raise("Invalid unicode escape");
      }
      state.raise("Invalid escape");
    }
    return false
  };
  pp$1.regexp_eatBackReference = function(state) {
    var start = state.pos;
    if (this.regexp_eatDecimalEscape(state)) {
      var n = state.lastIntValue;
      if (state.switchU) {
        // For SyntaxError in https://www.ecma-international.org/ecma-262/8.0/#sec-atomescape
        if (n > state.maxBackReference) {
          state.maxBackReference = n;
        }
        return true
      }
      if (n <= state.numCapturingParens) {
        return true
      }
      state.pos = start;
    }
    return false
  };
  pp$1.regexp_eatKGroupName = function(state) {
    if (state.eat(0x6B /* k */)) {
      if (this.regexp_eatGroupName(state)) {
        state.backReferenceNames.push(state.lastStringValue);
        return true
      }
      state.raise("Invalid named reference");
    }
    return false
  };

  // https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-CharacterEscape
  pp$1.regexp_eatCharacterEscape = function(state) {
    return (
      this.regexp_eatControlEscape(state) ||
      this.regexp_eatCControlLetter(state) ||
      this.regexp_eatZero(state) ||
      this.regexp_eatHexEscapeSequence(state) ||
      this.regexp_eatRegExpUnicodeEscapeSequence(state, false) ||
      (!state.switchU && this.regexp_eatLegacyOctalEscapeSequence(state)) ||
      this.regexp_eatIdentityEscape(state)
    )
  };
  pp$1.regexp_eatCControlLetter = function(state) {
    var start = state.pos;
    if (state.eat(0x63 /* c */)) {
      if (this.regexp_eatControlLetter(state)) {
        return true
      }
      state.pos = start;
    }
    return false
  };
  pp$1.regexp_eatZero = function(state) {
    if (state.current() === 0x30 /* 0 */ && !isDecimalDigit(state.lookahead())) {
      state.lastIntValue = 0;
      state.advance();
      return true
    }
    return false
  };

  // https://www.ecma-international.org/ecma-262/8.0/#prod-ControlEscape
  pp$1.regexp_eatControlEscape = function(state) {
    var ch = state.current();
    if (ch === 0x74 /* t */) {
      state.lastIntValue = 0x09; /* \t */
      state.advance();
      return true
    }
    if (ch === 0x6E /* n */) {
      state.lastIntValue = 0x0A; /* \n */
      state.advance();
      return true
    }
    if (ch === 0x76 /* v */) {
      state.lastIntValue = 0x0B; /* \v */
      state.advance();
      return true
    }
    if (ch === 0x66 /* f */) {
      state.lastIntValue = 0x0C; /* \f */
      state.advance();
      return true
    }
    if (ch === 0x72 /* r */) {
      state.lastIntValue = 0x0D; /* \r */
      state.advance();
      return true
    }
    return false
  };

  // https://www.ecma-international.org/ecma-262/8.0/#prod-ControlLetter
  pp$1.regexp_eatControlLetter = function(state) {
    var ch = state.current();
    if (isControlLetter(ch)) {
      state.lastIntValue = ch % 0x20;
      state.advance();
      return true
    }
    return false
  };
  function isControlLetter(ch) {
    return (
      (ch >= 0x41 /* A */ && ch <= 0x5A /* Z */) ||
      (ch >= 0x61 /* a */ && ch <= 0x7A /* z */)
    )
  }

  // https://www.ecma-international.org/ecma-262/8.0/#prod-RegExpUnicodeEscapeSequence
  pp$1.regexp_eatRegExpUnicodeEscapeSequence = function(state, forceU) {
    if ( forceU === void 0 ) forceU = false;

    var start = state.pos;
    var switchU = forceU || state.switchU;

    if (state.eat(0x75 /* u */)) {
      if (this.regexp_eatFixedHexDigits(state, 4)) {
        var lead = state.lastIntValue;
        if (switchU && lead >= 0xD800 && lead <= 0xDBFF) {
          var leadSurrogateEnd = state.pos;
          if (state.eat(0x5C /* \ */) && state.eat(0x75 /* u */) && this.regexp_eatFixedHexDigits(state, 4)) {
            var trail = state.lastIntValue;
            if (trail >= 0xDC00 && trail <= 0xDFFF) {
              state.lastIntValue = (lead - 0xD800) * 0x400 + (trail - 0xDC00) + 0x10000;
              return true
            }
          }
          state.pos = leadSurrogateEnd;
          state.lastIntValue = lead;
        }
        return true
      }
      if (
        switchU &&
        state.eat(0x7B /* { */) &&
        this.regexp_eatHexDigits(state) &&
        state.eat(0x7D /* } */) &&
        isValidUnicode(state.lastIntValue)
      ) {
        return true
      }
      if (switchU) {
        state.raise("Invalid unicode escape");
      }
      state.pos = start;
    }

    return false
  };
  function isValidUnicode(ch) {
    return ch >= 0 && ch <= 0x10FFFF
  }

  // https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-IdentityEscape
  pp$1.regexp_eatIdentityEscape = function(state) {
    if (state.switchU) {
      if (this.regexp_eatSyntaxCharacter(state)) {
        return true
      }
      if (state.eat(0x2F /* / */)) {
        state.lastIntValue = 0x2F; /* / */
        return true
      }
      return false
    }

    var ch = state.current();
    if (ch !== 0x63 /* c */ && (!state.switchN || ch !== 0x6B /* k */)) {
      state.lastIntValue = ch;
      state.advance();
      return true
    }

    return false
  };

  // https://www.ecma-international.org/ecma-262/8.0/#prod-DecimalEscape
  pp$1.regexp_eatDecimalEscape = function(state) {
    state.lastIntValue = 0;
    var ch = state.current();
    if (ch >= 0x31 /* 1 */ && ch <= 0x39 /* 9 */) {
      do {
        state.lastIntValue = 10 * state.lastIntValue + (ch - 0x30 /* 0 */);
        state.advance();
      } while ((ch = state.current()) >= 0x30 /* 0 */ && ch <= 0x39 /* 9 */)
      return true
    }
    return false
  };

  // Return values used by character set parsing methods, needed to
  // forbid negation of sets that can match strings.
  var CharSetNone = 0; // Nothing parsed
  var CharSetOk = 1; // Construct parsed, cannot contain strings
  var CharSetString = 2; // Construct parsed, can contain strings

  // https://www.ecma-international.org/ecma-262/8.0/#prod-CharacterClassEscape
  pp$1.regexp_eatCharacterClassEscape = function(state) {
    var ch = state.current();

    if (isCharacterClassEscape(ch)) {
      state.lastIntValue = -1;
      state.advance();
      return CharSetOk
    }

    var negate = false;
    if (
      state.switchU &&
      this.options.ecmaVersion >= 9 &&
      ((negate = ch === 0x50 /* P */) || ch === 0x70 /* p */)
    ) {
      state.lastIntValue = -1;
      state.advance();
      var result;
      if (
        state.eat(0x7B /* { */) &&
        (result = this.regexp_eatUnicodePropertyValueExpression(state)) &&
        state.eat(0x7D /* } */)
      ) {
        if (negate && result === CharSetString) { state.raise("Invalid property name"); }
        return result
      }
      state.raise("Invalid property name");
    }

    return CharSetNone
  };

  function isCharacterClassEscape(ch) {
    return (
      ch === 0x64 /* d */ ||
      ch === 0x44 /* D */ ||
      ch === 0x73 /* s */ ||
      ch === 0x53 /* S */ ||
      ch === 0x77 /* w */ ||
      ch === 0x57 /* W */
    )
  }

  // UnicodePropertyValueExpression ::
  //   UnicodePropertyName `=` UnicodePropertyValue
  //   LoneUnicodePropertyNameOrValue
  pp$1.regexp_eatUnicodePropertyValueExpression = function(state) {
    var start = state.pos;

    // UnicodePropertyName `=` UnicodePropertyValue
    if (this.regexp_eatUnicodePropertyName(state) && state.eat(0x3D /* = */)) {
      var name = state.lastStringValue;
      if (this.regexp_eatUnicodePropertyValue(state)) {
        var value = state.lastStringValue;
        this.regexp_validateUnicodePropertyNameAndValue(state, name, value);
        return CharSetOk
      }
    }
    state.pos = start;

    // LoneUnicodePropertyNameOrValue
    if (this.regexp_eatLoneUnicodePropertyNameOrValue(state)) {
      var nameOrValue = state.lastStringValue;
      return this.regexp_validateUnicodePropertyNameOrValue(state, nameOrValue)
    }
    return CharSetNone
  };

  pp$1.regexp_validateUnicodePropertyNameAndValue = function(state, name, value) {
    if (!hasOwn(state.unicodeProperties.nonBinary, name))
      { state.raise("Invalid property name"); }
    if (!state.unicodeProperties.nonBinary[name].test(value))
      { state.raise("Invalid property value"); }
  };

  pp$1.regexp_validateUnicodePropertyNameOrValue = function(state, nameOrValue) {
    if (state.unicodeProperties.binary.test(nameOrValue)) { return CharSetOk }
    if (state.switchV && state.unicodeProperties.binaryOfStrings.test(nameOrValue)) { return CharSetString }
    state.raise("Invalid property name");
  };

  // UnicodePropertyName ::
  //   UnicodePropertyNameCharacters
  pp$1.regexp_eatUnicodePropertyName = function(state) {
    var ch = 0;
    state.lastStringValue = "";
    while (isUnicodePropertyNameCharacter(ch = state.current())) {
      state.lastStringValue += codePointToString(ch);
      state.advance();
    }
    return state.lastStringValue !== ""
  };

  function isUnicodePropertyNameCharacter(ch) {
    return isControlLetter(ch) || ch === 0x5F /* _ */
  }

  // UnicodePropertyValue ::
  //   UnicodePropertyValueCharacters
  pp$1.regexp_eatUnicodePropertyValue = function(state) {
    var ch = 0;
    state.lastStringValue = "";
    while (isUnicodePropertyValueCharacter(ch = state.current())) {
      state.lastStringValue += codePointToString(ch);
      state.advance();
    }
    return state.lastStringValue !== ""
  };
  function isUnicodePropertyValueCharacter(ch) {
    return isUnicodePropertyNameCharacter(ch) || isDecimalDigit(ch)
  }

  // LoneUnicodePropertyNameOrValue ::
  //   UnicodePropertyValueCharacters
  pp$1.regexp_eatLoneUnicodePropertyNameOrValue = function(state) {
    return this.regexp_eatUnicodePropertyValue(state)
  };

  // https://www.ecma-international.org/ecma-262/8.0/#prod-CharacterClass
  pp$1.regexp_eatCharacterClass = function(state) {
    if (state.eat(0x5B /* [ */)) {
      var negate = state.eat(0x5E /* ^ */);
      var result = this.regexp_classContents(state);
      if (!state.eat(0x5D /* ] */))
        { state.raise("Unterminated character class"); }
      if (negate && result === CharSetString)
        { state.raise("Negated character class may contain strings"); }
      return true
    }
    return false
  };

  // https://tc39.es/ecma262/#prod-ClassContents
  // https://www.ecma-international.org/ecma-262/8.0/#prod-ClassRanges
  pp$1.regexp_classContents = function(state) {
    if (state.current() === 0x5D /* ] */) { return CharSetOk }
    if (state.switchV) { return this.regexp_classSetExpression(state) }
    this.regexp_nonEmptyClassRanges(state);
    return CharSetOk
  };

  // https://www.ecma-international.org/ecma-262/8.0/#prod-NonemptyClassRanges
  // https://www.ecma-international.org/ecma-262/8.0/#prod-NonemptyClassRangesNoDash
  pp$1.regexp_nonEmptyClassRanges = function(state) {
    while (this.regexp_eatClassAtom(state)) {
      var left = state.lastIntValue;
      if (state.eat(0x2D /* - */) && this.regexp_eatClassAtom(state)) {
        var right = state.lastIntValue;
        if (state.switchU && (left === -1 || right === -1)) {
          state.raise("Invalid character class");
        }
        if (left !== -1 && right !== -1 && left > right) {
          state.raise("Range out of order in character class");
        }
      }
    }
  };

  // https://www.ecma-international.org/ecma-262/8.0/#prod-ClassAtom
  // https://www.ecma-international.org/ecma-262/8.0/#prod-ClassAtomNoDash
  pp$1.regexp_eatClassAtom = function(state) {
    var start = state.pos;

    if (state.eat(0x5C /* \ */)) {
      if (this.regexp_eatClassEscape(state)) {
        return true
      }
      if (state.switchU) {
        // Make the same message as V8.
        var ch$1 = state.current();
        if (ch$1 === 0x63 /* c */ || isOctalDigit(ch$1)) {
          state.raise("Invalid class escape");
        }
        state.raise("Invalid escape");
      }
      state.pos = start;
    }

    var ch = state.current();
    if (ch !== 0x5D /* ] */) {
      state.lastIntValue = ch;
      state.advance();
      return true
    }

    return false
  };

  // https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-ClassEscape
  pp$1.regexp_eatClassEscape = function(state) {
    var start = state.pos;

    if (state.eat(0x62 /* b */)) {
      state.lastIntValue = 0x08; /* <BS> */
      return true
    }

    if (state.switchU && state.eat(0x2D /* - */)) {
      state.lastIntValue = 0x2D; /* - */
      return true
    }

    if (!state.switchU && state.eat(0x63 /* c */)) {
      if (this.regexp_eatClassControlLetter(state)) {
        return true
      }
      state.pos = start;
    }

    return (
      this.regexp_eatCharacterClassEscape(state) ||
      this.regexp_eatCharacterEscape(state)
    )
  };

  // https://tc39.es/ecma262/#prod-ClassSetExpression
  // https://tc39.es/ecma262/#prod-ClassUnion
  // https://tc39.es/ecma262/#prod-ClassIntersection
  // https://tc39.es/ecma262/#prod-ClassSubtraction
  pp$1.regexp_classSetExpression = function(state) {
    var result = CharSetOk, subResult;
    if (this.regexp_eatClassSetRange(state)) ; else if (subResult = this.regexp_eatClassSetOperand(state)) {
      if (subResult === CharSetString) { result = CharSetString; }
      // https://tc39.es/ecma262/#prod-ClassIntersection
      var start = state.pos;
      while (state.eatChars([0x26, 0x26] /* && */)) {
        if (
          state.current() !== 0x26 /* & */ &&
          (subResult = this.regexp_eatClassSetOperand(state))
        ) {
          if (subResult !== CharSetString) { result = CharSetOk; }
          continue
        }
        state.raise("Invalid character in character class");
      }
      if (start !== state.pos) { return result }
      // https://tc39.es/ecma262/#prod-ClassSubtraction
      while (state.eatChars([0x2D, 0x2D] /* -- */)) {
        if (this.regexp_eatClassSetOperand(state)) { continue }
        state.raise("Invalid character in character class");
      }
      if (start !== state.pos) { return result }
    } else {
      state.raise("Invalid character in character class");
    }
    // https://tc39.es/ecma262/#prod-ClassUnion
    for (;;) {
      if (this.regexp_eatClassSetRange(state)) { continue }
      subResult = this.regexp_eatClassSetOperand(state);
      if (!subResult) { return result }
      if (subResult === CharSetString) { result = CharSetString; }
    }
  };

  // https://tc39.es/ecma262/#prod-ClassSetRange
  pp$1.regexp_eatClassSetRange = function(state) {
    var start = state.pos;
    if (this.regexp_eatClassSetCharacter(state)) {
      var left = state.lastIntValue;
      if (state.eat(0x2D /* - */) && this.regexp_eatClassSetCharacter(state)) {
        var right = state.lastIntValue;
        if (left !== -1 && right !== -1 && left > right) {
          state.raise("Range out of order in character class");
        }
        return true
      }
      state.pos = start;
    }
    return false
  };

  // https://tc39.es/ecma262/#prod-ClassSetOperand
  pp$1.regexp_eatClassSetOperand = function(state) {
    if (this.regexp_eatClassSetCharacter(state)) { return CharSetOk }
    return this.regexp_eatClassStringDisjunction(state) || this.regexp_eatNestedClass(state)
  };

  // https://tc39.es/ecma262/#prod-NestedClass
  pp$1.regexp_eatNestedClass = function(state) {
    var start = state.pos;
    if (state.eat(0x5B /* [ */)) {
      var negate = state.eat(0x5E /* ^ */);
      var result = this.regexp_classContents(state);
      if (state.eat(0x5D /* ] */)) {
        if (negate && result === CharSetString) {
          state.raise("Negated character class may contain strings");
        }
        return result
      }
      state.pos = start;
    }
    if (state.eat(0x5C /* \ */)) {
      var result$1 = this.regexp_eatCharacterClassEscape(state);
      if (result$1) {
        return result$1
      }
      state.pos = start;
    }
    return null
  };

  // https://tc39.es/ecma262/#prod-ClassStringDisjunction
  pp$1.regexp_eatClassStringDisjunction = function(state) {
    var start = state.pos;
    if (state.eatChars([0x5C, 0x71] /* \q */)) {
      if (state.eat(0x7B /* { */)) {
        var result = this.regexp_classStringDisjunctionContents(state);
        if (state.eat(0x7D /* } */)) {
          return result
        }
      } else {
        // Make the same message as V8.
        state.raise("Invalid escape");
      }
      state.pos = start;
    }
    return null
  };

  // https://tc39.es/ecma262/#prod-ClassStringDisjunctionContents
  pp$1.regexp_classStringDisjunctionContents = function(state) {
    var result = this.regexp_classString(state);
    while (state.eat(0x7C /* | */)) {
      if (this.regexp_classString(state) === CharSetString) { result = CharSetString; }
    }
    return result
  };

  // https://tc39.es/ecma262/#prod-ClassString
  // https://tc39.es/ecma262/#prod-NonEmptyClassString
  pp$1.regexp_classString = function(state) {
    var count = 0;
    while (this.regexp_eatClassSetCharacter(state)) { count++; }
    return count === 1 ? CharSetOk : CharSetString
  };

  // https://tc39.es/ecma262/#prod-ClassSetCharacter
  pp$1.regexp_eatClassSetCharacter = function(state) {
    var start = state.pos;
    if (state.eat(0x5C /* \ */)) {
      if (
        this.regexp_eatCharacterEscape(state) ||
        this.regexp_eatClassSetReservedPunctuator(state)
      ) {
        return true
      }
      if (state.eat(0x62 /* b */)) {
        state.lastIntValue = 0x08; /* <BS> */
        return true
      }
      state.pos = start;
      return false
    }
    var ch = state.current();
    if (ch < 0 || ch === state.lookahead() && isClassSetReservedDoublePunctuatorCharacter(ch)) { return false }
    if (isClassSetSyntaxCharacter(ch)) { return false }
    state.advance();
    state.lastIntValue = ch;
    return true
  };

  // https://tc39.es/ecma262/#prod-ClassSetReservedDoublePunctuator
  function isClassSetReservedDoublePunctuatorCharacter(ch) {
    return (
      ch === 0x21 /* ! */ ||
      ch >= 0x23 /* # */ && ch <= 0x26 /* & */ ||
      ch >= 0x2A /* * */ && ch <= 0x2C /* , */ ||
      ch === 0x2E /* . */ ||
      ch >= 0x3A /* : */ && ch <= 0x40 /* @ */ ||
      ch === 0x5E /* ^ */ ||
      ch === 0x60 /* ` */ ||
      ch === 0x7E /* ~ */
    )
  }

  // https://tc39.es/ecma262/#prod-ClassSetSyntaxCharacter
  function isClassSetSyntaxCharacter(ch) {
    return (
      ch === 0x28 /* ( */ ||
      ch === 0x29 /* ) */ ||
      ch === 0x2D /* - */ ||
      ch === 0x2F /* / */ ||
      ch >= 0x5B /* [ */ && ch <= 0x5D /* ] */ ||
      ch >= 0x7B /* { */ && ch <= 0x7D /* } */
    )
  }

  // https://tc39.es/ecma262/#prod-ClassSetReservedPunctuator
  pp$1.regexp_eatClassSetReservedPunctuator = function(state) {
    var ch = state.current();
    if (isClassSetReservedPunctuator(ch)) {
      state.lastIntValue = ch;
      state.advance();
      return true
    }
    return false
  };

  // https://tc39.es/ecma262/#prod-ClassSetReservedPunctuator
  function isClassSetReservedPunctuator(ch) {
    return (
      ch === 0x21 /* ! */ ||
      ch === 0x23 /* # */ ||
      ch === 0x25 /* % */ ||
      ch === 0x26 /* & */ ||
      ch === 0x2C /* , */ ||
      ch === 0x2D /* - */ ||
      ch >= 0x3A /* : */ && ch <= 0x3E /* > */ ||
      ch === 0x40 /* @ */ ||
      ch === 0x60 /* ` */ ||
      ch === 0x7E /* ~ */
    )
  }

  // https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-ClassControlLetter
  pp$1.regexp_eatClassControlLetter = function(state) {
    var ch = state.current();
    if (isDecimalDigit(ch) || ch === 0x5F /* _ */) {
      state.lastIntValue = ch % 0x20;
      state.advance();
      return true
    }
    return false
  };

  // https://www.ecma-international.org/ecma-262/8.0/#prod-HexEscapeSequence
  pp$1.regexp_eatHexEscapeSequence = function(state) {
    var start = state.pos;
    if (state.eat(0x78 /* x */)) {
      if (this.regexp_eatFixedHexDigits(state, 2)) {
        return true
      }
      if (state.switchU) {
        state.raise("Invalid escape");
      }
      state.pos = start;
    }
    return false
  };

  // https://www.ecma-international.org/ecma-262/8.0/#prod-DecimalDigits
  pp$1.regexp_eatDecimalDigits = function(state) {
    var start = state.pos;
    var ch = 0;
    state.lastIntValue = 0;
    while (isDecimalDigit(ch = state.current())) {
      state.lastIntValue = 10 * state.lastIntValue + (ch - 0x30 /* 0 */);
      state.advance();
    }
    return state.pos !== start
  };
  function isDecimalDigit(ch) {
    return ch >= 0x30 /* 0 */ && ch <= 0x39 /* 9 */
  }

  // https://www.ecma-international.org/ecma-262/8.0/#prod-HexDigits
  pp$1.regexp_eatHexDigits = function(state) {
    var start = state.pos;
    var ch = 0;
    state.lastIntValue = 0;
    while (isHexDigit(ch = state.current())) {
      state.lastIntValue = 16 * state.lastIntValue + hexToInt(ch);
      state.advance();
    }
    return state.pos !== start
  };
  function isHexDigit(ch) {
    return (
      (ch >= 0x30 /* 0 */ && ch <= 0x39 /* 9 */) ||
      (ch >= 0x41 /* A */ && ch <= 0x46 /* F */) ||
      (ch >= 0x61 /* a */ && ch <= 0x66 /* f */)
    )
  }
  function hexToInt(ch) {
    if (ch >= 0x41 /* A */ && ch <= 0x46 /* F */) {
      return 10 + (ch - 0x41 /* A */)
    }
    if (ch >= 0x61 /* a */ && ch <= 0x66 /* f */) {
      return 10 + (ch - 0x61 /* a */)
    }
    return ch - 0x30 /* 0 */
  }

  // https://www.ecma-international.org/ecma-262/8.0/#prod-annexB-LegacyOctalEscapeSequence
  // Allows only 0-377(octal) i.e. 0-255(decimal).
  pp$1.regexp_eatLegacyOctalEscapeSequence = function(state) {
    if (this.regexp_eatOctalDigit(state)) {
      var n1 = state.lastIntValue;
      if (this.regexp_eatOctalDigit(state)) {
        var n2 = state.lastIntValue;
        if (n1 <= 3 && this.regexp_eatOctalDigit(state)) {
          state.lastIntValue = n1 * 64 + n2 * 8 + state.lastIntValue;
        } else {
          state.lastIntValue = n1 * 8 + n2;
        }
      } else {
        state.lastIntValue = n1;
      }
      return true
    }
    return false
  };

  // https://www.ecma-international.org/ecma-262/8.0/#prod-OctalDigit
  pp$1.regexp_eatOctalDigit = function(state) {
    var ch = state.current();
    if (isOctalDigit(ch)) {
      state.lastIntValue = ch - 0x30; /* 0 */
      state.advance();
      return true
    }
    state.lastIntValue = 0;
    return false
  };
  function isOctalDigit(ch) {
    return ch >= 0x30 /* 0 */ && ch <= 0x37 /* 7 */
  }

  // https://www.ecma-international.org/ecma-262/8.0/#prod-Hex4Digits
  // https://www.ecma-international.org/ecma-262/8.0/#prod-HexDigit
  // And HexDigit HexDigit in https://www.ecma-international.org/ecma-262/8.0/#prod-HexEscapeSequence
  pp$1.regexp_eatFixedHexDigits = function(state, length) {
    var start = state.pos;
    state.lastIntValue = 0;
    for (var i = 0; i < length; ++i) {
      var ch = state.current();
      if (!isHexDigit(ch)) {
        state.pos = start;
        return false
      }
      state.lastIntValue = 16 * state.lastIntValue + hexToInt(ch);
      state.advance();
    }
    return true
  };

  // Object type used to represent tokens. Note that normally, tokens
  // simply exist as properties on the parser object. This is only
  // used for the onToken callback and the external tokenizer.

  var Token = function Token(p) {
    this.type = p.type;
    this.value = p.value;
    this.start = p.start;
    this.end = p.end;
    if (p.options.locations)
      { this.loc = new SourceLocation(p, p.startLoc, p.endLoc); }
    if (p.options.ranges)
      { this.range = [p.start, p.end]; }
  };

  // ## Tokenizer

  var pp = Parser.prototype;

  // Move to the next token

  pp.next = function(ignoreEscapeSequenceInKeyword) {
    if (!ignoreEscapeSequenceInKeyword && this.type.keyword && this.containsEsc)
      { this.raiseRecoverable(this.start, "Escape sequence in keyword " + this.type.keyword); }
    if (this.options.onToken)
      { this.options.onToken(new Token(this)); }

    this.lastTokEnd = this.end;
    this.lastTokStart = this.start;
    this.lastTokEndLoc = this.endLoc;
    this.lastTokStartLoc = this.startLoc;
    this.nextToken();
  };

  pp.getToken = function() {
    this.next();
    return new Token(this)
  };

  // If we're in an ES6 environment, make parsers iterable
  if (typeof Symbol !== "undefined")
    { pp[Symbol.iterator] = function() {
      var this$1$1 = this;

      return {
        next: function () {
          var token = this$1$1.getToken();
          return {
            done: token.type === types$1.eof,
            value: token
          }
        }
      }
    }; }

  // Toggle strict mode. Re-reads the next number or string to please
  // pedantic tests (`"use strict"; 010;` should fail).

  // Read a single token, updating the parser object's token-related
  // properties.

  pp.nextToken = function() {
    var curContext = this.curContext();
    if (!curContext || !curContext.preserveSpace) { this.skipSpace(); }

    this.start = this.pos;
    if (this.options.locations) { this.startLoc = this.curPosition(); }
    if (this.pos >= this.input.length) { return this.finishToken(types$1.eof) }

    if (curContext.override) { return curContext.override(this) }
    else { this.readToken(this.fullCharCodeAtPos()); }
  };

  pp.readToken = function(code) {
    // Identifier or keyword. '\uXXXX' sequences are allowed in
    // identifiers, so '\' also dispatches to that.
    if (isIdentifierStart(code, this.options.ecmaVersion >= 6) || code === 92 /* '\' */)
      { return this.readWord() }

    return this.getTokenFromCode(code)
  };

  pp.fullCharCodeAtPos = function() {
    var code = this.input.charCodeAt(this.pos);
    if (code <= 0xd7ff || code >= 0xdc00) { return code }
    var next = this.input.charCodeAt(this.pos + 1);
    return next <= 0xdbff || next >= 0xe000 ? code : (code << 10) + next - 0x35fdc00
  };

  pp.skipBlockComment = function() {
    var startLoc = this.options.onComment && this.curPosition();
    var start = this.pos, end = this.input.indexOf("*/", this.pos += 2);
    if (end === -1) { this.raise(this.pos - 2, "Unterminated comment"); }
    this.pos = end + 2;
    if (this.options.locations) {
      for (var nextBreak = (void 0), pos = start; (nextBreak = nextLineBreak(this.input, pos, this.pos)) > -1;) {
        ++this.curLine;
        pos = this.lineStart = nextBreak;
      }
    }
    if (this.options.onComment)
      { this.options.onComment(true, this.input.slice(start + 2, end), start, this.pos,
                             startLoc, this.curPosition()); }
  };

  pp.skipLineComment = function(startSkip) {
    var start = this.pos;
    var startLoc = this.options.onComment && this.curPosition();
    var ch = this.input.charCodeAt(this.pos += startSkip);
    while (this.pos < this.input.length && !isNewLine(ch)) {
      ch = this.input.charCodeAt(++this.pos);
    }
    if (this.options.onComment)
      { this.options.onComment(false, this.input.slice(start + startSkip, this.pos), start, this.pos,
                             startLoc, this.curPosition()); }
  };

  // Called at the start of the parse and after every token. Skips
  // whitespace and comments, and.

  pp.skipSpace = function() {
    loop: while (this.pos < this.input.length) {
      var ch = this.input.charCodeAt(this.pos);
      switch (ch) {
      case 32: case 160: // ' '
        ++this.pos;
        break
      case 13:
        if (this.input.charCodeAt(this.pos + 1) === 10) {
          ++this.pos;
        }
      case 10: case 8232: case 8233:
        ++this.pos;
        if (this.options.locations) {
          ++this.curLine;
          this.lineStart = this.pos;
        }
        break
      case 47: // '/'
        switch (this.input.charCodeAt(this.pos + 1)) {
        case 42: // '*'
          this.skipBlockComment();
          break
        case 47:
          this.skipLineComment(2);
          break
        default:
          break loop
        }
        break
      default:
        if (ch > 8 && ch < 14 || ch >= 5760 && nonASCIIwhitespace.test(String.fromCharCode(ch))) {
          ++this.pos;
        } else {
          break loop
        }
      }
    }
  };

  // Called at the end of every token. Sets `end`, `val`, and
  // maintains `context` and `exprAllowed`, and skips the space after
  // the token, so that the next one's `start` will point at the
  // right position.

  pp.finishToken = function(type, val) {
    this.end = this.pos;
    if (this.options.locations) { this.endLoc = this.curPosition(); }
    var prevType = this.type;
    this.type = type;
    this.value = val;

    this.updateContext(prevType);
  };

  // ### Token reading

  // This is the function that is called to fetch the next token. It
  // is somewhat obscure, because it works in character codes rather
  // than characters, and because operator parsing has been inlined
  // into it.
  //
  // All in the name of speed.
  //
  pp.readToken_dot = function() {
    var next = this.input.charCodeAt(this.pos + 1);
    if (next >= 48 && next <= 57) { return this.readNumber(true) }
    var next2 = this.input.charCodeAt(this.pos + 2);
    if (this.options.ecmaVersion >= 6 && next === 46 && next2 === 46) { // 46 = dot '.'
      this.pos += 3;
      return this.finishToken(types$1.ellipsis)
    } else {
      ++this.pos;
      return this.finishToken(types$1.dot)
    }
  };

  pp.readToken_slash = function() { // '/'
    var next = this.input.charCodeAt(this.pos + 1);
    if (this.exprAllowed) { ++this.pos; return this.readRegexp() }
    if (next === 61) { return this.finishOp(types$1.assign, 2) }
    return this.finishOp(types$1.slash, 1)
  };

  pp.readToken_mult_modulo_exp = function(code) { // '%*'
    var next = this.input.charCodeAt(this.pos + 1);
    var size = 1;
    var tokentype = code === 42 ? types$1.star : types$1.modulo;

    // exponentiation operator ** and **=
    if (this.options.ecmaVersion >= 7 && code === 42 && next === 42) {
      ++size;
      tokentype = types$1.starstar;
      next = this.input.charCodeAt(this.pos + 2);
    }

    if (next === 61) { return this.finishOp(types$1.assign, size + 1) }
    return this.finishOp(tokentype, size)
  };

  pp.readToken_pipe_amp = function(code) { // '|&'
    var next = this.input.charCodeAt(this.pos + 1);
    if (next === code) {
      if (this.options.ecmaVersion >= 12) {
        var next2 = this.input.charCodeAt(this.pos + 2);
        if (next2 === 61) { return this.finishOp(types$1.assign, 3) }
      }
      return this.finishOp(code === 124 ? types$1.logicalOR : types$1.logicalAND, 2)
    }
    if (next === 61) { return this.finishOp(types$1.assign, 2) }
    return this.finishOp(code === 124 ? types$1.bitwiseOR : types$1.bitwiseAND, 1)
  };

  pp.readToken_caret = function() { // '^'
    var next = this.input.charCodeAt(this.pos + 1);
    if (next === 61) { return this.finishOp(types$1.assign, 2) }
    return this.finishOp(types$1.bitwiseXOR, 1)
  };

  pp.readToken_plus_min = function(code) { // '+-'
    var next = this.input.charCodeAt(this.pos + 1);
    if (next === code) {
      if (next === 45 && !this.inModule && this.input.charCodeAt(this.pos + 2) === 62 &&
          (this.lastTokEnd === 0 || lineBreak.test(this.input.slice(this.lastTokEnd, this.pos)))) {
        // A `-->` line comment
        this.skipLineComment(3);
        this.skipSpace();
        return this.nextToken()
      }
      return this.finishOp(types$1.incDec, 2)
    }
    if (next === 61) { return this.finishOp(types$1.assign, 2) }
    return this.finishOp(types$1.plusMin, 1)
  };

  pp.readToken_lt_gt = function(code) { // '<>'
    var next = this.input.charCodeAt(this.pos + 1);
    var size = 1;
    if (next === code) {
      size = code === 62 && this.input.charCodeAt(this.pos + 2) === 62 ? 3 : 2;
      if (this.input.charCodeAt(this.pos + size) === 61) { return this.finishOp(types$1.assign, size + 1) }
      return this.finishOp(types$1.bitShift, size)
    }
    if (next === 33 && code === 60 && !this.inModule && this.input.charCodeAt(this.pos + 2) === 45 &&
        this.input.charCodeAt(this.pos + 3) === 45) {
      // `<!--`, an XML-style comment that should be interpreted as a line comment
      this.skipLineComment(4);
      this.skipSpace();
      return this.nextToken()
    }
    if (next === 61) { size = 2; }
    return this.finishOp(types$1.relational, size)
  };

  pp.readToken_eq_excl = function(code) { // '=!'
    var next = this.input.charCodeAt(this.pos + 1);
    if (next === 61) { return this.finishOp(types$1.equality, this.input.charCodeAt(this.pos + 2) === 61 ? 3 : 2) }
    if (code === 61 && next === 62 && this.options.ecmaVersion >= 6) { // '=>'
      this.pos += 2;
      return this.finishToken(types$1.arrow)
    }
    return this.finishOp(code === 61 ? types$1.eq : types$1.prefix, 1)
  };

  pp.readToken_question = function() { // '?'
    var ecmaVersion = this.options.ecmaVersion;
    if (ecmaVersion >= 11) {
      var next = this.input.charCodeAt(this.pos + 1);
      if (next === 46) {
        var next2 = this.input.charCodeAt(this.pos + 2);
        if (next2 < 48 || next2 > 57) { return this.finishOp(types$1.questionDot, 2) }
      }
      if (next === 63) {
        if (ecmaVersion >= 12) {
          var next2$1 = this.input.charCodeAt(this.pos + 2);
          if (next2$1 === 61) { return this.finishOp(types$1.assign, 3) }
        }
        return this.finishOp(types$1.coalesce, 2)
      }
    }
    return this.finishOp(types$1.question, 1)
  };

  pp.readToken_numberSign = function() { // '#'
    var ecmaVersion = this.options.ecmaVersion;
    var code = 35; // '#'
    if (ecmaVersion >= 13) {
      ++this.pos;
      code = this.fullCharCodeAtPos();
      if (isIdentifierStart(code, true) || code === 92 /* '\' */) {
        return this.finishToken(types$1.privateId, this.readWord1())
      }
    }

    this.raise(this.pos, "Unexpected character '" + codePointToString(code) + "'");
  };

  pp.getTokenFromCode = function(code) {
    switch (code) {
    // The interpretation of a dot depends on whether it is followed
    // by a digit or another two dots.
    case 46: // '.'
      return this.readToken_dot()

    // Punctuation tokens.
    case 40: ++this.pos; return this.finishToken(types$1.parenL)
    case 41: ++this.pos; return this.finishToken(types$1.parenR)
    case 59: ++this.pos; return this.finishToken(types$1.semi)
    case 44: ++this.pos; return this.finishToken(types$1.comma)
    case 91: ++this.pos; return this.finishToken(types$1.bracketL)
    case 93: ++this.pos; return this.finishToken(types$1.bracketR)
    case 123: ++this.pos; return this.finishToken(types$1.braceL)
    case 125: ++this.pos; return this.finishToken(types$1.braceR)
    case 58: ++this.pos; return this.finishToken(types$1.colon)

    case 96: // '`'
      if (this.options.ecmaVersion < 6) { break }
      ++this.pos;
      return this.finishToken(types$1.backQuote)

    case 48: // '0'
      var next = this.input.charCodeAt(this.pos + 1);
      if (next === 120 || next === 88) { return this.readRadixNumber(16) } // '0x', '0X' - hex number
      if (this.options.ecmaVersion >= 6) {
        if (next === 111 || next === 79) { return this.readRadixNumber(8) } // '0o', '0O' - octal number
        if (next === 98 || next === 66) { return this.readRadixNumber(2) } // '0b', '0B' - binary number
      }

    // Anything else beginning with a digit is an integer, octal
    // number, or float.
    case 49: case 50: case 51: case 52: case 53: case 54: case 55: case 56: case 57: // 1-9
      return this.readNumber(false)

    // Quotes produce strings.
    case 34: case 39: // '"', "'"
      return this.readString(code)

    // Operators are parsed inline in tiny state machines. '=' (61) is
    // often referred to. `finishOp` simply skips the amount of
    // characters it is given as second argument, and returns a token
    // of the type given by its first argument.
    case 47: // '/'
      return this.readToken_slash()

    case 37: case 42: // '%*'
      return this.readToken_mult_modulo_exp(code)

    case 124: case 38: // '|&'
      return this.readToken_pipe_amp(code)

    case 94: // '^'
      return this.readToken_caret()

    case 43: case 45: // '+-'
      return this.readToken_plus_min(code)

    case 60: case 62: // '<>'
      return this.readToken_lt_gt(code)

    case 61: case 33: // '=!'
      return this.readToken_eq_excl(code)

    case 63: // '?'
      return this.readToken_question()

    case 126: // '~'
      return this.finishOp(types$1.prefix, 1)

    case 35: // '#'
      return this.readToken_numberSign()
    }

    this.raise(this.pos, "Unexpected character '" + codePointToString(code) + "'");
  };

  pp.finishOp = function(type, size) {
    var str = this.input.slice(this.pos, this.pos + size);
    this.pos += size;
    return this.finishToken(type, str)
  };

  pp.readRegexp = function() {
    var escaped, inClass, start = this.pos;
    for (;;) {
      if (this.pos >= this.input.length) { this.raise(start, "Unterminated regular expression"); }
      var ch = this.input.charAt(this.pos);
      if (lineBreak.test(ch)) { this.raise(start, "Unterminated regular expression"); }
      if (!escaped) {
        if (ch === "[") { inClass = true; }
        else if (ch === "]" && inClass) { inClass = false; }
        else if (ch === "/" && !inClass) { break }
        escaped = ch === "\\";
      } else { escaped = false; }
      ++this.pos;
    }
    var pattern = this.input.slice(start, this.pos);
    ++this.pos;
    var flagsStart = this.pos;
    var flags = this.readWord1();
    if (this.containsEsc) { this.unexpected(flagsStart); }

    // Validate pattern
    var state = this.regexpState || (this.regexpState = new RegExpValidationState(this));
    state.reset(start, pattern, flags);
    this.validateRegExpFlags(state);
    this.validateRegExpPattern(state);

    // Create Literal#value property value.
    var value = null;
    try {
      value = new RegExp(pattern, flags);
    } catch (e) {
      // ESTree requires null if it failed to instantiate RegExp object.
      // https://github.com/estree/estree/blob/a27003adf4fd7bfad44de9cef372a2eacd527b1c/es5.md#regexpliteral
    }

    return this.finishToken(types$1.regexp, {pattern: pattern, flags: flags, value: value})
  };

  // Read an integer in the given radix. Return null if zero digits
  // were read, the integer value otherwise. When `len` is given, this
  // will return `null` unless the integer has exactly `len` digits.

  pp.readInt = function(radix, len, maybeLegacyOctalNumericLiteral) {
    // `len` is used for character escape sequences. In that case, disallow separators.
    var allowSeparators = this.options.ecmaVersion >= 12 && len === undefined;

    // `maybeLegacyOctalNumericLiteral` is true if it doesn't have prefix (0x,0o,0b)
    // and isn't fraction part nor exponent part. In that case, if the first digit
    // is zero then disallow separators.
    var isLegacyOctalNumericLiteral = maybeLegacyOctalNumericLiteral && this.input.charCodeAt(this.pos) === 48;

    var start = this.pos, total = 0, lastCode = 0;
    for (var i = 0, e = len == null ? Infinity : len; i < e; ++i, ++this.pos) {
      var code = this.input.charCodeAt(this.pos), val = (void 0);

      if (allowSeparators && code === 95) {
        if (isLegacyOctalNumericLiteral) { this.raiseRecoverable(this.pos, "Numeric separator is not allowed in legacy octal numeric literals"); }
        if (lastCode === 95) { this.raiseRecoverable(this.pos, "Numeric separator must be exactly one underscore"); }
        if (i === 0) { this.raiseRecoverable(this.pos, "Numeric separator is not allowed at the first of digits"); }
        lastCode = code;
        continue
      }

      if (code >= 97) { val = code - 97 + 10; } // a
      else if (code >= 65) { val = code - 65 + 10; } // A
      else if (code >= 48 && code <= 57) { val = code - 48; } // 0-9
      else { val = Infinity; }
      if (val >= radix) { break }
      lastCode = code;
      total = total * radix + val;
    }

    if (allowSeparators && lastCode === 95) { this.raiseRecoverable(this.pos - 1, "Numeric separator is not allowed at the last of digits"); }
    if (this.pos === start || len != null && this.pos - start !== len) { return null }

    return total
  };

  function stringToNumber(str, isLegacyOctalNumericLiteral) {
    if (isLegacyOctalNumericLiteral) {
      return parseInt(str, 8)
    }

    // `parseFloat(value)` stops parsing at the first numeric separator then returns a wrong value.
    return parseFloat(str.replace(/_/g, ""))
  }

  function stringToBigInt(str) {
    if (typeof BigInt !== "function") {
      return null
    }

    // `BigInt(value)` throws syntax error if the string contains numeric separators.
    return BigInt(str.replace(/_/g, ""))
  }

  pp.readRadixNumber = function(radix) {
    var start = this.pos;
    this.pos += 2; // 0x
    var val = this.readInt(radix);
    if (val == null) { this.raise(this.start + 2, "Expected number in radix " + radix); }
    if (this.options.ecmaVersion >= 11 && this.input.charCodeAt(this.pos) === 110) {
      val = stringToBigInt(this.input.slice(start, this.pos));
      ++this.pos;
    } else if (isIdentifierStart(this.fullCharCodeAtPos())) { this.raise(this.pos, "Identifier directly after number"); }
    return this.finishToken(types$1.num, val)
  };

  // Read an integer, octal integer, or floating-point number.

  pp.readNumber = function(startsWithDot) {
    var start = this.pos;
    if (!startsWithDot && this.readInt(10, undefined, true) === null) { this.raise(start, "Invalid number"); }
    var octal = this.pos - start >= 2 && this.input.charCodeAt(start) === 48;
    if (octal && this.strict) { this.raise(start, "Invalid number"); }
    var next = this.input.charCodeAt(this.pos);
    if (!octal && !startsWithDot && this.options.ecmaVersion >= 11 && next === 110) {
      var val$1 = stringToBigInt(this.input.slice(start, this.pos));
      ++this.pos;
      if (isIdentifierStart(this.fullCharCodeAtPos())) { this.raise(this.pos, "Identifier directly after number"); }
      return this.finishToken(types$1.num, val$1)
    }
    if (octal && /[89]/.test(this.input.slice(start, this.pos))) { octal = false; }
    if (next === 46 && !octal) { // '.'
      ++this.pos;
      this.readInt(10);
      next = this.input.charCodeAt(this.pos);
    }
    if ((next === 69 || next === 101) && !octal) { // 'eE'
      next = this.input.charCodeAt(++this.pos);
      if (next === 43 || next === 45) { ++this.pos; } // '+-'
      if (this.readInt(10) === null) { this.raise(start, "Invalid number"); }
    }
    if (isIdentifierStart(this.fullCharCodeAtPos())) { this.raise(this.pos, "Identifier directly after number"); }

    var val = stringToNumber(this.input.slice(start, this.pos), octal);
    return this.finishToken(types$1.num, val)
  };

  // Read a string value, interpreting backslash-escapes.

  pp.readCodePoint = function() {
    var ch = this.input.charCodeAt(this.pos), code;

    if (ch === 123) { // '{'
      if (this.options.ecmaVersion < 6) { this.unexpected(); }
      var codePos = ++this.pos;
      code = this.readHexChar(this.input.indexOf("}", this.pos) - this.pos);
      ++this.pos;
      if (code > 0x10FFFF) { this.invalidStringToken(codePos, "Code point out of bounds"); }
    } else {
      code = this.readHexChar(4);
    }
    return code
  };

  pp.readString = function(quote) {
    var out = "", chunkStart = ++this.pos;
    for (;;) {
      if (this.pos >= this.input.length) { this.raise(this.start, "Unterminated string constant"); }
      var ch = this.input.charCodeAt(this.pos);
      if (ch === quote) { break }
      if (ch === 92) { // '\'
        out += this.input.slice(chunkStart, this.pos);
        out += this.readEscapedChar(false);
        chunkStart = this.pos;
      } else if (ch === 0x2028 || ch === 0x2029) {
        if (this.options.ecmaVersion < 10) { this.raise(this.start, "Unterminated string constant"); }
        ++this.pos;
        if (this.options.locations) {
          this.curLine++;
          this.lineStart = this.pos;
        }
      } else {
        if (isNewLine(ch)) { this.raise(this.start, "Unterminated string constant"); }
        ++this.pos;
      }
    }
    out += this.input.slice(chunkStart, this.pos++);
    return this.finishToken(types$1.string, out)
  };

  // Reads template string tokens.

  var INVALID_TEMPLATE_ESCAPE_ERROR = {};

  pp.tryReadTemplateToken = function() {
    this.inTemplateElement = true;
    try {
      this.readTmplToken();
    } catch (err) {
      if (err === INVALID_TEMPLATE_ESCAPE_ERROR) {
        this.readInvalidTemplateToken();
      } else {
        throw err
      }
    }

    this.inTemplateElement = false;
  };

  pp.invalidStringToken = function(position, message) {
    if (this.inTemplateElement && this.options.ecmaVersion >= 9) {
      throw INVALID_TEMPLATE_ESCAPE_ERROR
    } else {
      this.raise(position, message);
    }
  };

  pp.readTmplToken = function() {
    var out = "", chunkStart = this.pos;
    for (;;) {
      if (this.pos >= this.input.length) { this.raise(this.start, "Unterminated template"); }
      var ch = this.input.charCodeAt(this.pos);
      if (ch === 96 || ch === 36 && this.input.charCodeAt(this.pos + 1) === 123) { // '`', '${'
        if (this.pos === this.start && (this.type === types$1.template || this.type === types$1.invalidTemplate)) {
          if (ch === 36) {
            this.pos += 2;
            return this.finishToken(types$1.dollarBraceL)
          } else {
            ++this.pos;
            return this.finishToken(types$1.backQuote)
          }
        }
        out += this.input.slice(chunkStart, this.pos);
        return this.finishToken(types$1.template, out)
      }
      if (ch === 92) { // '\'
        out += this.input.slice(chunkStart, this.pos);
        out += this.readEscapedChar(true);
        chunkStart = this.pos;
      } else if (isNewLine(ch)) {
        out += this.input.slice(chunkStart, this.pos);
        ++this.pos;
        switch (ch) {
        case 13:
          if (this.input.charCodeAt(this.pos) === 10) { ++this.pos; }
        case 10:
          out += "\n";
          break
        default:
          out += String.fromCharCode(ch);
          break
        }
        if (this.options.locations) {
          ++this.curLine;
          this.lineStart = this.pos;
        }
        chunkStart = this.pos;
      } else {
        ++this.pos;
      }
    }
  };

  // Reads a template token to search for the end, without validating any escape sequences
  pp.readInvalidTemplateToken = function() {
    for (; this.pos < this.input.length; this.pos++) {
      switch (this.input[this.pos]) {
      case "\\":
        ++this.pos;
        break

      case "$":
        if (this.input[this.pos + 1] !== "{") { break }
        // fall through
      case "`":
        return this.finishToken(types$1.invalidTemplate, this.input.slice(this.start, this.pos))

      case "\r":
        if (this.input[this.pos + 1] === "\n") { ++this.pos; }
        // fall through
      case "\n": case "\u2028": case "\u2029":
        ++this.curLine;
        this.lineStart = this.pos + 1;
        break
      }
    }
    this.raise(this.start, "Unterminated template");
  };

  // Used to read escaped characters

  pp.readEscapedChar = function(inTemplate) {
    var ch = this.input.charCodeAt(++this.pos);
    ++this.pos;
    switch (ch) {
    case 110: return "\n" // 'n' -> '\n'
    case 114: return "\r" // 'r' -> '\r'
    case 120: return String.fromCharCode(this.readHexChar(2)) // 'x'
    case 117: return codePointToString(this.readCodePoint()) // 'u'
    case 116: return "\t" // 't' -> '\t'
    case 98: return "\b" // 'b' -> '\b'
    case 118: return "\u000b" // 'v' -> '\u000b'
    case 102: return "\f" // 'f' -> '\f'
    case 13: if (this.input.charCodeAt(this.pos) === 10) { ++this.pos; } // '\r\n'
    case 10: // ' \n'
      if (this.options.locations) { this.lineStart = this.pos; ++this.curLine; }
      return ""
    case 56:
    case 57:
      if (this.strict) {
        this.invalidStringToken(
          this.pos - 1,
          "Invalid escape sequence"
        );
      }
      if (inTemplate) {
        var codePos = this.pos - 1;

        this.invalidStringToken(
          codePos,
          "Invalid escape sequence in template string"
        );
      }
    default:
      if (ch >= 48 && ch <= 55) {
        var octalStr = this.input.substr(this.pos - 1, 3).match(/^[0-7]+/)[0];
        var octal = parseInt(octalStr, 8);
        if (octal > 255) {
          octalStr = octalStr.slice(0, -1);
          octal = parseInt(octalStr, 8);
        }
        this.pos += octalStr.length - 1;
        ch = this.input.charCodeAt(this.pos);
        if ((octalStr !== "0" || ch === 56 || ch === 57) && (this.strict || inTemplate)) {
          this.invalidStringToken(
            this.pos - 1 - octalStr.length,
            inTemplate
              ? "Octal literal in template string"
              : "Octal literal in strict mode"
          );
        }
        return String.fromCharCode(octal)
      }
      if (isNewLine(ch)) {
        // Unicode new line characters after \ get removed from output in both
        // template literals and strings
        if (this.options.locations) { this.lineStart = this.pos; ++this.curLine; }
        return ""
      }
      return String.fromCharCode(ch)
    }
  };

  // Used to read character escape sequences ('\x', '\u', '\U').

  pp.readHexChar = function(len) {
    var codePos = this.pos;
    var n = this.readInt(16, len);
    if (n === null) { this.invalidStringToken(codePos, "Bad character escape sequence"); }
    return n
  };

  // Read an identifier, and return it as a string. Sets `this.containsEsc`
  // to whether the word contained a '\u' escape.
  //
  // Incrementally adds only escaped chars, adding other chunks as-is
  // as a micro-optimization.

  pp.readWord1 = function() {
    this.containsEsc = false;
    var word = "", first = true, chunkStart = this.pos;
    var astral = this.options.ecmaVersion >= 6;
    while (this.pos < this.input.length) {
      var ch = this.fullCharCodeAtPos();
      if (isIdentifierChar(ch, astral)) {
        this.pos += ch <= 0xffff ? 1 : 2;
      } else if (ch === 92) { // "\"
        this.containsEsc = true;
        word += this.input.slice(chunkStart, this.pos);
        var escStart = this.pos;
        if (this.input.charCodeAt(++this.pos) !== 117) // "u"
          { this.invalidStringToken(this.pos, "Expecting Unicode escape sequence \\uXXXX"); }
        ++this.pos;
        var esc = this.readCodePoint();
        if (!(first ? isIdentifierStart : isIdentifierChar)(esc, astral))
          { this.invalidStringToken(escStart, "Invalid Unicode escape"); }
        word += codePointToString(esc);
        chunkStart = this.pos;
      } else {
        break
      }
      first = false;
    }
    return word + this.input.slice(chunkStart, this.pos)
  };

  // Read an identifier or keyword token. Will check for reserved
  // words when necessary.

  pp.readWord = function() {
    var word = this.readWord1();
    var type = types$1.name;
    if (this.keywords.test(word)) {
      type = keywords[word];
    }
    return this.finishToken(type, word)
  };

  // Acorn is a tiny, fast JavaScript parser written in JavaScript.
  //
  // Acorn was written by Marijn Haverbeke, Ingvar Stepanyan, and
  // various contributors and released under an MIT license.
  //
  // Git repositories for Acorn are available at
  //
  //     http://marijnhaverbeke.nl/git/acorn
  //     https://github.com/acornjs/acorn.git
  //
  // Please use the [github bug tracker][ghbt] to report issues.
  //
  // [ghbt]: https://github.com/acornjs/acorn/issues


  var version = "8.15.0";

  Parser.acorn = {
    Parser: Parser,
    version: version,
    defaultOptions: defaultOptions,
    Position: Position,
    SourceLocation: SourceLocation,
    getLineInfo: getLineInfo,
    Node: Node,
    TokenType: TokenType,
    tokTypes: types$1,
    keywordTypes: keywords,
    TokContext: TokContext,
    tokContexts: types,
    isIdentifierChar: isIdentifierChar,
    isIdentifierStart: isIdentifierStart,
    Token: Token,
    isNewLine: isNewLine,
    lineBreak: lineBreak,
    lineBreakG: lineBreakG,
    nonASCIIwhitespace: nonASCIIwhitespace
  };

  // The main exported interface (under `self.acorn` when in the
  // browser) is a `parse` function that takes a code string and returns
  // an abstract syntax tree as specified by the [ESTree spec][estree].
  //
  // [estree]: https://github.com/estree/estree

  function parse(input, options) {
    return Parser.parse(input, options)
  }

  // This function tries to parse a single expression at a given
  // offset in a string. Useful for parsing mixed-language formats
  // that embed JavaScript expressions.

  function parseExpressionAt(input, pos, options) {
    return Parser.parseExpressionAt(input, pos, options)
  }

  // Acorn is organized as a tokenizer and a recursive-descent parser.
  // The `tokenizer` export provides an interface to the tokenizer.

  function tokenizer(input, options) {
    return Parser.tokenizer(input, options)
  }

  exports.Node = Node;
  exports.Parser = Parser;
  exports.Position = Position;
  exports.SourceLocation = SourceLocation;
  exports.TokContext = TokContext;
  exports.Token = Token;
  exports.TokenType = TokenType;
  exports.defaultOptions = defaultOptions;
  exports.getLineInfo = getLineInfo;
  exports.isIdentifierChar = isIdentifierChar;
  exports.isIdentifierStart = isIdentifierStart;
  exports.isNewLine = isNewLine;
  exports.keywordTypes = keywords;
  exports.lineBreak = lineBreak;
  exports.lineBreakG = lineBreakG;
  exports.nonASCIIwhitespace = nonASCIIwhitespace;
  exports.parse = parse;
  exports.parseExpressionAt = parseExpressionAt;
  exports.tokContexts = types;
  exports.tokTypes = types$1;
  exports.tokenizer = tokenizer;
  exports.version = version;

}));
)JS2C1b732aee");static StaticExternalTwoByteResource internal_deps_acorn_acorn_dist_acorn_resource(internal_deps_acorn_acorn_dist_acorn_raw, 241547, nullptr);

static const uint8_t *internal_deps_cjs_module_lexer_dist_lexer_raw = reinterpret_cast<const uint8_t*>(R"JS2C1b732aee("use strict";exports.init=init;exports.initSync=initSync;exports.parse=parse;let A;const B=1===new Uint8Array(new Uint16Array([1]).buffer)[0];function parse(I,C="@"){if(!A)throw new Error("Not initialized");const w=I.length+1,D=(A.__heap_base.value||A.__heap_base)+4*w-A.memory.buffer.byteLength;D>0&&A.memory.grow(Math.ceil(D/65536));const G=A.sa(w);(B?g:E)(I,new Uint16Array(A.memory.buffer,G,w));const S=A.parseCJS(G,I.length,0,0,0);if(S){const B=new Error(`Parse error ${C}${A.e()}:${I.slice(0,A.e()).split("\n").length}:${A.e()-I.lastIndexOf("\n",A.e()-1)}`);throw Object.assign(B,{idx:A.e()}),5!==S&&6!==S&&7!==S||Object.assign(B,{code:"ERR_LEXER_ESM_SYNTAX"}),B}let R=new Set,o=new Set,H=new Set;for(;A.rre();){const B=Q(I.slice(A.res(),A.ree()));B&&o.add(B)}for(;A.ru();)H.add(Q(I.slice(A.us(),A.ue())));for(;A.re();){let B=Q(I.slice(A.es(),A.ee()));void 0===B||H.has(B)||R.add(B)}return{exports:[...R],reexports:[...o]}}function Q(A){if('"'!==A[0]&&"'"!==A[0])return A;try{const B=(0,eval)(A);for(let A=0;A<B.length;A++){const Q=64512&B.charCodeAt(A);if(!(Q<55296)){if(55296!==Q)return;if(56320!=(64512&B.charCodeAt(++A)))return}}return B}catch{}}function E(A,B){const Q=A.length;let E=0;for(;E<Q;){const Q=A.charCodeAt(E);B[E++]=(255&Q)<<8|Q>>>8}}function g(A,B){const Q=A.length;let E=0;for(;E<Q;)B[E]=A.charCodeAt(E++)}function I(){const A="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";return"undefined"!=typeof Buffer?Buffer.from(A,"base64"):Uint8Array.from(atob(A),A=>A.charCodeAt(0))}let C;function init(){return C||(C=(async()=>{const B=await WebAssembly.compile(I()),{exports:Q}=await WebAssembly.instantiate(B);A=Q})())}function initSync(){if(A)return;const B=new WebAssembly.Module(I()),{exports:Q}=new WebAssembly.Instance(B);A=Q})JS2C1b732aee");static StaticExternalOneByteResource internal_deps_cjs_module_lexer_dist_lexer_resource(internal_deps_cjs_module_lexer_dist_lexer_raw, 31259, nullptr);

static const uint8_t *internal_deps_cjs_module_lexer_lexer_raw = reinterpret_cast<const uint8_t*>(R"JS2C1b732aee(let source, pos, end;
let openTokenDepth,
  templateDepth,
  lastTokenPos,
  lastSlashWasDivision,
  templateStack,
  templateStackDepth,
  openTokenPosStack,
  openClassPosStack,
  nextBraceIsClass,
  starExportMap,
  lastStarExportSpecifier,
  _exports,
  unsafeGetters,
  reexports;

function resetState () {
  openTokenDepth = 0;
  templateDepth = -1;
  lastTokenPos = -1;
  lastSlashWasDivision = false;
  templateStack = new Array(1024);
  templateStackDepth = 0;
  openTokenPosStack = new Array(1024);
  openClassPosStack = new Array(1024);
  nextBraceIsClass = false;
  starExportMap = Object.create(null);
  lastStarExportSpecifier = null;

  _exports = new Set();
  unsafeGetters = new Set();
  reexports = new Set();
}

// RequireType
const Import = 0;
const ExportAssign = 1;
const ExportStar = 2;

function parseCJS (source, name = '@') {
  resetState();
  try {
    parseSource(source);
  }
  catch (e) {
    e.message += `\n  at ${name}:${source.slice(0, pos).split('\n').length}:${pos - source.lastIndexOf('\n', pos - 1)}`;
    e.loc = pos;
    throw e;
  }
  const result = { exports: [..._exports].filter(expt => expt !== undefined && !unsafeGetters.has(expt)), reexports: [...reexports].filter(reexpt => reexpt !== undefined) };
  resetState();
  return result;
}

function decode (str) {
  if (str[0] === '"' || str[0] === '\'') {
    try {
      const decoded = (0, eval)(str);
      // Filter to exclude non-matching UTF-16 surrogate strings
      for (let i = 0; i < decoded.length; i++) {
        const surrogatePrefix = decoded.charCodeAt(i) & 0xFC00;
        if (surrogatePrefix < 0xD800) {
          // Not a surrogate
          continue;
        }
        else if (surrogatePrefix === 0xD800) {
          // Validate surrogate pair
          if ((decoded.charCodeAt(++i) & 0xFC00) !== 0xDC00)
            return;
        }
        else {
          // Out-of-range surrogate code (above 0xD800)
          return;
        }
      }
      return decoded;
    }
    catch {}
  }
  else {
    return str;
  }
}

function parseSource (cjsSource) {
  source = cjsSource;
  pos = -1;
  end = source.length - 1;
  let ch = 0;

  // Handle #!
  if (source.charCodeAt(0) === 35/*#*/ && source.charCodeAt(1) === 33/*!*/) {
    if (source.length === 2)
      return true;
    pos += 2;
    while (pos++ < end) {
      ch = source.charCodeAt(pos);
      if (ch === 10/*\n*/ || ch === 13/*\r*/)
        break;
    }
  }

  while (pos++ < end) {
    ch = source.charCodeAt(pos);

    if (ch === 32 || ch < 14 && ch > 8)
      continue;

    if (openTokenDepth === 0) {
      switch (ch) {
        case 105/*i*/:
          if (source.startsWith('mport', pos + 1) && keywordStart(pos))
            throwIfImportStatement();
          lastTokenPos = pos;
          continue;
        case 114/*r*/:
          const startPos = pos;
          if (tryParseRequire(Import) && keywordStart(startPos))
            tryBacktrackAddStarExportBinding(startPos - 1);
          lastTokenPos = pos;
          continue;
        case 95/*_*/:
          if (source.startsWith('interopRequireWildcard', pos + 1) && (keywordStart(pos) || source.charCodeAt(pos - 1) === 46/*.*/)) {
            const startPos = pos;
            pos += 23;
            if (source.charCodeAt(pos) === 40/*(*/) {
              pos++;
              openTokenPosStack[openTokenDepth++] = lastTokenPos;
              if (tryParseRequire(Import) && keywordStart(startPos)) {
                tryBacktrackAddStarExportBinding(startPos - 1);
              }
            }
          }
          else if (source.startsWith('_export', pos + 1) && (keywordStart(pos) || source.charCodeAt(pos - 1) === 46/*.*/)) {
            pos += 8;
            if (source.startsWith('Star', pos))
              pos += 4;
            if (source.charCodeAt(pos) === 40/*(*/) {
              openTokenPosStack[openTokenDepth++] = lastTokenPos;
              if (source.charCodeAt(++pos) === 114/*r*/)
                tryParseRequire(ExportStar);
            }
          }
          lastTokenPos = pos;
          continue;
      }
    }

    switch (ch) {
      case 101/*e*/:
        if (source.startsWith('xport', pos + 1) && keywordStart(pos)) {
          if (source.charCodeAt(pos + 6) === 115/*s*/)
            tryParseExportsDotAssign(false);
          else if (openTokenDepth === 0)
            throwIfExportStatement();
        }
        break;
      case 99/*c*/:
        if (keywordStart(pos) && source.startsWith('lass', pos + 1) && isBrOrWs(source.charCodeAt(pos + 5)))
          nextBraceIsClass = true;
        break;
      case 109/*m*/:
        if (source.startsWith('odule', pos + 1) && keywordStart(pos))
          tryParseModuleExportsDotAssign();
        break;
      case 79/*O*/:
        if (source.startsWith('bject', pos + 1) && keywordStart(pos))
          tryParseObjectDefineOrKeys(openTokenDepth === 0);
        break;
      case 40/*(*/:
        openTokenPosStack[openTokenDepth++] = lastTokenPos;
        break;
      case 41/*)*/:
        if (openTokenDepth === 0)
          throw new Error('Unexpected closing bracket.');
        openTokenDepth--;
        break;
      case 123/*{*/:
        openClassPosStack[openTokenDepth] = nextBraceIsClass;
        nextBraceIsClass = false;
        openTokenPosStack[openTokenDepth++] = lastTokenPos;
        break;
      case 125/*}*/:
        if (openTokenDepth === 0)
          throw new Error('Unexpected closing brace.');
        if (openTokenDepth-- === templateDepth) {
          templateDepth = templateStack[--templateStackDepth];
          templateString();
        }
        else {
          if (templateDepth !== -1 && openTokenDepth < templateDepth)
            throw new Error('Unexpected closing brace.');
        }
        break;
      case 60/*>*/:
        // TODO: <!-- XML comment support
        break;
      case 39/*'*/:
      case 34/*"*/:
        stringLiteral(ch);
        break;
      case 47/*/*/: {
        const next_ch = source.charCodeAt(pos + 1);
        if (next_ch === 47/*/*/) {
          lineComment();
          // dont update lastToken
          continue;
        }
        else if (next_ch === 42/***/) {
          blockComment();
          // dont update lastToken
          continue;
        }
        else {
          // Division / regex ambiguity handling based on checking backtrack analysis of:
          // - what token came previously (lastToken)
          // - if a closing brace or paren, what token came before the corresponding
          //   opening brace or paren (lastOpenTokenIndex)
          const lastToken = source.charCodeAt(lastTokenPos);
          if (isExpressionPunctuator(lastToken) &&
              !(lastToken === 46/*.*/ && (source.charCodeAt(lastTokenPos - 1) >= 48/*0*/ && source.charCodeAt(lastTokenPos - 1) <= 57/*9*/)) &&
              !(lastToken === 43/*+*/ && source.charCodeAt(lastTokenPos - 1) === 43/*+*/) && !(lastToken === 45/*-*/ && source.charCodeAt(lastTokenPos - 1) === 45/*-*/) ||
              lastToken === 41/*)*/ && isParenKeyword(openTokenPosStack[openTokenDepth]) ||
              lastToken === 125/*}*/ && (isExpressionTerminator(openTokenPosStack[openTokenDepth]) || openClassPosStack[openTokenDepth]) ||
              lastToken === 47/*/*/ && lastSlashWasDivision ||
              isExpressionKeyword(lastTokenPos) ||
              !lastToken) {
            regularExpression();
            lastSlashWasDivision = false;
          }
          else {
            lastSlashWasDivision = true;
          }
        }
        break;
      }
      case 96/*`*/:
        templateString();
        break;
    }
    lastTokenPos = pos;
  }

  if (templateDepth !== -1)
    throw new Error('Unterminated template.');

  if (openTokenDepth)
    throw new Error('Unterminated braces.');
}

function tryBacktrackAddStarExportBinding (bPos) {
  while (source.charCodeAt(bPos) === 32/* */ && bPos >= 0)
    bPos--;
  if (source.charCodeAt(bPos) === 61/*=*/) {
    bPos--;
    while (source.charCodeAt(bPos) === 32/* */ && bPos >= 0)
      bPos--;
    let codePoint;
    const id_end = bPos;
    let identifierStart = false;
    while ((codePoint = codePointAtLast(bPos)) && bPos >= 0) {
      if (codePoint === 92/*\*/)
        return;
      if (!isIdentifierChar(codePoint, true))
        break;
      identifierStart = isIdentifierStart(codePoint, true);
      bPos -= codePointLen(codePoint);
    }
    if (identifierStart && source.charCodeAt(bPos) === 32/* */) {
      const starExportId = source.slice(bPos + 1, id_end + 1);
      while (source.charCodeAt(bPos) === 32/* */ && bPos >= 0)
        bPos--;
      switch (source.charCodeAt(bPos)) {
        case 114/*r*/:
          if (!source.startsWith('va', bPos - 2))
            return;
          break;
        case 116/*t*/:
          if (!source.startsWith('le', bPos - 2) && !source.startsWith('cons', bPos - 4))
            return;
          break;
        default: return;
      }
      starExportMap[starExportId] = lastStarExportSpecifier;
    }
  }
}

// `Object.` `prototype.`? hasOwnProperty.call(`  IDENTIFIER `, ` IDENTIFIER$2 `)`
function tryParseObjectHasOwnProperty (it_id) {
  ch = commentWhitespace();
  if (ch !== 79/*O*/ || !source.startsWith('bject', pos + 1)) return false;
  pos += 6;
  ch = commentWhitespace();
  if (ch !== 46/*.*/) return false;
  pos++;
  ch = commentWhitespace();
  if (ch === 112/*p*/) {
    if (!source.startsWith('rototype', pos + 1)) return false;
    pos += 9;
    ch = commentWhitespace();
    if (ch !== 46/*.*/) return false;
    pos++;
    ch = commentWhitespace();
  }
  if (ch !== 104/*h*/ || !source.startsWith('asOwnProperty', pos + 1)) return false;
  pos += 14;
  ch = commentWhitespace();
  if (ch !== 46/*.*/) return false;
  pos++;
  ch = commentWhitespace();
  if (ch !== 99/*c*/ || !source.startsWith('all', pos + 1)) return false;
  pos += 4;
  ch = commentWhitespace();
  if (ch !== 40/*(*/) return false;
  pos++;
  ch = commentWhitespace();
  if (!identifier()) return false;
  ch = commentWhitespace();
  if (ch !== 44/*,*/) return false;
  pos++;
  ch = commentWhitespace();
  if (!source.startsWith(it_id, pos)) return false;
  pos += it_id.length;
  ch = commentWhitespace();
  if (ch !== 41/*)*/) return false;
  pos++;
  return true;
}

function tryParseObjectDefineOrKeys (keys) {
  pos += 6;
  let revertPos = pos - 1;
  let ch = commentWhitespace();
  if (ch === 46/*.*/) {
    pos++;
    ch = commentWhitespace();
    if (ch === 100/*d*/ && source.startsWith('efineProperty', pos + 1)) {
      let expt;
      while (true) {
        pos += 14;
        revertPos = pos - 1;
        ch = commentWhitespace();
        if (ch !== 40/*(*/) break;
        pos++;
        ch = commentWhitespace();
        if (!readExportsOrModuleDotExports(ch)) break;
        ch = commentWhitespace();
        if (ch !== 44/*,*/) break;
        pos++;
        ch = commentWhitespace();
        if (ch !== 39/*'*/ && ch !== 34/*"*/) break;
        const exportPos = pos;
        stringLiteral(ch);
        expt = source.slice(exportPos, ++pos);
        ch = commentWhitespace();
        if (ch !== 44/*,*/) break;
        pos++;
        ch = commentWhitespace();
        if (ch !== 123/*{*/) break;
        pos++;
        ch = commentWhitespace();
        if (ch === 101/*e*/) {
          if (!source.startsWith('numerable', pos + 1)) break;
          pos += 10;
          ch = commentWhitespace();
          if (ch !== 58/*:*/) break;
          pos++;
          ch = commentWhitespace();
          if (ch !== 116/*t*/ || !source.startsWith('rue', pos + 1)) break;
          pos += 4;
          ch = commentWhitespace();
          if (ch !== 44) break;
          pos++;
          ch = commentWhitespace();
        }
        if (ch === 118/*v*/) {
          if (!source.startsWith('alue', pos + 1)) break;
          pos += 5;
          ch = commentWhitespace();
          if (ch !== 58/*:*/) break;
          _exports.add(decode(expt));
          pos = revertPos;
          return;
        }
        else if (ch === 103/*g*/) {
          if (!source.startsWith('et', pos + 1)) break;
          pos += 3;
          ch = commentWhitespace();
          if (ch === 58/*:*/) {
            pos++;
            ch = commentWhitespace();
            if (ch !== 102/*f*/) break;
            if (!source.startsWith('unction', pos + 1)) break;
            pos += 8;
            let lastPos = pos;
            ch = commentWhitespace();
            if (ch !== 40 && (lastPos === pos || !identifier())) break;
            ch = commentWhitespace();
          }
          if (ch !== 40/*(*/) break;
          pos++;
          ch = commentWhitespace();
          if (ch !== 41/*)*/) break;
          pos++;
          ch = commentWhitespace();
          if (ch !== 123/*{*/) break;
          pos++;
          ch = commentWhitespace();
          if (ch !== 114/*r*/) break;
          if (!source.startsWith('eturn', pos + 1)) break;
          pos += 6;
          ch = commentWhitespace();
          if (!identifier()) break;
          ch = commentWhitespace();
          if (ch === 46/*.*/) {
            pos++;
            commentWhitespace();
            if (!identifier()) break;
            ch = commentWhitespace();
          }
          else if (ch === 91/*[*/) {
            pos++;
            ch = commentWhitespace();
            if (ch === 39/*'*/ || ch === 34/*"*/) stringLiteral(ch);
            else break;
            pos++;
            ch = commentWhitespace();
            if (ch !== 93/*]*/) break;
            pos++;
            ch = commentWhitespace();
          }
          if (ch === 59/*;*/) {
            pos++;
            ch = commentWhitespace();
          }
          if (ch !== 125/*}*/) break;
          pos++;
          ch = commentWhitespace();
          if (ch === 44/*,*/) {
            pos++;
            ch = commentWhitespace();
          }
          if (ch !== 125/*}*/) break;
          pos++;
          ch = commentWhitespace();
          if (ch !== 41/*)*/) break;
          _exports.add(decode(expt));
          return;
        }
        break;
      }
      if (expt) {
        unsafeGetters.add(decode(expt));
      }
    }
    else if (keys && ch === 107/*k*/ && source.startsWith('eys', pos + 1)) {
      while (true) {
        pos += 4;
        revertPos = pos - 1;
        ch = commentWhitespace();
        if (ch !== 40/*(*/) break;
        pos++;
        ch = commentWhitespace();
        const id_start = pos;
        if (!identifier()) break;
        const id = source.slice(id_start, pos);
        ch = commentWhitespace();
        if (ch !== 41/*)*/) break;

        revertPos = pos++;
        ch = commentWhitespace();
        if (ch !== 46/*.*/) break;
        pos++;
        ch = commentWhitespace();
        if (ch !== 102/*f*/ || !source.startsWith('orEach', pos + 1)) break;
        pos += 7;
        ch = commentWhitespace();
        revertPos = pos - 1;
        if (ch !== 40/*(*/) break;
        pos++;
        ch = commentWhitespace();
        if (ch !== 102/*f*/ || !source.startsWith('unction', pos + 1)) break;
        pos += 8;
        ch = commentWhitespace();
        if (ch !== 40/*(*/) break;
        pos++;
        ch = commentWhitespace();
        const it_id_start = pos;
        if (!identifier()) break;
        const it_id = source.slice(it_id_start, pos);
        ch = commentWhitespace();
        if (ch !== 41/*)*/) break;
        pos++;
        ch = commentWhitespace();
        if (ch !== 123/*{*/) break;
        pos++;
        ch = commentWhitespace();
        if (ch !== 105/*i*/ || source.charCodeAt(pos + 1) !== 102/*f*/) break;
        pos += 2;
        ch = commentWhitespace();
        if (ch !== 40/*(*/) break;
        pos++;
        ch = commentWhitespace();
        if (!source.startsWith(it_id, pos)) break;
        pos += it_id.length;
        ch = commentWhitespace();
        // `if (` IDENTIFIER$2 `===` ( `'default'` | `"default"` ) `||` IDENTIFIER$2 `===` ( '__esModule' | `"__esModule"` ) `) return` `;`? |
        if (ch === 61/*=*/) {
          if (!source.startsWith('==', pos + 1)) break;
          pos += 3;
          ch = commentWhitespace();
          if (ch !== 34/*"*/ && ch !== 39/*'*/) break;
          let quot = ch;
          if (!source.startsWith('default', pos + 1)) break;
          pos += 8;
          ch = commentWhitespace();
          if (ch !== quot) break;
          pos += 1;
          ch = commentWhitespace();
          if (ch !== 124/*|*/ || source.charCodeAt(pos + 1) !== 124/*|*/) break;
          pos += 2;
          ch = commentWhitespace();
          if (source.slice(pos, pos + it_id.length) !== it_id) break;
          pos += it_id.length;
          ch = commentWhitespace();
          if (ch !== 61/*=*/ || source.slice(pos + 1, pos + 3) !== '==') break;
          pos += 3;
          ch = commentWhitespace();
          if (ch !== 34/*"*/ && ch !== 39/*'*/) break;
          quot = ch;
          if (!source.startsWith('__esModule', pos + 1)) break;
          pos += 11;
          ch = commentWhitespace();
          if (ch !== quot) break;
          pos += 1;
          ch = commentWhitespace();
          if (ch !== 41/*)*/) break;
          pos += 1;
          ch = commentWhitespace();
          if (ch !== 114/*r*/ || !source.startsWith('eturn', pos + 1)) break;
          pos += 6;
          ch = commentWhitespace();
          if (ch === 59/*;*/)
            pos++;
          ch = commentWhitespace();

          // `if (`
          if (ch === 105/*i*/ && source.charCodeAt(pos + 1) === 102/*f*/) {
            let inIf = true;
            pos += 2;
            ch = commentWhitespace();
            if (ch !== 40/*(*/) break;
            pos++;
            const ifInnerPos = pos;
            // `Object.prototype.hasOwnProperty.call(`  IDENTIFIER `, ` IDENTIFIER$2 `)) return` `;`?
            if (tryParseObjectHasOwnProperty(it_id)) {
              ch = commentWhitespace();
              if (ch !== 41/*)*/) break;
              pos++;
              ch = commentWhitespace();
              if (ch !== 114/*r*/ || !source.startsWith('eturn', pos + 1)) break;
              pos += 6;
              ch = commentWhitespace();
              if (ch === 59/*;*/)
                pos++;
              ch = commentWhitespace();
              // match next if
              if (ch === 105/*i*/ && source.charCodeAt(pos + 1) === 102/*f*/) {
                pos += 2;
                ch = commentWhitespace();
                if (ch !== 40/*(*/) break;
                pos++;
              }
              else {
                inIf = false;
              }
            }
            else {
              pos = ifInnerPos;
            }

            // IDENTIFIER$2 `in` EXPORTS_IDENTIFIER `&&` EXPORTS_IDENTIFIER `[` IDENTIFIER$2 `] ===` IDENTIFIER$1 `[` IDENTIFIER$2 `]) return` `;`?
            if (inIf) {
              if (!source.startsWith(it_id, pos)) break;
              pos += it_id.length;
              ch = commentWhitespace();
              if (ch !== 105/*i*/ || !source.startsWith('n ', pos + 1)) break;
              pos += 3;
              ch = commentWhitespace();
              if (!readExportsOrModuleDotExports(ch)) break;
              ch = commentWhitespace();
              if (ch !== 38/*&*/ || source.charCodeAt(pos + 1) !== 38/*&*/) break;
              pos += 2;
              ch = commentWhitespace();
              if (!readExportsOrModuleDotExports(ch)) break;
              ch = commentWhitespace();
              if (ch !== 91/*[*/) break;
              pos++;
              ch = commentWhitespace();
              if (!source.startsWith(it_id, pos)) break;
              pos += it_id.length;
              ch = commentWhitespace();
              if (ch !== 93/*]*/) break;
              pos++;
              ch = commentWhitespace();
              if (ch !== 61/*=*/ || !source.startsWith('==', pos + 1)) break;
              pos += 3;
              ch = commentWhitespace();
              if (!source.startsWith(id, pos)) break;
              pos += id.length;
              ch = commentWhitespace();
              if (ch !== 91/*[*/) break;
              pos++;
              ch = commentWhitespace();
              if (!source.startsWith(it_id, pos)) break;
              pos += it_id.length;
              ch = commentWhitespace();
              if (ch !== 93/*]*/) break;
              pos++;
              ch = commentWhitespace();
              if (ch !== 41/*)*/) break;
              pos++;
              ch = commentWhitespace();
              if (ch !== 114/*r*/ || !source.startsWith('eturn', pos + 1)) break;
              pos += 6;
              ch = commentWhitespace();
              if (ch === 59/*;*/)
                pos++;
              ch = commentWhitespace();
            }
          }
        }
        // `if (` IDENTIFIER$2 `!==` ( `'default'` | `"default"` ) (`&& !` IDENTIFIER `.hasOwnProperty(` IDENTIFIER$2 `)`  )? `)`
        else if (ch === 33/*!*/) {
          if (!source.startsWith('==', pos + 1)) break;
          pos += 3;
          ch = commentWhitespace();
          if (ch !== 34/*"*/ && ch !== 39/*'*/) break;
          const quot = ch;
          if (!source.startsWith('default', pos + 1)) break;
          pos += 8;
          ch = commentWhitespace();
          if (ch !== quot) break;
          pos += 1;
          ch = commentWhitespace();
          if (ch === 38/*&*/) {
            if (source.charCodeAt(pos + 1) !== 38/*&*/) break;
            pos += 2;
            ch = commentWhitespace();
            if (ch !== 33/*!*/) break;
            pos += 1;
            ch = commentWhitespace();
            if (ch === 79/*O*/ && source.startsWith('bject', pos + 1) && source[pos + 6] === '.') {
              if (!tryParseObjectHasOwnProperty(it_id)) break;
            }
            else if (identifier()) {
              ch = commentWhitespace();
              if (ch !== 46/*.*/) break;
              pos++;
              ch = commentWhitespace();
              if (ch !== 104/*h*/ || !source.startsWith('asOwnProperty', pos + 1)) break;
              pos += 14;
              ch = commentWhitespace();
              if (ch !== 40/*(*/) break;
              pos += 1;
              ch = commentWhitespace();
              if (!source.startsWith(it_id, pos)) break;
              pos += it_id.length;
              ch = commentWhitespace();
              if (ch !== 41/*)*/) break;
              pos += 1;
            }
            else break;
            ch = commentWhitespace();
          }
          if (ch !== 41/*)*/) break;
          pos += 1;
          ch = commentWhitespace();
        }
        else break;

        // EXPORTS_IDENTIFIER `[` IDENTIFIER$2 `] =` IDENTIFIER$1 `[` IDENTIFIER$2 `]`
        if (readExportsOrModuleDotExports(ch)) {
          ch = commentWhitespace();
          if (ch !== 91/*[*/) break;
          pos++;
          ch = commentWhitespace();
          if (source.slice(pos, pos + it_id.length) !== it_id) break;
          pos += it_id.length;
          ch = commentWhitespace();
          if (ch !== 93/*]*/) break;
          pos++;
          ch = commentWhitespace();
          if (ch !== 61/*=*/) break;
          pos++;
          ch = commentWhitespace();
          if (source.slice(pos, pos + id.length) !== id) break;
          pos += id.length;
          ch = commentWhitespace();
          if (ch !== 91/*[*/) break;
          pos++;
          ch = commentWhitespace();
          if (source.slice(pos, pos + it_id.length) !== it_id) break;
          pos += it_id.length;
          ch = commentWhitespace();
          if (ch !== 93/*]*/) break;
          pos++;
          ch = commentWhitespace();
          if (ch === 59/*;*/) {
            pos++;
            ch = commentWhitespace();
          }
        }
        // `Object.defineProperty(` EXPORTS_IDENTIFIER `, ` IDENTIFIER$2 `, { enumerable: true, get: function () { return ` IDENTIFIER$1 `[` IDENTIFIER$2 `]; } })`
        else if (ch === 79/*O*/) {
          if (source.slice(pos + 1, pos + 6) !== 'bject') break;
          pos += 6;
          ch = commentWhitespace();
          if (ch !== 46/*.*/) break;
          pos++;
          ch = commentWhitespace();
          if (ch !== 100/*d*/ || !source.startsWith('efineProperty', pos + 1)) break;
          pos += 14;
          ch = commentWhitespace();
          if (ch !== 40/*(*/) break;
          pos++;
          ch = commentWhitespace();
          if (!readExportsOrModuleDotExports(ch)) break;
          ch = commentWhitespace();
          if (ch !== 44/*,*/) break;
          pos++;
          ch = commentWhitespace();
          if (!source.startsWith(it_id, pos)) break;
          pos += it_id.length;
          ch = commentWhitespace();
          if (ch !== 44/*,*/) break;
          pos++;
          ch = commentWhitespace();
          if (ch !== 123/*{*/) break;
          pos++;
          ch = commentWhitespace();
          if (ch !== 101/*e*/ || !source.startsWith('numerable', pos + 1)) break;
          pos += 10;
          ch = commentWhitespace();
          if (ch !== 58/*:*/) break;
          pos++;
          ch = commentWhitespace();
          if (ch !== 116/*t*/ && !source.startsWith('rue', pos + 1)) break;
          pos += 4;
          ch = commentWhitespace();
          if (ch !== 44/*,*/) break;
          pos++;
          ch = commentWhitespace();
          if (ch !== 103/*g*/ || !source.startsWith('et', pos + 1)) break;
          pos += 3;
          ch = commentWhitespace();
          if (ch === 58/*:*/) {
            pos++;
            ch = commentWhitespace();
            if (ch !== 102/*f*/) break;
            if (!source.startsWith('unction', pos + 1)) break;
            pos += 8;
            let lastPos = pos;
            ch = commentWhitespace();
            if (ch !== 40 && (lastPos === pos || !identifier())) break;
            ch = commentWhitespace();
          }
          if (ch !== 40/*(*/) break;
          pos++;
          ch = commentWhitespace();
          if (ch !== 41/*)*/) break;
          pos++;
          ch = commentWhitespace();
          if (ch !== 123/*{*/) break;
          pos++;
          ch = commentWhitespace();
          if (ch !== 114/*r*/ || !source.startsWith('eturn', pos + 1)) break;
          pos += 6;
          ch = commentWhitespace();
          if (!source.startsWith(id, pos)) break;
          pos += id.length;
          ch = commentWhitespace();
          if (ch !== 91/*[*/) break;
          pos++;
          ch = commentWhitespace();
          if (!source.startsWith(it_id, pos)) break;
          pos += it_id.length;
          ch = commentWhitespace();
          if (ch !== 93/*]*/) break;
          pos++;
          ch = commentWhitespace();
          if (ch === 59/*;*/) {
            pos++;
            ch = commentWhitespace();
          }
          if (ch !== 125/*}*/) break;
          pos++;
          ch = commentWhitespace();
          if (ch === 44/*,*/) {
            pos++;
            ch = commentWhitespace();
          }
          if (ch !== 125/*}*/) break;
          pos++;
          ch = commentWhitespace();
          if (ch !== 41/*)*/) break;
          pos++;
          ch = commentWhitespace();
          if (ch === 59/*;*/) {
            pos++;
            ch = commentWhitespace();
          }
        }
        else break;

        if (ch !== 125/*}*/) break;
        pos++;
        ch = commentWhitespace();
        if (ch !== 41/*)*/) break;

        const starExportSpecifier = starExportMap[id];
        if (starExportSpecifier) {
          reexports.add(decode(starExportSpecifier));
          pos = revertPos;
          return;
        }
        return;
      }
    }
  }
  pos = revertPos;
}

function readExportsOrModuleDotExports (ch) {
  const revertPos = pos;
  if (ch === 109/*m*/ && source.startsWith('odule', pos + 1)) {
    pos += 6;
    ch = commentWhitespace();
    if (ch !== 46/*.*/) {
      pos = revertPos;
      return false;
    }
    pos++;
    ch = commentWhitespace();
  }
  if (ch === 101/*e*/ && source.startsWith('xports', pos + 1)) {
    pos += 7;
    return true;
  }
  else {
    pos = revertPos;
    return false;
  }
}

function tryParseModuleExportsDotAssign () {
  pos += 6;
  const revertPos = pos - 1;
  let ch = commentWhitespace();
  if (ch === 46/*.*/) {
    pos++;
    ch = commentWhitespace();
    if (ch === 101/*e*/ && source.startsWith('xports', pos + 1)) {
      tryParseExportsDotAssign(true);
      return;
    }
  }
  pos = revertPos;
}

function tryParseExportsDotAssign (assign) {
  pos += 7;
  const revertPos = pos - 1;
  let ch = commentWhitespace();
  switch (ch) {
    // exports.asdf
    case 46/*.*/: {
      pos++;
      ch = commentWhitespace();
      const startPos = pos;
      if (identifier()) {
        const endPos = pos;
        ch = commentWhitespace();
        if (ch === 61/*=*/) {
          _exports.add(decode(source.slice(startPos, endPos)));
          return;
        }
      }
      break;
    }
    // exports['asdf']
    case 91/*[*/: {
      pos++;
      ch = commentWhitespace();
      if (ch === 39/*'*/ || ch === 34/*"*/) {
        const startPos = pos;
        stringLiteral(ch);
        const endPos = ++pos;
        ch = commentWhitespace();
        if (ch !== 93/*]*/) break;
        pos++;
        ch = commentWhitespace();
        if (ch !== 61/*=*/) break;
        _exports.add(decode(source.slice(startPos, endPos)));
      }
      break;
    }
    // module.exports =
    case 61/*=*/: {
      if (assign) {
        if (reexports.size)
          reexports = new Set();
        pos++;
        ch = commentWhitespace();
        // { ... }
        if (ch === 123/*{*/) {
          tryParseLiteralExports();
          return;
        }

        // require('...')
        if (ch === 114/*r*/)
          tryParseRequire(ExportAssign);
      }
    }
  }
  pos = revertPos;
}

function tryParseRequire (requireType) {
  // require('...')
  const revertPos = pos;
  if (source.startsWith('equire', pos + 1)) {
    pos += 7;
    let ch = commentWhitespace();
    if (ch === 40/*(*/) {
      pos++;
      ch = commentWhitespace();
      const reexportStart = pos;
      if (ch === 39/*'*/ || ch === 34/*"*/) {
        stringLiteral(ch);
        const reexportEnd = ++pos;
        ch = commentWhitespace();
        if (ch === 41/*)*/) {
          switch (requireType) {
            case ExportAssign:
              reexports.add(decode(source.slice(reexportStart, reexportEnd)));
              return true;
            case ExportStar:
              reexports.add(decode(source.slice(reexportStart, reexportEnd)));
              return true;
            default:
              lastStarExportSpecifier = decode(source.slice(reexportStart, reexportEnd));
              return true;
          }
        }
      }
    }
    pos = revertPos;
  }
  return false;
}

function tryParseLiteralExports () {
  const revertPos = pos - 1;
  while (pos++ < end) {
    let ch = commentWhitespace();
    const startPos = pos;
    if (identifier()) {
      const endPos = pos;
      ch = commentWhitespace();
      if (ch === 58/*:*/) {
        pos++;
        ch = commentWhitespace();
        // nothing more complex than identifier expressions for now
        if (!identifier()) {
          pos = revertPos;
          return;
        }
        ch = source.charCodeAt(pos);
      }
      _exports.add(decode(source.slice(startPos, endPos)));
    }
    else if (ch === 46/*.*/ && source.startsWith('..', pos + 1)) {
      pos += 3;
      if (source.charCodeAt(pos) === 114/*r*/ && tryParseRequire(ExportAssign)) {
        pos++;
      }
      else if (!identifier()) {
        pos = revertPos;
        return;
      }
      ch = commentWhitespace();
    }
    else if (ch === 39/*'*/ || ch === 34/*"*/) {
      const startPos = pos;
      stringLiteral(ch);
      const endPos = ++pos;
      ch = commentWhitespace();
      if (ch === 58/*:*/) {
        pos++;
        ch = commentWhitespace();
        // nothing more complex than identifier expressions for now
        if (!identifier()) {
          pos = revertPos;
          return;
        }
        ch = source.charCodeAt(pos);
        _exports.add(decode(source.slice(startPos, endPos)));
      }
    }
    else {
      pos = revertPos;
      return;
    }

    if (ch === 125/*}*/)
      return;

    if (ch !== 44/*,*/) {
      pos = revertPos;
      return;
    }
  }
}

// --- Extracted from AcornJS ---
//(https://github.com/acornjs/acorn/blob/master/acorn/src/identifier.js#L23
//
// MIT License

// Copyright (C) 2012-2018 by various contributors (see AUTHORS)

// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to deal
// in the Software without restriction, including without limitation the rights
// to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
// copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:

// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.

// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
// AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
// OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
// THE SOFTWARE.

// ## Character categories

// Big ugly regular expressions that match characters in the
// whitespace, identifier, and identifier-start categories. These
// are only applied when a character is found to actually have a
// code point above 128.
// Generated by `bin/generate-identifier-regex.js`.
let nonASCIIidentifierStartChars = "\xaa\xb5\xba\xc0-\xd6\xd8-\xf6\xf8-\u02c1\u02c6-\u02d1\u02e0-\u02e4\u02ec\u02ee\u0370-\u0374\u0376\u0377\u037a-\u037d\u037f\u0386\u0388-\u038a\u038c\u038e-\u03a1\u03a3-\u03f5\u03f7-\u0481\u048a-\u052f\u0531-\u0556\u0559\u0560-\u0588\u05d0-\u05ea\u05ef-\u05f2\u0620-\u064a\u066e\u066f\u0671-\u06d3\u06d5\u06e5\u06e6\u06ee\u06ef\u06fa-\u06fc\u06ff\u0710\u0712-\u072f\u074d-\u07a5\u07b1\u07ca-\u07ea\u07f4\u07f5\u07fa\u0800-\u0815\u081a\u0824\u0828\u0840-\u0858\u0860-\u086a\u08a0-\u08b4\u08b6-\u08c7\u0904-\u0939\u093d\u0950\u0958-\u0961\u0971-\u0980\u0985-\u098c\u098f\u0990\u0993-\u09a8\u09aa-\u09b0\u09b2\u09b6-\u09b9\u09bd\u09ce\u09dc\u09dd\u09df-\u09e1\u09f0\u09f1\u09fc\u0a05-\u0a0a\u0a0f\u0a10\u0a13-\u0a28\u0a2a-\u0a30\u0a32\u0a33\u0a35\u0a36\u0a38\u0a39\u0a59-\u0a5c\u0a5e\u0a72-\u0a74\u0a85-\u0a8d\u0a8f-\u0a91\u0a93-\u0aa8\u0aaa-\u0ab0\u0ab2\u0ab3\u0ab5-\u0ab9\u0abd\u0ad0\u0ae0\u0ae1\u0af9\u0b05-\u0b0c\u0b0f\u0b10\u0b13-\u0b28\u0b2a-\u0b30\u0b32\u0b33\u0b35-\u0b39\u0b3d\u0b5c\u0b5d\u0b5f-\u0b61\u0b71\u0b83\u0b85-\u0b8a\u0b8e-\u0b90\u0b92-\u0b95\u0b99\u0b9a\u0b9c\u0b9e\u0b9f\u0ba3\u0ba4\u0ba8-\u0baa\u0bae-\u0bb9\u0bd0\u0c05-\u0c0c\u0c0e-\u0c10\u0c12-\u0c28\u0c2a-\u0c39\u0c3d\u0c58-\u0c5a\u0c60\u0c61\u0c80\u0c85-\u0c8c\u0c8e-\u0c90\u0c92-\u0ca8\u0caa-\u0cb3\u0cb5-\u0cb9\u0cbd\u0cde\u0ce0\u0ce1\u0cf1\u0cf2\u0d04-\u0d0c\u0d0e-\u0d10\u0d12-\u0d3a\u0d3d\u0d4e\u0d54-\u0d56\u0d5f-\u0d61\u0d7a-\u0d7f\u0d85-\u0d96\u0d9a-\u0db1\u0db3-\u0dbb\u0dbd\u0dc0-\u0dc6\u0e01-\u0e30\u0e32\u0e33\u0e40-\u0e46\u0e81\u0e82\u0e84\u0e86-\u0e8a\u0e8c-\u0ea3\u0ea5\u0ea7-\u0eb0\u0eb2\u0eb3\u0ebd\u0ec0-\u0ec4\u0ec6\u0edc-\u0edf\u0f00\u0f40-\u0f47\u0f49-\u0f6c\u0f88-\u0f8c\u1000-\u102a\u103f\u1050-\u1055\u105a-\u105d\u1061\u1065\u1066\u106e-\u1070\u1075-\u1081\u108e\u10a0-\u10c5\u10c7\u10cd\u10d0-\u10fa\u10fc-\u1248\u124a-\u124d\u1250-\u1256\u1258\u125a-\u125d\u1260-\u1288\u128a-\u128d\u1290-\u12b0\u12b2-\u12b5\u12b8-\u12be\u12c0\u12c2-\u12c5\u12c8-\u12d6\u12d8-\u1310\u1312-\u1315\u1318-\u135a\u1380-\u138f\u13a0-\u13f5\u13f8-\u13fd\u1401-\u166c\u166f-\u167f\u1681-\u169a\u16a0-\u16ea\u16ee-\u16f8\u1700-\u170c\u170e-\u1711\u1720-\u1731\u1740-\u1751\u1760-\u176c\u176e-\u1770\u1780-\u17b3\u17d7\u17dc\u1820-\u1878\u1880-\u18a8\u18aa\u18b0-\u18f5\u1900-\u191e\u1950-\u196d\u1970-\u1974\u1980-\u19ab\u19b0-\u19c9\u1a00-\u1a16\u1a20-\u1a54\u1aa7\u1b05-\u1b33\u1b45-\u1b4b\u1b83-\u1ba0\u1bae\u1baf\u1bba-\u1be5\u1c00-\u1c23\u1c4d-\u1c4f\u1c5a-\u1c7d\u1c80-\u1c88\u1c90-\u1cba\u1cbd-\u1cbf\u1ce9-\u1cec\u1cee-\u1cf3\u1cf5\u1cf6\u1cfa\u1d00-\u1dbf\u1e00-\u1f15\u1f18-\u1f1d\u1f20-\u1f45\u1f48-\u1f4d\u1f50-\u1f57\u1f59\u1f5b\u1f5d\u1f5f-\u1f7d\u1f80-\u1fb4\u1fb6-\u1fbc\u1fbe\u1fc2-\u1fc4\u1fc6-\u1fcc\u1fd0-\u1fd3\u1fd6-\u1fdb\u1fe0-\u1fec\u1ff2-\u1ff4\u1ff6-\u1ffc\u2071\u207f\u2090-\u209c\u2102\u2107\u210a-\u2113\u2115\u2118-\u211d\u2124\u2126\u2128\u212a-\u2139\u213c-\u213f\u2145-\u2149\u214e\u2160-\u2188\u2c00-\u2c2e\u2c30-\u2c5e\u2c60-\u2ce4\u2ceb-\u2cee\u2cf2\u2cf3\u2d00-\u2d25\u2d27\u2d2d\u2d30-\u2d67\u2d6f\u2d80-\u2d96\u2da0-\u2da6\u2da8-\u2dae\u2db0-\u2db6\u2db8-\u2dbe\u2dc0-\u2dc6\u2dc8-\u2dce\u2dd0-\u2dd6\u2dd8-\u2dde\u3005-\u3007\u3021-\u3029\u3031-\u3035\u3038-\u303c\u3041-\u3096\u309b-\u309f\u30a1-\u30fa\u30fc-\u30ff\u3105-\u312f\u3131-\u318e\u31a0-\u31bf\u31f0-\u31ff\u3400-\u4dbf\u4e00-\u9ffc\ua000-\ua48c\ua4d0-\ua4fd\ua500-\ua60c\ua610-\ua61f\ua62a\ua62b\ua640-\ua66e\ua67f-\ua69d\ua6a0-\ua6ef\ua717-\ua71f\ua722-\ua788\ua78b-\ua7bf\ua7c2-\ua7ca\ua7f5-\ua801\ua803-\ua805\ua807-\ua80a\ua80c-\ua822\ua840-\ua873\ua882-\ua8b3\ua8f2-\ua8f7\ua8fb\ua8fd\ua8fe\ua90a-\ua925\ua930-\ua946\ua960-\ua97c\ua984-\ua9b2\ua9cf\ua9e0-\ua9e4\ua9e6-\ua9ef\ua9fa-\ua9fe\uaa00-\uaa28\uaa40-\uaa42\uaa44-\uaa4b\uaa60-\uaa76\uaa7a\uaa7e-\uaaaf\uaab1\uaab5\uaab6\uaab9-\uaabd\uaac0\uaac2\uaadb-\uaadd\uaae0-\uaaea\uaaf2-\uaaf4\uab01-\uab06\uab09-\uab0e\uab11-\uab16\uab20-\uab26\uab28-\uab2e\uab30-\uab5a\uab5c-\uab69\uab70-\uabe2\uac00-\ud7a3\ud7b0-\ud7c6\ud7cb-\ud7fb\uf900-\ufa6d\ufa70-\ufad9\ufb00-\ufb06\ufb13-\ufb17\ufb1d\ufb1f-\ufb28\ufb2a-\ufb36\ufb38-\ufb3c\ufb3e\ufb40\ufb41\ufb43\ufb44\ufb46-\ufbb1\ufbd3-\ufd3d\ufd50-\ufd8f\ufd92-\ufdc7\ufdf0-\ufdfb\ufe70-\ufe74\ufe76-\ufefc\uff21-\uff3a\uff41-\uff5a\uff66-\uffbe\uffc2-\uffc7\uffca-\uffcf\uffd2-\uffd7\uffda-\uffdc"
let nonASCIIidentifierChars = "\u200c\u200d\xb7\u0300-\u036f\u0387\u0483-\u0487\u0591-\u05bd\u05bf\u05c1\u05c2\u05c4\u05c5\u05c7\u0610-\u061a\u064b-\u0669\u0670\u06d6-\u06dc\u06df-\u06e4\u06e7\u06e8\u06ea-\u06ed\u06f0-\u06f9\u0711\u0730-\u074a\u07a6-\u07b0\u07c0-\u07c9\u07eb-\u07f3\u07fd\u0816-\u0819\u081b-\u0823\u0825-\u0827\u0829-\u082d\u0859-\u085b\u08d3-\u08e1\u08e3-\u0903\u093a-\u093c\u093e-\u094f\u0951-\u0957\u0962\u0963\u0966-\u096f\u0981-\u0983\u09bc\u09be-\u09c4\u09c7\u09c8\u09cb-\u09cd\u09d7\u09e2\u09e3\u09e6-\u09ef\u09fe\u0a01-\u0a03\u0a3c\u0a3e-\u0a42\u0a47\u0a48\u0a4b-\u0a4d\u0a51\u0a66-\u0a71\u0a75\u0a81-\u0a83\u0abc\u0abe-\u0ac5\u0ac7-\u0ac9\u0acb-\u0acd\u0ae2\u0ae3\u0ae6-\u0aef\u0afa-\u0aff\u0b01-\u0b03\u0b3c\u0b3e-\u0b44\u0b47\u0b48\u0b4b-\u0b4d\u0b55-\u0b57\u0b62\u0b63\u0b66-\u0b6f\u0b82\u0bbe-\u0bc2\u0bc6-\u0bc8\u0bca-\u0bcd\u0bd7\u0be6-\u0bef\u0c00-\u0c04\u0c3e-\u0c44\u0c46-\u0c48\u0c4a-\u0c4d\u0c55\u0c56\u0c62\u0c63\u0c66-\u0c6f\u0c81-\u0c83\u0cbc\u0cbe-\u0cc4\u0cc6-\u0cc8\u0cca-\u0ccd\u0cd5\u0cd6\u0ce2\u0ce3\u0ce6-\u0cef\u0d00-\u0d03\u0d3b\u0d3c\u0d3e-\u0d44\u0d46-\u0d48\u0d4a-\u0d4d\u0d57\u0d62\u0d63\u0d66-\u0d6f\u0d81-\u0d83\u0dca\u0dcf-\u0dd4\u0dd6\u0dd8-\u0ddf\u0de6-\u0def\u0df2\u0df3\u0e31\u0e34-\u0e3a\u0e47-\u0e4e\u0e50-\u0e59\u0eb1\u0eb4-\u0ebc\u0ec8-\u0ecd\u0ed0-\u0ed9\u0f18\u0f19\u0f20-\u0f29\u0f35\u0f37\u0f39\u0f3e\u0f3f\u0f71-\u0f84\u0f86\u0f87\u0f8d-\u0f97\u0f99-\u0fbc\u0fc6\u102b-\u103e\u1040-\u1049\u1056-\u1059\u105e-\u1060\u1062-\u1064\u1067-\u106d\u1071-\u1074\u1082-\u108d\u108f-\u109d\u135d-\u135f\u1369-\u1371\u1712-\u1714\u1732-\u1734\u1752\u1753\u1772\u1773\u17b4-\u17d3\u17dd\u17e0-\u17e9\u180b-\u180d\u1810-\u1819\u18a9\u1920-\u192b\u1930-\u193b\u1946-\u194f\u19d0-\u19da\u1a17-\u1a1b\u1a55-\u1a5e\u1a60-\u1a7c\u1a7f-\u1a89\u1a90-\u1a99\u1ab0-\u1abd\u1abf\u1ac0\u1b00-\u1b04\u1b34-\u1b44\u1b50-\u1b59\u1b6b-\u1b73\u1b80-\u1b82\u1ba1-\u1bad\u1bb0-\u1bb9\u1be6-\u1bf3\u1c24-\u1c37\u1c40-\u1c49\u1c50-\u1c59\u1cd0-\u1cd2\u1cd4-\u1ce8\u1ced\u1cf4\u1cf7-\u1cf9\u1dc0-\u1df9\u1dfb-\u1dff\u203f\u2040\u2054\u20d0-\u20dc\u20e1\u20e5-\u20f0\u2cef-\u2cf1\u2d7f\u2de0-\u2dff\u302a-\u302f\u3099\u309a\ua620-\ua629\ua66f\ua674-\ua67d\ua69e\ua69f\ua6f0\ua6f1\ua802\ua806\ua80b\ua823-\ua827\ua82c\ua880\ua881\ua8b4-\ua8c5\ua8d0-\ua8d9\ua8e0-\ua8f1\ua8ff-\ua909\ua926-\ua92d\ua947-\ua953\ua980-\ua983\ua9b3-\ua9c0\ua9d0-\ua9d9\ua9e5\ua9f0-\ua9f9\uaa29-\uaa36\uaa43\uaa4c\uaa4d\uaa50-\uaa59\uaa7b-\uaa7d\uaab0\uaab2-\uaab4\uaab7\uaab8\uaabe\uaabf\uaac1\uaaeb-\uaaef\uaaf5\uaaf6\uabe3-\uabea\uabec\uabed\uabf0-\uabf9\ufb1e\ufe00-\ufe0f\ufe20-\ufe2f\ufe33\ufe34\ufe4d-\ufe4f\uff10-\uff19\uff3f"

const nonASCIIidentifierStart = new RegExp("[" + nonASCIIidentifierStartChars + "]")
const nonASCIIidentifier = new RegExp("[" + nonASCIIidentifierStartChars + nonASCIIidentifierChars + "]")

nonASCIIidentifierStartChars = nonASCIIidentifierChars = null

// These are a run-length and offset encoded representation of the
// >0xffff code points that are a valid part of identifiers. The
// offset starts at 0x10000, and each pair of numbers represents an
// offset to the next range, and then a size of the range. They were
// generated by bin/generate-identifier-regex.js

// eslint-disable-next-line comma-spacing
const astralIdentifierStartCodes = [0,11,2,25,2,18,2,1,2,14,3,13,35,122,70,52,268,28,4,48,48,31,14,29,6,37,11,29,3,35,5,7,2,4,43,157,19,35,5,35,5,39,9,51,157,310,10,21,11,7,153,5,3,0,2,43,2,1,4,0,3,22,11,22,10,30,66,18,2,1,11,21,11,25,71,55,7,1,65,0,16,3,2,2,2,28,43,28,4,28,36,7,2,27,28,53,11,21,11,18,14,17,111,72,56,50,14,50,14,35,349,41,7,1,79,28,11,0,9,21,107,20,28,22,13,52,76,44,33,24,27,35,30,0,3,0,9,34,4,0,13,47,15,3,22,0,2,0,36,17,2,24,85,6,2,0,2,3,2,14,2,9,8,46,39,7,3,1,3,21,2,6,2,1,2,4,4,0,19,0,13,4,159,52,19,3,21,2,31,47,21,1,2,0,185,46,42,3,37,47,21,0,60,42,14,0,72,26,230,43,117,63,32,7,3,0,3,7,2,1,2,23,16,0,2,0,95,7,3,38,17,0,2,0,29,0,11,39,8,0,22,0,12,45,20,0,35,56,264,8,2,36,18,0,50,29,113,6,2,1,2,37,22,0,26,5,2,1,2,31,15,0,328,18,190,0,80,921,103,110,18,195,2749,1070,4050,582,8634,568,8,30,114,29,19,47,17,3,32,20,6,18,689,63,129,74,6,0,67,12,65,1,2,0,29,6135,9,1237,43,8,8952,286,50,2,18,3,9,395,2309,106,6,12,4,8,8,9,5991,84,2,70,2,1,3,0,3,1,3,3,2,11,2,0,2,6,2,64,2,3,3,7,2,6,2,27,2,3,2,4,2,0,4,6,2,339,3,24,2,24,2,30,2,24,2,30,2,24,2,30,2,24,2,30,2,24,2,7,2357,44,11,6,17,0,370,43,1301,196,60,67,8,0,1205,3,2,26,2,1,2,0,3,0,2,9,2,3,2,0,2,0,7,0,5,0,2,0,2,0,2,2,2,1,2,0,3,0,2,0,2,0,2,0,2,0,2,1,2,0,3,3,2,6,2,3,2,3,2,0,2,9,2,16,6,2,2,4,2,16,4421,42717,35,4148,12,221,3,5761,15,7472,3104,541,1507,4938]

// eslint-disable-next-line comma-spacing
const astralIdentifierCodes = [509,0,227,0,150,4,294,9,1368,2,2,1,6,3,41,2,5,0,166,1,574,3,9,9,370,1,154,10,176,2,54,14,32,9,16,3,46,10,54,9,7,2,37,13,2,9,6,1,45,0,13,2,49,13,9,3,2,11,83,11,7,0,161,11,6,9,7,3,56,1,2,6,3,1,3,2,10,0,11,1,3,6,4,4,193,17,10,9,5,0,82,19,13,9,214,6,3,8,28,1,83,16,16,9,82,12,9,9,84,14,5,9,243,14,166,9,71,5,2,1,3,3,2,0,2,1,13,9,120,6,3,6,4,0,29,9,41,6,2,3,9,0,10,10,47,15,406,7,2,7,17,9,57,21,2,13,123,5,4,0,2,1,2,6,2,0,9,9,49,4,2,1,2,4,9,9,330,3,19306,9,135,4,60,6,26,9,1014,0,2,54,8,3,82,0,12,1,19628,1,5319,4,4,5,9,7,3,6,31,3,149,2,1418,49,513,54,5,49,9,0,15,0,23,4,2,14,1361,6,2,16,3,6,2,1,2,4,262,6,10,9,419,13,1495,6,110,6,6,9,4759,9,787719,239]

// This has a complexity linear to the value of the code. The
// assumption is that looking up astral identifier characters is
// rare.
function isInAstralSet(code, set) {
  let pos = 0x10000
  for (let i = 0; i < set.length; i += 2) {
    pos += set[i]
    if (pos > code) return false
    pos += set[i + 1]
    if (pos >= code) return true
  }
}

// Test whether a given character code starts an identifier.

function isIdentifierStart(code, astral) {
  if (code < 65) return code === 36
  if (code < 91) return true
  if (code < 97) return code === 95
  if (code < 123) return true
  if (code <= 0xffff) return code >= 0xaa && nonASCIIidentifierStart.test(String.fromCharCode(code))
  if (astral === false) return false
  return isInAstralSet(code, astralIdentifierStartCodes)
}

// Test whether a given character is part of an identifier.

function isIdentifierChar(code, astral) {
  if (code < 48) return code === 36
  if (code < 58) return true
  if (code < 65) return false
  if (code < 91) return true
  if (code < 97) return code === 95
  if (code < 123) return true
  if (code <= 0xffff) return code >= 0xaa && nonASCIIidentifier.test(String.fromCharCode(code))
  if (astral === false) return false
  return isInAstralSet(code, astralIdentifierStartCodes) || isInAstralSet(code, astralIdentifierCodes)
}

function identifier () {
  let ch = source.codePointAt(pos);
  if (!isIdentifierStart(ch, true) || ch === '\\')
    return false;
  pos += codePointLen(ch);
  while (ch = source.codePointAt(pos)) {
    if (isIdentifierChar(ch, true)) {
      pos += codePointLen(ch);
    }
    else if (ch === '\\') {
      // no identifier escapes support for now
      return false;
    }
    else {
      break;
    }
  }
  return true;
}

function codePointLen (ch) {
  if (ch < 0x10000) return 1;
  return 2;
}

function codePointAtLast (bPos) {
  // Gives the UTF char for backtracking surrogates
  const ch = source.charCodeAt(bPos);
  if ((ch & 0xFC00) === 0xDC00)
    return (((source.charCodeAt(bPos - 1) & 0x3FF) << 10) | (ch & 0x3FF)) + 0x10000;
  return ch;
}

function esmSyntaxErr (msg) {
  return Object.assign(new Error(msg), { code: 'ERR_LEXER_ESM_SYNTAX' });
}

function throwIfImportStatement () {
  const startPos = pos;
  pos += 6;
  const ch = commentWhitespace();
  switch (ch) {
    // dynamic import
    case 40/*(*/:
      openTokenPosStack[openTokenDepth++] = startPos;
      return;
    // import.meta
    case 46/*.*/:
      throw esmSyntaxErr('Unexpected import.meta in CJS module.');

    default:
      // no space after "import" -> not an import keyword
      if (pos === startPos + 6)
        break;
    case 34/*"*/:
    case 39/*'*/:
    case 123/*{*/:
    case 42/***/:
      // import statement only permitted at base-level
      if (openTokenDepth !== 0) {
        pos--;
        return;
      }
      // import statements are a syntax error in CommonJS
      throw esmSyntaxErr('Unexpected import statement in CJS module.');
  }
}

function throwIfExportStatement () {
  pos += 6;
  const curPos = pos;
  const ch = commentWhitespace();
  if (pos === curPos && !isPunctuator(ch))
    return;
  throw esmSyntaxErr('Unexpected export statement in CJS module.');
}

function commentWhitespace () {
  let ch;
  do {
    ch = source.charCodeAt(pos);
    if (ch === 47/*/*/) {
      const next_ch = source.charCodeAt(pos + 1);
      if (next_ch === 47/*/*/)
        lineComment();
      else if (next_ch === 42/***/)
        blockComment();
      else
        return ch;
    }
    else if (!isBrOrWs(ch)) {
      return ch;
    }
  } while (pos++ < end);
  return ch;
}

function templateString () {
  while (pos++ < end) {
    const ch = source.charCodeAt(pos);
    if (ch === 36/*$*/ && source.charCodeAt(pos + 1) === 123/*{*/) {
      pos++;
      templateStack[templateStackDepth++] = templateDepth;
      templateDepth = ++openTokenDepth;
      return;
    }
    if (ch === 96/*`*/)
      return;
    if (ch === 92/*\*/)
      pos++;
  }
  syntaxError();
}

function blockComment () {
  pos++;
  while (pos++ < end) {
    const ch = source.charCodeAt(pos);
    if (ch === 42/***/ && source.charCodeAt(pos + 1) === 47/*/*/) {
      pos++;
      return;
    }
  }
}

function lineComment () {
  while (pos++ < end) {
    const ch = source.charCodeAt(pos);
    if (ch === 10/*\n*/ || ch === 13/*\r*/)
      return;
  }
}

function stringLiteral (quote) {
  while (pos++ < end) {
    let ch = source.charCodeAt(pos);
    if (ch === quote)
      return;
    if (ch === 92/*\*/) {
      ch = source.charCodeAt(++pos);
      if (ch === 13/*\r*/ && source.charCodeAt(pos + 1) === 10/*\n*/)
        pos++;
    }
    else if (isBr(ch))
      break;
  }
  throw new Error('Unterminated string.');
}

function regexCharacterClass () {
  while (pos++ < end) {
    let ch = source.charCodeAt(pos);
    if (ch === 93/*]*/)
      return ch;
    if (ch === 92/*\*/)
      pos++;
    else if (ch === 10/*\n*/ || ch === 13/*\r*/)
      break;
  }
  throw new Error('Syntax error reading regular expression class.');
}

function regularExpression () {
  while (pos++ < end) {
    let ch = source.charCodeAt(pos);
    if (ch === 47/*/*/)
      return;
    if (ch === 91/*[*/)
      ch = regexCharacterClass();
    else if (ch === 92/*\*/)
      pos++;
    else if (ch === 10/*\n*/ || ch === 13/*\r*/)
      break;
  }
  throw new Error('Syntax error reading regular expression.');
}

// Note: non-asii BR and whitespace checks omitted for perf / footprint
// if there is a significant user need this can be reconsidered
function isBr (c) {
  return c === 13/*\r*/ || c === 10/*\n*/;
}

function isBrOrWs (c) {
  return c > 8 && c < 14 || c === 32 || c === 160;
}

function isBrOrWsOrPunctuatorNotDot (c) {
  return c > 8 && c < 14 || c === 32 || c === 160 || isPunctuator(c) && c !== 46/*.*/;
}

function keywordStart (pos) {
  return pos === 0 || isBrOrWsOrPunctuatorNotDot(source.charCodeAt(pos - 1));
}

function readPrecedingKeyword (pos, match) {
  if (pos < match.length - 1)
    return false;
  return source.startsWith(match, pos - match.length + 1) && (pos === 0 || isBrOrWsOrPunctuatorNotDot(source.charCodeAt(pos - match.length)));
}

function readPrecedingKeyword1 (pos, ch) {
  return source.charCodeAt(pos) === ch && (pos === 0 || isBrOrWsOrPunctuatorNotDot(source.charCodeAt(pos - 1)));
}

// Detects one of case, debugger, delete, do, else, in, instanceof, new,
//   return, throw, typeof, void, yield, await
function isExpressionKeyword (pos) {
  switch (source.charCodeAt(pos)) {
    case 100/*d*/:
      switch (source.charCodeAt(pos - 1)) {
        case 105/*i*/:
          // void
          return readPrecedingKeyword(pos - 2, 'vo');
        case 108/*l*/:
          // yield
          return readPrecedingKeyword(pos - 2, 'yie');
        default:
          return false;
      }
    case 101/*e*/:
      switch (source.charCodeAt(pos - 1)) {
        case 115/*s*/:
          switch (source.charCodeAt(pos - 2)) {
            case 108/*l*/:
              // else
              return readPrecedingKeyword1(pos - 3, 101/*e*/);
            case 97/*a*/:
              // case
              return readPrecedingKeyword1(pos - 3, 99/*c*/);
            default:
              return false;
          }
        case 116/*t*/:
          // delete
          return readPrecedingKeyword(pos - 2, 'dele');
        default:
          return false;
      }
    case 102/*f*/:
      if (source.charCodeAt(pos - 1) !== 111/*o*/ || source.charCodeAt(pos - 2) !== 101/*e*/)
        return false;
      switch (source.charCodeAt(pos - 3)) {
        case 99/*c*/:
          // instanceof
          return readPrecedingKeyword(pos - 4, 'instan');
        case 112/*p*/:
          // typeof
          return readPrecedingKeyword(pos - 4, 'ty');
        default:
          return false;
      }
    case 110/*n*/:
      // in, return
      return readPrecedingKeyword1(pos - 1, 105/*i*/) || readPrecedingKeyword(pos - 1, 'retur');
    case 111/*o*/:
      // do
      return readPrecedingKeyword1(pos - 1, 100/*d*/);
    case 114/*r*/:
      // debugger
      return readPrecedingKeyword(pos - 1, 'debugge');
    case 116/*t*/:
      // await
      return readPrecedingKeyword(pos - 1, 'awai');
    case 119/*w*/:
      switch (source.charCodeAt(pos - 1)) {
        case 101/*e*/:
          // new
          return readPrecedingKeyword1(pos - 2, 110/*n*/);
        case 111/*o*/:
          // throw
          return readPrecedingKeyword(pos - 2, 'thr');
        default:
          return false;
      }
  }
  return false;
}

function isParenKeyword (curPos) {
  return source.charCodeAt(curPos) === 101/*e*/ && source.startsWith('whil', curPos - 4) ||
      source.charCodeAt(curPos) === 114/*r*/ && source.startsWith('fo', curPos - 2) ||
      source.charCodeAt(curPos - 1) === 105/*i*/ && source.charCodeAt(curPos) === 102/*f*/;
}

function isPunctuator (ch) {
  // 23 possible punctuator endings: !%&()*+,-./:;<=>?[]^{}|~
  return ch === 33/*!*/ || ch === 37/*%*/ || ch === 38/*&*/ ||
    ch > 39 && ch < 48 || ch > 57 && ch < 64 ||
    ch === 91/*[*/ || ch === 93/*]*/ || ch === 94/*^*/ ||
    ch > 122 && ch < 127;
}

function isExpressionPunctuator (ch) {
  // 20 possible expression endings: !%&(*+,-.:;<=>?[^{|~
  return ch === 33/*!*/ || ch === 37/*%*/ || ch === 38/*&*/ ||
    ch > 39 && ch < 47 && ch !== 41 || ch > 57 && ch < 64 ||
    ch === 91/*[*/ || ch === 94/*^*/ || ch > 122 && ch < 127 && ch !== 125/*}*/;
}

function isExpressionTerminator (curPos) {
  // detects:
  // => ; ) finally catch else
  // as all of these followed by a { will indicate a statement brace
  switch (source.charCodeAt(curPos)) {
    case 62/*>*/:
      return source.charCodeAt(curPos - 1) === 61/*=*/;
    case 59/*;*/:
    case 41/*)*/:
      return true;
    case 104/*h*/:
      return source.startsWith('catc', curPos - 4);
    case 121/*y*/:
      return source.startsWith('finall', curPos - 6);
    case 101/*e*/:
      return source.startsWith('els', curPos - 3);
  }
  return false;
}

const initPromise = Promise.resolve();

module.exports.init = () => initPromise;
module.exports.initSync = () => {};
module.exports.parse = parseCJS;
)JS2C1b732aee");static StaticExternalOneByteResource internal_deps_cjs_module_lexer_lexer_resource(internal_deps_cjs_module_lexer_lexer_raw, 53714, nullptr);

static const uint8_t *internal_deps_minimatch_index_raw = reinterpret_cast<const uint8_t*>(R"JS2C1b732aee("use strict";
var __getOwnPropNames = Object.getOwnPropertyNames;
var __commonJS = (cb, mod) => function __require() {
  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;
};

// node_modules/@isaacs/balanced-match/dist/commonjs/index.js
var require_commonjs = __commonJS({
  "node_modules/@isaacs/balanced-match/dist/commonjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.range = exports2.balanced = void 0;
    var balanced = (a, b, str) => {
      const ma = a instanceof RegExp ? maybeMatch(a, str) : a;
      const mb = b instanceof RegExp ? maybeMatch(b, str) : b;
      const r = ma !== null && mb != null && (0, exports2.range)(ma, mb, str);
      return r && {
        start: r[0],
        end: r[1],
        pre: str.slice(0, r[0]),
        body: str.slice(r[0] + ma.length, r[1]),
        post: str.slice(r[1] + mb.length)
      };
    };
    exports2.balanced = balanced;
    var maybeMatch = (reg, str) => {
      const m = str.match(reg);
      return m ? m[0] : null;
    };
    var range = (a, b, str) => {
      let begs, beg, left, right = void 0, result;
      let ai = str.indexOf(a);
      let bi = str.indexOf(b, ai + 1);
      let i = ai;
      if (ai >= 0 && bi > 0) {
        if (a === b) {
          return [ai, bi];
        }
        begs = [];
        left = str.length;
        while (i >= 0 && !result) {
          if (i === ai) {
            begs.push(i);
            ai = str.indexOf(a, i + 1);
          } else if (begs.length === 1) {
            const r = begs.pop();
            if (r !== void 0)
              result = [r, bi];
          } else {
            beg = begs.pop();
            if (beg !== void 0 && beg < left) {
              left = beg;
              right = bi;
            }
            bi = str.indexOf(b, i + 1);
          }
          i = ai < bi && ai >= 0 ? ai : bi;
        }
        if (begs.length && right !== void 0) {
          result = [left, right];
        }
      }
      return result;
    };
    exports2.range = range;
  }
});

// node_modules/@isaacs/brace-expansion/dist/commonjs/index.js
var require_commonjs2 = __commonJS({
  "node_modules/@isaacs/brace-expansion/dist/commonjs/index.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.expand = expand;
    var balanced_match_1 = require_commonjs();
    var escSlash = "\0SLASH" + Math.random() + "\0";
    var escOpen = "\0OPEN" + Math.random() + "\0";
    var escClose = "\0CLOSE" + Math.random() + "\0";
    var escComma = "\0COMMA" + Math.random() + "\0";
    var escPeriod = "\0PERIOD" + Math.random() + "\0";
    var escSlashPattern = new RegExp(escSlash, "g");
    var escOpenPattern = new RegExp(escOpen, "g");
    var escClosePattern = new RegExp(escClose, "g");
    var escCommaPattern = new RegExp(escComma, "g");
    var escPeriodPattern = new RegExp(escPeriod, "g");
    var slashPattern = /\\\\/g;
    var openPattern = /\\{/g;
    var closePattern = /\\}/g;
    var commaPattern = /\\,/g;
    var periodPattern = /\\./g;
    function numeric(str) {
      return !isNaN(str) ? parseInt(str, 10) : str.charCodeAt(0);
    }
    function escapeBraces(str) {
      return str.replace(slashPattern, escSlash).replace(openPattern, escOpen).replace(closePattern, escClose).replace(commaPattern, escComma).replace(periodPattern, escPeriod);
    }
    function unescapeBraces(str) {
      return str.replace(escSlashPattern, "\\").replace(escOpenPattern, "{").replace(escClosePattern, "}").replace(escCommaPattern, ",").replace(escPeriodPattern, ".");
    }
    function parseCommaParts(str) {
      if (!str) {
        return [""];
      }
      const parts = [];
      const m = (0, balanced_match_1.balanced)("{", "}", str);
      if (!m) {
        return str.split(",");
      }
      const { pre, body, post } = m;
      const p = pre.split(",");
      p[p.length - 1] += "{" + body + "}";
      const postParts = parseCommaParts(post);
      if (post.length) {
        ;
        p[p.length - 1] += postParts.shift();
        p.push.apply(p, postParts);
      }
      parts.push.apply(parts, p);
      return parts;
    }
    function expand(str) {
      if (!str) {
        return [];
      }
      if (str.slice(0, 2) === "{}") {
        str = "\\{\\}" + str.slice(2);
      }
      return expand_(escapeBraces(str), true).map(unescapeBraces);
    }
    function embrace(str) {
      return "{" + str + "}";
    }
    function isPadded(el) {
      return /^-?0\d/.test(el);
    }
    function lte(i, y) {
      return i <= y;
    }
    function gte(i, y) {
      return i >= y;
    }
    function expand_(str, isTop) {
      const expansions = [];
      const m = (0, balanced_match_1.balanced)("{", "}", str);
      if (!m)
        return [str];
      const pre = m.pre;
      const post = m.post.length ? expand_(m.post, false) : [""];
      if (/\$$/.test(m.pre)) {
        for (let k = 0; k < post.length; k++) {
          const expansion = pre + "{" + m.body + "}" + post[k];
          expansions.push(expansion);
        }
      } else {
        const isNumericSequence = /^-?\d+\.\.-?\d+(?:\.\.-?\d+)?$/.test(m.body);
        const isAlphaSequence = /^[a-zA-Z]\.\.[a-zA-Z](?:\.\.-?\d+)?$/.test(m.body);
        const isSequence = isNumericSequence || isAlphaSequence;
        const isOptions = m.body.indexOf(",") >= 0;
        if (!isSequence && !isOptions) {
          if (m.post.match(/,(?!,).*\}/)) {
            str = m.pre + "{" + m.body + escClose + m.post;
            return expand_(str);
          }
          return [str];
        }
        let n;
        if (isSequence) {
          n = m.body.split(/\.\./);
        } else {
          n = parseCommaParts(m.body);
          if (n.length === 1 && n[0] !== void 0) {
            n = expand_(n[0], false).map(embrace);
            if (n.length === 1) {
              return post.map((p) => m.pre + n[0] + p);
            }
          }
        }
        let N;
        if (isSequence && n[0] !== void 0 && n[1] !== void 0) {
          const x = numeric(n[0]);
          const y = numeric(n[1]);
          const width = Math.max(n[0].length, n[1].length);
          let incr = n.length === 3 && n[2] !== void 0 ? Math.abs(numeric(n[2])) : 1;
          let test = lte;
          const reverse = y < x;
          if (reverse) {
            incr *= -1;
            test = gte;
          }
          const pad = n.some(isPadded);
          N = [];
          for (let i = x; test(i, y); i += incr) {
            let c;
            if (isAlphaSequence) {
              c = String.fromCharCode(i);
              if (c === "\\") {
                c = "";
              }
            } else {
              c = String(i);
              if (pad) {
                const need = width - c.length;
                if (need > 0) {
                  const z = new Array(need + 1).join("0");
                  if (i < 0) {
                    c = "-" + z + c.slice(1);
                  } else {
                    c = z + c;
                  }
                }
              }
            }
            N.push(c);
          }
        } else {
          N = [];
          for (let j = 0; j < n.length; j++) {
            N.push.apply(N, expand_(n[j], false));
          }
        }
        for (let j = 0; j < N.length; j++) {
          for (let k = 0; k < post.length; k++) {
            const expansion = pre + N[j] + post[k];
            if (!isTop || isSequence || expansion) {
              expansions.push(expansion);
            }
          }
        }
      }
      return expansions;
    }
  }
});

// dist/commonjs/assert-valid-pattern.js
var require_assert_valid_pattern = __commonJS({
  "dist/commonjs/assert-valid-pattern.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.assertValidPattern = void 0;
    var MAX_PATTERN_LENGTH = 1024 * 64;
    var assertValidPattern = (pattern) => {
      if (typeof pattern !== "string") {
        throw new TypeError("invalid pattern");
      }
      if (pattern.length > MAX_PATTERN_LENGTH) {
        throw new TypeError("pattern is too long");
      }
    };
    exports2.assertValidPattern = assertValidPattern;
  }
});

// dist/commonjs/brace-expressions.js
var require_brace_expressions = __commonJS({
  "dist/commonjs/brace-expressions.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.parseClass = void 0;
    var posixClasses = {
      "[:alnum:]": ["\\p{L}\\p{Nl}\\p{Nd}", true],
      "[:alpha:]": ["\\p{L}\\p{Nl}", true],
      "[:ascii:]": ["\\x00-\\x7f", false],
      "[:blank:]": ["\\p{Zs}\\t", true],
      "[:cntrl:]": ["\\p{Cc}", true],
      "[:digit:]": ["\\p{Nd}", true],
      "[:graph:]": ["\\p{Z}\\p{C}", true, true],
      "[:lower:]": ["\\p{Ll}", true],
      "[:print:]": ["\\p{C}", true],
      "[:punct:]": ["\\p{P}", true],
      "[:space:]": ["\\p{Z}\\t\\r\\n\\v\\f", true],
      "[:upper:]": ["\\p{Lu}", true],
      "[:word:]": ["\\p{L}\\p{Nl}\\p{Nd}\\p{Pc}", true],
      "[:xdigit:]": ["A-Fa-f0-9", false]
    };
    var braceEscape = (s) => s.replace(/[[\]\\-]/g, "\\$&");
    var regexpEscape = (s) => s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    var rangesToString = (ranges) => ranges.join("");
    var parseClass = (glob, position) => {
      const pos = position;
      if (glob.charAt(pos) !== "[") {
        throw new Error("not in a brace expression");
      }
      const ranges = [];
      const negs = [];
      let i = pos + 1;
      let sawStart = false;
      let uflag = false;
      let escaping = false;
      let negate = false;
      let endPos = pos;
      let rangeStart = "";
      WHILE: while (i < glob.length) {
        const c = glob.charAt(i);
        if ((c === "!" || c === "^") && i === pos + 1) {
          negate = true;
          i++;
          continue;
        }
        if (c === "]" && sawStart && !escaping) {
          endPos = i + 1;
          break;
        }
        sawStart = true;
        if (c === "\\") {
          if (!escaping) {
            escaping = true;
            i++;
            continue;
          }
        }
        if (c === "[" && !escaping) {
          for (const [cls, [unip, u, neg]] of Object.entries(posixClasses)) {
            if (glob.startsWith(cls, i)) {
              if (rangeStart) {
                return ["$.", false, glob.length - pos, true];
              }
              i += cls.length;
              if (neg)
                negs.push(unip);
              else
                ranges.push(unip);
              uflag = uflag || u;
              continue WHILE;
            }
          }
        }
        escaping = false;
        if (rangeStart) {
          if (c > rangeStart) {
            ranges.push(braceEscape(rangeStart) + "-" + braceEscape(c));
          } else if (c === rangeStart) {
            ranges.push(braceEscape(c));
          }
          rangeStart = "";
          i++;
          continue;
        }
        if (glob.startsWith("-]", i + 1)) {
          ranges.push(braceEscape(c + "-"));
          i += 2;
          continue;
        }
        if (glob.startsWith("-", i + 1)) {
          rangeStart = c;
          i += 2;
          continue;
        }
        ranges.push(braceEscape(c));
        i++;
      }
      if (endPos < i) {
        return ["", false, 0, false];
      }
      if (!ranges.length && !negs.length) {
        return ["$.", false, glob.length - pos, true];
      }
      if (negs.length === 0 && ranges.length === 1 && /^\\?.$/.test(ranges[0]) && !negate) {
        const r = ranges[0].length === 2 ? ranges[0].slice(-1) : ranges[0];
        return [regexpEscape(r), false, endPos - pos, false];
      }
      const sranges = "[" + (negate ? "^" : "") + rangesToString(ranges) + "]";
      const snegs = "[" + (negate ? "" : "^") + rangesToString(negs) + "]";
      const comb = ranges.length && negs.length ? "(" + sranges + "|" + snegs + ")" : ranges.length ? sranges : snegs;
      return [comb, uflag, endPos - pos, true];
    };
    exports2.parseClass = parseClass;
  }
});

// dist/commonjs/unescape.js
var require_unescape = __commonJS({
  "dist/commonjs/unescape.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.unescape = void 0;
    var unescape = (s, { windowsPathsNoEscape = false } = {}) => {
      return windowsPathsNoEscape ? s.replace(/\[([^\/\\])\]/g, "$1") : s.replace(/((?!\\).|^)\[([^\/\\])\]/g, "$1$2").replace(/\\([^\/])/g, "$1");
    };
    exports2.unescape = unescape;
  }
});

// dist/commonjs/ast.js
var require_ast = __commonJS({
  "dist/commonjs/ast.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.AST = void 0;
    var brace_expressions_js_1 = require_brace_expressions();
    var unescape_js_12 = require_unescape();
    var types = /* @__PURE__ */ new Set(["!", "?", "+", "*", "@"]);
    var isExtglobType = (c) => types.has(c);
    var startNoTraversal = "(?!(?:^|/)\\.\\.?(?:$|/))";
    var startNoDot = "(?!\\.)";
    var addPatternStart = /* @__PURE__ */ new Set(["[", "."]);
    var justDots = /* @__PURE__ */ new Set(["..", "."]);
    var reSpecials = new Set("().*{}+?[]^$\\!");
    var regExpEscape2 = (s) => s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
    var qmark2 = "[^/]";
    var star2 = qmark2 + "*?";
    var starNoEmpty = qmark2 + "+?";
    var AST = class _AST {
      type;
      #root;
      #hasMagic;
      #uflag = false;
      #parts = [];
      #parent;
      #parentIndex;
      #negs;
      #filledNegs = false;
      #options;
      #toString;
      // set to true if it's an extglob with no children
      // (which really means one child of '')
      #emptyExt = false;
      constructor(type, parent, options = {}) {
        this.type = type;
        if (type)
          this.#hasMagic = true;
        this.#parent = parent;
        this.#root = this.#parent ? this.#parent.#root : this;
        this.#options = this.#root === this ? options : this.#root.#options;
        this.#negs = this.#root === this ? [] : this.#root.#negs;
        if (type === "!" && !this.#root.#filledNegs)
          this.#negs.push(this);
        this.#parentIndex = this.#parent ? this.#parent.#parts.length : 0;
      }
      get hasMagic() {
        if (this.#hasMagic !== void 0)
          return this.#hasMagic;
        for (const p of this.#parts) {
          if (typeof p === "string")
            continue;
          if (p.type || p.hasMagic)
            return this.#hasMagic = true;
        }
        return this.#hasMagic;
      }
      // reconstructs the pattern
      toString() {
        if (this.#toString !== void 0)
          return this.#toString;
        if (!this.type) {
          return this.#toString = this.#parts.map((p) => String(p)).join("");
        } else {
          return this.#toString = this.type + "(" + this.#parts.map((p) => String(p)).join("|") + ")";
        }
      }
      #fillNegs() {
        if (this !== this.#root)
          throw new Error("should only call on root");
        if (this.#filledNegs)
          return this;
        this.toString();
        this.#filledNegs = true;
        let n;
        while (n = this.#negs.pop()) {
          if (n.type !== "!")
            continue;
          let p = n;
          let pp = p.#parent;
          while (pp) {
            for (let i = p.#parentIndex + 1; !pp.type && i < pp.#parts.length; i++) {
              for (const part of n.#parts) {
                if (typeof part === "string") {
                  throw new Error("string part in extglob AST??");
                }
                part.copyIn(pp.#parts[i]);
              }
            }
            p = pp;
            pp = p.#parent;
          }
        }
        return this;
      }
      push(...parts) {
        for (const p of parts) {
          if (p === "")
            continue;
          if (typeof p !== "string" && !(p instanceof _AST && p.#parent === this)) {
            throw new Error("invalid part: " + p);
          }
          this.#parts.push(p);
        }
      }
      toJSON() {
        const ret = this.type === null ? this.#parts.slice().map((p) => typeof p === "string" ? p : p.toJSON()) : [this.type, ...this.#parts.map((p) => p.toJSON())];
        if (this.isStart() && !this.type)
          ret.unshift([]);
        if (this.isEnd() && (this === this.#root || this.#root.#filledNegs && this.#parent?.type === "!")) {
          ret.push({});
        }
        return ret;
      }
      isStart() {
        if (this.#root === this)
          return true;
        if (!this.#parent?.isStart())
          return false;
        if (this.#parentIndex === 0)
          return true;
        const p = this.#parent;
        for (let i = 0; i < this.#parentIndex; i++) {
          const pp = p.#parts[i];
          if (!(pp instanceof _AST && pp.type === "!")) {
            return false;
          }
        }
        return true;
      }
      isEnd() {
        if (this.#root === this)
          return true;
        if (this.#parent?.type === "!")
          return true;
        if (!this.#parent?.isEnd())
          return false;
        if (!this.type)
          return this.#parent?.isEnd();
        const pl = this.#parent ? this.#parent.#parts.length : 0;
        return this.#parentIndex === pl - 1;
      }
      copyIn(part) {
        if (typeof part === "string")
          this.push(part);
        else
          this.push(part.clone(this));
      }
      clone(parent) {
        const c = new _AST(this.type, parent);
        for (const p of this.#parts) {
          c.copyIn(p);
        }
        return c;
      }
      static #parseAST(str, ast, pos, opt) {
        let escaping = false;
        let inBrace = false;
        let braceStart = -1;
        let braceNeg = false;
        if (ast.type === null) {
          let i2 = pos;
          let acc2 = "";
          while (i2 < str.length) {
            const c = str.charAt(i2++);
            if (escaping || c === "\\") {
              escaping = !escaping;
              acc2 += c;
              continue;
            }
            if (inBrace) {
              if (i2 === braceStart + 1) {
                if (c === "^" || c === "!") {
                  braceNeg = true;
                }
              } else if (c === "]" && !(i2 === braceStart + 2 && braceNeg)) {
                inBrace = false;
              }
              acc2 += c;
              continue;
            } else if (c === "[") {
              inBrace = true;
              braceStart = i2;
              braceNeg = false;
              acc2 += c;
              continue;
            }
            if (!opt.noext && isExtglobType(c) && str.charAt(i2) === "(") {
              ast.push(acc2);
              acc2 = "";
              const ext2 = new _AST(c, ast);
              i2 = _AST.#parseAST(str, ext2, i2, opt);
              ast.push(ext2);
              continue;
            }
            acc2 += c;
          }
          ast.push(acc2);
          return i2;
        }
        let i = pos + 1;
        let part = new _AST(null, ast);
        const parts = [];
        let acc = "";
        while (i < str.length) {
          const c = str.charAt(i++);
          if (escaping || c === "\\") {
            escaping = !escaping;
            acc += c;
            continue;
          }
          if (inBrace) {
            if (i === braceStart + 1) {
              if (c === "^" || c === "!") {
                braceNeg = true;
              }
            } else if (c === "]" && !(i === braceStart + 2 && braceNeg)) {
              inBrace = false;
            }
            acc += c;
            continue;
          } else if (c === "[") {
            inBrace = true;
            braceStart = i;
            braceNeg = false;
            acc += c;
            continue;
          }
          if (isExtglobType(c) && str.charAt(i) === "(") {
            part.push(acc);
            acc = "";
            const ext2 = new _AST(c, part);
            part.push(ext2);
            i = _AST.#parseAST(str, ext2, i, opt);
            continue;
          }
          if (c === "|") {
            part.push(acc);
            acc = "";
            parts.push(part);
            part = new _AST(null, ast);
            continue;
          }
          if (c === ")") {
            if (acc === "" && ast.#parts.length === 0) {
              ast.#emptyExt = true;
            }
            part.push(acc);
            acc = "";
            ast.push(...parts, part);
            return i;
          }
          acc += c;
        }
        ast.type = null;
        ast.#hasMagic = void 0;
        ast.#parts = [str.substring(pos - 1)];
        return i;
      }
      static fromGlob(pattern, options = {}) {
        const ast = new _AST(null, void 0, options);
        _AST.#parseAST(pattern, ast, 0, options);
        return ast;
      }
      // returns the regular expression if there's magic, or the unescaped
      // string if not.
      toMMPattern() {
        if (this !== this.#root)
          return this.#root.toMMPattern();
        const glob = this.toString();
        const [re, body, hasMagic, uflag] = this.toRegExpSource();
        const anyMagic = hasMagic || this.#hasMagic || this.#options.nocase && !this.#options.nocaseMagicOnly && glob.toUpperCase() !== glob.toLowerCase();
        if (!anyMagic) {
          return body;
        }
        const flags = (this.#options.nocase ? "i" : "") + (uflag ? "u" : "");
        return Object.assign(new RegExp(`^${re}$`, flags), {
          _src: re,
          _glob: glob
        });
      }
      get options() {
        return this.#options;
      }
      // returns the string match, the regexp source, whether there's magic
      // in the regexp (so a regular expression is required) and whether or
      // not the uflag is needed for the regular expression (for posix classes)
      // TODO: instead of injecting the start/end at this point, just return
      // the BODY of the regexp, along with the start/end portions suitable
      // for binding the start/end in either a joined full-path makeRe context
      // (where we bind to (^|/), or a standalone matchPart context (where
      // we bind to ^, and not /).  Otherwise slashes get duped!
      //
      // In part-matching mode, the start is:
      // - if not isStart: nothing
      // - if traversal possible, but not allowed: ^(?!\.\.?$)
      // - if dots allowed or not possible: ^
      // - if dots possible and not allowed: ^(?!\.)
      // end is:
      // - if not isEnd(): nothing
      // - else: $
      //
      // In full-path matching mode, we put the slash at the START of the
      // pattern, so start is:
      // - if first pattern: same as part-matching mode
      // - if not isStart(): nothing
      // - if traversal possible, but not allowed: /(?!\.\.?(?:$|/))
      // - if dots allowed or not possible: /
      // - if dots possible and not allowed: /(?!\.)
      // end is:
      // - if last pattern, same as part-matching mode
      // - else nothing
      //
      // Always put the (?:$|/) on negated tails, though, because that has to be
      // there to bind the end of the negated pattern portion, and it's easier to
      // just stick it in now rather than try to inject it later in the middle of
      // the pattern.
      //
      // We can just always return the same end, and leave it up to the caller
      // to know whether it's going to be used joined or in parts.
      // And, if the start is adjusted slightly, can do the same there:
      // - if not isStart: nothing
      // - if traversal possible, but not allowed: (?:/|^)(?!\.\.?$)
      // - if dots allowed or not possible: (?:/|^)
      // - if dots possible and not allowed: (?:/|^)(?!\.)
      //
      // But it's better to have a simpler binding without a conditional, for
      // performance, so probably better to return both start options.
      //
      // Then the caller just ignores the end if it's not the first pattern,
      // and the start always gets applied.
      //
      // But that's always going to be $ if it's the ending pattern, or nothing,
      // so the caller can just attach $ at the end of the pattern when building.
      //
      // So the todo is:
      // - better detect what kind of start is needed
      // - return both flavors of starting pattern
      // - attach $ at the end of the pattern when creating the actual RegExp
      //
      // Ah, but wait, no, that all only applies to the root when the first pattern
      // is not an extglob. If the first pattern IS an extglob, then we need all
      // that dot prevention biz to live in the extglob portions, because eg
      // +(*|.x*) can match .xy but not .yx.
      //
      // So, return the two flavors if it's #root and the first child is not an
      // AST, otherwise leave it to the child AST to handle it, and there,
      // use the (?:^|/) style of start binding.
      //
      // Even simplified further:
      // - Since the start for a join is eg /(?!\.) and the start for a part
      // is ^(?!\.), we can just prepend (?!\.) to the pattern (either root
      // or start or whatever) and prepend ^ or / at the Regexp construction.
      toRegExpSource(allowDot) {
        const dot = allowDot ?? !!this.#options.dot;
        if (this.#root === this)
          this.#fillNegs();
        if (!this.type) {
          const noEmpty = this.isStart() && this.isEnd();
          const src = this.#parts.map((p) => {
            const [re, _, hasMagic, uflag] = typeof p === "string" ? _AST.#parseGlob(p, this.#hasMagic, noEmpty) : p.toRegExpSource(allowDot);
            this.#hasMagic = this.#hasMagic || hasMagic;
            this.#uflag = this.#uflag || uflag;
            return re;
          }).join("");
          let start2 = "";
          if (this.isStart()) {
            if (typeof this.#parts[0] === "string") {
              const dotTravAllowed = this.#parts.length === 1 && justDots.has(this.#parts[0]);
              if (!dotTravAllowed) {
                const aps = addPatternStart;
                const needNoTrav = (
                  // dots are allowed, and the pattern starts with [ or .
                  dot && aps.has(src.charAt(0)) || // the pattern starts with \., and then [ or .
                  src.startsWith("\\.") && aps.has(src.charAt(2)) || // the pattern starts with \.\., and then [ or .
                  src.startsWith("\\.\\.") && aps.has(src.charAt(4))
                );
                const needNoDot = !dot && !allowDot && aps.has(src.charAt(0));
                start2 = needNoTrav ? startNoTraversal : needNoDot ? startNoDot : "";
              }
            }
          }
          let end = "";
          if (this.isEnd() && this.#root.#filledNegs && this.#parent?.type === "!") {
            end = "(?:$|\\/)";
          }
          const final2 = start2 + src + end;
          return [
            final2,
            (0, unescape_js_12.unescape)(src),
            this.#hasMagic = !!this.#hasMagic,
            this.#uflag
          ];
        }
        const repeated = this.type === "*" || this.type === "+";
        const start = this.type === "!" ? "(?:(?!(?:" : "(?:";
        let body = this.#partsToRegExp(dot);
        if (this.isStart() && this.isEnd() && !body && this.type !== "!") {
          const s = this.toString();
          this.#parts = [s];
          this.type = null;
          this.#hasMagic = void 0;
          return [s, (0, unescape_js_12.unescape)(this.toString()), false, false];
        }
        let bodyDotAllowed = !repeated || allowDot || dot || !startNoDot ? "" : this.#partsToRegExp(true);
        if (bodyDotAllowed === body) {
          bodyDotAllowed = "";
        }
        if (bodyDotAllowed) {
          body = `(?:${body})(?:${bodyDotAllowed})*?`;
        }
        let final = "";
        if (this.type === "!" && this.#emptyExt) {
          final = (this.isStart() && !dot ? startNoDot : "") + starNoEmpty;
        } else {
          const close = this.type === "!" ? (
            // !() must match something,but !(x) can match ''
            "))" + (this.isStart() && !dot && !allowDot ? startNoDot : "") + star2 + ")"
          ) : this.type === "@" ? ")" : this.type === "?" ? ")?" : this.type === "+" && bodyDotAllowed ? ")" : this.type === "*" && bodyDotAllowed ? `)?` : `)${this.type}`;
          final = start + body + close;
        }
        return [
          final,
          (0, unescape_js_12.unescape)(body),
          this.#hasMagic = !!this.#hasMagic,
          this.#uflag
        ];
      }
      #partsToRegExp(dot) {
        return this.#parts.map((p) => {
          if (typeof p === "string") {
            throw new Error("string type in extglob ast??");
          }
          const [re, _, _hasMagic, uflag] = p.toRegExpSource(dot);
          this.#uflag = this.#uflag || uflag;
          return re;
        }).filter((p) => !(this.isStart() && this.isEnd()) || !!p).join("|");
      }
      static #parseGlob(glob, hasMagic, noEmpty = false) {
        let escaping = false;
        let re = "";
        let uflag = false;
        for (let i = 0; i < glob.length; i++) {
          const c = glob.charAt(i);
          if (escaping) {
            escaping = false;
            re += (reSpecials.has(c) ? "\\" : "") + c;
            continue;
          }
          if (c === "\\") {
            if (i === glob.length - 1) {
              re += "\\\\";
            } else {
              escaping = true;
            }
            continue;
          }
          if (c === "[") {
            const [src, needUflag, consumed, magic] = (0, brace_expressions_js_1.parseClass)(glob, i);
            if (consumed) {
              re += src;
              uflag = uflag || needUflag;
              i += consumed - 1;
              hasMagic = hasMagic || magic;
              continue;
            }
          }
          if (c === "*") {
            if (noEmpty && glob === "*")
              re += starNoEmpty;
            else
              re += star2;
            hasMagic = true;
            continue;
          }
          if (c === "?") {
            re += qmark2;
            hasMagic = true;
            continue;
          }
          re += regExpEscape2(c);
        }
        return [re, (0, unescape_js_12.unescape)(glob), !!hasMagic, uflag];
      }
    };
    exports2.AST = AST;
  }
});

// dist/commonjs/escape.js
var require_escape = __commonJS({
  "dist/commonjs/escape.js"(exports2) {
    "use strict";
    Object.defineProperty(exports2, "__esModule", { value: true });
    exports2.escape = void 0;
    var escape = (s, { windowsPathsNoEscape = false } = {}) => {
      return windowsPathsNoEscape ? s.replace(/[?*()[\]]/g, "[$&]") : s.replace(/[?*()[\]\\]/g, "\\$&");
    };
    exports2.escape = escape;
  }
});

// dist/commonjs/index.js
Object.defineProperty(exports, "__esModule", { value: true });
exports.unescape = exports.escape = exports.AST = exports.Minimatch = exports.match = exports.makeRe = exports.braceExpand = exports.defaults = exports.filter = exports.GLOBSTAR = exports.sep = exports.minimatch = void 0;
var brace_expansion_1 = require_commonjs2();
var assert_valid_pattern_js_1 = require_assert_valid_pattern();
var ast_js_1 = require_ast();
var escape_js_1 = require_escape();
var unescape_js_1 = require_unescape();
var minimatch = (p, pattern, options = {}) => {
  (0, assert_valid_pattern_js_1.assertValidPattern)(pattern);
  if (!options.nocomment && pattern.charAt(0) === "#") {
    return false;
  }
  return new Minimatch(pattern, options).match(p);
};
exports.minimatch = minimatch;
var starDotExtRE = /^\*+([^+@!?\*\[\(]*)$/;
var starDotExtTest = (ext2) => (f) => !f.startsWith(".") && f.endsWith(ext2);
var starDotExtTestDot = (ext2) => (f) => f.endsWith(ext2);
var starDotExtTestNocase = (ext2) => {
  ext2 = ext2.toLowerCase();
  return (f) => !f.startsWith(".") && f.toLowerCase().endsWith(ext2);
};
var starDotExtTestNocaseDot = (ext2) => {
  ext2 = ext2.toLowerCase();
  return (f) => f.toLowerCase().endsWith(ext2);
};
var starDotStarRE = /^\*+\.\*+$/;
var starDotStarTest = (f) => !f.startsWith(".") && f.includes(".");
var starDotStarTestDot = (f) => f !== "." && f !== ".." && f.includes(".");
var dotStarRE = /^\.\*+$/;
var dotStarTest = (f) => f !== "." && f !== ".." && f.startsWith(".");
var starRE = /^\*+$/;
var starTest = (f) => f.length !== 0 && !f.startsWith(".");
var starTestDot = (f) => f.length !== 0 && f !== "." && f !== "..";
var qmarksRE = /^\?+([^+@!?\*\[\(]*)?$/;
var qmarksTestNocase = ([$0, ext2 = ""]) => {
  const noext = qmarksTestNoExt([$0]);
  if (!ext2)
    return noext;
  ext2 = ext2.toLowerCase();
  return (f) => noext(f) && f.toLowerCase().endsWith(ext2);
};
var qmarksTestNocaseDot = ([$0, ext2 = ""]) => {
  const noext = qmarksTestNoExtDot([$0]);
  if (!ext2)
    return noext;
  ext2 = ext2.toLowerCase();
  return (f) => noext(f) && f.toLowerCase().endsWith(ext2);
};
var qmarksTestDot = ([$0, ext2 = ""]) => {
  const noext = qmarksTestNoExtDot([$0]);
  return !ext2 ? noext : (f) => noext(f) && f.endsWith(ext2);
};
var qmarksTest = ([$0, ext2 = ""]) => {
  const noext = qmarksTestNoExt([$0]);
  return !ext2 ? noext : (f) => noext(f) && f.endsWith(ext2);
};
var qmarksTestNoExt = ([$0]) => {
  const len = $0.length;
  return (f) => f.length === len && !f.startsWith(".");
};
var qmarksTestNoExtDot = ([$0]) => {
  const len = $0.length;
  return (f) => f.length === len && f !== "." && f !== "..";
};
var defaultPlatform = typeof process === "object" && process ? typeof process.env === "object" && process.env && process.env.__MINIMATCH_TESTING_PLATFORM__ || process.platform : "posix";
var path = {
  win32: { sep: "\\" },
  posix: { sep: "/" }
};
exports.sep = defaultPlatform === "win32" ? path.win32.sep : path.posix.sep;
exports.minimatch.sep = exports.sep;
exports.GLOBSTAR = Symbol("globstar **");
exports.minimatch.GLOBSTAR = exports.GLOBSTAR;
var qmark = "[^/]";
var star = qmark + "*?";
var twoStarDot = "(?:(?!(?:\\/|^)(?:\\.{1,2})($|\\/)).)*?";
var twoStarNoDot = "(?:(?!(?:\\/|^)\\.).)*?";
var filter = (pattern, options = {}) => (p) => (0, exports.minimatch)(p, pattern, options);
exports.filter = filter;
exports.minimatch.filter = exports.filter;
var ext = (a, b = {}) => Object.assign({}, a, b);
var defaults = (def) => {
  if (!def || typeof def !== "object" || !Object.keys(def).length) {
    return exports.minimatch;
  }
  const orig = exports.minimatch;
  const m = (p, pattern, options = {}) => orig(p, pattern, ext(def, options));
  return Object.assign(m, {
    Minimatch: class Minimatch extends orig.Minimatch {
      constructor(pattern, options = {}) {
        super(pattern, ext(def, options));
      }
      static defaults(options) {
        return orig.defaults(ext(def, options)).Minimatch;
      }
    },
    AST: class AST extends orig.AST {
      /* c8 ignore start */
      constructor(type, parent, options = {}) {
        super(type, parent, ext(def, options));
      }
      /* c8 ignore stop */
      static fromGlob(pattern, options = {}) {
        return orig.AST.fromGlob(pattern, ext(def, options));
      }
    },
    unescape: (s, options = {}) => orig.unescape(s, ext(def, options)),
    escape: (s, options = {}) => orig.escape(s, ext(def, options)),
    filter: (pattern, options = {}) => orig.filter(pattern, ext(def, options)),
    defaults: (options) => orig.defaults(ext(def, options)),
    makeRe: (pattern, options = {}) => orig.makeRe(pattern, ext(def, options)),
    braceExpand: (pattern, options = {}) => orig.braceExpand(pattern, ext(def, options)),
    match: (list, pattern, options = {}) => orig.match(list, pattern, ext(def, options)),
    sep: orig.sep,
    GLOBSTAR: exports.GLOBSTAR
  });
};
exports.defaults = defaults;
exports.minimatch.defaults = exports.defaults;
var braceExpand = (pattern, options = {}) => {
  (0, assert_valid_pattern_js_1.assertValidPattern)(pattern);
  if (options.nobrace || !/\{(?:(?!\{).)*\}/.test(pattern)) {
    return [pattern];
  }
  return (0, brace_expansion_1.expand)(pattern);
};
exports.braceExpand = braceExpand;
exports.minimatch.braceExpand = exports.braceExpand;
var makeRe = (pattern, options = {}) => new Minimatch(pattern, options).makeRe();
exports.makeRe = makeRe;
exports.minimatch.makeRe = exports.makeRe;
var match = (list, pattern, options = {}) => {
  const mm = new Minimatch(pattern, options);
  list = list.filter((f) => mm.match(f));
  if (mm.options.nonull && !list.length) {
    list.push(pattern);
  }
  return list;
};
exports.match = match;
exports.minimatch.match = exports.match;
var globMagic = /[?*]|[+@!]\(.*?\)|\[|\]/;
var regExpEscape = (s) => s.replace(/[-[\]{}()*+?.,\\^$|#\s]/g, "\\$&");
var Minimatch = class {
  options;
  set;
  pattern;
  windowsPathsNoEscape;
  nonegate;
  negate;
  comment;
  empty;
  preserveMultipleSlashes;
  partial;
  globSet;
  globParts;
  nocase;
  isWindows;
  platform;
  windowsNoMagicRoot;
  regexp;
  constructor(pattern, options = {}) {
    (0, assert_valid_pattern_js_1.assertValidPattern)(pattern);
    options = options || {};
    this.options = options;
    this.pattern = pattern;
    this.platform = options.platform || defaultPlatform;
    this.isWindows = this.platform === "win32";
    this.windowsPathsNoEscape = !!options.windowsPathsNoEscape || options.allowWindowsEscape === false;
    if (this.windowsPathsNoEscape) {
      this.pattern = this.pattern.replace(/\\/g, "/");
    }
    this.preserveMultipleSlashes = !!options.preserveMultipleSlashes;
    this.regexp = null;
    this.negate = false;
    this.nonegate = !!options.nonegate;
    this.comment = false;
    this.empty = false;
    this.partial = !!options.partial;
    this.nocase = !!this.options.nocase;
    this.windowsNoMagicRoot = options.windowsNoMagicRoot !== void 0 ? options.windowsNoMagicRoot : !!(this.isWindows && this.nocase);
    this.globSet = [];
    this.globParts = [];
    this.set = [];
    this.make();
  }
  hasMagic() {
    if (this.options.magicalBraces && this.set.length > 1) {
      return true;
    }
    for (const pattern of this.set) {
      for (const part of pattern) {
        if (typeof part !== "string")
          return true;
      }
    }
    return false;
  }
  debug(..._) {
  }
  make() {
    const pattern = this.pattern;
    const options = this.options;
    if (!options.nocomment && pattern.charAt(0) === "#") {
      this.comment = true;
      return;
    }
    if (!pattern) {
      this.empty = true;
      return;
    }
    this.parseNegate();
    this.globSet = [...new Set(this.braceExpand())];
    if (options.debug) {
      this.debug = (...args) => console.error(...args);
    }
    this.debug(this.pattern, this.globSet);
    const rawGlobParts = this.globSet.map((s) => this.slashSplit(s));
    this.globParts = this.preprocess(rawGlobParts);
    this.debug(this.pattern, this.globParts);
    let set = this.globParts.map((s, _, __) => {
      if (this.isWindows && this.windowsNoMagicRoot) {
        const isUNC = s[0] === "" && s[1] === "" && (s[2] === "?" || !globMagic.test(s[2])) && !globMagic.test(s[3]);
        const isDrive = /^[a-z]:/i.test(s[0]);
        if (isUNC) {
          return [...s.slice(0, 4), ...s.slice(4).map((ss) => this.parse(ss))];
        } else if (isDrive) {
          return [s[0], ...s.slice(1).map((ss) => this.parse(ss))];
        }
      }
      return s.map((ss) => this.parse(ss));
    });
    this.debug(this.pattern, set);
    this.set = set.filter((s) => s.indexOf(false) === -1);
    if (this.isWindows) {
      for (let i = 0; i < this.set.length; i++) {
        const p = this.set[i];
        if (p[0] === "" && p[1] === "" && this.globParts[i][2] === "?" && typeof p[3] === "string" && /^[a-z]:$/i.test(p[3])) {
          p[2] = "?";
        }
      }
    }
    this.debug(this.pattern, this.set);
  }
  // various transforms to equivalent pattern sets that are
  // faster to process in a filesystem walk.  The goal is to
  // eliminate what we can, and push all ** patterns as far
  // to the right as possible, even if it increases the number
  // of patterns that we have to process.
  preprocess(globParts) {
    if (this.options.noglobstar) {
      for (let i = 0; i < globParts.length; i++) {
        for (let j = 0; j < globParts[i].length; j++) {
          if (globParts[i][j] === "**") {
            globParts[i][j] = "*";
          }
        }
      }
    }
    const { optimizationLevel = 1 } = this.options;
    if (optimizationLevel >= 2) {
      globParts = this.firstPhasePreProcess(globParts);
      globParts = this.secondPhasePreProcess(globParts);
    } else if (optimizationLevel >= 1) {
      globParts = this.levelOneOptimize(globParts);
    } else {
      globParts = this.adjascentGlobstarOptimize(globParts);
    }
    return globParts;
  }
  // just get rid of adjascent ** portions
  adjascentGlobstarOptimize(globParts) {
    return globParts.map((parts) => {
      let gs = -1;
      while (-1 !== (gs = parts.indexOf("**", gs + 1))) {
        let i = gs;
        while (parts[i + 1] === "**") {
          i++;
        }
        if (i !== gs) {
          parts.splice(gs, i - gs);
        }
      }
      return parts;
    });
  }
  // get rid of adjascent ** and resolve .. portions
  levelOneOptimize(globParts) {
    return globParts.map((parts) => {
      parts = parts.reduce((set, part) => {
        const prev = set[set.length - 1];
        if (part === "**" && prev === "**") {
          return set;
        }
        if (part === "..") {
          if (prev && prev !== ".." && prev !== "." && prev !== "**") {
            set.pop();
            return set;
          }
        }
        set.push(part);
        return set;
      }, []);
      return parts.length === 0 ? [""] : parts;
    });
  }
  levelTwoFileOptimize(parts) {
    if (!Array.isArray(parts)) {
      parts = this.slashSplit(parts);
    }
    let didSomething = false;
    do {
      didSomething = false;
      if (!this.preserveMultipleSlashes) {
        for (let i = 1; i < parts.length - 1; i++) {
          const p = parts[i];
          if (i === 1 && p === "" && parts[0] === "")
            continue;
          if (p === "." || p === "") {
            didSomething = true;
            parts.splice(i, 1);
            i--;
          }
        }
        if (parts[0] === "." && parts.length === 2 && (parts[1] === "." || parts[1] === "")) {
          didSomething = true;
          parts.pop();
        }
      }
      let dd = 0;
      while (-1 !== (dd = parts.indexOf("..", dd + 1))) {
        const p = parts[dd - 1];
        if (p && p !== "." && p !== ".." && p !== "**") {
          didSomething = true;
          parts.splice(dd - 1, 2);
          dd -= 2;
        }
      }
    } while (didSomething);
    return parts.length === 0 ? [""] : parts;
  }
  // First phase: single-pattern processing
  // <pre> is 1 or more portions
  // <rest> is 1 or more portions
  // <p> is any portion other than ., .., '', or **
  // <e> is . or ''
  //
  // **/.. is *brutal* for filesystem walking performance, because
  // it effectively resets the recursive walk each time it occurs,
  // and ** cannot be reduced out by a .. pattern part like a regexp
  // or most strings (other than .., ., and '') can be.
  //
  // <pre>/**/../<p>/<p>/<rest> -> {<pre>/../<p>/<p>/<rest>,<pre>/**/<p>/<p>/<rest>}
  // <pre>/<e>/<rest> -> <pre>/<rest>
  // <pre>/<p>/../<rest> -> <pre>/<rest>
  // **/**/<rest> -> **/<rest>
  //
  // **/*/<rest> -> */**/<rest> <== not valid because ** doesn't follow
  // this WOULD be allowed if ** did follow symlinks, or * didn't
  firstPhasePreProcess(globParts) {
    let didSomething = false;
    do {
      didSomething = false;
      for (let parts of globParts) {
        let gs = -1;
        while (-1 !== (gs = parts.indexOf("**", gs + 1))) {
          let gss = gs;
          while (parts[gss + 1] === "**") {
            gss++;
          }
          if (gss > gs) {
            parts.splice(gs + 1, gss - gs);
          }
          let next = parts[gs + 1];
          const p = parts[gs + 2];
          const p2 = parts[gs + 3];
          if (next !== "..")
            continue;
          if (!p || p === "." || p === ".." || !p2 || p2 === "." || p2 === "..") {
            continue;
          }
          didSomething = true;
          parts.splice(gs, 1);
          const other = parts.slice(0);
          other[gs] = "**";
          globParts.push(other);
          gs--;
        }
        if (!this.preserveMultipleSlashes) {
          for (let i = 1; i < parts.length - 1; i++) {
            const p = parts[i];
            if (i === 1 && p === "" && parts[0] === "")
              continue;
            if (p === "." || p === "") {
              didSomething = true;
              parts.splice(i, 1);
              i--;
            }
          }
          if (parts[0] === "." && parts.length === 2 && (parts[1] === "." || parts[1] === "")) {
            didSomething = true;
            parts.pop();
          }
        }
        let dd = 0;
        while (-1 !== (dd = parts.indexOf("..", dd + 1))) {
          const p = parts[dd - 1];
          if (p && p !== "." && p !== ".." && p !== "**") {
            didSomething = true;
            const needDot = dd === 1 && parts[dd + 1] === "**";
            const splin = needDot ? ["."] : [];
            parts.splice(dd - 1, 2, ...splin);
            if (parts.length === 0)
              parts.push("");
            dd -= 2;
          }
        }
      }
    } while (didSomething);
    return globParts;
  }
  // second phase: multi-pattern dedupes
  // {<pre>/*/<rest>,<pre>/<p>/<rest>} -> <pre>/*/<rest>
  // {<pre>/<rest>,<pre>/<rest>} -> <pre>/<rest>
  // {<pre>/**/<rest>,<pre>/<rest>} -> <pre>/**/<rest>
  //
  // {<pre>/**/<rest>,<pre>/**/<p>/<rest>} -> <pre>/**/<rest>
  // ^-- not valid because ** doens't follow symlinks
  secondPhasePreProcess(globParts) {
    for (let i = 0; i < globParts.length - 1; i++) {
      for (let j = i + 1; j < globParts.length; j++) {
        const matched = this.partsMatch(globParts[i], globParts[j], !this.preserveMultipleSlashes);
        if (matched) {
          globParts[i] = [];
          globParts[j] = matched;
          break;
        }
      }
    }
    return globParts.filter((gs) => gs.length);
  }
  partsMatch(a, b, emptyGSMatch = false) {
    let ai = 0;
    let bi = 0;
    let result = [];
    let which = "";
    while (ai < a.length && bi < b.length) {
      if (a[ai] === b[bi]) {
        result.push(which === "b" ? b[bi] : a[ai]);
        ai++;
        bi++;
      } else if (emptyGSMatch && a[ai] === "**" && b[bi] === a[ai + 1]) {
        result.push(a[ai]);
        ai++;
      } else if (emptyGSMatch && b[bi] === "**" && a[ai] === b[bi + 1]) {
        result.push(b[bi]);
        bi++;
      } else if (a[ai] === "*" && b[bi] && (this.options.dot || !b[bi].startsWith(".")) && b[bi] !== "**") {
        if (which === "b")
          return false;
        which = "a";
        result.push(a[ai]);
        ai++;
        bi++;
      } else if (b[bi] === "*" && a[ai] && (this.options.dot || !a[ai].startsWith(".")) && a[ai] !== "**") {
        if (which === "a")
          return false;
        which = "b";
        result.push(b[bi]);
        ai++;
        bi++;
      } else {
        return false;
      }
    }
    return a.length === b.length && result;
  }
  parseNegate() {
    if (this.nonegate)
      return;
    const pattern = this.pattern;
    let negate = false;
    let negateOffset = 0;
    for (let i = 0; i < pattern.length && pattern.charAt(i) === "!"; i++) {
      negate = !negate;
      negateOffset++;
    }
    if (negateOffset)
      this.pattern = pattern.slice(negateOffset);
    this.negate = negate;
  }
  // set partial to true to test if, for example,
  // "/a/b" matches the start of "/*/b/*/d"
  // Partial means, if you run out of file before you run
  // out of pattern, then that's fine, as long as all
  // the parts match.
  matchOne(file, pattern, partial = false) {
    const options = this.options;
    if (this.isWindows) {
      const fileDrive = typeof file[0] === "string" && /^[a-z]:$/i.test(file[0]);
      const fileUNC = !fileDrive && file[0] === "" && file[1] === "" && file[2] === "?" && /^[a-z]:$/i.test(file[3]);
      const patternDrive = typeof pattern[0] === "string" && /^[a-z]:$/i.test(pattern[0]);
      const patternUNC = !patternDrive && pattern[0] === "" && pattern[1] === "" && pattern[2] === "?" && typeof pattern[3] === "string" && /^[a-z]:$/i.test(pattern[3]);
      const fdi = fileUNC ? 3 : fileDrive ? 0 : void 0;
      const pdi = patternUNC ? 3 : patternDrive ? 0 : void 0;
      if (typeof fdi === "number" && typeof pdi === "number") {
        const [fd, pd] = [file[fdi], pattern[pdi]];
        if (fd.toLowerCase() === pd.toLowerCase()) {
          pattern[pdi] = fd;
          if (pdi > fdi) {
            pattern = pattern.slice(pdi);
          } else if (fdi > pdi) {
            file = file.slice(fdi);
          }
        }
      }
    }
    const { optimizationLevel = 1 } = this.options;
    if (optimizationLevel >= 2) {
      file = this.levelTwoFileOptimize(file);
    }
    this.debug("matchOne", this, { file, pattern });
    this.debug("matchOne", file.length, pattern.length);
    for (var fi = 0, pi = 0, fl = file.length, pl = pattern.length; fi < fl && pi < pl; fi++, pi++) {
      this.debug("matchOne loop");
      var p = pattern[pi];
      var f = file[fi];
      this.debug(pattern, p, f);
      if (p === false) {
        return false;
      }
      if (p === exports.GLOBSTAR) {
        this.debug("GLOBSTAR", [pattern, p, f]);
        var fr = fi;
        var pr = pi + 1;
        if (pr === pl) {
          this.debug("** at the end");
          for (; fi < fl; fi++) {
            if (file[fi] === "." || file[fi] === ".." || !options.dot && file[fi].charAt(0) === ".")
              return false;
          }
          return true;
        }
        while (fr < fl) {
          var swallowee = file[fr];
          this.debug("\nglobstar while", file, fr, pattern, pr, swallowee);
          if (this.matchOne(file.slice(fr), pattern.slice(pr), partial)) {
            this.debug("globstar found match!", fr, fl, swallowee);
            return true;
          } else {
            if (swallowee === "." || swallowee === ".." || !options.dot && swallowee.charAt(0) === ".") {
              this.debug("dot detected!", file, fr, pattern, pr);
              break;
            }
            this.debug("globstar swallow a segment, and continue");
            fr++;
          }
        }
        if (partial) {
          this.debug("\n>>> no match, partial?", file, fr, pattern, pr);
          if (fr === fl) {
            return true;
          }
        }
        return false;
      }
      let hit;
      if (typeof p === "string") {
        hit = f === p;
        this.debug("string match", p, f, hit);
      } else {
        hit = p.test(f);
        this.debug("pattern match", p, f, hit);
      }
      if (!hit)
        return false;
    }
    if (fi === fl && pi === pl) {
      return true;
    } else if (fi === fl) {
      return partial;
    } else if (pi === pl) {
      return fi === fl - 1 && file[fi] === "";
    } else {
      throw new Error("wtf?");
    }
  }
  braceExpand() {
    return (0, exports.braceExpand)(this.pattern, this.options);
  }
  parse(pattern) {
    (0, assert_valid_pattern_js_1.assertValidPattern)(pattern);
    const options = this.options;
    if (pattern === "**")
      return exports.GLOBSTAR;
    if (pattern === "")
      return "";
    let m;
    let fastTest = null;
    if (m = pattern.match(starRE)) {
      fastTest = options.dot ? starTestDot : starTest;
    } else if (m = pattern.match(starDotExtRE)) {
      fastTest = (options.nocase ? options.dot ? starDotExtTestNocaseDot : starDotExtTestNocase : options.dot ? starDotExtTestDot : starDotExtTest)(m[1]);
    } else if (m = pattern.match(qmarksRE)) {
      fastTest = (options.nocase ? options.dot ? qmarksTestNocaseDot : qmarksTestNocase : options.dot ? qmarksTestDot : qmarksTest)(m);
    } else if (m = pattern.match(starDotStarRE)) {
      fastTest = options.dot ? starDotStarTestDot : starDotStarTest;
    } else if (m = pattern.match(dotStarRE)) {
      fastTest = dotStarTest;
    }
    const re = ast_js_1.AST.fromGlob(pattern, this.options).toMMPattern();
    if (fastTest && typeof re === "object") {
      Reflect.defineProperty(re, "test", { value: fastTest });
    }
    return re;
  }
  makeRe() {
    if (this.regexp || this.regexp === false)
      return this.regexp;
    const set = this.set;
    if (!set.length) {
      this.regexp = false;
      return this.regexp;
    }
    const options = this.options;
    const twoStar = options.noglobstar ? star : options.dot ? twoStarDot : twoStarNoDot;
    const flags = new Set(options.nocase ? ["i"] : []);
    let re = set.map((pattern) => {
      const pp = pattern.map((p) => {
        if (p instanceof RegExp) {
          for (const f of p.flags.split(""))
            flags.add(f);
        }
        return typeof p === "string" ? regExpEscape(p) : p === exports.GLOBSTAR ? exports.GLOBSTAR : p._src;
      });
      pp.forEach((p, i) => {
        const next = pp[i + 1];
        const prev = pp[i - 1];
        if (p !== exports.GLOBSTAR || prev === exports.GLOBSTAR) {
          return;
        }
        if (prev === void 0) {
          if (next !== void 0 && next !== exports.GLOBSTAR) {
            pp[i + 1] = "(?:\\/|" + twoStar + "\\/)?" + next;
          } else {
            pp[i] = twoStar;
          }
        } else if (next === void 0) {
          pp[i - 1] = prev + "(?:\\/|" + twoStar + ")?";
        } else if (next !== exports.GLOBSTAR) {
          pp[i - 1] = prev + "(?:\\/|\\/" + twoStar + "\\/)" + next;
          pp[i + 1] = exports.GLOBSTAR;
        }
      });
      return pp.filter((p) => p !== exports.GLOBSTAR).join("/");
    }).join("|");
    const [open, close] = set.length > 1 ? ["(?:", ")"] : ["", ""];
    re = "^" + open + re + close + "$";
    if (this.negate)
      re = "^(?!" + re + ").+$";
    try {
      this.regexp = new RegExp(re, [...flags].join(""));
    } catch (ex) {
      this.regexp = false;
    }
    return this.regexp;
  }
  slashSplit(p) {
    if (this.preserveMultipleSlashes) {
      return p.split("/");
    } else if (this.isWindows && /^\/\/[^\/]+/.test(p)) {
      return ["", ...p.split(/\/+/)];
    } else {
      return p.split(/\/+/);
    }
  }
  match(f, partial = this.partial) {
    this.debug("match", f, this.pattern);
    if (this.comment) {
      return false;
    }
    if (this.empty) {
      return f === "";
    }
    if (f === "/" && partial) {
      return true;
    }
    const options = this.options;
    if (this.isWindows) {
      f = f.split("\\").join("/");
    }
    const ff = this.slashSplit(f);
    this.debug(this.pattern, "split", ff);
    const set = this.set;
    this.debug(this.pattern, "set", set);
    let filename = ff[ff.length - 1];
    if (!filename) {
      for (let i = ff.length - 2; !filename && i >= 0; i--) {
        filename = ff[i];
      }
    }
    for (let i = 0; i < set.length; i++) {
      const pattern = set[i];
      let file = ff;
      if (options.matchBase && pattern.length === 1) {
        file = [filename];
      }
      const hit = this.matchOne(file, pattern, partial);
      if (hit) {
        if (options.flipNegate) {
          return true;
        }
        return !this.negate;
      }
    }
    if (options.flipNegate) {
      return false;
    }
    return this.negate;
  }
  static defaults(def) {
    return exports.minimatch.defaults(def).Minimatch;
  }
};
exports.Minimatch = Minimatch;
var ast_js_2 = require_ast();
Object.defineProperty(exports, "AST", { enumerable: true, get: function() {
  return ast_js_2.AST;
} });
var escape_js_2 = require_escape();
Object.defineProperty(exports, "escape", { enumerable: true, get: function() {
  return escape_js_2.escape;
} });
var unescape_js_2 = require_unescape();
Object.defineProperty(exports, "unescape", { enumerable: true, get: function() {
  return unescape_js_2.unescape;
} });
exports.minimatch.AST = ast_js_1.AST;
exports.minimatch.Minimatch = Minimatch;
exports.minimatch.escape = escape_js_1.escape;
exports.minimatch.unescape = unescape_js_1.unescape;
)JS2C1b732aee");static StaticExternalOneByteResource internal_deps_minimatch_index_resource(internal_deps_minimatch_index_raw, 56535, nullptr);

static const uint8_t *internal_deps_undici_undici_raw = reinterpret_cast<const uint8_t*>("\042use strict\042;\012var __defProp = Object.defineProperty;\012var __getOwnPropNames = Object.getOwnPropertyNames;\012var __name = (target, value) => __defProp(target, \042name\042, { value, configurable: true });\012var __commonJS = (cb, mod) => function __require() {\012  return mod || (0, cb[__getOwnPropNames(cb)[0]])((mod = { exports: {} }).exports, mod), mod.exports;\012};\012\012// lib/core/errors.js\012var require_errors = __commonJS({\012  \042lib/core/errors.js\042(exports2, module2) {\012    \042use strict\042;\012    var UndiciError = class extends Error {\012      static {\012        __name(this, \042UndiciError\042);\012      }\012      constructor(message) {\012        super(message);\012        this.name = \042UndiciError\042;\012        this.code = \042UND_ERR\042;\012      }\012    };\012    var ConnectTimeoutError = class extends UndiciError {\012      static {\012        __name(this, \042ConnectTimeoutError\042);\012      }\012      constructor(message) {\012        super(message);\012        this.name = \042ConnectTimeoutError\042;\012        this.message = message || \042Connect Timeout Error\042;\012        this.code = \042UND_ERR_CONNECT_TIMEOUT\042;\012      }\012    };\012    var HeadersTimeoutError = class extends UndiciError {\012      static {\012        __name(this, \042HeadersTimeoutError\042);\012      }\012      constructor(message) {\012        super(message);\012        this.name = \042HeadersTimeoutError\042;\012        this.message = message || \042Headers Timeout Error\042;\012        this.code = \042UND_ERR_HEADERS_TIMEOUT\042;\012      }\012    };\012    var HeadersOverflowError = class extends UndiciError {\012      static {\012        __name(this, \042HeadersOverflowError\042);\012      }\012      constructor(message) {\012        super(message);\012        this.name = \042HeadersOverflowError\042;\012        this.message = message || \042Headers Overflow Error\042;\012        this.code = \042UND_ERR_HEADERS_OVERFLOW\042;\012      }\012    };\012    var BodyTimeoutError = class extends UndiciError {\012      static {\012        __name(this, \042BodyTimeoutError\042);\012      }\012      constructor(message) {\012        super(message);\012        this.name = \042BodyTimeoutError\042;\012        this.message = message || \042Body Timeout Error\042;\012        this.code = \042UND_ERR_BODY_TIMEOUT\042;\012      }\012    };\012    var ResponseStatusCodeError = class extends UndiciError {\012      static {\012        __name(this, \042ResponseStatusCodeError\042);\012      }\012      constructor(message, statusCode, headers, body) {\012        super(message);\012        this.name = \042ResponseStatusCodeError\042;\012        this.message = message || \042Response Status Code Error\042;\012        this.code = \042UND_ERR_RESPONSE_STATUS_CODE\042;\012        this.body = body;\012        this.status = statusCode;\012        this.statusCode = statusCode;\012        this.headers = headers;\012      }\012    };\012    var InvalidArgumentError = class extends UndiciError {\012      static {\012        __name(this, \042InvalidArgumentError\042);\012      }\012      constructor(message) {\012        super(message);\012        this.name = \042InvalidArgumentError\042;\012        this.message = message || \042Invalid Argument Error\042;\012        this.code = \042UND_ERR_INVALID_ARG\042;\012      }\012    };\012    var InvalidReturnValueError = class extends UndiciError {\012      static {\012        __name(this, \042InvalidReturnValueError\042);\012      }\012      constructor(message) {\012        super(message);\012        this.name = \042InvalidReturnValueError\042;\012        this.message = message || \042Invalid Return Value Error\042;\012        this.code = \042UND_ERR_INVALID_RETURN_VALUE\042;\012      }\012    };\012    var AbortError = class extends UndiciError {\012      static {\012        __name(this, \042AbortError\042);\012      }\012      constructor(message) {\012        super(message);\012        this.name = \042AbortError\042;\012        this.message = message || \042The operation was aborted\042;\012      }\012    };\012    var RequestAbortedError = class extends AbortError {\012      static {\012        __name(this, \042RequestAbortedError\042);\012      }\012      constructor(message) {\012        super(message);\012        this.name = \042AbortError\042;\012        this.message = message || \042Request aborted\042;\012        this.code = \042UND_ERR_ABORTED\042;\012      }\012    };\012    var InformationalError = class extends UndiciError {\012      static {\012        __name(this, \042InformationalError\042);\012      }\012      constructor(message) {\012        super(message);\012        this.name = \042InformationalError\042;\012        this.message = message || \042Request information\042;\012        this.code = \042UND_ERR_INFO\042;\012      }\012    };\012    var RequestContentLengthMismatchError = class extends UndiciError {\012      static {\012        __name(this, \042RequestContentLengthMismatchError\042);\012      }\012      constructor(message) {\012        super(message);\012        this.name = \042RequestContentLengthMismatchError\042;\012        this.message = message || \042Request body length does not match content-length header\042;\012        this.code = \042UND_ERR_REQ_CONTENT_LENGTH_MISMATCH\042;\012      }\012    };\012    var ResponseContentLengthMismatchError = class extends UndiciError {\012      static {\012        __name(this, \042ResponseContentLengthMismatchError\042);\012      }\012      constructor(message) {\012        super(message);\012        this.name = \042ResponseContentLengthMismatchError\042;\012        this.message = message || \042Response body length does not match content-length header\042;\012        this.code = \042UND_ERR_RES_CONTENT_LENGTH_MISMATCH\042;\012      }\012    };\012    var ClientDestroyedError = class extends UndiciError {\012      static {\012        __name(this, \042ClientDestroyedError\042);\012      }\012      constructor(message) {\012        super(message);\012        this.name = \042ClientDestroyedError\042;\012        this.message = message || \042The client is destroyed\042;\012        this.code = \042UND_ERR_DESTROYED\042;\012      }\012    };\012    var ClientClosedError = class extends UndiciError {\012      static {\012        __name(this, \042ClientClosedError\042);\012      }\012      constructor(message) {\012        super(message);\012        this.name = \042ClientClosedError\042;\012        this.message = message || \042The client is closed\042;\012        this.code = \042UND_ERR_CLOSED\042;\012      }\012    };\012    var SocketError = class extends UndiciError {\012      static {\012        __name(this, \042SocketError\042);\012      }\012      constructor(message, socket) {\012        super(message);\012        this.name = \042SocketError\042;\012        this.message = message || \042Socket error\042;\012        this.code = \042UND_ERR_SOCKET\042;\012        this.socket = socket;\012      }\012    };\012    var NotSupportedError = class extends UndiciError {\012      static {\012        __name(this, \042NotSupportedError\042);\012      }\012      constructor(message) {\012        super(message);\012        this.name = \042NotSupportedError\042;\012        this.message = message || \042Not supported error\042;\012        this.code = \042UND_ERR_NOT_SUPPORTED\042;\012      }\012    };\012    var BalancedPoolMissingUpstreamError = class extends UndiciError {\012      static {\012        __name(this, \042BalancedPoolMissingUpstreamError\042);\012      }\012      constructor(message) {\012        super(message);\012        this.name = \042MissingUpstreamError\042;\012        this.message = message || \042No upstream has been added to the BalancedPool\042;\012        this.code = \042UND_ERR_BPL_MISSING_UPSTREAM\042;\012      }\012    };\012    var HTTPParserError = class extends Error {\012      static {\012        __name(this, \042HTTPParserError\042);\012      }\012      constructor(message, code, data) {\012        super(message);\012        this.name = \042HTTPParserError\042;\012        this.code = code \077 `HPE_${code}` : void 0;\012        this.data = data \077 data.toString() : void 0;\012      }\012    };\012    var ResponseExceededMaxSizeError = class extends UndiciError {\012      static {\012        __name(this, \042ResponseExceededMaxSizeError\042);\012      }\012      constructor(message) {\012        super(message);\012        this.name = \042ResponseExceededMaxSizeError\042;\012        this.message = message || \042Response content exceeded max size\042;\012        this.code = \042UND_ERR_RES_EXCEEDED_MAX_SIZE\042;\012      }\012    };\012    var RequestRetryError = class extends UndiciError {\012      static {\012        __name(this, \042RequestRetryError\042);\012      }\012      constructor(message, code, { headers, data }) {\012        super(message);\012        this.name = \042RequestRetryError\042;\012        this.message = message || \042Request retry error\042;\012        this.code = \042UND_ERR_REQ_RETRY\042;\012        this.statusCode = code;\012        this.data = data;\012        this.headers = headers;\012      }\012    };\012    var ResponseError = class extends UndiciError {\012      static {\012        __name(this, \042ResponseError\042);\012      }\012      constructor(message, code, { headers, data }) {\012        super(message);\012        this.name = \042ResponseError\042;\012        this.message = message || \042Response error\042;\012        this.code = \042UND_ERR_RESPONSE\042;\012        this.statusCode = code;\012        this.data = data;\012        this.headers = headers;\012      }\012    };\012    var SecureProxyConnectionError = class extends UndiciError {\012      static {\012        __name(this, \042SecureProxyConnectionError\042);\012      }\012      constructor(cause, message, options) {\012        super(message, { cause, ...options \077\077 {} });\012        this.name = \042SecureProxyConnectionError\042;\012        this.message = message || \042Secure Proxy Connection failed\042;\012        this.code = \042UND_ERR_PRX_TLS\042;\012        this.cause = cause;\012      }\012    };\012    module2.exports = {\012      AbortError,\012      HTTPParserError,\012      UndiciError,\012      HeadersTimeoutError,\012      HeadersOverflowError,\012      BodyTimeoutError,\012      RequestContentLengthMismatchError,\012      ConnectTimeoutError,\012      ResponseStatusCodeError,\012      InvalidArgumentError,\012      InvalidReturnValueError,\012      RequestAbortedError,\012      ClientDestroyedError,\012      ClientClosedError,\012      InformationalError,\012      SocketError,\012      NotSupportedError,\012      ResponseContentLengthMismatchError,\012      BalancedPoolMissingUpstreamError,\012      ResponseExceededMaxSizeError,\012      RequestRetryError,\012      ResponseError,\012      SecureProxyConnectionError\012    };\012  }\012});\012\012// lib/core/symbols.js\012var require_symbols = __commonJS({\012  \042lib/core/symbols.js\042(exports2, module2) {\012    module2.exports = {\012      kClose: Symbol(\042close\042),\012      kDestroy: Symbol(\042destroy\042),\012      kDispatch: Symbol(\042dispatch\042),\012      kUrl: Symbol(\042url\042),\012      kWriting: Symbol(\042writing\042),\012      kResuming: Symbol(\042resuming\042),\012      kQueue: Symbol(\042queue\042),\012      kConnect: Symbol(\042connect\042),\012      kConnecting: Symbol(\042connecting\042),\012      kKeepAliveDefaultTimeout: Symbol(\042default keep alive timeout\042),\012      kKeepAliveMaxTimeout: Symbol(\042max keep alive timeout\042),\012      kKeepAliveTimeoutThreshold: Symbol(\042keep alive timeout threshold\042),\012      kKeepAliveTimeoutValue: Symbol(\042keep alive timeout\042),\012      kKeepAlive: Symbol(\042keep alive\042),\012      kHeadersTimeout: Symbol(\042headers timeout\042),\012      kBodyTimeout: Symbol(\042body timeout\042),\012      kServerName: Symbol(\042server name\042),\012      kLocalAddress: Symbol(\042local address\042),\012      kHost: Symbol(\042host\042),\012      kNoRef: Symbol(\042no ref\042),\012      kBodyUsed: Symbol(\042used\042),\012      kBody: Symbol(\042abstracted request body\042),\012      kRunning: Symbol(\042running\042),\012      kBlocking: Symbol(\042blocking\042),\012      kPending: Symbol(\042pending\042),\012      kSize: Symbol(\042size\042),\012      kBusy: Symbol(\042busy\042),\012      kQueued: Symbol(\042queued\042),\012      kFree: Symbol(\042free\042),\012      kConnected: Symbol(\042connected\042),\012      kClosed: Symbol(\042closed\042),\012      kNeedDrain: Symbol(\042need drain\042),\012      kReset: Symbol(\042reset\042),\012      kDestroyed: Symbol.for(\042nodejs.stream.destroyed\042),\012      kResume: Symbol(\042resume\042),\012      kOnError: Symbol(\042on error\042),\012      kMaxHeadersSize: Symbol(\042max headers size\042),\012      kRunningIdx: Symbol(\042running index\042),\012      kPendingIdx: Symbol(\042pending index\042),\012      kError: Symbol(\042error\042),\012      kClients: Symbol(\042clients\042),\012      kClient: Symbol(\042client\042),\012      kParser: Symbol(\042parser\042),\012      kOnDestroyed: Symbol(\042destroy callbacks\042),\012      kPipelining: Symbol(\042pipelining\042),\012      kSocket: Symbol(\042socket\042),\012      kHostHeader: Symbol(\042host header\042),\012      kConnector: Symbol(\042connector\042),\012      kStrictContentLength: Symbol(\042strict content length\042),\012      kMaxRedirections: Symbol(\042maxRedirections\042),\012      kMaxRequests: Symbol(\042maxRequestsPerClient\042),\012      kProxy: Symbol(\042proxy agent options\042),\012      kCounter: Symbol(\042socket request counter\042),\012      kInterceptors: Symbol(\042dispatch interceptors\042),\012      kMaxResponseSize: Symbol(\042max response size\042),\012      kHTTP2Session: Symbol(\042http2Session\042),\012      kHTTP2SessionState: Symbol(\042http2Session state\042),\012      kRetryHandlerDefaultRetry: Symbol(\042retry agent default retry\042),\012      kConstruct: Symbol(\042constructable\042),\012      kListeners: Symbol(\042listeners\042),\012      kHTTPContext: Symbol(\042http context\042),\012      kMaxConcurrentStreams: Symbol(\042max concurrent streams\042),\012      kNoProxyAgent: Symbol(\042no proxy agent\042),\012      kHttpProxyAgent: Symbol(\042http proxy agent\042),\012      kHttpsProxyAgent: Symbol(\042https proxy agent\042)\012    };\012  }\012});\012\012// lib/dispatcher/dispatcher.js\012var require_dispatcher = __commonJS({\012  \042lib/dispatcher/dispatcher.js\042(exports2, module2) {\012    \042use strict\042;\012    var EventEmitter = require(\042node:events\042);\012    var Dispatcher = class extends EventEmitter {\012      static {\012        __name(this, \042Dispatcher\042);\012      }\012      dispatch() {\012        throw new Error(\042not implemented\042);\012      }\012      close() {\012        throw new Error(\042not implemented\042);\012      }\012      destroy() {\012        throw new Error(\042not implemented\042);\012      }\012      compose(...args) {\012        const interceptors = Array.isArray(args[0]) \077 args[0] : args;\012        let dispatch = this.dispatch.bind(this);\012        for (const interceptor of interceptors) {\012          if (interceptor == null) {\012            continue;\012          }\012          if (typeof interceptor !== \042function\042) {\012            throw new TypeError(`invalid interceptor, expected function received ${typeof interceptor}`);\012          }\012          dispatch = interceptor(dispatch);\012          if (dispatch == null || typeof dispatch !== \042function\042 || dispatch.length !== 2) {\012            throw new TypeError(\042invalid interceptor\042);\012          }\012        }\012        return new ComposedDispatcher(this, dispatch);\012      }\012    };\012    var ComposedDispatcher = class extends Dispatcher {\012      static {\012        __name(this, \042ComposedDispatcher\042);\012      }\012      #dispatcher = null;\012      #dispatch = null;\012      constructor(dispatcher, dispatch) {\012        super();\012        this.#dispatcher = dispatcher;\012        this.#dispatch = dispatch;\012      }\012      dispatch(...args) {\012        this.#dispatch(...args);\012      }\012      close(...args) {\012        return this.#dispatcher.close(...args);\012      }\012      destroy(...args) {\012        return this.#dispatcher.destroy(...args);\012      }\012    };\012    module2.exports = Dispatcher;\012  }\012});\012\012// lib/dispatcher/dispatcher-base.js\012var require_dispatcher_base = __commonJS({\012  \042lib/dispatcher/dispatcher-base.js\042(exports2, module2) {\012    \042use strict\042;\012    var Dispatcher = require_dispatcher();\012    var {\012      ClientDestroyedError,\012      ClientClosedError,\012      InvalidArgumentError\012    } = require_errors();\012    var { kDestroy, kClose, kClosed, kDestroyed, kDispatch, kInterceptors } = require_symbols();\012    var kOnDestroyed = Symbol(\042onDestroyed\042);\012    var kOnClosed = Symbol(\042onClosed\042);\012    var kInterceptedDispatch = Symbol(\042Intercepted Dispatch\042);\012    var DispatcherBase = class extends Dispatcher {\012      static {\012        __name(this, \042DispatcherBase\042);\012      }\012      constructor() {\012        super();\012        this[kDestroyed] = false;\012        this[kOnDestroyed] = null;\012        this[kClosed] = false;\012        this[kOnClosed] = [];\012      }\012      get destroyed() {\012        return this[kDestroyed];\012      }\012      get closed() {\012        return this[kClosed];\012      }\012      get interceptors() {\012        return this[kInterceptors];\012      }\012      set interceptors(newInterceptors) {\012        if (newInterceptors) {\012          for (let i = newInterceptors.length - 1; i >= 0; i--) {\012            const interceptor = this[kInterceptors][i];\012            if (typeof interceptor !== \042function\042) {\012              throw new InvalidArgumentError(\042interceptor must be an function\042);\012            }\012          }\012        }\012        this[kInterceptors] = newInterceptors;\012      }\012      close(callback) {\012        if (callback === void 0) {\012          return new Promise((resolve, reject) => {\012            this.close((err, data) => {\012              return err \077 reject(err) : resolve(data);\012            });\012          });\012        }\012        if (typeof callback !== \042function\042) {\012          throw new InvalidArgumentError(\042invalid callback\042);\012        }\012        if (this[kDestroyed]) {\012          queueMicrotask(() => callback(new ClientDestroyedError(), null));\012          return;\012        }\012        if (this[kClosed]) {\012          if (this[kOnClosed]) {\012            this[kOnClosed].push(callback);\012          } else {\012            queueMicrotask(() => callback(null, null));\012          }\012          return;\012        }\012        this[kClosed] = true;\012        this[kOnClosed].push(callback);\012        const onClosed = /* @__PURE__ */ __name(() => {\012          const callbacks = this[kOnClosed];\012          this[kOnClosed] = null;\012          for (let i = 0; i < callbacks.length; i++) {\012            callbacks[i](null, null);\012          }\012        }, \042onClosed\042);\012        this[kClose]().then(() => this.destroy()).then(() => {\012          queueMicrotask(onClosed);\012        });\012      }\012      destroy(err, callback) {\012        if (typeof err === \042function\042) {\012          callback = err;\012          err = null;\012        }\012        if (callback === void 0) {\012          return new Promise((resolve, reject) => {\012            this.destroy(err, (err2, data) => {\012              return err2 \077 (\012                /* istanbul ignore next: should never error */\012                reject(err2)\012              ) : resolve(data);\012            });\012          });\012        }\012        if (typeof callback !== \042function\042) {\012          throw new InvalidArgumentError(\042invalid callback\042);\012        }\012        if (this[kDestroyed]) {\012          if (this[kOnDestroyed]) {\012            this[kOnDestroyed].push(callback);\012          } else {\012            queueMicrotask(() => callback(null, null));\012          }\012          return;\012        }\012        if (!err) {\012          err = new ClientDestroyedError();\012        }\012        this[kDestroyed] = true;\012        this[kOnDestroyed] = this[kOnDestroyed] || [];\012        this[kOnDestroyed].push(callback);\012        const onDestroyed = /* @__PURE__ */ __name(() => {\012          const callbacks = this[kOnDestroyed];\012          this[kOnDestroyed] = null;\012          for (let i = 0; i < callbacks.length; i++) {\012            callbacks[i](null, null);\012          }\012        }, \042onDestroyed\042);\012        this[kDestroy](err).then(() => {\012          queueMicrotask(onDestroyed);\012        });\012      }\012      [kInterceptedDispatch](opts, handler) {\012        if (!this[kInterceptors] || this[kInterceptors].length === 0) {\012          this[kInterceptedDispatch] = this[kDispatch];\012          return this[kDispatch](opts, handler);\012        }\012        let dispatch = this[kDispatch].bind(this);\012        for (let i = this[kInterceptors].length - 1; i >= 0; i--) {\012          dispatch = this[kInterceptors][i](dispatch);\012        }\012        this[kInterceptedDispatch] = dispatch;\012        return dispatch(opts, handler);\012      }\012      dispatch(opts, handler) {\012        if (!handler || typeof handler !== \042object\042) {\012          throw new InvalidArgumentError(\042handler must be an object\042);\012        }\012        try {\012          if (!opts || typeof opts !== \042object\042) {\012            throw new InvalidArgumentError(\042opts must be an object.\042);\012          }\012          if (this[kDestroyed] || this[kOnDestroyed]) {\012            throw new ClientDestroyedError();\012          }\012          if (this[kClosed]) {\012            throw new ClientClosedError();\012          }\012          return this[kInterceptedDispatch](opts, handler);\012        } catch (err) {\012          if (typeof handler.onError !== \042function\042) {\012            throw new InvalidArgumentError(\042invalid onError method\042);\012          }\012          handler.onError(err);\012          return false;\012        }\012      }\012    };\012    module2.exports = DispatcherBase;\012  }\012});\012\012// lib/dispatcher/fixed-queue.js\012var require_fixed_queue = __commonJS({\012  \042lib/dispatcher/fixed-queue.js\042(exports2, module2) {\012    \042use strict\042;\012    var kSize = 2048;\012    var kMask = kSize - 1;\012    var FixedCircularBuffer = class {\012      static {\012        __name(this, \042FixedCircularBuffer\042);\012      }\012      constructor() {\012        this.bottom = 0;\012        this.top = 0;\012        this.list = new Array(kSize);\012        this.next = null;\012      }\012      isEmpty() {\012        return this.top === this.bottom;\012      }\012      isFull() {\012        return (this.top + 1 & kMask) === this.bottom;\012      }\012      push(data) {\012        this.list[this.top] = data;\012        this.top = this.top + 1 & kMask;\012      }\012      shift() {\012        const nextItem = this.list[this.bottom];\012        if (nextItem === void 0)\012          return null;\012        this.list[this.bottom] = void 0;\012        this.bottom = this.bottom + 1 & kMask;\012        return nextItem;\012      }\012    };\012    module2.exports = class FixedQueue {\012      static {\012        __name(this, \042FixedQueue\042);\012      }\012      constructor() {\012        this.head = this.tail = new FixedCircularBuffer();\012      }\012      isEmpty() {\012        return this.head.isEmpty();\012      }\012      push(data) {\012        if (this.head.isFull()) {\012          this.head = this.head.next = new FixedCircularBuffer();\012        }\012        this.head.push(data);\012      }\012      shift() {\012        const tail = this.tail;\012        const next = tail.shift();\012        if (tail.isEmpty() && tail.next !== null) {\012          this.tail = tail.next;\012        }\012        return next;\012      }\012    };\012  }\012});\012\012// lib/dispatcher/pool-stats.js\012var require_pool_stats = __commonJS({\012  \042lib/dispatcher/pool-stats.js\042(exports2, module2) {\012    var { kFree, kConnected, kPending, kQueued, kRunning, kSize } = require_symbols();\012    var kPool = Symbol(\042pool\042);\012    var PoolStats = class {\012      static {\012        __name(this, \042PoolStats\042);\012      }\012      constructor(pool) {\012        this[kPool] = pool;\012      }\012      get connected() {\012        return this[kPool][kConnected];\012      }\012      get free() {\012        return this[kPool][kFree];\012      }\012      get pending() {\012        return this[kPool][kPending];\012      }\012      get queued() {\012        return this[kPool][kQueued];\012      }\012      get running() {\012        return this[kPool][kRunning];\012      }\012      get size() {\012        return this[kPool][kSize];\012      }\012    };\012    module2.exports = PoolStats;\012  }\012});\012\012// lib/dispatcher/pool-base.js\012var require_pool_base = __commonJS({\012  \042lib/dispatcher/pool-base.js\042(exports2, module2) {\012    \042use strict\042;\012    var DispatcherBase = require_dispatcher_base();\012    var FixedQueue = require_fixed_queue();\012    var { kConnected, kSize, kRunning, kPending, kQueued, kBusy, kFree, kUrl, kClose, kDestroy, kDispatch } = require_symbols();\012    var PoolStats = require_pool_stats();\012    var kClients = Symbol(\042clients\042);\012    var kNeedDrain = Symbol(\042needDrain\042);\012    var kQueue = Symbol(\042queue\042);\012    var kClosedResolve = Symbol(\042closed resolve\042);\012    var kOnDrain = Symbol(\042onDrain\042);\012    var kOnConnect = Symbol(\042onConnect\042);\012    var kOnDisconnect = Symbol(\042onDisconnect\042);\012    var kOnConnectionError = Symbol(\042onConnectionError\042);\012    var kGetDispatcher = Symbol(\042get dispatcher\042);\012    var kAddClient = Symbol(\042add client\042);\012    var kRemoveClient = Symbol(\042remove client\042);\012    var kStats = Symbol(\042stats\042);\012    var PoolBase = class extends DispatcherBase {\012      static {\012        __name(this, \042PoolBase\042);\012      }\012      constructor() {\012        super();\012        this[kQueue] = new FixedQueue();\012        this[kClients] = [];\012        this[kQueued] = 0;\012        const pool = this;\012        this[kOnDrain] = /* @__PURE__ */ __name(function onDrain(origin, targets) {\012          const queue = pool[kQueue];\012          let needDrain = false;\012          while (!needDrain) {\012            const item = queue.shift();\012            if (!item) {\012              break;\012            }\012            pool[kQueued]--;\012            needDrain = !this.dispatch(item.opts, item.handler);\012          }\012          this[kNeedDrain] = needDrain;\012          if (!this[kNeedDrain] && pool[kNeedDrain]) {\012            pool[kNeedDrain] = false;\012            pool.emit(\042drain\042, origin, [pool, ...targets]);\012          }\012          if (pool[kClosedResolve] && queue.isEmpty()) {\012            Promise.all(pool[kClients].map((c) => c.close())).then(pool[kClosedResolve]);\012          }\012        }, \042onDrain\042);\012        this[kOnConnect] = (origin, targets) => {\012          pool.emit(\042connect\042, origin, [pool, ...targets]);\012        };\012        this[kOnDisconnect] = (origin, targets, err) => {\012          pool.emit(\042disconnect\042, origin, [pool, ...targets], err);\012        };\012        this[kOnConnectionError] = (origin, targets, err) => {\012          pool.emit(\042connectionError\042, origin, [pool, ...targets], err);\012        };\012        this[kStats] = new PoolStats(this);\012      }\012      get [kBusy]() {\012        return this[kNeedDrain];\012      }\012      get [kConnected]() {\012        return this[kClients].filter((client) => client[kConnected]).length;\012      }\012      get [kFree]() {\012        return this[kClients].filter((client) => client[kConnected] && !client[kNeedDrain]).length;\012      }\012      get [kPending]() {\012        let ret = this[kQueued];\012        for (const { [kPending]: pending } of this[kClients]) {\012          ret += pending;\012        }\012        return ret;\012      }\012      get [kRunning]() {\012        let ret = 0;\012        for (const { [kRunning]: running } of this[kClients]) {\012          ret += running;\012        }\012        return ret;\012      }\012      get [kSize]() {\012        let ret = this[kQueued];\012        for (const { [kSize]: size } of this[kClients]) {\012          ret += size;\012        }\012        return ret;\012      }\012      get stats() {\012        return this[kStats];\012      }\012      async [kClose]() {\012        if (this[kQueue].isEmpty()) {\012          await Promise.all(this[kClients].map((c) => c.close()));\012        } else {\012          await new Promise((resolve) => {\012            this[kClosedResolve] = resolve;\012          });\012        }\012      }\012      async [kDestroy](err) {\012        while (true) {\012          const item = this[kQueue].shift();\012          if (!item) {\012            break;\012          }\012          item.handler.onError(err);\012        }\012        await Promise.all(this[kClients].map((c) => c.destroy(err)));\012      }\012      [kDispatch](opts, handler) {\012        const dispatcher = this[kGetDispatcher]();\012        if (!dispatcher) {\012          this[kNeedDrain] = true;\012          this[kQueue].push({ opts, handler });\012          this[kQueued]++;\012        } else if (!dispatcher.dispatch(opts, handler)) {\012          dispatcher[kNeedDrain] = true;\012          this[kNeedDrain] = !this[kGetDispatcher]();\012        }\012        return !this[kNeedDrain];\012      }\012      [kAddClient](client) {\012        client.on(\042drain\042, this[kOnDrain]).on(\042connect\042, this[kOnConnect]).on(\042disconnect\042, this[kOnDisconnect]).on(\042connectionError\042, this[kOnConnectionError]);\012        this[kClients].push(client);\012        if (this[kNeedDrain]) {\012          queueMicrotask(() => {\012            if (this[kNeedDrain]) {\012              this[kOnDrain](client[kUrl], [this, client]);\012            }\012          });\012        }\012        return this;\012      }\012      [kRemoveClient](client) {\012        client.close(() => {\012          const idx = this[kClients].indexOf(client);\012          if (idx !== -1) {\012            this[kClients].splice(idx, 1);\012          }\012        });\012        this[kNeedDrain] = this[kClients].some((dispatcher) => !dispatcher[kNeedDrain] && dispatcher.closed !== true && dispatcher.destroyed !== true);\012      }\012    };\012    module2.exports = {\012      PoolBase,\012      kClients,\012      kNeedDrain,\012      kAddClient,\012      kRemoveClient,\012      kGetDispatcher\012    };\012  }\012});\012\012// lib/core/constants.js\012var require_constants = __commonJS({\012  \042lib/core/constants.js\042(exports2, module2) {\012    \042use strict\042;\012    var headerNameLowerCasedRecord = {};\012    var wellknownHeaderNames = [\012      \042Accept\042,\012      \042Accept-Encoding\042,\012      \042Accept-Language\042,\012      \042Accept-Ranges\042,\012      \042Access-Control-Allow-Credentials\042,\012      \042Access-Control-Allow-Headers\042,\012      \042Access-Control-Allow-Methods\042,\012      \042Access-Control-Allow-Origin\042,\012      \042Access-Control-Expose-Headers\042,\012      \042Access-Control-Max-Age\042,\012      \042Access-Control-Request-Headers\042,\012      \042Access-Control-Request-Method\042,\012      \042Age\042,\012      \042Allow\042,\012      \042Alt-Svc\042,\012      \042Alt-Used\042,\012      \042Authorization\042,\012      \042Cache-Control\042,\012      \042Clear-Site-Data\042,\012      \042Connection\042,\012      \042Content-Disposition\042,\012      \042Content-Encoding\042,\012      \042Content-Language\042,\012      \042Content-Length\042,\012      \042Content-Location\042,\012      \042Content-Range\042,\012      \042Content-Security-Policy\042,\012      \042Content-Security-Policy-Report-Only\042,\012      \042Content-Type\042,\012      \042Cookie\042,\012      \042Cross-Origin-Embedder-Policy\042,\012      \042Cross-Origin-Opener-Policy\042,\012      \042Cross-Origin-Resource-Policy\042,\012      \042Date\042,\012      \042Device-Memory\042,\012      \042Downlink\042,\012      \042ECT\042,\012      \042ETag\042,\012      \042Expect\042,\012      \042Expect-CT\042,\012      \042Expires\042,\012      \042Forwarded\042,\012      \042From\042,\012      \042Host\042,\012      \042If-Match\042,\012      \042If-Modified-Since\042,\012      \042If-None-Match\042,\012      \042If-Range\042,\012      \042If-Unmodified-Since\042,\012      \042Keep-Alive\042,\012      \042Last-Modified\042,\012      \042Link\042,\012      \042Location\042,\012      \042Max-Forwards\042,\012      \042Origin\042,\012      \042Permissions-Policy\042,\012      \042Pragma\042,\012      \042Proxy-Authenticate\042,\012      \042Proxy-Authorization\042,\012      \042RTT\042,\012      \042Range\042,\012      \042Referer\042,\012      \042Referrer-Policy\042,\012      \042Refresh\042,\012      \042Retry-After\042,\012      \042Sec-WebSocket-Accept\042,\012      \042Sec-WebSocket-Extensions\042,\012      \042Sec-WebSocket-Key\042,\012      \042Sec-WebSocket-Protocol\042,\012      \042Sec-WebSocket-Version\042,\012      \042Server\042,\012      \042Server-Timing\042,\012      \042Service-Worker-Allowed\042,\012      \042Service-Worker-Navigation-Preload\042,\012      \042Set-Cookie\042,\012      \042SourceMap\042,\012      \042Strict-Transport-Security\042,\012      \042Supports-Loading-Mode\042,\012      \042TE\042,\012      \042Timing-Allow-Origin\042,\012      \042Trailer\042,\012      \042Transfer-Encoding\042,\012      \042Upgrade\042,\012      \042Upgrade-Insecure-Requests\042,\012      \042User-Agent\042,\012      \042Vary\042,\012      \042Via\042,\012      \042WWW-Authenticate\042,\012      \042X-Content-Type-Options\042,\012      \042X-DNS-Prefetch-Control\042,\012      \042X-Frame-Options\042,\012      \042X-Permitted-Cross-Domain-Policies\042,\012      \042X-Powered-By\042,\012      \042X-Requested-With\042,\012      \042X-XSS-Protection\042\012    ];\012    for (let i = 0; i < wellknownHeaderNames.length; ++i) {\012      const key = wellknownHeaderNames[i];\012      const lowerCasedKey = key.toLowerCase();\012      headerNameLowerCasedRecord[key] = headerNameLowerCasedRecord[lowerCasedKey] = lowerCasedKey;\012    }\012    Object.setPrototypeOf(headerNameLowerCasedRecord, null);\012    module2.exports = {\012      wellknownHeaderNames,\012      headerNameLowerCasedRecord\012    };\012  }\012});\012\012// lib/core/tree.js\012var require_tree = __commonJS({\012  \042lib/core/tree.js\042(exports2, module2) {\012    \042use strict\042;\012    var {\012      wellknownHeaderNames,\012      headerNameLowerCasedRecord\012    } = require_constants();\012    var TstNode = class _TstNode {\012      static {\012        __name(this, \042TstNode\042);\012      }\012      /** @type {any} */\012      value = null;\012      /** @type {null | TstNode} */\012      left = null;\012      /** @type {null | TstNode} */\012      middle = null;\012      /** @type {null | TstNode} */\012      right = null;\012      /** @type {number} */\012      code;\012      /**\012       * @param {string} key\012       * @param {any} value\012       * @param {number} index\012       */\012      constructor(key, value, index) {\012        if (index === void 0 || index >= key.length) {\012          throw new TypeError(\042Unreachable\042);\012        }\012        const code = this.code = key.charCodeAt(index);\012        if (code > 127) {\012          throw new TypeError(\042key must be ascii string\042);\012        }\012        if (key.length !== ++index) {\012          this.middle = new _TstNode(key, value, index);\012        } else {\012          this.value = value;\012        }\012      }\012      /**\012       * @param {string} key\012       * @param {any} value\012       */\012      add(key, value) {\012        const length = key.length;\012        if (length === 0) {\012          throw new TypeError(\042Unreachable\042);\012        }\012        let index = 0;\012        let node = this;\012        while (true) {\012          const code = key.charCodeAt(index);\012          if (code > 127) {\012            throw new TypeError(\042key must be ascii string\042);\012          }\012          if (node.code === code) {\012            if (length === ++index) {\012              node.value = value;\012              break;\012            } else if (node.middle !== null) {\012              node = node.middle;\012            } else {\012              node.middle = new _TstNode(key, value, index);\012              break;\012            }\012          } else if (node.code < code) {\012            if (node.left !== null) {\012              node = node.left;\012            } else {\012              node.left = new _TstNode(key, value, index);\012              break;\012            }\012          } else if (node.right !== null) {\012            node = node.right;\012          } else {\012            node.right = new _TstNode(key, value, index);\012            break;\012          }\012        }\012      }\012      /**\012       * @param {Uint8Array} key\012       * @return {TstNode | null}\012       */\012      search(key) {\012        const keylength = key.length;\012        let index = 0;\012        let node = this;\012        while (node !== null && index < keylength) {\012          let code = key[index];\012          if (code <= 90 && code >= 65) {\012            code |= 32;\012          }\012          while (node !== null) {\012            if (code === node.code) {\012              if (keylength === ++index) {\012                return node;\012              }\012              node = node.middle;\012              break;\012            }\012            node = node.code < code \077 node.left : node.right;\012          }\012        }\012        return null;\012      }\012    };\012    var TernarySearchTree = class {\012      static {\012        __name(this, \042TernarySearchTree\042);\012      }\012      /** @type {TstNode | null} */\012      node = null;\012      /**\012       * @param {string} key\012       * @param {any} value\012       * */\012      insert(key, value) {\012        if (this.node === null) {\012          this.node = new TstNode(key, value, 0);\012        } else {\012          this.node.add(key, value);\012        }\012      }\012      /**\012       * @param {Uint8Array} key\012       * @return {any}\012       */\012      lookup(key) {\012        return this.node\077.search(key)\077.value \077\077 null;\012      }\012    };\012    var tree = new TernarySearchTree();\012    for (let i = 0; i < wellknownHeaderNames.length; ++i) {\012      const key = headerNameLowerCasedRecord[wellknownHeaderNames[i]];\012      tree.insert(key, key);\012    }\012    module2.exports = {\012      TernarySearchTree,\012      tree\012    };\012  }\012});\012\012// lib/core/util.js\012var require_util = __commonJS({\012  \042lib/core/util.js\042(exports2, module2) {\012    \042use strict\042;\012    var assert = require(\042node:assert\042);\012    var { kDestroyed, kBodyUsed, kListeners, kBody } = require_symbols();\012    var { IncomingMessage } = require(\042node:http\042);\012    var stream = require(\042node:stream\042);\012    var net = require(\042node:net\042);\012    var { Blob: Blob2 } = require(\042node:buffer\042);\012    var nodeUtil = require(\042node:util\042);\012    var { stringify } = require(\042node:querystring\042);\012    var { EventEmitter: EE } = require(\042node:events\042);\012    var { InvalidArgumentError } = require_errors();\012    var { headerNameLowerCasedRecord } = require_constants();\012    var { tree } = require_tree();\012    var [nodeMajor, nodeMinor] = process.versions.node.split(\042.\042).map((v) => Number(v));\012    var BodyAsyncIterable = class {\012      static {\012        __name(this, \042BodyAsyncIterable\042);\012      }\012      constructor(body) {\012        this[kBody] = body;\012        this[kBodyUsed] = false;\012      }\012      async *[Symbol.asyncIterator]() {\012        assert(!this[kBodyUsed], \042disturbed\042);\012        this[kBodyUsed] = true;\012        yield* this[kBody];\012      }\012    };\012    function wrapRequestBody(body) {\012      if (isStream(body)) {\012        if (bodyLength(body) === 0) {\012          body.on(\042data\042, function() {\012            assert(false);\012          });\012        }\012        if (typeof body.readableDidRead !== \042boolean\042) {\012          body[kBodyUsed] = false;\012          EE.prototype.on.call(body, \042data\042, function() {\012            this[kBodyUsed] = true;\012          });\012        }\012        return body;\012      } else if (body && typeof body.pipeTo === \042function\042) {\012        return new BodyAsyncIterable(body);\012      } else if (body && typeof body !== \042string\042 && !ArrayBuffer.isView(body) && isIterable(body)) {\012        return new BodyAsyncIterable(body);\012      } else {\012        return body;\012      }\012    }\012    __name(wrapRequestBody, \042wrapRequestBody\042);\012    function nop() {\012    }\012    __name(nop, \042nop\042);\012    function isStream(obj) {\012      return obj && typeof obj === \042object\042 && typeof obj.pipe === \042function\042 && typeof obj.on === \042function\042;\012    }\012    __name(isStream, \042isStream\042);\012    function isBlobLike(object) {\012      if (object === null) {\012        return false;\012      } else if (object instanceof Blob2) {\012        return true;\012      } else if (typeof object !== \042object\042) {\012        return false;\012      } else {\012        const sTag = object[Symbol.toStringTag];\012        return (sTag === \042Blob\042 || sTag === \042File\042) && (\042stream\042 in object && typeof object.stream === \042function\042 || \042arrayBuffer\042 in object && typeof object.arrayBuffer === \042function\042);\012      }\012    }\012    __name(isBlobLike, \042isBlobLike\042);\012    function buildURL(url, queryParams) {\012      if (url.includes(\042\077\042) || url.includes(\042#\042)) {\012        throw new Error('Query params cannot be passed when url already contains \042\077\042 or \042#\042.');\012      }\012      const stringified = stringify(queryParams);\012      if (stringified) {\012        url += \042\077\042 + stringified;\012      }\012      return url;\012    }\012    __name(buildURL, \042buildURL\042);\012    function isValidPort(port) {\012      const value = parseInt(port, 10);\012      return value === Number(port) && value >= 0 && value <= 65535;\012    }\012    __name(isValidPort, \042isValidPort\042);\012    function isHttpOrHttpsPrefixed(value) {\012      return value != null && value[0] === \042h\042 && value[1] === \042t\042 && value[2] === \042t\042 && value[3] === \042p\042 && (value[4] === \042:\042 || value[4] === \042s\042 && value[5] === \042:\042);\012    }\012    __name(isHttpOrHttpsPrefixed, \042isHttpOrHttpsPrefixed\042);\012    function parseURL(url) {\012      if (typeof url === \042string\042) {\012        url = new URL(url);\012        if (!isHttpOrHttpsPrefixed(url.origin || url.protocol)) {\012          throw new InvalidArgumentError(\042Invalid URL protocol: the URL must start with `http:` or `https:`.\042);\012        }\012        return url;\012      }\012      if (!url || typeof url !== \042object\042) {\012        throw new InvalidArgumentError(\042Invalid URL: The URL argument must be a non-null object.\042);\012      }\012      if (!(url instanceof URL)) {\012        if (url.port != null && url.port !== \042\042 && isValidPort(url.port) === false) {\012          throw new InvalidArgumentError(\042Invalid URL: port must be a valid integer or a string representation of an integer.\042);\012        }\012        if (url.path != null && typeof url.path !== \042string\042) {\012          throw new InvalidArgumentError(\042Invalid URL path: the path must be a string or null/undefined.\042);\012        }\012        if (url.pathname != null && typeof url.pathname !== \042string\042) {\012          throw new InvalidArgumentError(\042Invalid URL pathname: the pathname must be a string or null/undefined.\042);\012        }\012        if (url.hostname != null && typeof url.hostname !== \042string\042) {\012          throw new InvalidArgumentError(\042Invalid URL hostname: the hostname must be a string or null/undefined.\042);\012        }\012        if (url.origin != null && typeof url.origin !== \042string\042) {\012          throw new InvalidArgumentError(\042Invalid URL origin: the origin must be a string or null/undefined.\042);\012        }\012        if (!isHttpOrHttpsPrefixed(url.origin || url.protocol)) {\012          throw new InvalidArgumentError(\042Invalid URL protocol: the URL must start with `http:` or `https:`.\042);\012        }\012        const port = url.port != null \077 url.port : url.protocol === \042https:\042 \077 443 : 80;\012        let origin = url.origin != null \077 url.origin : `${url.protocol || \042\042}//${url.hostname || \042\042}:${port}`;\012        let path = url.path != null \077 url.path : `${url.pathname || \042\042}${url.search || \042\042}`;\012        if (origin[origin.length - 1] === \042/\042) {\012          origin = origin.slice(0, origin.length - 1);\012        }\012        if (path && path[0] !== \042/\042) {\012          path = `/${path}`;\012        }\012        return new URL(`${origin}${path}`);\012      }\012      if (!isHttpOrHttpsPrefixed(url.origin || url.protocol)) {\012        throw new InvalidArgumentError(\042Invalid URL protocol: the URL must start with `http:` or `https:`.\042);\012      }\012      return url;\012    }\012    __name(parseURL, \042parseURL\042);\012    function parseOrigin(url) {\012      url = parseURL(url);\012      if (url.pathname !== \042/\042 || url.search || url.hash) {\012        throw new InvalidArgumentError(\042invalid url\042);\012      }\012      return url;\012    }\012    __name(parseOrigin, \042parseOrigin\042);\012    function getHostname(host) {\012      if (host[0] === \042[\042) {\012        const idx2 = host.indexOf(\042]\042);\012        assert(idx2 !== -1);\012        return host.substring(1, idx2);\012      }\012      const idx = host.indexOf(\042:\042);\012      if (idx === -1)\012        return host;\012      return host.substring(0, idx);\012    }\012    __name(getHostname, \042getHostname\042);\012    function getServerName(host) {\012      if (!host) {\012        return null;\012      }\012      assert(typeof host === \042string\042);\012      const servername = getHostname(host);\012      if (net.isIP(servername)) {\012        return \042\042;\012      }\012      return servername;\012    }\012    __name(getServerName, \042getServerName\042);\012    function deepClone(obj) {\012      return JSON.parse(JSON.stringify(obj));\012    }\012    __name(deepClone, \042deepClone\042);\012    function isAsyncIterable(obj) {\012      return !!(obj != null && typeof obj[Symbol.asyncIterator] === \042function\042);\012    }\012    __name(isAsyncIterable, \042isAsyncIterable\042);\012    function isIterable(obj) {\012      return !!(obj != null && (typeof obj[Symbol.iterator] === \042function\042 || typeof obj[Symbol.asyncIterator] === \042function\042));\012    }\012    __name(isIterable, \042isIterable\042);\012    function bodyLength(body) {\012      if (body == null) {\012        return 0;\012      } else if (isStream(body)) {\012        const state = body._readableState;\012        return state && state.objectMode === false && state.ended === true && Number.isFinite(state.length) \077 state.length : null;\012      } else if (isBlobLike(body)) {\012        return body.size != null \077 body.size : null;\012      } else if (isBuffer(body)) {\012        return body.byteLength;\012      }\012      return null;\012    }\012    __name(bodyLength, \042bodyLength\042);\012    function isDestroyed(body) {\012      return body && !!(body.destroyed || body[kDestroyed] || stream.isDestroyed\077.(body));\012    }\012    __name(isDestroyed, \042isDestroyed\042);\012    function destroy(stream2, err) {\012      if (stream2 == null || !isStream(stream2) || isDestroyed(stream2)) {\012        return;\012      }\012      if (typeof stream2.destroy === \042function\042) {\012        if (Object.getPrototypeOf(stream2).constructor === IncomingMessage) {\012          stream2.socket = null;\012        }\012        stream2.destroy(err);\012      } else if (err) {\012        queueMicrotask(() => {\012          stream2.emit(\042error\042, err);\012        });\012      }\012      if (stream2.destroyed !== true) {\012        stream2[kDestroyed] = true;\012      }\012    }\012    __name(destroy, \042destroy\042);\012    var KEEPALIVE_TIMEOUT_EXPR = /timeout=(\134d+)/;\012    function parseKeepAliveTimeout(val) {\012      const m = val.toString().match(KEEPALIVE_TIMEOUT_EXPR);\012      return m \077 parseInt(m[1], 10) * 1e3 : null;\012    }\012    __name(parseKeepAliveTimeout, \042parseKeepAliveTimeout\042);\012    function headerNameToString(value) {\012      return typeof value === \042string\042 \077 headerNameLowerCasedRecord[value] \077\077 value.toLowerCase() : tree.lookup(value) \077\077 value.toString(\042latin1\042).toLowerCase();\012    }\012    __name(headerNameToString, \042headerNameToString\042);\012    function bufferToLowerCasedHeaderName(value) {\012      return tree.lookup(value) \077\077 value.toString(\042latin1\042).toLowerCase();\012    }\012    __name(bufferToLowerCasedHeaderName, \042bufferToLowerCasedHeaderName\042);\012    function parseHeaders(headers, obj) {\012      if (obj === void 0)\012        obj = {};\012      for (let i = 0; i < headers.length; i += 2) {\012        const key = headerNameToString(headers[i]);\012        let val = obj[key];\012        if (val) {\012          if (typeof val === \042string\042) {\012            val = [val];\012            obj[key] = val;\012          }\012          val.push(headers[i + 1].toString(\042utf8\042));\012        } else {\012          const headersValue = headers[i + 1];\012          if (typeof headersValue === \042string\042) {\012            obj[key] = headersValue;\012          } else {\012            obj[key] = Array.isArray(headersValue) \077 headersValue.map((x) => x.toString(\042utf8\042)) : headersValue.toString(\042utf8\042);\012          }\012        }\012      }\012      if (\042content-length\042 in obj && \042content-disposition\042 in obj) {\012        obj[\042content-disposition\042] = Buffer.from(obj[\042content-disposition\042]).toString(\042latin1\042);\012      }\012      return obj;\012    }\012    __name(parseHeaders, \042parseHeaders\042);\012    function parseRawHeaders(headers) {\012      const len = headers.length;\012      const ret = new Array(len);\012      let hasContentLength = false;\012      let contentDispositionIdx = -1;\012      let key;\012      let val;\012      let kLen = 0;\012      for (let n = 0; n < headers.length; n += 2) {\012        key = headers[n];\012        val = headers[n + 1];\012        typeof key !== \042string\042 && (key = key.toString());\012        typeof val !== \042string\042 && (val = val.toString(\042utf8\042));\012        kLen = key.length;\012        if (kLen === 14 && key[7] === \042-\042 && (key === \042content-length\042 || key.toLowerCase() === \042content-length\042)) {\012          hasContentLength = true;\012        } else if (kLen === 19 && key[7] === \042-\042 && (key === \042content-disposition\042 || key.toLowerCase() === \042content-disposition\042)) {\012          contentDispositionIdx = n + 1;\012        }\012        ret[n] = key;\012        ret[n + 1] = val;\012      }\012      if (hasContentLength && contentDispositionIdx !== -1) {\012        ret[contentDispositionIdx] = Buffer.from(ret[contentDispositionIdx]).toString(\042latin1\042);\012      }\012      return ret;\012    }\012    __name(parseRawHeaders, \042parseRawHeaders\042);\012    function isBuffer(buffer) {\012      return buffer instanceof Uint8Array || Buffer.isBuffer(buffer);\012    }\012    __name(isBuffer, \042isBuffer\042);\012    function validateHandler(handler, method, upgrade) {\012      if (!handler || typeof handler !== \042object\042) {\012        throw new InvalidArgumentError(\042handler must be an object\042);\012      }\012      if (typeof handler.onConnect !== \042function\042) {\012        throw new InvalidArgumentError(\042invalid onConnect method\042);\012      }\012      if (typeof handler.onError !== \042function\042) {\012        throw new InvalidArgumentError(\042invalid onError method\042);\012      }\012      if (typeof handler.onBodySent !== \042function\042 && handler.onBodySent !== void 0) {\012        throw new InvalidArgumentError(\042invalid onBodySent method\042);\012      }\012      if (upgrade || method === \042CONNECT\042) {\012        if (typeof handler.onUpgrade !== \042function\042) {\012          throw new InvalidArgumentError(\042invalid onUpgrade method\042);\012        }\012      } else {\012        if (typeof handler.onHeaders !== \042function\042) {\012          throw new InvalidArgumentError(\042invalid onHeaders method\042);\012        }\012        if (typeof handler.onData !== \042function\042) {\012          throw new InvalidArgumentError(\042invalid onData method\042);\012        }\012        if (typeof handler.onComplete !== \042function\042) {\012          throw new InvalidArgumentError(\042invalid onComplete method\042);\012        }\012      }\012    }\012    __name(validateHandler, \042validateHandler\042);\012    function isDisturbed(body) {\012      return !!(body && (stream.isDisturbed(body) || body[kBodyUsed]));\012    }\012    __name(isDisturbed, \042isDisturbed\042);\012    function isErrored(body) {\012      return !!(body && stream.isErrored(body));\012    }\012    __name(isErrored, \042isErrored\042);\012    function isReadable(body) {\012      return !!(body && stream.isReadable(body));\012    }\012    __name(isReadable, \042isReadable\042);\012    function getSocketInfo(socket) {\012      return {\012        localAddress: socket.localAddress,\012        localPort: socket.localPort,\012        remoteAddress: socket.remoteAddress,\012        remotePort: socket.remotePort,\012        remoteFamily: socket.remoteFamily,\012        timeout: socket.timeout,\012        bytesWritten: socket.bytesWritten,\012        bytesRead: socket.bytesRead\012      };\012    }\012    __name(getSocketInfo, \042getSocketInfo\042);\012    function ReadableStreamFrom(iterable) {\012      let iterator;\012      return new ReadableStream(\012        {\012          async start() {\012            iterator = iterable[Symbol.asyncIterator]();\012          },\012          async pull(controller) {\012            const { done, value } = await iterator.next();\012            if (done) {\012              queueMicrotask(() => {\012                controller.close();\012                controller.byobRequest\077.respond(0);\012              });\012            } else {\012              const buf = Buffer.isBuffer(value) \077 value : Buffer.from(value);\012              if (buf.byteLength) {\012                controller.enqueue(new Uint8Array(buf));\012              }\012            }\012            return controller.desiredSize > 0;\012          },\012          async cancel(reason) {\012            await iterator.return();\012          },\012          type: \042bytes\042\012        }\012      );\012    }\012    __name(ReadableStreamFrom, \042ReadableStreamFrom\042);\012    function isFormDataLike(object) {\012      return object && typeof object === \042object\042 && typeof object.append === \042function\042 && typeof object.delete === \042function\042 && typeof object.get === \042function\042 && typeof object.getAll === \042function\042 && typeof object.has === \042function\042 && typeof object.set === \042function\042 && object[Symbol.toStringTag] === \042FormData\042;\012    }\012    __name(isFormDataLike, \042isFormDataLike\042);\012    function addAbortListener(signal, listener) {\012      if (\042addEventListener\042 in signal) {\012        signal.addEventListener(\042abort\042, listener, { once: true });\012        return () => signal.removeEventListener(\042abort\042, listener);\012      }\012      signal.addListener(\042abort\042, listener);\012      return () => signal.removeListener(\042abort\042, listener);\012    }\012    __name(addAbortListener, \042addAbortListener\042);\012    var hasToWellFormed = typeof String.prototype.toWellFormed === \042function\042;\012    var hasIsWellFormed = typeof String.prototype.isWellFormed === \042function\042;\012    function toUSVString(val) {\012      return hasToWellFormed \077 `${val}`.toWellFormed() : nodeUtil.toUSVString(val);\012    }\012    __name(toUSVString, \042toUSVString\042);\012    function isUSVString(val) {\012      return hasIsWellFormed \077 `${val}`.isWellFormed() : toUSVString(val) === `${val}`;\012    }\012    __name(isUSVString, \042isUSVString\042);\012    function isTokenCharCode(c) {\012      switch (c) {\012        case 34:\012        case 40:\012        case 41:\012        case 44:\012        case 47:\012        case 58:\012        case 59:\012        case 60:\012        case 61:\012        case 62:\012        case 63:\012        case 64:\012        case 91:\012        case 92:\012        case 93:\012        case 123:\012        case 125:\012          return false;\012        default:\012          return c >= 33 && c <= 126;\012      }\012    }\012    __name(isTokenCharCode, \042isTokenCharCode\042);\012    function isValidHTTPToken(characters) {\012      if (characters.length === 0) {\012        return false;\012      }\012      for (let i = 0; i < characters.length; ++i) {\012        if (!isTokenCharCode(characters.charCodeAt(i))) {\012          return false;\012        }\012      }\012      return true;\012    }\012    __name(isValidHTTPToken, \042isValidHTTPToken\042);\012    var headerCharRegex = /[^\134t\134x20-\134x7e\134x80-\134xff]/;\012    function isValidHeaderValue(characters) {\012      return !headerCharRegex.test(characters);\012    }\012    __name(isValidHeaderValue, \042isValidHeaderValue\042);\012    function parseRangeHeader(range) {\012      if (range == null || range === \042\042)\012        return { start: 0, end: null, size: null };\012      const m = range \077 range.match(/^bytes (\134d+)-(\134d+)\134/(\134d+)\077$/) : null;\012      return m \077 {\012        start: parseInt(m[1]),\012        end: m[2] \077 parseInt(m[2]) : null,\012        size: m[3] \077 parseInt(m[3]) : null\012      } : null;\012    }\012    __name(parseRangeHeader, \042parseRangeHeader\042);\012    function addListener(obj, name, listener) {\012      const listeners = obj[kListeners] \077\077= [];\012      listeners.push([name, listener]);\012      obj.on(name, listener);\012      return obj;\012    }\012    __name(addListener, \042addListener\042);\012    function removeAllListeners(obj) {\012      for (const [name, listener] of obj[kListeners] \077\077 []) {\012        obj.removeListener(name, listener);\012      }\012      obj[kListeners] = null;\012    }\012    __name(removeAllListeners, \042removeAllListeners\042);\012    function errorRequest(client, request, err) {\012      try {\012        request.onError(err);\012        assert(request.aborted);\012      } catch (err2) {\012        client.emit(\042error\042, err2);\012      }\012    }\012    __name(errorRequest, \042errorRequest\042);\012    var kEnumerableProperty = /* @__PURE__ */ Object.create(null);\012    kEnumerableProperty.enumerable = true;\012    var normalizedMethodRecordsBase = {\012      delete: \042DELETE\042,\012      DELETE: \042DELETE\042,\012      get: \042GET\042,\012      GET: \042GET\042,\012      head: \042HEAD\042,\012      HEAD: \042HEAD\042,\012      options: \042OPTIONS\042,\012      OPTIONS: \042OPTIONS\042,\012      post: \042POST\042,\012      POST: \042POST\042,\012      put: \042PUT\042,\012      PUT: \042PUT\042\012    };\012    var normalizedMethodRecords = {\012      ...normalizedMethodRecordsBase,\012      patch: \042patch\042,\012      PATCH: \042PATCH\042\012    };\012    Object.setPrototypeOf(normalizedMethodRecordsBase, null);\012    Object.setPrototypeOf(normalizedMethodRecords, null);\012    module2.exports = {\012      kEnumerableProperty,\012      nop,\012      isDisturbed,\012      isErrored,\012      isReadable,\012      toUSVString,\012      isUSVString,\012      isBlobLike,\012      parseOrigin,\012      parseURL,\012      getServerName,\012      isStream,\012      isIterable,\012      isAsyncIterable,\012      isDestroyed,\012      headerNameToString,\012      bufferToLowerCasedHeaderName,\012      addListener,\012      removeAllListeners,\012      errorRequest,\012      parseRawHeaders,\012      parseHeaders,\012      parseKeepAliveTimeout,\012      destroy,\012      bodyLength,\012      deepClone,\012      ReadableStreamFrom,\012      isBuffer,\012      validateHandler,\012      getSocketInfo,\012      isFormDataLike,\012      buildURL,\012      addAbortListener,\012      isValidHTTPToken,\012      isValidHeaderValue,\012      isTokenCharCode,\012      parseRangeHeader,\012      normalizedMethodRecordsBase,\012      normalizedMethodRecords,\012      isValidPort,\012      isHttpOrHttpsPrefixed,\012      nodeMajor,\012      nodeMinor,\012      safeHTTPMethods: [\042GET\042, \042HEAD\042, \042OPTIONS\042, \042TRACE\042],\012      wrapRequestBody\012    };\012  }\012});\012\012// lib/core/diagnostics.js\012var require_diagnostics = __commonJS({\012  \042lib/core/diagnostics.js\042(exports2, module2) {\012    \042use strict\042;\012    var diagnosticsChannel = require(\042node:diagnostics_channel\042);\012    var util = require(\042node:util\042);\012    var undiciDebugLog = util.debuglog(\042undici\042);\012    var fetchDebuglog = util.debuglog(\042fetch\042);\012    var websocketDebuglog = util.debuglog(\042websocket\042);\012    var isClientSet = false;\012    var channels = {\012      // Client\012      beforeConnect: diagnosticsChannel.channel(\042undici:client:beforeConnect\042),\012      connected: diagnosticsChannel.channel(\042undici:client:connected\042),\012      connectError: diagnosticsChannel.channel(\042undici:client:connectError\042),\012      sendHeaders: diagnosticsChannel.channel(\042undici:client:sendHeaders\042),\012      // Request\012      create: diagnosticsChannel.channel(\042undici:request:create\042),\012      bodySent: diagnosticsChannel.channel(\042undici:request:bodySent\042),\012      headers: diagnosticsChannel.channel(\042undici:request:headers\042),\012      trailers: diagnosticsChannel.channel(\042undici:request:trailers\042),\012      error: diagnosticsChannel.channel(\042undici:request:error\042),\012      // WebSocket\012      open: diagnosticsChannel.channel(\042undici:websocket:open\042),\012      close: diagnosticsChannel.channel(\042undici:websocket:close\042),\012      socketError: diagnosticsChannel.channel(\042undici:websocket:socket_error\042),\012      ping: diagnosticsChannel.channel(\042undici:websocket:ping\042),\012      pong: diagnosticsChannel.channel(\042undici:websocket:pong\042)\012    };\012    if (undiciDebugLog.enabled || fetchDebuglog.enabled) {\012      const debuglog = fetchDebuglog.enabled \077 fetchDebuglog : undiciDebugLog;\012      diagnosticsChannel.channel(\042undici:client:beforeConnect\042).subscribe((evt) => {\012        const {\012          connectParams: { version, protocol, port, host }\012        } = evt;\012        debuglog(\012          \042connecting to %s using %s%s\042,\012          `${host}${port \077 `:${port}` : \042\042}`,\012          protocol,\012          version\012        );\012      });\012      diagnosticsChannel.channel(\042undici:client:connected\042).subscribe((evt) => {\012        const {\012          connectParams: { version, protocol, port, host }\012        } = evt;\012        debuglog(\012          \042connected to %s using %s%s\042,\012          `${host}${port \077 `:${port}` : \042\042}`,\012          protocol,\012          version\012        );\012      });\012      diagnosticsChannel.channel(\042undici:client:connectError\042).subscribe((evt) => {\012        const {\012          connectParams: { version, protocol, port, host },\012          error\012        } = evt;\012        debuglog(\012          \042connection to %s using %s%s errored - %s\042,\012          `${host}${port \077 `:${port}` : \042\042}`,\012          protocol,\012          version,\012          error.message\012        );\012      });\012      diagnosticsChannel.channel(\042undici:client:sendHeaders\042).subscribe((evt) => {\012        const {\012          request: { method, path, origin }\012        } = evt;\012        debuglog(\042sending request to %s %s/%s\042, method, origin, path);\012      });\012      diagnosticsChannel.channel(\042undici:request:headers\042).subscribe((evt) => {\012        const {\012          request: { method, path, origin },\012          response: { statusCode }\012        } = evt;\012        debuglog(\012          \042received response to %s %s/%s - HTTP %d\042,\012          method,\012          origin,\012          path,\012          statusCode\012        );\012      });\012      diagnosticsChannel.channel(\042undici:request:trailers\042).subscribe((evt) => {\012        const {\012          request: { method, path, origin }\012        } = evt;\012        debuglog(\042trailers received from %s %s/%s\042, method, origin, path);\012      });\012      diagnosticsChannel.channel(\042undici:request:error\042).subscribe((evt) => {\012        const {\012          request: { method, path, origin },\012          error\012        } = evt;\012        debuglog(\012          \042request to %s %s/%s errored - %s\042,\012          method,\012          origin,\012          path,\012          error.message\012        );\012      });\012      isClientSet = true;\012    }\012    if (websocketDebuglog.enabled) {\012      if (!isClientSet) {\012        const debuglog = undiciDebugLog.enabled \077 undiciDebugLog : websocketDebuglog;\012        diagnosticsChannel.channel(\042undici:client:beforeConnect\042).subscribe((evt) => {\012          const {\012            connectParams: { version, protocol, port, host }\012          } = evt;\012          debuglog(\012            \042connecting to %s%s using %s%s\042,\012            host,\012            port \077 `:${port}` : \042\042,\012            protocol,\012            version\012          );\012        });\012        diagnosticsChannel.channel(\042undici:client:connected\042).subscribe((evt) => {\012          const {\012            connectParams: { version, protocol, port, host }\012          } = evt;\012          debuglog(\012            \042connected to %s%s using %s%s\042,\012            host,\012            port \077 `:${port}` : \042\042,\012            protocol,\012            version\012          );\012        });\012        diagnosticsChannel.channel(\042undici:client:connectError\042).subscribe((evt) => {\012          const {\012            connectParams: { version, protocol, port, host },\012            error\012          } = evt;\012          debuglog(\012            \042connection to %s%s using %s%s errored - %s\042,\012            host,\012            port \077 `:${port}` : \042\042,\012            protocol,\012            version,\012            error.message\012          );\012        });\012        diagnosticsChannel.channel(\042undici:client:sendHeaders\042).subscribe((evt) => {\012          const {\012            request: { method, path, origin }\012          } = evt;\012          debuglog(\042sending request to %s %s/%s\042, method, origin, path);\012        });\012      }\012      diagnosticsChannel.channel(\042undici:websocket:open\042).subscribe((evt) => {\012        const {\012          address: { address, port }\012        } = evt;\012        websocketDebuglog(\042connection opened %s%s\042, address, port \077 `:${port}` : \042\042);\012      });\012      diagnosticsChannel.channel(\042undici:websocket:close\042).subscribe((evt) => {\012        const { websocket, code, reason } = evt;\012        websocketDebuglog(\012          \042closed connection to %s - %s %s\042,\012          websocket.url,\012          code,\012          reason\012        );\012      });\012      diagnosticsChannel.channel(\042undici:websocket:socket_error\042).subscribe((err) => {\012        websocketDebuglog(\042connection errored - %s\042, err.message);\012      });\012      diagnosticsChannel.channel(\042undici:websocket:ping\042).subscribe((evt) => {\012        websocketDebuglog(\042ping received\042);\012      });\012      diagnosticsChannel.channel(\042undici:websocket:pong\042).subscribe((evt) => {\012        websocketDebuglog(\042pong received\042);\012      });\012    }\012    module2.exports = {\012      channels\012    };\012  }\012});\012\012// lib/core/request.js\012var require_request = __commonJS({\012  \042lib/core/request.js\042(exports2, module2) {\012    \042use strict\042;\012    var {\012      InvalidArgumentError,\012      NotSupportedError\012    } = require_errors();\012    var assert = require(\042node:assert\042);\012    var {\012      isValidHTTPToken,\012      isValidHeaderValue,\012      isStream,\012      destroy,\012      isBuffer,\012      isFormDataLike,\012      isIterable,\012      isBlobLike,\012      buildURL,\012      validateHandler,\012      getServerName,\012      normalizedMethodRecords\012    } = require_util();\012    var { channels } = require_diagnostics();\012    var { headerNameLowerCasedRecord } = require_constants();\012    var invalidPathRegex = /[^\134u0021-\134u00ff]/;\012    var kHandler = Symbol(\042handler\042);\012    var Request = class {\012      static {\012        __name(this, \042Request\042);\012      }\012      constructor(origin, {\012        path,\012        method,\012        body,\012        headers,\012        query,\012        idempotent,\012        blocking,\012        upgrade,\012        headersTimeout,\012        bodyTimeout,\012        reset,\012        throwOnError,\012        expectContinue,\012        servername\012      }, handler) {\012        if (typeof path !== \042string\042) {\012          throw new InvalidArgumentError(\042path must be a string\042);\012        } else if (path[0] !== \042/\042 && !(path.startsWith(\042http://\042) || path.startsWith(\042https://\042)) && method !== \042CONNECT\042) {\012          throw new InvalidArgumentError(\042path must be an absolute URL or start with a slash\042);\012        } else if (invalidPathRegex.test(path)) {\012          throw new InvalidArgumentError(\042invalid request path\042);\012        }\012        if (typeof method !== \042string\042) {\012          throw new InvalidArgumentError(\042method must be a string\042);\012        } else if (normalizedMethodRecords[method] === void 0 && !isValidHTTPToken(method)) {\012          throw new InvalidArgumentError(\042invalid request method\042);\012        }\012        if (upgrade && typeof upgrade !== \042string\042) {\012          throw new InvalidArgumentError(\042upgrade must be a string\042);\012        }\012        if (headersTimeout != null && (!Number.isFinite(headersTimeout) || headersTimeout < 0)) {\012          throw new InvalidArgumentError(\042invalid headersTimeout\042);\012        }\012        if (bodyTimeout != null && (!Number.isFinite(bodyTimeout) || bodyTimeout < 0)) {\012          throw new InvalidArgumentError(\042invalid bodyTimeout\042);\012        }\012        if (reset != null && typeof reset !== \042boolean\042) {\012          throw new InvalidArgumentError(\042invalid reset\042);\012        }\012        if (expectContinue != null && typeof expectContinue !== \042boolean\042) {\012          throw new InvalidArgumentError(\042invalid expectContinue\042);\012        }\012        this.headersTimeout = headersTimeout;\012        this.bodyTimeout = bodyTimeout;\012        this.throwOnError = throwOnError === true;\012        this.method = method;\012        this.abort = null;\012        if (body == null) {\012          this.body = null;\012        } else if (isStream(body)) {\012          this.body = body;\012          const rState = this.body._readableState;\012          if (!rState || !rState.autoDestroy) {\012            this.endHandler = /* @__PURE__ */ __name(function autoDestroy() {\012              destroy(this);\012            }, \042autoDestroy\042);\012            this.body.on(\042end\042, this.endHandler);\012          }\012          this.errorHandler = (err) => {\012            if (this.abort) {\012              this.abort(err);\012            } else {\012              this.error = err;\012            }\012          };\012          this.body.on(\042error\042, this.errorHandler);\012        } else if (isBuffer(body)) {\012          this.body = body.byteLength \077 body : null;\012        } else if (ArrayBuffer.isView(body)) {\012          this.body = body.buffer.byteLength \077 Buffer.from(body.buffer, body.byteOffset, body.byteLength) : null;\012        } else if (body instanceof ArrayBuffer) {\012          this.body = body.byteLength \077 Buffer.from(body) : null;\012        } else if (typeof body === \042string\042) {\012          this.body = body.length \077 Buffer.from(body) : null;\012        } else if (isFormDataLike(body) || isIterable(body) || isBlobLike(body)) {\012          this.body = body;\012        } else {\012          throw new InvalidArgumentError(\042body must be a string, a Buffer, a Readable stream, an iterable, or an async iterable\042);\012        }\012        this.completed = false;\012        this.aborted = false;\012        this.upgrade = upgrade || null;\012        this.path = query \077 buildURL(path, query) : path;\012        this.origin = origin;\012        this.idempotent = idempotent == null \077 method === \042HEAD\042 || method === \042GET\042 : idempotent;\012        this.blocking = blocking == null \077 false : blocking;\012        this.reset = reset == null \077 null : reset;\012        this.host = null;\012        this.contentLength = null;\012        this.contentType = null;\012        this.headers = [];\012        this.expectContinue = expectContinue != null \077 expectContinue : false;\012        if (Array.isArray(headers)) {\012          if (headers.length % 2 !== 0) {\012            throw new InvalidArgumentError(\042headers array must be even\042);\012          }\012          for (let i = 0; i < headers.length; i += 2) {\012            processHeader(this, headers[i], headers[i + 1]);\012          }\012        } else if (headers && typeof headers === \042object\042) {\012          if (headers[Symbol.iterator]) {\012            for (const header of headers) {\012              if (!Array.isArray(header) || header.length !== 2) {\012                throw new InvalidArgumentError(\042headers must be in key-value pair format\042);\012              }\012              processHeader(this, header[0], header[1]);\012            }\012          } else {\012            const keys = Object.keys(headers);\012            for (let i = 0; i < keys.length; ++i) {\012              processHeader(this, keys[i], headers[keys[i]]);\012            }\012          }\012        } else if (headers != null) {\012          throw new InvalidArgumentError(\042headers must be an object or an array\042);\012        }\012        validateHandler(handler, method, upgrade);\012        this.servername = servername || getServerName(this.host);\012        this[kHandler] = handler;\012        if (channels.create.hasSubscribers) {\012          channels.create.publish({ request: this });\012        }\012      }\012      onBodySent(chunk) {\012        if (this[kHandler].onBodySent) {\012          try {\012            return this[kHandler].onBodySent(chunk);\012          } catch (err) {\012            this.abort(err);\012          }\012        }\012      }\012      onRequestSent() {\012        if (channels.bodySent.hasSubscribers) {\012          channels.bodySent.publish({ request: this });\012        }\012        if (this[kHandler].onRequestSent) {\012          try {\012            return this[kHandler].onRequestSent();\012          } catch (err) {\012            this.abort(err);\012          }\012        }\012      }\012      onConnect(abort) {\012        assert(!this.aborted);\012        assert(!this.completed);\012        if (this.error) {\012          abort(this.error);\012        } else {\012          this.abort = abort;\012          return this[kHandler].onConnect(abort);\012        }\012      }\012      onResponseStarted() {\012        return this[kHandler].onResponseStarted\077.();\012      }\012      onHeaders(statusCode, headers, resume, statusText) {\012        assert(!this.aborted);\012        assert(!this.completed);\012        if (channels.headers.hasSubscribers) {\012          channels.headers.publish({ request: this, response: { statusCode, headers, statusText } });\012        }\012        try {\012          return this[kHandler].onHeaders(statusCode, headers, resume, statusText);\012        } catch (err) {\012          this.abort(err);\012        }\012      }\012      onData(chunk) {\012        assert(!this.aborted);\012        assert(!this.completed);\012        try {\012          return this[kHandler].onData(chunk);\012        } catch (err) {\012          this.abort(err);\012          return false;\012        }\012      }\012      onUpgrade(statusCode, headers, socket) {\012        assert(!this.aborted);\012        assert(!this.completed);\012        return this[kHandler].onUpgrade(statusCode, headers, socket);\012      }\012      onComplete(trailers) {\012        this.onFinally();\012        assert(!this.aborted);\012        this.completed = true;\012        if (channels.trailers.hasSubscribers) {\012          channels.trailers.publish({ request: this, trailers });\012        }\012        try {\012          return this[kHandler].onComplete(trailers);\012        } catch (err) {\012          this.onError(err);\012        }\012      }\012      onError(error) {\012        this.onFinally();\012        if (channels.error.hasSubscribers) {\012          channels.error.publish({ request: this, error });\012        }\012        if (this.aborted) {\012          return;\012        }\012        this.aborted = true;\012        return this[kHandler].onError(error);\012      }\012      onFinally() {\012        if (this.errorHandler) {\012          this.body.off(\042error\042, this.errorHandler);\012          this.errorHandler = null;\012        }\012        if (this.endHandler) {\012          this.body.off(\042end\042, this.endHandler);\012          this.endHandler = null;\012        }\012      }\012      addHeader(key, value) {\012        processHeader(this, key, value);\012        return this;\012      }\012    };\012    function processHeader(request, key, val) {\012      if (val && (typeof val === \042object\042 && !Array.isArray(val))) {\012        throw new InvalidArgumentError(`invalid ${key} header`);\012      } else if (val === void 0) {\012        return;\012      }\012      let headerName = headerNameLowerCasedRecord[key];\012      if (headerName === void 0) {\012        headerName = key.toLowerCase();\012        if (headerNameLowerCasedRecord[headerName] === void 0 && !isValidHTTPToken(headerName)) {\012          throw new InvalidArgumentError(\042invalid header key\042);\012        }\012      }\012      if (Array.isArray(val)) {\012        const arr = [];\012        for (let i = 0; i < val.length; i++) {\012          if (typeof val[i] === \042string\042) {\012            if (!isValidHeaderValue(val[i])) {\012              throw new InvalidArgumentError(`invalid ${key} header`);\012            }\012            arr.push(val[i]);\012          } else if (val[i] === null) {\012            arr.push(\042\042);\012          } else if (typeof val[i] === \042object\042) {\012            throw new InvalidArgumentError(`invalid ${key} header`);\012          } else {\012            arr.push(`${val[i]}`);\012          }\012        }\012        val = arr;\012      } else if (typeof val === \042string\042) {\012        if (!isValidHeaderValue(val)) {\012          throw new InvalidArgumentError(`invalid ${key} header`);\012        }\012      } else if (val === null) {\012        val = \042\042;\012      } else {\012        val = `${val}`;\012      }\012      if (request.host === null && headerName === \042host\042) {\012        if (typeof val !== \042string\042) {\012          throw new InvalidArgumentError(\042invalid host header\042);\012        }\012        request.host = val;\012      } else if (request.contentLength === null && headerName === \042content-length\042) {\012        request.contentLength = parseInt(val, 10);\012        if (!Number.isFinite(request.contentLength)) {\012          throw new InvalidArgumentError(\042invalid content-length header\042);\012        }\012      } else if (request.contentType === null && headerName === \042content-type\042) {\012        request.contentType = val;\012        request.headers.push(key, val);\012      } else if (headerName === \042transfer-encoding\042 || headerName === \042keep-alive\042 || headerName === \042upgrade\042) {\012        throw new InvalidArgumentError(`invalid ${headerName} header`);\012      } else if (headerName === \042connection\042) {\012        const value = typeof val === \042string\042 \077 val.toLowerCase() : null;\012        if (value !== \042close\042 && value !== \042keep-alive\042) {\012          throw new InvalidArgumentError(\042invalid connection header\042);\012        }\012        if (value === \042close\042) {\012          request.reset = true;\012        }\012      } else if (headerName === \042expect\042) {\012        throw new NotSupportedError(\042expect header not supported\042);\012      } else {\012        request.headers.push(key, val);\012      }\012    }\012    __name(processHeader, \042processHeader\042);\012    module2.exports = Request;\012  }\012});\012\012// lib/util/timers.js\012var require_timers = __commonJS({\012  \042lib/util/timers.js\042(exports2, module2) {\012    \042use strict\042;\012    var fastNow = 0;\012    var RESOLUTION_MS = 1e3;\012    var TICK_MS = (RESOLUTION_MS >> 1) - 1;\012    var fastNowTimeout;\012    var kFastTimer = Symbol(\042kFastTimer\042);\012    var fastTimers = [];\012    var NOT_IN_LIST = -2;\012    var TO_BE_CLEARED = -1;\012    var PENDING = 0;\012    var ACTIVE = 1;\012    function onTick() {\012      fastNow += TICK_MS;\012      let idx = 0;\012      let len = fastTimers.length;\012      while (idx < len) {\012        const timer = fastTimers[idx];\012        if (timer._state === PENDING) {\012          timer._idleStart = fastNow - TICK_MS;\012          timer._state = ACTIVE;\012        } else if (timer._state === ACTIVE && fastNow >= timer._idleStart + timer._idleTimeout) {\012          timer._state = TO_BE_CLEARED;\012          timer._idleStart = -1;\012          timer._onTimeout(timer._timerArg);\012        }\012        if (timer._state === TO_BE_CLEARED) {\012          timer._state = NOT_IN_LIST;\012          if (--len !== 0) {\012            fastTimers[idx] = fastTimers[len];\012          }\012        } else {\012          ++idx;\012        }\012      }\012      fastTimers.length = len;\012      if (fastTimers.length !== 0) {\012        refreshTimeout();\012      }\012    }\012    __name(onTick, \042onTick\042);\012    function refreshTimeout() {\012      if (fastNowTimeout) {\012        fastNowTimeout.refresh();\012      } else {\012        clearTimeout(fastNowTimeout);\012        fastNowTimeout = setTimeout(onTick, TICK_MS);\012        if (fastNowTimeout.unref) {\012          fastNowTimeout.unref();\012        }\012      }\012    }\012    __name(refreshTimeout, \042refreshTimeout\042);\012    var FastTimer = class {\012      static {\012        __name(this, \042FastTimer\042);\012      }\012      [kFastTimer] = true;\012      /**\012       * The state of the timer, which can be one of the following:\012       * - NOT_IN_LIST (-2)\012       * - TO_BE_CLEARED (-1)\012       * - PENDING (0)\012       * - ACTIVE (1)\012       *\012       * @type {-2|-1|0|1}\012       * @private\012       */\012      _state = NOT_IN_LIST;\012      /**\012       * The number of milliseconds to wait before calling the callback.\012       *\012       * @type {number}\012       * @private\012       */\012      _idleTimeout = -1;\012      /**\012       * The time in milliseconds when the timer was started. This value is used to\012       * calculate when the timer should expire.\012       *\012       * @type {number}\012       * @default -1\012       * @private\012       */\012      _idleStart = -1;\012      /**\012       * The function to be executed when the timer expires.\012       * @type {Function}\012       * @private\012       */\012      _onTimeout;\012      /**\012       * The argument to be passed to the callback when the timer expires.\012       *\012       * @type {*}\012       * @private\012       */\012      _timerArg;\012      /**\012       * @constructor\012       * @param {Function} callback A function to be executed after the timer\012       * expires.\012       * @param {number} delay The time, in milliseconds that the timer should wait\012       * before the specified function or code is executed.\012       * @param {*} arg\012       */\012      constructor(callback, delay, arg) {\012        this._onTimeout = callback;\012        this._idleTimeout = delay;\012        this._timerArg = arg;\012        this.refresh();\012      }\012      /**\012       * Sets the timer's start time to the current time, and reschedules the timer\012       * to call its callback at the previously specified duration adjusted to the\012       * current time.\012       * Using this on a timer that has already called its callback will reactivate\012       * the timer.\012       *\012       * @returns {void}\012       */\012      refresh() {\012        if (this._state === NOT_IN_LIST) {\012          fastTimers.push(this);\012        }\012        if (!fastNowTimeout || fastTimers.length === 1) {\012          refreshTimeout();\012        }\012        this._state = PENDING;\012      }\012      /**\012       * The `clear` method cancels the timer, preventing it from executing.\012       *\012       * @returns {void}\012       * @private\012       */\012      clear() {\012        this._state = TO_BE_CLEARED;\012        this._idleStart = -1;\012      }\012    };\012    module2.exports = {\012      /**\012       * The setTimeout() method sets a timer which executes a function once the\012       * timer expires.\012       * @param {Function} callback A function to be executed after the timer\012       * expires.\012       * @param {number} delay The time, in milliseconds that the timer should\012       * wait before the specified function or code is executed.\012       * @param {*} [arg] An optional argument to be passed to the callback function\012       * when the timer expires.\012       * @returns {NodeJS.Timeout|FastTimer}\012       */\012      setTimeout(callback, delay, arg) {\012        return delay <= RESOLUTION_MS \077 setTimeout(callback, delay, arg) : new FastTimer(callback, delay, arg);\012      },\012      /**\012       * The clearTimeout method cancels an instantiated Timer previously created\012       * by calling setTimeout.\012       *\012       * @param {NodeJS.Timeout|FastTimer} timeout\012       */\012      clearTimeout(timeout) {\012        if (timeout[kFastTimer]) {\012          timeout.clear();\012        } else {\012          clearTimeout(timeout);\012        }\012      },\012      /**\012       * The setFastTimeout() method sets a fastTimer which executes a function once\012       * the timer expires.\012       * @param {Function} callback A function to be executed after the timer\012       * expires.\012       * @param {number} delay The time, in milliseconds that the timer should\012       * wait before the specified function or code is executed.\012       * @param {*} [arg] An optional argument to be passed to the callback function\012       * when the timer expires.\012       * @returns {FastTimer}\012       */\012      setFastTimeout(callback, delay, arg) {\012        return new FastTimer(callback, delay, arg);\012      },\012      /**\012       * The clearTimeout method cancels an instantiated FastTimer previously\012       * created by calling setFastTimeout.\012       *\012       * @param {FastTimer} timeout\012       */\012      clearFastTimeout(timeout) {\012        timeout.clear();\012      },\012      /**\012       * The now method returns the value of the internal fast timer clock.\012       *\012       * @returns {number}\012       */\012      now() {\012        return fastNow;\012      },\012      /**\012       * Trigger the onTick function to process the fastTimers array.\012       * Exported for testing purposes only.\012       * Marking as deprecated to discourage any use outside of testing.\012       * @deprecated\012       * @param {number} [delay=0] The delay in milliseconds to add to the now value.\012       */\012      tick(delay = 0) {\012        fastNow += delay - RESOLUTION_MS + 1;\012        onTick();\012        onTick();\012      },\012      /**\012       * Reset FastTimers.\012       * Exported for testing purposes only.\012       * Marking as deprecated to discourage any use outside of testing.\012       * @deprecated\012       */\012      reset() {\012        fastNow = 0;\012        fastTimers.length = 0;\012        clearTimeout(fastNowTimeout);\012        fastNowTimeout = null;\012      },\012      /**\012       * Exporting for testing purposes only.\012       * Marking as deprecated to discourage any use outside of testing.\012       * @deprecated\012       */\012      kFastTimer\012    };\012  }\012});\012\012// lib/core/connect.js\012var require_connect = __commonJS({\012  \042lib/core/connect.js\042(exports2, module2) {\012    \042use strict\042;\012    var net = require(\042node:net\042);\012    var assert = require(\042node:assert\042);\012    var util = require_util();\012    var { InvalidArgumentError, ConnectTimeoutError } = require_errors();\012    var timers = require_timers();\012    function noop() {\012    }\012    __name(noop, \042noop\042);\012    var tls;\012    var SessionCache;\012    if (global.FinalizationRegistry && !(process.env.NODE_V8_COVERAGE || process.env.UNDICI_NO_FG)) {\012      SessionCache = class WeakSessionCache {\012        static {\012          __name(this, \042WeakSessionCache\042);\012        }\012        constructor(maxCachedSessions) {\012          this._maxCachedSessions = maxCachedSessions;\012          this._sessionCache = /* @__PURE__ */ new Map();\012          this._sessionRegistry = new global.FinalizationRegistry((key) => {\012            if (this._sessionCache.size < this._maxCachedSessions) {\012              return;\012            }\012            const ref = this._sessionCache.get(key);\012            if (ref !== void 0 && ref.deref() === void 0) {\012              this._sessionCache.delete(key);\012            }\012          });\012        }\012        get(sessionKey) {\012          const ref = this._sessionCache.get(sessionKey);\012          return ref \077 ref.deref() : null;\012        }\012        set(sessionKey, session) {\012          if (this._maxCachedSessions === 0) {\012            return;\012          }\012          this._sessionCache.set(sessionKey, new WeakRef(session));\012          this._sessionRegistry.register(session, sessionKey);\012        }\012      };\012    } else {\012      SessionCache = class SimpleSessionCache {\012        static {\012          __name(this, \042SimpleSessionCache\042);\012        }\012        constructor(maxCachedSessions) {\012          this._maxCachedSessions = maxCachedSessions;\012          this._sessionCache = /* @__PURE__ */ new Map();\012        }\012        get(sessionKey) {\012          return this._sessionCache.get(sessionKey);\012        }\012        set(sessionKey, session) {\012          if (this._maxCachedSessions === 0) {\012            return;\012          }\012          if (this._sessionCache.size >= this._maxCachedSessions) {\012            const { value: oldestKey } = this._sessionCache.keys().next();\012            this._sessionCache.delete(oldestKey);\012          }\012          this._sessionCache.set(sessionKey, session);\012        }\012      };\012    }\012    function buildConnector({ allowH2, maxCachedSessions, socketPath, timeout, session: customSession, ...opts }) {\012      if (maxCachedSessions != null && (!Number.isInteger(maxCachedSessions) || maxCachedSessions < 0)) {\012        throw new InvalidArgumentError(\042maxCachedSessions must be a positive integer or zero\042);\012      }\012      const options = { path: socketPath, ...opts };\012      const sessionCache = new SessionCache(maxCachedSessions == null \077 100 : maxCachedSessions);\012      timeout = timeout == null \077 1e4 : timeout;\012      allowH2 = allowH2 != null \077 allowH2 : false;\012      return /* @__PURE__ */ __name(function connect({ hostname, host, protocol, port, servername, localAddress, httpSocket }, callback) {\012        let socket;\012        if (protocol === \042https:\042) {\012          if (!tls) {\012            tls = require(\042node:tls\042);\012          }\012          servername = servername || options.servername || util.getServerName(host) || null;\012          const sessionKey = servername || hostname;\012          assert(sessionKey);\012          const session = customSession || sessionCache.get(sessionKey) || null;\012          port = port || 443;\012          socket = tls.connect({\012            highWaterMark: 16384,\012            // TLS in node can't have bigger HWM anyway...\012            ...options,\012            servername,\012            session,\012            localAddress,\012            // TODO(HTTP/2): Add support for h2c\012            ALPNProtocols: allowH2 \077 [\042http/1.1\042, \042h2\042] : [\042http/1.1\042],\012            socket: httpSocket,\012            // upgrade socket connection\012            port,\012            host: hostname\012          });\012          socket.on(\042session\042, function(session2) {\012            sessionCache.set(sessionKey, session2);\012          });\012        } else {\012          assert(!httpSocket, \042httpSocket can only be sent on TLS update\042);\012          port = port || 80;\012          socket = net.connect({\012            highWaterMark: 64 * 1024,\012            // Same as nodejs fs streams.\012            ...options,\012            localAddress,\012            port,\012            host: hostname\012          });\012        }\012        if (options.keepAlive == null || options.keepAlive) {\012          const keepAliveInitialDelay = options.keepAliveInitialDelay === void 0 \077 6e4 : options.keepAliveInitialDelay;\012          socket.setKeepAlive(true, keepAliveInitialDelay);\012        }\012        const clearConnectTimeout = setupConnectTimeout(new WeakRef(socket), { timeout, hostname, port });\012        socket.setNoDelay(true).once(protocol === \042https:\042 \077 \042secureConnect\042 : \042connect\042, function() {\012          queueMicrotask(clearConnectTimeout);\012          if (callback) {\012            const cb = callback;\012            callback = null;\012            cb(null, this);\012          }\012        }).on(\042error\042, function(err) {\012          queueMicrotask(clearConnectTimeout);\012          if (callback) {\012            const cb = callback;\012            callback = null;\012            cb(err);\012          }\012        });\012        return socket;\012      }, \042connect\042);\012    }\012    __name(buildConnector, \042buildConnector\042);\012    var setupConnectTimeout = process.platform === \042win32\042 \077 (socketWeakRef, opts) => {\012      if (!opts.timeout) {\012        return noop;\012      }\012      let s1 = null;\012      let s2 = null;\012      const fastTimer = timers.setFastTimeout(() => {\012        s1 = setImmediate(() => {\012          s2 = setImmediate(() => onConnectTimeout(socketWeakRef.deref(), opts));\012        });\012      }, opts.timeout);\012      return () => {\012        timers.clearFastTimeout(fastTimer);\012        clearImmediate(s1);\012        clearImmediate(s2);\012      };\012    } : (socketWeakRef, opts) => {\012      if (!opts.timeout) {\012        return noop;\012      }\012      let s1 = null;\012      const fastTimer = timers.setFastTimeout(() => {\012        s1 = setImmediate(() => {\012          onConnectTimeout(socketWeakRef.deref(), opts);\012        });\012      }, opts.timeout);\012      return () => {\012        timers.clearFastTimeout(fastTimer);\012        clearImmediate(s1);\012      };\012    };\012    function onConnectTimeout(socket, opts) {\012      if (socket == null) {\012        return;\012      }\012      let message = \042Connect Timeout Error\042;\012      if (Array.isArray(socket.autoSelectFamilyAttemptedAddresses)) {\012        message += ` (attempted addresses: ${socket.autoSelectFamilyAttemptedAddresses.join(\042, \042)},`;\012      } else {\012        message += ` (attempted address: ${opts.hostname}:${opts.port},`;\012      }\012      message += ` timeout: ${opts.timeout}ms)`;\012      util.destroy(socket, new ConnectTimeoutError(message));\012    }\012    __name(onConnectTimeout, \042onConnectTimeout\042);\012    module2.exports = buildConnector;\012  }\012});\012\012// lib/llhttp/utils.js\012var require_utils = __commonJS({\012  \042lib/llhttp/utils.js\042(exports2) {\012    \042use strict\042;\012    Object.defineProperty(exports2, \042__esModule\042, { value: true });\012    exports2.enumToMap = void 0;\012    function enumToMap(obj) {\012      const res = {};\012      Object.keys(obj).forEach((key) => {\012        const value = obj[key];\012        if (typeof value === \042number\042) {\012          res[key] = value;\012        }\012      });\012      return res;\012    }\012    __name(enumToMap, \042enumToMap\042);\012    exports2.enumToMap = enumToMap;\012  }\012});\012\012// lib/llhttp/constants.js\012var require_constants2 = __commonJS({\012  \042lib/llhttp/constants.js\042(exports2) {\012    \042use strict\042;\012    Object.defineProperty(exports2, \042__esModule\042, { value: true });\012    exports2.SPECIAL_HEADERS = exports2.HEADER_STATE = exports2.MINOR = exports2.MAJOR = exports2.CONNECTION_TOKEN_CHARS = exports2.HEADER_CHARS = exports2.TOKEN = exports2.STRICT_TOKEN = exports2.HEX = exports2.URL_CHAR = exports2.STRICT_URL_CHAR = exports2.USERINFO_CHARS = exports2.MARK = exports2.ALPHANUM = exports2.NUM = exports2.HEX_MAP = exports2.NUM_MAP = exports2.ALPHA = exports2.FINISH = exports2.H_METHOD_MAP = exports2.METHOD_MAP = exports2.METHODS_RTSP = exports2.METHODS_ICE = exports2.METHODS_HTTP = exports2.METHODS = exports2.LENIENT_FLAGS = exports2.FLAGS = exports2.TYPE = exports2.ERROR = void 0;\012    var utils_1 = require_utils();\012    var ERROR;\012    (function(ERROR2) {\012      ERROR2[ERROR2[\042OK\042] = 0] = \042OK\042;\012      ERROR2[ERROR2[\042INTERNAL\042] = 1] = \042INTERNAL\042;\012      ERROR2[ERROR2[\042STRICT\042] = 2] = \042STRICT\042;\012      ERROR2[ERROR2[\042LF_EXPECTED\042] = 3] = \042LF_EXPECTED\042;\012      ERROR2[ERROR2[\042UNEXPECTED_CONTENT_LENGTH\042] = 4] = \042UNEXPECTED_CONTENT_LENGTH\042;\012      ERROR2[ERROR2[\042CLOSED_CONNECTION\042] = 5] = \042CLOSED_CONNECTION\042;\012      ERROR2[ERROR2[\042INVALID_METHOD\042] = 6] = \042INVALID_METHOD\042;\012      ERROR2[ERROR2[\042INVALID_URL\042] = 7] = \042INVALID_URL\042;\012      ERROR2[ERROR2[\042INVALID_CONSTANT\042] = 8] = \042INVALID_CONSTANT\042;\012      ERROR2[ERROR2[\042INVALID_VERSION\042] = 9] = \042INVALID_VERSION\042;\012      ERROR2[ERROR2[\042INVALID_HEADER_TOKEN\042] = 10] = \042INVALID_HEADER_TOKEN\042;\012      ERROR2[ERROR2[\042INVALID_CONTENT_LENGTH\042] = 11] = \042INVALID_CONTENT_LENGTH\042;\012      ERROR2[ERROR2[\042INVALID_CHUNK_SIZE\042] = 12] = \042INVALID_CHUNK_SIZE\042;\012      ERROR2[ERROR2[\042INVALID_STATUS\042] = 13] = \042INVALID_STATUS\042;\012      ERROR2[ERROR2[\042INVALID_EOF_STATE\042] = 14] = \042INVALID_EOF_STATE\042;\012      ERROR2[ERROR2[\042INVALID_TRANSFER_ENCODING\042] = 15] = \042INVALID_TRANSFER_ENCODING\042;\012      ERROR2[ERROR2[\042CB_MESSAGE_BEGIN\042] = 16] = \042CB_MESSAGE_BEGIN\042;\012      ERROR2[ERROR2[\042CB_HEADERS_COMPLETE\042] = 17] = \042CB_HEADERS_COMPLETE\042;\012      ERROR2[ERROR2[\042CB_MESSAGE_COMPLETE\042] = 18] = \042CB_MESSAGE_COMPLETE\042;\012      ERROR2[ERROR2[\042CB_CHUNK_HEADER\042] = 19] = \042CB_CHUNK_HEADER\042;\012      ERROR2[ERROR2[\042CB_CHUNK_COMPLETE\042] = 20] = \042CB_CHUNK_COMPLETE\042;\012      ERROR2[ERROR2[\042PAUSED\042] = 21] = \042PAUSED\042;\012      ERROR2[ERROR2[\042PAUSED_UPGRADE\042] = 22] = \042PAUSED_UPGRADE\042;\012      ERROR2[ERROR2[\042PAUSED_H2_UPGRADE\042] = 23] = \042PAUSED_H2_UPGRADE\042;\012      ERROR2[ERROR2[\042USER\042] = 24] = \042USER\042;\012    })(ERROR = exports2.ERROR || (exports2.ERROR = {}));\012    var TYPE;\012    (function(TYPE2) {\012      TYPE2[TYPE2[\042BOTH\042] = 0] = \042BOTH\042;\012      TYPE2[TYPE2[\042REQUEST\042] = 1] = \042REQUEST\042;\012      TYPE2[TYPE2[\042RESPONSE\042] = 2] = \042RESPONSE\042;\012    })(TYPE = exports2.TYPE || (exports2.TYPE = {}));\012    var FLAGS;\012    (function(FLAGS2) {\012      FLAGS2[FLAGS2[\042CONNECTION_KEEP_ALIVE\042] = 1] = \042CONNECTION_KEEP_ALIVE\042;\012      FLAGS2[FLAGS2[\042CONNECTION_CLOSE\042] = 2] = \042CONNECTION_CLOSE\042;\012      FLAGS2[FLAGS2[\042CONNECTION_UPGRADE\042] = 4] = \042CONNECTION_UPGRADE\042;\012      FLAGS2[FLAGS2[\042CHUNKED\042] = 8] = \042CHUNKED\042;\012      FLAGS2[FLAGS2[\042UPGRADE\042] = 16] = \042UPGRADE\042;\012      FLAGS2[FLAGS2[\042CONTENT_LENGTH\042] = 32] = \042CONTENT_LENGTH\042;\012      FLAGS2[FLAGS2[\042SKIPBODY\042] = 64] = \042SKIPBODY\042;\012      FLAGS2[FLAGS2[\042TRAILING\042] = 128] = \042TRAILING\042;\012      FLAGS2[FLAGS2[\042TRANSFER_ENCODING\042] = 512] = \042TRANSFER_ENCODING\042;\012    })(FLAGS = exports2.FLAGS || (exports2.FLAGS = {}));\012    var LENIENT_FLAGS;\012    (function(LENIENT_FLAGS2) {\012      LENIENT_FLAGS2[LENIENT_FLAGS2[\042HEADERS\042] = 1] = \042HEADERS\042;\012      LENIENT_FLAGS2[LENIENT_FLAGS2[\042CHUNKED_LENGTH\042] = 2] = \042CHUNKED_LENGTH\042;\012      LENIENT_FLAGS2[LENIENT_FLAGS2[\042KEEP_ALIVE\042] = 4] = \042KEEP_ALIVE\042;\012    })(LENIENT_FLAGS = exports2.LENIENT_FLAGS || (exports2.LENIENT_FLAGS = {}));\012    var METHODS;\012    (function(METHODS2) {\012      METHODS2[METHODS2[\042DELETE\042] = 0] = \042DELETE\042;\012      METHODS2[METHODS2[\042GET\042] = 1] = \042GET\042;\012      METHODS2[METHODS2[\042HEAD\042] = 2] = \042HEAD\042;\012      METHODS2[METHODS2[\042POST\042] = 3] = \042POST\042;\012      METHODS2[METHODS2[\042PUT\042] = 4] = \042PUT\042;\012      METHODS2[METHODS2[\042CONNECT\042] = 5] = \042CONNECT\042;\012      METHODS2[METHODS2[\042OPTIONS\042] = 6] = \042OPTIONS\042;\012      METHODS2[METHODS2[\042TRACE\042] = 7] = \042TRACE\042;\012      METHODS2[METHODS2[\042COPY\042] = 8] = \042COPY\042;\012      METHODS2[METHODS2[\042LOCK\042] = 9] = \042LOCK\042;\012      METHODS2[METHODS2[\042MKCOL\042] = 10] = \042MKCOL\042;\012      METHODS2[METHODS2[\042MOVE\042] = 11] = \042MOVE\042;\012      METHODS2[METHODS2[\042PROPFIND\042] = 12] = \042PROPFIND\042;\012      METHODS2[METHODS2[\042PROPPATCH\042] = 13] = \042PROPPATCH\042;\012      METHODS2[METHODS2[\042SEARCH\042] = 14] = \042SEARCH\042;\012      METHODS2[METHODS2[\042UNLOCK\042] = 15] = \042UNLOCK\042;\012      METHODS2[METHODS2[\042BIND\042] = 16] = \042BIND\042;\012      METHODS2[METHODS2[\042REBIND\042] = 17] = \042REBIND\042;\012      METHODS2[METHODS2[\042UNBIND\042] = 18] = \042UNBIND\042;\012      METHODS2[METHODS2[\042ACL\042] = 19] = \042ACL\042;\012      METHODS2[METHODS2[\042REPORT\042] = 20] = \042REPORT\042;\012      METHODS2[METHODS2[\042MKACTIVITY\042] = 21] = \042MKACTIVITY\042;\012      METHODS2[METHODS2[\042CHECKOUT\042] = 22] = \042CHECKOUT\042;\012      METHODS2[METHODS2[\042MERGE\042] = 23] = \042MERGE\042;\012      METHODS2[METHODS2[\042M-SEARCH\042] = 24] = \042M-SEARCH\042;\012      METHODS2[METHODS2[\042NOTIFY\042] = 25] = \042NOTIFY\042;\012      METHODS2[METHODS2[\042SUBSCRIBE\042] = 26] = \042SUBSCRIBE\042;\012      METHODS2[METHODS2[\042UNSUBSCRIBE\042] = 27] = \042UNSUBSCRIBE\042;\012      METHODS2[METHODS2[\042PATCH\042] = 28] = \042PATCH\042;\012      METHODS2[METHODS2[\042PURGE\042] = 29] = \042PURGE\042;\012      METHODS2[METHODS2[\042MKCALENDAR\042] = 30] = \042MKCALENDAR\042;\012      METHODS2[METHODS2[\042LINK\042] = 31] = \042LINK\042;\012      METHODS2[METHODS2[\042UNLINK\042] = 32] = \042UNLINK\042;\012      METHODS2[METHODS2[\042SOURCE\042] = 33] = \042SOURCE\042;\012      METHODS2[METHODS2[\042PRI\042] = 34] = \042PRI\042;\012      METHODS2[METHODS2[\042DESCRIBE\042] = 35] = \042DESCRIBE\042;\012      METHODS2[METHODS2[\042ANNOUNCE\042] = 36] = \042ANNOUNCE\042;\012      METHODS2[METHODS2[\042SETUP\042] = 37] = \042SETUP\042;\012      METHODS2[METHODS2[\042PLAY\042] = 38] = \042PLAY\042;\012      METHODS2[METHODS2[\042PAUSE\042] = 39] = \042PAUSE\042;\012      METHODS2[METHODS2[\042TEARDOWN\042] = 40] = \042TEARDOWN\042;\012      METHODS2[METHODS2[\042GET_PARAMETER\042] = 41] = \042GET_PARAMETER\042;\012      METHODS2[METHODS2[\042SET_PARAMETER\042] = 42] = \042SET_PARAMETER\042;\012      METHODS2[METHODS2[\042REDIRECT\042] = 43] = \042REDIRECT\042;\012      METHODS2[METHODS2[\042RECORD\042] = 44] = \042RECORD\042;\012      METHODS2[METHODS2[\042FLUSH\042] = 45] = \042FLUSH\042;\012    })(METHODS = exports2.METHODS || (exports2.METHODS = {}));\012    exports2.METHODS_HTTP = [\012      METHODS.DELETE,\012      METHODS.GET,\012      METHODS.HEAD,\012      METHODS.POST,\012      METHODS.PUT,\012      METHODS.CONNECT,\012      METHODS.OPTIONS,\012      METHODS.TRACE,\012      METHODS.COPY,\012      METHODS.LOCK,\012      METHODS.MKCOL,\012      METHODS.MOVE,\012      METHODS.PROPFIND,\012      METHODS.PROPPATCH,\012      METHODS.SEARCH,\012      METHODS.UNLOCK,\012      METHODS.BIND,\012      METHODS.REBIND,\012      METHODS.UNBIND,\012      METHODS.ACL,\012      METHODS.REPORT,\012      METHODS.MKACTIVITY,\012      METHODS.CHECKOUT,\012      METHODS.MERGE,\012      METHODS[\042M-SEARCH\042],\012      METHODS.NOTIFY,\012      METHODS.SUBSCRIBE,\012      METHODS.UNSUBSCRIBE,\012      METHODS.PATCH,\012      METHODS.PURGE,\012      METHODS.MKCALENDAR,\012      METHODS.LINK,\012      METHODS.UNLINK,\012      METHODS.PRI,\012      // TODO(indutny): should we allow it with HTTP\077\012      METHODS.SOURCE\012    ];\012    exports2.METHODS_ICE = [\012      METHODS.SOURCE\012    ];\012    exports2.METHODS_RTSP = [\012      METHODS.OPTIONS,\012      METHODS.DESCRIBE,\012      METHODS.ANNOUNCE,\012      METHODS.SETUP,\012      METHODS.PLAY,\012      METHODS.PAUSE,\012      METHODS.TEARDOWN,\012      METHODS.GET_PARAMETER,\012      METHODS.SET_PARAMETER,\012      METHODS.REDIRECT,\012      METHODS.RECORD,\012      METHODS.FLUSH,\012      // For AirPlay\012      METHODS.GET,\012      METHODS.POST\012    ];\012    exports2.METHOD_MAP = utils_1.enumToMap(METHODS);\012    exports2.H_METHOD_MAP = {};\012    Object.keys(exports2.METHOD_MAP).forEach((key) => {\012      if (/^H/.test(key)) {\012        exports2.H_METHOD_MAP[key] = exports2.METHOD_MAP[key];\012      }\012    });\012    var FINISH;\012    (function(FINISH2) {\012      FINISH2[FINISH2[\042SAFE\042] = 0] = \042SAFE\042;\012      FINISH2[FINISH2[\042SAFE_WITH_CB\042] = 1] = \042SAFE_WITH_CB\042;\012      FINISH2[FINISH2[\042UNSAFE\042] = 2] = \042UNSAFE\042;\012    })(FINISH = exports2.FINISH || (exports2.FINISH = {}));\012    exports2.ALPHA = [];\012    for (let i = \042A\042.charCodeAt(0); i <= \042Z\042.charCodeAt(0); i++) {\012      exports2.ALPHA.push(String.fromCharCode(i));\012      exports2.ALPHA.push(String.fromCharCode(i + 32));\012    }\012    exports2.NUM_MAP = {\012      0: 0,\012      1: 1,\012      2: 2,\012      3: 3,\012      4: 4,\012      5: 5,\012      6: 6,\012      7: 7,\012      8: 8,\012      9: 9\012    };\012    exports2.HEX_MAP = {\012      0: 0,\012      1: 1,\012      2: 2,\012      3: 3,\012      4: 4,\012      5: 5,\012      6: 6,\012      7: 7,\012      8: 8,\012      9: 9,\012      A: 10,\012      B: 11,\012      C: 12,\012      D: 13,\012      E: 14,\012      F: 15,\012      a: 10,\012      b: 11,\012      c: 12,\012      d: 13,\012      e: 14,\012      f: 15\012    };\012    exports2.NUM = [\012      \0420\042,\012      \0421\042,\012      \0422\042,\012      \0423\042,\012      \0424\042,\012      \0425\042,\012      \0426\042,\012      \0427\042,\012      \0428\042,\012      \0429\042\012    ];\012    exports2.ALPHANUM = exports2.ALPHA.concat(exports2.NUM);\012    exports2.MARK = [\042-\042, \042_\042, \042.\042, \042!\042, \042~\042, \042*\042, \042'\042, \042(\042, \042)\042];\012    exports2.USERINFO_CHARS = exports2.ALPHANUM.concat(exports2.MARK).concat([\042%\042, \042;\042, \042:\042, \042&\042, \042=\042, \042+\042, \042$\042, \042,\042]);\012    exports2.STRICT_URL_CHAR = [\012      \042!\042,\012      '\042',\012      \042$\042,\012      \042%\042,\012      \042&\042,\012      \042'\042,\012      \042(\042,\012      \042)\042,\012      \042*\042,\012      \042+\042,\012      \042,\042,\012      \042-\042,\012      \042.\042,\012      \042/\042,\012      \042:\042,\012      \042;\042,\012      \042<\042,\012      \042=\042,\012      \042>\042,\012      \042@\042,\012      \042[\042,\012      \042\134\134\042,\012      \042]\042,\012      \042^\042,\012      \042_\042,\012      \042`\042,\012      \042{\042,\012      \042|\042,\012      \042}\042,\012      \042~\042\012    ].concat(exports2.ALPHANUM);\012    exports2.URL_CHAR = exports2.STRICT_URL_CHAR.concat([\042\011\042, \042\134f\042]);\012    for (let i = 128; i <= 255; i++) {\012      exports2.URL_CHAR.push(i);\012    }\012    exports2.HEX = exports2.NUM.concat([\042a\042, \042b\042, \042c\042, \042d\042, \042e\042, \042f\042, \042A\042, \042B\042, \042C\042, \042D\042, \042E\042, \042F\042]);\012    exports2.STRICT_TOKEN = [\012      \042!\042,\012      \042#\042,\012      \042$\042,\012      \042%\042,\012      \042&\042,\012      \042'\042,\012      \042*\042,\012      \042+\042,\012      \042-\042,\012      \042.\042,\012      \042^\042,\012      \042_\042,\012      \042`\042,\012      \042|\042,\012      \042~\042\012    ].concat(exports2.ALPHANUM);\012    exports2.TOKEN = exports2.STRICT_TOKEN.concat([\042 \042]);\012    exports2.HEADER_CHARS = [\042\011\042];\012    for (let i = 32; i <= 255; i++) {\012      if (i !== 127) {\012        exports2.HEADER_CHARS.push(i);\012      }\012    }\012    exports2.CONNECTION_TOKEN_CHARS = exports2.HEADER_CHARS.filter((c) => c !== 44);\012    exports2.MAJOR = exports2.NUM_MAP;\012    exports2.MINOR = exports2.MAJOR;\012    var HEADER_STATE;\012    (function(HEADER_STATE2) {\012      HEADER_STATE2[HEADER_STATE2[\042GENERAL\042] = 0] = \042GENERAL\042;\012      HEADER_STATE2[HEADER_STATE2[\042CONNECTION\042] = 1] = \042CONNECTION\042;\012      HEADER_STATE2[HEADER_STATE2[\042CONTENT_LENGTH\042] = 2] = \042CONTENT_LENGTH\042;\012      HEADER_STATE2[HEADER_STATE2[\042TRANSFER_ENCODING\042] = 3] = \042TRANSFER_ENCODING\042;\012      HEADER_STATE2[HEADER_STATE2[\042UPGRADE\042] = 4] = \042UPGRADE\042;\012      HEADER_STATE2[HEADER_STATE2[\042CONNECTION_KEEP_ALIVE\042] = 5] = \042CONNECTION_KEEP_ALIVE\042;\012      HEADER_STATE2[HEADER_STATE2[\042CONNECTION_CLOSE\042] = 6] = \042CONNECTION_CLOSE\042;\012      HEADER_STATE2[HEADER_STATE2[\042CONNECTION_UPGRADE\042] = 7] = \042CONNECTION_UPGRADE\042;\012      HEADER_STATE2[HEADER_STATE2[\042TRANSFER_ENCODING_CHUNKED\042] = 8] = \042TRANSFER_ENCODING_CHUNKED\042;\012    })(HEADER_STATE = exports2.HEADER_STATE || (exports2.HEADER_STATE = {}));\012    exports2.SPECIAL_HEADERS = {\012      \042connection\042: HEADER_STATE.CONNECTION,\012      \042content-length\042: HEADER_STATE.CONTENT_LENGTH,\012      \042proxy-connection\042: HEADER_STATE.CONNECTION,\012      \042transfer-encoding\042: HEADER_STATE.TRANSFER_ENCODING,\012      \042upgrade\042: HEADER_STATE.UPGRADE\012    };\012  }\012});\012\012// lib/llhttp/llhttp-wasm.js\012var require_llhttp_wasm = __commonJS({\012  \042lib/llhttp/llhttp-wasm.js\042(exports2, module2) {\012    \042use strict\042;\012    var { Buffer: Buffer2 } = require(\042node:buffer\042);\012    module2.exports = Buffer2.from(\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\042, \042base64\042);\012  }\012});\012\012// lib/llhttp/llhttp_simd-wasm.js\012var require_llhttp_simd_wasm = __commonJS({\012  \042lib/llhttp/llhttp_simd-wasm.js\042(exports2, module2) {\012    \042use strict\042;\012    var { Buffer: Buffer2 } = require(\042node:buffer\042);\012    module2.exports = Buffer2.from(\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\042, \042base64\042);\012  }\012});\012\012// lib/web/fetch/constants.js\012var require_constants3 = __commonJS({\012  \042lib/web/fetch/constants.js\042(exports2, module2) {\012    \042use strict\042;\012    var corsSafeListedMethods = (\012      /** @type {const} */\012      [\042GET\042, \042HEAD\042, \042POST\042]\012    );\012    var corsSafeListedMethodsSet = new Set(corsSafeListedMethods);\012    var nullBodyStatus = (\012      /** @type {const} */\012      [101, 204, 205, 304]\012    );\012    var redirectStatus = (\012      /** @type {const} */\012      [301, 302, 303, 307, 308]\012    );\012    var redirectStatusSet = new Set(redirectStatus);\012    var badPorts = (\012      /** @type {const} */\012      [\012        \0421\042,\012        \0427\042,\012        \0429\042,\012        \04211\042,\012        \04213\042,\012        \04215\042,\012        \04217\042,\012        \04219\042,\012        \04220\042,\012        \04221\042,\012        \04222\042,\012        \04223\042,\012        \04225\042,\012        \04237\042,\012        \04242\042,\012        \04243\042,\012        \04253\042,\012        \04269\042,\012        \04277\042,\012        \04279\042,\012        \04287\042,\012        \04295\042,\012        \042101\042,\012        \042102\042,\012        \042103\042,\012        \042104\042,\012        \042109\042,\012        \042110\042,\012        \042111\042,\012        \042113\042,\012        \042115\042,\012        \042117\042,\012        \042119\042,\012        \042123\042,\012        \042135\042,\012        \042137\042,\012        \042139\042,\012        \042143\042,\012        \042161\042,\012        \042179\042,\012        \042389\042,\012        \042427\042,\012        \042465\042,\012        \042512\042,\012        \042513\042,\012        \042514\042,\012        \042515\042,\012        \042526\042,\012        \042530\042,\012        \042531\042,\012        \042532\042,\012        \042540\042,\012        \042548\042,\012        \042554\042,\012        \042556\042,\012        \042563\042,\012        \042587\042,\012        \042601\042,\012        \042636\042,\012        \042989\042,\012        \042990\042,\012        \042993\042,\012        \042995\042,\012        \0421719\042,\012        \0421720\042,\012        \0421723\042,\012        \0422049\042,\012        \0423659\042,\012        \0424045\042,\012        \0424190\042,\012        \0425060\042,\012        \0425061\042,\012        \0426000\042,\012        \0426566\042,\012        \0426665\042,\012        \0426666\042,\012        \0426667\042,\012        \0426668\042,\012        \0426669\042,\012        \0426679\042,\012        \0426697\042,\012        \04210080\042\012      ]\012    );\012    var badPortsSet = new Set(badPorts);\012    var referrerPolicy = (\012      /** @type {const} */\012      [\012        \042\042,\012        \042no-referrer\042,\012        \042no-referrer-when-downgrade\042,\012        \042same-origin\042,\012        \042origin\042,\012        \042strict-origin\042,\012        \042origin-when-cross-origin\042,\012        \042strict-origin-when-cross-origin\042,\012        \042unsafe-url\042\012      ]\012    );\012    var referrerPolicySet = new Set(referrerPolicy);\012    var requestRedirect = (\012      /** @type {const} */\012      [\042follow\042, \042manual\042, \042error\042]\012    );\012    var safeMethods = (\012      /** @type {const} */\012      [\042GET\042, \042HEAD\042, \042OPTIONS\042, \042TRACE\042]\012    );\012    var safeMethodsSet = new Set(safeMethods);\012    var requestMode = (\012      /** @type {const} */\012      [\042navigate\042, \042same-origin\042, \042no-cors\042, \042cors\042]\012    );\012    var requestCredentials = (\012      /** @type {const} */\012      [\042omit\042, \042same-origin\042, \042include\042]\012    );\012    var requestCache = (\012      /** @type {const} */\012      [\012        \042default\042,\012        \042no-store\042,\012        \042reload\042,\012        \042no-cache\042,\012        \042force-cache\042,\012        \042only-if-cached\042\012      ]\012    );\012    var requestBodyHeader = (\012      /** @type {const} */\012      [\012        \042content-encoding\042,\012        \042content-language\042,\012        \042content-location\042,\012        \042content-type\042,\012        // See https://github.com/nodejs/undici/issues/2021\012        // 'Content-Length' is a forbidden header name, which is typically\012        // removed in the Headers implementation. However, undici doesn't\012        // filter out headers, so we add it here.\012        \042content-length\042\012      ]\012    );\012    var requestDuplex = (\012      /** @type {const} */\012      [\012        \042half\042\012      ]\012    );\012    var forbiddenMethods = (\012      /** @type {const} */\012      [\042CONNECT\042, \042TRACE\042, \042TRACK\042]\012    );\012    var forbiddenMethodsSet = new Set(forbiddenMethods);\012    var subresource = (\012      /** @type {const} */\012      [\012        \042audio\042,\012        \042audioworklet\042,\012        \042font\042,\012        \042image\042,\012        \042manifest\042,\012        \042paintworklet\042,\012        \042script\042,\012        \042style\042,\012        \042track\042,\012        \042video\042,\012        \042xslt\042,\012        \042\042\012      ]\012    );\012    var subresourceSet = new Set(subresource);\012    module2.exports = {\012      subresource,\012      forbiddenMethods,\012      requestBodyHeader,\012      referrerPolicy,\012      requestRedirect,\012      requestMode,\012      requestCredentials,\012      requestCache,\012      redirectStatus,\012      corsSafeListedMethods,\012      nullBodyStatus,\012      safeMethods,\012      badPorts,\012      requestDuplex,\012      subresourceSet,\012      badPortsSet,\012      redirectStatusSet,\012      corsSafeListedMethodsSet,\012      safeMethodsSet,\012      forbiddenMethodsSet,\012      referrerPolicySet\012    };\012  }\012});\012\012// lib/web/fetch/global.js\012var require_global = __commonJS({\012  \042lib/web/fetch/global.js\042(exports2, module2) {\012    \042use strict\042;\012    var globalOrigin = Symbol.for(\042undici.globalOrigin.1\042);\012    function getGlobalOrigin() {\012      return globalThis[globalOrigin];\012    }\012    __name(getGlobalOrigin, \042getGlobalOrigin\042);\012    function setGlobalOrigin(newOrigin) {\012      if (newOrigin === void 0) {\012        Object.defineProperty(globalThis, globalOrigin, {\012          value: void 0,\012          writable: true,\012          enumerable: false,\012          configurable: false\012        });\012        return;\012      }\012      const parsedURL = new URL(newOrigin);\012      if (parsedURL.protocol !== \042http:\042 && parsedURL.protocol !== \042https:\042) {\012        throw new TypeError(`Only http & https urls are allowed, received ${parsedURL.protocol}`);\012      }\012      Object.defineProperty(globalThis, globalOrigin, {\012        value: parsedURL,\012        writable: true,\012        enumerable: false,\012        configurable: false\012      });\012    }\012    __name(setGlobalOrigin, \042setGlobalOrigin\042);\012    module2.exports = {\012      getGlobalOrigin,\012      setGlobalOrigin\012    };\012  }\012});\012\012// lib/web/fetch/data-url.js\012var require_data_url = __commonJS({\012  \042lib/web/fetch/data-url.js\042(exports2, module2) {\012    \042use strict\042;\012    var assert = require(\042node:assert\042);\012    var encoder = new TextEncoder();\012    var HTTP_TOKEN_CODEPOINTS = /^[!#$%&'*+\134-.^_|~A-Za-z0-9]+$/;\012    var HTTP_WHITESPACE_REGEX = /[\134u000A\134u000D\134u0009\134u0020]/;\012    var ASCII_WHITESPACE_REPLACE_REGEX = /[\134u0009\134u000A\134u000C\134u000D\134u0020]/g;\012    var HTTP_QUOTED_STRING_TOKENS = /^[\134u0009\134u0020-\134u007E\134u0080-\134u00FF]+$/;\012    function dataURLProcessor(dataURL) {\012      assert(dataURL.protocol === \042data:\042);\012      let input = URLSerializer(dataURL, true);\012      input = input.slice(5);\012      const position = { position: 0 };\012      let mimeType = collectASequenceOfCodePointsFast(\012        \042,\042,\012        input,\012        position\012      );\012      const mimeTypeLength = mimeType.length;\012      mimeType = removeASCIIWhitespace(mimeType, true, true);\012      if (position.position >= input.length) {\012        return \042failure\042;\012      }\012      position.position++;\012      const encodedBody = input.slice(mimeTypeLength + 1);\012      let body = stringPercentDecode(encodedBody);\012      if (/;(\134u0020){0,}base64$/i.test(mimeType)) {\012        const stringBody = isomorphicDecode(body);\012        body = forgivingBase64(stringBody);\012        if (body === \042failure\042) {\012          return \042failure\042;\012        }\012        mimeType = mimeType.slice(0, -6);\012        mimeType = mimeType.replace(/(\134u0020)+$/, \042\042);\012        mimeType = mimeType.slice(0, -1);\012      }\012      if (mimeType.startsWith(\042;\042)) {\012        mimeType = \042text/plain\042 + mimeType;\012      }\012      let mimeTypeRecord = parseMIMEType(mimeType);\012      if (mimeTypeRecord === \042failure\042) {\012        mimeTypeRecord = parseMIMEType(\042text/plain;charset=US-ASCII\042);\012      }\012      return { mimeType: mimeTypeRecord, body };\012    }\012    __name(dataURLProcessor, \042dataURLProcessor\042);\012    function URLSerializer(url, excludeFragment = false) {\012      if (!excludeFragment) {\012        return url.href;\012      }\012      const href = url.href;\012      const hashLength = url.hash.length;\012      const serialized = hashLength === 0 \077 href : href.substring(0, href.length - hashLength);\012      if (!hashLength && href.endsWith(\042#\042)) {\012        return serialized.slice(0, -1);\012      }\012      return serialized;\012    }\012    __name(URLSerializer, \042URLSerializer\042);\012    function collectASequenceOfCodePoints(condition, input, position) {\012      let result = \042\042;\012      while (position.position < input.length && condition(input[position.position])) {\012        result += input[position.position];\012        position.position++;\012      }\012      return result;\012    }\012    __name(collectASequenceOfCodePoints, \042collectASequenceOfCodePoints\042);\012    function collectASequenceOfCodePointsFast(char, input, position) {\012      const idx = input.indexOf(char, position.position);\012      const start = position.position;\012      if (idx === -1) {\012        position.position = input.length;\012        return input.slice(start);\012      }\012      position.position = idx;\012      return input.slice(start, position.position);\012    }\012    __name(collectASequenceOfCodePointsFast, \042collectASequenceOfCodePointsFast\042);\012    function stringPercentDecode(input) {\012      const bytes = encoder.encode(input);\012      return percentDecode(bytes);\012    }\012    __name(stringPercentDecode, \042stringPercentDecode\042);\012    function isHexCharByte(byte) {\012      return byte >= 48 && byte <= 57 || byte >= 65 && byte <= 70 || byte >= 97 && byte <= 102;\012    }\012    __name(isHexCharByte, \042isHexCharByte\042);\012    function hexByteToNumber(byte) {\012      return (\012        // 0-9\012        byte >= 48 && byte <= 57 \077 byte - 48 : (byte & 223) - 55\012      );\012    }\012    __name(hexByteToNumber, \042hexByteToNumber\042);\012    function percentDecode(input) {\012      const length = input.length;\012      const output = new Uint8Array(length);\012      let j = 0;\012      for (let i = 0; i < length; ++i) {\012        const byte = input[i];\012        if (byte !== 37) {\012          output[j++] = byte;\012        } else if (byte === 37 && !(isHexCharByte(input[i + 1]) && isHexCharByte(input[i + 2]))) {\012          output[j++] = 37;\012        } else {\012          output[j++] = hexByteToNumber(input[i + 1]) << 4 | hexByteToNumber(input[i + 2]);\012          i += 2;\012        }\012      }\012      return length === j \077 output : output.subarray(0, j);\012    }\012    __name(percentDecode, \042percentDecode\042);\012    function parseMIMEType(input) {\012      input = removeHTTPWhitespace(input, true, true);\012      const position = { position: 0 };\012      const type = collectASequenceOfCodePointsFast(\012        \042/\042,\012        input,\012        position\012      );\012      if (type.length === 0 || !HTTP_TOKEN_CODEPOINTS.test(type)) {\012        return \042failure\042;\012      }\012      if (position.position > input.length) {\012        return \042failure\042;\012      }\012      position.position++;\012      let subtype = collectASequenceOfCodePointsFast(\012        \042;\042,\012        input,\012        position\012      );\012      subtype = removeHTTPWhitespace(subtype, false, true);\012      if (subtype.length === 0 || !HTTP_TOKEN_CODEPOINTS.test(subtype)) {\012        return \042failure\042;\012      }\012      const typeLowercase = type.toLowerCase();\012      const subtypeLowercase = subtype.toLowerCase();\012      const mimeType = {\012        type: typeLowercase,\012        subtype: subtypeLowercase,\012        /** @type {Map<string, string>} */\012        parameters: /* @__PURE__ */ new Map(),\012        // https://mimesniff.spec.whatwg.org/#mime-type-essence\012        essence: `${typeLowercase}/${subtypeLowercase}`\012      };\012      while (position.position < input.length) {\012        position.position++;\012        collectASequenceOfCodePoints(\012          // https://fetch.spec.whatwg.org/#http-whitespace\012          (char) => HTTP_WHITESPACE_REGEX.test(char),\012          input,\012          position\012        );\012        let parameterName = collectASequenceOfCodePoints(\012          (char) => char !== \042;\042 && char !== \042=\042,\012          input,\012          position\012        );\012        parameterName = parameterName.toLowerCase();\012        if (position.position < input.length) {\012          if (input[position.position] === \042;\042) {\012            continue;\012          }\012          position.position++;\012        }\012        if (position.position > input.length) {\012          break;\012        }\012        let parameterValue = null;\012        if (input[position.position] === '\042') {\012          parameterValue = collectAnHTTPQuotedString(input, position, true);\012          collectASequenceOfCodePointsFast(\012            \042;\042,\012            input,\012            position\012          );\012        } else {\012          parameterValue = collectASequenceOfCodePointsFast(\012            \042;\042,\012            input,\012            position\012          );\012          parameterValue = removeHTTPWhitespace(parameterValue, false, true);\012          if (parameterValue.length === 0) {\012            continue;\012          }\012        }\012        if (parameterName.length !== 0 && HTTP_TOKEN_CODEPOINTS.test(parameterName) && (parameterValue.length === 0 || HTTP_QUOTED_STRING_TOKENS.test(parameterValue)) && !mimeType.parameters.has(parameterName)) {\012          mimeType.parameters.set(parameterName, parameterValue);\012        }\012      }\012      return mimeType;\012    }\012    __name(parseMIMEType, \042parseMIMEType\042);\012    function forgivingBase64(data) {\012      data = data.replace(ASCII_WHITESPACE_REPLACE_REGEX, \042\042);\012      let dataLength = data.length;\012      if (dataLength % 4 === 0) {\012        if (data.charCodeAt(dataLength - 1) === 61) {\012          --dataLength;\012          if (data.charCodeAt(dataLength - 1) === 61) {\012            --dataLength;\012          }\012        }\012      }\012      if (dataLength % 4 === 1) {\012        return \042failure\042;\012      }\012      if (/[^+/0-9A-Za-z]/.test(data.length === dataLength \077 data : data.substring(0, dataLength))) {\012        return \042failure\042;\012      }\012      const buffer = Buffer.from(data, \042base64\042);\012      return new Uint8Array(buffer.buffer, buffer.byteOffset, buffer.byteLength);\012    }\012    __name(forgivingBase64, \042forgivingBase64\042);\012    function collectAnHTTPQuotedString(input, position, extractValue) {\012      const positionStart = position.position;\012      let value = \042\042;\012      assert(input[position.position] === '\042');\012      position.position++;\012      while (true) {\012        value += collectASequenceOfCodePoints(\012          (char) => char !== '\042' && char !== \042\134\134\042,\012          input,\012          position\012        );\012        if (position.position >= input.length) {\012          break;\012        }\012        const quoteOrBackslash = input[position.position];\012        position.position++;\012        if (quoteOrBackslash === \042\134\134\042) {\012          if (position.position >= input.length) {\012            value += \042\134\134\042;\012            break;\012          }\012          value += input[position.position];\012          position.position++;\012        } else {\012          assert(quoteOrBackslash === '\042');\012          break;\012        }\012      }\012      if (extractValue) {\012        return value;\012      }\012      return input.slice(positionStart, position.position);\012    }\012    __name(collectAnHTTPQuotedString, \042collectAnHTTPQuotedString\042);\012    function serializeAMimeType(mimeType) {\012      assert(mimeType !== \042failure\042);\012      const { parameters, essence } = mimeType;\012      let serialization = essence;\012      for (let [name, value] of parameters.entries()) {\012        serialization += \042;\042;\012        serialization += name;\012        serialization += \042=\042;\012        if (!HTTP_TOKEN_CODEPOINTS.test(value)) {\012          value = value.replace(/(\134\134|\042)/g, \042\134\134$1\042);\012          value = '\042' + value;\012          value += '\042';\012        }\012        serialization += value;\012      }\012      return serialization;\012    }\012    __name(serializeAMimeType, \042serializeAMimeType\042);\012    function isHTTPWhiteSpace(char) {\012      return char === 13 || char === 10 || char === 9 || char === 32;\012    }\012    __name(isHTTPWhiteSpace, \042isHTTPWhiteSpace\042);\012    function removeHTTPWhitespace(str, leading = true, trailing = true) {\012      return removeChars(str, leading, trailing, isHTTPWhiteSpace);\012    }\012    __name(removeHTTPWhitespace, \042removeHTTPWhitespace\042);\012    function isASCIIWhitespace(char) {\012      return char === 13 || char === 10 || char === 9 || char === 12 || char === 32;\012    }\012    __name(isASCIIWhitespace, \042isASCIIWhitespace\042);\012    function removeASCIIWhitespace(str, leading = true, trailing = true) {\012      return removeChars(str, leading, trailing, isASCIIWhitespace);\012    }\012    __name(removeASCIIWhitespace, \042removeASCIIWhitespace\042);\012    function removeChars(str, leading, trailing, predicate) {\012      let lead = 0;\012      let trail = str.length - 1;\012      if (leading) {\012        while (lead < str.length && predicate(str.charCodeAt(lead)))\012          lead++;\012      }\012      if (trailing) {\012        while (trail > 0 && predicate(str.charCodeAt(trail)))\012          trail--;\012      }\012      return lead === 0 && trail === str.length - 1 \077 str : str.slice(lead, trail + 1);\012    }\012    __name(removeChars, \042removeChars\042);\012    function isomorphicDecode(input) {\012      const length = input.length;\012      if ((2 << 15) - 1 > length) {\012        return String.fromCharCode.apply(null, input);\012      }\012      let result = \042\042;\012      let i = 0;\012      let addition = (2 << 15) - 1;\012      while (i < length) {\012        if (i + addition > length) {\012          addition = length - i;\012        }\012        result += String.fromCharCode.apply(null, input.subarray(i, i += addition));\012      }\012      return result;\012    }\012    __name(isomorphicDecode, \042isomorphicDecode\042);\012    function minimizeSupportedMimeType(mimeType) {\012      switch (mimeType.essence) {\012        case \042application/ecmascript\042:\012        case \042application/javascript\042:\012        case \042application/x-ecmascript\042:\012        case \042application/x-javascript\042:\012        case \042text/ecmascript\042:\012        case \042text/javascript\042:\012        case \042text/javascript1.0\042:\012        case \042text/javascript1.1\042:\012        case \042text/javascript1.2\042:\012        case \042text/javascript1.3\042:\012        case \042text/javascript1.4\042:\012        case \042text/javascript1.5\042:\012        case \042text/jscript\042:\012        case \042text/livescript\042:\012        case \042text/x-ecmascript\042:\012        case \042text/x-javascript\042:\012          return \042text/javascript\042;\012        case \042application/json\042:\012        case \042text/json\042:\012          return \042application/json\042;\012        case \042image/svg+xml\042:\012          return \042image/svg+xml\042;\012        case \042text/xml\042:\012        case \042application/xml\042:\012          return \042application/xml\042;\012      }\012      if (mimeType.subtype.endsWith(\042+json\042)) {\012        return \042application/json\042;\012      }\012      if (mimeType.subtype.endsWith(\042+xml\042)) {\012        return \042application/xml\042;\012      }\012      return \042\042;\012    }\012    __name(minimizeSupportedMimeType, \042minimizeSupportedMimeType\042);\012    module2.exports = {\012      dataURLProcessor,\012      URLSerializer,\012      collectASequenceOfCodePoints,\012      collectASequenceOfCodePointsFast,\012      stringPercentDecode,\012      parseMIMEType,\012      collectAnHTTPQuotedString,\012      serializeAMimeType,\012      removeChars,\012      removeHTTPWhitespace,\012      minimizeSupportedMimeType,\012      HTTP_TOKEN_CODEPOINTS,\012      isomorphicDecode\012    };\012  }\012});\012\012// lib/web/fetch/webidl.js\012var require_webidl = __commonJS({\012  \042lib/web/fetch/webidl.js\042(exports2, module2) {\012    \042use strict\042;\012    var { types, inspect } = require(\042node:util\042);\012    var { markAsUncloneable } = require(\042node:worker_threads\042);\012    var { toUSVString } = require_util();\012    var webidl = {};\012    webidl.converters = {};\012    webidl.util = {};\012    webidl.errors = {};\012    webidl.errors.exception = function(message) {\012      return new TypeError(`${message.header}: ${message.message}`);\012    };\012    webidl.errors.conversionFailed = function(context) {\012      const plural = context.types.length === 1 \077 \042\042 : \042 one of\042;\012      const message = `${context.argument} could not be converted to${plural}: ${context.types.join(\042, \042)}.`;\012      return webidl.errors.exception({\012        header: context.prefix,\012        message\012      });\012    };\012    webidl.errors.invalidArgument = function(context) {\012      return webidl.errors.exception({\012        header: context.prefix,\012        message: `\042${context.value}\042 is an invalid ${context.type}.`\012      });\012    };\012    webidl.brandCheck = function(V, I, opts) {\012      if (opts\077.strict !== false) {\012        if (!(V instanceof I)) {\012          const err = new TypeError(\042Illegal invocation\042);\012          err.code = \042ERR_INVALID_THIS\042;\012          throw err;\012        }\012      } else {\012        if (V\077.[Symbol.toStringTag] !== I.prototype[Symbol.toStringTag]) {\012          const err = new TypeError(\042Illegal invocation\042);\012          err.code = \042ERR_INVALID_THIS\042;\012          throw err;\012        }\012      }\012    };\012    webidl.argumentLengthCheck = function({ length }, min, ctx) {\012      if (length < min) {\012        throw webidl.errors.exception({\012          message: `${min} argument${min !== 1 \077 \042s\042 : \042\042} required, but${length \077 \042 only\042 : \042\042} ${length} found.`,\012          header: ctx\012        });\012      }\012    };\012    webidl.illegalConstructor = function() {\012      throw webidl.errors.exception({\012        header: \042TypeError\042,\012        message: \042Illegal constructor\042\012      });\012    };\012    webidl.util.Type = function(V) {\012      switch (typeof V) {\012        case \042undefined\042:\012          return \042Undefined\042;\012        case \042boolean\042:\012          return \042Boolean\042;\012        case \042string\042:\012          return \042String\042;\012        case \042symbol\042:\012          return \042Symbol\042;\012        case \042number\042:\012          return \042Number\042;\012        case \042bigint\042:\012          return \042BigInt\042;\012        case \042function\042:\012        case \042object\042: {\012          if (V === null) {\012            return \042Null\042;\012          }\012          return \042Object\042;\012        }\012      }\012    };\012    webidl.util.markAsUncloneable = markAsUncloneable || (() => {\012    });\012    webidl.util.ConvertToInt = function(V, bitLength, signedness, opts) {\012      let upperBound;\012      let lowerBound;\012      if (bitLength === 64) {\012        upperBound = Math.pow(2, 53) - 1;\012        if (signedness === \042unsigned\042) {\012          lowerBound = 0;\012        } else {\012          lowerBound = Math.pow(-2, 53) + 1;\012        }\012      } else if (signedness === \042unsigned\042) {\012        lowerBound = 0;\012        upperBound = Math.pow(2, bitLength) - 1;\012      } else {\012        lowerBound = Math.pow(-2, bitLength) - 1;\012        upperBound = Math.pow(2, bitLength - 1) - 1;\012      }\012      let x = Number(V);\012      if (x === 0) {\012        x = 0;\012      }\012      if (opts\077.enforceRange === true) {\012        if (Number.isNaN(x) || x === Number.POSITIVE_INFINITY || x === Number.NEGATIVE_INFINITY) {\012          throw webidl.errors.exception({\012            header: \042Integer conversion\042,\012            message: `Could not convert ${webidl.util.Stringify(V)} to an integer.`\012          });\012        }\012        x = webidl.util.IntegerPart(x);\012        if (x < lowerBound || x > upperBound) {\012          throw webidl.errors.exception({\012            header: \042Integer conversion\042,\012            message: `Value must be between ${lowerBound}-${upperBound}, got ${x}.`\012          });\012        }\012        return x;\012      }\012      if (!Number.isNaN(x) && opts\077.clamp === true) {\012        x = Math.min(Math.max(x, lowerBound), upperBound);\012        if (Math.floor(x) % 2 === 0) {\012          x = Math.floor(x);\012        } else {\012          x = Math.ceil(x);\012        }\012        return x;\012      }\012      if (Number.isNaN(x) || x === 0 && Object.is(0, x) || x === Number.POSITIVE_INFINITY || x === Number.NEGATIVE_INFINITY) {\012        return 0;\012      }\012      x = webidl.util.IntegerPart(x);\012      x = x % Math.pow(2, bitLength);\012      if (signedness === \042signed\042 && x >= Math.pow(2, bitLength) - 1) {\012        return x - Math.pow(2, bitLength);\012      }\012      return x;\012    };\012    webidl.util.IntegerPart = function(n) {\012      const r = Math.floor(Math.abs(n));\012      if (n < 0) {\012        return -1 * r;\012      }\012      return r;\012    };\012    webidl.util.Stringify = function(V) {\012      const type = webidl.util.Type(V);\012      switch (type) {\012        case \042Symbol\042:\012          return `Symbol(${V.description})`;\012        case \042Object\042:\012          return inspect(V);\012        case \042String\042:\012          return `\042${V}\042`;\012        default:\012          return `${V}`;\012      }\012    };\012    webidl.sequenceConverter = function(converter) {\012      return (V, prefix, argument, Iterable) => {\012        if (webidl.util.Type(V) !== \042Object\042) {\012          throw webidl.errors.exception({\012            header: prefix,\012            message: `${argument} (${webidl.util.Stringify(V)}) is not iterable.`\012          });\012        }\012        const method = typeof Iterable === \042function\042 \077 Iterable() : V\077.[Symbol.iterator]\077.();\012        const seq = [];\012        let index = 0;\012        if (method === void 0 || typeof method.next !== \042function\042) {\012          throw webidl.errors.exception({\012            header: prefix,\012            message: `${argument} is not iterable.`\012          });\012        }\012        while (true) {\012          const { done, value } = method.next();\012          if (done) {\012            break;\012          }\012          seq.push(converter(value, prefix, `${argument}[${index++}]`));\012        }\012        return seq;\012      };\012    };\012    webidl.recordConverter = function(keyConverter, valueConverter) {\012      return (O, prefix, argument) => {\012        if (webidl.util.Type(O) !== \042Object\042) {\012          throw webidl.errors.exception({\012            header: prefix,\012            message: `${argument} (\042${webidl.util.Type(O)}\042) is not an Object.`\012          });\012        }\012        const result = {};\012        if (!types.isProxy(O)) {\012          const keys2 = [...Object.getOwnPropertyNames(O), ...Object.getOwnPropertySymbols(O)];\012          for (const key of keys2) {\012            const typedKey = keyConverter(key, prefix, argument);\012            const typedValue = valueConverter(O[key], prefix, argument);\012            result[typedKey] = typedValue;\012          }\012          return result;\012        }\012        const keys = Reflect.ownKeys(O);\012        for (const key of keys) {\012          const desc = Reflect.getOwnPropertyDescriptor(O, key);\012          if (desc\077.enumerable) {\012            const typedKey = keyConverter(key, prefix, argument);\012            const typedValue = valueConverter(O[key], prefix, argument);\012            result[typedKey] = typedValue;\012          }\012        }\012        return result;\012      };\012    };\012    webidl.interfaceConverter = function(i) {\012      return (V, prefix, argument, opts) => {\012        if (opts\077.strict !== false && !(V instanceof i)) {\012          throw webidl.errors.exception({\012            header: prefix,\012            message: `Expected ${argument} (\042${webidl.util.Stringify(V)}\042) to be an instance of ${i.name}.`\012          });\012        }\012        return V;\012      };\012    };\012    webidl.dictionaryConverter = function(converters) {\012      return (dictionary, prefix, argument) => {\012        const type = webidl.util.Type(dictionary);\012        const dict = {};\012        if (type === \042Null\042 || type === \042Undefined\042) {\012          return dict;\012        } else if (type !== \042Object\042) {\012          throw webidl.errors.exception({\012            header: prefix,\012            message: `Expected ${dictionary} to be one of: Null, Undefined, Object.`\012          });\012        }\012        for (const options of converters) {\012          const { key, defaultValue, required, converter } = options;\012          if (required === true) {\012            if (!Object.hasOwn(dictionary, key)) {\012              throw webidl.errors.exception({\012                header: prefix,\012                message: `Missing required key \042${key}\042.`\012              });\012            }\012          }\012          let value = dictionary[key];\012          const hasDefault = Object.hasOwn(options, \042defaultValue\042);\012          if (hasDefault && value !== null) {\012            value \077\077= defaultValue();\012          }\012          if (required || hasDefault || value !== void 0) {\012            value = converter(value, prefix, `${argument}.${key}`);\012            if (options.allowedValues && !options.allowedValues.includes(value)) {\012              throw webidl.errors.exception({\012                header: prefix,\012                message: `${value} is not an accepted type. Expected one of ${options.allowedValues.join(\042, \042)}.`\012              });\012            }\012            dict[key] = value;\012          }\012        }\012        return dict;\012      };\012    };\012    webidl.nullableConverter = function(converter) {\012      return (V, prefix, argument) => {\012        if (V === null) {\012          return V;\012        }\012        return converter(V, prefix, argument);\012      };\012    };\012    webidl.converters.DOMString = function(V, prefix, argument, opts) {\012      if (V === null && opts\077.legacyNullToEmptyString) {\012        return \042\042;\012      }\012      if (typeof V === \042symbol\042) {\012        throw webidl.errors.exception({\012          header: prefix,\012          message: `${argument} is a symbol, which cannot be converted to a DOMString.`\012        });\012      }\012      return String(V);\012    };\012    webidl.converters.ByteString = function(V, prefix, argument) {\012      const x = webidl.converters.DOMString(V, prefix, argument);\012      for (let index = 0; index < x.length; index++) {\012        if (x.charCodeAt(index) > 255) {\012          throw new TypeError(\012            `Cannot convert argument to a ByteString because the character at index ${index} has a value of ${x.charCodeAt(index)} which is greater than 255.`\012          );\012        }\012      }\012      return x;\012    };\012    webidl.converters.USVString = toUSVString;\012    webidl.converters.boolean = function(V) {\012      const x = Boolean(V);\012      return x;\012    };\012    webidl.converters.any = function(V) {\012      return V;\012    };\012    webidl.converters[\042long long\042] = function(V, prefix, argument) {\012      const x = webidl.util.ConvertToInt(V, 64, \042signed\042, void 0, prefix, argument);\012      return x;\012    };\012    webidl.converters[\042unsigned long long\042] = function(V, prefix, argument) {\012      const x = webidl.util.ConvertToInt(V, 64, \042unsigned\042, void 0, prefix, argument);\012      return x;\012    };\012    webidl.converters[\042unsigned long\042] = function(V, prefix, argument) {\012      const x = webidl.util.ConvertToInt(V, 32, \042unsigned\042, void 0, prefix, argument);\012      return x;\012    };\012    webidl.converters[\042unsigned short\042] = function(V, prefix, argument, opts) {\012      const x = webidl.util.ConvertToInt(V, 16, \042unsigned\042, opts, prefix, argument);\012      return x;\012    };\012    webidl.converters.ArrayBuffer = function(V, prefix, argument, opts) {\012      if (webidl.util.Type(V) !== \042Object\042 || !types.isAnyArrayBuffer(V)) {\012        throw webidl.errors.conversionFailed({\012          prefix,\012          argument: `${argument} (\042${webidl.util.Stringify(V)}\042)`,\012          types: [\042ArrayBuffer\042]\012        });\012      }\012      if (opts\077.allowShared === false && types.isSharedArrayBuffer(V)) {\012        throw webidl.errors.exception({\012          header: \042ArrayBuffer\042,\012          message: \042SharedArrayBuffer is not allowed.\042\012        });\012      }\012      if (V.resizable || V.growable) {\012        throw webidl.errors.exception({\012          header: \042ArrayBuffer\042,\012          message: \042Received a resizable ArrayBuffer.\042\012        });\012      }\012      return V;\012    };\012    webidl.converters.TypedArray = function(V, T, prefix, name, opts) {\012      if (webidl.util.Type(V) !== \042Object\042 || !types.isTypedArray(V) || V.constructor.name !== T.name) {\012        throw webidl.errors.conversionFailed({\012          prefix,\012          argument: `${name} (\042${webidl.util.Stringify(V)}\042)`,\012          types: [T.name]\012        });\012      }\012      if (opts\077.allowShared === false && types.isSharedArrayBuffer(V.buffer)) {\012        throw webidl.errors.exception({\012          header: \042ArrayBuffer\042,\012          message: \042SharedArrayBuffer is not allowed.\042\012        });\012      }\012      if (V.buffer.resizable || V.buffer.growable) {\012        throw webidl.errors.exception({\012          header: \042ArrayBuffer\042,\012          message: \042Received a resizable ArrayBuffer.\042\012        });\012      }\012      return V;\012    };\012    webidl.converters.DataView = function(V, prefix, name, opts) {\012      if (webidl.util.Type(V) !== \042Object\042 || !types.isDataView(V)) {\012        throw webidl.errors.exception({\012          header: prefix,\012          message: `${name} is not a DataView.`\012        });\012      }\012      if (opts\077.allowShared === false && types.isSharedArrayBuffer(V.buffer)) {\012        throw webidl.errors.exception({\012          header: \042ArrayBuffer\042,\012          message: \042SharedArrayBuffer is not allowed.\042\012        });\012      }\012      if (V.buffer.resizable || V.buffer.growable) {\012        throw webidl.errors.exception({\012          header: \042ArrayBuffer\042,\012          message: \042Received a resizable ArrayBuffer.\042\012        });\012      }\012      return V;\012    };\012    webidl.converters.BufferSource = function(V, prefix, name, opts) {\012      if (types.isAnyArrayBuffer(V)) {\012        return webidl.converters.ArrayBuffer(V, prefix, name, { ...opts, allowShared: false });\012      }\012      if (types.isTypedArray(V)) {\012        return webidl.converters.TypedArray(V, V.constructor, prefix, name, { ...opts, allowShared: false });\012      }\012      if (types.isDataView(V)) {\012        return webidl.converters.DataView(V, prefix, name, { ...opts, allowShared: false });\012      }\012      throw webidl.errors.conversionFailed({\012        prefix,\012        argument: `${name} (\042${webidl.util.Stringify(V)}\042)`,\012        types: [\042BufferSource\042]\012      });\012    };\012    webidl.converters[\042sequence<ByteString>\042] = webidl.sequenceConverter(\012      webidl.converters.ByteString\012    );\012    webidl.converters[\042sequence<sequence<ByteString>>\042] = webidl.sequenceConverter(\012      webidl.converters[\042sequence<ByteString>\042]\012    );\012    webidl.converters[\042record<ByteString, ByteString>\042] = webidl.recordConverter(\012      webidl.converters.ByteString,\012      webidl.converters.ByteString\012    );\012    module2.exports = {\012      webidl\012    };\012  }\012});\012\012// lib/web/fetch/util.js\012var require_util2 = __commonJS({\012  \042lib/web/fetch/util.js\042(exports2, module2) {\012    \042use strict\042;\012    var { Transform } = require(\042node:stream\042);\012    var zlib = require(\042node:zlib\042);\012    var { redirectStatusSet, referrerPolicySet: referrerPolicyTokens, badPortsSet } = require_constants3();\012    var { getGlobalOrigin } = require_global();\012    var { collectASequenceOfCodePoints, collectAnHTTPQuotedString, removeChars, parseMIMEType } = require_data_url();\012    var { performance: performance2 } = require(\042node:perf_hooks\042);\012    var { isBlobLike, ReadableStreamFrom, isValidHTTPToken, normalizedMethodRecordsBase } = require_util();\012    var assert = require(\042node:assert\042);\012    var { isUint8Array } = require(\042node:util/types\042);\012    var { webidl } = require_webidl();\012    var supportedHashes = [];\012    var crypto;\012    try {\012      crypto = require(\042node:crypto\042);\012      const possibleRelevantHashes = [\042sha256\042, \042sha384\042, \042sha512\042];\012      supportedHashes = crypto.getHashes().filter((hash) => possibleRelevantHashes.includes(hash));\012    } catch {\012    }\012    function responseURL(response) {\012      const urlList = response.urlList;\012      const length = urlList.length;\012      return length === 0 \077 null : urlList[length - 1].toString();\012    }\012    __name(responseURL, \042responseURL\042);\012    function responseLocationURL(response, requestFragment) {\012      if (!redirectStatusSet.has(response.status)) {\012        return null;\012      }\012      let location = response.headersList.get(\042location\042, true);\012      if (location !== null && isValidHeaderValue(location)) {\012        if (!isValidEncodedURL(location)) {\012          location = normalizeBinaryStringToUtf8(location);\012        }\012        location = new URL(location, responseURL(response));\012      }\012      if (location && !location.hash) {\012        location.hash = requestFragment;\012      }\012      return location;\012    }\012    __name(responseLocationURL, \042responseLocationURL\042);\012    function isValidEncodedURL(url) {\012      for (let i = 0; i < url.length; ++i) {\012        const code = url.charCodeAt(i);\012        if (code > 126 || // Non-US-ASCII + DEL\012        code < 32) {\012          return false;\012        }\012      }\012      return true;\012    }\012    __name(isValidEncodedURL, \042isValidEncodedURL\042);\012    function normalizeBinaryStringToUtf8(value) {\012      return Buffer.from(value, \042binary\042).toString(\042utf8\042);\012    }\012    __name(normalizeBinaryStringToUtf8, \042normalizeBinaryStringToUtf8\042);\012    function requestCurrentURL(request) {\012      return request.urlList[request.urlList.length - 1];\012    }\012    __name(requestCurrentURL, \042requestCurrentURL\042);\012    function requestBadPort(request) {\012      const url = requestCurrentURL(request);\012      if (urlIsHttpHttpsScheme(url) && badPortsSet.has(url.port)) {\012        return \042blocked\042;\012      }\012      return \042allowed\042;\012    }\012    __name(requestBadPort, \042requestBadPort\042);\012    function isErrorLike(object) {\012      return object instanceof Error || (object\077.constructor\077.name === \042Error\042 || object\077.constructor\077.name === \042DOMException\042);\012    }\012    __name(isErrorLike, \042isErrorLike\042);\012    function isValidReasonPhrase(statusText) {\012      for (let i = 0; i < statusText.length; ++i) {\012        const c = statusText.charCodeAt(i);\012        if (!(c === 9 || // HTAB\012        c >= 32 && c <= 126 || // SP / VCHAR\012        c >= 128 && c <= 255)) {\012          return false;\012        }\012      }\012      return true;\012    }\012    __name(isValidReasonPhrase, \042isValidReasonPhrase\042);\012    var isValidHeaderName = isValidHTTPToken;\012    function isValidHeaderValue(potentialValue) {\012      return (potentialValue[0] === \042\011\042 || potentialValue[0] === \042 \042 || potentialValue[potentialValue.length - 1] === \042\011\042 || potentialValue[potentialValue.length - 1] === \042 \042 || potentialValue.includes(\042\134n\042) || potentialValue.includes(\042\134r\042) || potentialValue.includes(\042\1340\042)) === false;\012    }\012    __name(isValidHeaderValue, \042isValidHeaderValue\042);\012    function setRequestReferrerPolicyOnRedirect(request, actualResponse) {\012      const { headersList } = actualResponse;\012      const policyHeader = (headersList.get(\042referrer-policy\042, true) \077\077 \042\042).split(\042,\042);\012      let policy = \042\042;\012      if (policyHeader.length > 0) {\012        for (let i = policyHeader.length; i !== 0; i--) {\012          const token = policyHeader[i - 1].trim();\012          if (referrerPolicyTokens.has(token)) {\012            policy = token;\012            break;\012          }\012        }\012      }\012      if (policy !== \042\042) {\012        request.referrerPolicy = policy;\012      }\012    }\012    __name(setRequestReferrerPolicyOnRedirect, \042setRequestReferrerPolicyOnRedirect\042);\012    function crossOriginResourcePolicyCheck() {\012      return \042allowed\042;\012    }\012    __name(crossOriginResourcePolicyCheck, \042crossOriginResourcePolicyCheck\042);\012    function corsCheck() {\012      return \042success\042;\012    }\012    __name(corsCheck, \042corsCheck\042);\012    function TAOCheck() {\012      return \042success\042;\012    }\012    __name(TAOCheck, \042TAOCheck\042);\012    function appendFetchMetadata(httpRequest) {\012      let header = null;\012      header = httpRequest.mode;\012      httpRequest.headersList.set(\042sec-fetch-mode\042, header, true);\012    }\012    __name(appendFetchMetadata, \042appendFetchMetadata\042);\012    function appendRequestOriginHeader(request) {\012      let serializedOrigin = request.origin;\012      if (serializedOrigin === \042client\042 || serializedOrigin === void 0) {\012        return;\012      }\012      if (request.responseTainting === \042cors\042 || request.mode === \042websocket\042) {\012        request.headersList.append(\042origin\042, serializedOrigin, true);\012      } else if (request.method !== \042GET\042 && request.method !== \042HEAD\042) {\012        switch (request.referrerPolicy) {\012          case \042no-referrer\042:\012            serializedOrigin = null;\012            break;\012          case \042no-referrer-when-downgrade\042:\012          case \042strict-origin\042:\012          case \042strict-origin-when-cross-origin\042:\012            if (request.origin && urlHasHttpsScheme(request.origin) && !urlHasHttpsScheme(requestCurrentURL(request))) {\012              serializedOrigin = null;\012            }\012            break;\012          case \042same-origin\042:\012            if (!sameOrigin(request, requestCurrentURL(request))) {\012              serializedOrigin = null;\012            }\012            break;\012          default:\012        }\012        request.headersList.append(\042origin\042, serializedOrigin, true);\012      }\012    }\012    __name(appendRequestOriginHeader, \042appendRequestOriginHeader\042);\012    function coarsenTime(timestamp, crossOriginIsolatedCapability) {\012      return timestamp;\012    }\012    __name(coarsenTime, \042coarsenTime\042);\012    function clampAndCoarsenConnectionTimingInfo(connectionTimingInfo, defaultStartTime, crossOriginIsolatedCapability) {\012      if (!connectionTimingInfo\077.startTime || connectionTimingInfo.startTime < defaultStartTime) {\012        return {\012          domainLookupStartTime: defaultStartTime,\012          domainLookupEndTime: defaultStartTime,\012          connectionStartTime: defaultStartTime,\012          connectionEndTime: defaultStartTime,\012          secureConnectionStartTime: defaultStartTime,\012          ALPNNegotiatedProtocol: connectionTimingInfo\077.ALPNNegotiatedProtocol\012        };\012      }\012      return {\012        domainLookupStartTime: coarsenTime(connectionTimingInfo.domainLookupStartTime, crossOriginIsolatedCapability),\012        domainLookupEndTime: coarsenTime(connectionTimingInfo.domainLookupEndTime, crossOriginIsolatedCapability),\012        connectionStartTime: coarsenTime(connectionTimingInfo.connectionStartTime, crossOriginIsolatedCapability),\012        connectionEndTime: coarsenTime(connectionTimingInfo.connectionEndTime, crossOriginIsolatedCapability),\012        secureConnectionStartTime: coarsenTime(connectionTimingInfo.secureConnectionStartTime, crossOriginIsolatedCapability),\012        ALPNNegotiatedProtocol: connectionTimingInfo.ALPNNegotiatedProtocol\012      };\012    }\012    __name(clampAndCoarsenConnectionTimingInfo, \042clampAndCoarsenConnectionTimingInfo\042);\012    function coarsenedSharedCurrentTime(crossOriginIsolatedCapability) {\012      return coarsenTime(performance2.now(), crossOriginIsolatedCapability);\012    }\012    __name(coarsenedSharedCurrentTime, \042coarsenedSharedCurrentTime\042);\012    function createOpaqueTimingInfo(timingInfo) {\012      return {\012        startTime: timingInfo.startTime \077\077 0,\012        redirectStartTime: 0,\012        redirectEndTime: 0,\012        postRedirectStartTime: timingInfo.startTime \077\077 0,\012        finalServiceWorkerStartTime: 0,\012        finalNetworkResponseStartTime: 0,\012        finalNetworkRequestStartTime: 0,\012        endTime: 0,\012        encodedBodySize: 0,\012        decodedBodySize: 0,\012        finalConnectionTimingInfo: null\012      };\012    }\012    __name(createOpaqueTimingInfo, \042createOpaqueTimingInfo\042);\012    function makePolicyContainer() {\012      return {\012        referrerPolicy: \042strict-origin-when-cross-origin\042\012      };\012    }\012    __name(makePolicyContainer, \042makePolicyContainer\042);\012    function clonePolicyContainer(policyContainer) {\012      return {\012        referrerPolicy: policyContainer.referrerPolicy\012      };\012    }\012    __name(clonePolicyContainer, \042clonePolicyContainer\042);\012    function determineRequestsReferrer(request) {\012      const policy = request.referrerPolicy;\012      assert(policy);\012      let referrerSource = null;\012      if (request.referrer === \042client\042) {\012        const globalOrigin = getGlobalOrigin();\012        if (!globalOrigin || globalOrigin.origin === \042null\042) {\012          return \042no-referrer\042;\012        }\012        referrerSource = new URL(globalOrigin);\012      } else if (request.referrer instanceof URL) {\012        referrerSource = request.referrer;\012      }\012      let referrerURL = stripURLForReferrer(referrerSource);\012      const referrerOrigin = stripURLForReferrer(referrerSource, true);\012      if (referrerURL.toString().length > 4096) {\012        referrerURL = referrerOrigin;\012      }\012      const areSameOrigin = sameOrigin(request, referrerURL);\012      const isNonPotentiallyTrustWorthy = isURLPotentiallyTrustworthy(referrerURL) && !isURLPotentiallyTrustworthy(request.url);\012      switch (policy) {\012        case \042origin\042:\012          return referrerOrigin != null \077 referrerOrigin : stripURLForReferrer(referrerSource, true);\012        case \042unsafe-url\042:\012          return referrerURL;\012        case \042same-origin\042:\012          return areSameOrigin \077 referrerOrigin : \042no-referrer\042;\012        case \042origin-when-cross-origin\042:\012          return areSameOrigin \077 referrerURL : referrerOrigin;\012        case \042strict-origin-when-cross-origin\042: {\012          const currentURL = requestCurrentURL(request);\012          if (sameOrigin(referrerURL, currentURL)) {\012            return referrerURL;\012          }\012          if (isURLPotentiallyTrustworthy(referrerURL) && !isURLPotentiallyTrustworthy(currentURL)) {\012            return \042no-referrer\042;\012          }\012          return referrerOrigin;\012        }\012        case \042strict-origin\042:\012        case \042no-referrer-when-downgrade\042:\012        default:\012          return isNonPotentiallyTrustWorthy \077 \042no-referrer\042 : referrerOrigin;\012      }\012    }\012    __name(determineRequestsReferrer, \042determineRequestsReferrer\042);\012    function stripURLForReferrer(url, originOnly) {\012      assert(url instanceof URL);\012      url = new URL(url);\012      if (url.protocol === \042file:\042 || url.protocol === \042about:\042 || url.protocol === \042blank:\042) {\012        return \042no-referrer\042;\012      }\012      url.username = \042\042;\012      url.password = \042\042;\012      url.hash = \042\042;\012      if (originOnly) {\012        url.pathname = \042\042;\012        url.search = \042\042;\012      }\012      return url;\012    }\012    __name(stripURLForReferrer, \042stripURLForReferrer\042);\012    function isURLPotentiallyTrustworthy(url) {\012      if (!(url instanceof URL)) {\012        return false;\012      }\012      if (url.href === \042about:blank\042 || url.href === \042about:srcdoc\042) {\012        return true;\012      }\012      if (url.protocol === \042data:\042)\012        return true;\012      if (url.protocol === \042file:\042)\012        return true;\012      return isOriginPotentiallyTrustworthy(url.origin);\012      function isOriginPotentiallyTrustworthy(origin) {\012        if (origin == null || origin === \042null\042)\012          return false;\012        const originAsURL = new URL(origin);\012        if (originAsURL.protocol === \042https:\042 || originAsURL.protocol === \042wss:\042) {\012          return true;\012        }\012        if (/^127(\077:\134.[0-9]+){0,2}\134.[0-9]+$|^\134[(\077:0*:)*\077:\0770*1\134]$/.test(originAsURL.hostname) || (originAsURL.hostname === \042localhost\042 || originAsURL.hostname.includes(\042localhost.\042)) || originAsURL.hostname.endsWith(\042.localhost\042)) {\012          return true;\012        }\012        return false;\012      }\012      __name(isOriginPotentiallyTrustworthy, \042isOriginPotentiallyTrustworthy\042);\012    }\012    __name(isURLPotentiallyTrustworthy, \042isURLPotentiallyTrustworthy\042);\012    function bytesMatch(bytes, metadataList) {\012      if (crypto === void 0) {\012        return true;\012      }\012      const parsedMetadata = parseMetadata(metadataList);\012      if (parsedMetadata === \042no metadata\042) {\012        return true;\012      }\012      if (parsedMetadata.length === 0) {\012        return true;\012      }\012      const strongest = getStrongestMetadata(parsedMetadata);\012      const metadata = filterMetadataListByAlgorithm(parsedMetadata, strongest);\012      for (const item of metadata) {\012        const algorithm = item.algo;\012        const expectedValue = item.hash;\012        let actualValue = crypto.createHash(algorithm).update(bytes).digest(\042base64\042);\012        if (actualValue[actualValue.length - 1] === \042=\042) {\012          if (actualValue[actualValue.length - 2] === \042=\042) {\012            actualValue = actualValue.slice(0, -2);\012          } else {\012            actualValue = actualValue.slice(0, -1);\012          }\012        }\012        if (compareBase64Mixed(actualValue, expectedValue)) {\012          return true;\012        }\012      }\012      return false;\012    }\012    __name(bytesMatch, \042bytesMatch\042);\012    var parseHashWithOptions = /(\077<algo>sha256|sha384|sha512)-((\077<hash>[A-Za-z0-9+/]+|[A-Za-z0-9_-]+)={0,2}(\077:\134s|$)( +[!-~]*)\077)\077/i;\012    function parseMetadata(metadata) {\012      const result = [];\012      let empty = true;\012      for (const token of metadata.split(\042 \042)) {\012        empty = false;\012        const parsedToken = parseHashWithOptions.exec(token);\012        if (parsedToken === null || parsedToken.groups === void 0 || parsedToken.groups.algo === void 0) {\012          continue;\012        }\012        const algorithm = parsedToken.groups.algo.toLowerCase();\012        if (supportedHashes.includes(algorithm)) {\012          result.push(parsedToken.groups);\012        }\012      }\012      if (empty === true) {\012        return \042no metadata\042;\012      }\012      return result;\012    }\012    __name(parseMetadata, \042parseMetadata\042);\012    function getStrongestMetadata(metadataList) {\012      let algorithm = metadataList[0].algo;\012      if (algorithm[3] === \0425\042) {\012        return algorithm;\012      }\012      for (let i = 1; i < metadataList.length; ++i) {\012        const metadata = metadataList[i];\012        if (metadata.algo[3] === \0425\042) {\012          algorithm = \042sha512\042;\012          break;\012        } else if (algorithm[3] === \0423\042) {\012          continue;\012        } else if (metadata.algo[3] === \0423\042) {\012          algorithm = \042sha384\042;\012        }\012      }\012      return algorithm;\012    }\012    __name(getStrongestMetadata, \042getStrongestMetadata\042);\012    function filterMetadataListByAlgorithm(metadataList, algorithm) {\012      if (metadataList.length === 1) {\012        return metadataList;\012      }\012      let pos = 0;\012      for (let i = 0; i < metadataList.length; ++i) {\012        if (metadataList[i].algo === algorithm) {\012          metadataList[pos++] = metadataList[i];\012        }\012      }\012      metadataList.length = pos;\012      return metadataList;\012    }\012    __name(filterMetadataListByAlgorithm, \042filterMetadataListByAlgorithm\042);\012    function compareBase64Mixed(actualValue, expectedValue) {\012      if (actualValue.length !== expectedValue.length) {\012        return false;\012      }\012      for (let i = 0; i < actualValue.length; ++i) {\012        if (actualValue[i] !== expectedValue[i]) {\012          if (actualValue[i] === \042+\042 && expectedValue[i] === \042-\042 || actualValue[i] === \042/\042 && expectedValue[i] === \042_\042) {\012            continue;\012          }\012          return false;\012        }\012      }\012      return true;\012    }\012    __name(compareBase64Mixed, \042compareBase64Mixed\042);\012    function tryUpgradeRequestToAPotentiallyTrustworthyURL(request) {\012    }\012    __name(tryUpgradeRequestToAPotentiallyTrustworthyURL, \042tryUpgradeRequestToAPotentiallyTrustworthyURL\042);\012    function sameOrigin(A, B) {\012      if (A.origin === B.origin && A.origin === \042null\042) {\012        return true;\012      }\012      if (A.protocol === B.protocol && A.hostname === B.hostname && A.port === B.port) {\012        return true;\012      }\012      return false;\012    }\012    __name(sameOrigin, \042sameOrigin\042);\012    function createDeferredPromise() {\012      let res;\012      let rej;\012      const promise = new Promise((resolve, reject) => {\012        res = resolve;\012        rej = reject;\012      });\012      return { promise, resolve: res, reject: rej };\012    }\012    __name(createDeferredPromise, \042createDeferredPromise\042);\012    function isAborted(fetchParams) {\012      return fetchParams.controller.state === \042aborted\042;\012    }\012    __name(isAborted, \042isAborted\042);\012    function isCancelled(fetchParams) {\012      return fetchParams.controller.state === \042aborted\042 || fetchParams.controller.state === \042terminated\042;\012    }\012    __name(isCancelled, \042isCancelled\042);\012    function normalizeMethod(method) {\012      return normalizedMethodRecordsBase[method.toLowerCase()] \077\077 method;\012    }\012    __name(normalizeMethod, \042normalizeMethod\042);\012    function serializeJavascriptValueToJSONString(value) {\012      const result = JSON.stringify(value);\012      if (result === void 0) {\012        throw new TypeError(\042Value is not JSON serializable\042);\012      }\012      assert(typeof result === \042string\042);\012      return result;\012    }\012    __name(serializeJavascriptValueToJSONString, \042serializeJavascriptValueToJSONString\042);\012    var esIteratorPrototype = Object.getPrototypeOf(Object.getPrototypeOf([][Symbol.iterator]()));\012    function createIterator(name, kInternalIterator, keyIndex = 0, valueIndex = 1) {\012      class FastIterableIterator {\012        static {\012          __name(this, \042FastIterableIterator\042);\012        }\012        /** @type {any} */\012        #target;\012        /** @type {'key' | 'value' | 'key+value'} */\012        #kind;\012        /** @type {number} */\012        #index;\012        /**\012         * @see https://webidl.spec.whatwg.org/#dfn-default-iterator-object\012         * @param {unknown} target\012         * @param {'key' | 'value' | 'key+value'} kind\012         */\012        constructor(target, kind) {\012          this.#target = target;\012          this.#kind = kind;\012          this.#index = 0;\012        }\012        next() {\012          if (typeof this !== \042object\042 || this === null || !(#target in this)) {\012            throw new TypeError(\012              `'next' called on an object that does not implement interface ${name} Iterator.`\012            );\012          }\012          const index = this.#index;\012          const values = this.#target[kInternalIterator];\012          const len = values.length;\012          if (index >= len) {\012            return {\012              value: void 0,\012              done: true\012            };\012          }\012          const { [keyIndex]: key, [valueIndex]: value } = values[index];\012          this.#index = index + 1;\012          let result;\012          switch (this.#kind) {\012            case \042key\042:\012              result = key;\012              break;\012            case \042value\042:\012              result = value;\012              break;\012            case \042key+value\042:\012              result = [key, value];\012              break;\012          }\012          return {\012            value: result,\012            done: false\012          };\012        }\012      }\012      delete FastIterableIterator.prototype.constructor;\012      Object.setPrototypeOf(FastIterableIterator.prototype, esIteratorPrototype);\012      Object.defineProperties(FastIterableIterator.prototype, {\012        [Symbol.toStringTag]: {\012          writable: false,\012          enumerable: false,\012          configurable: true,\012          value: `${name} Iterator`\012        },\012        next: { writable: true, enumerable: true, configurable: true }\012      });\012      return function(target, kind) {\012        return new FastIterableIterator(target, kind);\012      };\012    }\012    __name(createIterator, \042createIterator\042);\012    function iteratorMixin(name, object, kInternalIterator, keyIndex = 0, valueIndex = 1) {\012      const makeIterator = createIterator(name, kInternalIterator, keyIndex, valueIndex);\012      const properties = {\012        keys: {\012          writable: true,\012          enumerable: true,\012          configurable: true,\012          value: /* @__PURE__ */ __name(function keys() {\012            webidl.brandCheck(this, object);\012            return makeIterator(this, \042key\042);\012          }, \042keys\042)\012        },\012        values: {\012          writable: true,\012          enumerable: true,\012          configurable: true,\012          value: /* @__PURE__ */ __name(function values() {\012            webidl.brandCheck(this, object);\012            return makeIterator(this, \042value\042);\012          }, \042values\042)\012        },\012        entries: {\012          writable: true,\012          enumerable: true,\012          configurable: true,\012          value: /* @__PURE__ */ __name(function entries() {\012            webidl.brandCheck(this, object);\012            return makeIterator(this, \042key+value\042);\012          }, \042entries\042)\012        },\012        forEach: {\012          writable: true,\012          enumerable: true,\012          configurable: true,\012          value: /* @__PURE__ */ __name(function forEach(callbackfn, thisArg = globalThis) {\012            webidl.brandCheck(this, object);\012            webidl.argumentLengthCheck(arguments, 1, `${name}.forEach`);\012            if (typeof callbackfn !== \042function\042) {\012              throw new TypeError(\012                `Failed to execute 'forEach' on '${name}': parameter 1 is not of type 'Function'.`\012              );\012            }\012            for (const { 0: key, 1: value } of makeIterator(this, \042key+value\042)) {\012              callbackfn.call(thisArg, value, key, this);\012            }\012          }, \042forEach\042)\012        }\012      };\012      return Object.defineProperties(object.prototype, {\012        ...properties,\012        [Symbol.iterator]: {\012          writable: true,\012          enumerable: false,\012          configurable: true,\012          value: properties.entries.value\012        }\012      });\012    }\012    __name(iteratorMixin, \042iteratorMixin\042);\012    async function fullyReadBody(body, processBody, processBodyError) {\012      const successSteps = processBody;\012      const errorSteps = processBodyError;\012      let reader;\012      try {\012        reader = body.stream.getReader();\012      } catch (e) {\012        errorSteps(e);\012        return;\012      }\012      try {\012        successSteps(await readAllBytes(reader));\012      } catch (e) {\012        errorSteps(e);\012      }\012    }\012    __name(fullyReadBody, \042fullyReadBody\042);\012    function isReadableStreamLike(stream) {\012      return stream instanceof ReadableStream || stream[Symbol.toStringTag] === \042ReadableStream\042 && typeof stream.tee === \042function\042;\012    }\012    __name(isReadableStreamLike, \042isReadableStreamLike\042);\012    function readableStreamClose(controller) {\012      try {\012        controller.close();\012        controller.byobRequest\077.respond(0);\012      } catch (err) {\012        if (!err.message.includes(\042Controller is already closed\042) && !err.message.includes(\042ReadableStream is already closed\042)) {\012          throw err;\012        }\012      }\012    }\012    __name(readableStreamClose, \042readableStreamClose\042);\012    var invalidIsomorphicEncodeValueRegex = /[^\134x00-\134xFF]/;\012    function isomorphicEncode(input) {\012      assert(!invalidIsomorphicEncodeValueRegex.test(input));\012      return input;\012    }\012    __name(isomorphicEncode, \042isomorphicEncode\042);\012    async function readAllBytes(reader) {\012      const bytes = [];\012      let byteLength = 0;\012      while (true) {\012        const { done, value: chunk } = await reader.read();\012        if (done) {\012          return Buffer.concat(bytes, byteLength);\012        }\012        if (!isUint8Array(chunk)) {\012          throw new TypeError(\042Received non-Uint8Array chunk\042);\012        }\012        bytes.push(chunk);\012        byteLength += chunk.length;\012      }\012    }\012    __name(readAllBytes, \042readAllBytes\042);\012    function urlIsLocal(url) {\012      assert(\042protocol\042 in url);\012      const protocol = url.protocol;\012      return protocol === \042about:\042 || protocol === \042blob:\042 || protocol === \042data:\042;\012    }\012    __name(urlIsLocal, \042urlIsLocal\042);\012    function urlHasHttpsScheme(url) {\012      return typeof url === \042string\042 && url[5] === \042:\042 && url[0] === \042h\042 && url[1] === \042t\042 && url[2] === \042t\042 && url[3] === \042p\042 && url[4] === \042s\042 || url.protocol === \042https:\042;\012    }\012    __name(urlHasHttpsScheme, \042urlHasHttpsScheme\042);\012    function urlIsHttpHttpsScheme(url) {\012      assert(\042protocol\042 in url);\012      const protocol = url.protocol;\012      return protocol === \042http:\042 || protocol === \042https:\042;\012    }\012    __name(urlIsHttpHttpsScheme, \042urlIsHttpHttpsScheme\042);\012    function simpleRangeHeaderValue(value, allowWhitespace) {\012      const data = value;\012      if (!data.startsWith(\042bytes\042)) {\012        return \042failure\042;\012      }\012      const position = { position: 5 };\012      if (allowWhitespace) {\012        collectASequenceOfCodePoints(\012          (char) => char === \042\011\042 || char === \042 \042,\012          data,\012          position\012        );\012      }\012      if (data.charCodeAt(position.position) !== 61) {\012        return \042failure\042;\012      }\012      position.position++;\012      if (allowWhitespace) {\012        collectASequenceOfCodePoints(\012          (char) => char === \042\011\042 || char === \042 \042,\012          data,\012          position\012        );\012      }\012      const rangeStart = collectASequenceOfCodePoints(\012        (char) => {\012          const code = char.charCodeAt(0);\012          return code >= 48 && code <= 57;\012        },\012        data,\012        position\012      );\012      const rangeStartValue = rangeStart.length \077 Number(rangeStart) : null;\012      if (allowWhitespace) {\012        collectASequenceOfCodePoints(\012          (char) => char === \042\011\042 || char === \042 \042,\012          data,\012          position\012        );\012      }\012      if (data.charCodeAt(position.position) !== 45) {\012        return \042failure\042;\012      }\012      position.position++;\012      if (allowWhitespace) {\012        collectASequenceOfCodePoints(\012          (char) => char === \042\011\042 || char === \042 \042,\012          data,\012          position\012        );\012      }\012      const rangeEnd = collectASequenceOfCodePoints(\012        (char) => {\012          const code = char.charCodeAt(0);\012          return code >= 48 && code <= 57;\012        },\012        data,\012        position\012      );\012      const rangeEndValue = rangeEnd.length \077 Number(rangeEnd) : null;\012      if (position.position < data.length) {\012        return \042failure\042;\012      }\012      if (rangeEndValue === null && rangeStartValue === null) {\012        return \042failure\042;\012      }\012      if (rangeStartValue > rangeEndValue) {\012        return \042failure\042;\012      }\012      return { rangeStartValue, rangeEndValue };\012    }\012    __name(simpleRangeHeaderValue, \042simpleRangeHeaderValue\042);\012    function buildContentRange(rangeStart, rangeEnd, fullLength) {\012      let contentRange = \042bytes \042;\012      contentRange += isomorphicEncode(`${rangeStart}`);\012      contentRange += \042-\042;\012      contentRange += isomorphicEncode(`${rangeEnd}`);\012      contentRange += \042/\042;\012      contentRange += isomorphicEncode(`${fullLength}`);\012      return contentRange;\012    }\012    __name(buildContentRange, \042buildContentRange\042);\012    var InflateStream = class extends Transform {\012      static {\012        __name(this, \042InflateStream\042);\012      }\012      #zlibOptions;\012      /** @param {zlib.ZlibOptions} [zlibOptions] */\012      constructor(zlibOptions) {\012        super();\012        this.#zlibOptions = zlibOptions;\012      }\012      _transform(chunk, encoding, callback) {\012        if (!this._inflateStream) {\012          if (chunk.length === 0) {\012            callback();\012            return;\012          }\012          this._inflateStream = (chunk[0] & 15) === 8 \077 zlib.createInflate(this.#zlibOptions) : zlib.createInflateRaw(this.#zlibOptions);\012          this._inflateStream.on(\042data\042, this.push.bind(this));\012          this._inflateStream.on(\042end\042, () => this.push(null));\012          this._inflateStream.on(\042error\042, (err) => this.destroy(err));\012        }\012        this._inflateStream.write(chunk, encoding, callback);\012      }\012      _final(callback) {\012        if (this._inflateStream) {\012          this._inflateStream.end();\012          this._inflateStream = null;\012        }\012        callback();\012      }\012    };\012    function createInflate(zlibOptions) {\012      return new InflateStream(zlibOptions);\012    }\012    __name(createInflate, \042createInflate\042);\012    function extractMimeType(headers) {\012      let charset = null;\012      let essence = null;\012      let mimeType = null;\012      const values = getDecodeSplit(\042content-type\042, headers);\012      if (values === null) {\012        return \042failure\042;\012      }\012      for (const value of values) {\012        const temporaryMimeType = parseMIMEType(value);\012        if (temporaryMimeType === \042failure\042 || temporaryMimeType.essence === \042*/*\042) {\012          continue;\012        }\012        mimeType = temporaryMimeType;\012        if (mimeType.essence !== essence) {\012          charset = null;\012          if (mimeType.parameters.has(\042charset\042)) {\012            charset = mimeType.parameters.get(\042charset\042);\012          }\012          essence = mimeType.essence;\012        } else if (!mimeType.parameters.has(\042charset\042) && charset !== null) {\012          mimeType.parameters.set(\042charset\042, charset);\012        }\012      }\012      if (mimeType == null) {\012        return \042failure\042;\012      }\012      return mimeType;\012    }\012    __name(extractMimeType, \042extractMimeType\042);\012    function gettingDecodingSplitting(value) {\012      const input = value;\012      const position = { position: 0 };\012      const values = [];\012      let temporaryValue = \042\042;\012      while (position.position < input.length) {\012        temporaryValue += collectASequenceOfCodePoints(\012          (char) => char !== '\042' && char !== \042,\042,\012          input,\012          position\012        );\012        if (position.position < input.length) {\012          if (input.charCodeAt(position.position) === 34) {\012            temporaryValue += collectAnHTTPQuotedString(\012              input,\012              position\012            );\012            if (position.position < input.length) {\012              continue;\012            }\012          } else {\012            assert(input.charCodeAt(position.position) === 44);\012            position.position++;\012          }\012        }\012        temporaryValue = removeChars(temporaryValue, true, true, (char) => char === 9 || char === 32);\012        values.push(temporaryValue);\012        temporaryValue = \042\042;\012      }\012      return values;\012    }\012    __name(gettingDecodingSplitting, \042gettingDecodingSplitting\042);\012    function getDecodeSplit(name, list) {\012      const value = list.get(name, true);\012      if (value === null) {\012        return null;\012      }\012      return gettingDecodingSplitting(value);\012    }\012    __name(getDecodeSplit, \042getDecodeSplit\042);\012    var textDecoder = new TextDecoder();\012    function utf8DecodeBytes(buffer) {\012      if (buffer.length === 0) {\012        return \042\042;\012      }\012      if (buffer[0] === 239 && buffer[1] === 187 && buffer[2] === 191) {\012        buffer = buffer.subarray(3);\012      }\012      const output = textDecoder.decode(buffer);\012      return output;\012    }\012    __name(utf8DecodeBytes, \042utf8DecodeBytes\042);\012    var EnvironmentSettingsObjectBase = class {\012      static {\012        __name(this, \042EnvironmentSettingsObjectBase\042);\012      }\012      get baseUrl() {\012        return getGlobalOrigin();\012      }\012      get origin() {\012        return this.baseUrl\077.origin;\012      }\012      policyContainer = makePolicyContainer();\012    };\012    var EnvironmentSettingsObject = class {\012      static {\012        __name(this, \042EnvironmentSettingsObject\042);\012      }\012      settingsObject = new EnvironmentSettingsObjectBase();\012    };\012    var environmentSettingsObject = new EnvironmentSettingsObject();\012    module2.exports = {\012      isAborted,\012      isCancelled,\012      isValidEncodedURL,\012      createDeferredPromise,\012      ReadableStreamFrom,\012      tryUpgradeRequestToAPotentiallyTrustworthyURL,\012      clampAndCoarsenConnectionTimingInfo,\012      coarsenedSharedCurrentTime,\012      determineRequestsReferrer,\012      makePolicyContainer,\012      clonePolicyContainer,\012      appendFetchMetadata,\012      appendRequestOriginHeader,\012      TAOCheck,\012      corsCheck,\012      crossOriginResourcePolicyCheck,\012      createOpaqueTimingInfo,\012      setRequestReferrerPolicyOnRedirect,\012      isValidHTTPToken,\012      requestBadPort,\012      requestCurrentURL,\012      responseURL,\012      responseLocationURL,\012      isBlobLike,\012      isURLPotentiallyTrustworthy,\012      isValidReasonPhrase,\012      sameOrigin,\012      normalizeMethod,\012      serializeJavascriptValueToJSONString,\012      iteratorMixin,\012      createIterator,\012      isValidHeaderName,\012      isValidHeaderValue,\012      isErrorLike,\012      fullyReadBody,\012      bytesMatch,\012      isReadableStreamLike,\012      readableStreamClose,\012      isomorphicEncode,\012      urlIsLocal,\012      urlHasHttpsScheme,\012      urlIsHttpHttpsScheme,\012      readAllBytes,\012      simpleRangeHeaderValue,\012      buildContentRange,\012      parseMetadata,\012      createInflate,\012      extractMimeType,\012      getDecodeSplit,\012      utf8DecodeBytes,\012      environmentSettingsObject\012    };\012  }\012});\012\012// lib/web/fetch/symbols.js\012var require_symbols2 = __commonJS({\012  \042lib/web/fetch/symbols.js\042(exports2, module2) {\012    \042use strict\042;\012    module2.exports = {\012      kUrl: Symbol(\042url\042),\012      kHeaders: Symbol(\042headers\042),\012      kSignal: Symbol(\042signal\042),\012      kState: Symbol(\042state\042),\012      kDispatcher: Symbol(\042dispatcher\042)\012    };\012  }\012});\012\012// lib/web/fetch/file.js\012var require_file = __commonJS({\012  \042lib/web/fetch/file.js\042(exports2, module2) {\012    \042use strict\042;\012    var { Blob: Blob2, File } = require(\042node:buffer\042);\012    var { kState } = require_symbols2();\012    var { webidl } = require_webidl();\012    var FileLike = class _FileLike {\012      static {\012        __name(this, \042FileLike\042);\012      }\012      constructor(blobLike, fileName, options = {}) {\012        const n = fileName;\012        const t = options.type;\012        const d = options.lastModified \077\077 Date.now();\012        this[kState] = {\012          blobLike,\012          name: n,\012          type: t,\012          lastModified: d\012        };\012      }\012      stream(...args) {\012        webidl.brandCheck(this, _FileLike);\012        return this[kState].blobLike.stream(...args);\012      }\012      arrayBuffer(...args) {\012        webidl.brandCheck(this, _FileLike);\012        return this[kState].blobLike.arrayBuffer(...args);\012      }\012      slice(...args) {\012        webidl.brandCheck(this, _FileLike);\012        return this[kState].blobLike.slice(...args);\012      }\012      text(...args) {\012        webidl.brandCheck(this, _FileLike);\012        return this[kState].blobLike.text(...args);\012      }\012      get size() {\012        webidl.brandCheck(this, _FileLike);\012        return this[kState].blobLike.size;\012      }\012      get type() {\012        webidl.brandCheck(this, _FileLike);\012        return this[kState].blobLike.type;\012      }\012      get name() {\012        webidl.brandCheck(this, _FileLike);\012        return this[kState].name;\012      }\012      get lastModified() {\012        webidl.brandCheck(this, _FileLike);\012        return this[kState].lastModified;\012      }\012      get [Symbol.toStringTag]() {\012        return \042File\042;\012      }\012    };\012    webidl.converters.Blob = webidl.interfaceConverter(Blob2);\012    function isFileLike(object) {\012      return object instanceof File || object && (typeof object.stream === \042function\042 || typeof object.arrayBuffer === \042function\042) && object[Symbol.toStringTag] === \042File\042;\012    }\012    __name(isFileLike, \042isFileLike\042);\012    module2.exports = { FileLike, isFileLike };\012  }\012});\012\012// lib/web/fetch/formdata.js\012var require_formdata = __commonJS({\012  \042lib/web/fetch/formdata.js\042(exports2, module2) {\012    \042use strict\042;\012    var { isBlobLike, iteratorMixin } = require_util2();\012    var { kState } = require_symbols2();\012    var { kEnumerableProperty } = require_util();\012    var { FileLike, isFileLike } = require_file();\012    var { webidl } = require_webidl();\012    var { File: NativeFile } = require(\042node:buffer\042);\012    var nodeUtil = require(\042node:util\042);\012    var File = globalThis.File \077\077 NativeFile;\012    var FormData = class _FormData {\012      static {\012        __name(this, \042FormData\042);\012      }\012      constructor(form) {\012        webidl.util.markAsUncloneable(this);\012        if (form !== void 0) {\012          throw webidl.errors.conversionFailed({\012            prefix: \042FormData constructor\042,\012            argument: \042Argument 1\042,\012            types: [\042undefined\042]\012          });\012        }\012        this[kState] = [];\012      }\012      append(name, value, filename = void 0) {\012        webidl.brandCheck(this, _FormData);\012        const prefix = \042FormData.append\042;\012        webidl.argumentLengthCheck(arguments, 2, prefix);\012        if (arguments.length === 3 && !isBlobLike(value)) {\012          throw new TypeError(\012            \042Failed to execute 'append' on 'FormData': parameter 2 is not of type 'Blob'\042\012          );\012        }\012        name = webidl.converters.USVString(name, prefix, \042name\042);\012        value = isBlobLike(value) \077 webidl.converters.Blob(value, prefix, \042value\042, { strict: false }) : webidl.converters.USVString(value, prefix, \042value\042);\012        filename = arguments.length === 3 \077 webidl.converters.USVString(filename, prefix, \042filename\042) : void 0;\012        const entry = makeEntry(name, value, filename);\012        this[kState].push(entry);\012      }\012      delete(name) {\012        webidl.brandCheck(this, _FormData);\012        const prefix = \042FormData.delete\042;\012        webidl.argumentLengthCheck(arguments, 1, prefix);\012        name = webidl.converters.USVString(name, prefix, \042name\042);\012        this[kState] = this[kState].filter((entry) => entry.name !== name);\012      }\012      get(name) {\012        webidl.brandCheck(this, _FormData);\012        const prefix = \042FormData.get\042;\012        webidl.argumentLengthCheck(arguments, 1, prefix);\012        name = webidl.converters.USVString(name, prefix, \042name\042);\012        const idx = this[kState].findIndex((entry) => entry.name === name);\012        if (idx === -1) {\012          return null;\012        }\012        return this[kState][idx].value;\012      }\012      getAll(name) {\012        webidl.brandCheck(this, _FormData);\012        const prefix = \042FormData.getAll\042;\012        webidl.argumentLengthCheck(arguments, 1, prefix);\012        name = webidl.converters.USVString(name, prefix, \042name\042);\012        return this[kState].filter((entry) => entry.name === name).map((entry) => entry.value);\012      }\012      has(name) {\012        webidl.brandCheck(this, _FormData);\012        const prefix = \042FormData.has\042;\012        webidl.argumentLengthCheck(arguments, 1, prefix);\012        name = webidl.converters.USVString(name, prefix, \042name\042);\012        return this[kState].findIndex((entry) => entry.name === name) !== -1;\012      }\012      set(name, value, filename = void 0) {\012        webidl.brandCheck(this, _FormData);\012        const prefix = \042FormData.set\042;\012        webidl.argumentLengthCheck(arguments, 2, prefix);\012        if (arguments.length === 3 && !isBlobLike(value)) {\012          throw new TypeError(\012            \042Failed to execute 'set' on 'FormData': parameter 2 is not of type 'Blob'\042\012          );\012        }\012        name = webidl.converters.USVString(name, prefix, \042name\042);\012        value = isBlobLike(value) \077 webidl.converters.Blob(value, prefix, \042name\042, { strict: false }) : webidl.converters.USVString(value, prefix, \042name\042);\012        filename = arguments.length === 3 \077 webidl.converters.USVString(filename, prefix, \042name\042) : void 0;\012        const entry = makeEntry(name, value, filename);\012        const idx = this[kState].findIndex((entry2) => entry2.name === name);\012        if (idx !== -1) {\012          this[kState] = [\012            ...this[kState].slice(0, idx),\012            entry,\012            ...this[kState].slice(idx + 1).filter((entry2) => entry2.name !== name)\012          ];\012        } else {\012          this[kState].push(entry);\012        }\012      }\012      [nodeUtil.inspect.custom](depth, options) {\012        const state = this[kState].reduce((a, b) => {\012          if (a[b.name]) {\012            if (Array.isArray(a[b.name])) {\012              a[b.name].push(b.value);\012            } else {\012              a[b.name] = [a[b.name], b.value];\012            }\012          } else {\012            a[b.name] = b.value;\012          }\012          return a;\012        }, { __proto__: null });\012        options.depth \077\077= depth;\012        options.colors \077\077= true;\012        const output = nodeUtil.formatWithOptions(options, state);\012        return `FormData ${output.slice(output.indexOf(\042]\042) + 2)}`;\012      }\012    };\012    iteratorMixin(\042FormData\042, FormData, kState, \042name\042, \042value\042);\012    Object.defineProperties(FormData.prototype, {\012      append: kEnumerableProperty,\012      delete: kEnumerableProperty,\012      get: kEnumerableProperty,\012      getAll: kEnumerableProperty,\012      has: kEnumerableProperty,\012      set: kEnumerableProperty,\012      [Symbol.toStringTag]: {\012        value: \042FormData\042,\012        configurable: true\012      }\012    });\012    function makeEntry(name, value, filename) {\012      if (typeof value === \042string\042) {\012      } else {\012        if (!isFileLike(value)) {\012          value = value instanceof Blob \077 new File([value], \042blob\042, { type: value.type }) : new FileLike(value, \042blob\042, { type: value.type });\012        }\012        if (filename !== void 0) {\012          const options = {\012            type: value.type,\012            lastModified: value.lastModified\012          };\012          value = value instanceof NativeFile \077 new File([value], filename, options) : new FileLike(value, filename, options);\012        }\012      }\012      return { name, value };\012    }\012    __name(makeEntry, \042makeEntry\042);\012    module2.exports = { FormData, makeEntry };\012  }\012});\012\012// lib/web/fetch/formdata-parser.js\012var require_formdata_parser = __commonJS({\012  \042lib/web/fetch/formdata-parser.js\042(exports2, module2) {\012    \042use strict\042;\012    var { isUSVString, bufferToLowerCasedHeaderName } = require_util();\012    var { utf8DecodeBytes } = require_util2();\012    var { HTTP_TOKEN_CODEPOINTS, isomorphicDecode } = require_data_url();\012    var { isFileLike } = require_file();\012    var { makeEntry } = require_formdata();\012    var assert = require(\042node:assert\042);\012    var { File: NodeFile } = require(\042node:buffer\042);\012    var File = globalThis.File \077\077 NodeFile;\012    var formDataNameBuffer = Buffer.from('form-data; name=\042');\012    var filenameBuffer = Buffer.from(\042; filename\042);\012    var dd = Buffer.from(\042--\042);\012    var ddcrlf = Buffer.from(\042--\134r\134n\042);\012    function isAsciiString(chars) {\012      for (let i = 0; i < chars.length; ++i) {\012        if ((chars.charCodeAt(i) & ~127) !== 0) {\012          return false;\012        }\012      }\012      return true;\012    }\012    __name(isAsciiString, \042isAsciiString\042);\012    function validateBoundary(boundary) {\012      const length = boundary.length;\012      if (length < 27 || length > 70) {\012        return false;\012      }\012      for (let i = 0; i < length; ++i) {\012        const cp = boundary.charCodeAt(i);\012        if (!(cp >= 48 && cp <= 57 || cp >= 65 && cp <= 90 || cp >= 97 && cp <= 122 || cp === 39 || cp === 45 || cp === 95)) {\012          return false;\012        }\012      }\012      return true;\012    }\012    __name(validateBoundary, \042validateBoundary\042);\012    function multipartFormDataParser(input, mimeType) {\012      assert(mimeType !== \042failure\042 && mimeType.essence === \042multipart/form-data\042);\012      const boundaryString = mimeType.parameters.get(\042boundary\042);\012      if (boundaryString === void 0) {\012        return \042failure\042;\012      }\012      const boundary = Buffer.from(`--${boundaryString}`, \042utf8\042);\012      const entryList = [];\012      const position = { position: 0 };\012      while (input[position.position] === 13 && input[position.position + 1] === 10) {\012        position.position += 2;\012      }\012      let trailing = input.length;\012      while (input[trailing - 1] === 10 && input[trailing - 2] === 13) {\012        trailing -= 2;\012      }\012      if (trailing !== input.length) {\012        input = input.subarray(0, trailing);\012      }\012      while (true) {\012        if (input.subarray(position.position, position.position + boundary.length).equals(boundary)) {\012          position.position += boundary.length;\012        } else {\012          return \042failure\042;\012        }\012        if (position.position === input.length - 2 && bufferStartsWith(input, dd, position) || position.position === input.length - 4 && bufferStartsWith(input, ddcrlf, position)) {\012          return entryList;\012        }\012        if (input[position.position] !== 13 || input[position.position + 1] !== 10) {\012          return \042failure\042;\012        }\012        position.position += 2;\012        const result = parseMultipartFormDataHeaders(input, position);\012        if (result === \042failure\042) {\012          return \042failure\042;\012        }\012        let { name, filename, contentType, encoding } = result;\012        position.position += 2;\012        let body;\012        {\012          const boundaryIndex = input.indexOf(boundary.subarray(2), position.position);\012          if (boundaryIndex === -1) {\012            return \042failure\042;\012          }\012          body = input.subarray(position.position, boundaryIndex - 4);\012          position.position += body.length;\012          if (encoding === \042base64\042) {\012            body = Buffer.from(body.toString(), \042base64\042);\012          }\012        }\012        if (input[position.position] !== 13 || input[position.position + 1] !== 10) {\012          return \042failure\042;\012        } else {\012          position.position += 2;\012        }\012        let value;\012        if (filename !== null) {\012          contentType \077\077= \042text/plain\042;\012          if (!isAsciiString(contentType)) {\012            contentType = \042\042;\012          }\012          value = new File([body], filename, { type: contentType });\012        } else {\012          value = utf8DecodeBytes(Buffer.from(body));\012        }\012        assert(isUSVString(name));\012        assert(typeof value === \042string\042 && isUSVString(value) || isFileLike(value));\012        entryList.push(makeEntry(name, value, filename));\012      }\012    }\012    __name(multipartFormDataParser, \042multipartFormDataParser\042);\012    function parseMultipartFormDataHeaders(input, position) {\012      let name = null;\012      let filename = null;\012      let contentType = null;\012      let encoding = null;\012      while (true) {\012        if (input[position.position] === 13 && input[position.position + 1] === 10) {\012          if (name === null) {\012            return \042failure\042;\012          }\012          return { name, filename, contentType, encoding };\012        }\012        let headerName = collectASequenceOfBytes(\012          (char) => char !== 10 && char !== 13 && char !== 58,\012          input,\012          position\012        );\012        headerName = removeChars(headerName, true, true, (char) => char === 9 || char === 32);\012        if (!HTTP_TOKEN_CODEPOINTS.test(headerName.toString())) {\012          return \042failure\042;\012        }\012        if (input[position.position] !== 58) {\012          return \042failure\042;\012        }\012        position.position++;\012        collectASequenceOfBytes(\012          (char) => char === 32 || char === 9,\012          input,\012          position\012        );\012        switch (bufferToLowerCasedHeaderName(headerName)) {\012          case \042content-disposition\042: {\012            name = filename = null;\012            if (!bufferStartsWith(input, formDataNameBuffer, position)) {\012              return \042failure\042;\012            }\012            position.position += 17;\012            name = parseMultipartFormDataName(input, position);\012            if (name === null) {\012              return \042failure\042;\012            }\012            if (bufferStartsWith(input, filenameBuffer, position)) {\012              let check = position.position + filenameBuffer.length;\012              if (input[check] === 42) {\012                position.position += 1;\012                check += 1;\012              }\012              if (input[check] !== 61 || input[check + 1] !== 34) {\012                return \042failure\042;\012              }\012              position.position += 12;\012              filename = parseMultipartFormDataName(input, position);\012              if (filename === null) {\012                return \042failure\042;\012              }\012            }\012            break;\012          }\012          case \042content-type\042: {\012            let headerValue = collectASequenceOfBytes(\012              (char) => char !== 10 && char !== 13,\012              input,\012              position\012            );\012            headerValue = removeChars(headerValue, false, true, (char) => char === 9 || char === 32);\012            contentType = isomorphicDecode(headerValue);\012            break;\012          }\012          case \042content-transfer-encoding\042: {\012            let headerValue = collectASequenceOfBytes(\012              (char) => char !== 10 && char !== 13,\012              input,\012              position\012            );\012            headerValue = removeChars(headerValue, false, true, (char) => char === 9 || char === 32);\012            encoding = isomorphicDecode(headerValue);\012            break;\012          }\012          default: {\012            collectASequenceOfBytes(\012              (char) => char !== 10 && char !== 13,\012              input,\012              position\012            );\012          }\012        }\012        if (input[position.position] !== 13 && input[position.position + 1] !== 10) {\012          return \042failure\042;\012        } else {\012          position.position += 2;\012        }\012      }\012    }\012    __name(parseMultipartFormDataHeaders, \042parseMultipartFormDataHeaders\042);\012    function parseMultipartFormDataName(input, position) {\012      assert(input[position.position - 1] === 34);\012      let name = collectASequenceOfBytes(\012        (char) => char !== 10 && char !== 13 && char !== 34,\012        input,\012        position\012      );\012      if (input[position.position] !== 34) {\012        return null;\012      } else {\012        position.position++;\012      }\012      name = new TextDecoder().decode(name).replace(/%0A/ig, \042\134n\042).replace(/%0D/ig, \042\134r\042).replace(/%22/g, '\042');\012      return name;\012    }\012    __name(parseMultipartFormDataName, \042parseMultipartFormDataName\042);\012    function collectASequenceOfBytes(condition, input, position) {\012      let start = position.position;\012      while (start < input.length && condition(input[start])) {\012        ++start;\012      }\012      return input.subarray(position.position, position.position = start);\012    }\012    __name(collectASequenceOfBytes, \042collectASequenceOfBytes\042);\012    function removeChars(buf, leading, trailing, predicate) {\012      let lead = 0;\012      let trail = buf.length - 1;\012      if (leading) {\012        while (lead < buf.length && predicate(buf[lead]))\012          lead++;\012      }\012      if (trailing) {\012        while (trail > 0 && predicate(buf[trail]))\012          trail--;\012      }\012      return lead === 0 && trail === buf.length - 1 \077 buf : buf.subarray(lead, trail + 1);\012    }\012    __name(removeChars, \042removeChars\042);\012    function bufferStartsWith(buffer, start, position) {\012      if (buffer.length < start.length) {\012        return false;\012      }\012      for (let i = 0; i < start.length; i++) {\012        if (start[i] !== buffer[position.position + i]) {\012          return false;\012        }\012      }\012      return true;\012    }\012    __name(bufferStartsWith, \042bufferStartsWith\042);\012    module2.exports = {\012      multipartFormDataParser,\012      validateBoundary\012    };\012  }\012});\012\012// lib/web/fetch/body.js\012var require_body = __commonJS({\012  \042lib/web/fetch/body.js\042(exports2, module2) {\012    \042use strict\042;\012    var util = require_util();\012    var {\012      ReadableStreamFrom,\012      isBlobLike,\012      isReadableStreamLike,\012      readableStreamClose,\012      createDeferredPromise,\012      fullyReadBody,\012      extractMimeType,\012      utf8DecodeBytes\012    } = require_util2();\012    var { FormData } = require_formdata();\012    var { kState } = require_symbols2();\012    var { webidl } = require_webidl();\012    var { Blob: Blob2 } = require(\042node:buffer\042);\012    var assert = require(\042node:assert\042);\012    var { isErrored, isDisturbed } = require(\042node:stream\042);\012    var { isArrayBuffer } = require(\042node:util/types\042);\012    var { serializeAMimeType } = require_data_url();\012    var { multipartFormDataParser } = require_formdata_parser();\012    var random;\012    try {\012      const crypto = require(\042node:crypto\042);\012      random = /* @__PURE__ */ __name((max) => crypto.randomInt(0, max), \042random\042);\012    } catch {\012      random = /* @__PURE__ */ __name((max) => Math.floor(Math.random(max)), \042random\042);\012    }\012    var textEncoder = new TextEncoder();\012    function noop() {\012    }\012    __name(noop, \042noop\042);\012    var hasFinalizationRegistry = globalThis.FinalizationRegistry && process.version.indexOf(\042v18\042) !== 0;\012    var streamRegistry;\012    if (hasFinalizationRegistry) {\012      streamRegistry = new FinalizationRegistry((weakRef) => {\012        const stream = weakRef.deref();\012        if (stream && !stream.locked && !isDisturbed(stream) && !isErrored(stream)) {\012          stream.cancel(\042Response object has been garbage collected\042).catch(noop);\012        }\012      });\012    }\012    function extractBody(object, keepalive = false) {\012      let stream = null;\012      if (object instanceof ReadableStream) {\012        stream = object;\012      } else if (isBlobLike(object)) {\012        stream = object.stream();\012      } else {\012        stream = new ReadableStream({\012          async pull(controller) {\012            const buffer = typeof source === \042string\042 \077 textEncoder.encode(source) : source;\012            if (buffer.byteLength) {\012              controller.enqueue(buffer);\012            }\012            queueMicrotask(() => readableStreamClose(controller));\012          },\012          start() {\012          },\012          type: \042bytes\042\012        });\012      }\012      assert(isReadableStreamLike(stream));\012      let action = null;\012      let source = null;\012      let length = null;\012      let type = null;\012      if (typeof object === \042string\042) {\012        source = object;\012        type = \042text/plain;charset=UTF-8\042;\012      } else if (object instanceof URLSearchParams) {\012        source = object.toString();\012        type = \042application/x-www-form-urlencoded;charset=UTF-8\042;\012      } else if (isArrayBuffer(object)) {\012        source = new Uint8Array(object.slice());\012      } else if (ArrayBuffer.isView(object)) {\012        source = new Uint8Array(object.buffer.slice(object.byteOffset, object.byteOffset + object.byteLength));\012      } else if (util.isFormDataLike(object)) {\012        const boundary = `----formdata-undici-0${`${random(1e11)}`.padStart(11, \0420\042)}`;\012        const prefix = `--${boundary}\134r\012Content-Disposition: form-data`;\012        const escape = /* @__PURE__ */ __name((str) => str.replace(/\134n/g, \042%0A\042).replace(/\134r/g, \042%0D\042).replace(/\042/g, \042%22\042), \042escape\042);\012        const normalizeLinefeeds = /* @__PURE__ */ __name((value) => value.replace(/\134r\077\134n|\134r/g, \042\134r\134n\042), \042normalizeLinefeeds\042);\012        const blobParts = [];\012        const rn = new Uint8Array([13, 10]);\012        length = 0;\012        let hasUnknownSizeValue = false;\012        for (const [name, value] of object) {\012          if (typeof value === \042string\042) {\012            const chunk2 = textEncoder.encode(prefix + `; name=\042${escape(normalizeLinefeeds(name))}\042\134r\012\134r\012${normalizeLinefeeds(value)}\134r\012`);\012            blobParts.push(chunk2);\012            length += chunk2.byteLength;\012          } else {\012            const chunk2 = textEncoder.encode(`${prefix}; name=\042${escape(normalizeLinefeeds(name))}\042` + (value.name \077 `; filename=\042${escape(value.name)}\042` : \042\042) + `\134r\012Content-Type: ${value.type || \042application/octet-stream\042}\134r\012\134r\012`);\012            blobParts.push(chunk2, value, rn);\012            if (typeof value.size === \042number\042) {\012              length += chunk2.byteLength + value.size + rn.byteLength;\012            } else {\012              hasUnknownSizeValue = true;\012            }\012          }\012        }\012        const chunk = textEncoder.encode(`--${boundary}--`);\012        blobParts.push(chunk);\012        length += chunk.byteLength;\012        if (hasUnknownSizeValue) {\012          length = null;\012        }\012        source = object;\012        action = /* @__PURE__ */ __name(async function* () {\012          for (const part of blobParts) {\012            if (part.stream) {\012              yield* part.stream();\012            } else {\012              yield part;\012            }\012          }\012        }, \042action\042);\012        type = `multipart/form-data; boundary=${boundary}`;\012      } else if (isBlobLike(object)) {\012        source = object;\012        length = object.size;\012        if (object.type) {\012          type = object.type;\012        }\012      } else if (typeof object[Symbol.asyncIterator] === \042function\042) {\012        if (keepalive) {\012          throw new TypeError(\042keepalive\042);\012        }\012        if (util.isDisturbed(object) || object.locked) {\012          throw new TypeError(\012            \042Response body object should not be disturbed or locked\042\012          );\012        }\012        stream = object instanceof ReadableStream \077 object : ReadableStreamFrom(object);\012      }\012      if (typeof source === \042string\042 || util.isBuffer(source)) {\012        length = Buffer.byteLength(source);\012      }\012      if (action != null) {\012        let iterator;\012        stream = new ReadableStream({\012          async start() {\012            iterator = action(object)[Symbol.asyncIterator]();\012          },\012          async pull(controller) {\012            const { value, done } = await iterator.next();\012            if (done) {\012              queueMicrotask(() => {\012                controller.close();\012                controller.byobRequest\077.respond(0);\012              });\012            } else {\012              if (!isErrored(stream)) {\012                const buffer = new Uint8Array(value);\012                if (buffer.byteLength) {\012                  controller.enqueue(buffer);\012                }\012              }\012            }\012            return controller.desiredSize > 0;\012          },\012          async cancel(reason) {\012            await iterator.return();\012          },\012          type: \042bytes\042\012        });\012      }\012      const body = { stream, source, length };\012      return [body, type];\012    }\012    __name(extractBody, \042extractBody\042);\012    function safelyExtractBody(object, keepalive = false) {\012      if (object instanceof ReadableStream) {\012        assert(!util.isDisturbed(object), \042The body has already been consumed.\042);\012        assert(!object.locked, \042The stream is locked.\042);\012      }\012      return extractBody(object, keepalive);\012    }\012    __name(safelyExtractBody, \042safelyExtractBody\042);\012    function cloneBody(instance, body) {\012      const [out1, out2] = body.stream.tee();\012      if (hasFinalizationRegistry) {\012        streamRegistry.register(instance, new WeakRef(out1));\012      }\012      body.stream = out1;\012      return {\012        stream: out2,\012        length: body.length,\012        source: body.source\012      };\012    }\012    __name(cloneBody, \042cloneBody\042);\012    function throwIfAborted(state) {\012      if (state.aborted) {\012        throw new DOMException(\042The operation was aborted.\042, \042AbortError\042);\012      }\012    }\012    __name(throwIfAborted, \042throwIfAborted\042);\012    function bodyMixinMethods(instance) {\012      const methods = {\012        blob() {\012          return consumeBody(this, (bytes) => {\012            let mimeType = bodyMimeType(this);\012            if (mimeType === null) {\012              mimeType = \042\042;\012            } else if (mimeType) {\012              mimeType = serializeAMimeType(mimeType);\012            }\012            return new Blob2([bytes], { type: mimeType });\012          }, instance);\012        },\012        arrayBuffer() {\012          return consumeBody(this, (bytes) => {\012            return new Uint8Array(bytes).buffer;\012          }, instance);\012        },\012        text() {\012          return consumeBody(this, utf8DecodeBytes, instance);\012        },\012        json() {\012          return consumeBody(this, parseJSONFromBytes, instance);\012        },\012        formData() {\012          return consumeBody(this, (value) => {\012            const mimeType = bodyMimeType(this);\012            if (mimeType !== null) {\012              switch (mimeType.essence) {\012                case \042multipart/form-data\042: {\012                  const parsed = multipartFormDataParser(value, mimeType);\012                  if (parsed === \042failure\042) {\012                    throw new TypeError(\042Failed to parse body as FormData.\042);\012                  }\012                  const fd = new FormData();\012                  fd[kState] = parsed;\012                  return fd;\012                }\012                case \042application/x-www-form-urlencoded\042: {\012                  const entries = new URLSearchParams(value.toString());\012                  const fd = new FormData();\012                  for (const [name, value2] of entries) {\012                    fd.append(name, value2);\012                  }\012                  return fd;\012                }\012              }\012            }\012            throw new TypeError(\012              'Content-Type was not one of \042multipart/form-data\042 or \042application/x-www-form-urlencoded\042.'\012            );\012          }, instance);\012        },\012        bytes() {\012          return consumeBody(this, (bytes) => {\012            return new Uint8Array(bytes);\012          }, instance);\012        }\012      };\012      return methods;\012    }\012    __name(bodyMixinMethods, \042bodyMixinMethods\042);\012    function mixinBody(prototype) {\012      Object.assign(prototype.prototype, bodyMixinMethods(prototype));\012    }\012    __name(mixinBody, \042mixinBody\042);\012    async function consumeBody(object, convertBytesToJSValue, instance) {\012      webidl.brandCheck(object, instance);\012      if (bodyUnusable(object)) {\012        throw new TypeError(\042Body is unusable: Body has already been read\042);\012      }\012      throwIfAborted(object[kState]);\012      const promise = createDeferredPromise();\012      const errorSteps = /* @__PURE__ */ __name((error) => promise.reject(error), \042errorSteps\042);\012      const successSteps = /* @__PURE__ */ __name((data) => {\012        try {\012          promise.resolve(convertBytesToJSValue(data));\012        } catch (e) {\012          errorSteps(e);\012        }\012      }, \042successSteps\042);\012      if (object[kState].body == null) {\012        successSteps(Buffer.allocUnsafe(0));\012        return promise.promise;\012      }\012      await fullyReadBody(object[kState].body, successSteps, errorSteps);\012      return promise.promise;\012    }\012    __name(consumeBody, \042consumeBody\042);\012    function bodyUnusable(object) {\012      const body = object[kState].body;\012      return body != null && (body.stream.locked || util.isDisturbed(body.stream));\012    }\012    __name(bodyUnusable, \042bodyUnusable\042);\012    function parseJSONFromBytes(bytes) {\012      return JSON.parse(utf8DecodeBytes(bytes));\012    }\012    __name(parseJSONFromBytes, \042parseJSONFromBytes\042);\012    function bodyMimeType(requestOrResponse) {\012      const headers = requestOrResponse[kState].headersList;\012      const mimeType = extractMimeType(headers);\012      if (mimeType === \042failure\042) {\012        return null;\012      }\012      return mimeType;\012    }\012    __name(bodyMimeType, \042bodyMimeType\042);\012    module2.exports = {\012      extractBody,\012      safelyExtractBody,\012      cloneBody,\012      mixinBody,\012      streamRegistry,\012      hasFinalizationRegistry,\012      bodyUnusable\012    };\012  }\012});\012\012// lib/dispatcher/client-h1.js\012var require_client_h1 = __commonJS({\012  \042lib/dispatcher/client-h1.js\042(exports2, module2) {\012    \042use strict\042;\012    var assert = require(\042node:assert\042);\012    var util = require_util();\012    var { channels } = require_diagnostics();\012    var timers = require_timers();\012    var {\012      RequestContentLengthMismatchError,\012      ResponseContentLengthMismatchError,\012      RequestAbortedError,\012      HeadersTimeoutError,\012      HeadersOverflowError,\012      SocketError,\012      InformationalError,\012      BodyTimeoutError,\012      HTTPParserError,\012      ResponseExceededMaxSizeError\012    } = require_errors();\012    var {\012      kUrl,\012      kReset,\012      kClient,\012      kParser,\012      kBlocking,\012      kRunning,\012      kPending,\012      kSize,\012      kWriting,\012      kQueue,\012      kNoRef,\012      kKeepAliveDefaultTimeout,\012      kHostHeader,\012      kPendingIdx,\012      kRunningIdx,\012      kError,\012      kPipelining,\012      kSocket,\012      kKeepAliveTimeoutValue,\012      kMaxHeadersSize,\012      kKeepAliveMaxTimeout,\012      kKeepAliveTimeoutThreshold,\012      kHeadersTimeout,\012      kBodyTimeout,\012      kStrictContentLength,\012      kMaxRequests,\012      kCounter,\012      kMaxResponseSize,\012      kOnError,\012      kResume,\012      kHTTPContext\012    } = require_symbols();\012    var constants = require_constants2();\012    var EMPTY_BUF = Buffer.alloc(0);\012    var FastBuffer = Buffer[Symbol.species];\012    var addListener = util.addListener;\012    var removeAllListeners = util.removeAllListeners;\012    var extractBody;\012    async function lazyllhttp() {\012      const llhttpWasmData = process.env.JEST_WORKER_ID \077 require_llhttp_wasm() : void 0;\012      let mod;\012      try {\012        mod = await WebAssembly.compile(require_llhttp_simd_wasm());\012      } catch (e) {\012        mod = await WebAssembly.compile(llhttpWasmData || require_llhttp_wasm());\012      }\012      return await WebAssembly.instantiate(mod, {\012        env: {\012          /* eslint-disable camelcase */\012          wasm_on_url: (p, at, len) => {\012            return 0;\012          },\012          wasm_on_status: (p, at, len) => {\012            assert(currentParser.ptr === p);\012            const start = at - currentBufferPtr + currentBufferRef.byteOffset;\012            return currentParser.onStatus(new FastBuffer(currentBufferRef.buffer, start, len)) || 0;\012          },\012          wasm_on_message_begin: (p) => {\012            assert(currentParser.ptr === p);\012            return currentParser.onMessageBegin() || 0;\012          },\012          wasm_on_header_field: (p, at, len) => {\012            assert(currentParser.ptr === p);\012            const start = at - currentBufferPtr + currentBufferRef.byteOffset;\012            return currentParser.onHeaderField(new FastBuffer(currentBufferRef.buffer, start, len)) || 0;\012          },\012          wasm_on_header_value: (p, at, len) => {\012            assert(currentParser.ptr === p);\012            const start = at - currentBufferPtr + currentBufferRef.byteOffset;\012            return currentParser.onHeaderValue(new FastBuffer(currentBufferRef.buffer, start, len)) || 0;\012          },\012          wasm_on_headers_complete: (p, statusCode, upgrade, shouldKeepAlive) => {\012            assert(currentParser.ptr === p);\012            return currentParser.onHeadersComplete(statusCode, Boolean(upgrade), Boolean(shouldKeepAlive)) || 0;\012          },\012          wasm_on_body: (p, at, len) => {\012            assert(currentParser.ptr === p);\012            const start = at - currentBufferPtr + currentBufferRef.byteOffset;\012            return currentParser.onBody(new FastBuffer(currentBufferRef.buffer, start, len)) || 0;\012          },\012          wasm_on_message_complete: (p) => {\012            assert(currentParser.ptr === p);\012            return currentParser.onMessageComplete() || 0;\012          }\012          /* eslint-enable camelcase */\012        }\012      });\012    }\012    __name(lazyllhttp, \042lazyllhttp\042);\012    var llhttpInstance = null;\012    var llhttpPromise = lazyllhttp();\012    llhttpPromise.catch();\012    var currentParser = null;\012    var currentBufferRef = null;\012    var currentBufferSize = 0;\012    var currentBufferPtr = null;\012    var USE_NATIVE_TIMER = 0;\012    var USE_FAST_TIMER = 1;\012    var TIMEOUT_HEADERS = 2 | USE_FAST_TIMER;\012    var TIMEOUT_BODY = 4 | USE_FAST_TIMER;\012    var TIMEOUT_KEEP_ALIVE = 8 | USE_NATIVE_TIMER;\012    var Parser = class {\012      static {\012        __name(this, \042Parser\042);\012      }\012      constructor(client, socket, { exports: exports3 }) {\012        assert(Number.isFinite(client[kMaxHeadersSize]) && client[kMaxHeadersSize] > 0);\012        this.llhttp = exports3;\012        this.ptr = this.llhttp.llhttp_alloc(constants.TYPE.RESPONSE);\012        this.client = client;\012        this.socket = socket;\012        this.timeout = null;\012        this.timeoutValue = null;\012        this.timeoutType = null;\012        this.statusCode = null;\012        this.statusText = \042\042;\012        this.upgrade = false;\012        this.headers = [];\012        this.headersSize = 0;\012        this.headersMaxSize = client[kMaxHeadersSize];\012        this.shouldKeepAlive = false;\012        this.paused = false;\012        this.resume = this.resume.bind(this);\012        this.bytesRead = 0;\012        this.keepAlive = \042\042;\012        this.contentLength = \042\042;\012        this.connection = \042\042;\012        this.maxResponseSize = client[kMaxResponseSize];\012      }\012      setTimeout(delay, type) {\012        if (delay !== this.timeoutValue || type & USE_FAST_TIMER ^ this.timeoutType & USE_FAST_TIMER) {\012          if (this.timeout) {\012            timers.clearTimeout(this.timeout);\012            this.timeout = null;\012          }\012          if (delay) {\012            if (type & USE_FAST_TIMER) {\012              this.timeout = timers.setFastTimeout(onParserTimeout, delay, new WeakRef(this));\012            } else {\012              this.timeout = setTimeout(onParserTimeout, delay, new WeakRef(this));\012              this.timeout.unref();\012            }\012          }\012          this.timeoutValue = delay;\012        } else if (this.timeout) {\012          if (this.timeout.refresh) {\012            this.timeout.refresh();\012          }\012        }\012        this.timeoutType = type;\012      }\012      resume() {\012        if (this.socket.destroyed || !this.paused) {\012          return;\012        }\012        assert(this.ptr != null);\012        assert(currentParser == null);\012        this.llhttp.llhttp_resume(this.ptr);\012        assert(this.timeoutType === TIMEOUT_BODY);\012        if (this.timeout) {\012          if (this.timeout.refresh) {\012            this.timeout.refresh();\012          }\012        }\012        this.paused = false;\012        this.execute(this.socket.read() || EMPTY_BUF);\012        this.readMore();\012      }\012      readMore() {\012        while (!this.paused && this.ptr) {\012          const chunk = this.socket.read();\012          if (chunk === null) {\012            break;\012          }\012          this.execute(chunk);\012        }\012      }\012      execute(data) {\012        assert(this.ptr != null);\012        assert(currentParser == null);\012        assert(!this.paused);\012        const { socket, llhttp } = this;\012        if (data.length > currentBufferSize) {\012          if (currentBufferPtr) {\012            llhttp.free(currentBufferPtr);\012          }\012          currentBufferSize = Math.ceil(data.length / 4096) * 4096;\012          currentBufferPtr = llhttp.malloc(currentBufferSize);\012        }\012        new Uint8Array(llhttp.memory.buffer, currentBufferPtr, currentBufferSize).set(data);\012        try {\012          let ret;\012          try {\012            currentBufferRef = data;\012            currentParser = this;\012            ret = llhttp.llhttp_execute(this.ptr, currentBufferPtr, data.length);\012          } catch (err) {\012            throw err;\012          } finally {\012            currentParser = null;\012            currentBufferRef = null;\012          }\012          const offset = llhttp.llhttp_get_error_pos(this.ptr) - currentBufferPtr;\012          if (ret === constants.ERROR.PAUSED_UPGRADE) {\012            this.onUpgrade(data.slice(offset));\012          } else if (ret === constants.ERROR.PAUSED) {\012            this.paused = true;\012            socket.unshift(data.slice(offset));\012          } else if (ret !== constants.ERROR.OK) {\012            const ptr = llhttp.llhttp_get_error_reason(this.ptr);\012            let message = \042\042;\012            if (ptr) {\012              const len = new Uint8Array(llhttp.memory.buffer, ptr).indexOf(0);\012              message = \042Response does not match the HTTP/1.1 protocol (\042 + Buffer.from(llhttp.memory.buffer, ptr, len).toString() + \042)\042;\012            }\012            throw new HTTPParserError(message, constants.ERROR[ret], data.slice(offset));\012          }\012        } catch (err) {\012          util.destroy(socket, err);\012        }\012      }\012      destroy() {\012        assert(this.ptr != null);\012        assert(currentParser == null);\012        this.llhttp.llhttp_free(this.ptr);\012        this.ptr = null;\012        this.timeout && timers.clearTimeout(this.timeout);\012        this.timeout = null;\012        this.timeoutValue = null;\012        this.timeoutType = null;\012        this.paused = false;\012      }\012      onStatus(buf) {\012        this.statusText = buf.toString();\012      }\012      onMessageBegin() {\012        const { socket, client } = this;\012        if (socket.destroyed) {\012          return -1;\012        }\012        const request = client[kQueue][client[kRunningIdx]];\012        if (!request) {\012          return -1;\012        }\012        request.onResponseStarted();\012      }\012      onHeaderField(buf) {\012        const len = this.headers.length;\012        if ((len & 1) === 0) {\012          this.headers.push(buf);\012        } else {\012          this.headers[len - 1] = Buffer.concat([this.headers[len - 1], buf]);\012        }\012        this.trackHeader(buf.length);\012      }\012      onHeaderValue(buf) {\012        let len = this.headers.length;\012        if ((len & 1) === 1) {\012          this.headers.push(buf);\012          len += 1;\012        } else {\012          this.headers[len - 1] = Buffer.concat([this.headers[len - 1], buf]);\012        }\012        const key = this.headers[len - 2];\012        if (key.length === 10) {\012          const headerName = util.bufferToLowerCasedHeaderName(key);\012          if (headerName === \042keep-alive\042) {\012            this.keepAlive += buf.toString();\012          } else if (headerName === \042connection\042) {\012            this.connection += buf.toString();\012          }\012        } else if (key.length === 14 && util.bufferToLowerCasedHeaderName(key) === \042content-length\042) {\012          this.contentLength += buf.toString();\012        }\012        this.trackHeader(buf.length);\012      }\012      trackHeader(len) {\012        this.headersSize += len;\012        if (this.headersSize >= this.headersMaxSize) {\012          util.destroy(this.socket, new HeadersOverflowError());\012        }\012      }\012      onUpgrade(head) {\012        const { upgrade, client, socket, headers, statusCode } = this;\012        assert(upgrade);\012        assert(client[kSocket] === socket);\012        assert(!socket.destroyed);\012        assert(!this.paused);\012        assert((headers.length & 1) === 0);\012        const request = client[kQueue][client[kRunningIdx]];\012        assert(request);\012        assert(request.upgrade || request.method === \042CONNECT\042);\012        this.statusCode = null;\012        this.statusText = \042\042;\012        this.shouldKeepAlive = null;\012        this.headers = [];\012        this.headersSize = 0;\012        socket.unshift(head);\012        socket[kParser].destroy();\012        socket[kParser] = null;\012        socket[kClient] = null;\012        socket[kError] = null;\012        removeAllListeners(socket);\012        client[kSocket] = null;\012        client[kHTTPContext] = null;\012        client[kQueue][client[kRunningIdx]++] = null;\012        client.emit(\042disconnect\042, client[kUrl], [client], new InformationalError(\042upgrade\042));\012        try {\012          request.onUpgrade(statusCode, headers, socket);\012        } catch (err) {\012          util.destroy(socket, err);\012        }\012        client[kResume]();\012      }\012      onHeadersComplete(statusCode, upgrade, shouldKeepAlive) {\012        const { client, socket, headers, statusText } = this;\012        if (socket.destroyed) {\012          return -1;\012        }\012        const request = client[kQueue][client[kRunningIdx]];\012        if (!request) {\012          return -1;\012        }\012        assert(!this.upgrade);\012        assert(this.statusCode < 200);\012        if (statusCode === 100) {\012          util.destroy(socket, new SocketError(\042bad response\042, util.getSocketInfo(socket)));\012          return -1;\012        }\012        if (upgrade && !request.upgrade) {\012          util.destroy(socket, new SocketError(\042bad upgrade\042, util.getSocketInfo(socket)));\012          return -1;\012        }\012        assert(this.timeoutType === TIMEOUT_HEADERS);\012        this.statusCode = statusCode;\012        this.shouldKeepAlive = shouldKeepAlive || // Override llhttp value which does not allow keepAlive for HEAD.\012        request.method === \042HEAD\042 && !socket[kReset] && this.connection.toLowerCase() === \042keep-alive\042;\012        if (this.statusCode >= 200) {\012          const bodyTimeout = request.bodyTimeout != null \077 request.bodyTimeout : client[kBodyTimeout];\012          this.setTimeout(bodyTimeout, TIMEOUT_BODY);\012        } else if (this.timeout) {\012          if (this.timeout.refresh) {\012            this.timeout.refresh();\012          }\012        }\012        if (request.method === \042CONNECT\042) {\012          assert(client[kRunning] === 1);\012          this.upgrade = true;\012          return 2;\012        }\012        if (upgrade) {\012          assert(client[kRunning] === 1);\012          this.upgrade = true;\012          return 2;\012        }\012        assert((this.headers.length & 1) === 0);\012        this.headers = [];\012        this.headersSize = 0;\012        if (this.shouldKeepAlive && client[kPipelining]) {\012          const keepAliveTimeout = this.keepAlive \077 util.parseKeepAliveTimeout(this.keepAlive) : null;\012          if (keepAliveTimeout != null) {\012            const timeout = Math.min(\012              keepAliveTimeout - client[kKeepAliveTimeoutThreshold],\012              client[kKeepAliveMaxTimeout]\012            );\012            if (timeout <= 0) {\012              socket[kReset] = true;\012            } else {\012              client[kKeepAliveTimeoutValue] = timeout;\012            }\012          } else {\012            client[kKeepAliveTimeoutValue] = client[kKeepAliveDefaultTimeout];\012          }\012        } else {\012          socket[kReset] = true;\012        }\012        const pause = request.onHeaders(statusCode, headers, this.resume, statusText) === false;\012        if (request.aborted) {\012          return -1;\012        }\012        if (request.method === \042HEAD\042) {\012          return 1;\012        }\012        if (statusCode < 200) {\012          return 1;\012        }\012        if (socket[kBlocking]) {\012          socket[kBlocking] = false;\012          client[kResume]();\012        }\012        return pause \077 constants.ERROR.PAUSED : 0;\012      }\012      onBody(buf) {\012        const { client, socket, statusCode, maxResponseSize } = this;\012        if (socket.destroyed) {\012          return -1;\012        }\012        const request = client[kQueue][client[kRunningIdx]];\012        assert(request);\012        assert(this.timeoutType === TIMEOUT_BODY);\012        if (this.timeout) {\012          if (this.timeout.refresh) {\012            this.timeout.refresh();\012          }\012        }\012        assert(statusCode >= 200);\012        if (maxResponseSize > -1 && this.bytesRead + buf.length > maxResponseSize) {\012          util.destroy(socket, new ResponseExceededMaxSizeError());\012          return -1;\012        }\012        this.bytesRead += buf.length;\012        if (request.onData(buf) === false) {\012          return constants.ERROR.PAUSED;\012        }\012      }\012      onMessageComplete() {\012        const { client, socket, statusCode, upgrade, headers, contentLength, bytesRead, shouldKeepAlive } = this;\012        if (socket.destroyed && (!statusCode || shouldKeepAlive)) {\012          return -1;\012        }\012        if (upgrade) {\012          return;\012        }\012        assert(statusCode >= 100);\012        assert((this.headers.length & 1) === 0);\012        const request = client[kQueue][client[kRunningIdx]];\012        assert(request);\012        this.statusCode = null;\012        this.statusText = \042\042;\012        this.bytesRead = 0;\012        this.contentLength = \042\042;\012        this.keepAlive = \042\042;\012        this.connection = \042\042;\012        this.headers = [];\012        this.headersSize = 0;\012        if (statusCode < 200) {\012          return;\012        }\012        if (request.method !== \042HEAD\042 && contentLength && bytesRead !== parseInt(contentLength, 10)) {\012          util.destroy(socket, new ResponseContentLengthMismatchError());\012          return -1;\012        }\012        request.onComplete(headers);\012        client[kQueue][client[kRunningIdx]++] = null;\012        if (socket[kWriting]) {\012          assert(client[kRunning] === 0);\012          util.destroy(socket, new InformationalError(\042reset\042));\012          return constants.ERROR.PAUSED;\012        } else if (!shouldKeepAlive) {\012          util.destroy(socket, new InformationalError(\042reset\042));\012          return constants.ERROR.PAUSED;\012        } else if (socket[kReset] && client[kRunning] === 0) {\012          util.destroy(socket, new InformationalError(\042reset\042));\012          return constants.ERROR.PAUSED;\012        } else if (client[kPipelining] == null || client[kPipelining] === 1) {\012          setImmediate(() => client[kResume]());\012        } else {\012          client[kResume]();\012        }\012      }\012    };\012    function onParserTimeout(parser) {\012      const { socket, timeoutType, client, paused } = parser.deref();\012      if (timeoutType === TIMEOUT_HEADERS) {\012        if (!socket[kWriting] || socket.writableNeedDrain || client[kRunning] > 1) {\012          assert(!paused, \042cannot be paused while waiting for headers\042);\012          util.destroy(socket, new HeadersTimeoutError());\012        }\012      } else if (timeoutType === TIMEOUT_BODY) {\012        if (!paused) {\012          util.destroy(socket, new BodyTimeoutError());\012        }\012      } else if (timeoutType === TIMEOUT_KEEP_ALIVE) {\012        assert(client[kRunning] === 0 && client[kKeepAliveTimeoutValue]);\012        util.destroy(socket, new InformationalError(\042socket idle timeout\042));\012      }\012    }\012    __name(onParserTimeout, \042onParserTimeout\042);\012    async function connectH1(client, socket) {\012      client[kSocket] = socket;\012      if (!llhttpInstance) {\012        llhttpInstance = await llhttpPromise;\012        llhttpPromise = null;\012      }\012      socket[kNoRef] = false;\012      socket[kWriting] = false;\012      socket[kReset] = false;\012      socket[kBlocking] = false;\012      socket[kParser] = new Parser(client, socket, llhttpInstance);\012      addListener(socket, \042error\042, function(err) {\012        assert(err.code !== \042ERR_TLS_CERT_ALTNAME_INVALID\042);\012        const parser = this[kParser];\012        if (err.code === \042ECONNRESET\042 && parser.statusCode && !parser.shouldKeepAlive) {\012          parser.onMessageComplete();\012          return;\012        }\012        this[kError] = err;\012        this[kClient][kOnError](err);\012      });\012      addListener(socket, \042readable\042, function() {\012        const parser = this[kParser];\012        if (parser) {\012          parser.readMore();\012        }\012      });\012      addListener(socket, \042end\042, function() {\012        const parser = this[kParser];\012        if (parser.statusCode && !parser.shouldKeepAlive) {\012          parser.onMessageComplete();\012          return;\012        }\012        util.destroy(this, new SocketError(\042other side closed\042, util.getSocketInfo(this)));\012      });\012      addListener(socket, \042close\042, function() {\012        const client2 = this[kClient];\012        const parser = this[kParser];\012        if (parser) {\012          if (!this[kError] && parser.statusCode && !parser.shouldKeepAlive) {\012            parser.onMessageComplete();\012          }\012          this[kParser].destroy();\012          this[kParser] = null;\012        }\012        const err = this[kError] || new SocketError(\042closed\042, util.getSocketInfo(this));\012        client2[kSocket] = null;\012        client2[kHTTPContext] = null;\012        if (client2.destroyed) {\012          assert(client2[kPending] === 0);\012          const requests = client2[kQueue].splice(client2[kRunningIdx]);\012          for (let i = 0; i < requests.length; i++) {\012            const request = requests[i];\012            util.errorRequest(client2, request, err);\012          }\012        } else if (client2[kRunning] > 0 && err.code !== \042UND_ERR_INFO\042) {\012          const request = client2[kQueue][client2[kRunningIdx]];\012          client2[kQueue][client2[kRunningIdx]++] = null;\012          util.errorRequest(client2, request, err);\012        }\012        client2[kPendingIdx] = client2[kRunningIdx];\012        assert(client2[kRunning] === 0);\012        client2.emit(\042disconnect\042, client2[kUrl], [client2], err);\012        client2[kResume]();\012      });\012      let closed = false;\012      socket.on(\042close\042, () => {\012        closed = true;\012      });\012      return {\012        version: \042h1\042,\012        defaultPipelining: 1,\012        write(...args) {\012          return writeH1(client, ...args);\012        },\012        resume() {\012          resumeH1(client);\012        },\012        destroy(err, callback) {\012          if (closed) {\012            queueMicrotask(callback);\012          } else {\012            socket.destroy(err).on(\042close\042, callback);\012          }\012        },\012        get destroyed() {\012          return socket.destroyed;\012        },\012        busy(request) {\012          if (socket[kWriting] || socket[kReset] || socket[kBlocking]) {\012            return true;\012          }\012          if (request) {\012            if (client[kRunning] > 0 && !request.idempotent) {\012              return true;\012            }\012            if (client[kRunning] > 0 && (request.upgrade || request.method === \042CONNECT\042)) {\012              return true;\012            }\012            if (client[kRunning] > 0 && util.bodyLength(request.body) !== 0 && (util.isStream(request.body) || util.isAsyncIterable(request.body) || util.isFormDataLike(request.body))) {\012              return true;\012            }\012          }\012          return false;\012        }\012      };\012    }\012    __name(connectH1, \042connectH1\042);\012    function resumeH1(client) {\012      const socket = client[kSocket];\012      if (socket && !socket.destroyed) {\012        if (client[kSize] === 0) {\012          if (!socket[kNoRef] && socket.unref) {\012            socket.unref();\012            socket[kNoRef] = true;\012          }\012        } else if (socket[kNoRef] && socket.ref) {\012          socket.ref();\012          socket[kNoRef] = false;\012        }\012        if (client[kSize] === 0) {\012          if (socket[kParser].timeoutType !== TIMEOUT_KEEP_ALIVE) {\012            socket[kParser].setTimeout(client[kKeepAliveTimeoutValue], TIMEOUT_KEEP_ALIVE);\012          }\012        } else if (client[kRunning] > 0 && socket[kParser].statusCode < 200) {\012          if (socket[kParser].timeoutType !== TIMEOUT_HEADERS) {\012            const request = client[kQueue][client[kRunningIdx]];\012            const headersTimeout = request.headersTimeout != null \077 request.headersTimeout : client[kHeadersTimeout];\012            socket[kParser].setTimeout(headersTimeout, TIMEOUT_HEADERS);\012          }\012        }\012      }\012    }\012    __name(resumeH1, \042resumeH1\042);\012    function shouldSendContentLength(method) {\012      return method !== \042GET\042 && method !== \042HEAD\042 && method !== \042OPTIONS\042 && method !== \042TRACE\042 && method !== \042CONNECT\042;\012    }\012    __name(shouldSendContentLength, \042shouldSendContentLength\042);\012    function writeH1(client, request) {\012      const { method, path, host, upgrade, blocking, reset } = request;\012      let { body, headers, contentLength } = request;\012      const expectsPayload = method === \042PUT\042 || method === \042POST\042 || method === \042PATCH\042 || method === \042QUERY\042 || method === \042PROPFIND\042 || method === \042PROPPATCH\042;\012      if (util.isFormDataLike(body)) {\012        if (!extractBody) {\012          extractBody = require_body().extractBody;\012        }\012        const [bodyStream, contentType] = extractBody(body);\012        if (request.contentType == null) {\012          headers.push(\042content-type\042, contentType);\012        }\012        body = bodyStream.stream;\012        contentLength = bodyStream.length;\012      } else if (util.isBlobLike(body) && request.contentType == null && body.type) {\012        headers.push(\042content-type\042, body.type);\012      }\012      if (body && typeof body.read === \042function\042) {\012        body.read(0);\012      }\012      const bodyLength = util.bodyLength(body);\012      contentLength = bodyLength \077\077 contentLength;\012      if (contentLength === null) {\012        contentLength = request.contentLength;\012      }\012      if (contentLength === 0 && !expectsPayload) {\012        contentLength = null;\012      }\012      if (shouldSendContentLength(method) && contentLength > 0 && request.contentLength !== null && request.contentLength !== contentLength) {\012        if (client[kStrictContentLength]) {\012          util.errorRequest(client, request, new RequestContentLengthMismatchError());\012          return false;\012        }\012        process.emitWarning(new RequestContentLengthMismatchError());\012      }\012      const socket = client[kSocket];\012      const abort = /* @__PURE__ */ __name((err) => {\012        if (request.aborted || request.completed) {\012          return;\012        }\012        util.errorRequest(client, request, err || new RequestAbortedError());\012        util.destroy(body);\012        util.destroy(socket, new InformationalError(\042aborted\042));\012      }, \042abort\042);\012      try {\012        request.onConnect(abort);\012      } catch (err) {\012        util.errorRequest(client, request, err);\012      }\012      if (request.aborted) {\012        return false;\012      }\012      if (method === \042HEAD\042) {\012        socket[kReset] = true;\012      }\012      if (upgrade || method === \042CONNECT\042) {\012        socket[kReset] = true;\012      }\012      if (reset != null) {\012        socket[kReset] = reset;\012      }\012      if (client[kMaxRequests] && socket[kCounter]++ >= client[kMaxRequests]) {\012        socket[kReset] = true;\012      }\012      if (blocking) {\012        socket[kBlocking] = true;\012      }\012      let header = `${method} ${path} HTTP/1.1\134r\012`;\012      if (typeof host === \042string\042) {\012        header += `host: ${host}\134r\012`;\012      } else {\012        header += client[kHostHeader];\012      }\012      if (upgrade) {\012        header += `connection: upgrade\134r\012upgrade: ${upgrade}\134r\012`;\012      } else if (client[kPipelining] && !socket[kReset]) {\012        header += \042connection: keep-alive\134r\134n\042;\012      } else {\012        header += \042connection: close\134r\134n\042;\012      }\012      if (Array.isArray(headers)) {\012        for (let n = 0; n < headers.length; n += 2) {\012          const key = headers[n + 0];\012          const val = headers[n + 1];\012          if (Array.isArray(val)) {\012            for (let i = 0; i < val.length; i++) {\012              header += `${key}: ${val[i]}\134r\012`;\012            }\012          } else {\012            header += `${key}: ${val}\134r\012`;\012          }\012        }\012      }\012      if (channels.sendHeaders.hasSubscribers) {\012        channels.sendHeaders.publish({ request, headers: header, socket });\012      }\012      if (!body || bodyLength === 0) {\012        writeBuffer(abort, null, client, request, socket, contentLength, header, expectsPayload);\012      } else if (util.isBuffer(body)) {\012        writeBuffer(abort, body, client, request, socket, contentLength, header, expectsPayload);\012      } else if (util.isBlobLike(body)) {\012        if (typeof body.stream === \042function\042) {\012          writeIterable(abort, body.stream(), client, request, socket, contentLength, header, expectsPayload);\012        } else {\012          writeBlob(abort, body, client, request, socket, contentLength, header, expectsPayload);\012        }\012      } else if (util.isStream(body)) {\012        writeStream(abort, body, client, request, socket, contentLength, header, expectsPayload);\012      } else if (util.isIterable(body)) {\012        writeIterable(abort, body, client, request, socket, contentLength, header, expectsPayload);\012      } else {\012        assert(false);\012      }\012      return true;\012    }\012    __name(writeH1, \042writeH1\042);\012    function writeStream(abort, body, client, request, socket, contentLength, header, expectsPayload) {\012      assert(contentLength !== 0 || client[kRunning] === 0, \042stream body cannot be pipelined\042);\012      let finished = false;\012      const writer = new AsyncWriter({ abort, socket, request, contentLength, client, expectsPayload, header });\012      const onData = /* @__PURE__ */ __name(function(chunk) {\012        if (finished) {\012          return;\012        }\012        try {\012          if (!writer.write(chunk) && this.pause) {\012            this.pause();\012          }\012        } catch (err) {\012          util.destroy(this, err);\012        }\012      }, \042onData\042);\012      const onDrain = /* @__PURE__ */ __name(function() {\012        if (finished) {\012          return;\012        }\012        if (body.resume) {\012          body.resume();\012        }\012      }, \042onDrain\042);\012      const onClose = /* @__PURE__ */ __name(function() {\012        queueMicrotask(() => {\012          body.removeListener(\042error\042, onFinished);\012        });\012        if (!finished) {\012          const err = new RequestAbortedError();\012          queueMicrotask(() => onFinished(err));\012        }\012      }, \042onClose\042);\012      const onFinished = /* @__PURE__ */ __name(function(err) {\012        if (finished) {\012          return;\012        }\012        finished = true;\012        assert(socket.destroyed || socket[kWriting] && client[kRunning] <= 1);\012        socket.off(\042drain\042, onDrain).off(\042error\042, onFinished);\012        body.removeListener(\042data\042, onData).removeListener(\042end\042, onFinished).removeListener(\042close\042, onClose);\012        if (!err) {\012          try {\012            writer.end();\012          } catch (er) {\012            err = er;\012          }\012        }\012        writer.destroy(err);\012        if (err && (err.code !== \042UND_ERR_INFO\042 || err.message !== \042reset\042)) {\012          util.destroy(body, err);\012        } else {\012          util.destroy(body);\012        }\012      }, \042onFinished\042);\012      body.on(\042data\042, onData).on(\042end\042, onFinished).on(\042error\042, onFinished).on(\042close\042, onClose);\012      if (body.resume) {\012        body.resume();\012      }\012      socket.on(\042drain\042, onDrain).on(\042error\042, onFinished);\012      if (body.errorEmitted \077\077 body.errored) {\012        setImmediate(() => onFinished(body.errored));\012      } else if (body.endEmitted \077\077 body.readableEnded) {\012        setImmediate(() => onFinished(null));\012      }\012      if (body.closeEmitted \077\077 body.closed) {\012        setImmediate(onClose);\012      }\012    }\012    __name(writeStream, \042writeStream\042);\012    function writeBuffer(abort, body, client, request, socket, contentLength, header, expectsPayload) {\012      try {\012        if (!body) {\012          if (contentLength === 0) {\012            socket.write(`${header}content-length: 0\134r\012\134r\012`, \042latin1\042);\012          } else {\012            assert(contentLength === null, \042no body must not have content length\042);\012            socket.write(`${header}\134r\012`, \042latin1\042);\012          }\012        } else if (util.isBuffer(body)) {\012          assert(contentLength === body.byteLength, \042buffer body must have content length\042);\012          socket.cork();\012          socket.write(`${header}content-length: ${contentLength}\134r\012\134r\012`, \042latin1\042);\012          socket.write(body);\012          socket.uncork();\012          request.onBodySent(body);\012          if (!expectsPayload && request.reset !== false) {\012            socket[kReset] = true;\012          }\012        }\012        request.onRequestSent();\012        client[kResume]();\012      } catch (err) {\012        abort(err);\012      }\012    }\012    __name(writeBuffer, \042writeBuffer\042);\012    async function writeBlob(abort, body, client, request, socket, contentLength, header, expectsPayload) {\012      assert(contentLength === body.size, \042blob body must have content length\042);\012      try {\012        if (contentLength != null && contentLength !== body.size) {\012          throw new RequestContentLengthMismatchError();\012        }\012        const buffer = Buffer.from(await body.arrayBuffer());\012        socket.cork();\012        socket.write(`${header}content-length: ${contentLength}\134r\012\134r\012`, \042latin1\042);\012        socket.write(buffer);\012        socket.uncork();\012        request.onBodySent(buffer);\012        request.onRequestSent();\012        if (!expectsPayload && request.reset !== false) {\012          socket[kReset] = true;\012        }\012        client[kResume]();\012      } catch (err) {\012        abort(err);\012      }\012    }\012    __name(writeBlob, \042writeBlob\042);\012    async function writeIterable(abort, body, client, request, socket, contentLength, header, expectsPayload) {\012      assert(contentLength !== 0 || client[kRunning] === 0, \042iterator body cannot be pipelined\042);\012      let callback = null;\012      function onDrain() {\012        if (callback) {\012          const cb = callback;\012          callback = null;\012          cb();\012        }\012      }\012      __name(onDrain, \042onDrain\042);\012      const waitForDrain = /* @__PURE__ */ __name(() => new Promise((resolve, reject) => {\012        assert(callback === null);\012        if (socket[kError]) {\012          reject(socket[kError]);\012        } else {\012          callback = resolve;\012        }\012      }), \042waitForDrain\042);\012      socket.on(\042close\042, onDrain).on(\042drain\042, onDrain);\012      const writer = new AsyncWriter({ abort, socket, request, contentLength, client, expectsPayload, header });\012      try {\012        for await (const chunk of body) {\012          if (socket[kError]) {\012            throw socket[kError];\012          }\012          if (!writer.write(chunk)) {\012            await waitForDrain();\012          }\012        }\012        writer.end();\012      } catch (err) {\012        writer.destroy(err);\012      } finally {\012        socket.off(\042close\042, onDrain).off(\042drain\042, onDrain);\012      }\012    }\012    __name(writeIterable, \042writeIterable\042);\012    var AsyncWriter = class {\012      static {\012        __name(this, \042AsyncWriter\042);\012      }\012      constructor({ abort, socket, request, contentLength, client, expectsPayload, header }) {\012        this.socket = socket;\012        this.request = request;\012        this.contentLength = contentLength;\012        this.client = client;\012        this.bytesWritten = 0;\012        this.expectsPayload = expectsPayload;\012        this.header = header;\012        this.abort = abort;\012        socket[kWriting] = true;\012      }\012      write(chunk) {\012        const { socket, request, contentLength, client, bytesWritten, expectsPayload, header } = this;\012        if (socket[kError]) {\012          throw socket[kError];\012        }\012        if (socket.destroyed) {\012          return false;\012        }\012        const len = Buffer.byteLength(chunk);\012        if (!len) {\012          return true;\012        }\012        if (contentLength !== null && bytesWritten + len > contentLength) {\012          if (client[kStrictContentLength]) {\012            throw new RequestContentLengthMismatchError();\012          }\012          process.emitWarning(new RequestContentLengthMismatchError());\012        }\012        socket.cork();\012        if (bytesWritten === 0) {\012          if (!expectsPayload && request.reset !== false) {\012            socket[kReset] = true;\012          }\012          if (contentLength === null) {\012            socket.write(`${header}transfer-encoding: chunked\134r\012`, \042latin1\042);\012          } else {\012            socket.write(`${header}content-length: ${contentLength}\134r\012\134r\012`, \042latin1\042);\012          }\012        }\012        if (contentLength === null) {\012          socket.write(`\134r\012${len.toString(16)}\134r\012`, \042latin1\042);\012        }\012        this.bytesWritten += len;\012        const ret = socket.write(chunk);\012        socket.uncork();\012        request.onBodySent(chunk);\012        if (!ret) {\012          if (socket[kParser].timeout && socket[kParser].timeoutType === TIMEOUT_HEADERS) {\012            if (socket[kParser].timeout.refresh) {\012              socket[kParser].timeout.refresh();\012            }\012          }\012        }\012        return ret;\012      }\012      end() {\012        const { socket, contentLength, client, bytesWritten, expectsPayload, header, request } = this;\012        request.onRequestSent();\012        socket[kWriting] = false;\012        if (socket[kError]) {\012          throw socket[kError];\012        }\012        if (socket.destroyed) {\012          return;\012        }\012        if (bytesWritten === 0) {\012          if (expectsPayload) {\012            socket.write(`${header}content-length: 0\134r\012\134r\012`, \042latin1\042);\012          } else {\012            socket.write(`${header}\134r\012`, \042latin1\042);\012          }\012        } else if (contentLength === null) {\012          socket.write(\042\134r\134n0\134r\134n\134r\134n\042, \042latin1\042);\012        }\012        if (contentLength !== null && bytesWritten !== contentLength) {\012          if (client[kStrictContentLength]) {\012            throw new RequestContentLengthMismatchError();\012          } else {\012            process.emitWarning(new RequestContentLengthMismatchError());\012          }\012        }\012        if (socket[kParser].timeout && socket[kParser].timeoutType === TIMEOUT_HEADERS) {\012          if (socket[kParser].timeout.refresh) {\012            socket[kParser].timeout.refresh();\012          }\012        }\012        client[kResume]();\012      }\012      destroy(err) {\012        const { socket, client, abort } = this;\012        socket[kWriting] = false;\012        if (err) {\012          assert(client[kRunning] <= 1, \042pipeline should only contain this request\042);\012          abort(err);\012        }\012      }\012    };\012    module2.exports = connectH1;\012  }\012});\012\012// lib/dispatcher/client-h2.js\012var require_client_h2 = __commonJS({\012  \042lib/dispatcher/client-h2.js\042(exports2, module2) {\012    \042use strict\042;\012    var assert = require(\042node:assert\042);\012    var { pipeline } = require(\042node:stream\042);\012    var util = require_util();\012    var {\012      RequestContentLengthMismatchError,\012      RequestAbortedError,\012      SocketError,\012      InformationalError\012    } = require_errors();\012    var {\012      kUrl,\012      kReset,\012      kClient,\012      kRunning,\012      kPending,\012      kQueue,\012      kPendingIdx,\012      kRunningIdx,\012      kError,\012      kSocket,\012      kStrictContentLength,\012      kOnError,\012      kMaxConcurrentStreams,\012      kHTTP2Session,\012      kResume,\012      kSize,\012      kHTTPContext\012    } = require_symbols();\012    var kOpenStreams = Symbol(\042open streams\042);\012    var extractBody;\012    var h2ExperimentalWarned = false;\012    var http2;\012    try {\012      http2 = require(\042node:http2\042);\012    } catch {\012      http2 = { constants: {} };\012    }\012    var {\012      constants: {\012        HTTP2_HEADER_AUTHORITY,\012        HTTP2_HEADER_METHOD,\012        HTTP2_HEADER_PATH,\012        HTTP2_HEADER_SCHEME,\012        HTTP2_HEADER_CONTENT_LENGTH,\012        HTTP2_HEADER_EXPECT,\012        HTTP2_HEADER_STATUS\012      }\012    } = http2;\012    function parseH2Headers(headers) {\012      const result = [];\012      for (const [name, value] of Object.entries(headers)) {\012        if (Array.isArray(value)) {\012          for (const subvalue of value) {\012            result.push(Buffer.from(name), Buffer.from(subvalue));\012          }\012        } else {\012          result.push(Buffer.from(name), Buffer.from(value));\012        }\012      }\012      return result;\012    }\012    __name(parseH2Headers, \042parseH2Headers\042);\012    async function connectH2(client, socket) {\012      client[kSocket] = socket;\012      if (!h2ExperimentalWarned) {\012        h2ExperimentalWarned = true;\012        process.emitWarning(\042H2 support is experimental, expect them to change at any time.\042, {\012          code: \042UNDICI-H2\042\012        });\012      }\012      const session = http2.connect(client[kUrl], {\012        createConnection: () => socket,\012        peerMaxConcurrentStreams: client[kMaxConcurrentStreams]\012      });\012      session[kOpenStreams] = 0;\012      session[kClient] = client;\012      session[kSocket] = socket;\012      util.addListener(session, \042error\042, onHttp2SessionError);\012      util.addListener(session, \042frameError\042, onHttp2FrameError);\012      util.addListener(session, \042end\042, onHttp2SessionEnd);\012      util.addListener(session, \042goaway\042, onHTTP2GoAway);\012      util.addListener(session, \042close\042, function() {\012        const { [kClient]: client2 } = this;\012        const { [kSocket]: socket2 } = client2;\012        const err = this[kSocket][kError] || this[kError] || new SocketError(\042closed\042, util.getSocketInfo(socket2));\012        client2[kHTTP2Session] = null;\012        if (client2.destroyed) {\012          assert(client2[kPending] === 0);\012          const requests = client2[kQueue].splice(client2[kRunningIdx]);\012          for (let i = 0; i < requests.length; i++) {\012            const request = requests[i];\012            util.errorRequest(client2, request, err);\012          }\012        }\012      });\012      session.unref();\012      client[kHTTP2Session] = session;\012      socket[kHTTP2Session] = session;\012      util.addListener(socket, \042error\042, function(err) {\012        assert(err.code !== \042ERR_TLS_CERT_ALTNAME_INVALID\042);\012        this[kError] = err;\012        this[kClient][kOnError](err);\012      });\012      util.addListener(socket, \042end\042, function() {\012        util.destroy(this, new SocketError(\042other side closed\042, util.getSocketInfo(this)));\012      });\012      util.addListener(socket, \042close\042, function() {\012        const err = this[kError] || new SocketError(\042closed\042, util.getSocketInfo(this));\012        client[kSocket] = null;\012        if (this[kHTTP2Session] != null) {\012          this[kHTTP2Session].destroy(err);\012        }\012        client[kPendingIdx] = client[kRunningIdx];\012        assert(client[kRunning] === 0);\012        client.emit(\042disconnect\042, client[kUrl], [client], err);\012        client[kResume]();\012      });\012      let closed = false;\012      socket.on(\042close\042, () => {\012        closed = true;\012      });\012      return {\012        version: \042h2\042,\012        defaultPipelining: Infinity,\012        write(...args) {\012          return writeH2(client, ...args);\012        },\012        resume() {\012          resumeH2(client);\012        },\012        destroy(err, callback) {\012          if (closed) {\012            queueMicrotask(callback);\012          } else {\012            socket.destroy(err).on(\042close\042, callback);\012          }\012        },\012        get destroyed() {\012          return socket.destroyed;\012        },\012        busy() {\012          return false;\012        }\012      };\012    }\012    __name(connectH2, \042connectH2\042);\012    function resumeH2(client) {\012      const socket = client[kSocket];\012      if (socket\077.destroyed === false) {\012        if (client[kSize] === 0 && client[kMaxConcurrentStreams] === 0) {\012          socket.unref();\012          client[kHTTP2Session].unref();\012        } else {\012          socket.ref();\012          client[kHTTP2Session].ref();\012        }\012      }\012    }\012    __name(resumeH2, \042resumeH2\042);\012    function onHttp2SessionError(err) {\012      assert(err.code !== \042ERR_TLS_CERT_ALTNAME_INVALID\042);\012      this[kSocket][kError] = err;\012      this[kClient][kOnError](err);\012    }\012    __name(onHttp2SessionError, \042onHttp2SessionError\042);\012    function onHttp2FrameError(type, code, id) {\012      if (id === 0) {\012        const err = new InformationalError(`HTTP/2: \042frameError\042 received - type ${type}, code ${code}`);\012        this[kSocket][kError] = err;\012        this[kClient][kOnError](err);\012      }\012    }\012    __name(onHttp2FrameError, \042onHttp2FrameError\042);\012    function onHttp2SessionEnd() {\012      const err = new SocketError(\042other side closed\042, util.getSocketInfo(this[kSocket]));\012      this.destroy(err);\012      util.destroy(this[kSocket], err);\012    }\012    __name(onHttp2SessionEnd, \042onHttp2SessionEnd\042);\012    function onHTTP2GoAway(code) {\012      const err = this[kError] || new SocketError(`HTTP/2: \042GOAWAY\042 frame received with code ${code}`, util.getSocketInfo(this));\012      const client = this[kClient];\012      client[kSocket] = null;\012      client[kHTTPContext] = null;\012      if (this[kHTTP2Session] != null) {\012        this[kHTTP2Session].destroy(err);\012        this[kHTTP2Session] = null;\012      }\012      util.destroy(this[kSocket], err);\012      if (client[kRunningIdx] < client[kQueue].length) {\012        const request = client[kQueue][client[kRunningIdx]];\012        client[kQueue][client[kRunningIdx]++] = null;\012        util.errorRequest(client, request, err);\012        client[kPendingIdx] = client[kRunningIdx];\012      }\012      assert(client[kRunning] === 0);\012      client.emit(\042disconnect\042, client[kUrl], [client], err);\012      client[kResume]();\012    }\012    __name(onHTTP2GoAway, \042onHTTP2GoAway\042);\012    function shouldSendContentLength(method) {\012      return method !== \042GET\042 && method !== \042HEAD\042 && method !== \042OPTIONS\042 && method !== \042TRACE\042 && method !== \042CONNECT\042;\012    }\012    __name(shouldSendContentLength, \042shouldSendContentLength\042);\012    function writeH2(client, request) {\012      const session = client[kHTTP2Session];\012      const { method, path, host, upgrade, expectContinue, signal, headers: reqHeaders } = request;\012      let { body } = request;\012      if (upgrade) {\012        util.errorRequest(client, request, new Error(\042Upgrade not supported for H2\042));\012        return false;\012      }\012      const headers = {};\012      for (let n = 0; n < reqHeaders.length; n += 2) {\012        const key = reqHeaders[n + 0];\012        const val = reqHeaders[n + 1];\012        if (Array.isArray(val)) {\012          for (let i = 0; i < val.length; i++) {\012            if (headers[key]) {\012              headers[key] += `,${val[i]}`;\012            } else {\012              headers[key] = val[i];\012            }\012          }\012        } else {\012          headers[key] = val;\012        }\012      }\012      let stream;\012      const { hostname, port } = client[kUrl];\012      headers[HTTP2_HEADER_AUTHORITY] = host || `${hostname}${port \077 `:${port}` : \042\042}`;\012      headers[HTTP2_HEADER_METHOD] = method;\012      const abort = /* @__PURE__ */ __name((err) => {\012        if (request.aborted || request.completed) {\012          return;\012        }\012        err = err || new RequestAbortedError();\012        util.errorRequest(client, request, err);\012        if (stream != null) {\012          util.destroy(stream, err);\012        }\012        util.destroy(body, err);\012        client[kQueue][client[kRunningIdx]++] = null;\012        client[kResume]();\012      }, \042abort\042);\012      try {\012        request.onConnect(abort);\012      } catch (err) {\012        util.errorRequest(client, request, err);\012      }\012      if (request.aborted) {\012        return false;\012      }\012      if (method === \042CONNECT\042) {\012        session.ref();\012        stream = session.request(headers, { endStream: false, signal });\012        if (stream.id && !stream.pending) {\012          request.onUpgrade(null, null, stream);\012          ++session[kOpenStreams];\012          client[kQueue][client[kRunningIdx]++] = null;\012        } else {\012          stream.once(\042ready\042, () => {\012            request.onUpgrade(null, null, stream);\012            ++session[kOpenStreams];\012            client[kQueue][client[kRunningIdx]++] = null;\012          });\012        }\012        stream.once(\042close\042, () => {\012          session[kOpenStreams] -= 1;\012          if (session[kOpenStreams] === 0)\012            session.unref();\012        });\012        return true;\012      }\012      headers[HTTP2_HEADER_PATH] = path;\012      headers[HTTP2_HEADER_SCHEME] = \042https\042;\012      const expectsPayload = method === \042PUT\042 || method === \042POST\042 || method === \042PATCH\042;\012      if (body && typeof body.read === \042function\042) {\012        body.read(0);\012      }\012      let contentLength = util.bodyLength(body);\012      if (util.isFormDataLike(body)) {\012        extractBody \077\077= require_body().extractBody;\012        const [bodyStream, contentType] = extractBody(body);\012        headers[\042content-type\042] = contentType;\012        body = bodyStream.stream;\012        contentLength = bodyStream.length;\012      }\012      if (contentLength == null) {\012        contentLength = request.contentLength;\012      }\012      if (contentLength === 0 || !expectsPayload) {\012        contentLength = null;\012      }\012      if (shouldSendContentLength(method) && contentLength > 0 && request.contentLength != null && request.contentLength !== contentLength) {\012        if (client[kStrictContentLength]) {\012          util.errorRequest(client, request, new RequestContentLengthMismatchError());\012          return false;\012        }\012        process.emitWarning(new RequestContentLengthMismatchError());\012      }\012      if (contentLength != null) {\012        assert(body, \042no body must not have content length\042);\012        headers[HTTP2_HEADER_CONTENT_LENGTH] = `${contentLength}`;\012      }\012      session.ref();\012      const shouldEndStream = method === \042GET\042 || method === \042HEAD\042 || body === null;\012      if (expectContinue) {\012        headers[HTTP2_HEADER_EXPECT] = \042100-continue\042;\012        stream = session.request(headers, { endStream: shouldEndStream, signal });\012        stream.once(\042continue\042, writeBodyH2);\012      } else {\012        stream = session.request(headers, {\012          endStream: shouldEndStream,\012          signal\012        });\012        writeBodyH2();\012      }\012      ++session[kOpenStreams];\012      stream.once(\042response\042, (headers2) => {\012        const { [HTTP2_HEADER_STATUS]: statusCode, ...realHeaders } = headers2;\012        request.onResponseStarted();\012        if (request.aborted) {\012          const err = new RequestAbortedError();\012          util.errorRequest(client, request, err);\012          util.destroy(stream, err);\012          return;\012        }\012        if (request.onHeaders(Number(statusCode), parseH2Headers(realHeaders), stream.resume.bind(stream), \042\042) === false) {\012          stream.pause();\012        }\012        stream.on(\042data\042, (chunk) => {\012          if (request.onData(chunk) === false) {\012            stream.pause();\012          }\012        });\012      });\012      stream.once(\042end\042, () => {\012        if (stream.state\077.state == null || stream.state.state < 6) {\012          request.onComplete([]);\012        }\012        if (session[kOpenStreams] === 0) {\012          session.unref();\012        }\012        abort(new InformationalError(\042HTTP/2: stream half-closed (remote)\042));\012        client[kQueue][client[kRunningIdx]++] = null;\012        client[kPendingIdx] = client[kRunningIdx];\012        client[kResume]();\012      });\012      stream.once(\042close\042, () => {\012        session[kOpenStreams] -= 1;\012        if (session[kOpenStreams] === 0) {\012          session.unref();\012        }\012      });\012      stream.once(\042error\042, function(err) {\012        abort(err);\012      });\012      stream.once(\042frameError\042, (type, code) => {\012        abort(new InformationalError(`HTTP/2: \042frameError\042 received - type ${type}, code ${code}`));\012      });\012      return true;\012      function writeBodyH2() {\012        if (!body || contentLength === 0) {\012          writeBuffer(\012            abort,\012            stream,\012            null,\012            client,\012            request,\012            client[kSocket],\012            contentLength,\012            expectsPayload\012          );\012        } else if (util.isBuffer(body)) {\012          writeBuffer(\012            abort,\012            stream,\012            body,\012            client,\012            request,\012            client[kSocket],\012            contentLength,\012            expectsPayload\012          );\012        } else if (util.isBlobLike(body)) {\012          if (typeof body.stream === \042function\042) {\012            writeIterable(\012              abort,\012              stream,\012              body.stream(),\012              client,\012              request,\012              client[kSocket],\012              contentLength,\012              expectsPayload\012            );\012          } else {\012            writeBlob(\012              abort,\012              stream,\012              body,\012              client,\012              request,\012              client[kSocket],\012              contentLength,\012              expectsPayload\012            );\012          }\012        } else if (util.isStream(body)) {\012          writeStream(\012            abort,\012            client[kSocket],\012            expectsPayload,\012            stream,\012            body,\012            client,\012            request,\012            contentLength\012          );\012        } else if (util.isIterable(body)) {\012          writeIterable(\012            abort,\012            stream,\012            body,\012            client,\012            request,\012            client[kSocket],\012            contentLength,\012            expectsPayload\012          );\012        } else {\012          assert(false);\012        }\012      }\012      __name(writeBodyH2, \042writeBodyH2\042);\012    }\012    __name(writeH2, \042writeH2\042);\012    function writeBuffer(abort, h2stream, body, client, request, socket, contentLength, expectsPayload) {\012      try {\012        if (body != null && util.isBuffer(body)) {\012          assert(contentLength === body.byteLength, \042buffer body must have content length\042);\012          h2stream.cork();\012          h2stream.write(body);\012          h2stream.uncork();\012          h2stream.end();\012          request.onBodySent(body);\012        }\012        if (!expectsPayload) {\012          socket[kReset] = true;\012        }\012        request.onRequestSent();\012        client[kResume]();\012      } catch (error) {\012        abort(error);\012      }\012    }\012    __name(writeBuffer, \042writeBuffer\042);\012    function writeStream(abort, socket, expectsPayload, h2stream, body, client, request, contentLength) {\012      assert(contentLength !== 0 || client[kRunning] === 0, \042stream body cannot be pipelined\042);\012      const pipe = pipeline(\012        body,\012        h2stream,\012        (err) => {\012          if (err) {\012            util.destroy(pipe, err);\012            abort(err);\012          } else {\012            util.removeAllListeners(pipe);\012            request.onRequestSent();\012            if (!expectsPayload) {\012              socket[kReset] = true;\012            }\012            client[kResume]();\012          }\012        }\012      );\012      util.addListener(pipe, \042data\042, onPipeData);\012      function onPipeData(chunk) {\012        request.onBodySent(chunk);\012      }\012      __name(onPipeData, \042onPipeData\042);\012    }\012    __name(writeStream, \042writeStream\042);\012    async function writeBlob(abort, h2stream, body, client, request, socket, contentLength, expectsPayload) {\012      assert(contentLength === body.size, \042blob body must have content length\042);\012      try {\012        if (contentLength != null && contentLength !== body.size) {\012          throw new RequestContentLengthMismatchError();\012        }\012        const buffer = Buffer.from(await body.arrayBuffer());\012        h2stream.cork();\012        h2stream.write(buffer);\012        h2stream.uncork();\012        h2stream.end();\012        request.onBodySent(buffer);\012        request.onRequestSent();\012        if (!expectsPayload) {\012          socket[kReset] = true;\012        }\012        client[kResume]();\012      } catch (err) {\012        abort(err);\012      }\012    }\012    __name(writeBlob, \042writeBlob\042);\012    async function writeIterable(abort, h2stream, body, client, request, socket, contentLength, expectsPayload) {\012      assert(contentLength !== 0 || client[kRunning] === 0, \042iterator body cannot be pipelined\042);\012      let callback = null;\012      function onDrain() {\012        if (callback) {\012          const cb = callback;\012          callback = null;\012          cb();\012        }\012      }\012      __name(onDrain, \042onDrain\042);\012      const waitForDrain = /* @__PURE__ */ __name(() => new Promise((resolve, reject) => {\012        assert(callback === null);\012        if (socket[kError]) {\012          reject(socket[kError]);\012        } else {\012          callback = resolve;\012        }\012      }), \042waitForDrain\042);\012      h2stream.on(\042close\042, onDrain).on(\042drain\042, onDrain);\012      try {\012        for await (const chunk of body) {\012          if (socket[kError]) {\012            throw socket[kError];\012          }\012          const res = h2stream.write(chunk);\012          request.onBodySent(chunk);\012          if (!res) {\012            await waitForDrain();\012          }\012        }\012        h2stream.end();\012        request.onRequestSent();\012        if (!expectsPayload) {\012          socket[kReset] = true;\012        }\012        client[kResume]();\012      } catch (err) {\012        abort(err);\012      } finally {\012        h2stream.off(\042close\042, onDrain).off(\042drain\042, onDrain);\012      }\012    }\012    __name(writeIterable, \042writeIterable\042);\012    module2.exports = connectH2;\012  }\012});\012\012// lib/handler/redirect-handler.js\012var require_redirect_handler = __commonJS({\012  \042lib/handler/redirect-handler.js\042(exports2, module2) {\012    \042use strict\042;\012    var util = require_util();\012    var { kBodyUsed } = require_symbols();\012    var assert = require(\042node:assert\042);\012    var { InvalidArgumentError } = require_errors();\012    var EE = require(\042node:events\042);\012    var redirectableStatusCodes = [300, 301, 302, 303, 307, 308];\012    var kBody = Symbol(\042body\042);\012    var BodyAsyncIterable = class {\012      static {\012        __name(this, \042BodyAsyncIterable\042);\012      }\012      constructor(body) {\012        this[kBody] = body;\012        this[kBodyUsed] = false;\012      }\012      async *[Symbol.asyncIterator]() {\012        assert(!this[kBodyUsed], \042disturbed\042);\012        this[kBodyUsed] = true;\012        yield* this[kBody];\012      }\012    };\012    var RedirectHandler = class {\012      static {\012        __name(this, \042RedirectHandler\042);\012      }\012      constructor(dispatch, maxRedirections, opts, handler) {\012        if (maxRedirections != null && (!Number.isInteger(maxRedirections) || maxRedirections < 0)) {\012          throw new InvalidArgumentError(\042maxRedirections must be a positive number\042);\012        }\012        util.validateHandler(handler, opts.method, opts.upgrade);\012        this.dispatch = dispatch;\012        this.location = null;\012        this.abort = null;\012        this.opts = { ...opts, maxRedirections: 0 };\012        this.maxRedirections = maxRedirections;\012        this.handler = handler;\012        this.history = [];\012        this.redirectionLimitReached = false;\012        if (util.isStream(this.opts.body)) {\012          if (util.bodyLength(this.opts.body) === 0) {\012            this.opts.body.on(\042data\042, function() {\012              assert(false);\012            });\012          }\012          if (typeof this.opts.body.readableDidRead !== \042boolean\042) {\012            this.opts.body[kBodyUsed] = false;\012            EE.prototype.on.call(this.opts.body, \042data\042, function() {\012              this[kBodyUsed] = true;\012            });\012          }\012        } else if (this.opts.body && typeof this.opts.body.pipeTo === \042function\042) {\012          this.opts.body = new BodyAsyncIterable(this.opts.body);\012        } else if (this.opts.body && typeof this.opts.body !== \042string\042 && !ArrayBuffer.isView(this.opts.body) && util.isIterable(this.opts.body)) {\012          this.opts.body = new BodyAsyncIterable(this.opts.body);\012        }\012      }\012      onConnect(abort) {\012        this.abort = abort;\012        this.handler.onConnect(abort, { history: this.history });\012      }\012      onUpgrade(statusCode, headers, socket) {\012        this.handler.onUpgrade(statusCode, headers, socket);\012      }\012      onError(error) {\012        this.handler.onError(error);\012      }\012      onHeaders(statusCode, headers, resume, statusText) {\012        this.location = this.history.length >= this.maxRedirections || util.isDisturbed(this.opts.body) \077 null : parseLocation(statusCode, headers);\012        if (this.opts.throwOnMaxRedirect && this.history.length >= this.maxRedirections) {\012          if (this.request) {\012            this.request.abort(new Error(\042max redirects\042));\012          }\012          this.redirectionLimitReached = true;\012          this.abort(new Error(\042max redirects\042));\012          return;\012        }\012        if (this.opts.origin) {\012          this.history.push(new URL(this.opts.path, this.opts.origin));\012        }\012        if (!this.location) {\012          return this.handler.onHeaders(statusCode, headers, resume, statusText);\012        }\012        const { origin, pathname, search } = util.parseURL(new URL(this.location, this.opts.origin && new URL(this.opts.path, this.opts.origin)));\012        const path = search \077 `${pathname}${search}` : pathname;\012        this.opts.headers = cleanRequestHeaders(this.opts.headers, statusCode === 303, this.opts.origin !== origin);\012        this.opts.path = path;\012        this.opts.origin = origin;\012        this.opts.maxRedirections = 0;\012        this.opts.query = null;\012        if (statusCode === 303 && this.opts.method !== \042HEAD\042) {\012          this.opts.method = \042GET\042;\012          this.opts.body = null;\012        }\012      }\012      onData(chunk) {\012        if (this.location) {\012        } else {\012          return this.handler.onData(chunk);\012        }\012      }\012      onComplete(trailers) {\012        if (this.location) {\012          this.location = null;\012          this.abort = null;\012          this.dispatch(this.opts, this);\012        } else {\012          this.handler.onComplete(trailers);\012        }\012      }\012      onBodySent(chunk) {\012        if (this.handler.onBodySent) {\012          this.handler.onBodySent(chunk);\012        }\012      }\012    };\012    function parseLocation(statusCode, headers) {\012      if (redirectableStatusCodes.indexOf(statusCode) === -1) {\012        return null;\012      }\012      for (let i = 0; i < headers.length; i += 2) {\012        if (headers[i].length === 8 && util.headerNameToString(headers[i]) === \042location\042) {\012          return headers[i + 1];\012        }\012      }\012    }\012    __name(parseLocation, \042parseLocation\042);\012    function shouldRemoveHeader(header, removeContent, unknownOrigin) {\012      if (header.length === 4) {\012        return util.headerNameToString(header) === \042host\042;\012      }\012      if (removeContent && util.headerNameToString(header).startsWith(\042content-\042)) {\012        return true;\012      }\012      if (unknownOrigin && (header.length === 13 || header.length === 6 || header.length === 19)) {\012        const name = util.headerNameToString(header);\012        return name === \042authorization\042 || name === \042cookie\042 || name === \042proxy-authorization\042;\012      }\012      return false;\012    }\012    __name(shouldRemoveHeader, \042shouldRemoveHeader\042);\012    function cleanRequestHeaders(headers, removeContent, unknownOrigin) {\012      const ret = [];\012      if (Array.isArray(headers)) {\012        for (let i = 0; i < headers.length; i += 2) {\012          if (!shouldRemoveHeader(headers[i], removeContent, unknownOrigin)) {\012            ret.push(headers[i], headers[i + 1]);\012          }\012        }\012      } else if (headers && typeof headers === \042object\042) {\012        for (const key of Object.keys(headers)) {\012          if (!shouldRemoveHeader(key, removeContent, unknownOrigin)) {\012            ret.push(key, headers[key]);\012          }\012        }\012      } else {\012        assert(headers == null, \042headers must be an object or an array\042);\012      }\012      return ret;\012    }\012    __name(cleanRequestHeaders, \042cleanRequestHeaders\042);\012    module2.exports = RedirectHandler;\012  }\012});\012\012// lib/interceptor/redirect-interceptor.js\012var require_redirect_interceptor = __commonJS({\012  \042lib/interceptor/redirect-interceptor.js\042(exports2, module2) {\012    \042use strict\042;\012    var RedirectHandler = require_redirect_handler();\012    function createRedirectInterceptor({ maxRedirections: defaultMaxRedirections }) {\012      return (dispatch) => {\012        return /* @__PURE__ */ __name(function Intercept(opts, handler) {\012          const { maxRedirections = defaultMaxRedirections } = opts;\012          if (!maxRedirections) {\012            return dispatch(opts, handler);\012          }\012          const redirectHandler = new RedirectHandler(dispatch, maxRedirections, opts, handler);\012          opts = { ...opts, maxRedirections: 0 };\012          return dispatch(opts, redirectHandler);\012        }, \042Intercept\042);\012      };\012    }\012    __name(createRedirectInterceptor, \042createRedirectInterceptor\042);\012    module2.exports = createRedirectInterceptor;\012  }\012});\012\012// lib/dispatcher/client.js\012var require_client = __commonJS({\012  \042lib/dispatcher/client.js\042(exports2, module2) {\012    \042use strict\042;\012    var assert = require(\042node:assert\042);\012    var net = require(\042node:net\042);\012    var http = require(\042node:http\042);\012    var util = require_util();\012    var { channels } = require_diagnostics();\012    var Request = require_request();\012    var DispatcherBase = require_dispatcher_base();\012    var {\012      InvalidArgumentError,\012      InformationalError,\012      ClientDestroyedError\012    } = require_errors();\012    var buildConnector = require_connect();\012    var {\012      kUrl,\012      kServerName,\012      kClient,\012      kBusy,\012      kConnect,\012      kResuming,\012      kRunning,\012      kPending,\012      kSize,\012      kQueue,\012      kConnected,\012      kConnecting,\012      kNeedDrain,\012      kKeepAliveDefaultTimeout,\012      kHostHeader,\012      kPendingIdx,\012      kRunningIdx,\012      kError,\012      kPipelining,\012      kKeepAliveTimeoutValue,\012      kMaxHeadersSize,\012      kKeepAliveMaxTimeout,\012      kKeepAliveTimeoutThreshold,\012      kHeadersTimeout,\012      kBodyTimeout,\012      kStrictContentLength,\012      kConnector,\012      kMaxRedirections,\012      kMaxRequests,\012      kCounter,\012      kClose,\012      kDestroy,\012      kDispatch,\012      kInterceptors,\012      kLocalAddress,\012      kMaxResponseSize,\012      kOnError,\012      kHTTPContext,\012      kMaxConcurrentStreams,\012      kResume\012    } = require_symbols();\012    var connectH1 = require_client_h1();\012    var connectH2 = require_client_h2();\012    var deprecatedInterceptorWarned = false;\012    var kClosedResolve = Symbol(\042kClosedResolve\042);\012    var noop = /* @__PURE__ */ __name(() => {\012    }, \042noop\042);\012    function getPipelining(client) {\012      return client[kPipelining] \077\077 client[kHTTPContext]\077.defaultPipelining \077\077 1;\012    }\012    __name(getPipelining, \042getPipelining\042);\012    var Client = class extends DispatcherBase {\012      static {\012        __name(this, \042Client\042);\012      }\012      /**\012       *\012       * @param {string|URL} url\012       * @param {import('../../types/client.js').Client.Options} options\012       */\012      constructor(url, {\012        interceptors,\012        maxHeaderSize,\012        headersTimeout,\012        socketTimeout,\012        requestTimeout,\012        connectTimeout,\012        bodyTimeout,\012        idleTimeout,\012        keepAlive,\012        keepAliveTimeout,\012        maxKeepAliveTimeout,\012        keepAliveMaxTimeout,\012        keepAliveTimeoutThreshold,\012        socketPath,\012        pipelining,\012        tls,\012        strictContentLength,\012        maxCachedSessions,\012        maxRedirections,\012        connect: connect2,\012        maxRequestsPerClient,\012        localAddress,\012        maxResponseSize,\012        autoSelectFamily,\012        autoSelectFamilyAttemptTimeout,\012        // h2\012        maxConcurrentStreams,\012        allowH2\012      } = {}) {\012        super();\012        if (keepAlive !== void 0) {\012          throw new InvalidArgumentError(\042unsupported keepAlive, use pipelining=0 instead\042);\012        }\012        if (socketTimeout !== void 0) {\012          throw new InvalidArgumentError(\042unsupported socketTimeout, use headersTimeout & bodyTimeout instead\042);\012        }\012        if (requestTimeout !== void 0) {\012          throw new InvalidArgumentError(\042unsupported requestTimeout, use headersTimeout & bodyTimeout instead\042);\012        }\012        if (idleTimeout !== void 0) {\012          throw new InvalidArgumentError(\042unsupported idleTimeout, use keepAliveTimeout instead\042);\012        }\012        if (maxKeepAliveTimeout !== void 0) {\012          throw new InvalidArgumentError(\042unsupported maxKeepAliveTimeout, use keepAliveMaxTimeout instead\042);\012        }\012        if (maxHeaderSize != null && !Number.isFinite(maxHeaderSize)) {\012          throw new InvalidArgumentError(\042invalid maxHeaderSize\042);\012        }\012        if (socketPath != null && typeof socketPath !== \042string\042) {\012          throw new InvalidArgumentError(\042invalid socketPath\042);\012        }\012        if (connectTimeout != null && (!Number.isFinite(connectTimeout) || connectTimeout < 0)) {\012          throw new InvalidArgumentError(\042invalid connectTimeout\042);\012        }\012        if (keepAliveTimeout != null && (!Number.isFinite(keepAliveTimeout) || keepAliveTimeout <= 0)) {\012          throw new InvalidArgumentError(\042invalid keepAliveTimeout\042);\012        }\012        if (keepAliveMaxTimeout != null && (!Number.isFinite(keepAliveMaxTimeout) || keepAliveMaxTimeout <= 0)) {\012          throw new InvalidArgumentError(\042invalid keepAliveMaxTimeout\042);\012        }\012        if (keepAliveTimeoutThreshold != null && !Number.isFinite(keepAliveTimeoutThreshold)) {\012          throw new InvalidArgumentError(\042invalid keepAliveTimeoutThreshold\042);\012        }\012        if (headersTimeout != null && (!Number.isInteger(headersTimeout) || headersTimeout < 0)) {\012          throw new InvalidArgumentError(\042headersTimeout must be a positive integer or zero\042);\012        }\012        if (bodyTimeout != null && (!Number.isInteger(bodyTimeout) || bodyTimeout < 0)) {\012          throw new InvalidArgumentError(\042bodyTimeout must be a positive integer or zero\042);\012        }\012        if (connect2 != null && typeof connect2 !== \042function\042 && typeof connect2 !== \042object\042) {\012          throw new InvalidArgumentError(\042connect must be a function or an object\042);\012        }\012        if (maxRedirections != null && (!Number.isInteger(maxRedirections) || maxRedirections < 0)) {\012          throw new InvalidArgumentError(\042maxRedirections must be a positive number\042);\012        }\012        if (maxRequestsPerClient != null && (!Number.isInteger(maxRequestsPerClient) || maxRequestsPerClient < 0)) {\012          throw new InvalidArgumentError(\042maxRequestsPerClient must be a positive number\042);\012        }\012        if (localAddress != null && (typeof localAddress !== \042string\042 || net.isIP(localAddress) === 0)) {\012          throw new InvalidArgumentError(\042localAddress must be valid string IP address\042);\012        }\012        if (maxResponseSize != null && (!Number.isInteger(maxResponseSize) || maxResponseSize < -1)) {\012          throw new InvalidArgumentError(\042maxResponseSize must be a positive number\042);\012        }\012        if (autoSelectFamilyAttemptTimeout != null && (!Number.isInteger(autoSelectFamilyAttemptTimeout) || autoSelectFamilyAttemptTimeout < -1)) {\012          throw new InvalidArgumentError(\042autoSelectFamilyAttemptTimeout must be a positive number\042);\012        }\012        if (allowH2 != null && typeof allowH2 !== \042boolean\042) {\012          throw new InvalidArgumentError(\042allowH2 must be a valid boolean value\042);\012        }\012        if (maxConcurrentStreams != null && (typeof maxConcurrentStreams !== \042number\042 || maxConcurrentStreams < 1)) {\012          throw new InvalidArgumentError(\042maxConcurrentStreams must be a positive integer, greater than 0\042);\012        }\012        if (typeof connect2 !== \042function\042) {\012          connect2 = buildConnector({\012            ...tls,\012            maxCachedSessions,\012            allowH2,\012            socketPath,\012            timeout: connectTimeout,\012            ...autoSelectFamily \077 { autoSelectFamily, autoSelectFamilyAttemptTimeout } : void 0,\012            ...connect2\012          });\012        }\012        if (interceptors\077.Client && Array.isArray(interceptors.Client)) {\012          this[kInterceptors] = interceptors.Client;\012          if (!deprecatedInterceptorWarned) {\012            deprecatedInterceptorWarned = true;\012            process.emitWarning(\042Client.Options#interceptor is deprecated. Use Dispatcher#compose instead.\042, {\012              code: \042UNDICI-CLIENT-INTERCEPTOR-DEPRECATED\042\012            });\012          }\012        } else {\012          this[kInterceptors] = [createRedirectInterceptor({ maxRedirections })];\012        }\012        this[kUrl] = util.parseOrigin(url);\012        this[kConnector] = connect2;\012        this[kPipelining] = pipelining != null \077 pipelining : 1;\012        this[kMaxHeadersSize] = maxHeaderSize || http.maxHeaderSize;\012        this[kKeepAliveDefaultTimeout] = keepAliveTimeout == null \077 4e3 : keepAliveTimeout;\012        this[kKeepAliveMaxTimeout] = keepAliveMaxTimeout == null \077 6e5 : keepAliveMaxTimeout;\012        this[kKeepAliveTimeoutThreshold] = keepAliveTimeoutThreshold == null \077 2e3 : keepAliveTimeoutThreshold;\012        this[kKeepAliveTimeoutValue] = this[kKeepAliveDefaultTimeout];\012        this[kServerName] = null;\012        this[kLocalAddress] = localAddress != null \077 localAddress : null;\012        this[kResuming] = 0;\012        this[kNeedDrain] = 0;\012        this[kHostHeader] = `host: ${this[kUrl].hostname}${this[kUrl].port \077 `:${this[kUrl].port}` : \042\042}\134r\012`;\012        this[kBodyTimeout] = bodyTimeout != null \077 bodyTimeout : 3e5;\012        this[kHeadersTimeout] = headersTimeout != null \077 headersTimeout : 3e5;\012        this[kStrictContentLength] = strictContentLength == null \077 true : strictContentLength;\012        this[kMaxRedirections] = maxRedirections;\012        this[kMaxRequests] = maxRequestsPerClient;\012        this[kClosedResolve] = null;\012        this[kMaxResponseSize] = maxResponseSize > -1 \077 maxResponseSize : -1;\012        this[kMaxConcurrentStreams] = maxConcurrentStreams != null \077 maxConcurrentStreams : 100;\012        this[kHTTPContext] = null;\012        this[kQueue] = [];\012        this[kRunningIdx] = 0;\012        this[kPendingIdx] = 0;\012        this[kResume] = (sync) => resume(this, sync);\012        this[kOnError] = (err) => onError(this, err);\012      }\012      get pipelining() {\012        return this[kPipelining];\012      }\012      set pipelining(value) {\012        this[kPipelining] = value;\012        this[kResume](true);\012      }\012      get [kPending]() {\012        return this[kQueue].length - this[kPendingIdx];\012      }\012      get [kRunning]() {\012        return this[kPendingIdx] - this[kRunningIdx];\012      }\012      get [kSize]() {\012        return this[kQueue].length - this[kRunningIdx];\012      }\012      get [kConnected]() {\012        return !!this[kHTTPContext] && !this[kConnecting] && !this[kHTTPContext].destroyed;\012      }\012      get [kBusy]() {\012        return Boolean(\012          this[kHTTPContext]\077.busy(null) || this[kSize] >= (getPipelining(this) || 1) || this[kPending] > 0\012        );\012      }\012      /* istanbul ignore: only used for test */\012      [kConnect](cb) {\012        connect(this);\012        this.once(\042connect\042, cb);\012      }\012      [kDispatch](opts, handler) {\012        const origin = opts.origin || this[kUrl].origin;\012        const request = new Request(origin, opts, handler);\012        this[kQueue].push(request);\012        if (this[kResuming]) {\012        } else if (util.bodyLength(request.body) == null && util.isIterable(request.body)) {\012          this[kResuming] = 1;\012          queueMicrotask(() => resume(this));\012        } else {\012          this[kResume](true);\012        }\012        if (this[kResuming] && this[kNeedDrain] !== 2 && this[kBusy]) {\012          this[kNeedDrain] = 2;\012        }\012        return this[kNeedDrain] < 2;\012      }\012      async [kClose]() {\012        return new Promise((resolve) => {\012          if (this[kSize]) {\012            this[kClosedResolve] = resolve;\012          } else {\012            resolve(null);\012          }\012        });\012      }\012      async [kDestroy](err) {\012        return new Promise((resolve) => {\012          const requests = this[kQueue].splice(this[kPendingIdx]);\012          for (let i = 0; i < requests.length; i++) {\012            const request = requests[i];\012            util.errorRequest(this, request, err);\012          }\012          const callback = /* @__PURE__ */ __name(() => {\012            if (this[kClosedResolve]) {\012              this[kClosedResolve]();\012              this[kClosedResolve] = null;\012            }\012            resolve(null);\012          }, \042callback\042);\012          if (this[kHTTPContext]) {\012            this[kHTTPContext].destroy(err, callback);\012            this[kHTTPContext] = null;\012          } else {\012            queueMicrotask(callback);\012          }\012          this[kResume]();\012        });\012      }\012    };\012    var createRedirectInterceptor = require_redirect_interceptor();\012    function onError(client, err) {\012      if (client[kRunning] === 0 && err.code !== \042UND_ERR_INFO\042 && err.code !== \042UND_ERR_SOCKET\042) {\012        assert(client[kPendingIdx] === client[kRunningIdx]);\012        const requests = client[kQueue].splice(client[kRunningIdx]);\012        for (let i = 0; i < requests.length; i++) {\012          const request = requests[i];\012          util.errorRequest(client, request, err);\012        }\012        assert(client[kSize] === 0);\012      }\012    }\012    __name(onError, \042onError\042);\012    async function connect(client) {\012      assert(!client[kConnecting]);\012      assert(!client[kHTTPContext]);\012      let { host, hostname, protocol, port } = client[kUrl];\012      if (hostname[0] === \042[\042) {\012        const idx = hostname.indexOf(\042]\042);\012        assert(idx !== -1);\012        const ip = hostname.substring(1, idx);\012        assert(net.isIP(ip));\012        hostname = ip;\012      }\012      client[kConnecting] = true;\012      if (channels.beforeConnect.hasSubscribers) {\012        channels.beforeConnect.publish({\012          connectParams: {\012            host,\012            hostname,\012            protocol,\012            port,\012            version: client[kHTTPContext]\077.version,\012            servername: client[kServerName],\012            localAddress: client[kLocalAddress]\012          },\012          connector: client[kConnector]\012        });\012      }\012      try {\012        const socket = await new Promise((resolve, reject) => {\012          client[kConnector]({\012            host,\012            hostname,\012            protocol,\012            port,\012            servername: client[kServerName],\012            localAddress: client[kLocalAddress]\012          }, (err, socket2) => {\012            if (err) {\012              reject(err);\012            } else {\012              resolve(socket2);\012            }\012          });\012        });\012        if (client.destroyed) {\012          util.destroy(socket.on(\042error\042, noop), new ClientDestroyedError());\012          return;\012        }\012        assert(socket);\012        try {\012          client[kHTTPContext] = socket.alpnProtocol === \042h2\042 \077 await connectH2(client, socket) : await connectH1(client, socket);\012        } catch (err) {\012          socket.destroy().on(\042error\042, noop);\012          throw err;\012        }\012        client[kConnecting] = false;\012        socket[kCounter] = 0;\012        socket[kMaxRequests] = client[kMaxRequests];\012        socket[kClient] = client;\012        socket[kError] = null;\012        if (channels.connected.hasSubscribers) {\012          channels.connected.publish({\012            connectParams: {\012              host,\012              hostname,\012              protocol,\012              port,\012              version: client[kHTTPContext]\077.version,\012              servername: client[kServerName],\012              localAddress: client[kLocalAddress]\012            },\012            connector: client[kConnector],\012            socket\012          });\012        }\012        client.emit(\042connect\042, client[kUrl], [client]);\012      } catch (err) {\012        if (client.destroyed) {\012          return;\012        }\012        client[kConnecting] = false;\012        if (channels.connectError.hasSubscribers) {\012          channels.connectError.publish({\012            connectParams: {\012              host,\012              hostname,\012              protocol,\012              port,\012              version: client[kHTTPContext]\077.version,\012              servername: client[kServerName],\012              localAddress: client[kLocalAddress]\012            },\012            connector: client[kConnector],\012            error: err\012          });\012        }\012        if (err.code === \042ERR_TLS_CERT_ALTNAME_INVALID\042) {\012          assert(client[kRunning] === 0);\012          while (client[kPending] > 0 && client[kQueue][client[kPendingIdx]].servername === client[kServerName]) {\012            const request = client[kQueue][client[kPendingIdx]++];\012            util.errorRequest(client, request, err);\012          }\012        } else {\012          onError(client, err);\012        }\012        client.emit(\042connectionError\042, client[kUrl], [client], err);\012      }\012      client[kResume]();\012    }\012    __name(connect, \042connect\042);\012    function emitDrain(client) {\012      client[kNeedDrain] = 0;\012      client.emit(\042drain\042, client[kUrl], [client]);\012    }\012    __name(emitDrain, \042emitDrain\042);\012    function resume(client, sync) {\012      if (client[kResuming] === 2) {\012        return;\012      }\012      client[kResuming] = 2;\012      _resume(client, sync);\012      client[kResuming] = 0;\012      if (client[kRunningIdx] > 256) {\012        client[kQueue].splice(0, client[kRunningIdx]);\012        client[kPendingIdx] -= client[kRunningIdx];\012        client[kRunningIdx] = 0;\012      }\012    }\012    __name(resume, \042resume\042);\012    function _resume(client, sync) {\012      while (true) {\012        if (client.destroyed) {\012          assert(client[kPending] === 0);\012          return;\012        }\012        if (client[kClosedResolve] && !client[kSize]) {\012          client[kClosedResolve]();\012          client[kClosedResolve] = null;\012          return;\012        }\012        if (client[kHTTPContext]) {\012          client[kHTTPContext].resume();\012        }\012        if (client[kBusy]) {\012          client[kNeedDrain] = 2;\012        } else if (client[kNeedDrain] === 2) {\012          if (sync) {\012            client[kNeedDrain] = 1;\012            queueMicrotask(() => emitDrain(client));\012          } else {\012            emitDrain(client);\012          }\012          continue;\012        }\012        if (client[kPending] === 0) {\012          return;\012        }\012        if (client[kRunning] >= (getPipelining(client) || 1)) {\012          return;\012        }\012        const request = client[kQueue][client[kPendingIdx]];\012        if (client[kUrl].protocol === \042https:\042 && client[kServerName] !== request.servername) {\012          if (client[kRunning] > 0) {\012            return;\012          }\012          client[kServerName] = request.servername;\012          client[kHTTPContext]\077.destroy(new InformationalError(\042servername changed\042), () => {\012            client[kHTTPContext] = null;\012            resume(client);\012          });\012        }\012        if (client[kConnecting]) {\012          return;\012        }\012        if (!client[kHTTPContext]) {\012          connect(client);\012          return;\012        }\012        if (client[kHTTPContext].destroyed) {\012          return;\012        }\012        if (client[kHTTPContext].busy(request)) {\012          return;\012        }\012        if (!request.aborted && client[kHTTPContext].write(request)) {\012          client[kPendingIdx]++;\012        } else {\012          client[kQueue].splice(client[kPendingIdx], 1);\012        }\012      }\012    }\012    __name(_resume, \042_resume\042);\012    module2.exports = Client;\012  }\012});\012\012// lib/dispatcher/pool.js\012var require_pool = __commonJS({\012  \042lib/dispatcher/pool.js\042(exports2, module2) {\012    \042use strict\042;\012    var {\012      PoolBase,\012      kClients,\012      kNeedDrain,\012      kAddClient,\012      kGetDispatcher\012    } = require_pool_base();\012    var Client = require_client();\012    var {\012      InvalidArgumentError\012    } = require_errors();\012    var util = require_util();\012    var { kUrl, kInterceptors } = require_symbols();\012    var buildConnector = require_connect();\012    var kOptions = Symbol(\042options\042);\012    var kConnections = Symbol(\042connections\042);\012    var kFactory = Symbol(\042factory\042);\012    function defaultFactory(origin, opts) {\012      return new Client(origin, opts);\012    }\012    __name(defaultFactory, \042defaultFactory\042);\012    var Pool = class extends PoolBase {\012      static {\012        __name(this, \042Pool\042);\012      }\012      constructor(origin, {\012        connections,\012        factory = defaultFactory,\012        connect,\012        connectTimeout,\012        tls,\012        maxCachedSessions,\012        socketPath,\012        autoSelectFamily,\012        autoSelectFamilyAttemptTimeout,\012        allowH2,\012        ...options\012      } = {}) {\012        super();\012        if (connections != null && (!Number.isFinite(connections) || connections < 0)) {\012          throw new InvalidArgumentError(\042invalid connections\042);\012        }\012        if (typeof factory !== \042function\042) {\012          throw new InvalidArgumentError(\042factory must be a function.\042);\012        }\012        if (connect != null && typeof connect !== \042function\042 && typeof connect !== \042object\042) {\012          throw new InvalidArgumentError(\042connect must be a function or an object\042);\012        }\012        if (typeof connect !== \042function\042) {\012          connect = buildConnector({\012            ...tls,\012            maxCachedSessions,\012            allowH2,\012            socketPath,\012            timeout: connectTimeout,\012            ...autoSelectFamily \077 { autoSelectFamily, autoSelectFamilyAttemptTimeout } : void 0,\012            ...connect\012          });\012        }\012        this[kInterceptors] = options.interceptors\077.Pool && Array.isArray(options.interceptors.Pool) \077 options.interceptors.Pool : [];\012        this[kConnections] = connections || null;\012        this[kUrl] = util.parseOrigin(origin);\012        this[kOptions] = { ...util.deepClone(options), connect, allowH2 };\012        this[kOptions].interceptors = options.interceptors \077 { ...options.interceptors } : void 0;\012        this[kFactory] = factory;\012        this.on(\042connectionError\042, (origin2, targets, error) => {\012          for (const target of targets) {\012            const idx = this[kClients].indexOf(target);\012            if (idx !== -1) {\012              this[kClients].splice(idx, 1);\012            }\012          }\012        });\012      }\012      [kGetDispatcher]() {\012        for (const client of this[kClients]) {\012          if (!client[kNeedDrain]) {\012            return client;\012          }\012        }\012        if (!this[kConnections] || this[kClients].length < this[kConnections]) {\012          const dispatcher = this[kFactory](this[kUrl], this[kOptions]);\012          this[kAddClient](dispatcher);\012          return dispatcher;\012        }\012      }\012    };\012    module2.exports = Pool;\012  }\012});\012\012// lib/dispatcher/agent.js\012var require_agent = __commonJS({\012  \042lib/dispatcher/agent.js\042(exports2, module2) {\012    \042use strict\042;\012    var { InvalidArgumentError } = require_errors();\012    var { kClients, kRunning, kClose, kDestroy, kDispatch, kInterceptors } = require_symbols();\012    var DispatcherBase = require_dispatcher_base();\012    var Pool = require_pool();\012    var Client = require_client();\012    var util = require_util();\012    var createRedirectInterceptor = require_redirect_interceptor();\012    var kOnConnect = Symbol(\042onConnect\042);\012    var kOnDisconnect = Symbol(\042onDisconnect\042);\012    var kOnConnectionError = Symbol(\042onConnectionError\042);\012    var kMaxRedirections = Symbol(\042maxRedirections\042);\012    var kOnDrain = Symbol(\042onDrain\042);\012    var kFactory = Symbol(\042factory\042);\012    var kOptions = Symbol(\042options\042);\012    function defaultFactory(origin, opts) {\012      return opts && opts.connections === 1 \077 new Client(origin, opts) : new Pool(origin, opts);\012    }\012    __name(defaultFactory, \042defaultFactory\042);\012    var Agent = class extends DispatcherBase {\012      static {\012        __name(this, \042Agent\042);\012      }\012      constructor({ factory = defaultFactory, maxRedirections = 0, connect, ...options } = {}) {\012        super();\012        if (typeof factory !== \042function\042) {\012          throw new InvalidArgumentError(\042factory must be a function.\042);\012        }\012        if (connect != null && typeof connect !== \042function\042 && typeof connect !== \042object\042) {\012          throw new InvalidArgumentError(\042connect must be a function or an object\042);\012        }\012        if (!Number.isInteger(maxRedirections) || maxRedirections < 0) {\012          throw new InvalidArgumentError(\042maxRedirections must be a positive number\042);\012        }\012        if (connect && typeof connect !== \042function\042) {\012          connect = { ...connect };\012        }\012        this[kInterceptors] = options.interceptors\077.Agent && Array.isArray(options.interceptors.Agent) \077 options.interceptors.Agent : [createRedirectInterceptor({ maxRedirections })];\012        this[kOptions] = { ...util.deepClone(options), connect };\012        this[kOptions].interceptors = options.interceptors \077 { ...options.interceptors } : void 0;\012        this[kMaxRedirections] = maxRedirections;\012        this[kFactory] = factory;\012        this[kClients] = /* @__PURE__ */ new Map();\012        this[kOnDrain] = (origin, targets) => {\012          this.emit(\042drain\042, origin, [this, ...targets]);\012        };\012        this[kOnConnect] = (origin, targets) => {\012          this.emit(\042connect\042, origin, [this, ...targets]);\012        };\012        this[kOnDisconnect] = (origin, targets, err) => {\012          this.emit(\042disconnect\042, origin, [this, ...targets], err);\012        };\012        this[kOnConnectionError] = (origin, targets, err) => {\012          this.emit(\042connectionError\042, origin, [this, ...targets], err);\012        };\012      }\012      get [kRunning]() {\012        let ret = 0;\012        for (const client of this[kClients].values()) {\012          ret += client[kRunning];\012        }\012        return ret;\012      }\012      [kDispatch](opts, handler) {\012        let key;\012        if (opts.origin && (typeof opts.origin === \042string\042 || opts.origin instanceof URL)) {\012          key = String(opts.origin);\012        } else {\012          throw new InvalidArgumentError(\042opts.origin must be a non-empty string or URL.\042);\012        }\012        let dispatcher = this[kClients].get(key);\012        if (!dispatcher) {\012          dispatcher = this[kFactory](opts.origin, this[kOptions]).on(\042drain\042, this[kOnDrain]).on(\042connect\042, this[kOnConnect]).on(\042disconnect\042, this[kOnDisconnect]).on(\042connectionError\042, this[kOnConnectionError]);\012          this[kClients].set(key, dispatcher);\012        }\012        return dispatcher.dispatch(opts, handler);\012      }\012      async [kClose]() {\012        const closePromises = [];\012        for (const client of this[kClients].values()) {\012          closePromises.push(client.close());\012        }\012        this[kClients].clear();\012        await Promise.all(closePromises);\012      }\012      async [kDestroy](err) {\012        const destroyPromises = [];\012        for (const client of this[kClients].values()) {\012          destroyPromises.push(client.destroy(err));\012        }\012        this[kClients].clear();\012        await Promise.all(destroyPromises);\012      }\012    };\012    module2.exports = Agent;\012  }\012});\012\012// lib/global.js\012var require_global2 = __commonJS({\012  \042lib/global.js\042(exports2, module2) {\012    \042use strict\042;\012    var globalDispatcher = Symbol.for(\042undici.globalDispatcher.1\042);\012    var { InvalidArgumentError } = require_errors();\012    var Agent = require_agent();\012    if (getGlobalDispatcher2() === void 0) {\012      setGlobalDispatcher2(new Agent());\012    }\012    function setGlobalDispatcher2(agent) {\012      if (!agent || typeof agent.dispatch !== \042function\042) {\012        throw new InvalidArgumentError(\042Argument agent must implement Agent\042);\012      }\012      Object.defineProperty(globalThis, globalDispatcher, {\012        value: agent,\012        writable: true,\012        enumerable: false,\012        configurable: false\012      });\012    }\012    __name(setGlobalDispatcher2, \042setGlobalDispatcher\042);\012    function getGlobalDispatcher2() {\012      return globalThis[globalDispatcher];\012    }\012    __name(getGlobalDispatcher2, \042getGlobalDispatcher\042);\012    module2.exports = {\012      setGlobalDispatcher: setGlobalDispatcher2,\012      getGlobalDispatcher: getGlobalDispatcher2\012    };\012  }\012});\012\012// lib/dispatcher/proxy-agent.js\012var require_proxy_agent = __commonJS({\012  \042lib/dispatcher/proxy-agent.js\042(exports2, module2) {\012    \042use strict\042;\012    var { kProxy, kClose, kDestroy, kInterceptors } = require_symbols();\012    var { URL: URL2 } = require(\042node:url\042);\012    var Agent = require_agent();\012    var Pool = require_pool();\012    var DispatcherBase = require_dispatcher_base();\012    var { InvalidArgumentError, RequestAbortedError, SecureProxyConnectionError } = require_errors();\012    var buildConnector = require_connect();\012    var kAgent = Symbol(\042proxy agent\042);\012    var kClient = Symbol(\042proxy client\042);\012    var kProxyHeaders = Symbol(\042proxy headers\042);\012    var kRequestTls = Symbol(\042request tls settings\042);\012    var kProxyTls = Symbol(\042proxy tls settings\042);\012    var kConnectEndpoint = Symbol(\042connect endpoint function\042);\012    function defaultProtocolPort(protocol) {\012      return protocol === \042https:\042 \077 443 : 80;\012    }\012    __name(defaultProtocolPort, \042defaultProtocolPort\042);\012    function defaultFactory(origin, opts) {\012      return new Pool(origin, opts);\012    }\012    __name(defaultFactory, \042defaultFactory\042);\012    var noop = /* @__PURE__ */ __name(() => {\012    }, \042noop\042);\012    var ProxyAgent = class extends DispatcherBase {\012      static {\012        __name(this, \042ProxyAgent\042);\012      }\012      constructor(opts) {\012        super();\012        if (!opts || typeof opts === \042object\042 && !(opts instanceof URL2) && !opts.uri) {\012          throw new InvalidArgumentError(\042Proxy uri is mandatory\042);\012        }\012        const { clientFactory = defaultFactory } = opts;\012        if (typeof clientFactory !== \042function\042) {\012          throw new InvalidArgumentError(\042Proxy opts.clientFactory must be a function.\042);\012        }\012        const url = this.#getUrl(opts);\012        const { href, origin, port, protocol, username, password, hostname: proxyHostname } = url;\012        this[kProxy] = { uri: href, protocol };\012        this[kInterceptors] = opts.interceptors\077.ProxyAgent && Array.isArray(opts.interceptors.ProxyAgent) \077 opts.interceptors.ProxyAgent : [];\012        this[kRequestTls] = opts.requestTls;\012        this[kProxyTls] = opts.proxyTls;\012        this[kProxyHeaders] = opts.headers || {};\012        if (opts.auth && opts.token) {\012          throw new InvalidArgumentError(\042opts.auth cannot be used in combination with opts.token\042);\012        } else if (opts.auth) {\012          this[kProxyHeaders][\042proxy-authorization\042] = `Basic ${opts.auth}`;\012        } else if (opts.token) {\012          this[kProxyHeaders][\042proxy-authorization\042] = opts.token;\012        } else if (username && password) {\012          this[kProxyHeaders][\042proxy-authorization\042] = `Basic ${Buffer.from(`${decodeURIComponent(username)}:${decodeURIComponent(password)}`).toString(\042base64\042)}`;\012        }\012        const connect = buildConnector({ ...opts.proxyTls });\012        this[kConnectEndpoint] = buildConnector({ ...opts.requestTls });\012        this[kClient] = clientFactory(url, { connect });\012        this[kAgent] = new Agent({\012          ...opts,\012          connect: async (opts2, callback) => {\012            let requestedPath = opts2.host;\012            if (!opts2.port) {\012              requestedPath += `:${defaultProtocolPort(opts2.protocol)}`;\012            }\012            try {\012              const { socket, statusCode } = await this[kClient].connect({\012                origin,\012                port,\012                path: requestedPath,\012                signal: opts2.signal,\012                headers: {\012                  ...this[kProxyHeaders],\012                  host: opts2.host\012                },\012                servername: this[kProxyTls]\077.servername || proxyHostname\012              });\012              if (statusCode !== 200) {\012                socket.on(\042error\042, noop).destroy();\012                callback(new RequestAbortedError(`Proxy response (${statusCode}) !== 200 when HTTP Tunneling`));\012              }\012              if (opts2.protocol !== \042https:\042) {\012                callback(null, socket);\012                return;\012              }\012              let servername;\012              if (this[kRequestTls]) {\012                servername = this[kRequestTls].servername;\012              } else {\012                servername = opts2.servername;\012              }\012              this[kConnectEndpoint]({ ...opts2, servername, httpSocket: socket }, callback);\012            } catch (err) {\012              if (err.code === \042ERR_TLS_CERT_ALTNAME_INVALID\042) {\012                callback(new SecureProxyConnectionError(err));\012              } else {\012                callback(err);\012              }\012            }\012          }\012        });\012      }\012      dispatch(opts, handler) {\012        const headers = buildHeaders(opts.headers);\012        throwIfProxyAuthIsSent(headers);\012        if (headers && !(\042host\042 in headers) && !(\042Host\042 in headers)) {\012          const { host } = new URL2(opts.origin);\012          headers.host = host;\012        }\012        return this[kAgent].dispatch(\012          {\012            ...opts,\012            headers\012          },\012          handler\012        );\012      }\012      /**\012       * @param {import('../types/proxy-agent').ProxyAgent.Options | string | URL} opts\012       * @returns {URL}\012       */\012      #getUrl(opts) {\012        if (typeof opts === \042string\042) {\012          return new URL2(opts);\012        } else if (opts instanceof URL2) {\012          return opts;\012        } else {\012          return new URL2(opts.uri);\012        }\012      }\012      async [kClose]() {\012        await this[kAgent].close();\012        await this[kClient].close();\012      }\012      async [kDestroy]() {\012        await this[kAgent].destroy();\012        await this[kClient].destroy();\012      }\012    };\012    function buildHeaders(headers) {\012      if (Array.isArray(headers)) {\012        const headersPair = {};\012        for (let i = 0; i < headers.length; i += 2) {\012          headersPair[headers[i]] = headers[i + 1];\012        }\012        return headersPair;\012      }\012      return headers;\012    }\012    __name(buildHeaders, \042buildHeaders\042);\012    function throwIfProxyAuthIsSent(headers) {\012      const existProxyAuth = headers && Object.keys(headers).find((key) => key.toLowerCase() === \042proxy-authorization\042);\012      if (existProxyAuth) {\012        throw new InvalidArgumentError(\042Proxy-Authorization should be sent in ProxyAgent constructor\042);\012      }\012    }\012    __name(throwIfProxyAuthIsSent, \042throwIfProxyAuthIsSent\042);\012    module2.exports = ProxyAgent;\012  }\012});\012\012// lib/dispatcher/env-http-proxy-agent.js\012var require_env_http_proxy_agent = __commonJS({\012  \042lib/dispatcher/env-http-proxy-agent.js\042(exports2, module2) {\012    \042use strict\042;\012    var DispatcherBase = require_dispatcher_base();\012    var { kClose, kDestroy, kClosed, kDestroyed, kDispatch, kNoProxyAgent, kHttpProxyAgent, kHttpsProxyAgent } = require_symbols();\012    var ProxyAgent = require_proxy_agent();\012    var Agent = require_agent();\012    var DEFAULT_PORTS = {\012      \042http:\042: 80,\012      \042https:\042: 443\012    };\012    var experimentalWarned = false;\012    var EnvHttpProxyAgent2 = class extends DispatcherBase {\012      static {\012        __name(this, \042EnvHttpProxyAgent\042);\012      }\012      #noProxyValue = null;\012      #noProxyEntries = null;\012      #opts = null;\012      constructor(opts = {}) {\012        super();\012        this.#opts = opts;\012        if (!experimentalWarned) {\012          experimentalWarned = true;\012          process.emitWarning(\042EnvHttpProxyAgent is experimental, expect them to change at any time.\042, {\012            code: \042UNDICI-EHPA\042\012          });\012        }\012        const { httpProxy, httpsProxy, noProxy, ...agentOpts } = opts;\012        this[kNoProxyAgent] = new Agent(agentOpts);\012        const HTTP_PROXY = httpProxy \077\077 process.env.http_proxy \077\077 process.env.HTTP_PROXY;\012        if (HTTP_PROXY) {\012          this[kHttpProxyAgent] = new ProxyAgent({ ...agentOpts, uri: HTTP_PROXY });\012        } else {\012          this[kHttpProxyAgent] = this[kNoProxyAgent];\012        }\012        const HTTPS_PROXY = httpsProxy \077\077 process.env.https_proxy \077\077 process.env.HTTPS_PROXY;\012        if (HTTPS_PROXY) {\012          this[kHttpsProxyAgent] = new ProxyAgent({ ...agentOpts, uri: HTTPS_PROXY });\012        } else {\012          this[kHttpsProxyAgent] = this[kHttpProxyAgent];\012        }\012        this.#parseNoProxy();\012      }\012      [kDispatch](opts, handler) {\012        const url = new URL(opts.origin);\012        const agent = this.#getProxyAgentForUrl(url);\012        return agent.dispatch(opts, handler);\012      }\012      async [kClose]() {\012        await this[kNoProxyAgent].close();\012        if (!this[kHttpProxyAgent][kClosed]) {\012          await this[kHttpProxyAgent].close();\012        }\012        if (!this[kHttpsProxyAgent][kClosed]) {\012          await this[kHttpsProxyAgent].close();\012        }\012      }\012      async [kDestroy](err) {\012        await this[kNoProxyAgent].destroy(err);\012        if (!this[kHttpProxyAgent][kDestroyed]) {\012          await this[kHttpProxyAgent].destroy(err);\012        }\012        if (!this[kHttpsProxyAgent][kDestroyed]) {\012          await this[kHttpsProxyAgent].destroy(err);\012        }\012      }\012      #getProxyAgentForUrl(url) {\012        let { protocol, host: hostname, port } = url;\012        hostname = hostname.replace(/:\134d*$/, \042\042).toLowerCase();\012        port = Number.parseInt(port, 10) || DEFAULT_PORTS[protocol] || 0;\012        if (!this.#shouldProxy(hostname, port)) {\012          return this[kNoProxyAgent];\012        }\012        if (protocol === \042https:\042) {\012          return this[kHttpsProxyAgent];\012        }\012        return this[kHttpProxyAgent];\012      }\012      #shouldProxy(hostname, port) {\012        if (this.#noProxyChanged) {\012          this.#parseNoProxy();\012        }\012        if (this.#noProxyEntries.length === 0) {\012          return true;\012        }\012        if (this.#noProxyValue === \042*\042) {\012          return false;\012        }\012        for (let i = 0; i < this.#noProxyEntries.length; i++) {\012          const entry = this.#noProxyEntries[i];\012          if (entry.port && entry.port !== port) {\012            continue;\012          }\012          if (!/^[.*]/.test(entry.hostname)) {\012            if (hostname === entry.hostname) {\012              return false;\012            }\012          } else {\012            if (hostname.endsWith(entry.hostname.replace(/^\134*/, \042\042))) {\012              return false;\012            }\012          }\012        }\012        return true;\012      }\012      #parseNoProxy() {\012        const noProxyValue = this.#opts.noProxy \077\077 this.#noProxyEnv;\012        const noProxySplit = noProxyValue.split(/[,\134s]/);\012        const noProxyEntries = [];\012        for (let i = 0; i < noProxySplit.length; i++) {\012          const entry = noProxySplit[i];\012          if (!entry) {\012            continue;\012          }\012          const parsed = entry.match(/^(.+):(\134d+)$/);\012          noProxyEntries.push({\012            hostname: (parsed \077 parsed[1] : entry).toLowerCase(),\012            port: parsed \077 Number.parseInt(parsed[2], 10) : 0\012          });\012        }\012        this.#noProxyValue = noProxyValue;\012        this.#noProxyEntries = noProxyEntries;\012      }\012      get #noProxyChanged() {\012        if (this.#opts.noProxy !== void 0) {\012          return false;\012        }\012        return this.#noProxyValue !== this.#noProxyEnv;\012      }\012      get #noProxyEnv() {\012        return process.env.no_proxy \077\077 process.env.NO_PROXY \077\077 \042\042;\012      }\012    };\012    module2.exports = EnvHttpProxyAgent2;\012  }\012});\012\012// lib/web/fetch/headers.js\012var require_headers = __commonJS({\012  \042lib/web/fetch/headers.js\042(exports2, module2) {\012    \042use strict\042;\012    var { kConstruct } = require_symbols();\012    var { kEnumerableProperty } = require_util();\012    var {\012      iteratorMixin,\012      isValidHeaderName,\012      isValidHeaderValue\012    } = require_util2();\012    var { webidl } = require_webidl();\012    var assert = require(\042node:assert\042);\012    var util = require(\042node:util\042);\012    var kHeadersMap = Symbol(\042headers map\042);\012    var kHeadersSortedMap = Symbol(\042headers map sorted\042);\012    function isHTTPWhiteSpaceCharCode(code) {\012      return code === 10 || code === 13 || code === 9 || code === 32;\012    }\012    __name(isHTTPWhiteSpaceCharCode, \042isHTTPWhiteSpaceCharCode\042);\012    function headerValueNormalize(potentialValue) {\012      let i = 0;\012      let j = potentialValue.length;\012      while (j > i && isHTTPWhiteSpaceCharCode(potentialValue.charCodeAt(j - 1)))\012        --j;\012      while (j > i && isHTTPWhiteSpaceCharCode(potentialValue.charCodeAt(i)))\012        ++i;\012      return i === 0 && j === potentialValue.length \077 potentialValue : potentialValue.substring(i, j);\012    }\012    __name(headerValueNormalize, \042headerValueNormalize\042);\012    function fill(headers, object) {\012      if (Array.isArray(object)) {\012        for (let i = 0; i < object.length; ++i) {\012          const header = object[i];\012          if (header.length !== 2) {\012            throw webidl.errors.exception({\012              header: \042Headers constructor\042,\012              message: `expected name/value pair to be length 2, found ${header.length}.`\012            });\012          }\012          appendHeader(headers, header[0], header[1]);\012        }\012      } else if (typeof object === \042object\042 && object !== null) {\012        const keys = Object.keys(object);\012        for (let i = 0; i < keys.length; ++i) {\012          appendHeader(headers, keys[i], object[keys[i]]);\012        }\012      } else {\012        throw webidl.errors.conversionFailed({\012          prefix: \042Headers constructor\042,\012          argument: \042Argument 1\042,\012          types: [\042sequence<sequence<ByteString>>\042, \042record<ByteString, ByteString>\042]\012        });\012      }\012    }\012    __name(fill, \042fill\042);\012    function appendHeader(headers, name, value) {\012      value = headerValueNormalize(value);\012      if (!isValidHeaderName(name)) {\012        throw webidl.errors.invalidArgument({\012          prefix: \042Headers.append\042,\012          value: name,\012          type: \042header name\042\012        });\012      } else if (!isValidHeaderValue(value)) {\012        throw webidl.errors.invalidArgument({\012          prefix: \042Headers.append\042,\012          value,\012          type: \042header value\042\012        });\012      }\012      if (getHeadersGuard(headers) === \042immutable\042) {\012        throw new TypeError(\042immutable\042);\012      }\012      return getHeadersList(headers).append(name, value, false);\012    }\012    __name(appendHeader, \042appendHeader\042);\012    function compareHeaderName(a, b) {\012      return a[0] < b[0] \077 -1 : 1;\012    }\012    __name(compareHeaderName, \042compareHeaderName\042);\012    var HeadersList = class _HeadersList {\012      static {\012        __name(this, \042HeadersList\042);\012      }\012      /** @type {[string, string][]|null} */\012      cookies = null;\012      constructor(init) {\012        if (init instanceof _HeadersList) {\012          this[kHeadersMap] = new Map(init[kHeadersMap]);\012          this[kHeadersSortedMap] = init[kHeadersSortedMap];\012          this.cookies = init.cookies === null \077 null : [...init.cookies];\012        } else {\012          this[kHeadersMap] = new Map(init);\012          this[kHeadersSortedMap] = null;\012        }\012      }\012      /**\012       * @see https://fetch.spec.whatwg.org/#header-list-contains\012       * @param {string} name\012       * @param {boolean} isLowerCase\012       */\012      contains(name, isLowerCase) {\012        return this[kHeadersMap].has(isLowerCase \077 name : name.toLowerCase());\012      }\012      clear() {\012        this[kHeadersMap].clear();\012        this[kHeadersSortedMap] = null;\012        this.cookies = null;\012      }\012      /**\012       * @see https://fetch.spec.whatwg.org/#concept-header-list-append\012       * @param {string} name\012       * @param {string} value\012       * @param {boolean} isLowerCase\012       */\012      append(name, value, isLowerCase) {\012        this[kHeadersSortedMap] = null;\012        const lowercaseName = isLowerCase \077 name : name.toLowerCase();\012        const exists = this[kHeadersMap].get(lowercaseName);\012        if (exists) {\012          const delimiter = lowercaseName === \042cookie\042 \077 \042; \042 : \042, \042;\012          this[kHeadersMap].set(lowercaseName, {\012            name: exists.name,\012            value: `${exists.value}${delimiter}${value}`\012          });\012        } else {\012          this[kHeadersMap].set(lowercaseName, { name, value });\012        }\012        if (lowercaseName === \042set-cookie\042) {\012          (this.cookies \077\077= []).push(value);\012        }\012      }\012      /**\012       * @see https://fetch.spec.whatwg.org/#concept-header-list-set\012       * @param {string} name\012       * @param {string} value\012       * @param {boolean} isLowerCase\012       */\012      set(name, value, isLowerCase) {\012        this[kHeadersSortedMap] = null;\012        const lowercaseName = isLowerCase \077 name : name.toLowerCase();\012        if (lowercaseName === \042set-cookie\042) {\012          this.cookies = [value];\012        }\012        this[kHeadersMap].set(lowercaseName, { name, value });\012      }\012      /**\012       * @see https://fetch.spec.whatwg.org/#concept-header-list-delete\012       * @param {string} name\012       * @param {boolean} isLowerCase\012       */\012      delete(name, isLowerCase) {\012        this[kHeadersSortedMap] = null;\012        if (!isLowerCase)\012          name = name.toLowerCase();\012        if (name === \042set-cookie\042) {\012          this.cookies = null;\012        }\012        this[kHeadersMap].delete(name);\012      }\012      /**\012       * @see https://fetch.spec.whatwg.org/#concept-header-list-get\012       * @param {string} name\012       * @param {boolean} isLowerCase\012       * @returns {string | null}\012       */\012      get(name, isLowerCase) {\012        return this[kHeadersMap].get(isLowerCase \077 name : name.toLowerCase())\077.value \077\077 null;\012      }\012      *[Symbol.iterator]() {\012        for (const { 0: name, 1: { value } } of this[kHeadersMap]) {\012          yield [name, value];\012        }\012      }\012      get entries() {\012        const headers = {};\012        if (this[kHeadersMap].size !== 0) {\012          for (const { name, value } of this[kHeadersMap].values()) {\012            headers[name] = value;\012          }\012        }\012        return headers;\012      }\012      rawValues() {\012        return this[kHeadersMap].values();\012      }\012      get entriesList() {\012        const headers = [];\012        if (this[kHeadersMap].size !== 0) {\012          for (const { 0: lowerName, 1: { name, value } } of this[kHeadersMap]) {\012            if (lowerName === \042set-cookie\042) {\012              for (const cookie of this.cookies) {\012                headers.push([name, cookie]);\012              }\012            } else {\012              headers.push([name, value]);\012            }\012          }\012        }\012        return headers;\012      }\012      // https://fetch.spec.whatwg.org/#convert-header-names-to-a-sorted-lowercase-set\012      toSortedArray() {\012        const size = this[kHeadersMap].size;\012        const array = new Array(size);\012        if (size <= 32) {\012          if (size === 0) {\012            return array;\012          }\012          const iterator = this[kHeadersMap][Symbol.iterator]();\012          const firstValue = iterator.next().value;\012          array[0] = [firstValue[0], firstValue[1].value];\012          assert(firstValue[1].value !== null);\012          for (let i = 1, j = 0, right = 0, left = 0, pivot = 0, x, value; i < size; ++i) {\012            value = iterator.next().value;\012            x = array[i] = [value[0], value[1].value];\012            assert(x[1] !== null);\012            left = 0;\012            right = i;\012            while (left < right) {\012              pivot = left + (right - left >> 1);\012              if (array[pivot][0] <= x[0]) {\012                left = pivot + 1;\012              } else {\012                right = pivot;\012              }\012            }\012            if (i !== pivot) {\012              j = i;\012              while (j > left) {\012                array[j] = array[--j];\012              }\012              array[left] = x;\012            }\012          }\012          if (!iterator.next().done) {\012            throw new TypeError(\042Unreachable\042);\012          }\012          return array;\012        } else {\012          let i = 0;\012          for (const { 0: name, 1: { value } } of this[kHeadersMap]) {\012            array[i++] = [name, value];\012            assert(value !== null);\012          }\012          return array.sort(compareHeaderName);\012        }\012      }\012    };\012    var Headers = class _Headers {\012      static {\012        __name(this, \042Headers\042);\012      }\012      #guard;\012      #headersList;\012      constructor(init = void 0) {\012        webidl.util.markAsUncloneable(this);\012        if (init === kConstruct) {\012          return;\012        }\012        this.#headersList = new HeadersList();\012        this.#guard = \042none\042;\012        if (init !== void 0) {\012          init = webidl.converters.HeadersInit(init, \042Headers contructor\042, \042init\042);\012          fill(this, init);\012        }\012      }\012      // https://fetch.spec.whatwg.org/#dom-headers-append\012      append(name, value) {\012        webidl.brandCheck(this, _Headers);\012        webidl.argumentLengthCheck(arguments, 2, \042Headers.append\042);\012        const prefix = \042Headers.append\042;\012        name = webidl.converters.ByteString(name, prefix, \042name\042);\012        value = webidl.converters.ByteString(value, prefix, \042value\042);\012        return appendHeader(this, name, value);\012      }\012      // https://fetch.spec.whatwg.org/#dom-headers-delete\012      delete(name) {\012        webidl.brandCheck(this, _Headers);\012        webidl.argumentLengthCheck(arguments, 1, \042Headers.delete\042);\012        const prefix = \042Headers.delete\042;\012        name = webidl.converters.ByteString(name, prefix, \042name\042);\012        if (!isValidHeaderName(name)) {\012          throw webidl.errors.invalidArgument({\012            prefix: \042Headers.delete\042,\012            value: name,\012            type: \042header name\042\012          });\012        }\012        if (this.#guard === \042immutable\042) {\012          throw new TypeError(\042immutable\042);\012        }\012        if (!this.#headersList.contains(name, false)) {\012          return;\012        }\012        this.#headersList.delete(name, false);\012      }\012      // https://fetch.spec.whatwg.org/#dom-headers-get\012      get(name) {\012        webidl.brandCheck(this, _Headers);\012        webidl.argumentLengthCheck(arguments, 1, \042Headers.get\042);\012        const prefix = \042Headers.get\042;\012        name = webidl.converters.ByteString(name, prefix, \042name\042);\012        if (!isValidHeaderName(name)) {\012          throw webidl.errors.invalidArgument({\012            prefix,\012            value: name,\012            type: \042header name\042\012          });\012        }\012        return this.#headersList.get(name, false);\012      }\012      // https://fetch.spec.whatwg.org/#dom-headers-has\012      has(name) {\012        webidl.brandCheck(this, _Headers);\012        webidl.argumentLengthCheck(arguments, 1, \042Headers.has\042);\012        const prefix = \042Headers.has\042;\012        name = webidl.converters.ByteString(name, prefix, \042name\042);\012        if (!isValidHeaderName(name)) {\012          throw webidl.errors.invalidArgument({\012            prefix,\012            value: name,\012            type: \042header name\042\012          });\012        }\012        return this.#headersList.contains(name, false);\012      }\012      // https://fetch.spec.whatwg.org/#dom-headers-set\012      set(name, value) {\012        webidl.brandCheck(this, _Headers);\012        webidl.argumentLengthCheck(arguments, 2, \042Headers.set\042);\012        const prefix = \042Headers.set\042;\012        name = webidl.converters.ByteString(name, prefix, \042name\042);\012        value = webidl.converters.ByteString(value, prefix, \042value\042);\012        value = headerValueNormalize(value);\012        if (!isValidHeaderName(name)) {\012          throw webidl.errors.invalidArgument({\012            prefix,\012            value: name,\012            type: \042header name\042\012          });\012        } else if (!isValidHeaderValue(value)) {\012          throw webidl.errors.invalidArgument({\012            prefix,\012            value,\012            type: \042header value\042\012          });\012        }\012        if (this.#guard === \042immutable\042) {\012          throw new TypeError(\042immutable\042);\012        }\012        this.#headersList.set(name, value, false);\012      }\012      // https://fetch.spec.whatwg.org/#dom-headers-getsetcookie\012      getSetCookie() {\012        webidl.brandCheck(this, _Headers);\012        const list = this.#headersList.cookies;\012        if (list) {\012          return [...list];\012        }\012        return [];\012      }\012      // https://fetch.spec.whatwg.org/#concept-header-list-sort-and-combine\012      get [kHeadersSortedMap]() {\012        if (this.#headersList[kHeadersSortedMap]) {\012          return this.#headersList[kHeadersSortedMap];\012        }\012        const headers = [];\012        const names = this.#headersList.toSortedArray();\012        const cookies = this.#headersList.cookies;\012        if (cookies === null || cookies.length === 1) {\012          return this.#headersList[kHeadersSortedMap] = names;\012        }\012        for (let i = 0; i < names.length; ++i) {\012          const { 0: name, 1: value } = names[i];\012          if (name === \042set-cookie\042) {\012            for (let j = 0; j < cookies.length; ++j) {\012              headers.push([name, cookies[j]]);\012            }\012          } else {\012            headers.push([name, value]);\012          }\012        }\012        return this.#headersList[kHeadersSortedMap] = headers;\012      }\012      [util.inspect.custom](depth, options) {\012        options.depth \077\077= depth;\012        return `Headers ${util.formatWithOptions(options, this.#headersList.entries)}`;\012      }\012      static getHeadersGuard(o) {\012        return o.#guard;\012      }\012      static setHeadersGuard(o, guard) {\012        o.#guard = guard;\012      }\012      static getHeadersList(o) {\012        return o.#headersList;\012      }\012      static setHeadersList(o, list) {\012        o.#headersList = list;\012      }\012    };\012    var { getHeadersGuard, setHeadersGuard, getHeadersList, setHeadersList } = Headers;\012    Reflect.deleteProperty(Headers, \042getHeadersGuard\042);\012    Reflect.deleteProperty(Headers, \042setHeadersGuard\042);\012    Reflect.deleteProperty(Headers, \042getHeadersList\042);\012    Reflect.deleteProperty(Headers, \042setHeadersList\042);\012    iteratorMixin(\042Headers\042, Headers, kHeadersSortedMap, 0, 1);\012    Object.defineProperties(Headers.prototype, {\012      append: kEnumerableProperty,\012      delete: kEnumerableProperty,\012      get: kEnumerableProperty,\012      has: kEnumerableProperty,\012      set: kEnumerableProperty,\012      getSetCookie: kEnumerableProperty,\012      [Symbol.toStringTag]: {\012        value: \042Headers\042,\012        configurable: true\012      },\012      [util.inspect.custom]: {\012        enumerable: false\012      }\012    });\012    webidl.converters.HeadersInit = function(V, prefix, argument) {\012      if (webidl.util.Type(V) === \042Object\042) {\012        const iterator = Reflect.get(V, Symbol.iterator);\012        if (!util.types.isProxy(V) && iterator === Headers.prototype.entries) {\012          try {\012            return getHeadersList(V).entriesList;\012          } catch {\012          }\012        }\012        if (typeof iterator === \042function\042) {\012          return webidl.converters[\042sequence<sequence<ByteString>>\042](V, prefix, argument, iterator.bind(V));\012        }\012        return webidl.converters[\042record<ByteString, ByteString>\042](V, prefix, argument);\012      }\012      throw webidl.errors.conversionFailed({\012        prefix: \042Headers constructor\042,\012        argument: \042Argument 1\042,\012        types: [\042sequence<sequence<ByteString>>\042, \042record<ByteString, ByteString>\042]\012      });\012    };\012    module2.exports = {\012      fill,\012      // for test.\012      compareHeaderName,\012      Headers,\012      HeadersList,\012      getHeadersGuard,\012      setHeadersGuard,\012      setHeadersList,\012      getHeadersList\012    };\012  }\012});\012\012// lib/web/fetch/response.js\012var require_response = __commonJS({\012  \042lib/web/fetch/response.js\042(exports2, module2) {\012    \042use strict\042;\012    var { Headers, HeadersList, fill, getHeadersGuard, setHeadersGuard, setHeadersList } = require_headers();\012    var { extractBody, cloneBody, mixinBody, hasFinalizationRegistry, streamRegistry, bodyUnusable } = require_body();\012    var util = require_util();\012    var nodeUtil = require(\042node:util\042);\012    var { kEnumerableProperty } = util;\012    var {\012      isValidReasonPhrase,\012      isCancelled,\012      isAborted,\012      isBlobLike,\012      serializeJavascriptValueToJSONString,\012      isErrorLike,\012      isomorphicEncode,\012      environmentSettingsObject: relevantRealm\012    } = require_util2();\012    var {\012      redirectStatusSet,\012      nullBodyStatus\012    } = require_constants3();\012    var { kState, kHeaders } = require_symbols2();\012    var { webidl } = require_webidl();\012    var { FormData } = require_formdata();\012    var { URLSerializer } = require_data_url();\012    var { kConstruct } = require_symbols();\012    var assert = require(\042node:assert\042);\012    var { types } = require(\042node:util\042);\012    var textEncoder = new TextEncoder(\042utf-8\042);\012    var Response = class _Response {\012      static {\012        __name(this, \042Response\042);\012      }\012      // Creates network error Response.\012      static error() {\012        const responseObject = fromInnerResponse(makeNetworkError(), \042immutable\042);\012        return responseObject;\012      }\012      // https://fetch.spec.whatwg.org/#dom-response-json\012      static json(data, init = {}) {\012        webidl.argumentLengthCheck(arguments, 1, \042Response.json\042);\012        if (init !== null) {\012          init = webidl.converters.ResponseInit(init);\012        }\012        const bytes = textEncoder.encode(\012          serializeJavascriptValueToJSONString(data)\012        );\012        const body = extractBody(bytes);\012        const responseObject = fromInnerResponse(makeResponse({}), \042response\042);\012        initializeResponse(responseObject, init, { body: body[0], type: \042application/json\042 });\012        return responseObject;\012      }\012      // Creates a redirect Response that redirects to url with status status.\012      static redirect(url, status = 302) {\012        webidl.argumentLengthCheck(arguments, 1, \042Response.redirect\042);\012        url = webidl.converters.USVString(url);\012        status = webidl.converters[\042unsigned short\042](status);\012        let parsedURL;\012        try {\012          parsedURL = new URL(url, relevantRealm.settingsObject.baseUrl);\012        } catch (err) {\012          throw new TypeError(`Failed to parse URL from ${url}`, { cause: err });\012        }\012        if (!redirectStatusSet.has(status)) {\012          throw new RangeError(`Invalid status code ${status}`);\012        }\012        const responseObject = fromInnerResponse(makeResponse({}), \042immutable\042);\012        responseObject[kState].status = status;\012        const value = isomorphicEncode(URLSerializer(parsedURL));\012        responseObject[kState].headersList.append(\042location\042, value, true);\012        return responseObject;\012      }\012      // https://fetch.spec.whatwg.org/#dom-response\012      constructor(body = null, init = {}) {\012        webidl.util.markAsUncloneable(this);\012        if (body === kConstruct) {\012          return;\012        }\012        if (body !== null) {\012          body = webidl.converters.BodyInit(body);\012        }\012        init = webidl.converters.ResponseInit(init);\012        this[kState] = makeResponse({});\012        this[kHeaders] = new Headers(kConstruct);\012        setHeadersGuard(this[kHeaders], \042response\042);\012        setHeadersList(this[kHeaders], this[kState].headersList);\012        let bodyWithType = null;\012        if (body != null) {\012          const [extractedBody, type] = extractBody(body);\012          bodyWithType = { body: extractedBody, type };\012        }\012        initializeResponse(this, init, bodyWithType);\012      }\012      // Returns response\077s type, e.g., \042cors\042.\012      get type() {\012        webidl.brandCheck(this, _Response);\012        return this[kState].type;\012      }\012      // Returns response\077s URL, if it has one; otherwise the empty string.\012      get url() {\012        webidl.brandCheck(this, _Response);\012        const urlList = this[kState].urlList;\012        const url = urlList[urlList.length - 1] \077\077 null;\012        if (url === null) {\012          return \042\042;\012        }\012        return URLSerializer(url, true);\012      }\012      // Returns whether response was obtained through a redirect.\012      get redirected() {\012        webidl.brandCheck(this, _Response);\012        return this[kState].urlList.length > 1;\012      }\012      // Returns response\077s status.\012      get status() {\012        webidl.brandCheck(this, _Response);\012        return this[kState].status;\012      }\012      // Returns whether response\077s status is an ok status.\012      get ok() {\012        webidl.brandCheck(this, _Response);\012        return this[kState].status >= 200 && this[kState].status <= 299;\012      }\012      // Returns response\077s status message.\012      get statusText() {\012        webidl.brandCheck(this, _Response);\012        return this[kState].statusText;\012      }\012      // Returns response\077s headers as Headers.\012      get headers() {\012        webidl.brandCheck(this, _Response);\012        return this[kHeaders];\012      }\012      get body() {\012        webidl.brandCheck(this, _Response);\012        return this[kState].body \077 this[kState].body.stream : null;\012      }\012      get bodyUsed() {\012        webidl.brandCheck(this, _Response);\012        return !!this[kState].body && util.isDisturbed(this[kState].body.stream);\012      }\012      // Returns a clone of response.\012      clone() {\012        webidl.brandCheck(this, _Response);\012        if (bodyUnusable(this)) {\012          throw webidl.errors.exception({\012            header: \042Response.clone\042,\012            message: \042Body has already been consumed.\042\012          });\012        }\012        const clonedResponse = cloneResponse(this[kState]);\012        return fromInnerResponse(clonedResponse, getHeadersGuard(this[kHeaders]));\012      }\012      [nodeUtil.inspect.custom](depth, options) {\012        if (options.depth === null) {\012          options.depth = 2;\012        }\012        options.colors \077\077= true;\012        const properties = {\012          status: this.status,\012          statusText: this.statusText,\012          headers: this.headers,\012          body: this.body,\012          bodyUsed: this.bodyUsed,\012          ok: this.ok,\012          redirected: this.redirected,\012          type: this.type,\012          url: this.url\012        };\012        return `Response ${nodeUtil.formatWithOptions(options, properties)}`;\012      }\012    };\012    mixinBody(Response);\012    Object.defineProperties(Response.prototype, {\012      type: kEnumerableProperty,\012      url: kEnumerableProperty,\012      status: kEnumerableProperty,\012      ok: kEnumerableProperty,\012      redirected: kEnumerableProperty,\012      statusText: kEnumerableProperty,\012      headers: kEnumerableProperty,\012      clone: kEnumerableProperty,\012      body: kEnumerableProperty,\012      bodyUsed: kEnumerableProperty,\012      [Symbol.toStringTag]: {\012        value: \042Response\042,\012        configurable: true\012      }\012    });\012    Object.defineProperties(Response, {\012      json: kEnumerableProperty,\012      redirect: kEnumerableProperty,\012      error: kEnumerableProperty\012    });\012    function cloneResponse(response) {\012      if (response.internalResponse) {\012        return filterResponse(\012          cloneResponse(response.internalResponse),\012          response.type\012        );\012      }\012      const newResponse = makeResponse({ ...response, body: null });\012      if (response.body != null) {\012        newResponse.body = cloneBody(newResponse, response.body);\012      }\012      return newResponse;\012    }\012    __name(cloneResponse, \042cloneResponse\042);\012    function makeResponse(init) {\012      return {\012        aborted: false,\012        rangeRequested: false,\012        timingAllowPassed: false,\012        requestIncludesCredentials: false,\012        type: \042default\042,\012        status: 200,\012        timingInfo: null,\012        cacheState: \042\042,\012        statusText: \042\042,\012        ...init,\012        headersList: init\077.headersList \077 new HeadersList(init\077.headersList) : new HeadersList(),\012        urlList: init\077.urlList \077 [...init.urlList] : []\012      };\012    }\012    __name(makeResponse, \042makeResponse\042);\012    function makeNetworkError(reason) {\012      const isError = isErrorLike(reason);\012      return makeResponse({\012        type: \042error\042,\012        status: 0,\012        error: isError \077 reason : new Error(reason \077 String(reason) : reason),\012        aborted: reason && reason.name === \042AbortError\042\012      });\012    }\012    __name(makeNetworkError, \042makeNetworkError\042);\012    function isNetworkError(response) {\012      return (\012        // A network error is a response whose type is \042error\042,\012        response.type === \042error\042 && // status is 0\012        response.status === 0\012      );\012    }\012    __name(isNetworkError, \042isNetworkError\042);\012    function makeFilteredResponse(response, state) {\012      state = {\012        internalResponse: response,\012        ...state\012      };\012      return new Proxy(response, {\012        get(target, p) {\012          return p in state \077 state[p] : target[p];\012        },\012        set(target, p, value) {\012          assert(!(p in state));\012          target[p] = value;\012          return true;\012        }\012      });\012    }\012    __name(makeFilteredResponse, \042makeFilteredResponse\042);\012    function filterResponse(response, type) {\012      if (type === \042basic\042) {\012        return makeFilteredResponse(response, {\012          type: \042basic\042,\012          headersList: response.headersList\012        });\012      } else if (type === \042cors\042) {\012        return makeFilteredResponse(response, {\012          type: \042cors\042,\012          headersList: response.headersList\012        });\012      } else if (type === \042opaque\042) {\012        return makeFilteredResponse(response, {\012          type: \042opaque\042,\012          urlList: Object.freeze([]),\012          status: 0,\012          statusText: \042\042,\012          body: null\012        });\012      } else if (type === \042opaqueredirect\042) {\012        return makeFilteredResponse(response, {\012          type: \042opaqueredirect\042,\012          status: 0,\012          statusText: \042\042,\012          headersList: [],\012          body: null\012        });\012      } else {\012        assert(false);\012      }\012    }\012    __name(filterResponse, \042filterResponse\042);\012    function makeAppropriateNetworkError(fetchParams, err = null) {\012      assert(isCancelled(fetchParams));\012      return isAborted(fetchParams) \077 makeNetworkError(Object.assign(new DOMException(\042The operation was aborted.\042, \042AbortError\042), { cause: err })) : makeNetworkError(Object.assign(new DOMException(\042Request was cancelled.\042), { cause: err }));\012    }\012    __name(makeAppropriateNetworkError, \042makeAppropriateNetworkError\042);\012    function initializeResponse(response, init, body) {\012      if (init.status !== null && (init.status < 200 || init.status > 599)) {\012        throw new RangeError('init[\042status\042] must be in the range of 200 to 599, inclusive.');\012      }\012      if (\042statusText\042 in init && init.statusText != null) {\012        if (!isValidReasonPhrase(String(init.statusText))) {\012          throw new TypeError(\042Invalid statusText\042);\012        }\012      }\012      if (\042status\042 in init && init.status != null) {\012        response[kState].status = init.status;\012      }\012      if (\042statusText\042 in init && init.statusText != null) {\012        response[kState].statusText = init.statusText;\012      }\012      if (\042headers\042 in init && init.headers != null) {\012        fill(response[kHeaders], init.headers);\012      }\012      if (body) {\012        if (nullBodyStatus.includes(response.status)) {\012          throw webidl.errors.exception({\012            header: \042Response constructor\042,\012            message: `Invalid response status code ${response.status}`\012          });\012        }\012        response[kState].body = body.body;\012        if (body.type != null && !response[kState].headersList.contains(\042content-type\042, true)) {\012          response[kState].headersList.append(\042content-type\042, body.type, true);\012        }\012      }\012    }\012    __name(initializeResponse, \042initializeResponse\042);\012    function fromInnerResponse(innerResponse, guard) {\012      const response = new Response(kConstruct);\012      response[kState] = innerResponse;\012      response[kHeaders] = new Headers(kConstruct);\012      setHeadersList(response[kHeaders], innerResponse.headersList);\012      setHeadersGuard(response[kHeaders], guard);\012      if (hasFinalizationRegistry && innerResponse.body\077.stream) {\012        streamRegistry.register(response, new WeakRef(innerResponse.body.stream));\012      }\012      return response;\012    }\012    __name(fromInnerResponse, \042fromInnerResponse\042);\012    webidl.converters.ReadableStream = webidl.interfaceConverter(\012      ReadableStream\012    );\012    webidl.converters.FormData = webidl.interfaceConverter(\012      FormData\012    );\012    webidl.converters.URLSearchParams = webidl.interfaceConverter(\012      URLSearchParams\012    );\012    webidl.converters.XMLHttpRequestBodyInit = function(V, prefix, name) {\012      if (typeof V === \042string\042) {\012        return webidl.converters.USVString(V, prefix, name);\012      }\012      if (isBlobLike(V)) {\012        return webidl.converters.Blob(V, prefix, name, { strict: false });\012      }\012      if (ArrayBuffer.isView(V) || types.isArrayBuffer(V)) {\012        return webidl.converters.BufferSource(V, prefix, name);\012      }\012      if (util.isFormDataLike(V)) {\012        return webidl.converters.FormData(V, prefix, name, { strict: false });\012      }\012      if (V instanceof URLSearchParams) {\012        return webidl.converters.URLSearchParams(V, prefix, name);\012      }\012      return webidl.converters.DOMString(V, prefix, name);\012    };\012    webidl.converters.BodyInit = function(V, prefix, argument) {\012      if (V instanceof ReadableStream) {\012        return webidl.converters.ReadableStream(V, prefix, argument);\012      }\012      if (V\077.[Symbol.asyncIterator]) {\012        return V;\012      }\012      return webidl.converters.XMLHttpRequestBodyInit(V, prefix, argument);\012    };\012    webidl.converters.ResponseInit = webidl.dictionaryConverter([\012      {\012        key: \042status\042,\012        converter: webidl.converters[\042unsigned short\042],\012        defaultValue: () => 200\012      },\012      {\012        key: \042statusText\042,\012        converter: webidl.converters.ByteString,\012        defaultValue: () => \042\042\012      },\012      {\012        key: \042headers\042,\012        converter: webidl.converters.HeadersInit\012      }\012    ]);\012    module2.exports = {\012      isNetworkError,\012      makeNetworkError,\012      makeResponse,\012      makeAppropriateNetworkError,\012      filterResponse,\012      Response,\012      cloneResponse,\012      fromInnerResponse\012    };\012  }\012});\012\012// lib/web/fetch/dispatcher-weakref.js\012var require_dispatcher_weakref = __commonJS({\012  \042lib/web/fetch/dispatcher-weakref.js\042(exports2, module2) {\012    \042use strict\042;\012    var { kConnected, kSize } = require_symbols();\012    var CompatWeakRef = class {\012      static {\012        __name(this, \042CompatWeakRef\042);\012      }\012      constructor(value) {\012        this.value = value;\012      }\012      deref() {\012        return this.value[kConnected] === 0 && this.value[kSize] === 0 \077 void 0 : this.value;\012      }\012    };\012    var CompatFinalizer = class {\012      static {\012        __name(this, \042CompatFinalizer\042);\012      }\012      constructor(finalizer) {\012        this.finalizer = finalizer;\012      }\012      register(dispatcher, key) {\012        if (dispatcher.on) {\012          dispatcher.on(\042disconnect\042, () => {\012            if (dispatcher[kConnected] === 0 && dispatcher[kSize] === 0) {\012              this.finalizer(key);\012            }\012          });\012        }\012      }\012      unregister(key) {\012      }\012    };\012    module2.exports = function() {\012      if (process.env.NODE_V8_COVERAGE && process.version.startsWith(\042v18\042)) {\012        process._rawDebug(\042Using compatibility WeakRef and FinalizationRegistry\042);\012        return {\012          WeakRef: CompatWeakRef,\012          FinalizationRegistry: CompatFinalizer\012        };\012      }\012      return { WeakRef, FinalizationRegistry };\012    };\012  }\012});\012\012// lib/web/fetch/request.js\012var require_request2 = __commonJS({\012  \042lib/web/fetch/request.js\042(exports2, module2) {\012    \042use strict\042;\012    var { extractBody, mixinBody, cloneBody, bodyUnusable } = require_body();\012    var { Headers, fill: fillHeaders, HeadersList, setHeadersGuard, getHeadersGuard, setHeadersList, getHeadersList } = require_headers();\012    var { FinalizationRegistry: FinalizationRegistry2 } = require_dispatcher_weakref()();\012    var util = require_util();\012    var nodeUtil = require(\042node:util\042);\012    var {\012      isValidHTTPToken,\012      sameOrigin,\012      environmentSettingsObject\012    } = require_util2();\012    var {\012      forbiddenMethodsSet,\012      corsSafeListedMethodsSet,\012      referrerPolicy,\012      requestRedirect,\012      requestMode,\012      requestCredentials,\012      requestCache,\012      requestDuplex\012    } = require_constants3();\012    var { kEnumerableProperty, normalizedMethodRecordsBase, normalizedMethodRecords } = util;\012    var { kHeaders, kSignal, kState, kDispatcher } = require_symbols2();\012    var { webidl } = require_webidl();\012    var { URLSerializer } = require_data_url();\012    var { kConstruct } = require_symbols();\012    var assert = require(\042node:assert\042);\012    var { getMaxListeners, setMaxListeners, getEventListeners, defaultMaxListeners } = require(\042node:events\042);\012    var kAbortController = Symbol(\042abortController\042);\012    var requestFinalizer = new FinalizationRegistry2(({ signal, abort }) => {\012      signal.removeEventListener(\042abort\042, abort);\012    });\012    var dependentControllerMap = /* @__PURE__ */ new WeakMap();\012    function buildAbort(acRef) {\012      return abort;\012      function abort() {\012        const ac = acRef.deref();\012        if (ac !== void 0) {\012          requestFinalizer.unregister(abort);\012          this.removeEventListener(\042abort\042, abort);\012          ac.abort(this.reason);\012          const controllerList = dependentControllerMap.get(ac.signal);\012          if (controllerList !== void 0) {\012            if (controllerList.size !== 0) {\012              for (const ref of controllerList) {\012                const ctrl = ref.deref();\012                if (ctrl !== void 0) {\012                  ctrl.abort(this.reason);\012                }\012              }\012              controllerList.clear();\012            }\012            dependentControllerMap.delete(ac.signal);\012          }\012        }\012      }\012      __name(abort, \042abort\042);\012    }\012    __name(buildAbort, \042buildAbort\042);\012    var patchMethodWarning = false;\012    var Request = class _Request {\012      static {\012        __name(this, \042Request\042);\012      }\012      // https://fetch.spec.whatwg.org/#dom-request\012      constructor(input, init = {}) {\012        webidl.util.markAsUncloneable(this);\012        if (input === kConstruct) {\012          return;\012        }\012        const prefix = \042Request constructor\042;\012        webidl.argumentLengthCheck(arguments, 1, prefix);\012        input = webidl.converters.RequestInfo(input, prefix, \042input\042);\012        init = webidl.converters.RequestInit(init, prefix, \042init\042);\012        let request = null;\012        let fallbackMode = null;\012        const baseUrl = environmentSettingsObject.settingsObject.baseUrl;\012        let signal = null;\012        if (typeof input === \042string\042) {\012          this[kDispatcher] = init.dispatcher;\012          let parsedURL;\012          try {\012            parsedURL = new URL(input, baseUrl);\012          } catch (err) {\012            throw new TypeError(\042Failed to parse URL from \042 + input, { cause: err });\012          }\012          if (parsedURL.username || parsedURL.password) {\012            throw new TypeError(\012              \042Request cannot be constructed from a URL that includes credentials: \042 + input\012            );\012          }\012          request = makeRequest({ urlList: [parsedURL] });\012          fallbackMode = \042cors\042;\012        } else {\012          this[kDispatcher] = init.dispatcher || input[kDispatcher];\012          assert(input instanceof _Request);\012          request = input[kState];\012          signal = input[kSignal];\012        }\012        const origin = environmentSettingsObject.settingsObject.origin;\012        let window = \042client\042;\012        if (request.window\077.constructor\077.name === \042EnvironmentSettingsObject\042 && sameOrigin(request.window, origin)) {\012          window = request.window;\012        }\012        if (init.window != null) {\012          throw new TypeError(`'window' option '${window}' must be null`);\012        }\012        if (\042window\042 in init) {\012          window = \042no-window\042;\012        }\012        request = makeRequest({\012          // URL request\077s URL.\012          // undici implementation note: this is set as the first item in request's urlList in makeRequest\012          // method request\077s method.\012          method: request.method,\012          // header list A copy of request\077s header list.\012          // undici implementation note: headersList is cloned in makeRequest\012          headersList: request.headersList,\012          // unsafe-request flag Set.\012          unsafeRequest: request.unsafeRequest,\012          // client This\077s relevant settings object.\012          client: environmentSettingsObject.settingsObject,\012          // window window.\012          window,\012          // priority request\077s priority.\012          priority: request.priority,\012          // origin request\077s origin. The propagation of the origin is only significant for navigation requests\012          // being handled by a service worker. In this scenario a request can have an origin that is different\012          // from the current client.\012          origin: request.origin,\012          // referrer request\077s referrer.\012          referrer: request.referrer,\012          // referrer policy request\077s referrer policy.\012          referrerPolicy: request.referrerPolicy,\012          // mode request\077s mode.\012          mode: request.mode,\012          // credentials mode request\077s credentials mode.\012          credentials: request.credentials,\012          // cache mode request\077s cache mode.\012          cache: request.cache,\012          // redirect mode request\077s redirect mode.\012          redirect: request.redirect,\012          // integrity metadata request\077s integrity metadata.\012          integrity: request.integrity,\012          // keepalive request\077s keepalive.\012          keepalive: request.keepalive,\012          // reload-navigation flag request\077s reload-navigation flag.\012          reloadNavigation: request.reloadNavigation,\012          // history-navigation flag request\077s history-navigation flag.\012          historyNavigation: request.historyNavigation,\012          // URL list A clone of request\077s URL list.\012          urlList: [...request.urlList]\012        });\012        const initHasKey = Object.keys(init).length !== 0;\012        if (initHasKey) {\012          if (request.mode === \042navigate\042) {\012            request.mode = \042same-origin\042;\012          }\012          request.reloadNavigation = false;\012          request.historyNavigation = false;\012          request.origin = \042client\042;\012          request.referrer = \042client\042;\012          request.referrerPolicy = \042\042;\012          request.url = request.urlList[request.urlList.length - 1];\012          request.urlList = [request.url];\012        }\012        if (init.referrer !== void 0) {\012          const referrer = init.referrer;\012          if (referrer === \042\042) {\012            request.referrer = \042no-referrer\042;\012          } else {\012            let parsedReferrer;\012            try {\012              parsedReferrer = new URL(referrer, baseUrl);\012            } catch (err) {\012              throw new TypeError(`Referrer \042${referrer}\042 is not a valid URL.`, { cause: err });\012            }\012            if (parsedReferrer.protocol === \042about:\042 && parsedReferrer.hostname === \042client\042 || origin && !sameOrigin(parsedReferrer, environmentSettingsObject.settingsObject.baseUrl)) {\012              request.referrer = \042client\042;\012            } else {\012              request.referrer = parsedReferrer;\012            }\012          }\012        }\012        if (init.referrerPolicy !== void 0) {\012          request.referrerPolicy = init.referrerPolicy;\012        }\012        let mode;\012        if (init.mode !== void 0) {\012          mode = init.mode;\012        } else {\012          mode = fallbackMode;\012        }\012        if (mode === \042navigate\042) {\012          throw webidl.errors.exception({\012            header: \042Request constructor\042,\012            message: \042invalid request mode navigate.\042\012          });\012        }\012        if (mode != null) {\012          request.mode = mode;\012        }\012        if (init.credentials !== void 0) {\012          request.credentials = init.credentials;\012        }\012        if (init.cache !== void 0) {\012          request.cache = init.cache;\012        }\012        if (request.cache === \042only-if-cached\042 && request.mode !== \042same-origin\042) {\012          throw new TypeError(\012            \042'only-if-cached' can be set only with 'same-origin' mode\042\012          );\012        }\012        if (init.redirect !== void 0) {\012          request.redirect = init.redirect;\012        }\012        if (init.integrity != null) {\012          request.integrity = String(init.integrity);\012        }\012        if (init.keepalive !== void 0) {\012          request.keepalive = Boolean(init.keepalive);\012        }\012        if (init.method !== void 0) {\012          let method = init.method;\012          const mayBeNormalized = normalizedMethodRecords[method];\012          if (mayBeNormalized !== void 0) {\012            request.method = mayBeNormalized;\012          } else {\012            if (!isValidHTTPToken(method)) {\012              throw new TypeError(`'${method}' is not a valid HTTP method.`);\012            }\012            const upperCase = method.toUpperCase();\012            if (forbiddenMethodsSet.has(upperCase)) {\012              throw new TypeError(`'${method}' HTTP method is unsupported.`);\012            }\012            method = normalizedMethodRecordsBase[upperCase] \077\077 method;\012            request.method = method;\012          }\012          if (!patchMethodWarning && request.method === \042patch\042) {\012            process.emitWarning(\042Using `patch` is highly likely to result in a `405 Method Not Allowed`. `PATCH` is much more likely to succeed.\042, {\012              code: \042UNDICI-FETCH-patch\042\012            });\012            patchMethodWarning = true;\012          }\012        }\012        if (init.signal !== void 0) {\012          signal = init.signal;\012        }\012        this[kState] = request;\012        const ac = new AbortController();\012        this[kSignal] = ac.signal;\012        if (signal != null) {\012          if (!signal || typeof signal.aborted !== \042boolean\042 || typeof signal.addEventListener !== \042function\042) {\012            throw new TypeError(\012              \042Failed to construct 'Request': member signal is not of type AbortSignal.\042\012            );\012          }\012          if (signal.aborted) {\012            ac.abort(signal.reason);\012          } else {\012            this[kAbortController] = ac;\012            const acRef = new WeakRef(ac);\012            const abort = buildAbort(acRef);\012            try {\012              if (typeof getMaxListeners === \042function\042 && getMaxListeners(signal) === defaultMaxListeners) {\012                setMaxListeners(1500, signal);\012              } else if (getEventListeners(signal, \042abort\042).length >= defaultMaxListeners) {\012                setMaxListeners(1500, signal);\012              }\012            } catch {\012            }\012            util.addAbortListener(signal, abort);\012            requestFinalizer.register(ac, { signal, abort }, abort);\012          }\012        }\012        this[kHeaders] = new Headers(kConstruct);\012        setHeadersList(this[kHeaders], request.headersList);\012        setHeadersGuard(this[kHeaders], \042request\042);\012        if (mode === \042no-cors\042) {\012          if (!corsSafeListedMethodsSet.has(request.method)) {\012            throw new TypeError(\012              `'${request.method} is unsupported in no-cors mode.`\012            );\012          }\012          setHeadersGuard(this[kHeaders], \042request-no-cors\042);\012        }\012        if (initHasKey) {\012          const headersList = getHeadersList(this[kHeaders]);\012          const headers = init.headers !== void 0 \077 init.headers : new HeadersList(headersList);\012          headersList.clear();\012          if (headers instanceof HeadersList) {\012            for (const { name, value } of headers.rawValues()) {\012              headersList.append(name, value, false);\012            }\012            headersList.cookies = headers.cookies;\012          } else {\012            fillHeaders(this[kHeaders], headers);\012          }\012        }\012        const inputBody = input instanceof _Request \077 input[kState].body : null;\012        if ((init.body != null || inputBody != null) && (request.method === \042GET\042 || request.method === \042HEAD\042)) {\012          throw new TypeError(\042Request with GET/HEAD method cannot have body.\042);\012        }\012        let initBody = null;\012        if (init.body != null) {\012          const [extractedBody, contentType] = extractBody(\012            init.body,\012            request.keepalive\012          );\012          initBody = extractedBody;\012          if (contentType && !getHeadersList(this[kHeaders]).contains(\042content-type\042, true)) {\012            this[kHeaders].append(\042content-type\042, contentType);\012          }\012        }\012        const inputOrInitBody = initBody \077\077 inputBody;\012        if (inputOrInitBody != null && inputOrInitBody.source == null) {\012          if (initBody != null && init.duplex == null) {\012            throw new TypeError(\042RequestInit: duplex option is required when sending a body.\042);\012          }\012          if (request.mode !== \042same-origin\042 && request.mode !== \042cors\042) {\012            throw new TypeError(\012              'If request is made from ReadableStream, mode should be \042same-origin\042 or \042cors\042'\012            );\012          }\012          request.useCORSPreflightFlag = true;\012        }\012        let finalBody = inputOrInitBody;\012        if (initBody == null && inputBody != null) {\012          if (bodyUnusable(input)) {\012            throw new TypeError(\012              \042Cannot construct a Request with a Request object that has already been used.\042\012            );\012          }\012          const identityTransform = new TransformStream();\012          inputBody.stream.pipeThrough(identityTransform);\012          finalBody = {\012            source: inputBody.source,\012            length: inputBody.length,\012            stream: identityTransform.readable\012          };\012        }\012        this[kState].body = finalBody;\012      }\012      // Returns request\077s HTTP method, which is \042GET\042 by default.\012      get method() {\012        webidl.brandCheck(this, _Request);\012        return this[kState].method;\012      }\012      // Returns the URL of request as a string.\012      get url() {\012        webidl.brandCheck(this, _Request);\012        return URLSerializer(this[kState].url);\012      }\012      // Returns a Headers object consisting of the headers associated with request.\012      // Note that headers added in the network layer by the user agent will not\012      // be accounted for in this object, e.g., the \042Host\042 header.\012      get headers() {\012        webidl.brandCheck(this, _Request);\012        return this[kHeaders];\012      }\012      // Returns the kind of resource requested by request, e.g., \042document\042\012      // or \042script\042.\012      get destination() {\012        webidl.brandCheck(this, _Request);\012        return this[kState].destination;\012      }\012      // Returns the referrer of request. Its value can be a same-origin URL if\012      // explicitly set in init, the empty string to indicate no referrer, and\012      // \042about:client\042 when defaulting to the global\077s default. This is used\012      // during fetching to determine the value of the `Referer` header of the\012      // request being made.\012      get referrer() {\012        webidl.brandCheck(this, _Request);\012        if (this[kState].referrer === \042no-referrer\042) {\012          return \042\042;\012        }\012        if (this[kState].referrer === \042client\042) {\012          return \042about:client\042;\012        }\012        return this[kState].referrer.toString();\012      }\012      // Returns the referrer policy associated with request.\012      // This is used during fetching to compute the value of the request\077s\012      // referrer.\012      get referrerPolicy() {\012        webidl.brandCheck(this, _Request);\012        return this[kState].referrerPolicy;\012      }\012      // Returns the mode associated with request, which is a string indicating\012      // whether the request will use CORS, or will be restricted to same-origin\012      // URLs.\012      get mode() {\012        webidl.brandCheck(this, _Request);\012        return this[kState].mode;\012      }\012      // Returns the credentials mode associated with request,\012      // which is a string indicating whether credentials will be sent with the\012      // request always, never, or only when sent to a same-origin URL.\012      get credentials() {\012        return this[kState].credentials;\012      }\012      // Returns the cache mode associated with request,\012      // which is a string indicating how the request will\012      // interact with the browser\077s cache when fetching.\012      get cache() {\012        webidl.brandCheck(this, _Request);\012        return this[kState].cache;\012      }\012      // Returns the redirect mode associated with request,\012      // which is a string indicating how redirects for the\012      // request will be handled during fetching. A request\012      // will follow redirects by default.\012      get redirect() {\012        webidl.brandCheck(this, _Request);\012        return this[kState].redirect;\012      }\012      // Returns request\077s subresource integrity metadata, which is a\012      // cryptographic hash of the resource being fetched. Its value\012      // consists of multiple hashes separated by whitespace. [SRI]\012      get integrity() {\012        webidl.brandCheck(this, _Request);\012        return this[kState].integrity;\012      }\012      // Returns a boolean indicating whether or not request can outlive the\012      // global in which it was created.\012      get keepalive() {\012        webidl.brandCheck(this, _Request);\012        return this[kState].keepalive;\012      }\012      // Returns a boolean indicating whether or not request is for a reload\012      // navigation.\012      get isReloadNavigation() {\012        webidl.brandCheck(this, _Request);\012        return this[kState].reloadNavigation;\012      }\012      // Returns a boolean indicating whether or not request is for a history\012      // navigation (a.k.a. back-forward navigation).\012      get isHistoryNavigation() {\012        webidl.brandCheck(this, _Request);\012        return this[kState].historyNavigation;\012      }\012      // Returns the signal associated with request, which is an AbortSignal\012      // object indicating whether or not request has been aborted, and its\012      // abort event handler.\012      get signal() {\012        webidl.brandCheck(this, _Request);\012        return this[kSignal];\012      }\012      get body() {\012        webidl.brandCheck(this, _Request);\012        return this[kState].body \077 this[kState].body.stream : null;\012      }\012      get bodyUsed() {\012        webidl.brandCheck(this, _Request);\012        return !!this[kState].body && util.isDisturbed(this[kState].body.stream);\012      }\012      get duplex() {\012        webidl.brandCheck(this, _Request);\012        return \042half\042;\012      }\012      // Returns a clone of request.\012      clone() {\012        webidl.brandCheck(this, _Request);\012        if (bodyUnusable(this)) {\012          throw new TypeError(\042unusable\042);\012        }\012        const clonedRequest = cloneRequest(this[kState]);\012        const ac = new AbortController();\012        if (this.signal.aborted) {\012          ac.abort(this.signal.reason);\012        } else {\012          let list = dependentControllerMap.get(this.signal);\012          if (list === void 0) {\012            list = /* @__PURE__ */ new Set();\012            dependentControllerMap.set(this.signal, list);\012          }\012          const acRef = new WeakRef(ac);\012          list.add(acRef);\012          util.addAbortListener(\012            ac.signal,\012            buildAbort(acRef)\012          );\012        }\012        return fromInnerRequest(clonedRequest, ac.signal, getHeadersGuard(this[kHeaders]));\012      }\012      [nodeUtil.inspect.custom](depth, options) {\012        if (options.depth === null) {\012          options.depth = 2;\012        }\012        options.colors \077\077= true;\012        const properties = {\012          method: this.method,\012          url: this.url,\012          headers: this.headers,\012          destination: this.destination,\012          referrer: this.referrer,\012          referrerPolicy: this.referrerPolicy,\012          mode: this.mode,\012          credentials: this.credentials,\012          cache: this.cache,\012          redirect: this.redirect,\012          integrity: this.integrity,\012          keepalive: this.keepalive,\012          isReloadNavigation: this.isReloadNavigation,\012          isHistoryNavigation: this.isHistoryNavigation,\012          signal: this.signal\012        };\012        return `Request ${nodeUtil.formatWithOptions(options, properties)}`;\012      }\012    };\012    mixinBody(Request);\012    function makeRequest(init) {\012      return {\012        method: init.method \077\077 \042GET\042,\012        localURLsOnly: init.localURLsOnly \077\077 false,\012        unsafeRequest: init.unsafeRequest \077\077 false,\012        body: init.body \077\077 null,\012        client: init.client \077\077 null,\012        reservedClient: init.reservedClient \077\077 null,\012        replacesClientId: init.replacesClientId \077\077 \042\042,\012        window: init.window \077\077 \042client\042,\012        keepalive: init.keepalive \077\077 false,\012        serviceWorkers: init.serviceWorkers \077\077 \042all\042,\012        initiator: init.initiator \077\077 \042\042,\012        destination: init.destination \077\077 \042\042,\012        priority: init.priority \077\077 null,\012        origin: init.origin \077\077 \042client\042,\012        policyContainer: init.policyContainer \077\077 \042client\042,\012        referrer: init.referrer \077\077 \042client\042,\012        referrerPolicy: init.referrerPolicy \077\077 \042\042,\012        mode: init.mode \077\077 \042no-cors\042,\012        useCORSPreflightFlag: init.useCORSPreflightFlag \077\077 false,\012        credentials: init.credentials \077\077 \042same-origin\042,\012        useCredentials: init.useCredentials \077\077 false,\012        cache: init.cache \077\077 \042default\042,\012        redirect: init.redirect \077\077 \042follow\042,\012        integrity: init.integrity \077\077 \042\042,\012        cryptoGraphicsNonceMetadata: init.cryptoGraphicsNonceMetadata \077\077 \042\042,\012        parserMetadata: init.parserMetadata \077\077 \042\042,\012        reloadNavigation: init.reloadNavigation \077\077 false,\012        historyNavigation: init.historyNavigation \077\077 false,\012        userActivation: init.userActivation \077\077 false,\012        taintedOrigin: init.taintedOrigin \077\077 false,\012        redirectCount: init.redirectCount \077\077 0,\012        responseTainting: init.responseTainting \077\077 \042basic\042,\012        preventNoCacheCacheControlHeaderModification: init.preventNoCacheCacheControlHeaderModification \077\077 false,\012        done: init.done \077\077 false,\012        timingAllowFailed: init.timingAllowFailed \077\077 false,\012        urlList: init.urlList,\012        url: init.urlList[0],\012        headersList: init.headersList \077 new HeadersList(init.headersList) : new HeadersList()\012      };\012    }\012    __name(makeRequest, \042makeRequest\042);\012    function cloneRequest(request) {\012      const newRequest = makeRequest({ ...request, body: null });\012      if (request.body != null) {\012        newRequest.body = cloneBody(newRequest, request.body);\012      }\012      return newRequest;\012    }\012    __name(cloneRequest, \042cloneRequest\042);\012    function fromInnerRequest(innerRequest, signal, guard) {\012      const request = new Request(kConstruct);\012      request[kState] = innerRequest;\012      request[kSignal] = signal;\012      request[kHeaders] = new Headers(kConstruct);\012      setHeadersList(request[kHeaders], innerRequest.headersList);\012      setHeadersGuard(request[kHeaders], guard);\012      return request;\012    }\012    __name(fromInnerRequest, \042fromInnerRequest\042);\012    Object.defineProperties(Request.prototype, {\012      method: kEnumerableProperty,\012      url: kEnumerableProperty,\012      headers: kEnumerableProperty,\012      redirect: kEnumerableProperty,\012      clone: kEnumerableProperty,\012      signal: kEnumerableProperty,\012      duplex: kEnumerableProperty,\012      destination: kEnumerableProperty,\012      body: kEnumerableProperty,\012      bodyUsed: kEnumerableProperty,\012      isHistoryNavigation: kEnumerableProperty,\012      isReloadNavigation: kEnumerableProperty,\012      keepalive: kEnumerableProperty,\012      integrity: kEnumerableProperty,\012      cache: kEnumerableProperty,\012      credentials: kEnumerableProperty,\012      attribute: kEnumerableProperty,\012      referrerPolicy: kEnumerableProperty,\012      referrer: kEnumerableProperty,\012      mode: kEnumerableProperty,\012      [Symbol.toStringTag]: {\012        value: \042Request\042,\012        configurable: true\012      }\012    });\012    webidl.converters.Request = webidl.interfaceConverter(\012      Request\012    );\012    webidl.converters.RequestInfo = function(V, prefix, argument) {\012      if (typeof V === \042string\042) {\012        return webidl.converters.USVString(V, prefix, argument);\012      }\012      if (V instanceof Request) {\012        return webidl.converters.Request(V, prefix, argument);\012      }\012      return webidl.converters.USVString(V, prefix, argument);\012    };\012    webidl.converters.AbortSignal = webidl.interfaceConverter(\012      AbortSignal\012    );\012    webidl.converters.RequestInit = webidl.dictionaryConverter([\012      {\012        key: \042method\042,\012        converter: webidl.converters.ByteString\012      },\012      {\012        key: \042headers\042,\012        converter: webidl.converters.HeadersInit\012      },\012      {\012        key: \042body\042,\012        converter: webidl.nullableConverter(\012          webidl.converters.BodyInit\012        )\012      },\012      {\012        key: \042referrer\042,\012        converter: webidl.converters.USVString\012      },\012      {\012        key: \042referrerPolicy\042,\012        converter: webidl.converters.DOMString,\012        // https://w3c.github.io/webappsec-referrer-policy/#referrer-policy\012        allowedValues: referrerPolicy\012      },\012      {\012        key: \042mode\042,\012        converter: webidl.converters.DOMString,\012        // https://fetch.spec.whatwg.org/#concept-request-mode\012        allowedValues: requestMode\012      },\012      {\012        key: \042credentials\042,\012        converter: webidl.converters.DOMString,\012        // https://fetch.spec.whatwg.org/#requestcredentials\012        allowedValues: requestCredentials\012      },\012      {\012        key: \042cache\042,\012        converter: webidl.converters.DOMString,\012        // https://fetch.spec.whatwg.org/#requestcache\012        allowedValues: requestCache\012      },\012      {\012        key: \042redirect\042,\012        converter: webidl.converters.DOMString,\012        // https://fetch.spec.whatwg.org/#requestredirect\012        allowedValues: requestRedirect\012      },\012      {\012        key: \042integrity\042,\012        converter: webidl.converters.DOMString\012      },\012      {\012        key: \042keepalive\042,\012        converter: webidl.converters.boolean\012      },\012      {\012        key: \042signal\042,\012        converter: webidl.nullableConverter(\012          (signal) => webidl.converters.AbortSignal(\012            signal,\012            \042RequestInit\042,\012            \042signal\042,\012            { strict: false }\012          )\012        )\012      },\012      {\012        key: \042window\042,\012        converter: webidl.converters.any\012      },\012      {\012        key: \042duplex\042,\012        converter: webidl.converters.DOMString,\012        allowedValues: requestDuplex\012      },\012      {\012        key: \042dispatcher\042,\012        // undici specific option\012        converter: webidl.converters.any\012      }\012    ]);\012    module2.exports = { Request, makeRequest, fromInnerRequest, cloneRequest };\012  }\012});\012\012// lib/web/fetch/index.js\012var require_fetch = __commonJS({\012  \042lib/web/fetch/index.js\042(exports2, module2) {\012    \042use strict\042;\012    var {\012      makeNetworkError,\012      makeAppropriateNetworkError,\012      filterResponse,\012      makeResponse,\012      fromInnerResponse\012    } = require_response();\012    var { HeadersList } = require_headers();\012    var { Request, cloneRequest } = require_request2();\012    var zlib = require(\042node:zlib\042);\012    var {\012      bytesMatch,\012      makePolicyContainer,\012      clonePolicyContainer,\012      requestBadPort,\012      TAOCheck,\012      appendRequestOriginHeader,\012      responseLocationURL,\012      requestCurrentURL,\012      setRequestReferrerPolicyOnRedirect,\012      tryUpgradeRequestToAPotentiallyTrustworthyURL,\012      createOpaqueTimingInfo,\012      appendFetchMetadata,\012      corsCheck,\012      crossOriginResourcePolicyCheck,\012      determineRequestsReferrer,\012      coarsenedSharedCurrentTime,\012      createDeferredPromise,\012      isBlobLike,\012      sameOrigin,\012      isCancelled,\012      isAborted,\012      isErrorLike,\012      fullyReadBody,\012      readableStreamClose,\012      isomorphicEncode,\012      urlIsLocal,\012      urlIsHttpHttpsScheme,\012      urlHasHttpsScheme,\012      clampAndCoarsenConnectionTimingInfo,\012      simpleRangeHeaderValue,\012      buildContentRange,\012      createInflate,\012      extractMimeType\012    } = require_util2();\012    var { kState, kDispatcher } = require_symbols2();\012    var assert = require(\042node:assert\042);\012    var { safelyExtractBody, extractBody } = require_body();\012    var {\012      redirectStatusSet,\012      nullBodyStatus,\012      safeMethodsSet,\012      requestBodyHeader,\012      subresourceSet\012    } = require_constants3();\012    var EE = require(\042node:events\042);\012    var { Readable, pipeline, finished } = require(\042node:stream\042);\012    var { addAbortListener, isErrored, isReadable, bufferToLowerCasedHeaderName } = require_util();\012    var { dataURLProcessor, serializeAMimeType, minimizeSupportedMimeType } = require_data_url();\012    var { getGlobalDispatcher: getGlobalDispatcher2 } = require_global2();\012    var { webidl } = require_webidl();\012    var { STATUS_CODES } = require(\042node:http\042);\012    var GET_OR_HEAD = [\042GET\042, \042HEAD\042];\012    var defaultUserAgent = typeof __UNDICI_IS_NODE__ !== \042undefined\042 || true \077 \042node\042 : \042undici\042;\012    var resolveObjectURL;\012    var Fetch = class extends EE {\012      static {\012        __name(this, \042Fetch\042);\012      }\012      constructor(dispatcher) {\012        super();\012        this.dispatcher = dispatcher;\012        this.connection = null;\012        this.dump = false;\012        this.state = \042ongoing\042;\012      }\012      terminate(reason) {\012        if (this.state !== \042ongoing\042) {\012          return;\012        }\012        this.state = \042terminated\042;\012        this.connection\077.destroy(reason);\012        this.emit(\042terminated\042, reason);\012      }\012      // https://fetch.spec.whatwg.org/#fetch-controller-abort\012      abort(error) {\012        if (this.state !== \042ongoing\042) {\012          return;\012        }\012        this.state = \042aborted\042;\012        if (!error) {\012          error = new DOMException(\042The operation was aborted.\042, \042AbortError\042);\012        }\012        this.serializedAbortReason = error;\012        this.connection\077.destroy(error);\012        this.emit(\042terminated\042, error);\012      }\012    };\012    function handleFetchDone(response) {\012      finalizeAndReportTiming(response, \042fetch\042);\012    }\012    __name(handleFetchDone, \042handleFetchDone\042);\012    function fetch2(input, init = void 0) {\012      webidl.argumentLengthCheck(arguments, 1, \042globalThis.fetch\042);\012      let p = createDeferredPromise();\012      let requestObject;\012      try {\012        requestObject = new Request(input, init);\012      } catch (e) {\012        p.reject(e);\012        return p.promise;\012      }\012      const request = requestObject[kState];\012      if (requestObject.signal.aborted) {\012        abortFetch(p, request, null, requestObject.signal.reason);\012        return p.promise;\012      }\012      const globalObject = request.client.globalObject;\012      if (globalObject\077.constructor\077.name === \042ServiceWorkerGlobalScope\042) {\012        request.serviceWorkers = \042none\042;\012      }\012      let responseObject = null;\012      let locallyAborted = false;\012      let controller = null;\012      addAbortListener(\012        requestObject.signal,\012        () => {\012          locallyAborted = true;\012          assert(controller != null);\012          controller.abort(requestObject.signal.reason);\012          const realResponse = responseObject\077.deref();\012          abortFetch(p, request, realResponse, requestObject.signal.reason);\012        }\012      );\012      const processResponse = /* @__PURE__ */ __name((response) => {\012        if (locallyAborted) {\012          return;\012        }\012        if (response.aborted) {\012          abortFetch(p, request, responseObject, controller.serializedAbortReason);\012          return;\012        }\012        if (response.type === \042error\042) {\012          p.reject(new TypeError(\042fetch failed\042, { cause: response.error }));\012          return;\012        }\012        responseObject = new WeakRef(fromInnerResponse(response, \042immutable\042));\012        p.resolve(responseObject.deref());\012        p = null;\012      }, \042processResponse\042);\012      controller = fetching({\012        request,\012        processResponseEndOfBody: handleFetchDone,\012        processResponse,\012        dispatcher: requestObject[kDispatcher]\012        // undici\012      });\012      return p.promise;\012    }\012    __name(fetch2, \042fetch\042);\012    function finalizeAndReportTiming(response, initiatorType = \042other\042) {\012      if (response.type === \042error\042 && response.aborted) {\012        return;\012      }\012      if (!response.urlList\077.length) {\012        return;\012      }\012      const originalURL = response.urlList[0];\012      let timingInfo = response.timingInfo;\012      let cacheState = response.cacheState;\012      if (!urlIsHttpHttpsScheme(originalURL)) {\012        return;\012      }\012      if (timingInfo === null) {\012        return;\012      }\012      if (!response.timingAllowPassed) {\012        timingInfo = createOpaqueTimingInfo({\012          startTime: timingInfo.startTime\012        });\012        cacheState = \042\042;\012      }\012      timingInfo.endTime = coarsenedSharedCurrentTime();\012      response.timingInfo = timingInfo;\012      markResourceTiming(\012        timingInfo,\012        originalURL.href,\012        initiatorType,\012        globalThis,\012        cacheState\012      );\012    }\012    __name(finalizeAndReportTiming, \042finalizeAndReportTiming\042);\012    var markResourceTiming = performance.markResourceTiming;\012    function abortFetch(p, request, responseObject, error) {\012      if (p) {\012        p.reject(error);\012      }\012      if (request.body != null && isReadable(request.body\077.stream)) {\012        request.body.stream.cancel(error).catch((err) => {\012          if (err.code === \042ERR_INVALID_STATE\042) {\012            return;\012          }\012          throw err;\012        });\012      }\012      if (responseObject == null) {\012        return;\012      }\012      const response = responseObject[kState];\012      if (response.body != null && isReadable(response.body\077.stream)) {\012        response.body.stream.cancel(error).catch((err) => {\012          if (err.code === \042ERR_INVALID_STATE\042) {\012            return;\012          }\012          throw err;\012        });\012      }\012    }\012    __name(abortFetch, \042abortFetch\042);\012    function fetching({\012      request,\012      processRequestBodyChunkLength,\012      processRequestEndOfBody,\012      processResponse,\012      processResponseEndOfBody,\012      processResponseConsumeBody,\012      useParallelQueue = false,\012      dispatcher = getGlobalDispatcher2()\012      // undici\012    }) {\012      assert(dispatcher);\012      let taskDestination = null;\012      let crossOriginIsolatedCapability = false;\012      if (request.client != null) {\012        taskDestination = request.client.globalObject;\012        crossOriginIsolatedCapability = request.client.crossOriginIsolatedCapability;\012      }\012      const currentTime = coarsenedSharedCurrentTime(crossOriginIsolatedCapability);\012      const timingInfo = createOpaqueTimingInfo({\012        startTime: currentTime\012      });\012      const fetchParams = {\012        controller: new Fetch(dispatcher),\012        request,\012        timingInfo,\012        processRequestBodyChunkLength,\012        processRequestEndOfBody,\012        processResponse,\012        processResponseConsumeBody,\012        processResponseEndOfBody,\012        taskDestination,\012        crossOriginIsolatedCapability\012      };\012      assert(!request.body || request.body.stream);\012      if (request.window === \042client\042) {\012        request.window = request.client\077.globalObject\077.constructor\077.name === \042Window\042 \077 request.client : \042no-window\042;\012      }\012      if (request.origin === \042client\042) {\012        request.origin = request.client.origin;\012      }\012      if (request.policyContainer === \042client\042) {\012        if (request.client != null) {\012          request.policyContainer = clonePolicyContainer(\012            request.client.policyContainer\012          );\012        } else {\012          request.policyContainer = makePolicyContainer();\012        }\012      }\012      if (!request.headersList.contains(\042accept\042, true)) {\012        const value = \042*/*\042;\012        request.headersList.append(\042accept\042, value, true);\012      }\012      if (!request.headersList.contains(\042accept-language\042, true)) {\012        request.headersList.append(\042accept-language\042, \042*\042, true);\012      }\012      if (request.priority === null) {\012      }\012      if (subresourceSet.has(request.destination)) {\012      }\012      mainFetch(fetchParams).catch((err) => {\012        fetchParams.controller.terminate(err);\012      });\012      return fetchParams.controller;\012    }\012    __name(fetching, \042fetching\042);\012    async function mainFetch(fetchParams, recursive = false) {\012      const request = fetchParams.request;\012      let response = null;\012      if (request.localURLsOnly && !urlIsLocal(requestCurrentURL(request))) {\012        response = makeNetworkError(\042local URLs only\042);\012      }\012      tryUpgradeRequestToAPotentiallyTrustworthyURL(request);\012      if (requestBadPort(request) === \042blocked\042) {\012        response = makeNetworkError(\042bad port\042);\012      }\012      if (request.referrerPolicy === \042\042) {\012        request.referrerPolicy = request.policyContainer.referrerPolicy;\012      }\012      if (request.referrer !== \042no-referrer\042) {\012        request.referrer = determineRequestsReferrer(request);\012      }\012      if (response === null) {\012        response = await (async () => {\012          const currentURL = requestCurrentURL(request);\012          if (\012            // - request\077s current URL\077s origin is same origin with request\077s origin,\012            //   and request\077s response tainting is \042basic\042\012            sameOrigin(currentURL, request.url) && request.responseTainting === \042basic\042 || // request\077s current URL\077s scheme is \042data\042\012            currentURL.protocol === \042data:\042 || // - request\077s mode is \042navigate\042 or \042websocket\042\012            (request.mode === \042navigate\042 || request.mode === \042websocket\042)\012          ) {\012            request.responseTainting = \042basic\042;\012            return await schemeFetch(fetchParams);\012          }\012          if (request.mode === \042same-origin\042) {\012            return makeNetworkError('request mode cannot be \042same-origin\042');\012          }\012          if (request.mode === \042no-cors\042) {\012            if (request.redirect !== \042follow\042) {\012              return makeNetworkError(\012                'redirect mode cannot be \042follow\042 for \042no-cors\042 request'\012              );\012            }\012            request.responseTainting = \042opaque\042;\012            return await schemeFetch(fetchParams);\012          }\012          if (!urlIsHttpHttpsScheme(requestCurrentURL(request))) {\012            return makeNetworkError(\042URL scheme must be a HTTP(S) scheme\042);\012          }\012          request.responseTainting = \042cors\042;\012          return await httpFetch(fetchParams);\012        })();\012      }\012      if (recursive) {\012        return response;\012      }\012      if (response.status !== 0 && !response.internalResponse) {\012        if (request.responseTainting === \042cors\042) {\012        }\012        if (request.responseTainting === \042basic\042) {\012          response = filterResponse(response, \042basic\042);\012        } else if (request.responseTainting === \042cors\042) {\012          response = filterResponse(response, \042cors\042);\012        } else if (request.responseTainting === \042opaque\042) {\012          response = filterResponse(response, \042opaque\042);\012        } else {\012          assert(false);\012        }\012      }\012      let internalResponse = response.status === 0 \077 response : response.internalResponse;\012      if (internalResponse.urlList.length === 0) {\012        internalResponse.urlList.push(...request.urlList);\012      }\012      if (!request.timingAllowFailed) {\012        response.timingAllowPassed = true;\012      }\012      if (response.type === \042opaque\042 && internalResponse.status === 206 && internalResponse.rangeRequested && !request.headers.contains(\042range\042, true)) {\012        response = internalResponse = makeNetworkError();\012      }\012      if (response.status !== 0 && (request.method === \042HEAD\042 || request.method === \042CONNECT\042 || nullBodyStatus.includes(internalResponse.status))) {\012        internalResponse.body = null;\012        fetchParams.controller.dump = true;\012      }\012      if (request.integrity) {\012        const processBodyError = /* @__PURE__ */ __name((reason) => fetchFinale(fetchParams, makeNetworkError(reason)), \042processBodyError\042);\012        if (request.responseTainting === \042opaque\042 || response.body == null) {\012          processBodyError(response.error);\012          return;\012        }\012        const processBody = /* @__PURE__ */ __name((bytes) => {\012          if (!bytesMatch(bytes, request.integrity)) {\012            processBodyError(\042integrity mismatch\042);\012            return;\012          }\012          response.body = safelyExtractBody(bytes)[0];\012          fetchFinale(fetchParams, response);\012        }, \042processBody\042);\012        await fullyReadBody(response.body, processBody, processBodyError);\012      } else {\012        fetchFinale(fetchParams, response);\012      }\012    }\012    __name(mainFetch, \042mainFetch\042);\012    function schemeFetch(fetchParams) {\012      if (isCancelled(fetchParams) && fetchParams.request.redirectCount === 0) {\012        return Promise.resolve(makeAppropriateNetworkError(fetchParams));\012      }\012      const { request } = fetchParams;\012      const { protocol: scheme } = requestCurrentURL(request);\012      switch (scheme) {\012        case \042about:\042: {\012          return Promise.resolve(makeNetworkError(\042about scheme is not supported\042));\012        }\012        case \042blob:\042: {\012          if (!resolveObjectURL) {\012            resolveObjectURL = require(\042node:buffer\042).resolveObjectURL;\012          }\012          const blobURLEntry = requestCurrentURL(request);\012          if (blobURLEntry.search.length !== 0) {\012            return Promise.resolve(makeNetworkError(\042NetworkError when attempting to fetch resource.\042));\012          }\012          const blob = resolveObjectURL(blobURLEntry.toString());\012          if (request.method !== \042GET\042 || !isBlobLike(blob)) {\012            return Promise.resolve(makeNetworkError(\042invalid method\042));\012          }\012          const response = makeResponse();\012          const fullLength = blob.size;\012          const serializedFullLength = isomorphicEncode(`${fullLength}`);\012          const type = blob.type;\012          if (!request.headersList.contains(\042range\042, true)) {\012            const bodyWithType = extractBody(blob);\012            response.statusText = \042OK\042;\012            response.body = bodyWithType[0];\012            response.headersList.set(\042content-length\042, serializedFullLength, true);\012            response.headersList.set(\042content-type\042, type, true);\012          } else {\012            response.rangeRequested = true;\012            const rangeHeader = request.headersList.get(\042range\042, true);\012            const rangeValue = simpleRangeHeaderValue(rangeHeader, true);\012            if (rangeValue === \042failure\042) {\012              return Promise.resolve(makeNetworkError(\042failed to fetch the data URL\042));\012            }\012            let { rangeStartValue: rangeStart, rangeEndValue: rangeEnd } = rangeValue;\012            if (rangeStart === null) {\012              rangeStart = fullLength - rangeEnd;\012              rangeEnd = rangeStart + rangeEnd - 1;\012            } else {\012              if (rangeStart >= fullLength) {\012                return Promise.resolve(makeNetworkError(\042Range start is greater than the blob's size.\042));\012              }\012              if (rangeEnd === null || rangeEnd >= fullLength) {\012                rangeEnd = fullLength - 1;\012              }\012            }\012            const slicedBlob = blob.slice(rangeStart, rangeEnd, type);\012            const slicedBodyWithType = extractBody(slicedBlob);\012            response.body = slicedBodyWithType[0];\012            const serializedSlicedLength = isomorphicEncode(`${slicedBlob.size}`);\012            const contentRange = buildContentRange(rangeStart, rangeEnd, fullLength);\012            response.status = 206;\012            response.statusText = \042Partial Content\042;\012            response.headersList.set(\042content-length\042, serializedSlicedLength, true);\012            response.headersList.set(\042content-type\042, type, true);\012            response.headersList.set(\042content-range\042, contentRange, true);\012          }\012          return Promise.resolve(response);\012        }\012        case \042data:\042: {\012          const currentURL = requestCurrentURL(request);\012          const dataURLStruct = dataURLProcessor(currentURL);\012          if (dataURLStruct === \042failure\042) {\012            return Promise.resolve(makeNetworkError(\042failed to fetch the data URL\042));\012          }\012          const mimeType = serializeAMimeType(dataURLStruct.mimeType);\012          return Promise.resolve(makeResponse({\012            statusText: \042OK\042,\012            headersList: [\012              [\042content-type\042, { name: \042Content-Type\042, value: mimeType }]\012            ],\012            body: safelyExtractBody(dataURLStruct.body)[0]\012          }));\012        }\012        case \042file:\042: {\012          return Promise.resolve(makeNetworkError(\042not implemented... yet...\042));\012        }\012        case \042http:\042:\012        case \042https:\042: {\012          return httpFetch(fetchParams).catch((err) => makeNetworkError(err));\012        }\012        default: {\012          return Promise.resolve(makeNetworkError(\042unknown scheme\042));\012        }\012      }\012    }\012    __name(schemeFetch, \042schemeFetch\042);\012    function finalizeResponse(fetchParams, response) {\012      fetchParams.request.done = true;\012      if (fetchParams.processResponseDone != null) {\012        queueMicrotask(() => fetchParams.processResponseDone(response));\012      }\012    }\012    __name(finalizeResponse, \042finalizeResponse\042);\012    function fetchFinale(fetchParams, response) {\012      let timingInfo = fetchParams.timingInfo;\012      const processResponseEndOfBody = /* @__PURE__ */ __name(() => {\012        const unsafeEndTime = Date.now();\012        if (fetchParams.request.destination === \042document\042) {\012          fetchParams.controller.fullTimingInfo = timingInfo;\012        }\012        fetchParams.controller.reportTimingSteps = () => {\012          if (fetchParams.request.url.protocol !== \042https:\042) {\012            return;\012          }\012          timingInfo.endTime = unsafeEndTime;\012          let cacheState = response.cacheState;\012          const bodyInfo = response.bodyInfo;\012          if (!response.timingAllowPassed) {\012            timingInfo = createOpaqueTimingInfo(timingInfo);\012            cacheState = \042\042;\012          }\012          let responseStatus = 0;\012          if (fetchParams.request.mode !== \042navigator\042 || !response.hasCrossOriginRedirects) {\012            responseStatus = response.status;\012            const mimeType = extractMimeType(response.headersList);\012            if (mimeType !== \042failure\042) {\012              bodyInfo.contentType = minimizeSupportedMimeType(mimeType);\012            }\012          }\012          if (fetchParams.request.initiatorType != null) {\012            markResourceTiming(timingInfo, fetchParams.request.url.href, fetchParams.request.initiatorType, globalThis, cacheState, bodyInfo, responseStatus);\012          }\012        };\012        const processResponseEndOfBodyTask = /* @__PURE__ */ __name(() => {\012          fetchParams.request.done = true;\012          if (fetchParams.processResponseEndOfBody != null) {\012            queueMicrotask(() => fetchParams.processResponseEndOfBody(response));\012          }\012          if (fetchParams.request.initiatorType != null) {\012            fetchParams.controller.reportTimingSteps();\012          }\012        }, \042processResponseEndOfBodyTask\042);\012        queueMicrotask(() => processResponseEndOfBodyTask());\012      }, \042processResponseEndOfBody\042);\012      if (fetchParams.processResponse != null) {\012        queueMicrotask(() => {\012          fetchParams.processResponse(response);\012          fetchParams.processResponse = null;\012        });\012      }\012      const internalResponse = response.type === \042error\042 \077 response : response.internalResponse \077\077 response;\012      if (internalResponse.body == null) {\012        processResponseEndOfBody();\012      } else {\012        finished(internalResponse.body.stream, () => {\012          processResponseEndOfBody();\012        });\012      }\012    }\012    __name(fetchFinale, \042fetchFinale\042);\012    async function httpFetch(fetchParams) {\012      const request = fetchParams.request;\012      let response = null;\012      let actualResponse = null;\012      const timingInfo = fetchParams.timingInfo;\012      if (request.serviceWorkers === \042all\042) {\012      }\012      if (response === null) {\012        if (request.redirect === \042follow\042) {\012          request.serviceWorkers = \042none\042;\012        }\012        actualResponse = response = await httpNetworkOrCacheFetch(fetchParams);\012        if (request.responseTainting === \042cors\042 && corsCheck(request, response) === \042failure\042) {\012          return makeNetworkError(\042cors failure\042);\012        }\012        if (TAOCheck(request, response) === \042failure\042) {\012          request.timingAllowFailed = true;\012        }\012      }\012      if ((request.responseTainting === \042opaque\042 || response.type === \042opaque\042) && crossOriginResourcePolicyCheck(\012        request.origin,\012        request.client,\012        request.destination,\012        actualResponse\012      ) === \042blocked\042) {\012        return makeNetworkError(\042blocked\042);\012      }\012      if (redirectStatusSet.has(actualResponse.status)) {\012        if (request.redirect !== \042manual\042) {\012          fetchParams.controller.connection.destroy(void 0, false);\012        }\012        if (request.redirect === \042error\042) {\012          response = makeNetworkError(\042unexpected redirect\042);\012        } else if (request.redirect === \042manual\042) {\012          response = actualResponse;\012        } else if (request.redirect === \042follow\042) {\012          response = await httpRedirectFetch(fetchParams, response);\012        } else {\012          assert(false);\012        }\012      }\012      response.timingInfo = timingInfo;\012      return response;\012    }\012    __name(httpFetch, \042httpFetch\042);\012    function httpRedirectFetch(fetchParams, response) {\012      const request = fetchParams.request;\012      const actualResponse = response.internalResponse \077 response.internalResponse : response;\012      let locationURL;\012      try {\012        locationURL = responseLocationURL(\012          actualResponse,\012          requestCurrentURL(request).hash\012        );\012        if (locationURL == null) {\012          return response;\012        }\012      } catch (err) {\012        return Promise.resolve(makeNetworkError(err));\012      }\012      if (!urlIsHttpHttpsScheme(locationURL)) {\012        return Promise.resolve(makeNetworkError(\042URL scheme must be a HTTP(S) scheme\042));\012      }\012      if (request.redirectCount === 20) {\012        return Promise.resolve(makeNetworkError(\042redirect count exceeded\042));\012      }\012      request.redirectCount += 1;\012      if (request.mode === \042cors\042 && (locationURL.username || locationURL.password) && !sameOrigin(request, locationURL)) {\012        return Promise.resolve(makeNetworkError('cross origin not allowed for request mode \042cors\042'));\012      }\012      if (request.responseTainting === \042cors\042 && (locationURL.username || locationURL.password)) {\012        return Promise.resolve(makeNetworkError(\012          'URL cannot contain credentials for request mode \042cors\042'\012        ));\012      }\012      if (actualResponse.status !== 303 && request.body != null && request.body.source == null) {\012        return Promise.resolve(makeNetworkError());\012      }\012      if ([301, 302].includes(actualResponse.status) && request.method === \042POST\042 || actualResponse.status === 303 && !GET_OR_HEAD.includes(request.method)) {\012        request.method = \042GET\042;\012        request.body = null;\012        for (const headerName of requestBodyHeader) {\012          request.headersList.delete(headerName);\012        }\012      }\012      if (!sameOrigin(requestCurrentURL(request), locationURL)) {\012        request.headersList.delete(\042authorization\042, true);\012        request.headersList.delete(\042proxy-authorization\042, true);\012        request.headersList.delete(\042cookie\042, true);\012        request.headersList.delete(\042host\042, true);\012      }\012      if (request.body != null) {\012        assert(request.body.source != null);\012        request.body = safelyExtractBody(request.body.source)[0];\012      }\012      const timingInfo = fetchParams.timingInfo;\012      timingInfo.redirectEndTime = timingInfo.postRedirectStartTime = coarsenedSharedCurrentTime(fetchParams.crossOriginIsolatedCapability);\012      if (timingInfo.redirectStartTime === 0) {\012        timingInfo.redirectStartTime = timingInfo.startTime;\012      }\012      request.urlList.push(locationURL);\012      setRequestReferrerPolicyOnRedirect(request, actualResponse);\012      return mainFetch(fetchParams, true);\012    }\012    __name(httpRedirectFetch, \042httpRedirectFetch\042);\012    async function httpNetworkOrCacheFetch(fetchParams, isAuthenticationFetch = false, isNewConnectionFetch = false) {\012      const request = fetchParams.request;\012      let httpFetchParams = null;\012      let httpRequest = null;\012      let response = null;\012      const httpCache = null;\012      const revalidatingFlag = false;\012      if (request.window === \042no-window\042 && request.redirect === \042error\042) {\012        httpFetchParams = fetchParams;\012        httpRequest = request;\012      } else {\012        httpRequest = cloneRequest(request);\012        httpFetchParams = { ...fetchParams };\012        httpFetchParams.request = httpRequest;\012      }\012      const includeCredentials = request.credentials === \042include\042 || request.credentials === \042same-origin\042 && request.responseTainting === \042basic\042;\012      const contentLength = httpRequest.body \077 httpRequest.body.length : null;\012      let contentLengthHeaderValue = null;\012      if (httpRequest.body == null && [\042POST\042, \042PUT\042].includes(httpRequest.method)) {\012        contentLengthHeaderValue = \0420\042;\012      }\012      if (contentLength != null) {\012        contentLengthHeaderValue = isomorphicEncode(`${contentLength}`);\012      }\012      if (contentLengthHeaderValue != null) {\012        httpRequest.headersList.append(\042content-length\042, contentLengthHeaderValue, true);\012      }\012      if (contentLength != null && httpRequest.keepalive) {\012      }\012      if (httpRequest.referrer instanceof URL) {\012        httpRequest.headersList.append(\042referer\042, isomorphicEncode(httpRequest.referrer.href), true);\012      }\012      appendRequestOriginHeader(httpRequest);\012      appendFetchMetadata(httpRequest);\012      if (!httpRequest.headersList.contains(\042user-agent\042, true)) {\012        httpRequest.headersList.append(\042user-agent\042, defaultUserAgent);\012      }\012      if (httpRequest.cache === \042default\042 && (httpRequest.headersList.contains(\042if-modified-since\042, true) || httpRequest.headersList.contains(\042if-none-match\042, true) || httpRequest.headersList.contains(\042if-unmodified-since\042, true) || httpRequest.headersList.contains(\042if-match\042, true) || httpRequest.headersList.contains(\042if-range\042, true))) {\012        httpRequest.cache = \042no-store\042;\012      }\012      if (httpRequest.cache === \042no-cache\042 && !httpRequest.preventNoCacheCacheControlHeaderModification && !httpRequest.headersList.contains(\042cache-control\042, true)) {\012        httpRequest.headersList.append(\042cache-control\042, \042max-age=0\042, true);\012      }\012      if (httpRequest.cache === \042no-store\042 || httpRequest.cache === \042reload\042) {\012        if (!httpRequest.headersList.contains(\042pragma\042, true)) {\012          httpRequest.headersList.append(\042pragma\042, \042no-cache\042, true);\012        }\012        if (!httpRequest.headersList.contains(\042cache-control\042, true)) {\012          httpRequest.headersList.append(\042cache-control\042, \042no-cache\042, true);\012        }\012      }\012      if (httpRequest.headersList.contains(\042range\042, true)) {\012        httpRequest.headersList.append(\042accept-encoding\042, \042identity\042, true);\012      }\012      if (!httpRequest.headersList.contains(\042accept-encoding\042, true)) {\012        if (urlHasHttpsScheme(requestCurrentURL(httpRequest))) {\012          httpRequest.headersList.append(\042accept-encoding\042, \042br, gzip, deflate\042, true);\012        } else {\012          httpRequest.headersList.append(\042accept-encoding\042, \042gzip, deflate\042, true);\012        }\012      }\012      httpRequest.headersList.delete(\042host\042, true);\012      if (includeCredentials) {\012      }\012      if (httpCache == null) {\012        httpRequest.cache = \042no-store\042;\012      }\012      if (httpRequest.cache !== \042no-store\042 && httpRequest.cache !== \042reload\042) {\012      }\012      if (response == null) {\012        if (httpRequest.cache === \042only-if-cached\042) {\012          return makeNetworkError(\042only if cached\042);\012        }\012        const forwardResponse = await httpNetworkFetch(\012          httpFetchParams,\012          includeCredentials,\012          isNewConnectionFetch\012        );\012        if (!safeMethodsSet.has(httpRequest.method) && forwardResponse.status >= 200 && forwardResponse.status <= 399) {\012        }\012        if (revalidatingFlag && forwardResponse.status === 304) {\012        }\012        if (response == null) {\012          response = forwardResponse;\012        }\012      }\012      response.urlList = [...httpRequest.urlList];\012      if (httpRequest.headersList.contains(\042range\042, true)) {\012        response.rangeRequested = true;\012      }\012      response.requestIncludesCredentials = includeCredentials;\012      if (response.status === 407) {\012        if (request.window === \042no-window\042) {\012          return makeNetworkError();\012        }\012        if (isCancelled(fetchParams)) {\012          return makeAppropriateNetworkError(fetchParams);\012        }\012        return makeNetworkError(\042proxy authentication required\042);\012      }\012      if (\012        // response\077s status is 421\012        response.status === 421 && // isNewConnectionFetch is false\012        !isNewConnectionFetch && // request\077s body is null, or request\077s body is non-null and request\077s body\077s source is non-null\012        (request.body == null || request.body.source != null)\012      ) {\012        if (isCancelled(fetchParams)) {\012          return makeAppropriateNetworkError(fetchParams);\012        }\012        fetchParams.controller.connection.destroy();\012        response = await httpNetworkOrCacheFetch(\012          fetchParams,\012          isAuthenticationFetch,\012          true\012        );\012      }\012      if (isAuthenticationFetch) {\012      }\012      return response;\012    }\012    __name(httpNetworkOrCacheFetch, \042httpNetworkOrCacheFetch\042);\012    async function httpNetworkFetch(fetchParams, includeCredentials = false, forceNewConnection = false) {\012      assert(!fetchParams.controller.connection || fetchParams.controller.connection.destroyed);\012      fetchParams.controller.connection = {\012        abort: null,\012        destroyed: false,\012        destroy(err, abort = true) {\012          if (!this.destroyed) {\012            this.destroyed = true;\012            if (abort) {\012              this.abort\077.(err \077\077 new DOMException(\042The operation was aborted.\042, \042AbortError\042));\012            }\012          }\012        }\012      };\012      const request = fetchParams.request;\012      let response = null;\012      const timingInfo = fetchParams.timingInfo;\012      const httpCache = null;\012      if (httpCache == null) {\012        request.cache = \042no-store\042;\012      }\012      const newConnection = forceNewConnection \077 \042yes\042 : \042no\042;\012      if (request.mode === \042websocket\042) {\012      } else {\012      }\012      let requestBody = null;\012      if (request.body == null && fetchParams.processRequestEndOfBody) {\012        queueMicrotask(() => fetchParams.processRequestEndOfBody());\012      } else if (request.body != null) {\012        const processBodyChunk = /* @__PURE__ */ __name(async function* (bytes) {\012          if (isCancelled(fetchParams)) {\012            return;\012          }\012          yield bytes;\012          fetchParams.processRequestBodyChunkLength\077.(bytes.byteLength);\012        }, \042processBodyChunk\042);\012        const processEndOfBody = /* @__PURE__ */ __name(() => {\012          if (isCancelled(fetchParams)) {\012            return;\012          }\012          if (fetchParams.processRequestEndOfBody) {\012            fetchParams.processRequestEndOfBody();\012          }\012        }, \042processEndOfBody\042);\012        const processBodyError = /* @__PURE__ */ __name((e) => {\012          if (isCancelled(fetchParams)) {\012            return;\012          }\012          if (e.name === \042AbortError\042) {\012            fetchParams.controller.abort();\012          } else {\012            fetchParams.controller.terminate(e);\012          }\012        }, \042processBodyError\042);\012        requestBody = async function* () {\012          try {\012            for await (const bytes of request.body.stream) {\012              yield* processBodyChunk(bytes);\012            }\012            processEndOfBody();\012          } catch (err) {\012            processBodyError(err);\012          }\012        }();\012      }\012      try {\012        const { body, status, statusText, headersList, socket } = await dispatch({ body: requestBody });\012        if (socket) {\012          response = makeResponse({ status, statusText, headersList, socket });\012        } else {\012          const iterator = body[Symbol.asyncIterator]();\012          fetchParams.controller.next = () => iterator.next();\012          response = makeResponse({ status, statusText, headersList });\012        }\012      } catch (err) {\012        if (err.name === \042AbortError\042) {\012          fetchParams.controller.connection.destroy();\012          return makeAppropriateNetworkError(fetchParams, err);\012        }\012        return makeNetworkError(err);\012      }\012      const pullAlgorithm = /* @__PURE__ */ __name(async () => {\012        await fetchParams.controller.resume();\012      }, \042pullAlgorithm\042);\012      const cancelAlgorithm = /* @__PURE__ */ __name((reason) => {\012        if (!isCancelled(fetchParams)) {\012          fetchParams.controller.abort(reason);\012        }\012      }, \042cancelAlgorithm\042);\012      const stream = new ReadableStream(\012        {\012          async start(controller) {\012            fetchParams.controller.controller = controller;\012          },\012          async pull(controller) {\012            await pullAlgorithm(controller);\012          },\012          async cancel(reason) {\012            await cancelAlgorithm(reason);\012          },\012          type: \042bytes\042\012        }\012      );\012      response.body = { stream, source: null, length: null };\012      fetchParams.controller.onAborted = onAborted;\012      fetchParams.controller.on(\042terminated\042, onAborted);\012      fetchParams.controller.resume = async () => {\012        while (true) {\012          let bytes;\012          let isFailure;\012          try {\012            const { done, value } = await fetchParams.controller.next();\012            if (isAborted(fetchParams)) {\012              break;\012            }\012            bytes = done \077 void 0 : value;\012          } catch (err) {\012            if (fetchParams.controller.ended && !timingInfo.encodedBodySize) {\012              bytes = void 0;\012            } else {\012              bytes = err;\012              isFailure = true;\012            }\012          }\012          if (bytes === void 0) {\012            readableStreamClose(fetchParams.controller.controller);\012            finalizeResponse(fetchParams, response);\012            return;\012          }\012          timingInfo.decodedBodySize += bytes\077.byteLength \077\077 0;\012          if (isFailure) {\012            fetchParams.controller.terminate(bytes);\012            return;\012          }\012          const buffer = new Uint8Array(bytes);\012          if (buffer.byteLength) {\012            fetchParams.controller.controller.enqueue(buffer);\012          }\012          if (isErrored(stream)) {\012            fetchParams.controller.terminate();\012            return;\012          }\012          if (fetchParams.controller.controller.desiredSize <= 0) {\012            return;\012          }\012        }\012      };\012      function onAborted(reason) {\012        if (isAborted(fetchParams)) {\012          response.aborted = true;\012          if (isReadable(stream)) {\012            fetchParams.controller.controller.error(\012              fetchParams.controller.serializedAbortReason\012            );\012          }\012        } else {\012          if (isReadable(stream)) {\012            fetchParams.controller.controller.error(new TypeError(\042terminated\042, {\012              cause: isErrorLike(reason) \077 reason : void 0\012            }));\012          }\012        }\012        fetchParams.controller.connection.destroy();\012      }\012      __name(onAborted, \042onAborted\042);\012      return response;\012      function dispatch({ body }) {\012        const url = requestCurrentURL(request);\012        const agent = fetchParams.controller.dispatcher;\012        return new Promise((resolve, reject) => agent.dispatch(\012          {\012            path: url.pathname + url.search,\012            origin: url.origin,\012            method: request.method,\012            body: agent.isMockActive \077 request.body && (request.body.source || request.body.stream) : body,\012            headers: request.headersList.entries,\012            maxRedirections: 0,\012            upgrade: request.mode === \042websocket\042 \077 \042websocket\042 : void 0\012          },\012          {\012            body: null,\012            abort: null,\012            onConnect(abort) {\012              const { connection } = fetchParams.controller;\012              timingInfo.finalConnectionTimingInfo = clampAndCoarsenConnectionTimingInfo(void 0, timingInfo.postRedirectStartTime, fetchParams.crossOriginIsolatedCapability);\012              if (connection.destroyed) {\012                abort(new DOMException(\042The operation was aborted.\042, \042AbortError\042));\012              } else {\012                fetchParams.controller.on(\042terminated\042, abort);\012                this.abort = connection.abort = abort;\012              }\012              timingInfo.finalNetworkRequestStartTime = coarsenedSharedCurrentTime(fetchParams.crossOriginIsolatedCapability);\012            },\012            onResponseStarted() {\012              timingInfo.finalNetworkResponseStartTime = coarsenedSharedCurrentTime(fetchParams.crossOriginIsolatedCapability);\012            },\012            onHeaders(status, rawHeaders, resume, statusText) {\012              if (status < 200) {\012                return;\012              }\012              let codings = [];\012              let location = \042\042;\012              const headersList = new HeadersList();\012              for (let i = 0; i < rawHeaders.length; i += 2) {\012                headersList.append(bufferToLowerCasedHeaderName(rawHeaders[i]), rawHeaders[i + 1].toString(\042latin1\042), true);\012              }\012              const contentEncoding = headersList.get(\042content-encoding\042, true);\012              if (contentEncoding) {\012                codings = contentEncoding.toLowerCase().split(\042,\042).map((x) => x.trim());\012              }\012              location = headersList.get(\042location\042, true);\012              this.body = new Readable({ read: resume });\012              const decoders = [];\012              const willFollow = location && request.redirect === \042follow\042 && redirectStatusSet.has(status);\012              if (codings.length !== 0 && request.method !== \042HEAD\042 && request.method !== \042CONNECT\042 && !nullBodyStatus.includes(status) && !willFollow) {\012                for (let i = codings.length - 1; i >= 0; --i) {\012                  const coding = codings[i];\012                  if (coding === \042x-gzip\042 || coding === \042gzip\042) {\012                    decoders.push(zlib.createGunzip({\012                      // Be less strict when decoding compressed responses, since sometimes\012                      // servers send slightly invalid responses that are still accepted\012                      // by common browsers.\012                      // Always using Z_SYNC_FLUSH is what cURL does.\012                      flush: zlib.constants.Z_SYNC_FLUSH,\012                      finishFlush: zlib.constants.Z_SYNC_FLUSH\012                    }));\012                  } else if (coding === \042deflate\042) {\012                    decoders.push(createInflate({\012                      flush: zlib.constants.Z_SYNC_FLUSH,\012                      finishFlush: zlib.constants.Z_SYNC_FLUSH\012                    }));\012                  } else if (coding === \042br\042) {\012                    decoders.push(zlib.createBrotliDecompress({\012                      flush: zlib.constants.BROTLI_OPERATION_FLUSH,\012                      finishFlush: zlib.constants.BROTLI_OPERATION_FLUSH\012                    }));\012                  } else {\012                    decoders.length = 0;\012                    break;\012                  }\012                }\012              }\012              const onError = this.onError.bind(this);\012              resolve({\012                status,\012                statusText,\012                headersList,\012                body: decoders.length \077 pipeline(this.body, ...decoders, (err) => {\012                  if (err) {\012                    this.onError(err);\012                  }\012                }).on(\042error\042, onError) : this.body.on(\042error\042, onError)\012              });\012              return true;\012            },\012            onData(chunk) {\012              if (fetchParams.controller.dump) {\012                return;\012              }\012              const bytes = chunk;\012              timingInfo.encodedBodySize += bytes.byteLength;\012              return this.body.push(bytes);\012            },\012            onComplete() {\012              if (this.abort) {\012                fetchParams.controller.off(\042terminated\042, this.abort);\012              }\012              if (fetchParams.controller.onAborted) {\012                fetchParams.controller.off(\042terminated\042, fetchParams.controller.onAborted);\012              }\012              fetchParams.controller.ended = true;\012              this.body.push(null);\012            },\012            onError(error) {\012              if (this.abort) {\012                fetchParams.controller.off(\042terminated\042, this.abort);\012              }\012              this.body\077.destroy(error);\012              fetchParams.controller.terminate(error);\012              reject(error);\012            },\012            onUpgrade(status, rawHeaders, socket) {\012              if (status !== 101) {\012                return;\012              }\012              const headersList = new HeadersList();\012              for (let i = 0; i < rawHeaders.length; i += 2) {\012                headersList.append(bufferToLowerCasedHeaderName(rawHeaders[i]), rawHeaders[i + 1].toString(\042latin1\042), true);\012              }\012              resolve({\012                status,\012                statusText: STATUS_CODES[status],\012                headersList,\012                socket\012              });\012              return true;\012            }\012          }\012        ));\012      }\012      __name(dispatch, \042dispatch\042);\012    }\012    __name(httpNetworkFetch, \042httpNetworkFetch\042);\012    module2.exports = {\012      fetch: fetch2,\012      Fetch,\012      fetching,\012      finalizeAndReportTiming\012    };\012  }\012});\012\012// lib/web/websocket/events.js\012var require_events = __commonJS({\012  \042lib/web/websocket/events.js\042(exports2, module2) {\012    \042use strict\042;\012    var { webidl } = require_webidl();\012    var { kEnumerableProperty } = require_util();\012    var { kConstruct } = require_symbols();\012    var { MessagePort } = require(\042node:worker_threads\042);\012    var MessageEvent2 = class _MessageEvent extends Event {\012      static {\012        __name(this, \042MessageEvent\042);\012      }\012      #eventInit;\012      constructor(type, eventInitDict = {}) {\012        if (type === kConstruct) {\012          super(arguments[1], arguments[2]);\012          webidl.util.markAsUncloneable(this);\012          return;\012        }\012        const prefix = \042MessageEvent constructor\042;\012        webidl.argumentLengthCheck(arguments, 1, prefix);\012        type = webidl.converters.DOMString(type, prefix, \042type\042);\012        eventInitDict = webidl.converters.MessageEventInit(eventInitDict, prefix, \042eventInitDict\042);\012        super(type, eventInitDict);\012        this.#eventInit = eventInitDict;\012        webidl.util.markAsUncloneable(this);\012      }\012      get data() {\012        webidl.brandCheck(this, _MessageEvent);\012        return this.#eventInit.data;\012      }\012      get origin() {\012        webidl.brandCheck(this, _MessageEvent);\012        return this.#eventInit.origin;\012      }\012      get lastEventId() {\012        webidl.brandCheck(this, _MessageEvent);\012        return this.#eventInit.lastEventId;\012      }\012      get source() {\012        webidl.brandCheck(this, _MessageEvent);\012        return this.#eventInit.source;\012      }\012      get ports() {\012        webidl.brandCheck(this, _MessageEvent);\012        if (!Object.isFrozen(this.#eventInit.ports)) {\012          Object.freeze(this.#eventInit.ports);\012        }\012        return this.#eventInit.ports;\012      }\012      initMessageEvent(type, bubbles = false, cancelable = false, data = null, origin = \042\042, lastEventId = \042\042, source = null, ports = []) {\012        webidl.brandCheck(this, _MessageEvent);\012        webidl.argumentLengthCheck(arguments, 1, \042MessageEvent.initMessageEvent\042);\012        return new _MessageEvent(type, {\012          bubbles,\012          cancelable,\012          data,\012          origin,\012          lastEventId,\012          source,\012          ports\012        });\012      }\012      static createFastMessageEvent(type, init) {\012        const messageEvent = new _MessageEvent(kConstruct, type, init);\012        messageEvent.#eventInit = init;\012        messageEvent.#eventInit.data \077\077= null;\012        messageEvent.#eventInit.origin \077\077= \042\042;\012        messageEvent.#eventInit.lastEventId \077\077= \042\042;\012        messageEvent.#eventInit.source \077\077= null;\012        messageEvent.#eventInit.ports \077\077= [];\012        return messageEvent;\012      }\012    };\012    var { createFastMessageEvent: createFastMessageEvent2 } = MessageEvent2;\012    delete MessageEvent2.createFastMessageEvent;\012    var CloseEvent2 = class _CloseEvent extends Event {\012      static {\012        __name(this, \042CloseEvent\042);\012      }\012      #eventInit;\012      constructor(type, eventInitDict = {}) {\012        const prefix = \042CloseEvent constructor\042;\012        webidl.argumentLengthCheck(arguments, 1, prefix);\012        type = webidl.converters.DOMString(type, prefix, \042type\042);\012        eventInitDict = webidl.converters.CloseEventInit(eventInitDict);\012        super(type, eventInitDict);\012        this.#eventInit = eventInitDict;\012        webidl.util.markAsUncloneable(this);\012      }\012      get wasClean() {\012        webidl.brandCheck(this, _CloseEvent);\012        return this.#eventInit.wasClean;\012      }\012      get code() {\012        webidl.brandCheck(this, _CloseEvent);\012        return this.#eventInit.code;\012      }\012      get reason() {\012        webidl.brandCheck(this, _CloseEvent);\012        return this.#eventInit.reason;\012      }\012    };\012    var ErrorEvent2 = class _ErrorEvent extends Event {\012      static {\012        __name(this, \042ErrorEvent\042);\012      }\012      #eventInit;\012      constructor(type, eventInitDict) {\012        const prefix = \042ErrorEvent constructor\042;\012        webidl.argumentLengthCheck(arguments, 1, prefix);\012        super(type, eventInitDict);\012        webidl.util.markAsUncloneable(this);\012        type = webidl.converters.DOMString(type, prefix, \042type\042);\012        eventInitDict = webidl.converters.ErrorEventInit(eventInitDict \077\077 {});\012        this.#eventInit = eventInitDict;\012      }\012      get message() {\012        webidl.brandCheck(this, _ErrorEvent);\012        return this.#eventInit.message;\012      }\012      get filename() {\012        webidl.brandCheck(this, _ErrorEvent);\012        return this.#eventInit.filename;\012      }\012      get lineno() {\012        webidl.brandCheck(this, _ErrorEvent);\012        return this.#eventInit.lineno;\012      }\012      get colno() {\012        webidl.brandCheck(this, _ErrorEvent);\012        return this.#eventInit.colno;\012      }\012      get error() {\012        webidl.brandCheck(this, _ErrorEvent);\012        return this.#eventInit.error;\012      }\012    };\012    Object.defineProperties(MessageEvent2.prototype, {\012      [Symbol.toStringTag]: {\012        value: \042MessageEvent\042,\012        configurable: true\012      },\012      data: kEnumerableProperty,\012      origin: kEnumerableProperty,\012      lastEventId: kEnumerableProperty,\012      source: kEnumerableProperty,\012      ports: kEnumerableProperty,\012      initMessageEvent: kEnumerableProperty\012    });\012    Object.defineProperties(CloseEvent2.prototype, {\012      [Symbol.toStringTag]: {\012        value: \042CloseEvent\042,\012        configurable: true\012      },\012      reason: kEnumerableProperty,\012      code: kEnumerableProperty,\012      wasClean: kEnumerableProperty\012    });\012    Object.defineProperties(ErrorEvent2.prototype, {\012      [Symbol.toStringTag]: {\012        value: \042ErrorEvent\042,\012        configurable: true\012      },\012      message: kEnumerableProperty,\012      filename: kEnumerableProperty,\012      lineno: kEnumerableProperty,\012      colno: kEnumerableProperty,\012      error: kEnumerableProperty\012    });\012    webidl.converters.MessagePort = webidl.interfaceConverter(MessagePort);\012    webidl.converters[\042sequence<MessagePort>\042] = webidl.sequenceConverter(\012      webidl.converters.MessagePort\012    );\012    var eventInit = [\012      {\012        key: \042bubbles\042,\012        converter: webidl.converters.boolean,\012        defaultValue: () => false\012      },\012      {\012        key: \042cancelable\042,\012        converter: webidl.converters.boolean,\012        defaultValue: () => false\012      },\012      {\012        key: \042composed\042,\012        converter: webidl.converters.boolean,\012        defaultValue: () => false\012      }\012    ];\012    webidl.converters.MessageEventInit = webidl.dictionaryConverter([\012      ...eventInit,\012      {\012        key: \042data\042,\012        converter: webidl.converters.any,\012        defaultValue: () => null\012      },\012      {\012        key: \042origin\042,\012        converter: webidl.converters.USVString,\012        defaultValue: () => \042\042\012      },\012      {\012        key: \042lastEventId\042,\012        converter: webidl.converters.DOMString,\012        defaultValue: () => \042\042\012      },\012      {\012        key: \042source\042,\012        // Node doesn't implement WindowProxy or ServiceWorker, so the only\012        // valid value for source is a MessagePort.\012        converter: webidl.nullableConverter(webidl.converters.MessagePort),\012        defaultValue: () => null\012      },\012      {\012        key: \042ports\042,\012        converter: webidl.converters[\042sequence<MessagePort>\042],\012        defaultValue: () => new Array(0)\012      }\012    ]);\012    webidl.converters.CloseEventInit = webidl.dictionaryConverter([\012      ...eventInit,\012      {\012        key: \042wasClean\042,\012        converter: webidl.converters.boolean,\012        defaultValue: () => false\012      },\012      {\012        key: \042code\042,\012        converter: webidl.converters[\042unsigned short\042],\012        defaultValue: () => 0\012      },\012      {\012        key: \042reason\042,\012        converter: webidl.converters.USVString,\012        defaultValue: () => \042\042\012      }\012    ]);\012    webidl.converters.ErrorEventInit = webidl.dictionaryConverter([\012      ...eventInit,\012      {\012        key: \042message\042,\012        converter: webidl.converters.DOMString,\012        defaultValue: () => \042\042\012      },\012      {\012        key: \042filename\042,\012        converter: webidl.converters.USVString,\012        defaultValue: () => \042\042\012      },\012      {\012        key: \042lineno\042,\012        converter: webidl.converters[\042unsigned long\042],\012        defaultValue: () => 0\012      },\012      {\012        key: \042colno\042,\012        converter: webidl.converters[\042unsigned long\042],\012        defaultValue: () => 0\012      },\012      {\012        key: \042error\042,\012        converter: webidl.converters.any\012      }\012    ]);\012    module2.exports = {\012      MessageEvent: MessageEvent2,\012      CloseEvent: CloseEvent2,\012      ErrorEvent: ErrorEvent2,\012      createFastMessageEvent: createFastMessageEvent2\012    };\012  }\012});\012\012// lib/web/websocket/constants.js\012var require_constants4 = __commonJS({\012  \042lib/web/websocket/constants.js\042(exports2, module2) {\012    \042use strict\042;\012    var uid = \042258EAFA5-E914-47DA-95CA-C5AB0DC85B11\042;\012    var staticPropertyDescriptors = {\012      enumerable: true,\012      writable: false,\012      configurable: false\012    };\012    var states = {\012      CONNECTING: 0,\012      OPEN: 1,\012      CLOSING: 2,\012      CLOSED: 3\012    };\012    var sentCloseFrameState = {\012      NOT_SENT: 0,\012      PROCESSING: 1,\012      SENT: 2\012    };\012    var opcodes = {\012      CONTINUATION: 0,\012      TEXT: 1,\012      BINARY: 2,\012      CLOSE: 8,\012      PING: 9,\012      PONG: 10\012    };\012    var maxUnsigned16Bit = 2 ** 16 - 1;\012    var parserStates = {\012      INFO: 0,\012      PAYLOADLENGTH_16: 2,\012      PAYLOADLENGTH_64: 3,\012      READ_DATA: 4\012    };\012    var emptyBuffer = Buffer.allocUnsafe(0);\012    var sendHints = {\012      string: 1,\012      typedArray: 2,\012      arrayBuffer: 3,\012      blob: 4\012    };\012    module2.exports = {\012      uid,\012      sentCloseFrameState,\012      staticPropertyDescriptors,\012      states,\012      opcodes,\012      maxUnsigned16Bit,\012      parserStates,\012      emptyBuffer,\012      sendHints\012    };\012  }\012});\012\012// lib/web/websocket/symbols.js\012var require_symbols3 = __commonJS({\012  \042lib/web/websocket/symbols.js\042(exports2, module2) {\012    \042use strict\042;\012    module2.exports = {\012      kWebSocketURL: Symbol(\042url\042),\012      kReadyState: Symbol(\042ready state\042),\012      kController: Symbol(\042controller\042),\012      kResponse: Symbol(\042response\042),\012      kBinaryType: Symbol(\042binary type\042),\012      kSentClose: Symbol(\042sent close\042),\012      kReceivedClose: Symbol(\042received close\042),\012      kByteParser: Symbol(\042byte parser\042)\012    };\012  }\012});\012\012// lib/web/websocket/util.js\012var require_util3 = __commonJS({\012  \042lib/web/websocket/util.js\042(exports2, module2) {\012    \042use strict\042;\012    var { kReadyState, kController, kResponse, kBinaryType, kWebSocketURL } = require_symbols3();\012    var { states, opcodes } = require_constants4();\012    var { ErrorEvent: ErrorEvent2, createFastMessageEvent: createFastMessageEvent2 } = require_events();\012    var { isUtf8 } = require(\042node:buffer\042);\012    var { collectASequenceOfCodePointsFast, removeHTTPWhitespace } = require_data_url();\012    function isConnecting(ws) {\012      return ws[kReadyState] === states.CONNECTING;\012    }\012    __name(isConnecting, \042isConnecting\042);\012    function isEstablished(ws) {\012      return ws[kReadyState] === states.OPEN;\012    }\012    __name(isEstablished, \042isEstablished\042);\012    function isClosing(ws) {\012      return ws[kReadyState] === states.CLOSING;\012    }\012    __name(isClosing, \042isClosing\042);\012    function isClosed(ws) {\012      return ws[kReadyState] === states.CLOSED;\012    }\012    __name(isClosed, \042isClosed\042);\012    function fireEvent(e, target, eventFactory = (type, init) => new Event(type, init), eventInitDict = {}) {\012      const event = eventFactory(e, eventInitDict);\012      target.dispatchEvent(event);\012    }\012    __name(fireEvent, \042fireEvent\042);\012    function websocketMessageReceived(ws, type, data) {\012      if (ws[kReadyState] !== states.OPEN) {\012        return;\012      }\012      let dataForEvent;\012      if (type === opcodes.TEXT) {\012        try {\012          dataForEvent = utf8Decode(data);\012        } catch {\012          failWebsocketConnection(ws, \042Received invalid UTF-8 in text frame.\042);\012          return;\012        }\012      } else if (type === opcodes.BINARY) {\012        if (ws[kBinaryType] === \042blob\042) {\012          dataForEvent = new Blob([data]);\012        } else {\012          dataForEvent = toArrayBuffer(data);\012        }\012      }\012      fireEvent(\042message\042, ws, createFastMessageEvent2, {\012        origin: ws[kWebSocketURL].origin,\012        data: dataForEvent\012      });\012    }\012    __name(websocketMessageReceived, \042websocketMessageReceived\042);\012    function toArrayBuffer(buffer) {\012      if (buffer.byteLength === buffer.buffer.byteLength) {\012        return buffer.buffer;\012      }\012      return buffer.buffer.slice(buffer.byteOffset, buffer.byteOffset + buffer.byteLength);\012    }\012    __name(toArrayBuffer, \042toArrayBuffer\042);\012    function isValidSubprotocol(protocol) {\012      if (protocol.length === 0) {\012        return false;\012      }\012      for (let i = 0; i < protocol.length; ++i) {\012        const code = protocol.charCodeAt(i);\012        if (code < 33 || // CTL, contains SP (0x20) and HT (0x09)\012        code > 126 || code === 34 || // \042\012        code === 40 || // (\012        code === 41 || // )\012        code === 44 || // ,\012        code === 47 || // /\012        code === 58 || // :\012        code === 59 || // ;\012        code === 60 || // <\012        code === 61 || // =\012        code === 62 || // >\012        code === 63 || // \077\012        code === 64 || // @\012        code === 91 || // [\012        code === 92 || // \134\012        code === 93 || // ]\012        code === 123 || // {\012        code === 125) {\012          return false;\012        }\012      }\012      return true;\012    }\012    __name(isValidSubprotocol, \042isValidSubprotocol\042);\012    function isValidStatusCode(code) {\012      if (code >= 1e3 && code < 1015) {\012        return code !== 1004 && // reserved\012        code !== 1005 && // \042MUST NOT be set as a status code\042\012        code !== 1006;\012      }\012      return code >= 3e3 && code <= 4999;\012    }\012    __name(isValidStatusCode, \042isValidStatusCode\042);\012    function failWebsocketConnection(ws, reason) {\012      const { [kController]: controller, [kResponse]: response } = ws;\012      controller.abort();\012      if (response\077.socket && !response.socket.destroyed) {\012        response.socket.destroy();\012      }\012      if (reason) {\012        fireEvent(\042error\042, ws, (type, init) => new ErrorEvent2(type, init), {\012          error: new Error(reason),\012          message: reason\012        });\012      }\012    }\012    __name(failWebsocketConnection, \042failWebsocketConnection\042);\012    function isControlFrame(opcode) {\012      return opcode === opcodes.CLOSE || opcode === opcodes.PING || opcode === opcodes.PONG;\012    }\012    __name(isControlFrame, \042isControlFrame\042);\012    function isContinuationFrame(opcode) {\012      return opcode === opcodes.CONTINUATION;\012    }\012    __name(isContinuationFrame, \042isContinuationFrame\042);\012    function isTextBinaryFrame(opcode) {\012      return opcode === opcodes.TEXT || opcode === opcodes.BINARY;\012    }\012    __name(isTextBinaryFrame, \042isTextBinaryFrame\042);\012    function isValidOpcode(opcode) {\012      return isTextBinaryFrame(opcode) || isContinuationFrame(opcode) || isControlFrame(opcode);\012    }\012    __name(isValidOpcode, \042isValidOpcode\042);\012    function parseExtensions(extensions) {\012      const position = { position: 0 };\012      const extensionList = /* @__PURE__ */ new Map();\012      while (position.position < extensions.length) {\012        const pair = collectASequenceOfCodePointsFast(\042;\042, extensions, position);\012        const [name, value = \042\042] = pair.split(\042=\042);\012        extensionList.set(\012          removeHTTPWhitespace(name, true, false),\012          removeHTTPWhitespace(value, false, true)\012        );\012        position.position++;\012      }\012      return extensionList;\012    }\012    __name(parseExtensions, \042parseExtensions\042);\012    function isValidClientWindowBits(value) {\012      for (let i = 0; i < value.length; i++) {\012        const byte = value.charCodeAt(i);\012        if (byte < 48 || byte > 57) {\012          return false;\012        }\012      }\012      return true;\012    }\012    __name(isValidClientWindowBits, \042isValidClientWindowBits\042);\012    var hasIntl = typeof process.versions.icu === \042string\042;\012    var fatalDecoder = hasIntl \077 new TextDecoder(\042utf-8\042, { fatal: true }) : void 0;\012    var utf8Decode = hasIntl \077 fatalDecoder.decode.bind(fatalDecoder) : function(buffer) {\012      if (isUtf8(buffer)) {\012        return buffer.toString(\042utf-8\042);\012      }\012      throw new TypeError(\042Invalid utf-8 received.\042);\012    };\012    module2.exports = {\012      isConnecting,\012      isEstablished,\012      isClosing,\012      isClosed,\012      fireEvent,\012      isValidSubprotocol,\012      isValidStatusCode,\012      failWebsocketConnection,\012      websocketMessageReceived,\012      utf8Decode,\012      isControlFrame,\012      isContinuationFrame,\012      isTextBinaryFrame,\012      isValidOpcode,\012      parseExtensions,\012      isValidClientWindowBits\012    };\012  }\012});\012\012// lib/web/websocket/frame.js\012var require_frame = __commonJS({\012  \042lib/web/websocket/frame.js\042(exports2, module2) {\012    \042use strict\042;\012    var { maxUnsigned16Bit } = require_constants4();\012    var BUFFER_SIZE = 16386;\012    var crypto;\012    var buffer = null;\012    var bufIdx = BUFFER_SIZE;\012    try {\012      crypto = require(\042node:crypto\042);\012    } catch {\012      crypto = {\012        // not full compatibility, but minimum.\012        randomFillSync: /* @__PURE__ */ __name(function randomFillSync(buffer2, _offset, _size) {\012          for (let i = 0; i < buffer2.length; ++i) {\012            buffer2[i] = Math.random() * 255 | 0;\012          }\012          return buffer2;\012        }, \042randomFillSync\042)\012      };\012    }\012    function generateMask() {\012      if (bufIdx === BUFFER_SIZE) {\012        bufIdx = 0;\012        crypto.randomFillSync(buffer \077\077= Buffer.allocUnsafe(BUFFER_SIZE), 0, BUFFER_SIZE);\012      }\012      return [buffer[bufIdx++], buffer[bufIdx++], buffer[bufIdx++], buffer[bufIdx++]];\012    }\012    __name(generateMask, \042generateMask\042);\012    var WebsocketFrameSend = class {\012      static {\012        __name(this, \042WebsocketFrameSend\042);\012      }\012      /**\012       * @param {Buffer|undefined} data\012       */\012      constructor(data) {\012        this.frameData = data;\012      }\012      createFrame(opcode) {\012        const frameData = this.frameData;\012        const maskKey = generateMask();\012        const bodyLength = frameData\077.byteLength \077\077 0;\012        let payloadLength = bodyLength;\012        let offset = 6;\012        if (bodyLength > maxUnsigned16Bit) {\012          offset += 8;\012          payloadLength = 127;\012        } else if (bodyLength > 125) {\012          offset += 2;\012          payloadLength = 126;\012        }\012        const buffer2 = Buffer.allocUnsafe(bodyLength + offset);\012        buffer2[0] = buffer2[1] = 0;\012        buffer2[0] |= 128;\012        buffer2[0] = (buffer2[0] & 240) + opcode;\012        buffer2[offset - 4] = maskKey[0];\012        buffer2[offset - 3] = maskKey[1];\012        buffer2[offset - 2] = maskKey[2];\012        buffer2[offset - 1] = maskKey[3];\012        buffer2[1] = payloadLength;\012        if (payloadLength === 126) {\012          buffer2.writeUInt16BE(bodyLength, 2);\012        } else if (payloadLength === 127) {\012          buffer2[2] = buffer2[3] = 0;\012          buffer2.writeUIntBE(bodyLength, 4, 6);\012        }\012        buffer2[1] |= 128;\012        for (let i = 0; i < bodyLength; ++i) {\012          buffer2[offset + i] = frameData[i] ^ maskKey[i & 3];\012        }\012        return buffer2;\012      }\012    };\012    module2.exports = {\012      WebsocketFrameSend\012    };\012  }\012});\012\012// lib/web/websocket/connection.js\012var require_connection = __commonJS({\012  \042lib/web/websocket/connection.js\042(exports2, module2) {\012    \042use strict\042;\012    var { uid, states, sentCloseFrameState, emptyBuffer, opcodes } = require_constants4();\012    var {\012      kReadyState,\012      kSentClose,\012      kByteParser,\012      kReceivedClose,\012      kResponse\012    } = require_symbols3();\012    var { fireEvent, failWebsocketConnection, isClosing, isClosed, isEstablished, parseExtensions } = require_util3();\012    var { channels } = require_diagnostics();\012    var { CloseEvent: CloseEvent2 } = require_events();\012    var { makeRequest } = require_request2();\012    var { fetching } = require_fetch();\012    var { Headers, getHeadersList } = require_headers();\012    var { getDecodeSplit } = require_util2();\