static const struct { const char *name; OptIndex opt_idx; } option_hash_elems[] = {
  { .name = "pa", .opt_idx = kOptPath },
  { .name = "ea", .opt_idx = kOptEqualalways },
  { .name = "ma", .opt_idx = kOptModifiable },
  { .name = "wa", .opt_idx = kOptWriteany },
  { .name = "pb", .opt_idx = kOptPumblend },
  { .name = "cb", .opt_idx = kOptClipboard },
  { .name = "wb", .opt_idx = kOptWritebackup },
  { .name = "eb", .opt_idx = kOptErrorbells },
  { .name = "vb", .opt_idx = kOptVisualbell },
  { .name = "sb", .opt_idx = kOptSplitbelow },
  { .name = "ic", .opt_idx = kOptIgnorecase },
  { .name = "sc", .opt_idx = kOptShowcmd },
  { .name = "tc", .opt_idx = kOptTagcase },
  { .name = "cc", .opt_idx = kOptColorcolumn },
  { .name = "uc", .opt_idx = kOptUpdatecount },
  { .name = "wc", .opt_idx = kOptWildchar },
  { .name = "ed", .opt_idx = kOptEdcompatible },
  { .name = "wd", .opt_idx = kOptWritedelay },
  { .name = "gd", .opt_idx = kOptGdefault },
  { .name = "sd", .opt_idx = kOptShada },
  { .name = "cd", .opt_idx = kOptCdpath },
  { .name = "qe", .opt_idx = kOptQuoteescape },
  { .name = "ve", .opt_idx = kOptVirtualedit },
  { .name = "re", .opt_idx = kOptRegexpengine },
  { .name = "nf", .opt_idx = kOptNrformats },
  { .name = "tf", .opt_idx = kOptTtyfast },
  { .name = "ff", .opt_idx = kOptFileformat },
  { .name = "cf", .opt_idx = kOptConfirm },
  { .name = "ef", .opt_idx = kOptErrorfile },
  { .name = "hf", .opt_idx = kOptHelpfile },
  { .name = "dg", .opt_idx = kOptDigraph },
  { .name = "bg", .opt_idx = kOptBackground },
  { .name = "ph", .opt_idx = kOptPumheight },
  { .name = "ch", .opt_idx = kOptCmdheight },
  { .name = "sh", .opt_idx = kOptShell },
  { .name = "wh", .opt_idx = kOptWinheight },
  { .name = "hh", .opt_idx = kOptHelpheight },
  { .name = "bh", .opt_idx = kOptBufhidden },
  { .name = "mh", .opt_idx = kOptMousehide },
  { .name = "pi", .opt_idx = kOptPreserveindent },
  { .name = "ai", .opt_idx = kOptAutoindent },
  { .name = "si", .opt_idx = kOptSmartindent },
  { .name = "wi", .opt_idx = kOptWindow },
  { .name = "ci", .opt_idx = kOptCopyindent },
  { .name = "ei", .opt_idx = kOptEventignore },
  { .name = "hi", .opt_idx = kOptHistory },
  { .name = "ri", .opt_idx = kOptRevins },
  { .name = "vi", .opt_idx = kOptShada },
  { .name = "sj", .opt_idx = kOptScrolljump },
  { .name = "bk", .opt_idx = kOptBackup },
  { .name = "hk", .opt_idx = kOptHkmap },
  { .name = "hl", .opt_idx = kOptHighlight },
  { .name = "ml", .opt_idx = kOptModeline },
  { .name = "ul", .opt_idx = kOptUndolevels },
  { .name = "tl", .opt_idx = kOptTaglength },
  { .name = "rl", .opt_idx = kOptRightleft },
  { .name = "al", .opt_idx = kOptAleph },
  { .name = "bl", .opt_idx = kOptBuflisted },
  { .name = "pm", .opt_idx = kOptPatchmode },
  { .name = "lm", .opt_idx = kOptLangmenu },
  { .name = "km", .opt_idx = kOptKeymodel },
  { .name = "im", .opt_idx = kOptInsertmode },
  { .name = "sm", .opt_idx = kOptShowmatch },
  { .name = "tm", .opt_idx = kOptTimeoutlen },
  { .name = "wm", .opt_idx = kOptWrapmargin },
  { .name = "to", .opt_idx = kOptTimeout },
  { .name = "ro", .opt_idx = kOptReadonly },
  { .name = "bo", .opt_idx = kOptBelloff },
  { .name = "go", .opt_idx = kOptGuioptions },
  { .name = "co", .opt_idx = kOptColumns },
  { .name = "so", .opt_idx = kOptScrolloff },
  { .name = "fo", .opt_idx = kOptFormatoptions },
  { .name = "pp", .opt_idx = kOptPackpath },
  { .name = "ep", .opt_idx = kOptEqualprg },
  { .name = "kp", .opt_idx = kOptKeywordprg },
  { .name = "mp", .opt_idx = kOptMakeprg },
  { .name = "cp", .opt_idx = kOptCompatible },
  { .name = "fp", .opt_idx = kOptFormatprg },
  { .name = "gp", .opt_idx = kOptGrepprg },
  { .name = "sp", .opt_idx = kOptShellpipe },
  { .name = "ar", .opt_idx = kOptAutoread },
  { .name = "tr", .opt_idx = kOptTagrelative },
  { .name = "ur", .opt_idx = kOptUndoreload },
  { .name = "sr", .opt_idx = kOptShiftround },
  { .name = "ss", .opt_idx = kOptSidescroll },
  { .name = "ls", .opt_idx = kOptLaststatus },
  { .name = "ws", .opt_idx = kOptWrapscan },
  { .name = "is", .opt_idx = kOptIncsearch },
  { .name = "js", .opt_idx = kOptJoinspaces },
  { .name = "bs", .opt_idx = kOptBackspace },
  { .name = "ts", .opt_idx = kOptTabstop },
  { .name = "fs", .opt_idx = kOptFsync },
  { .name = "pt", .opt_idx = kOptPastetoggle },
  { .name = "et", .opt_idx = kOptExpandtab },
  { .name = "ft", .opt_idx = kOptFiletype },
  { .name = "ut", .opt_idx = kOptUpdatetime },
  { .name = "bt", .opt_idx = kOptBuftype },
  { .name = "nu", .opt_idx = kOptNumber },
  { .name = "su", .opt_idx = kOptSuffixes },
  { .name = "ru", .opt_idx = kOptRuler },
  { .name = "pw", .opt_idx = kOptPumwidth },
  { .name = "aw", .opt_idx = kOptAutowrite },
  { .name = "lw", .opt_idx = kOptLispwords },
  { .name = "sw", .opt_idx = kOptShiftwidth },
  { .name = "tw", .opt_idx = kOptTextwidth },
  { .name = "ww", .opt_idx = kOptWhichwrap },
  { .name = "ex", .opt_idx = kOptExrc },
  { .name = "dy", .opt_idx = kOptDisplay },
  { .name = "lz", .opt_idx = kOptLazyredraw },
  { .name = "awa", .opt_idx = kOptAutowriteall },
  { .name = "sta", .opt_idx = kOptSmarttab },
  { .name = "cia", .opt_idx = kOptCompleteitemalign },
  { .name = "sua", .opt_idx = kOptSuffixesadd },
  { .name = "rdb", .opt_idx = kOptRedrawdebug },
  { .name = "scb", .opt_idx = kOptScrollbind },
  { .name = "crb", .opt_idx = kOptCursorbind },
  { .name = "wfb", .opt_idx = kOptWinfixbuf },
  { .name = "swb", .opt_idx = kOptSwitchbuf },
  { .name = "enc", .opt_idx = kOptEncoding },
  { .name = "fic", .opt_idx = kOptFileignorecase },
  { .name = "spc", .opt_idx = kOptSpellcapcheck },
  { .name = "inc", .opt_idx = kOptInclude },
  { .name = "wic", .opt_idx = kOptWildignorecase },
  { .name = "cuc", .opt_idx = kOptCursorcolumn },
  { .name = "tgc", .opt_idx = kOptTermguicolors },
  { .name = "smc", .opt_idx = kOptSynmaxcol },
  { .name = "fdc", .opt_idx = kOptFoldcolumn },
  { .name = "imc", .opt_idx = kOptImcmdline },
  { .name = "stc", .opt_idx = kOptStatuscolumn },
  { .name = "rlc", .opt_idx = kOptRightleftcmd },
  { .name = "bkc", .opt_idx = kOptBackupcopy },
  { .name = "ead", .opt_idx = kOptEadirection },
  { .name = "acd", .opt_idx = kOptAutochdir },
  { .name = "mfd", .opt_idx = kOptMaxfuncdepth },
  { .name = "mmd", .opt_idx = kOptMaxmapdepth },
  { .name = "smd", .opt_idx = kOptShowmode },
  { .name = "imd", .opt_idx = kOptImdisable },
  { .name = "hid", .opt_idx = kOptHidden },
  { .name = "mod", .opt_idx = kOptModified },
  { .name = "sxe", .opt_idx = kOptShellxescape },
  { .name = "mle", .opt_idx = kOptModelineexpr },
  { .name = "fde", .opt_idx = kOptFoldexpr },
  { .name = "udf", .opt_idx = kOptUndofile },
  { .name = "eof", .opt_idx = kOptEndoffile },
  { .name = "spf", .opt_idx = kOptSpellfile },
  { .name = "mef", .opt_idx = kOptMakeef },
  { .name = "inf", .opt_idx = kOptInfercase },
  { .name = "isf", .opt_idx = kOptIsfname },
  { .name = "def", .opt_idx = kOptDefine },
  { .name = "tpf", .opt_idx = kOptTermpastefilter },
  { .name = "ruf", .opt_idx = kOptRulerformat },
  { .name = "sdf", .opt_idx = kOptShadafile },
  { .name = "vif", .opt_idx = kOptShadafile },
  { .name = "swf", .opt_idx = kOptSwapfile },
  { .name = "tag", .opt_idx = kOptTags },
  { .name = "wig", .opt_idx = kOptWildignore },
  { .name = "hlg", .opt_idx = kOptHelplang },
  { .name = "pvh", .opt_idx = kOptPreviewheight },
  { .name = "wfh", .opt_idx = kOptWinfixheight },
  { .name = "cwh", .opt_idx = kOptCmdwinheight },
  { .name = "wmh", .opt_idx = kOptWinminheight },
  { .name = "cdh", .opt_idx = kOptCdhome },
  { .name = "fdi", .opt_idx = kOptFoldignore },
  { .name = "isi", .opt_idx = kOptIsident },
  { .name = "ari", .opt_idx = kOptAllowrevins },
  { .name = "imi", .opt_idx = kOptIminsert },
  { .name = "bri", .opt_idx = kOptBreakindent },
  { .name = "isk", .opt_idx = kOptIskeyword },
  { .name = "wak", .opt_idx = kOptWinaltkeys },
  { .name = "spk", .opt_idx = kOptSplitkeep },
  { .name = "bsk", .opt_idx = kOptBackupskip },
  { .name = "brk", .opt_idx = kOptBreakat },
  { .name = "scl", .opt_idx = kOptSigncolumn },
  { .name = "lpl", .opt_idx = kOptLoadplugins },
  { .name = "tcl", .opt_idx = kOptTabclose },
  { .name = "tal", .opt_idx = kOptTabline },
  { .name = "spl", .opt_idx = kOptSpelllang },
  { .name = "cul", .opt_idx = kOptCursorline },
  { .name = "stl", .opt_idx = kOptStatusline },
  { .name = "sol", .opt_idx = kOptStartofline },
  { .name = "csl", .opt_idx = kOptCompleteslash },
  { .name = "fdl", .opt_idx = kOptFoldlevel },
  { .name = "fml", .opt_idx = kOptFoldminlines },
  { .name = "sel", .opt_idx = kOptSelection },
  { .name = "eol", .opt_idx = kOptEndofline },
  { .name = "ssl", .opt_idx = kOptShellslash },
  { .name = "gtl", .opt_idx = kOptGuitablabel },
  { .name = "fcl", .opt_idx = kOptFoldclose },
  { .name = "efm", .opt_idx = kOptErrorformat },
  { .name = "lrm", .opt_idx = kOptLangremap },
  { .name = "shm", .opt_idx = kOptShortmess },
  { .name = "msm", .opt_idx = kOptMkspellmem },
  { .name = "tpm", .opt_idx = kOptTabpagemax },
  { .name = "icm", .opt_idx = kOptInccommand },
  { .name = "wim", .opt_idx = kOptWildmode },
  { .name = "com", .opt_idx = kOptComments },
  { .name = "fdm", .opt_idx = kOptFoldmethod },
  { .name = "ttm", .opt_idx = kOptTtimeoutlen },
  { .name = "slm", .opt_idx = kOptSelectmode },
  { .name = "wcm", .opt_idx = kOptWildcharm },
  { .name = "gfm", .opt_idx = kOptGrepformat },
  { .name = "cin", .opt_idx = kOptCindent },
  { .name = "syn", .opt_idx = kOptSyntax },
  { .name = "fen", .opt_idx = kOptFoldenable },
  { .name = "fdn", .opt_idx = kOptFoldnestmax },
  { .name = "gfn", .opt_idx = kOptGuifont },
  { .name = "bin", .opt_idx = kOptBinary },
  { .name = "emo", .opt_idx = kOptEmoji },
  { .name = "mco", .opt_idx = kOptMaxcombine },
  { .name = "cpo", .opt_idx = kOptCpoptions },
  { .name = "sbo", .opt_idx = kOptScrollopt },
  { .name = "fdo", .opt_idx = kOptFoldopen },
  { .name = "spo", .opt_idx = kOptSpelloptions },
  { .name = "top", .opt_idx = kOptTildeop },
  { .name = "lsp", .opt_idx = kOptLinespace },
  { .name = "lop", .opt_idx = kOptLispoptions },
  { .name = "hkp", .opt_idx = kOptHkmapp },
  { .name = "mmp", .opt_idx = kOptMaxmempattern },
  { .name = "wop", .opt_idx = kOptWildoptions },
  { .name = "isp", .opt_idx = kOptIsprint },
  { .name = "jop", .opt_idx = kOptJumpoptions },
  { .name = "kmp", .opt_idx = kOptKeymap },
  { .name = "vop", .opt_idx = kOptViewoptions },
  { .name = "dip", .opt_idx = kOptDiffopt },
  { .name = "rtp", .opt_idx = kOptRuntimepath },
  { .name = "flp", .opt_idx = kOptFormatlistpat },
  { .name = "cmp", .opt_idx = kOptCasemap },
  { .name = "sxq", .opt_idx = kOptShellxquote },
  { .name = "shq", .opt_idx = kOptShellquote },
  { .name = "dir", .opt_idx = kOptDirectory },
  { .name = "lnr", .opt_idx = kOptLangnoremap },
  { .name = "lbr", .opt_idx = kOptLinebreak },
  { .name = "wbr", .opt_idx = kOptWinbar },
  { .name = "tsr", .opt_idx = kOptThesaurus },
  { .name = "scr", .opt_idx = kOptScroll },
  { .name = "gcr", .opt_idx = kOptGuicursor },
  { .name = "srr", .opt_idx = kOptShellredir },
  { .name = "spr", .opt_idx = kOptSplitright },
  { .name = "sbr", .opt_idx = kOptShowbreak },
  { .name = "fmr", .opt_idx = kOptFoldmarker },
  { .name = "vbs", .opt_idx = kOptVerbose },
  { .name = "ffs", .opt_idx = kOptFileformats },
  { .name = "fcs", .opt_idx = kOptFillchars },
  { .name = "scs", .opt_idx = kOptSmartcase },
  { .name = "sms", .opt_idx = kOptSmoothscroll },
  { .name = "sts", .opt_idx = kOptSofttabstop },
  { .name = "lcs", .opt_idx = kOptListchars },
  { .name = "mps", .opt_idx = kOptMatchpairs },
  { .name = "mis", .opt_idx = kOptMenuitems },
  { .name = "ims", .opt_idx = kOptImsearch },
  { .name = "mls", .opt_idx = kOptModelines },
  { .name = "tbs", .opt_idx = kOptTagbsearch },
  { .name = "cms", .opt_idx = kOptCommentstring },
  { .name = "vts", .opt_idx = kOptVartabstop },
  { .name = "hls", .opt_idx = kOptHlsearch },
  { .name = "sps", .opt_idx = kOptSpellsuggest },
  { .name = "mat", .opt_idx = kOptMatchtime },
  { .name = "sft", .opt_idx = kOptShowfulltag },
  { .name = "cot", .opt_idx = kOptCompleteopt },
  { .name = "rdt", .opt_idx = kOptRedrawtime },
  { .name = "cpt", .opt_idx = kOptComplete },
  { .name = "fdt", .opt_idx = kOptFoldtext },
  { .name = "gtt", .opt_idx = kOptGuitabtooltip },
  { .name = "ofu", .opt_idx = kOptOmnifunc },
  { .name = "ffu", .opt_idx = kOptFindfunc },
  { .name = "tfu", .opt_idx = kOptTagfunc },
  { .name = "cfu", .opt_idx = kOptCompletefunc },
  { .name = "rnu", .opt_idx = kOptRelativenumber },
  { .name = "ccv", .opt_idx = kOptCharconvert },
  { .name = "nuw", .opt_idx = kOptNumberwidth },
  { .name = "pvw", .opt_idx = kOptPreviewwindow },
  { .name = "eiw", .opt_idx = kOptEventignorewin },
  { .name = "wiw", .opt_idx = kOptWinwidth },
  { .name = "wmw", .opt_idx = kOptWinminwidth },
  { .name = "wfw", .opt_idx = kOptWinfixwidth },
  { .name = "gfw", .opt_idx = kOptGuifontwide },
  { .name = "pex", .opt_idx = kOptPatchexpr },
  { .name = "pyx", .opt_idx = kOptPyxversion },
  { .name = "dex", .opt_idx = kOptDiffexpr },
  { .name = "fex", .opt_idx = kOptFormatexpr },
  { .name = "bex", .opt_idx = kOptBackupext },
  { .name = "para", .opt_idx = kOptParagraphs },
  { .name = "bomb", .opt_idx = kOptBomb },
  { .name = "arab", .opt_idx = kOptArabic },
  { .name = "exrc", .opt_idx = kOptExrc },
  { .name = "fenc", .opt_idx = kOptFileencoding },
  { .name = "menc", .opt_idx = kOptMakeencoding },
  { .name = "sloc", .opt_idx = kOptShowcmdloc },
  { .name = "tenc", .opt_idx = kOptTermencoding },
  { .name = "cole", .opt_idx = kOptConceallevel },
  { .name = "inde", .opt_idx = kOptIndentexpr },
  { .name = "more", .opt_idx = kOptMore },
  { .name = "qftf", .opt_idx = kOptQuickfixtextfunc },
  { .name = "diff", .opt_idx = kOptDiff },
  { .name = "shcf", .opt_idx = kOptShellcmdflag },
  { .name = "path", .opt_idx = kOptPath },
  { .name = "cink", .opt_idx = kOptCinkeys },
  { .name = "indk", .opt_idx = kOptIndentkeys },
  { .name = "scbk", .opt_idx = kOptScrollback },
  { .name = "stal", .opt_idx = kOptShowtabline },
  { .name = "icon", .opt_idx = kOptIcon },
  { .name = "warn", .opt_idx = kOptWarn },
  { .name = "siso", .opt_idx = kOptSidescrolloff },
  { .name = "cino", .opt_idx = kOptCinoptions },
  { .name = "deco", .opt_idx = kOptDelcombine },
  { .name = "lmap", .opt_idx = kOptLangmap },
  { .name = "lisp", .opt_idx = kOptLisp },
  { .name = "stmp", .opt_idx = kOptShelltemp },
  { .name = "wrap", .opt_idx = kOptWrap },
  { .name = "ssop", .opt_idx = kOptSessionoptions },
  { .name = "vdir", .opt_idx = kOptViewdir },
  { .name = "udir", .opt_idx = kOptUndodir },
  { .name = "bdir", .opt_idx = kOptBackupdir },
  { .name = "vsts", .opt_idx = kOptVarsofttabstop },
  { .name = "fdls", .opt_idx = kOptFoldlevelstart },
  { .name = "tags", .opt_idx = kOptTags },
  { .name = "list", .opt_idx = kOptList },
  { .name = "mopt", .opt_idx = kOptMessagesopt },
  { .name = "dict", .opt_idx = kOptDictionary },
  { .name = "tgst", .opt_idx = kOptTagstack },
  { .name = "sect", .opt_idx = kOptSections },
  { .name = "wmnu", .opt_idx = kOptWildmenu },
  { .name = "cocu", .opt_idx = kOptConcealcursor },
  { .name = "odev", .opt_idx = kOptOpendevice },
  { .name = "ambw", .opt_idx = kOptAmbiwidth },
  { .name = "cinw", .opt_idx = kOptCinwords },
  { .name = "inex", .opt_idx = kOptIncludeexpr },
  { .name = "aleph", .opt_idx = kOptAleph },
  { .name = "bsdir", .opt_idx = kOptBrowsedir },
  { .name = "cedit", .opt_idx = kOptCedit },
  { .name = "cinsd", .opt_idx = kOptCinscopedecls },
  { .name = "debug", .opt_idx = kOptDebug },
  { .name = "emoji", .opt_idx = kOptEmoji },
  { .name = "fencs", .opt_idx = kOptFileencodings },
  { .name = "fsync", .opt_idx = kOptFsync },
  { .name = "hkmap", .opt_idx = kOptHkmap },
  { .name = "lines", .opt_idx = kOptLines },
  { .name = "magic", .opt_idx = kOptMagic },
  { .name = "mouse", .opt_idx = kOptMouse },
  { .name = "paste", .opt_idx = kOptPaste },
  { .name = "remap", .opt_idx = kOptRemap },
  { .name = "ruler", .opt_idx = kOptRuler },
  { .name = "spell", .opt_idx = kOptSpell },
  { .name = "shada", .opt_idx = kOptShada },
  { .name = "shell", .opt_idx = kOptShell },
  { .name = "title", .opt_idx = kOptTitle },
  { .name = "tbidi", .opt_idx = kOptTermbidi },
  { .name = "terse", .opt_idx = kOptTerse },
  { .name = "tsrfu", .opt_idx = kOptThesaurusfunc },
  { .name = "vfile", .opt_idx = kOptVerbosefile },
  { .name = "write", .opt_idx = kOptWrite },
  { .name = "winhl", .opt_idx = kOptWinhighlight },
  { .name = "winbl", .opt_idx = kOptWinblend },
  { .name = "arabic", .opt_idx = kOptArabic },
  { .name = "secure", .opt_idx = kOptSecure },
  { .name = "backup", .opt_idx = kOptBackup },
  { .name = "hidden", .opt_idx = kOptHidden },
  { .name = "opfunc", .opt_idx = kOptOperatorfunc },
  { .name = "define", .opt_idx = kOptDefine },
  { .name = "cdhome", .opt_idx = kOptCdhome },
  { .name = "briopt", .opt_idx = kOptBreakindentopt },
  { .name = "makeef", .opt_idx = kOptMakeef },
  { .name = "culopt", .opt_idx = kOptCursorlineopt },
  { .name = "hkmapp", .opt_idx = kOptHkmapp },
  { .name = "number", .opt_idx = kOptNumber },
  { .name = "window", .opt_idx = kOptWindow },
  { .name = "winbar", .opt_idx = kOptWinbar },
  { .name = "syntax", .opt_idx = kOptSyntax },
  { .name = "binary", .opt_idx = kOptBinary },
  { .name = "prompt", .opt_idx = kOptPrompt },
  { .name = "report", .opt_idx = kOptReport },
  { .name = "cdpath", .opt_idx = kOptCdpath },
  { .name = "scroll", .opt_idx = kOptScroll },
  { .name = "mouset", .opt_idx = kOptMousetime },
  { .name = "mouses", .opt_idx = kOptMouseshape },
  { .name = "mousef", .opt_idx = kOptMousefocus },
  { .name = "mousem", .opt_idx = kOptMousemodel },
  { .name = "revins", .opt_idx = kOptRevins },
  { .name = "fixeol", .opt_idx = kOptFixendofline },
  { .name = "keymap", .opt_idx = kOptKeymap },
  { .name = "channel", .opt_idx = kOptChannel },
  { .name = "tabline", .opt_idx = kOptTabline },
  { .name = "tabstop", .opt_idx = kOptTabstop },
  { .name = "include", .opt_idx = kOptInclude },
  { .name = "undodir", .opt_idx = kOptUndodir },
  { .name = "viewdir", .opt_idx = kOptViewdir },
  { .name = "grepprg", .opt_idx = kOptGrepprg },
  { .name = "breakat", .opt_idx = kOptBreakat },
  { .name = "diffopt", .opt_idx = kOptDiffopt },
  { .name = "isfname", .opt_idx = kOptIsfname },
  { .name = "buftype", .opt_idx = kOptBuftype },
  { .name = "digraph", .opt_idx = kOptDigraph },
  { .name = "tagcase", .opt_idx = kOptTagcase },
  { .name = "tagfunc", .opt_idx = kOptTagfunc },
  { .name = "isident", .opt_idx = kOptIsident },
  { .name = "guifont", .opt_idx = kOptGuifont },
  { .name = "makeprg", .opt_idx = kOptMakeprg },
  { .name = "tildeop", .opt_idx = kOptTildeop },
  { .name = "columns", .opt_idx = kOptColumns },
  { .name = "belloff", .opt_idx = kOptBelloff },
  { .name = "timeout", .opt_idx = kOptTimeout },
  { .name = "viminfo", .opt_idx = kOptShada },
  { .name = "cindent", .opt_idx = kOptCindent },
  { .name = "cinkeys", .opt_idx = kOptCinkeys },
  { .name = "langmap", .opt_idx = kOptLangmap },
  { .name = "confirm", .opt_idx = kOptConfirm },
  { .name = "showcmd", .opt_idx = kOptShowcmd },
  { .name = "isprint", .opt_idx = kOptIsprint },
  { .name = "verbose", .opt_idx = kOptVerbose },
  { .name = "display", .opt_idx = kOptDisplay },
  { .name = "arshape", .opt_idx = kOptArabicshape },
  { .name = "casemap", .opt_idx = kOptCasemap },
  { .name = "history", .opt_idx = kOptHistory },
  { .name = "ttyfast", .opt_idx = kOptTtyfast },
  { .name = "autoread", .opt_idx = kOptAutoread },
  { .name = "cinwords", .opt_idx = kOptCinwords },
  { .name = "comments", .opt_idx = kOptComments },
  { .name = "complete", .opt_idx = kOptComplete },
  { .name = "diffexpr", .opt_idx = kOptDiffexpr },
  { .name = "encoding", .opt_idx = kOptEncoding },
  { .name = "equalprg", .opt_idx = kOptEqualprg },
  { .name = "filetype", .opt_idx = kOptFiletype },
  { .name = "findfunc", .opt_idx = kOptFindfunc },
  { .name = "foldexpr", .opt_idx = kOptFoldexpr },
  { .name = "foldopen", .opt_idx = kOptFoldopen },
  { .name = "foldtext", .opt_idx = kOptFoldtext },
  { .name = "gdefault", .opt_idx = kOptGdefault },
  { .name = "helpfile", .opt_idx = kOptHelpfile },
  { .name = "hlsearch", .opt_idx = kOptHlsearch },
  { .name = "helplang", .opt_idx = kOptHelplang },
  { .name = "imsearch", .opt_idx = kOptImsearch },
  { .name = "iminsert", .opt_idx = kOptIminsert },
  { .name = "keymodel", .opt_idx = kOptKeymodel },
  { .name = "langmenu", .opt_idx = kOptLangmenu },
  { .name = "modeline", .opt_idx = kOptModeline },
  { .name = "mousemev", .opt_idx = kOptMousemoveevent },
  { .name = "modified", .opt_idx = kOptModified },
  { .name = "omnifunc", .opt_idx = kOptOmnifunc },
  { .name = "packpath", .opt_idx = kOptPackpath },
  { .name = "pumblend", .opt_idx = kOptPumblend },
  { .name = "pumwidth", .opt_idx = kOptPumwidth },
  { .name = "readonly", .opt_idx = kOptReadonly },
  { .name = "smarttab", .opt_idx = kOptSmarttab },
  { .name = "showmode", .opt_idx = kOptShowmode },
  { .name = "swapfile", .opt_idx = kOptSwapfile },
  { .name = "sections", .opt_idx = kOptSections },
  { .name = "suffixes", .opt_idx = kOptSuffixes },
  { .name = "titleold", .opt_idx = kOptTitleold },
  { .name = "tagstack", .opt_idx = kOptTagstack },
  { .name = "ttimeout", .opt_idx = kOptTtimeout },
  { .name = "titlelen", .opt_idx = kOptTitlelen },
  { .name = "termbidi", .opt_idx = kOptTermbidi },
  { .name = "tabclose", .opt_idx = kOptTabclose },
  { .name = "termsync", .opt_idx = kOptTermsync },
  { .name = "undofile", .opt_idx = kOptUndofile },
  { .name = "writeany", .opt_idx = kOptWriteany },
  { .name = "wrapscan", .opt_idx = kOptWrapscan },
  { .name = "winwidth", .opt_idx = kOptWinwidth },
  { .name = "winblend", .opt_idx = kOptWinblend },
  { .name = "wildmode", .opt_idx = kOptWildmode },
  { .name = "wildmenu", .opt_idx = kOptWildmenu },
  { .name = "wildchar", .opt_idx = kOptWildchar },
  { .name = "expandtab", .opt_idx = kOptExpandtab },
  { .name = "langremap", .opt_idx = kOptLangremap },
  { .name = "linebreak", .opt_idx = kOptLinebreak },
  { .name = "showbreak", .opt_idx = kOptShowbreak },
  { .name = "whichwrap", .opt_idx = kOptWhichwrap },
  { .name = "linespace", .opt_idx = kOptLinespace },
  { .name = "incsearch", .opt_idx = kOptIncsearch },
  { .name = "backspace", .opt_idx = kOptBackspace },
  { .name = "showmatch", .opt_idx = kOptShowmatch },
  { .name = "patchmode", .opt_idx = kOptPatchmode },
  { .name = "lispwords", .opt_idx = kOptLispwords },
  { .name = "mousehide", .opt_idx = kOptMousehide },
  { .name = "modelines", .opt_idx = kOptModelines },
  { .name = "winborder", .opt_idx = kOptWinborder },
  { .name = "foldlevel", .opt_idx = kOptFoldlevel },
  { .name = "splitkeep", .opt_idx = kOptSplitkeep },
  { .name = "bufhidden", .opt_idx = kOptBufhidden },
  { .name = "buflisted", .opt_idx = kOptBuflisted },
  { .name = "rightleft", .opt_idx = kOptRightleft },
  { .name = "scrolloff", .opt_idx = kOptScrolloff },
  { .name = "pumheight", .opt_idx = kOptPumheight },
  { .name = "winheight", .opt_idx = kOptWinheight },
  { .name = "cmdheight", .opt_idx = kOptCmdheight },
  { .name = "highlight", .opt_idx = kOptHighlight },
  { .name = "autochdir", .opt_idx = kOptAutochdir },
  { .name = "backupdir", .opt_idx = kOptBackupdir },
  { .name = "browsedir", .opt_idx = kOptBrowsedir },
  { .name = "spellfile", .opt_idx = kOptSpellfile },
  { .name = "shadafile", .opt_idx = kOptShadafile },
  { .name = "imdisable", .opt_idx = kOptImdisable },
  { .name = "errorfile", .opt_idx = kOptErrorfile },
  { .name = "endoffile", .opt_idx = kOptEndoffile },
  { .name = "matchtime", .opt_idx = kOptMatchtime },
  { .name = "menuitems", .opt_idx = kOptMenuitems },
  { .name = "mousetime", .opt_idx = kOptMousetime },
  { .name = "shelltemp", .opt_idx = kOptShelltemp },
  { .name = "endofline", .opt_idx = kOptEndofline },
  { .name = "cpoptions", .opt_idx = kOptCpoptions },
  { .name = "spelllang", .opt_idx = kOptSpelllang },
  { .name = "imcmdline", .opt_idx = kOptImcmdline },
  { .name = "synmaxcol", .opt_idx = kOptSynmaxcol },
  { .name = "selection", .opt_idx = kOptSelection },
  { .name = "guicursor", .opt_idx = kOptGuicursor },
  { .name = "patchexpr", .opt_idx = kOptPatchexpr },
  { .name = "scrollopt", .opt_idx = kOptScrollopt },
  { .name = "shellpipe", .opt_idx = kOptShellpipe },
  { .name = "directory", .opt_idx = kOptDirectory },
  { .name = "fillchars", .opt_idx = kOptFillchars },
  { .name = "listchars", .opt_idx = kOptListchars },
  { .name = "clipboard", .opt_idx = kOptClipboard },
  { .name = "iskeyword", .opt_idx = kOptIskeyword },
  { .name = "wildcharm", .opt_idx = kOptWildcharm },
  { .name = "formatprg", .opt_idx = kOptFormatprg },
  { .name = "smartcase", .opt_idx = kOptSmartcase },
  { .name = "infercase", .opt_idx = kOptInfercase },
  { .name = "foldclose", .opt_idx = kOptFoldclose },
  { .name = "shortmess", .opt_idx = kOptShortmess },
  { .name = "nrformats", .opt_idx = kOptNrformats },
  { .name = "ambiwidth", .opt_idx = kOptAmbiwidth },
  { .name = "autowrite", .opt_idx = kOptAutowrite },
  { .name = "taglength", .opt_idx = kOptTaglength },
  { .name = "textwidth", .opt_idx = kOptTextwidth },
  { .name = "switchbuf", .opt_idx = kOptSwitchbuf },
  { .name = "winfixbuf", .opt_idx = kOptWinfixbuf },
  { .name = "thesaurus", .opt_idx = kOptThesaurus },
  { .name = "backupext", .opt_idx = kOptBackupext },
  { .name = "paragraphs", .opt_idx = kOptParagraphs },
  { .name = "laststatus", .opt_idx = kOptLaststatus },
  { .name = "matchpairs", .opt_idx = kOptMatchpairs },
  { .name = "tagbsearch", .opt_idx = kOptTagbsearch },
  { .name = "joinspaces", .opt_idx = kOptJoinspaces },
  { .name = "foldenable", .opt_idx = kOptFoldenable },
  { .name = "modifiable", .opt_idx = kOptModifiable },
  { .name = "maxcombine", .opt_idx = kOptMaxcombine },
  { .name = "cursorbind", .opt_idx = kOptCursorbind },
  { .name = "delcombine", .opt_idx = kOptDelcombine },
  { .name = "scrollback", .opt_idx = kOptScrollback },
  { .name = "scrollbind", .opt_idx = kOptScrollbind },
  { .name = "visualbell", .opt_idx = kOptVisualbell },
  { .name = "backupcopy", .opt_idx = kOptBackupcopy },
  { .name = "ignorecase", .opt_idx = kOptIgnorecase },
  { .name = "keywordprg", .opt_idx = kOptKeywordprg },
  { .name = "lazyredraw", .opt_idx = kOptLazyredraw },
  { .name = "showcmdloc", .opt_idx = kOptShowcmdloc },
  { .name = "copyindent", .opt_idx = kOptCopyindent },
  { .name = "autoindent", .opt_idx = kOptAutoindent },
  { .name = "errorbells", .opt_idx = kOptErrorbells },
  { .name = "indentexpr", .opt_idx = kOptIndentexpr },
  { .name = "tabpagemax", .opt_idx = kOptTabpagemax },
  { .name = "splitbelow", .opt_idx = kOptSplitbelow },
  { .name = "formatexpr", .opt_idx = kOptFormatexpr },
  { .name = "shellredir", .opt_idx = kOptShellredir },
  { .name = "writedelay", .opt_idx = kOptWritedelay },
  { .name = "mouseshape", .opt_idx = kOptMouseshape },
  { .name = "cinoptions", .opt_idx = kOptCinoptions },
  { .name = "compatible", .opt_idx = kOptCompatible },
  { .name = "splitright", .opt_idx = kOptSplitright },
  { .name = "guioptions", .opt_idx = kOptGuioptions },
  { .name = "helpheight", .opt_idx = kOptHelpheight },
  { .name = "shiftwidth", .opt_idx = kOptShiftwidth },
  { .name = "scrolljump", .opt_idx = kOptScrolljump },
  { .name = "winaltkeys", .opt_idx = kOptWinaltkeys },
  { .name = "indentkeys", .opt_idx = kOptIndentkeys },
  { .name = "undoreload", .opt_idx = kOptUndoreload },
  { .name = "signcolumn", .opt_idx = kOptSigncolumn },
  { .name = "statusline", .opt_idx = kOptStatusline },
  { .name = "cursorline", .opt_idx = kOptCursorline },
  { .name = "foldcolumn", .opt_idx = kOptFoldcolumn },
  { .name = "shellslash", .opt_idx = kOptShellslash },
  { .name = "mkspellmem", .opt_idx = kOptMkspellmem },
  { .name = "inccommand", .opt_idx = kOptInccommand },
  { .name = "insertmode", .opt_idx = kOptInsertmode },
  { .name = "selectmode", .opt_idx = kOptSelectmode },
  { .name = "wildignore", .opt_idx = kOptWildignore },
  { .name = "dictionary", .opt_idx = kOptDictionary },
  { .name = "foldignore", .opt_idx = kOptFoldignore },
  { .name = "mousemodel", .opt_idx = kOptMousemodel },
  { .name = "background", .opt_idx = kOptBackground },
  { .name = "shiftround", .opt_idx = kOptShiftround },
  { .name = "mousefocus", .opt_idx = kOptMousefocus },
  { .name = "fileformat", .opt_idx = kOptFileformat },
  { .name = "wrapmargin", .opt_idx = kOptWrapmargin },
  { .name = "foldmarker", .opt_idx = kOptFoldmarker },
  { .name = "sidescroll", .opt_idx = kOptSidescroll },
  { .name = "iconstring", .opt_idx = kOptIconstring },
  { .name = "grepformat", .opt_idx = kOptGrepformat },
  { .name = "pyxversion", .opt_idx = kOptPyxversion },
  { .name = "vartabstop", .opt_idx = kOptVartabstop },
  { .name = "backupskip", .opt_idx = kOptBackupskip },
  { .name = "timeoutlen", .opt_idx = kOptTimeoutlen },
  { .name = "updatetime", .opt_idx = kOptUpdatetime },
  { .name = "redrawtime", .opt_idx = kOptRedrawtime },
  { .name = "foldmethod", .opt_idx = kOptFoldmethod },
  { .name = "shellquote", .opt_idx = kOptShellquote },
  { .name = "opendevice", .opt_idx = kOptOpendevice },
  { .name = "undolevels", .opt_idx = kOptUndolevels },
  { .name = "equalalways", .opt_idx = kOptEqualalways },
  { .name = "showtabline", .opt_idx = kOptShowtabline },
  { .name = "softtabstop", .opt_idx = kOptSofttabstop },
  { .name = "virtualedit", .opt_idx = kOptVirtualedit },
  { .name = "guitablabel", .opt_idx = kOptGuitablabel },
  { .name = "writebackup", .opt_idx = kOptWritebackup },
  { .name = "arabicshape", .opt_idx = kOptArabicshape },
  { .name = "colorcolumn", .opt_idx = kOptColorcolumn },
  { .name = "includeexpr", .opt_idx = kOptIncludeexpr },
  { .name = "quoteescape", .opt_idx = kOptQuoteescape },
  { .name = "eadirection", .opt_idx = kOptEadirection },
  { .name = "foldnestmax", .opt_idx = kOptFoldnestmax },
  { .name = "updatecount", .opt_idx = kOptUpdatecount },
  { .name = "completeopt", .opt_idx = kOptCompleteopt },
  { .name = "errorformat", .opt_idx = kOptErrorformat },
  { .name = "rulerformat", .opt_idx = kOptRulerformat },
  { .name = "viminfofile", .opt_idx = kOptShadafile },
  { .name = "messagesopt", .opt_idx = kOptMessagesopt },
  { .name = "eventignore", .opt_idx = kOptEventignore },
  { .name = "smartindent", .opt_idx = kOptSmartindent },
  { .name = "breakindent", .opt_idx = kOptBreakindent },
  { .name = "loadplugins", .opt_idx = kOptLoadplugins },
  { .name = "tagrelative", .opt_idx = kOptTagrelative },
  { .name = "runtimepath", .opt_idx = kOptRuntimepath },
  { .name = "winminwidth", .opt_idx = kOptWinminwidth },
  { .name = "guifontwide", .opt_idx = kOptGuifontwide },
  { .name = "charconvert", .opt_idx = kOptCharconvert },
  { .name = "ttimeoutlen", .opt_idx = kOptTtimeoutlen },
  { .name = "fileformats", .opt_idx = kOptFileformats },
  { .name = "langnoremap", .opt_idx = kOptLangnoremap },
  { .name = "startofline", .opt_idx = kOptStartofline },
  { .name = "lispoptions", .opt_idx = kOptLispoptions },
  { .name = "maxmapdepth", .opt_idx = kOptMaxmapdepth },
  { .name = "wildoptions", .opt_idx = kOptWildoptions },
  { .name = "jumpoptions", .opt_idx = kOptJumpoptions },
  { .name = "viewoptions", .opt_idx = kOptViewoptions },
  { .name = "numberwidth", .opt_idx = kOptNumberwidth },
  { .name = "allowrevins", .opt_idx = kOptAllowrevins },
  { .name = "mousescroll", .opt_idx = kOptMousescroll },
  { .name = "titlestring", .opt_idx = kOptTitlestring },
  { .name = "verbosefile", .opt_idx = kOptVerbosefile },
  { .name = "pastetoggle", .opt_idx = kOptPastetoggle },
  { .name = "showfulltag", .opt_idx = kOptShowfulltag },
  { .name = "redrawdebug", .opt_idx = kOptRedrawdebug },
  { .name = "shellxquote", .opt_idx = kOptShellxquote },
  { .name = "suffixesadd", .opt_idx = kOptSuffixesadd },
  { .name = "winfixwidth", .opt_idx = kOptWinfixwidth },
  { .name = "statuscolumn", .opt_idx = kOptStatuscolumn },
  { .name = "edcompatible", .opt_idx = kOptEdcompatible },
  { .name = "modelineexpr", .opt_idx = kOptModelineexpr },
  { .name = "cmdwinheight", .opt_idx = kOptCmdwinheight },
  { .name = "operatorfunc", .opt_idx = kOptOperatorfunc },
  { .name = "shellxescape", .opt_idx = kOptShellxescape },
  { .name = "spelloptions", .opt_idx = kOptSpelloptions },
  { .name = "shellcmdflag", .opt_idx = kOptShellcmdflag },
  { .name = "spellsuggest", .opt_idx = kOptSpellsuggest },
  { .name = "regexpengine", .opt_idx = kOptRegexpengine },
  { .name = "rightleftcmd", .opt_idx = kOptRightleftcmd },
  { .name = "makeencoding", .opt_idx = kOptMakeencoding },
  { .name = "fileencoding", .opt_idx = kOptFileencoding },
  { .name = "foldminlines", .opt_idx = kOptFoldminlines },
  { .name = "completefunc", .opt_idx = kOptCompletefunc },
  { .name = "winminheight", .opt_idx = kOptWinminheight },
  { .name = "winfixheight", .opt_idx = kOptWinfixheight },
  { .name = "winhighlight", .opt_idx = kOptWinhighlight },
  { .name = "conceallevel", .opt_idx = kOptConceallevel },
  { .name = "smoothscroll", .opt_idx = kOptSmoothscroll },
  { .name = "cursorcolumn", .opt_idx = kOptCursorcolumn },
  { .name = "termencoding", .opt_idx = kOptTermencoding },
  { .name = "autowriteall", .opt_idx = kOptAutowriteall },
  { .name = "maxfuncdepth", .opt_idx = kOptMaxfuncdepth },
  { .name = "fixendofline", .opt_idx = kOptFixendofline },
  { .name = "concealcursor", .opt_idx = kOptConcealcursor },
  { .name = "guitabtooltip", .opt_idx = kOptGuitabtooltip },
  { .name = "sidescrolloff", .opt_idx = kOptSidescrolloff },
  { .name = "spellcapcheck", .opt_idx = kOptSpellcapcheck },
  { .name = "previewheight", .opt_idx = kOptPreviewheight },
  { .name = "previewwindow", .opt_idx = kOptPreviewwindow },
  { .name = "completeslash", .opt_idx = kOptCompleteslash },
  { .name = "maxmempattern", .opt_idx = kOptMaxmempattern },
  { .name = "fileencodings", .opt_idx = kOptFileencodings },
  { .name = "commentstring", .opt_idx = kOptCommentstring },
  { .name = "cinscopedecls", .opt_idx = kOptCinscopedecls },
  { .name = "cursorlineopt", .opt_idx = kOptCursorlineopt },
  { .name = "formatlistpat", .opt_idx = kOptFormatlistpat },
  { .name = "formatoptions", .opt_idx = kOptFormatoptions },
  { .name = "thesaurusfunc", .opt_idx = kOptThesaurusfunc },
  { .name = "termguicolors", .opt_idx = kOptTermguicolors },
  { .name = "breakindentopt", .opt_idx = kOptBreakindentopt },
  { .name = "eventignorewin", .opt_idx = kOptEventignorewin },
  { .name = "fileignorecase", .opt_idx = kOptFileignorecase },
  { .name = "foldlevelstart", .opt_idx = kOptFoldlevelstart },
  { .name = "mousemoveevent", .opt_idx = kOptMousemoveevent },
  { .name = "preserveindent", .opt_idx = kOptPreserveindent },
  { .name = "relativenumber", .opt_idx = kOptRelativenumber },
  { .name = "sessionoptions", .opt_idx = kOptSessionoptions },
  { .name = "varsofttabstop", .opt_idx = kOptVarsofttabstop },
  { .name = "wildignorecase", .opt_idx = kOptWildignorecase },
  { .name = "termpastefilter", .opt_idx = kOptTermpastefilter },
  { .name = "quickfixtextfunc", .opt_idx = kOptQuickfixtextfunc },
  { .name = "completeitemalign", .opt_idx = kOptCompleteitemalign },
};

static int find_option_hash(const char *str, size_t len)
{
  int low = 0, high = 0;
  switch (len) {
    case 2: switch (str[1]) {
      case 'a': low = 0; high = 4; break;
      case 'b': low = 4; high = 10; break;
      case 'c': low = 10; high = 16; break;
      case 'd': low = 16; high = 21; break;
      case 'e': low = 21; high = 24; break;
      case 'f': low = 24; high = 30; break;
      case 'g': low = 30; high = 32; break;
      case 'h': low = 32; high = 39; break;
      case 'i': low = 39; high = 48; break;
      case 'j': low = 48; high = 49; break;
      case 'k': low = 49; high = 51; break;
      case 'l': low = 51; high = 58; break;
      case 'm': low = 58; high = 65; break;
      case 'o': low = 65; high = 72; break;
      case 'p': low = 72; high = 80; break;
      case 'r': low = 80; high = 84; break;
      case 's': low = 84; high = 92; break;
      case 't': low = 92; high = 97; break;
      case 'u': low = 97; high = 100; break;
      case 'w': low = 100; high = 106; break;
      case 'x': low = 106; high = 107; break;
      case 'y': low = 107; high = 108; break;
      case 'z': low = 108; high = 109; break;
      default: break;
    }
    break;
    case 3: switch (str[2]) {
      case 'a': low = 109; high = 113; break;
      case 'b': low = 113; high = 118; break;
      case 'c': low = 118; high = 131; break;
      case 'd': low = 131; high = 139; break;
      case 'e': low = 139; high = 142; break;
      case 'f': low = 142; high = 154; break;
      case 'g': low = 154; high = 157; break;
      case 'h': low = 157; high = 162; break;
      case 'i': low = 162; high = 167; break;
      case 'k': low = 167; high = 172; break;
      case 'l': low = 172; high = 188; break;
      case 'm': low = 188; high = 201; break;
      case 'n': low = 201; high = 207; break;
      case 'o': low = 207; high = 213; break;
      case 'p': low = 213; high = 227; break;
      case 'q': low = 227; high = 229; break;
      case 'r': low = 229; high = 240; break;
      case 's': low = 240; high = 256; break;
      case 't': low = 256; high = 263; break;
      case 'u': low = 263; high = 268; break;
      case 'v': low = 268; high = 269; break;
      case 'w': low = 269; high = 276; break;
      case 'x': low = 276; high = 281; break;
      default: break;
    }
    break;
    case 4: switch (str[3]) {
      case 'a': low = 281; high = 282; break;
      case 'b': low = 282; high = 284; break;
      case 'c': low = 284; high = 289; break;
      case 'e': low = 289; high = 292; break;
      case 'f': low = 292; high = 295; break;
      case 'h': low = 295; high = 296; break;
      case 'k': low = 296; high = 299; break;
      case 'l': low = 299; high = 300; break;
      case 'n': low = 300; high = 302; break;
      case 'o': low = 302; high = 305; break;
      case 'p': low = 305; high = 310; break;
      case 'r': low = 310; high = 313; break;
      case 's': low = 313; high = 316; break;
      case 't': low = 316; high = 321; break;
      case 'u': low = 321; high = 323; break;
      case 'v': low = 323; high = 324; break;
      case 'w': low = 324; high = 326; break;
      case 'x': low = 326; high = 327; break;
      default: break;
    }
    break;
    case 5: switch (str[0]) {
      case 'a': low = 327; high = 328; break;
      case 'b': low = 328; high = 329; break;
      case 'c': low = 329; high = 331; break;
      case 'd': low = 331; high = 332; break;
      case 'e': low = 332; high = 333; break;
      case 'f': low = 333; high = 335; break;
      case 'h': low = 335; high = 336; break;
      case 'l': low = 336; high = 337; break;
      case 'm': low = 337; high = 339; break;
      case 'p': low = 339; high = 340; break;
      case 'r': low = 340; high = 342; break;
      case 's': low = 342; high = 345; break;
      case 't': low = 345; high = 349; break;
      case 'v': low = 349; high = 350; break;
      case 'w': low = 350; high = 353; break;
      default: break;
    }
    break;
    case 6: switch (str[2]) {
      case 'a': low = 353; high = 354; break;
      case 'c': low = 354; high = 356; break;
      case 'd': low = 356; high = 357; break;
      case 'f': low = 357; high = 359; break;
      case 'h': low = 359; high = 360; break;
      case 'i': low = 360; high = 361; break;
      case 'k': low = 361; high = 362; break;
      case 'l': low = 362; high = 363; break;
      case 'm': low = 363; high = 365; break;
      case 'n': low = 365; high = 369; break;
      case 'o': low = 369; high = 370; break;
      case 'p': low = 370; high = 372; break;
      case 'r': low = 372; high = 373; break;
      case 'u': low = 373; high = 377; break;
      case 'v': low = 377; high = 378; break;
      case 'x': low = 378; high = 379; break;
      case 'y': low = 379; high = 380; break;
      default: break;
    }
    break;
    case 7: switch (str[2]) {
      case 'a': low = 380; high = 381; break;
      case 'b': low = 381; high = 383; break;
      case 'c': low = 383; high = 384; break;
      case 'd': low = 384; high = 385; break;
      case 'e': low = 385; high = 388; break;
      case 'f': low = 388; high = 391; break;
      case 'g': low = 391; high = 394; break;
      case 'i': low = 394; high = 396; break;
      case 'k': low = 396; high = 397; break;
      case 'l': low = 397; high = 400; break;
      case 'm': low = 400; high = 402; break;
      case 'n': low = 402; high = 406; break;
      case 'o': low = 406; high = 407; break;
      case 'p': low = 407; high = 408; break;
      case 'r': low = 408; high = 409; break;
      case 's': low = 409; high = 413; break;
      case 'y': low = 413; high = 414; break;
      default: break;
    }
    break;
    case 8: switch (str[0]) {
      case 'a': low = 414; high = 415; break;
      case 'c': low = 415; high = 418; break;
      case 'd': low = 418; high = 419; break;
      case 'e': low = 419; high = 421; break;
      case 'f': low = 421; high = 426; break;
      case 'g': low = 426; high = 427; break;
      case 'h': low = 427; high = 430; break;
      case 'i': low = 430; high = 432; break;
      case 'k': low = 432; high = 433; break;
      case 'l': low = 433; high = 434; break;
      case 'm': low = 434; high = 437; break;
      case 'o': low = 437; high = 438; break;
      case 'p': low = 438; high = 441; break;
      case 'r': low = 441; high = 442; break;
      case 's': low = 442; high = 447; break;
      case 't': low = 447; high = 454; break;
      case 'u': low = 454; high = 455; break;
      case 'w': low = 455; high = 462; break;
      default: break;
    }
    break;
    case 9: switch (str[7]) {
      case 'a': low = 462; high = 467; break;
      case 'c': low = 467; high = 471; break;
      case 'd': low = 471; high = 474; break;
      case 'e': low = 474; high = 480; break;
      case 'f': low = 480; high = 482; break;
      case 'h': low = 482; high = 486; break;
      case 'i': low = 486; high = 489; break;
      case 'l': low = 489; high = 494; break;
      case 'm': low = 494; high = 498; break;
      case 'n': low = 498; high = 502; break;
      case 'o': low = 502; high = 505; break;
      case 'p': low = 505; high = 508; break;
      case 'r': low = 508; high = 515; break;
      case 's': low = 515; high = 519; break;
      case 't': low = 519; high = 524; break;
      case 'u': low = 524; high = 527; break;
      case 'x': low = 527; high = 528; break;
      default: break;
    }
    break;
    case 10: switch (str[6]) {
      case 'a': low = 528; high = 535; break;
      case 'b': low = 535; high = 541; break;
      case 'c': low = 541; high = 543; break;
      case 'd': low = 543; high = 548; break;
      case 'e': low = 548; high = 555; break;
      case 'h': low = 555; high = 556; break;
      case 'i': low = 556; high = 562; break;
      case 'j': low = 562; high = 563; break;
      case 'k': low = 563; high = 565; break;
      case 'l': low = 565; high = 572; break;
      case 'm': low = 572; high = 575; break;
      case 'n': low = 575; high = 578; break;
      case 'o': low = 578; high = 582; break;
      case 'r': low = 582; high = 588; break;
      case 's': low = 588; high = 591; break;
      case 't': low = 591; high = 595; break;
      case 'u': low = 595; high = 596; break;
      case 'v': low = 596; high = 598; break;
      default: break;
    }
    break;
    case 11: switch (str[5]) {
      case 'a': low = 598; high = 602; break;
      case 'b': low = 602; high = 604; break;
      case 'c': low = 604; high = 606; break;
      case 'd': low = 606; high = 607; break;
      case 'e': low = 607; high = 612; break;
      case 'f': low = 612; high = 615; break;
      case 'g': low = 615; high = 616; break;
      case 'i': low = 616; high = 619; break;
      case 'l': low = 619; high = 621; break;
      case 'm': low = 621; high = 622; break;
      case 'n': low = 622; high = 624; break;
      case 'o': low = 624; high = 629; break;
      case 'p': low = 629; high = 634; break;
      case 'r': low = 634; high = 636; break;
      case 's': low = 636; high = 639; break;
      case 't': low = 639; high = 640; break;
      case 'u': low = 640; high = 641; break;
      case 'w': low = 641; high = 642; break;
      case 'x': low = 642; high = 645; break;
      default: break;
    }
    break;
    case 12: switch (str[2]) {
      case 'a': low = 645; high = 646; break;
      case 'c': low = 646; high = 647; break;
      case 'd': low = 647; high = 649; break;
      case 'e': low = 649; high = 654; break;
      case 'g': low = 654; high = 656; break;
      case 'k': low = 656; high = 657; break;
      case 'l': low = 657; high = 659; break;
      case 'm': low = 659; high = 660; break;
      case 'n': low = 660; high = 664; break;
      case 'o': low = 664; high = 665; break;
      case 'r': low = 665; high = 667; break;
      case 't': low = 667; high = 668; break;
      case 'x': low = 668; high = 670; break;
      default: break;
    }
    break;
    case 13: switch (str[5]) {
      case 'a': low = 670; high = 671; break;
      case 'b': low = 671; high = 672; break;
      case 'c': low = 672; high = 674; break;
      case 'e': low = 674; high = 677; break;
      case 'm': low = 677; high = 678; break;
      case 'n': low = 678; high = 680; break;
      case 'o': low = 680; high = 681; break;
      case 'r': low = 681; high = 682; break;
      case 't': low = 682; high = 684; break;
      case 'u': low = 684; high = 686; break;
      default: break;
    }
    break;
    case 14: switch (str[0]) {
      case 'b': low = 686; high = 687; break;
      case 'e': low = 687; high = 688; break;
      case 'f': low = 688; high = 690; break;
      case 'm': low = 690; high = 691; break;
      case 'p': low = 691; high = 692; break;
      case 'r': low = 692; high = 693; break;
      case 's': low = 693; high = 694; break;
      case 'v': low = 694; high = 695; break;
      case 'w': low = 695; high = 696; break;
      default: break;
    }
    break;
    case 15: low = 696; high = 697; break;
    case 16: low = 697; high = 698; break;
    case 17: low = 698; high = 699; break;
    default: break;
  }
  for (int i = low; i < high; i++) {
    if (!memcmp(str, option_hash_elems[i].name, len)) {
      return i;
    }
  }
  return -1;
}


