/* Generated by wayland-scanner 1.24.0 */

#ifndef EXT_WORKSPACE_V1_CLIENT_PROTOCOL_H
#define EXT_WORKSPACE_V1_CLIENT_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-client-core.h"

#ifdef  __cplusplus
extern "C" {
#endif

/**
 * @page page_ext_workspace_v1 The ext_workspace_v1 protocol
 * @section page_ifaces_ext_workspace_v1 Interfaces
 * - @subpage page_iface_ext_workspace_manager_v1 - list and control workspaces
 * - @subpage page_iface_ext_workspace_group_handle_v1 - a workspace group assigned to a set of outputs
 * - @subpage page_iface_ext_workspace_handle_v1 - a workspace handing a group of surfaces
 * @section page_copyright_ext_workspace_v1 Copyright
 * <pre>
 *
 * Copyright © 2019 Christopher Billington
 * Copyright © 2020 Ilia Bozhinov
 * Copyright © 2022 Victoria Brekenfeld
 *
 * Permission to use, copy, modify, distribute, and sell this
 * software and its documentation for any purpose is hereby granted
 * without fee, provided that the above copyright notice appear in
 * all copies and that both that copyright notice and this permission
 * notice appear in supporting documentation, and that the name of
 * the copyright holders not be used in advertising or publicity
 * pertaining to distribution of the software without specific,
 * written prior permission.  The copyright holders make no
 * representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied
 * warranty.
 *
 * THE COPYRIGHT HOLDERS DISCLAIM ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS, IN NO EVENT SHALL THE COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
 * AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF
 * THIS SOFTWARE.
 * </pre>
 */
struct ext_workspace_group_handle_v1;
struct ext_workspace_handle_v1;
struct ext_workspace_manager_v1;
struct wl_output;

#ifndef EXT_WORKSPACE_MANAGER_V1_INTERFACE
#define EXT_WORKSPACE_MANAGER_V1_INTERFACE
/**
 * @page page_iface_ext_workspace_manager_v1 ext_workspace_manager_v1
 * @section page_iface_ext_workspace_manager_v1_desc Description
 *
 * Workspaces, also called virtual desktops, are groups of surfaces. A
 * compositor with a concept of workspaces may only show some such groups of
 * surfaces (those of 'active' workspaces) at a time. 'Activating' a
 * workspace is a request for the compositor to display that workspace's
 * surfaces as normal, whereas the compositor may hide or otherwise
 * de-emphasise surfaces that are associated only with 'inactive' workspaces.
 * Workspaces are grouped by which sets of outputs they correspond to, and
 * may contain surfaces only from those outputs. In this way, it is possible
 * for each output to have its own set of workspaces, or for all outputs (or
 * any other arbitrary grouping) to share workspaces. Compositors may
 * optionally conceptually arrange each group of workspaces in an
 * N-dimensional grid.
 *
 * The purpose of this protocol is to enable the creation of taskbars and
 * docks by providing them with a list of workspaces and their properties,
 * and allowing them to activate and deactivate workspaces.
 *
 * After a client binds the ext_workspace_manager_v1, each workspace will be
 * sent via the workspace event.
 * @section page_iface_ext_workspace_manager_v1_api API
 * See @ref iface_ext_workspace_manager_v1.
 */
/**
 * @defgroup iface_ext_workspace_manager_v1 The ext_workspace_manager_v1 interface
 *
 * Workspaces, also called virtual desktops, are groups of surfaces. A
 * compositor with a concept of workspaces may only show some such groups of
 * surfaces (those of 'active' workspaces) at a time. 'Activating' a
 * workspace is a request for the compositor to display that workspace's
 * surfaces as normal, whereas the compositor may hide or otherwise
 * de-emphasise surfaces that are associated only with 'inactive' workspaces.
 * Workspaces are grouped by which sets of outputs they correspond to, and
 * may contain surfaces only from those outputs. In this way, it is possible
 * for each output to have its own set of workspaces, or for all outputs (or
 * any other arbitrary grouping) to share workspaces. Compositors may
 * optionally conceptually arrange each group of workspaces in an
 * N-dimensional grid.
 *
 * The purpose of this protocol is to enable the creation of taskbars and
 * docks by providing them with a list of workspaces and their properties,
 * and allowing them to activate and deactivate workspaces.
 *
 * After a client binds the ext_workspace_manager_v1, each workspace will be
 * sent via the workspace event.
 */
extern const struct wl_interface ext_workspace_manager_v1_interface;
#endif
#ifndef EXT_WORKSPACE_GROUP_HANDLE_V1_INTERFACE
#define EXT_WORKSPACE_GROUP_HANDLE_V1_INTERFACE
/**
 * @page page_iface_ext_workspace_group_handle_v1 ext_workspace_group_handle_v1
 * @section page_iface_ext_workspace_group_handle_v1_desc Description
 *
 * A ext_workspace_group_handle_v1 object represents a workspace group
 * that is assigned a set of outputs and contains a number of workspaces.
 *
 * The set of outputs assigned to the workspace group is conveyed to the client via
 * output_enter and output_leave events, and its workspaces are conveyed with
 * workspace events.
 *
 * For example, a compositor which has a set of workspaces for each output may
 * advertise a workspace group (and its workspaces) per output, whereas a compositor
 * where a workspace spans all outputs may advertise a single workspace group for all
 * outputs.
 * @section page_iface_ext_workspace_group_handle_v1_api API
 * See @ref iface_ext_workspace_group_handle_v1.
 */
/**
 * @defgroup iface_ext_workspace_group_handle_v1 The ext_workspace_group_handle_v1 interface
 *
 * A ext_workspace_group_handle_v1 object represents a workspace group
 * that is assigned a set of outputs and contains a number of workspaces.
 *
 * The set of outputs assigned to the workspace group is conveyed to the client via
 * output_enter and output_leave events, and its workspaces are conveyed with
 * workspace events.
 *
 * For example, a compositor which has a set of workspaces for each output may
 * advertise a workspace group (and its workspaces) per output, whereas a compositor
 * where a workspace spans all outputs may advertise a single workspace group for all
 * outputs.
 */
extern const struct wl_interface ext_workspace_group_handle_v1_interface;
#endif
#ifndef EXT_WORKSPACE_HANDLE_V1_INTERFACE
#define EXT_WORKSPACE_HANDLE_V1_INTERFACE
/**
 * @page page_iface_ext_workspace_handle_v1 ext_workspace_handle_v1
 * @section page_iface_ext_workspace_handle_v1_desc Description
 *
 * A ext_workspace_handle_v1 object represents a workspace that handles a
 * group of surfaces.
 *
 * Each workspace has:
 * - a name, conveyed to the client with the name event
 * - potentially an id conveyed with the id event
 * - a list of states, conveyed to the client with the state event
 * - and optionally a set of coordinates, conveyed to the client with the
 * coordinates event
 *
 * The client may request that the compositor activate or deactivate the workspace.
 *
 * Each workspace can belong to only a single workspace group.
 * Depending on the compositor policy, there might be workspaces with
 * the same name in different workspace groups, but these workspaces are still
 * separate (e.g. one of them might be active while the other is not).
 * @section page_iface_ext_workspace_handle_v1_api API
 * See @ref iface_ext_workspace_handle_v1.
 */
/**
 * @defgroup iface_ext_workspace_handle_v1 The ext_workspace_handle_v1 interface
 *
 * A ext_workspace_handle_v1 object represents a workspace that handles a
 * group of surfaces.
 *
 * Each workspace has:
 * - a name, conveyed to the client with the name event
 * - potentially an id conveyed with the id event
 * - a list of states, conveyed to the client with the state event
 * - and optionally a set of coordinates, conveyed to the client with the
 * coordinates event
 *
 * The client may request that the compositor activate or deactivate the workspace.
 *
 * Each workspace can belong to only a single workspace group.
 * Depending on the compositor policy, there might be workspaces with
 * the same name in different workspace groups, but these workspaces are still
 * separate (e.g. one of them might be active while the other is not).
 */
extern const struct wl_interface ext_workspace_handle_v1_interface;
#endif

/**
 * @ingroup iface_ext_workspace_manager_v1
 * @struct ext_workspace_manager_v1_listener
 */
struct ext_workspace_manager_v1_listener {
	/**
	 * a workspace group has been created
	 *
	 * This event is emitted whenever a new workspace group has been
	 * created.
	 *
	 * All initial details of the workspace group (outputs) will be
	 * sent immediately after this event via the corresponding events
	 * in ext_workspace_group_handle_v1 and ext_workspace_handle_v1.
	 */
	void (*workspace_group)(void *data,
				struct ext_workspace_manager_v1 *ext_workspace_manager_v1,
				struct ext_workspace_group_handle_v1 *workspace_group);
	/**
	 * workspace has been created
	 *
	 * This event is emitted whenever a new workspace has been
	 * created.
	 *
	 * All initial details of the workspace (name, coordinates, state)
	 * will be sent immediately after this event via the corresponding
	 * events in ext_workspace_handle_v1.
	 *
	 * Workspaces start off unassigned to any workspace group.
	 */
	void (*workspace)(void *data,
			  struct ext_workspace_manager_v1 *ext_workspace_manager_v1,
			  struct ext_workspace_handle_v1 *workspace);
	/**
	 * all information about the workspaces and workspace groups has been sent
	 *
	 * This event is sent after all changes in all workspaces and
	 * workspace groups have been sent.
	 *
	 * This allows changes to one or more ext_workspace_group_handle_v1
	 * properties and ext_workspace_handle_v1 properties to be seen as
	 * atomic, even if they happen via multiple events. In particular,
	 * an output moving from one workspace group to another sends an
	 * output_enter event and an output_leave event to the two
	 * ext_workspace_group_handle_v1 objects in question. The
	 * compositor sends the done event only after updating the output
	 * information in both workspace groups.
	 */
	void (*done)(void *data,
		     struct ext_workspace_manager_v1 *ext_workspace_manager_v1);
	/**
	 * the compositor has finished with the workspace_manager
	 *
	 * This event indicates that the compositor is done sending
	 * events to the ext_workspace_manager_v1. The server will destroy
	 * the object immediately after sending this request.
	 */
	void (*finished)(void *data,
			 struct ext_workspace_manager_v1 *ext_workspace_manager_v1);
};

/**
 * @ingroup iface_ext_workspace_manager_v1
 */
static inline int
ext_workspace_manager_v1_add_listener(struct ext_workspace_manager_v1 *ext_workspace_manager_v1,
				      const struct ext_workspace_manager_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) ext_workspace_manager_v1,
				     (void (**)(void)) listener, data);
}

#define EXT_WORKSPACE_MANAGER_V1_COMMIT 0
#define EXT_WORKSPACE_MANAGER_V1_STOP 1

/**
 * @ingroup iface_ext_workspace_manager_v1
 */
#define EXT_WORKSPACE_MANAGER_V1_WORKSPACE_GROUP_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_manager_v1
 */
#define EXT_WORKSPACE_MANAGER_V1_WORKSPACE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_manager_v1
 */
#define EXT_WORKSPACE_MANAGER_V1_DONE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_manager_v1
 */
#define EXT_WORKSPACE_MANAGER_V1_FINISHED_SINCE_VERSION 1

/**
 * @ingroup iface_ext_workspace_manager_v1
 */
#define EXT_WORKSPACE_MANAGER_V1_COMMIT_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_manager_v1
 */
#define EXT_WORKSPACE_MANAGER_V1_STOP_SINCE_VERSION 1

/** @ingroup iface_ext_workspace_manager_v1 */
static inline void
ext_workspace_manager_v1_set_user_data(struct ext_workspace_manager_v1 *ext_workspace_manager_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ext_workspace_manager_v1, user_data);
}

/** @ingroup iface_ext_workspace_manager_v1 */
static inline void *
ext_workspace_manager_v1_get_user_data(struct ext_workspace_manager_v1 *ext_workspace_manager_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ext_workspace_manager_v1);
}

static inline uint32_t
ext_workspace_manager_v1_get_version(struct ext_workspace_manager_v1 *ext_workspace_manager_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) ext_workspace_manager_v1);
}

/** @ingroup iface_ext_workspace_manager_v1 */
static inline void
ext_workspace_manager_v1_destroy(struct ext_workspace_manager_v1 *ext_workspace_manager_v1)
{
	wl_proxy_destroy((struct wl_proxy *) ext_workspace_manager_v1);
}

/**
 * @ingroup iface_ext_workspace_manager_v1
 *
 * The client must send this request after it has finished sending other
 * requests. The compositor must process a series of requests preceding a
 * commit request atomically.
 *
 * This allows changes to the workspace properties to be seen as atomic,
 * even if they happen via multiple events, and even if they involve
 * multiple ext_workspace_handle_v1 objects, for example, deactivating one
 * workspace and activating another.
 */
static inline void
ext_workspace_manager_v1_commit(struct ext_workspace_manager_v1 *ext_workspace_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_workspace_manager_v1,
			 EXT_WORKSPACE_MANAGER_V1_COMMIT, NULL, wl_proxy_get_version((struct wl_proxy *) ext_workspace_manager_v1), 0);
}

/**
 * @ingroup iface_ext_workspace_manager_v1
 *
 * Indicates the client no longer wishes to receive events for new
 * workspace groups. However the compositor may emit further workspace
 * events, until the finished event is emitted. The compositor is expected
 * to send the finished event eventually once the stop request has been processed.
 *
 * The client must not send any requests after this one, doing so will raise a wl_display
 * invalid_object error.
 */
static inline void
ext_workspace_manager_v1_stop(struct ext_workspace_manager_v1 *ext_workspace_manager_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_workspace_manager_v1,
			 EXT_WORKSPACE_MANAGER_V1_STOP, NULL, wl_proxy_get_version((struct wl_proxy *) ext_workspace_manager_v1), 0);
}

#ifndef EXT_WORKSPACE_GROUP_HANDLE_V1_GROUP_CAPABILITIES_ENUM
#define EXT_WORKSPACE_GROUP_HANDLE_V1_GROUP_CAPABILITIES_ENUM
enum ext_workspace_group_handle_v1_group_capabilities {
	/**
	 * create_workspace request is available
	 */
	EXT_WORKSPACE_GROUP_HANDLE_V1_GROUP_CAPABILITIES_CREATE_WORKSPACE = 1,
};
#endif /* EXT_WORKSPACE_GROUP_HANDLE_V1_GROUP_CAPABILITIES_ENUM */

/**
 * @ingroup iface_ext_workspace_group_handle_v1
 * @struct ext_workspace_group_handle_v1_listener
 */
struct ext_workspace_group_handle_v1_listener {
	/**
	 * compositor capabilities
	 *
	 * This event advertises the capabilities supported by the
	 * compositor. If a capability isn't supported, clients should hide
	 * or disable the UI elements that expose this functionality. For
	 * instance, if the compositor doesn't advertise support for
	 * creating workspaces, a button triggering the create_workspace
	 * request should not be displayed.
	 *
	 * The compositor will ignore requests it doesn't support. For
	 * instance, a compositor which doesn't advertise support for
	 * creating workspaces will ignore create_workspace requests.
	 *
	 * Compositors must send this event once after creation of an
	 * ext_workspace_group_handle_v1. When the capabilities change,
	 * compositors must send this event again.
	 * @param capabilities capabilities
	 */
	void (*capabilities)(void *data,
			     struct ext_workspace_group_handle_v1 *ext_workspace_group_handle_v1,
			     uint32_t capabilities);
	/**
	 * output assigned to workspace group
	 *
	 * This event is emitted whenever an output is assigned to the
	 * workspace group or a new `wl_output` object is bound by the
	 * client, which was already assigned to this workspace_group.
	 */
	void (*output_enter)(void *data,
			     struct ext_workspace_group_handle_v1 *ext_workspace_group_handle_v1,
			     struct wl_output *output);
	/**
	 * output removed from workspace group
	 *
	 * This event is emitted whenever an output is removed from the
	 * workspace group.
	 */
	void (*output_leave)(void *data,
			     struct ext_workspace_group_handle_v1 *ext_workspace_group_handle_v1,
			     struct wl_output *output);
	/**
	 * workspace added to workspace group
	 *
	 * This event is emitted whenever a workspace is assigned to this
	 * group. A workspace may only ever be assigned to a single group
	 * at a single point in time, but can be re-assigned during it's
	 * lifetime.
	 */
	void (*workspace_enter)(void *data,
				struct ext_workspace_group_handle_v1 *ext_workspace_group_handle_v1,
				struct ext_workspace_handle_v1 *workspace);
	/**
	 * workspace removed from workspace group
	 *
	 * This event is emitted whenever a workspace is removed from
	 * this group.
	 */
	void (*workspace_leave)(void *data,
				struct ext_workspace_group_handle_v1 *ext_workspace_group_handle_v1,
				struct ext_workspace_handle_v1 *workspace);
	/**
	 * this workspace group has been removed
	 *
	 * This event is send when the group associated with the
	 * ext_workspace_group_handle_v1 has been removed. After sending
	 * this request the compositor will immediately consider the object
	 * inert. Any requests will be ignored except the destroy request.
	 * It is guaranteed there won't be any more events referencing this
	 * ext_workspace_group_handle_v1.
	 *
	 * The compositor must remove all workspaces belonging to a
	 * workspace group via a workspace_leave event before removing the
	 * workspace group.
	 */
	void (*removed)(void *data,
			struct ext_workspace_group_handle_v1 *ext_workspace_group_handle_v1);
};

/**
 * @ingroup iface_ext_workspace_group_handle_v1
 */
static inline int
ext_workspace_group_handle_v1_add_listener(struct ext_workspace_group_handle_v1 *ext_workspace_group_handle_v1,
					   const struct ext_workspace_group_handle_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) ext_workspace_group_handle_v1,
				     (void (**)(void)) listener, data);
}

#define EXT_WORKSPACE_GROUP_HANDLE_V1_CREATE_WORKSPACE 0
#define EXT_WORKSPACE_GROUP_HANDLE_V1_DESTROY 1

/**
 * @ingroup iface_ext_workspace_group_handle_v1
 */
#define EXT_WORKSPACE_GROUP_HANDLE_V1_CAPABILITIES_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_group_handle_v1
 */
#define EXT_WORKSPACE_GROUP_HANDLE_V1_OUTPUT_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_group_handle_v1
 */
#define EXT_WORKSPACE_GROUP_HANDLE_V1_OUTPUT_LEAVE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_group_handle_v1
 */
#define EXT_WORKSPACE_GROUP_HANDLE_V1_WORKSPACE_ENTER_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_group_handle_v1
 */
#define EXT_WORKSPACE_GROUP_HANDLE_V1_WORKSPACE_LEAVE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_group_handle_v1
 */
#define EXT_WORKSPACE_GROUP_HANDLE_V1_REMOVED_SINCE_VERSION 1

/**
 * @ingroup iface_ext_workspace_group_handle_v1
 */
#define EXT_WORKSPACE_GROUP_HANDLE_V1_CREATE_WORKSPACE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_group_handle_v1
 */
#define EXT_WORKSPACE_GROUP_HANDLE_V1_DESTROY_SINCE_VERSION 1

/** @ingroup iface_ext_workspace_group_handle_v1 */
static inline void
ext_workspace_group_handle_v1_set_user_data(struct ext_workspace_group_handle_v1 *ext_workspace_group_handle_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ext_workspace_group_handle_v1, user_data);
}

/** @ingroup iface_ext_workspace_group_handle_v1 */
static inline void *
ext_workspace_group_handle_v1_get_user_data(struct ext_workspace_group_handle_v1 *ext_workspace_group_handle_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ext_workspace_group_handle_v1);
}

static inline uint32_t
ext_workspace_group_handle_v1_get_version(struct ext_workspace_group_handle_v1 *ext_workspace_group_handle_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) ext_workspace_group_handle_v1);
}

/**
 * @ingroup iface_ext_workspace_group_handle_v1
 *
 * Request that the compositor create a new workspace with the given name
 * and assign it to this group.
 *
 * There is no guarantee that the compositor will create a new workspace,
 * or that the created workspace will have the provided name.
 */
static inline void
ext_workspace_group_handle_v1_create_workspace(struct ext_workspace_group_handle_v1 *ext_workspace_group_handle_v1, const char *workspace)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_workspace_group_handle_v1,
			 EXT_WORKSPACE_GROUP_HANDLE_V1_CREATE_WORKSPACE, NULL, wl_proxy_get_version((struct wl_proxy *) ext_workspace_group_handle_v1), 0, workspace);
}

/**
 * @ingroup iface_ext_workspace_group_handle_v1
 *
 * Destroys the ext_workspace_group_handle_v1 object.
 *
 * This request should be send either when the client does not want to
 * use the workspace group object any more or after the removed event to finalize
 * the destruction of the object.
 */
static inline void
ext_workspace_group_handle_v1_destroy(struct ext_workspace_group_handle_v1 *ext_workspace_group_handle_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_workspace_group_handle_v1,
			 EXT_WORKSPACE_GROUP_HANDLE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ext_workspace_group_handle_v1), WL_MARSHAL_FLAG_DESTROY);
}

#ifndef EXT_WORKSPACE_HANDLE_V1_STATE_ENUM
#define EXT_WORKSPACE_HANDLE_V1_STATE_ENUM
/**
 * @ingroup iface_ext_workspace_handle_v1
 * types of states on the workspace
 *
 * The different states that a workspace can have.
 */
enum ext_workspace_handle_v1_state {
	/**
	 * the workspace is active
	 */
	EXT_WORKSPACE_HANDLE_V1_STATE_ACTIVE = 1,
	/**
	 * the workspace requests attention
	 */
	EXT_WORKSPACE_HANDLE_V1_STATE_URGENT = 2,
	/**
	 * the workspace is not visible
	 *
	 * The workspace is not visible in its workspace group, and
	 * clients attempting to visualize the compositor workspace state
	 * should not display such workspaces.
	 */
	EXT_WORKSPACE_HANDLE_V1_STATE_HIDDEN = 4,
};
#endif /* EXT_WORKSPACE_HANDLE_V1_STATE_ENUM */

#ifndef EXT_WORKSPACE_HANDLE_V1_WORKSPACE_CAPABILITIES_ENUM
#define EXT_WORKSPACE_HANDLE_V1_WORKSPACE_CAPABILITIES_ENUM
enum ext_workspace_handle_v1_workspace_capabilities {
	/**
	 * activate request is available
	 */
	EXT_WORKSPACE_HANDLE_V1_WORKSPACE_CAPABILITIES_ACTIVATE = 1,
	/**
	 * deactivate request is available
	 */
	EXT_WORKSPACE_HANDLE_V1_WORKSPACE_CAPABILITIES_DEACTIVATE = 2,
	/**
	 * remove request is available
	 */
	EXT_WORKSPACE_HANDLE_V1_WORKSPACE_CAPABILITIES_REMOVE = 4,
	/**
	 * assign request is available
	 */
	EXT_WORKSPACE_HANDLE_V1_WORKSPACE_CAPABILITIES_ASSIGN = 8,
};
#endif /* EXT_WORKSPACE_HANDLE_V1_WORKSPACE_CAPABILITIES_ENUM */

/**
 * @ingroup iface_ext_workspace_handle_v1
 * @struct ext_workspace_handle_v1_listener
 */
struct ext_workspace_handle_v1_listener {
	/**
	 * workspace id
	 *
	 * If this event is emitted, it will be send immediately after
	 * the ext_workspace_handle_v1 is created or when an id is assigned
	 * to a workspace (at most once during it's lifetime).
	 *
	 * An id will never change during the lifetime of the
	 * `ext_workspace_handle_v1` and is guaranteed to be unique during
	 * it's lifetime.
	 *
	 * Ids are not human-readable and shouldn't be displayed, use
	 * `name` for that purpose.
	 *
	 * Compositors are expected to only send ids for workspaces likely
	 * stable across multiple sessions and can be used by clients to
	 * store preferences for workspaces. Workspaces without ids should
	 * be considered temporary and any data associated with them should
	 * be deleted once the respective object is lost.
	 */
	void (*id)(void *data,
		   struct ext_workspace_handle_v1 *ext_workspace_handle_v1,
		   const char *id);
	/**
	 * workspace name changed
	 *
	 * This event is emitted immediately after the
	 * ext_workspace_handle_v1 is created and whenever the name of the
	 * workspace changes.
	 *
	 * A name is meant to be human-readable and can be displayed to a
	 * user. Unlike the id it is neither stable nor unique.
	 */
	void (*name)(void *data,
		     struct ext_workspace_handle_v1 *ext_workspace_handle_v1,
		     const char *name);
	/**
	 * workspace coordinates changed
	 *
	 * This event is used to organize workspaces into an
	 * N-dimensional grid within a workspace group, and if supported,
	 * is emitted immediately after the ext_workspace_handle_v1 is
	 * created and whenever the coordinates of the workspace change.
	 * Compositors may not send this event if they do not conceptually
	 * arrange workspaces in this way. If compositors simply number
	 * workspaces, without any geometric interpretation, they may send
	 * 1D coordinates, which clients should not interpret as implying
	 * any geometry. Sending an empty array means that the compositor
	 * no longer orders the workspace geometrically.
	 *
	 * Coordinates have an arbitrary number of dimensions N with an
	 * uint32 position along each dimension. By convention if N > 1,
	 * the first dimension is X, the second Y, the third Z, and so on.
	 * The compositor may chose to utilize these events for a more
	 * novel workspace layout convention, however. No guarantee is made
	 * about the grid being filled or bounded; there may be a workspace
	 * at coordinate 1 and another at coordinate 1000 and none in
	 * between. Within a workspace group, however, workspaces must have
	 * unique coordinates of equal dimensionality.
	 */
	void (*coordinates)(void *data,
			    struct ext_workspace_handle_v1 *ext_workspace_handle_v1,
			    struct wl_array *coordinates);
	/**
	 * the state of the workspace changed
	 *
	 * This event is emitted immediately after the
	 * ext_workspace_handle_v1 is created and each time the workspace
	 * state changes, either because of a compositor action or because
	 * of a request in this protocol.
	 *
	 * Missing states convey the opposite meaning, e.g. an unset active
	 * bit means the workspace is currently inactive.
	 */
	void (*state)(void *data,
		      struct ext_workspace_handle_v1 *ext_workspace_handle_v1,
		      uint32_t state);
	/**
	 * compositor capabilities
	 *
	 * This event advertises the capabilities supported by the
	 * compositor. If a capability isn't supported, clients should hide
	 * or disable the UI elements that expose this functionality. For
	 * instance, if the compositor doesn't advertise support for
	 * removing workspaces, a button triggering the remove request
	 * should not be displayed.
	 *
	 * The compositor will ignore requests it doesn't support. For
	 * instance, a compositor which doesn't advertise support for
	 * remove will ignore remove requests.
	 *
	 * Compositors must send this event once after creation of an
	 * ext_workspace_handle_v1 . When the capabilities change,
	 * compositors must send this event again.
	 * @param capabilities capabilities
	 */
	void (*capabilities)(void *data,
			     struct ext_workspace_handle_v1 *ext_workspace_handle_v1,
			     uint32_t capabilities);
	/**
	 * this workspace has been removed
	 *
	 * This event is send when the workspace associated with the
	 * ext_workspace_handle_v1 has been removed. After sending this
	 * request, the compositor will immediately consider the object
	 * inert. Any requests will be ignored except the destroy request.
	 *
	 * It is guaranteed there won't be any more events referencing this
	 * ext_workspace_handle_v1.
	 *
	 * The compositor must only remove a workspaces not currently
	 * belonging to any workspace_group.
	 */
	void (*removed)(void *data,
			struct ext_workspace_handle_v1 *ext_workspace_handle_v1);
};

/**
 * @ingroup iface_ext_workspace_handle_v1
 */
static inline int
ext_workspace_handle_v1_add_listener(struct ext_workspace_handle_v1 *ext_workspace_handle_v1,
				     const struct ext_workspace_handle_v1_listener *listener, void *data)
{
	return wl_proxy_add_listener((struct wl_proxy *) ext_workspace_handle_v1,
				     (void (**)(void)) listener, data);
}

#define EXT_WORKSPACE_HANDLE_V1_DESTROY 0
#define EXT_WORKSPACE_HANDLE_V1_ACTIVATE 1
#define EXT_WORKSPACE_HANDLE_V1_DEACTIVATE 2
#define EXT_WORKSPACE_HANDLE_V1_ASSIGN 3
#define EXT_WORKSPACE_HANDLE_V1_REMOVE 4

/**
 * @ingroup iface_ext_workspace_handle_v1
 */
#define EXT_WORKSPACE_HANDLE_V1_ID_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_handle_v1
 */
#define EXT_WORKSPACE_HANDLE_V1_NAME_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_handle_v1
 */
#define EXT_WORKSPACE_HANDLE_V1_COORDINATES_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_handle_v1
 */
#define EXT_WORKSPACE_HANDLE_V1_STATE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_handle_v1
 */
#define EXT_WORKSPACE_HANDLE_V1_CAPABILITIES_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_handle_v1
 */
#define EXT_WORKSPACE_HANDLE_V1_REMOVED_SINCE_VERSION 1

/**
 * @ingroup iface_ext_workspace_handle_v1
 */
#define EXT_WORKSPACE_HANDLE_V1_DESTROY_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_handle_v1
 */
#define EXT_WORKSPACE_HANDLE_V1_ACTIVATE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_handle_v1
 */
#define EXT_WORKSPACE_HANDLE_V1_DEACTIVATE_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_handle_v1
 */
#define EXT_WORKSPACE_HANDLE_V1_ASSIGN_SINCE_VERSION 1
/**
 * @ingroup iface_ext_workspace_handle_v1
 */
#define EXT_WORKSPACE_HANDLE_V1_REMOVE_SINCE_VERSION 1

/** @ingroup iface_ext_workspace_handle_v1 */
static inline void
ext_workspace_handle_v1_set_user_data(struct ext_workspace_handle_v1 *ext_workspace_handle_v1, void *user_data)
{
	wl_proxy_set_user_data((struct wl_proxy *) ext_workspace_handle_v1, user_data);
}

/** @ingroup iface_ext_workspace_handle_v1 */
static inline void *
ext_workspace_handle_v1_get_user_data(struct ext_workspace_handle_v1 *ext_workspace_handle_v1)
{
	return wl_proxy_get_user_data((struct wl_proxy *) ext_workspace_handle_v1);
}

static inline uint32_t
ext_workspace_handle_v1_get_version(struct ext_workspace_handle_v1 *ext_workspace_handle_v1)
{
	return wl_proxy_get_version((struct wl_proxy *) ext_workspace_handle_v1);
}

/**
 * @ingroup iface_ext_workspace_handle_v1
 *
 * Destroys the ext_workspace_handle_v1 object.
 *
 * This request should be made either when the client does not want to
 * use the workspace object any more or after the remove event to finalize
 * the destruction of the object.
 */
static inline void
ext_workspace_handle_v1_destroy(struct ext_workspace_handle_v1 *ext_workspace_handle_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_workspace_handle_v1,
			 EXT_WORKSPACE_HANDLE_V1_DESTROY, NULL, wl_proxy_get_version((struct wl_proxy *) ext_workspace_handle_v1), WL_MARSHAL_FLAG_DESTROY);
}

/**
 * @ingroup iface_ext_workspace_handle_v1
 *
 * Request that this workspace be activated.
 *
 * There is no guarantee the workspace will be actually activated, and
 * behaviour may be compositor-dependent. For example, activating a
 * workspace may or may not deactivate all other workspaces in the same
 * group.
 */
static inline void
ext_workspace_handle_v1_activate(struct ext_workspace_handle_v1 *ext_workspace_handle_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_workspace_handle_v1,
			 EXT_WORKSPACE_HANDLE_V1_ACTIVATE, NULL, wl_proxy_get_version((struct wl_proxy *) ext_workspace_handle_v1), 0);
}

/**
 * @ingroup iface_ext_workspace_handle_v1
 *
 * Request that this workspace be deactivated.
 *
 * There is no guarantee the workspace will be actually deactivated.
 */
static inline void
ext_workspace_handle_v1_deactivate(struct ext_workspace_handle_v1 *ext_workspace_handle_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_workspace_handle_v1,
			 EXT_WORKSPACE_HANDLE_V1_DEACTIVATE, NULL, wl_proxy_get_version((struct wl_proxy *) ext_workspace_handle_v1), 0);
}

/**
 * @ingroup iface_ext_workspace_handle_v1
 *
 * Requests that this workspace is assigned to the given workspace group.
 *
 * There is no guarantee the workspace will be assigned.
 */
static inline void
ext_workspace_handle_v1_assign(struct ext_workspace_handle_v1 *ext_workspace_handle_v1, struct ext_workspace_group_handle_v1 *workspace_group)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_workspace_handle_v1,
			 EXT_WORKSPACE_HANDLE_V1_ASSIGN, NULL, wl_proxy_get_version((struct wl_proxy *) ext_workspace_handle_v1), 0, workspace_group);
}

/**
 * @ingroup iface_ext_workspace_handle_v1
 *
 * Request that this workspace be removed.
 *
 * There is no guarantee the workspace will be actually removed.
 */
static inline void
ext_workspace_handle_v1_remove(struct ext_workspace_handle_v1 *ext_workspace_handle_v1)
{
	wl_proxy_marshal_flags((struct wl_proxy *) ext_workspace_handle_v1,
			 EXT_WORKSPACE_HANDLE_V1_REMOVE, NULL, wl_proxy_get_version((struct wl_proxy *) ext_workspace_handle_v1), 0);
}

#ifdef  __cplusplus
}
#endif

#endif
