/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the ARM target                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 85;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(ARMInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(ARMInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static ARMInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static ARMInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_v2s1,
  GILLT_v2s32,
  GILLT_v2s64,
  GILLT_v4s1,
  GILLT_v4s16,
  GILLT_v4s32,
  GILLT_v4s64,
  GILLT_v8s1,
  GILLT_v8s8,
  GILLT_v8s16,
  GILLT_v8s64,
  GILLT_v16s1,
  GILLT_v16s8,
};
const static size_t NumTypeObjects = 16;
const static LLT TypeObjects[] = {
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getFixed(2), 1),
  LLT::vector(ElementCount::getFixed(2), 32),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 1),
  LLT::vector(ElementCount::getFixed(4), 16),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(4), 64),
  LLT::vector(ElementCount::getFixed(8), 1),
  LLT::vector(ElementCount::getFixed(8), 8),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(8), 64),
  LLT::vector(ElementCount::getFixed(16), 1),
  LLT::vector(ElementCount::getFixed(16), 8),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_NoHonorSignDependentRoundingBit = 75,
  Feature_HasV4TBit = 6,
  Feature_NoV4TBit = 7,
  Feature_HasV5TBit = 13,
  Feature_NoV5TBit = 65,
  Feature_HasV5TEBit = 11,
  Feature_HasV6Bit = 0,
  Feature_NoV6Bit = 9,
  Feature_HasV6MBit = 28,
  Feature_HasV8MBaselineBit = 35,
  Feature_HasV8_1MMainlineBit = 41,
  Feature_HasMVEIntBit = 63,
  Feature_HasMVEFloatBit = 64,
  Feature_HasCDEBit = 84,
  Feature_HasFPRegsBit = 42,
  Feature_HasFPRegs16Bit = 43,
  Feature_HasFPRegs64Bit = 76,
  Feature_HasV6T2Bit = 8,
  Feature_HasV6KBit = 18,
  Feature_HasV7Bit = 3,
  Feature_HasV8Bit = 55,
  Feature_PreV8Bit = 19,
  Feature_HasV8_1aBit = 78,
  Feature_HasV8_3aBit = 79,
  Feature_NoVFPBit = 22,
  Feature_HasVFP2Bit = 21,
  Feature_HasVFP3Bit = 52,
  Feature_HasVFP4Bit = 50,
  Feature_HasDPVFPBit = 44,
  Feature_HasFPARMv8Bit = 47,
  Feature_HasNEONBit = 53,
  Feature_HasSHA2Bit = 62,
  Feature_HasAESBit = 54,
  Feature_HasDotProdBit = 56,
  Feature_HasCRCBit = 14,
  Feature_HasLOBBit = 40,
  Feature_HasFP16Bit = 61,
  Feature_HasFullFP16Bit = 46,
  Feature_HasMatMulInt8Bit = 57,
  Feature_HasDivideInThumbBit = 37,
  Feature_HasDivideInARMBit = 12,
  Feature_HasDSPBit = 36,
  Feature_HasDBBit = 15,
  Feature_HasV7ClrexBit = 17,
  Feature_HasAcquireReleaseBit = 16,
  Feature_HasMPBit = 2,
  Feature_Has8MSecExtBit = 29,
  Feature_HasZCZBit = 58,
  Feature_UseNEONForFPBit = 82,
  Feature_DontUseNEONForFPBit = 45,
  Feature_IsThumbBit = 26,
  Feature_IsThumb1OnlyBit = 27,
  Feature_IsThumb2Bit = 34,
  Feature_IsNotMClassBit = 38,
  Feature_IsARMBit = 1,
  Feature_IsWindowsBit = 30,
  Feature_IsNotWindowsBit = 31,
  Feature_IsReadTPTPIDRURWBit = 68,
  Feature_IsReadTPTPIDRUROBit = 69,
  Feature_IsReadTPTPIDRPRWBit = 70,
  Feature_IsReadTPSoftBit = 20,
  Feature_UseNaClTrapBit = 4,
  Feature_DontUseNaClTrapBit = 5,
  Feature_UseMovtBit = 39,
  Feature_DontUseMovtBit = 23,
  Feature_UseMovtInPicBit = 24,
  Feature_DontUseMovtInPicBit = 25,
  Feature_UseFPVMLxBit = 49,
  Feature_SLSBLRMitigationBit = 67,
  Feature_NoSLSBLRMitigationBit = 66,
  Feature_UseMulOpsBit = 10,
  Feature_UseFusedMACBit = 51,
  Feature_HasFastVGETLNi32Bit = 59,
  Feature_HasSlowVGETLNi32Bit = 80,
  Feature_HasFastVDUP32Bit = 60,
  Feature_HasSlowVDUP32Bit = 81,
  Feature_UseVMOVSRBit = 48,
  Feature_DontUseVMOVSRBit = 83,
  Feature_IsLEBit = 74,
  Feature_IsBEBit = 77,
  Feature_GenExecuteOnlyBit = 33,
  Feature_DontGenExecuteOnlyBit = 32,
  Feature_GenT1ExecuteOnlyBit = 73,
  Feature_SignRetAddrBit = 72,
  Feature_NoSignRetAddrBit = 71,
};

PredicateBitset ARMInstructionSelector::
computeAvailableModuleFeatures(const ARMSubtarget *Subtarget) const {
  PredicateBitset Features{};
  if (!TM.Options.HonorSignDependentRoundingFPMath())
    Features.set(Feature_NoHonorSignDependentRoundingBit);
  if (Subtarget->hasV4TOps())
    Features.set(Feature_HasV4TBit);
  if (!Subtarget->hasV4TOps())
    Features.set(Feature_NoV4TBit);
  if (Subtarget->hasV5TOps())
    Features.set(Feature_HasV5TBit);
  if (!Subtarget->hasV5TOps())
    Features.set(Feature_NoV5TBit);
  if (Subtarget->hasV5TEOps())
    Features.set(Feature_HasV5TEBit);
  if (Subtarget->hasV6Ops())
    Features.set(Feature_HasV6Bit);
  if (!Subtarget->hasV6Ops())
    Features.set(Feature_NoV6Bit);
  if (Subtarget->hasV6MOps())
    Features.set(Feature_HasV6MBit);
  if (Subtarget->hasV8MBaselineOps())
    Features.set(Feature_HasV8MBaselineBit);
  if (Subtarget->hasV8_1MMainlineOps())
    Features.set(Feature_HasV8_1MMainlineBit);
  if (Subtarget->hasMVEIntegerOps())
    Features.set(Feature_HasMVEIntBit);
  if (Subtarget->hasMVEFloatOps())
    Features.set(Feature_HasMVEFloatBit);
  if (Subtarget->hasCDEOps())
    Features.set(Feature_HasCDEBit);
  if (Subtarget->hasFPRegs())
    Features.set(Feature_HasFPRegsBit);
  if (Subtarget->hasFPRegs16())
    Features.set(Feature_HasFPRegs16Bit);
  if (Subtarget->hasFPRegs64())
    Features.set(Feature_HasFPRegs64Bit);
  if (Subtarget->hasV6T2Ops())
    Features.set(Feature_HasV6T2Bit);
  if (Subtarget->hasV6KOps())
    Features.set(Feature_HasV6KBit);
  if (Subtarget->hasV7Ops())
    Features.set(Feature_HasV7Bit);
  if (Subtarget->hasV8Ops())
    Features.set(Feature_HasV8Bit);
  if (!Subtarget->hasV8Ops())
    Features.set(Feature_PreV8Bit);
  if (Subtarget->hasV8_1aOps())
    Features.set(Feature_HasV8_1aBit);
  if (Subtarget->hasV8_3aOps())
    Features.set(Feature_HasV8_3aBit);
  if (!Subtarget->hasVFP2Base())
    Features.set(Feature_NoVFPBit);
  if (Subtarget->hasVFP2Base())
    Features.set(Feature_HasVFP2Bit);
  if (Subtarget->hasVFP3Base())
    Features.set(Feature_HasVFP3Bit);
  if (Subtarget->hasVFP4Base())
    Features.set(Feature_HasVFP4Bit);
  if (Subtarget->hasFP64())
    Features.set(Feature_HasDPVFPBit);
  if (Subtarget->hasFPARMv8Base())
    Features.set(Feature_HasFPARMv8Bit);
  if (Subtarget->hasNEON())
    Features.set(Feature_HasNEONBit);
  if (Subtarget->hasSHA2())
    Features.set(Feature_HasSHA2Bit);
  if (Subtarget->hasAES())
    Features.set(Feature_HasAESBit);
  if (Subtarget->hasDotProd())
    Features.set(Feature_HasDotProdBit);
  if (Subtarget->hasCRC())
    Features.set(Feature_HasCRCBit);
  if (Subtarget->hasLOB())
    Features.set(Feature_HasLOBBit);
  if (Subtarget->hasFP16())
    Features.set(Feature_HasFP16Bit);
  if (Subtarget->hasFullFP16())
    Features.set(Feature_HasFullFP16Bit);
  if (Subtarget->hasMatMulInt8())
    Features.set(Feature_HasMatMulInt8Bit);
  if (Subtarget->hasDivideInThumbMode())
    Features.set(Feature_HasDivideInThumbBit);
  if (Subtarget->hasDivideInARMMode())
    Features.set(Feature_HasDivideInARMBit);
  if (Subtarget->hasDSP())
    Features.set(Feature_HasDSPBit);
  if (Subtarget->hasDataBarrier())
    Features.set(Feature_HasDBBit);
  if (Subtarget->hasV7Clrex())
    Features.set(Feature_HasV7ClrexBit);
  if (Subtarget->hasAcquireRelease())
    Features.set(Feature_HasAcquireReleaseBit);
  if (Subtarget->hasMPExtension())
    Features.set(Feature_HasMPBit);
  if (Subtarget->has8MSecExt())
    Features.set(Feature_Has8MSecExtBit);
  if (Subtarget->hasZeroCycleZeroing())
    Features.set(Feature_HasZCZBit);
  if (Subtarget->useNEONForSinglePrecisionFP())
    Features.set(Feature_UseNEONForFPBit);
  if (!Subtarget->useNEONForSinglePrecisionFP())
    Features.set(Feature_DontUseNEONForFPBit);
  if (Subtarget->isThumb())
    Features.set(Feature_IsThumbBit);
  if (Subtarget->isThumb1Only())
    Features.set(Feature_IsThumb1OnlyBit);
  if (Subtarget->isThumb2())
    Features.set(Feature_IsThumb2Bit);
  if (!Subtarget->isMClass())
    Features.set(Feature_IsNotMClassBit);
  if (!Subtarget->isThumb())
    Features.set(Feature_IsARMBit);
  if (Subtarget->isTargetWindows())
    Features.set(Feature_IsWindowsBit);
  if (!Subtarget->isTargetWindows())
    Features.set(Feature_IsNotWindowsBit);
  if (Subtarget->isReadTPTPIDRURW())
    Features.set(Feature_IsReadTPTPIDRURWBit);
  if (Subtarget->isReadTPTPIDRURO())
    Features.set(Feature_IsReadTPTPIDRUROBit);
  if (Subtarget->isReadTPTPIDRPRW())
    Features.set(Feature_IsReadTPTPIDRPRWBit);
  if (Subtarget->isReadTPSoft())
    Features.set(Feature_IsReadTPSoftBit);
  if (Subtarget->useNaClTrap())
    Features.set(Feature_UseNaClTrapBit);
  if (!Subtarget->useNaClTrap())
    Features.set(Feature_DontUseNaClTrapBit);
  if (Subtarget->useMulOps())
    Features.set(Feature_UseMulOpsBit);
  if (TM.Options.AllowFPOpFusion ==  FPOpFusion::Fast && Subtarget->useFPVFMx())
    Features.set(Feature_UseFusedMACBit);
  if (!Subtarget->hasSlowVGETLNi32())
    Features.set(Feature_HasFastVGETLNi32Bit);
  if (Subtarget->hasSlowVGETLNi32())
    Features.set(Feature_HasSlowVGETLNi32Bit);
  if (!Subtarget->hasSlowVDUP32())
    Features.set(Feature_HasFastVDUP32Bit);
  if (Subtarget->hasSlowVDUP32())
    Features.set(Feature_HasSlowVDUP32Bit);
  if (Subtarget->preferVMOVSR() ||!Subtarget->useNEONForSinglePrecisionFP())
    Features.set(Feature_UseVMOVSRBit);
  if (!Subtarget->preferVMOVSR() &&Subtarget->useNEONForSinglePrecisionFP())
    Features.set(Feature_DontUseVMOVSRBit);
  if (Subtarget->genExecuteOnly())
    Features.set(Feature_GenExecuteOnlyBit);
  if (!Subtarget->genExecuteOnly())
    Features.set(Feature_DontGenExecuteOnlyBit);
  if (Subtarget->genExecuteOnly() && Subtarget->isThumb1Only() && !Subtarget->hasV8MBaselineOps())
    Features.set(Feature_GenT1ExecuteOnlyBit);
  return Features;
}

void ARMInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const ARMSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset ARMInstructionSelector::
computeAvailableFunctionFeatures(const ARMSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  if (Subtarget->useMovt())
    Features.set(Feature_UseMovtBit);
  if (!Subtarget->useMovt())
    Features.set(Feature_DontUseMovtBit);
  if (Subtarget->useMovt() && Subtarget->allowPositionIndependentMovt())
    Features.set(Feature_UseMovtInPicBit);
  if (!Subtarget->useMovt() || !Subtarget->allowPositionIndependentMovt())
    Features.set(Feature_DontUseMovtInPicBit);
  if (((Subtarget->useFPVMLx() &&  TM.Options.AllowFPOpFusion != FPOpFusion::Fast) ||Subtarget->hasMinSize()))
    Features.set(Feature_UseFPVMLxBit);
  if ( MF->getSubtarget<ARMSubtarget>().hardenSlsBlr() )
    Features.set(Feature_SLSBLRMitigationBit);
  if ( !MF->getSubtarget<ARMSubtarget>().hardenSlsBlr() )
    Features.set(Feature_NoSLSBLRMitigationBit);
  if (MF->getDataLayout().isLittleEndian())
    Features.set(Feature_IsLEBit);
  if (MF->getDataLayout().isBigEndian())
    Features.set(Feature_IsBEBit);
  if ( MF->getInfo<ARMFunctionInfo>()->shouldSignReturnAddress(true) )
    Features.set(Feature_SignRetAddrBit);
  if ( !MF->getInfo<ARMFunctionInfo>()->shouldSignReturnAddress(true) )
    Features.set(Feature_NoSignRetAddrBit);
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HasDotProd,
  GIFBS_HasFP16,
  GIFBS_HasFPARMv8,
  GIFBS_HasFPRegs,
  GIFBS_HasFullFP16,
  GIFBS_HasMVEFloat,
  GIFBS_HasMVEInt,
  GIFBS_HasMatMulInt8,
  GIFBS_HasNEON,
  GIFBS_HasVFP2,
  GIFBS_HasVFP3,
  GIFBS_HasVFP4,
  GIFBS_IsARM,
  GIFBS_IsThumb,
  GIFBS_IsThumb2,
  GIFBS_NoHonorSignDependentRounding,
  GIFBS_DontUseNEONForFP_HasVFP2,
  GIFBS_DontUseNaClTrap_IsARM,
  GIFBS_DontUseVMOVSR_HasNEON,
  GIFBS_Has8MSecExt_IsThumb,
  GIFBS_HasAES_HasV8,
  GIFBS_HasCRC_IsARM,
  GIFBS_HasCRC_IsThumb2,
  GIFBS_HasDB_IsARM,
  GIFBS_HasDB_IsThumb,
  GIFBS_HasDPVFP_HasFPARMv8,
  GIFBS_HasDPVFP_HasVFP2,
  GIFBS_HasDPVFP_HasVFP3,
  GIFBS_HasDPVFP_HasVFP4,
  GIFBS_HasDPVFP_NoHonorSignDependentRounding,
  GIFBS_HasDSP_IsThumb2,
  GIFBS_HasDivideInARM_IsARM,
  GIFBS_HasFP16_HasNEON,
  GIFBS_HasFPARMv8_HasNEON,
  GIFBS_HasFPRegs_HasFastVGETLNi32,
  GIFBS_HasFPRegs_UseVMOVSR,
  GIFBS_HasFullFP16_HasNEON,
  GIFBS_HasMVEInt_HasV8_1MMainline,
  GIFBS_HasMVEInt_IsBE,
  GIFBS_HasMVEInt_IsLE,
  GIFBS_HasNEON_HasV8,
  GIFBS_HasNEON_HasV8_1a,
  GIFBS_HasNEON_HasV8_3a,
  GIFBS_HasNEON_HasVFP4,
  GIFBS_HasNEON_IsBE,
  GIFBS_HasNEON_IsLE,
  GIFBS_HasNEON_UseNEONForFP,
  GIFBS_HasSHA2_HasV8,
  GIFBS_HasV5T_IsARM,
  GIFBS_HasV5T_IsThumb,
  GIFBS_HasV5TE_IsARM,
  GIFBS_HasV6_IsARM,
  GIFBS_HasV6K_IsARM,
  GIFBS_HasV6M_IsThumb,
  GIFBS_HasV6T2_IsARM,
  GIFBS_HasV7_IsARM,
  GIFBS_HasV7Clrex_IsThumb,
  GIFBS_HasV8MBaseline_IsThumb,
  GIFBS_IsARM_NoV5T,
  GIFBS_IsARM_NoV6,
  GIFBS_IsARM_PreV8,
  GIFBS_IsARM_UseNaClTrap,
  GIFBS_IsThumb_IsThumb1Only,
  GIFBS_IsThumb_IsWindows,
  GIFBS_IsThumb_NoV5T,
  GIFBS_IsThumb_UseMovt,
  GIFBS_IsThumb2_PreV8,
  GIFBS_IsThumb2_UseMulOps,
  GIFBS_DontUseMovt_GenExecuteOnly_IsThumb1Only,
  GIFBS_HasDSP_IsThumb2_UseMulOps,
  GIFBS_HasDivideInThumb_HasV8MBaseline_IsThumb,
  GIFBS_HasFPARMv8_HasFullFP16_HasNEON,
  GIFBS_HasFullFP16_HasNEON_HasV8,
  GIFBS_HasFullFP16_HasNEON_HasV8_3a,
  GIFBS_HasFullFP16_HasNEON_UseFPVMLx,
  GIFBS_HasFullFP16_HasNEON_UseFusedMAC,
  GIFBS_HasLOB_HasV8_1MMainline_IsThumb2,
  GIFBS_HasNEON_UseFPVMLx_UseNEONForFP,
  GIFBS_HasV5TE_IsARM_UseMulOps,
  GIFBS_HasV6_IsARM_UseMulOps,
  GIFBS_HasV6_IsThumb_IsThumb1Only,
  GIFBS_HasV6T2_IsARM_UseMulOps,
  GIFBS_HasVFP4_UseFusedMAC_UseNEONForFP,
  GIFBS_IsARM_NoV6_UseMulOps,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HasDotProdBit, },
  {Feature_HasFP16Bit, },
  {Feature_HasFPARMv8Bit, },
  {Feature_HasFPRegsBit, },
  {Feature_HasFullFP16Bit, },
  {Feature_HasMVEFloatBit, },
  {Feature_HasMVEIntBit, },
  {Feature_HasMatMulInt8Bit, },
  {Feature_HasNEONBit, },
  {Feature_HasVFP2Bit, },
  {Feature_HasVFP3Bit, },
  {Feature_HasVFP4Bit, },
  {Feature_IsARMBit, },
  {Feature_IsThumbBit, },
  {Feature_IsThumb2Bit, },
  {Feature_NoHonorSignDependentRoundingBit, },
  {Feature_DontUseNEONForFPBit, Feature_HasVFP2Bit, },
  {Feature_DontUseNaClTrapBit, Feature_IsARMBit, },
  {Feature_DontUseVMOVSRBit, Feature_HasNEONBit, },
  {Feature_Has8MSecExtBit, Feature_IsThumbBit, },
  {Feature_HasAESBit, Feature_HasV8Bit, },
  {Feature_HasCRCBit, Feature_IsARMBit, },
  {Feature_HasCRCBit, Feature_IsThumb2Bit, },
  {Feature_HasDBBit, Feature_IsARMBit, },
  {Feature_HasDBBit, Feature_IsThumbBit, },
  {Feature_HasDPVFPBit, Feature_HasFPARMv8Bit, },
  {Feature_HasDPVFPBit, Feature_HasVFP2Bit, },
  {Feature_HasDPVFPBit, Feature_HasVFP3Bit, },
  {Feature_HasDPVFPBit, Feature_HasVFP4Bit, },
  {Feature_HasDPVFPBit, Feature_NoHonorSignDependentRoundingBit, },
  {Feature_HasDSPBit, Feature_IsThumb2Bit, },
  {Feature_HasDivideInARMBit, Feature_IsARMBit, },
  {Feature_HasFP16Bit, Feature_HasNEONBit, },
  {Feature_HasFPARMv8Bit, Feature_HasNEONBit, },
  {Feature_HasFPRegsBit, Feature_HasFastVGETLNi32Bit, },
  {Feature_HasFPRegsBit, Feature_UseVMOVSRBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, },
  {Feature_HasMVEIntBit, Feature_HasV8_1MMainlineBit, },
  {Feature_HasMVEIntBit, Feature_IsBEBit, },
  {Feature_HasMVEIntBit, Feature_IsLEBit, },
  {Feature_HasNEONBit, Feature_HasV8Bit, },
  {Feature_HasNEONBit, Feature_HasV8_1aBit, },
  {Feature_HasNEONBit, Feature_HasV8_3aBit, },
  {Feature_HasNEONBit, Feature_HasVFP4Bit, },
  {Feature_HasNEONBit, Feature_IsBEBit, },
  {Feature_HasNEONBit, Feature_IsLEBit, },
  {Feature_HasNEONBit, Feature_UseNEONForFPBit, },
  {Feature_HasSHA2Bit, Feature_HasV8Bit, },
  {Feature_HasV5TBit, Feature_IsARMBit, },
  {Feature_HasV5TBit, Feature_IsThumbBit, },
  {Feature_HasV5TEBit, Feature_IsARMBit, },
  {Feature_HasV6Bit, Feature_IsARMBit, },
  {Feature_HasV6KBit, Feature_IsARMBit, },
  {Feature_HasV6MBit, Feature_IsThumbBit, },
  {Feature_HasV6T2Bit, Feature_IsARMBit, },
  {Feature_HasV7Bit, Feature_IsARMBit, },
  {Feature_HasV7ClrexBit, Feature_IsThumbBit, },
  {Feature_HasV8MBaselineBit, Feature_IsThumbBit, },
  {Feature_IsARMBit, Feature_NoV5TBit, },
  {Feature_IsARMBit, Feature_NoV6Bit, },
  {Feature_IsARMBit, Feature_PreV8Bit, },
  {Feature_IsARMBit, Feature_UseNaClTrapBit, },
  {Feature_IsThumbBit, Feature_IsThumb1OnlyBit, },
  {Feature_IsThumbBit, Feature_IsWindowsBit, },
  {Feature_IsThumbBit, Feature_NoV5TBit, },
  {Feature_IsThumbBit, Feature_UseMovtBit, },
  {Feature_IsThumb2Bit, Feature_PreV8Bit, },
  {Feature_IsThumb2Bit, Feature_UseMulOpsBit, },
  {Feature_DontUseMovtBit, Feature_GenExecuteOnlyBit, Feature_IsThumb1OnlyBit, },
  {Feature_HasDSPBit, Feature_IsThumb2Bit, Feature_UseMulOpsBit, },
  {Feature_HasDivideInThumbBit, Feature_HasV8MBaselineBit, Feature_IsThumbBit, },
  {Feature_HasFPARMv8Bit, Feature_HasFullFP16Bit, Feature_HasNEONBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_HasV8Bit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_HasV8_3aBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_UseFPVMLxBit, },
  {Feature_HasFullFP16Bit, Feature_HasNEONBit, Feature_UseFusedMACBit, },
  {Feature_HasLOBBit, Feature_HasV8_1MMainlineBit, Feature_IsThumb2Bit, },
  {Feature_HasNEONBit, Feature_UseFPVMLxBit, Feature_UseNEONForFPBit, },
  {Feature_HasV5TEBit, Feature_IsARMBit, Feature_UseMulOpsBit, },
  {Feature_HasV6Bit, Feature_IsARMBit, Feature_UseMulOpsBit, },
  {Feature_HasV6Bit, Feature_IsThumbBit, Feature_IsThumb1OnlyBit, },
  {Feature_HasV6T2Bit, Feature_IsARMBit, Feature_UseMulOpsBit, },
  {Feature_HasVFP4Bit, Feature_UseFusedMACBit, Feature_UseNEONForFPBit, },
  {Feature_IsARMBit, Feature_NoV6Bit, Feature_UseMulOpsBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

ARMInstructionSelector::ComplexMatcherMemFn
ARMInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_bf_inv_mask_imm = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_vfp_f32imm,
  GICXXPred_MI_Predicate_vfp_f64imm,
};
bool ARMInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_bf_inv_mask_imm: {
    
        // There's better methods of implementing this check. IntImmLeaf<> would be
        // equivalent and have less boilerplate but we need a test for C++
        // predicates and this one causes new rules to be imported into GlobalISel
        // without requiring additional features first.
        const auto &MO = MI.getOperand(1);
        if (!MO.isCImm())
          return false;
        return ARM::isBitFieldInvertedMask(MO.getCImm()->getZExtValue());
      
    llvm_unreachable("bf_inv_mask_imm should have returned");
  }
  case GICXXPred_MI_Predicate_vfp_f32imm: {
    
          const auto &MO = MI.getOperand(1);
          if (!MO.isFPImm())
            return false;
          return ARM_AM::getFP32Imm(MO.getFPImm()->getValueAPF()) != -1;
        
    llvm_unreachable("vfp_f32imm should have returned");
  }
  case GICXXPred_MI_Predicate_vfp_f64imm: {
    
          const auto &MO = MI.getOperand(1);
          if (!MO.isFPImm())
            return false;
          return ARM_AM::getFP64Imm(MO.getFPImm()->getValueAPF()) != -1;
        
    llvm_unreachable("vfp_f64imm should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_VectorIndex8 = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_VectorIndex16,
  GICXXPred_I64_Predicate_VectorIndex32,
  GICXXPred_I64_Predicate_VectorIndex64,
  GICXXPred_I64_Predicate_asr_imm,
  GICXXPred_I64_Predicate_imm0_7,
  GICXXPred_I64_Predicate_imm0_15,
  GICXXPred_I64_Predicate_imm0_31,
  GICXXPred_I64_Predicate_imm0_32,
  GICXXPred_I64_Predicate_imm0_63,
  GICXXPred_I64_Predicate_imm0_239,
  GICXXPred_I64_Predicate_imm0_255,
  GICXXPred_I64_Predicate_imm0_255_expr,
  GICXXPred_I64_Predicate_imm0_4095,
  GICXXPred_I64_Predicate_imm0_65535,
  GICXXPred_I64_Predicate_imm0_65535_expr,
  GICXXPred_I64_Predicate_imm0_65535_neg,
  GICXXPred_I64_Predicate_imm1_7,
  GICXXPred_I64_Predicate_imm1_15,
  GICXXPred_I64_Predicate_imm1_16,
  GICXXPred_I64_Predicate_imm1_31,
  GICXXPred_I64_Predicate_imm8,
  GICXXPred_I64_Predicate_imm8_255,
  GICXXPred_I64_Predicate_imm8_or_16,
  GICXXPred_I64_Predicate_imm16,
  GICXXPred_I64_Predicate_imm16_31,
  GICXXPred_I64_Predicate_imm24b,
  GICXXPred_I64_Predicate_imm32,
  GICXXPred_I64_Predicate_imm256_510,
  GICXXPred_I64_Predicate_imm_3b,
  GICXXPred_I64_Predicate_imm_4b,
  GICXXPred_I64_Predicate_imm_6b,
  GICXXPred_I64_Predicate_imm_7b,
  GICXXPred_I64_Predicate_imm_9b,
  GICXXPred_I64_Predicate_imm_11b,
  GICXXPred_I64_Predicate_imm_12b,
  GICXXPred_I64_Predicate_imm_13b,
  GICXXPred_I64_Predicate_imm_even,
  GICXXPred_I64_Predicate_imm_odd,
  GICXXPred_I64_Predicate_imm_sr,
  GICXXPred_I64_Predicate_long_shift,
  GICXXPred_I64_Predicate_mod_imm,
  GICXXPred_I64_Predicate_mod_imm_not,
  GICXXPred_I64_Predicate_pkh_asr_amt,
  GICXXPred_I64_Predicate_pkh_lsl_amt,
  GICXXPred_I64_Predicate_shr_imm8,
  GICXXPred_I64_Predicate_shr_imm16,
  GICXXPred_I64_Predicate_shr_imm32,
  GICXXPred_I64_Predicate_shr_imm64,
  GICXXPred_I64_Predicate_t2_so_imm,
  GICXXPred_I64_Predicate_t2_so_imm_neg,
};
bool ARMInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_VectorIndex8: {
    
      return ((uint64_t)Imm) < 8;
    
  }
  case GICXXPred_I64_Predicate_VectorIndex16: {
    
      return ((uint64_t)Imm) < 4;
    
  }
  case GICXXPred_I64_Predicate_VectorIndex32: {
    
      return ((uint64_t)Imm) < 2;
    
  }
  case GICXXPred_I64_Predicate_VectorIndex64: {
    
      return ((uint64_t)Imm) < 1;
    
  }
  case GICXXPred_I64_Predicate_asr_imm: {
     return Imm > 0 && Imm <= 32; 
  }
  case GICXXPred_I64_Predicate_imm0_7: {
    
      return Imm >= 0 && Imm < 8;
    
  }
  case GICXXPred_I64_Predicate_imm0_15: {
    
      return Imm >= 0 && Imm < 16;
    
  }
  case GICXXPred_I64_Predicate_imm0_31: {
    
      return Imm >= 0 && Imm < 32;
    
  }
  case GICXXPred_I64_Predicate_imm0_32: {
    
      return Imm >= 0 && Imm < 33;
    
  }
  case GICXXPred_I64_Predicate_imm0_63: {
    
      return Imm >= 0 && Imm < 64;
    
  }
  case GICXXPred_I64_Predicate_imm0_239: {
     return Imm >= 0 && Imm < 240; 
  }
  case GICXXPred_I64_Predicate_imm0_255: {
     return Imm >= 0 && Imm < 256; 
  }
  case GICXXPred_I64_Predicate_imm0_255_expr: {
     return Imm >= 0 && Imm < 256; 
  }
  case GICXXPred_I64_Predicate_imm0_4095: {
    
      return Imm >= 0 && Imm < 4096;
    
  }
  case GICXXPred_I64_Predicate_imm0_65535: {
    
      return Imm >= 0 && Imm < 65536;
    
  }
  case GICXXPred_I64_Predicate_imm0_65535_expr: {
    
      return Imm >= 0 && Imm < 65536;
    
  }
  case GICXXPred_I64_Predicate_imm0_65535_neg: {
    
      return -Imm >= 0 && -Imm < 65536;
    
  }
  case GICXXPred_I64_Predicate_imm1_7: {
     return Imm > 0 && Imm < 8; 
  }
  case GICXXPred_I64_Predicate_imm1_15: {
     return Imm > 0 && Imm < 16; 
  }
  case GICXXPred_I64_Predicate_imm1_16: {
    
        return Imm > 0 && Imm <= 16;
      
  }
  case GICXXPred_I64_Predicate_imm1_31: {
     return Imm > 0 && Imm < 32; 
  }
  case GICXXPred_I64_Predicate_imm8: {
     return Imm == 8; 
  }
  case GICXXPred_I64_Predicate_imm8_255: {
    
      return Imm >= 8 && Imm < 256;
    
  }
  case GICXXPred_I64_Predicate_imm8_or_16: {
     return Imm == 8 || Imm == 16;
  }
  case GICXXPred_I64_Predicate_imm16: {
     return Imm == 16; 
  }
  case GICXXPred_I64_Predicate_imm16_31: {
    
      return (int32_t)Imm >= 16 && (int32_t)Imm < 32;
    
  }
  case GICXXPred_I64_Predicate_imm24b: {
    
      return Imm >= 0 && Imm <= 0xffffff;
    
  }
  case GICXXPred_I64_Predicate_imm32: {
     return Imm == 32; 
  }
  case GICXXPred_I64_Predicate_imm256_510: {
    
      return Imm >= 256 && Imm < 511;
    
  }
  case GICXXPred_I64_Predicate_imm_3b: {
    { return Imm >= 0 && Imm < (1 << 3); }
    llvm_unreachable("imm_3b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_4b: {
    { return Imm >= 0 && Imm < (1 << 4); }
    llvm_unreachable("imm_4b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_6b: {
    { return Imm >= 0 && Imm < (1 << 6); }
    llvm_unreachable("imm_6b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_7b: {
    { return Imm >= 0 && Imm < (1 << 7); }
    llvm_unreachable("imm_7b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_9b: {
    { return Imm >= 0 && Imm < (1 << 9); }
    llvm_unreachable("imm_9b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_11b: {
    { return Imm >= 0 && Imm < (1 << 11); }
    llvm_unreachable("imm_11b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_12b: {
    { return Imm >= 0 && Imm < (1 << 12); }
    llvm_unreachable("imm_12b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_13b: {
    { return Imm >= 0 && Imm < (1 << 13); }
    llvm_unreachable("imm_13b should have returned");
  }
  case GICXXPred_I64_Predicate_imm_even: {
     return (Imm & 1) == 0; 
  }
  case GICXXPred_I64_Predicate_imm_odd: {
     return (Imm & 1) == 1; 
  }
  case GICXXPred_I64_Predicate_imm_sr: {
    
      return Imm > 0 && Imm <= 32;
    
  }
  case GICXXPred_I64_Predicate_long_shift: {
     return Imm > 0 && Imm <= 32; 
  }
  case GICXXPred_I64_Predicate_mod_imm: {
    
        return ARM_AM::getSOImmVal(Imm) != -1;
      
  }
  case GICXXPred_I64_Predicate_mod_imm_not: {
    
        return ARM_AM::getSOImmVal(~(uint32_t)Imm) != -1;
      
  }
  case GICXXPred_I64_Predicate_pkh_asr_amt: {
     return Imm > 0 && Imm <= 32; 
  }
  case GICXXPred_I64_Predicate_pkh_lsl_amt: {
     return Imm >= 0 && Imm < 32; 
  }
  case GICXXPred_I64_Predicate_shr_imm8: {
     return Imm > 0 && Imm <= 8; 
  }
  case GICXXPred_I64_Predicate_shr_imm16: {
     return Imm > 0 && Imm <= 16; 
  }
  case GICXXPred_I64_Predicate_shr_imm32: {
     return Imm > 0 && Imm <= 32; 
  }
  case GICXXPred_I64_Predicate_shr_imm64: {
     return Imm > 0 && Imm <= 64; 
  }
  case GICXXPred_I64_Predicate_t2_so_imm: {
    
        return ARM_AM::getT2SOImmVal(Imm) != -1;
      
  }
  case GICXXPred_I64_Predicate_t2_so_imm_neg: {
    
      return Imm && ARM_AM::getT2SOImmVal(-(uint32_t)Imm) != -1;
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool ARMInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_arm_i32imm = GICXXPred_Invalid + 1,
};
bool ARMInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_arm_i32imm: {
    
      if (Subtarget->useMovt())
        return true;
      if (ARM_AM::isSOImmTwoPartVal(Imm.getZExtValue()))
        return true;
      return ARM_AM::isSOImmTwoPartValNeg(Imm.getZExtValue());
    
    llvm_unreachable("arm_i32imm should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool ARMInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("ARMInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderInvertedImm,
  GICR_renderVFPF32Imm,
  GICR_renderVFPF64Imm,
};
ARMInstructionSelector::CustomRendererFn
ARMInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &ARMInstructionSelector::renderInvertedImm,
  &ARMInstructionSelector::renderVFPF32Imm,
  &ARMInstructionSelector::renderVFPF64Imm,
};

bool ARMInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool ARMInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("ARMInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *ARMInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(53), GIMT_Encode2(304), /*)*//*default:*//*Label 78*/ GIMT_Encode4(130906),
    /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(1014),
    /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(10341),
    /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(13585),
    /*TargetOpcode::G_SDIV*//*Label 3*/ GIMT_Encode4(15289),
    /*TargetOpcode::G_UDIV*//*Label 4*/ GIMT_Encode4(15385), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_AND*//*Label 5*/ GIMT_Encode4(15481),
    /*TargetOpcode::G_OR*//*Label 6*/ GIMT_Encode4(18661),
    /*TargetOpcode::G_XOR*//*Label 7*/ GIMT_Encode4(24470), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CONCAT_VECTORS*//*Label 8*/ GIMT_Encode4(26165), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BITCAST*//*Label 9*/ GIMT_Encode4(26552), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 10*/ GIMT_Encode4(35564),
    /*TargetOpcode::G_INTRINSIC_ROUND*//*Label 11*/ GIMT_Encode4(35860), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SEXTLOAD*//*Label 12*/ GIMT_Encode4(36123), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FENCE*//*Label 13*/ GIMT_Encode4(36286), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC*//*Label 14*/ GIMT_Encode4(36307),
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 15*/ GIMT_Encode4(91479), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ANYEXT*//*Label 16*/ GIMT_Encode4(99141),
    /*TargetOpcode::G_TRUNC*//*Label 17*/ GIMT_Encode4(99299),
    /*TargetOpcode::G_CONSTANT*//*Label 18*/ GIMT_Encode4(99457),
    /*TargetOpcode::G_FCONSTANT*//*Label 19*/ GIMT_Encode4(99778), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SEXT*//*Label 20*/ GIMT_Encode4(99874),
    /*TargetOpcode::G_SEXT_INREG*//*Label 21*/ GIMT_Encode4(100032),
    /*TargetOpcode::G_ZEXT*//*Label 22*/ GIMT_Encode4(100637),
    /*TargetOpcode::G_SHL*//*Label 23*/ GIMT_Encode4(100795),
    /*TargetOpcode::G_LSHR*//*Label 24*/ GIMT_Encode4(101011),
    /*TargetOpcode::G_ASHR*//*Label 25*/ GIMT_Encode4(101119), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ROTR*//*Label 26*/ GIMT_Encode4(101392), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_UMULH*//*Label 27*/ GIMT_Encode4(101724),
    /*TargetOpcode::G_SMULH*//*Label 28*/ GIMT_Encode4(101972),
    /*TargetOpcode::G_UADDSAT*//*Label 29*/ GIMT_Encode4(102341),
    /*TargetOpcode::G_SADDSAT*//*Label 30*/ GIMT_Encode4(102986),
    /*TargetOpcode::G_USUBSAT*//*Label 31*/ GIMT_Encode4(104286),
    /*TargetOpcode::G_SSUBSAT*//*Label 32*/ GIMT_Encode4(104931), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FADD*//*Label 33*/ GIMT_Encode4(105951),
    /*TargetOpcode::G_FSUB*//*Label 34*/ GIMT_Encode4(108304),
    /*TargetOpcode::G_FMUL*//*Label 35*/ GIMT_Encode4(109981),
    /*TargetOpcode::G_FMA*//*Label 36*/ GIMT_Encode4(110962), GIMT_Encode4(0),
    /*TargetOpcode::G_FDIV*//*Label 37*/ GIMT_Encode4(113053), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FNEG*//*Label 38*/ GIMT_Encode4(113218),
    /*TargetOpcode::G_FPEXT*//*Label 39*/ GIMT_Encode4(114749),
    /*TargetOpcode::G_FPTRUNC*//*Label 40*/ GIMT_Encode4(114985),
    /*TargetOpcode::G_FPTOSI*//*Label 41*/ GIMT_Encode4(115257),
    /*TargetOpcode::G_FPTOUI*//*Label 42*/ GIMT_Encode4(116591),
    /*TargetOpcode::G_SITOFP*//*Label 43*/ GIMT_Encode4(117925),
    /*TargetOpcode::G_UITOFP*//*Label 44*/ GIMT_Encode4(118577), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FABS*//*Label 45*/ GIMT_Encode4(119229), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FMINNUM*//*Label 46*/ GIMT_Encode4(120005),
    /*TargetOpcode::G_FMAXNUM*//*Label 47*/ GIMT_Encode4(120597), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FMINIMUM*//*Label 48*/ GIMT_Encode4(121189),
    /*TargetOpcode::G_FMAXIMUM*//*Label 49*/ GIMT_Encode4(121923),
    /*TargetOpcode::G_GET_FPENV*//*Label 50*/ GIMT_Encode4(122657),
    /*TargetOpcode::G_SET_FPENV*//*Label 51*/ GIMT_Encode4(122690),
    /*TargetOpcode::G_RESET_FPENV*//*Label 52*/ GIMT_Encode4(122726),
    /*TargetOpcode::G_GET_FPMODE*//*Label 53*/ GIMT_Encode4(122855), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SMIN*//*Label 54*/ GIMT_Encode4(122888),
    /*TargetOpcode::G_SMAX*//*Label 55*/ GIMT_Encode4(123431),
    /*TargetOpcode::G_UMIN*//*Label 56*/ GIMT_Encode4(123974),
    /*TargetOpcode::G_UMAX*//*Label 57*/ GIMT_Encode4(124895),
    /*TargetOpcode::G_ABS*//*Label 58*/ GIMT_Encode4(125816), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BR*//*Label 59*/ GIMT_Encode4(126287), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INSERT_VECTOR_ELT*//*Label 60*/ GIMT_Encode4(126360),
    /*TargetOpcode::G_EXTRACT_VECTOR_ELT*//*Label 61*/ GIMT_Encode4(126660), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CTLZ*//*Label 62*/ GIMT_Encode4(126717), GIMT_Encode4(0),
    /*TargetOpcode::G_CTPOP*//*Label 63*/ GIMT_Encode4(127278),
    /*TargetOpcode::G_BSWAP*//*Label 64*/ GIMT_Encode4(127386),
    /*TargetOpcode::G_BITREVERSE*//*Label 65*/ GIMT_Encode4(127676),
    /*TargetOpcode::G_FCEIL*//*Label 66*/ GIMT_Encode4(128108), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FSQRT*//*Label 67*/ GIMT_Encode4(128371),
    /*TargetOpcode::G_FFLOOR*//*Label 68*/ GIMT_Encode4(128509),
    /*TargetOpcode::G_FRINT*//*Label 69*/ GIMT_Encode4(128772),
    /*TargetOpcode::G_FNEARBYINT*//*Label 70*/ GIMT_Encode4(129068), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_TRAP*//*Label 71*/ GIMT_Encode4(129206),
    /*TargetOpcode::G_DEBUGTRAP*//*Label 72*/ GIMT_Encode4(129252), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_VECREDUCE_ADD*//*Label 73*/ GIMT_Encode4(129339), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_VECREDUCE_SMAX*//*Label 74*/ GIMT_Encode4(129760),
    /*TargetOpcode::G_VECREDUCE_SMIN*//*Label 75*/ GIMT_Encode4(130040),
    /*TargetOpcode::G_VECREDUCE_UMAX*//*Label 76*/ GIMT_Encode4(130329),
    /*TargetOpcode::G_VECREDUCE_UMIN*//*Label 77*/ GIMT_Encode4(130610),
    // Label 0: @1014
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 88*/ GIMT_Encode4(10340),
    /*GILLT_s32*//*Label 79*/ GIMT_Encode4(1085),
    /*GILLT_s64*//*Label 80*/ GIMT_Encode4(6861), GIMT_Encode4(0),
    /*GILLT_v2s32*//*Label 81*/ GIMT_Encode4(6908),
    /*GILLT_v2s64*//*Label 82*/ GIMT_Encode4(7093), GIMT_Encode4(0),
    /*GILLT_v4s16*//*Label 83*/ GIMT_Encode4(7804),
    /*GILLT_v4s32*//*Label 84*/ GIMT_Encode4(7989), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s8*//*Label 85*/ GIMT_Encode4(8945),
    /*GILLT_v8s16*//*Label 86*/ GIMT_Encode4(9130), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s8*//*Label 87*/ GIMT_Encode4(10086),
    // Label 79: @1085
    GIM_Try, /*On fail goto*//*Label 89*/ GIMT_Encode4(6860),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 90*/ GIMT_Encode4(1171), // Rule ID 5650 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (UXTAB:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTAB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5650,
        GIR_EraseRootFromParent_Done,
      // Label 90: @1171
      GIM_Try, /*On fail goto*//*Label 91*/ GIMT_Encode4(1246), // Rule ID 5651 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (UXTAH:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTAH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5651,
        GIR_EraseRootFromParent_Done,
      // Label 91: @1246
      GIM_Try, /*On fail goto*//*Label 92*/ GIMT_Encode4(1321), // Rule ID 5685 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2UXTAB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTAB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5685,
        GIR_EraseRootFromParent_Done,
      // Label 92: @1321
      GIM_Try, /*On fail goto*//*Label 93*/ GIMT_Encode4(1396), // Rule ID 5686 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2UXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTAH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5686,
        GIR_EraseRootFromParent_Done,
      // Label 93: @1396
      GIM_Try, /*On fail goto*//*Label 94*/ GIMT_Encode4(1471), // Rule ID 1995 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }))  =>  (UXTAB:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTAB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1995,
        GIR_EraseRootFromParent_Done,
      // Label 94: @1471
      GIM_Try, /*On fail goto*//*Label 95*/ GIMT_Encode4(1546), // Rule ID 1996 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }))  =>  (UXTAH:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTAH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1996,
        GIR_EraseRootFromParent_Done,
      // Label 95: @1546
      GIM_Try, /*On fail goto*//*Label 96*/ GIMT_Encode4(1621), // Rule ID 2227 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] }))  =>  (t2UXTAB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTAB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2227,
        GIR_EraseRootFromParent_Done,
      // Label 96: @1621
      GIM_Try, /*On fail goto*//*Label 97*/ GIMT_Encode4(1696), // Rule ID 2228 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] }))  =>  (t2UXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTAH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2228,
        GIR_EraseRootFromParent_Done,
      // Label 97: @1696
      GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(1824), // Rule ID 5661 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 8,
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (add:{ *:[i32] } (sext_inreg:{ *:[i32] } (or:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 8:{ *:[i32] })), i16:{ *:[Other] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2SXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 3:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SXTAH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5661,
        GIR_EraseRootFromParent_Done,
      // Label 98: @1824
      GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(1952), // Rule ID 5662 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 8,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 24,
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (add:{ *:[i32] } (sext_inreg:{ *:[i32] } (or:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] })), i16:{ *:[Other] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2SXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 3:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SXTAH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5662,
        GIR_EraseRootFromParent_Done,
      // Label 99: @1952
      GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(2080), // Rule ID 2094 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 24,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 8,
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (sext_inreg:{ *:[i32] } (or:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 8:{ *:[i32] })), i16:{ *:[Other] }))  =>  (t2SXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 3:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SXTAH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2094,
        GIR_EraseRootFromParent_Done,
      // Label 100: @2080
      GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(2208), // Rule ID 5660 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_OR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 8,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/2, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/3, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 24,
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (sext_inreg:{ *:[i32] } (or:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] })), i16:{ *:[Other] }))  =>  (t2SXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 3:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SXTAH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5660,
        GIR_EraseRootFromParent_Done,
      // Label 101: @2208
      GIM_Try, /*On fail goto*//*Label 102*/ GIMT_Encode4(2318), // Rule ID 5429 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } (mul:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 16:{ *:[i32] })), GPR:{ *:[i32] }:$Ra)  =>  (SMLATT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMLATT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5429,
        GIR_EraseRootFromParent_Done,
      // Label 102: @2318
      GIM_Try, /*On fail goto*//*Label 103*/ GIMT_Encode4(2428), // Rule ID 5466 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] })), rGPR:{ *:[i32] }:$Ra)  =>  (t2SMLATT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMLATT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5466,
        GIR_EraseRootFromParent_Done,
      // Label 103: @2428
      GIM_Try, /*On fail goto*//*Label 104*/ GIMT_Encode4(2538), // Rule ID 192 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 16:{ *:[i32] })))  =>  (SMLATT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMLATT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 192,
        GIR_EraseRootFromParent_Done,
      // Label 104: @2538
      GIM_Try, /*On fail goto*//*Label 105*/ GIMT_Encode4(2648), // Rule ID 521 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] })))  =>  (t2SMLATT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMLATT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 521,
        GIR_EraseRootFromParent_Done,
      // Label 105: @2648
      GIM_Try, /*On fail goto*//*Label 106*/ GIMT_Encode4(2761), // Rule ID 5428 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // MIs[3] Operand 2
        GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } (mul:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 16:{ *:[i32] }), (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, i16:{ *:[Other] })), GPR:{ *:[i32] }:$Ra)  =>  (SMLABT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMLABT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5428,
        GIR_EraseRootFromParent_Done,
      // Label 106: @2761
      GIM_Try, /*On fail goto*//*Label 107*/ GIMT_Encode4(2874), // Rule ID 5465 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[3] Operand 2
        GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] }), (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, i16:{ *:[Other] })), rGPR:{ *:[i32] }:$Ra)  =>  (t2SMLABT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMLABT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5465,
        GIR_EraseRootFromParent_Done,
      // Label 107: @2874
      GIM_Try, /*On fail goto*//*Label 108*/ GIMT_Encode4(2987), // Rule ID 5427 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // MIs[2] Operand 2
        GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 16:{ *:[i32] })), GPR:{ *:[i32] }:$Ra)  =>  (SMLABT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMLABT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5427,
        GIR_EraseRootFromParent_Done,
      // Label 108: @2987
      GIM_Try, /*On fail goto*//*Label 109*/ GIMT_Encode4(3100), // Rule ID 5464 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[2] Operand 2
        GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] })), rGPR:{ *:[i32] }:$Ra)  =>  (t2SMLABT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMLABT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5464,
        GIR_EraseRootFromParent_Done,
      // Label 109: @3100
      GIM_Try, /*On fail goto*//*Label 110*/ GIMT_Encode4(3213), // Rule ID 191 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // MIs[3] Operand 2
        GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, i16:{ *:[Other] })))  =>  (SMLATB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMLATB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 191,
        GIR_EraseRootFromParent_Done,
      // Label 110: @3213
      GIM_Try, /*On fail goto*//*Label 111*/ GIMT_Encode4(3326), // Rule ID 520 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[3] Operand 2
        GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, i16:{ *:[Other] })))  =>  (t2SMLATB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMLATB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 520,
        GIR_EraseRootFromParent_Done,
      // Label 111: @3326
      GIM_Try, /*On fail goto*//*Label 112*/ GIMT_Encode4(3439), // Rule ID 190 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // MIs[2] Operand 2
        GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 16:{ *:[i32] })))  =>  (SMLABT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMLABT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 190,
        GIR_EraseRootFromParent_Done,
      // Label 112: @3439
      GIM_Try, /*On fail goto*//*Label 113*/ GIMT_Encode4(3552), // Rule ID 519 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[2] Operand 2
        GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] })))  =>  (t2SMLABT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMLABT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 519,
        GIR_EraseRootFromParent_Done,
      // Label 113: @3552
      GIM_Try, /*On fail goto*//*Label 114*/ GIMT_Encode4(3643), // Rule ID 5659 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ROTR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } (sext_inreg:{ *:[i32] } (rotr:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), i16:{ *:[Other] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2SXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 3:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SXTAH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5659,
        GIR_EraseRootFromParent_Done,
      // Label 114: @3643
      GIM_Try, /*On fail goto*//*Label 115*/ GIMT_Encode4(3734), // Rule ID 2093 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ROTR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (sext_inreg:{ *:[i32] } (rotr:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), i16:{ *:[Other] }))  =>  (t2SXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 3:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SXTAH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2093,
        GIR_EraseRootFromParent_Done,
      // Label 115: @3734
      GIM_Try, /*On fail goto*//*Label 116*/ GIMT_Encode4(3850), // Rule ID 5426 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // MIs[2] Operand 2
        GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // MIs[3] Operand 2
        GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, i16:{ *:[Other] })), GPR:{ *:[i32] }:$Ra)  =>  (SMLABB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMLABB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5426,
        GIR_EraseRootFromParent_Done,
      // Label 116: @3850
      GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(3966), // Rule ID 5463 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[2] Operand 2
        GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[3] Operand 2
        GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, i16:{ *:[Other] })), rGPR:{ *:[i32] }:$Ra)  =>  (t2SMLABB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMLABB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5463,
        GIR_EraseRootFromParent_Done,
      // Label 117: @3966
      GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(4082), // Rule ID 189 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // MIs[2] Operand 2
        GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // MIs[3] Operand 2
        GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, i16:{ *:[Other] })))  =>  (SMLABB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMLABB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 189,
        GIR_EraseRootFromParent_Done,
      // Label 118: @4082
      GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(4198), // Rule ID 518 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[2] Operand 2
        GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[3] Operand 2
        GIM_CheckLiteralInt, /*MI*/3, /*Op*/2, GIMT_Encode8(16),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, i16:{ *:[Other] })))  =>  (t2SMLABB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMLABB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 518,
        GIR_EraseRootFromParent_Done,
      // Label 119: @4198
      GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(4286), // Rule ID 3228 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } (vecreduce_add:{ *:[i32] } (mul:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$src1, MQPR:{ *:[v4i32] }:$src2)), tGPREven:{ *:[i32] }:$src3)  =>  (MVE_VMLADAVau32:{ *:[i32] } ?:{ *:[i32] }:$src3, ?:{ *:[v4i32] }:$src1, ?:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMLADAVau32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RdaDest]
        GIR_RootToRootCopy, /*OpIdx*/2, // src3
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3228,
        GIR_EraseRootFromParent_Done,
      // Label 120: @4286
      GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(4374), // Rule ID 3229 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } (vecreduce_add:{ *:[i32] } (mul:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$src1, MQPR:{ *:[v8i16] }:$src2)), tGPREven:{ *:[i32] }:$src3)  =>  (MVE_VMLADAVau16:{ *:[i32] } ?:{ *:[i32] }:$src3, ?:{ *:[v8i16] }:$src1, ?:{ *:[v8i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMLADAVau16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RdaDest]
        GIR_RootToRootCopy, /*OpIdx*/2, // src3
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3229,
        GIR_EraseRootFromParent_Done,
      // Label 121: @4374
      GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(4462), // Rule ID 3232 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } (vecreduce_add:{ *:[i32] } (mul:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$src1, MQPR:{ *:[v16i8] }:$src2)), tGPREven:{ *:[i32] }:$src3)  =>  (MVE_VMLADAVau8:{ *:[i32] } ?:{ *:[i32] }:$src3, ?:{ *:[v16i8] }:$src1, ?:{ *:[v16i8] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMLADAVau8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RdaDest]
        GIR_RootToRootCopy, /*OpIdx*/2, // src3
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3232,
        GIR_EraseRootFromParent_Done,
      // Label 122: @4462
      GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(4550), // Rule ID 5930 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } tGPREven:{ *:[i32] }:$src3, (vecreduce_add:{ *:[i32] } (mul:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$src1, MQPR:{ *:[v4i32] }:$src2)))  =>  (MVE_VMLADAVau32:{ *:[i32] } ?:{ *:[i32] }:$src3, ?:{ *:[v4i32] }:$src1, ?:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMLADAVau32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RdaDest]
        GIR_RootToRootCopy, /*OpIdx*/1, // src3
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5930,
        GIR_EraseRootFromParent_Done,
      // Label 123: @4550
      GIM_Try, /*On fail goto*//*Label 124*/ GIMT_Encode4(4638), // Rule ID 5931 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } tGPREven:{ *:[i32] }:$src3, (vecreduce_add:{ *:[i32] } (mul:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$src1, MQPR:{ *:[v8i16] }:$src2)))  =>  (MVE_VMLADAVau16:{ *:[i32] } ?:{ *:[i32] }:$src3, ?:{ *:[v8i16] }:$src1, ?:{ *:[v8i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMLADAVau16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RdaDest]
        GIR_RootToRootCopy, /*OpIdx*/1, // src3
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5931,
        GIR_EraseRootFromParent_Done,
      // Label 124: @4638
      GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(4726), // Rule ID 5934 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[i32] } tGPREven:{ *:[i32] }:$src3, (vecreduce_add:{ *:[i32] } (mul:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$src1, MQPR:{ *:[v16i8] }:$src2)))  =>  (MVE_VMLADAVau8:{ *:[i32] } ?:{ *:[i32] }:$src3, ?:{ *:[v16i8] }:$src1, ?:{ *:[v16i8] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMLADAVau8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[RdaDest]
        GIR_RootToRootCopy, /*OpIdx*/1, // src3
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5934,
        GIR_EraseRootFromParent_Done,
      // Label 125: @4726
      GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(4783), // Rule ID 72 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (ADDri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::ADDri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 72,
        GIR_EraseRootFromParent_Done,
      // Label 126: @4783
      GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(4840), // Rule ID 303 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_7),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } tGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm0_7>>:$imm3)  =>  (tADDi3:{ *:[i32] } tGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$imm3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tADDi3),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
        GIR_RootToRootCopy, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm3
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 303,
        GIR_EraseRootFromParent_Done,
      // Label 127: @4840
      GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(4897), // Rule ID 304 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_255_expr),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_imm0_255_expr>>:$imm8)  =>  (tADDi8:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm8)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tADDi8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm8
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 304,
        GIR_EraseRootFromParent_Done,
      // Label 128: @4897
      GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(4954), // Rule ID 407 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2ADDri:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ADDri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 407,
        GIR_EraseRootFromParent_Done,
      // Label 129: @4954
      GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(5005), // Rule ID 408 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_4095),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_imm0_4095>>:$imm)  =>  (t2ADDri12:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ADDri12),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 408,
        GIR_EraseRootFromParent_Done,
      // Label 130: @5005
      GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(5081), // Rule ID 171 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm), GPRnopc:{ *:[i32] }:$Ra)  =>  (MLA:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MLA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 171,
        GIR_EraseRootFromParent_Done,
      // Label 131: @5081
      GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(5157), // Rule ID 172 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM_NoV6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm), GPRnopc:{ *:[i32] }:$Ra)  =>  (MLAv5:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MLAv5),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 172,
        GIR_EraseRootFromParent_Done,
      // Label 132: @5157
      GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(5227), // Rule ID 503 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm), rGPR:{ *:[i32] }:$Ra)  =>  (t2MLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MLA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 503,
        GIR_EraseRootFromParent_Done,
      // Label 133: @5227
      GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(5298), // Rule ID 5652 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, i8:{ *:[Other] }), GPR:{ *:[i32] }:$Rn)  =>  (SXTAB:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SXTAB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5652,
        GIR_EraseRootFromParent_Done,
      // Label 134: @5298
      GIM_Try, /*On fail goto*//*Label 135*/ GIMT_Encode4(5369), // Rule ID 5653 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, i16:{ *:[Other] }), GPR:{ *:[i32] }:$Rn)  =>  (SXTAH:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SXTAH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5653,
        GIR_EraseRootFromParent_Done,
      // Label 135: @5369
      GIM_Try, /*On fail goto*//*Label 136*/ GIMT_Encode4(5440), // Rule ID 5687 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, i8:{ *:[Other] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2SXTAB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SXTAB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5687,
        GIR_EraseRootFromParent_Done,
      // Label 136: @5440
      GIM_Try, /*On fail goto*//*Label 137*/ GIMT_Encode4(5511), // Rule ID 5688 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, i16:{ *:[Other] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2SXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SXTAH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5688,
        GIR_EraseRootFromParent_Done,
      // Label 137: @5511
      GIM_Try, /*On fail goto*//*Label 138*/ GIMT_Encode4(5581), // Rule ID 180 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SMULH),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mulhs:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm), GPR:{ *:[i32] }:$Ra)  =>  (SMMLA:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMMLA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 180,
        GIR_EraseRootFromParent_Done,
      // Label 138: @5581
      GIM_Try, /*On fail goto*//*Label 139*/ GIMT_Encode4(5651), // Rule ID 509 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SMULH),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (mulhs:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn), rGPR:{ *:[i32] }:$Ra)  =>  (t2SMMLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMMLA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/2, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 509,
        GIR_EraseRootFromParent_Done,
      // Label 139: @5651
      GIM_Try, /*On fail goto*//*Label 140*/ GIMT_Encode4(5714), // Rule ID 3033 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (vecreduce_add:{ *:[i32] } MQPR:{ *:[v16i8] }:$vec), tGPREven:{ *:[i32] }:$acc)  =>  (MVE_VADDVu8acc:{ *:[i32] } ?:{ *:[i32] }:$acc, ?:{ *:[v16i8] }:$vec)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDVu8acc),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rda]
        GIR_RootToRootCopy, /*OpIdx*/2, // acc
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vec
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3033,
        GIR_EraseRootFromParent_Done,
      // Label 140: @5714
      GIM_Try, /*On fail goto*//*Label 141*/ GIMT_Encode4(5777), // Rule ID 3061 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (vecreduce_add:{ *:[i32] } MQPR:{ *:[v8i16] }:$vec), tGPREven:{ *:[i32] }:$acc)  =>  (MVE_VADDVu16acc:{ *:[i32] } ?:{ *:[i32] }:$acc, ?:{ *:[v8i16] }:$vec)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDVu16acc),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rda]
        GIR_RootToRootCopy, /*OpIdx*/2, // acc
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vec
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3061,
        GIR_EraseRootFromParent_Done,
      // Label 141: @5777
      GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(5840), // Rule ID 3071 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } (vecreduce_add:{ *:[i32] } MQPR:{ *:[v4i32] }:$vec), tGPREven:{ *:[i32] }:$acc)  =>  (MVE_VADDVu32acc:{ *:[i32] } ?:{ *:[i32] }:$acc, ?:{ *:[v4i32] }:$vec)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDVu32acc),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rda]
        GIR_RootToRootCopy, /*OpIdx*/2, // acc
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vec
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3071,
        GIR_EraseRootFromParent_Done,
      // Label 142: @5840
      GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(5916), // Rule ID 5423 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Ra, (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm))  =>  (MLA:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MLA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5423,
        GIR_EraseRootFromParent_Done,
      // Label 143: @5916
      GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(5992), // Rule ID 5424 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM_NoV6),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Ra, (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm))  =>  (MLAv5:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MLAv5),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5424,
        GIR_EraseRootFromParent_Done,
      // Label 144: @5992
      GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(6062), // Rule ID 5461 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm))  =>  (t2MLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MLA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5461,
        GIR_EraseRootFromParent_Done,
      // Label 145: @6062
      GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(6133), // Rule ID 1999 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, i8:{ *:[Other] }))  =>  (SXTAB:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SXTAB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1999,
        GIR_EraseRootFromParent_Done,
      // Label 146: @6133
      GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(6204), // Rule ID 2000 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (sext_inreg:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, i16:{ *:[Other] }))  =>  (SXTAH:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SXTAH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2000,
        GIR_EraseRootFromParent_Done,
      // Label 147: @6204
      GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(6275), // Rule ID 2231 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, i8:{ *:[Other] }))  =>  (t2SXTAB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SXTAB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2231,
        GIR_EraseRootFromParent_Done,
      // Label 148: @6275
      GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(6346), // Rule ID 2232 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, i16:{ *:[Other] }))  =>  (t2SXTAH:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SXTAH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2232,
        GIR_EraseRootFromParent_Done,
      // Label 149: @6346
      GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(6416), // Rule ID 5425 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SMULH),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mulhs:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm))  =>  (SMMLA:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMMLA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5425,
        GIR_EraseRootFromParent_Done,
      // Label 150: @6416
      GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(6486), // Rule ID 5462 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SMULH),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mulhs:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Rn))  =>  (t2SMMLA:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMMLA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5462,
        GIR_EraseRootFromParent_Done,
      // Label 151: @6486
      GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(6549), // Rule ID 5906 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } tGPREven:{ *:[i32] }:$acc, (vecreduce_add:{ *:[i32] } MQPR:{ *:[v16i8] }:$vec))  =>  (MVE_VADDVu8acc:{ *:[i32] } ?:{ *:[i32] }:$acc, ?:{ *:[v16i8] }:$vec)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDVu8acc),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rda]
        GIR_RootToRootCopy, /*OpIdx*/1, // acc
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vec
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5906,
        GIR_EraseRootFromParent_Done,
      // Label 152: @6549
      GIM_Try, /*On fail goto*//*Label 153*/ GIMT_Encode4(6612), // Rule ID 5920 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } tGPREven:{ *:[i32] }:$acc, (vecreduce_add:{ *:[i32] } MQPR:{ *:[v8i16] }:$vec))  =>  (MVE_VADDVu16acc:{ *:[i32] } ?:{ *:[i32] }:$acc, ?:{ *:[v8i16] }:$vec)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDVu16acc),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rda]
        GIR_RootToRootCopy, /*OpIdx*/1, // acc
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vec
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5920,
        GIR_EraseRootFromParent_Done,
      // Label 153: @6612
      GIM_Try, /*On fail goto*//*Label 154*/ GIMT_Encode4(6675), // Rule ID 5925 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPREvenRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_VECREDUCE_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } tGPREven:{ *:[i32] }:$acc, (vecreduce_add:{ *:[i32] } MQPR:{ *:[v4i32] }:$vec))  =>  (MVE_VADDVu32acc:{ *:[i32] } ?:{ *:[i32] }:$acc, ?:{ *:[v4i32] }:$vec)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDVu32acc),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rda]
        GIR_RootToRootCopy, /*OpIdx*/1, // acc
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // vec
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5925,
        GIR_EraseRootFromParent_Done,
      // Label 154: @6675
      GIM_Try, /*On fail goto*//*Label 155*/ GIMT_Encode4(6721), // Rule ID 73 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (add:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (ADDrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::ADDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 73,
        GIR_EraseRootFromParent_Done,
      // Label 155: @6721
      GIM_Try, /*On fail goto*//*Label 156*/ GIMT_Encode4(6767), // Rule ID 305 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        // (add:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)  =>  (tADDrr:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tADDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 305,
        GIR_EraseRootFromParent_Done,
      // Label 156: @6767
      GIM_Try, /*On fail goto*//*Label 157*/ GIMT_Encode4(6813), // Rule ID 409 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (add:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2ADDrr:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ADDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 409,
        GIR_EraseRootFromParent_Done,
      // Label 157: @6813
      GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(6859), // Rule ID 5443 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // (add:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, GPRnopc:{ *:[i32] }:$Rn)  =>  (t2ADDrr:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ADDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_RootToRootCopy, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5443,
        GIR_EraseRootFromParent_Done,
      // Label 158: @6859
      GIM_Reject,
    // Label 89: @6860
    GIM_Reject,
    // Label 80: @6861
    GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(6907), // Rule ID 759 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (add:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VADDv1i64:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv1i64),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // Vn
      GIR_RootToRootCopy, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 759,
      GIR_EraseRootFromParent_Done,
    // Label 159: @6907
    GIM_Reject,
    // Label 81: @6908
    GIM_Try, /*On fail goto*//*Label 160*/ GIMT_Encode4(7092),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(6989), // Rule ID 5512 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i32] } (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm), DPR:{ *:[v2i32] }:$src1)  =>  (VMLAv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5512,
        GIR_EraseRootFromParent_Done,
      // Label 161: @6989
      GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(7055), // Rule ID 886 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VMLAv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 886,
        GIR_EraseRootFromParent_Done,
      // Label 162: @7055
      GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(7091), // Rule ID 755 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (add:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VADDv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 755,
        GIR_EraseRootFromParent_Done,
      // Label 163: @7091
      GIM_Reject,
    // Label 160: @7092
    GIM_Reject,
    // Label 82: @7093
    GIM_Try, /*On fail goto*//*Label 164*/ GIMT_Encode4(7803),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(7176), // Rule ID 779 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 779,
        GIR_EraseRootFromParent_Done,
      // Label 165: @7176
      GIM_Try, /*On fail goto*//*Label 166*/ GIMT_Encode4(7244), // Rule ID 778 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 778,
        GIR_EraseRootFromParent_Done,
      // Label 166: @7244
      GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(7312), // Rule ID 767 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLsv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLsv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 767,
        GIR_EraseRootFromParent_Done,
      // Label 167: @7312
      GIM_Try, /*On fail goto*//*Label 168*/ GIMT_Encode4(7380), // Rule ID 777 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 777,
        GIR_EraseRootFromParent_Done,
      // Label 168: @7380
      GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(7448), // Rule ID 776 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 776,
        GIR_EraseRootFromParent_Done,
      // Label 169: @7448
      GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(7501), // Rule ID 5491 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm), QPR:{ *:[v2i64] }:$Vn)  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5491,
        GIR_EraseRootFromParent_Done,
      // Label 170: @7501
      GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(7554), // Rule ID 5485 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm), QPR:{ *:[v2i64] }:$Vn)  =>  (VADDWsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWsv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5485,
        GIR_EraseRootFromParent_Done,
      // Label 171: @7554
      GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(7607), // Rule ID 5490 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm), QPR:{ *:[v2i64] }:$Vn)  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5490,
        GIR_EraseRootFromParent_Done,
      // Label 172: @7607
      GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(7660), // Rule ID 788 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 788,
        GIR_EraseRootFromParent_Done,
      // Label 173: @7660
      GIM_Try, /*On fail goto*//*Label 174*/ GIMT_Encode4(7713), // Rule ID 782 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDWsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWsv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 782,
        GIR_EraseRootFromParent_Done,
      // Label 174: @7713
      GIM_Try, /*On fail goto*//*Label 175*/ GIMT_Encode4(7766), // Rule ID 787 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VADDWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 787,
        GIR_EraseRootFromParent_Done,
      // Label 175: @7766
      GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(7802), // Rule ID 760 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (add:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VADDv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 760,
        GIR_EraseRootFromParent_Done,
      // Label 176: @7802
      GIM_Reject,
    // Label 164: @7803
    GIM_Reject,
    // Label 83: @7804
    GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(7988),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(7885), // Rule ID 5511 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i16] } (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm), DPR:{ *:[v4i16] }:$src1)  =>  (VMLAv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5511,
        GIR_EraseRootFromParent_Done,
      // Label 178: @7885
      GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(7951), // Rule ID 885 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VMLAv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 885,
        GIR_EraseRootFromParent_Done,
      // Label 179: @7951
      GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(7987), // Rule ID 754 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (add:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VADDv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 754,
        GIR_EraseRootFromParent_Done,
      // Label 180: @7987
      GIM_Reject,
    // Label 177: @7988
    GIM_Reject,
    // Label 84: @7989
    GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(8944),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(8072), // Rule ID 775 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 775,
        GIR_EraseRootFromParent_Done,
      // Label 182: @8072
      GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(8144), // Rule ID 774 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 774,
        GIR_EraseRootFromParent_Done,
      // Label 183: @8144
      GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(8216), // Rule ID 766 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLsv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLsv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 766,
        GIR_EraseRootFromParent_Done,
      // Label 184: @8216
      GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(8288), // Rule ID 773 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 773,
        GIR_EraseRootFromParent_Done,
      // Label 185: @8288
      GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(8360), // Rule ID 772 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 772,
        GIR_EraseRootFromParent_Done,
      // Label 186: @8360
      GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(8430), // Rule ID 5515 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm), QPR:{ *:[v4i32] }:$src1)  =>  (VMLAv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5515,
        GIR_EraseRootFromParent_Done,
      // Label 187: @8430
      GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(8487), // Rule ID 5489 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm), QPR:{ *:[v4i32] }:$Vn)  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5489,
        GIR_EraseRootFromParent_Done,
      // Label 188: @8487
      GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(8544), // Rule ID 5484 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm), QPR:{ *:[v4i32] }:$Vn)  =>  (VADDWsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWsv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5484,
        GIR_EraseRootFromParent_Done,
      // Label 189: @8544
      GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(8601), // Rule ID 5488 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm), QPR:{ *:[v4i32] }:$Vn)  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5488,
        GIR_EraseRootFromParent_Done,
      // Label 190: @8601
      GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(8671), // Rule ID 889 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VMLAv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 889,
        GIR_EraseRootFromParent_Done,
      // Label 191: @8671
      GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(8728), // Rule ID 786 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 786,
        GIR_EraseRootFromParent_Done,
      // Label 192: @8728
      GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(8785), // Rule ID 781 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDWsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWsv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 781,
        GIR_EraseRootFromParent_Done,
      // Label 193: @8785
      GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(8842), // Rule ID 785 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VADDWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 785,
        GIR_EraseRootFromParent_Done,
      // Label 194: @8842
      GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(8882), // Rule ID 758 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (add:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VADDv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 758,
        GIR_EraseRootFromParent_Done,
      // Label 195: @8882
      GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(8943), // Rule ID 3476 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (add:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VADDi32:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDi32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3476,
        GIR_EraseRootFromParent_Done,
      // Label 196: @8943
      GIM_Reject,
    // Label 181: @8944
    GIM_Reject,
    // Label 85: @8945
    GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(9129),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(9026), // Rule ID 5510 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i8] } (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm), DPR:{ *:[v8i8] }:$src1)  =>  (VMLAv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5510,
        GIR_EraseRootFromParent_Done,
      // Label 198: @9026
      GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(9092), // Rule ID 884 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm))  =>  (VMLAv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 884,
        GIR_EraseRootFromParent_Done,
      // Label 199: @9092
      GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(9128), // Rule ID 753 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (add:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VADDv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 753,
        GIR_EraseRootFromParent_Done,
      // Label 200: @9128
      GIM_Reject,
    // Label 197: @9129
    GIM_Reject,
    // Label 86: @9130
    GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(10085),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(9213), // Rule ID 771 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 771,
        GIR_EraseRootFromParent_Done,
      // Label 202: @9213
      GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(9285), // Rule ID 770 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 770,
        GIR_EraseRootFromParent_Done,
      // Label 203: @9285
      GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(9357), // Rule ID 765 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLsv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLsv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 765,
        GIR_EraseRootFromParent_Done,
      // Label 204: @9357
      GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(9429), // Rule ID 769 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 769,
        GIR_EraseRootFromParent_Done,
      // Label 205: @9429
      GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(9501), // Rule ID 768 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDLuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 768,
        GIR_EraseRootFromParent_Done,
      // Label 206: @9501
      GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(9571), // Rule ID 5514 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm), QPR:{ *:[v8i16] }:$src1)  =>  (VMLAv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5514,
        GIR_EraseRootFromParent_Done,
      // Label 207: @9571
      GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(9628), // Rule ID 5487 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm), QPR:{ *:[v8i16] }:$Vn)  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5487,
        GIR_EraseRootFromParent_Done,
      // Label 208: @9628
      GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(9685), // Rule ID 5483 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm), QPR:{ *:[v8i16] }:$Vn)  =>  (VADDWsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWsv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5483,
        GIR_EraseRootFromParent_Done,
      // Label 209: @9685
      GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(9742), // Rule ID 5486 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm), QPR:{ *:[v8i16] }:$Vn)  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5486,
        GIR_EraseRootFromParent_Done,
      // Label 210: @9742
      GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(9812), // Rule ID 888 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VMLAv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 888,
        GIR_EraseRootFromParent_Done,
      // Label 211: @9812
      GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(9869), // Rule ID 784 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 784,
        GIR_EraseRootFromParent_Done,
      // Label 212: @9869
      GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(9926), // Rule ID 780 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDWsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWsv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 780,
        GIR_EraseRootFromParent_Done,
      // Label 213: @9926
      GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(9983), // Rule ID 783 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VADDWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDWuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 783,
        GIR_EraseRootFromParent_Done,
      // Label 214: @9983
      GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(10023), // Rule ID 757 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (add:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VADDv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 757,
        GIR_EraseRootFromParent_Done,
      // Label 215: @10023
      GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(10084), // Rule ID 3472 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (add:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VADDi16:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDi16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3472,
        GIR_EraseRootFromParent_Done,
      // Label 216: @10084
      GIM_Reject,
    // Label 201: @10085
    GIM_Reject,
    // Label 87: @10086
    GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(10339),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(10167), // Rule ID 5513 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v16i8] } (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm), QPR:{ *:[v16i8] }:$src1)  =>  (VMLAv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5513,
        GIR_EraseRootFromParent_Done,
      // Label 218: @10167
      GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(10237), // Rule ID 887 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm))  =>  (VMLAv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLAv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 887,
        GIR_EraseRootFromParent_Done,
      // Label 219: @10237
      GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(10277), // Rule ID 756 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (add:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VADDv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VADDv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 756,
        GIR_EraseRootFromParent_Done,
      // Label 220: @10277
      GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(10338), // Rule ID 3468 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (add:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VADDi8:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VADDi8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3468,
        GIR_EraseRootFromParent_Done,
      // Label 221: @10338
      GIM_Reject,
    // Label 217: @10339
    GIM_Reject,
    // Label 88: @10340
    GIM_Reject,
    // Label 1: @10341
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 231*/ GIMT_Encode4(13584),
    /*GILLT_s32*//*Label 222*/ GIMT_Encode4(10412),
    /*GILLT_s64*//*Label 223*/ GIMT_Encode4(11026), GIMT_Encode4(0),
    /*GILLT_v2s32*//*Label 224*/ GIMT_Encode4(11073),
    /*GILLT_v2s64*//*Label 225*/ GIMT_Encode4(11188), GIMT_Encode4(0),
    /*GILLT_v4s16*//*Label 226*/ GIMT_Encode4(11740),
    /*GILLT_v4s32*//*Label 227*/ GIMT_Encode4(11855), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s8*//*Label 228*/ GIMT_Encode4(12570),
    /*GILLT_v8s16*//*Label 229*/ GIMT_Encode4(12685), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s8*//*Label 230*/ GIMT_Encode4(13400),
    // Label 222: @10412
    GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(11025),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(10467), // Rule ID 330 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        // (sub:{ *:[i32] } 0:{ *:[i32] }, tGPR:{ *:[i32] }:$Rn)  =>  (tRSB:{ *:[i32] } tGPR:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tRSB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 330,
        GIR_EraseRootFromParent_Done,
      // Label 233: @10467
      GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(10524), // Rule ID 96 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm, GPR:{ *:[i32] }:$Rn)  =>  (RSBri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::RSBri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 96,
        GIR_EraseRootFromParent_Done,
      // Label 234: @10524
      GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(10581), // Rule ID 427 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, rGPR:{ *:[i32] }:$Rn)  =>  (t2RSBri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2RSBri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 427,
        GIR_EraseRootFromParent_Done,
      // Label 235: @10581
      GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(10638), // Rule ID 76 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (SUBri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SUBri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 76,
        GIR_EraseRootFromParent_Done,
      // Label 236: @10638
      GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(10695), // Rule ID 411 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2SUBri:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SUBri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 411,
        GIR_EraseRootFromParent_Done,
      // Label 237: @10695
      GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(10746), // Rule ID 412 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_4095),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_imm0_4095>>:$imm)  =>  (t2SUBri12:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SUBri12),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 412,
        GIR_EraseRootFromParent_Done,
      // Label 238: @10746
      GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(10816), // Rule ID 173 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6T2_IsARM_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm))  =>  (MLS:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm, GPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MLS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 173,
        GIR_EraseRootFromParent_Done,
      // Label 239: @10816
      GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(10886), // Rule ID 504 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } rGPR:{ *:[i32] }:$Ra, (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm))  =>  (t2MLS:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, rGPR:{ *:[i32] }:$Ra)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MLS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Rm
        GIR_RootToRootCopy, /*OpIdx*/1, // Ra
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 504,
        GIR_EraseRootFromParent_Done,
      // Label 240: @10886
      GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(10932), // Rule ID 77 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (sub:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (SUBrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SUBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 77,
        GIR_EraseRootFromParent_Done,
      // Label 241: @10932
      GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(10978), // Rule ID 333 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        // (sub:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)  =>  (tSUBrr:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tSUBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 333,
        GIR_EraseRootFromParent_Done,
      // Label 242: @10978
      GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(11024), // Rule ID 413 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (sub:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SUBrr:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SUBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 413,
        GIR_EraseRootFromParent_Done,
      // Label 243: @11024
      GIM_Reject,
    // Label 232: @11025
    GIM_Reject,
    // Label 223: @11026
    GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(11072), // Rule ID 963 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (sub:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)  =>  (VSUBv1i64:{ *:[v1i64] } DPR:{ *:[v1i64] }:$Vn, DPR:{ *:[v1i64] }:$Vm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv1i64),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // Vn
      GIR_RootToRootCopy, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 963,
      GIR_EraseRootFromParent_Done,
    // Label 244: @11072
    GIM_Reject,
    // Label 224: @11073
    GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(11187),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(11154), // Rule ID 914 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm))  =>  (VMLSv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$src1, DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLSv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 914,
        GIR_EraseRootFromParent_Done,
      // Label 246: @11154
      GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(11186), // Rule ID 959 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (sub:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VSUBv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 959,
        GIR_EraseRootFromParent_Done,
      // Label 247: @11186
      GIM_Reject,
    // Label 245: @11187
    GIM_Reject,
    // Label 225: @11188
    GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(11739),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(11271), // Rule ID 983 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 983,
        GIR_EraseRootFromParent_Done,
      // Label 249: @11271
      GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(11339), // Rule ID 982 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v2i64] } (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 982,
        GIR_EraseRootFromParent_Done,
      // Label 250: @11339
      GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(11407), // Rule ID 971 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v2i64] } (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLsv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLsv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 971,
        GIR_EraseRootFromParent_Done,
      // Label 251: @11407
      GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(11475), // Rule ID 981 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 981,
        GIR_EraseRootFromParent_Done,
      // Label 252: @11475
      GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(11543), // Rule ID 980 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v2i64] } (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn), (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBLuv2i64:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 980,
        GIR_EraseRootFromParent_Done,
      // Label 253: @11543
      GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(11596), // Rule ID 992 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (anyext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 992,
        GIR_EraseRootFromParent_Done,
      // Label 254: @11596
      GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(11649), // Rule ID 986 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (sext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBWsv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWsv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 986,
        GIR_EraseRootFromParent_Done,
      // Label 255: @11649
      GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(11702), // Rule ID 991 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, (zext:{ *:[v2i64] } DPR:{ *:[v2i32] }:$Vm))  =>  (VSUBWuv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 991,
        GIR_EraseRootFromParent_Done,
      // Label 256: @11702
      GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(11738), // Rule ID 964 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (sub:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)  =>  (VSUBv2i64:{ *:[v2i64] } QPR:{ *:[v2i64] }:$Vn, QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv2i64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 964,
        GIR_EraseRootFromParent_Done,
      // Label 257: @11738
      GIM_Reject,
    // Label 248: @11739
    GIM_Reject,
    // Label 226: @11740
    GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(11854),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(11821), // Rule ID 913 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm))  =>  (VMLSv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$src1, DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLSv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 913,
        GIR_EraseRootFromParent_Done,
      // Label 259: @11821
      GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(11853), // Rule ID 958 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (sub:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VSUBv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 958,
        GIR_EraseRootFromParent_Done,
      // Label 260: @11853
      GIM_Reject,
    // Label 258: @11854
    GIM_Reject,
    // Label 227: @11855
    GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(12569),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(11938), // Rule ID 979 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 979,
        GIR_EraseRootFromParent_Done,
      // Label 262: @11938
      GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(12010), // Rule ID 978 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v4i32] } (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 978,
        GIR_EraseRootFromParent_Done,
      // Label 263: @12010
      GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(12082), // Rule ID 970 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v4i32] } (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLsv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLsv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 970,
        GIR_EraseRootFromParent_Done,
      // Label 264: @12082
      GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(12154), // Rule ID 977 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 977,
        GIR_EraseRootFromParent_Done,
      // Label 265: @12154
      GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(12226), // Rule ID 976 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v4i32] } (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn), (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBLuv4i32:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 976,
        GIR_EraseRootFromParent_Done,
      // Label 266: @12226
      GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(12296), // Rule ID 917 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm))  =>  (VMLSv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$src1, QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLSv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 917,
        GIR_EraseRootFromParent_Done,
      // Label 267: @12296
      GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(12353), // Rule ID 990 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (anyext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 990,
        GIR_EraseRootFromParent_Done,
      // Label 268: @12353
      GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(12410), // Rule ID 985 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (sext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBWsv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWsv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 985,
        GIR_EraseRootFromParent_Done,
      // Label 269: @12410
      GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(12467), // Rule ID 989 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, (zext:{ *:[v4i32] } DPR:{ *:[v4i16] }:$Vm))  =>  (VSUBWuv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 989,
        GIR_EraseRootFromParent_Done,
      // Label 270: @12467
      GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(12507), // Rule ID 962 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (sub:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VSUBv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 962,
        GIR_EraseRootFromParent_Done,
      // Label 271: @12507
      GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(12568), // Rule ID 3488 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (sub:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VSUBi32:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VSUBi32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3488,
        GIR_EraseRootFromParent_Done,
      // Label 272: @12568
      GIM_Reject,
    // Label 261: @12569
    GIM_Reject,
    // Label 228: @12570
    GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(12684),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(12651), // Rule ID 912 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm))  =>  (VMLSv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$src1, DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLSv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 912,
        GIR_EraseRootFromParent_Done,
      // Label 274: @12651
      GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(12683), // Rule ID 957 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (sub:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VSUBv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 957,
        GIR_EraseRootFromParent_Done,
      // Label 275: @12683
      GIM_Reject,
    // Label 273: @12684
    GIM_Reject,
    // Label 229: @12685
    GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(13399),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(12768), // Rule ID 975 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 975,
        GIR_EraseRootFromParent_Done,
      // Label 277: @12768
      GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(12840), // Rule ID 974 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v8i16] } (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 974,
        GIR_EraseRootFromParent_Done,
      // Label 278: @12840
      GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(12912), // Rule ID 969 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v8i16] } (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLsv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLsv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 969,
        GIR_EraseRootFromParent_Done,
      // Label 279: @12912
      GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(12984), // Rule ID 973 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 973,
        GIR_EraseRootFromParent_Done,
      // Label 280: @12984
      GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(13056), // Rule ID 972 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (sub:{ *:[v8i16] } (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn), (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBLuv8i16:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBLuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 972,
        GIR_EraseRootFromParent_Done,
      // Label 281: @13056
      GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(13126), // Rule ID 916 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm))  =>  (VMLSv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$src1, QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLSv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 916,
        GIR_EraseRootFromParent_Done,
      // Label 282: @13126
      GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(13183), // Rule ID 988 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (anyext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 988,
        GIR_EraseRootFromParent_Done,
      // Label 283: @13183
      GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(13240), // Rule ID 984 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (sext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBWsv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWsv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 984,
        GIR_EraseRootFromParent_Done,
      // Label 284: @13240
      GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(13297), // Rule ID 987 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, (zext:{ *:[v8i16] } DPR:{ *:[v8i8] }:$Vm))  =>  (VSUBWuv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBWuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 987,
        GIR_EraseRootFromParent_Done,
      // Label 285: @13297
      GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(13337), // Rule ID 961 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (sub:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VSUBv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 961,
        GIR_EraseRootFromParent_Done,
      // Label 286: @13337
      GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(13398), // Rule ID 3484 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (sub:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VSUBi16:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VSUBi16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3484,
        GIR_EraseRootFromParent_Done,
      // Label 287: @13398
      GIM_Reject,
    // Label 276: @13399
    GIM_Reject,
    // Label 230: @13400
    GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(13583),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(13481), // Rule ID 915 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm))  =>  (VMLSv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$src1, QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMLSv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Vn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 915,
        GIR_EraseRootFromParent_Done,
      // Label 289: @13481
      GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(13521), // Rule ID 960 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (sub:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VSUBv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VSUBv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 960,
        GIR_EraseRootFromParent_Done,
      // Label 290: @13521
      GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(13582), // Rule ID 3480 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (sub:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VSUBi8:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VSUBi8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3480,
        GIR_EraseRootFromParent_Done,
      // Label 291: @13582
      GIM_Reject,
    // Label 288: @13583
    GIM_Reject,
    // Label 231: @13584
    GIM_Reject,
    // Label 2: @13585
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 299*/ GIMT_Encode4(15288),
    /*GILLT_s32*//*Label 292*/ GIMT_Encode4(13656), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s32*//*Label 293*/ GIMT_Encode4(14575), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s16*//*Label 294*/ GIMT_Encode4(14622),
    /*GILLT_v4s32*//*Label 295*/ GIMT_Encode4(14669), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s8*//*Label 296*/ GIMT_Encode4(14898),
    /*GILLT_v8s16*//*Label 297*/ GIMT_Encode4(14945), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s8*//*Label 298*/ GIMT_Encode4(15174),
    // Label 292: @13656
    GIM_Try, /*On fail goto*//*Label 300*/ GIMT_Encode4(14574),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(13755), // Rule ID 186 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[i32] } (sra:{ *:[i32] } GPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 16:{ *:[i32] }))  =>  (SMULTT:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMULTT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 186,
        GIR_EraseRootFromParent_Done,
      // Label 301: @13755
      GIM_Try, /*On fail goto*//*Label 302*/ GIMT_Encode4(13843), // Rule ID 515 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] }))  =>  (t2SMULTT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMULTT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 515,
        GIR_EraseRootFromParent_Done,
      // Label 302: @13843
      GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(13934), // Rule ID 185 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // MIs[2] Operand 2
        GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[i32] } (sra:{ *:[i32] } GPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sext_inreg:{ *:[i32] } GPR:{ *:[i32] }:$Rm, i16:{ *:[Other] }))  =>  (SMULTB:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMULTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 185,
        GIR_EraseRootFromParent_Done,
      // Label 303: @13934
      GIM_Try, /*On fail goto*//*Label 304*/ GIMT_Encode4(14025), // Rule ID 514 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[2] Operand 2
        GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 16:{ *:[i32] }), (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, i16:{ *:[Other] }))  =>  (t2SMULTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMULTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 514,
        GIR_EraseRootFromParent_Done,
      // Label 304: @14025
      GIM_Try, /*On fail goto*//*Label 305*/ GIMT_Encode4(14116), // Rule ID 184 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } GPR:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sra:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 16:{ *:[i32] }))  =>  (SMULBT:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMULBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 184,
        GIR_EraseRootFromParent_Done,
      // Label 305: @14116
      GIM_Try, /*On fail goto*//*Label 306*/ GIMT_Encode4(14207), // Rule ID 513 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16:{ *:[i32] }))  =>  (t2SMULBT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMULBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 513,
        GIR_EraseRootFromParent_Done,
      // Label 306: @14207
      GIM_Try, /*On fail goto*//*Label 307*/ GIMT_Encode4(14301), // Rule ID 183 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV5TE_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // MIs[2] Operand 2
        GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } GPR:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } GPR:{ *:[i32] }:$Rm, i16:{ *:[Other] }))  =>  (SMULBB:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SMULBB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 183,
        GIR_EraseRootFromParent_Done,
      // Label 307: @14301
      GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(14395), // Rule ID 512 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[2] Operand 2
        GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[i32] } (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, i16:{ *:[Other] }), (sext_inreg:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, i16:{ *:[Other] }))  =>  (t2SMULBB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SMULBB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 512,
        GIR_EraseRootFromParent_Done,
      // Label 308: @14395
      GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(14441), // Rule ID 169 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (MUL:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MUL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 169,
        GIR_EraseRootFromParent_Done,
      // Label 309: @14441
      GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(14487), // Rule ID 170 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM_NoV6_UseMulOps),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // (mul:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)  =>  (MULv5:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MULv5),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 170,
        GIR_EraseRootFromParent_Done,
      // Label 310: @14487
      GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(14533), // Rule ID 323 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        // (mul:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)  =>  (tMUL:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tMUL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 323,
        GIR_EraseRootFromParent_Done,
      // Label 311: @14533
      GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(14573), // Rule ID 502 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (mul:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2MUL:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MUL),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 502,
        GIR_EraseRootFromParent_Done,
      // Label 312: @14573
      GIM_Reject,
    // Label 300: @14574
    GIM_Reject,
    // Label 293: @14575
    GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(14621), // Rule ID 834 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (mul:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VMULv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMULv2i32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // Vn
      GIR_RootToRootCopy, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 834,
      GIR_EraseRootFromParent_Done,
    // Label 313: @14621
    GIM_Reject,
    // Label 294: @14622
    GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(14668), // Rule ID 833 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (mul:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)  =>  (VMULv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vn, DPR:{ *:[v4i16] }:$Vm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMULv4i16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // Vn
      GIR_RootToRootCopy, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 833,
      GIR_EraseRootFromParent_Done,
    // Label 314: @14668
    GIM_Reject,
    // Label 295: @14669
    GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(14897),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(14795), // Rule ID 4401 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(16),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // MIs[2] Operand 2
        GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(16),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[v4i32] } (sext_inreg:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$src1, v4i16:{ *:[Other] }), (sext_inreg:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$src2, v4i16:{ *:[Other] }))  =>  (MVE_VMULLBs16:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$src1, MQPR:{ *:[v4i32] }:$src2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMULLBs16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4401,
        GIR_EraseRootFromParent_Done,
      // Label 316: @14795
      GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(14835), // Rule ID 837 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (mul:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VMULv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMULv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 837,
        GIR_EraseRootFromParent_Done,
      // Label 317: @14835
      GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(14896), // Rule ID 3446 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (mul:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VMULi32:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMULi32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3446,
        GIR_EraseRootFromParent_Done,
      // Label 318: @14896
      GIM_Reject,
    // Label 315: @14897
    GIM_Reject,
    // Label 296: @14898
    GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(14944), // Rule ID 832 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (mul:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)  =>  (VMULv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vn, DPR:{ *:[v8i8] }:$Vm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMULv8i8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // Vn
      GIR_RootToRootCopy, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 832,
      GIR_EraseRootFromParent_Done,
    // Label 319: @14944
    GIM_Reject,
    // Label 297: @14945
    GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(15173),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(15071), // Rule ID 4406 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // MIs[1] Operand 2
        GIM_CheckLiteralInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT_INREG),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // MIs[2] Operand 2
        GIM_CheckLiteralInt, /*MI*/2, /*Op*/2, GIMT_Encode8(8),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (mul:{ *:[v8i16] } (sext_inreg:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$src1, v8i8:{ *:[Other] }), (sext_inreg:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$src2, v8i8:{ *:[Other] }))  =>  (MVE_VMULLBs8:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$src1, MQPR:{ *:[v8i16] }:$src2)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMULLBs8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4406,
        GIR_EraseRootFromParent_Done,
      // Label 321: @15071
      GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(15111), // Rule ID 836 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (mul:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)  =>  (VMULv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vn, QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMULv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 836,
        GIR_EraseRootFromParent_Done,
      // Label 322: @15111
      GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(15172), // Rule ID 3442 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (mul:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VMULi16:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMULi16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3442,
        GIR_EraseRootFromParent_Done,
      // Label 323: @15172
      GIM_Reject,
    // Label 320: @15173
    GIM_Reject,
    // Label 298: @15174
    GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(15287),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(15225), // Rule ID 835 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (mul:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)  =>  (VMULv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vn, QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMULv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 835,
        GIR_EraseRootFromParent_Done,
      // Label 325: @15225
      GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(15286), // Rule ID 3438 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (mul:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VMULi8:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VMULi8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3438,
        GIR_EraseRootFromParent_Done,
      // Label 326: @15286
      GIM_Reject,
    // Label 324: @15287
    GIM_Reject,
    // Label 299: @15288
    GIM_Reject,
    // Label 3: @15289
    GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(15384),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(15343), // Rule ID 195 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDivideInARM_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (sdiv:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (SDIV:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SDIV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 195,
        GIR_EraseRootFromParent_Done,
      // Label 328: @15343
      GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(15383), // Rule ID 532 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDivideInThumb_HasV8MBaseline_IsThumb),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (sdiv:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2SDIV:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SDIV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 532,
        GIR_EraseRootFromParent_Done,
      // Label 329: @15383
      GIM_Reject,
    // Label 327: @15384
    GIM_Reject,
    // Label 4: @15385
    GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(15480),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(15439), // Rule ID 196 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDivideInARM_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (udiv:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (UDIV:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UDIV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 196,
        GIR_EraseRootFromParent_Done,
      // Label 331: @15439
      GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(15479), // Rule ID 533 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDivideInThumb_HasV8MBaseline_IsThumb),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (udiv:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UDIV:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UDIV),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 533,
        GIR_EraseRootFromParent_Done,
      // Label 332: @15479
      GIM_Reject,
    // Label 330: @15480
    GIM_Reject,
    // Label 5: @15481
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 346*/ GIMT_Encode4(18660),
    /*GILLT_s32*//*Label 333*/ GIMT_Encode4(15552),
    /*GILLT_s64*//*Label 334*/ GIMT_Encode4(17544),
    /*GILLT_v2s1*//*Label 335*/ GIMT_Encode4(17591),
    /*GILLT_v2s32*//*Label 336*/ GIMT_Encode4(17709),
    /*GILLT_v2s64*//*Label 337*/ GIMT_Encode4(17756),
    /*GILLT_v4s1*//*Label 338*/ GIMT_Encode4(17870),
    /*GILLT_v4s16*//*Label 339*/ GIMT_Encode4(17988),
    /*GILLT_v4s32*//*Label 340*/ GIMT_Encode4(18035), GIMT_Encode4(0),
    /*GILLT_v8s1*//*Label 341*/ GIMT_Encode4(18149),
    /*GILLT_v8s8*//*Label 342*/ GIMT_Encode4(18267),
    /*GILLT_v8s16*//*Label 343*/ GIMT_Encode4(18314), GIMT_Encode4(0),
    /*GILLT_v16s1*//*Label 344*/ GIMT_Encode4(18428),
    /*GILLT_v16s8*//*Label 345*/ GIMT_Encode4(18546),
    // Label 333: @15552
    GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(17543),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(15636), // Rule ID 1852 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(16711935),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$Src, 8:{ *:[i32] }), 16711935:{ *:[i32] })  =>  (UXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTB16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1852,
        GIR_EraseRootFromParent_Done,
      // Label 348: @15636
      GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(15709), // Rule ID 2100 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(16711935),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Src, 8:{ *:[i32] }), 16711935:{ *:[i32] })  =>  (t2UXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Src, 1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTB16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2100,
        GIR_EraseRootFromParent_Done,
      // Label 349: @15709
      GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(15757), // Rule ID 1992 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Src, 255:{ *:[i32] })  =>  (UXTB:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1992,
        GIR_EraseRootFromParent_Done,
      // Label 350: @15757
      GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(15805), // Rule ID 1993 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Src, 65535:{ *:[i32] })  =>  (UXTH:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1993,
        GIR_EraseRootFromParent_Done,
      // Label 351: @15805
      GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(15853), // Rule ID 1994 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(16711935),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Src, 16711935:{ *:[i32] })  =>  (UXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTB16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1994,
        GIR_EraseRootFromParent_Done,
      // Label 352: @15853
      GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(15901), // Rule ID 2224 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] })  =>  (t2UXTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2224,
        GIR_EraseRootFromParent_Done,
      // Label 353: @15901
      GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(15949), // Rule ID 2225 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] })  =>  (t2UXTH:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2225,
        GIR_EraseRootFromParent_Done,
      // Label 354: @15949
      GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(15997), // Rule ID 2226 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(16711935),
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 16711935:{ *:[i32] })  =>  (t2UXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTB16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2226,
        GIR_EraseRootFromParent_Done,
      // Label 355: @15997
      GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(16074), // Rule ID 5419 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm), GPR:{ *:[i32] }:$Rn)  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BICri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5419,
        GIR_EraseRootFromParent_Done,
      // Label 356: @16074
      GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(16151), // Rule ID 5452 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm), rGPR:{ *:[i32] }:$Rn)  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2BICri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5452,
        GIR_EraseRootFromParent_Done,
      // Label 357: @16151
      GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(16228), // Rule ID 5418 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm, -1:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BICri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5418,
        GIR_EraseRootFromParent_Done,
      // Label 358: @16228
      GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(16305), // Rule ID 5451 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2BICri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5451,
        GIR_EraseRootFromParent_Done,
      // Label 359: @16305
      GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(16382), // Rule ID 5417 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm))  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BICri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5417,
        GIR_EraseRootFromParent_Done,
      // Label 360: @16382
      GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(16459), // Rule ID 5450 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm))  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2BICri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5450,
        GIR_EraseRootFromParent_Done,
      // Label 361: @16459
      GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(16536), // Rule ID 159 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm, -1:{ *:[i32] }))  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BICri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 159,
        GIR_EraseRootFromParent_Done,
      // Label 362: @16536
      GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(16613), // Rule ID 490 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }))  =>  (t2BICri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2BICri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 490,
        GIR_EraseRootFromParent_Done,
      // Label 363: @16613
      GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(16684), // Rule ID 5420 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), GPR:{ *:[i32] }:$Rn)  =>  (BICrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BICrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5420,
        GIR_EraseRootFromParent_Done,
      // Label 364: @16684
      GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(16755), // Rule ID 5441 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } tGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), tGPR:{ *:[i32] }:$Rn)  =>  (tBIC:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tBIC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5441,
        GIR_EraseRootFromParent_Done,
      // Label 365: @16755
      GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(16826), // Rule ID 5453 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2BICrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2BICrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5453,
        GIR_EraseRootFromParent_Done,
      // Label 366: @16826
      GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(16897), // Rule ID 160 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (BICrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BICrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 160,
        GIR_EraseRootFromParent_Done,
      // Label 367: @16897
      GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(16968), // Rule ID 313 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } tGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (tBIC:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tBIC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 313,
        GIR_EraseRootFromParent_Done,
      // Label 368: @16968
      GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(17039), // Rule ID 491 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (t2BICrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2BICrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 491,
        GIR_EraseRootFromParent_Done,
      // Label 369: @17039
      GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(17084), // Rule ID 345 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsThumb_IsThumb1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        // (and:{ *:[i32] } tGPR:{ *:[i32] }:$Rm, 255:{ *:[i32] })  =>  (tUXTB:{ *:[i32] } tGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tUXTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 345,
        GIR_EraseRootFromParent_Done,
      // Label 370: @17084
      GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(17129), // Rule ID 346 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsThumb_IsThumb1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } tGPR:{ *:[i32] }:$Rm, 65535:{ *:[i32] })  =>  (tUXTH:{ *:[i32] } tGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tUXTH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 346,
        GIR_EraseRootFromParent_Done,
      // Label 371: @17129
      GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(17188), // Rule ID 1891 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm_not),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_mod_imm_not>><<X:imm_not_XFORM>>:$imm)  =>  (BICri:{ *:[i32] } GPR:{ *:[i32] }:$src, (imm_not_XFORM:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_mod_imm_not>>:$imm))
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BICri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderInvertedImm), // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1891,
        GIR_EraseRootFromParent_Done,
      // Label 372: @17188
      GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(17245), // Rule ID 147 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (ANDri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::ANDri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 147,
        GIR_EraseRootFromParent_Done,
      // Label 373: @17245
      GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(17302), // Rule ID 481 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2ANDri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ANDri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 481,
        GIR_EraseRootFromParent_Done,
      // Label 374: @17302
      GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(17353), // Rule ID 163 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6T2_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_bf_inv_mask_imm),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_bf_inv_mask_imm>>:$imm)  =>  (BFC:{ *:[i32] } GPR:{ *:[i32] }:$src, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::BFC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 163,
        GIR_EraseRootFromParent_Done,
      // Label 375: @17353
      GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(17404), // Rule ID 493 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_bf_inv_mask_imm),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$src, (imm:{ *:[i32] })<<P:Predicate_bf_inv_mask_imm>>:$imm)  =>  (t2BFC:{ *:[i32] } rGPR:{ *:[i32] }:$src, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2BFC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 493,
        GIR_EraseRootFromParent_Done,
      // Label 376: @17404
      GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(17450), // Rule ID 148 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (and:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (ANDrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::ANDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 148,
        GIR_EraseRootFromParent_Done,
      // Label 377: @17450
      GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(17496), // Rule ID 310 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        // (and:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)  =>  (tAND:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tAND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 310,
        GIR_EraseRootFromParent_Done,
      // Label 378: @17496
      GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(17542), // Rule ID 482 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2ANDrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ANDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 482,
        GIR_EraseRootFromParent_Done,
      // Label 379: @17542
      GIM_Reject,
    // Label 347: @17543
    GIM_Reject,
    // Label 334: @17544
    GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(17590), // Rule ID 2506 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (and:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)  =>  (VANDd:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // LHS
      GIR_RootToRootCopy, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2506,
      GIR_EraseRootFromParent_Done,
    // Label 380: @17590
    GIM_Reject,
    // Label 335: @17591
    GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(17708), // Rule ID 1823 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (and:{ *:[v2i1] } VCCR:{ *:[v2i1] }:$p1, VCCR:{ *:[v2i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (t2ANDrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ANDrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1823,
      GIR_EraseRootFromParent_Done,
    // Label 381: @17708
    GIM_Reject,
    // Label 336: @17709
    GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(17755), // Rule ID 1130 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (and:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VANDd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // Vn
      GIR_RootToRootCopy, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1130,
      GIR_EraseRootFromParent_Done,
    // Label 382: @17755
    GIM_Reject,
    // Label 337: @17756
    GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(17869),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(17807), // Rule ID 2509 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (and:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)  =>  (VANDq:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_RootToRootCopy, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2509,
        GIR_EraseRootFromParent_Done,
      // Label 384: @17807
      GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(17868), // Rule ID 3350 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (and:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)  =>  (MVE_VAND:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VAND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3350,
        GIR_EraseRootFromParent_Done,
      // Label 385: @17868
      GIM_Reject,
    // Label 383: @17869
    GIM_Reject,
    // Label 338: @17870
    GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(17987), // Rule ID 1824 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (and:{ *:[v4i1] } VCCR:{ *:[v4i1] }:$p1, VCCR:{ *:[v4i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (t2ANDrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ANDrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1824,
      GIR_EraseRootFromParent_Done,
    // Label 386: @17987
    GIM_Reject,
    // Label 339: @17988
    GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(18034), // Rule ID 2505 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (and:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)  =>  (VANDd:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // LHS
      GIR_RootToRootCopy, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2505,
      GIR_EraseRootFromParent_Done,
    // Label 387: @18034
    GIM_Reject,
    // Label 340: @18035
    GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(18148),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(18086), // Rule ID 1131 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (and:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VANDq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1131,
        GIR_EraseRootFromParent_Done,
      // Label 389: @18086
      GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(18147), // Rule ID 3346 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (and:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VAND:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VAND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3346,
        GIR_EraseRootFromParent_Done,
      // Label 390: @18147
      GIM_Reject,
    // Label 388: @18148
    GIM_Reject,
    // Label 341: @18149
    GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(18266), // Rule ID 1825 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (and:{ *:[v8i1] } VCCR:{ *:[v8i1] }:$p1, VCCR:{ *:[v8i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (t2ANDrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ANDrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1825,
      GIR_EraseRootFromParent_Done,
    // Label 391: @18266
    GIM_Reject,
    // Label 342: @18267
    GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(18313), // Rule ID 2504 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (and:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)  =>  (VANDd:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // LHS
      GIR_RootToRootCopy, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2504,
      GIR_EraseRootFromParent_Done,
    // Label 392: @18313
    GIM_Reject,
    // Label 343: @18314
    GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(18427),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(18365), // Rule ID 2508 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (and:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)  =>  (VANDq:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_RootToRootCopy, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2508,
        GIR_EraseRootFromParent_Done,
      // Label 394: @18365
      GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(18426), // Rule ID 3342 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (and:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VAND:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VAND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3342,
        GIR_EraseRootFromParent_Done,
      // Label 395: @18426
      GIM_Reject,
    // Label 393: @18427
    GIM_Reject,
    // Label 344: @18428
    GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(18545), // Rule ID 1826 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (and:{ *:[v16i1] } VCCR:{ *:[v16i1] }:$p1, VCCR:{ *:[v16i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v16i1] } (t2ANDrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ANDrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1826,
      GIR_EraseRootFromParent_Done,
    // Label 396: @18545
    GIM_Reject,
    // Label 345: @18546
    GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(18659),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(18597), // Rule ID 2507 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (and:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)  =>  (VANDq:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VANDq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_RootToRootCopy, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2507,
        GIR_EraseRootFromParent_Done,
      // Label 398: @18597
      GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(18658), // Rule ID 3338 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (and:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VAND:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VAND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3338,
        GIR_EraseRootFromParent_Done,
      // Label 399: @18658
      GIM_Reject,
    // Label 397: @18659
    GIM_Reject,
    // Label 346: @18660
    GIM_Reject,
    // Label 6: @18661
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 413*/ GIMT_Encode4(24469),
    /*GILLT_s32*//*Label 400*/ GIMT_Encode4(18732),
    /*GILLT_s64*//*Label 401*/ GIMT_Encode4(23353),
    /*GILLT_v2s1*//*Label 402*/ GIMT_Encode4(23400),
    /*GILLT_v2s32*//*Label 403*/ GIMT_Encode4(23518),
    /*GILLT_v2s64*//*Label 404*/ GIMT_Encode4(23565),
    /*GILLT_v4s1*//*Label 405*/ GIMT_Encode4(23679),
    /*GILLT_v4s16*//*Label 406*/ GIMT_Encode4(23797),
    /*GILLT_v4s32*//*Label 407*/ GIMT_Encode4(23844), GIMT_Encode4(0),
    /*GILLT_v8s1*//*Label 408*/ GIMT_Encode4(23958),
    /*GILLT_v8s8*//*Label 409*/ GIMT_Encode4(24076),
    /*GILLT_v8s16*//*Label 410*/ GIMT_Encode4(24123), GIMT_Encode4(0),
    /*GILLT_v16s1*//*Label 411*/ GIMT_Encode4(24237),
    /*GILLT_v16s8*//*Label 412*/ GIMT_Encode4(24355),
    // Label 400: @18732
    GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(23352),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(18870), // Rule ID 5635 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 24,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }), (sra:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }))  =>  (REVSH:{ *:[i32] } GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::REVSH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5635,
        GIR_EraseRootFromParent_Done,
      // Label 415: @18870
      GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(18997), // Rule ID 5677 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(255),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 24,
        GIM_CheckConstantInt8, /*MI*/3, /*Op*/2, 16,
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }), (sra:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }))  =>  (t2REVSH:{ *:[i32] } rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2REVSH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5677,
        GIR_EraseRootFromParent_Done,
      // Label 416: @18997
      GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(19124), // Rule ID 1911 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (sra:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } GPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }))  =>  (REVSH:{ *:[i32] } GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::REVSH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1911,
        GIR_EraseRootFromParent_Done,
      // Label 417: @19124
      GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(19251), // Rule ID 2184 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 24,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 16,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/1, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[4] Rm
        GIM_CheckIsSameOperand, /*MI*/4, /*OpIdx*/1, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/4, /*Op*/2, 8,
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(255),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (sra:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 24:{ *:[i32] }), 16:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 8:{ *:[i32] }), 255:{ *:[i32] }))  =>  (t2REVSH:{ *:[i32] } rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2REVSH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2184,
        GIR_EraseRootFromParent_Done,
      // Label 418: @19251
      GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(19384), // Rule ID 5433 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_asr_amt),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5433,
        GIR_EraseRootFromParent_Done,
      // Label 419: @19384
      GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(19517), // Rule ID 5470 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_asr_amt),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5470,
        GIR_EraseRootFromParent_Done,
      // Label 420: @19517
      GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(19650), // Rule ID 5640 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm1_15),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5640,
        GIR_EraseRootFromParent_Done,
      // Label 421: @19650
      GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(19783), // Rule ID 5682 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm1_15),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5682,
        GIR_EraseRootFromParent_Done,
      // Label 422: @19783
      GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(19916), // Rule ID 5432 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_lsl_amt),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5432,
        GIR_EraseRootFromParent_Done,
      // Label 423: @19916
      GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(20049), // Rule ID 5469 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_lsl_amt),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/0, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/4, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/4, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/4, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/4, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/4, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5469,
        GIR_EraseRootFromParent_Done,
      // Label 424: @20049
      GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(20182), // Rule ID 203 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_asr_amt),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 203,
        GIR_EraseRootFromParent_Done,
      // Label 425: @20182
      GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(20315), // Rule ID 540 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_asr_amt),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_asr_amt>>:$sh), 65535:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 540,
        GIR_EraseRootFromParent_Done,
      // Label 426: @20315
      GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(20448), // Rule ID 1916 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm1_15),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1916,
        GIR_EraseRootFromParent_Done,
      // Label 427: @20448
      GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(20581), // Rule ID 2189 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm1_15),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (and:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh), 65535:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm1_15>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2189,
        GIR_EraseRootFromParent_Done,
      // Label 428: @20581
      GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(20714), // Rule ID 202 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_lsl_amt),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (and:{ *:[i32] } (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 202,
        GIR_EraseRootFromParent_Done,
      // Label 429: @20714
      GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(20847), // Rule ID 539 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/1, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/4, /*MI*/3, /*OpIdx*/2, // MIs[4]
        GIM_CheckOpcode, /*MI*/4, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/4, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_pkh_lsl_amt),
        // MIs[4] Operand 1
        // No operand predicates
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/4,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (and:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_pkh_lsl_amt>>:$sh), 4294901760:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, (imm:{ *:[i32] }):$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/4, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 539,
        GIR_EraseRootFromParent_Done,
      // Label 430: @20847
      GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(20952), // Rule ID 1912 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 4294901760:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1912,
        GIR_EraseRootFromParent_Done,
      // Label 431: @20952
      GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(21057), // Rule ID 2185 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src2, 4294901760:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2185,
        GIR_EraseRootFromParent_Done,
      // Label 432: @21057
      GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(21162), // Rule ID 5636 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, 4294901760:{ *:[i32] }), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5636,
        GIR_EraseRootFromParent_Done,
      // Label 433: @21162
      GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(21267), // Rule ID 5678 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src2, 4294901760:{ *:[i32] }), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5678,
        GIR_EraseRootFromParent_Done,
      // Label 434: @21267
      GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(21373), // Rule ID 1915 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1915,
        GIR_EraseRootFromParent_Done,
      // Label 435: @21373
      GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(21479), // Rule ID 2188 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (sra:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2188,
        GIR_EraseRootFromParent_Done,
      // Label 436: @21479
      GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(21585), // Rule ID 1914 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1914,
        GIR_EraseRootFromParent_Done,
      // Label 437: @21585
      GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(21691), // Rule ID 2187 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }), (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2187,
        GIR_EraseRootFromParent_Done,
      // Label 438: @21691
      GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(21797), // Rule ID 1913 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }), (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1913,
        GIR_EraseRootFromParent_Done,
      // Label 439: @21797
      GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(21903), // Rule ID 2186 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(65535),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/2, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }), (shl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2186,
        GIR_EraseRootFromParent_Done,
      // Label 440: @21903
      GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(22009), // Rule ID 5639 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (sra:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5639,
        GIR_EraseRootFromParent_Done,
      // Label 441: @22009
      GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(22115), // Rule ID 5681 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (sra:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5681,
        GIR_EraseRootFromParent_Done,
      // Label 442: @22115
      GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(22221), // Rule ID 5638 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (srl:{ *:[i32] } GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (PKHTB:{ *:[i32] } GPRnopc:{ *:[i32] }:$src1, GPRnopc:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5638,
        GIR_EraseRootFromParent_Done,
      // Label 443: @22221
      GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(22327), // Rule ID 5680 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(4294901760),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (srl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 4294901760:{ *:[i32] }))  =>  (t2PKHTB:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHTB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5680,
        GIR_EraseRootFromParent_Done,
      // Label 444: @22327
      GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(22433), // Rule ID 5637 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, 65535:{ *:[i32] }))  =>  (PKHBT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn, GPRnopc:{ *:[i32] }:$Rm, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5637,
        GIR_EraseRootFromParent_Done,
      // Label 445: @22433
      GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(22539), // Rule ID 5679 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm16_31),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/2, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_AND),
        GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/3, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/3, /*Op*/2, GIMT_Encode8(65535),
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (or:{ *:[i32] } (shl:{ *:[i32] } rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh), (and:{ *:[i32] } rGPR:{ *:[i32] }:$src1, 65535:{ *:[i32] }))  =>  (t2PKHBT:{ *:[i32] } rGPR:{ *:[i32] }:$src1, rGPR:{ *:[i32] }:$src2, (imm:{ *:[i32] })<<P:Predicate_imm16_31>>:$sh)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2PKHBT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src2
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // sh
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5679,
        GIR_EraseRootFromParent_Done,
      // Label 446: @22539
      GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(22616), // Rule ID 5457 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm), rGPR:{ *:[i32] }:$Rn)  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORNri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5457,
        GIR_EraseRootFromParent_Done,
      // Label 447: @22616
      GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(22693), // Rule ID 5456 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORNri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5456,
        GIR_EraseRootFromParent_Done,
      // Label 448: @22693
      GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(22770), // Rule ID 5455 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm))  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORNri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5455,
        GIR_EraseRootFromParent_Done,
      // Label 449: @22770
      GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(22847), // Rule ID 496 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] }))  =>  (t2ORNri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORNri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 496,
        GIR_EraseRootFromParent_Done,
      // Label 450: @22847
      GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(22918), // Rule ID 5458 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }), rGPR:{ *:[i32] }:$Rn)  =>  (t2ORNrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORNrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5458,
        GIR_EraseRootFromParent_Done,
      // Label 451: @22918
      GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(22989), // Rule ID 497 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] }))  =>  (t2ORNrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORNrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 497,
        GIR_EraseRootFromParent_Done,
      // Label 452: @22989
      GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(23044), // Rule ID 1845 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6T2_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(4294901760),
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$src, 4294901760:{ *:[i32] })  =>  (MOVTi16:{ *:[i32] } GPR:{ *:[i32] }:$src, 65535:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MOVTi16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(65535),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1845,
        GIR_EraseRootFromParent_Done,
      // Label 453: @23044
      GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(23099), // Rule ID 2082 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(4294901760),
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$src, 4294901760:{ *:[i32] })  =>  (t2MOVTi16:{ *:[i32] } rGPR:{ *:[i32] }:$src, 65535:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MOVTi16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(65535),
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2082,
        GIR_EraseRootFromParent_Done,
      // Label 454: @23099
      GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(23156), // Rule ID 151 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (ORRri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::ORRri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 151,
        GIR_EraseRootFromParent_Done,
      // Label 455: @23156
      GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(23213), // Rule ID 484 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2ORRri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORRri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 484,
        GIR_EraseRootFromParent_Done,
      // Label 456: @23213
      GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(23259), // Rule ID 152 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (or:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (ORRrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::ORRrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 152,
        GIR_EraseRootFromParent_Done,
      // Label 457: @23259
      GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(23305), // Rule ID 325 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        // (or:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)  =>  (tORR:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tORR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 325,
        GIR_EraseRootFromParent_Done,
      // Label 458: @23305
      GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(23351), // Rule ID 485 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (or:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2ORRrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2ORRrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 485,
        GIR_EraseRootFromParent_Done,
      // Label 459: @23351
      GIM_Reject,
    // Label 414: @23352
    GIM_Reject,
    // Label 401: @23353
    GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(23399), // Rule ID 2512 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (or:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)  =>  (VORRd:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // LHS
      GIR_RootToRootCopy, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2512,
      GIR_EraseRootFromParent_Done,
    // Label 460: @23399
    GIM_Reject,
    // Label 402: @23400
    GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(23517), // Rule ID 1831 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (or:{ *:[v2i1] } VCCR:{ *:[v2i1] }:$p1, VCCR:{ *:[v2i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (t2ORRrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ORRrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1831,
      GIR_EraseRootFromParent_Done,
    // Label 461: @23517
    GIM_Reject,
    // Label 403: @23518
    GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(23564), // Rule ID 1134 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (or:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VORRd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // Vn
      GIR_RootToRootCopy, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1134,
      GIR_EraseRootFromParent_Done,
    // Label 462: @23564
    GIM_Reject,
    // Label 404: @23565
    GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(23678),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 464*/ GIMT_Encode4(23616), // Rule ID 2515 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (or:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)  =>  (VORRq:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_RootToRootCopy, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2515,
        GIR_EraseRootFromParent_Done,
      // Label 464: @23616
      GIM_Try, /*On fail goto*//*Label 465*/ GIMT_Encode4(23677), // Rule ID 3364 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (or:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)  =>  (MVE_VORR:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VORR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3364,
        GIR_EraseRootFromParent_Done,
      // Label 465: @23677
      GIM_Reject,
    // Label 463: @23678
    GIM_Reject,
    // Label 405: @23679
    GIM_Try, /*On fail goto*//*Label 466*/ GIMT_Encode4(23796), // Rule ID 1832 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (or:{ *:[v4i1] } VCCR:{ *:[v4i1] }:$p1, VCCR:{ *:[v4i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (t2ORRrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ORRrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1832,
      GIR_EraseRootFromParent_Done,
    // Label 466: @23796
    GIM_Reject,
    // Label 406: @23797
    GIM_Try, /*On fail goto*//*Label 467*/ GIMT_Encode4(23843), // Rule ID 2511 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (or:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)  =>  (VORRd:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // LHS
      GIR_RootToRootCopy, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2511,
      GIR_EraseRootFromParent_Done,
    // Label 467: @23843
    GIM_Reject,
    // Label 407: @23844
    GIM_Try, /*On fail goto*//*Label 468*/ GIMT_Encode4(23957),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(23895), // Rule ID 1135 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (or:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VORRq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1135,
        GIR_EraseRootFromParent_Done,
      // Label 469: @23895
      GIM_Try, /*On fail goto*//*Label 470*/ GIMT_Encode4(23956), // Rule ID 3360 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (or:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VORR:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VORR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3360,
        GIR_EraseRootFromParent_Done,
      // Label 470: @23956
      GIM_Reject,
    // Label 468: @23957
    GIM_Reject,
    // Label 408: @23958
    GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(24075), // Rule ID 1833 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (or:{ *:[v8i1] } VCCR:{ *:[v8i1] }:$p1, VCCR:{ *:[v8i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (t2ORRrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ORRrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1833,
      GIR_EraseRootFromParent_Done,
    // Label 471: @24075
    GIM_Reject,
    // Label 409: @24076
    GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(24122), // Rule ID 2510 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (or:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)  =>  (VORRd:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // LHS
      GIR_RootToRootCopy, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2510,
      GIR_EraseRootFromParent_Done,
    // Label 472: @24122
    GIM_Reject,
    // Label 410: @24123
    GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(24236),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(24174), // Rule ID 2514 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (or:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)  =>  (VORRq:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_RootToRootCopy, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2514,
        GIR_EraseRootFromParent_Done,
      // Label 474: @24174
      GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(24235), // Rule ID 3356 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (or:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VORR:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VORR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3356,
        GIR_EraseRootFromParent_Done,
      // Label 475: @24235
      GIM_Reject,
    // Label 473: @24236
    GIM_Reject,
    // Label 411: @24237
    GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(24354), // Rule ID 1834 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (or:{ *:[v16i1] } VCCR:{ *:[v16i1] }:$p1, VCCR:{ *:[v16i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v16i1] } (t2ORRrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2ORRrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1834,
      GIR_EraseRootFromParent_Done,
    // Label 476: @24354
    GIM_Reject,
    // Label 412: @24355
    GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(24468),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(24406), // Rule ID 2513 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (or:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)  =>  (VORRq:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VORRq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_RootToRootCopy, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2513,
        GIR_EraseRootFromParent_Done,
      // Label 478: @24406
      GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(24467), // Rule ID 3352 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (or:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VORR:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VORR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3352,
        GIR_EraseRootFromParent_Done,
      // Label 479: @24467
      GIM_Reject,
    // Label 477: @24468
    GIM_Reject,
    // Label 413: @24469
    GIM_Reject,
    // Label 7: @24470
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 493*/ GIMT_Encode4(26164),
    /*GILLT_s32*//*Label 480*/ GIMT_Encode4(24541),
    /*GILLT_s64*//*Label 481*/ GIMT_Encode4(25048),
    /*GILLT_v2s1*//*Label 482*/ GIMT_Encode4(25095),
    /*GILLT_v2s32*//*Label 483*/ GIMT_Encode4(25213),
    /*GILLT_v2s64*//*Label 484*/ GIMT_Encode4(25260),
    /*GILLT_v4s1*//*Label 485*/ GIMT_Encode4(25374),
    /*GILLT_v4s16*//*Label 486*/ GIMT_Encode4(25492),
    /*GILLT_v4s32*//*Label 487*/ GIMT_Encode4(25539), GIMT_Encode4(0),
    /*GILLT_v8s1*//*Label 488*/ GIMT_Encode4(25653),
    /*GILLT_v8s8*//*Label 489*/ GIMT_Encode4(25771),
    /*GILLT_v8s16*//*Label 490*/ GIMT_Encode4(25818), GIMT_Encode4(0),
    /*GILLT_v16s1*//*Label 491*/ GIMT_Encode4(25932),
    /*GILLT_v16s8*//*Label 492*/ GIMT_Encode4(26050),
    // Label 480: @24541
    GIM_Try, /*On fail goto*//*Label 494*/ GIMT_Encode4(25047),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 495*/ GIMT_Encode4(24607), // Rule ID 5460 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } -1:{ *:[i32] }, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2MVNi:{ *:[i32] } (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MVNi),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5460,
        GIR_EraseRootFromParent_Done,
      // Label 495: @24607
      GIM_Try, /*On fail goto*//*Label 496*/ GIMT_Encode4(24662), // Rule ID 499 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm, -1:{ *:[i32] })  =>  (t2MVNi:{ *:[i32] } (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MVNi),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 499,
        GIR_EraseRootFromParent_Done,
      // Label 496: @24662
      GIM_Try, /*On fail goto*//*Label 497*/ GIMT_Encode4(24706), // Rule ID 500 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, -1:{ *:[i32] })  =>  (t2MVNr:{ *:[i32] } rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2MVNr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 500,
        GIR_EraseRootFromParent_Done,
      // Label 497: @24706
      GIM_Try, /*On fail goto*//*Label 498*/ GIMT_Encode4(24750), // Rule ID 165 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rm, -1:{ *:[i32] })  =>  (MVNr:{ *:[i32] } GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVNr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 165,
        GIR_EraseRootFromParent_Done,
      // Label 498: @24750
      GIM_Try, /*On fail goto*//*Label 499*/ GIMT_Encode4(24794), // Rule ID 324 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, -1:{ *:[i32] })  =>  (tMVN:{ *:[i32] } tGPR:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tMVN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 324,
        GIR_EraseRootFromParent_Done,
      // Label 499: @24794
      GIM_Try, /*On fail goto*//*Label 500*/ GIMT_Encode4(24851), // Rule ID 155 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_mod_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_mod_imm>>:$imm)  =>  (EORri:{ *:[i32] } GPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::EORri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 155,
        GIR_EraseRootFromParent_Done,
      // Label 500: @24851
      GIM_Try, /*On fail goto*//*Label 501*/ GIMT_Encode4(24908), // Rule ID 487 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_t2_so_imm),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] })<<P:Predicate_t2_so_imm>>:$imm)  =>  (t2EORri:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, (imm:{ *:[i32] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2EORri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 487,
        GIR_EraseRootFromParent_Done,
      // Label 501: @24908
      GIM_Try, /*On fail goto*//*Label 502*/ GIMT_Encode4(24954), // Rule ID 156 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsARM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (xor:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)  =>  (EORrr:{ *:[i32] } GPR:{ *:[i32] }:$Rn, GPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::EORrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 156,
        GIR_EraseRootFromParent_Done,
      // Label 502: @24954
      GIM_Try, /*On fail goto*//*Label 503*/ GIMT_Encode4(25000), // Rule ID 317 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb_IsThumb1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        // (xor:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)  =>  (tEOR:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, tGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tEOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rdn]
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 317,
        GIR_EraseRootFromParent_Done,
      // Label 503: @25000
      GIM_Try, /*On fail goto*//*Label 504*/ GIMT_Encode4(25046), // Rule ID 488 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (xor:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2EORrr:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2EORrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 488,
        GIR_EraseRootFromParent_Done,
      // Label 504: @25046
      GIM_Reject,
    // Label 494: @25047
    GIM_Reject,
    // Label 481: @25048
    GIM_Try, /*On fail goto*//*Label 505*/ GIMT_Encode4(25094), // Rule ID 2518 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (xor:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)  =>  (VEORd:{ *:[v1i64] } DPR:{ *:[v1i64] }:$LHS, DPR:{ *:[v1i64] }:$RHS)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // LHS
      GIR_RootToRootCopy, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2518,
      GIR_EraseRootFromParent_Done,
    // Label 505: @25094
    GIM_Reject,
    // Label 482: @25095
    GIM_Try, /*On fail goto*//*Label 506*/ GIMT_Encode4(25212), // Rule ID 1827 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (xor:{ *:[v2i1] } VCCR:{ *:[v2i1] }:$p1, VCCR:{ *:[v2i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (t2EORrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v2i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2EORrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1827,
      GIR_EraseRootFromParent_Done,
    // Label 506: @25212
    GIM_Reject,
    // Label 483: @25213
    GIM_Try, /*On fail goto*//*Label 507*/ GIMT_Encode4(25259), // Rule ID 1132 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (xor:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)  =>  (VEORd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vn, DPR:{ *:[v2i32] }:$Vm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // Vn
      GIR_RootToRootCopy, /*OpIdx*/2, // Vm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1132,
      GIR_EraseRootFromParent_Done,
    // Label 507: @25259
    GIM_Reject,
    // Label 484: @25260
    GIM_Try, /*On fail goto*//*Label 508*/ GIMT_Encode4(25373),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 509*/ GIMT_Encode4(25311), // Rule ID 2521 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (xor:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)  =>  (VEORq:{ *:[v2i64] } QPR:{ *:[v2i64] }:$LHS, QPR:{ *:[v2i64] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_RootToRootCopy, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2521,
        GIR_EraseRootFromParent_Done,
      // Label 509: @25311
      GIM_Try, /*On fail goto*//*Label 510*/ GIMT_Encode4(25372), // Rule ID 3378 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (xor:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)  =>  (MVE_VEOR:{ *:[v2i64] } MQPR:{ *:[v2i64] }:$Qm, MQPR:{ *:[v2i64] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VEOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3378,
        GIR_EraseRootFromParent_Done,
      // Label 510: @25372
      GIM_Reject,
    // Label 508: @25373
    GIM_Reject,
    // Label 485: @25374
    GIM_Try, /*On fail goto*//*Label 511*/ GIMT_Encode4(25491), // Rule ID 1828 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (xor:{ *:[v4i1] } VCCR:{ *:[v4i1] }:$p1, VCCR:{ *:[v4i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (t2EORrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v4i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2EORrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1828,
      GIR_EraseRootFromParent_Done,
    // Label 511: @25491
    GIM_Reject,
    // Label 486: @25492
    GIM_Try, /*On fail goto*//*Label 512*/ GIMT_Encode4(25538), // Rule ID 2517 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (xor:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)  =>  (VEORd:{ *:[v4i16] } DPR:{ *:[v4i16] }:$LHS, DPR:{ *:[v4i16] }:$RHS)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // LHS
      GIR_RootToRootCopy, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2517,
      GIR_EraseRootFromParent_Done,
    // Label 512: @25538
    GIM_Reject,
    // Label 487: @25539
    GIM_Try, /*On fail goto*//*Label 513*/ GIMT_Encode4(25652),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 514*/ GIMT_Encode4(25590), // Rule ID 1133 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (xor:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)  =>  (VEORq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vn, QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Vn
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1133,
        GIR_EraseRootFromParent_Done,
      // Label 514: @25590
      GIM_Try, /*On fail goto*//*Label 515*/ GIMT_Encode4(25651), // Rule ID 3374 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (xor:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)  =>  (MVE_VEOR:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$Qm, MQPR:{ *:[v4i32] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VEOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3374,
        GIR_EraseRootFromParent_Done,
      // Label 515: @25651
      GIM_Reject,
    // Label 513: @25652
    GIM_Reject,
    // Label 488: @25653
    GIM_Try, /*On fail goto*//*Label 516*/ GIMT_Encode4(25770), // Rule ID 1829 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (xor:{ *:[v8i1] } VCCR:{ *:[v8i1] }:$p1, VCCR:{ *:[v8i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (t2EORrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v8i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2EORrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1829,
      GIR_EraseRootFromParent_Done,
    // Label 516: @25770
    GIM_Reject,
    // Label 489: @25771
    GIM_Try, /*On fail goto*//*Label 517*/ GIMT_Encode4(25817), // Rule ID 2516 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (xor:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)  =>  (VEORd:{ *:[v8i8] } DPR:{ *:[v8i8] }:$LHS, DPR:{ *:[v8i8] }:$RHS)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORd),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // LHS
      GIR_RootToRootCopy, /*OpIdx*/2, // RHS
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2516,
      GIR_EraseRootFromParent_Done,
    // Label 517: @25817
    GIM_Reject,
    // Label 490: @25818
    GIM_Try, /*On fail goto*//*Label 518*/ GIMT_Encode4(25931),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 519*/ GIMT_Encode4(25869), // Rule ID 2520 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (xor:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)  =>  (VEORq:{ *:[v8i16] } QPR:{ *:[v8i16] }:$LHS, QPR:{ *:[v8i16] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_RootToRootCopy, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2520,
        GIR_EraseRootFromParent_Done,
      // Label 519: @25869
      GIM_Try, /*On fail goto*//*Label 520*/ GIMT_Encode4(25930), // Rule ID 3370 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (xor:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)  =>  (MVE_VEOR:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$Qm, MQPR:{ *:[v8i16] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VEOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3370,
        GIR_EraseRootFromParent_Done,
      // Label 520: @25930
      GIM_Reject,
    // Label 518: @25931
    GIM_Reject,
    // Label 491: @25932
    GIM_Try, /*On fail goto*//*Label 521*/ GIMT_Encode4(26049), // Rule ID 1830 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
      // (xor:{ *:[v16i1] } VCCR:{ *:[v16i1] }:$p1, VCCR:{ *:[v16i1] }:$p2)  =>  (COPY_TO_REGCLASS:{ *:[v16i1] } (t2EORrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p1, rGPR:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[i32] } VCCR:{ *:[v16i1] }:$p2, rGPR:{ *:[i32] })), VCCR:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // p2
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // p1
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(ARM::rGPRRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::t2EORrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::VCCRRegClassID),
      // GIR_Coverage, 1830,
      GIR_EraseRootFromParent_Done,
    // Label 521: @26049
    GIM_Reject,
    // Label 492: @26050
    GIM_Try, /*On fail goto*//*Label 522*/ GIMT_Encode4(26163),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(26101), // Rule ID 2519 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (xor:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)  =>  (VEORq:{ *:[v16i8] } QPR:{ *:[v16i8] }:$LHS, QPR:{ *:[v16i8] }:$RHS)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VEORq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/1, // LHS
        GIR_RootToRootCopy, /*OpIdx*/2, // RHS
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2519,
        GIR_EraseRootFromParent_Done,
      // Label 523: @26101
      GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(26162), // Rule ID 3366 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (xor:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)  =>  (MVE_VEOR:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$Qm, MQPR:{ *:[v16i8] }:$Qn)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VEOR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/1, // Qm
        GIR_RootToRootCopy, /*OpIdx*/2, // Qn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3366,
        GIR_EraseRootFromParent_Done,
      // Label 524: @26162
      GIM_Reject,
    // Label 522: @26163
    GIM_Reject,
    // Label 493: @26164
    GIM_Reject,
    // Label 8: @26165
    GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(26551),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(5), GIMT_Encode2(16), /*)*//*default:*//*Label 530*/ GIMT_Encode4(26550),
      /*GILLT_v2s64*//*Label 526*/ GIMT_Encode4(26228), GIMT_Encode4(0), GIMT_Encode4(0),
      /*GILLT_v4s32*//*Label 527*/ GIMT_Encode4(26286), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
      /*GILLT_v8s16*//*Label 528*/ GIMT_Encode4(26389), GIMT_Encode4(0), GIMT_Encode4(0),
      /*GILLT_v16s8*//*Label 529*/ GIMT_Encode4(26492),
      // Label 526: @26228
      GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(26285), // Rule ID 3004 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (concat_vectors:{ *:[v2i64] } DPR:{ *:[v1i64] }:$Dn, DPR:{ *:[v1i64] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v2i64] } QPR:{ *:[i32] }, DPR:{ *:[v1i64] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v1i64] }:$Dm, dsub_1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Dn
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
        GIR_RootToRootCopy, /*OpIdx*/2, // Dm
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
        // GIR_Coverage, 3004,
        GIR_EraseRootFromParent_Done,
      // Label 531: @26285
      GIM_Reject,
      // Label 527: @26286
      GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(26388),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(26348), // Rule ID 3005 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
          // (concat_vectors:{ *:[v4i32] } DPR:{ *:[v2i32] }:$Dn, DPR:{ *:[v2i32] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v4i32] } QPR:{ *:[i32] }, DPR:{ *:[v2i32] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v2i32] }:$Dm, dsub_1:{ *:[i32] })
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/1, // Dn
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
          GIR_RootToRootCopy, /*OpIdx*/2, // Dm
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
          // GIR_Coverage, 3005,
          GIR_EraseRootFromParent_Done,
        // Label 533: @26348
        GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(26387), // Rule ID 3008 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
          // (concat_vectors:{ *:[v4f32] } DPR:{ *:[v2f32] }:$Dn, DPR:{ *:[v2f32] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v4f32] } QPR:{ *:[i32] }, DPR:{ *:[v2f32] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v2f32] }:$Dm, dsub_1:{ *:[i32] })
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/1, // Dn
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
          GIR_RootToRootCopy, /*OpIdx*/2, // Dm
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
          // GIR_Coverage, 3008,
          GIR_EraseRootFromParent_Done,
        // Label 534: @26387
        GIM_Reject,
      // Label 532: @26388
      GIM_Reject,
      // Label 528: @26389
      GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(26491),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(26451), // Rule ID 3006 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
          // (concat_vectors:{ *:[v8i16] } DPR:{ *:[v4i16] }:$Dn, DPR:{ *:[v4i16] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v8i16] } QPR:{ *:[i32] }, DPR:{ *:[v4i16] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v4i16] }:$Dm, dsub_1:{ *:[i32] })
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/1, // Dn
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
          GIR_RootToRootCopy, /*OpIdx*/2, // Dm
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
          // GIR_Coverage, 3006,
          GIR_EraseRootFromParent_Done,
        // Label 536: @26451
        GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(26490), // Rule ID 3009 //
          GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
          // (concat_vectors:{ *:[v8f16] } DPR:{ *:[v4f16] }:$Dn, DPR:{ *:[v4f16] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v8f16] } QPR:{ *:[i32] }, DPR:{ *:[v4f16] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v4f16] }:$Dm, dsub_1:{ *:[i32] })
          GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
          GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
          GIR_RootToRootCopy, /*OpIdx*/1, // Dn
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
          GIR_RootToRootCopy, /*OpIdx*/2, // Dm
          GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
          GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
          // GIR_Coverage, 3009,
          GIR_EraseRootFromParent_Done,
        // Label 537: @26490
        GIM_Reject,
      // Label 535: @26491
      GIM_Reject,
      // Label 529: @26492
      GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(26549), // Rule ID 3007 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (concat_vectors:{ *:[v16i8] } DPR:{ *:[v8i8] }:$Dn, DPR:{ *:[v8i8] }:$Dm)  =>  (REG_SEQUENCE:{ *:[v16i8] } QPR:{ *:[i32] }, DPR:{ *:[v8i8] }:$Dn, dsub_0:{ *:[i32] }, DPR:{ *:[v8i8] }:$Dm, dsub_1:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::REG_SEQUENCE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // Dn
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/1,
        GIR_RootToRootCopy, /*OpIdx*/2, // Dm
        GIR_AddImm8, /*InsnID*/0, /*SubRegIndex*/2,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPRRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/3, GIMT_Encode2(ARM::DPRRegClassID),
        // GIR_Coverage, 3007,
        GIR_EraseRootFromParent_Done,
      // Label 538: @26549
      GIM_Reject,
      // Label 530: @26550
      GIM_Reject,
    // Label 525: @26551
    GIM_Reject,
    // Label 9: @26552
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(16), /*)*//*default:*//*Label 548*/ GIMT_Encode4(35563),
    /*GILLT_s32*//*Label 539*/ GIMT_Encode4(26623),
    /*GILLT_s64*//*Label 540*/ GIMT_Encode4(26771), GIMT_Encode4(0),
    /*GILLT_v2s32*//*Label 541*/ GIMT_Encode4(27526),
    /*GILLT_v2s64*//*Label 542*/ GIMT_Encode4(28281), GIMT_Encode4(0),
    /*GILLT_v4s16*//*Label 543*/ GIMT_Encode4(30000),
    /*GILLT_v4s32*//*Label 544*/ GIMT_Encode4(30755), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s8*//*Label 545*/ GIMT_Encode4(32474),
    /*GILLT_v8s16*//*Label 546*/ GIMT_Encode4(32889), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s8*//*Label 547*/ GIMT_Encode4(34608),
    // Label 539: @26623
    GIM_Try, /*On fail goto*//*Label 549*/ GIMT_Encode4(26770),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 550*/ GIMT_Encode4(26665), // Rule ID 689 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPRegs),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        // (bitconvert:{ *:[i32] } SPR:{ *:[f32] }:$Sn)  =>  (VMOVRS:{ *:[i32] } SPR:{ *:[f32] }:$Sn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMOVRS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rt]
        GIR_RootToRootCopy, /*OpIdx*/1, // Sn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 689,
        GIR_EraseRootFromParent_Done,
      // Label 550: @26665
      GIM_Try, /*On fail goto*//*Label 551*/ GIMT_Encode4(26699), // Rule ID 690 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPRegs_UseVMOVSR),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (bitconvert:{ *:[f32] } GPR:{ *:[i32] }:$Rt)  =>  (VMOVSR:{ *:[f32] } GPR:{ *:[i32] }:$Rt)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VMOVSR),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Sn]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rt
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 690,
        GIR_EraseRootFromParent_Done,
      // Label 551: @26699
      GIM_Try, /*On fail goto*//*Label 552*/ GIMT_Encode4(26769), // Rule ID 2698 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_DontUseVMOVSR_HasNEON),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (bitconvert:{ *:[f32] } GPR:{ *:[i32] }:$a)  =>  (EXTRACT_SUBREG:{ *:[f32] } (VMOVDRR:{ *:[f64] } GPR:{ *:[i32] }:$a, GPR:{ *:[i32] }:$a), ssub_0:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::VMOVDRR),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // a
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // a
        GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(ARM::ssub_0),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::SPRRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(ARM::DPR_VFP2RegClassID),
        // GIR_Coverage, 2698,
        GIR_EraseRootFromParent_Done,
      // Label 552: @26769
      GIM_Reject,
    // Label 549: @26770
    GIM_Reject,
    // Label 540: @26771
    GIM_Try, /*On fail goto*//*Label 553*/ GIMT_Encode4(26803), // Rule ID 2700 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2700,
      GIR_EraseRootFromParent_Done,
    // Label 553: @26803
    GIM_Try, /*On fail goto*//*Label 554*/ GIMT_Encode4(26835), // Rule ID 2701 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2701,
      GIR_EraseRootFromParent_Done,
    // Label 554: @26835
    GIM_Try, /*On fail goto*//*Label 555*/ GIMT_Encode4(26867), // Rule ID 2712 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2712,
      GIR_EraseRootFromParent_Done,
    // Label 555: @26867
    GIM_Try, /*On fail goto*//*Label 556*/ GIMT_Encode4(26899), // Rule ID 2713 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2713,
      GIR_EraseRootFromParent_Done,
    // Label 556: @26899
    GIM_Try, /*On fail goto*//*Label 557*/ GIMT_Encode4(26931), // Rule ID 2714 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2714,
      GIR_EraseRootFromParent_Done,
    // Label 557: @26931
    GIM_Try, /*On fail goto*//*Label 558*/ GIMT_Encode4(26963), // Rule ID 2715 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2715,
      GIR_EraseRootFromParent_Done,
    // Label 558: @26963
    GIM_Try, /*On fail goto*//*Label 559*/ GIMT_Encode4(26995), // Rule ID 2716 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2716,
      GIR_EraseRootFromParent_Done,
    // Label 559: @26995
    GIM_Try, /*On fail goto*//*Label 560*/ GIMT_Encode4(27027), // Rule ID 2717 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2717,
      GIR_EraseRootFromParent_Done,
    // Label 560: @27027
    GIM_Try, /*On fail goto*//*Label 561*/ GIMT_Encode4(27059), // Rule ID 2718 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2718,
      GIR_EraseRootFromParent_Done,
    // Label 561: @27059
    GIM_Try, /*On fail goto*//*Label 562*/ GIMT_Encode4(27091), // Rule ID 2719 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2719,
      GIR_EraseRootFromParent_Done,
    // Label 562: @27091
    GIM_Try, /*On fail goto*//*Label 563*/ GIMT_Encode4(27123), // Rule ID 2720 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2720,
      GIR_EraseRootFromParent_Done,
    // Label 563: @27123
    GIM_Try, /*On fail goto*//*Label 564*/ GIMT_Encode4(27155), // Rule ID 2721 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v1i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2721,
      GIR_EraseRootFromParent_Done,
    // Label 564: @27155
    GIM_Try, /*On fail goto*//*Label 565*/ GIMT_Encode4(27192), // Rule ID 2784 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2f32] }:$src)  =>  (VREV64d32:{ *:[f64] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2784,
      GIR_EraseRootFromParent_Done,
    // Label 565: @27192
    GIM_Try, /*On fail goto*//*Label 566*/ GIMT_Encode4(27229), // Rule ID 2785 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v2i32] }:$src)  =>  (VREV64d32:{ *:[f64] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2785,
      GIR_EraseRootFromParent_Done,
    // Label 566: @27229
    GIM_Try, /*On fail goto*//*Label 567*/ GIMT_Encode4(27266), // Rule ID 2786 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4f16] }:$src)  =>  (VREV64d16:{ *:[f64] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2786,
      GIR_EraseRootFromParent_Done,
    // Label 567: @27266
    GIM_Try, /*On fail goto*//*Label 568*/ GIMT_Encode4(27303), // Rule ID 2787 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v4i16] }:$src)  =>  (VREV64d16:{ *:[f64] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2787,
      GIR_EraseRootFromParent_Done,
    // Label 568: @27303
    GIM_Try, /*On fail goto*//*Label 569*/ GIMT_Encode4(27340), // Rule ID 2788 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[f64] } DPR:{ *:[v8i8] }:$src)  =>  (VREV64d8:{ *:[f64] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2788,
      GIR_EraseRootFromParent_Done,
    // Label 569: @27340
    GIM_Try, /*On fail goto*//*Label 570*/ GIMT_Encode4(27377), // Rule ID 2789 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2f32] }:$src)  =>  (VREV64d32:{ *:[v1i64] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2789,
      GIR_EraseRootFromParent_Done,
    // Label 570: @27377
    GIM_Try, /*On fail goto*//*Label 571*/ GIMT_Encode4(27414), // Rule ID 2790 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v2i32] }:$src)  =>  (VREV64d32:{ *:[v1i64] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2790,
      GIR_EraseRootFromParent_Done,
    // Label 571: @27414
    GIM_Try, /*On fail goto*//*Label 572*/ GIMT_Encode4(27451), // Rule ID 2791 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4f16] }:$src)  =>  (VREV64d16:{ *:[v1i64] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2791,
      GIR_EraseRootFromParent_Done,
    // Label 572: @27451
    GIM_Try, /*On fail goto*//*Label 573*/ GIMT_Encode4(27488), // Rule ID 2792 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v4i16] }:$src)  =>  (VREV64d16:{ *:[v1i64] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2792,
      GIR_EraseRootFromParent_Done,
    // Label 573: @27488
    GIM_Try, /*On fail goto*//*Label 574*/ GIMT_Encode4(27525), // Rule ID 2793 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v1i64] } DPR:{ *:[v8i8] }:$src)  =>  (VREV64d8:{ *:[v1i64] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2793,
      GIR_EraseRootFromParent_Done,
    // Label 574: @27525
    GIM_Reject,
    // Label 541: @27526
    GIM_Try, /*On fail goto*//*Label 575*/ GIMT_Encode4(27558), // Rule ID 2702 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2702,
      GIR_EraseRootFromParent_Done,
    // Label 575: @27558
    GIM_Try, /*On fail goto*//*Label 576*/ GIMT_Encode4(27590), // Rule ID 2703 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2703,
      GIR_EraseRootFromParent_Done,
    // Label 576: @27590
    GIM_Try, /*On fail goto*//*Label 577*/ GIMT_Encode4(27622), // Rule ID 2722 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2722,
      GIR_EraseRootFromParent_Done,
    // Label 577: @27622
    GIM_Try, /*On fail goto*//*Label 578*/ GIMT_Encode4(27654), // Rule ID 2723 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2723,
      GIR_EraseRootFromParent_Done,
    // Label 578: @27654
    GIM_Try, /*On fail goto*//*Label 579*/ GIMT_Encode4(27686), // Rule ID 2724 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2724,
      GIR_EraseRootFromParent_Done,
    // Label 579: @27686
    GIM_Try, /*On fail goto*//*Label 580*/ GIMT_Encode4(27718), // Rule ID 2725 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2725,
      GIR_EraseRootFromParent_Done,
    // Label 580: @27718
    GIM_Try, /*On fail goto*//*Label 581*/ GIMT_Encode4(27750), // Rule ID 2726 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v2f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2726,
      GIR_EraseRootFromParent_Done,
    // Label 581: @27750
    GIM_Try, /*On fail goto*//*Label 582*/ GIMT_Encode4(27782), // Rule ID 2727 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2727,
      GIR_EraseRootFromParent_Done,
    // Label 582: @27782
    GIM_Try, /*On fail goto*//*Label 583*/ GIMT_Encode4(27814), // Rule ID 2728 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2728,
      GIR_EraseRootFromParent_Done,
    // Label 583: @27814
    GIM_Try, /*On fail goto*//*Label 584*/ GIMT_Encode4(27846), // Rule ID 2729 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2729,
      GIR_EraseRootFromParent_Done,
    // Label 584: @27846
    GIM_Try, /*On fail goto*//*Label 585*/ GIMT_Encode4(27878), // Rule ID 2730 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2730,
      GIR_EraseRootFromParent_Done,
    // Label 585: @27878
    GIM_Try, /*On fail goto*//*Label 586*/ GIMT_Encode4(27910), // Rule ID 2731 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v2i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2731,
      GIR_EraseRootFromParent_Done,
    // Label 586: @27910
    GIM_Try, /*On fail goto*//*Label 587*/ GIMT_Encode4(27947), // Rule ID 2794 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[f64] }:$src)  =>  (VREV64d32:{ *:[v2f32] } DPR:{ *:[f64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2794,
      GIR_EraseRootFromParent_Done,
    // Label 587: @27947
    GIM_Try, /*On fail goto*//*Label 588*/ GIMT_Encode4(27984), // Rule ID 2795 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d32:{ *:[v2f32] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2795,
      GIR_EraseRootFromParent_Done,
    // Label 588: @27984
    GIM_Try, /*On fail goto*//*Label 589*/ GIMT_Encode4(28021), // Rule ID 2796 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4f16] }:$src)  =>  (VREV32d16:{ *:[v2f32] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2796,
      GIR_EraseRootFromParent_Done,
    // Label 589: @28021
    GIM_Try, /*On fail goto*//*Label 590*/ GIMT_Encode4(28058), // Rule ID 2797 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v4i16] }:$src)  =>  (VREV32d16:{ *:[v2f32] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2797,
      GIR_EraseRootFromParent_Done,
    // Label 590: @28058
    GIM_Try, /*On fail goto*//*Label 591*/ GIMT_Encode4(28095), // Rule ID 2798 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2f32] } DPR:{ *:[v8i8] }:$src)  =>  (VREV32d8:{ *:[v2f32] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2798,
      GIR_EraseRootFromParent_Done,
    // Label 591: @28095
    GIM_Try, /*On fail goto*//*Label 592*/ GIMT_Encode4(28132), // Rule ID 2799 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[f64] }:$src)  =>  (VREV64d32:{ *:[v2i32] } DPR:{ *:[f64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2799,
      GIR_EraseRootFromParent_Done,
    // Label 592: @28132
    GIM_Try, /*On fail goto*//*Label 593*/ GIMT_Encode4(28169), // Rule ID 2800 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d32:{ *:[v2i32] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2800,
      GIR_EraseRootFromParent_Done,
    // Label 593: @28169
    GIM_Try, /*On fail goto*//*Label 594*/ GIMT_Encode4(28206), // Rule ID 2801 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4f16] }:$src)  =>  (VREV32d16:{ *:[v2i32] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2801,
      GIR_EraseRootFromParent_Done,
    // Label 594: @28206
    GIM_Try, /*On fail goto*//*Label 595*/ GIMT_Encode4(28243), // Rule ID 2802 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v4i16] }:$src)  =>  (VREV32d16:{ *:[v2i32] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2802,
      GIR_EraseRootFromParent_Done,
    // Label 595: @28243
    GIM_Try, /*On fail goto*//*Label 596*/ GIMT_Encode4(28280), // Rule ID 2803 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v2i32] } DPR:{ *:[v8i8] }:$src)  =>  (VREV32d8:{ *:[v2i32] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2803,
      GIR_EraseRootFromParent_Done,
    // Label 596: @28280
    GIM_Reject,
    // Label 542: @28281
    GIM_Try, /*On fail goto*//*Label 597*/ GIMT_Encode4(28313), // Rule ID 2706 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2706,
      GIR_EraseRootFromParent_Done,
    // Label 597: @28313
    GIM_Try, /*On fail goto*//*Label 598*/ GIMT_Encode4(28345), // Rule ID 2707 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2707,
      GIR_EraseRootFromParent_Done,
    // Label 598: @28345
    GIM_Try, /*On fail goto*//*Label 599*/ GIMT_Encode4(28377), // Rule ID 2748 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2748,
      GIR_EraseRootFromParent_Done,
    // Label 599: @28377
    GIM_Try, /*On fail goto*//*Label 600*/ GIMT_Encode4(28409), // Rule ID 2749 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2749,
      GIR_EraseRootFromParent_Done,
    // Label 600: @28409
    GIM_Try, /*On fail goto*//*Label 601*/ GIMT_Encode4(28441), // Rule ID 2750 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2750,
      GIR_EraseRootFromParent_Done,
    // Label 601: @28441
    GIM_Try, /*On fail goto*//*Label 602*/ GIMT_Encode4(28473), // Rule ID 2751 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2751,
      GIR_EraseRootFromParent_Done,
    // Label 602: @28473
    GIM_Try, /*On fail goto*//*Label 603*/ GIMT_Encode4(28505), // Rule ID 2752 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2752,
      GIR_EraseRootFromParent_Done,
    // Label 603: @28505
    GIM_Try, /*On fail goto*//*Label 604*/ GIMT_Encode4(28537), // Rule ID 2753 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2753,
      GIR_EraseRootFromParent_Done,
    // Label 604: @28537
    GIM_Try, /*On fail goto*//*Label 605*/ GIMT_Encode4(28569), // Rule ID 2754 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2754,
      GIR_EraseRootFromParent_Done,
    // Label 605: @28569
    GIM_Try, /*On fail goto*//*Label 606*/ GIMT_Encode4(28601), // Rule ID 2755 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2755,
      GIR_EraseRootFromParent_Done,
    // Label 606: @28601
    GIM_Try, /*On fail goto*//*Label 607*/ GIMT_Encode4(28633), // Rule ID 2756 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2756,
      GIR_EraseRootFromParent_Done,
    // Label 607: @28633
    GIM_Try, /*On fail goto*//*Label 608*/ GIMT_Encode4(28665), // Rule ID 2757 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2757,
      GIR_EraseRootFromParent_Done,
    // Label 608: @28665
    GIM_Try, /*On fail goto*//*Label 609*/ GIMT_Encode4(28702), // Rule ID 2820 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4f32] }:$src)  =>  (VREV64q32:{ *:[v2f64] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2820,
      GIR_EraseRootFromParent_Done,
    // Label 609: @28702
    GIM_Try, /*On fail goto*//*Label 610*/ GIMT_Encode4(28739), // Rule ID 2821 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v4i32] }:$src)  =>  (VREV64q32:{ *:[v2f64] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2821,
      GIR_EraseRootFromParent_Done,
    // Label 610: @28739
    GIM_Try, /*On fail goto*//*Label 611*/ GIMT_Encode4(28776), // Rule ID 2822 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8f16] }:$src)  =>  (VREV64q16:{ *:[v2f64] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2822,
      GIR_EraseRootFromParent_Done,
    // Label 611: @28776
    GIM_Try, /*On fail goto*//*Label 612*/ GIMT_Encode4(28813), // Rule ID 2823 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v8i16] }:$src)  =>  (VREV64q16:{ *:[v2f64] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2823,
      GIR_EraseRootFromParent_Done,
    // Label 612: @28813
    GIM_Try, /*On fail goto*//*Label 613*/ GIMT_Encode4(28850), // Rule ID 2824 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2f64] } QPR:{ *:[v16i8] }:$src)  =>  (VREV64q8:{ *:[v2f64] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2824,
      GIR_EraseRootFromParent_Done,
    // Label 613: @28850
    GIM_Try, /*On fail goto*//*Label 614*/ GIMT_Encode4(28887), // Rule ID 2825 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4f32] }:$src)  =>  (VREV64q32:{ *:[v2i64] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2825,
      GIR_EraseRootFromParent_Done,
    // Label 614: @28887
    GIM_Try, /*On fail goto*//*Label 615*/ GIMT_Encode4(28924), // Rule ID 2826 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v4i32] }:$src)  =>  (VREV64q32:{ *:[v2i64] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2826,
      GIR_EraseRootFromParent_Done,
    // Label 615: @28924
    GIM_Try, /*On fail goto*//*Label 616*/ GIMT_Encode4(28961), // Rule ID 2827 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8f16] }:$src)  =>  (VREV64q16:{ *:[v2i64] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2827,
      GIR_EraseRootFromParent_Done,
    // Label 616: @28961
    GIM_Try, /*On fail goto*//*Label 617*/ GIMT_Encode4(28998), // Rule ID 2828 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v8i16] }:$src)  =>  (VREV64q16:{ *:[v2i64] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2828,
      GIR_EraseRootFromParent_Done,
    // Label 617: @28998
    GIM_Try, /*On fail goto*//*Label 618*/ GIMT_Encode4(29035), // Rule ID 2829 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v2i64] } QPR:{ *:[v16i8] }:$src)  =>  (VREV64q8:{ *:[v2i64] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2829,
      GIR_EraseRootFromParent_Done,
    // Label 618: @29035
    GIM_Try, /*On fail goto*//*Label 619*/ GIMT_Encode4(29067), // Rule ID 5263 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5263,
      GIR_EraseRootFromParent_Done,
    // Label 619: @29067
    GIM_Try, /*On fail goto*//*Label 620*/ GIMT_Encode4(29099), // Rule ID 5264 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5264,
      GIR_EraseRootFromParent_Done,
    // Label 620: @29099
    GIM_Try, /*On fail goto*//*Label 621*/ GIMT_Encode4(29131), // Rule ID 5269 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5269,
      GIR_EraseRootFromParent_Done,
    // Label 621: @29131
    GIM_Try, /*On fail goto*//*Label 622*/ GIMT_Encode4(29163), // Rule ID 5270 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5270,
      GIR_EraseRootFromParent_Done,
    // Label 622: @29163
    GIM_Try, /*On fail goto*//*Label 623*/ GIMT_Encode4(29195), // Rule ID 5271 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5271,
      GIR_EraseRootFromParent_Done,
    // Label 623: @29195
    GIM_Try, /*On fail goto*//*Label 624*/ GIMT_Encode4(29227), // Rule ID 5272 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5272,
      GIR_EraseRootFromParent_Done,
    // Label 624: @29227
    GIM_Try, /*On fail goto*//*Label 625*/ GIMT_Encode4(29259), // Rule ID 5273 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v2f64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5273,
      GIR_EraseRootFromParent_Done,
    // Label 625: @29259
    GIM_Try, /*On fail goto*//*Label 626*/ GIMT_Encode4(29291), // Rule ID 5274 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5274,
      GIR_EraseRootFromParent_Done,
    // Label 626: @29291
    GIM_Try, /*On fail goto*//*Label 627*/ GIMT_Encode4(29323), // Rule ID 5275 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5275,
      GIR_EraseRootFromParent_Done,
    // Label 627: @29323
    GIM_Try, /*On fail goto*//*Label 628*/ GIMT_Encode4(29355), // Rule ID 5276 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5276,
      GIR_EraseRootFromParent_Done,
    // Label 628: @29355
    GIM_Try, /*On fail goto*//*Label 629*/ GIMT_Encode4(29387), // Rule ID 5277 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5277,
      GIR_EraseRootFromParent_Done,
    // Label 629: @29387
    GIM_Try, /*On fail goto*//*Label 630*/ GIMT_Encode4(29419), // Rule ID 5278 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v2i64] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5278,
      GIR_EraseRootFromParent_Done,
    // Label 630: @29419
    GIM_Try, /*On fail goto*//*Label 631*/ GIMT_Encode4(29477), // Rule ID 5305 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV64_32:{ *:[v2f64] } MQPR:{ *:[v4f32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5305,
      GIR_EraseRootFromParent_Done,
    // Label 631: @29477
    GIM_Try, /*On fail goto*//*Label 632*/ GIMT_Encode4(29535), // Rule ID 5306 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV64_32:{ *:[v2f64] } MQPR:{ *:[v4i32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5306,
      GIR_EraseRootFromParent_Done,
    // Label 632: @29535
    GIM_Try, /*On fail goto*//*Label 633*/ GIMT_Encode4(29593), // Rule ID 5307 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV64_16:{ *:[v2f64] } MQPR:{ *:[v8f16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5307,
      GIR_EraseRootFromParent_Done,
    // Label 633: @29593
    GIM_Try, /*On fail goto*//*Label 634*/ GIMT_Encode4(29651), // Rule ID 5308 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV64_16:{ *:[v2f64] } MQPR:{ *:[v8i16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5308,
      GIR_EraseRootFromParent_Done,
    // Label 634: @29651
    GIM_Try, /*On fail goto*//*Label 635*/ GIMT_Encode4(29709), // Rule ID 5309 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2f64] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV64_8:{ *:[v2f64] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5309,
      GIR_EraseRootFromParent_Done,
    // Label 635: @29709
    GIM_Try, /*On fail goto*//*Label 636*/ GIMT_Encode4(29767), // Rule ID 5310 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV64_32:{ *:[v2i64] } MQPR:{ *:[v4f32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5310,
      GIR_EraseRootFromParent_Done,
    // Label 636: @29767
    GIM_Try, /*On fail goto*//*Label 637*/ GIMT_Encode4(29825), // Rule ID 5311 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV64_32:{ *:[v2i64] } MQPR:{ *:[v4i32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5311,
      GIR_EraseRootFromParent_Done,
    // Label 637: @29825
    GIM_Try, /*On fail goto*//*Label 638*/ GIMT_Encode4(29883), // Rule ID 5312 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV64_16:{ *:[v2i64] } MQPR:{ *:[v8f16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5312,
      GIR_EraseRootFromParent_Done,
    // Label 638: @29883
    GIM_Try, /*On fail goto*//*Label 639*/ GIMT_Encode4(29941), // Rule ID 5313 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV64_16:{ *:[v2i64] } MQPR:{ *:[v8i16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5313,
      GIR_EraseRootFromParent_Done,
    // Label 639: @29941
    GIM_Try, /*On fail goto*//*Label 640*/ GIMT_Encode4(29999), // Rule ID 5314 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v2i64] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV64_8:{ *:[v2i64] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5314,
      GIR_EraseRootFromParent_Done,
    // Label 640: @29999
    GIM_Reject,
    // Label 543: @30000
    GIM_Try, /*On fail goto*//*Label 641*/ GIMT_Encode4(30032), // Rule ID 2704 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2704,
      GIR_EraseRootFromParent_Done,
    // Label 641: @30032
    GIM_Try, /*On fail goto*//*Label 642*/ GIMT_Encode4(30064), // Rule ID 2705 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2705,
      GIR_EraseRootFromParent_Done,
    // Label 642: @30064
    GIM_Try, /*On fail goto*//*Label 643*/ GIMT_Encode4(30096), // Rule ID 2732 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2732,
      GIR_EraseRootFromParent_Done,
    // Label 643: @30096
    GIM_Try, /*On fail goto*//*Label 644*/ GIMT_Encode4(30128), // Rule ID 2733 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2733,
      GIR_EraseRootFromParent_Done,
    // Label 644: @30128
    GIM_Try, /*On fail goto*//*Label 645*/ GIMT_Encode4(30160), // Rule ID 2734 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2734,
      GIR_EraseRootFromParent_Done,
    // Label 645: @30160
    GIM_Try, /*On fail goto*//*Label 646*/ GIMT_Encode4(30192), // Rule ID 2735 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2735,
      GIR_EraseRootFromParent_Done,
    // Label 646: @30192
    GIM_Try, /*On fail goto*//*Label 647*/ GIMT_Encode4(30224), // Rule ID 2736 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v4f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2736,
      GIR_EraseRootFromParent_Done,
    // Label 647: @30224
    GIM_Try, /*On fail goto*//*Label 648*/ GIMT_Encode4(30256), // Rule ID 2737 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2737,
      GIR_EraseRootFromParent_Done,
    // Label 648: @30256
    GIM_Try, /*On fail goto*//*Label 649*/ GIMT_Encode4(30288), // Rule ID 2738 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2738,
      GIR_EraseRootFromParent_Done,
    // Label 649: @30288
    GIM_Try, /*On fail goto*//*Label 650*/ GIMT_Encode4(30320), // Rule ID 2739 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2739,
      GIR_EraseRootFromParent_Done,
    // Label 650: @30320
    GIM_Try, /*On fail goto*//*Label 651*/ GIMT_Encode4(30352), // Rule ID 2740 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2740,
      GIR_EraseRootFromParent_Done,
    // Label 651: @30352
    GIM_Try, /*On fail goto*//*Label 652*/ GIMT_Encode4(30384), // Rule ID 2741 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v8i8] }:$src)  =>  DPR:{ *:[v4i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2741,
      GIR_EraseRootFromParent_Done,
    // Label 652: @30384
    GIM_Try, /*On fail goto*//*Label 653*/ GIMT_Encode4(30421), // Rule ID 2804 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[f64] }:$src)  =>  (VREV64d16:{ *:[v4f16] } DPR:{ *:[f64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2804,
      GIR_EraseRootFromParent_Done,
    // Label 653: @30421
    GIM_Try, /*On fail goto*//*Label 654*/ GIMT_Encode4(30458), // Rule ID 2805 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d16:{ *:[v4f16] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2805,
      GIR_EraseRootFromParent_Done,
    // Label 654: @30458
    GIM_Try, /*On fail goto*//*Label 655*/ GIMT_Encode4(30495), // Rule ID 2806 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d16:{ *:[v4f16] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2806,
      GIR_EraseRootFromParent_Done,
    // Label 655: @30495
    GIM_Try, /*On fail goto*//*Label 656*/ GIMT_Encode4(30532), // Rule ID 2807 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d16:{ *:[v4f16] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2807,
      GIR_EraseRootFromParent_Done,
    // Label 656: @30532
    GIM_Try, /*On fail goto*//*Label 657*/ GIMT_Encode4(30569), // Rule ID 2808 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4f16] } DPR:{ *:[v8i8] }:$src)  =>  (VREV16d8:{ *:[v4f16] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2808,
      GIR_EraseRootFromParent_Done,
    // Label 657: @30569
    GIM_Try, /*On fail goto*//*Label 658*/ GIMT_Encode4(30606), // Rule ID 2809 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[f64] }:$src)  =>  (VREV64d16:{ *:[v4i16] } DPR:{ *:[f64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2809,
      GIR_EraseRootFromParent_Done,
    // Label 658: @30606
    GIM_Try, /*On fail goto*//*Label 659*/ GIMT_Encode4(30643), // Rule ID 2810 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d16:{ *:[v4i16] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2810,
      GIR_EraseRootFromParent_Done,
    // Label 659: @30643
    GIM_Try, /*On fail goto*//*Label 660*/ GIMT_Encode4(30680), // Rule ID 2811 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d16:{ *:[v4i16] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2811,
      GIR_EraseRootFromParent_Done,
    // Label 660: @30680
    GIM_Try, /*On fail goto*//*Label 661*/ GIMT_Encode4(30717), // Rule ID 2812 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d16:{ *:[v4i16] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2812,
      GIR_EraseRootFromParent_Done,
    // Label 661: @30717
    GIM_Try, /*On fail goto*//*Label 662*/ GIMT_Encode4(30754), // Rule ID 2813 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v4i16] } DPR:{ *:[v8i8] }:$src)  =>  (VREV16d8:{ *:[v4i16] } DPR:{ *:[v8i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2813,
      GIR_EraseRootFromParent_Done,
    // Label 662: @30754
    GIM_Reject,
    // Label 544: @30755
    GIM_Try, /*On fail goto*//*Label 663*/ GIMT_Encode4(30787), // Rule ID 2708 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2708,
      GIR_EraseRootFromParent_Done,
    // Label 663: @30787
    GIM_Try, /*On fail goto*//*Label 664*/ GIMT_Encode4(30819), // Rule ID 2709 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2709,
      GIR_EraseRootFromParent_Done,
    // Label 664: @30819
    GIM_Try, /*On fail goto*//*Label 665*/ GIMT_Encode4(30851), // Rule ID 2758 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2758,
      GIR_EraseRootFromParent_Done,
    // Label 665: @30851
    GIM_Try, /*On fail goto*//*Label 666*/ GIMT_Encode4(30883), // Rule ID 2759 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2759,
      GIR_EraseRootFromParent_Done,
    // Label 666: @30883
    GIM_Try, /*On fail goto*//*Label 667*/ GIMT_Encode4(30915), // Rule ID 2760 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2760,
      GIR_EraseRootFromParent_Done,
    // Label 667: @30915
    GIM_Try, /*On fail goto*//*Label 668*/ GIMT_Encode4(30947), // Rule ID 2761 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2761,
      GIR_EraseRootFromParent_Done,
    // Label 668: @30947
    GIM_Try, /*On fail goto*//*Label 669*/ GIMT_Encode4(30979), // Rule ID 2762 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2762,
      GIR_EraseRootFromParent_Done,
    // Label 669: @30979
    GIM_Try, /*On fail goto*//*Label 670*/ GIMT_Encode4(31011), // Rule ID 2763 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2763,
      GIR_EraseRootFromParent_Done,
    // Label 670: @31011
    GIM_Try, /*On fail goto*//*Label 671*/ GIMT_Encode4(31043), // Rule ID 2764 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2764,
      GIR_EraseRootFromParent_Done,
    // Label 671: @31043
    GIM_Try, /*On fail goto*//*Label 672*/ GIMT_Encode4(31075), // Rule ID 2765 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2765,
      GIR_EraseRootFromParent_Done,
    // Label 672: @31075
    GIM_Try, /*On fail goto*//*Label 673*/ GIMT_Encode4(31107), // Rule ID 2766 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2766,
      GIR_EraseRootFromParent_Done,
    // Label 673: @31107
    GIM_Try, /*On fail goto*//*Label 674*/ GIMT_Encode4(31139), // Rule ID 2767 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2767,
      GIR_EraseRootFromParent_Done,
    // Label 674: @31139
    GIM_Try, /*On fail goto*//*Label 675*/ GIMT_Encode4(31176), // Rule ID 2830 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q32:{ *:[v4f32] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2830,
      GIR_EraseRootFromParent_Done,
    // Label 675: @31176
    GIM_Try, /*On fail goto*//*Label 676*/ GIMT_Encode4(31213), // Rule ID 2831 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q32:{ *:[v4f32] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2831,
      GIR_EraseRootFromParent_Done,
    // Label 676: @31213
    GIM_Try, /*On fail goto*//*Label 677*/ GIMT_Encode4(31250), // Rule ID 2832 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8f16] }:$src)  =>  (VREV32q16:{ *:[v4f32] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2832,
      GIR_EraseRootFromParent_Done,
    // Label 677: @31250
    GIM_Try, /*On fail goto*//*Label 678*/ GIMT_Encode4(31287), // Rule ID 2833 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v8i16] }:$src)  =>  (VREV32q16:{ *:[v4f32] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2833,
      GIR_EraseRootFromParent_Done,
    // Label 678: @31287
    GIM_Try, /*On fail goto*//*Label 679*/ GIMT_Encode4(31324), // Rule ID 2834 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4f32] } QPR:{ *:[v16i8] }:$src)  =>  (VREV32q8:{ *:[v4f32] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2834,
      GIR_EraseRootFromParent_Done,
    // Label 679: @31324
    GIM_Try, /*On fail goto*//*Label 680*/ GIMT_Encode4(31361), // Rule ID 2835 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q32:{ *:[v4i32] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2835,
      GIR_EraseRootFromParent_Done,
    // Label 680: @31361
    GIM_Try, /*On fail goto*//*Label 681*/ GIMT_Encode4(31398), // Rule ID 2836 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q32:{ *:[v4i32] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2836,
      GIR_EraseRootFromParent_Done,
    // Label 681: @31398
    GIM_Try, /*On fail goto*//*Label 682*/ GIMT_Encode4(31435), // Rule ID 2837 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8f16] }:$src)  =>  (VREV32q16:{ *:[v4i32] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2837,
      GIR_EraseRootFromParent_Done,
    // Label 682: @31435
    GIM_Try, /*On fail goto*//*Label 683*/ GIMT_Encode4(31472), // Rule ID 2838 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v8i16] }:$src)  =>  (VREV32q16:{ *:[v4i32] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2838,
      GIR_EraseRootFromParent_Done,
    // Label 683: @31472
    GIM_Try, /*On fail goto*//*Label 684*/ GIMT_Encode4(31509), // Rule ID 2839 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v4i32] } QPR:{ *:[v16i8] }:$src)  =>  (VREV32q8:{ *:[v4i32] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2839,
      GIR_EraseRootFromParent_Done,
    // Label 684: @31509
    GIM_Try, /*On fail goto*//*Label 685*/ GIMT_Encode4(31541), // Rule ID 5265 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5265,
      GIR_EraseRootFromParent_Done,
    // Label 685: @31541
    GIM_Try, /*On fail goto*//*Label 686*/ GIMT_Encode4(31573), // Rule ID 5266 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5266,
      GIR_EraseRootFromParent_Done,
    // Label 686: @31573
    GIM_Try, /*On fail goto*//*Label 687*/ GIMT_Encode4(31605), // Rule ID 5279 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5279,
      GIR_EraseRootFromParent_Done,
    // Label 687: @31605
    GIM_Try, /*On fail goto*//*Label 688*/ GIMT_Encode4(31637), // Rule ID 5280 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5280,
      GIR_EraseRootFromParent_Done,
    // Label 688: @31637
    GIM_Try, /*On fail goto*//*Label 689*/ GIMT_Encode4(31669), // Rule ID 5281 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5281,
      GIR_EraseRootFromParent_Done,
    // Label 689: @31669
    GIM_Try, /*On fail goto*//*Label 690*/ GIMT_Encode4(31701), // Rule ID 5282 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5282,
      GIR_EraseRootFromParent_Done,
    // Label 690: @31701
    GIM_Try, /*On fail goto*//*Label 691*/ GIMT_Encode4(31733), // Rule ID 5283 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v4f32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5283,
      GIR_EraseRootFromParent_Done,
    // Label 691: @31733
    GIM_Try, /*On fail goto*//*Label 692*/ GIMT_Encode4(31765), // Rule ID 5284 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5284,
      GIR_EraseRootFromParent_Done,
    // Label 692: @31765
    GIM_Try, /*On fail goto*//*Label 693*/ GIMT_Encode4(31797), // Rule ID 5285 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5285,
      GIR_EraseRootFromParent_Done,
    // Label 693: @31797
    GIM_Try, /*On fail goto*//*Label 694*/ GIMT_Encode4(31829), // Rule ID 5286 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5286,
      GIR_EraseRootFromParent_Done,
    // Label 694: @31829
    GIM_Try, /*On fail goto*//*Label 695*/ GIMT_Encode4(31861), // Rule ID 5287 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5287,
      GIR_EraseRootFromParent_Done,
    // Label 695: @31861
    GIM_Try, /*On fail goto*//*Label 696*/ GIMT_Encode4(31893), // Rule ID 5288 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v4i32] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5288,
      GIR_EraseRootFromParent_Done,
    // Label 696: @31893
    GIM_Try, /*On fail goto*//*Label 697*/ GIMT_Encode4(31951), // Rule ID 5315 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_32:{ *:[v4f32] } MQPR:{ *:[v2f64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5315,
      GIR_EraseRootFromParent_Done,
    // Label 697: @31951
    GIM_Try, /*On fail goto*//*Label 698*/ GIMT_Encode4(32009), // Rule ID 5316 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_32:{ *:[v4f32] } MQPR:{ *:[v2i64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5316,
      GIR_EraseRootFromParent_Done,
    // Label 698: @32009
    GIM_Try, /*On fail goto*//*Label 699*/ GIMT_Encode4(32067), // Rule ID 5317 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV32_16:{ *:[v4f32] } MQPR:{ *:[v8f16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5317,
      GIR_EraseRootFromParent_Done,
    // Label 699: @32067
    GIM_Try, /*On fail goto*//*Label 700*/ GIMT_Encode4(32125), // Rule ID 5318 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV32_16:{ *:[v4f32] } MQPR:{ *:[v8i16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5318,
      GIR_EraseRootFromParent_Done,
    // Label 700: @32125
    GIM_Try, /*On fail goto*//*Label 701*/ GIMT_Encode4(32183), // Rule ID 5319 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4f32] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV32_8:{ *:[v4f32] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5319,
      GIR_EraseRootFromParent_Done,
    // Label 701: @32183
    GIM_Try, /*On fail goto*//*Label 702*/ GIMT_Encode4(32241), // Rule ID 5320 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_32:{ *:[v4i32] } MQPR:{ *:[v2f64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5320,
      GIR_EraseRootFromParent_Done,
    // Label 702: @32241
    GIM_Try, /*On fail goto*//*Label 703*/ GIMT_Encode4(32299), // Rule ID 5321 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_32:{ *:[v4i32] } MQPR:{ *:[v2i64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_32),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5321,
      GIR_EraseRootFromParent_Done,
    // Label 703: @32299
    GIM_Try, /*On fail goto*//*Label 704*/ GIMT_Encode4(32357), // Rule ID 5322 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV32_16:{ *:[v4i32] } MQPR:{ *:[v8f16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5322,
      GIR_EraseRootFromParent_Done,
    // Label 704: @32357
    GIM_Try, /*On fail goto*//*Label 705*/ GIMT_Encode4(32415), // Rule ID 5323 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV32_16:{ *:[v4i32] } MQPR:{ *:[v8i16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5323,
      GIR_EraseRootFromParent_Done,
    // Label 705: @32415
    GIM_Try, /*On fail goto*//*Label 706*/ GIMT_Encode4(32473), // Rule ID 5324 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v4i32] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV32_8:{ *:[v4i32] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5324,
      GIR_EraseRootFromParent_Done,
    // Label 706: @32473
    GIM_Reject,
    // Label 545: @32474
    GIM_Try, /*On fail goto*//*Label 707*/ GIMT_Encode4(32506), // Rule ID 2742 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[f64] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2742,
      GIR_EraseRootFromParent_Done,
    // Label 707: @32506
    GIM_Try, /*On fail goto*//*Label 708*/ GIMT_Encode4(32538), // Rule ID 2743 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v1i64] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2743,
      GIR_EraseRootFromParent_Done,
    // Label 708: @32538
    GIM_Try, /*On fail goto*//*Label 709*/ GIMT_Encode4(32570), // Rule ID 2744 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2f32] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2744,
      GIR_EraseRootFromParent_Done,
    // Label 709: @32570
    GIM_Try, /*On fail goto*//*Label 710*/ GIMT_Encode4(32602), // Rule ID 2745 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2i32] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2745,
      GIR_EraseRootFromParent_Done,
    // Label 710: @32602
    GIM_Try, /*On fail goto*//*Label 711*/ GIMT_Encode4(32634), // Rule ID 2746 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4f16] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2746,
      GIR_EraseRootFromParent_Done,
    // Label 711: @32634
    GIM_Try, /*On fail goto*//*Label 712*/ GIMT_Encode4(32666), // Rule ID 2747 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4i16] }:$src)  =>  DPR:{ *:[v8i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::DPRRegClassID),
      // GIR_Coverage, 2747,
      GIR_EraseRootFromParent_Done,
    // Label 712: @32666
    GIM_Try, /*On fail goto*//*Label 713*/ GIMT_Encode4(32703), // Rule ID 2814 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[f64] }:$src)  =>  (VREV64d8:{ *:[v8i8] } DPR:{ *:[f64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2814,
      GIR_EraseRootFromParent_Done,
    // Label 713: @32703
    GIM_Try, /*On fail goto*//*Label 714*/ GIMT_Encode4(32740), // Rule ID 2815 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v1i64] }:$src)  =>  (VREV64d8:{ *:[v8i8] } DPR:{ *:[v1i64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2815,
      GIR_EraseRootFromParent_Done,
    // Label 714: @32740
    GIM_Try, /*On fail goto*//*Label 715*/ GIMT_Encode4(32777), // Rule ID 2816 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2f32] }:$src)  =>  (VREV32d8:{ *:[v8i8] } DPR:{ *:[v2f32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2816,
      GIR_EraseRootFromParent_Done,
    // Label 715: @32777
    GIM_Try, /*On fail goto*//*Label 716*/ GIMT_Encode4(32814), // Rule ID 2817 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v2i32] }:$src)  =>  (VREV32d8:{ *:[v8i8] } DPR:{ *:[v2i32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2817,
      GIR_EraseRootFromParent_Done,
    // Label 716: @32814
    GIM_Try, /*On fail goto*//*Label 717*/ GIMT_Encode4(32851), // Rule ID 2818 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4f16] }:$src)  =>  (VREV16d8:{ *:[v8i8] } DPR:{ *:[v4f16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2818,
      GIR_EraseRootFromParent_Done,
    // Label 717: @32851
    GIM_Try, /*On fail goto*//*Label 718*/ GIMT_Encode4(32888), // Rule ID 2819 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (bitconvert:{ *:[v8i8] } DPR:{ *:[v4i16] }:$src)  =>  (VREV16d8:{ *:[v8i8] } DPR:{ *:[v4i16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16d8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2819,
      GIR_EraseRootFromParent_Done,
    // Label 718: @32888
    GIM_Reject,
    // Label 546: @32889
    GIM_Try, /*On fail goto*//*Label 719*/ GIMT_Encode4(32921), // Rule ID 2710 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2710,
      GIR_EraseRootFromParent_Done,
    // Label 719: @32921
    GIM_Try, /*On fail goto*//*Label 720*/ GIMT_Encode4(32953), // Rule ID 2711 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2711,
      GIR_EraseRootFromParent_Done,
    // Label 720: @32953
    GIM_Try, /*On fail goto*//*Label 721*/ GIMT_Encode4(32985), // Rule ID 2768 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2768,
      GIR_EraseRootFromParent_Done,
    // Label 721: @32985
    GIM_Try, /*On fail goto*//*Label 722*/ GIMT_Encode4(33017), // Rule ID 2769 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2769,
      GIR_EraseRootFromParent_Done,
    // Label 722: @33017
    GIM_Try, /*On fail goto*//*Label 723*/ GIMT_Encode4(33049), // Rule ID 2770 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2770,
      GIR_EraseRootFromParent_Done,
    // Label 723: @33049
    GIM_Try, /*On fail goto*//*Label 724*/ GIMT_Encode4(33081), // Rule ID 2771 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2771,
      GIR_EraseRootFromParent_Done,
    // Label 724: @33081
    GIM_Try, /*On fail goto*//*Label 725*/ GIMT_Encode4(33113), // Rule ID 2772 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2772,
      GIR_EraseRootFromParent_Done,
    // Label 725: @33113
    GIM_Try, /*On fail goto*//*Label 726*/ GIMT_Encode4(33145), // Rule ID 2773 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2773,
      GIR_EraseRootFromParent_Done,
    // Label 726: @33145
    GIM_Try, /*On fail goto*//*Label 727*/ GIMT_Encode4(33177), // Rule ID 2774 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2774,
      GIR_EraseRootFromParent_Done,
    // Label 727: @33177
    GIM_Try, /*On fail goto*//*Label 728*/ GIMT_Encode4(33209), // Rule ID 2775 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2775,
      GIR_EraseRootFromParent_Done,
    // Label 728: @33209
    GIM_Try, /*On fail goto*//*Label 729*/ GIMT_Encode4(33241), // Rule ID 2776 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2776,
      GIR_EraseRootFromParent_Done,
    // Label 729: @33241
    GIM_Try, /*On fail goto*//*Label 730*/ GIMT_Encode4(33273), // Rule ID 2777 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v16i8] }:$src)  =>  QPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2777,
      GIR_EraseRootFromParent_Done,
    // Label 730: @33273
    GIM_Try, /*On fail goto*//*Label 731*/ GIMT_Encode4(33310), // Rule ID 2840 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q16:{ *:[v8f16] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2840,
      GIR_EraseRootFromParent_Done,
    // Label 731: @33310
    GIM_Try, /*On fail goto*//*Label 732*/ GIMT_Encode4(33347), // Rule ID 2841 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q16:{ *:[v8f16] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2841,
      GIR_EraseRootFromParent_Done,
    // Label 732: @33347
    GIM_Try, /*On fail goto*//*Label 733*/ GIMT_Encode4(33384), // Rule ID 2842 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q16:{ *:[v8f16] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2842,
      GIR_EraseRootFromParent_Done,
    // Label 733: @33384
    GIM_Try, /*On fail goto*//*Label 734*/ GIMT_Encode4(33421), // Rule ID 2843 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q16:{ *:[v8f16] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2843,
      GIR_EraseRootFromParent_Done,
    // Label 734: @33421
    GIM_Try, /*On fail goto*//*Label 735*/ GIMT_Encode4(33458), // Rule ID 2844 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8f16] } QPR:{ *:[v16i8] }:$src)  =>  (VREV16q8:{ *:[v8f16] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2844,
      GIR_EraseRootFromParent_Done,
    // Label 735: @33458
    GIM_Try, /*On fail goto*//*Label 736*/ GIMT_Encode4(33495), // Rule ID 2845 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q16:{ *:[v8i16] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2845,
      GIR_EraseRootFromParent_Done,
    // Label 736: @33495
    GIM_Try, /*On fail goto*//*Label 737*/ GIMT_Encode4(33532), // Rule ID 2846 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q16:{ *:[v8i16] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2846,
      GIR_EraseRootFromParent_Done,
    // Label 737: @33532
    GIM_Try, /*On fail goto*//*Label 738*/ GIMT_Encode4(33569), // Rule ID 2847 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q16:{ *:[v8i16] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2847,
      GIR_EraseRootFromParent_Done,
    // Label 738: @33569
    GIM_Try, /*On fail goto*//*Label 739*/ GIMT_Encode4(33606), // Rule ID 2848 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q16:{ *:[v8i16] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2848,
      GIR_EraseRootFromParent_Done,
    // Label 739: @33606
    GIM_Try, /*On fail goto*//*Label 740*/ GIMT_Encode4(33643), // Rule ID 2849 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v8i16] } QPR:{ *:[v16i8] }:$src)  =>  (VREV16q8:{ *:[v8i16] } QPR:{ *:[v16i8] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2849,
      GIR_EraseRootFromParent_Done,
    // Label 740: @33643
    GIM_Try, /*On fail goto*//*Label 741*/ GIMT_Encode4(33675), // Rule ID 5267 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5267,
      GIR_EraseRootFromParent_Done,
    // Label 741: @33675
    GIM_Try, /*On fail goto*//*Label 742*/ GIMT_Encode4(33707), // Rule ID 5268 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5268,
      GIR_EraseRootFromParent_Done,
    // Label 742: @33707
    GIM_Try, /*On fail goto*//*Label 743*/ GIMT_Encode4(33739), // Rule ID 5289 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5289,
      GIR_EraseRootFromParent_Done,
    // Label 743: @33739
    GIM_Try, /*On fail goto*//*Label 744*/ GIMT_Encode4(33771), // Rule ID 5290 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5290,
      GIR_EraseRootFromParent_Done,
    // Label 744: @33771
    GIM_Try, /*On fail goto*//*Label 745*/ GIMT_Encode4(33803), // Rule ID 5291 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5291,
      GIR_EraseRootFromParent_Done,
    // Label 745: @33803
    GIM_Try, /*On fail goto*//*Label 746*/ GIMT_Encode4(33835), // Rule ID 5292 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5292,
      GIR_EraseRootFromParent_Done,
    // Label 746: @33835
    GIM_Try, /*On fail goto*//*Label 747*/ GIMT_Encode4(33867), // Rule ID 5293 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v8f16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5293,
      GIR_EraseRootFromParent_Done,
    // Label 747: @33867
    GIM_Try, /*On fail goto*//*Label 748*/ GIMT_Encode4(33899), // Rule ID 5294 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5294,
      GIR_EraseRootFromParent_Done,
    // Label 748: @33899
    GIM_Try, /*On fail goto*//*Label 749*/ GIMT_Encode4(33931), // Rule ID 5295 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5295,
      GIR_EraseRootFromParent_Done,
    // Label 749: @33931
    GIM_Try, /*On fail goto*//*Label 750*/ GIMT_Encode4(33963), // Rule ID 5296 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5296,
      GIR_EraseRootFromParent_Done,
    // Label 750: @33963
    GIM_Try, /*On fail goto*//*Label 751*/ GIMT_Encode4(33995), // Rule ID 5297 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5297,
      GIR_EraseRootFromParent_Done,
    // Label 751: @33995
    GIM_Try, /*On fail goto*//*Label 752*/ GIMT_Encode4(34027), // Rule ID 5298 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v16i8] }:$src)  =>  MQPR:{ *:[v8i16] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5298,
      GIR_EraseRootFromParent_Done,
    // Label 752: @34027
    GIM_Try, /*On fail goto*//*Label 753*/ GIMT_Encode4(34085), // Rule ID 5325 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_16:{ *:[v8f16] } MQPR:{ *:[v2f64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5325,
      GIR_EraseRootFromParent_Done,
    // Label 753: @34085
    GIM_Try, /*On fail goto*//*Label 754*/ GIMT_Encode4(34143), // Rule ID 5326 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_16:{ *:[v8f16] } MQPR:{ *:[v2i64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5326,
      GIR_EraseRootFromParent_Done,
    // Label 754: @34143
    GIM_Try, /*On fail goto*//*Label 755*/ GIMT_Encode4(34201), // Rule ID 5327 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV32_16:{ *:[v8f16] } MQPR:{ *:[v4f32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5327,
      GIR_EraseRootFromParent_Done,
    // Label 755: @34201
    GIM_Try, /*On fail goto*//*Label 756*/ GIMT_Encode4(34259), // Rule ID 5328 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV32_16:{ *:[v8f16] } MQPR:{ *:[v4i32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5328,
      GIR_EraseRootFromParent_Done,
    // Label 756: @34259
    GIM_Try, /*On fail goto*//*Label 757*/ GIMT_Encode4(34317), // Rule ID 5329 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8f16] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV16_8:{ *:[v8f16] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV16_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5329,
      GIR_EraseRootFromParent_Done,
    // Label 757: @34317
    GIM_Try, /*On fail goto*//*Label 758*/ GIMT_Encode4(34375), // Rule ID 5330 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_16:{ *:[v8i16] } MQPR:{ *:[v2f64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5330,
      GIR_EraseRootFromParent_Done,
    // Label 758: @34375
    GIM_Try, /*On fail goto*//*Label 759*/ GIMT_Encode4(34433), // Rule ID 5331 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_16:{ *:[v8i16] } MQPR:{ *:[v2i64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5331,
      GIR_EraseRootFromParent_Done,
    // Label 759: @34433
    GIM_Try, /*On fail goto*//*Label 760*/ GIMT_Encode4(34491), // Rule ID 5332 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV32_16:{ *:[v8i16] } MQPR:{ *:[v4f32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5332,
      GIR_EraseRootFromParent_Done,
    // Label 760: @34491
    GIM_Try, /*On fail goto*//*Label 761*/ GIMT_Encode4(34549), // Rule ID 5333 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV32_16:{ *:[v8i16] } MQPR:{ *:[v4i32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_16),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5333,
      GIR_EraseRootFromParent_Done,
    // Label 761: @34549
    GIM_Try, /*On fail goto*//*Label 762*/ GIMT_Encode4(34607), // Rule ID 5334 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v8i16] } MQPR:{ *:[v16i8] }:$src)  =>  (MVE_VREV16_8:{ *:[v8i16] } MQPR:{ *:[v16i8] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV16_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5334,
      GIR_EraseRootFromParent_Done,
    // Label 762: @34607
    GIM_Reject,
    // Label 547: @34608
    GIM_Try, /*On fail goto*//*Label 763*/ GIMT_Encode4(34640), // Rule ID 2778 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2f64] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2778,
      GIR_EraseRootFromParent_Done,
    // Label 763: @34640
    GIM_Try, /*On fail goto*//*Label 764*/ GIMT_Encode4(34672), // Rule ID 2779 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2i64] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2779,
      GIR_EraseRootFromParent_Done,
    // Label 764: @34672
    GIM_Try, /*On fail goto*//*Label 765*/ GIMT_Encode4(34704), // Rule ID 2780 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4f32] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2780,
      GIR_EraseRootFromParent_Done,
    // Label 765: @34704
    GIM_Try, /*On fail goto*//*Label 766*/ GIMT_Encode4(34736), // Rule ID 2781 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4i32] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2781,
      GIR_EraseRootFromParent_Done,
    // Label 766: @34736
    GIM_Try, /*On fail goto*//*Label 767*/ GIMT_Encode4(34768), // Rule ID 2782 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8f16] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2782,
      GIR_EraseRootFromParent_Done,
    // Label 767: @34768
    GIM_Try, /*On fail goto*//*Label 768*/ GIMT_Encode4(34800), // Rule ID 2783 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8i16] }:$src)  =>  QPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::QPRRegClassID),
      // GIR_Coverage, 2783,
      GIR_EraseRootFromParent_Done,
    // Label 768: @34800
    GIM_Try, /*On fail goto*//*Label 769*/ GIMT_Encode4(34837), // Rule ID 2850 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2f64] }:$src)  =>  (VREV64q8:{ *:[v16i8] } QPR:{ *:[v2f64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2850,
      GIR_EraseRootFromParent_Done,
    // Label 769: @34837
    GIM_Try, /*On fail goto*//*Label 770*/ GIMT_Encode4(34874), // Rule ID 2851 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v2i64] }:$src)  =>  (VREV64q8:{ *:[v16i8] } QPR:{ *:[v2i64] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV64q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2851,
      GIR_EraseRootFromParent_Done,
    // Label 770: @34874
    GIM_Try, /*On fail goto*//*Label 771*/ GIMT_Encode4(34911), // Rule ID 2852 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4f32] }:$src)  =>  (VREV32q8:{ *:[v16i8] } QPR:{ *:[v4f32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2852,
      GIR_EraseRootFromParent_Done,
    // Label 771: @34911
    GIM_Try, /*On fail goto*//*Label 772*/ GIMT_Encode4(34948), // Rule ID 2853 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v4i32] }:$src)  =>  (VREV32q8:{ *:[v16i8] } QPR:{ *:[v4i32] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV32q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2853,
      GIR_EraseRootFromParent_Done,
    // Label 772: @34948
    GIM_Try, /*On fail goto*//*Label 773*/ GIMT_Encode4(34985), // Rule ID 2854 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8f16] }:$src)  =>  (VREV16q8:{ *:[v16i8] } QPR:{ *:[v8f16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2854,
      GIR_EraseRootFromParent_Done,
    // Label 773: @34985
    GIM_Try, /*On fail goto*//*Label 774*/ GIMT_Encode4(35022), // Rule ID 2855 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
      // (bitconvert:{ *:[v16i8] } QPR:{ *:[v8i16] }:$src)  =>  (VREV16q8:{ *:[v16i8] } QPR:{ *:[v8i16] }:$src)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VREV16q8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2855,
      GIR_EraseRootFromParent_Done,
    // Label 774: @35022
    GIM_Try, /*On fail goto*//*Label 775*/ GIMT_Encode4(35054), // Rule ID 5299 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v2f64] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5299,
      GIR_EraseRootFromParent_Done,
    // Label 775: @35054
    GIM_Try, /*On fail goto*//*Label 776*/ GIMT_Encode4(35086), // Rule ID 5300 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v2i64] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5300,
      GIR_EraseRootFromParent_Done,
    // Label 776: @35086
    GIM_Try, /*On fail goto*//*Label 777*/ GIMT_Encode4(35118), // Rule ID 5301 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v4f32] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5301,
      GIR_EraseRootFromParent_Done,
    // Label 777: @35118
    GIM_Try, /*On fail goto*//*Label 778*/ GIMT_Encode4(35150), // Rule ID 5302 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v4i32] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5302,
      GIR_EraseRootFromParent_Done,
    // Label 778: @35150
    GIM_Try, /*On fail goto*//*Label 779*/ GIMT_Encode4(35182), // Rule ID 5303 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v8f16] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5303,
      GIR_EraseRootFromParent_Done,
    // Label 779: @35182
    GIM_Try, /*On fail goto*//*Label 780*/ GIMT_Encode4(35214), // Rule ID 5304 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsLE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v8i16] }:$src)  =>  MQPR:{ *:[v16i8] }:$src
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // dst
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::MQPRRegClassID),
      // GIR_Coverage, 5304,
      GIR_EraseRootFromParent_Done,
    // Label 780: @35214
    GIM_Try, /*On fail goto*//*Label 781*/ GIMT_Encode4(35272), // Rule ID 5335 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v2f64] }:$src)  =>  (MVE_VREV64_8:{ *:[v16i8] } MQPR:{ *:[v2f64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5335,
      GIR_EraseRootFromParent_Done,
    // Label 781: @35272
    GIM_Try, /*On fail goto*//*Label 782*/ GIMT_Encode4(35330), // Rule ID 5336 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v2i64] }:$src)  =>  (MVE_VREV64_8:{ *:[v16i8] } MQPR:{ *:[v2i64] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV64_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5336,
      GIR_EraseRootFromParent_Done,
    // Label 782: @35330
    GIM_Try, /*On fail goto*//*Label 783*/ GIMT_Encode4(35388), // Rule ID 5337 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v4f32] }:$src)  =>  (MVE_VREV32_8:{ *:[v16i8] } MQPR:{ *:[v4f32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5337,
      GIR_EraseRootFromParent_Done,
    // Label 783: @35388
    GIM_Try, /*On fail goto*//*Label 784*/ GIMT_Encode4(35446), // Rule ID 5338 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v4i32] }:$src)  =>  (MVE_VREV32_8:{ *:[v16i8] } MQPR:{ *:[v4i32] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV32_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5338,
      GIR_EraseRootFromParent_Done,
    // Label 784: @35446
    GIM_Try, /*On fail goto*//*Label 785*/ GIMT_Encode4(35504), // Rule ID 5339 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v8f16] }:$src)  =>  (MVE_VREV16_8:{ *:[v16i8] } MQPR:{ *:[v8f16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV16_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5339,
      GIR_EraseRootFromParent_Done,
    // Label 785: @35504
    GIM_Try, /*On fail goto*//*Label 786*/ GIMT_Encode4(35562), // Rule ID 5340 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt_IsBE),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (bitconvert:{ *:[v16i8] } MQPR:{ *:[v8i16] }:$src)  =>  (MVE_VREV16_8:{ *:[v16i8] } MQPR:{ *:[v8i16] }:$src)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VREV16_8),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5340,
      GIR_EraseRootFromParent_Done,
    // Label 786: @35562
    GIM_Reject,
    // Label 548: @35563
    GIM_Reject,
    // Label 10: @35564
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(13), /*)*//*default:*//*Label 792*/ GIMT_Encode4(35859),
    /*GILLT_s16*//*Label 787*/ GIMT_Encode4(35627),
    /*GILLT_s32*//*Label 788*/ GIMT_Encode4(35665),
    /*GILLT_s64*//*Label 789*/ GIMT_Encode4(35703), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 790*/ GIMT_Encode4(35741), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s16*//*Label 791*/ GIMT_Encode4(35800),
    // Label 787: @35627
    GIM_Try, /*On fail goto*//*Label 793*/ GIMT_Encode4(35664), // Rule ID 665 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::HPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::HPRRegClassID),
      // (ftrunc:{ *:[f16] } HPR:{ *:[f16] }:$Sm)  =>  (VRINTZH:{ *:[f16] } HPR:{ *:[f16] }:$Sm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTZH),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Sd]
      GIR_RootToRootCopy, /*OpIdx*/1, // Sm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 665,
      GIR_EraseRootFromParent_Done,
    // Label 793: @35664
    GIM_Reject,
    // Label 788: @35665
    GIM_Try, /*On fail goto*//*Label 794*/ GIMT_Encode4(35702), // Rule ID 666 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPARMv8),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
      // (ftrunc:{ *:[f32] } SPR:{ *:[f32] }:$Sm)  =>  (VRINTZS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTZS),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Sd]
      GIR_RootToRootCopy, /*OpIdx*/1, // Sm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 666,
      GIR_EraseRootFromParent_Done,
    // Label 794: @35702
    GIM_Reject,
    // Label 789: @35703
    GIM_Try, /*On fail goto*//*Label 795*/ GIMT_Encode4(35740), // Rule ID 667 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDPVFP_HasFPARMv8),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (ftrunc:{ *:[f64] } DPR:{ *:[f64] }:$Dm)  =>  (VRINTZD:{ *:[f64] } DPR:{ *:[f64] }:$Dm)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTZD),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Dd]
      GIR_RootToRootCopy, /*OpIdx*/1, // Dm
      GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 667,
      GIR_EraseRootFromParent_Done,
    // Label 795: @35740
    GIM_Reject,
    // Label 790: @35741
    GIM_Try, /*On fail goto*//*Label 796*/ GIMT_Encode4(35799), // Rule ID 3962 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (ftrunc:{ *:[v4f32] } MQPR:{ *:[v4f32] }:$val)  =>  (MVE_VRINTf32Z:{ *:[v4f32] } MQPR:{ *:[v4f32] }:$val)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VRINTf32Z),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // val
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 3962,
      GIR_EraseRootFromParent_Done,
    // Label 796: @35799
    GIM_Reject,
    // Label 791: @35800
    GIM_Try, /*On fail goto*//*Label 797*/ GIMT_Encode4(35858), // Rule ID 3950 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (ftrunc:{ *:[v8f16] } MQPR:{ *:[v8f16] }:$val)  =>  (MVE_VRINTf16Z:{ *:[v8f16] } MQPR:{ *:[v8f16] }:$val)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VRINTf16Z),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // val
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 3950,
      GIR_EraseRootFromParent_Done,
    // Label 797: @35858
    GIM_Reject,
    // Label 792: @35859
    GIM_Reject,
    // Label 11: @35860
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(13), /*)*//*default:*//*Label 803*/ GIMT_Encode4(36122),
    /*GILLT_s16*//*Label 798*/ GIMT_Encode4(35923),
    /*GILLT_s32*//*Label 799*/ GIMT_Encode4(35950),
    /*GILLT_s64*//*Label 800*/ GIMT_Encode4(35977), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 801*/ GIMT_Encode4(36004), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s16*//*Label 802*/ GIMT_Encode4(36063),
    // Label 798: @35923
    GIM_Try, /*On fail goto*//*Label 804*/ GIMT_Encode4(35949), // Rule ID 674 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::HPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::HPRRegClassID),
      // (fround:{ *:[f16] } HPR:{ *:[f16] }:$Sm)  =>  (VRINTAH:{ *:[f16] } HPR:{ *:[f16] }:$Sm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRINTAH),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 674,
      GIR_Done,
    // Label 804: @35949
    GIM_Reject,
    // Label 799: @35950
    GIM_Try, /*On fail goto*//*Label 805*/ GIMT_Encode4(35976), // Rule ID 675 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPARMv8),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
      // (fround:{ *:[f32] } SPR:{ *:[f32] }:$Sm)  =>  (VRINTAS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRINTAS),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 675,
      GIR_Done,
    // Label 805: @35976
    GIM_Reject,
    // Label 800: @35977
    GIM_Try, /*On fail goto*//*Label 806*/ GIMT_Encode4(36003), // Rule ID 676 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDPVFP_HasFPARMv8),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
      // (fround:{ *:[f64] } DPR:{ *:[f64] }:$Dm)  =>  (VRINTAD:{ *:[f64] } DPR:{ *:[f64] }:$Dm)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(ARM::VRINTAD),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 676,
      GIR_Done,
    // Label 806: @36003
    GIM_Reject,
    // Label 801: @36004
    GIM_Try, /*On fail goto*//*Label 807*/ GIMT_Encode4(36062), // Rule ID 3960 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (fround:{ *:[v4f32] } MQPR:{ *:[v4f32] }:$val)  =>  (MVE_VRINTf32A:{ *:[v4f32] } MQPR:{ *:[v4f32] }:$val)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VRINTf32A),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // val
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 3960,
      GIR_EraseRootFromParent_Done,
    // Label 807: @36062
    GIM_Reject,
    // Label 802: @36063
    GIM_Try, /*On fail goto*//*Label 808*/ GIMT_Encode4(36121), // Rule ID 3948 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
      // (fround:{ *:[v8f16] } MQPR:{ *:[v8f16] }:$val)  =>  (MVE_VRINTf16A:{ *:[v8f16] } MQPR:{ *:[v8f16] }:$val)
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VRINTf16A),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
      GIR_RootToRootCopy, /*OpIdx*/1, // val
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 3948,
      GIR_EraseRootFromParent_Done,
    // Label 808: @36121
    GIM_Reject,
    // Label 803: @36122
    GIM_Reject,
    // Label 12: @36123
    GIM_Try, /*On fail goto*//*Label 809*/ GIMT_Encode4(36285),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
      GIM_CheckAtomicOrdering, /*MI*/0, /*Order*/(uint8_t)AtomicOrdering::NotAtomic,
      GIM_Try, /*On fail goto*//*Label 810*/ GIMT_Encode4(36209), // Rule ID 2045 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsThumb_IsThumb1Only),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(1),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        // (ld:{ *:[i32] } tGPR:{ *:[i32] }:$Rn)<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi8>>  =>  (tLDRSB:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, (tMOVi8:{ *:[i32] } 0:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::tMOVi8),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
        GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tLDRSB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rt]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2045,
        GIR_EraseRootFromParent_Done,
      // Label 810: @36209
      GIM_Try, /*On fail goto*//*Label 811*/ GIMT_Encode4(36284), // Rule ID 2046 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsThumb_IsThumb1Only),
        GIM_CheckMemorySizeEqualTo, /*MI*/0, /*MMO*/0, /*Size*/GIMT_Encode4(2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(ARM::tGPRRegClassID),
        // (ld:{ *:[i32] } tGPR:{ *:[i32] }:$Rn)<<P:Predicate_unindexedload>><<P:Predicate_sextload>><<P:Predicate_sextloadi16>>  =>  (tLDRSH:{ *:[i32] } tGPR:{ *:[i32] }:$Rn, (tMOVi8:{ *:[i32] } 0:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(ARM::tMOVi8),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::CPSR), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define | RegState::Dead),
        GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::tLDRSH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rt]
        GIR_RootToRootCopy, /*OpIdx*/1, // Rn
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2046,
        GIR_EraseRootFromParent_Done,
      // Label 811: @36284
      GIM_Reject,
    // Label 809: @36285
    GIM_Reject,
    // Label 13: @36286
    GIM_Try, /*On fail goto*//*Label 812*/ GIMT_Encode4(36306), // Rule ID 5401 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      // MIs[0] Operand 0
      GIM_CheckIsImm, /*MI*/0, /*Op*/0,
      GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
      // (atomic_fence (timm:{ *:[i32] }), 0:{ *:[i32] })  =>  (MEMBARRIER)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::MEMBARRIER),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5401,
      GIR_EraseRootFromParent_Done,
    // Label 812: @36306
    GIM_Reject,
    // Label 14: @36307
    GIM_Try, /*On fail goto*//*Label 813*/ GIMT_Encode4(42122),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 814*/ GIMT_Encode4(36363), // Rule ID 1853 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_uxtb16),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 3811:{ *:[iPTR] }, GPR:{ *:[i32] }:$Src)  =>  (UXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::UXTB16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1853,
        GIR_EraseRootFromParent_Done,
      // Label 814: @36363
      GIM_Try, /*On fail goto*//*Label 815*/ GIMT_Encode4(36411), // Rule ID 2098 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_uxtb16),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 3811:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rm)  =>  (t2UXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTB16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2098,
        GIR_EraseRootFromParent_Done,
      // Label 815: @36411
      GIM_Try, /*On fail goto*//*Label 816*/ GIMT_Encode4(36447), // Rule ID 677 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::HPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::HPRRegClassID),
        // (intrinsic_wo_chain:{ *:[f16] } 3697:{ *:[iPTR] }, HPR:{ *:[f16] }:$Sm)  =>  (VRINTNH:{ *:[f16] } HPR:{ *:[f16] }:$Sm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTNH),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Sd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Sm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 677,
        GIR_EraseRootFromParent_Done,
      // Label 816: @36447
      GIM_Try, /*On fail goto*//*Label 817*/ GIMT_Encode4(36483), // Rule ID 678 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFPARMv8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 3697:{ *:[iPTR] }, SPR:{ *:[f32] }:$Sm)  =>  (VRINTNS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTNS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Sd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Sm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 678,
        GIR_EraseRootFromParent_Done,
      // Label 817: @36483
      GIM_Try, /*On fail goto*//*Label 818*/ GIMT_Encode4(36519), // Rule ID 679 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDPVFP_HasFPARMv8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[f64] } 3697:{ *:[iPTR] }, DPR:{ *:[f64] }:$Dm)  =>  (VRINTND:{ *:[f64] } DPR:{ *:[f64] }:$Dm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Dd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Dm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 679,
        GIR_EraseRootFromParent_Done,
      // Label 818: @36519
      GIM_Try, /*On fail goto*//*Label 819*/ GIMT_Encode4(36564), // Rule ID 693 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDPVFP_HasVFP2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_vcvtr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 3812:{ *:[iPTR] }, DPR:{ *:[f64] }:$Dm)  =>  (VTOSIRD:{ *:[f32] } DPR:{ *:[f64] }:$Dm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VTOSIRD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Sd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Dm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 693,
        GIR_EraseRootFromParent_Done,
      // Label 819: @36564
      GIM_Try, /*On fail goto*//*Label 820*/ GIMT_Encode4(36609), // Rule ID 694 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_DontUseNEONForFP_HasVFP2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_vcvtr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 3812:{ *:[iPTR] }, SPR:{ *:[f32] }:$Sm)  =>  (VTOSIRS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VTOSIRS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Sd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Sm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 694,
        GIR_EraseRootFromParent_Done,
      // Label 820: @36609
      GIM_Try, /*On fail goto*//*Label 821*/ GIMT_Encode4(36654), // Rule ID 695 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDPVFP_HasVFP2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_vcvtru),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 3813:{ *:[iPTR] }, DPR:{ *:[f64] }:$Dm)  =>  (VTOUIRD:{ *:[f32] } DPR:{ *:[f64] }:$Dm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VTOUIRD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Sd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Dm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 695,
        GIR_EraseRootFromParent_Done,
      // Label 821: @36654
      GIM_Try, /*On fail goto*//*Label 822*/ GIMT_Encode4(36699), // Rule ID 696 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_DontUseNEONForFP_HasVFP2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_vcvtru),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::SPRRegClassID),
        // (intrinsic_wo_chain:{ *:[f32] } 3813:{ *:[iPTR] }, SPR:{ *:[f32] }:$Sm)  =>  (VTOUIRS:{ *:[f32] } SPR:{ *:[f32] }:$Sm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VTOUIRS),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Sd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Sm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 696,
        GIR_EraseRootFromParent_Done,
      // Label 822: @36699
      GIM_Try, /*On fail goto*//*Label 823*/ GIMT_Encode4(36744), // Rule ID 1239 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3663:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VPADDLsv8i8:{ *:[v4i16] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLsv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1239,
        GIR_EraseRootFromParent_Done,
      // Label 823: @36744
      GIM_Try, /*On fail goto*//*Label 824*/ GIMT_Encode4(36789), // Rule ID 1240 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3663:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VPADDLsv4i16:{ *:[v2i32] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLsv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1240,
        GIR_EraseRootFromParent_Done,
      // Label 824: @36789
      GIM_Try, /*On fail goto*//*Label 825*/ GIMT_Encode4(36834), // Rule ID 1241 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i64] } 3663:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VPADDLsv2i32:{ *:[v1i64] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLsv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1241,
        GIR_EraseRootFromParent_Done,
      // Label 825: @36834
      GIM_Try, /*On fail goto*//*Label 826*/ GIMT_Encode4(36879), // Rule ID 1242 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3663:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VPADDLsv16i8:{ *:[v8i16] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLsv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1242,
        GIR_EraseRootFromParent_Done,
      // Label 826: @36879
      GIM_Try, /*On fail goto*//*Label 827*/ GIMT_Encode4(36924), // Rule ID 1243 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3663:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VPADDLsv8i16:{ *:[v4i32] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLsv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1243,
        GIR_EraseRootFromParent_Done,
      // Label 827: @36924
      GIM_Try, /*On fail goto*//*Label 828*/ GIMT_Encode4(36969), // Rule ID 1244 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 3663:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VPADDLsv4i32:{ *:[v2i64] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLsv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1244,
        GIR_EraseRootFromParent_Done,
      // Label 828: @36969
      GIM_Try, /*On fail goto*//*Label 829*/ GIMT_Encode4(37014), // Rule ID 1245 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddlu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3664:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VPADDLuv8i8:{ *:[v4i16] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLuv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1245,
        GIR_EraseRootFromParent_Done,
      // Label 829: @37014
      GIM_Try, /*On fail goto*//*Label 830*/ GIMT_Encode4(37059), // Rule ID 1246 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddlu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3664:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VPADDLuv4i16:{ *:[v2i32] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLuv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1246,
        GIR_EraseRootFromParent_Done,
      // Label 830: @37059
      GIM_Try, /*On fail goto*//*Label 831*/ GIMT_Encode4(37104), // Rule ID 1247 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddlu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v1i64] } 3664:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VPADDLuv2i32:{ *:[v1i64] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLuv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1247,
        GIR_EraseRootFromParent_Done,
      // Label 831: @37104
      GIM_Try, /*On fail goto*//*Label 832*/ GIMT_Encode4(37149), // Rule ID 1248 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddlu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3664:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VPADDLuv16i8:{ *:[v8i16] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLuv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1248,
        GIR_EraseRootFromParent_Done,
      // Label 832: @37149
      GIM_Try, /*On fail goto*//*Label 833*/ GIMT_Encode4(37194), // Rule ID 1249 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddlu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3664:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VPADDLuv8i16:{ *:[v4i32] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLuv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1249,
        GIR_EraseRootFromParent_Done,
      // Label 833: @37194
      GIM_Try, /*On fail goto*//*Label 834*/ GIMT_Encode4(37239), // Rule ID 1250 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vpaddlu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 3664:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VPADDLuv4i32:{ *:[v2i64] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VPADDLuv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1250,
        GIR_EraseRootFromParent_Done,
      // Label 834: @37239
      GIM_Try, /*On fail goto*//*Label 835*/ GIMT_Encode4(37284), // Rule ID 1279 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrecpe),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3691:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VRECPEd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRECPEd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1279,
        GIR_EraseRootFromParent_Done,
      // Label 835: @37284
      GIM_Try, /*On fail goto*//*Label 836*/ GIMT_Encode4(37329), // Rule ID 1280 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrecpe),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3691:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VRECPEq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRECPEq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1280,
        GIR_EraseRootFromParent_Done,
      // Label 836: @37329
      GIM_Try, /*On fail goto*//*Label 837*/ GIMT_Encode4(37374), // Rule ID 1281 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrecpe),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f32] } 3691:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRECPEfd:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRECPEfd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1281,
        GIR_EraseRootFromParent_Done,
      // Label 837: @37374
      GIM_Try, /*On fail goto*//*Label 838*/ GIMT_Encode4(37419), // Rule ID 1282 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrecpe),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 3691:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRECPEfq:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRECPEfq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1282,
        GIR_EraseRootFromParent_Done,
      // Label 838: @37419
      GIM_Try, /*On fail goto*//*Label 839*/ GIMT_Encode4(37464), // Rule ID 1283 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrecpe),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f16] } 3691:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRECPEhd:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRECPEhd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1283,
        GIR_EraseRootFromParent_Done,
      // Label 839: @37464
      GIM_Try, /*On fail goto*//*Label 840*/ GIMT_Encode4(37509), // Rule ID 1284 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrecpe),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 3691:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRECPEhq:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRECPEhq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1284,
        GIR_EraseRootFromParent_Done,
      // Label 840: @37509
      GIM_Try, /*On fail goto*//*Label 841*/ GIMT_Encode4(37554), // Rule ID 1289 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrsqrte),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3704:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VRSQRTEd:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRSQRTEd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1289,
        GIR_EraseRootFromParent_Done,
      // Label 841: @37554
      GIM_Try, /*On fail goto*//*Label 842*/ GIMT_Encode4(37599), // Rule ID 1290 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrsqrte),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3704:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VRSQRTEq:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRSQRTEq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1290,
        GIR_EraseRootFromParent_Done,
      // Label 842: @37599
      GIM_Try, /*On fail goto*//*Label 843*/ GIMT_Encode4(37644), // Rule ID 1291 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrsqrte),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f32] } 3704:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRSQRTEfd:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRSQRTEfd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1291,
        GIR_EraseRootFromParent_Done,
      // Label 843: @37644
      GIM_Try, /*On fail goto*//*Label 844*/ GIMT_Encode4(37689), // Rule ID 1292 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrsqrte),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 3704:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRSQRTEfq:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRSQRTEfq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1292,
        GIR_EraseRootFromParent_Done,
      // Label 844: @37689
      GIM_Try, /*On fail goto*//*Label 845*/ GIMT_Encode4(37734), // Rule ID 1293 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrsqrte),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f16] } 3704:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRSQRTEhd:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRSQRTEhd),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1293,
        GIR_EraseRootFromParent_Done,
      // Label 845: @37734
      GIM_Try, /*On fail goto*//*Label 846*/ GIMT_Encode4(37779), // Rule ID 1294 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrsqrte),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 3704:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRSQRTEhq:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRSQRTEhq),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1294,
        GIR_EraseRootFromParent_Done,
      // Label 846: @37779
      GIM_Try, /*On fail goto*//*Label 847*/ GIMT_Encode4(37824), // Rule ID 1515 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqabs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i8] } 3669:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VQABSv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQABSv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1515,
        GIR_EraseRootFromParent_Done,
      // Label 847: @37824
      GIM_Try, /*On fail goto*//*Label 848*/ GIMT_Encode4(37869), // Rule ID 1516 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqabs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3669:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VQABSv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQABSv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1516,
        GIR_EraseRootFromParent_Done,
      // Label 848: @37869
      GIM_Try, /*On fail goto*//*Label 849*/ GIMT_Encode4(37914), // Rule ID 1517 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqabs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3669:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VQABSv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQABSv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1517,
        GIR_EraseRootFromParent_Done,
      // Label 849: @37914
      GIM_Try, /*On fail goto*//*Label 850*/ GIMT_Encode4(37959), // Rule ID 1518 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqabs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 3669:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VQABSv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQABSv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1518,
        GIR_EraseRootFromParent_Done,
      // Label 850: @37959
      GIM_Try, /*On fail goto*//*Label 851*/ GIMT_Encode4(38004), // Rule ID 1519 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqabs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3669:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQABSv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQABSv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1519,
        GIR_EraseRootFromParent_Done,
      // Label 851: @38004
      GIM_Try, /*On fail goto*//*Label 852*/ GIMT_Encode4(38049), // Rule ID 1520 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqabs),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3669:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQABSv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQABSv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1520,
        GIR_EraseRootFromParent_Done,
      // Label 852: @38049
      GIM_Try, /*On fail goto*//*Label 853*/ GIMT_Encode4(38094), // Rule ID 1531 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqneg),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i8] } 3675:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VQNEGv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQNEGv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1531,
        GIR_EraseRootFromParent_Done,
      // Label 853: @38094
      GIM_Try, /*On fail goto*//*Label 854*/ GIMT_Encode4(38139), // Rule ID 1532 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqneg),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3675:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VQNEGv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQNEGv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1532,
        GIR_EraseRootFromParent_Done,
      // Label 854: @38139
      GIM_Try, /*On fail goto*//*Label 855*/ GIMT_Encode4(38184), // Rule ID 1533 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqneg),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3675:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VQNEGv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQNEGv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1533,
        GIR_EraseRootFromParent_Done,
      // Label 855: @38184
      GIM_Try, /*On fail goto*//*Label 856*/ GIMT_Encode4(38229), // Rule ID 1534 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqneg),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 3675:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VQNEGv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQNEGv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1534,
        GIR_EraseRootFromParent_Done,
      // Label 856: @38229
      GIM_Try, /*On fail goto*//*Label 857*/ GIMT_Encode4(38274), // Rule ID 1535 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqneg),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3675:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQNEGv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQNEGv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1535,
        GIR_EraseRootFromParent_Done,
      // Label 857: @38274
      GIM_Try, /*On fail goto*//*Label 858*/ GIMT_Encode4(38319), // Rule ID 1536 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqneg),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3675:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQNEGv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQNEGv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1536,
        GIR_EraseRootFromParent_Done,
      // Label 858: @38319
      GIM_Try, /*On fail goto*//*Label 859*/ GIMT_Encode4(38364), // Rule ID 1537 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i8] } 3616:{ *:[iPTR] }, DPR:{ *:[v8i8] }:$Vm)  =>  (VCLSv8i8:{ *:[v8i8] } DPR:{ *:[v8i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCLSv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1537,
        GIR_EraseRootFromParent_Done,
      // Label 859: @38364
      GIM_Try, /*On fail goto*//*Label 860*/ GIMT_Encode4(38409), // Rule ID 1538 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3616:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VCLSv4i16:{ *:[v4i16] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCLSv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1538,
        GIR_EraseRootFromParent_Done,
      // Label 860: @38409
      GIM_Try, /*On fail goto*//*Label 861*/ GIMT_Encode4(38454), // Rule ID 1539 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3616:{ *:[iPTR] }, DPR:{ *:[v2i32] }:$Vm)  =>  (VCLSv2i32:{ *:[v2i32] } DPR:{ *:[v2i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCLSv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1539,
        GIR_EraseRootFromParent_Done,
      // Label 861: @38454
      GIM_Try, /*On fail goto*//*Label 862*/ GIMT_Encode4(38499), // Rule ID 1540 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 3616:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (VCLSv16i8:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCLSv16i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1540,
        GIR_EraseRootFromParent_Done,
      // Label 862: @38499
      GIM_Try, /*On fail goto*//*Label 863*/ GIMT_Encode4(38544), // Rule ID 1541 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3616:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VCLSv8i16:{ *:[v8i16] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCLSv8i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1541,
        GIR_EraseRootFromParent_Done,
      // Label 863: @38544
      GIM_Try, /*On fail goto*//*Label 864*/ GIMT_Encode4(38589), // Rule ID 1542 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3616:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VCLSv4i32:{ *:[v4i32] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCLSv4i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1542,
        GIR_EraseRootFromParent_Done,
      // Label 864: @38589
      GIM_Try, /*On fail goto*//*Label 865*/ GIMT_Encode4(38634), // Rule ID 1586 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovns),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i8] } 3672:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQMOVNsv8i8:{ *:[v8i8] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQMOVNsv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1586,
        GIR_EraseRootFromParent_Done,
      // Label 865: @38634
      GIM_Try, /*On fail goto*//*Label 866*/ GIMT_Encode4(38679), // Rule ID 1587 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovns),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3672:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQMOVNsv4i16:{ *:[v4i16] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQMOVNsv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1587,
        GIR_EraseRootFromParent_Done,
      // Label 866: @38679
      GIM_Try, /*On fail goto*//*Label 867*/ GIMT_Encode4(38724), // Rule ID 1588 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovns),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3672:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vm)  =>  (VQMOVNsv2i32:{ *:[v2i32] } QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQMOVNsv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1588,
        GIR_EraseRootFromParent_Done,
      // Label 867: @38724
      GIM_Try, /*On fail goto*//*Label 868*/ GIMT_Encode4(38769), // Rule ID 1589 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovnu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i8] } 3674:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQMOVNuv8i8:{ *:[v8i8] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQMOVNuv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1589,
        GIR_EraseRootFromParent_Done,
      // Label 868: @38769
      GIM_Try, /*On fail goto*//*Label 869*/ GIMT_Encode4(38814), // Rule ID 1590 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovnu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3674:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQMOVNuv4i16:{ *:[v4i16] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQMOVNuv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1590,
        GIR_EraseRootFromParent_Done,
      // Label 869: @38814
      GIM_Try, /*On fail goto*//*Label 870*/ GIMT_Encode4(38859), // Rule ID 1591 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovnu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3674:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vm)  =>  (VQMOVNuv2i32:{ *:[v2i32] } QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQMOVNuv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1591,
        GIR_EraseRootFromParent_Done,
      // Label 870: @38859
      GIM_Try, /*On fail goto*//*Label 871*/ GIMT_Encode4(38904), // Rule ID 1592 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovnsu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i8] } 3673:{ *:[iPTR] }, QPR:{ *:[v8i16] }:$Vm)  =>  (VQMOVNsuv8i8:{ *:[v8i8] } QPR:{ *:[v8i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQMOVNsuv8i8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1592,
        GIR_EraseRootFromParent_Done,
      // Label 871: @38904
      GIM_Try, /*On fail goto*//*Label 872*/ GIMT_Encode4(38949), // Rule ID 1593 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovnsu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3673:{ *:[iPTR] }, QPR:{ *:[v4i32] }:$Vm)  =>  (VQMOVNsuv4i16:{ *:[v4i16] } QPR:{ *:[v4i32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQMOVNsuv4i16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1593,
        GIR_EraseRootFromParent_Done,
      // Label 872: @38949
      GIM_Try, /*On fail goto*//*Label 873*/ GIMT_Encode4(38994), // Rule ID 1594 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vqmovnsu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3673:{ *:[iPTR] }, QPR:{ *:[v2i64] }:$Vm)  =>  (VQMOVNsuv2i32:{ *:[v2i32] } QPR:{ *:[v2i64] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VQMOVNsuv2i32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1594,
        GIR_EraseRootFromParent_Done,
      // Label 873: @38994
      GIM_Try, /*On fail goto*//*Label 874*/ GIMT_Encode4(39030), // Rule ID 1617 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtas),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3617:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTANSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTANSDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1617,
        GIR_EraseRootFromParent_Done,
      // Label 874: @39030
      GIM_Try, /*On fail goto*//*Label 875*/ GIMT_Encode4(39066), // Rule ID 1618 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtas),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3617:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTANSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTANSQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1618,
        GIR_EraseRootFromParent_Done,
      // Label 875: @39066
      GIM_Try, /*On fail goto*//*Label 876*/ GIMT_Encode4(39102), // Rule ID 1619 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtau),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3618:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTANUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTANUDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1619,
        GIR_EraseRootFromParent_Done,
      // Label 876: @39102
      GIM_Try, /*On fail goto*//*Label 877*/ GIMT_Encode4(39138), // Rule ID 1620 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtau),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3618:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTANUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTANUQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1620,
        GIR_EraseRootFromParent_Done,
      // Label 877: @39138
      GIM_Try, /*On fail goto*//*Label 878*/ GIMT_Encode4(39174), // Rule ID 1621 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtas),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3617:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTANSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTANSDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1621,
        GIR_EraseRootFromParent_Done,
      // Label 878: @39174
      GIM_Try, /*On fail goto*//*Label 879*/ GIMT_Encode4(39210), // Rule ID 1622 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtas),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3617:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTANSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTANSQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1622,
        GIR_EraseRootFromParent_Done,
      // Label 879: @39210
      GIM_Try, /*On fail goto*//*Label 880*/ GIMT_Encode4(39246), // Rule ID 1623 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtau),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3618:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTANUDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTANUDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1623,
        GIR_EraseRootFromParent_Done,
      // Label 880: @39246
      GIM_Try, /*On fail goto*//*Label 881*/ GIMT_Encode4(39282), // Rule ID 1624 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtau),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3618:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTANUQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTANUQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1624,
        GIR_EraseRootFromParent_Done,
      // Label 881: @39282
      GIM_Try, /*On fail goto*//*Label 882*/ GIMT_Encode4(39318), // Rule ID 1625 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtns),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3629:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTNNSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTNNSDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1625,
        GIR_EraseRootFromParent_Done,
      // Label 882: @39318
      GIM_Try, /*On fail goto*//*Label 883*/ GIMT_Encode4(39354), // Rule ID 1626 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtns),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3629:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTNNSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTNNSQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1626,
        GIR_EraseRootFromParent_Done,
      // Label 883: @39354
      GIM_Try, /*On fail goto*//*Label 884*/ GIMT_Encode4(39390), // Rule ID 1627 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtnu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3630:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTNNUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTNNUDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1627,
        GIR_EraseRootFromParent_Done,
      // Label 884: @39390
      GIM_Try, /*On fail goto*//*Label 885*/ GIMT_Encode4(39426), // Rule ID 1628 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtnu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3630:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTNNUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTNNUQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1628,
        GIR_EraseRootFromParent_Done,
      // Label 885: @39426
      GIM_Try, /*On fail goto*//*Label 886*/ GIMT_Encode4(39462), // Rule ID 1629 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtns),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3629:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTNNSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTNNSDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1629,
        GIR_EraseRootFromParent_Done,
      // Label 886: @39462
      GIM_Try, /*On fail goto*//*Label 887*/ GIMT_Encode4(39498), // Rule ID 1630 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtns),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3629:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTNNSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTNNSQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1630,
        GIR_EraseRootFromParent_Done,
      // Label 887: @39498
      GIM_Try, /*On fail goto*//*Label 888*/ GIMT_Encode4(39534), // Rule ID 1631 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtnu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3630:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTNNUDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTNNUDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1631,
        GIR_EraseRootFromParent_Done,
      // Label 888: @39534
      GIM_Try, /*On fail goto*//*Label 889*/ GIMT_Encode4(39570), // Rule ID 1632 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtnu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3630:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTNNUQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTNNUQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1632,
        GIR_EraseRootFromParent_Done,
      // Label 889: @39570
      GIM_Try, /*On fail goto*//*Label 890*/ GIMT_Encode4(39606), // Rule ID 1633 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtps),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3631:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTPNSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTPNSDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1633,
        GIR_EraseRootFromParent_Done,
      // Label 890: @39606
      GIM_Try, /*On fail goto*//*Label 891*/ GIMT_Encode4(39642), // Rule ID 1634 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtps),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3631:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTPNSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTPNSQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1634,
        GIR_EraseRootFromParent_Done,
      // Label 891: @39642
      GIM_Try, /*On fail goto*//*Label 892*/ GIMT_Encode4(39678), // Rule ID 1635 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtpu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3632:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTPNUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTPNUDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1635,
        GIR_EraseRootFromParent_Done,
      // Label 892: @39678
      GIM_Try, /*On fail goto*//*Label 893*/ GIMT_Encode4(39714), // Rule ID 1636 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtpu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3632:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTPNUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTPNUQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1636,
        GIR_EraseRootFromParent_Done,
      // Label 893: @39714
      GIM_Try, /*On fail goto*//*Label 894*/ GIMT_Encode4(39750), // Rule ID 1637 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtps),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3631:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTPNSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTPNSDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1637,
        GIR_EraseRootFromParent_Done,
      // Label 894: @39750
      GIM_Try, /*On fail goto*//*Label 895*/ GIMT_Encode4(39786), // Rule ID 1638 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtps),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3631:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTPNSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTPNSQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1638,
        GIR_EraseRootFromParent_Done,
      // Label 895: @39786
      GIM_Try, /*On fail goto*//*Label 896*/ GIMT_Encode4(39822), // Rule ID 1639 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtpu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3632:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTPNUDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTPNUDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1639,
        GIR_EraseRootFromParent_Done,
      // Label 896: @39822
      GIM_Try, /*On fail goto*//*Label 897*/ GIMT_Encode4(39858), // Rule ID 1640 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtpu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3632:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTPNUQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTPNUQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1640,
        GIR_EraseRootFromParent_Done,
      // Label 897: @39858
      GIM_Try, /*On fail goto*//*Label 898*/ GIMT_Encode4(39894), // Rule ID 1641 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtms),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3627:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTMNSDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTMNSDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1641,
        GIR_EraseRootFromParent_Done,
      // Label 898: @39894
      GIM_Try, /*On fail goto*//*Label 899*/ GIMT_Encode4(39930), // Rule ID 1642 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtms),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3627:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTMNSQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTMNSQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1642,
        GIR_EraseRootFromParent_Done,
      // Label 899: @39930
      GIM_Try, /*On fail goto*//*Label 900*/ GIMT_Encode4(39966), // Rule ID 1643 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtmu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i32] } 3628:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VCVTMNUDf:{ *:[v2i32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTMNUDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1643,
        GIR_EraseRootFromParent_Done,
      // Label 900: @39966
      GIM_Try, /*On fail goto*//*Label 901*/ GIMT_Encode4(40002), // Rule ID 1644 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtmu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3628:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTMNUQf:{ *:[v4i32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTMNUQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1644,
        GIR_EraseRootFromParent_Done,
      // Label 901: @40002
      GIM_Try, /*On fail goto*//*Label 902*/ GIMT_Encode4(40038), // Rule ID 1645 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtms),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3627:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTMNSDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTMNSDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1645,
        GIR_EraseRootFromParent_Done,
      // Label 902: @40038
      GIM_Try, /*On fail goto*//*Label 903*/ GIMT_Encode4(40074), // Rule ID 1646 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtms),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3627:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTMNSQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTMNSQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1646,
        GIR_EraseRootFromParent_Done,
      // Label 903: @40074
      GIM_Try, /*On fail goto*//*Label 904*/ GIMT_Encode4(40110), // Rule ID 1647 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtmu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3628:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VCVTMNUDh:{ *:[v4i16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTMNUDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1647,
        GIR_EraseRootFromParent_Done,
      // Label 904: @40110
      GIM_Try, /*On fail goto*//*Label 905*/ GIMT_Encode4(40146), // Rule ID 1648 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtmu),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3628:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VCVTMNUQh:{ *:[v8i16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTMNUQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1648,
        GIR_EraseRootFromParent_Done,
      // Label 905: @40146
      GIM_Try, /*On fail goto*//*Label 906*/ GIMT_Encode4(40191), // Rule ID 1665 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFP16_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvtfp2hf),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i16] } 3623:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VCVTf2h:{ *:[v4i16] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTf2h),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1665,
        GIR_EraseRootFromParent_Done,
      // Label 906: @40191
      GIM_Try, /*On fail goto*//*Label 907*/ GIMT_Encode4(40236), // Rule ID 1666 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFP16_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vcvthf2fp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 3626:{ *:[iPTR] }, DPR:{ *:[v4i16] }:$Vm)  =>  (VCVTh2f:{ *:[v4f32] } DPR:{ *:[v4i16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VCVTh2f),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1666,
        GIR_EraseRootFromParent_Done,
      // Label 907: @40236
      GIM_Try, /*On fail goto*//*Label 908*/ GIMT_Encode4(40272), // Rule ID 1688 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f32] } 3697:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTNNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTNNDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1688,
        GIR_EraseRootFromParent_Done,
      // Label 908: @40272
      GIM_Try, /*On fail goto*//*Label 909*/ GIMT_Encode4(40308), // Rule ID 1689 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 3697:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTNNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTNNQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1689,
        GIR_EraseRootFromParent_Done,
      // Label 909: @40308
      GIM_Try, /*On fail goto*//*Label 910*/ GIMT_Encode4(40344), // Rule ID 1690 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f16] } 3697:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTNNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTNNDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1690,
        GIR_EraseRootFromParent_Done,
      // Label 910: @40344
      GIM_Try, /*On fail goto*//*Label 911*/ GIMT_Encode4(40380), // Rule ID 1691 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 3697:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTNNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTNNQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1691,
        GIR_EraseRootFromParent_Done,
      // Label 911: @40380
      GIM_Try, /*On fail goto*//*Label 912*/ GIMT_Encode4(40416), // Rule ID 1692 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f32] } 3699:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTXNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTXNDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1692,
        GIR_EraseRootFromParent_Done,
      // Label 912: @40416
      GIM_Try, /*On fail goto*//*Label 913*/ GIMT_Encode4(40452), // Rule ID 1693 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 3699:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTXNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTXNQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1693,
        GIR_EraseRootFromParent_Done,
      // Label 913: @40452
      GIM_Try, /*On fail goto*//*Label 914*/ GIMT_Encode4(40488), // Rule ID 1694 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f16] } 3699:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTXNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTXNDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1694,
        GIR_EraseRootFromParent_Done,
      // Label 914: @40488
      GIM_Try, /*On fail goto*//*Label 915*/ GIMT_Encode4(40524), // Rule ID 1695 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintx),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 3699:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTXNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTXNQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1695,
        GIR_EraseRootFromParent_Done,
      // Label 915: @40524
      GIM_Try, /*On fail goto*//*Label 916*/ GIMT_Encode4(40560), // Rule ID 1696 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrinta),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f32] } 3695:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTANDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTANDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1696,
        GIR_EraseRootFromParent_Done,
      // Label 916: @40560
      GIM_Try, /*On fail goto*//*Label 917*/ GIMT_Encode4(40596), // Rule ID 1697 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrinta),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 3695:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTANQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTANQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1697,
        GIR_EraseRootFromParent_Done,
      // Label 917: @40596
      GIM_Try, /*On fail goto*//*Label 918*/ GIMT_Encode4(40632), // Rule ID 1698 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrinta),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f16] } 3695:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTANDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTANDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1698,
        GIR_EraseRootFromParent_Done,
      // Label 918: @40632
      GIM_Try, /*On fail goto*//*Label 919*/ GIMT_Encode4(40668), // Rule ID 1699 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrinta),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 3695:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTANQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTANQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1699,
        GIR_EraseRootFromParent_Done,
      // Label 919: @40668
      GIM_Try, /*On fail goto*//*Label 920*/ GIMT_Encode4(40704), // Rule ID 1700 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintz),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f32] } 3700:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTZNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTZNDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1700,
        GIR_EraseRootFromParent_Done,
      // Label 920: @40704
      GIM_Try, /*On fail goto*//*Label 921*/ GIMT_Encode4(40740), // Rule ID 1701 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintz),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 3700:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTZNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTZNQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1701,
        GIR_EraseRootFromParent_Done,
      // Label 921: @40740
      GIM_Try, /*On fail goto*//*Label 922*/ GIMT_Encode4(40776), // Rule ID 1702 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintz),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f16] } 3700:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTZNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTZNDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1702,
        GIR_EraseRootFromParent_Done,
      // Label 922: @40776
      GIM_Try, /*On fail goto*//*Label 923*/ GIMT_Encode4(40812), // Rule ID 1703 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintz),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 3700:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTZNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTZNQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1703,
        GIR_EraseRootFromParent_Done,
      // Label 923: @40812
      GIM_Try, /*On fail goto*//*Label 924*/ GIMT_Encode4(40848), // Rule ID 1704 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f32] } 3696:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTMNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTMNDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1704,
        GIR_EraseRootFromParent_Done,
      // Label 924: @40848
      GIM_Try, /*On fail goto*//*Label 925*/ GIMT_Encode4(40884), // Rule ID 1705 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 3696:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTMNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTMNQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1705,
        GIR_EraseRootFromParent_Done,
      // Label 925: @40884
      GIM_Try, /*On fail goto*//*Label 926*/ GIMT_Encode4(40920), // Rule ID 1706 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f16] } 3696:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTMNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTMNDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1706,
        GIR_EraseRootFromParent_Done,
      // Label 926: @40920
      GIM_Try, /*On fail goto*//*Label 927*/ GIMT_Encode4(40956), // Rule ID 1707 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintm),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 3696:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTMNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTMNQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1707,
        GIR_EraseRootFromParent_Done,
      // Label 927: @40956
      GIM_Try, /*On fail goto*//*Label 928*/ GIMT_Encode4(40992), // Rule ID 1708 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2f32] } 3698:{ *:[iPTR] }, DPR:{ *:[v2f32] }:$Vm)  =>  (VRINTPNDf:{ *:[v2f32] } DPR:{ *:[v2f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTPNDf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1708,
        GIR_EraseRootFromParent_Done,
      // Label 928: @40992
      GIM_Try, /*On fail goto*//*Label 929*/ GIMT_Encode4(41028), // Rule ID 1709 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 3698:{ *:[iPTR] }, QPR:{ *:[v4f32] }:$Vm)  =>  (VRINTPNQf:{ *:[v4f32] } QPR:{ *:[v4f32] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTPNQf),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1709,
        GIR_EraseRootFromParent_Done,
      // Label 929: @41028
      GIM_Try, /*On fail goto*//*Label 930*/ GIMT_Encode4(41064), // Rule ID 1710 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::DPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f16] } 3698:{ *:[iPTR] }, DPR:{ *:[v4f16] }:$Vm)  =>  (VRINTPNDh:{ *:[v4f16] } DPR:{ *:[v4f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTPNDh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1710,
        GIR_EraseRootFromParent_Done,
      // Label 930: @41064
      GIM_Try, /*On fail goto*//*Label 931*/ GIMT_Encode4(41100), // Rule ID 1711 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFullFP16_HasNEON_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_vrintp),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 3698:{ *:[iPTR] }, QPR:{ *:[v8f16] }:$Vm)  =>  (VRINTPNQh:{ *:[v8f16] } QPR:{ *:[v8f16] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::VRINTPNQh),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1711,
        GIR_EraseRootFromParent_Done,
      // Label 931: @41100
      GIM_Try, /*On fail goto*//*Label 932*/ GIMT_Encode4(41136), // Rule ID 1714 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_aesimc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 3586:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (AESIMC:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::AESIMC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1714,
        GIR_EraseRootFromParent_Done,
      // Label 932: @41136
      GIM_Try, /*On fail goto*//*Label 933*/ GIMT_Encode4(41172), // Rule ID 1715 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_HasV8),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_aesmc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::QPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 3587:{ *:[iPTR] }, QPR:{ *:[v16i8] }:$Vm)  =>  (AESMC:{ *:[v16i8] } QPR:{ *:[v16i8] }:$Vm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::AESMC),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Vd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Vm
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1715,
        GIR_EraseRootFromParent_Done,
      // Label 933: @41172
      GIM_Try, /*On fail goto*//*Label 934*/ GIMT_Encode4(41220), // Rule ID 1848 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_sxtb16),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 3786:{ *:[iPTR] }, GPR:{ *:[i32] }:$Src)  =>  (SXTB16:{ *:[i32] } GPR:{ *:[i32] }:$Src, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::SXTB16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1848,
        GIR_EraseRootFromParent_Done,
      // Label 934: @41220
      GIM_Try, /*On fail goto*//*Label 935*/ GIMT_Encode4(41268), // Rule ID 2087 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_sxtb16),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 3786:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn)  =>  (t2SXTB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2SXTB16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2087,
        GIR_EraseRootFromParent_Done,
      // Label 935: @41268
      GIM_Try, /*On fail goto*//*Label 936*/ GIMT_Encode4(41334), // Rule ID 3628 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 3468:{ *:[iPTR] }, MQPR:{ *:[v16i8] }:$val)  =>  (MVE_VCLSs8:{ *:[v16i8] } MQPR:{ *:[v16i8] }:$val)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCLSs8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/2, // val
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3628,
        GIR_EraseRootFromParent_Done,
      // Label 936: @41334
      GIM_Try, /*On fail goto*//*Label 937*/ GIMT_Encode4(41400), // Rule ID 3630 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 3468:{ *:[iPTR] }, MQPR:{ *:[v8i16] }:$val)  =>  (MVE_VCLSs16:{ *:[v8i16] } MQPR:{ *:[v8i16] }:$val)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCLSs16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/2, // val
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3630,
        GIR_EraseRootFromParent_Done,
      // Label 937: @41400
      GIM_Try, /*On fail goto*//*Label 938*/ GIMT_Encode4(41466), // Rule ID 3632 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vcls),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 3468:{ *:[iPTR] }, MQPR:{ *:[v4i32] }:$val)  =>  (MVE_VCLSs32:{ *:[v4i32] } MQPR:{ *:[v4i32] }:$val)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCLSs32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/2, // val
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3632,
        GIR_EraseRootFromParent_Done,
      // Label 938: @41466
      GIM_Try, /*On fail goto*//*Label 939*/ GIMT_Encode4(41532), // Rule ID 3944 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vrintn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8f16] } 3550:{ *:[iPTR] }, MQPR:{ *:[v8f16] }:$val)  =>  (MVE_VRINTf16N:{ *:[v8f16] } MQPR:{ *:[v8f16] }:$val)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VRINTf16N),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/2, // val
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3944,
        GIR_EraseRootFromParent_Done,
      // Label 939: @41532
      GIM_Try, /*On fail goto*//*Label 940*/ GIMT_Encode4(41598), // Rule ID 3956 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEFloat),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vrintn),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::MQPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 3550:{ *:[iPTR] }, MQPR:{ *:[v4f32] }:$val)  =>  (MVE_VRINTf32N:{ *:[v4f32] } MQPR:{ *:[v4f32] }:$val)
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v4s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VRINTf32N),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Qd]
        GIR_RootToRootCopy, /*OpIdx*/2, // val
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3956,
        GIR_EraseRootFromParent_Done,
      // Label 940: @41598
      GIM_Try, /*On fail goto*//*Label 941*/ GIMT_Encode4(41649), // Rule ID 4844 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vctp8),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v16i1] } 3476:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn)  =>  (MVE_VCTP8:{ *:[v16i1] } rGPR:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCTP8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[P0]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4844,
        GIR_EraseRootFromParent_Done,
      // Label 941: @41649
      GIM_Try, /*On fail goto*//*Label 942*/ GIMT_Encode4(41700), // Rule ID 4846 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vctp16),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i1] } 3473:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn)  =>  (MVE_VCTP16:{ *:[v8i1] } rGPR:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCTP16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[P0]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4846,
        GIR_EraseRootFromParent_Done,
      // Label 942: @41700
      GIM_Try, /*On fail goto*//*Label 943*/ GIMT_Encode4(41751), // Rule ID 4848 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vctp32),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i1] } 3474:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn)  =>  (MVE_VCTP32:{ *:[v4i1] } rGPR:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCTP32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[P0]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4848,
        GIR_EraseRootFromParent_Done,
      // Label 943: @41751
      GIM_Try, /*On fail goto*//*Label 944*/ GIMT_Encode4(41802), // Rule ID 4850 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMVEInt),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_mve_vctp64),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::VCCRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i1] } 3475:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn)  =>  (MVE_VCTP64:{ *:[v2i1] } rGPR:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::MVE_VCTP64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[P0]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4850,
        GIR_EraseRootFromParent_Done,
      // Label 944: @41802
      GIM_Try, /*On fail goto*//*Label 945*/ GIMT_Encode4(41848), // Rule ID 600 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has8MSecExt_IsThumb),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_cmse_tt),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/2, /*SizeInBits*/32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 3358:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn)  =>  (t2TT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2TT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 600,
        GIR_EraseRootFromParent_Done,
      // Label 945: @41848
      GIM_Try, /*On fail goto*//*Label 946*/ GIMT_Encode4(41894), // Rule ID 601 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has8MSecExt_IsThumb),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_cmse_ttt),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/2, /*SizeInBits*/32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 3361:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn)  =>  (t2TTT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2TTT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 601,
        GIR_EraseRootFromParent_Done,
      // Label 946: @41894
      GIM_Try, /*On fail goto*//*Label 947*/ GIMT_Encode4(41940), // Rule ID 602 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has8MSecExt_IsThumb),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_cmse_tta),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/2, /*SizeInBits*/32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 3359:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn)  =>  (t2TTA:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2TTA),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 602,
        GIR_EraseRootFromParent_Done,
      // Label 947: @41940
      GIM_Try, /*On fail goto*//*Label 948*/ GIMT_Encode4(41986), // Rule ID 603 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Has8MSecExt_IsThumb),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_cmse_ttat),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // MIs[0] Rn
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/2, /*SizeInBits*/32,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 3360:{ *:[iPTR] }, GPRnopc:{ *:[i32] }:$Rn)  =>  (t2TTAT:{ *:[i32] } GPRnopc:{ *:[i32] }:$Rn)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2TTAT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rt]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 603,
        GIR_EraseRootFromParent_Done,
      // Label 948: @41986
      GIM_Try, /*On fail goto*//*Label 949*/ GIMT_Encode4(42121), // Rule ID 2673 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNEON),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_neon_sha1h),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 3594:{ *:[iPTR] }, i32:{ *:[i32] }:$Rn)  =>  (COPY_TO_REGCLASS:{ *:[i32] } (EXTRACT_SUBREG:{ *:[f32] } (SHA1H:{ *:[v16i8] } (SUBREG_TO_REG:{ *:[v16i8] } 0:{ *:[i64] }, (COPY_TO_REGCLASS:{ *:[f32] } i32:{ *:[i32] }:$Rn, SPR:{ *:[i32] }), ssub_0:{ *:[i32] })), ssub_0:{ *:[i32] }), GPR:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/2, // Rn
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(ARM::SPRRegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s8,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddImm8, /*InsnID*/3, /*Imm*/0,
        GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
        GIR_AddImm8, /*InsnID*/3, /*Imm*/17,
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(ARM::DPair_with_ssub_0RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, GIMT_Encode2(ARM::SPRRegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s8,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(ARM::SHA1H),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddTempSubRegister, /*InsnID*/1, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(ARM::ssub_0),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(ARM::SPRRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(ARM::MQPRRegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(ARM::GPRRegClassID),
        // GIR_Coverage, 2673,
        GIR_EraseRootFromParent_Done,
      // Label 949: @42121
      GIM_Reject,
    // Label 813: @42122
    GIM_Try, /*On fail goto*//*Label 950*/ GIMT_Encode4(62676),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 951*/ GIMT_Encode4(42187), // Rule ID 2105 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDSP_IsThumb2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_uxtab16),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 3810:{ *:[iPTR] }, rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm)  =>  (t2UXTAB16:{ *:[i32] } rGPR:{ *:[i32] }:$Rn, rGPR:{ *:[i32] }:$Rm, 0:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::t2UXTAB16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_RootToRootCopy, /*OpIdx*/2, // Rn
        GIR_RootToRootCopy, /*OpIdx*/3, // Rm
        GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2105,
        GIR_EraseRootFromParent_Done,
      // Label 951: @42187
      GIM_Try, /*On fail goto*//*Label 952*/ GIMT_Encode4(42286), // Rule ID 1885 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasV6_IsARM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_usat),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(ARM::GPRnopcRegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_31),
        // MIs[2] Operand 1
        // No operand predicates
        GIM_RecordInsn, /*DefineMI*/3, /*MI*/0, /*OpIdx*/3, // MIs[3]
        GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/3, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_imm0_31),
        // MIs[3] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/3,
        // (intrinsic_wo_chain:{ *:[i32] } 3805:{ *:[iPTR] }, (shl:{ *:[i32] } GPRnopc:{ *:[i32] }:$a, (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$shft), (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$pos)  =>  (USAT:{ *:[i32] } (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$pos, GPRnopc:{ *:[i32] }:$a, (imm:{ *:[i32] })<<P:Predicate_imm0_31>>:$shft)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(ARM::USAT),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[Rd]
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/3, // pos
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // a
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // shft
        GIR_AddImm8, /*InsnID*/0, /*Imm*/14,
        GIR_AddRegister, /*InsnID*/0, GIMT_Encode2(ARM::NoRegister), /*AddRegisterRegFlags*/GIMT_Encode2(0),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1885,
        GIR_EraseRootFromParent_Done,
      // Label 952: @42286
      GIM_Try, /*On fail goto*//*Label 953*/ GIMT_Encode4(42385), // Rule ID 2142 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsThumb2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::arm_usat),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(ARM::rGPRRegClassID),
        GIM_RecordInsn,