/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the RISCV target                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 107;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(RISCVInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(RISCVInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static RISCVInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static RISCVInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testMOPredicate_MO(unsigned PredicateID, const MachineOperand &MO, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(4),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_p0s32,
  GILLT_p0s64,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_nxv1s1,
  GILLT_nxv1s8,
  GILLT_nxv1s16,
  GILLT_nxv1s32,
  GILLT_nxv1s64,
  GILLT_nxv2s1,
  GILLT_nxv2s8,
  GILLT_nxv2s16,
  GILLT_nxv2s32,
  GILLT_nxv2s64,
  GILLT_nxv4s1,
  GILLT_nxv4s8,
  GILLT_nxv4s16,
  GILLT_nxv4s32,
  GILLT_nxv4s64,
  GILLT_nxv8s1,
  GILLT_nxv8s8,
  GILLT_nxv8s16,
  GILLT_nxv8s32,
  GILLT_nxv8s64,
  GILLT_nxv16s1,
  GILLT_nxv16s8,
  GILLT_nxv16s16,
  GILLT_nxv16s32,
  GILLT_nxv32s1,
  GILLT_nxv32s8,
  GILLT_nxv32s16,
  GILLT_nxv64s1,
  GILLT_nxv64s8,
};
const static size_t NumTypeObjects = 34;
const static LLT TypeObjects[] = {
  LLT::pointer(0, 32),
  LLT::pointer(0, 64),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::vector(ElementCount::getScalable(1), 1),
  LLT::vector(ElementCount::getScalable(1), 8),
  LLT::vector(ElementCount::getScalable(1), 16),
  LLT::vector(ElementCount::getScalable(1), 32),
  LLT::vector(ElementCount::getScalable(1), 64),
  LLT::vector(ElementCount::getScalable(2), 1),
  LLT::vector(ElementCount::getScalable(2), 8),
  LLT::vector(ElementCount::getScalable(2), 16),
  LLT::vector(ElementCount::getScalable(2), 32),
  LLT::vector(ElementCount::getScalable(2), 64),
  LLT::vector(ElementCount::getScalable(4), 1),
  LLT::vector(ElementCount::getScalable(4), 8),
  LLT::vector(ElementCount::getScalable(4), 16),
  LLT::vector(ElementCount::getScalable(4), 32),
  LLT::vector(ElementCount::getScalable(4), 64),
  LLT::vector(ElementCount::getScalable(8), 1),
  LLT::vector(ElementCount::getScalable(8), 8),
  LLT::vector(ElementCount::getScalable(8), 16),
  LLT::vector(ElementCount::getScalable(8), 32),
  LLT::vector(ElementCount::getScalable(8), 64),
  LLT::vector(ElementCount::getScalable(16), 1),
  LLT::vector(ElementCount::getScalable(16), 8),
  LLT::vector(ElementCount::getScalable(16), 16),
  LLT::vector(ElementCount::getScalable(16), 32),
  LLT::vector(ElementCount::getScalable(32), 1),
  LLT::vector(ElementCount::getScalable(32), 8),
  LLT::vector(ElementCount::getScalable(32), 16),
  LLT::vector(ElementCount::getScalable(64), 1),
  LLT::vector(ElementCount::getScalable(64), 8),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_HasStdExtZicbopBit = 34,
  Feature_HasStdExtZicondBit = 36,
  Feature_HasStdExtZihintpauseBit = 22,
  Feature_HasStdExtZimopBit = 33,
  Feature_HasStdExtZicfilpBit = 2,
  Feature_NoStdExtZicfilpBit = 1,
  Feature_HasStdExtZilsdBit = 37,
  Feature_HasStdExtZmmulBit = 23,
  Feature_HasStdExtMBit = 24,
  Feature_HasStdExtABit = 26,
  Feature_HasStdExtZtsoBit = 28,
  Feature_NotHasStdExtZtsoBit = 27,
  Feature_HasStdExtZabhaBit = 31,
  Feature_HasStdExtZacasBit = 30,
  Feature_NoStdExtZacasBit = 29,
  Feature_HasStdExtZalasrBit = 32,
  Feature_HasStdExtFBit = 5,
  Feature_HasStdExtDBit = 7,
  Feature_HasStdExtZfhminBit = 12,
  Feature_HasStdExtZfhBit = 10,
  Feature_HasStdExtZfaBit = 38,
  Feature_NoStdExtZfaBit = 8,
  Feature_HasStdExtZfinxBit = 6,
  Feature_HasStdExtZdinxBit = 9,
  Feature_HasStdExtZhinxminBit = 13,
  Feature_HasStdExtZhinxBit = 11,
  Feature_HasStdExtZcaBit = 20,
  Feature_HasStdExtCBit = 18,
  Feature_HasStdExtZbaBit = 44,
  Feature_NotHasStdExtZbaBit = 21,
  Feature_HasStdExtZbbBit = 41,
  Feature_NoStdExtZbbBit = 43,
  Feature_HasStdExtZbcBit = 46,
  Feature_HasStdExtZbsBit = 40,
  Feature_HasStdExtZbkbBit = 42,
  Feature_NoStdExtZbkbBit = 104,
  Feature_HasStdExtZbkxBit = 47,
  Feature_HasStdExtZbbOrZbkbBit = 39,
  Feature_HasStdExtZbcOrZbkcBit = 45,
  Feature_HasStdExtZkndBit = 48,
  Feature_HasStdExtZkneBit = 50,
  Feature_HasStdExtZkndOrZkneBit = 49,
  Feature_HasStdExtZknhBit = 51,
  Feature_HasStdExtZksedBit = 52,
  Feature_HasStdExtZkshBit = 53,
  Feature_HasStdExtZvkbBit = 61,
  Feature_HasStdExtZvbbBit = 60,
  Feature_HasStdExtZvbcBit = 65,
  Feature_HasStdExtZvkgBit = 62,
  Feature_HasStdExtZvknedBit = 63,
  Feature_HasStdExtZvknhaBit = 66,
  Feature_HasStdExtZvknhbBit = 67,
  Feature_HasStdExtZvksedBit = 68,
  Feature_HasStdExtZvkshBit = 64,
  Feature_HasVInstructionsBit = 14,
  Feature_HasVInstructionsI64Bit = 56,
  Feature_HasVInstructionsAnyFBit = 55,
  Feature_HasVInstructionsF16MinimalBit = 58,
  Feature_HasVInstructionsF16Bit = 54,
  Feature_HasVInstructionsF64Bit = 59,
  Feature_HasVInstructionsFullMultiplyBit = 57,
  Feature_HasVendorXVentanaCondOpsBit = 69,
  Feature_HasVendorXTHeadBaBit = 70,
  Feature_HasVendorXTHeadBbBit = 71,
  Feature_HasVendorXTHeadBsBit = 72,
  Feature_HasVendorXTHeadCondMovBit = 73,
  Feature_HasVendorXTHeadFMemIdxBit = 78,
  Feature_HasVendorXTHeadMacBit = 74,
  Feature_HasVendorXTHeadMemIdxBit = 77,
  Feature_HasVendorXTHeadMemPairBit = 76,
  Feature_HasVendorXTHeadVdotBit = 75,
  Feature_HasVendorXSfvcpBit = 79,
  Feature_HasVendorXSfvqmaccdodBit = 80,
  Feature_HasVendorXSfvqmaccqoqBit = 81,
  Feature_HasVendorXSfvfnrclipxfqfBit = 82,
  Feature_HasVendorXCVbitmanipBit = 84,
  Feature_HasVendorXCVmacBit = 87,
  Feature_HasVendorXCVmemBit = 83,
  Feature_HasVendorXCValuBit = 85,
  Feature_HasVendorXCVbiBit = 86,
  Feature_UseCCMovInsnBit = 102,
  Feature_HasVendorXMIPSCBOPBit = 101,
  Feature_NotHasVendorXMIPSCBOPBit = 35,
  Feature_HasVendorXqciaBit = 92,
  Feature_HasVendorXqciacBit = 88,
  Feature_HasVendorXqcibiBit = 93,
  Feature_HasVendorXqcibmBit = 94,
  Feature_HasVendorXqcicliBit = 98,
  Feature_HasVendorXqcicmBit = 96,
  Feature_HasVendorXqcicsBit = 100,
  Feature_NoVendorXqcicsBit = 97,
  Feature_HasVendorXqcicsOrXqcicmBit = 99,
  Feature_HasVendorXqciintBit = 95,
  Feature_HasVendorXqciliaBit = 89,
  Feature_HasVendorXqciloBit = 90,
  Feature_HasVendorXqcislsBit = 91,
  Feature_HasVendorXAndesPerfBit = 103,
  Feature_IsRV64Bit = 4,
  Feature_IsRV32Bit = 3,
  Feature_HasShortForwardBranchOptBit = 15,
  Feature_NoShortForwardBranchOptBit = 17,
  Feature_HasConditionalMoveFusionBit = 16,
  Feature_NoConditionalMoveFusionBit = 0,
  Feature_HasAtomicLdStBit = 25,
  Feature_OptForMinSizeBit = 19,
  Feature_HwMode1Bit = 106,
  Feature_HwMode0Bit = 105,
};

PredicateBitset RISCVInstructionSelector::
computeAvailableModuleFeatures(const RISCVSubtarget *Subtarget) const {
  PredicateBitset Features{};
  if (Subtarget->hasStdExtZicbop())
    Features.set(Feature_HasStdExtZicbopBit);
  if (Subtarget->hasStdExtZicond())
    Features.set(Feature_HasStdExtZicondBit);
  if (Subtarget->hasStdExtZihintpause())
    Features.set(Feature_HasStdExtZihintpauseBit);
  if (Subtarget->hasStdExtZimop())
    Features.set(Feature_HasStdExtZimopBit);
  if (Subtarget->hasStdExtZicfilp())
    Features.set(Feature_HasStdExtZicfilpBit);
  if (!Subtarget->hasStdExtZicfilp())
    Features.set(Feature_NoStdExtZicfilpBit);
  if (Subtarget->hasStdExtZilsd())
    Features.set(Feature_HasStdExtZilsdBit);
  if (Subtarget->hasStdExtZmmul())
    Features.set(Feature_HasStdExtZmmulBit);
  if (Subtarget->hasStdExtM())
    Features.set(Feature_HasStdExtMBit);
  if (Subtarget->hasStdExtA())
    Features.set(Feature_HasStdExtABit);
  if (Subtarget->hasStdExtZtso())
    Features.set(Feature_HasStdExtZtsoBit);
  if (!Subtarget->hasStdExtZtso())
    Features.set(Feature_NotHasStdExtZtsoBit);
  if (Subtarget->hasStdExtZabha())
    Features.set(Feature_HasStdExtZabhaBit);
  if (Subtarget->hasStdExtZacas())
    Features.set(Feature_HasStdExtZacasBit);
  if (!Subtarget->hasStdExtZacas())
    Features.set(Feature_NoStdExtZacasBit);
  if (Subtarget->hasStdExtZalasr())
    Features.set(Feature_HasStdExtZalasrBit);
  if (Subtarget->hasStdExtF())
    Features.set(Feature_HasStdExtFBit);
  if (Subtarget->hasStdExtD())
    Features.set(Feature_HasStdExtDBit);
  if (Subtarget->hasStdExtZfhmin())
    Features.set(Feature_HasStdExtZfhminBit);
  if (Subtarget->hasStdExtZfh())
    Features.set(Feature_HasStdExtZfhBit);
  if (Subtarget->hasStdExtZfa())
    Features.set(Feature_HasStdExtZfaBit);
  if (!Subtarget->hasStdExtZfa())
    Features.set(Feature_NoStdExtZfaBit);
  if (Subtarget->hasStdExtZfinx())
    Features.set(Feature_HasStdExtZfinxBit);
  if (Subtarget->hasStdExtZdinx())
    Features.set(Feature_HasStdExtZdinxBit);
  if (Subtarget->hasStdExtZhinxmin())
    Features.set(Feature_HasStdExtZhinxminBit);
  if (Subtarget->hasStdExtZhinx())
    Features.set(Feature_HasStdExtZhinxBit);
  if (Subtarget->hasStdExtZca())
    Features.set(Feature_HasStdExtZcaBit);
  if (Subtarget->hasStdExtC())
    Features.set(Feature_HasStdExtCBit);
  if (Subtarget->hasStdExtZba())
    Features.set(Feature_HasStdExtZbaBit);
  if (!Subtarget->hasStdExtZba())
    Features.set(Feature_NotHasStdExtZbaBit);
  if (Subtarget->hasStdExtZbb())
    Features.set(Feature_HasStdExtZbbBit);
  if (!Subtarget->hasStdExtZbb())
    Features.set(Feature_NoStdExtZbbBit);
  if (Subtarget->hasStdExtZbc())
    Features.set(Feature_HasStdExtZbcBit);
  if (Subtarget->hasStdExtZbs())
    Features.set(Feature_HasStdExtZbsBit);
  if (Subtarget->hasStdExtZbkb())
    Features.set(Feature_HasStdExtZbkbBit);
  if (!Subtarget->hasStdExtZbkb())
    Features.set(Feature_NoStdExtZbkbBit);
  if (Subtarget->hasStdExtZbkx())
    Features.set(Feature_HasStdExtZbkxBit);
  if (Subtarget->hasStdExtZbb() || Subtarget->hasStdExtZbkb())
    Features.set(Feature_HasStdExtZbbOrZbkbBit);
  if (Subtarget->hasStdExtZbc() || Subtarget->hasStdExtZbkc())
    Features.set(Feature_HasStdExtZbcOrZbkcBit);
  if (Subtarget->hasStdExtZknd())
    Features.set(Feature_HasStdExtZkndBit);
  if (Subtarget->hasStdExtZkne())
    Features.set(Feature_HasStdExtZkneBit);
  if (Subtarget->hasStdExtZknd() || Subtarget->hasStdExtZkne())
    Features.set(Feature_HasStdExtZkndOrZkneBit);
  if (Subtarget->hasStdExtZknh())
    Features.set(Feature_HasStdExtZknhBit);
  if (Subtarget->hasStdExtZksed())
    Features.set(Feature_HasStdExtZksedBit);
  if (Subtarget->hasStdExtZksh())
    Features.set(Feature_HasStdExtZkshBit);
  if (Subtarget->hasStdExtZvkb())
    Features.set(Feature_HasStdExtZvkbBit);
  if (Subtarget->hasStdExtZvbb())
    Features.set(Feature_HasStdExtZvbbBit);
  if (Subtarget->hasStdExtZvbc())
    Features.set(Feature_HasStdExtZvbcBit);
  if (Subtarget->hasStdExtZvkg())
    Features.set(Feature_HasStdExtZvkgBit);
  if (Subtarget->hasStdExtZvkned())
    Features.set(Feature_HasStdExtZvknedBit);
  if (Subtarget->hasStdExtZvknha())
    Features.set(Feature_HasStdExtZvknhaBit);
  if (Subtarget->hasStdExtZvknhb())
    Features.set(Feature_HasStdExtZvknhbBit);
  if (Subtarget->hasStdExtZvksed())
    Features.set(Feature_HasStdExtZvksedBit);
  if (Subtarget->hasStdExtZvksh())
    Features.set(Feature_HasStdExtZvkshBit);
  if (Subtarget->hasVInstructions())
    Features.set(Feature_HasVInstructionsBit);
  if (Subtarget->hasVInstructionsI64())
    Features.set(Feature_HasVInstructionsI64Bit);
  if (Subtarget->hasVInstructionsAnyF())
    Features.set(Feature_HasVInstructionsAnyFBit);
  if (Subtarget->hasVInstructionsF16Minimal())
    Features.set(Feature_HasVInstructionsF16MinimalBit);
  if (Subtarget->hasVInstructionsF16())
    Features.set(Feature_HasVInstructionsF16Bit);
  if (Subtarget->hasVInstructionsF64())
    Features.set(Feature_HasVInstructionsF64Bit);
  if (Subtarget->hasVInstructionsFullMultiply())
    Features.set(Feature_HasVInstructionsFullMultiplyBit);
  if (Subtarget->hasVendorXVentanaCondOps())
    Features.set(Feature_HasVendorXVentanaCondOpsBit);
  if (Subtarget->hasVendorXTHeadBa())
    Features.set(Feature_HasVendorXTHeadBaBit);
  if (Subtarget->hasVendorXTHeadBb())
    Features.set(Feature_HasVendorXTHeadBbBit);
  if (Subtarget->hasVendorXTHeadBs())
    Features.set(Feature_HasVendorXTHeadBsBit);
  if (Subtarget->hasVendorXTHeadCondMov())
    Features.set(Feature_HasVendorXTHeadCondMovBit);
  if (Subtarget->hasVendorXTHeadFMemIdx())
    Features.set(Feature_HasVendorXTHeadFMemIdxBit);
  if (Subtarget->hasVendorXTHeadMac())
    Features.set(Feature_HasVendorXTHeadMacBit);
  if (Subtarget->hasVendorXTHeadMemIdx())
    Features.set(Feature_HasVendorXTHeadMemIdxBit);
  if (Subtarget->hasVendorXTHeadMemPair())
    Features.set(Feature_HasVendorXTHeadMemPairBit);
  if (Subtarget->hasVendorXTHeadVdot())
    Features.set(Feature_HasVendorXTHeadVdotBit);
  if (Subtarget->hasVendorXSfvcp())
    Features.set(Feature_HasVendorXSfvcpBit);
  if (Subtarget->hasVendorXSfvqmaccdod())
    Features.set(Feature_HasVendorXSfvqmaccdodBit);
  if (Subtarget->hasVendorXSfvqmaccqoq())
    Features.set(Feature_HasVendorXSfvqmaccqoqBit);
  if (Subtarget->hasVendorXSfvfnrclipxfqf())
    Features.set(Feature_HasVendorXSfvfnrclipxfqfBit);
  if (Subtarget->hasVendorXCVbitmanip())
    Features.set(Feature_HasVendorXCVbitmanipBit);
  if (Subtarget->hasVendorXCVmac())
    Features.set(Feature_HasVendorXCVmacBit);
  if (Subtarget->hasVendorXCVmem())
    Features.set(Feature_HasVendorXCVmemBit);
  if (Subtarget->hasVendorXCValu())
    Features.set(Feature_HasVendorXCValuBit);
  if (Subtarget->hasVendorXCVbi())
    Features.set(Feature_HasVendorXCVbiBit);
  if (Subtarget->useCCMovInsn())
    Features.set(Feature_UseCCMovInsnBit);
  if (Subtarget->hasVendorXMIPSCBOP())
    Features.set(Feature_HasVendorXMIPSCBOPBit);
  if (!Subtarget->hasVendorXMIPSCBOP())
    Features.set(Feature_NotHasVendorXMIPSCBOPBit);
  if (Subtarget->hasVendorXqcia())
    Features.set(Feature_HasVendorXqciaBit);
  if (Subtarget->hasVendorXqciac())
    Features.set(Feature_HasVendorXqciacBit);
  if (Subtarget->hasVendorXqcibi())
    Features.set(Feature_HasVendorXqcibiBit);
  if (Subtarget->hasVendorXqcibm())
    Features.set(Feature_HasVendorXqcibmBit);
  if (Subtarget->hasVendorXqcicli())
    Features.set(Feature_HasVendorXqcicliBit);
  if (Subtarget->hasVendorXqcicm())
    Features.set(Feature_HasVendorXqcicmBit);
  if (Subtarget->hasVendorXqcics())
    Features.set(Feature_HasVendorXqcicsBit);
  if (!Subtarget->hasVendorXqcics())
    Features.set(Feature_NoVendorXqcicsBit);
  if (Subtarget->hasVendorXqcics() || Subtarget->hasVendorXqcicm())
    Features.set(Feature_HasVendorXqcicsOrXqcicmBit);
  if (Subtarget->hasVendorXqciint())
    Features.set(Feature_HasVendorXqciintBit);
  if (Subtarget->hasVendorXqcilia())
    Features.set(Feature_HasVendorXqciliaBit);
  if (Subtarget->hasVendorXqcilo())
    Features.set(Feature_HasVendorXqciloBit);
  if (Subtarget->hasVendorXqcisls())
    Features.set(Feature_HasVendorXqcislsBit);
  if (Subtarget->hasVendorXAndesPerf())
    Features.set(Feature_HasVendorXAndesPerfBit);
  if (Subtarget->is64Bit())
    Features.set(Feature_IsRV64Bit);
  if (!Subtarget->is64Bit())
    Features.set(Feature_IsRV32Bit);
  if (Subtarget->hasShortForwardBranchOpt())
    Features.set(Feature_HasShortForwardBranchOptBit);
  if (!Subtarget->hasShortForwardBranchOpt())
    Features.set(Feature_NoShortForwardBranchOptBit);
  if (Subtarget->hasConditionalMoveFusion())
    Features.set(Feature_HasConditionalMoveFusionBit);
  if (!Subtarget->hasConditionalMoveFusion())
    Features.set(Feature_NoConditionalMoveFusionBit);
  if (Subtarget->hasStdExtA() || Subtarget->hasForcedAtomics())
    Features.set(Feature_HasAtomicLdStBit);
  if (MF ? MF->getFunction().hasMinSize() : false)
    Features.set(Feature_OptForMinSizeBit);
  if (!((Subtarget->is64Bit())))
    Features.set(Feature_HwMode1Bit);
  if ((Subtarget->is64Bit()))
    Features.set(Feature_HwMode0Bit);
  return Features;
}

void RISCVInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const RISCVSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset RISCVInstructionSelector::
computeAvailableFunctionFeatures(const RISCVSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_HwMode0,
  GIFBS_HwMode1,
  GIFBS_HasAtomicLdSt_HwMode0,
  GIFBS_HasAtomicLdSt_HwMode1,
  GIFBS_HasShortForwardBranchOpt_HwMode0,
  GIFBS_HasShortForwardBranchOpt_HwMode1,
  GIFBS_HasStdExtA_HwMode0,
  GIFBS_HasStdExtA_HwMode1,
  GIFBS_HasStdExtD,
  GIFBS_HasStdExtD_HwMode0,
  GIFBS_HasStdExtD_HwMode1,
  GIFBS_HasStdExtF,
  GIFBS_HasStdExtF_HwMode0,
  GIFBS_HasStdExtF_HwMode1,
  GIFBS_HasStdExtM_HwMode0,
  GIFBS_HasStdExtM_HwMode1,
  GIFBS_HasStdExtZalasr_HwMode0,
  GIFBS_HasStdExtZalasr_HwMode1,
  GIFBS_HasStdExtZba_HwMode0,
  GIFBS_HasStdExtZba_HwMode1,
  GIFBS_HasStdExtZbb_HwMode0,
  GIFBS_HasStdExtZbb_HwMode1,
  GIFBS_HasStdExtZbbOrZbkb_HwMode0,
  GIFBS_HasStdExtZbbOrZbkb_HwMode1,
  GIFBS_HasStdExtZbkb_HwMode0,
  GIFBS_HasStdExtZbkb_HwMode1,
  GIFBS_HasStdExtZbkx_HwMode0,
  GIFBS_HasStdExtZbkx_HwMode1,
  GIFBS_HasStdExtZbs_HwMode0,
  GIFBS_HasStdExtZbs_HwMode1,
  GIFBS_HasStdExtZfa,
  GIFBS_HasStdExtZfa_HwMode0,
  GIFBS_HasStdExtZfa_HwMode1,
  GIFBS_HasStdExtZfh,
  GIFBS_HasStdExtZfh_HwMode0,
  GIFBS_HasStdExtZfh_HwMode1,
  GIFBS_HasStdExtZfhmin_HwMode0,
  GIFBS_HasStdExtZfhmin_HwMode1,
  GIFBS_HasStdExtZfinx,
  GIFBS_HasStdExtZfinx_HwMode0,
  GIFBS_HasStdExtZfinx_HwMode1,
  GIFBS_HasStdExtZhinx,
  GIFBS_HasStdExtZhinx_HwMode0,
  GIFBS_HasStdExtZhinx_HwMode1,
  GIFBS_HasStdExtZhinxmin_HwMode0,
  GIFBS_HasStdExtZhinxmin_HwMode1,
  GIFBS_HasStdExtZihintpause_HwMode0,
  GIFBS_HasStdExtZihintpause_HwMode1,
  GIFBS_HasStdExtZmmul_HwMode0,
  GIFBS_HasStdExtZmmul_HwMode1,
  GIFBS_HasStdExtZvbb_HwMode0,
  GIFBS_HasStdExtZvbb_HwMode1,
  GIFBS_HasStdExtZvbc_HwMode0,
  GIFBS_HasStdExtZvbc_HwMode1,
  GIFBS_HasStdExtZvkb_HwMode0,
  GIFBS_HasStdExtZvkb_HwMode1,
  GIFBS_HasStdExtZvkg_HwMode0,
  GIFBS_HasStdExtZvkg_HwMode1,
  GIFBS_HasStdExtZvkned_HwMode0,
  GIFBS_HasStdExtZvkned_HwMode1,
  GIFBS_HasStdExtZvknha_HwMode0,
  GIFBS_HasStdExtZvknha_HwMode1,
  GIFBS_HasStdExtZvknhb_HwMode0,
  GIFBS_HasStdExtZvknhb_HwMode1,
  GIFBS_HasStdExtZvksed_HwMode0,
  GIFBS_HasStdExtZvksed_HwMode1,
  GIFBS_HasStdExtZvksh_HwMode0,
  GIFBS_HasStdExtZvksh_HwMode1,
  GIFBS_HasVInstructions_HwMode0,
  GIFBS_HasVInstructions_HwMode1,
  GIFBS_HasVInstructionsAnyF_HwMode0,
  GIFBS_HasVInstructionsAnyF_HwMode1,
  GIFBS_HasVInstructionsF16_HwMode0,
  GIFBS_HasVInstructionsF16_HwMode1,
  GIFBS_HasVInstructionsF16Minimal_HwMode0,
  GIFBS_HasVInstructionsF16Minimal_HwMode1,
  GIFBS_HasVInstructionsF64_HwMode0,
  GIFBS_HasVInstructionsF64_HwMode1,
  GIFBS_HasVInstructionsFullMultiply_HwMode0,
  GIFBS_HasVInstructionsFullMultiply_HwMode1,
  GIFBS_HasVInstructionsI64_HwMode0,
  GIFBS_HasVInstructionsI64_HwMode1,
  GIFBS_HasVendorXAndesPerf_HwMode0,
  GIFBS_HasVendorXAndesPerf_HwMode1,
  GIFBS_HasVendorXCVmac_HwMode0,
  GIFBS_HasVendorXCVmac_HwMode1,
  GIFBS_HasVendorXSfvcp_HwMode0,
  GIFBS_HasVendorXSfvcp_HwMode1,
  GIFBS_HasVendorXSfvfnrclipxfqf_HwMode0,
  GIFBS_HasVendorXSfvfnrclipxfqf_HwMode1,
  GIFBS_HasVendorXSfvqmaccdod_HwMode0,
  GIFBS_HasVendorXSfvqmaccdod_HwMode1,
  GIFBS_HasVendorXSfvqmaccqoq_HwMode0,
  GIFBS_HasVendorXSfvqmaccqoq_HwMode1,
  GIFBS_HasVendorXTHeadBa_HwMode0,
  GIFBS_HasVendorXTHeadBa_HwMode1,
  GIFBS_HasVendorXTHeadBb_HwMode0,
  GIFBS_HasVendorXTHeadBb_HwMode1,
  GIFBS_HasVendorXTHeadBs_HwMode0,
  GIFBS_HasVendorXTHeadBs_HwMode1,
  GIFBS_HasVendorXTHeadCondMov_HwMode0,
  GIFBS_HasVendorXTHeadCondMov_HwMode1,
  GIFBS_HasVendorXTHeadMac_HwMode0,
  GIFBS_HasVendorXTHeadMac_HwMode1,
  GIFBS_HasVendorXTHeadVdot_HwMode0,
  GIFBS_HasVendorXTHeadVdot_HwMode1,
  GIFBS_IsRV32_HwMode0,
  GIFBS_IsRV32_HwMode1,
  GIFBS_IsRV64_HwMode0,
  GIFBS_IsRV64_HwMode1,
  GIFBS_UseCCMovInsn_HwMode0,
  GIFBS_UseCCMovInsn_HwMode1,
  GIFBS_HasAtomicLdSt_IsRV32_HwMode0,
  GIFBS_HasAtomicLdSt_IsRV32_HwMode1,
  GIFBS_HasAtomicLdSt_IsRV64_HwMode0,
  GIFBS_HasAtomicLdSt_IsRV64_HwMode1,
  GIFBS_HasStdExtA_HasStdExtZtso_HwMode0,
  GIFBS_HasStdExtA_HasStdExtZtso_HwMode1,
  GIFBS_HasStdExtA_IsRV64_HwMode0,
  GIFBS_HasStdExtA_NoStdExtZacas_HwMode0,
  GIFBS_HasStdExtA_NoStdExtZacas_HwMode1,
  GIFBS_HasStdExtA_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtA_NotHasStdExtZtso_HwMode1,
  GIFBS_HasStdExtD_HasStdExtZfa,
  GIFBS_HasStdExtD_HasStdExtZfa_HwMode0,
  GIFBS_HasStdExtD_HasStdExtZfa_HwMode1,
  GIFBS_HasStdExtD_HasStdExtZfhmin_HwMode0,
  GIFBS_HasStdExtD_HasStdExtZfhmin_HwMode1,
  GIFBS_HasStdExtD_IsRV32_HwMode0,
  GIFBS_HasStdExtD_IsRV32_HwMode1,
  GIFBS_HasStdExtD_IsRV64_HwMode0,
  GIFBS_HasStdExtF_IsRV32_HwMode0,
  GIFBS_HasStdExtF_IsRV32_HwMode1,
  GIFBS_HasStdExtF_IsRV64_HwMode0,
  GIFBS_HasStdExtM_IsRV64_HwMode0,
  GIFBS_HasStdExtZacas_HasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZacas_HasStdExtZtso_HwMode1,
  GIFBS_HasStdExtZacas_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZacas_NotHasStdExtZtso_HwMode1,
  GIFBS_HasStdExtZalasr_IsRV32_HwMode0,
  GIFBS_HasStdExtZalasr_IsRV32_HwMode1,
  GIFBS_HasStdExtZalasr_IsRV64_HwMode0,
  GIFBS_HasStdExtZalasr_IsRV64_HwMode1,
  GIFBS_HasStdExtZba_IsRV64_HwMode0,
  GIFBS_HasStdExtZbb_IsRV32_HwMode0,
  GIFBS_HasStdExtZbb_IsRV32_HwMode1,
  GIFBS_HasStdExtZbb_IsRV64_HwMode0,
  GIFBS_HasStdExtZbb_IsRV64_HwMode1,
  GIFBS_HasStdExtZbbOrZbkb_IsRV32_HwMode0,
  GIFBS_HasStdExtZbbOrZbkb_IsRV32_HwMode1,
  GIFBS_HasStdExtZbbOrZbkb_IsRV64_HwMode0,
  GIFBS_HasStdExtZbkb_IsRV32_HwMode0,
  GIFBS_HasStdExtZbkb_IsRV32_HwMode1,
  GIFBS_HasStdExtZbkb_IsRV64_HwMode0,
  GIFBS_HasStdExtZdinx_IsRV32,
  GIFBS_HasStdExtZdinx_IsRV32_HwMode0,
  GIFBS_HasStdExtZdinx_IsRV32_HwMode1,
  GIFBS_HasStdExtZdinx_IsRV64_HwMode0,
  GIFBS_HasStdExtZfa_HasStdExtZfh,
  GIFBS_HasStdExtZfa_HasStdExtZfh_HwMode0,
  GIFBS_HasStdExtZfa_HasStdExtZfh_HwMode1,
  GIFBS_HasStdExtZfh_IsRV32_HwMode0,
  GIFBS_HasStdExtZfh_IsRV32_HwMode1,
  GIFBS_HasStdExtZfh_IsRV64_HwMode0,
  GIFBS_HasStdExtZfinx_IsRV32_HwMode0,
  GIFBS_HasStdExtZfinx_IsRV32_HwMode1,
  GIFBS_HasStdExtZfinx_IsRV64_HwMode0,
  GIFBS_HasStdExtZhinx_IsRV32_HwMode0,
  GIFBS_HasStdExtZhinx_IsRV32_HwMode1,
  GIFBS_HasStdExtZhinx_IsRV64_HwMode0,
  GIFBS_HasStdExtZknd_IsRV32_HwMode1,
  GIFBS_HasStdExtZknd_IsRV64_HwMode0,
  GIFBS_HasStdExtZkndOrZkne_IsRV64_HwMode0,
  GIFBS_HasStdExtZkne_IsRV32_HwMode1,
  GIFBS_HasStdExtZkne_IsRV64_HwMode0,
  GIFBS_HasStdExtZknh_IsRV32_HwMode1,
  GIFBS_HasStdExtZknh_IsRV64_HwMode0,
  GIFBS_HasStdExtZmmul_IsRV64_HwMode0,
  GIFBS_HasStdExtZvbb_HasVInstructions_HwMode0,
  GIFBS_HasStdExtZvbb_HasVInstructions_HwMode1,
  GIFBS_HasStdExtZvbb_HasVInstructionsI64_HwMode0,
  GIFBS_HasStdExtZvbb_HasVInstructionsI64_HwMode1,
  GIFBS_HasStdExtZvkb_HasVInstructions_HwMode0,
  GIFBS_HasStdExtZvkb_HasVInstructions_HwMode1,
  GIFBS_HasStdExtZvkb_HasVInstructionsI64_HwMode0,
  GIFBS_HasStdExtZvkb_HasVInstructionsI64_HwMode1,
  GIFBS_HasVInstructions_HasVInstructionsAnyF_HwMode0,
  GIFBS_HasVInstructions_HasVInstructionsAnyF_HwMode1,
  GIFBS_HasVInstructions_HasVInstructionsF16_HwMode0,
  GIFBS_HasVInstructions_HasVInstructionsF16_HwMode1,
  GIFBS_HasVInstructions_HasVInstructionsF64_HwMode0,
  GIFBS_HasVInstructions_HasVInstructionsF64_HwMode1,
  GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0,
  GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsF16_HwMode0,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsF16_HwMode1,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsF16Minimal_HwMode0,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsF16Minimal_HwMode1,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsF64_HwMode0,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsF64_HwMode1,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsI64_HwMode0,
  GIFBS_HasVInstructionsAnyF_HasVInstructionsI64_HwMode1,
  GIFBS_HasVInstructionsF64_HasVInstructionsI64_HwMode0,
  GIFBS_HasVInstructionsF64_HasVInstructionsI64_HwMode1,
  GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0,
  GIFBS_HasVendorXCValu_IsRV32_HwMode0,
  GIFBS_HasVendorXCValu_IsRV32_HwMode1,
  GIFBS_HasVendorXCVbitmanip_IsRV32_HwMode0,
  GIFBS_HasVendorXCVbitmanip_IsRV32_HwMode1,
  GIFBS_HasVendorXTHeadBb_IsRV64_HwMode0,
  GIFBS_HasVendorXTHeadMac_IsRV64_HwMode0,
  GIFBS_HasVendorXqcia_IsRV32_HwMode0,
  GIFBS_HasVendorXqcia_IsRV32_HwMode1,
  GIFBS_HasVendorXqciac_IsRV32_HwMode0,
  GIFBS_HasVendorXqciac_IsRV32_HwMode1,
  GIFBS_HasVendorXqcibm_IsRV32_HwMode0,
  GIFBS_HasVendorXqcibm_IsRV32_HwMode1,
  GIFBS_HasVendorXqcicm_IsRV32_HwMode0,
  GIFBS_HasVendorXqcicm_IsRV32_HwMode1,
  GIFBS_HasVendorXqcics_IsRV32_HwMode0,
  GIFBS_HasVendorXqcics_IsRV32_HwMode1,
  GIFBS_HasVendorXqcilia_IsRV32_HwMode1,
  GIFBS_IsRV32_NoStdExtZbb_HwMode0,
  GIFBS_IsRV32_NoStdExtZbb_HwMode1,
  GIFBS_IsRV64_NoStdExtZbb_HwMode0,
  GIFBS_IsRV64_NoStdExtZbb_HwMode1,
  GIFBS_IsRV64_NotHasStdExtZba_HwMode0,
  GIFBS_HasStdExtA_HasStdExtZabha_HasStdExtZtso_HwMode0,
  GIFBS_HasStdExtA_HasStdExtZabha_HasStdExtZtso_HwMode1,
  GIFBS_HasStdExtA_HasStdExtZabha_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtA_HasStdExtZabha_NotHasStdExtZtso_HwMode1,
  GIFBS_HasStdExtA_HasStdExtZtso_IsRV64_HwMode0,
  GIFBS_HasStdExtA_IsRV64_NoStdExtZacas_HwMode0,
  GIFBS_HasStdExtA_IsRV64_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtD_HasStdExtZfa_IsRV32_HwMode0,
  GIFBS_HasStdExtD_HasStdExtZfa_IsRV32_HwMode1,
  GIFBS_HasStdExtD_IsRV32_NoStdExtZfa_HwMode0,
  GIFBS_HasStdExtD_IsRV32_NoStdExtZfa_HwMode1,
  GIFBS_HasStdExtZabha_HasStdExtZacas_HasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZabha_HasStdExtZacas_HasStdExtZtso_HwMode1,
  GIFBS_HasStdExtZabha_HasStdExtZacas_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZabha_HasStdExtZacas_NotHasStdExtZtso_HwMode1,
  GIFBS_HasStdExtZacas_HasStdExtZtso_IsRV64_HwMode0,
  GIFBS_HasStdExtZacas_IsRV64_NotHasStdExtZtso_HwMode0,
  GIFBS_HasStdExtZbb_HasVendorXqcibm_IsRV32_HwMode0,
  GIFBS_HasStdExtZbb_HasVendorXqcibm_IsRV32_HwMode1,
  GIFBS_HasStdExtZbkb_IsRV32_NoStdExtZbb_HwMode0,
  GIFBS_HasStdExtZbkb_IsRV32_NoStdExtZbb_HwMode1,
  GIFBS_HasStdExtZbkb_IsRV64_NoStdExtZbb_HwMode0,
  GIFBS_HasStdExtZbkb_IsRV64_NoStdExtZbb_HwMode1,
  GIFBS_HasStdExtZdinx_HasStdExtZhinxmin_IsRV32_HwMode0,
  GIFBS_HasStdExtZdinx_HasStdExtZhinxmin_IsRV32_HwMode1,
  GIFBS_HasStdExtZdinx_HasStdExtZhinxmin_IsRV64_HwMode0,
  GIFBS_HasStdExtZdinx_HasStdExtZilsd_IsRV32_HwMode0,
  GIFBS_HasStdExtZdinx_HasStdExtZilsd_IsRV32_HwMode1,
  GIFBS_HasStdExtZmmul_IsRV64_NotHasStdExtZba_HwMode0,
  GIFBS_HasStdExtZvbb_HasVInstructions_HasVInstructionsI64_HwMode0,
  GIFBS_HasStdExtZvbb_HasVInstructions_HasVInstructionsI64_HwMode1,
  GIFBS_HasVendorXqcibm_IsRV32_NoStdExtZbb_HwMode0,
  GIFBS_HasVendorXqcibm_IsRV32_NoStdExtZbb_HwMode1,
  GIFBS_HasVendorXqcicli_HasVendorXqcicsOrXqcicm_IsRV32_HwMode0,
  GIFBS_HasVendorXqcicli_HasVendorXqcicsOrXqcicm_IsRV32_HwMode1,
  GIFBS_HasVendorXqcicm_IsRV32_NoVendorXqcics_HwMode1,
  GIFBS_IsRV32_NoStdExtZbb_NoStdExtZbkb_HwMode0,
  GIFBS_IsRV32_NoStdExtZbb_NoStdExtZbkb_HwMode1,
  GIFBS_IsRV64_NoStdExtZbb_NoStdExtZbkb_HwMode0,
  GIFBS_IsRV64_NoStdExtZbb_NoStdExtZbkb_HwMode1,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_HwMode0Bit, },
  {Feature_HwMode1Bit, },
  {Feature_HasAtomicLdStBit, Feature_HwMode0Bit, },
  {Feature_HasAtomicLdStBit, Feature_HwMode1Bit, },
  {Feature_HasShortForwardBranchOptBit, Feature_HwMode0Bit, },
  {Feature_HasShortForwardBranchOptBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, },
  {Feature_HasStdExtDBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtFBit, },
  {Feature_HasStdExtFBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtFBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtMBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtMBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZalasrBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZalasrBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbaBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbkbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbkbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbkxBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbkxBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbsBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbsBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfaBit, },
  {Feature_HasStdExtZfaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfaBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfhBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfhminBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhminBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfinxBit, },
  {Feature_HasStdExtZfinxBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfinxBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZhinxBit, },
  {Feature_HasStdExtZhinxBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxminBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZihintpauseBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZihintpauseBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZmmulBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZmmulBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvbcBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvbcBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvkgBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvkgBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvknedBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvknedBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvknhaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvknhaBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvknhbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvknhbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvksedBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvksedBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvkshBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvkshBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsF16Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsF16Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsF16MinimalBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsF16MinimalBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsF64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsF64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsFullMultiplyBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsFullMultiplyBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXAndesPerfBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXAndesPerfBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXCVmacBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXCVmacBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXSfvcpBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXSfvcpBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXSfvfnrclipxfqfBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXSfvfnrclipxfqfBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXSfvqmaccdodBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXSfvqmaccdodBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXSfvqmaccqoqBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXSfvqmaccqoqBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadBaBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadBaBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadBbBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadBbBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadBsBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadBsBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadCondMovBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadCondMovBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadMacBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadMacBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadVdotBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadVdotBit, Feature_HwMode1Bit, },
  {Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_UseCCMovInsnBit, Feature_HwMode0Bit, },
  {Feature_UseCCMovInsnBit, Feature_HwMode1Bit, },
  {Feature_HasAtomicLdStBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasAtomicLdStBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasAtomicLdStBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasAtomicLdStBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_NoStdExtZacasBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_NoStdExtZacasBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_NotHasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfaBit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfaBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfhminBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfhminBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtFBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtFBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtFBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtMBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZacasBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZacasBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZalasrBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZalasrBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZalasrBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZalasrBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbaBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbBit, Feature_IsRV64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbbOrZbkbBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZdinxBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhBit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfaBit, Feature_HasStdExtZfhBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfhBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfhBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfhBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfinxBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZfinxBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZfinxBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZhinxBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZhinxBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZkndBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZkndOrZkneBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZkneBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZknhBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZmmulBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HasVInstructionsBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HasVInstructionsBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvkbBit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsAnyFBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsAnyFBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsF16Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsF16Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsF64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsF64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsBit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsF16Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsF16Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsF16MinimalBit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsF16MinimalBit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsF64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsF64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsAnyFBit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVInstructionsF64Bit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasVInstructionsF64Bit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXAndesPerfBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXCValuBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXCValuBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXCVbitmanipBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXCVbitmanipBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXTHeadBbBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXTHeadMacBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXqciaBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXqciaBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXqciacBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXqciacBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXqcibmBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXqcibmBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXqcicmBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXqcicmBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXqcicsBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXqcicsBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXqciliaBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_IsRV32Bit, Feature_NoStdExtZbbBit, Feature_HwMode0Bit, },
  {Feature_IsRV32Bit, Feature_NoStdExtZbbBit, Feature_HwMode1Bit, },
  {Feature_IsRV64Bit, Feature_NoStdExtZbbBit, Feature_HwMode0Bit, },
  {Feature_IsRV64Bit, Feature_NoStdExtZbbBit, Feature_HwMode1Bit, },
  {Feature_IsRV64Bit, Feature_NotHasStdExtZbaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZabhaBit, Feature_HasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZabhaBit, Feature_HasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZabhaBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZabhaBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtABit, Feature_HasStdExtZtsoBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_IsRV64Bit, Feature_NoStdExtZacasBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtABit, Feature_IsRV64Bit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfaBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_HasStdExtZfaBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtDBit, Feature_IsRV32Bit, Feature_NoStdExtZfaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtDBit, Feature_IsRV32Bit, Feature_NoStdExtZfaBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZabhaBit, Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZabhaBit, Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZabhaBit, Feature_HasStdExtZacasBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZabhaBit, Feature_HasStdExtZacasBit, Feature_NotHasStdExtZtsoBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZacasBit, Feature_HasStdExtZtsoBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZacasBit, Feature_IsRV64Bit, Feature_NotHasStdExtZtsoBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbBit, Feature_HasVendorXqcibmBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbbBit, Feature_HasVendorXqcibmBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV32Bit, Feature_NoStdExtZbbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV32Bit, Feature_NoStdExtZbbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV64Bit, Feature_NoStdExtZbbBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZbkbBit, Feature_IsRV64Bit, Feature_NoStdExtZbbBit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZdinxBit, Feature_HasStdExtZhinxminBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZdinxBit, Feature_HasStdExtZhinxminBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZdinxBit, Feature_HasStdExtZhinxminBit, Feature_IsRV64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZdinxBit, Feature_HasStdExtZilsdBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZdinxBit, Feature_HasStdExtZilsdBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasStdExtZmmulBit, Feature_IsRV64Bit, Feature_NotHasStdExtZbaBit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsBit, Feature_HasVInstructionsI64Bit, Feature_HwMode0Bit, },
  {Feature_HasStdExtZvbbBit, Feature_HasVInstructionsBit, Feature_HasVInstructionsI64Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXqcibmBit, Feature_IsRV32Bit, Feature_NoStdExtZbbBit, Feature_HwMode0Bit, },
  {Feature_HasVendorXqcibmBit, Feature_IsRV32Bit, Feature_NoStdExtZbbBit, Feature_HwMode1Bit, },
  {Feature_HasVendorXqcicliBit, Feature_HasVendorXqcicsOrXqcicmBit, Feature_IsRV32Bit, Feature_HwMode0Bit, },
  {Feature_HasVendorXqcicliBit, Feature_HasVendorXqcicsOrXqcicmBit, Feature_IsRV32Bit, Feature_HwMode1Bit, },
  {Feature_HasVendorXqcicmBit, Feature_IsRV32Bit, Feature_NoVendorXqcicsBit, Feature_HwMode1Bit, },
  {Feature_IsRV32Bit, Feature_NoStdExtZbbBit, Feature_NoStdExtZbkbBit, Feature_HwMode0Bit, },
  {Feature_IsRV32Bit, Feature_NoStdExtZbbBit, Feature_NoStdExtZbkbBit, Feature_HwMode1Bit, },
  {Feature_IsRV64Bit, Feature_NoStdExtZbbBit, Feature_NoStdExtZbkbBit, Feature_HwMode0Bit, },
  {Feature_IsRV64Bit, Feature_NoStdExtZbbBit, Feature_NoStdExtZbkbBit, Feature_HwMode1Bit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
  GICP_GIAddrRegImm,
  GICP_GIShiftMask32,
  GICP_GIShiftMaskXLen,
  GICP_GIVLOp,
  GICP_gi_sexti32,
  GICP_gi_sh1add_op,
  GICP_gi_sh1add_uw_op,
  GICP_gi_sh2add_op,
  GICP_gi_sh2add_uw_op,
  GICP_gi_sh3add_op,
  GICP_gi_sh3add_uw_op,
  GICP_gi_zexti16,
  GICP_gi_zexti32,
  GICP_gi_zexti8,
};
// See constructor for table contents

RISCVInstructionSelector::ComplexMatcherMemFn
RISCVInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
  &RISCVInstructionSelector::selectAddrRegImm, // GIAddrRegImm
  &RISCVInstructionSelector::selectShiftMask32, // GIShiftMask32
  &RISCVInstructionSelector::selectShiftMaskXLen, // GIShiftMaskXLen
  &RISCVInstructionSelector::renderVLOp, // GIVLOp
  &RISCVInstructionSelector::selectSExtBits<32>, // gi_sexti32
  &RISCVInstructionSelector::selectSHXADDOp<1>, // gi_sh1add_op
  &RISCVInstructionSelector::selectSHXADD_UWOp<1>, // gi_sh1add_uw_op
  &RISCVInstructionSelector::selectSHXADDOp<2>, // gi_sh2add_op
  &RISCVInstructionSelector::selectSHXADD_UWOp<2>, // gi_sh2add_uw_op
  &RISCVInstructionSelector::selectSHXADDOp<3>, // gi_sh3add_op
  &RISCVInstructionSelector::selectSHXADD_UWOp<3>, // gi_sh3add_uw_op
  &RISCVInstructionSelector::selectZExtBits<16>, // gi_zexti16
  &RISCVInstructionSelector::selectZExtBits<32>, // gi_zexti32
  &RISCVInstructionSelector::selectZExtBits<8>, // gi_zexti8
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_add_like_non_imm12 = GICXXPred_Invalid + 1,
  GICXXPred_MI_Predicate_add_non_imm12,
  GICXXPred_MI_Predicate_anonymous_9940,
  GICXXPred_MI_Predicate_anonymous_9942,
  GICXXPred_MI_Predicate_anonymous_10032,
  GICXXPred_MI_Predicate_anonymous_10046,
  GICXXPred_MI_Predicate_anonymous_10050,
  GICXXPred_MI_Predicate_anonymous_10052,
  GICXXPred_MI_Predicate_anonymous_10054,
  GICXXPred_MI_Predicate_anonymous_10056,
  GICXXPred_MI_Predicate_anonymous_10059,
  GICXXPred_MI_Predicate_anonymous_10061,
  GICXXPred_MI_Predicate_anonymous_10074,
  GICXXPred_MI_Predicate_anonymous_10087,
  GICXXPred_MI_Predicate_anonymous_11283,
  GICXXPred_MI_Predicate_or_disjoint,
};
bool RISCVInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_add_like_non_imm12: {
    
        const MachineOperand &ImmOp = *Operands[1];
    
        if (ImmOp.isReg() && ImmOp.getReg())
          if (auto Val = getIConstantVRegValWithLookThrough(ImmOp.getReg(), MRI)) {
            // We do NOT want immediates that fit in 12 bits.
            return !isInt<12>(Val->Value.getSExtValue());
          }
    
        return true;
      
    llvm_unreachable("add_like_non_imm12 should have returned");
  }
  case GICXXPred_MI_Predicate_add_non_imm12: {
    
        const MachineOperand &ImmOp = *Operands[1];
    
        if (ImmOp.isReg() && ImmOp.getReg())
          if (auto Val = getIConstantVRegValWithLookThrough(ImmOp.getReg(), MRI)) {
            // We do NOT want immediates that fit in 12 bits.
            return !isInt<12>(Val->Value.getSExtValue());
          }
    
        return true;
      
    llvm_unreachable("add_non_imm12 should have returned");
  }
  case GICXXPred_MI_Predicate_anonymous_9940: {
    
        return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
      
  }
  case GICXXPred_MI_Predicate_anonymous_9942: {
    
        return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
      
  }
  case GICXXPred_MI_Predicate_anonymous_10032: {
    
        return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
      
  }
  case GICXXPred_MI_Predicate_anonymous_10046: {
     return hasAllWUsers(MI); 
  }
  case GICXXPred_MI_Predicate_anonymous_10050: {
     return hasAllWUsers(MI); 
  }
  case GICXXPred_MI_Predicate_anonymous_10052: {
     return hasAllWUsers(MI); 
  }
  case GICXXPred_MI_Predicate_anonymous_10054: {
     return hasAllWUsers(MI); 
  }
  case GICXXPred_MI_Predicate_anonymous_10056: {
     return hasAllWUsers(MI); 
  }
  case GICXXPred_MI_Predicate_anonymous_10059: {
     return hasAllWUsers(MI); 
  }
  case GICXXPred_MI_Predicate_anonymous_10061: {
     return hasAllWUsers(MI); 
  }
  case GICXXPred_MI_Predicate_anonymous_10074: {
    
        return MRI.hasOneNonDBGUse(MI.getOperand(0).getReg());
      
  }
  case GICXXPred_MI_Predicate_anonymous_10087: {
     return hasAllWUsers(MI); 
  }
  case GICXXPred_MI_Predicate_anonymous_11283: {
     return hasAllHUsers(MI); 
  }
  case GICXXPred_MI_Predicate_or_disjoint: {
    
        return MI.getFlag(MachineInstr::Disjoint);
      
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool RISCVInstructionSelector::testMOPredicate_MO(unsigned PredicateID, const MachineOperand & MO, const MatcherState &State) const {
  const auto &Operands = State.RecordedOperands;
  Register Reg = MO.getReg();
  (void)Operands;
  (void)Reg;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_AddiPair = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_BCLRMask,
  GICXXPred_I64_Predicate_LeadingOnesMask,
  GICXXPred_I64_Predicate_LeadingOnesWMask,
  GICXXPred_I64_Predicate_SingleBitSetMask,
  GICXXPred_I64_Predicate_allonessew8,
  GICXXPred_I64_Predicate_allonessew16,
  GICXXPred_I64_Predicate_allonessew32,
  GICXXPred_I64_Predicate_allonessew64,
  GICXXPred_I64_Predicate_bare_simm9_lsb0,
  GICXXPred_I64_Predicate_bare_simm12_lsb0,
  GICXXPred_I64_Predicate_bare_simm13_lsb0,
  GICXXPred_I64_Predicate_byteselect,
  GICXXPred_I64_Predicate_c_lui_imm,
  GICXXPred_I64_Predicate_csr_sysreg,
  GICXXPred_I64_Predicate_cv_tuimm2,
  GICXXPred_I64_Predicate_cv_tuimm5,
  GICXXPred_I64_Predicate_cv_uimm10,
  GICXXPred_I64_Predicate_immzero,
  GICXXPred_I64_Predicate_payload1,
  GICXXPred_I64_Predicate_payload2,
  GICXXPred_I64_Predicate_payload5,
  GICXXPred_I64_Predicate_powerOf2Minus1,
  GICXXPred_I64_Predicate_rnum,
  GICXXPred_I64_Predicate_simm5,
  GICXXPred_I64_Predicate_simm5_plus1,
  GICXXPred_I64_Predicate_simm5_plus1_nonzero,
  GICXXPred_I64_Predicate_simm5nonzero,
  GICXXPred_I64_Predicate_simm6,
  GICXXPred_I64_Predicate_simm6nonzero,
  GICXXPred_I64_Predicate_simm10,
  GICXXPred_I64_Predicate_simm10_lsb0000nonzero,
  GICXXPred_I64_Predicate_simm11,
  GICXXPred_I64_Predicate_simm12,
  GICXXPred_I64_Predicate_simm12Minus1Nonzero,
  GICXXPred_I64_Predicate_simm12Minus1NonzeroNonNeg1,
  GICXXPred_I64_Predicate_simm12Plus1,
  GICXXPred_I64_Predicate_simm12Plus1i32,
  GICXXPred_I64_Predicate_simm12_lsb00000,
  GICXXPred_I64_Predicate_simm12_no6,
  GICXXPred_I64_Predicate_simm12_plus1,
  GICXXPred_I64_Predicate_simm16nonzero,
  GICXXPred_I64_Predicate_simm20_li,
  GICXXPred_I64_Predicate_simm21_lsb0_jal,
  GICXXPred_I64_Predicate_simm26,
  GICXXPred_I64_Predicate_simm26_nosimm12,
  GICXXPred_I64_Predicate_simm32_nosimm26,
  GICXXPred_I64_Predicate_tsimm5,
  GICXXPred_I64_Predicate_tuimm5,
  GICXXPred_I64_Predicate_u32simm12,
  GICXXPred_I64_Predicate_uimm1,
  GICXXPred_I64_Predicate_uimm2,
  GICXXPred_I64_Predicate_uimm2_3,
  GICXXPred_I64_Predicate_uimm2_4,
  GICXXPred_I64_Predicate_uimm2_lsb0,
  GICXXPred_I64_Predicate_uimm3,
  GICXXPred_I64_Predicate_uimm4,
  GICXXPred_I64_Predicate_uimm5,
  GICXXPred_I64_Predicate_uimm5_lsb0,
  GICXXPred_I64_Predicate_uimm5_plus1,
  GICXXPred_I64_Predicate_uimm5ge6_plus1,
  GICXXPred_I64_Predicate_uimm5gt3,
  GICXXPred_I64_Predicate_uimm5i32,
  GICXXPred_I64_Predicate_uimm5nonzero,
  GICXXPred_I64_Predicate_uimm5slist,
  GICXXPred_I64_Predicate_uimm6,
  GICXXPred_I64_Predicate_uimm6_lsb0,
  GICXXPred_I64_Predicate_uimm6gt32,
  GICXXPred_I64_Predicate_uimm7,
  GICXXPred_I64_Predicate_uimm7_lsb00,
  GICXXPred_I64_Predicate_uimm7_lsb000,
  GICXXPred_I64_Predicate_uimm8_lsb00,
  GICXXPred_I64_Predicate_uimm8_lsb000,
  GICXXPred_I64_Predicate_uimm9_lsb000,
  GICXXPred_I64_Predicate_uimm10,
  GICXXPred_I64_Predicate_uimm10_lsb00nonzero,
  GICXXPred_I64_Predicate_uimm11,
  GICXXPred_I64_Predicate_uimm14lsb00,
  GICXXPred_I64_Predicate_uimm16nonzero,
  GICXXPred_I64_Predicate_uimmlog2xlen,
  GICXXPred_I64_Predicate_uimmlog2xlennonzero,
};
bool RISCVInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_AddiPair: {
    
      // The immediate operand must be in range [-4096,-2049] or [2048,4094].
      return (-4096 <= Imm && Imm <= -2049) || (2048 <= Imm && Imm <= 4094);
    
    llvm_unreachable("AddiPair should have returned");
  }
  case GICXXPred_I64_Predicate_BCLRMask: {
    
      if (Subtarget->is64Bit())
        return !isInt<12>(Imm) && isPowerOf2_64(~Imm);
      return !isInt<12>(Imm) && isPowerOf2_32(~Imm);
    
    llvm_unreachable("BCLRMask should have returned");
  }
  case GICXXPred_I64_Predicate_LeadingOnesMask: {
    
      return !isInt<32>(Imm) && isMask_64(~Imm);
    
  }
  case GICXXPred_I64_Predicate_LeadingOnesWMask: {
    
      // If the value is a uint32 but not an int32, it must have bit 31 set and
      // bits 63:32 cleared. After that we're looking for a shifted mask but not
      // an all ones mask.
      return !isInt<32>(Imm) && isUInt<32>(Imm) && isShiftedMask_64(Imm) &&
             Imm != UINT64_C(0xffffffff);
    
    llvm_unreachable("LeadingOnesWMask should have returned");
  }
  case GICXXPred_I64_Predicate_SingleBitSetMask: {
    
      if (Subtarget->is64Bit())
        return !isInt<12>(Imm) && isPowerOf2_64(Imm);
      return !isInt<12>(Imm) && isPowerOf2_32(Imm);
    
    llvm_unreachable("SingleBitSetMask should have returned");
  }
  case GICXXPred_I64_Predicate_allonessew8: {
    return SignExtend64<8>(Imm) == -1LL;
  }
  case GICXXPred_I64_Predicate_allonessew16: {
    return SignExtend64<16>(Imm) == -1LL;
  }
  case GICXXPred_I64_Predicate_allonessew32: {
    return SignExtend64<32>(Imm) == -1LL;
  }
  case GICXXPred_I64_Predicate_allonessew64: {
    return Imm == -1LL;
  }
  case GICXXPred_I64_Predicate_bare_simm9_lsb0: {
    return isShiftedInt<8, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_bare_simm12_lsb0: {
    return isShiftedInt<11, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_bare_simm13_lsb0: {
    return isShiftedInt<12, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_byteselect: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_c_lui_imm: {
    return (Imm != 0) &&
                                     (isUInt<5>(Imm) ||
                                      (Imm >= 0xfffe0 && Imm <= 0xfffff));
  }
  case GICXXPred_I64_Predicate_csr_sysreg: {
    return isUInt<12>(Imm);
  }
  case GICXXPred_I64_Predicate_cv_tuimm2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_cv_tuimm5: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_cv_uimm10: {
    return isUInt<10>(Imm);
  }
  case GICXXPred_I64_Predicate_immzero: {
    return (Imm == 0);
  }
  case GICXXPred_I64_Predicate_payload1: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_payload2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_payload5: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_powerOf2Minus1: {
     return isPowerOf2_32(Imm+1); 
  }
  case GICXXPred_I64_Predicate_rnum: {
    return (Imm >= 0 && Imm <= 10);
  }
  case GICXXPred_I64_Predicate_simm5: {
    return isInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_simm5_plus1: {
    return (isInt<5>(Imm) && Imm != -16) || Imm == 16;
  }
  case GICXXPred_I64_Predicate_simm5_plus1_nonzero: {
    return Imm != 0 && ((isInt<5>(Imm) && Imm != -16) || Imm == 16);
  }
  case GICXXPred_I64_Predicate_simm5nonzero: {
    return (Imm != 0) && isInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_simm6: {
    return isInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_simm6nonzero: {
    return (Imm != 0) && isInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_simm10: {
    return isInt<10>(Imm);
  }
  case GICXXPred_I64_Predicate_simm10_lsb0000nonzero: {
    return (Imm != 0) && isShiftedInt<6, 4>(Imm);
  }
  case GICXXPred_I64_Predicate_simm11: {
    return isInt<11>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12: {
    return isInt<12>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12Minus1Nonzero: {
    
      return (Imm >= -2049 && Imm < 0) || (Imm > 0 && Imm <= 2046);
  }
  case GICXXPred_I64_Predicate_simm12Minus1NonzeroNonNeg1: {
    
      return (Imm >= -2049 && Imm < -1) || (Imm > 0 && Imm <= 2046);
  }
  case GICXXPred_I64_Predicate_simm12Plus1: {
    
        return (isInt<12>(Imm) && Imm != -2048) || Imm == 2048;
  }
  case GICXXPred_I64_Predicate_simm12Plus1i32: {
    
        return (isInt<12>(Imm) && Imm != -2048) || Imm == 2048;
  }
  case GICXXPred_I64_Predicate_simm12_lsb00000: {
    return isShiftedInt<7, 5>(Imm);
  }
  case GICXXPred_I64_Predicate_simm12_no6: {
    
      return isInt<12>(Imm) && !isInt<6>(Imm) && isInt<12>(-Imm);
  }
  case GICXXPred_I64_Predicate_simm12_plus1: {
    return (isInt<12>(Imm) && Imm != -2048) || Imm == 2048;
  }
  case GICXXPred_I64_Predicate_simm16nonzero: {
    return (Imm != 0) && isInt<16>(Imm);
  }
  case GICXXPred_I64_Predicate_simm20_li: {
    return isInt<20>(Imm);
  }
  case GICXXPred_I64_Predicate_simm21_lsb0_jal: {
    return isShiftedInt<20, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_simm26: {
    return isInt<26>(Imm);
  }
  case GICXXPred_I64_Predicate_simm26_nosimm12: {
    
      return isInt<26>(Imm) && !isInt<12>(Imm);
  }
  case GICXXPred_I64_Predicate_simm32_nosimm26: {
    
      return isInt<32>(Imm) && !isInt<26>(Imm);
  }
  case GICXXPred_I64_Predicate_tsimm5: {
    return isInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_tuimm5: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_u32simm12: {
    
      return isUInt<32>(Imm) && isInt<12>(SignExtend64<32>(Imm));
    
  }
  case GICXXPred_I64_Predicate_uimm1: {
    return isUInt<1>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm2: {
    return isUInt<2>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm2_3: {
    
      return isShiftedUInt<2, 3>(Imm);
    
  }
  case GICXXPred_I64_Predicate_uimm2_4: {
    
      return isShiftedUInt<2, 4>(Imm);
    
  }
  case GICXXPred_I64_Predicate_uimm2_lsb0: {
    return isShiftedUInt<1, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm3: {
    return isUInt<3>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm4: {
    return isUInt<4>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm5: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm5_lsb0: {
    return isShiftedUInt<4, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm5_plus1: {
    return (isUInt<5>(Imm) && (Imm != 0)) || (Imm == 32);
  }
  case GICXXPred_I64_Predicate_uimm5ge6_plus1: {
    return (Imm >= 6) && (isUInt<5>(Imm) || (Imm == 32));
  }
  case GICXXPred_I64_Predicate_uimm5gt3: {
    return (Imm > 3) && isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm5i32: {
    return isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm5nonzero: {
    return (Imm != 0) && isUInt<5>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm5slist: {
    return ((Imm == 0)  ||
                (Imm == 1)  ||
                (Imm == 2)  ||
                (Imm == 4)  ||
                (Imm == 8)  ||
                (Imm == 16) ||
                (Imm == 15) ||
                (Imm == 31));
  }
  case GICXXPred_I64_Predicate_uimm6: {
    return isUInt<6>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm6_lsb0: {
    return isShiftedUInt<5, 1>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm6gt32: {
    
      return isUInt<6>(Imm) && Imm > 32;
    
  }
  case GICXXPred_I64_Predicate_uimm7: {
    return isUInt<7>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm7_lsb00: {
    return isShiftedUInt<5, 2>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm7_lsb000: {
    return isShiftedUInt<4, 3>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm8_lsb00: {
    return isShiftedUInt<6, 2>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm8_lsb000: {
    return isShiftedUInt<5, 3>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm9_lsb000: {
    return isShiftedUInt<6, 3>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm10: {
    return isUInt<10>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm10_lsb00nonzero: {
    return isShiftedUInt<8, 2>(Imm) && (Imm != 0);
  }
  case GICXXPred_I64_Predicate_uimm11: {
    return isUInt<11>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm14lsb00: {
    return isShiftedUInt<12, 2>(Imm);
  }
  case GICXXPred_I64_Predicate_uimm16nonzero: {
    return (Imm != 0) && isUInt<16>(Imm);
  }
  case GICXXPred_I64_Predicate_uimmlog2xlen: {
    
      if (Subtarget->is64Bit())
        return isUInt<6>(Imm);
      return isUInt<5>(Imm);
    
    llvm_unreachable("uimmlog2xlen should have returned");
  }
  case GICXXPred_I64_Predicate_uimmlog2xlennonzero: {
    
      if (Subtarget->is64Bit())
        return isUInt<6>(Imm) && (Imm != 0);
      return isUInt<5>(Imm) && (Imm != 0);
    
    llvm_unreachable("uimmlog2xlennonzero should have returned");
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool RISCVInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_Shifted32OnesMask = GICXXPred_Invalid + 1,
  GICXXPred_APInt_Predicate_TrailingOnesMask,
};
bool RISCVInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_Shifted32OnesMask: {
    
      if (!Imm.isShiftedMask())
        return false;
    
      unsigned TrailingZeros = Imm.countr_zero();
      return TrailingZeros > 0 && TrailingZeros < 32 &&
             Imm == UINT64_C(0xFFFFFFFF) << TrailingZeros;
    
    llvm_unreachable("Shifted32OnesMask should have returned");
  }
  case GICXXPred_APInt_Predicate_TrailingOnesMask: {
    
      return !isInt<12>(Imm.getSExtValue()) && isMask_64(Imm.getZExtValue());
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool RISCVInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("RISCVInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
  GICR_renderAddiPairImmLarge,
  GICR_renderAddiPairImmSmall,
  GICR_renderFrameIndex,
  GICR_renderImmPlus1,
  GICR_renderImmSubFrom32,
  GICR_renderImmSubFromXLen,
  GICR_renderNegImm,
  GICR_renderTrailingZeros,
  GICR_renderXLenSubTrailingOnes,
};
RISCVInstructionSelector::CustomRendererFn
RISCVInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
  &RISCVInstructionSelector::renderAddiPairImmLarge,
  &RISCVInstructionSelector::renderAddiPairImmSmall,
  &RISCVInstructionSelector::renderFrameIndex,
  &RISCVInstructionSelector::renderImmPlus1,
  &RISCVInstructionSelector::renderImmSubFrom32,
  &RISCVInstructionSelector::renderImmSubFromXLen,
  &RISCVInstructionSelector::renderNegImm,
  &RISCVInstructionSelector::renderTrailingZeros,
  &RISCVInstructionSelector::renderXLenSubTrailingOnes,
};

bool RISCVInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool RISCVInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("RISCVInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *RISCVInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
     /*       0 */ GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(53), GIMT_Encode2(337), /*)*//*default:*//*Label 125*/ GIMT_Encode4(2457144),
     /*      10 */ /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(1146),
     /*      14 */ /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(61537),
     /*      18 */ /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(80770),
     /*      22 */ /*TargetOpcode::G_SDIV*//*Label 3*/ GIMT_Encode4(107824),
     /*      26 */ /*TargetOpcode::G_UDIV*//*Label 4*/ GIMT_Encode4(110558),
     /*      30 */ /*TargetOpcode::G_SREM*//*Label 5*/ GIMT_Encode4(113292),
     /*      34 */ /*TargetOpcode::G_UREM*//*Label 6*/ GIMT_Encode4(116071), GIMT_Encode4(0), GIMT_Encode4(0),
     /*      46 */ /*TargetOpcode::G_AND*//*Label 7*/ GIMT_Encode4(118805),
     /*      50 */ /*TargetOpcode::G_OR*//*Label 8*/ GIMT_Encode4(128763),
     /*      54 */ /*TargetOpcode::G_XOR*//*Label 9*/ GIMT_Encode4(141384), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*      74 */ /*TargetOpcode::G_FRAME_INDEX*//*Label 10*/ GIMT_Encode4(156291), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*      94 */ /*TargetOpcode::G_UNMERGE_VALUES*//*Label 11*/ GIMT_Encode4(156352), GIMT_Encode4(0),
     /*     102 */ /*TargetOpcode::G_MERGE_VALUES*//*Label 12*/ GIMT_Encode4(156413), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     126 */ /*TargetOpcode::G_BITCAST*//*Label 13*/ GIMT_Encode4(156504), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     142 */ /*TargetOpcode::G_INTRINSIC_TRUNC*//*Label 14*/ GIMT_Encode4(156871),
     /*     146 */ /*TargetOpcode::G_INTRINSIC_ROUND*//*Label 15*/ GIMT_Encode4(157069),
     /*     150 */ /*TargetOpcode::G_INTRINSIC_LRINT*//*Label 16*/ GIMT_Encode4(157267),
     /*     154 */ /*TargetOpcode::G_INTRINSIC_LLRINT*//*Label 17*/ GIMT_Encode4(157847),
     /*     158 */ /*TargetOpcode::G_INTRINSIC_ROUNDEVEN*//*Label 18*/ GIMT_Encode4(158057),
     /*     162 */ /*TargetOpcode::G_READCYCLECOUNTER*//*Label 19*/ GIMT_Encode4(158255),
     /*     166 */ /*TargetOpcode::G_READSTEADYCOUNTER*//*Label 20*/ GIMT_Encode4(158294),
     /*     170 */ /*TargetOpcode::G_LOAD*//*Label 21*/ GIMT_Encode4(158333),
     /*     174 */ /*TargetOpcode::G_SEXTLOAD*//*Label 22*/ GIMT_Encode4(167311),
     /*     178 */ /*TargetOpcode::G_ZEXTLOAD*//*Label 23*/ GIMT_Encode4(168425), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     194 */ /*TargetOpcode::G_STORE*//*Label 24*/ GIMT_Encode4(169059), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     206 */ /*TargetOpcode::G_ATOMIC_CMPXCHG*//*Label 25*/ GIMT_Encode4(175959),
     /*     210 */ /*TargetOpcode::G_ATOMICRMW_XCHG*//*Label 26*/ GIMT_Encode4(180845),
     /*     214 */ /*TargetOpcode::G_ATOMICRMW_ADD*//*Label 27*/ GIMT_Encode4(183755), GIMT_Encode4(0),
     /*     222 */ /*TargetOpcode::G_ATOMICRMW_AND*//*Label 28*/ GIMT_Encode4(186665),
     /*     226 */ /*TargetOpcode::G_ATOMICRMW_NAND*//*Label 29*/ GIMT_Encode4(189575),
     /*     230 */ /*TargetOpcode::G_ATOMICRMW_OR*//*Label 30*/ GIMT_Encode4(190487),
     /*     234 */ /*TargetOpcode::G_ATOMICRMW_XOR*//*Label 31*/ GIMT_Encode4(193397),
     /*     238 */ /*TargetOpcode::G_ATOMICRMW_MAX*//*Label 32*/ GIMT_Encode4(196307),
     /*     242 */ /*TargetOpcode::G_ATOMICRMW_MIN*//*Label 33*/ GIMT_Encode4(199217),
     /*     246 */ /*TargetOpcode::G_ATOMICRMW_UMAX*//*Label 34*/ GIMT_Encode4(202127),
     /*     250 */ /*TargetOpcode::G_ATOMICRMW_UMIN*//*Label 35*/ GIMT_Encode4(205037), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     294 */ /*TargetOpcode::G_FENCE*//*Label 36*/ GIMT_Encode4(207947), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     314 */ /*TargetOpcode::G_INTRINSIC*//*Label 37*/ GIMT_Encode4(208165),
     /*     318 */ /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 38*/ GIMT_Encode4(2206458), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     330 */ /*TargetOpcode::G_ANYEXT*//*Label 39*/ GIMT_Encode4(2208026), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     366 */ /*TargetOpcode::G_SEXT*//*Label 40*/ GIMT_Encode4(2211147),
     /*     370 */ /*TargetOpcode::G_SEXT_INREG*//*Label 41*/ GIMT_Encode4(2214622),
     /*     374 */ /*TargetOpcode::G_ZEXT*//*Label 42*/ GIMT_Encode4(2215665),
     /*     378 */ /*TargetOpcode::G_SHL*//*Label 43*/ GIMT_Encode4(2219352),
     /*     382 */ /*TargetOpcode::G_LSHR*//*Label 44*/ GIMT_Encode4(2227948),
     /*     386 */ /*TargetOpcode::G_ASHR*//*Label 45*/ GIMT_Encode4(2230979), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     398 */ /*TargetOpcode::G_ROTR*//*Label 46*/ GIMT_Encode4(2233918),
     /*     402 */ /*TargetOpcode::G_ROTL*//*Label 47*/ GIMT_Encode4(2236858),
     /*     406 */ /*TargetOpcode::G_ICMP*//*Label 48*/ GIMT_Encode4(2239768),
     /*     410 */ /*TargetOpcode::G_FCMP*//*Label 49*/ GIMT_Encode4(2266845), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     422 */ /*TargetOpcode::G_SELECT*//*Label 50*/ GIMT_Encode4(2274307), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     466 */ /*TargetOpcode::G_UMULH*//*Label 51*/ GIMT_Encode4(2285292),
     /*     470 */ /*TargetOpcode::G_SMULH*//*Label 52*/ GIMT_Encode4(2288026),
     /*     474 */ /*TargetOpcode::G_UADDSAT*//*Label 53*/ GIMT_Encode4(2290760),
     /*     478 */ /*TargetOpcode::G_SADDSAT*//*Label 54*/ GIMT_Encode4(2293613),
     /*     482 */ /*TargetOpcode::G_USUBSAT*//*Label 55*/ GIMT_Encode4(2296466),
     /*     486 */ /*TargetOpcode::G_SSUBSAT*//*Label 56*/ GIMT_Encode4(2299319),
     /*     490 */ /*TargetOpcode::G_USHLSAT*//*Label 57*/ GIMT_Encode4(2302172),
     /*     494 */ /*TargetOpcode::G_SSHLSAT*//*Label 58*/ GIMT_Encode4(2302230), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     530 */ /*TargetOpcode::G_FADD*//*Label 59*/ GIMT_Encode4(2302288),
     /*     534 */ /*TargetOpcode::G_FSUB*//*Label 60*/ GIMT_Encode4(2304716),
     /*     538 */ /*TargetOpcode::G_FMUL*//*Label 61*/ GIMT_Encode4(2307144),
     /*     542 */ /*TargetOpcode::G_FMA*//*Label 62*/ GIMT_Encode4(2309572), GIMT_Encode4(0),
     /*     550 */ /*TargetOpcode::G_FDIV*//*Label 63*/ GIMT_Encode4(2326217), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     598 */ /*TargetOpcode::G_FNEG*//*Label 64*/ GIMT_Encode4(2328645),
     /*     602 */ /*TargetOpcode::G_FPEXT*//*Label 65*/ GIMT_Encode4(2330616),
     /*     606 */ /*TargetOpcode::G_FPTRUNC*//*Label 66*/ GIMT_Encode4(2331069),
     /*     610 */ /*TargetOpcode::G_FPTOSI*//*Label 67*/ GIMT_Encode4(2332605),
     /*     614 */ /*TargetOpcode::G_FPTOUI*//*Label 68*/ GIMT_Encode4(2337491),
     /*     618 */ /*TargetOpcode::G_SITOFP*//*Label 69*/ GIMT_Encode4(2342377),
     /*     622 */ /*TargetOpcode::G_UITOFP*//*Label 70*/ GIMT_Encode4(2347663), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     634 */ /*TargetOpcode::G_FABS*//*Label 71*/ GIMT_Encode4(2352949),
     /*     638 */ /*TargetOpcode::G_FCOPYSIGN*//*Label 72*/ GIMT_Encode4(2354920), GIMT_Encode4(0),
     /*     646 */ /*TargetOpcode::G_FCANONICALIZE*//*Label 73*/ GIMT_Encode4(2360982),
     /*     650 */ /*TargetOpcode::G_FMINNUM*//*Label 74*/ GIMT_Encode4(2361172),
     /*     654 */ /*TargetOpcode::G_FMAXNUM*//*Label 75*/ GIMT_Encode4(2363257), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     666 */ /*TargetOpcode::G_FMINIMUM*//*Label 76*/ GIMT_Encode4(2365342),
     /*     670 */ /*TargetOpcode::G_FMAXIMUM*//*Label 77*/ GIMT_Encode4(2365468),
     /*     674 */ /*TargetOpcode::G_FMINIMUMNUM*//*Label 78*/ GIMT_Encode4(2365594),
     /*     678 */ /*TargetOpcode::G_FMAXIMUMNUM*//*Label 79*/ GIMT_Encode4(2367679), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     718 */ /*TargetOpcode::G_SMIN*//*Label 80*/ GIMT_Encode4(2369764),
     /*     722 */ /*TargetOpcode::G_SMAX*//*Label 81*/ GIMT_Encode4(2372540),
     /*     726 */ /*TargetOpcode::G_UMIN*//*Label 82*/ GIMT_Encode4(2375316),
     /*     730 */ /*TargetOpcode::G_UMAX*//*Label 83*/ GIMT_Encode4(2378092),
     /*     734 */ /*TargetOpcode::G_ABS*//*Label 84*/ GIMT_Encode4(2380868),
     /*     738 */ /*TargetOpcode::G_LROUND*//*Label 85*/ GIMT_Encode4(2381026),
     /*     742 */ /*TargetOpcode::G_LLROUND*//*Label 86*/ GIMT_Encode4(2381606),
     /*     746 */ /*TargetOpcode::G_BR*//*Label 87*/ GIMT_Encode4(2381816), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     790 */ /*TargetOpcode::G_CTTZ*//*Label 88*/ GIMT_Encode4(2381832), GIMT_Encode4(0),
     /*     798 */ /*TargetOpcode::G_CTLZ*//*Label 89*/ GIMT_Encode4(2384460), GIMT_Encode4(0),
     /*     806 */ /*TargetOpcode::G_CTPOP*//*Label 90*/ GIMT_Encode4(2387230),
     /*     810 */ /*TargetOpcode::G_BSWAP*//*Label 91*/ GIMT_Encode4(2389781),
     /*     814 */ /*TargetOpcode::G_BITREVERSE*//*Label 92*/ GIMT_Encode4(2392316),
     /*     818 */ /*TargetOpcode::G_FCEIL*//*Label 93*/ GIMT_Encode4(2394862), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     866 */ /*TargetOpcode::G_FSQRT*//*Label 94*/ GIMT_Encode4(2395060),
     /*     870 */ /*TargetOpcode::G_FFLOOR*//*Label 95*/ GIMT_Encode4(2397236),
     /*     874 */ /*TargetOpcode::G_FRINT*//*Label 96*/ GIMT_Encode4(2397434),
     /*     878 */ /*TargetOpcode::G_FNEARBYINT*//*Label 97*/ GIMT_Encode4(2397632), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     906 */ /*TargetOpcode::G_STRICT_FADD*//*Label 98*/ GIMT_Encode4(2397830),
     /*     910 */ /*TargetOpcode::G_STRICT_FSUB*//*Label 99*/ GIMT_Encode4(2400258),
     /*     914 */ /*TargetOpcode::G_STRICT_FMUL*//*Label 100*/ GIMT_Encode4(2402686),
     /*     918 */ /*TargetOpcode::G_STRICT_FDIV*//*Label 101*/ GIMT_Encode4(2405114), GIMT_Encode4(0),
     /*     926 */ /*TargetOpcode::G_STRICT_FMA*//*Label 102*/ GIMT_Encode4(2407542),
     /*     930 */ /*TargetOpcode::G_STRICT_FSQRT*//*Label 103*/ GIMT_Encode4(2424187), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*     966 */ /*TargetOpcode::G_TRAP*//*Label 104*/ GIMT_Encode4(2426363),
     /*     970 */ /*TargetOpcode::G_DEBUGTRAP*//*Label 105*/ GIMT_Encode4(2426376), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
     /*    1066 */ /*RISCV::G_CLZW*//*Label 106*/ GIMT_Encode4(2426389),
     /*    1070 */ /*RISCV::G_CTZW*//*Label 107*/ GIMT_Encode4(2426484),
     /*    1074 */ /*RISCV::G_DIVUW*//*Label 108*/ GIMT_Encode4(2426514),
     /*    1078 */ /*RISCV::G_DIVW*//*Label 109*/ GIMT_Encode4(2426551),
     /*    1082 */ /*RISCV::G_FCLASS*//*Label 110*/ GIMT_Encode4(2426588),
     /*    1086 */ /*RISCV::G_FCVT_WU_RV64*//*Label 111*/ GIMT_Encode4(2426948),
     /*    1090 */ /*RISCV::G_FCVT_W_RV64*//*Label 112*/ GIMT_Encode4(2427146),
     /*    1094 */ /*RISCV::G_READ_VLENB*//*Label 113*/ GIMT_Encode4(2427344),
     /*    1098 */ /*RISCV::G_REMUW*//*Label 114*/ GIMT_Encode4(2427404),
     /*    1102 */ /*RISCV::G_ROLW*//*Label 115*/ GIMT_Encode4(2427441),
     /*    1106 */ /*RISCV::G_RORW*//*Label 116*/ GIMT_Encode4(2427566),
     /*    1110 */ /*RISCV::G_SLLW*//*Label 117*/ GIMT_Encode4(2427687), GIMT_Encode4(0),
     /*    1118 */ /*RISCV::G_SRAW*//*Label 118*/ GIMT_Encode4(2427734),
     /*    1122 */ /*RISCV::G_SRLW*//*Label 119*/ GIMT_Encode4(2427781),
     /*    1126 */ /*RISCV::G_VMCLR_VL*//*Label 120*/ GIMT_Encode4(2427828),
     /*    1130 */ /*RISCV::G_VMSET_VL*//*Label 121*/ GIMT_Encode4(2428477),
     /*    1134 */ /*RISCV::G_VMV_V_V_VL*//*Label 122*/ GIMT_Encode4(2429126),
     /*    1138 */ /*RISCV::G_VSLIDEDOWN_VL*//*Label 123*/ GIMT_Encode4(2433384),
     /*    1142 */ /*RISCV::G_VSLIDEUP_VL*//*Label 124*/ GIMT_Encode4(2445264),
     /*    1146 */ // Label 0: @1146
     /*    1146 */ GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(34), /*)*//*default:*//*Label 150*/ GIMT_Encode4(61536),
     /*    1157 */ /*GILLT_s32*//*Label 126*/ GIMT_Encode4(1281),
     /*    1161 */ /*GILLT_s64*//*Label 127*/ GIMT_Encode4(3996), GIMT_Encode4(0),
     /*    1169 */ /*GILLT_nxv1s8*//*Label 128*/ GIMT_Encode4(11896),
     /*    1173 */ /*GILLT_nxv1s16*//*Label 129*/ GIMT_Encode4(12291),
     /*    1177 */ /*GILLT_nxv1s32*//*Label 130*/ GIMT_Encode4(15416),
     /*    1181 */ /*GILLT_nxv1s64*//*Label 131*/ GIMT_Encode4(18541), GIMT_Encode4(0),
     /*    1189 */ /*GILLT_nxv2s8*//*Label 132*/ GIMT_Encode4(21666),
     /*    1193 */ /*GILLT_nxv2s16*//*Label 133*/ GIMT_Encode4(22061),
     /*    1197 */ /*GILLT_nxv2s32*//*Label 134*/ GIMT_Encode4(25186),
     /*    1201 */ /*GILLT_nxv2s64*//*Label 135*/ GIMT_Encode4(28311), GIMT_Encode4(0),
     /*    1209 */ /*GILLT_nxv4s8*//*Label 136*/ GIMT_Encode4(31436),
     /*    1213 */ /*GILLT_nxv4s16*//*Label 137*/ GIMT_Encode4(31831),
     /*    1217 */ /*GILLT_nxv4s32*//*Label 138*/ GIMT_Encode4(34956),
     /*    1221 */ /*GILLT_nxv4s64*//*Label 139*/ GIMT_Encode4(38081), GIMT_Encode4(0),
     /*    1229 */ /*GILLT_nxv8s8*//*Label 140*/ GIMT_Encode4(41206),
     /*    1233 */ /*GILLT_nxv8s16*//*Label 141*/ GIMT_Encode4(41601),
     /*    1237 */ /*GILLT_nxv8s32*//*Label 142*/ GIMT_Encode4(44726),
     /*    1241 */ /*GILLT_nxv8s64*//*Label 143*/ GIMT_Encode4(47851), GIMT_Encode4(0),
     /*    1249 */ /*GILLT_nxv16s8*//*Label 144*/ GIMT_Encode4(50976),
     /*    1253 */ /*GILLT_nxv16s16*//*Label 145*/ GIMT_Encode4(51371),
     /*    1257 */ /*GILLT_nxv16s32*//*Label 146*/ GIMT_Encode4(54496), GIMT_Encode4(0),
     /*    1265 */ /*GILLT_nxv32s8*//*Label 147*/ GIMT_Encode4(57621),
     /*    1269 */ /*GILLT_nxv32s16*//*Label 148*/ GIMT_Encode4(58016), GIMT_Encode4(0),
     /*    1277 */ /*GILLT_nxv64s8*//*Label 149*/ GIMT_Encode4(61141),
     /*    1281 */ // Label 126: @1281
     /*    1281 */ GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(3995),
     /*    1286 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
     /*    1289 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
     /*    1292 */   GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(1340), // Rule ID 2572 //
     /*    1297 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
     /*    1300 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1304 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:2:x
     /*    1308 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:2:y
     /*    1312 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1316 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    1320 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
     /*    1327 */     // (add:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs1:$pred:2:x, GPR:{ *:[i32] }:$rs2:$pred:2:y)<<P:2:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    1327 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
     /*    1330 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    1332 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    1336 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    1338 */     GIR_RootConstrainSelectedInstOperands,
     /*    1339 */     // GIR_Coverage, 2572,
     /*    1339 */     GIR_EraseRootFromParent_Done,
     /*    1340 */   // Label 152: @1340
     /*    1340 */   GIM_Try, /*On fail goto*//*Label 153*/ GIMT_Encode4(1388), // Rule ID 2582 //
     /*    1345 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
     /*    1348 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1352 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:4:x
     /*    1356 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:4:y
     /*    1360 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1364 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    1368 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
     /*    1375 */     // (add:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs1:$pred:4:x, GPR:{ *:[i32] }:$rs2:$pred:4:y)<<P:4:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    1375 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
     /*    1378 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    1380 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    1384 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    1386 */     GIR_RootConstrainSelectedInstOperands,
     /*    1387 */     // GIR_Coverage, 2582,
     /*    1387 */     GIR_EraseRootFromParent_Done,
     /*    1388 */   // Label 153: @1388
     /*    1388 */   GIM_Try, /*On fail goto*//*Label 154*/ GIMT_Encode4(1436), // Rule ID 2592 //
     /*    1393 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
     /*    1396 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1400 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:6:x
     /*    1404 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:6:y
     /*    1408 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1412 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    1416 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
     /*    1423 */     // (add:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs1:$pred:6:x, GPR:{ *:[i32] }:$rs2:$pred:6:y)<<P:6:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    1423 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
     /*    1426 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    1428 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    1432 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    1434 */     GIR_RootConstrainSelectedInstOperands,
     /*    1435 */     // GIR_Coverage, 2592,
     /*    1435 */     GIR_EraseRootFromParent_Done,
     /*    1436 */   // Label 154: @1436
     /*    1436 */   GIM_Try, /*On fail goto*//*Label 155*/ GIMT_Encode4(1487), // Rule ID 62538 //
     /*    1441 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
     /*    1444 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1448 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:24:x
     /*    1452 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:24:y
     /*    1456 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1460 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    1464 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
     /*    1471 */     // (add:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs2:$pred:24:x, GPR:{ *:[i32] }:$rs1:$pred:24:y)<<P:24:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, sh1add_op:{ *:[i32] }:$rs2, 1:{ *:[i32] })
     /*    1471 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
     /*    1474 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    1476 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs1
     /*    1478 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
     /*    1482 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*    1485 */     GIR_RootConstrainSelectedInstOperands,
     /*    1486 */     // GIR_Coverage, 62538,
     /*    1486 */     GIR_EraseRootFromParent_Done,
     /*    1487 */   // Label 155: @1487
     /*    1487 */   GIM_Try, /*On fail goto*//*Label 156*/ GIMT_Encode4(1538), // Rule ID 62542 //
     /*    1492 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
     /*    1495 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1499 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:25:x
     /*    1503 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:25:y
     /*    1507 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1511 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    1515 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
     /*    1522 */     // (add:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs2:$pred:25:x, GPR:{ *:[i32] }:$rs1:$pred:25:y)<<P:25:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, sh2add_op:{ *:[i32] }:$rs2, 2:{ *:[i32] })
     /*    1522 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
     /*    1525 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    1527 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs1
     /*    1529 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
     /*    1533 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/2,
     /*    1536 */     GIR_RootConstrainSelectedInstOperands,
     /*    1537 */     // GIR_Coverage, 62542,
     /*    1537 */     GIR_EraseRootFromParent_Done,
     /*    1538 */   // Label 156: @1538
     /*    1538 */   GIM_Try, /*On fail goto*//*Label 157*/ GIMT_Encode4(1589), // Rule ID 62546 //
     /*    1543 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
     /*    1546 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1550 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:26:x
     /*    1554 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:26:y
     /*    1558 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1562 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    1566 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
     /*    1573 */     // (add:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs2:$pred:26:x, GPR:{ *:[i32] }:$rs1:$pred:26:y)<<P:26:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, sh3add_op:{ *:[i32] }:$rs2, 3:{ *:[i32] })
     /*    1573 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
     /*    1576 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    1578 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs1
     /*    1580 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
     /*    1584 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*    1587 */     GIR_RootConstrainSelectedInstOperands,
     /*    1588 */     // GIR_Coverage, 62546,
     /*    1588 */     GIR_EraseRootFromParent_Done,
     /*    1589 */   // Label 157: @1589
     /*    1589 */   GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(1637), // Rule ID 65117 //
     /*    1594 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode1),
     /*    1597 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1601 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:29:x
     /*    1605 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:29:y
     /*    1609 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1613 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    1617 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
     /*    1624 */     // (add:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs1:$pred:29:x, GPR:{ *:[i32] }:$rs2:$pred:29:y)<<P:29:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_H:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    1624 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_H),
     /*    1627 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    1629 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    1633 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    1635 */     GIR_RootConstrainSelectedInstOperands,
     /*    1636 */     // GIR_Coverage, 65117,
     /*    1636 */     GIR_EraseRootFromParent_Done,
     /*    1637 */   // Label 158: @1637
     /*    1637 */   GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(1685), // Rule ID 65127 //
     /*    1642 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode1),
     /*    1645 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1649 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:31:x
     /*    1653 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:31:y
     /*    1657 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1661 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    1665 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
     /*    1672 */     // (add:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs1:$pred:31:x, GPR:{ *:[i32] }:$rs2:$pred:31:y)<<P:31:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_W:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    1672 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_W),
     /*    1675 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    1677 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    1681 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    1683 */     GIR_RootConstrainSelectedInstOperands,
     /*    1684 */     // GIR_Coverage, 65127,
     /*    1684 */     GIR_EraseRootFromParent_Done,
     /*    1685 */   // Label 159: @1685
     /*    1685 */   GIM_Try, /*On fail goto*//*Label 160*/ GIMT_Encode4(1733), // Rule ID 65137 //
     /*    1690 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode1),
     /*    1693 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1697 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:33:x
     /*    1701 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:33:y
     /*    1705 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1709 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    1713 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
     /*    1720 */     // (add:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs1:$pred:33:x, GPR:{ *:[i32] }:$rs2:$pred:33:y)<<P:33:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_D:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    1720 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_D),
     /*    1723 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    1725 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    1729 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    1731 */     GIR_RootConstrainSelectedInstOperands,
     /*    1732 */     // GIR_Coverage, 65137,
     /*    1732 */     GIR_EraseRootFromParent_Done,
     /*    1733 */   // Label 160: @1733
     /*    1733 */   GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(1781), // Rule ID 65596 //
     /*    1738 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
     /*    1741 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1745 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:2:y
     /*    1749 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1753 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:2:x
     /*    1757 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    1761 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
     /*    1768 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:2:y, sh1add_op:{ *:[i32] }:$rs1:$pred:2:x)<<P:2:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    1768 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
     /*    1771 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    1773 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    1777 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    1779 */     GIR_RootConstrainSelectedInstOperands,
     /*    1780 */     // GIR_Coverage, 65596,
     /*    1780 */     GIR_EraseRootFromParent_Done,
     /*    1781 */   // Label 161: @1781
     /*    1781 */   GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(1829), // Rule ID 65604 //
     /*    1786 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
     /*    1789 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1793 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:4:y
     /*    1797 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1801 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:4:x
     /*    1805 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    1809 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
     /*    1816 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:4:y, sh2add_op:{ *:[i32] }:$rs1:$pred:4:x)<<P:4:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    1816 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
     /*    1819 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    1821 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    1825 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    1827 */     GIR_RootConstrainSelectedInstOperands,
     /*    1828 */     // GIR_Coverage, 65604,
     /*    1828 */     GIR_EraseRootFromParent_Done,
     /*    1829 */   // Label 162: @1829
     /*    1829 */   GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(1877), // Rule ID 65612 //
     /*    1834 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
     /*    1837 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1841 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:6:y
     /*    1845 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1849 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:6:x
     /*    1853 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    1857 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
     /*    1864 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:6:y, sh3add_op:{ *:[i32] }:$rs1:$pred:6:x)<<P:6:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    1864 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
     /*    1867 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    1869 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    1873 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    1875 */     GIR_RootConstrainSelectedInstOperands,
     /*    1876 */     // GIR_Coverage, 65612,
     /*    1876 */     GIR_EraseRootFromParent_Done,
     /*    1877 */   // Label 163: @1877
     /*    1877 */   GIM_Try, /*On fail goto*//*Label 164*/ GIMT_Encode4(1928), // Rule ID 74430 //
     /*    1882 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
     /*    1885 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1889 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:24:y
     /*    1893 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1897 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:24:x
     /*    1901 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    1905 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
     /*    1912 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1:$pred:24:y, sh1add_op:{ *:[i32] }:$rs2:$pred:24:x)<<P:24:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, sh1add_op:{ *:[i32] }:$rs2, 1:{ *:[i32] })
     /*    1912 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
     /*    1915 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    1917 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*    1919 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
     /*    1923 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*    1926 */     GIR_RootConstrainSelectedInstOperands,
     /*    1927 */     // GIR_Coverage, 74430,
     /*    1927 */     GIR_EraseRootFromParent_Done,
     /*    1928 */   // Label 164: @1928
     /*    1928 */   GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(1979), // Rule ID 74434 //
     /*    1933 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
     /*    1936 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1940 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:25:y
     /*    1944 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1948 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:25:x
     /*    1952 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    1956 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
     /*    1963 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1:$pred:25:y, sh2add_op:{ *:[i32] }:$rs2:$pred:25:x)<<P:25:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, sh2add_op:{ *:[i32] }:$rs2, 2:{ *:[i32] })
     /*    1963 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
     /*    1966 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    1968 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*    1970 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
     /*    1974 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/2,
     /*    1977 */     GIR_RootConstrainSelectedInstOperands,
     /*    1978 */     // GIR_Coverage, 74434,
     /*    1978 */     GIR_EraseRootFromParent_Done,
     /*    1979 */   // Label 165: @1979
     /*    1979 */   GIM_Try, /*On fail goto*//*Label 166*/ GIMT_Encode4(2030), // Rule ID 74438 //
     /*    1984 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
     /*    1987 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1991 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:26:y
     /*    1995 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    1999 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:26:x
     /*    2003 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    2007 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
     /*    2014 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1:$pred:26:y, sh3add_op:{ *:[i32] }:$rs2:$pred:26:x)<<P:26:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, sh3add_op:{ *:[i32] }:$rs2, 3:{ *:[i32] })
     /*    2014 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
     /*    2017 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    2019 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*    2021 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
     /*    2025 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*    2028 */     GIR_RootConstrainSelectedInstOperands,
     /*    2029 */     // GIR_Coverage, 74438,
     /*    2029 */     GIR_EraseRootFromParent_Done,
     /*    2030 */   // Label 166: @2030
     /*    2030 */   GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(2078), // Rule ID 74456 //
     /*    2035 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode1),
     /*    2038 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2042 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:29:y
     /*    2046 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2050 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:29:x
     /*    2054 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    2058 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
     /*    2065 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:29:y, sh1add_op:{ *:[i32] }:$rs1:$pred:29:x)<<P:29:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_H:{ *:[i32] } sh1add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    2065 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_H),
     /*    2068 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    2070 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    2074 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    2076 */     GIR_RootConstrainSelectedInstOperands,
     /*    2077 */     // GIR_Coverage, 74456,
     /*    2077 */     GIR_EraseRootFromParent_Done,
     /*    2078 */   // Label 167: @2078
     /*    2078 */   GIM_Try, /*On fail goto*//*Label 168*/ GIMT_Encode4(2126), // Rule ID 74464 //
     /*    2083 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode1),
     /*    2086 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2090 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:31:y
     /*    2094 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2098 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:31:x
     /*    2102 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    2106 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
     /*    2113 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:31:y, sh2add_op:{ *:[i32] }:$rs1:$pred:31:x)<<P:31:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_W:{ *:[i32] } sh2add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    2113 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_W),
     /*    2116 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    2118 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    2122 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    2124 */     GIR_RootConstrainSelectedInstOperands,
     /*    2125 */     // GIR_Coverage, 74464,
     /*    2125 */     GIR_EraseRootFromParent_Done,
     /*    2126 */   // Label 168: @2126
     /*    2126 */   GIM_Try, /*On fail goto*//*Label 169*/ GIMT_Encode4(2174), // Rule ID 74472 //
     /*    2131 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode1),
     /*    2134 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2138 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:33:y
     /*    2142 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2146 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:33:x
     /*    2150 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    2154 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
     /*    2161 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:33:y, sh3add_op:{ *:[i32] }:$rs1:$pred:33:x)<<P:33:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_D:{ *:[i32] } sh3add_op:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    2161 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_D),
     /*    2164 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    2166 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    2170 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    2172 */     GIR_RootConstrainSelectedInstOperands,
     /*    2173 */     // GIR_Coverage, 74472,
     /*    2173 */     GIR_EraseRootFromParent_Done,
     /*    2174 */   // Label 169: @2174
     /*    2174 */   GIM_Try, /*On fail goto*//*Label 170*/ GIMT_Encode4(2242), // Rule ID 2566 //
     /*    2179 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
     /*    2182 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2186 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
     /*    2190 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    2194 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    2198 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*    2202 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*    2206 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2211 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*    2215 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
     /*    2219 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2223 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    2227 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    2229 */     // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }):$pred:1:x, GPR:{ *:[i32] }:$rs2:$pred:1:y)<<P:1:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    2229 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
     /*    2232 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    2234 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    2238 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    2240 */     GIR_RootConstrainSelectedInstOperands,
     /*    2241 */     // GIR_Coverage, 2566,
     /*    2241 */     GIR_EraseRootFromParent_Done,
     /*    2242 */   // Label 170: @2242
     /*    2242 */   GIM_Try, /*On fail goto*//*Label 171*/ GIMT_Encode4(2310), // Rule ID 2576 //
     /*    2247 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
     /*    2250 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2254 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
     /*    2258 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    2262 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    2266 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*    2270 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*    2274 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2279 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
     /*    2283 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
     /*    2287 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2291 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    2295 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    2297 */     // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i32] }):$pred:3:x, GPR:{ *:[i32] }:$rs2:$pred:3:y)<<P:3:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    2297 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
     /*    2300 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    2302 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    2306 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    2308 */     GIR_RootConstrainSelectedInstOperands,
     /*    2309 */     // GIR_Coverage, 2576,
     /*    2309 */     GIR_EraseRootFromParent_Done,
     /*    2310 */   // Label 171: @2310
     /*    2310 */   GIM_Try, /*On fail goto*//*Label 172*/ GIMT_Encode4(2378), // Rule ID 2586 //
     /*    2315 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
     /*    2318 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2322 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
     /*    2326 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    2330 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    2334 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*    2338 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*    2342 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2347 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
     /*    2351 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:5:y
     /*    2355 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2359 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    2363 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    2365 */     // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i32] }):$pred:5:x, GPR:{ *:[i32] }:$rs2:$pred:5:y)<<P:5:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    2365 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
     /*    2368 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    2370 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    2374 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    2376 */     GIR_RootConstrainSelectedInstOperands,
     /*    2377 */     // GIR_Coverage, 2586,
     /*    2377 */     GIR_EraseRootFromParent_Done,
     /*    2378 */   // Label 172: @2378
     /*    2378 */   GIM_Try, /*On fail goto*//*Label 173*/ GIMT_Encode4(2446), // Rule ID 65111 //
     /*    2383 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode1),
     /*    2386 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2390 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:28:x
     /*    2394 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    2398 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    2402 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*    2406 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*    2410 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2415 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*    2419 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:28:y
     /*    2423 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2427 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    2431 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    2433 */     // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }):$pred:28:x, GPR:{ *:[i32] }:$rs2:$pred:28:y)<<P:28:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_H:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    2433 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_H),
     /*    2436 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    2438 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    2442 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    2444 */     GIR_RootConstrainSelectedInstOperands,
     /*    2445 */     // GIR_Coverage, 65111,
     /*    2445 */     GIR_EraseRootFromParent_Done,
     /*    2446 */   // Label 173: @2446
     /*    2446 */   GIM_Try, /*On fail goto*//*Label 174*/ GIMT_Encode4(2514), // Rule ID 65121 //
     /*    2451 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode1),
     /*    2454 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2458 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:30:x
     /*    2462 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    2466 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    2470 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*    2474 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*    2478 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2483 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
     /*    2487 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:30:y
     /*    2491 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2495 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    2499 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    2501 */     // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i32] }):$pred:30:x, GPR:{ *:[i32] }:$rs2:$pred:30:y)<<P:30:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_W:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    2501 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_W),
     /*    2504 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    2506 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    2510 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    2512 */     GIR_RootConstrainSelectedInstOperands,
     /*    2513 */     // GIR_Coverage, 65121,
     /*    2513 */     GIR_EraseRootFromParent_Done,
     /*    2514 */   // Label 174: @2514
     /*    2514 */   GIM_Try, /*On fail goto*//*Label 175*/ GIMT_Encode4(2582), // Rule ID 65131 //
     /*    2519 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode1),
     /*    2522 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2526 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:32:x
     /*    2530 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    2534 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    2538 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*    2542 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*    2546 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2551 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
     /*    2555 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:32:y
     /*    2559 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2563 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    2567 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    2569 */     // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i32] }):$pred:32:x, GPR:{ *:[i32] }:$rs2:$pred:32:y)<<P:32:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_D:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    2569 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_D),
     /*    2572 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    2574 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    2578 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    2580 */     GIR_RootConstrainSelectedInstOperands,
     /*    2581 */     // GIR_Coverage, 65131,
     /*    2581 */     GIR_EraseRootFromParent_Done,
     /*    2582 */   // Label 175: @2582
     /*    2582 */   GIM_Try, /*On fail goto*//*Label 176*/ GIMT_Encode4(2650), // Rule ID 65592 //
     /*    2587 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
     /*    2590 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2594 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
     /*    2598 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2602 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:1:x
     /*    2606 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    2610 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    2614 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*    2618 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*    2622 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2627 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*    2631 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    2635 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    2637 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:1:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }):$pred:1:x)<<P:1:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    2637 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
     /*    2640 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    2642 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    2646 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    2648 */     GIR_RootConstrainSelectedInstOperands,
     /*    2649 */     // GIR_Coverage, 65592,
     /*    2649 */     GIR_EraseRootFromParent_Done,
     /*    2650 */   // Label 176: @2650
     /*    2650 */   GIM_Try, /*On fail goto*//*Label 177*/ GIMT_Encode4(2718), // Rule ID 65600 //
     /*    2655 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
     /*    2658 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2662 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:3:y
     /*    2666 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2670 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:3:x
     /*    2674 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    2678 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    2682 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*    2686 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*    2690 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2695 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
     /*    2699 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    2703 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    2705 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:3:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i32] }):$pred:3:x)<<P:3:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    2705 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
     /*    2708 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    2710 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    2714 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    2716 */     GIR_RootConstrainSelectedInstOperands,
     /*    2717 */     // GIR_Coverage, 65600,
     /*    2717 */     GIR_EraseRootFromParent_Done,
     /*    2718 */   // Label 177: @2718
     /*    2718 */   GIM_Try, /*On fail goto*//*Label 178*/ GIMT_Encode4(2786), // Rule ID 65608 //
     /*    2723 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode1),
     /*    2726 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2730 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:5:y
     /*    2734 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2738 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:5:x
     /*    2742 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    2746 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    2750 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*    2754 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*    2758 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2763 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
     /*    2767 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    2771 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    2773 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:5:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i32] }):$pred:5:x)<<P:5:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    2773 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
     /*    2776 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    2778 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    2782 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    2784 */     GIR_RootConstrainSelectedInstOperands,
     /*    2785 */     // GIR_Coverage, 65608,
     /*    2785 */     GIR_EraseRootFromParent_Done,
     /*    2786 */   // Label 178: @2786
     /*    2786 */   GIM_Try, /*On fail goto*//*Label 179*/ GIMT_Encode4(2854), // Rule ID 74452 //
     /*    2791 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode1),
     /*    2794 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2798 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:28:y
     /*    2802 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2806 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:28:x
     /*    2810 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    2814 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    2818 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*    2822 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*    2826 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2831 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*    2835 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    2839 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    2841 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:28:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 1:{ *:[i32] }):$pred:28:x)<<P:28:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_H:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    2841 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_H),
     /*    2844 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    2846 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    2850 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    2852 */     GIR_RootConstrainSelectedInstOperands,
     /*    2853 */     // GIR_Coverage, 74452,
     /*    2853 */     GIR_EraseRootFromParent_Done,
     /*    2854 */   // Label 179: @2854
     /*    2854 */   GIM_Try, /*On fail goto*//*Label 180*/ GIMT_Encode4(2922), // Rule ID 74460 //
     /*    2859 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode1),
     /*    2862 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2866 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:30:y
     /*    2870 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2874 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:30:x
     /*    2878 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    2882 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    2886 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*    2890 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*    2894 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2899 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
     /*    2903 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    2907 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    2909 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:30:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 2:{ *:[i32] }):$pred:30:x)<<P:30:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_W:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    2909 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_W),
     /*    2912 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    2914 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    2918 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    2920 */     GIR_RootConstrainSelectedInstOperands,
     /*    2921 */     // GIR_Coverage, 74460,
     /*    2921 */     GIR_EraseRootFromParent_Done,
     /*    2922 */   // Label 180: @2922
     /*    2922 */   GIM_Try, /*On fail goto*//*Label 181*/ GIMT_Encode4(2990), // Rule ID 74468 //
     /*    2927 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode1),
     /*    2930 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2934 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:32:y
     /*    2938 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2942 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:32:x
     /*    2946 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    2950 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    2954 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*    2958 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*    2962 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    2967 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
     /*    2971 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    2975 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    2977 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs2:$pred:32:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs1, 3:{ *:[i32] }):$pred:32:x)<<P:32:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_D:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    2977 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_D),
     /*    2980 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    2982 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    2986 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    2988 */     GIR_RootConstrainSelectedInstOperands,
     /*    2989 */     // GIR_Coverage, 74468,
     /*    2989 */     GIR_EraseRootFromParent_Done,
     /*    2990 */   // Label 181: @2990
     /*    2990 */   GIM_Try, /*On fail goto*//*Label 182*/ GIMT_Encode4(3069), // Rule ID 62532 //
     /*    2995 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
     /*    2998 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    3002 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:23:x
     /*    3006 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    3010 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    3014 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*    3018 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*    3022 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    3027 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*    3031 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*    3035 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm2),
     /*    3039 */     // MIs[2] Operand 1
     /*    3039 */     // No operand predicates
     /*    3039 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:23:y
     /*    3043 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    3047 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    3051 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    3053 */     // (add:{ *:[i32] } (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2):$pred:23:x, GPR:{ *:[i32] }:$rs1:$pred:23:y)<<P:23:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2)
     /*    3053 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
     /*    3056 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    3058 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs1
     /*    3060 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*    3064 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
     /*    3067 */     GIR_RootConstrainSelectedInstOperands,
     /*    3068 */     // GIR_Coverage, 62532,
     /*    3068 */     GIR_EraseRootFromParent_Done,
     /*    3069 */   // Label 182: @3069
     /*    3069 */   GIM_Try, /*On fail goto*//*Label 183*/ GIMT_Encode4(3148), // Rule ID 64533 //
     /*    3074 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXqciac_IsRV32_HwMode0),
     /*    3077 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRNoX0RegClassID),
     /*    3081 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:27:x
     /*    3085 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    3089 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    3093 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*    3097 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    3101 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRNoX0RegClassID),
     /*    3106 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*    3110 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*    3114 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm5gt3),
     /*    3118 */     // MIs[2] Operand 1
     /*    3118 */     // No operand predicates
     /*    3118 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:27:y
     /*    3122 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRNoX0RegClassID),
     /*    3126 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    3130 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    3132 */     // (add:{ *:[i32] } (shl:{ *:[i32] } GPRNoX0:{ *:[i32] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimm5gt3>>:$imm):$pred:27:x, GPRNoX0:{ *:[i32] }:$rs2:$pred:27:y)<<P:27:Predicate_add_like_non_imm12>>  =>  (QC_SHLADD:{ *:[i32] } GPRNoX0:{ *:[i32] }:$rs1, GPRNoX0:{ *:[i32] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm5gt3>>:$imm)
     /*    3132 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::QC_SHLADD),
     /*    3135 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    3137 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    3141 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    3143 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*    3146 */     GIR_RootConstrainSelectedInstOperands,
     /*    3147 */     // GIR_Coverage, 64533,
     /*    3147 */     GIR_EraseRootFromParent_Done,
     /*    3148 */   // Label 183: @3148
     /*    3148 */   GIM_Try, /*On fail goto*//*Label 184*/ GIMT_Encode4(3227), // Rule ID 64534 //
     /*    3153 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXqciac_IsRV32_HwMode1),
     /*    3156 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRNoX0RegClassID),
     /*    3160 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:27:x
     /*    3164 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    3168 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    3172 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*    3176 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*    3180 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRNoX0RegClassID),
     /*    3185 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*    3189 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*    3193 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm5gt3),
     /*    3197 */     // MIs[2] Operand 1
     /*    3197 */     // No operand predicates
     /*    3197 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:27:y
     /*    3201 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRNoX0RegClassID),
     /*    3205 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    3209 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    3211 */     // (add:{ *:[i32] } (shl:{ *:[i32] } GPRNoX0:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimm5gt3>>:$imm):$pred:27:x, GPRNoX0:{ *:[i32] }:$rs2:$pred:27:y)<<P:27:Predicate_add_like_non_imm12>>  =>  (QC_SHLADD:{ *:[i32] } GPRNoX0:{ *:[i32] }:$rs1, GPRNoX0:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm5gt3>>:$imm)
     /*    3211 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::QC_SHLADD),
     /*    3214 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    3216 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    3220 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    3222 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*    3225 */     GIR_RootConstrainSelectedInstOperands,
     /*    3226 */     // GIR_Coverage, 64534,
     /*    3226 */     GIR_EraseRootFromParent_Done,
     /*    3227 */   // Label 184: @3227
     /*    3227 */   GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(3306), // Rule ID 74426 //
     /*    3232 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode1),
     /*    3235 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    3239 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:23:y
     /*    3243 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    3247 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:23:x
     /*    3251 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    3255 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    3259 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*    3263 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*    3267 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    3272 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*    3276 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*    3280 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm2),
     /*    3284 */     // MIs[2] Operand 1
     /*    3284 */     // No operand predicates
     /*    3284 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    3288 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    3290 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1:$pred:23:y, (shl:{ *:[i32] } GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2):$pred:23:x)<<P:23:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm2>>:$uimm2)
     /*    3290 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
     /*    3293 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    3295 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*    3297 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*    3301 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
     /*    3304 */     GIR_RootConstrainSelectedInstOperands,
     /*    3305 */     // GIR_Coverage, 74426,
     /*    3305 */     GIR_EraseRootFromParent_Done,
     /*    3306 */   // Label 185: @3306
     /*    3306 */   GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(3385), // Rule ID 74447 //
     /*    3311 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXqciac_IsRV32_HwMode0),
     /*    3314 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRNoX0RegClassID),
     /*    3318 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:27:y
     /*    3322 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRNoX0RegClassID),
     /*    3326 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:27:x
     /*    3330 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    3334 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    3338 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*    3342 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    3346 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRNoX0RegClassID),
     /*    3351 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*    3355 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*    3359 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm5gt3),
     /*    3363 */     // MIs[2] Operand 1
     /*    3363 */     // No operand predicates
     /*    3363 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    3367 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    3369 */     // (add:{ *:[i32] } GPRNoX0:{ *:[i32] }:$rs2:$pred:27:y, (shl:{ *:[i32] } GPRNoX0:{ *:[i32] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_uimm5gt3>>:$imm):$pred:27:x)<<P:27:Predicate_add_like_non_imm12>>  =>  (QC_SHLADD:{ *:[i32] } GPRNoX0:{ *:[i32] }:$rs1, GPRNoX0:{ *:[i32] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm5gt3>>:$imm)
     /*    3369 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::QC_SHLADD),
     /*    3372 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    3374 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    3378 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    3380 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*    3383 */     GIR_RootConstrainSelectedInstOperands,
     /*    3384 */     // GIR_Coverage, 74447,
     /*    3384 */     GIR_EraseRootFromParent_Done,
     /*    3385 */   // Label 186: @3385
     /*    3385 */   GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(3464), // Rule ID 74448 //
     /*    3390 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXqciac_IsRV32_HwMode1),
     /*    3393 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRNoX0RegClassID),
     /*    3397 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:27:y
     /*    3401 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRNoX0RegClassID),
     /*    3405 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:27:x
     /*    3409 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    3413 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    3417 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*    3421 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*    3425 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRNoX0RegClassID),
     /*    3430 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*    3434 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*    3438 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm5gt3),
     /*    3442 */     // MIs[2] Operand 1
     /*    3442 */     // No operand predicates
     /*    3442 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    3446 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    3448 */     // (add:{ *:[i32] } GPRNoX0:{ *:[i32] }:$rs2:$pred:27:y, (shl:{ *:[i32] } GPRNoX0:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_uimm5gt3>>:$imm):$pred:27:x)<<P:27:Predicate_add_like_non_imm12>>  =>  (QC_SHLADD:{ *:[i32] } GPRNoX0:{ *:[i32] }:$rs1, GPRNoX0:{ *:[i32] }:$rs2, (imm:{ *:[i32] })<<P:Predicate_uimm5gt3>>:$imm)
     /*    3448 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::QC_SHLADD),
     /*    3451 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    3453 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    3457 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    3459 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm
     /*    3462 */     GIR_RootConstrainSelectedInstOperands,
     /*    3463 */     // GIR_Coverage, 74448,
     /*    3463 */     GIR_EraseRootFromParent_Done,
     /*    3464 */   // Label 187: @3464
     /*    3464 */   GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(3531), // Rule ID 74444 //
     /*    3469 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXqciac_IsRV32_HwMode1),
     /*    3472 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRNoX0RegClassID),
     /*    3476 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    3480 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*    3484 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*    3488 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*    3492 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRNoX0RegClassID),
     /*    3497 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*    3501 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*    3505 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
     /*    3509 */     // MIs[2] Operand 1
     /*    3509 */     // No operand predicates
     /*    3509 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRNoX0RegClassID),
     /*    3513 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    3515 */     // (add:{ *:[i32] } (mul:{ *:[i32] } GPRNoX0:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm12), GPRNoX0:{ *:[i32] }:$rd)  =>  (QC_MULIADD:{ *:[i32] } GPRNoX0:{ *:[i32] }:$rd, GPRNoX0:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm12)
     /*    3515 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::QC_MULIADD),
     /*    3518 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
     /*    3520 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*    3522 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    3526 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm12
     /*    3529 */     GIR_RootConstrainSelectedInstOperands,
     /*    3530 */     // GIR_Coverage, 74444,
     /*    3530 */     GIR_EraseRootFromParent_Done,
     /*    3531 */   // Label 188: @3531
     /*    3531 */   GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(3580), // Rule ID 121 //
     /*    3536 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
     /*    3539 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    3543 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    3547 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FRAME_INDEX),
     /*    3551 */     // MIs[1] Operand 1
     /*    3551 */     // No operand predicates
     /*    3551 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*    3555 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*    3559 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
     /*    3563 */     // MIs[2] Operand 1
     /*    3563 */     // No operand predicates
     /*    3563 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    3565 */     // (add:{ *:[i32] } (frameindex:{ *:[i32] }):$fi, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$offset)  =>  (ADDI:{ *:[i32] } (to_tframeindex:{ *:[iPTR] } ?:{ *:[i32] }:$fi), (imm:{ *:[i32] })<<P:Predicate_simm12>>:$offset)
     /*    3565 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
     /*    3568 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    3570 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderFrameIndex), // fi
     /*    3575 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // offset
     /*    3578 */     GIR_RootConstrainSelectedInstOperands,
     /*    3579 */     // GIR_Coverage, 121,
     /*    3579 */     GIR_EraseRootFromParent_Done,
     /*    3580 */   // Label 189: @3580
     /*    3580 */   GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(3647), // Rule ID 64530 //
     /*    3585 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXqciac_IsRV32_HwMode1),
     /*    3588 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRNoX0RegClassID),
     /*    3592 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRNoX0RegClassID),
     /*    3596 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    3600 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*    3604 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*    3608 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*    3612 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRNoX0RegClassID),
     /*    3617 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*    3621 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*    3625 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
     /*    3629 */     // MIs[2] Operand 1
     /*    3629 */     // No operand predicates
     /*    3629 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    3631 */     // (add:{ *:[i32] } GPRNoX0:{ *:[i32] }:$rd, (mul:{ *:[i32] } GPRNoX0:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm12))  =>  (QC_MULIADD:{ *:[i32] } GPRNoX0:{ *:[i32] }:$rd, GPRNoX0:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm12)
     /*    3631 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::QC_MULIADD),
     /*    3634 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
     /*    3636 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*    3638 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    3642 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // imm12
     /*    3645 */     GIR_RootConstrainSelectedInstOperands,
     /*    3646 */     // GIR_Coverage, 64530,
     /*    3646 */     GIR_EraseRootFromParent_Done,
     /*    3647 */   // Label 190: @3647
     /*    3647 */   GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(3689), // Rule ID 81 //
     /*    3652 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
     /*    3655 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    3659 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    3663 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    3667 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*    3671 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
     /*    3675 */     // MIs[1] Operand 1
     /*    3675 */     // No operand predicates
     /*    3675 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    3677 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)  =>  (ADDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm12>>:$imm)
     /*    3677 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
     /*    3680 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    3682 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*    3684 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*    3687 */     GIR_RootConstrainSelectedInstOperands,
     /*    3688 */     // GIR_Coverage, 81,
     /*    3688 */     GIR_EraseRootFromParent_Done,
     /*    3689 */   // Label 191: @3689
     /*    3689 */   GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(3761), // Rule ID 296 //
     /*    3694 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
     /*    3697 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    3701 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    3705 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    3709 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*    3713 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_AddiPair),
     /*    3717 */     // MIs[1] Operand 1
     /*    3717 */     // No operand predicates
     /*    3717 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_10074),
     /*    3721 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    3723 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_AddiPair>><<P:Predicate_anonymous_10074>>:$rs2)  =>  (ADDI:{ *:[i32] } (ADDI:{ *:[i32] } GPR:{ *:[i32] }:$rs1, (AddiPairImmLarge:{ *:[i32] } (imm:{ *:[i32] }):$rs2)), (AddiPairImmSmall:{ *:[i32] } (imm:{ *:[i32] }):$rs2))
     /*    3723 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
     /*    3726 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
     /*    3730 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*    3735 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
     /*    3739 */     GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderAddiPairImmLarge), // rs2
     /*    3744 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*    3746 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
     /*    3749 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    3751 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*    3754 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderAddiPairImmSmall), // rs2
     /*    3759 */     GIR_RootConstrainSelectedInstOperands,
     /*    3760 */     // GIR_Coverage, 296,
     /*    3760 */     GIR_EraseRootFromParent_Done,
     /*    3761 */   // Label 192: @3761
     /*    3761 */   GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(3803), // Rule ID 64537 //
     /*    3766 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXqcilia_IsRV32_HwMode1),
     /*    3769 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRNoX0RegClassID),
     /*    3773 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRNoX0RegClassID),
     /*    3777 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    3781 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*    3785 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm32_nosimm26),
     /*    3789 */     // MIs[1] Operand 1
     /*    3789 */     // No operand predicates
     /*    3789 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    3791 */     // (add:{ *:[i32] } GPRNoX0:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm32_nosimm26>>:$imm)  =>  (QC_E_ADDAI:{ *:[i32] } GPRNoX0:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm32_nosimm26>>:$imm)
     /*    3791 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::QC_E_ADDAI),
     /*    3794 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
     /*    3796 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*    3798 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*    3801 */     GIR_RootConstrainSelectedInstOperands,
     /*    3802 */     // GIR_Coverage, 64537,
     /*    3802 */     GIR_EraseRootFromParent_Done,
     /*    3803 */   // Label 193: @3803
     /*    3803 */   GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(3845), // Rule ID 64541 //
     /*    3808 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXqcilia_IsRV32_HwMode1),
     /*    3811 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRNoX0RegClassID),
     /*    3815 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRNoX0RegClassID),
     /*    3819 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    3823 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*    3827 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm26_nosimm12),
     /*    3831 */     // MIs[1] Operand 1
     /*    3831 */     // No operand predicates
     /*    3831 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    3833 */     // (add:{ *:[i32] } GPRNoX0:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm26_nosimm12>>:$imm)  =>  (QC_E_ADDI:{ *:[i32] } GPRNoX0:{ *:[i32] }:$rs1, (imm:{ *:[i32] })<<P:Predicate_simm26_nosimm12>>:$imm)
     /*    3833 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::QC_E_ADDI),
     /*    3836 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    3838 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*    3840 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*    3843 */     GIR_RootConstrainSelectedInstOperands,
     /*    3844 */     // GIR_Coverage, 64541,
     /*    3844 */     GIR_EraseRootFromParent_Done,
     /*    3845 */   // Label 194: @3845
     /*    3845 */   GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(3906), // Rule ID 74440 //
     /*    3850 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode1),
     /*    3853 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    3857 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    3861 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*    3865 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*    3869 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*    3873 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    3878 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    3883 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    3887 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    3889 */     // (add:{ *:[i32] } (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2), GPR:{ *:[i32] }:$rd)  =>  (TH_MULA:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    3889 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULA),
     /*    3892 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
     /*    3894 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*    3896 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    3900 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
     /*    3904 */     GIR_RootConstrainSelectedInstOperands,
     /*    3905 */     // GIR_Coverage, 74440,
     /*    3905 */     GIR_EraseRootFromParent_Done,
     /*    3906 */   // Label 195: @3906
     /*    3906 */   GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(3967), // Rule ID 62599 //
     /*    3911 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode1),
     /*    3914 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    3918 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    3922 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    3926 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*    3930 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
     /*    3934 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
     /*    3938 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    3943 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    3948 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    3950 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$rd, (mul:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2))  =>  (TH_MULA:{ *:[i32] } GPR:{ *:[i32] }:$rd, GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    3950 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULA),
     /*    3953 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
     /*    3955 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*    3957 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    3961 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
     /*    3965 */     GIR_RootConstrainSelectedInstOperands,
     /*    3966 */     // GIR_Coverage, 62599,
     /*    3966 */     GIR_EraseRootFromParent_Done,
     /*    3967 */   // Label 196: @3967
     /*    3967 */   GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(3994), // Rule ID 79 //
     /*    3972 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode1),
     /*    3975 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    3979 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    3983 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    3987 */     // (add:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)  =>  (ADD:{ *:[i32] } GPR:{ *:[i32] }:$rs1, GPR:{ *:[i32] }:$rs2)
     /*    3987 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADD),
     /*    3992 */     GIR_RootConstrainSelectedInstOperands,
     /*    3993 */     // GIR_Coverage, 79,
     /*    3993 */     GIR_Done,
     /*    3994 */   // Label 197: @3994
     /*    3994 */   GIM_Reject,
     /*    3995 */ // Label 151: @3995
     /*    3995 */ GIM_Reject,
     /*    3996 */ // Label 127: @3996
     /*    3996 */ GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(11895),
     /*    4001 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*    4004 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*    4007 */   GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(4102), // Rule ID 2612 //
     /*    4012 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    4015 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4019 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:10:x
     /*    4023 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    4027 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    4031 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    4035 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    4039 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*    4043 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    4047 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*    4051 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*    4055 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4060 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
     /*    4064 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934591),
     /*    4075 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:10:y
     /*    4079 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4083 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    4087 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    4089 */     // (add:{ *:[i64] } (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), 8589934591:{ *:[i64] }):$pred:10:x, GPR:{ *:[i64] }:$rs2:$pred:10:y)<<P:10:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    4089 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
     /*    4092 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    4094 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*    4098 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    4100 */     GIR_RootConstrainSelectedInstOperands,
     /*    4101 */     // GIR_Coverage, 2612,
     /*    4101 */     GIR_EraseRootFromParent_Done,
     /*    4102 */   // Label 199: @4102
     /*    4102 */   GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(4197), // Rule ID 2616 //
     /*    4107 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    4110 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4114 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:12:x
     /*    4118 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    4122 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    4126 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    4130 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    4134 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*    4138 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    4142 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*    4146 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*    4150 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4155 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 2,
     /*    4159 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869183),
     /*    4170 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:12:y
     /*    4174 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4178 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    4182 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    4184 */     // (add:{ *:[i64] } (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), 17179869183:{ *:[i64] }):$pred:12:x, GPR:{ *:[i64] }:$rs2:$pred:12:y)<<P:12:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    4184 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
     /*    4187 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    4189 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*    4193 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    4195 */     GIR_RootConstrainSelectedInstOperands,
     /*    4196 */     // GIR_Coverage, 2616,
     /*    4196 */     GIR_EraseRootFromParent_Done,
     /*    4197 */   // Label 200: @4197
     /*    4197 */   GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(4292), // Rule ID 65167 //
     /*    4202 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    4205 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4209 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:41:x
     /*    4213 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    4217 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    4221 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    4225 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    4229 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*    4233 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    4237 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*    4241 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*    4245 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4250 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
     /*    4254 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934591),
     /*    4265 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:41:y
     /*    4269 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4273 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    4277 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    4279 */     // (add:{ *:[i64] } (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), 8589934591:{ *:[i64] }):$pred:41:x, GPR:{ *:[i64] }:$rs2:$pred:41:y)<<P:41:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_H_ZE:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    4279 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_H_ZE),
     /*    4282 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    4284 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*    4288 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    4290 */     GIR_RootConstrainSelectedInstOperands,
     /*    4291 */     // GIR_Coverage, 65167,
     /*    4291 */     GIR_EraseRootFromParent_Done,
     /*    4292 */   // Label 201: @4292
     /*    4292 */   GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(4387), // Rule ID 65171 //
     /*    4297 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    4300 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4304 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:43:x
     /*    4308 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    4312 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    4316 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    4320 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    4324 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*    4328 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    4332 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*    4336 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*    4340 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4345 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 2,
     /*    4349 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869183),
     /*    4360 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:43:y
     /*    4364 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4368 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    4372 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    4374 */     // (add:{ *:[i64] } (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), 17179869183:{ *:[i64] }):$pred:43:x, GPR:{ *:[i64] }:$rs2:$pred:43:y)<<P:43:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_W_ZE:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    4374 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_W_ZE),
     /*    4377 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    4379 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*    4383 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    4385 */     GIR_RootConstrainSelectedInstOperands,
     /*    4386 */     // GIR_Coverage, 65171,
     /*    4386 */     GIR_EraseRootFromParent_Done,
     /*    4387 */   // Label 202: @4387
     /*    4387 */   GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(4482), // Rule ID 2607 //
     /*    4392 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    4395 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4399 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:8:x
     /*    4403 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    4407 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    4411 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    4415 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    4419 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*    4423 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*    4427 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*    4431 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*    4435 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4440 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
     /*    4451 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*    4455 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:8:y
     /*    4459 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4463 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    4467 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    4469 */     // (add:{ *:[i64] } (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 1:{ *:[i64] }):$pred:8:x, GPR:{ *:[i64] }:$rs2:$pred:8:y)<<P:8:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    4469 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
     /*    4472 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    4474 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*    4478 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    4480 */     GIR_RootConstrainSelectedInstOperands,
     /*    4481 */     // GIR_Coverage, 2607,
     /*    4481 */     GIR_EraseRootFromParent_Done,
     /*    4482 */   // Label 203: @4482
     /*    4482 */   GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(4577), // Rule ID 2626 //
     /*    4487 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    4490 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4494 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:16:x
     /*    4498 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    4502 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    4506 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    4510 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    4514 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*    4518 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*    4522 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*    4526 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*    4530 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4535 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
     /*    4546 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
     /*    4550 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:16:y
     /*    4554 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4558 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    4562 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    4564 */     // (add:{ *:[i64] } (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 2:{ *:[i64] }):$pred:16:x, GPR:{ *:[i64] }:$rs2:$pred:16:y)<<P:16:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    4564 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
     /*    4567 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    4569 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*    4573 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    4575 */     GIR_RootConstrainSelectedInstOperands,
     /*    4576 */     // GIR_Coverage, 2626,
     /*    4576 */     GIR_EraseRootFromParent_Done,
     /*    4577 */   // Label 204: @4577
     /*    4577 */   GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(4672), // Rule ID 2631 //
     /*    4582 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    4585 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4589 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:18:x
     /*    4593 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    4597 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    4601 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    4605 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    4609 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*    4613 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*    4617 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*    4621 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*    4625 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4630 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
     /*    4641 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
     /*    4645 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:18:y
     /*    4649 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4653 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    4657 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    4659 */     // (add:{ *:[i64] } (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 3:{ *:[i64] }):$pred:18:x, GPR:{ *:[i64] }:$rs2:$pred:18:y)<<P:18:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    4659 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
     /*    4662 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    4664 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*    4668 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    4670 */     GIR_RootConstrainSelectedInstOperands,
     /*    4671 */     // GIR_Coverage, 2631,
     /*    4671 */     GIR_EraseRootFromParent_Done,
     /*    4672 */   // Label 205: @4672
     /*    4672 */   GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(4767), // Rule ID 65152 //
     /*    4677 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    4680 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4684 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:35:x
     /*    4688 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    4692 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    4696 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    4700 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    4704 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*    4708 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*    4712 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*    4716 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*    4720 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4725 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
     /*    4736 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*    4740 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:35:y
     /*    4744 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4748 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    4752 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    4754 */     // (add:{ *:[i64] } (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 1:{ *:[i64] }):$pred:35:x, GPR:{ *:[i64] }:$rs2:$pred:35:y)<<P:35:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_H_ZE:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    4754 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_H_ZE),
     /*    4757 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    4759 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*    4763 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    4765 */     GIR_RootConstrainSelectedInstOperands,
     /*    4766 */     // GIR_Coverage, 65152,
     /*    4766 */     GIR_EraseRootFromParent_Done,
     /*    4767 */   // Label 206: @4767
     /*    4767 */   GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(4862), // Rule ID 65157 //
     /*    4772 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    4775 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4779 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:37:x
     /*    4783 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    4787 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    4791 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    4795 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    4799 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*    4803 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*    4807 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*    4811 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*    4815 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4820 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
     /*    4831 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
     /*    4835 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:37:y
     /*    4839 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4843 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    4847 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    4849 */     // (add:{ *:[i64] } (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 2:{ *:[i64] }):$pred:37:x, GPR:{ *:[i64] }:$rs2:$pred:37:y)<<P:37:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_W_ZE:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    4849 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_W_ZE),
     /*    4852 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    4854 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*    4858 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    4860 */     GIR_RootConstrainSelectedInstOperands,
     /*    4861 */     // GIR_Coverage, 65157,
     /*    4861 */     GIR_EraseRootFromParent_Done,
     /*    4862 */   // Label 207: @4862
     /*    4862 */   GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(4957), // Rule ID 65162 //
     /*    4867 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    4870 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4874 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:39:x
     /*    4878 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    4882 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    4886 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    4890 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    4894 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*    4898 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*    4902 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*    4906 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*    4910 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4915 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
     /*    4926 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
     /*    4930 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:39:y
     /*    4934 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4938 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    4942 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    4944 */     // (add:{ *:[i64] } (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 3:{ *:[i64] }):$pred:39:x, GPR:{ *:[i64] }:$rs2:$pred:39:y)<<P:39:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_D_ZE:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    4944 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_D_ZE),
     /*    4947 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    4949 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*    4953 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    4955 */     GIR_RootConstrainSelectedInstOperands,
     /*    4956 */     // GIR_Coverage, 65162,
     /*    4956 */     GIR_EraseRootFromParent_Done,
     /*    4957 */   // Label 208: @4957
     /*    4957 */   GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(5052), // Rule ID 65622 //
     /*    4962 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    4965 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4969 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:10:y
     /*    4973 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    4977 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:10:x
     /*    4981 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    4985 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    4989 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    4993 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    4997 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*    5001 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    5005 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*    5009 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*    5013 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5018 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
     /*    5022 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934591),
     /*    5033 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    5037 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    5039 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:10:y, (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), 8589934591:{ *:[i64] }):$pred:10:x)<<P:10:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    5039 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
     /*    5042 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    5044 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*    5048 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    5050 */     GIR_RootConstrainSelectedInstOperands,
     /*    5051 */     // GIR_Coverage, 65622,
     /*    5051 */     GIR_EraseRootFromParent_Done,
     /*    5052 */   // Label 209: @5052
     /*    5052 */   GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(5147), // Rule ID 65626 //
     /*    5057 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    5060 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5064 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:12:y
     /*    5068 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5072 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:12:x
     /*    5076 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    5080 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    5084 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    5088 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    5092 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*    5096 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    5100 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*    5104 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*    5108 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5113 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 2,
     /*    5117 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869183),
     /*    5128 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    5132 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    5134 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:12:y, (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), 17179869183:{ *:[i64] }):$pred:12:x)<<P:12:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    5134 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
     /*    5137 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    5139 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*    5143 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    5145 */     GIR_RootConstrainSelectedInstOperands,
     /*    5146 */     // GIR_Coverage, 65626,
     /*    5146 */     GIR_EraseRootFromParent_Done,
     /*    5147 */   // Label 210: @5147
     /*    5147 */   GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(5242), // Rule ID 74490 //
     /*    5152 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    5155 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5159 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:41:y
     /*    5163 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5167 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:41:x
     /*    5171 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    5175 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    5179 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    5183 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    5187 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*    5191 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    5195 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*    5199 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*    5203 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5208 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
     /*    5212 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934591),
     /*    5223 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    5227 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    5229 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:41:y, (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), 8589934591:{ *:[i64] }):$pred:41:x)<<P:41:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_H_ZE:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    5229 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_H_ZE),
     /*    5232 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    5234 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*    5238 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    5240 */     GIR_RootConstrainSelectedInstOperands,
     /*    5241 */     // GIR_Coverage, 74490,
     /*    5241 */     GIR_EraseRootFromParent_Done,
     /*    5242 */   // Label 211: @5242
     /*    5242 */   GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(5337), // Rule ID 74494 //
     /*    5247 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    5250 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5254 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:43:y
     /*    5258 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5262 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:43:x
     /*    5266 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    5270 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    5274 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    5278 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    5282 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*    5286 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    5290 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*    5294 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*    5298 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5303 */     GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 2,
     /*    5307 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869183),
     /*    5318 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    5322 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    5324 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:43:y, (and:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), 17179869183:{ *:[i64] }):$pred:43:x)<<P:43:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_W_ZE:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    5324 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_W_ZE),
     /*    5327 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    5329 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*    5333 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    5335 */     GIR_RootConstrainSelectedInstOperands,
     /*    5336 */     // GIR_Coverage, 74494,
     /*    5336 */     GIR_EraseRootFromParent_Done,
     /*    5337 */   // Label 212: @5337
     /*    5337 */   GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(5432), // Rule ID 65618 //
     /*    5342 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    5345 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5349 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:8:y
     /*    5353 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5357 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:8:x
     /*    5361 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    5365 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    5369 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    5373 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    5377 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*    5381 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*    5385 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*    5389 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*    5393 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5398 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
     /*    5409 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*    5413 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    5417 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    5419 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:8:y, (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 1:{ *:[i64] }):$pred:8:x)<<P:8:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    5419 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
     /*    5422 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    5424 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*    5428 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    5430 */     GIR_RootConstrainSelectedInstOperands,
     /*    5431 */     // GIR_Coverage, 65618,
     /*    5431 */     GIR_EraseRootFromParent_Done,
     /*    5432 */   // Label 213: @5432
     /*    5432 */   GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(5527), // Rule ID 65634 //
     /*    5437 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    5440 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5444 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:16:y
     /*    5448 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5452 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:16:x
     /*    5456 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    5460 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    5464 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    5468 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    5472 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*    5476 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*    5480 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*    5484 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*    5488 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5493 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
     /*    5504 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
     /*    5508 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    5512 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    5514 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:16:y, (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 2:{ *:[i64] }):$pred:16:x)<<P:16:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    5514 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
     /*    5517 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    5519 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*    5523 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    5525 */     GIR_RootConstrainSelectedInstOperands,
     /*    5526 */     // GIR_Coverage, 65634,
     /*    5526 */     GIR_EraseRootFromParent_Done,
     /*    5527 */   // Label 214: @5527
     /*    5527 */   GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(5622), // Rule ID 65638 //
     /*    5532 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    5535 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5539 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:18:y
     /*    5543 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5547 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:18:x
     /*    5551 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    5555 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    5559 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    5563 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    5567 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*    5571 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*    5575 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*    5579 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*    5583 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5588 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
     /*    5599 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
     /*    5603 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    5607 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    5609 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:18:y, (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 3:{ *:[i64] }):$pred:18:x)<<P:18:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    5609 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
     /*    5612 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    5614 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*    5618 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    5620 */     GIR_RootConstrainSelectedInstOperands,
     /*    5621 */     // GIR_Coverage, 65638,
     /*    5621 */     GIR_EraseRootFromParent_Done,
     /*    5622 */   // Label 215: @5622
     /*    5622 */   GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(5717), // Rule ID 74478 //
     /*    5627 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    5630 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5634 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:35:y
     /*    5638 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5642 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:35:x
     /*    5646 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    5650 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    5654 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    5658 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    5662 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*    5666 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*    5670 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*    5674 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*    5678 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5683 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
     /*    5694 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*    5698 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    5702 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    5704 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:35:y, (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 1:{ *:[i64] }):$pred:35:x)<<P:35:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_H_ZE:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    5704 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_H_ZE),
     /*    5707 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    5709 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*    5713 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    5715 */     GIR_RootConstrainSelectedInstOperands,
     /*    5716 */     // GIR_Coverage, 74478,
     /*    5716 */     GIR_EraseRootFromParent_Done,
     /*    5717 */   // Label 216: @5717
     /*    5717 */   GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(5812), // Rule ID 74482 //
     /*    5722 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    5725 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5729 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:37:y
     /*    5733 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5737 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:37:x
     /*    5741 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    5745 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    5749 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    5753 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    5757 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*    5761 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*    5765 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*    5769 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*    5773 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5778 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
     /*    5789 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
     /*    5793 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    5797 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    5799 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:37:y, (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 2:{ *:[i64] }):$pred:37:x)<<P:37:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_W_ZE:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    5799 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_W_ZE),
     /*    5802 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    5804 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*    5808 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    5810 */     GIR_RootConstrainSelectedInstOperands,
     /*    5811 */     // GIR_Coverage, 74482,
     /*    5811 */     GIR_EraseRootFromParent_Done,
     /*    5812 */   // Label 217: @5812
     /*    5812 */   GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(5907), // Rule ID 74486 //
     /*    5817 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    5820 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5824 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:39:y
     /*    5828 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5832 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:39:x
     /*    5836 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    5840 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    5844 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    5848 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    5852 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*    5856 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_AND),
     /*    5860 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
     /*    5864 */     GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
     /*    5868 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5873 */     GIM_CheckConstantInt, /*MI*/2, /*Op*/2, GIMT_Encode8(4294967295),
     /*    5884 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
     /*    5888 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    5892 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*    5894 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:39:y, (shl:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }), 3:{ *:[i64] }):$pred:39:x)<<P:39:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_D_ZE:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    5894 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_D_ZE),
     /*    5897 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    5899 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*    5903 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    5905 */     GIR_RootConstrainSelectedInstOperands,
     /*    5906 */     // GIR_Coverage, 74486,
     /*    5906 */     GIR_EraseRootFromParent_Done,
     /*    5907 */   // Label 218: @5907
     /*    5907 */   GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(5955), // Rule ID 2571 //
     /*    5912 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
     /*    5915 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5919 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:2:x
     /*    5923 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:2:y
     /*    5927 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5931 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    5935 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
     /*    5942 */     // (add:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs1:$pred:2:x, GPR:{ *:[i64] }:$rs2:$pred:2:y)<<P:2:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    5942 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
     /*    5945 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    5947 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    5951 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    5953 */     GIR_RootConstrainSelectedInstOperands,
     /*    5954 */     // GIR_Coverage, 2571,
     /*    5954 */     GIR_EraseRootFromParent_Done,
     /*    5955 */   // Label 219: @5955
     /*    5955 */   GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(6003), // Rule ID 2581 //
     /*    5960 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
     /*    5963 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5967 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:4:x
     /*    5971 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:4:y
     /*    5975 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    5979 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    5983 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
     /*    5990 */     // (add:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs1:$pred:4:x, GPR:{ *:[i64] }:$rs2:$pred:4:y)<<P:4:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    5990 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
     /*    5993 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    5995 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    5999 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    6001 */     GIR_RootConstrainSelectedInstOperands,
     /*    6002 */     // GIR_Coverage, 2581,
     /*    6002 */     GIR_EraseRootFromParent_Done,
     /*    6003 */   // Label 220: @6003
     /*    6003 */   GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(6051), // Rule ID 2591 //
     /*    6008 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
     /*    6011 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6015 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:6:x
     /*    6019 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:6:y
     /*    6023 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6027 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    6031 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
     /*    6038 */     // (add:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs1:$pred:6:x, GPR:{ *:[i64] }:$rs2:$pred:6:y)<<P:6:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    6038 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
     /*    6041 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    6043 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    6047 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    6049 */     GIR_RootConstrainSelectedInstOperands,
     /*    6050 */     // GIR_Coverage, 2591,
     /*    6050 */     GIR_EraseRootFromParent_Done,
     /*    6051 */   // Label 221: @6051
     /*    6051 */   GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(6099), // Rule ID 2610 //
     /*    6056 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    6059 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6063 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:9:x
     /*    6067 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:9:y
     /*    6071 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6075 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    6079 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_uw_op),
     /*    6086 */     // (add:{ *:[i64] } sh1add_uw_op:{ *:[i64] }:$rs1:$pred:9:x, GPR:{ *:[i64] }:$rs2:$pred:9:y)<<P:9:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } sh1add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    6086 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
     /*    6089 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    6091 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    6095 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    6097 */     GIR_RootConstrainSelectedInstOperands,
     /*    6098 */     // GIR_Coverage, 2610,
     /*    6098 */     GIR_EraseRootFromParent_Done,
     /*    6099 */   // Label 222: @6099
     /*    6099 */   GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(6147), // Rule ID 2629 //
     /*    6104 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    6107 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6111 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:17:x
     /*    6115 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:17:y
     /*    6119 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6123 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    6127 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_uw_op),
     /*    6134 */     // (add:{ *:[i64] } sh2add_uw_op:{ *:[i64] }:$rs1:$pred:17:x, GPR:{ *:[i64] }:$rs2:$pred:17:y)<<P:17:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } sh2add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    6134 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
     /*    6137 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    6139 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    6143 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    6145 */     GIR_RootConstrainSelectedInstOperands,
     /*    6146 */     // GIR_Coverage, 2629,
     /*    6146 */     GIR_EraseRootFromParent_Done,
     /*    6147 */   // Label 223: @6147
     /*    6147 */   GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(6195), // Rule ID 2634 //
     /*    6152 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    6155 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6159 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:19:x
     /*    6163 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:19:y
     /*    6167 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6171 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    6175 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_uw_op),
     /*    6182 */     // (add:{ *:[i64] } sh3add_uw_op:{ *:[i64] }:$rs1:$pred:19:x, GPR:{ *:[i64] }:$rs2:$pred:19:y)<<P:19:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } sh3add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    6182 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
     /*    6185 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    6187 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    6191 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    6193 */     GIR_RootConstrainSelectedInstOperands,
     /*    6194 */     // GIR_Coverage, 2634,
     /*    6194 */     GIR_EraseRootFromParent_Done,
     /*    6195 */   // Label 224: @6195
     /*    6195 */   GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(6246), // Rule ID 62537 //
     /*    6200 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
     /*    6203 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6207 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:24:x
     /*    6211 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:24:y
     /*    6215 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6219 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    6223 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
     /*    6230 */     // (add:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs2:$pred:24:x, GPR:{ *:[i64] }:$rs1:$pred:24:y)<<P:24:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, sh1add_op:{ *:[i64] }:$rs2, 1:{ *:[i64] })
     /*    6230 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
     /*    6233 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    6235 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs1
     /*    6237 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
     /*    6241 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*    6244 */     GIR_RootConstrainSelectedInstOperands,
     /*    6245 */     // GIR_Coverage, 62537,
     /*    6245 */     GIR_EraseRootFromParent_Done,
     /*    6246 */   // Label 225: @6246
     /*    6246 */   GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(6297), // Rule ID 62541 //
     /*    6251 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
     /*    6254 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6258 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:25:x
     /*    6262 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:25:y
     /*    6266 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6270 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    6274 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
     /*    6281 */     // (add:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs2:$pred:25:x, GPR:{ *:[i64] }:$rs1:$pred:25:y)<<P:25:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, sh2add_op:{ *:[i64] }:$rs2, 2:{ *:[i64] })
     /*    6281 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
     /*    6284 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    6286 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs1
     /*    6288 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
     /*    6292 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/2,
     /*    6295 */     GIR_RootConstrainSelectedInstOperands,
     /*    6296 */     // GIR_Coverage, 62541,
     /*    6296 */     GIR_EraseRootFromParent_Done,
     /*    6297 */   // Label 226: @6297
     /*    6297 */   GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(6348), // Rule ID 62545 //
     /*    6302 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
     /*    6305 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6309 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:26:x
     /*    6313 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:26:y
     /*    6317 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6321 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    6325 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
     /*    6332 */     // (add:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs2:$pred:26:x, GPR:{ *:[i64] }:$rs1:$pred:26:y)<<P:26:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, sh3add_op:{ *:[i64] }:$rs2, 3:{ *:[i64] })
     /*    6332 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
     /*    6335 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    6337 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs1
     /*    6339 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
     /*    6343 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*    6346 */     GIR_RootConstrainSelectedInstOperands,
     /*    6347 */     // GIR_Coverage, 62545,
     /*    6347 */     GIR_EraseRootFromParent_Done,
     /*    6348 */   // Label 227: @6348
     /*    6348 */   GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(6396), // Rule ID 65116 //
     /*    6353 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode0),
     /*    6356 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6360 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:29:x
     /*    6364 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:29:y
     /*    6368 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6372 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    6376 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
     /*    6383 */     // (add:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs1:$pred:29:x, GPR:{ *:[i64] }:$rs2:$pred:29:y)<<P:29:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_H:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    6383 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_H),
     /*    6386 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    6388 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    6392 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    6394 */     GIR_RootConstrainSelectedInstOperands,
     /*    6395 */     // GIR_Coverage, 65116,
     /*    6395 */     GIR_EraseRootFromParent_Done,
     /*    6396 */   // Label 228: @6396
     /*    6396 */   GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(6444), // Rule ID 65126 //
     /*    6401 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode0),
     /*    6404 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6408 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:31:x
     /*    6412 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:31:y
     /*    6416 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6420 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    6424 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
     /*    6431 */     // (add:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs1:$pred:31:x, GPR:{ *:[i64] }:$rs2:$pred:31:y)<<P:31:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_W:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    6431 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_W),
     /*    6434 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    6436 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    6440 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    6442 */     GIR_RootConstrainSelectedInstOperands,
     /*    6443 */     // GIR_Coverage, 65126,
     /*    6443 */     GIR_EraseRootFromParent_Done,
     /*    6444 */   // Label 229: @6444
     /*    6444 */   GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(6492), // Rule ID 65136 //
     /*    6449 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode0),
     /*    6452 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6456 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:33:x
     /*    6460 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:33:y
     /*    6464 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6468 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    6472 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
     /*    6479 */     // (add:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs1:$pred:33:x, GPR:{ *:[i64] }:$rs2:$pred:33:y)<<P:33:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_D:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    6479 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_D),
     /*    6482 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    6484 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    6488 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    6490 */     GIR_RootConstrainSelectedInstOperands,
     /*    6491 */     // GIR_Coverage, 65136,
     /*    6491 */     GIR_EraseRootFromParent_Done,
     /*    6492 */   // Label 230: @6492
     /*    6492 */   GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(6540), // Rule ID 65155 //
     /*    6497 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    6500 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6504 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:36:x
     /*    6508 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:36:y
     /*    6512 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6516 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    6520 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_uw_op),
     /*    6527 */     // (add:{ *:[i64] } sh1add_uw_op:{ *:[i64] }:$rs1:$pred:36:x, GPR:{ *:[i64] }:$rs2:$pred:36:y)<<P:36:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_H_ZE:{ *:[i64] } sh1add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    6527 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_H_ZE),
     /*    6530 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    6532 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    6536 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    6538 */     GIR_RootConstrainSelectedInstOperands,
     /*    6539 */     // GIR_Coverage, 65155,
     /*    6539 */     GIR_EraseRootFromParent_Done,
     /*    6540 */   // Label 231: @6540
     /*    6540 */   GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(6588), // Rule ID 65160 //
     /*    6545 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    6548 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6552 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:38:x
     /*    6556 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:38:y
     /*    6560 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6564 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    6568 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_uw_op),
     /*    6575 */     // (add:{ *:[i64] } sh2add_uw_op:{ *:[i64] }:$rs1:$pred:38:x, GPR:{ *:[i64] }:$rs2:$pred:38:y)<<P:38:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_W_ZE:{ *:[i64] } sh2add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    6575 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_W_ZE),
     /*    6578 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    6580 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    6584 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    6586 */     GIR_RootConstrainSelectedInstOperands,
     /*    6587 */     // GIR_Coverage, 65160,
     /*    6587 */     GIR_EraseRootFromParent_Done,
     /*    6588 */   // Label 232: @6588
     /*    6588 */   GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(6636), // Rule ID 65165 //
     /*    6593 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    6596 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6600 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:40:x
     /*    6604 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:40:y
     /*    6608 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6612 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    6616 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/1, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_uw_op),
     /*    6623 */     // (add:{ *:[i64] } sh3add_uw_op:{ *:[i64] }:$rs1:$pred:40:x, GPR:{ *:[i64] }:$rs2:$pred:40:y)<<P:40:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_D_ZE:{ *:[i64] } sh3add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    6623 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_D_ZE),
     /*    6626 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    6628 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    6632 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    6634 */     GIR_RootConstrainSelectedInstOperands,
     /*    6635 */     // GIR_Coverage, 65165,
     /*    6635 */     GIR_EraseRootFromParent_Done,
     /*    6636 */   // Label 233: @6636
     /*    6636 */   GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(6684), // Rule ID 65595 //
     /*    6641 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
     /*    6644 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6648 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:2:y
     /*    6652 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6656 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:2:x
     /*    6660 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    6664 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
     /*    6671 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:2:y, sh1add_op:{ *:[i64] }:$rs1:$pred:2:x)<<P:2:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    6671 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
     /*    6674 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    6676 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    6680 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    6682 */     GIR_RootConstrainSelectedInstOperands,
     /*    6683 */     // GIR_Coverage, 65595,
     /*    6683 */     GIR_EraseRootFromParent_Done,
     /*    6684 */   // Label 234: @6684
     /*    6684 */   GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(6732), // Rule ID 65603 //
     /*    6689 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
     /*    6692 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6696 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:4:y
     /*    6700 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6704 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:4:x
     /*    6708 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    6712 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
     /*    6719 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:4:y, sh2add_op:{ *:[i64] }:$rs1:$pred:4:x)<<P:4:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    6719 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
     /*    6722 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    6724 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    6728 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    6730 */     GIR_RootConstrainSelectedInstOperands,
     /*    6731 */     // GIR_Coverage, 65603,
     /*    6731 */     GIR_EraseRootFromParent_Done,
     /*    6732 */   // Label 235: @6732
     /*    6732 */   GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(6780), // Rule ID 65611 //
     /*    6737 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
     /*    6740 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6744 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:6:y
     /*    6748 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6752 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:6:x
     /*    6756 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    6760 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
     /*    6767 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:6:y, sh3add_op:{ *:[i64] }:$rs1:$pred:6:x)<<P:6:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    6767 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
     /*    6770 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    6772 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    6776 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    6778 */     GIR_RootConstrainSelectedInstOperands,
     /*    6779 */     // GIR_Coverage, 65611,
     /*    6779 */     GIR_EraseRootFromParent_Done,
     /*    6780 */   // Label 236: @6780
     /*    6780 */   GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(6828), // Rule ID 65620 //
     /*    6785 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    6788 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6792 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:9:y
     /*    6796 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6800 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:9:x
     /*    6804 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    6808 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_uw_op),
     /*    6815 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:9:y, sh1add_uw_op:{ *:[i64] }:$rs1:$pred:9:x)<<P:9:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } sh1add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    6815 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
     /*    6818 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    6820 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    6824 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    6826 */     GIR_RootConstrainSelectedInstOperands,
     /*    6827 */     // GIR_Coverage, 65620,
     /*    6827 */     GIR_EraseRootFromParent_Done,
     /*    6828 */   // Label 237: @6828
     /*    6828 */   GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(6876), // Rule ID 65636 //
     /*    6833 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    6836 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6840 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:17:y
     /*    6844 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6848 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:17:x
     /*    6852 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    6856 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_uw_op),
     /*    6863 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:17:y, sh2add_uw_op:{ *:[i64] }:$rs1:$pred:17:x)<<P:17:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } sh2add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    6863 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
     /*    6866 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    6868 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    6872 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    6874 */     GIR_RootConstrainSelectedInstOperands,
     /*    6875 */     // GIR_Coverage, 65636,
     /*    6875 */     GIR_EraseRootFromParent_Done,
     /*    6876 */   // Label 238: @6876
     /*    6876 */   GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(6924), // Rule ID 65640 //
     /*    6881 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    6884 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6888 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:19:y
     /*    6892 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6896 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:19:x
     /*    6900 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    6904 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_uw_op),
     /*    6911 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:19:y, sh3add_uw_op:{ *:[i64] }:$rs1:$pred:19:x)<<P:19:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } sh3add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    6911 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
     /*    6914 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    6916 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    6920 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    6922 */     GIR_RootConstrainSelectedInstOperands,
     /*    6923 */     // GIR_Coverage, 65640,
     /*    6923 */     GIR_EraseRootFromParent_Done,
     /*    6924 */   // Label 239: @6924
     /*    6924 */   GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(6975), // Rule ID 74429 //
     /*    6929 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
     /*    6932 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6936 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:24:y
     /*    6940 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6944 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:24:x
     /*    6948 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    6952 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
     /*    6959 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1:$pred:24:y, sh1add_op:{ *:[i64] }:$rs2:$pred:24:x)<<P:24:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, sh1add_op:{ *:[i64] }:$rs2, 1:{ *:[i64] })
     /*    6959 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
     /*    6962 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    6964 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*    6966 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
     /*    6970 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*    6973 */     GIR_RootConstrainSelectedInstOperands,
     /*    6974 */     // GIR_Coverage, 74429,
     /*    6974 */     GIR_EraseRootFromParent_Done,
     /*    6975 */   // Label 240: @6975
     /*    6975 */   GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(7026), // Rule ID 74433 //
     /*    6980 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
     /*    6983 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6987 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:25:y
     /*    6991 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    6995 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:25:x
     /*    6999 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    7003 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
     /*    7010 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1:$pred:25:y, sh2add_op:{ *:[i64] }:$rs2:$pred:25:x)<<P:25:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, sh2add_op:{ *:[i64] }:$rs2, 2:{ *:[i64] })
     /*    7010 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
     /*    7013 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    7015 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*    7017 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
     /*    7021 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/2,
     /*    7024 */     GIR_RootConstrainSelectedInstOperands,
     /*    7025 */     // GIR_Coverage, 74433,
     /*    7025 */     GIR_EraseRootFromParent_Done,
     /*    7026 */   // Label 241: @7026
     /*    7026 */   GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(7077), // Rule ID 74437 //
     /*    7031 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
     /*    7034 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7038 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:26:y
     /*    7042 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7046 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:26:x
     /*    7050 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    7054 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
     /*    7061 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1:$pred:26:y, sh3add_op:{ *:[i64] }:$rs2:$pred:26:x)<<P:26:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, sh3add_op:{ *:[i64] }:$rs2, 3:{ *:[i64] })
     /*    7061 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
     /*    7064 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    7066 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*    7068 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs2
     /*    7072 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*    7075 */     GIR_RootConstrainSelectedInstOperands,
     /*    7076 */     // GIR_Coverage, 74437,
     /*    7076 */     GIR_EraseRootFromParent_Done,
     /*    7077 */   // Label 242: @7077
     /*    7077 */   GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(7125), // Rule ID 74455 //
     /*    7082 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode0),
     /*    7085 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7089 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:29:y
     /*    7093 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7097 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:29:x
     /*    7101 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    7105 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_op),
     /*    7112 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:29:y, sh1add_op:{ *:[i64] }:$rs1:$pred:29:x)<<P:29:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_H:{ *:[i64] } sh1add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    7112 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_H),
     /*    7115 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    7117 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    7121 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    7123 */     GIR_RootConstrainSelectedInstOperands,
     /*    7124 */     // GIR_Coverage, 74455,
     /*    7124 */     GIR_EraseRootFromParent_Done,
     /*    7125 */   // Label 243: @7125
     /*    7125 */   GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(7173), // Rule ID 74463 //
     /*    7130 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode0),
     /*    7133 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7137 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:31:y
     /*    7141 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7145 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:31:x
     /*    7149 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    7153 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_op),
     /*    7160 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:31:y, sh2add_op:{ *:[i64] }:$rs1:$pred:31:x)<<P:31:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_W:{ *:[i64] } sh2add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    7160 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_W),
     /*    7163 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    7165 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    7169 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    7171 */     GIR_RootConstrainSelectedInstOperands,
     /*    7172 */     // GIR_Coverage, 74463,
     /*    7172 */     GIR_EraseRootFromParent_Done,
     /*    7173 */   // Label 244: @7173
     /*    7173 */   GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(7221), // Rule ID 74471 //
     /*    7178 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode0),
     /*    7181 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7185 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:33:y
     /*    7189 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7193 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:33:x
     /*    7197 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    7201 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_op),
     /*    7208 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:33:y, sh3add_op:{ *:[i64] }:$rs1:$pred:33:x)<<P:33:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_D:{ *:[i64] } sh3add_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    7208 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_D),
     /*    7211 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    7213 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    7217 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    7219 */     GIR_RootConstrainSelectedInstOperands,
     /*    7220 */     // GIR_Coverage, 74471,
     /*    7220 */     GIR_EraseRootFromParent_Done,
     /*    7221 */   // Label 245: @7221
     /*    7221 */   GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(7269), // Rule ID 74480 //
     /*    7226 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    7229 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7233 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:36:y
     /*    7237 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7241 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:36:x
     /*    7245 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    7249 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh1add_uw_op),
     /*    7256 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:36:y, sh1add_uw_op:{ *:[i64] }:$rs1:$pred:36:x)<<P:36:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_H_ZE:{ *:[i64] } sh1add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    7256 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_H_ZE),
     /*    7259 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    7261 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    7265 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    7267 */     GIR_RootConstrainSelectedInstOperands,
     /*    7268 */     // GIR_Coverage, 74480,
     /*    7268 */     GIR_EraseRootFromParent_Done,
     /*    7269 */   // Label 246: @7269
     /*    7269 */   GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(7317), // Rule ID 74484 //
     /*    7274 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    7277 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7281 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:38:y
     /*    7285 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7289 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:38:x
     /*    7293 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    7297 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh2add_uw_op),
     /*    7304 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:38:y, sh2add_uw_op:{ *:[i64] }:$rs1:$pred:38:x)<<P:38:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_W_ZE:{ *:[i64] } sh2add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    7304 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_W_ZE),
     /*    7307 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    7309 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    7313 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    7315 */     GIR_RootConstrainSelectedInstOperands,
     /*    7316 */     // GIR_Coverage, 74484,
     /*    7316 */     GIR_EraseRootFromParent_Done,
     /*    7317 */   // Label 247: @7317
     /*    7317 */   GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(7365), // Rule ID 74488 //
     /*    7322 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    7325 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7329 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:40:y
     /*    7333 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7337 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:40:x
     /*    7341 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    7345 */     GIM_CheckComplexPattern, /*MI*/0, /*Op*/2, /*Renderer*/GIMT_Encode2(0), GIMT_Encode2(GICP_gi_sh3add_uw_op),
     /*    7352 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:40:y, sh3add_uw_op:{ *:[i64] }:$rs1:$pred:40:x)<<P:40:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_D_ZE:{ *:[i64] } sh3add_uw_op:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    7352 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_D_ZE),
     /*    7355 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    7357 */     GIR_ComplexRenderer, /*InsnID*/0, /*RendererID*/GIMT_Encode2(0), // rs1
     /*    7361 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    7363 */     GIR_RootConstrainSelectedInstOperands,
     /*    7364 */     // GIR_Coverage, 74488,
     /*    7364 */     GIR_EraseRootFromParent_Done,
     /*    7365 */   // Label 248: @7365
     /*    7365 */   GIM_Try, /*On fail goto*//*Label 249*/ GIMT_Encode4(7440), // Rule ID 2602 //
     /*    7370 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    7373 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7377 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:7:x
     /*    7381 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    7385 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    7389 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    7393 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    7397 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7402 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967295),
     /*    7413 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:7:y
     /*    7417 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7421 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    7425 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    7427 */     // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }):$pred:7:x, GPR:{ *:[i64] }:$rs2:$pred:7:y)<<P:7:Predicate_add_like_non_imm12>>  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    7427 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADD_UW),
     /*    7430 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    7432 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    7436 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    7438 */     GIR_RootConstrainSelectedInstOperands,
     /*    7439 */     // GIR_Coverage, 2602,
     /*    7439 */     GIR_EraseRootFromParent_Done,
     /*    7440 */   // Label 249: @7440
     /*    7440 */   GIM_Try, /*On fail goto*//*Label 250*/ GIMT_Encode4(7535), // Rule ID 2614 //
     /*    7445 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    7448 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7452 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:11:x
     /*    7456 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    7460 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    7464 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    7468 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    7472 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7477 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934590),
     /*    7488 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:11:y
     /*    7492 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7496 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    7500 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    7502 */     // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 8589934590:{ *:[i64] }):$pred:11:x, GPR:{ *:[i64] }:$rs2:$pred:11:y)<<P:11:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*    7502 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*    7505 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
     /*    7509 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*    7514 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    7518 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*    7521 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*    7523 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
     /*    7526 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    7528 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*    7531 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    7533 */     GIR_RootConstrainSelectedInstOperands,
     /*    7534 */     // GIR_Coverage, 2614,
     /*    7534 */     GIR_EraseRootFromParent_Done,
     /*    7535 */   // Label 250: @7535
     /*    7535 */   GIM_Try, /*On fail goto*//*Label 251*/ GIMT_Encode4(7630), // Rule ID 2618 //
     /*    7540 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    7543 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7547 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:13:x
     /*    7551 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    7555 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    7559 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    7563 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    7567 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7572 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869180),
     /*    7583 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:13:y
     /*    7587 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7591 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    7595 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    7597 */     // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 17179869180:{ *:[i64] }):$pred:13:x, GPR:{ *:[i64] }:$rs2:$pred:13:y)<<P:13:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*    7597 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*    7600 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
     /*    7604 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*    7609 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    7613 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
     /*    7616 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*    7618 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
     /*    7621 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    7623 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*    7626 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    7628 */     GIR_RootConstrainSelectedInstOperands,
     /*    7629 */     // GIR_Coverage, 2618,
     /*    7629 */     GIR_EraseRootFromParent_Done,
     /*    7630 */   // Label 251: @7630
     /*    7630 */   GIM_Try, /*On fail goto*//*Label 252*/ GIMT_Encode4(7725), // Rule ID 2620 //
     /*    7635 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    7638 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7642 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:14:x
     /*    7646 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    7650 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    7654 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    7658 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    7662 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7667 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967288),
     /*    7678 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:14:y
     /*    7682 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7686 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    7690 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    7692 */     // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967288:{ *:[i64] }):$pred:14:x, GPR:{ *:[i64] }:$rs2:$pred:14:y)<<P:14:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*    7692 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*    7695 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
     /*    7699 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*    7704 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    7708 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
     /*    7711 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*    7713 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
     /*    7716 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    7718 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*    7721 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    7723 */     GIR_RootConstrainSelectedInstOperands,
     /*    7724 */     // GIR_Coverage, 2620,
     /*    7724 */     GIR_EraseRootFromParent_Done,
     /*    7725 */   // Label 252: @7725
     /*    7725 */   GIM_Try, /*On fail goto*//*Label 253*/ GIMT_Encode4(7820), // Rule ID 2622 //
     /*    7730 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    7733 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7737 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:15:x
     /*    7741 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    7745 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    7749 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    7753 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    7757 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7762 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(34359738360),
     /*    7773 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:15:y
     /*    7777 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7781 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    7785 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    7787 */     // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 34359738360:{ *:[i64] }):$pred:15:x, GPR:{ *:[i64] }:$rs2:$pred:15:y)<<P:15:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*    7787 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*    7790 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
     /*    7794 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*    7799 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    7803 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
     /*    7806 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*    7808 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
     /*    7811 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    7813 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*    7816 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    7818 */     GIR_RootConstrainSelectedInstOperands,
     /*    7819 */     // GIR_Coverage, 2622,
     /*    7819 */     GIR_EraseRootFromParent_Done,
     /*    7820 */   // Label 253: @7820
     /*    7820 */   GIM_Try, /*On fail goto*//*Label 254*/ GIMT_Encode4(7915), // Rule ID 2636 //
     /*    7825 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    7828 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7832 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:20:x
     /*    7836 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    7840 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    7844 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    7848 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    7852 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7857 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967294),
     /*    7868 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:20:y
     /*    7872 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7876 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    7880 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    7882 */     // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967294:{ *:[i64] }):$pred:20:x, GPR:{ *:[i64] }:$rs2:$pred:20:y)<<P:20:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*    7882 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*    7885 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
     /*    7889 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*    7894 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    7898 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*    7901 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*    7903 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
     /*    7906 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    7908 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*    7911 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    7913 */     GIR_RootConstrainSelectedInstOperands,
     /*    7914 */     // GIR_Coverage, 2636,
     /*    7914 */     GIR_EraseRootFromParent_Done,
     /*    7915 */   // Label 254: @7915
     /*    7915 */   GIM_Try, /*On fail goto*//*Label 255*/ GIMT_Encode4(8010), // Rule ID 2638 //
     /*    7920 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    7923 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7927 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:21:x
     /*    7931 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    7935 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    7939 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    7943 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    7947 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7952 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967292),
     /*    7963 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:21:y
     /*    7967 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    7971 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    7975 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    7977 */     // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967292:{ *:[i64] }):$pred:21:x, GPR:{ *:[i64] }:$rs2:$pred:21:y)<<P:21:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*    7977 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*    7980 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
     /*    7984 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*    7989 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    7993 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
     /*    7996 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*    7998 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
     /*    8001 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    8003 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*    8006 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    8008 */     GIR_RootConstrainSelectedInstOperands,
     /*    8009 */     // GIR_Coverage, 2638,
     /*    8009 */     GIR_EraseRootFromParent_Done,
     /*    8010 */   // Label 255: @8010
     /*    8010 */   GIM_Try, /*On fail goto*//*Label 256*/ GIMT_Encode4(8105), // Rule ID 2640 //
     /*    8015 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    8018 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8022 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:22:x
     /*    8026 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    8030 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    8034 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    8038 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    8042 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8047 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967288),
     /*    8058 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:22:y
     /*    8062 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8066 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    8070 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    8072 */     // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967288:{ *:[i64] }):$pred:22:x, GPR:{ *:[i64] }:$rs2:$pred:22:y)<<P:22:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*    8072 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*    8075 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
     /*    8079 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*    8084 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    8088 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
     /*    8091 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*    8093 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
     /*    8096 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    8098 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*    8101 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    8103 */     GIR_RootConstrainSelectedInstOperands,
     /*    8104 */     // GIR_Coverage, 2640,
     /*    8104 */     GIR_EraseRootFromParent_Done,
     /*    8105 */   // Label 256: @8105
     /*    8105 */   GIM_Try, /*On fail goto*//*Label 257*/ GIMT_Encode4(8180), // Rule ID 65147 //
     /*    8110 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    8113 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8117 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:34:x
     /*    8121 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    8125 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    8129 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    8133 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    8137 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8142 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967295),
     /*    8153 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:34:y
     /*    8157 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8161 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    8165 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    8167 */     // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }):$pred:34:x, GPR:{ *:[i64] }:$rs2:$pred:34:y)<<P:34:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_B_ZE:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    8167 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_B_ZE),
     /*    8170 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    8172 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    8176 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    8178 */     GIR_RootConstrainSelectedInstOperands,
     /*    8179 */     // GIR_Coverage, 65147,
     /*    8179 */     GIR_EraseRootFromParent_Done,
     /*    8180 */   // Label 257: @8180
     /*    8180 */   GIM_Try, /*On fail goto*//*Label 258*/ GIMT_Encode4(8275), // Rule ID 65169 //
     /*    8185 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    8188 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8192 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:42:x
     /*    8196 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    8200 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    8204 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    8208 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    8212 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8217 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934590),
     /*    8228 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:42:y
     /*    8232 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8236 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    8240 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    8242 */     // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 8589934590:{ *:[i64] }):$pred:42:x, GPR:{ *:[i64] }:$rs2:$pred:42:y)<<P:42:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_H_ZE:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*    8242 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*    8245 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
     /*    8249 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*    8254 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    8258 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*    8261 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*    8263 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_H_ZE),
     /*    8266 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    8268 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*    8271 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    8273 */     GIR_RootConstrainSelectedInstOperands,
     /*    8274 */     // GIR_Coverage, 65169,
     /*    8274 */     GIR_EraseRootFromParent_Done,
     /*    8275 */   // Label 258: @8275
     /*    8275 */   GIM_Try, /*On fail goto*//*Label 259*/ GIMT_Encode4(8370), // Rule ID 65173 //
     /*    8280 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    8283 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8287 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:44:x
     /*    8291 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    8295 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    8299 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    8303 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    8307 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8312 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869180),
     /*    8323 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:44:y
     /*    8327 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8331 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    8335 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    8337 */     // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 17179869180:{ *:[i64] }):$pred:44:x, GPR:{ *:[i64] }:$rs2:$pred:44:y)<<P:44:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_W_ZE:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*    8337 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*    8340 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
     /*    8344 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*    8349 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    8353 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
     /*    8356 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*    8358 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_W_ZE),
     /*    8361 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    8363 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*    8366 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    8368 */     GIR_RootConstrainSelectedInstOperands,
     /*    8369 */     // GIR_Coverage, 65173,
     /*    8369 */     GIR_EraseRootFromParent_Done,
     /*    8370 */   // Label 259: @8370
     /*    8370 */   GIM_Try, /*On fail goto*//*Label 260*/ GIMT_Encode4(8465), // Rule ID 65175 //
     /*    8375 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    8378 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8382 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:45:x
     /*    8386 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    8390 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    8394 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    8398 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    8402 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8407 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967288),
     /*    8418 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:45:y
     /*    8422 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8426 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    8430 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    8432 */     // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967288:{ *:[i64] }):$pred:45:x, GPR:{ *:[i64] }:$rs2:$pred:45:y)<<P:45:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_D_ZE:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*    8432 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*    8435 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
     /*    8439 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*    8444 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    8448 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
     /*    8451 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*    8453 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_D_ZE),
     /*    8456 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    8458 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*    8461 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    8463 */     GIR_RootConstrainSelectedInstOperands,
     /*    8464 */     // GIR_Coverage, 65175,
     /*    8464 */     GIR_EraseRootFromParent_Done,
     /*    8465 */   // Label 260: @8465
     /*    8465 */   GIM_Try, /*On fail goto*//*Label 261*/ GIMT_Encode4(8560), // Rule ID 65177 //
     /*    8470 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    8473 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8477 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:46:x
     /*    8481 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    8485 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    8489 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    8493 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    8497 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8502 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(34359738360),
     /*    8513 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:46:y
     /*    8517 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8521 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    8525 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    8527 */     // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 34359738360:{ *:[i64] }):$pred:46:x, GPR:{ *:[i64] }:$rs2:$pred:46:y)<<P:46:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_D_ZE:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*    8527 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*    8530 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
     /*    8534 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*    8539 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    8543 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
     /*    8546 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*    8548 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_D_ZE),
     /*    8551 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    8553 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*    8556 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    8558 */     GIR_RootConstrainSelectedInstOperands,
     /*    8559 */     // GIR_Coverage, 65177,
     /*    8559 */     GIR_EraseRootFromParent_Done,
     /*    8560 */   // Label 261: @8560
     /*    8560 */   GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(8655), // Rule ID 65179 //
     /*    8565 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    8568 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8572 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:47:x
     /*    8576 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    8580 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    8584 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    8588 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    8592 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8597 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967294),
     /*    8608 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:47:y
     /*    8612 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8616 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    8620 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    8622 */     // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967294:{ *:[i64] }):$pred:47:x, GPR:{ *:[i64] }:$rs2:$pred:47:y)<<P:47:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_H_ZE:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*    8622 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*    8625 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
     /*    8629 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*    8634 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    8638 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*    8641 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*    8643 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_H_ZE),
     /*    8646 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    8648 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*    8651 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    8653 */     GIR_RootConstrainSelectedInstOperands,
     /*    8654 */     // GIR_Coverage, 65179,
     /*    8654 */     GIR_EraseRootFromParent_Done,
     /*    8655 */   // Label 262: @8655
     /*    8655 */   GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(8750), // Rule ID 65181 //
     /*    8660 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    8663 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8667 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:48:x
     /*    8671 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    8675 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    8679 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    8683 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    8687 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8692 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967292),
     /*    8703 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:48:y
     /*    8707 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8711 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    8715 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    8717 */     // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967292:{ *:[i64] }):$pred:48:x, GPR:{ *:[i64] }:$rs2:$pred:48:y)<<P:48:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_W_ZE:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*    8717 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*    8720 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
     /*    8724 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*    8729 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    8733 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
     /*    8736 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*    8738 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_W_ZE),
     /*    8741 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    8743 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*    8746 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    8748 */     GIR_RootConstrainSelectedInstOperands,
     /*    8749 */     // GIR_Coverage, 65181,
     /*    8749 */     GIR_EraseRootFromParent_Done,
     /*    8750 */   // Label 263: @8750
     /*    8750 */   GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(8845), // Rule ID 65183 //
     /*    8755 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*    8758 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8762 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:49:x
     /*    8766 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    8770 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    8774 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    8778 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    8782 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8787 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967288),
     /*    8798 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:49:y
     /*    8802 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8806 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    8810 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    8812 */     // (add:{ *:[i64] } (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967288:{ *:[i64] }):$pred:49:x, GPR:{ *:[i64] }:$rs2:$pred:49:y)<<P:49:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_D_ZE:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*    8812 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*    8815 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
     /*    8819 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*    8824 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    8828 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
     /*    8831 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*    8833 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_D_ZE),
     /*    8836 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    8838 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*    8841 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    8843 */     GIR_RootConstrainSelectedInstOperands,
     /*    8844 */     // GIR_Coverage, 65183,
     /*    8844 */     GIR_EraseRootFromParent_Done,
     /*    8845 */   // Label 264: @8845
     /*    8845 */   GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(8913), // Rule ID 2565 //
     /*    8850 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
     /*    8853 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8857 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:1:x
     /*    8861 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    8865 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    8869 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    8873 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    8877 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8882 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*    8886 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:1:y
     /*    8890 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8894 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    8898 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    8900 */     // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }):$pred:1:x, GPR:{ *:[i64] }:$rs2:$pred:1:y)<<P:1:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    8900 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
     /*    8903 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    8905 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    8909 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    8911 */     GIR_RootConstrainSelectedInstOperands,
     /*    8912 */     // GIR_Coverage, 2565,
     /*    8912 */     GIR_EraseRootFromParent_Done,
     /*    8913 */   // Label 265: @8913
     /*    8913 */   GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(8981), // Rule ID 2575 //
     /*    8918 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
     /*    8921 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8925 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:3:x
     /*    8929 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    8933 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    8937 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    8941 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    8945 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8950 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
     /*    8954 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:3:y
     /*    8958 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8962 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    8966 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    8968 */     // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }):$pred:3:x, GPR:{ *:[i64] }:$rs2:$pred:3:y)<<P:3:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    8968 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
     /*    8971 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    8973 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    8977 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    8979 */     GIR_RootConstrainSelectedInstOperands,
     /*    8980 */     // GIR_Coverage, 2575,
     /*    8980 */     GIR_EraseRootFromParent_Done,
     /*    8981 */   // Label 266: @8981
     /*    8981 */   GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(9049), // Rule ID 2585 //
     /*    8986 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
     /*    8989 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    8993 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:5:x
     /*    8997 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    9001 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    9005 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    9009 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    9013 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9018 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
     /*    9022 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:5:y
     /*    9026 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9030 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    9034 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    9036 */     // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }):$pred:5:x, GPR:{ *:[i64] }:$rs2:$pred:5:y)<<P:5:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    9036 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
     /*    9039 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    9041 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    9045 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    9047 */     GIR_RootConstrainSelectedInstOperands,
     /*    9048 */     // GIR_Coverage, 2585,
     /*    9048 */     GIR_EraseRootFromParent_Done,
     /*    9049 */   // Label 267: @9049
     /*    9049 */   GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(9117), // Rule ID 65110 //
     /*    9054 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode0),
     /*    9057 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9061 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:28:x
     /*    9065 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    9069 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    9073 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    9077 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    9081 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9086 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*    9090 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:28:y
     /*    9094 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9098 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    9102 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    9104 */     // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }):$pred:28:x, GPR:{ *:[i64] }:$rs2:$pred:28:y)<<P:28:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_H:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    9104 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_H),
     /*    9107 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    9109 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    9113 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    9115 */     GIR_RootConstrainSelectedInstOperands,
     /*    9116 */     // GIR_Coverage, 65110,
     /*    9116 */     GIR_EraseRootFromParent_Done,
     /*    9117 */   // Label 268: @9117
     /*    9117 */   GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(9185), // Rule ID 65120 //
     /*    9122 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode0),
     /*    9125 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9129 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:30:x
     /*    9133 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    9137 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    9141 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    9145 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    9149 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9154 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
     /*    9158 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:30:y
     /*    9162 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9166 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    9170 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    9172 */     // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }):$pred:30:x, GPR:{ *:[i64] }:$rs2:$pred:30:y)<<P:30:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_W:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    9172 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_W),
     /*    9175 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    9177 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    9181 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    9183 */     GIR_RootConstrainSelectedInstOperands,
     /*    9184 */     // GIR_Coverage, 65120,
     /*    9184 */     GIR_EraseRootFromParent_Done,
     /*    9185 */   // Label 269: @9185
     /*    9185 */   GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(9253), // Rule ID 65130 //
     /*    9190 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode0),
     /*    9193 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9197 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:32:x
     /*    9201 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*    9205 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*    9209 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    9213 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    9217 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9222 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
     /*    9226 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:32:y
     /*    9230 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9234 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    9238 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    9240 */     // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }):$pred:32:x, GPR:{ *:[i64] }:$rs2:$pred:32:y)<<P:32:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_D:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    9240 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_D),
     /*    9243 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    9245 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    9249 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*    9251 */     GIR_RootConstrainSelectedInstOperands,
     /*    9252 */     // GIR_Coverage, 65130,
     /*    9252 */     GIR_EraseRootFromParent_Done,
     /*    9253 */   // Label 270: @9253
     /*    9253 */   GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(9328), // Rule ID 65614 //
     /*    9258 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    9261 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9265 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:7:y
     /*    9269 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9273 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:7:x
     /*    9277 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    9281 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    9285 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    9289 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    9293 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9298 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967295),
     /*    9309 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    9313 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    9315 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:7:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }):$pred:7:x)<<P:7:Predicate_add_like_non_imm12>>  =>  (ADD_UW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*    9315 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADD_UW),
     /*    9318 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    9320 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    9324 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    9326 */     GIR_RootConstrainSelectedInstOperands,
     /*    9327 */     // GIR_Coverage, 65614,
     /*    9327 */     GIR_EraseRootFromParent_Done,
     /*    9328 */   // Label 271: @9328
     /*    9328 */   GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(9423), // Rule ID 65624 //
     /*    9333 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    9336 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9340 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:11:y
     /*    9344 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9348 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:11:x
     /*    9352 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    9356 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    9360 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    9364 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    9368 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9373 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934590),
     /*    9384 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    9388 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    9390 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:11:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 8589934590:{ *:[i64] }):$pred:11:x)<<P:11:Predicate_add_like_non_imm12>>  =>  (SH1ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*    9390 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*    9393 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
     /*    9397 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*    9402 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    9406 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*    9409 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*    9411 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD_UW),
     /*    9414 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    9416 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*    9419 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    9421 */     GIR_RootConstrainSelectedInstOperands,
     /*    9422 */     // GIR_Coverage, 65624,
     /*    9422 */     GIR_EraseRootFromParent_Done,
     /*    9423 */   // Label 272: @9423
     /*    9423 */   GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(9518), // Rule ID 65628 //
     /*    9428 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    9431 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9435 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:13:y
     /*    9439 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9443 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:13:x
     /*    9447 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    9451 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    9455 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    9459 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    9463 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9468 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869180),
     /*    9479 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    9483 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    9485 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:13:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 17179869180:{ *:[i64] }):$pred:13:x)<<P:13:Predicate_add_like_non_imm12>>  =>  (SH2ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*    9485 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*    9488 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
     /*    9492 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*    9497 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    9501 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
     /*    9504 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*    9506 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD_UW),
     /*    9509 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    9511 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*    9514 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    9516 */     GIR_RootConstrainSelectedInstOperands,
     /*    9517 */     // GIR_Coverage, 65628,
     /*    9517 */     GIR_EraseRootFromParent_Done,
     /*    9518 */   // Label 273: @9518
     /*    9518 */   GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(9613), // Rule ID 65630 //
     /*    9523 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    9526 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9530 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:14:y
     /*    9534 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9538 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:14:x
     /*    9542 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    9546 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    9550 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    9554 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    9558 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9563 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967288),
     /*    9574 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    9578 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    9580 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:14:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967288:{ *:[i64] }):$pred:14:x)<<P:14:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*    9580 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*    9583 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
     /*    9587 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*    9592 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    9596 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
     /*    9599 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*    9601 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
     /*    9604 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    9606 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*    9609 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    9611 */     GIR_RootConstrainSelectedInstOperands,
     /*    9612 */     // GIR_Coverage, 65630,
     /*    9612 */     GIR_EraseRootFromParent_Done,
     /*    9613 */   // Label 274: @9613
     /*    9613 */   GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(9708), // Rule ID 65632 //
     /*    9618 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    9621 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9625 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:15:y
     /*    9629 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9633 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:15:x
     /*    9637 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    9641 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    9645 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    9649 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    9653 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9658 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(34359738360),
     /*    9669 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    9673 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    9675 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:15:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 34359738360:{ *:[i64] }):$pred:15:x)<<P:15:Predicate_add_like_non_imm12>>  =>  (SH3ADD_UW:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*    9675 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*    9678 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
     /*    9682 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*    9687 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    9691 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
     /*    9694 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*    9696 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD_UW),
     /*    9699 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    9701 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*    9704 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    9706 */     GIR_RootConstrainSelectedInstOperands,
     /*    9707 */     // GIR_Coverage, 65632,
     /*    9707 */     GIR_EraseRootFromParent_Done,
     /*    9708 */   // Label 275: @9708
     /*    9708 */   GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(9803), // Rule ID 65642 //
     /*    9713 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    9716 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9720 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:20:y
     /*    9724 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9728 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:20:x
     /*    9732 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    9736 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    9740 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    9744 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    9748 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9753 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967294),
     /*    9764 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    9768 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    9770 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:20:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967294:{ *:[i64] }):$pred:20:x)<<P:20:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*    9770 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*    9773 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
     /*    9777 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*    9782 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    9786 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*    9789 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*    9791 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
     /*    9794 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    9796 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*    9799 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    9801 */     GIR_RootConstrainSelectedInstOperands,
     /*    9802 */     // GIR_Coverage, 65642,
     /*    9802 */     GIR_EraseRootFromParent_Done,
     /*    9803 */   // Label 276: @9803
     /*    9803 */   GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(9898), // Rule ID 65644 //
     /*    9808 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    9811 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9815 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:21:y
     /*    9819 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9823 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:21:x
     /*    9827 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    9831 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    9835 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    9839 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    9843 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9848 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967292),
     /*    9859 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    9863 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    9865 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:21:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967292:{ *:[i64] }):$pred:21:x)<<P:21:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*    9865 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*    9868 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
     /*    9872 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*    9877 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    9881 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
     /*    9884 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*    9886 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
     /*    9889 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    9891 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*    9894 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    9896 */     GIR_RootConstrainSelectedInstOperands,
     /*    9897 */     // GIR_Coverage, 65644,
     /*    9897 */     GIR_EraseRootFromParent_Done,
     /*    9898 */   // Label 277: @9898
     /*    9898 */   GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(9993), // Rule ID 65646 //
     /*    9903 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_IsRV64_HwMode0),
     /*    9906 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9910 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:22:y
     /*    9914 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9918 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:22:x
     /*    9922 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*    9926 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*    9930 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*    9934 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*    9938 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*    9943 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967288),
     /*    9954 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*    9958 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*    9960 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:22:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967288:{ *:[i64] }):$pred:22:x)<<P:22:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*    9960 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*    9963 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
     /*    9967 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*    9972 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*    9976 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
     /*    9979 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*    9981 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
     /*    9984 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*    9986 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*    9989 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*    9991 */     GIR_RootConstrainSelectedInstOperands,
     /*    9992 */     // GIR_Coverage, 65646,
     /*    9992 */     GIR_EraseRootFromParent_Done,
     /*    9993 */   // Label 278: @9993
     /*    9993 */   GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(10068), // Rule ID 74474 //
     /*    9998 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*   10001 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10005 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:34:y
     /*   10009 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10013 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:34:x
     /*   10017 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   10021 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   10025 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   10029 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   10033 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10038 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967295),
     /*   10049 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*   10053 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   10055 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:34:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967295:{ *:[i64] }):$pred:34:x)<<P:34:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_B_ZE:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*   10055 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_B_ZE),
     /*   10058 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   10060 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   10064 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   10066 */     GIR_RootConstrainSelectedInstOperands,
     /*   10067 */     // GIR_Coverage, 74474,
     /*   10067 */     GIR_EraseRootFromParent_Done,
     /*   10068 */   // Label 279: @10068
     /*   10068 */   GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(10163), // Rule ID 74492 //
     /*   10073 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*   10076 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10080 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:42:y
     /*   10084 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10088 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:42:x
     /*   10092 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   10096 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   10100 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   10104 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   10108 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10113 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(8589934590),
     /*   10124 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*   10128 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   10130 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:42:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 8589934590:{ *:[i64] }):$pred:42:x)<<P:42:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_H_ZE:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*   10130 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   10133 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
     /*   10137 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   10142 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   10146 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*   10149 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   10151 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_H_ZE),
     /*   10154 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   10156 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   10159 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   10161 */     GIR_RootConstrainSelectedInstOperands,
     /*   10162 */     // GIR_Coverage, 74492,
     /*   10162 */     GIR_EraseRootFromParent_Done,
     /*   10163 */   // Label 280: @10163
     /*   10163 */   GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(10258), // Rule ID 74496 //
     /*   10168 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*   10171 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10175 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:44:y
     /*   10179 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10183 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:44:x
     /*   10187 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   10191 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   10195 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   10199 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   10203 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10208 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(17179869180),
     /*   10219 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*   10223 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   10225 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:44:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 17179869180:{ *:[i64] }):$pred:44:x)<<P:44:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_W_ZE:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*   10225 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   10228 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
     /*   10232 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   10237 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   10241 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
     /*   10244 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   10246 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_W_ZE),
     /*   10249 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   10251 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   10254 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   10256 */     GIR_RootConstrainSelectedInstOperands,
     /*   10257 */     // GIR_Coverage, 74496,
     /*   10257 */     GIR_EraseRootFromParent_Done,
     /*   10258 */   // Label 281: @10258
     /*   10258 */   GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(10353), // Rule ID 74498 //
     /*   10263 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*   10266 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10270 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:45:y
     /*   10274 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10278 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:45:x
     /*   10282 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   10286 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   10290 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   10294 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   10298 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10303 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967288),
     /*   10314 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*   10318 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   10320 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:45:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967288:{ *:[i64] }):$pred:45:x)<<P:45:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_D_ZE:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*   10320 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   10323 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
     /*   10327 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   10332 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   10336 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
     /*   10339 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   10341 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_D_ZE),
     /*   10344 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   10346 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   10349 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   10351 */     GIR_RootConstrainSelectedInstOperands,
     /*   10352 */     // GIR_Coverage, 74498,
     /*   10352 */     GIR_EraseRootFromParent_Done,
     /*   10353 */   // Label 282: @10353
     /*   10353 */   GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(10448), // Rule ID 74500 //
     /*   10358 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*   10361 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10365 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:46:y
     /*   10369 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10373 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:46:x
     /*   10377 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   10381 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   10385 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   10389 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   10393 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10398 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(34359738360),
     /*   10409 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*   10413 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   10415 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:46:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 34359738360:{ *:[i64] }):$pred:46:x)<<P:46:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_D_ZE:{ *:[i64] } (SRLI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*   10415 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   10418 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLI),
     /*   10422 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   10427 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   10431 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
     /*   10434 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   10436 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_D_ZE),
     /*   10439 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   10441 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   10444 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   10446 */     GIR_RootConstrainSelectedInstOperands,
     /*   10447 */     // GIR_Coverage, 74500,
     /*   10447 */     GIR_EraseRootFromParent_Done,
     /*   10448 */   // Label 283: @10448
     /*   10448 */   GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(10543), // Rule ID 74502 //
     /*   10453 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*   10456 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10460 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:47:y
     /*   10464 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10468 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:47:x
     /*   10472 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   10476 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   10480 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   10484 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   10488 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10493 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967294),
     /*   10504 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*   10508 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   10510 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:47:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967294:{ *:[i64] }):$pred:47:x)<<P:47:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_H_ZE:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*   10510 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   10513 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
     /*   10517 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   10522 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   10526 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
     /*   10529 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   10531 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_H_ZE),
     /*   10534 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   10536 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   10539 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   10541 */     GIR_RootConstrainSelectedInstOperands,
     /*   10542 */     // GIR_Coverage, 74502,
     /*   10542 */     GIR_EraseRootFromParent_Done,
     /*   10543 */   // Label 284: @10543
     /*   10543 */   GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(10638), // Rule ID 74504 //
     /*   10548 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*   10551 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10555 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:48:y
     /*   10559 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10563 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:48:x
     /*   10567 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   10571 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   10575 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   10579 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   10583 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10588 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967292),
     /*   10599 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*   10603 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   10605 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:48:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967292:{ *:[i64] }):$pred:48:x)<<P:48:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_W_ZE:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*   10605 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   10608 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
     /*   10612 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   10617 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   10621 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/2,
     /*   10624 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   10626 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_W_ZE),
     /*   10629 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   10631 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   10634 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   10636 */     GIR_RootConstrainSelectedInstOperands,
     /*   10637 */     // GIR_Coverage, 74504,
     /*   10637 */     GIR_EraseRootFromParent_Done,
     /*   10638 */   // Label 285: @10638
     /*   10638 */   GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(10733), // Rule ID 74506 //
     /*   10643 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_IsRV64_HwMode0),
     /*   10646 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10650 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:49:y
     /*   10654 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10658 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:49:x
     /*   10662 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   10666 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*   10670 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   10674 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   10678 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10683 */     GIM_CheckConstantInt, /*MI*/1, /*Op*/2, GIMT_Encode8(4294967288),
     /*   10694 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*   10698 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   10700 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:49:y, (and:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 4294967288:{ *:[i64] }):$pred:49:x)<<P:49:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_D_ZE:{ *:[i64] } (SRLIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }), GPR:{ *:[i64] }:$rs2)
     /*   10700 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   10703 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::SRLIW),
     /*   10707 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   10712 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   10716 */     GIR_AddImm8, /*InsnID*/1, /*Imm*/3,
     /*   10719 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   10721 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_D_ZE),
     /*   10724 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   10726 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   10729 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   10731 */     GIR_RootConstrainSelectedInstOperands,
     /*   10732 */     // GIR_Coverage, 74506,
     /*   10732 */     GIR_EraseRootFromParent_Done,
     /*   10733 */   // Label 286: @10733
     /*   10733 */   GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(10801), // Rule ID 65591 //
     /*   10738 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
     /*   10741 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10745 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:1:y
     /*   10749 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10753 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:1:x
     /*   10757 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   10761 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*   10765 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   10769 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   10773 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10778 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*   10782 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*   10786 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   10788 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:1:y, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }):$pred:1:x)<<P:1:Predicate_add_like_non_imm12>>  =>  (SH1ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*   10788 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH1ADD),
     /*   10791 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   10793 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   10797 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   10799 */     GIR_RootConstrainSelectedInstOperands,
     /*   10800 */     // GIR_Coverage, 65591,
     /*   10800 */     GIR_EraseRootFromParent_Done,
     /*   10801 */   // Label 287: @10801
     /*   10801 */   GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(10869), // Rule ID 65599 //
     /*   10806 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
     /*   10809 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10813 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:3:y
     /*   10817 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10821 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:3:x
     /*   10825 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   10829 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*   10833 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   10837 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   10841 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10846 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
     /*   10850 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*   10854 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   10856 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:3:y, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }):$pred:3:x)<<P:3:Predicate_add_like_non_imm12>>  =>  (SH2ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*   10856 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH2ADD),
     /*   10859 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   10861 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   10865 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   10867 */     GIR_RootConstrainSelectedInstOperands,
     /*   10868 */     // GIR_Coverage, 65599,
     /*   10868 */     GIR_EraseRootFromParent_Done,
     /*   10869 */   // Label 288: @10869
     /*   10869 */   GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(10937), // Rule ID 65607 //
     /*   10874 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasStdExtZba_HwMode0),
     /*   10877 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10881 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:5:y
     /*   10885 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10889 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:5:x
     /*   10893 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   10897 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*   10901 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   10905 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   10909 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10914 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
     /*   10918 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*   10922 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   10924 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:5:y, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }):$pred:5:x)<<P:5:Predicate_add_like_non_imm12>>  =>  (SH3ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*   10924 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::SH3ADD),
     /*   10927 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   10929 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   10933 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   10935 */     GIR_RootConstrainSelectedInstOperands,
     /*   10936 */     // GIR_Coverage, 65607,
     /*   10936 */     GIR_EraseRootFromParent_Done,
     /*   10937 */   // Label 289: @10937
     /*   10937 */   GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(11005), // Rule ID 74451 //
     /*   10942 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode0),
     /*   10945 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10949 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:28:y
     /*   10953 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10957 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:28:x
     /*   10961 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   10965 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*   10969 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   10973 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   10977 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   10982 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
     /*   10986 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*   10990 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   10992 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:28:y, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 1:{ *:[i64] }):$pred:28:x)<<P:28:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_H:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*   10992 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_H),
     /*   10995 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   10997 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   11001 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   11003 */     GIR_RootConstrainSelectedInstOperands,
     /*   11004 */     // GIR_Coverage, 74451,
     /*   11004 */     GIR_EraseRootFromParent_Done,
     /*   11005 */   // Label 290: @11005
     /*   11005 */   GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(11073), // Rule ID 74459 //
     /*   11010 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode0),
     /*   11013 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11017 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:30:y
     /*   11021 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11025 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:30:x
     /*   11029 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   11033 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*   11037 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   11041 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   11045 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11050 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 2,
     /*   11054 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*   11058 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   11060 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:30:y, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 2:{ *:[i64] }):$pred:30:x)<<P:30:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_W:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*   11060 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_W),
     /*   11063 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   11065 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   11069 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   11071 */     GIR_RootConstrainSelectedInstOperands,
     /*   11072 */     // GIR_Coverage, 74459,
     /*   11072 */     GIR_EraseRootFromParent_Done,
     /*   11073 */   // Label 291: @11073
     /*   11073 */   GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(11141), // Rule ID 74467 //
     /*   11078 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXAndesPerf_HwMode0),
     /*   11081 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11085 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:32:y
     /*   11089 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11093 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:32:x
     /*   11097 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   11101 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*   11105 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   11109 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   11113 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11118 */     GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 3,
     /*   11122 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*   11126 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   11128 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs2:$pred:32:y, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs1, 3:{ *:[i64] }):$pred:32:x)<<P:32:Predicate_add_like_non_imm12>>  =>  (NDS_LEA_D:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*   11128 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::NDS_LEA_D),
     /*   11131 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   11133 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   11137 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   11139 */     GIR_RootConstrainSelectedInstOperands,
     /*   11140 */     // GIR_Coverage, 74467,
     /*   11140 */     GIR_EraseRootFromParent_Done,
     /*   11141 */   // Label 292: @11141
     /*   11141 */   GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(11220), // Rule ID 62531 //
     /*   11146 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
     /*   11149 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11153 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/0, // Name : pred:23:x
     /*   11157 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   11161 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*   11165 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   11169 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   11173 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11178 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*   11182 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   11186 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm2),
     /*   11190 */     // MIs[2] Operand 1
     /*   11190 */     // No operand predicates
     /*   11190 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/1, // Name : pred:23:y
     /*   11194 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11198 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*   11202 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   11204 */     // (add:{ *:[i64] } (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2):$pred:23:x, GPR:{ *:[i64] }:$rs1:$pred:23:y)<<P:23:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2)
     /*   11204 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
     /*   11207 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   11209 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs1
     /*   11211 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   11215 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
     /*   11218 */     GIR_RootConstrainSelectedInstOperands,
     /*   11219 */     // GIR_Coverage, 62531,
     /*   11219 */     GIR_EraseRootFromParent_Done,
     /*   11220 */   // Label 293: @11220
     /*   11220 */   GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(11299), // Rule ID 74425 //
     /*   11225 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadBa_HwMode0),
     /*   11228 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11232 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/1, /*StoreIdx*/1, // Name : pred:23:y
     /*   11236 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11240 */     GIM_RecordNamedOperand, /*MI*/0, /*Op*/2, /*StoreIdx*/0, // Name : pred:23:x
     /*   11244 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   11248 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /*   11252 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   11256 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   11260 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11265 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
     /*   11269 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   11273 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_uimm2),
     /*   11277 */     // MIs[2] Operand 1
     /*   11277 */     // No operand predicates
     /*   11277 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_add_like_non_imm12),
     /*   11281 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   11283 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1:$pred:23:y, (shl:{ *:[i64] } GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2):$pred:23:x)<<P:23:Predicate_add_like_non_imm12>>  =>  (TH_ADDSL:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2, (imm:{ *:[i64] })<<P:Predicate_uimm2>>:$uimm2)
     /*   11283 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_ADDSL),
     /*   11286 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   11288 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*   11290 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   11294 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // uimm2
     /*   11297 */     GIR_RootConstrainSelectedInstOperands,
     /*   11298 */     // GIR_Coverage, 74425,
     /*   11298 */     GIR_EraseRootFromParent_Done,
     /*   11299 */   // Label 294: @11299
     /*   11299 */   GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(11348), // Rule ID 120 //
     /*   11304 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
     /*   11307 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11311 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   11315 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FRAME_INDEX),
     /*   11319 */     // MIs[1] Operand 1
     /*   11319 */     // No operand predicates
     /*   11319 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   11323 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   11327 */     GIM_CheckI64ImmPredicate, /*MI*/2, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
     /*   11331 */     // MIs[2] Operand 1
     /*   11331 */     // No operand predicates
     /*   11331 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   11333 */     // (add:{ *:[i64] } (frameindex:{ *:[i64] }):$fi, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$offset)  =>  (ADDI:{ *:[i64] } (to_tframeindex:{ *:[iPTR] } ?:{ *:[i64] }:$fi), (imm:{ *:[i64] })<<P:Predicate_simm12>>:$offset)
     /*   11333 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
     /*   11336 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   11338 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderFrameIndex), // fi
     /*   11343 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/2, // offset
     /*   11346 */     GIR_RootConstrainSelectedInstOperands,
     /*   11347 */     // GIR_Coverage, 120,
     /*   11347 */     GIR_EraseRootFromParent_Done,
     /*   11348 */   // Label 295: @11348
     /*   11348 */   GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(11394), // Rule ID 275 //
     /*   11353 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
     /*   11356 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11360 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11364 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   11368 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   11372 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
     /*   11376 */     // MIs[1] Operand 1
     /*   11376 */     // No operand predicates
     /*   11376 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_10046),
     /*   11380 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   11382 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)<<P:Predicate_anonymous_10046>>  =>  (ADDIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
     /*   11382 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDIW),
     /*   11385 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   11387 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*   11389 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*   11392 */     GIR_RootConstrainSelectedInstOperands,
     /*   11393 */     // GIR_Coverage, 275,
     /*   11393 */     GIR_EraseRootFromParent_Done,
     /*   11394 */   // Label 296: @11394
     /*   11394 */   GIM_Try, /*On fail goto*//*Label 297*/ GIMT_Encode4(11470), // Rule ID 297 //
     /*   11399 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
     /*   11402 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11406 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11410 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   11414 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   11418 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_AddiPair),
     /*   11422 */     // MIs[1] Operand 1
     /*   11422 */     // No operand predicates
     /*   11422 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_10074),
     /*   11426 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_10046),
     /*   11430 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   11432 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_AddiPair>><<P:Predicate_anonymous_10074>>:$rs2)<<P:Predicate_anonymous_10046>>  =>  (ADDIW:{ *:[i64] } (ADDIW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (AddiPairImmLarge:{ *:[i64] } (imm:{ *:[i64] }):$rs2)), (AddiPairImmSmall:{ *:[i64] } (imm:{ *:[i64] }):$rs2))
     /*   11432 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   11435 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::ADDIW),
     /*   11439 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   11444 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
     /*   11448 */     GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderAddiPairImmLarge), // rs2
     /*   11453 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   11455 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDIW),
     /*   11458 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   11460 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   11463 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderAddiPairImmSmall), // rs2
     /*   11468 */     GIR_RootConstrainSelectedInstOperands,
     /*   11469 */     // GIR_Coverage, 297,
     /*   11469 */     GIR_EraseRootFromParent_Done,
     /*   11470 */   // Label 297: @11470
     /*   11470 */   GIM_Try, /*On fail goto*//*Label 298*/ GIMT_Encode4(11535), // Rule ID 74441 //
     /*   11475 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_IsRV64_HwMode0),
     /*   11478 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11482 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   11486 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   11490 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   11494 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   11498 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11503 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11508 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11512 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_10046),
     /*   11516 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   11518 */     // (add:{ *:[i64] } (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2), GPR:{ *:[i64] }:$rd)<<P:Predicate_anonymous_10046>>  =>  (TH_MULAW:{ *:[i64] } GPR:{ *:[i64] }:$rd, GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*   11518 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULAW),
     /*   11521 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
     /*   11523 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   11525 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   11529 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
     /*   11533 */     GIR_RootConstrainSelectedInstOperands,
     /*   11534 */     // GIR_Coverage, 74441,
     /*   11534 */     GIR_EraseRootFromParent_Done,
     /*   11535 */   // Label 298: @11535
     /*   11535 */   GIM_Try, /*On fail goto*//*Label 299*/ GIMT_Encode4(11600), // Rule ID 62602 //
     /*   11540 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_IsRV64_HwMode0),
     /*   11543 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11547 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11551 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   11555 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   11559 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   11563 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   11567 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11572 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11577 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_10046),
     /*   11581 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   11583 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rd, (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2))<<P:Predicate_anonymous_10046>>  =>  (TH_MULAW:{ *:[i64] } GPR:{ *:[i64] }:$rd, GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*   11583 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULAW),
     /*   11586 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
     /*   11588 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   11590 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   11594 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
     /*   11598 */     GIR_RootConstrainSelectedInstOperands,
     /*   11599 */     // GIR_Coverage, 62602,
     /*   11599 */     GIR_EraseRootFromParent_Done,
     /*   11600 */   // Label 299: @11600
     /*   11600 */   GIM_Try, /*On fail goto*//*Label 300*/ GIMT_Encode4(11642), // Rule ID 80 //
     /*   11605 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
     /*   11608 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11612 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11616 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   11620 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   11624 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_simm12),
     /*   11628 */     // MIs[1] Operand 1
     /*   11628 */     // No operand predicates
     /*   11628 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   11630 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)  =>  (ADDI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_simm12>>:$imm)
     /*   11630 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
     /*   11633 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   11635 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*   11637 */     GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // imm
     /*   11640 */     GIR_RootConstrainSelectedInstOperands,
     /*   11641 */     // GIR_Coverage, 80,
     /*   11641 */     GIR_EraseRootFromParent_Done,
     /*   11642 */   // Label 300: @11642
     /*   11642 */   GIM_Try, /*On fail goto*//*Label 301*/ GIMT_Encode4(11714), // Rule ID 295 //
     /*   11647 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
     /*   11650 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11654 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11658 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   11662 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*   11666 */     GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_AddiPair),
     /*   11670 */     // MIs[1] Operand 1
     /*   11670 */     // No operand predicates
     /*   11670 */     GIM_CheckCxxInsnPredicate, /*MI*/1, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_10074),
     /*   11674 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   11676 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (imm:{ *:[i64] })<<P:Predicate_AddiPair>><<P:Predicate_anonymous_10074>>:$rs2)  =>  (ADDI:{ *:[i64] } (ADDI:{ *:[i64] } GPR:{ *:[i64] }:$rs1, (AddiPairImmLarge:{ *:[i64] } (imm:{ *:[i64] }):$rs2)), (AddiPairImmSmall:{ *:[i64] } (imm:{ *:[i64] }):$rs2))
     /*   11676 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
     /*   11679 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
     /*   11683 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   11688 */     GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // rs1
     /*   11692 */     GIR_CustomRenderer, /*InsnID*/1, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderAddiPairImmLarge), // rs2
     /*   11697 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   11699 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::ADDI),
     /*   11702 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   11704 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   11707 */     GIR_CustomRenderer, /*InsnID*/0, /*OldInsnID*/1, /*Renderer*/GIMT_Encode2(GICR_renderAddiPairImmSmall), // rs2
     /*   11712 */     GIR_RootConstrainSelectedInstOperands,
     /*   11713 */     // GIR_Coverage, 295,
     /*   11713 */     GIR_EraseRootFromParent_Done,
     /*   11714 */   // Label 301: @11714
     /*   11714 */   GIM_Try, /*On fail goto*//*Label 302*/ GIMT_Encode4(11775), // Rule ID 74439 //
     /*   11719 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode0),
     /*   11722 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11726 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   11730 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   11734 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   11738 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   11742 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11747 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11752 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11756 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   11758 */     // (add:{ *:[i64] } (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2), GPR:{ *:[i64] }:$rd)  =>  (TH_MULA:{ *:[i64] } GPR:{ *:[i64] }:$rd, GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*   11758 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULA),
     /*   11761 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
     /*   11763 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   11765 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   11769 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
     /*   11773 */     GIR_RootConstrainSelectedInstOperands,
     /*   11774 */     // GIR_Coverage, 74439,
     /*   11774 */     GIR_EraseRootFromParent_Done,
     /*   11775 */   // Label 302: @11775
     /*   11775 */   GIM_Try, /*On fail goto*//*Label 303*/ GIMT_Encode4(11836), // Rule ID 62598 //
     /*   11780 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVendorXTHeadMac_HwMode0),
     /*   11783 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11787 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11791 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   11795 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   11799 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   11803 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*   11807 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11812 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11817 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   11819 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rd, (mul:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2))  =>  (TH_MULA:{ *:[i64] } GPR:{ *:[i64] }:$rd, GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*   11819 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::TH_MULA),
     /*   11822 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd_wb]
     /*   11824 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   11826 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   11830 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rs2
     /*   11834 */     GIR_RootConstrainSelectedInstOperands,
     /*   11835 */     // GIR_Coverage, 62598,
     /*   11835 */     GIR_EraseRootFromParent_Done,
     /*   11836 */   // Label 303: @11836
     /*   11836 */   GIM_Try, /*On fail goto*//*Label 304*/ GIMT_Encode4(11867), // Rule ID 274 //
     /*   11841 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_IsRV64_HwMode0),
     /*   11844 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11848 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11852 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11856 */     GIM_CheckCxxInsnPredicate, /*MI*/0, /*FnId*/GIMT_Encode2(GICXXPred_MI_Predicate_anonymous_10046),
     /*   11860 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)<<P:Predicate_anonymous_10046>>  =>  (ADDW:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*   11860 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADDW),
     /*   11865 */     GIR_RootConstrainSelectedInstOperands,
     /*   11866 */     // GIR_Coverage, 274,
     /*   11866 */     GIR_Done,
     /*   11867 */   // Label 304: @11867
     /*   11867 */   GIM_Try, /*On fail goto*//*Label 305*/ GIMT_Encode4(11894), // Rule ID 78 //
     /*   11872 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HwMode0),
     /*   11875 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11879 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11883 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::GPRRegClassID),
     /*   11887 */     // (add:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)  =>  (ADD:{ *:[i64] } GPR:{ *:[i64] }:$rs1, GPR:{ *:[i64] }:$rs2)
     /*   11887 */     GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(RISCV::ADD),
     /*   11892 */     GIR_RootConstrainSelectedInstOperands,
     /*   11893 */     // GIR_Coverage, 78,
     /*   11893 */     GIR_Done,
     /*   11894 */   // Label 305: @11894
     /*   11894 */   GIM_Reject,
     /*   11895 */ // Label 198: @11895
     /*   11895 */ GIM_Reject,
     /*   11896 */ // Label 128: @11896
     /*   11896 */ GIM_Try, /*On fail goto*//*Label 306*/ GIMT_Encode4(12290),
     /*   11901 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   11904 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s8,
     /*   11907 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   11911 */   GIM_Try, /*On fail goto*//*Label 307*/ GIMT_Encode4(11979), // Rule ID 69389 //
     /*   11916 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   11919 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   11923 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   11927 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   11931 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s8,
     /*   11935 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   11937 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   11942 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   11947 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   11951 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   11953 */     // (add:{ *:[nxv1i8] } (mul:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rd)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVMADD_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rd, VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   11953 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF8),
     /*   11956 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   11958 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   11962 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   11966 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   11968 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   11971 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   11974 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   11977 */     GIR_RootConstrainSelectedInstOperands,
     /*   11978 */     // GIR_Coverage, 69389,
     /*   11978 */     GIR_EraseRootFromParent_Done,
     /*   11979 */   // Label 307: @11979
     /*   11979 */   GIM_Try, /*On fail goto*//*Label 308*/ GIMT_Encode4(12047), // Rule ID 69390 //
     /*   11984 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   11987 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   11991 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   11995 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   11999 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s8,
     /*   12003 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   12005 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12010 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12015 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12019 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   12021 */     // (add:{ *:[nxv1i8] } (mul:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rd)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVMADD_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rd, VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   12021 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF8),
     /*   12024 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   12026 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   12030 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   12034 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   12036 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   12039 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   12042 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   12045 */     GIR_RootConstrainSelectedInstOperands,
     /*   12046 */     // GIR_Coverage, 69390,
     /*   12046 */     GIR_EraseRootFromParent_Done,
     /*   12047 */   // Label 308: @12047
     /*   12047 */   GIM_Try, /*On fail goto*//*Label 309*/ GIMT_Encode4(12115), // Rule ID 45922 //
     /*   12052 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   12055 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12059 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   12063 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   12067 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   12071 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s8,
     /*   12075 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   12077 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12082 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12087 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   12089 */     // (add:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs2, (mul:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rd)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVMADD_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rd, VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   12089 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF8),
     /*   12092 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   12094 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   12098 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   12102 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   12104 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   12107 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   12110 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   12113 */     GIR_RootConstrainSelectedInstOperands,
     /*   12114 */     // GIR_Coverage, 45922,
     /*   12114 */     GIR_EraseRootFromParent_Done,
     /*   12115 */   // Label 309: @12115
     /*   12115 */   GIM_Try, /*On fail goto*//*Label 310*/ GIMT_Encode4(12183), // Rule ID 45923 //
     /*   12120 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   12123 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12127 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   12131 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   12135 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   12139 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s8,
     /*   12143 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   12145 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12150 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12155 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   12157 */     // (add:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs2, (mul:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rd)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVMADD_VV_MF8:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rd, VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   12157 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF8),
     /*   12160 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   12162 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   12166 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   12170 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   12172 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   12175 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   12178 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   12181 */     GIR_RootConstrainSelectedInstOperands,
     /*   12182 */     // GIR_Coverage, 45923,
     /*   12182 */     GIR_EraseRootFromParent_Done,
     /*   12183 */   // Label 310: @12183
     /*   12183 */   GIM_Try, /*On fail goto*//*Label 311*/ GIMT_Encode4(12236), // Rule ID 45750 //
     /*   12188 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   12191 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12195 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12199 */     // (add:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVADD_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
     /*   12199 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
     /*   12202 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   12206 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   12211 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   12213 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF8),
     /*   12216 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   12218 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   12221 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*   12223 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   12225 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   12228 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   12231 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   12234 */     GIR_RootConstrainSelectedInstOperands,
     /*   12235 */     // GIR_Coverage, 45750,
     /*   12235 */     GIR_EraseRootFromParent_Done,
     /*   12236 */   // Label 311: @12236
     /*   12236 */   GIM_Try, /*On fail goto*//*Label 312*/ GIMT_Encode4(12289), // Rule ID 45751 //
     /*   12241 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   12244 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12248 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12252 */     // (add:{ *:[nxv1i8] } VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2)  =>  (PseudoVADD_VV_MF8:{ *:[nxv1i8] } (IMPLICIT_DEF:{ *:[nxv1i8] }), VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
     /*   12252 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s8,
     /*   12255 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   12259 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   12264 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   12266 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF8),
     /*   12269 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   12271 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   12274 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*   12276 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   12278 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   12281 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   12284 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   12287 */     GIR_RootConstrainSelectedInstOperands,
     /*   12288 */     // GIR_Coverage, 45751,
     /*   12288 */     GIR_EraseRootFromParent_Done,
     /*   12289 */   // Label 312: @12289
     /*   12289 */   GIM_Reject,
     /*   12290 */ // Label 306: @12290
     /*   12290 */ GIM_Reject,
     /*   12291 */ // Label 129: @12291
     /*   12291 */ GIM_Try, /*On fail goto*//*Label 313*/ GIMT_Encode4(15415),
     /*   12296 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   12299 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s16,
     /*   12302 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12306 */   GIM_Try, /*On fail goto*//*Label 314*/ GIMT_Encode4(12402), // Rule ID 69303 //
     /*   12311 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   12314 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   12318 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   12322 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   12326 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s16,
     /*   12330 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   12332 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   12336 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   12340 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   12344 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   12346 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12351 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   12355 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   12359 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   12363 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   12365 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12370 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12374 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   12376 */     // (add:{ *:[nxv1i16] } (mul:{ *:[nxv1i16] } (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i16] }:$rd)  =>  (PseudoVWMACC_VV_MF8:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   12376 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_MF8),
     /*   12379 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   12381 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   12383 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   12387 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   12391 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   12394 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   12397 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   12400 */     GIR_RootConstrainSelectedInstOperands,
     /*   12401 */     // GIR_Coverage, 69303,
     /*   12401 */     GIR_EraseRootFromParent_Done,
     /*   12402 */   // Label 314: @12402
     /*   12402 */   GIM_Try, /*On fail goto*//*Label 315*/ GIMT_Encode4(12498), // Rule ID 69304 //
     /*   12407 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   12410 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   12414 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   12418 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   12422 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s16,
     /*   12426 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   12428 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   12432 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   12436 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   12440 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   12442 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12447 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   12451 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   12455 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   12459 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   12461 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12466 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12470 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   12472 */     // (add:{ *:[nxv1i16] } (mul:{ *:[nxv1i16] } (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i16] }:$rd)  =>  (PseudoVWMACC_VV_MF8:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   12472 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_MF8),
     /*   12475 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   12477 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   12479 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   12483 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   12487 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   12490 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   12493 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   12496 */     GIR_RootConstrainSelectedInstOperands,
     /*   12497 */     // GIR_Coverage, 69304,
     /*   12497 */     GIR_EraseRootFromParent_Done,
     /*   12498 */   // Label 315: @12498
     /*   12498 */   GIM_Try, /*On fail goto*//*Label 316*/ GIMT_Encode4(12594), // Rule ID 71129 //
     /*   12503 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   12506 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   12510 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   12514 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   12518 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s16,
     /*   12522 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   12524 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   12528 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   12532 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   12536 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   12538 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12543 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   12547 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   12551 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   12555 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   12557 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12562 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12566 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   12568 */     // (add:{ *:[nxv1i16] } (mul:{ *:[nxv1i16] } (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i16] }:$rd)  =>  (PseudoVWMACCSU_VV_MF8:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   12568 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF8),
     /*   12571 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   12573 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   12575 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   12579 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   12583 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   12586 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   12589 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   12592 */     GIR_RootConstrainSelectedInstOperands,
     /*   12593 */     // GIR_Coverage, 71129,
     /*   12593 */     GIR_EraseRootFromParent_Done,
     /*   12594 */   // Label 316: @12594
     /*   12594 */   GIM_Try, /*On fail goto*//*Label 317*/ GIMT_Encode4(12690), // Rule ID 71130 //
     /*   12599 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   12602 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   12606 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   12610 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   12614 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s16,
     /*   12618 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   12620 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   12624 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   12628 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   12632 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   12634 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12639 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   12643 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   12647 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   12651 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   12653 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12658 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12662 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   12664 */     // (add:{ *:[nxv1i16] } (mul:{ *:[nxv1i16] } (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i16] }:$rd)  =>  (PseudoVWMACCSU_VV_MF8:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   12664 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF8),
     /*   12667 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   12669 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   12671 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   12675 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   12679 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   12682 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   12685 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   12688 */     GIR_RootConstrainSelectedInstOperands,
     /*   12689 */     // GIR_Coverage, 71130,
     /*   12689 */     GIR_EraseRootFromParent_Done,
     /*   12690 */   // Label 317: @12690
     /*   12690 */   GIM_Try, /*On fail goto*//*Label 318*/ GIMT_Encode4(12786), // Rule ID 71131 //
     /*   12695 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   12698 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   12702 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   12706 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   12710 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s16,
     /*   12714 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   12716 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   12720 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   12724 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   12728 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   12730 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12735 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   12739 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   12743 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   12747 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   12749 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12754 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12758 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   12760 */     // (add:{ *:[nxv1i16] } (mul:{ *:[nxv1i16] } (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i16] }:$rd)  =>  (PseudoVWMACCSU_VV_MF8:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   12760 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF8),
     /*   12763 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   12765 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   12767 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   12771 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   12775 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   12778 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   12781 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   12784 */     GIR_RootConstrainSelectedInstOperands,
     /*   12785 */     // GIR_Coverage, 71131,
     /*   12785 */     GIR_EraseRootFromParent_Done,
     /*   12786 */   // Label 318: @12786
     /*   12786 */   GIM_Try, /*On fail goto*//*Label 319*/ GIMT_Encode4(12882), // Rule ID 71132 //
     /*   12791 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   12794 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   12798 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   12802 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   12806 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s16,
     /*   12810 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   12812 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   12816 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   12820 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   12824 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   12826 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12831 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   12835 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   12839 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   12843 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   12845 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12850 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12854 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   12856 */     // (add:{ *:[nxv1i16] } (mul:{ *:[nxv1i16] } (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i16] }:$rd)  =>  (PseudoVWMACCSU_VV_MF8:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   12856 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF8),
     /*   12859 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   12861 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   12863 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   12867 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   12871 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   12874 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   12877 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   12880 */     GIR_RootConstrainSelectedInstOperands,
     /*   12881 */     // GIR_Coverage, 71132,
     /*   12881 */     GIR_EraseRootFromParent_Done,
     /*   12882 */   // Label 319: @12882
     /*   12882 */   GIM_Try, /*On fail goto*//*Label 320*/ GIMT_Encode4(12978), // Rule ID 71007 //
     /*   12887 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   12890 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   12894 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   12898 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   12902 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s16,
     /*   12906 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   12908 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   12912 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   12916 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   12920 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   12922 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12927 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   12931 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   12935 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   12939 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   12941 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12946 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   12950 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   12952 */     // (add:{ *:[nxv1i16] } (mul:{ *:[nxv1i16] } (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i16] }:$rd)  =>  (PseudoVWMACCU_VV_MF8:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   12952 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_MF8),
     /*   12955 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   12957 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   12959 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   12963 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   12967 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   12970 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   12973 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   12976 */     GIR_RootConstrainSelectedInstOperands,
     /*   12977 */     // GIR_Coverage, 71007,
     /*   12977 */     GIR_EraseRootFromParent_Done,
     /*   12978 */   // Label 320: @12978
     /*   12978 */   GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(13074), // Rule ID 71008 //
     /*   12983 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   12986 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   12990 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   12994 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   12998 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s16,
     /*   13002 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   13004 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   13008 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   13012 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   13016 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   13018 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13023 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   13027 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   13031 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   13035 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   13037 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13042 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13046 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   13048 */     // (add:{ *:[nxv1i16] } (mul:{ *:[nxv1i16] } (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i16] }:$rd)  =>  (PseudoVWMACCU_VV_MF8:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   13048 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_MF8),
     /*   13051 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   13053 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   13055 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   13059 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   13063 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   13066 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   13069 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   13072 */     GIR_RootConstrainSelectedInstOperands,
     /*   13073 */     // GIR_Coverage, 71008,
     /*   13073 */     GIR_EraseRootFromParent_Done,
     /*   13074 */   // Label 321: @13074
     /*   13074 */   GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(13170), // Rule ID 45834 //
     /*   13079 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   13082 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13086 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   13090 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   13094 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   13098 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s16,
     /*   13102 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   13104 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   13108 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   13112 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   13116 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   13118 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13123 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   13127 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   13131 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   13135 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   13137 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13142 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   13144 */     // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, (mul:{ *:[nxv1i16] } (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACC_VV_MF8:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   13144 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_MF8),
     /*   13147 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   13149 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   13151 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   13155 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   13159 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   13162 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   13165 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   13168 */     GIR_RootConstrainSelectedInstOperands,
     /*   13169 */     // GIR_Coverage, 45834,
     /*   13169 */     GIR_EraseRootFromParent_Done,
     /*   13170 */   // Label 322: @13170
     /*   13170 */   GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(13266), // Rule ID 45835 //
     /*   13175 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   13178 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13182 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   13186 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   13190 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   13194 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s16,
     /*   13198 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   13200 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   13204 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   13208 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   13212 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   13214 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13219 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   13223 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   13227 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   13231 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   13233 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13238 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   13240 */     // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, (mul:{ *:[nxv1i16] } (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACC_VV_MF8:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   13240 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_MF8),
     /*   13243 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   13245 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   13247 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   13251 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   13255 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   13258 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   13261 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   13264 */     GIR_RootConstrainSelectedInstOperands,
     /*   13265 */     // GIR_Coverage, 45835,
     /*   13265 */     GIR_EraseRootFromParent_Done,
     /*   13266 */   // Label 323: @13266
     /*   13266 */   GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(13362), // Rule ID 52154 //
     /*   13271 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   13274 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13278 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   13282 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   13286 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   13290 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s16,
     /*   13294 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   13296 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   13300 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   13304 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   13308 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   13310 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13315 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   13319 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   13323 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   13327 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   13329 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13334 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   13336 */     // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, (mul:{ *:[nxv1i16] } (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_MF8:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   13336 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF8),
     /*   13339 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   13341 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   13343 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   13347 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   13351 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   13354 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   13357 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   13360 */     GIR_RootConstrainSelectedInstOperands,
     /*   13361 */     // GIR_Coverage, 52154,
     /*   13361 */     GIR_EraseRootFromParent_Done,
     /*   13362 */   // Label 324: @13362
     /*   13362 */   GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(13458), // Rule ID 52155 //
     /*   13367 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   13370 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13374 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   13378 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   13382 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   13386 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s16,
     /*   13390 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   13392 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   13396 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   13400 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   13404 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   13406 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13411 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   13415 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   13419 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   13423 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   13425 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13430 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   13432 */     // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, (mul:{ *:[nxv1i16] } (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_MF8:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   13432 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF8),
     /*   13435 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   13437 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   13439 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   13443 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   13447 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   13450 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   13453 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   13456 */     GIR_RootConstrainSelectedInstOperands,
     /*   13457 */     // GIR_Coverage, 52155,
     /*   13457 */     GIR_EraseRootFromParent_Done,
     /*   13458 */   // Label 325: @13458
     /*   13458 */   GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(13554), // Rule ID 71127 //
     /*   13463 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   13466 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13470 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   13474 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   13478 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   13482 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s16,
     /*   13486 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   13488 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   13492 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   13496 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   13500 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   13502 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13507 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   13511 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   13515 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   13519 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   13521 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13526 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   13528 */     // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, (mul:{ *:[nxv1i16] } (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_MF8:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   13528 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF8),
     /*   13531 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   13533 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   13535 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   13539 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   13543 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   13546 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   13549 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   13552 */     GIR_RootConstrainSelectedInstOperands,
     /*   13553 */     // GIR_Coverage, 71127,
     /*   13553 */     GIR_EraseRootFromParent_Done,
     /*   13554 */   // Label 326: @13554
     /*   13554 */   GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(13650), // Rule ID 71128 //
     /*   13559 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   13562 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13566 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   13570 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   13574 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   13578 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s16,
     /*   13582 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   13584 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   13588 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   13592 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   13596 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   13598 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13603 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   13607 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   13611 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   13615 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   13617 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13622 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   13624 */     // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, (mul:{ *:[nxv1i16] } (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_MF8:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   13624 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF8),
     /*   13627 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   13629 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   13631 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   13635 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   13639 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   13642 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   13645 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   13648 */     GIR_RootConstrainSelectedInstOperands,
     /*   13649 */     // GIR_Coverage, 71128,
     /*   13649 */     GIR_EraseRootFromParent_Done,
     /*   13650 */   // Label 327: @13650
     /*   13650 */   GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(13746), // Rule ID 52094 //
     /*   13655 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   13658 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13662 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   13666 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   13670 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   13674 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s16,
     /*   13678 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   13680 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   13684 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   13688 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   13692 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   13694 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13699 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   13703 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   13707 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   13711 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   13713 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13718 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   13720 */     // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, (mul:{ *:[nxv1i16] } (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCU_VV_MF8:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   13720 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_MF8),
     /*   13723 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   13725 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   13727 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   13731 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   13735 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   13738 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   13741 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   13744 */     GIR_RootConstrainSelectedInstOperands,
     /*   13745 */     // GIR_Coverage, 52094,
     /*   13745 */     GIR_EraseRootFromParent_Done,
     /*   13746 */   // Label 328: @13746
     /*   13746 */   GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(13842), // Rule ID 52095 //
     /*   13751 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   13754 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13758 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   13762 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   13766 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   13770 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s16,
     /*   13774 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   13776 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   13780 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   13784 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   13788 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   13790 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13795 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   13799 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   13803 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   13807 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   13809 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13814 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   13816 */     // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, (mul:{ *:[nxv1i16] } (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCU_VV_MF8:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, VR:{ *:[nxv1i8] }:$rs1, VR:{ *:[nxv1i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   13816 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_MF8),
     /*   13819 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   13821 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   13823 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   13827 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   13831 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   13834 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   13837 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   13840 */     GIR_RootConstrainSelectedInstOperands,
     /*   13841 */     // GIR_Coverage, 52095,
     /*   13841 */     GIR_EraseRootFromParent_Done,
     /*   13842 */   // Label 329: @13842
     /*   13842 */   GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(13931), // Rule ID 46680 //
     /*   13847 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   13850 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   13854 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   13858 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   13862 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   13864 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13869 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   13873 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   13877 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   13881 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   13883 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13888 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   13890 */     // (add:{ *:[nxv1i16] } (anyext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs2)<<P:Predicate_anyext_oneuse>>, (anyext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_VV_MF8:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i8] }:$rs2, VR:{ *:[nxv1i8] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
     /*   13890 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
     /*   13893 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   13897 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   13902 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   13904 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_MF8),
     /*   13907 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   13909 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   13912 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   13916 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   13920 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   13923 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   13926 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   13929 */     GIR_RootConstrainSelectedInstOperands,
     /*   13930 */     // GIR_Coverage, 46680,
     /*   13930 */     GIR_EraseRootFromParent_Done,
     /*   13931 */   // Label 330: @13931
     /*   13931 */   GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(14020), // Rule ID 46681 //
     /*   13936 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   13939 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   13943 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   13947 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   13951 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   13953 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13958 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   13962 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   13966 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   13970 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   13972 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   13977 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   13979 */     // (add:{ *:[nxv1i16] } (anyext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs2)<<P:Predicate_anyext_oneuse>>, (anyext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_VV_MF8:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i8] }:$rs2, VR:{ *:[nxv1i8] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
     /*   13979 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
     /*   13982 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   13986 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   13991 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   13993 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_MF8),
     /*   13996 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   13998 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   14001 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   14005 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   14009 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   14012 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   14015 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   14018 */     GIR_RootConstrainSelectedInstOperands,
     /*   14019 */     // GIR_Coverage, 46681,
     /*   14019 */     GIR_EraseRootFromParent_Done,
     /*   14020 */   // Label 331: @14020
     /*   14020 */   GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(14109), // Rule ID 45826 //
     /*   14025 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   14028 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   14032 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   14036 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   14040 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   14042 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14047 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   14051 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   14055 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   14059 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   14061 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14066 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   14068 */     // (add:{ *:[nxv1i16] } (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs2)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_VV_MF8:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i8] }:$rs2, VR:{ *:[nxv1i8] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
     /*   14068 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
     /*   14071 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   14075 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   14080 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   14082 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_VV_MF8),
     /*   14085 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   14087 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   14090 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   14094 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   14098 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   14101 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   14104 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   14107 */     GIR_RootConstrainSelectedInstOperands,
     /*   14108 */     // GIR_Coverage, 45826,
     /*   14108 */     GIR_EraseRootFromParent_Done,
     /*   14109 */   // Label 332: @14109
     /*   14109 */   GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(14198), // Rule ID 45827 //
     /*   14114 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   14117 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   14121 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   14125 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   14129 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   14131 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14136 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   14140 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   14144 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   14148 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   14150 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14155 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   14157 */     // (add:{ *:[nxv1i16] } (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs2)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_VV_MF8:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i8] }:$rs2, VR:{ *:[nxv1i8] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
     /*   14157 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
     /*   14160 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   14164 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   14169 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   14171 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_VV_MF8),
     /*   14174 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   14176 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   14179 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   14183 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   14187 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   14190 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   14193 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   14196 */     GIR_RootConstrainSelectedInstOperands,
     /*   14197 */     // GIR_Coverage, 45827,
     /*   14197 */     GIR_EraseRootFromParent_Done,
     /*   14198 */   // Label 333: @14198
     /*   14198 */   GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(14287), // Rule ID 46560 //
     /*   14203 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   14206 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   14210 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   14214 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   14218 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   14220 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14225 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   14229 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   14233 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   14237 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   14239 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14244 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   14246 */     // (add:{ *:[nxv1i16] } (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs2)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_VV_MF8:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i8] }:$rs2, VR:{ *:[nxv1i8] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
     /*   14246 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
     /*   14249 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   14253 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   14258 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   14260 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_MF8),
     /*   14263 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   14265 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   14268 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   14272 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   14276 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   14279 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   14282 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   14285 */     GIR_RootConstrainSelectedInstOperands,
     /*   14286 */     // GIR_Coverage, 46560,
     /*   14286 */     GIR_EraseRootFromParent_Done,
     /*   14287 */   // Label 334: @14287
     /*   14287 */   GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(14376), // Rule ID 46561 //
     /*   14292 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   14295 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   14299 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   14303 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   14307 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   14309 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14314 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   14318 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   14322 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   14326 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   14328 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14333 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   14335 */     // (add:{ *:[nxv1i16] } (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs2)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_VV_MF8:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i8] }:$rs2, VR:{ *:[nxv1i8] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
     /*   14335 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
     /*   14338 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   14342 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   14347 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   14349 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_MF8),
     /*   14352 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   14354 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   14357 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   14361 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   14365 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   14368 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   14371 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   14374 */     GIR_RootConstrainSelectedInstOperands,
     /*   14375 */     // GIR_Coverage, 46561,
     /*   14375 */     GIR_EraseRootFromParent_Done,
     /*   14376 */   // Label 335: @14376
     /*   14376 */   GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(14444), // Rule ID 70699 //
     /*   14381 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   14384 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   14388 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   14392 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   14396 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s16,
     /*   14400 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   14402 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14407 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14412 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14416 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   14418 */     // (add:{ *:[nxv1i16] } (mul:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rd)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVMADD_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   14418 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF4),
     /*   14421 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   14423 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   14427 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   14431 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   14433 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   14436 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   14439 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   14442 */     GIR_RootConstrainSelectedInstOperands,
     /*   14443 */     // GIR_Coverage, 70699,
     /*   14443 */     GIR_EraseRootFromParent_Done,
     /*   14444 */   // Label 336: @14444
     /*   14444 */   GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(14512), // Rule ID 70700 //
     /*   14449 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   14452 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   14456 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   14460 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   14464 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s16,
     /*   14468 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   14470 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14475 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14480 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14484 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   14486 */     // (add:{ *:[nxv1i16] } (mul:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rd)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVMADD_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   14486 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF4),
     /*   14489 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   14491 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   14495 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   14499 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   14501 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   14504 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   14507 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   14510 */     GIR_RootConstrainSelectedInstOperands,
     /*   14511 */     // GIR_Coverage, 70700,
     /*   14511 */     GIR_EraseRootFromParent_Done,
     /*   14512 */   // Label 337: @14512
     /*   14512 */   GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(14567), // Rule ID 69691 //
     /*   14517 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   14520 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   14524 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   14528 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   14532 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   14534 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14539 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14543 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   14545 */     // (add:{ *:[nxv1i16] } (anyext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_anyext_oneuse>>, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVWADDU_WV_MF8_TIED:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs2, VR:{ *:[nxv1i8] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   14545 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF8_TIED),
     /*   14548 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   14550 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   14552 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   14556 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   14559 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   14562 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   14565 */     GIR_RootConstrainSelectedInstOperands,
     /*   14566 */     // GIR_Coverage, 69691,
     /*   14566 */     GIR_EraseRootFromParent_Done,
     /*   14567 */   // Label 338: @14567
     /*   14567 */   GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(14622), // Rule ID 69692 //
     /*   14572 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   14575 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   14579 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   14583 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   14587 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   14589 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14594 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14598 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   14600 */     // (add:{ *:[nxv1i16] } (anyext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_anyext_oneuse>>, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVWADDU_WV_MF8_TIED:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs2, VR:{ *:[nxv1i8] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   14600 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF8_TIED),
     /*   14603 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   14605 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   14607 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   14611 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   14614 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   14617 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   14620 */     GIR_RootConstrainSelectedInstOperands,
     /*   14621 */     // GIR_Coverage, 69692,
     /*   14621 */     GIR_EraseRootFromParent_Done,
     /*   14622 */   // Label 339: @14622
     /*   14622 */   GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(14677), // Rule ID 69299 //
     /*   14627 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   14630 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   14634 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   14638 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   14642 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   14644 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14649 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14653 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   14655 */     // (add:{ *:[nxv1i16] } (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_sext_oneuse>>, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVWADD_WV_MF8_TIED:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs2, VR:{ *:[nxv1i8] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   14655 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_MF8_TIED),
     /*   14658 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   14660 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   14662 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   14666 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   14669 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   14672 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   14675 */     GIR_RootConstrainSelectedInstOperands,
     /*   14676 */     // GIR_Coverage, 69299,
     /*   14676 */     GIR_EraseRootFromParent_Done,
     /*   14677 */   // Label 340: @14677
     /*   14677 */   GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(14732), // Rule ID 69300 //
     /*   14682 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   14685 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   14689 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   14693 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   14697 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   14699 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14704 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14708 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   14710 */     // (add:{ *:[nxv1i16] } (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_sext_oneuse>>, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVWADD_WV_MF8_TIED:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs2, VR:{ *:[nxv1i8] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   14710 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_MF8_TIED),
     /*   14713 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   14715 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   14717 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   14721 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   14724 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   14727 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   14730 */     GIR_RootConstrainSelectedInstOperands,
     /*   14731 */     // GIR_Coverage, 69300,
     /*   14731 */     GIR_EraseRootFromParent_Done,
     /*   14732 */   // Label 341: @14732
     /*   14732 */   GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(14787), // Rule ID 69601 //
     /*   14737 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   14740 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   14744 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   14748 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   14752 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   14754 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14759 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14763 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   14765 */     // (add:{ *:[nxv1i16] } (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_zext_oneuse>>, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVWADDU_WV_MF8_TIED:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs2, VR:{ *:[nxv1i8] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   14765 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF8_TIED),
     /*   14768 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   14770 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   14772 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   14776 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   14779 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   14782 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   14785 */     GIR_RootConstrainSelectedInstOperands,
     /*   14786 */     // GIR_Coverage, 69601,
     /*   14786 */     GIR_EraseRootFromParent_Done,
     /*   14787 */   // Label 342: @14787
     /*   14787 */   GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(14842), // Rule ID 69602 //
     /*   14792 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   14795 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   14799 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   14803 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   14807 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   14809 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14814 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14818 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   14820 */     // (add:{ *:[nxv1i16] } (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_zext_oneuse>>, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVWADDU_WV_MF8_TIED:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs2, VR:{ *:[nxv1i8] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   14820 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF8_TIED),
     /*   14823 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   14825 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   14827 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   14831 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   14834 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   14837 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   14840 */     GIR_RootConstrainSelectedInstOperands,
     /*   14841 */     // GIR_Coverage, 69602,
     /*   14841 */     GIR_EraseRootFromParent_Done,
     /*   14842 */   // Label 343: @14842
     /*   14842 */   GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(14910), // Rule ID 51874 //
     /*   14847 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   14850 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14854 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   14858 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   14862 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   14866 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s16,
     /*   14870 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   14872 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14877 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14882 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   14884 */     // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs2, (mul:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rd)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVMADD_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   14884 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF4),
     /*   14887 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   14889 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   14893 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   14897 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   14899 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   14902 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   14905 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   14908 */     GIR_RootConstrainSelectedInstOperands,
     /*   14909 */     // GIR_Coverage, 51874,
     /*   14909 */     GIR_EraseRootFromParent_Done,
     /*   14910 */   // Label 344: @14910
     /*   14910 */   GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(14978), // Rule ID 51875 //
     /*   14915 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   14918 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14922 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   14926 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   14930 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   14934 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s16,
     /*   14938 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   14940 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14945 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14950 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   14952 */     // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs2, (mul:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rd)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVMADD_VV_MF4:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rd, VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   14952 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF4),
     /*   14955 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   14957 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   14961 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   14965 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   14967 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   14970 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   14973 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   14976 */     GIR_RootConstrainSelectedInstOperands,
     /*   14977 */     // GIR_Coverage, 51875,
     /*   14977 */     GIR_EraseRootFromParent_Done,
     /*   14978 */   // Label 345: @14978
     /*   14978 */   GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(15033), // Rule ID 46740 //
     /*   14983 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   14986 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   14990 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   14994 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   14998 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   15002 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   15004 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15009 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   15011 */     // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs2, (anyext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_WV_MF8_TIED:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs2, VR:{ *:[nxv1i8] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   15011 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF8_TIED),
     /*   15014 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   15016 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   15018 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   15022 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   15025 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   15028 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   15031 */     GIR_RootConstrainSelectedInstOperands,
     /*   15032 */     // GIR_Coverage, 46740,
     /*   15032 */     GIR_EraseRootFromParent_Done,
     /*   15033 */   // Label 346: @15033
     /*   15033 */   GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(15088), // Rule ID 46741 //
     /*   15038 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   15041 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15045 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   15049 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   15053 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   15057 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   15059 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15064 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   15066 */     // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs2, (anyext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_WV_MF8_TIED:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs2, VR:{ *:[nxv1i8] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   15066 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF8_TIED),
     /*   15069 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   15071 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   15073 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   15077 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   15080 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   15083 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   15086 */     GIR_RootConstrainSelectedInstOperands,
     /*   15087 */     // GIR_Coverage, 46741,
     /*   15087 */     GIR_EraseRootFromParent_Done,
     /*   15088 */   // Label 347: @15088
     /*   15088 */   GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(15143), // Rule ID 45830 //
     /*   15093 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   15096 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15100 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   15104 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   15108 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   15112 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   15114 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15119 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   15121 */     // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs2, (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_WV_MF8_TIED:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs2, VR:{ *:[nxv1i8] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   15121 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_MF8_TIED),
     /*   15124 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   15126 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   15128 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   15132 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   15135 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   15138 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   15141 */     GIR_RootConstrainSelectedInstOperands,
     /*   15142 */     // GIR_Coverage, 45830,
     /*   15142 */     GIR_EraseRootFromParent_Done,
     /*   15143 */   // Label 348: @15143
     /*   15143 */   GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(15198), // Rule ID 45831 //
     /*   15148 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   15151 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15155 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   15159 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   15163 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   15167 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   15169 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15174 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   15176 */     // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs2, (sext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_WV_MF8_TIED:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs2, VR:{ *:[nxv1i8] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   15176 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_MF8_TIED),
     /*   15179 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   15181 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   15183 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   15187 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   15190 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   15193 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   15196 */     GIR_RootConstrainSelectedInstOperands,
     /*   15197 */     // GIR_Coverage, 45831,
     /*   15197 */     GIR_EraseRootFromParent_Done,
     /*   15198 */   // Label 349: @15198
     /*   15198 */   GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(15253), // Rule ID 46620 //
     /*   15203 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   15206 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15210 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   15214 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   15218 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   15222 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   15224 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15229 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   15231 */     // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs2, (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_WV_MF8_TIED:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs2, VR:{ *:[nxv1i8] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   15231 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF8_TIED),
     /*   15234 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   15236 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   15238 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   15242 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   15245 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   15248 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   15251 */     GIR_RootConstrainSelectedInstOperands,
     /*   15252 */     // GIR_Coverage, 46620,
     /*   15252 */     GIR_EraseRootFromParent_Done,
     /*   15253 */   // Label 350: @15253
     /*   15253 */   GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(15308), // Rule ID 46621 //
     /*   15258 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   15261 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15265 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   15269 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   15273 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s8,
     /*   15277 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   15279 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15284 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   15286 */     // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs2, (zext:{ *:[nxv1i16] } VR:{ *:[nxv1i8] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_WV_MF8_TIED:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs2, VR:{ *:[nxv1i8] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   15286 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF8_TIED),
     /*   15289 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   15291 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   15293 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   15297 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   15300 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   15303 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   15306 */     GIR_RootConstrainSelectedInstOperands,
     /*   15307 */     // GIR_Coverage, 46621,
     /*   15307 */     GIR_EraseRootFromParent_Done,
     /*   15308 */   // Label 351: @15308
     /*   15308 */   GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(15361), // Rule ID 46106 //
     /*   15313 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   15316 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15320 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15324 */     // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
     /*   15324 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
     /*   15327 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   15331 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   15336 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   15338 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF4),
     /*   15341 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   15343 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   15346 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*   15348 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   15350 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   15353 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   15356 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   15359 */     GIR_RootConstrainSelectedInstOperands,
     /*   15360 */     // GIR_Coverage, 46106,
     /*   15360 */     GIR_EraseRootFromParent_Done,
     /*   15361 */   // Label 352: @15361
     /*   15361 */   GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(15414), // Rule ID 46107 //
     /*   15366 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   15369 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15373 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15377 */     // (add:{ *:[nxv1i16] } VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv1i16] } (IMPLICIT_DEF:{ *:[nxv1i16] }), VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
     /*   15377 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s16,
     /*   15380 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   15384 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   15389 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   15391 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF4),
     /*   15394 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   15396 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   15399 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*   15401 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   15403 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   15406 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   15409 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   15412 */     GIR_RootConstrainSelectedInstOperands,
     /*   15413 */     // GIR_Coverage, 46107,
     /*   15413 */     GIR_EraseRootFromParent_Done,
     /*   15414 */   // Label 353: @15414
     /*   15414 */   GIM_Reject,
     /*   15415 */ // Label 313: @15415
     /*   15415 */ GIM_Reject,
     /*   15416 */ // Label 130: @15416
     /*   15416 */ GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(18540),
     /*   15421 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   15424 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s32,
     /*   15427 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15431 */   GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(15527), // Rule ID 70905 //
     /*   15436 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   15439 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   15443 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   15447 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   15451 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s32,
     /*   15455 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   15457 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   15461 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   15465 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   15469 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   15471 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15476 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   15480 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   15484 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   15488 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   15490 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15495 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15499 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   15501 */     // (add:{ *:[nxv1i32] } (mul:{ *:[nxv1i32] } (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i32] }:$rd)  =>  (PseudoVWMACC_VV_MF4:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   15501 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_MF4),
     /*   15504 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   15506 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   15508 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   15512 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   15516 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   15519 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   15522 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   15525 */     GIR_RootConstrainSelectedInstOperands,
     /*   15526 */     // GIR_Coverage, 70905,
     /*   15526 */     GIR_EraseRootFromParent_Done,
     /*   15527 */   // Label 355: @15527
     /*   15527 */   GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(15623), // Rule ID 70906 //
     /*   15532 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   15535 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   15539 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   15543 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   15547 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s32,
     /*   15551 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   15553 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   15557 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   15561 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   15565 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   15567 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15572 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   15576 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   15580 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   15584 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   15586 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15591 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15595 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   15597 */     // (add:{ *:[nxv1i32] } (mul:{ *:[nxv1i32] } (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i32] }:$rd)  =>  (PseudoVWMACC_VV_MF4:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   15597 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_MF4),
     /*   15600 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   15602 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   15604 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   15608 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   15612 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   15615 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   15618 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   15621 */     GIR_RootConstrainSelectedInstOperands,
     /*   15622 */     // GIR_Coverage, 70906,
     /*   15622 */     GIR_EraseRootFromParent_Done,
     /*   15623 */   // Label 356: @15623
     /*   15623 */   GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(15719), // Rule ID 71165 //
     /*   15628 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   15631 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   15635 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   15639 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   15643 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s32,
     /*   15647 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   15649 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   15653 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   15657 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   15661 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   15663 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15668 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   15672 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   15676 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   15680 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   15682 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15687 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15691 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   15693 */     // (add:{ *:[nxv1i32] } (mul:{ *:[nxv1i32] } (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i32] }:$rd)  =>  (PseudoVWMACCSU_VV_MF4:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   15693 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF4),
     /*   15696 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   15698 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   15700 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   15704 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   15708 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   15711 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   15714 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   15717 */     GIR_RootConstrainSelectedInstOperands,
     /*   15718 */     // GIR_Coverage, 71165,
     /*   15718 */     GIR_EraseRootFromParent_Done,
     /*   15719 */   // Label 357: @15719
     /*   15719 */   GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(15815), // Rule ID 71166 //
     /*   15724 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   15727 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   15731 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   15735 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   15739 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s32,
     /*   15743 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   15745 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   15749 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   15753 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   15757 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   15759 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15764 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   15768 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   15772 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   15776 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   15778 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15783 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15787 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   15789 */     // (add:{ *:[nxv1i32] } (mul:{ *:[nxv1i32] } (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i32] }:$rd)  =>  (PseudoVWMACCSU_VV_MF4:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   15789 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF4),
     /*   15792 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   15794 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   15796 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   15800 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   15804 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   15807 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   15810 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   15813 */     GIR_RootConstrainSelectedInstOperands,
     /*   15814 */     // GIR_Coverage, 71166,
     /*   15814 */     GIR_EraseRootFromParent_Done,
     /*   15815 */   // Label 358: @15815
     /*   15815 */   GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(15911), // Rule ID 71167 //
     /*   15820 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   15823 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   15827 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   15831 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   15835 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s32,
     /*   15839 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   15841 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   15845 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   15849 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   15853 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   15855 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15860 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   15864 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   15868 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   15872 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   15874 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15879 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15883 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   15885 */     // (add:{ *:[nxv1i32] } (mul:{ *:[nxv1i32] } (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i32] }:$rd)  =>  (PseudoVWMACCSU_VV_MF4:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   15885 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF4),
     /*   15888 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   15890 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   15892 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   15896 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   15900 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   15903 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   15906 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   15909 */     GIR_RootConstrainSelectedInstOperands,
     /*   15910 */     // GIR_Coverage, 71167,
     /*   15910 */     GIR_EraseRootFromParent_Done,
     /*   15911 */   // Label 359: @15911
     /*   15911 */   GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(16007), // Rule ID 71168 //
     /*   15916 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   15919 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   15923 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   15927 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   15931 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s32,
     /*   15935 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   15937 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   15941 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   15945 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   15949 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   15951 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15956 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   15960 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   15964 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   15968 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   15970 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15975 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   15979 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   15981 */     // (add:{ *:[nxv1i32] } (mul:{ *:[nxv1i32] } (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i32] }:$rd)  =>  (PseudoVWMACCSU_VV_MF4:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   15981 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF4),
     /*   15984 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   15986 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   15988 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   15992 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   15996 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   15999 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   16002 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   16005 */     GIR_RootConstrainSelectedInstOperands,
     /*   16006 */     // GIR_Coverage, 71168,
     /*   16006 */     GIR_EraseRootFromParent_Done,
     /*   16007 */   // Label 360: @16007
     /*   16007 */   GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(16103), // Rule ID 71019 //
     /*   16012 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   16015 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   16019 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   16023 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   16027 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s32,
     /*   16031 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   16033 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   16037 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   16041 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   16045 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   16047 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16052 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   16056 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   16060 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   16064 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   16066 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16071 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16075 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   16077 */     // (add:{ *:[nxv1i32] } (mul:{ *:[nxv1i32] } (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i32] }:$rd)  =>  (PseudoVWMACCU_VV_MF4:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   16077 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_MF4),
     /*   16080 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   16082 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   16084 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   16088 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   16092 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   16095 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   16098 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   16101 */     GIR_RootConstrainSelectedInstOperands,
     /*   16102 */     // GIR_Coverage, 71019,
     /*   16102 */     GIR_EraseRootFromParent_Done,
     /*   16103 */   // Label 361: @16103
     /*   16103 */   GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(16199), // Rule ID 71020 //
     /*   16108 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   16111 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   16115 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   16119 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   16123 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s32,
     /*   16127 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   16129 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   16133 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   16137 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   16141 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   16143 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16148 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   16152 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   16156 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   16160 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   16162 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16167 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16171 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   16173 */     // (add:{ *:[nxv1i32] } (mul:{ *:[nxv1i32] } (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i32] }:$rd)  =>  (PseudoVWMACCU_VV_MF4:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   16173 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_MF4),
     /*   16176 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   16178 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   16180 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   16184 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   16188 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   16191 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   16194 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   16197 */     GIR_RootConstrainSelectedInstOperands,
     /*   16198 */     // GIR_Coverage, 71020,
     /*   16198 */     GIR_EraseRootFromParent_Done,
     /*   16199 */   // Label 362: @16199
     /*   16199 */   GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(16295), // Rule ID 52048 //
     /*   16204 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   16207 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16211 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   16215 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   16219 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   16223 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s32,
     /*   16227 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   16229 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   16233 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   16237 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   16241 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   16243 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16248 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   16252 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   16256 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   16260 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   16262 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16267 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   16269 */     // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, (mul:{ *:[nxv1i32] } (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACC_VV_MF4:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   16269 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_MF4),
     /*   16272 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   16274 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   16276 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   16280 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   16284 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   16287 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   16290 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   16293 */     GIR_RootConstrainSelectedInstOperands,
     /*   16294 */     // GIR_Coverage, 52048,
     /*   16294 */     GIR_EraseRootFromParent_Done,
     /*   16295 */   // Label 363: @16295
     /*   16295 */   GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(16391), // Rule ID 52049 //
     /*   16300 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   16303 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16307 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   16311 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   16315 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   16319 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s32,
     /*   16323 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   16325 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   16329 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   16333 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   16337 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   16339 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16344 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   16348 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   16352 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   16356 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   16358 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16363 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   16365 */     // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, (mul:{ *:[nxv1i32] } (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACC_VV_MF4:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   16365 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_MF4),
     /*   16368 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   16370 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   16372 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   16376 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   16380 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   16383 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   16386 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   16389 */     GIR_RootConstrainSelectedInstOperands,
     /*   16390 */     // GIR_Coverage, 52049,
     /*   16390 */     GIR_EraseRootFromParent_Done,
     /*   16391 */   // Label 364: @16391
     /*   16391 */   GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(16487), // Rule ID 52166 //
     /*   16396 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   16399 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16403 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   16407 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   16411 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   16415 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s32,
     /*   16419 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   16421 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   16425 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   16429 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   16433 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   16435 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16440 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   16444 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   16448 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   16452 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   16454 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16459 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   16461 */     // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, (mul:{ *:[nxv1i32] } (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_MF4:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   16461 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF4),
     /*   16464 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   16466 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   16468 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   16472 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   16476 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   16479 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   16482 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   16485 */     GIR_RootConstrainSelectedInstOperands,
     /*   16486 */     // GIR_Coverage, 52166,
     /*   16486 */     GIR_EraseRootFromParent_Done,
     /*   16487 */   // Label 365: @16487
     /*   16487 */   GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(16583), // Rule ID 52167 //
     /*   16492 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   16495 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16499 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   16503 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   16507 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   16511 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s32,
     /*   16515 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   16517 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   16521 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   16525 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   16529 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   16531 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16536 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   16540 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   16544 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   16548 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   16550 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16555 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   16557 */     // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, (mul:{ *:[nxv1i32] } (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_MF4:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   16557 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF4),
     /*   16560 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   16562 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   16564 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   16568 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   16572 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   16575 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   16578 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   16581 */     GIR_RootConstrainSelectedInstOperands,
     /*   16582 */     // GIR_Coverage, 52167,
     /*   16582 */     GIR_EraseRootFromParent_Done,
     /*   16583 */   // Label 366: @16583
     /*   16583 */   GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(16679), // Rule ID 71163 //
     /*   16588 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   16591 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16595 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   16599 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   16603 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   16607 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s32,
     /*   16611 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   16613 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   16617 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   16621 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   16625 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   16627 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16632 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   16636 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   16640 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   16644 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   16646 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16651 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   16653 */     // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, (mul:{ *:[nxv1i32] } (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_MF4:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   16653 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF4),
     /*   16656 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   16658 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   16660 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   16664 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   16668 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   16671 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   16674 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   16677 */     GIR_RootConstrainSelectedInstOperands,
     /*   16678 */     // GIR_Coverage, 71163,
     /*   16678 */     GIR_EraseRootFromParent_Done,
     /*   16679 */   // Label 367: @16679
     /*   16679 */   GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(16775), // Rule ID 71164 //
     /*   16684 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   16687 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16691 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   16695 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   16699 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   16703 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s32,
     /*   16707 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   16709 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   16713 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   16717 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   16721 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   16723 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16728 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   16732 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   16736 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   16740 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   16742 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16747 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   16749 */     // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, (mul:{ *:[nxv1i32] } (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_MF4:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   16749 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF4),
     /*   16752 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   16754 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   16756 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   16760 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   16764 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   16767 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   16770 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   16773 */     GIR_RootConstrainSelectedInstOperands,
     /*   16774 */     // GIR_Coverage, 71164,
     /*   16774 */     GIR_EraseRootFromParent_Done,
     /*   16775 */   // Label 368: @16775
     /*   16775 */   GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(16871), // Rule ID 52106 //
     /*   16780 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   16783 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16787 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   16791 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   16795 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   16799 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s32,
     /*   16803 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   16805 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   16809 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   16813 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   16817 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   16819 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16824 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   16828 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   16832 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   16836 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   16838 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16843 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   16845 */     // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, (mul:{ *:[nxv1i32] } (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCU_VV_MF4:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   16845 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_MF4),
     /*   16848 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   16850 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   16852 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   16856 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   16860 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   16863 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   16866 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   16869 */     GIR_RootConstrainSelectedInstOperands,
     /*   16870 */     // GIR_Coverage, 52106,
     /*   16870 */     GIR_EraseRootFromParent_Done,
     /*   16871 */   // Label 369: @16871
     /*   16871 */   GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(16967), // Rule ID 52107 //
     /*   16876 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   16879 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16883 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   16887 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   16891 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   16895 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s32,
     /*   16899 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   16901 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   16905 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   16909 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   16913 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   16915 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16920 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   16924 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   16928 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   16932 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   16934 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16939 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   16941 */     // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, (mul:{ *:[nxv1i32] } (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCU_VV_MF4:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, VR:{ *:[nxv1i16] }:$rs1, VR:{ *:[nxv1i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   16941 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_MF4),
     /*   16944 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   16946 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   16948 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   16952 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   16956 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   16959 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   16962 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   16965 */     GIR_RootConstrainSelectedInstOperands,
     /*   16966 */     // GIR_Coverage, 52107,
     /*   16966 */     GIR_EraseRootFromParent_Done,
     /*   16967 */   // Label 370: @16967
     /*   16967 */   GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(17056), // Rule ID 46704 //
     /*   16972 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   16975 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   16979 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   16983 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   16987 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   16989 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   16994 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   16998 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   17002 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   17006 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   17008 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17013 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   17015 */     // (add:{ *:[nxv1i32] } (anyext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs2)<<P:Predicate_anyext_oneuse>>, (anyext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_VV_MF4:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i16] }:$rs2, VR:{ *:[nxv1i16] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
     /*   17015 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
     /*   17018 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   17022 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   17027 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   17029 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_MF4),
     /*   17032 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   17034 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   17037 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   17041 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   17045 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   17048 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   17051 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   17054 */     GIR_RootConstrainSelectedInstOperands,
     /*   17055 */     // GIR_Coverage, 46704,
     /*   17055 */     GIR_EraseRootFromParent_Done,
     /*   17056 */   // Label 371: @17056
     /*   17056 */   GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(17145), // Rule ID 46705 //
     /*   17061 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   17064 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   17068 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   17072 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   17076 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   17078 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17083 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   17087 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   17091 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   17095 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   17097 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17102 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   17104 */     // (add:{ *:[nxv1i32] } (anyext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs2)<<P:Predicate_anyext_oneuse>>, (anyext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_VV_MF4:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i16] }:$rs2, VR:{ *:[nxv1i16] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
     /*   17104 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
     /*   17107 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   17111 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   17116 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   17118 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_MF4),
     /*   17121 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   17123 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   17126 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   17130 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   17134 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   17137 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   17140 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   17143 */     GIR_RootConstrainSelectedInstOperands,
     /*   17144 */     // GIR_Coverage, 46705,
     /*   17144 */     GIR_EraseRootFromParent_Done,
     /*   17145 */   // Label 372: @17145
     /*   17145 */   GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(17234), // Rule ID 46468 //
     /*   17150 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   17153 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   17157 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   17161 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   17165 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   17167 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17172 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   17176 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   17180 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   17184 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   17186 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17191 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   17193 */     // (add:{ *:[nxv1i32] } (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs2)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_VV_MF4:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i16] }:$rs2, VR:{ *:[nxv1i16] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
     /*   17193 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
     /*   17196 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   17200 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   17205 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   17207 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_VV_MF4),
     /*   17210 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   17212 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   17215 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   17219 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   17223 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   17226 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   17229 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   17232 */     GIR_RootConstrainSelectedInstOperands,
     /*   17233 */     // GIR_Coverage, 46468,
     /*   17233 */     GIR_EraseRootFromParent_Done,
     /*   17234 */   // Label 373: @17234
     /*   17234 */   GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(17323), // Rule ID 46469 //
     /*   17239 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   17242 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   17246 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   17250 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   17254 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   17256 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17261 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   17265 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   17269 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   17273 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   17275 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17280 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   17282 */     // (add:{ *:[nxv1i32] } (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs2)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_VV_MF4:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i16] }:$rs2, VR:{ *:[nxv1i16] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
     /*   17282 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
     /*   17285 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   17289 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   17294 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   17296 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_VV_MF4),
     /*   17299 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   17301 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   17304 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   17308 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   17312 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   17315 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   17318 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   17321 */     GIR_RootConstrainSelectedInstOperands,
     /*   17322 */     // GIR_Coverage, 46469,
     /*   17322 */     GIR_EraseRootFromParent_Done,
     /*   17323 */   // Label 374: @17323
     /*   17323 */   GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(17412), // Rule ID 46584 //
     /*   17328 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   17331 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   17335 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   17339 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   17343 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   17345 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17350 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   17354 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   17358 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   17362 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   17364 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17369 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   17371 */     // (add:{ *:[nxv1i32] } (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs2)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_VV_MF4:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i16] }:$rs2, VR:{ *:[nxv1i16] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
     /*   17371 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
     /*   17374 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   17378 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   17383 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   17385 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_MF4),
     /*   17388 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   17390 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   17393 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   17397 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   17401 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   17404 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   17407 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   17410 */     GIR_RootConstrainSelectedInstOperands,
     /*   17411 */     // GIR_Coverage, 46584,
     /*   17411 */     GIR_EraseRootFromParent_Done,
     /*   17412 */   // Label 375: @17412
     /*   17412 */   GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(17501), // Rule ID 46585 //
     /*   17417 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   17420 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   17424 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   17428 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   17432 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   17434 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17439 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   17443 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   17447 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   17451 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   17453 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17458 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   17460 */     // (add:{ *:[nxv1i32] } (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs2)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_VV_MF4:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i16] }:$rs2, VR:{ *:[nxv1i16] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
     /*   17460 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
     /*   17463 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   17467 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   17472 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   17474 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_MF4),
     /*   17477 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   17479 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   17482 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   17486 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   17490 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   17493 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   17496 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   17499 */     GIR_RootConstrainSelectedInstOperands,
     /*   17500 */     // GIR_Coverage, 46585,
     /*   17500 */     GIR_EraseRootFromParent_Done,
     /*   17501 */   // Label 376: @17501
     /*   17501 */   GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(17569), // Rule ID 70715 //
     /*   17506 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   17509 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   17513 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   17517 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   17521 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s32,
     /*   17525 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   17527 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17532 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17537 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17541 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   17543 */     // (add:{ *:[nxv1i32] } (mul:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rd)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVMADD_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   17543 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF2),
     /*   17546 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   17548 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   17552 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   17556 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   17558 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   17561 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   17564 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   17567 */     GIR_RootConstrainSelectedInstOperands,
     /*   17568 */     // GIR_Coverage, 70715,
     /*   17568 */     GIR_EraseRootFromParent_Done,
     /*   17569 */   // Label 377: @17569
     /*   17569 */   GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(17637), // Rule ID 70716 //
     /*   17574 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   17577 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   17581 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   17585 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   17589 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s32,
     /*   17593 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   17595 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17600 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17605 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17609 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   17611 */     // (add:{ *:[nxv1i32] } (mul:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rd)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVMADD_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   17611 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF2),
     /*   17614 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   17616 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   17620 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   17624 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   17626 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   17629 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   17632 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   17635 */     GIR_RootConstrainSelectedInstOperands,
     /*   17636 */     // GIR_Coverage, 70716,
     /*   17636 */     GIR_EraseRootFromParent_Done,
     /*   17637 */   // Label 378: @17637
     /*   17637 */   GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(17692), // Rule ID 69715 //
     /*   17642 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   17645 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   17649 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   17653 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   17657 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   17659 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17664 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17668 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   17670 */     // (add:{ *:[nxv1i32] } (anyext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_anyext_oneuse>>, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVWADDU_WV_MF4_TIED:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs2, VR:{ *:[nxv1i16] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   17670 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF4_TIED),
     /*   17673 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   17675 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   17677 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   17681 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   17684 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   17687 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   17690 */     GIR_RootConstrainSelectedInstOperands,
     /*   17691 */     // GIR_Coverage, 69715,
     /*   17691 */     GIR_EraseRootFromParent_Done,
     /*   17692 */   // Label 379: @17692
     /*   17692 */   GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(17747), // Rule ID 69716 //
     /*   17697 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   17700 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   17704 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   17708 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   17712 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   17714 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17719 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17723 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   17725 */     // (add:{ *:[nxv1i32] } (anyext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_anyext_oneuse>>, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVWADDU_WV_MF4_TIED:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs2, VR:{ *:[nxv1i16] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   17725 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF4_TIED),
     /*   17728 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   17730 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   17732 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   17736 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   17739 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   17742 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   17745 */     GIR_RootConstrainSelectedInstOperands,
     /*   17746 */     // GIR_Coverage, 69716,
     /*   17746 */     GIR_EraseRootFromParent_Done,
     /*   17747 */   // Label 380: @17747
     /*   17747 */   GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(17802), // Rule ID 69535 //
     /*   17752 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   17755 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   17759 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   17763 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   17767 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   17769 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17774 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17778 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   17780 */     // (add:{ *:[nxv1i32] } (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_sext_oneuse>>, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVWADD_WV_MF4_TIED:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs2, VR:{ *:[nxv1i16] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   17780 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_MF4_TIED),
     /*   17783 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   17785 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   17787 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   17791 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   17794 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   17797 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   17800 */     GIR_RootConstrainSelectedInstOperands,
     /*   17801 */     // GIR_Coverage, 69535,
     /*   17801 */     GIR_EraseRootFromParent_Done,
     /*   17802 */   // Label 381: @17802
     /*   17802 */   GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(17857), // Rule ID 69536 //
     /*   17807 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   17810 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   17814 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   17818 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   17822 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   17824 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17829 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17833 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   17835 */     // (add:{ *:[nxv1i32] } (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_sext_oneuse>>, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVWADD_WV_MF4_TIED:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs2, VR:{ *:[nxv1i16] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   17835 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_MF4_TIED),
     /*   17838 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   17840 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   17842 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   17846 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   17849 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   17852 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   17855 */     GIR_RootConstrainSelectedInstOperands,
     /*   17856 */     // GIR_Coverage, 69536,
     /*   17856 */     GIR_EraseRootFromParent_Done,
     /*   17857 */   // Label 382: @17857
     /*   17857 */   GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(17912), // Rule ID 69625 //
     /*   17862 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   17865 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   17869 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   17873 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   17877 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   17879 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17884 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17888 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   17890 */     // (add:{ *:[nxv1i32] } (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_zext_oneuse>>, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVWADDU_WV_MF4_TIED:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs2, VR:{ *:[nxv1i16] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   17890 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF4_TIED),
     /*   17893 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   17895 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   17897 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   17901 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   17904 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   17907 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   17910 */     GIR_RootConstrainSelectedInstOperands,
     /*   17911 */     // GIR_Coverage, 69625,
     /*   17911 */     GIR_EraseRootFromParent_Done,
     /*   17912 */   // Label 383: @17912
     /*   17912 */   GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(17967), // Rule ID 69626 //
     /*   17917 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   17920 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   17924 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   17928 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   17932 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   17934 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17939 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17943 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   17945 */     // (add:{ *:[nxv1i32] } (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_zext_oneuse>>, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVWADDU_WV_MF4_TIED:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs2, VR:{ *:[nxv1i16] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   17945 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF4_TIED),
     /*   17948 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   17950 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   17952 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   17956 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   17959 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   17962 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   17965 */     GIR_RootConstrainSelectedInstOperands,
     /*   17966 */     // GIR_Coverage, 69626,
     /*   17966 */     GIR_EraseRootFromParent_Done,
     /*   17967 */   // Label 384: @17967
     /*   17967 */   GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(18035), // Rule ID 51882 //
     /*   17972 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   17975 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   17979 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   17983 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   17987 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   17991 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s32,
     /*   17995 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   17997 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18002 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18007 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   18009 */     // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs2, (mul:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rd)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVMADD_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   18009 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF2),
     /*   18012 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   18014 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   18018 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   18022 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   18024 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   18027 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   18030 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   18033 */     GIR_RootConstrainSelectedInstOperands,
     /*   18034 */     // GIR_Coverage, 51882,
     /*   18034 */     GIR_EraseRootFromParent_Done,
     /*   18035 */   // Label 385: @18035
     /*   18035 */   GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(18103), // Rule ID 51883 //
     /*   18040 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   18043 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18047 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   18051 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   18055 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   18059 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s32,
     /*   18063 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   18065 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18070 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18075 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   18077 */     // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs2, (mul:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rd)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVMADD_VV_MF2:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rd, VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   18077 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF2),
     /*   18080 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   18082 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   18086 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   18090 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   18092 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   18095 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   18098 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   18101 */     GIR_RootConstrainSelectedInstOperands,
     /*   18102 */     // GIR_Coverage, 51883,
     /*   18102 */     GIR_EraseRootFromParent_Done,
     /*   18103 */   // Label 386: @18103
     /*   18103 */   GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(18158), // Rule ID 46764 //
     /*   18108 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   18111 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18115 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   18119 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   18123 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   18127 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   18129 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18134 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   18136 */     // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs2, (anyext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_WV_MF4_TIED:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs2, VR:{ *:[nxv1i16] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   18136 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF4_TIED),
     /*   18139 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   18141 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   18143 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   18147 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   18150 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   18153 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   18156 */     GIR_RootConstrainSelectedInstOperands,
     /*   18157 */     // GIR_Coverage, 46764,
     /*   18157 */     GIR_EraseRootFromParent_Done,
     /*   18158 */   // Label 387: @18158
     /*   18158 */   GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(18213), // Rule ID 46765 //
     /*   18163 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   18166 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18170 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   18174 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   18178 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   18182 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   18184 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18189 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   18191 */     // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs2, (anyext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_WV_MF4_TIED:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs2, VR:{ *:[nxv1i16] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   18191 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF4_TIED),
     /*   18194 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   18196 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   18198 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   18202 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   18205 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   18208 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   18211 */     GIR_RootConstrainSelectedInstOperands,
     /*   18212 */     // GIR_Coverage, 46765,
     /*   18212 */     GIR_EraseRootFromParent_Done,
     /*   18213 */   // Label 388: @18213
     /*   18213 */   GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(18268), // Rule ID 46524 //
     /*   18218 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   18221 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18225 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   18229 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   18233 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   18237 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   18239 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18244 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   18246 */     // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs2, (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_WV_MF4_TIED:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs2, VR:{ *:[nxv1i16] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   18246 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_MF4_TIED),
     /*   18249 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   18251 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   18253 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   18257 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   18260 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   18263 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   18266 */     GIR_RootConstrainSelectedInstOperands,
     /*   18267 */     // GIR_Coverage, 46524,
     /*   18267 */     GIR_EraseRootFromParent_Done,
     /*   18268 */   // Label 389: @18268
     /*   18268 */   GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(18323), // Rule ID 46525 //
     /*   18273 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   18276 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18280 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   18284 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   18288 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   18292 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   18294 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18299 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   18301 */     // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs2, (sext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_WV_MF4_TIED:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs2, VR:{ *:[nxv1i16] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   18301 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_MF4_TIED),
     /*   18304 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   18306 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   18308 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   18312 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   18315 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   18318 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   18321 */     GIR_RootConstrainSelectedInstOperands,
     /*   18322 */     // GIR_Coverage, 46525,
     /*   18322 */     GIR_EraseRootFromParent_Done,
     /*   18323 */   // Label 390: @18323
     /*   18323 */   GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(18378), // Rule ID 46644 //
     /*   18328 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   18331 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18335 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   18339 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   18343 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   18347 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   18349 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18354 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   18356 */     // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs2, (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_WV_MF4_TIED:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs2, VR:{ *:[nxv1i16] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   18356 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF4_TIED),
     /*   18359 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   18361 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   18363 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   18367 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   18370 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   18373 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   18376 */     GIR_RootConstrainSelectedInstOperands,
     /*   18377 */     // GIR_Coverage, 46644,
     /*   18377 */     GIR_EraseRootFromParent_Done,
     /*   18378 */   // Label 391: @18378
     /*   18378 */   GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(18433), // Rule ID 46645 //
     /*   18383 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   18386 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18390 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   18394 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   18398 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s16,
     /*   18402 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   18404 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18409 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   18411 */     // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs2, (zext:{ *:[nxv1i32] } VR:{ *:[nxv1i16] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_WV_MF4_TIED:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs2, VR:{ *:[nxv1i16] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   18411 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF4_TIED),
     /*   18414 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   18416 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   18418 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   18422 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   18425 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   18428 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   18431 */     GIR_RootConstrainSelectedInstOperands,
     /*   18432 */     // GIR_Coverage, 46645,
     /*   18432 */     GIR_EraseRootFromParent_Done,
     /*   18433 */   // Label 392: @18433
     /*   18433 */   GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(18486), // Rule ID 46114 //
     /*   18438 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   18441 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18445 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18449 */     // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
     /*   18449 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
     /*   18452 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   18456 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   18461 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   18463 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
     /*   18466 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   18468 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   18471 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*   18473 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   18475 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   18478 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   18481 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   18484 */     GIR_RootConstrainSelectedInstOperands,
     /*   18485 */     // GIR_Coverage, 46114,
     /*   18485 */     GIR_EraseRootFromParent_Done,
     /*   18486 */   // Label 393: @18486
     /*   18486 */   GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(18539), // Rule ID 46115 //
     /*   18491 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   18494 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18498 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18502 */     // (add:{ *:[nxv1i32] } VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv1i32] } (IMPLICIT_DEF:{ *:[nxv1i32] }), VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
     /*   18502 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s32,
     /*   18505 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   18509 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   18514 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   18516 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
     /*   18519 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   18521 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   18524 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*   18526 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   18528 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   18531 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   18534 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   18537 */     GIR_RootConstrainSelectedInstOperands,
     /*   18538 */     // GIR_Coverage, 46115,
     /*   18538 */     GIR_EraseRootFromParent_Done,
     /*   18539 */   // Label 394: @18539
     /*   18539 */   GIM_Reject,
     /*   18540 */ // Label 354: @18540
     /*   18540 */ GIM_Reject,
     /*   18541 */ // Label 131: @18541
     /*   18541 */ GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(21665),
     /*   18546 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv1s64,
     /*   18549 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv1s64,
     /*   18552 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18556 */   GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(18652), // Rule ID 70915 //
     /*   18561 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   18564 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   18568 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   18572 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s64,
     /*   18576 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s64,
     /*   18580 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   18582 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   18586 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   18590 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   18594 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   18596 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18601 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   18605 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   18609 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   18613 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   18615 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18620 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18624 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   18626 */     // (add:{ *:[nxv1i64] } (mul:{ *:[nxv1i64] } (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i64] }:$rd)  =>  (PseudoVWMACC_VV_MF2:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   18626 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_MF2),
     /*   18629 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   18631 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   18633 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   18637 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   18641 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   18644 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   18647 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   18650 */     GIR_RootConstrainSelectedInstOperands,
     /*   18651 */     // GIR_Coverage, 70915,
     /*   18651 */     GIR_EraseRootFromParent_Done,
     /*   18652 */   // Label 396: @18652
     /*   18652 */   GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(18748), // Rule ID 70916 //
     /*   18657 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   18660 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   18664 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   18668 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s64,
     /*   18672 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s64,
     /*   18676 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   18678 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   18682 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   18686 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   18690 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   18692 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18697 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   18701 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   18705 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   18709 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   18711 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18716 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18720 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   18722 */     // (add:{ *:[nxv1i64] } (mul:{ *:[nxv1i64] } (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i64] }:$rd)  =>  (PseudoVWMACC_VV_MF2:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   18722 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_MF2),
     /*   18725 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   18727 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   18729 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   18733 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   18737 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   18740 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   18743 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   18746 */     GIR_RootConstrainSelectedInstOperands,
     /*   18747 */     // GIR_Coverage, 70916,
     /*   18747 */     GIR_EraseRootFromParent_Done,
     /*   18748 */   // Label 397: @18748
     /*   18748 */   GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(18844), // Rule ID 71195 //
     /*   18753 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   18756 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   18760 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   18764 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s64,
     /*   18768 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s64,
     /*   18772 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   18774 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   18778 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   18782 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   18786 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   18788 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18793 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   18797 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   18801 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   18805 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   18807 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18812 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18816 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   18818 */     // (add:{ *:[nxv1i64] } (mul:{ *:[nxv1i64] } (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i64] }:$rd)  =>  (PseudoVWMACCSU_VV_MF2:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   18818 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF2),
     /*   18821 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   18823 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   18825 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   18829 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   18833 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   18836 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   18839 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   18842 */     GIR_RootConstrainSelectedInstOperands,
     /*   18843 */     // GIR_Coverage, 71195,
     /*   18843 */     GIR_EraseRootFromParent_Done,
     /*   18844 */   // Label 398: @18844
     /*   18844 */   GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(18940), // Rule ID 71196 //
     /*   18849 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   18852 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   18856 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   18860 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s64,
     /*   18864 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s64,
     /*   18868 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   18870 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   18874 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   18878 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   18882 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   18884 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18889 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   18893 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   18897 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   18901 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   18903 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18908 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18912 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   18914 */     // (add:{ *:[nxv1i64] } (mul:{ *:[nxv1i64] } (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i64] }:$rd)  =>  (PseudoVWMACCSU_VV_MF2:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   18914 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF2),
     /*   18917 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   18919 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   18921 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   18925 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   18929 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   18932 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   18935 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   18938 */     GIR_RootConstrainSelectedInstOperands,
     /*   18939 */     // GIR_Coverage, 71196,
     /*   18939 */     GIR_EraseRootFromParent_Done,
     /*   18940 */   // Label 399: @18940
     /*   18940 */   GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(19036), // Rule ID 71197 //
     /*   18945 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   18948 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   18952 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   18956 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s64,
     /*   18960 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s64,
     /*   18964 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   18966 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   18970 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   18974 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   18978 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   18980 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   18985 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   18989 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   18993 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   18997 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   18999 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19004 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19008 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   19010 */     // (add:{ *:[nxv1i64] } (mul:{ *:[nxv1i64] } (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i64] }:$rd)  =>  (PseudoVWMACCSU_VV_MF2:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   19010 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF2),
     /*   19013 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   19015 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   19017 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   19021 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   19025 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   19028 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   19031 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   19034 */     GIR_RootConstrainSelectedInstOperands,
     /*   19035 */     // GIR_Coverage, 71197,
     /*   19035 */     GIR_EraseRootFromParent_Done,
     /*   19036 */   // Label 400: @19036
     /*   19036 */   GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(19132), // Rule ID 71198 //
     /*   19041 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   19044 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   19048 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   19052 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s64,
     /*   19056 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s64,
     /*   19060 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   19062 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   19066 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   19070 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   19074 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   19076 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19081 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   19085 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   19089 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   19093 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   19095 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19100 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19104 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   19106 */     // (add:{ *:[nxv1i64] } (mul:{ *:[nxv1i64] } (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i64] }:$rd)  =>  (PseudoVWMACCSU_VV_MF2:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   19106 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF2),
     /*   19109 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   19111 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   19113 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   19117 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   19121 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   19124 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   19127 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   19130 */     GIR_RootConstrainSelectedInstOperands,
     /*   19131 */     // GIR_Coverage, 71198,
     /*   19131 */     GIR_EraseRootFromParent_Done,
     /*   19132 */   // Label 401: @19132
     /*   19132 */   GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(19228), // Rule ID 71029 //
     /*   19137 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   19140 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   19144 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   19148 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s64,
     /*   19152 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s64,
     /*   19156 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   19158 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   19162 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   19166 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   19170 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   19172 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19177 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   19181 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   19185 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   19189 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   19191 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19196 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19200 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   19202 */     // (add:{ *:[nxv1i64] } (mul:{ *:[nxv1i64] } (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i64] }:$rd)  =>  (PseudoVWMACCU_VV_MF2:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   19202 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_MF2),
     /*   19205 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   19207 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   19209 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   19213 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   19217 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   19220 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   19223 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   19226 */     GIR_RootConstrainSelectedInstOperands,
     /*   19227 */     // GIR_Coverage, 71029,
     /*   19227 */     GIR_EraseRootFromParent_Done,
     /*   19228 */   // Label 402: @19228
     /*   19228 */   GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(19324), // Rule ID 71030 //
     /*   19233 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   19236 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   19240 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   19244 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s64,
     /*   19248 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s64,
     /*   19252 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   19254 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   19258 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   19262 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   19266 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   19268 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19273 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   19277 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   19281 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   19285 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   19287 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19292 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19296 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   19298 */     // (add:{ *:[nxv1i64] } (mul:{ *:[nxv1i64] } (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i64] }:$rd)  =>  (PseudoVWMACCU_VV_MF2:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   19298 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_MF2),
     /*   19301 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   19303 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   19305 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   19309 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   19313 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   19316 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   19319 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   19322 */     GIR_RootConstrainSelectedInstOperands,
     /*   19323 */     // GIR_Coverage, 71030,
     /*   19323 */     GIR_EraseRootFromParent_Done,
     /*   19324 */   // Label 403: @19324
     /*   19324 */   GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(19420), // Rule ID 52058 //
     /*   19329 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   19332 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19336 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   19340 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   19344 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s64,
     /*   19348 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s64,
     /*   19352 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   19354 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   19358 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   19362 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   19366 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   19368 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19373 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   19377 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   19381 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   19385 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   19387 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19392 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   19394 */     // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, (mul:{ *:[nxv1i64] } (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACC_VV_MF2:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   19394 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_MF2),
     /*   19397 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   19399 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   19401 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   19405 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   19409 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   19412 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   19415 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   19418 */     GIR_RootConstrainSelectedInstOperands,
     /*   19419 */     // GIR_Coverage, 52058,
     /*   19419 */     GIR_EraseRootFromParent_Done,
     /*   19420 */   // Label 404: @19420
     /*   19420 */   GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(19516), // Rule ID 52059 //
     /*   19425 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   19428 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19432 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   19436 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   19440 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s64,
     /*   19444 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s64,
     /*   19448 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   19450 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   19454 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   19458 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   19462 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   19464 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19469 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   19473 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   19477 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   19481 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   19483 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19488 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   19490 */     // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, (mul:{ *:[nxv1i64] } (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACC_VV_MF2:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   19490 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_MF2),
     /*   19493 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   19495 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   19497 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   19501 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   19505 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   19508 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   19511 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   19514 */     GIR_RootConstrainSelectedInstOperands,
     /*   19515 */     // GIR_Coverage, 52059,
     /*   19515 */     GIR_EraseRootFromParent_Done,
     /*   19516 */   // Label 405: @19516
     /*   19516 */   GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(19612), // Rule ID 52176 //
     /*   19521 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   19524 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19528 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   19532 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   19536 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s64,
     /*   19540 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s64,
     /*   19544 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   19546 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   19550 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   19554 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   19558 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   19560 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19565 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   19569 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   19573 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   19577 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   19579 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19584 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   19586 */     // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, (mul:{ *:[nxv1i64] } (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_MF2:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   19586 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF2),
     /*   19589 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   19591 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   19593 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   19597 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   19601 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   19604 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   19607 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   19610 */     GIR_RootConstrainSelectedInstOperands,
     /*   19611 */     // GIR_Coverage, 52176,
     /*   19611 */     GIR_EraseRootFromParent_Done,
     /*   19612 */   // Label 406: @19612
     /*   19612 */   GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(19708), // Rule ID 52177 //
     /*   19617 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   19620 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19624 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   19628 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   19632 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s64,
     /*   19636 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s64,
     /*   19640 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   19642 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   19646 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   19650 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   19654 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   19656 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19661 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   19665 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   19669 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   19673 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   19675 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19680 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   19682 */     // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, (mul:{ *:[nxv1i64] } (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_MF2:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   19682 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF2),
     /*   19685 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   19687 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   19689 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   19693 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   19697 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   19700 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   19703 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   19706 */     GIR_RootConstrainSelectedInstOperands,
     /*   19707 */     // GIR_Coverage, 52177,
     /*   19707 */     GIR_EraseRootFromParent_Done,
     /*   19708 */   // Label 407: @19708
     /*   19708 */   GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(19804), // Rule ID 71193 //
     /*   19713 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   19716 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19720 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   19724 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   19728 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s64,
     /*   19732 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s64,
     /*   19736 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   19738 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   19742 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   19746 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   19750 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   19752 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19757 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   19761 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   19765 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   19769 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   19771 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19776 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   19778 */     // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, (mul:{ *:[nxv1i64] } (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_MF2:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   19778 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF2),
     /*   19781 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   19783 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   19785 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   19789 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   19793 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   19796 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   19799 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   19802 */     GIR_RootConstrainSelectedInstOperands,
     /*   19803 */     // GIR_Coverage, 71193,
     /*   19803 */     GIR_EraseRootFromParent_Done,
     /*   19804 */   // Label 408: @19804
     /*   19804 */   GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(19900), // Rule ID 71194 //
     /*   19809 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   19812 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19816 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   19820 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   19824 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s64,
     /*   19828 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s64,
     /*   19832 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   19834 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   19838 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   19842 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   19846 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   19848 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19853 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   19857 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   19861 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   19865 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   19867 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19872 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   19874 */     // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, (mul:{ *:[nxv1i64] } (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_MF2:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   19874 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF2),
     /*   19877 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   19879 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   19881 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   19885 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   19889 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   19892 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   19895 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   19898 */     GIR_RootConstrainSelectedInstOperands,
     /*   19899 */     // GIR_Coverage, 71194,
     /*   19899 */     GIR_EraseRootFromParent_Done,
     /*   19900 */   // Label 409: @19900
     /*   19900 */   GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(19996), // Rule ID 52116 //
     /*   19905 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   19908 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19912 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   19916 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   19920 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s64,
     /*   19924 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s64,
     /*   19928 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   19930 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   19934 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   19938 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   19942 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   19944 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19949 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   19953 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   19957 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   19961 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   19963 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   19968 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   19970 */     // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, (mul:{ *:[nxv1i64] } (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCU_VV_MF2:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   19970 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_MF2),
     /*   19973 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   19975 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   19977 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   19981 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   19985 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   19988 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   19991 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   19994 */     GIR_RootConstrainSelectedInstOperands,
     /*   19995 */     // GIR_Coverage, 52116,
     /*   19995 */     GIR_EraseRootFromParent_Done,
     /*   19996 */   // Label 410: @19996
     /*   19996 */   GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(20092), // Rule ID 52117 //
     /*   20001 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   20004 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20008 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   20012 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   20016 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s64,
     /*   20020 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s64,
     /*   20024 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   20026 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   20030 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   20034 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   20038 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   20040 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20045 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   20049 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   20053 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   20057 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   20059 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20064 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   20066 */     // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, (mul:{ *:[nxv1i64] } (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCU_VV_MF2:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, VR:{ *:[nxv1i32] }:$rs1, VR:{ *:[nxv1i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   20066 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_MF2),
     /*   20069 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   20071 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   20073 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   20077 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   20081 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   20084 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   20087 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   20090 */     GIR_RootConstrainSelectedInstOperands,
     /*   20091 */     // GIR_Coverage, 52117,
     /*   20091 */     GIR_EraseRootFromParent_Done,
     /*   20092 */   // Label 411: @20092
     /*   20092 */   GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(20181), // Rule ID 46724 //
     /*   20097 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   20100 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   20104 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   20108 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   20112 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   20114 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20119 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   20123 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   20127 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   20131 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   20133 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20138 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   20140 */     // (add:{ *:[nxv1i64] } (anyext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs2)<<P:Predicate_anyext_oneuse>>, (anyext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_VV_MF2:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i32] }:$rs2, VR:{ *:[nxv1i32] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
     /*   20140 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
     /*   20143 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   20147 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   20152 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   20154 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_MF2),
     /*   20157 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   20159 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   20162 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   20166 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   20170 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   20173 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   20176 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   20179 */     GIR_RootConstrainSelectedInstOperands,
     /*   20180 */     // GIR_Coverage, 46724,
     /*   20180 */     GIR_EraseRootFromParent_Done,
     /*   20181 */   // Label 412: @20181
     /*   20181 */   GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(20270), // Rule ID 46725 //
     /*   20186 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   20189 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   20193 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   20197 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   20201 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   20203 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20208 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   20212 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   20216 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   20220 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   20222 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20227 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   20229 */     // (add:{ *:[nxv1i64] } (anyext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs2)<<P:Predicate_anyext_oneuse>>, (anyext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_VV_MF2:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i32] }:$rs2, VR:{ *:[nxv1i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
     /*   20229 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
     /*   20232 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   20236 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   20241 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   20243 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_MF2),
     /*   20246 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   20248 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   20251 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   20255 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   20259 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   20262 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   20265 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   20268 */     GIR_RootConstrainSelectedInstOperands,
     /*   20269 */     // GIR_Coverage, 46725,
     /*   20269 */     GIR_EraseRootFromParent_Done,
     /*   20270 */   // Label 413: @20270
     /*   20270 */   GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(20359), // Rule ID 46488 //
     /*   20275 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   20278 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   20282 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   20286 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   20290 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   20292 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20297 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   20301 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   20305 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   20309 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   20311 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20316 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   20318 */     // (add:{ *:[nxv1i64] } (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs2)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_VV_MF2:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i32] }:$rs2, VR:{ *:[nxv1i32] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
     /*   20318 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
     /*   20321 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   20325 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   20330 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   20332 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_VV_MF2),
     /*   20335 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   20337 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   20340 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   20344 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   20348 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   20351 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   20354 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   20357 */     GIR_RootConstrainSelectedInstOperands,
     /*   20358 */     // GIR_Coverage, 46488,
     /*   20358 */     GIR_EraseRootFromParent_Done,
     /*   20359 */   // Label 414: @20359
     /*   20359 */   GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(20448), // Rule ID 46489 //
     /*   20364 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   20367 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   20371 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   20375 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   20379 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   20381 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20386 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   20390 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   20394 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   20398 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   20400 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20405 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   20407 */     // (add:{ *:[nxv1i64] } (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs2)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_VV_MF2:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i32] }:$rs2, VR:{ *:[nxv1i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
     /*   20407 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
     /*   20410 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   20414 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   20419 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   20421 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_VV_MF2),
     /*   20424 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   20426 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   20429 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   20433 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   20437 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   20440 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   20443 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   20446 */     GIR_RootConstrainSelectedInstOperands,
     /*   20447 */     // GIR_Coverage, 46489,
     /*   20447 */     GIR_EraseRootFromParent_Done,
     /*   20448 */   // Label 415: @20448
     /*   20448 */   GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(20537), // Rule ID 46604 //
     /*   20453 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   20456 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   20460 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   20464 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   20468 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   20470 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20475 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   20479 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   20483 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   20487 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   20489 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20494 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   20496 */     // (add:{ *:[nxv1i64] } (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs2)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_VV_MF2:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i32] }:$rs2, VR:{ *:[nxv1i32] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
     /*   20496 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
     /*   20499 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   20503 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   20508 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   20510 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_MF2),
     /*   20513 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   20515 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   20518 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   20522 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   20526 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   20529 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   20532 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   20535 */     GIR_RootConstrainSelectedInstOperands,
     /*   20536 */     // GIR_Coverage, 46604,
     /*   20536 */     GIR_EraseRootFromParent_Done,
     /*   20537 */   // Label 416: @20537
     /*   20537 */   GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(20626), // Rule ID 46605 //
     /*   20542 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   20545 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   20549 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   20553 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   20557 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   20559 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20564 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   20568 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   20572 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   20576 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   20578 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20583 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   20585 */     // (add:{ *:[nxv1i64] } (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs2)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_VV_MF2:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i32] }:$rs2, VR:{ *:[nxv1i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
     /*   20585 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
     /*   20588 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   20592 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   20597 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   20599 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_MF2),
     /*   20602 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   20604 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   20607 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   20611 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   20615 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   20618 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   20621 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   20624 */     GIR_RootConstrainSelectedInstOperands,
     /*   20625 */     // GIR_Coverage, 46605,
     /*   20625 */     GIR_EraseRootFromParent_Done,
     /*   20626 */   // Label 417: @20626
     /*   20626 */   GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(20694), // Rule ID 70747 //
     /*   20631 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
     /*   20634 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   20638 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   20642 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s64,
     /*   20646 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s64,
     /*   20650 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   20652 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20657 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20662 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20666 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   20668 */     // (add:{ *:[nxv1i64] } (mul:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rd)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVMADD_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 1:{ *:[i64] })
     /*   20668 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_M1),
     /*   20671 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   20673 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   20677 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   20681 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   20683 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   20686 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
     /*   20689 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   20692 */     GIR_RootConstrainSelectedInstOperands,
     /*   20693 */     // GIR_Coverage, 70747,
     /*   20693 */     GIR_EraseRootFromParent_Done,
     /*   20694 */   // Label 418: @20694
     /*   20694 */   GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(20762), // Rule ID 70748 //
     /*   20699 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
     /*   20702 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   20706 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   20710 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s64,
     /*   20714 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s64,
     /*   20718 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   20720 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20725 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20730 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20734 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   20736 */     // (add:{ *:[nxv1i64] } (mul:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rd)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVMADD_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 1:{ *:[i32] })
     /*   20736 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_M1),
     /*   20739 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   20741 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   20745 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   20749 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   20751 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   20754 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
     /*   20757 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   20760 */     GIR_RootConstrainSelectedInstOperands,
     /*   20761 */     // GIR_Coverage, 70748,
     /*   20761 */     GIR_EraseRootFromParent_Done,
     /*   20762 */   // Label 419: @20762
     /*   20762 */   GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(20817), // Rule ID 69735 //
     /*   20767 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   20770 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   20774 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   20778 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   20782 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   20784 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20789 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20793 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   20795 */     // (add:{ *:[nxv1i64] } (anyext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_anyext_oneuse>>, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVWADDU_WV_MF2_TIED:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs2, VR:{ *:[nxv1i32] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   20795 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF2_TIED),
     /*   20798 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   20800 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   20802 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   20806 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   20809 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   20812 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   20815 */     GIR_RootConstrainSelectedInstOperands,
     /*   20816 */     // GIR_Coverage, 69735,
     /*   20816 */     GIR_EraseRootFromParent_Done,
     /*   20817 */   // Label 420: @20817
     /*   20817 */   GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(20872), // Rule ID 69736 //
     /*   20822 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   20825 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   20829 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   20833 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   20837 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   20839 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20844 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20848 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   20850 */     // (add:{ *:[nxv1i64] } (anyext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_anyext_oneuse>>, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVWADDU_WV_MF2_TIED:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs2, VR:{ *:[nxv1i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   20850 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF2_TIED),
     /*   20853 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   20855 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   20857 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   20861 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   20864 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   20867 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   20870 */     GIR_RootConstrainSelectedInstOperands,
     /*   20871 */     // GIR_Coverage, 69736,
     /*   20871 */     GIR_EraseRootFromParent_Done,
     /*   20872 */   // Label 421: @20872
     /*   20872 */   GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(20927), // Rule ID 69555 //
     /*   20877 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   20880 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   20884 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   20888 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   20892 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   20894 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20899 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20903 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   20905 */     // (add:{ *:[nxv1i64] } (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_sext_oneuse>>, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVWADD_WV_MF2_TIED:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs2, VR:{ *:[nxv1i32] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   20905 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_MF2_TIED),
     /*   20908 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   20910 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   20912 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   20916 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   20919 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   20922 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   20925 */     GIR_RootConstrainSelectedInstOperands,
     /*   20926 */     // GIR_Coverage, 69555,
     /*   20926 */     GIR_EraseRootFromParent_Done,
     /*   20927 */   // Label 422: @20927
     /*   20927 */   GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(20982), // Rule ID 69556 //
     /*   20932 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   20935 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   20939 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   20943 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   20947 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   20949 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20954 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   20958 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   20960 */     // (add:{ *:[nxv1i64] } (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_sext_oneuse>>, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVWADD_WV_MF2_TIED:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs2, VR:{ *:[nxv1i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   20960 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_MF2_TIED),
     /*   20963 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   20965 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   20967 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   20971 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   20974 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   20977 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   20980 */     GIR_RootConstrainSelectedInstOperands,
     /*   20981 */     // GIR_Coverage, 69556,
     /*   20981 */     GIR_EraseRootFromParent_Done,
     /*   20982 */   // Label 423: @20982
     /*   20982 */   GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(21037), // Rule ID 69645 //
     /*   20987 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   20990 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   20994 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   20998 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   21002 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   21004 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21009 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21013 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   21015 */     // (add:{ *:[nxv1i64] } (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_zext_oneuse>>, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVWADDU_WV_MF2_TIED:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs2, VR:{ *:[nxv1i32] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   21015 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF2_TIED),
     /*   21018 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   21020 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   21022 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   21026 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   21029 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   21032 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   21035 */     GIR_RootConstrainSelectedInstOperands,
     /*   21036 */     // GIR_Coverage, 69645,
     /*   21036 */     GIR_EraseRootFromParent_Done,
     /*   21037 */   // Label 424: @21037
     /*   21037 */   GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(21092), // Rule ID 69646 //
     /*   21042 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   21045 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   21049 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   21053 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   21057 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   21059 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21064 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21068 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   21070 */     // (add:{ *:[nxv1i64] } (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_zext_oneuse>>, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVWADDU_WV_MF2_TIED:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs2, VR:{ *:[nxv1i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   21070 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF2_TIED),
     /*   21073 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   21075 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   21077 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   21081 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   21084 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   21087 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   21090 */     GIR_RootConstrainSelectedInstOperands,
     /*   21091 */     // GIR_Coverage, 69646,
     /*   21091 */     GIR_EraseRootFromParent_Done,
     /*   21092 */   // Label 425: @21092
     /*   21092 */   GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(21160), // Rule ID 51898 //
     /*   21097 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
     /*   21100 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21104 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   21108 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   21112 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s64,
     /*   21116 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s64,
     /*   21120 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   21122 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21127 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21132 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   21134 */     // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs2, (mul:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rd)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVMADD_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 1:{ *:[i64] })
     /*   21134 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_M1),
     /*   21137 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   21139 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   21143 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   21147 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   21149 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   21152 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
     /*   21155 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   21158 */     GIR_RootConstrainSelectedInstOperands,
     /*   21159 */     // GIR_Coverage, 51898,
     /*   21159 */     GIR_EraseRootFromParent_Done,
     /*   21160 */   // Label 426: @21160
     /*   21160 */   GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(21228), // Rule ID 51899 //
     /*   21165 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
     /*   21168 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21172 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   21176 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   21180 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s64,
     /*   21184 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv1s64,
     /*   21188 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   21190 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21195 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21200 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   21202 */     // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs2, (mul:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rd)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVMADD_VV_M1:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rd, VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 1:{ *:[i32] })
     /*   21202 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_M1),
     /*   21205 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   21207 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   21211 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   21215 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   21217 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   21220 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
     /*   21223 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   21226 */     GIR_RootConstrainSelectedInstOperands,
     /*   21227 */     // GIR_Coverage, 51899,
     /*   21227 */     GIR_EraseRootFromParent_Done,
     /*   21228 */   // Label 427: @21228
     /*   21228 */   GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(21283), // Rule ID 46784 //
     /*   21233 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   21236 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21240 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   21244 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   21248 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   21252 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   21254 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21259 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   21261 */     // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs2, (anyext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_WV_MF2_TIED:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs2, VR:{ *:[nxv1i32] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   21261 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF2_TIED),
     /*   21264 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   21266 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   21268 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   21272 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   21275 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   21278 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   21281 */     GIR_RootConstrainSelectedInstOperands,
     /*   21282 */     // GIR_Coverage, 46784,
     /*   21282 */     GIR_EraseRootFromParent_Done,
     /*   21283 */   // Label 428: @21283
     /*   21283 */   GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(21338), // Rule ID 46785 //
     /*   21288 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   21291 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21295 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   21299 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   21303 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   21307 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   21309 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21314 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   21316 */     // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs2, (anyext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_WV_MF2_TIED:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs2, VR:{ *:[nxv1i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   21316 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF2_TIED),
     /*   21319 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   21321 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   21323 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   21327 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   21330 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   21333 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   21336 */     GIR_RootConstrainSelectedInstOperands,
     /*   21337 */     // GIR_Coverage, 46785,
     /*   21337 */     GIR_EraseRootFromParent_Done,
     /*   21338 */   // Label 429: @21338
     /*   21338 */   GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(21393), // Rule ID 46544 //
     /*   21343 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   21346 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21350 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   21354 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   21358 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   21362 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   21364 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21369 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   21371 */     // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs2, (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_WV_MF2_TIED:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs2, VR:{ *:[nxv1i32] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   21371 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_MF2_TIED),
     /*   21374 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   21376 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   21378 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   21382 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   21385 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   21388 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   21391 */     GIR_RootConstrainSelectedInstOperands,
     /*   21392 */     // GIR_Coverage, 46544,
     /*   21392 */     GIR_EraseRootFromParent_Done,
     /*   21393 */   // Label 430: @21393
     /*   21393 */   GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(21448), // Rule ID 46545 //
     /*   21398 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   21401 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21405 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   21409 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   21413 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   21417 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   21419 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21424 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   21426 */     // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs2, (sext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_WV_MF2_TIED:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs2, VR:{ *:[nxv1i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   21426 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_MF2_TIED),
     /*   21429 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   21431 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   21433 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   21437 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   21440 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   21443 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   21446 */     GIR_RootConstrainSelectedInstOperands,
     /*   21447 */     // GIR_Coverage, 46545,
     /*   21447 */     GIR_EraseRootFromParent_Done,
     /*   21448 */   // Label 431: @21448
     /*   21448 */   GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(21503), // Rule ID 46664 //
     /*   21453 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   21456 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21460 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   21464 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   21468 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   21472 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   21474 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21479 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   21481 */     // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs2, (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_WV_MF2_TIED:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs2, VR:{ *:[nxv1i32] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   21481 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF2_TIED),
     /*   21484 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   21486 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   21488 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   21492 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   21495 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   21498 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   21501 */     GIR_RootConstrainSelectedInstOperands,
     /*   21502 */     // GIR_Coverage, 46664,
     /*   21502 */     GIR_EraseRootFromParent_Done,
     /*   21503 */   // Label 432: @21503
     /*   21503 */   GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(21558), // Rule ID 46665 //
     /*   21508 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   21511 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21515 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   21519 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   21523 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv1s32,
     /*   21527 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   21529 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21534 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   21536 */     // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs2, (zext:{ *:[nxv1i64] } VR:{ *:[nxv1i32] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_WV_MF2_TIED:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs2, VR:{ *:[nxv1i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   21536 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF2_TIED),
     /*   21539 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   21541 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   21543 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   21547 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   21550 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   21553 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   21556 */     GIR_RootConstrainSelectedInstOperands,
     /*   21557 */     // GIR_Coverage, 46665,
     /*   21557 */     GIR_EraseRootFromParent_Done,
     /*   21558 */   // Label 433: @21558
     /*   21558 */   GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(21611), // Rule ID 46130 //
     /*   21563 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
     /*   21566 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21570 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21574 */     // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
     /*   21574 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
     /*   21577 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   21581 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   21586 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   21588 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
     /*   21591 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   21593 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   21596 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*   21598 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   21600 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   21603 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
     /*   21606 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   21609 */     GIR_RootConstrainSelectedInstOperands,
     /*   21610 */     // GIR_Coverage, 46130,
     /*   21610 */     GIR_EraseRootFromParent_Done,
     /*   21611 */   // Label 434: @21611
     /*   21611 */   GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(21664), // Rule ID 46131 //
     /*   21616 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
     /*   21619 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21623 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21627 */     // (add:{ *:[nxv1i64] } VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv1i64] } (IMPLICIT_DEF:{ *:[nxv1i64] }), VR:{ *:[nxv1i64] }:$rs1, VR:{ *:[nxv1i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
     /*   21627 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv1s64,
     /*   21630 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   21634 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   21639 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   21641 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
     /*   21644 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   21646 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   21649 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*   21651 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   21653 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   21656 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
     /*   21659 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   21662 */     GIR_RootConstrainSelectedInstOperands,
     /*   21663 */     // GIR_Coverage, 46131,
     /*   21663 */     GIR_EraseRootFromParent_Done,
     /*   21664 */   // Label 435: @21664
     /*   21664 */   GIM_Reject,
     /*   21665 */ // Label 395: @21665
     /*   21665 */ GIM_Reject,
     /*   21666 */ // Label 132: @21666
     /*   21666 */ GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(22060),
     /*   21671 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   21674 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s8,
     /*   21677 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21681 */   GIM_Try, /*On fail goto*//*Label 437*/ GIMT_Encode4(21749), // Rule ID 70683 //
     /*   21686 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   21689 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   21693 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   21697 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   21701 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s8,
     /*   21705 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   21707 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21712 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21717 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21721 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   21723 */     // (add:{ *:[nxv2i8] } (mul:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rd)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVMADD_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rd, VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   21723 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF4),
     /*   21726 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   21728 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   21732 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   21736 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   21738 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   21741 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   21744 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   21747 */     GIR_RootConstrainSelectedInstOperands,
     /*   21748 */     // GIR_Coverage, 70683,
     /*   21748 */     GIR_EraseRootFromParent_Done,
     /*   21749 */   // Label 437: @21749
     /*   21749 */   GIM_Try, /*On fail goto*//*Label 438*/ GIMT_Encode4(21817), // Rule ID 70684 //
     /*   21754 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   21757 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   21761 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   21765 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   21769 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s8,
     /*   21773 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   21775 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21780 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21785 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21789 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   21791 */     // (add:{ *:[nxv2i8] } (mul:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rd)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVMADD_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rd, VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   21791 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF4),
     /*   21794 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   21796 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   21800 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   21804 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   21806 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   21809 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   21812 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   21815 */     GIR_RootConstrainSelectedInstOperands,
     /*   21816 */     // GIR_Coverage, 70684,
     /*   21816 */     GIR_EraseRootFromParent_Done,
     /*   21817 */   // Label 438: @21817
     /*   21817 */   GIM_Try, /*On fail goto*//*Label 439*/ GIMT_Encode4(21885), // Rule ID 51866 //
     /*   21822 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   21825 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21829 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   21833 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   21837 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   21841 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s8,
     /*   21845 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   21847 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21852 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21857 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   21859 */     // (add:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs2, (mul:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rd)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVMADD_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rd, VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   21859 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF4),
     /*   21862 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   21864 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   21868 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   21872 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   21874 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   21877 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   21880 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   21883 */     GIR_RootConstrainSelectedInstOperands,
     /*   21884 */     // GIR_Coverage, 51866,
     /*   21884 */     GIR_EraseRootFromParent_Done,
     /*   21885 */   // Label 439: @21885
     /*   21885 */   GIM_Try, /*On fail goto*//*Label 440*/ GIMT_Encode4(21953), // Rule ID 51867 //
     /*   21890 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   21893 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21897 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   21901 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   21905 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   21909 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s8,
     /*   21913 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   21915 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21920 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21925 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   21927 */     // (add:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs2, (mul:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rd)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVMADD_VV_MF4:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rd, VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   21927 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF4),
     /*   21930 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   21932 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   21936 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   21940 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   21942 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   21945 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   21948 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   21951 */     GIR_RootConstrainSelectedInstOperands,
     /*   21952 */     // GIR_Coverage, 51867,
     /*   21952 */     GIR_EraseRootFromParent_Done,
     /*   21953 */   // Label 440: @21953
     /*   21953 */   GIM_Try, /*On fail goto*//*Label 441*/ GIMT_Encode4(22006), // Rule ID 46098 //
     /*   21958 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   21961 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21965 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   21969 */     // (add:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
     /*   21969 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
     /*   21972 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   21976 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   21981 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   21983 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF4),
     /*   21986 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   21988 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   21991 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*   21993 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   21995 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   21998 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   22001 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   22004 */     GIR_RootConstrainSelectedInstOperands,
     /*   22005 */     // GIR_Coverage, 46098,
     /*   22005 */     GIR_EraseRootFromParent_Done,
     /*   22006 */   // Label 441: @22006
     /*   22006 */   GIM_Try, /*On fail goto*//*Label 442*/ GIMT_Encode4(22059), // Rule ID 46099 //
     /*   22011 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   22014 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22018 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22022 */     // (add:{ *:[nxv2i8] } VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2)  =>  (PseudoVADD_VV_MF4:{ *:[nxv2i8] } (IMPLICIT_DEF:{ *:[nxv2i8] }), VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
     /*   22022 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s8,
     /*   22025 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   22029 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   22034 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   22036 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF4),
     /*   22039 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   22041 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   22044 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*   22046 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   22048 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   22051 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   22054 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   22057 */     GIR_RootConstrainSelectedInstOperands,
     /*   22058 */     // GIR_Coverage, 46099,
     /*   22058 */     GIR_EraseRootFromParent_Done,
     /*   22059 */   // Label 442: @22059
     /*   22059 */   GIM_Reject,
     /*   22060 */ // Label 436: @22060
     /*   22060 */ GIM_Reject,
     /*   22061 */ // Label 133: @22061
     /*   22061 */ GIM_Try, /*On fail goto*//*Label 443*/ GIMT_Encode4(25185),
     /*   22066 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   22069 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s16,
     /*   22072 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22076 */   GIM_Try, /*On fail goto*//*Label 444*/ GIMT_Encode4(22172), // Rule ID 70895 //
     /*   22081 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   22084 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   22088 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   22092 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   22096 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s16,
     /*   22100 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   22102 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   22106 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   22110 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   22114 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   22116 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22121 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   22125 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   22129 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   22133 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   22135 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22140 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22144 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   22146 */     // (add:{ *:[nxv2i16] } (mul:{ *:[nxv2i16] } (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv2i16] }:$rd)  =>  (PseudoVWMACC_VV_MF4:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   22146 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_MF4),
     /*   22149 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   22151 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   22153 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   22157 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   22161 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   22164 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   22167 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   22170 */     GIR_RootConstrainSelectedInstOperands,
     /*   22171 */     // GIR_Coverage, 70895,
     /*   22171 */     GIR_EraseRootFromParent_Done,
     /*   22172 */   // Label 444: @22172
     /*   22172 */   GIM_Try, /*On fail goto*//*Label 445*/ GIMT_Encode4(22268), // Rule ID 70896 //
     /*   22177 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   22180 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   22184 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   22188 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   22192 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s16,
     /*   22196 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   22198 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   22202 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   22206 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   22210 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   22212 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22217 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   22221 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   22225 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   22229 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   22231 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22236 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22240 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   22242 */     // (add:{ *:[nxv2i16] } (mul:{ *:[nxv2i16] } (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv2i16] }:$rd)  =>  (PseudoVWMACC_VV_MF4:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   22242 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_MF4),
     /*   22245 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   22247 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   22249 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   22253 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   22257 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   22260 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   22263 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   22266 */     GIR_RootConstrainSelectedInstOperands,
     /*   22267 */     // GIR_Coverage, 70896,
     /*   22267 */     GIR_EraseRootFromParent_Done,
     /*   22268 */   // Label 445: @22268
     /*   22268 */   GIM_Try, /*On fail goto*//*Label 446*/ GIMT_Encode4(22364), // Rule ID 71135 //
     /*   22273 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   22276 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   22280 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   22284 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   22288 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s16,
     /*   22292 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   22294 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   22298 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   22302 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   22306 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   22308 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22313 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   22317 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   22321 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   22325 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   22327 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22332 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22336 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   22338 */     // (add:{ *:[nxv2i16] } (mul:{ *:[nxv2i16] } (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv2i16] }:$rd)  =>  (PseudoVWMACCSU_VV_MF4:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   22338 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF4),
     /*   22341 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   22343 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   22345 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   22349 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   22353 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   22356 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   22359 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   22362 */     GIR_RootConstrainSelectedInstOperands,
     /*   22363 */     // GIR_Coverage, 71135,
     /*   22363 */     GIR_EraseRootFromParent_Done,
     /*   22364 */   // Label 446: @22364
     /*   22364 */   GIM_Try, /*On fail goto*//*Label 447*/ GIMT_Encode4(22460), // Rule ID 71136 //
     /*   22369 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   22372 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   22376 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   22380 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   22384 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s16,
     /*   22388 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   22390 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   22394 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   22398 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   22402 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   22404 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22409 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   22413 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   22417 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   22421 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   22423 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22428 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22432 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   22434 */     // (add:{ *:[nxv2i16] } (mul:{ *:[nxv2i16] } (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv2i16] }:$rd)  =>  (PseudoVWMACCSU_VV_MF4:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   22434 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF4),
     /*   22437 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   22439 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   22441 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   22445 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   22449 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   22452 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   22455 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   22458 */     GIR_RootConstrainSelectedInstOperands,
     /*   22459 */     // GIR_Coverage, 71136,
     /*   22459 */     GIR_EraseRootFromParent_Done,
     /*   22460 */   // Label 447: @22460
     /*   22460 */   GIM_Try, /*On fail goto*//*Label 448*/ GIMT_Encode4(22556), // Rule ID 71137 //
     /*   22465 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   22468 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   22472 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   22476 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   22480 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s16,
     /*   22484 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   22486 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   22490 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   22494 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   22498 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   22500 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22505 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   22509 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   22513 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   22517 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   22519 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22524 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22528 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   22530 */     // (add:{ *:[nxv2i16] } (mul:{ *:[nxv2i16] } (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv2i16] }:$rd)  =>  (PseudoVWMACCSU_VV_MF4:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   22530 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF4),
     /*   22533 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   22535 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   22537 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   22541 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   22545 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   22548 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   22551 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   22554 */     GIR_RootConstrainSelectedInstOperands,
     /*   22555 */     // GIR_Coverage, 71137,
     /*   22555 */     GIR_EraseRootFromParent_Done,
     /*   22556 */   // Label 448: @22556
     /*   22556 */   GIM_Try, /*On fail goto*//*Label 449*/ GIMT_Encode4(22652), // Rule ID 71138 //
     /*   22561 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   22564 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   22568 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   22572 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   22576 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s16,
     /*   22580 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   22582 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   22586 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   22590 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   22594 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   22596 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22601 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   22605 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   22609 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   22613 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   22615 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22620 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22624 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   22626 */     // (add:{ *:[nxv2i16] } (mul:{ *:[nxv2i16] } (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv2i16] }:$rd)  =>  (PseudoVWMACCSU_VV_MF4:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   22626 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF4),
     /*   22629 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   22631 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   22633 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   22637 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   22641 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   22644 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   22647 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   22650 */     GIR_RootConstrainSelectedInstOperands,
     /*   22651 */     // GIR_Coverage, 71138,
     /*   22651 */     GIR_EraseRootFromParent_Done,
     /*   22652 */   // Label 449: @22652
     /*   22652 */   GIM_Try, /*On fail goto*//*Label 450*/ GIMT_Encode4(22748), // Rule ID 71009 //
     /*   22657 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   22660 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   22664 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   22668 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   22672 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s16,
     /*   22676 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   22678 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   22682 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   22686 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   22690 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   22692 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22697 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   22701 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   22705 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   22709 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   22711 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22716 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22720 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   22722 */     // (add:{ *:[nxv2i16] } (mul:{ *:[nxv2i16] } (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv2i16] }:$rd)  =>  (PseudoVWMACCU_VV_MF4:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   22722 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_MF4),
     /*   22725 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   22727 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   22729 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   22733 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   22737 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   22740 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   22743 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   22746 */     GIR_RootConstrainSelectedInstOperands,
     /*   22747 */     // GIR_Coverage, 71009,
     /*   22747 */     GIR_EraseRootFromParent_Done,
     /*   22748 */   // Label 450: @22748
     /*   22748 */   GIM_Try, /*On fail goto*//*Label 451*/ GIMT_Encode4(22844), // Rule ID 71010 //
     /*   22753 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   22756 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   22760 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   22764 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   22768 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s16,
     /*   22772 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   22774 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   22778 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   22782 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   22786 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   22788 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22793 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   22797 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   22801 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   22805 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   22807 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22812 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22816 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   22818 */     // (add:{ *:[nxv2i16] } (mul:{ *:[nxv2i16] } (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv2i16] }:$rd)  =>  (PseudoVWMACCU_VV_MF4:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   22818 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_MF4),
     /*   22821 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   22823 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   22825 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   22829 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   22833 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   22836 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   22839 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   22842 */     GIR_RootConstrainSelectedInstOperands,
     /*   22843 */     // GIR_Coverage, 71010,
     /*   22843 */     GIR_EraseRootFromParent_Done,
     /*   22844 */   // Label 451: @22844
     /*   22844 */   GIM_Try, /*On fail goto*//*Label 452*/ GIMT_Encode4(22940), // Rule ID 52038 //
     /*   22849 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   22852 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22856 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   22860 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   22864 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   22868 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s16,
     /*   22872 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   22874 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   22878 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   22882 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   22886 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   22888 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22893 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   22897 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   22901 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   22905 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   22907 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22912 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   22914 */     // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, (mul:{ *:[nxv2i16] } (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACC_VV_MF4:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   22914 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_MF4),
     /*   22917 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   22919 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   22921 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   22925 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   22929 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   22932 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   22935 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   22938 */     GIR_RootConstrainSelectedInstOperands,
     /*   22939 */     // GIR_Coverage, 52038,
     /*   22939 */     GIR_EraseRootFromParent_Done,
     /*   22940 */   // Label 452: @22940
     /*   22940 */   GIM_Try, /*On fail goto*//*Label 453*/ GIMT_Encode4(23036), // Rule ID 52039 //
     /*   22945 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   22948 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22952 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   22956 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   22960 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   22964 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s16,
     /*   22968 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   22970 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   22974 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   22978 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   22982 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   22984 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   22989 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   22993 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   22997 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   23001 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   23003 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23008 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   23010 */     // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, (mul:{ *:[nxv2i16] } (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACC_VV_MF4:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   23010 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_MF4),
     /*   23013 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   23015 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   23017 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   23021 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   23025 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   23028 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   23031 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   23034 */     GIR_RootConstrainSelectedInstOperands,
     /*   23035 */     // GIR_Coverage, 52039,
     /*   23035 */     GIR_EraseRootFromParent_Done,
     /*   23036 */   // Label 453: @23036
     /*   23036 */   GIM_Try, /*On fail goto*//*Label 454*/ GIMT_Encode4(23132), // Rule ID 52156 //
     /*   23041 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   23044 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23048 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   23052 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   23056 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   23060 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s16,
     /*   23064 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   23066 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   23070 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   23074 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   23078 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   23080 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23085 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   23089 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   23093 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   23097 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   23099 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23104 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   23106 */     // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, (mul:{ *:[nxv2i16] } (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_MF4:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   23106 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF4),
     /*   23109 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   23111 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   23113 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   23117 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   23121 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   23124 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   23127 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   23130 */     GIR_RootConstrainSelectedInstOperands,
     /*   23131 */     // GIR_Coverage, 52156,
     /*   23131 */     GIR_EraseRootFromParent_Done,
     /*   23132 */   // Label 454: @23132
     /*   23132 */   GIM_Try, /*On fail goto*//*Label 455*/ GIMT_Encode4(23228), // Rule ID 52157 //
     /*   23137 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   23140 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23144 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   23148 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   23152 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   23156 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s16,
     /*   23160 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   23162 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   23166 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   23170 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   23174 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   23176 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23181 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   23185 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   23189 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   23193 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   23195 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23200 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   23202 */     // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, (mul:{ *:[nxv2i16] } (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_MF4:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   23202 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF4),
     /*   23205 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   23207 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   23209 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   23213 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   23217 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   23220 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   23223 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   23226 */     GIR_RootConstrainSelectedInstOperands,
     /*   23227 */     // GIR_Coverage, 52157,
     /*   23227 */     GIR_EraseRootFromParent_Done,
     /*   23228 */   // Label 455: @23228
     /*   23228 */   GIM_Try, /*On fail goto*//*Label 456*/ GIMT_Encode4(23324), // Rule ID 71133 //
     /*   23233 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   23236 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23240 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   23244 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   23248 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   23252 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s16,
     /*   23256 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   23258 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   23262 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   23266 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   23270 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   23272 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23277 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   23281 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   23285 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   23289 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   23291 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23296 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   23298 */     // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, (mul:{ *:[nxv2i16] } (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_MF4:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   23298 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF4),
     /*   23301 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   23303 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   23305 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   23309 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   23313 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   23316 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   23319 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   23322 */     GIR_RootConstrainSelectedInstOperands,
     /*   23323 */     // GIR_Coverage, 71133,
     /*   23323 */     GIR_EraseRootFromParent_Done,
     /*   23324 */   // Label 456: @23324
     /*   23324 */   GIM_Try, /*On fail goto*//*Label 457*/ GIMT_Encode4(23420), // Rule ID 71134 //
     /*   23329 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   23332 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23336 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   23340 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   23344 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   23348 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s16,
     /*   23352 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   23354 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   23358 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   23362 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   23366 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   23368 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23373 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   23377 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   23381 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   23385 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   23387 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23392 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   23394 */     // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, (mul:{ *:[nxv2i16] } (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_MF4:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   23394 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF4),
     /*   23397 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   23399 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   23401 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   23405 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   23409 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   23412 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   23415 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   23418 */     GIR_RootConstrainSelectedInstOperands,
     /*   23419 */     // GIR_Coverage, 71134,
     /*   23419 */     GIR_EraseRootFromParent_Done,
     /*   23420 */   // Label 457: @23420
     /*   23420 */   GIM_Try, /*On fail goto*//*Label 458*/ GIMT_Encode4(23516), // Rule ID 52096 //
     /*   23425 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   23428 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23432 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   23436 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   23440 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   23444 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s16,
     /*   23448 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   23450 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   23454 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   23458 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   23462 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   23464 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23469 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   23473 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   23477 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   23481 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   23483 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23488 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   23490 */     // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, (mul:{ *:[nxv2i16] } (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCU_VV_MF4:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   23490 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_MF4),
     /*   23493 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   23495 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   23497 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   23501 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   23505 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   23508 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   23511 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   23514 */     GIR_RootConstrainSelectedInstOperands,
     /*   23515 */     // GIR_Coverage, 52096,
     /*   23515 */     GIR_EraseRootFromParent_Done,
     /*   23516 */   // Label 458: @23516
     /*   23516 */   GIM_Try, /*On fail goto*//*Label 459*/ GIMT_Encode4(23612), // Rule ID 52097 //
     /*   23521 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   23524 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23528 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   23532 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   23536 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   23540 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s16,
     /*   23544 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   23546 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   23550 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   23554 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   23558 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   23560 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23565 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   23569 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   23573 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   23577 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   23579 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23584 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   23586 */     // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, (mul:{ *:[nxv2i16] } (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCU_VV_MF4:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, VR:{ *:[nxv2i8] }:$rs1, VR:{ *:[nxv2i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   23586 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_MF4),
     /*   23589 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   23591 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   23593 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   23597 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   23601 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   23604 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   23607 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   23610 */     GIR_RootConstrainSelectedInstOperands,
     /*   23611 */     // GIR_Coverage, 52097,
     /*   23611 */     GIR_EraseRootFromParent_Done,
     /*   23612 */   // Label 459: @23612
     /*   23612 */   GIM_Try, /*On fail goto*//*Label 460*/ GIMT_Encode4(23701), // Rule ID 46684 //
     /*   23617 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   23620 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   23624 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   23628 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   23632 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   23634 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23639 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   23643 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   23647 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   23651 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   23653 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23658 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   23660 */     // (add:{ *:[nxv2i16] } (anyext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs2)<<P:Predicate_anyext_oneuse>>, (anyext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_VV_MF4:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i8] }:$rs2, VR:{ *:[nxv2i8] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
     /*   23660 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
     /*   23663 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   23667 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   23672 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   23674 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_MF4),
     /*   23677 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   23679 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   23682 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   23686 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   23690 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   23693 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   23696 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   23699 */     GIR_RootConstrainSelectedInstOperands,
     /*   23700 */     // GIR_Coverage, 46684,
     /*   23700 */     GIR_EraseRootFromParent_Done,
     /*   23701 */   // Label 460: @23701
     /*   23701 */   GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(23790), // Rule ID 46685 //
     /*   23706 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   23709 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   23713 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   23717 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   23721 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   23723 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23728 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   23732 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   23736 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   23740 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   23742 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23747 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   23749 */     // (add:{ *:[nxv2i16] } (anyext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs2)<<P:Predicate_anyext_oneuse>>, (anyext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_VV_MF4:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i8] }:$rs2, VR:{ *:[nxv2i8] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
     /*   23749 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
     /*   23752 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   23756 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   23761 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   23763 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_MF4),
     /*   23766 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   23768 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   23771 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   23775 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   23779 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   23782 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   23785 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   23788 */     GIR_RootConstrainSelectedInstOperands,
     /*   23789 */     // GIR_Coverage, 46685,
     /*   23789 */     GIR_EraseRootFromParent_Done,
     /*   23790 */   // Label 461: @23790
     /*   23790 */   GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(23879), // Rule ID 46448 //
     /*   23795 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   23798 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   23802 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   23806 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   23810 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   23812 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23817 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   23821 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   23825 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   23829 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   23831 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23836 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   23838 */     // (add:{ *:[nxv2i16] } (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs2)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_VV_MF4:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i8] }:$rs2, VR:{ *:[nxv2i8] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
     /*   23838 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
     /*   23841 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   23845 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   23850 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   23852 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_VV_MF4),
     /*   23855 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   23857 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   23860 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   23864 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   23868 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   23871 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   23874 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   23877 */     GIR_RootConstrainSelectedInstOperands,
     /*   23878 */     // GIR_Coverage, 46448,
     /*   23878 */     GIR_EraseRootFromParent_Done,
     /*   23879 */   // Label 462: @23879
     /*   23879 */   GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(23968), // Rule ID 46449 //
     /*   23884 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   23887 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   23891 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   23895 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   23899 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   23901 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23906 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   23910 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   23914 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   23918 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   23920 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23925 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   23927 */     // (add:{ *:[nxv2i16] } (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs2)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_VV_MF4:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i8] }:$rs2, VR:{ *:[nxv2i8] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
     /*   23927 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
     /*   23930 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   23934 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   23939 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   23941 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_VV_MF4),
     /*   23944 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   23946 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   23949 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   23953 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   23957 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   23960 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   23963 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   23966 */     GIR_RootConstrainSelectedInstOperands,
     /*   23967 */     // GIR_Coverage, 46449,
     /*   23967 */     GIR_EraseRootFromParent_Done,
     /*   23968 */   // Label 463: @23968
     /*   23968 */   GIM_Try, /*On fail goto*//*Label 464*/ GIMT_Encode4(24057), // Rule ID 46564 //
     /*   23973 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   23976 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   23980 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   23984 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   23988 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   23990 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   23995 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   23999 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   24003 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   24007 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   24009 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24014 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   24016 */     // (add:{ *:[nxv2i16] } (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs2)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_VV_MF4:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i8] }:$rs2, VR:{ *:[nxv2i8] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
     /*   24016 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
     /*   24019 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   24023 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   24028 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   24030 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_MF4),
     /*   24033 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   24035 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   24038 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   24042 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   24046 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   24049 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   24052 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   24055 */     GIR_RootConstrainSelectedInstOperands,
     /*   24056 */     // GIR_Coverage, 46564,
     /*   24056 */     GIR_EraseRootFromParent_Done,
     /*   24057 */   // Label 464: @24057
     /*   24057 */   GIM_Try, /*On fail goto*//*Label 465*/ GIMT_Encode4(24146), // Rule ID 46565 //
     /*   24062 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   24065 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   24069 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   24073 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   24077 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   24079 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24084 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   24088 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   24092 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   24096 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   24098 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24103 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   24105 */     // (add:{ *:[nxv2i16] } (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs2)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_VV_MF4:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i8] }:$rs2, VR:{ *:[nxv2i8] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
     /*   24105 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
     /*   24108 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   24112 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   24117 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   24119 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_MF4),
     /*   24122 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   24124 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   24127 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   24131 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   24135 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   24138 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   24141 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   24144 */     GIR_RootConstrainSelectedInstOperands,
     /*   24145 */     // GIR_Coverage, 46565,
     /*   24145 */     GIR_EraseRootFromParent_Done,
     /*   24146 */   // Label 465: @24146
     /*   24146 */   GIM_Try, /*On fail goto*//*Label 466*/ GIMT_Encode4(24214), // Rule ID 70707 //
     /*   24151 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   24154 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   24158 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   24162 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   24166 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s16,
     /*   24170 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   24172 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24177 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24182 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24186 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   24188 */     // (add:{ *:[nxv2i16] } (mul:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rd)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVMADD_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   24188 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF2),
     /*   24191 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   24193 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   24197 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   24201 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   24203 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   24206 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   24209 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   24212 */     GIR_RootConstrainSelectedInstOperands,
     /*   24213 */     // GIR_Coverage, 70707,
     /*   24213 */     GIR_EraseRootFromParent_Done,
     /*   24214 */   // Label 466: @24214
     /*   24214 */   GIM_Try, /*On fail goto*//*Label 467*/ GIMT_Encode4(24282), // Rule ID 70708 //
     /*   24219 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   24222 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   24226 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   24230 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   24234 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s16,
     /*   24238 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   24240 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24245 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24250 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24254 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   24256 */     // (add:{ *:[nxv2i16] } (mul:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rd)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVMADD_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   24256 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF2),
     /*   24259 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   24261 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   24265 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   24269 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   24271 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   24274 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   24277 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   24280 */     GIR_RootConstrainSelectedInstOperands,
     /*   24281 */     // GIR_Coverage, 70708,
     /*   24281 */     GIR_EraseRootFromParent_Done,
     /*   24282 */   // Label 467: @24282
     /*   24282 */   GIM_Try, /*On fail goto*//*Label 468*/ GIMT_Encode4(24337), // Rule ID 69695 //
     /*   24287 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   24290 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   24294 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   24298 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   24302 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   24304 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24309 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24313 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   24315 */     // (add:{ *:[nxv2i16] } (anyext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_anyext_oneuse>>, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVWADDU_WV_MF4_TIED:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs2, VR:{ *:[nxv2i8] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   24315 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF4_TIED),
     /*   24318 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   24320 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   24322 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   24326 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   24329 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   24332 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   24335 */     GIR_RootConstrainSelectedInstOperands,
     /*   24336 */     // GIR_Coverage, 69695,
     /*   24336 */     GIR_EraseRootFromParent_Done,
     /*   24337 */   // Label 468: @24337
     /*   24337 */   GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(24392), // Rule ID 69696 //
     /*   24342 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   24345 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   24349 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   24353 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   24357 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   24359 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24364 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24368 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   24370 */     // (add:{ *:[nxv2i16] } (anyext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_anyext_oneuse>>, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVWADDU_WV_MF4_TIED:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs2, VR:{ *:[nxv2i8] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   24370 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF4_TIED),
     /*   24373 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   24375 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   24377 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   24381 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   24384 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   24387 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   24390 */     GIR_RootConstrainSelectedInstOperands,
     /*   24391 */     // GIR_Coverage, 69696,
     /*   24391 */     GIR_EraseRootFromParent_Done,
     /*   24392 */   // Label 469: @24392
     /*   24392 */   GIM_Try, /*On fail goto*//*Label 470*/ GIMT_Encode4(24447), // Rule ID 69515 //
     /*   24397 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   24400 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   24404 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   24408 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   24412 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   24414 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24419 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24423 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   24425 */     // (add:{ *:[nxv2i16] } (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_sext_oneuse>>, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVWADD_WV_MF4_TIED:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs2, VR:{ *:[nxv2i8] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   24425 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_MF4_TIED),
     /*   24428 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   24430 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   24432 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   24436 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   24439 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   24442 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   24445 */     GIR_RootConstrainSelectedInstOperands,
     /*   24446 */     // GIR_Coverage, 69515,
     /*   24446 */     GIR_EraseRootFromParent_Done,
     /*   24447 */   // Label 470: @24447
     /*   24447 */   GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(24502), // Rule ID 69516 //
     /*   24452 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   24455 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   24459 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   24463 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   24467 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   24469 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24474 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24478 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   24480 */     // (add:{ *:[nxv2i16] } (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_sext_oneuse>>, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVWADD_WV_MF4_TIED:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs2, VR:{ *:[nxv2i8] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   24480 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_MF4_TIED),
     /*   24483 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   24485 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   24487 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   24491 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   24494 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   24497 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   24500 */     GIR_RootConstrainSelectedInstOperands,
     /*   24501 */     // GIR_Coverage, 69516,
     /*   24501 */     GIR_EraseRootFromParent_Done,
     /*   24502 */   // Label 471: @24502
     /*   24502 */   GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(24557), // Rule ID 69605 //
     /*   24507 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   24510 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   24514 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   24518 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   24522 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   24524 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24529 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24533 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   24535 */     // (add:{ *:[nxv2i16] } (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_zext_oneuse>>, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVWADDU_WV_MF4_TIED:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs2, VR:{ *:[nxv2i8] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   24535 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF4_TIED),
     /*   24538 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   24540 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   24542 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   24546 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   24549 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   24552 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   24555 */     GIR_RootConstrainSelectedInstOperands,
     /*   24556 */     // GIR_Coverage, 69605,
     /*   24556 */     GIR_EraseRootFromParent_Done,
     /*   24557 */   // Label 472: @24557
     /*   24557 */   GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(24612), // Rule ID 69606 //
     /*   24562 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   24565 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   24569 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   24573 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   24577 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   24579 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24584 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24588 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   24590 */     // (add:{ *:[nxv2i16] } (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_zext_oneuse>>, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVWADDU_WV_MF4_TIED:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs2, VR:{ *:[nxv2i8] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   24590 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF4_TIED),
     /*   24593 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   24595 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   24597 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   24601 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   24604 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   24607 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   24610 */     GIR_RootConstrainSelectedInstOperands,
     /*   24611 */     // GIR_Coverage, 69606,
     /*   24611 */     GIR_EraseRootFromParent_Done,
     /*   24612 */   // Label 473: @24612
     /*   24612 */   GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(24680), // Rule ID 51878 //
     /*   24617 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   24620 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24624 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   24628 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   24632 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   24636 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s16,
     /*   24640 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   24642 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24647 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24652 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   24654 */     // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs2, (mul:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rd)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVMADD_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   24654 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF2),
     /*   24657 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   24659 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   24663 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   24667 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   24669 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   24672 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   24675 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   24678 */     GIR_RootConstrainSelectedInstOperands,
     /*   24679 */     // GIR_Coverage, 51878,
     /*   24679 */     GIR_EraseRootFromParent_Done,
     /*   24680 */   // Label 474: @24680
     /*   24680 */   GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(24748), // Rule ID 51879 //
     /*   24685 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   24688 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24692 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   24696 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   24700 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   24704 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s16,
     /*   24708 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   24710 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24715 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24720 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   24722 */     // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs2, (mul:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rd)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVMADD_VV_MF2:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rd, VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   24722 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF2),
     /*   24725 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   24727 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   24731 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   24735 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   24737 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   24740 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   24743 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   24746 */     GIR_RootConstrainSelectedInstOperands,
     /*   24747 */     // GIR_Coverage, 51879,
     /*   24747 */     GIR_EraseRootFromParent_Done,
     /*   24748 */   // Label 475: @24748
     /*   24748 */   GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(24803), // Rule ID 46744 //
     /*   24753 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   24756 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24760 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   24764 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   24768 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   24772 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   24774 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24779 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   24781 */     // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs2, (anyext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_WV_MF4_TIED:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs2, VR:{ *:[nxv2i8] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   24781 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF4_TIED),
     /*   24784 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   24786 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   24788 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   24792 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   24795 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   24798 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   24801 */     GIR_RootConstrainSelectedInstOperands,
     /*   24802 */     // GIR_Coverage, 46744,
     /*   24802 */     GIR_EraseRootFromParent_Done,
     /*   24803 */   // Label 476: @24803
     /*   24803 */   GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(24858), // Rule ID 46745 //
     /*   24808 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   24811 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24815 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   24819 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   24823 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   24827 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   24829 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24834 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   24836 */     // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs2, (anyext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_WV_MF4_TIED:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs2, VR:{ *:[nxv2i8] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   24836 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF4_TIED),
     /*   24839 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   24841 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   24843 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   24847 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   24850 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   24853 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   24856 */     GIR_RootConstrainSelectedInstOperands,
     /*   24857 */     // GIR_Coverage, 46745,
     /*   24857 */     GIR_EraseRootFromParent_Done,
     /*   24858 */   // Label 477: @24858
     /*   24858 */   GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(24913), // Rule ID 46504 //
     /*   24863 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   24866 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24870 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   24874 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   24878 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   24882 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   24884 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24889 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   24891 */     // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs2, (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_WV_MF4_TIED:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs2, VR:{ *:[nxv2i8] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   24891 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_MF4_TIED),
     /*   24894 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   24896 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   24898 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   24902 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   24905 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   24908 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   24911 */     GIR_RootConstrainSelectedInstOperands,
     /*   24912 */     // GIR_Coverage, 46504,
     /*   24912 */     GIR_EraseRootFromParent_Done,
     /*   24913 */   // Label 478: @24913
     /*   24913 */   GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(24968), // Rule ID 46505 //
     /*   24918 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   24921 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24925 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   24929 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   24933 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   24937 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   24939 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24944 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   24946 */     // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs2, (sext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_WV_MF4_TIED:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs2, VR:{ *:[nxv2i8] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   24946 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_MF4_TIED),
     /*   24949 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   24951 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   24953 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   24957 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   24960 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   24963 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   24966 */     GIR_RootConstrainSelectedInstOperands,
     /*   24967 */     // GIR_Coverage, 46505,
     /*   24967 */     GIR_EraseRootFromParent_Done,
     /*   24968 */   // Label 479: @24968
     /*   24968 */   GIM_Try, /*On fail goto*//*Label 480*/ GIMT_Encode4(25023), // Rule ID 46624 //
     /*   24973 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   24976 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24980 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   24984 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   24988 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   24992 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   24994 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   24999 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   25001 */     // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs2, (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_WV_MF4_TIED:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs2, VR:{ *:[nxv2i8] }:$rs1, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   25001 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF4_TIED),
     /*   25004 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   25006 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   25008 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   25012 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   25015 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   25018 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   25021 */     GIR_RootConstrainSelectedInstOperands,
     /*   25022 */     // GIR_Coverage, 46624,
     /*   25022 */     GIR_EraseRootFromParent_Done,
     /*   25023 */   // Label 480: @25023
     /*   25023 */   GIM_Try, /*On fail goto*//*Label 481*/ GIMT_Encode4(25078), // Rule ID 46625 //
     /*   25028 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   25031 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25035 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   25039 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   25043 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s8,
     /*   25047 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   25049 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25054 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   25056 */     // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs2, (zext:{ *:[nxv2i16] } VR:{ *:[nxv2i8] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_WV_MF4_TIED:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs2, VR:{ *:[nxv2i8] }:$rs1, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   25056 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF4_TIED),
     /*   25059 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   25061 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   25063 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   25067 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   25070 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   25073 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   25076 */     GIR_RootConstrainSelectedInstOperands,
     /*   25077 */     // GIR_Coverage, 46625,
     /*   25077 */     GIR_EraseRootFromParent_Done,
     /*   25078 */   // Label 481: @25078
     /*   25078 */   GIM_Try, /*On fail goto*//*Label 482*/ GIMT_Encode4(25131), // Rule ID 46110 //
     /*   25083 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   25086 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25090 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25094 */     // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
     /*   25094 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
     /*   25097 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   25101 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   25106 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   25108 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
     /*   25111 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   25113 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   25116 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*   25118 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   25120 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   25123 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   25126 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   25129 */     GIR_RootConstrainSelectedInstOperands,
     /*   25130 */     // GIR_Coverage, 46110,
     /*   25130 */     GIR_EraseRootFromParent_Done,
     /*   25131 */   // Label 482: @25131
     /*   25131 */   GIM_Try, /*On fail goto*//*Label 483*/ GIMT_Encode4(25184), // Rule ID 46111 //
     /*   25136 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   25139 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25143 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25147 */     // (add:{ *:[nxv2i16] } VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv2i16] } (IMPLICIT_DEF:{ *:[nxv2i16] }), VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
     /*   25147 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s16,
     /*   25150 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   25154 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   25159 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   25161 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
     /*   25164 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   25166 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   25169 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*   25171 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   25173 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   25176 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   25179 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   25182 */     GIR_RootConstrainSelectedInstOperands,
     /*   25183 */     // GIR_Coverage, 46111,
     /*   25183 */     GIR_EraseRootFromParent_Done,
     /*   25184 */   // Label 483: @25184
     /*   25184 */   GIM_Reject,
     /*   25185 */ // Label 443: @25185
     /*   25185 */ GIM_Reject,
     /*   25186 */ // Label 134: @25186
     /*   25186 */ GIM_Try, /*On fail goto*//*Label 484*/ GIMT_Encode4(28310),
     /*   25191 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   25194 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s32,
     /*   25197 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25201 */   GIM_Try, /*On fail goto*//*Label 485*/ GIMT_Encode4(25297), // Rule ID 70907 //
     /*   25206 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   25209 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   25213 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   25217 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   25221 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s32,
     /*   25225 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   25227 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   25231 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   25235 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   25239 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   25241 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25246 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   25250 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   25254 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   25258 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   25260 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25265 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25269 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   25271 */     // (add:{ *:[nxv2i32] } (mul:{ *:[nxv2i32] } (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv2i32] }:$rd)  =>  (PseudoVWMACC_VV_MF2:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   25271 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_MF2),
     /*   25274 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   25276 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   25278 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   25282 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   25286 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   25289 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   25292 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   25295 */     GIR_RootConstrainSelectedInstOperands,
     /*   25296 */     // GIR_Coverage, 70907,
     /*   25296 */     GIR_EraseRootFromParent_Done,
     /*   25297 */   // Label 485: @25297
     /*   25297 */   GIM_Try, /*On fail goto*//*Label 486*/ GIMT_Encode4(25393), // Rule ID 70908 //
     /*   25302 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   25305 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   25309 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   25313 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   25317 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s32,
     /*   25321 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   25323 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   25327 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   25331 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   25335 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   25337 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25342 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   25346 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   25350 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   25354 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   25356 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25361 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25365 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   25367 */     // (add:{ *:[nxv2i32] } (mul:{ *:[nxv2i32] } (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv2i32] }:$rd)  =>  (PseudoVWMACC_VV_MF2:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   25367 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_MF2),
     /*   25370 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   25372 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   25374 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   25378 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   25382 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   25385 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   25388 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   25391 */     GIR_RootConstrainSelectedInstOperands,
     /*   25392 */     // GIR_Coverage, 70908,
     /*   25392 */     GIR_EraseRootFromParent_Done,
     /*   25393 */   // Label 486: @25393
     /*   25393 */   GIM_Try, /*On fail goto*//*Label 487*/ GIMT_Encode4(25489), // Rule ID 71171 //
     /*   25398 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   25401 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   25405 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   25409 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   25413 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s32,
     /*   25417 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   25419 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   25423 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   25427 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   25431 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   25433 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25438 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   25442 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   25446 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   25450 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   25452 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25457 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25461 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   25463 */     // (add:{ *:[nxv2i32] } (mul:{ *:[nxv2i32] } (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv2i32] }:$rd)  =>  (PseudoVWMACCSU_VV_MF2:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   25463 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF2),
     /*   25466 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   25468 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   25470 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   25474 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   25478 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   25481 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   25484 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   25487 */     GIR_RootConstrainSelectedInstOperands,
     /*   25488 */     // GIR_Coverage, 71171,
     /*   25488 */     GIR_EraseRootFromParent_Done,
     /*   25489 */   // Label 487: @25489
     /*   25489 */   GIM_Try, /*On fail goto*//*Label 488*/ GIMT_Encode4(25585), // Rule ID 71172 //
     /*   25494 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   25497 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   25501 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   25505 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   25509 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s32,
     /*   25513 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   25515 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   25519 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   25523 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   25527 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   25529 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25534 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   25538 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   25542 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   25546 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   25548 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25553 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25557 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   25559 */     // (add:{ *:[nxv2i32] } (mul:{ *:[nxv2i32] } (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv2i32] }:$rd)  =>  (PseudoVWMACCSU_VV_MF2:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   25559 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF2),
     /*   25562 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   25564 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   25566 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   25570 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   25574 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   25577 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   25580 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   25583 */     GIR_RootConstrainSelectedInstOperands,
     /*   25584 */     // GIR_Coverage, 71172,
     /*   25584 */     GIR_EraseRootFromParent_Done,
     /*   25585 */   // Label 488: @25585
     /*   25585 */   GIM_Try, /*On fail goto*//*Label 489*/ GIMT_Encode4(25681), // Rule ID 71173 //
     /*   25590 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   25593 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   25597 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   25601 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   25605 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s32,
     /*   25609 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   25611 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   25615 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   25619 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   25623 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   25625 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25630 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   25634 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   25638 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   25642 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   25644 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25649 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25653 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   25655 */     // (add:{ *:[nxv2i32] } (mul:{ *:[nxv2i32] } (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv2i32] }:$rd)  =>  (PseudoVWMACCSU_VV_MF2:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   25655 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF2),
     /*   25658 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   25660 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   25662 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   25666 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   25670 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   25673 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   25676 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   25679 */     GIR_RootConstrainSelectedInstOperands,
     /*   25680 */     // GIR_Coverage, 71173,
     /*   25680 */     GIR_EraseRootFromParent_Done,
     /*   25681 */   // Label 489: @25681
     /*   25681 */   GIM_Try, /*On fail goto*//*Label 490*/ GIMT_Encode4(25777), // Rule ID 71174 //
     /*   25686 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   25689 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   25693 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   25697 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   25701 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s32,
     /*   25705 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   25707 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   25711 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   25715 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   25719 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   25721 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25726 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   25730 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   25734 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   25738 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   25740 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25745 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25749 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   25751 */     // (add:{ *:[nxv2i32] } (mul:{ *:[nxv2i32] } (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv2i32] }:$rd)  =>  (PseudoVWMACCSU_VV_MF2:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   25751 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF2),
     /*   25754 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   25756 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   25758 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   25762 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   25766 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   25769 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   25772 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   25775 */     GIR_RootConstrainSelectedInstOperands,
     /*   25776 */     // GIR_Coverage, 71174,
     /*   25776 */     GIR_EraseRootFromParent_Done,
     /*   25777 */   // Label 490: @25777
     /*   25777 */   GIM_Try, /*On fail goto*//*Label 491*/ GIMT_Encode4(25873), // Rule ID 71021 //
     /*   25782 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   25785 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   25789 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   25793 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   25797 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s32,
     /*   25801 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   25803 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   25807 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   25811 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   25815 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   25817 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25822 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   25826 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   25830 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   25834 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   25836 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25841 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25845 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   25847 */     // (add:{ *:[nxv2i32] } (mul:{ *:[nxv2i32] } (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv2i32] }:$rd)  =>  (PseudoVWMACCU_VV_MF2:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   25847 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_MF2),
     /*   25850 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   25852 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   25854 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   25858 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   25862 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   25865 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   25868 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   25871 */     GIR_RootConstrainSelectedInstOperands,
     /*   25872 */     // GIR_Coverage, 71021,
     /*   25872 */     GIR_EraseRootFromParent_Done,
     /*   25873 */   // Label 491: @25873
     /*   25873 */   GIM_Try, /*On fail goto*//*Label 492*/ GIMT_Encode4(25969), // Rule ID 71022 //
     /*   25878 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   25881 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   25885 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   25889 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   25893 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s32,
     /*   25897 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   25899 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   25903 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   25907 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   25911 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   25913 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25918 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   25922 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   25926 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   25930 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   25932 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25937 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25941 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   25943 */     // (add:{ *:[nxv2i32] } (mul:{ *:[nxv2i32] } (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv2i32] }:$rd)  =>  (PseudoVWMACCU_VV_MF2:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   25943 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_MF2),
     /*   25946 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   25948 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   25950 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   25954 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   25958 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   25961 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   25964 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   25967 */     GIR_RootConstrainSelectedInstOperands,
     /*   25968 */     // GIR_Coverage, 71022,
     /*   25968 */     GIR_EraseRootFromParent_Done,
     /*   25969 */   // Label 492: @25969
     /*   25969 */   GIM_Try, /*On fail goto*//*Label 493*/ GIMT_Encode4(26065), // Rule ID 52050 //
     /*   25974 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   25977 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   25981 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   25985 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   25989 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   25993 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s32,
     /*   25997 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   25999 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   26003 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   26007 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   26011 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   26013 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26018 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   26022 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   26026 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   26030 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   26032 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26037 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   26039 */     // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, (mul:{ *:[nxv2i32] } (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACC_VV_MF2:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   26039 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_MF2),
     /*   26042 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   26044 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   26046 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   26050 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   26054 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   26057 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   26060 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   26063 */     GIR_RootConstrainSelectedInstOperands,
     /*   26064 */     // GIR_Coverage, 52050,
     /*   26064 */     GIR_EraseRootFromParent_Done,
     /*   26065 */   // Label 493: @26065
     /*   26065 */   GIM_Try, /*On fail goto*//*Label 494*/ GIMT_Encode4(26161), // Rule ID 52051 //
     /*   26070 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   26073 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26077 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   26081 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   26085 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   26089 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s32,
     /*   26093 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   26095 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   26099 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   26103 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   26107 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   26109 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26114 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   26118 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   26122 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   26126 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   26128 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26133 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   26135 */     // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, (mul:{ *:[nxv2i32] } (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACC_VV_MF2:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   26135 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_MF2),
     /*   26138 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   26140 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   26142 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   26146 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   26150 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   26153 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   26156 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   26159 */     GIR_RootConstrainSelectedInstOperands,
     /*   26160 */     // GIR_Coverage, 52051,
     /*   26160 */     GIR_EraseRootFromParent_Done,
     /*   26161 */   // Label 494: @26161
     /*   26161 */   GIM_Try, /*On fail goto*//*Label 495*/ GIMT_Encode4(26257), // Rule ID 52168 //
     /*   26166 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   26169 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26173 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   26177 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   26181 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   26185 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s32,
     /*   26189 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   26191 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   26195 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   26199 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   26203 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   26205 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26210 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   26214 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   26218 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   26222 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   26224 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26229 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   26231 */     // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, (mul:{ *:[nxv2i32] } (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_MF2:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   26231 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF2),
     /*   26234 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   26236 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   26238 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   26242 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   26246 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   26249 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   26252 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   26255 */     GIR_RootConstrainSelectedInstOperands,
     /*   26256 */     // GIR_Coverage, 52168,
     /*   26256 */     GIR_EraseRootFromParent_Done,
     /*   26257 */   // Label 495: @26257
     /*   26257 */   GIM_Try, /*On fail goto*//*Label 496*/ GIMT_Encode4(26353), // Rule ID 52169 //
     /*   26262 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   26265 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26269 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   26273 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   26277 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   26281 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s32,
     /*   26285 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   26287 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   26291 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   26295 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   26299 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   26301 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26306 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   26310 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   26314 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   26318 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   26320 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26325 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   26327 */     // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, (mul:{ *:[nxv2i32] } (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_MF2:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   26327 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF2),
     /*   26330 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   26332 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   26334 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   26338 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   26342 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   26345 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   26348 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   26351 */     GIR_RootConstrainSelectedInstOperands,
     /*   26352 */     // GIR_Coverage, 52169,
     /*   26352 */     GIR_EraseRootFromParent_Done,
     /*   26353 */   // Label 496: @26353
     /*   26353 */   GIM_Try, /*On fail goto*//*Label 497*/ GIMT_Encode4(26449), // Rule ID 71169 //
     /*   26358 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   26361 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26365 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   26369 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   26373 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   26377 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s32,
     /*   26381 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   26383 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   26387 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   26391 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   26395 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   26397 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26402 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   26406 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   26410 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   26414 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   26416 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26421 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   26423 */     // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, (mul:{ *:[nxv2i32] } (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_MF2:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   26423 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF2),
     /*   26426 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   26428 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   26430 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   26434 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   26438 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   26441 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   26444 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   26447 */     GIR_RootConstrainSelectedInstOperands,
     /*   26448 */     // GIR_Coverage, 71169,
     /*   26448 */     GIR_EraseRootFromParent_Done,
     /*   26449 */   // Label 497: @26449
     /*   26449 */   GIM_Try, /*On fail goto*//*Label 498*/ GIMT_Encode4(26545), // Rule ID 71170 //
     /*   26454 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   26457 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26461 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   26465 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   26469 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   26473 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s32,
     /*   26477 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   26479 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   26483 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   26487 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   26491 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   26493 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26498 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   26502 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   26506 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   26510 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   26512 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26517 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   26519 */     // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, (mul:{ *:[nxv2i32] } (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_MF2:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   26519 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_MF2),
     /*   26522 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   26524 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   26526 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   26530 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   26534 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   26537 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   26540 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   26543 */     GIR_RootConstrainSelectedInstOperands,
     /*   26544 */     // GIR_Coverage, 71170,
     /*   26544 */     GIR_EraseRootFromParent_Done,
     /*   26545 */   // Label 498: @26545
     /*   26545 */   GIM_Try, /*On fail goto*//*Label 499*/ GIMT_Encode4(26641), // Rule ID 52108 //
     /*   26550 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   26553 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26557 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   26561 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   26565 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   26569 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s32,
     /*   26573 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   26575 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   26579 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   26583 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   26587 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   26589 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26594 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   26598 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   26602 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   26606 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   26608 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26613 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   26615 */     // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, (mul:{ *:[nxv2i32] } (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCU_VV_MF2:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   26615 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_MF2),
     /*   26618 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   26620 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   26622 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   26626 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   26630 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   26633 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   26636 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   26639 */     GIR_RootConstrainSelectedInstOperands,
     /*   26640 */     // GIR_Coverage, 52108,
     /*   26640 */     GIR_EraseRootFromParent_Done,
     /*   26641 */   // Label 499: @26641
     /*   26641 */   GIM_Try, /*On fail goto*//*Label 500*/ GIMT_Encode4(26737), // Rule ID 52109 //
     /*   26646 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   26649 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26653 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   26657 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   26661 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   26665 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s32,
     /*   26669 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   26671 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   26675 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   26679 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   26683 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   26685 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26690 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   26694 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   26698 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   26702 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   26704 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26709 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   26711 */     // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, (mul:{ *:[nxv2i32] } (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCU_VV_MF2:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, VR:{ *:[nxv2i16] }:$rs1, VR:{ *:[nxv2i16] }:$rs2, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   26711 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_MF2),
     /*   26714 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   26716 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   26718 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   26722 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   26726 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   26729 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   26732 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   26735 */     GIR_RootConstrainSelectedInstOperands,
     /*   26736 */     // GIR_Coverage, 52109,
     /*   26736 */     GIR_EraseRootFromParent_Done,
     /*   26737 */   // Label 500: @26737
     /*   26737 */   GIM_Try, /*On fail goto*//*Label 501*/ GIMT_Encode4(26826), // Rule ID 46708 //
     /*   26742 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   26745 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   26749 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   26753 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   26757 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   26759 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26764 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   26768 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   26772 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   26776 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   26778 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26783 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   26785 */     // (add:{ *:[nxv2i32] } (anyext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs2)<<P:Predicate_anyext_oneuse>>, (anyext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_VV_MF2:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i16] }:$rs2, VR:{ *:[nxv2i16] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
     /*   26785 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
     /*   26788 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   26792 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   26797 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   26799 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_MF2),
     /*   26802 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   26804 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   26807 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   26811 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   26815 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   26818 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   26821 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   26824 */     GIR_RootConstrainSelectedInstOperands,
     /*   26825 */     // GIR_Coverage, 46708,
     /*   26825 */     GIR_EraseRootFromParent_Done,
     /*   26826 */   // Label 501: @26826
     /*   26826 */   GIM_Try, /*On fail goto*//*Label 502*/ GIMT_Encode4(26915), // Rule ID 46709 //
     /*   26831 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   26834 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   26838 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   26842 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   26846 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   26848 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26853 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   26857 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   26861 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   26865 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   26867 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26872 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   26874 */     // (add:{ *:[nxv2i32] } (anyext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs2)<<P:Predicate_anyext_oneuse>>, (anyext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_VV_MF2:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i16] }:$rs2, VR:{ *:[nxv2i16] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
     /*   26874 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
     /*   26877 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   26881 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   26886 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   26888 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_MF2),
     /*   26891 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   26893 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   26896 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   26900 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   26904 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   26907 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   26910 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   26913 */     GIR_RootConstrainSelectedInstOperands,
     /*   26914 */     // GIR_Coverage, 46709,
     /*   26914 */     GIR_EraseRootFromParent_Done,
     /*   26915 */   // Label 502: @26915
     /*   26915 */   GIM_Try, /*On fail goto*//*Label 503*/ GIMT_Encode4(27004), // Rule ID 46472 //
     /*   26920 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   26923 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   26927 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   26931 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   26935 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   26937 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26942 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   26946 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   26950 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   26954 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   26956 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   26961 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   26963 */     // (add:{ *:[nxv2i32] } (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs2)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_VV_MF2:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i16] }:$rs2, VR:{ *:[nxv2i16] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
     /*   26963 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
     /*   26966 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   26970 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   26975 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   26977 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_VV_MF2),
     /*   26980 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   26982 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   26985 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   26989 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   26993 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   26996 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   26999 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   27002 */     GIR_RootConstrainSelectedInstOperands,
     /*   27003 */     // GIR_Coverage, 46472,
     /*   27003 */     GIR_EraseRootFromParent_Done,
     /*   27004 */   // Label 503: @27004
     /*   27004 */   GIM_Try, /*On fail goto*//*Label 504*/ GIMT_Encode4(27093), // Rule ID 46473 //
     /*   27009 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   27012 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   27016 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   27020 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   27024 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   27026 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27031 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   27035 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   27039 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   27043 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   27045 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27050 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   27052 */     // (add:{ *:[nxv2i32] } (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs2)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_VV_MF2:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i16] }:$rs2, VR:{ *:[nxv2i16] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
     /*   27052 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
     /*   27055 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   27059 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   27064 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   27066 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_VV_MF2),
     /*   27069 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   27071 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   27074 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   27078 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   27082 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   27085 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   27088 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   27091 */     GIR_RootConstrainSelectedInstOperands,
     /*   27092 */     // GIR_Coverage, 46473,
     /*   27092 */     GIR_EraseRootFromParent_Done,
     /*   27093 */   // Label 504: @27093
     /*   27093 */   GIM_Try, /*On fail goto*//*Label 505*/ GIMT_Encode4(27182), // Rule ID 46588 //
     /*   27098 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   27101 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   27105 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   27109 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   27113 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   27115 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27120 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   27124 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   27128 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   27132 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   27134 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27139 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   27141 */     // (add:{ *:[nxv2i32] } (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs2)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_VV_MF2:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i16] }:$rs2, VR:{ *:[nxv2i16] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] }, 3:{ *:[i64] })
     /*   27141 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
     /*   27144 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   27148 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   27153 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   27155 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_MF2),
     /*   27158 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   27160 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   27163 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   27167 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   27171 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   27174 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   27177 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   27180 */     GIR_RootConstrainSelectedInstOperands,
     /*   27181 */     // GIR_Coverage, 46588,
     /*   27181 */     GIR_EraseRootFromParent_Done,
     /*   27182 */   // Label 505: @27182
     /*   27182 */   GIM_Try, /*On fail goto*//*Label 506*/ GIMT_Encode4(27271), // Rule ID 46589 //
     /*   27187 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   27190 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   27194 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   27198 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   27202 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   27204 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27209 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   27213 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   27217 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   27221 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   27223 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27228 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   27230 */     // (add:{ *:[nxv2i32] } (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs2)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_VV_MF2:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i16] }:$rs2, VR:{ *:[nxv2i16] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] }, 3:{ *:[i32] })
     /*   27230 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
     /*   27233 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   27237 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   27242 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   27244 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_MF2),
     /*   27247 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   27249 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   27252 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   27256 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   27260 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   27263 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   27266 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   27269 */     GIR_RootConstrainSelectedInstOperands,
     /*   27270 */     // GIR_Coverage, 46589,
     /*   27270 */     GIR_EraseRootFromParent_Done,
     /*   27271 */   // Label 506: @27271
     /*   27271 */   GIM_Try, /*On fail goto*//*Label 507*/ GIMT_Encode4(27339), // Rule ID 70739 //
     /*   27276 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   27279 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   27283 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   27287 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   27291 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s32,
     /*   27295 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   27297 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27302 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27307 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27311 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   27313 */     // (add:{ *:[nxv2i32] } (mul:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rd)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVMADD_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   27313 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_M1),
     /*   27316 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   27318 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   27322 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   27326 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   27328 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   27331 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   27334 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   27337 */     GIR_RootConstrainSelectedInstOperands,
     /*   27338 */     // GIR_Coverage, 70739,
     /*   27338 */     GIR_EraseRootFromParent_Done,
     /*   27339 */   // Label 507: @27339
     /*   27339 */   GIM_Try, /*On fail goto*//*Label 508*/ GIMT_Encode4(27407), // Rule ID 70740 //
     /*   27344 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   27347 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   27351 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   27355 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   27359 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s32,
     /*   27363 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   27365 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27370 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27375 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27379 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   27381 */     // (add:{ *:[nxv2i32] } (mul:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rd)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVMADD_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   27381 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_M1),
     /*   27384 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   27386 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   27390 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   27394 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   27396 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   27399 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   27402 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   27405 */     GIR_RootConstrainSelectedInstOperands,
     /*   27406 */     // GIR_Coverage, 70740,
     /*   27406 */     GIR_EraseRootFromParent_Done,
     /*   27407 */   // Label 508: @27407
     /*   27407 */   GIM_Try, /*On fail goto*//*Label 509*/ GIMT_Encode4(27462), // Rule ID 69719 //
     /*   27412 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   27415 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   27419 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   27423 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   27427 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   27429 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27434 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27438 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   27440 */     // (add:{ *:[nxv2i32] } (anyext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_anyext_oneuse>>, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVWADDU_WV_MF2_TIED:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs2, VR:{ *:[nxv2i16] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   27440 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF2_TIED),
     /*   27443 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   27445 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   27447 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   27451 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   27454 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   27457 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   27460 */     GIR_RootConstrainSelectedInstOperands,
     /*   27461 */     // GIR_Coverage, 69719,
     /*   27461 */     GIR_EraseRootFromParent_Done,
     /*   27462 */   // Label 509: @27462
     /*   27462 */   GIM_Try, /*On fail goto*//*Label 510*/ GIMT_Encode4(27517), // Rule ID 69720 //
     /*   27467 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   27470 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   27474 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   27478 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   27482 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   27484 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27489 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27493 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   27495 */     // (add:{ *:[nxv2i32] } (anyext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_anyext_oneuse>>, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVWADDU_WV_MF2_TIED:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs2, VR:{ *:[nxv2i16] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   27495 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF2_TIED),
     /*   27498 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   27500 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   27502 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   27506 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   27509 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   27512 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   27515 */     GIR_RootConstrainSelectedInstOperands,
     /*   27516 */     // GIR_Coverage, 69720,
     /*   27516 */     GIR_EraseRootFromParent_Done,
     /*   27517 */   // Label 510: @27517
     /*   27517 */   GIM_Try, /*On fail goto*//*Label 511*/ GIMT_Encode4(27572), // Rule ID 69539 //
     /*   27522 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   27525 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   27529 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   27533 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   27537 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   27539 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27544 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27548 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   27550 */     // (add:{ *:[nxv2i32] } (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_sext_oneuse>>, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVWADD_WV_MF2_TIED:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs2, VR:{ *:[nxv2i16] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   27550 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_MF2_TIED),
     /*   27553 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   27555 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   27557 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   27561 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   27564 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   27567 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   27570 */     GIR_RootConstrainSelectedInstOperands,
     /*   27571 */     // GIR_Coverage, 69539,
     /*   27571 */     GIR_EraseRootFromParent_Done,
     /*   27572 */   // Label 511: @27572
     /*   27572 */   GIM_Try, /*On fail goto*//*Label 512*/ GIMT_Encode4(27627), // Rule ID 69540 //
     /*   27577 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   27580 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   27584 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   27588 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   27592 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   27594 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27599 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27603 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   27605 */     // (add:{ *:[nxv2i32] } (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_sext_oneuse>>, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVWADD_WV_MF2_TIED:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs2, VR:{ *:[nxv2i16] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   27605 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_MF2_TIED),
     /*   27608 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   27610 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   27612 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   27616 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   27619 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   27622 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   27625 */     GIR_RootConstrainSelectedInstOperands,
     /*   27626 */     // GIR_Coverage, 69540,
     /*   27626 */     GIR_EraseRootFromParent_Done,
     /*   27627 */   // Label 512: @27627
     /*   27627 */   GIM_Try, /*On fail goto*//*Label 513*/ GIMT_Encode4(27682), // Rule ID 69629 //
     /*   27632 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   27635 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   27639 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   27643 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   27647 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   27649 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27654 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27658 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   27660 */     // (add:{ *:[nxv2i32] } (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_zext_oneuse>>, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVWADDU_WV_MF2_TIED:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs2, VR:{ *:[nxv2i16] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   27660 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF2_TIED),
     /*   27663 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   27665 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   27667 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   27671 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   27674 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   27677 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   27680 */     GIR_RootConstrainSelectedInstOperands,
     /*   27681 */     // GIR_Coverage, 69629,
     /*   27681 */     GIR_EraseRootFromParent_Done,
     /*   27682 */   // Label 513: @27682
     /*   27682 */   GIM_Try, /*On fail goto*//*Label 514*/ GIMT_Encode4(27737), // Rule ID 69630 //
     /*   27687 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   27690 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   27694 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   27698 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   27702 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   27704 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27709 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27713 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   27715 */     // (add:{ *:[nxv2i32] } (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_zext_oneuse>>, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVWADDU_WV_MF2_TIED:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs2, VR:{ *:[nxv2i16] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   27715 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF2_TIED),
     /*   27718 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   27720 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   27722 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   27726 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   27729 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   27732 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   27735 */     GIR_RootConstrainSelectedInstOperands,
     /*   27736 */     // GIR_Coverage, 69630,
     /*   27736 */     GIR_EraseRootFromParent_Done,
     /*   27737 */   // Label 514: @27737
     /*   27737 */   GIM_Try, /*On fail goto*//*Label 515*/ GIMT_Encode4(27805), // Rule ID 51894 //
     /*   27742 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   27745 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27749 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   27753 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   27757 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   27761 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s32,
     /*   27765 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   27767 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27772 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27777 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   27779 */     // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs2, (mul:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rd)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVMADD_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   27779 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_M1),
     /*   27782 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   27784 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   27788 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   27792 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   27794 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   27797 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   27800 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   27803 */     GIR_RootConstrainSelectedInstOperands,
     /*   27804 */     // GIR_Coverage, 51894,
     /*   27804 */     GIR_EraseRootFromParent_Done,
     /*   27805 */   // Label 515: @27805
     /*   27805 */   GIM_Try, /*On fail goto*//*Label 516*/ GIMT_Encode4(27873), // Rule ID 51895 //
     /*   27810 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   27813 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27817 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   27821 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   27825 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   27829 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s32,
     /*   27833 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   27835 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27840 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27845 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   27847 */     // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs2, (mul:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rd)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVMADD_VV_M1:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rd, VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   27847 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_M1),
     /*   27850 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   27852 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   27856 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   27860 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   27862 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   27865 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   27868 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   27871 */     GIR_RootConstrainSelectedInstOperands,
     /*   27872 */     // GIR_Coverage, 51895,
     /*   27872 */     GIR_EraseRootFromParent_Done,
     /*   27873 */   // Label 516: @27873
     /*   27873 */   GIM_Try, /*On fail goto*//*Label 517*/ GIMT_Encode4(27928), // Rule ID 46768 //
     /*   27878 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   27881 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27885 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   27889 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   27893 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   27897 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   27899 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27904 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   27906 */     // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs2, (anyext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_WV_MF2_TIED:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs2, VR:{ *:[nxv2i16] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   27906 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF2_TIED),
     /*   27909 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   27911 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   27913 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   27917 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   27920 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   27923 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   27926 */     GIR_RootConstrainSelectedInstOperands,
     /*   27927 */     // GIR_Coverage, 46768,
     /*   27927 */     GIR_EraseRootFromParent_Done,
     /*   27928 */   // Label 517: @27928
     /*   27928 */   GIM_Try, /*On fail goto*//*Label 518*/ GIMT_Encode4(27983), // Rule ID 46769 //
     /*   27933 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   27936 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27940 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   27944 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   27948 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   27952 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   27954 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27959 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   27961 */     // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs2, (anyext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_WV_MF2_TIED:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs2, VR:{ *:[nxv2i16] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   27961 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF2_TIED),
     /*   27964 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   27966 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   27968 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   27972 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   27975 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   27978 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   27981 */     GIR_RootConstrainSelectedInstOperands,
     /*   27982 */     // GIR_Coverage, 46769,
     /*   27982 */     GIR_EraseRootFromParent_Done,
     /*   27983 */   // Label 518: @27983
     /*   27983 */   GIM_Try, /*On fail goto*//*Label 519*/ GIMT_Encode4(28038), // Rule ID 46528 //
     /*   27988 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   27991 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   27995 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   27999 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   28003 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   28007 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   28009 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28014 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   28016 */     // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs2, (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_WV_MF2_TIED:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs2, VR:{ *:[nxv2i16] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   28016 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_MF2_TIED),
     /*   28019 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   28021 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   28023 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   28027 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   28030 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   28033 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   28036 */     GIR_RootConstrainSelectedInstOperands,
     /*   28037 */     // GIR_Coverage, 46528,
     /*   28037 */     GIR_EraseRootFromParent_Done,
     /*   28038 */   // Label 519: @28038
     /*   28038 */   GIM_Try, /*On fail goto*//*Label 520*/ GIMT_Encode4(28093), // Rule ID 46529 //
     /*   28043 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   28046 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28050 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   28054 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   28058 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   28062 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   28064 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28069 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   28071 */     // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs2, (sext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_WV_MF2_TIED:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs2, VR:{ *:[nxv2i16] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   28071 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_MF2_TIED),
     /*   28074 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   28076 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   28078 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   28082 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   28085 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   28088 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   28091 */     GIR_RootConstrainSelectedInstOperands,
     /*   28092 */     // GIR_Coverage, 46529,
     /*   28092 */     GIR_EraseRootFromParent_Done,
     /*   28093 */   // Label 520: @28093
     /*   28093 */   GIM_Try, /*On fail goto*//*Label 521*/ GIMT_Encode4(28148), // Rule ID 46648 //
     /*   28098 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   28101 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28105 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   28109 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   28113 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   28117 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   28119 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28124 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   28126 */     // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs2, (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_WV_MF2_TIED:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs2, VR:{ *:[nxv2i16] }:$rs1, -1:{ *:[i64] }, 4:{ *:[i64] }, 1:{ *:[i64] })
     /*   28126 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF2_TIED),
     /*   28129 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   28131 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   28133 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   28137 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   28140 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   28143 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   28146 */     GIR_RootConstrainSelectedInstOperands,
     /*   28147 */     // GIR_Coverage, 46648,
     /*   28147 */     GIR_EraseRootFromParent_Done,
     /*   28148 */   // Label 521: @28148
     /*   28148 */   GIM_Try, /*On fail goto*//*Label 522*/ GIMT_Encode4(28203), // Rule ID 46649 //
     /*   28153 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   28156 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28160 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   28164 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   28168 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s16,
     /*   28172 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   28174 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28179 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   28181 */     // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs2, (zext:{ *:[nxv2i32] } VR:{ *:[nxv2i16] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_WV_MF2_TIED:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs2, VR:{ *:[nxv2i16] }:$rs1, -1:{ *:[i32] }, 4:{ *:[i32] }, 1:{ *:[i32] })
     /*   28181 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_MF2_TIED),
     /*   28184 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   28186 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   28188 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   28192 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   28195 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
     /*   28198 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   28201 */     GIR_RootConstrainSelectedInstOperands,
     /*   28202 */     // GIR_Coverage, 46649,
     /*   28202 */     GIR_EraseRootFromParent_Done,
     /*   28203 */   // Label 522: @28203
     /*   28203 */   GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(28256), // Rule ID 46126 //
     /*   28208 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   28211 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28215 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28219 */     // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
     /*   28219 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
     /*   28222 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   28226 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   28231 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   28233 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
     /*   28236 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   28238 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   28241 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*   28243 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   28245 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   28248 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   28251 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   28254 */     GIR_RootConstrainSelectedInstOperands,
     /*   28255 */     // GIR_Coverage, 46126,
     /*   28255 */     GIR_EraseRootFromParent_Done,
     /*   28256 */   // Label 523: @28256
     /*   28256 */   GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(28309), // Rule ID 46127 //
     /*   28261 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   28264 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28268 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28272 */     // (add:{ *:[nxv2i32] } VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2)  =>  (PseudoVADD_VV_M1:{ *:[nxv2i32] } (IMPLICIT_DEF:{ *:[nxv2i32] }), VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
     /*   28272 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s32,
     /*   28275 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   28279 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   28284 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   28286 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M1),
     /*   28289 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   28291 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   28294 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*   28296 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   28298 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   28301 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   28304 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   28307 */     GIR_RootConstrainSelectedInstOperands,
     /*   28308 */     // GIR_Coverage, 46127,
     /*   28308 */     GIR_EraseRootFromParent_Done,
     /*   28309 */   // Label 524: @28309
     /*   28309 */   GIM_Reject,
     /*   28310 */ // Label 484: @28310
     /*   28310 */ GIM_Reject,
     /*   28311 */ // Label 135: @28311
     /*   28311 */ GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(31435),
     /*   28316 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv2s64,
     /*   28319 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv2s64,
     /*   28322 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   28326 */   GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(28422), // Rule ID 70917 //
     /*   28331 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   28334 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   28338 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   28342 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s64,
     /*   28346 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s64,
     /*   28350 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   28352 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   28356 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   28360 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   28364 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   28366 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28371 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   28375 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   28379 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   28383 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   28385 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28390 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   28394 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   28396 */     // (add:{ *:[nxv2i64] } (mul:{ *:[nxv2i64] } (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VRM2:{ *:[nxv2i64] }:$rd)  =>  (PseudoVWMACC_VV_M1:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   28396 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_M1),
     /*   28399 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   28401 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   28403 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   28407 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   28411 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   28414 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   28417 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   28420 */     GIR_RootConstrainSelectedInstOperands,
     /*   28421 */     // GIR_Coverage, 70917,
     /*   28421 */     GIR_EraseRootFromParent_Done,
     /*   28422 */   // Label 526: @28422
     /*   28422 */   GIM_Try, /*On fail goto*//*Label 527*/ GIMT_Encode4(28518), // Rule ID 70918 //
     /*   28427 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   28430 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   28434 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   28438 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s64,
     /*   28442 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s64,
     /*   28446 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   28448 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   28452 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   28456 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   28460 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   28462 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28467 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   28471 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   28475 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   28479 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   28481 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28486 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   28490 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   28492 */     // (add:{ *:[nxv2i64] } (mul:{ *:[nxv2i64] } (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VRM2:{ *:[nxv2i64] }:$rd)  =>  (PseudoVWMACC_VV_M1:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   28492 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_M1),
     /*   28495 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   28497 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   28499 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   28503 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   28507 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   28510 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   28513 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   28516 */     GIR_RootConstrainSelectedInstOperands,
     /*   28517 */     // GIR_Coverage, 70918,
     /*   28517 */     GIR_EraseRootFromParent_Done,
     /*   28518 */   // Label 527: @28518
     /*   28518 */   GIM_Try, /*On fail goto*//*Label 528*/ GIMT_Encode4(28614), // Rule ID 71201 //
     /*   28523 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   28526 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   28530 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   28534 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s64,
     /*   28538 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s64,
     /*   28542 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   28544 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   28548 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   28552 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   28556 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   28558 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28563 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   28567 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   28571 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   28575 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   28577 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28582 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   28586 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   28588 */     // (add:{ *:[nxv2i64] } (mul:{ *:[nxv2i64] } (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VRM2:{ *:[nxv2i64] }:$rd)  =>  (PseudoVWMACCSU_VV_M1:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   28588 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_M1),
     /*   28591 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   28593 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   28595 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   28599 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   28603 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   28606 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   28609 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   28612 */     GIR_RootConstrainSelectedInstOperands,
     /*   28613 */     // GIR_Coverage, 71201,
     /*   28613 */     GIR_EraseRootFromParent_Done,
     /*   28614 */   // Label 528: @28614
     /*   28614 */   GIM_Try, /*On fail goto*//*Label 529*/ GIMT_Encode4(28710), // Rule ID 71202 //
     /*   28619 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   28622 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   28626 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   28630 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s64,
     /*   28634 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s64,
     /*   28638 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   28640 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   28644 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   28648 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   28652 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   28654 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28659 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   28663 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   28667 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   28671 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   28673 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28678 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   28682 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   28684 */     // (add:{ *:[nxv2i64] } (mul:{ *:[nxv2i64] } (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VRM2:{ *:[nxv2i64] }:$rd)  =>  (PseudoVWMACCSU_VV_M1:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   28684 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_M1),
     /*   28687 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   28689 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   28691 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   28695 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   28699 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   28702 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   28705 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   28708 */     GIR_RootConstrainSelectedInstOperands,
     /*   28709 */     // GIR_Coverage, 71202,
     /*   28709 */     GIR_EraseRootFromParent_Done,
     /*   28710 */   // Label 529: @28710
     /*   28710 */   GIM_Try, /*On fail goto*//*Label 530*/ GIMT_Encode4(28806), // Rule ID 71203 //
     /*   28715 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   28718 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   28722 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   28726 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s64,
     /*   28730 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s64,
     /*   28734 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   28736 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   28740 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   28744 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   28748 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   28750 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28755 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   28759 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   28763 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   28767 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   28769 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28774 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   28778 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   28780 */     // (add:{ *:[nxv2i64] } (mul:{ *:[nxv2i64] } (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VRM2:{ *:[nxv2i64] }:$rd)  =>  (PseudoVWMACCSU_VV_M1:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   28780 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_M1),
     /*   28783 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   28785 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   28787 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   28791 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   28795 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   28798 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   28801 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   28804 */     GIR_RootConstrainSelectedInstOperands,
     /*   28805 */     // GIR_Coverage, 71203,
     /*   28805 */     GIR_EraseRootFromParent_Done,
     /*   28806 */   // Label 530: @28806
     /*   28806 */   GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(28902), // Rule ID 71204 //
     /*   28811 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   28814 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   28818 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   28822 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s64,
     /*   28826 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s64,
     /*   28830 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   28832 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   28836 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   28840 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   28844 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   28846 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28851 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   28855 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   28859 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   28863 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   28865 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28870 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   28874 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   28876 */     // (add:{ *:[nxv2i64] } (mul:{ *:[nxv2i64] } (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VRM2:{ *:[nxv2i64] }:$rd)  =>  (PseudoVWMACCSU_VV_M1:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   28876 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_M1),
     /*   28879 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   28881 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   28883 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   28887 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   28891 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   28894 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   28897 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   28900 */     GIR_RootConstrainSelectedInstOperands,
     /*   28901 */     // GIR_Coverage, 71204,
     /*   28901 */     GIR_EraseRootFromParent_Done,
     /*   28902 */   // Label 531: @28902
     /*   28902 */   GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(28998), // Rule ID 71031 //
     /*   28907 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   28910 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   28914 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   28918 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s64,
     /*   28922 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s64,
     /*   28926 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   28928 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   28932 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   28936 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   28940 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   28942 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28947 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   28951 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   28955 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   28959 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   28961 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   28966 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   28970 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   28972 */     // (add:{ *:[nxv2i64] } (mul:{ *:[nxv2i64] } (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VRM2:{ *:[nxv2i64] }:$rd)  =>  (PseudoVWMACCU_VV_M1:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   28972 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_M1),
     /*   28975 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   28977 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   28979 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   28983 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   28987 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   28990 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   28993 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   28996 */     GIR_RootConstrainSelectedInstOperands,
     /*   28997 */     // GIR_Coverage, 71031,
     /*   28997 */     GIR_EraseRootFromParent_Done,
     /*   28998 */   // Label 532: @28998
     /*   28998 */   GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(29094), // Rule ID 71032 //
     /*   29003 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   29006 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   29010 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   29014 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s64,
     /*   29018 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s64,
     /*   29022 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   29024 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   29028 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   29032 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   29036 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   29038 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   29043 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   29047 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   29051 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   29055 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   29057 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   29062 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   29066 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   29068 */     // (add:{ *:[nxv2i64] } (mul:{ *:[nxv2i64] } (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>, VRM2:{ *:[nxv2i64] }:$rd)  =>  (PseudoVWMACCU_VV_M1:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   29068 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_M1),
     /*   29071 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   29073 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   29075 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   29079 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   29083 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   29086 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   29089 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   29092 */     GIR_RootConstrainSelectedInstOperands,
     /*   29093 */     // GIR_Coverage, 71032,
     /*   29093 */     GIR_EraseRootFromParent_Done,
     /*   29094 */   // Label 533: @29094
     /*   29094 */   GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(29190), // Rule ID 52060 //
     /*   29099 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   29102 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   29106 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   29110 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   29114 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s64,
     /*   29118 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s64,
     /*   29122 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   29124 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   29128 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   29132 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   29136 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   29138 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   29143 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   29147 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   29151 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   29155 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   29157 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   29162 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   29164 */     // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, (mul:{ *:[nxv2i64] } (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACC_VV_M1:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   29164 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_M1),
     /*   29167 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   29169 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   29171 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   29175 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   29179 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   29182 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   29185 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   29188 */     GIR_RootConstrainSelectedInstOperands,
     /*   29189 */     // GIR_Coverage, 52060,
     /*   29189 */     GIR_EraseRootFromParent_Done,
     /*   29190 */   // Label 534: @29190
     /*   29190 */   GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(29286), // Rule ID 52061 //
     /*   29195 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   29198 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   29202 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   29206 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   29210 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s64,
     /*   29214 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s64,
     /*   29218 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   29220 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   29224 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   29228 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   29232 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   29234 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   29239 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   29243 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   29247 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   29251 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   29253 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   29258 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   29260 */     // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, (mul:{ *:[nxv2i64] } (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACC_VV_M1:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   29260 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_M1),
     /*   29263 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   29265 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   29267 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   29271 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   29275 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   29278 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   29281 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   29284 */     GIR_RootConstrainSelectedInstOperands,
     /*   29285 */     // GIR_Coverage, 52061,
     /*   29285 */     GIR_EraseRootFromParent_Done,
     /*   29286 */   // Label 535: @29286
     /*   29286 */   GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(29382), // Rule ID 52178 //
     /*   29291 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   29294 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   29298 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   29302 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   29306 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s64,
     /*   29310 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s64,
     /*   29314 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   29316 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   29320 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   29324 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   29328 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   29330 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   29335 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   29339 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   29343 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   29347 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   29349 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   29354 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   29356 */     // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, (mul:{ *:[nxv2i64] } (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_M1:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   29356 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_M1),
     /*   29359 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   29361 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   29363 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   29367 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   29371 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   29374 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   29377 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   29380 */     GIR_RootConstrainSelectedInstOperands,
     /*   29381 */     // GIR_Coverage, 52178,
     /*   29381 */     GIR_EraseRootFromParent_Done,
     /*   29382 */   // Label 536: @29382
     /*   29382 */   GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(29478), // Rule ID 52179 //
     /*   29387 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   29390 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   29394 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   29398 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   29402 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s64,
     /*   29406 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s64,
     /*   29410 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   29412 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   29416 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   29420 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   29424 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   29426 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   29431 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   29435 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   29439 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   29443 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   29445 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   29450 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   29452 */     // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, (mul:{ *:[nxv2i64] } (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_sext_oneuse>>, (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_M1:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   29452 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_M1),
     /*   29455 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   29457 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   29459 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   29463 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   29467 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   29470 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   29473 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   29476 */     GIR_RootConstrainSelectedInstOperands,
     /*   29477 */     // GIR_Coverage, 52179,
     /*   29477 */     GIR_EraseRootFromParent_Done,
     /*   29478 */   // Label 537: @29478
     /*   29478 */   GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(29574), // Rule ID 71199 //
     /*   29483 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   29486 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   29490 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   29494 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   29498 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s64,
     /*   29502 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s64,
     /*   29506 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   29508 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   29512 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   29516 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   29520 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   29522 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   29527 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   29531 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   29535 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   29539 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   29541 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   29546 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   29548 */     // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, (mul:{ *:[nxv2i64] } (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_M1:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   29548 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_M1),
     /*   29551 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   29553 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   29555 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   29559 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   29563 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   29566 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   29569 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   29572 */     GIR_RootConstrainSelectedInstOperands,
     /*   29573 */     // GIR_Coverage, 71199,
     /*   29573 */     GIR_EraseRootFromParent_Done,
     /*   29574 */   // Label 538: @29574
     /*   29574 */   GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(29670), // Rule ID 71200 //
     /*   29579 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   29582 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   29586 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   29590 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   29594 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s64,
     /*   29598 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s64,
     /*   29602 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   29604 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   29608 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   29612 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   29616 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   29618 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   29623 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   29627 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   29631 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   29635 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   29637 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   29642 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   29644 */     // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, (mul:{ *:[nxv2i64] } (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs2)<<P:Predicate_zext_oneuse>>, (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCSU_VV_M1:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   29644 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCSU_VV_M1),
     /*   29647 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   29649 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   29651 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs1
     /*   29655 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs2
     /*   29659 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   29662 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   29665 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   29668 */     GIR_RootConstrainSelectedInstOperands,
     /*   29669 */     // GIR_Coverage, 71200,
     /*   29669 */     GIR_EraseRootFromParent_Done,
     /*   29670 */   // Label 539: @29670
     /*   29670 */   GIM_Try, /*On fail goto*//*Label 540*/ GIMT_Encode4(29766), // Rule ID 52118 //
     /*   29675 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   29678 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   29682 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   29686 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   29690 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s64,
     /*   29694 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s64,
     /*   29698 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   29700 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   29704 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   29708 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   29712 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   29714 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   29719 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   29723 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   29727 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   29731 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   29733 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   29738 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   29740 */     // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, (mul:{ *:[nxv2i64] } (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCU_VV_M1:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   29740 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_M1),
     /*   29743 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   29745 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   29747 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   29751 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   29755 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   29758 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   29761 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   29764 */     GIR_RootConstrainSelectedInstOperands,
     /*   29765 */     // GIR_Coverage, 52118,
     /*   29765 */     GIR_EraseRootFromParent_Done,
     /*   29766 */   // Label 540: @29766
     /*   29766 */   GIM_Try, /*On fail goto*//*Label 541*/ GIMT_Encode4(29862), // Rule ID 52119 //
     /*   29771 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   29774 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   29778 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   29782 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   29786 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s64,
     /*   29790 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s64,
     /*   29794 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   29796 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   29800 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   29804 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   29808 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   29810 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   29815 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   29819 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   29823 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   29827 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   29829 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   29834 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   29836 */     // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, (mul:{ *:[nxv2i64] } (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs2)<<P:Predicate_zext_oneuse>>)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVWMACCU_VV_M1:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, VR:{ *:[nxv2i32] }:$rs1, VR:{ *:[nxv2i32] }:$rs2, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   29836 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACCU_VV_M1),
     /*   29839 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   29841 */     GIR_RootToRootCopy, /*OpIdx*/1, // rd
     /*   29843 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   29847 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   29851 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   29854 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   29857 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   29860 */     GIR_RootConstrainSelectedInstOperands,
     /*   29861 */     // GIR_Coverage, 52119,
     /*   29861 */     GIR_EraseRootFromParent_Done,
     /*   29862 */   // Label 541: @29862
     /*   29862 */   GIM_Try, /*On fail goto*//*Label 542*/ GIMT_Encode4(29951), // Rule ID 46728 //
     /*   29867 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   29870 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   29874 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   29878 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   29882 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   29884 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   29889 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   29893 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   29897 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   29901 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   29903 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   29908 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   29910 */     // (add:{ *:[nxv2i64] } (anyext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs2)<<P:Predicate_anyext_oneuse>>, (anyext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_VV_M1:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VR:{ *:[nxv2i32] }:$rs2, VR:{ *:[nxv2i32] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
     /*   29910 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
     /*   29913 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   29917 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   29922 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   29924 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_M1),
     /*   29927 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   29929 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   29932 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   29936 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   29940 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   29943 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   29946 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   29949 */     GIR_RootConstrainSelectedInstOperands,
     /*   29950 */     // GIR_Coverage, 46728,
     /*   29950 */     GIR_EraseRootFromParent_Done,
     /*   29951 */   // Label 542: @29951
     /*   29951 */   GIM_Try, /*On fail goto*//*Label 543*/ GIMT_Encode4(30040), // Rule ID 46729 //
     /*   29956 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   29959 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   29963 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   29967 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   29971 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   29973 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   29978 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   29982 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   29986 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   29990 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   29992 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   29997 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   29999 */     // (add:{ *:[nxv2i64] } (anyext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs2)<<P:Predicate_anyext_oneuse>>, (anyext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_VV_M1:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VR:{ *:[nxv2i32] }:$rs2, VR:{ *:[nxv2i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
     /*   29999 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
     /*   30002 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   30006 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   30011 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   30013 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_M1),
     /*   30016 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   30018 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   30021 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   30025 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   30029 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   30032 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   30035 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   30038 */     GIR_RootConstrainSelectedInstOperands,
     /*   30039 */     // GIR_Coverage, 46729,
     /*   30039 */     GIR_EraseRootFromParent_Done,
     /*   30040 */   // Label 543: @30040
     /*   30040 */   GIM_Try, /*On fail goto*//*Label 544*/ GIMT_Encode4(30129), // Rule ID 46492 //
     /*   30045 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   30048 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   30052 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   30056 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   30060 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   30062 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   30067 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   30071 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   30075 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   30079 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   30081 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   30086 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   30088 */     // (add:{ *:[nxv2i64] } (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs2)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_VV_M1:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VR:{ *:[nxv2i32] }:$rs2, VR:{ *:[nxv2i32] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
     /*   30088 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
     /*   30091 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   30095 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   30100 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   30102 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_VV_M1),
     /*   30105 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   30107 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   30110 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   30114 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   30118 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   30121 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   30124 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   30127 */     GIR_RootConstrainSelectedInstOperands,
     /*   30128 */     // GIR_Coverage, 46492,
     /*   30128 */     GIR_EraseRootFromParent_Done,
     /*   30129 */   // Label 544: @30129
     /*   30129 */   GIM_Try, /*On fail goto*//*Label 545*/ GIMT_Encode4(30218), // Rule ID 46493 //
     /*   30134 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   30137 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   30141 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   30145 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   30149 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   30151 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   30156 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   30160 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   30164 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   30168 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   30170 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   30175 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   30177 */     // (add:{ *:[nxv2i64] } (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs2)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_VV_M1:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VR:{ *:[nxv2i32] }:$rs2, VR:{ *:[nxv2i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
     /*   30177 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
     /*   30180 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   30184 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   30189 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   30191 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_VV_M1),
     /*   30194 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   30196 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   30199 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   30203 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   30207 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   30210 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   30213 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   30216 */     GIR_RootConstrainSelectedInstOperands,
     /*   30217 */     // GIR_Coverage, 46493,
     /*   30217 */     GIR_EraseRootFromParent_Done,
     /*   30218 */   // Label 545: @30218
     /*   30218 */   GIM_Try, /*On fail goto*//*Label 546*/ GIMT_Encode4(30307), // Rule ID 46608 //
     /*   30223 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   30226 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   30230 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   30234 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   30238 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   30240 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   30245 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   30249 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   30253 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   30257 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   30259 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   30264 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   30266 */     // (add:{ *:[nxv2i64] } (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs2)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_VV_M1:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VR:{ *:[nxv2i32] }:$rs2, VR:{ *:[nxv2i32] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] }, 3:{ *:[i64] })
     /*   30266 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
     /*   30269 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   30273 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   30278 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   30280 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_M1),
     /*   30283 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   30285 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   30288 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   30292 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   30296 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   30299 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   30302 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   30305 */     GIR_RootConstrainSelectedInstOperands,
     /*   30306 */     // GIR_Coverage, 46608,
     /*   30306 */     GIR_EraseRootFromParent_Done,
     /*   30307 */   // Label 546: @30307
     /*   30307 */   GIM_Try, /*On fail goto*//*Label 547*/ GIMT_Encode4(30396), // Rule ID 46609 //
     /*   30312 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   30315 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   30319 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   30323 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   30327 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   30329 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   30334 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
     /*   30338 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   30342 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   30346 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   30348 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   30353 */     GIM_CheckIsSafeToFold, /*NumInsns*/2,
     /*   30355 */     // (add:{ *:[nxv2i64] } (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs2)<<P:Predicate_zext_oneuse>>, (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_VV_M1:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VR:{ *:[nxv2i32] }:$rs2, VR:{ *:[nxv2i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] }, 3:{ *:[i32] })
     /*   30355 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
     /*   30358 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   30362 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   30367 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   30369 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_VV_M1),
     /*   30372 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   30374 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   30377 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs2
     /*   30381 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   30385 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   30388 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   30391 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   30394 */     GIR_RootConstrainSelectedInstOperands,
     /*   30395 */     // GIR_Coverage, 46609,
     /*   30395 */     GIR_EraseRootFromParent_Done,
     /*   30396 */   // Label 547: @30396
     /*   30396 */   GIM_Try, /*On fail goto*//*Label 548*/ GIMT_Encode4(30464), // Rule ID 70827 //
     /*   30401 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
     /*   30404 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   30408 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   30412 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s64,
     /*   30416 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s64,
     /*   30420 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   30422 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   30427 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   30432 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   30436 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   30438 */     // (add:{ *:[nxv2i64] } (mul:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rd)<<P:Predicate_mul_oneuse>>, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVMADD_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 1:{ *:[i64] })
     /*   30438 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_M2),
     /*   30441 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   30443 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   30447 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   30451 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   30453 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   30456 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
     /*   30459 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   30462 */     GIR_RootConstrainSelectedInstOperands,
     /*   30463 */     // GIR_Coverage, 70827,
     /*   30463 */     GIR_EraseRootFromParent_Done,
     /*   30464 */   // Label 548: @30464
     /*   30464 */   GIM_Try, /*On fail goto*//*Label 549*/ GIMT_Encode4(30532), // Rule ID 70828 //
     /*   30469 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
     /*   30472 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   30476 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   30480 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s64,
     /*   30484 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s64,
     /*   30488 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   30490 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   30495 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   30500 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   30504 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   30506 */     // (add:{ *:[nxv2i64] } (mul:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rd)<<P:Predicate_mul_oneuse>>, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVMADD_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 1:{ *:[i32] })
     /*   30506 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_M2),
     /*   30509 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   30511 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   30515 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   30519 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   30521 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   30524 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
     /*   30527 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   30530 */     GIR_RootConstrainSelectedInstOperands,
     /*   30531 */     // GIR_Coverage, 70828,
     /*   30531 */     GIR_EraseRootFromParent_Done,
     /*   30532 */   // Label 549: @30532
     /*   30532 */   GIM_Try, /*On fail goto*//*Label 550*/ GIMT_Encode4(30587), // Rule ID 69739 //
     /*   30537 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   30540 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   30544 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   30548 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   30552 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   30554 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   30559 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   30563 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   30565 */     // (add:{ *:[nxv2i64] } (anyext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_anyext_oneuse>>, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVWADDU_WV_M1_TIED:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs2, VR:{ *:[nxv2i32] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   30565 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_M1_TIED),
     /*   30568 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   30570 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   30572 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   30576 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   30579 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   30582 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   30585 */     GIR_RootConstrainSelectedInstOperands,
     /*   30586 */     // GIR_Coverage, 69739,
     /*   30586 */     GIR_EraseRootFromParent_Done,
     /*   30587 */   // Label 550: @30587
     /*   30587 */   GIM_Try, /*On fail goto*//*Label 551*/ GIMT_Encode4(30642), // Rule ID 69740 //
     /*   30592 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   30595 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   30599 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   30603 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   30607 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   30609 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   30614 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   30618 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   30620 */     // (add:{ *:[nxv2i64] } (anyext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_anyext_oneuse>>, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVWADDU_WV_M1_TIED:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs2, VR:{ *:[nxv2i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   30620 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_M1_TIED),
     /*   30623 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   30625 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   30627 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   30631 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   30634 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   30637 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   30640 */     GIR_RootConstrainSelectedInstOperands,
     /*   30641 */     // GIR_Coverage, 69740,
     /*   30641 */     GIR_EraseRootFromParent_Done,
     /*   30642 */   // Label 551: @30642
     /*   30642 */   GIM_Try, /*On fail goto*//*Label 552*/ GIMT_Encode4(30697), // Rule ID 69559 //
     /*   30647 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   30650 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   30654 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   30658 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   30662 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   30664 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   30669 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   30673 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   30675 */     // (add:{ *:[nxv2i64] } (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_sext_oneuse>>, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVWADD_WV_M1_TIED:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs2, VR:{ *:[nxv2i32] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   30675 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_M1_TIED),
     /*   30678 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   30680 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   30682 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   30686 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   30689 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   30692 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   30695 */     GIR_RootConstrainSelectedInstOperands,
     /*   30696 */     // GIR_Coverage, 69559,
     /*   30696 */     GIR_EraseRootFromParent_Done,
     /*   30697 */   // Label 552: @30697
     /*   30697 */   GIM_Try, /*On fail goto*//*Label 553*/ GIMT_Encode4(30752), // Rule ID 69560 //
     /*   30702 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   30705 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   30709 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   30713 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   30717 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   30719 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   30724 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   30728 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   30730 */     // (add:{ *:[nxv2i64] } (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_sext_oneuse>>, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVWADD_WV_M1_TIED:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs2, VR:{ *:[nxv2i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   30730 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_M1_TIED),
     /*   30733 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   30735 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   30737 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   30741 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   30744 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   30747 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   30750 */     GIR_RootConstrainSelectedInstOperands,
     /*   30751 */     // GIR_Coverage, 69560,
     /*   30751 */     GIR_EraseRootFromParent_Done,
     /*   30752 */   // Label 553: @30752
     /*   30752 */   GIM_Try, /*On fail goto*//*Label 554*/ GIMT_Encode4(30807), // Rule ID 69649 //
     /*   30757 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   30760 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   30764 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   30768 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   30772 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   30774 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   30779 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   30783 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   30785 */     // (add:{ *:[nxv2i64] } (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_zext_oneuse>>, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVWADDU_WV_M1_TIED:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs2, VR:{ *:[nxv2i32] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   30785 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_M1_TIED),
     /*   30788 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   30790 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   30792 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   30796 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   30799 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   30802 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   30805 */     GIR_RootConstrainSelectedInstOperands,
     /*   30806 */     // GIR_Coverage, 69649,
     /*   30806 */     GIR_EraseRootFromParent_Done,
     /*   30807 */   // Label 554: @30807
     /*   30807 */   GIM_Try, /*On fail goto*//*Label 555*/ GIMT_Encode4(30862), // Rule ID 69650 //
     /*   30812 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   30815 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   30819 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   30823 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   30827 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   30829 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   30834 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   30838 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   30840 */     // (add:{ *:[nxv2i64] } (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_zext_oneuse>>, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVWADDU_WV_M1_TIED:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs2, VR:{ *:[nxv2i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   30840 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_M1_TIED),
     /*   30843 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   30845 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   30847 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   30851 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   30854 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   30857 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   30860 */     GIR_RootConstrainSelectedInstOperands,
     /*   30861 */     // GIR_Coverage, 69650,
     /*   30861 */     GIR_EraseRootFromParent_Done,
     /*   30862 */   // Label 555: @30862
     /*   30862 */   GIM_Try, /*On fail goto*//*Label 556*/ GIMT_Encode4(30930), // Rule ID 51938 //
     /*   30867 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
     /*   30870 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   30874 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   30878 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   30882 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s64,
     /*   30886 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s64,
     /*   30890 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   30892 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   30897 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   30902 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   30904 */     // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs2, (mul:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rd)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVMADD_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 1:{ *:[i64] })
     /*   30904 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_M2),
     /*   30907 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   30909 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   30913 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   30917 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   30919 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   30922 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
     /*   30925 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   30928 */     GIR_RootConstrainSelectedInstOperands,
     /*   30929 */     // GIR_Coverage, 51938,
     /*   30929 */     GIR_EraseRootFromParent_Done,
     /*   30930 */   // Label 556: @30930
     /*   30930 */   GIM_Try, /*On fail goto*//*Label 557*/ GIMT_Encode4(30998), // Rule ID 51939 //
     /*   30935 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
     /*   30938 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   30942 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   30946 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   30950 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s64,
     /*   30954 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv2s64,
     /*   30958 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   30960 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   30965 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   30970 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   30972 */     // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs2, (mul:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rd)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVMADD_VV_M2:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rd, VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 1:{ *:[i32] })
     /*   30972 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_M2),
     /*   30975 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   30977 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   30981 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   30985 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   30987 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   30990 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
     /*   30993 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   30996 */     GIR_RootConstrainSelectedInstOperands,
     /*   30997 */     // GIR_Coverage, 51939,
     /*   30997 */     GIR_EraseRootFromParent_Done,
     /*   30998 */   // Label 557: @30998
     /*   30998 */   GIM_Try, /*On fail goto*//*Label 558*/ GIMT_Encode4(31053), // Rule ID 46788 //
     /*   31003 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   31006 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   31010 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   31014 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   31018 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   31022 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   31024 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31029 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   31031 */     // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs2, (anyext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_WV_M1_TIED:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs2, VR:{ *:[nxv2i32] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   31031 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_M1_TIED),
     /*   31034 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   31036 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   31038 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   31042 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   31045 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   31048 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   31051 */     GIR_RootConstrainSelectedInstOperands,
     /*   31052 */     // GIR_Coverage, 46788,
     /*   31052 */     GIR_EraseRootFromParent_Done,
     /*   31053 */   // Label 558: @31053
     /*   31053 */   GIM_Try, /*On fail goto*//*Label 559*/ GIMT_Encode4(31108), // Rule ID 46789 //
     /*   31058 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   31061 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   31065 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   31069 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ANYEXT),
     /*   31073 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   31077 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   31079 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31084 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   31086 */     // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs2, (anyext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_anyext_oneuse>>)  =>  (PseudoVWADDU_WV_M1_TIED:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs2, VR:{ *:[nxv2i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   31086 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_M1_TIED),
     /*   31089 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   31091 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   31093 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   31097 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   31100 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   31103 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   31106 */     GIR_RootConstrainSelectedInstOperands,
     /*   31107 */     // GIR_Coverage, 46789,
     /*   31107 */     GIR_EraseRootFromParent_Done,
     /*   31108 */   // Label 559: @31108
     /*   31108 */   GIM_Try, /*On fail goto*//*Label 560*/ GIMT_Encode4(31163), // Rule ID 46548 //
     /*   31113 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   31116 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   31120 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   31124 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   31128 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   31132 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   31134 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31139 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   31141 */     // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs2, (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_WV_M1_TIED:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs2, VR:{ *:[nxv2i32] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   31141 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_M1_TIED),
     /*   31144 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   31146 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   31148 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   31152 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   31155 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   31158 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   31161 */     GIR_RootConstrainSelectedInstOperands,
     /*   31162 */     // GIR_Coverage, 46548,
     /*   31162 */     GIR_EraseRootFromParent_Done,
     /*   31163 */   // Label 560: @31163
     /*   31163 */   GIM_Try, /*On fail goto*//*Label 561*/ GIMT_Encode4(31218), // Rule ID 46549 //
     /*   31168 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   31171 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   31175 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   31179 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   31183 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   31187 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   31189 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31194 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   31196 */     // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs2, (sext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_sext_oneuse>>)  =>  (PseudoVWADD_WV_M1_TIED:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs2, VR:{ *:[nxv2i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   31196 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADD_WV_M1_TIED),
     /*   31199 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   31201 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   31203 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   31207 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   31210 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   31213 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   31216 */     GIR_RootConstrainSelectedInstOperands,
     /*   31217 */     // GIR_Coverage, 46549,
     /*   31217 */     GIR_EraseRootFromParent_Done,
     /*   31218 */   // Label 561: @31218
     /*   31218 */   GIM_Try, /*On fail goto*//*Label 562*/ GIMT_Encode4(31273), // Rule ID 46668 //
     /*   31223 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode0),
     /*   31226 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   31230 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   31234 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   31238 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   31242 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   31244 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31249 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   31251 */     // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs2, (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_WV_M1_TIED:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs2, VR:{ *:[nxv2i32] }:$rs1, -1:{ *:[i64] }, 5:{ *:[i64] }, 1:{ *:[i64] })
     /*   31251 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_M1_TIED),
     /*   31254 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   31256 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   31258 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   31262 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   31265 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   31268 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   31271 */     GIR_RootConstrainSelectedInstOperands,
     /*   31272 */     // GIR_Coverage, 46668,
     /*   31272 */     GIR_EraseRootFromParent_Done,
     /*   31273 */   // Label 562: @31273
     /*   31273 */   GIM_Try, /*On fail goto*//*Label 563*/ GIMT_Encode4(31328), // Rule ID 46669 //
     /*   31278 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HasVInstructionsI64_HwMode1),
     /*   31281 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   31285 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   31289 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ZEXT),
     /*   31293 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv2s32,
     /*   31297 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   31299 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31304 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   31306 */     // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs2, (zext:{ *:[nxv2i64] } VR:{ *:[nxv2i32] }:$rs1)<<P:Predicate_zext_oneuse>>)  =>  (PseudoVWADDU_WV_M1_TIED:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs2, VR:{ *:[nxv2i32] }:$rs1, -1:{ *:[i32] }, 5:{ *:[i32] }, 1:{ *:[i32] })
     /*   31306 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWADDU_WV_M1_TIED),
     /*   31309 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   31311 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   31313 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   31317 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   31320 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/5,
     /*   31323 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   31326 */     GIR_RootConstrainSelectedInstOperands,
     /*   31327 */     // GIR_Coverage, 46669,
     /*   31327 */     GIR_EraseRootFromParent_Done,
     /*   31328 */   // Label 563: @31328
     /*   31328 */   GIM_Try, /*On fail goto*//*Label 564*/ GIMT_Encode4(31381), // Rule ID 46170 //
     /*   31333 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode0),
     /*   31336 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   31340 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   31344 */     // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i64] }, 6:{ *:[i64] }, 3:{ *:[i64] })
     /*   31344 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
     /*   31347 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   31351 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   31356 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   31358 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
     /*   31361 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   31363 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   31366 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*   31368 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   31370 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   31373 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
     /*   31376 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   31379 */     GIR_RootConstrainSelectedInstOperands,
     /*   31380 */     // GIR_Coverage, 46170,
     /*   31380 */     GIR_EraseRootFromParent_Done,
     /*   31381 */   // Label 564: @31381
     /*   31381 */   GIM_Try, /*On fail goto*//*Label 565*/ GIMT_Encode4(31434), // Rule ID 46171 //
     /*   31386 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructionsI64_HwMode1),
     /*   31389 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   31393 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRM2RegClassID),
     /*   31397 */     // (add:{ *:[nxv2i64] } VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2)  =>  (PseudoVADD_VV_M2:{ *:[nxv2i64] } (IMPLICIT_DEF:{ *:[nxv2i64] }), VRM2:{ *:[nxv2i64] }:$rs1, VRM2:{ *:[nxv2i64] }:$rs2, -1:{ *:[i32] }, 6:{ *:[i32] }, 3:{ *:[i32] })
     /*   31397 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv2s64,
     /*   31400 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   31404 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   31409 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   31411 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_M2),
     /*   31414 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   31416 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   31419 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*   31421 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   31423 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   31426 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
     /*   31429 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   31432 */     GIR_RootConstrainSelectedInstOperands,
     /*   31433 */     // GIR_Coverage, 46171,
     /*   31433 */     GIR_EraseRootFromParent_Done,
     /*   31434 */   // Label 565: @31434
     /*   31434 */   GIM_Reject,
     /*   31435 */ // Label 525: @31435
     /*   31435 */ GIM_Reject,
     /*   31436 */ // Label 136: @31436
     /*   31436 */ GIM_Try, /*On fail goto*//*Label 566*/ GIMT_Encode4(31830),
     /*   31441 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s8,
     /*   31444 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s8,
     /*   31447 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31451 */   GIM_Try, /*On fail goto*//*Label 567*/ GIMT_Encode4(31519), // Rule ID 70691 //
     /*   31456 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   31459 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   31463 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   31467 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s8,
     /*   31471 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s8,
     /*   31475 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   31477 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31482 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31487 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31491 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   31493 */     // (add:{ *:[nxv4i8] } (mul:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rd)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVMADD_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rd, VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   31493 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF2),
     /*   31496 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   31498 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   31502 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   31506 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   31508 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   31511 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   31514 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   31517 */     GIR_RootConstrainSelectedInstOperands,
     /*   31518 */     // GIR_Coverage, 70691,
     /*   31518 */     GIR_EraseRootFromParent_Done,
     /*   31519 */   // Label 567: @31519
     /*   31519 */   GIM_Try, /*On fail goto*//*Label 568*/ GIMT_Encode4(31587), // Rule ID 70692 //
     /*   31524 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   31527 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   31531 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   31535 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s8,
     /*   31539 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s8,
     /*   31543 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   31545 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31550 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31555 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31559 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   31561 */     // (add:{ *:[nxv4i8] } (mul:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rd)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVMADD_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rd, VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   31561 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF2),
     /*   31564 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   31566 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   31570 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   31574 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   31576 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   31579 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   31582 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   31585 */     GIR_RootConstrainSelectedInstOperands,
     /*   31586 */     // GIR_Coverage, 70692,
     /*   31586 */     GIR_EraseRootFromParent_Done,
     /*   31587 */   // Label 568: @31587
     /*   31587 */   GIM_Try, /*On fail goto*//*Label 569*/ GIMT_Encode4(31655), // Rule ID 51870 //
     /*   31592 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   31595 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31599 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   31603 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   31607 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s8,
     /*   31611 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s8,
     /*   31615 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   31617 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31622 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31627 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   31629 */     // (add:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs2, (mul:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rd)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVMADD_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rd, VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   31629 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF2),
     /*   31632 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   31634 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   31638 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   31642 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   31644 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   31647 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   31650 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   31653 */     GIR_RootConstrainSelectedInstOperands,
     /*   31654 */     // GIR_Coverage, 51870,
     /*   31654 */     GIR_EraseRootFromParent_Done,
     /*   31655 */   // Label 569: @31655
     /*   31655 */   GIM_Try, /*On fail goto*//*Label 570*/ GIMT_Encode4(31723), // Rule ID 51871 //
     /*   31660 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   31663 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31667 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
     /*   31671 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   31675 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s8,
     /*   31679 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s8,
     /*   31683 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   31685 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31690 */     GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31695 */     GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   31697 */     // (add:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs2, (mul:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rd)<<P:Predicate_mul_oneuse>>)  =>  (PseudoVMADD_VV_MF2:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rd, VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   31697 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVMADD_VV_MF2),
     /*   31700 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   31702 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // rd
     /*   31706 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // rs1
     /*   31710 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs2
     /*   31712 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   31715 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   31718 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   31721 */     GIR_RootConstrainSelectedInstOperands,
     /*   31722 */     // GIR_Coverage, 51871,
     /*   31722 */     GIR_EraseRootFromParent_Done,
     /*   31723 */   // Label 570: @31723
     /*   31723 */   GIM_Try, /*On fail goto*//*Label 571*/ GIMT_Encode4(31776), // Rule ID 46102 //
     /*   31728 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   31731 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31735 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31739 */     // (add:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 3:{ *:[i64] })
     /*   31739 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
     /*   31742 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   31746 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   31751 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   31753 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
     /*   31756 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   31758 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   31761 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*   31763 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   31765 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   31768 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   31771 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   31774 */     GIR_RootConstrainSelectedInstOperands,
     /*   31775 */     // GIR_Coverage, 46102,
     /*   31775 */     GIR_EraseRootFromParent_Done,
     /*   31776 */   // Label 571: @31776
     /*   31776 */   GIM_Try, /*On fail goto*//*Label 572*/ GIMT_Encode4(31829), // Rule ID 46103 //
     /*   31781 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   31784 */     GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31788 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31792 */     // (add:{ *:[nxv4i8] } VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2)  =>  (PseudoVADD_VV_MF2:{ *:[nxv4i8] } (IMPLICIT_DEF:{ *:[nxv4i8] }), VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 3:{ *:[i32] })
     /*   31792 */     GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_nxv4s8,
     /*   31795 */     GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
     /*   31799 */     GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
     /*   31804 */     GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
     /*   31806 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVADD_VV_MF2),
     /*   31809 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   31811 */     GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
     /*   31814 */     GIR_RootToRootCopy, /*OpIdx*/1, // rs1
     /*   31816 */     GIR_RootToRootCopy, /*OpIdx*/2, // rs2
     /*   31818 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   31821 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   31824 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   31827 */     GIR_RootConstrainSelectedInstOperands,
     /*   31828 */     // GIR_Coverage, 46103,
     /*   31828 */     GIR_EraseRootFromParent_Done,
     /*   31829 */   // Label 572: @31829
     /*   31829 */   GIM_Reject,
     /*   31830 */ // Label 566: @31830
     /*   31830 */ GIM_Reject,
     /*   31831 */ // Label 137: @31831
     /*   31831 */ GIM_Try, /*On fail goto*//*Label 573*/ GIMT_Encode4(34955),
     /*   31836 */   GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_nxv4s16,
     /*   31839 */   GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_nxv4s16,
     /*   31842 */   GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31846 */   GIM_Try, /*On fail goto*//*Label 574*/ GIMT_Encode4(31942), // Rule ID 70897 //
     /*   31851 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode0),
     /*   31854 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   31858 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   31862 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s16,
     /*   31866 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s16,
     /*   31870 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   31872 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   31876 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   31880 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv4s8,
     /*   31884 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   31886 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31891 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   31895 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   31899 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv4s8,
     /*   31903 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   31905 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31910 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31914 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   31916 */     // (add:{ *:[nxv4i16] } (mul:{ *:[nxv4i16] } (sext:{ *:[nxv4i16] } VR:{ *:[nxv4i8] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv4i16] } VR:{ *:[nxv4i8] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv4i16] }:$rd)  =>  (PseudoVWMACC_VV_MF2:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rd, VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i64] }, 3:{ *:[i64] }, 1:{ *:[i64] })
     /*   31916 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_MF2),
     /*   31919 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   31921 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   31923 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   31927 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   31931 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-1),
     /*   31934 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/3,
     /*   31937 */     GIR_AddImm8, /*InsnID*/0, /*Imm*/1,
     /*   31940 */     GIR_RootConstrainSelectedInstOperands,
     /*   31941 */     // GIR_Coverage, 70897,
     /*   31941 */     GIR_EraseRootFromParent_Done,
     /*   31942 */   // Label 574: @31942
     /*   31942 */   GIM_Try, /*On fail goto*//*Label 575*/ GIMT_Encode4(32038), // Rule ID 70898 //
     /*   31947 */     GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVInstructions_HwMode1),
     /*   31950 */     GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   31954 */     GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /*   31958 */     GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_nxv4s16,
     /*   31962 */     GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_nxv4s16,
     /*   31966 */     GIM_CheckHasOneUse, /*MI*/1,
     /*   31968 */     GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
     /*   31972 */     GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   31976 */     GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_nxv4s8,
     /*   31980 */     GIM_CheckHasOneUse, /*MI*/2,
     /*   31982 */     GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   31987 */     GIM_RecordInsn, /*DefineMI*/3, /*MI*/1, /*OpIdx*/2, // MIs[3]
     /*   31991 */     GIM_CheckOpcode, /*MI*/3, GIMT_Encode2(TargetOpcode::G_SEXT),
     /*   31995 */     GIM_CheckType, /*MI*/3, /*Op*/1, /*Type*/GILLT_nxv4s8,
     /*   31999 */     GIM_CheckHasOneUse, /*MI*/3,
     /*   32001 */     GIM_CheckRegBankForClass, /*MI*/3, /*Op*/1, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   32006 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(RISCV::VRRegClassID),
     /*   32010 */     GIM_CheckIsSafeToFold, /*NumInsns*/3,
     /*   32012 */     // (add:{ *:[nxv4i16] } (mul:{ *:[nxv4i16] } (sext:{ *:[nxv4i16] } VR:{ *:[nxv4i8] }:$rs1)<<P:Predicate_sext_oneuse>>, (sext:{ *:[nxv4i16] } VR:{ *:[nxv4i8] }:$rs2)<<P:Predicate_sext_oneuse>>)<<P:Predicate_mul_oneuse>>, VR:{ *:[nxv4i16] }:$rd)  =>  (PseudoVWMACC_VV_MF2:{ *:[nxv4i16] } VR:{ *:[nxv4i16] }:$rd, VR:{ *:[nxv4i8] }:$rs1, VR:{ *:[nxv4i8] }:$rs2, -1:{ *:[i32] }, 3:{ *:[i32] }, 1:{ *:[i32] })
     /*   32012 */     GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(RISCV::PseudoVWMACC_VV_MF2),
     /*   32015 */     GIR_RootToRootCopy, /*OpIdx*/0, // DstI[rd]
     /*   32017 */     GIR_RootToRootCopy, /*OpIdx*/2, // rd
     /*   32019 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // rs1
     /*   32023 */     GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/3, /*OpIdx*/1, // rs2
     /*   32