#ifndef itkMatrixCoefficientsSwigInterface_h
#define itkMatrixCoefficientsSwigInterface_h
#include "itkCommand.h"
#include "itkOffset.h"
#include "itkVector.h"
#include "itkCovariantVector.h"
#include "itkContinuousIndex.h"
#include "itkArray.h"
#include "itkFixedArray.h"
#include "itkRGBPixel.h"
#include "itkRGBAPixel.h"
#include "complex"
#include "itkSymmetricSecondRankTensor.h"
#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkVariableLengthVector.h"
#include "itkPoint.h"
#include "itkQuadEdgeMesh.h"
#include "itkQuadEdgeMeshParamMatrixCoefficients.h"

using itkMatrixCoefficientsQEMD2 = itk::MatrixCoefficients< itk::QuadEdgeMesh< double,2 > >;
using itkMatrixCoefficientsQEMD3 = itk::MatrixCoefficients< itk::QuadEdgeMesh< double,3 > >;
using itkMatrixCoefficientsQEMD4 = itk::MatrixCoefficients< itk::QuadEdgeMesh< double,4 > >;
using itkOnesMatrixCoefficientsQEMD2 = itk::OnesMatrixCoefficients< itk::QuadEdgeMesh< double,2 > >;
using itkOnesMatrixCoefficientsQEMD3 = itk::OnesMatrixCoefficients< itk::QuadEdgeMesh< double,3 > >;
using itkOnesMatrixCoefficientsQEMD4 = itk::OnesMatrixCoefficients< itk::QuadEdgeMesh< double,4 > >;
using itkInverseEuclideanDistanceMatrixCoefficientsQEMD2 = itk::InverseEuclideanDistanceMatrixCoefficients< itk::QuadEdgeMesh< double,2 > >;
using itkInverseEuclideanDistanceMatrixCoefficientsQEMD3 = itk::InverseEuclideanDistanceMatrixCoefficients< itk::QuadEdgeMesh< double,3 > >;
using itkInverseEuclideanDistanceMatrixCoefficientsQEMD4 = itk::InverseEuclideanDistanceMatrixCoefficients< itk::QuadEdgeMesh< double,4 > >;
using itkConformalMatrixCoefficientsQEMD2 = itk::ConformalMatrixCoefficients< itk::QuadEdgeMesh< double,2 > >;
using itkConformalMatrixCoefficientsQEMD3 = itk::ConformalMatrixCoefficients< itk::QuadEdgeMesh< double,3 > >;
using itkConformalMatrixCoefficientsQEMD4 = itk::ConformalMatrixCoefficients< itk::QuadEdgeMesh< double,4 > >;
using itkAuthalicMatrixCoefficientsQEMD2 = itk::AuthalicMatrixCoefficients< itk::QuadEdgeMesh< double,2 > >;
using itkAuthalicMatrixCoefficientsQEMD3 = itk::AuthalicMatrixCoefficients< itk::QuadEdgeMesh< double,3 > >;
using itkAuthalicMatrixCoefficientsQEMD4 = itk::AuthalicMatrixCoefficients< itk::QuadEdgeMesh< double,4 > >;
using itkIntrinsicMatrixCoefficientsQEMD2 = itk::IntrinsicMatrixCoefficients< itk::QuadEdgeMesh< double,2 > >;
using itkIntrinsicMatrixCoefficientsQEMD3 = itk::IntrinsicMatrixCoefficients< itk::QuadEdgeMesh< double,3 > >;
using itkIntrinsicMatrixCoefficientsQEMD4 = itk::IntrinsicMatrixCoefficients< itk::QuadEdgeMesh< double,4 > >;
using itkHarmonicMatrixCoefficientsQEMD2 = itk::HarmonicMatrixCoefficients< itk::QuadEdgeMesh< double,2 > >;
using itkHarmonicMatrixCoefficientsQEMD3 = itk::HarmonicMatrixCoefficients< itk::QuadEdgeMesh< double,3 > >;
using itkHarmonicMatrixCoefficientsQEMD4 = itk::HarmonicMatrixCoefficients< itk::QuadEdgeMesh< double,4 > >;


#include "itkGeometricalQuadEdgeSwigInterface.h"
#include "itkQuadEdgeMeshBaseSwigInterface.h"
#include "itkMatrixCoefficientsSwigInterface.h"
#endif
