/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, uhd, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_uhd_usrp_block = R"doc(Base class for USRP blocks.


Note that many of the functions defined here differ between Rx and Tx configurations. As an example, set_center_freq() will set the Rx frequency for a usrp_source object, and the Tx frequency on a usrp_sink object.)doc";


static const char* __doc_gr_uhd_usrp_block_set_subdev_spec = R"doc(Set the frontend specification.)doc";


static const char* __doc_gr_uhd_usrp_block_get_subdev_spec = R"doc(Get the frontend specification.)doc";


static const char* __doc_gr_uhd_usrp_block_get_num_mboards = R"doc(Return the number of motherboards in this configuration.)doc";


static const char* __doc_gr_uhd_usrp_block_set_samp_rate = R"doc(Set the sample rate for this connection to the USRP.)doc";


static const char* __doc_gr_uhd_usrp_block_get_samp_rate = R"doc(Get the sample rate for this connection to the USRP. This is the actual sample rate and may differ from the rate set.)doc";


static const char* __doc_gr_uhd_usrp_block_get_samp_rates = R"doc(Get the possible sample rates for this connection.)doc";


static const char* __doc_gr_uhd_usrp_block_set_center_freq_0 = R"doc()doc";


static const char* __doc_gr_uhd_usrp_block_set_center_freq_1 = R"doc()doc";


static const char* __doc_gr_uhd_usrp_block_get_center_freq = R"doc(Get the center frequency.)doc";


static const char* __doc_gr_uhd_usrp_block_get_freq_range = R"doc(Get the tunable frequency range.)doc";


static const char* __doc_gr_uhd_usrp_block_set_gain_0 = R"doc()doc";


static const char* __doc_gr_uhd_usrp_block_set_gain_1 = R"doc()doc";


static const char* __doc_gr_uhd_usrp_block_set_normalized_gain = R"doc(Set the normalized gain.


The normalized gain is always in [0, 1], regardless of the device. 0 corresponds to minimum gain (usually 0 dB, but make sure to read the device notes in the UHD manual) and 1 corresponds to maximum gain. This will work for any UHD device. Use get_gain() to see which dB value the normalized gain value corresponds to.


Note that it is not possible to specify a gain name for this function.)doc";


static const char* __doc_gr_uhd_usrp_block_get_gain_0 = R"doc()doc";


static const char* __doc_gr_uhd_usrp_block_get_gain_1 = R"doc()doc";


static const char* __doc_gr_uhd_usrp_block_get_normalized_gain = R"doc(Returns the normalized gain.


The normalized gain is always in [0, 1], regardless of the device. See also set_normalized_gain().


Note that it is not possible to specify a gain name for this function, the result is over the entire gain chain.)doc";


static const char* __doc_gr_uhd_usrp_block_get_gain_names = R"doc(Get the actual dboard gain setting of named stage.)doc";


static const char* __doc_gr_uhd_usrp_block_get_gain_range_0 = R"doc()doc";


static const char* __doc_gr_uhd_usrp_block_get_gain_range_1 = R"doc()doc";


static const char* __doc_gr_uhd_usrp_block_has_power_reference = R"doc(Query if this device is capable of absolute power levels


If true, the set_power_reference() and get_power_reference() APIs can be used as well. Note that if the underlying UHD version doesn't support power APIs, a warning will be printed, and the return value is always false.)doc";


static const char* __doc_gr_uhd_usrp_block_set_power_reference = R"doc(Set the absolute power reference level for this channel


Note that this API is available for certain devices only, and only if calibration data is available. Refer to the UHD manual for greater detail: 


In a nutshell, using the power reference will configure the device such that a full-scale signal (0 dBFS) corresponds to a signal at the antenna connector of . After calling this function, the device will attempt to keep the power level constant after retuning, which means the gain level may be changed after a re-tune.


The device may coerce the available power level (for example, if the requested power level is not achievable by the device). The coerced value may be read by calling get_power_reference().)doc";


static const char* __doc_gr_uhd_usrp_block_get_power_reference = R"doc(Return the absolute power reference level for this channel


Note that this API is only available for certain devices, and assuming the existence of calibration data. Refer to the UHD manual for greater detail: 


See also set_power_reference().)doc";


static const char* __doc_gr_uhd_usrp_block_get_power_range = R"doc(Return the available power range)doc";


static const char* __doc_gr_uhd_usrp_block_set_antenna = R"doc(Set the antenna to use for a given channel.)doc";


static const char* __doc_gr_uhd_usrp_block_get_antenna = R"doc(Get the antenna in use.)doc";


static const char* __doc_gr_uhd_usrp_block_get_antennas = R"doc(Get a list of possible antennas on a given channel.)doc";


static const char* __doc_gr_uhd_usrp_block_set_bandwidth = R"doc(Set the bandpass filter on the RF frontend.)doc";


static const char* __doc_gr_uhd_usrp_block_get_bandwidth = R"doc(Get the bandpass filter setting on the RF frontend.)doc";


static const char* __doc_gr_uhd_usrp_block_get_bandwidth_range = R"doc(Get the bandpass filter range of the RF frontend.)doc";


static const char* __doc_gr_uhd_usrp_block_get_sensor = R"doc(Get an RF frontend sensor value.)doc";


static const char* __doc_gr_uhd_usrp_block_get_sensor_names = R"doc(Get a list of possible RF frontend sensor names.)doc";


static const char* __doc_gr_uhd_usrp_block_get_dboard_sensor = R"doc(DEPRECATED use get_sensor.)doc";


static const char* __doc_gr_uhd_usrp_block_get_dboard_sensor_names = R"doc(DEPRECATED use get_sensor_names.)doc";


static const char* __doc_gr_uhd_usrp_block_get_mboard_sensor = R"doc(Get a motherboard sensor value.)doc";


static const char* __doc_gr_uhd_usrp_block_get_mboard_sensor_names = R"doc(Get a list of possible motherboard sensor names.)doc";


static const char* __doc_gr_uhd_usrp_block_get_time_source = R"doc(Get the currently set time source.)doc";


static const char* __doc_gr_uhd_usrp_block_get_time_sources = R"doc(Get a list of possible time sources.)doc";


static const char* __doc_gr_uhd_usrp_block_set_clock_source = R"doc(Set the clock source for the usrp device.


This sets the source for a 10 MHz reference clock. Typical options for source: internal, external, MIMO.)doc";


static const char* __doc_gr_uhd_usrp_block_get_clock_source = R"doc(Get the currently set clock source.)doc";


static const char* __doc_gr_uhd_usrp_block_get_clock_sources = R"doc(Get a list of possible clock sources.)doc";


static const char* __doc_gr_uhd_usrp_block_get_clock_rate = R"doc(Get the master clock rate.)doc";


static const char* __doc_gr_uhd_usrp_block_set_clock_rate = R"doc(Set the master clock rate.)doc";


static const char* __doc_gr_uhd_usrp_block_get_time_now = R"doc(Get the current time registers.)doc";


static const char* __doc_gr_uhd_usrp_block_get_time_last_pps = R"doc(Get the time when the last pps pulse occurred.)doc";


static const char* __doc_gr_uhd_usrp_block_set_time_now = R"doc(Sets the time registers immediately.)doc";


static const char* __doc_gr_uhd_usrp_block_set_time_next_pps = R"doc(Set the time registers at the next pps.)doc";


static const char* __doc_gr_uhd_usrp_block_set_time_unknown_pps = R"doc(Sync the time registers with an unknown pps edge.)doc";


static const char* __doc_gr_uhd_usrp_block_set_command_time = R"doc(Set the time at which the control commands will take effect.


A timed command will back-pressure all subsequent timed commands, assuming that the subsequent commands occur within the time-window. If the time spec is late, the command will be activated upon arrival.)doc";


static const char* __doc_gr_uhd_usrp_block_clear_command_time = R"doc(Clear the command time so future commands are sent ASAP.)doc";


static const char* __doc_gr_uhd_usrp_block_get_dboard_iface = R"doc(Get access to the underlying uhd dboard iface object.)doc";


static const char* __doc_gr_uhd_usrp_block_get_device = R"doc(Get access to the underlying uhd device object.


NOTE: This function is only available in C++.)doc";


static const char* __doc_gr_uhd_usrp_block_set_user_register = R"doc(Perform write on the user configuration register bus. These only exist if the user has implemented custom setting registers in the device FPGA.)doc";


static const char* __doc_gr_uhd_usrp_block_set_time_source = R"doc(Set the time source for the USRP device.


This sets the method of time synchronization, typically a pulse per second or an encoded time. Typical options for source: external, MIMO.)doc";


static const char* __doc_gr_uhd_usrp_block_set_stream_args = R"doc(Update the stream args for this device.


This update will only take effect after a restart of the streaming, or before streaming and after construction. This will also delete the current streamer. Note you cannot change the I/O signature of this block using this function, or it will throw.


It is possible to leave the 'channels' fields of  unset. In this case, the previous channels field is used.)doc";


static const char* __doc_gr_uhd_usrp_block_get_gpio_banks = R"doc(Enumerate GPIO banks on the current device.)doc";


static const char* __doc_gr_uhd_usrp_block_set_gpio_attr = R"doc(Set a GPIO attribute on a particular GPIO bank. Possible attribute names:)doc";


static const char* __doc_gr_uhd_usrp_block_get_gpio_attr = R"doc(Get a GPIO attribute on a particular GPIO bank. Possible attribute names:)doc";


static const char* __doc_gr_uhd_usrp_block_get_filter_names = R"doc(Enumerate the available filters in the signal path.)doc";


static const char* __doc_gr_uhd_usrp_block_set_filter = R"doc(Write back a filter obtained by get_filter() to the signal path.


This filter can be a modified version of the originally returned one. The information about Rx or Tx is contained in the path parameter.)doc";


static const char* __doc_gr_uhd_usrp_block_get_filter = R"doc(Return the filter object for the given name.)doc";


static const char* __doc_gr_uhd_usrp_block_get_usrp_info = R"doc(Returns identifying information about this USRP's configuration. Returns motherboard ID, name, and serial. Returns daughterboard TX ID, subdev name and spec, serial, and antenna.)doc";


static const char* __doc_gr_uhd_cmd_chan_key = R"doc()doc";


static const char* __doc_gr_uhd_cmd_gain_key = R"doc()doc";


static const char* __doc_gr_uhd_cmd_power_key = R"doc()doc";


static const char* __doc_gr_uhd_cmd_freq_key = R"doc()doc";


static const char* __doc_gr_uhd_cmd_lo_offset_key = R"doc()doc";


static const char* __doc_gr_uhd_cmd_tune_key = R"doc()doc";


static const char* __doc_gr_uhd_cmd_lo_freq_key = R"doc()doc";


static const char* __doc_gr_uhd_cmd_dsp_freq_key = R"doc()doc";


static const char* __doc_gr_uhd_cmd_rate_key = R"doc()doc";


static const char* __doc_gr_uhd_cmd_bandwidth_key = R"doc()doc";


static const char* __doc_gr_uhd_cmd_time_key = R"doc()doc";


static const char* __doc_gr_uhd_cmd_mboard_key = R"doc()doc";


static const char* __doc_gr_uhd_cmd_antenna_key = R"doc()doc";


static const char* __doc_gr_uhd_cmd_direction_key = R"doc()doc";


static const char* __doc_gr_uhd_cmd_tag_key = R"doc()doc";


static const char* __doc_gr_uhd_direction_rx = R"doc()doc";


static const char* __doc_gr_uhd_direction_tx = R"doc()doc";
