/* spice-display.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from spice-display.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib-object.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "common.h"
#include <stdlib.h>
#include <string.h>
#include <spice-client.h>
#include <spice-widget.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <handy.h>
#include <cairo-gobject.h>
#include <gio/gio.h>
#include <libusb.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOXES_TYPE_DISPLAY (boxes_display_get_type ())
#define BOXES_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DISPLAY, BoxesDisplay))
#define BOXES_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DISPLAY, BoxesDisplayClass))
#define BOXES_IS_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DISPLAY))
#define BOXES_IS_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DISPLAY))
#define BOXES_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DISPLAY, BoxesDisplayClass))

typedef struct _BoxesDisplay BoxesDisplay;
typedef struct _BoxesDisplayClass BoxesDisplayClass;
typedef struct _BoxesDisplayPrivate BoxesDisplayPrivate;
typedef gint (*BoxesDisplayOpenFDFunc) (gpointer user_data);

#define BOXES_TYPE_SPICE_DISPLAY (boxes_spice_display_get_type ())
#define BOXES_SPICE_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplay))
#define BOXES_SPICE_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplayClass))
#define BOXES_IS_SPICE_DISPLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_SPICE_DISPLAY))
#define BOXES_IS_SPICE_DISPLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_SPICE_DISPLAY))
#define BOXES_SPICE_DISPLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplayClass))

typedef struct _BoxesSpiceDisplay BoxesSpiceDisplay;
typedef struct _BoxesSpiceDisplayClass BoxesSpiceDisplayClass;
typedef struct _BoxesSpiceDisplayPrivate BoxesSpiceDisplayPrivate;

#define BOXES_TYPE_COLLECTION_ITEM (boxes_collection_item_get_type ())
#define BOXES_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItem))
#define BOXES_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))
#define BOXES_IS_COLLECTION_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_IS_COLLECTION_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_COLLECTION_ITEM))
#define BOXES_COLLECTION_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_COLLECTION_ITEM, BoxesCollectionItemClass))

typedef struct _BoxesCollectionItem BoxesCollectionItem;
typedef struct _BoxesCollectionItemClass BoxesCollectionItemClass;

#define BOXES_TYPE_MACHINE (boxes_machine_get_type ())
#define BOXES_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_MACHINE, BoxesMachine))
#define BOXES_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_MACHINE, BoxesMachineClass))
#define BOXES_IS_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_MACHINE))
#define BOXES_IS_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_MACHINE))
#define BOXES_MACHINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_MACHINE, BoxesMachineClass))

typedef struct _BoxesMachine BoxesMachine;
typedef struct _BoxesMachineClass BoxesMachineClass;

#define BOXES_TYPE_SPICE_CHANNEL_HANDLER (boxes_spice_channel_handler_get_type ())
#define BOXES_SPICE_CHANNEL_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_SPICE_CHANNEL_HANDLER, BoxesSpiceChannelHandler))
#define BOXES_SPICE_CHANNEL_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_SPICE_CHANNEL_HANDLER, BoxesSpiceChannelHandlerClass))
#define BOXES_IS_SPICE_CHANNEL_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_SPICE_CHANNEL_HANDLER))
#define BOXES_IS_SPICE_CHANNEL_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_SPICE_CHANNEL_HANDLER))
#define BOXES_SPICE_CHANNEL_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_SPICE_CHANNEL_HANDLER, BoxesSpiceChannelHandlerClass))

typedef struct _BoxesSpiceChannelHandler BoxesSpiceChannelHandler;
typedef struct _BoxesSpiceChannelHandlerClass BoxesSpiceChannelHandlerClass;
enum  {
	BOXES_SPICE_DISPLAY_0_PROPERTY,
	BOXES_SPICE_DISPLAY_PROTOCOL_PROPERTY,
	BOXES_SPICE_DISPLAY_URI_PROPERTY,
	BOXES_SPICE_DISPLAY_CAN_TRANSFER_FILES_PROPERTY,
	BOXES_SPICE_DISPLAY_CA_CERT_PROPERTY,
	BOXES_SPICE_DISPLAY_MAIN_CHANNEL_PROPERTY,
	BOXES_SPICE_DISPLAY_NUM_PROPERTIES
};
static GParamSpec* boxes_spice_display_properties[BOXES_SPICE_DISPLAY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define BOXES_TYPE_UI (boxes_ui_get_type ())
#define BOXES_UI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UI, BoxesUI))
#define BOXES_IS_UI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UI))
#define BOXES_UI_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BOXES_TYPE_UI, BoxesUIIface))

typedef struct _BoxesUI BoxesUI;
typedef struct _BoxesUIIface BoxesUIIface;
typedef enum  {
	BOXES_UI_STATE_NONE,
	BOXES_UI_STATE_COLLECTION,
	BOXES_UI_STATE_CREDS,
	BOXES_UI_STATE_DISPLAY,
	BOXES_UI_STATE_WIZARD,
	BOXES_UI_STATE_PROPERTIES,
	BOXES_UI_STATE_TROUBLESHOOT
} BoxesUIState;

#define BOXES_TYPE_UI_STATE (boxes_ui_state_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block44Data Block44Data;
typedef struct _Block45Data Block45Data;

#define BOXES_TYPE_APP_WINDOW (boxes_app_window_get_type ())
#define BOXES_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_APP_WINDOW, BoxesAppWindow))
#define BOXES_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_APP_WINDOW, BoxesAppWindowClass))
#define BOXES_IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_APP_WINDOW))
#define BOXES_IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_APP_WINDOW))
#define BOXES_APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_APP_WINDOW, BoxesAppWindowClass))

typedef struct _BoxesAppWindow BoxesAppWindow;
typedef struct _BoxesAppWindowClass BoxesAppWindowClass;
#define _g_ptr_array_unref0(var) ((var == NULL) ? NULL : (var = (g_ptr_array_unref (var), NULL)))

#define BOXES_TYPE_LIBVIRT_MACHINE (boxes_libvirt_machine_get_type ())
#define BOXES_LIBVIRT_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_LIBVIRT_MACHINE, BoxesLibvirtMachine))
#define BOXES_LIBVIRT_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_LIBVIRT_MACHINE, BoxesLibvirtMachineClass))
#define BOXES_IS_LIBVIRT_MACHINE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_LIBVIRT_MACHINE))
#define BOXES_IS_LIBVIRT_MACHINE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_LIBVIRT_MACHINE))
#define BOXES_LIBVIRT_MACHINE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_LIBVIRT_MACHINE, BoxesLibvirtMachineClass))

typedef struct _BoxesLibvirtMachine BoxesLibvirtMachine;
typedef struct _BoxesLibvirtMachineClass BoxesLibvirtMachineClass;
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define __vala_SpiceUsbDevice_free0(var) ((var == NULL) ? NULL : (var = (_vala_SpiceUsbDevice_free (var), NULL)))

#define BOXES_TYPE_APP (boxes_app_get_type ())
#define BOXES_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_APP, BoxesApp))
#define BOXES_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_APP, BoxesAppClass))
#define BOXES_IS_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_APP))
#define BOXES_IS_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_APP))
#define BOXES_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_APP, BoxesAppClass))

typedef struct _BoxesApp BoxesApp;
typedef struct _BoxesAppClass BoxesAppClass;
typedef struct _BoxesAppPrivate BoxesAppPrivate;

#define BOXES_TYPE_COLLECTION (boxes_collection_get_type ())
#define BOXES_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_COLLECTION, BoxesCollection))
#define BOXES_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_COLLECTION, BoxesCollectionClass))
#define BOXES_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_COLLECTION))
#define BOXES_IS_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_COLLECTION))
#define BOXES_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_COLLECTION, BoxesCollectionClass))

typedef struct _BoxesCollection BoxesCollection;
typedef struct _BoxesCollectionClass BoxesCollectionClass;

#define BOXES_TYPE_SHARED_FOLDERS_MANAGER (boxes_shared_folders_manager_get_type ())
#define BOXES_SHARED_FOLDERS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_SHARED_FOLDERS_MANAGER, BoxesSharedFoldersManager))
#define BOXES_SHARED_FOLDERS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_SHARED_FOLDERS_MANAGER, BoxesSharedFoldersManagerClass))
#define BOXES_IS_SHARED_FOLDERS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_SHARED_FOLDERS_MANAGER))
#define BOXES_IS_SHARED_FOLDERS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_SHARED_FOLDERS_MANAGER))
#define BOXES_SHARED_FOLDERS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_SHARED_FOLDERS_MANAGER, BoxesSharedFoldersManagerClass))

typedef struct _BoxesSharedFoldersManager BoxesSharedFoldersManager;
typedef struct _BoxesSharedFoldersManagerClass BoxesSharedFoldersManagerClass;
typedef struct _BoxesCollectionItemPrivate BoxesCollectionItemPrivate;
typedef struct _BoxesMachinePrivate BoxesMachinePrivate;
typedef enum  {
	BOXES_MACHINE_CONNECT_FLAGS_NONE = 0,
	BOXES_MACHINE_CONNECT_FLAGS_IGNORE_SAVED_STATE = 1 << 0
} BoxesMachineConnectFlags;

#define BOXES_MACHINE_TYPE_CONNECT_FLAGS (boxes_machine_connect_flags_get_type ())

#define BOXES_TYPE_DISPLAY_PAGE (boxes_display_page_get_type ())
#define BOXES_DISPLAY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DISPLAY_PAGE, BoxesDisplayPage))
#define BOXES_DISPLAY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DISPLAY_PAGE, BoxesDisplayPageClass))
#define BOXES_IS_DISPLAY_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DISPLAY_PAGE))
#define BOXES_IS_DISPLAY_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DISPLAY_PAGE))
#define BOXES_DISPLAY_PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DISPLAY_PAGE, BoxesDisplayPageClass))

typedef struct _BoxesDisplayPage BoxesDisplayPage;
typedef struct _BoxesDisplayPageClass BoxesDisplayPageClass;
typedef struct _BoxesAppWindowPrivate BoxesAppWindowPrivate;

#define BOXES_TYPE_SEARCHBAR (boxes_searchbar_get_type ())
#define BOXES_SEARCHBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_SEARCHBAR, BoxesSearchbar))
#define BOXES_SEARCHBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_SEARCHBAR, BoxesSearchbarClass))
#define BOXES_IS_SEARCHBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_SEARCHBAR))
#define BOXES_IS_SEARCHBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_SEARCHBAR))
#define BOXES_SEARCHBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_SEARCHBAR, BoxesSearchbarClass))

typedef struct _BoxesSearchbar BoxesSearchbar;
typedef struct _BoxesSearchbarClass BoxesSearchbarClass;

#define BOXES_TYPE_TOPBAR (boxes_topbar_get_type ())
#define BOXES_TOPBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_TOPBAR, BoxesTopbar))
#define BOXES_TOPBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_TOPBAR, BoxesTopbarClass))
#define BOXES_IS_TOPBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_TOPBAR))
#define BOXES_IS_TOPBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_TOPBAR))
#define BOXES_TOPBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_TOPBAR, BoxesTopbarClass))

typedef struct _BoxesTopbar BoxesTopbar;
typedef struct _BoxesTopbarClass BoxesTopbarClass;

#define BOXES_TYPE_TOAST_OVERLAY (boxes_toast_overlay_get_type ())
#define BOXES_TOAST_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_TOAST_OVERLAY, BoxesToastOverlay))
#define BOXES_TOAST_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_TOAST_OVERLAY, BoxesToastOverlayClass))
#define BOXES_IS_TOAST_OVERLAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_TOAST_OVERLAY))
#define BOXES_IS_TOAST_OVERLAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_TOAST_OVERLAY))
#define BOXES_TOAST_OVERLAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_TOAST_OVERLAY, BoxesToastOverlayClass))

typedef struct _BoxesToastOverlay BoxesToastOverlay;
typedef struct _BoxesToastOverlayClass BoxesToastOverlayClass;

#define BOXES_TYPE_TROUBLESHOOT_VIEW (boxes_troubleshoot_view_get_type ())
#define BOXES_TROUBLESHOOT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_TROUBLESHOOT_VIEW, BoxesTroubleshootView))
#define BOXES_TROUBLESHOOT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_TROUBLESHOOT_VIEW, BoxesTroubleshootViewClass))
#define BOXES_IS_TROUBLESHOOT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_TROUBLESHOOT_VIEW))
#define BOXES_IS_TROUBLESHOOT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_TROUBLESHOOT_VIEW))
#define BOXES_TROUBLESHOOT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_TROUBLESHOOT_VIEW, BoxesTroubleshootViewClass))

typedef struct _BoxesTroubleshootView BoxesTroubleshootView;
typedef struct _BoxesTroubleshootViewClass BoxesTroubleshootViewClass;
#define _libusb_unref_device0(var) ((var == NULL) ? NULL : (var = (libusb_unref_device (var), NULL)))
#define _libusb_free_config_descriptor0(var) ((var == NULL) ? NULL : (var = (libusb_free_config_descriptor (var), NULL)))
typedef struct _Block46Data Block46Data;

#define BOXES_TYPE_USB_DEVICE (boxes_usb_device_get_type ())
#define BOXES_USB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_USB_DEVICE, BoxesUsbDevice))
#define BOXES_USB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_USB_DEVICE, BoxesUsbDeviceClass))
#define BOXES_IS_USB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_USB_DEVICE))
#define BOXES_IS_USB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_USB_DEVICE))
#define BOXES_USB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_USB_DEVICE, BoxesUsbDeviceClass))

typedef struct _BoxesUsbDevice BoxesUsbDevice;
typedef struct _BoxesUsbDeviceClass BoxesUsbDeviceClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block47Data Block47Data;
typedef struct _BoxesUsbDevicePrivate BoxesUsbDevicePrivate;
typedef struct _BoxesSpiceChannelHandlerPrivate BoxesSpiceChannelHandlerPrivate;
enum  {
	BOXES_SPICE_CHANNEL_HANDLER_0_PROPERTY,
	BOXES_SPICE_CHANNEL_HANDLER_NUM_PROPERTIES
};
static GParamSpec* boxes_spice_channel_handler_properties[BOXES_SPICE_CHANNEL_HANDLER_NUM_PROPERTIES];
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _BoxesDisplay {
	GObject parent_instance;
	BoxesDisplayPrivate * priv;
	gboolean connected;
	GHashTable* displays;
};

struct _BoxesDisplayClass {
	GObjectClass parent_class;
	GtkWidget* (*get_display) (BoxesDisplay* self, gint n);
	GdkPixbuf* (*get_pixbuf) (BoxesDisplay* self, gint n, GError** error);
	void (*set_enable_audio) (BoxesDisplay* self, gboolean enable);
	gboolean (*should_keep_alive) (BoxesDisplay* self);
	void (*connect_it) (BoxesDisplay* self, BoxesDisplayOpenFDFunc open_fd, gpointer open_fd_target, GDestroyNotify open_fd_target_destroy_notify, GError** error);
	void (*disconnect_it) (BoxesDisplay* self);
	void (*collect_logs) (BoxesDisplay* self, GString* builder);
	void (*transfer_files) (BoxesDisplay* self, GList* uris);
	void (*send_keys) (BoxesDisplay* self, guint* keyvals, gint keyvals_length1);
	const gchar* (*get_protocol) (BoxesDisplay* self);
	gchar* (*get_uri) (BoxesDisplay* self);
	gboolean (*get_can_transfer_files) (BoxesDisplay* self);
};

struct _BoxesSpiceDisplay {
	BoxesDisplay parent_instance;
	BoxesSpiceDisplayPrivate * priv;
};

struct _BoxesSpiceDisplayClass {
	BoxesDisplayClass parent_class;
};

struct _BoxesSpiceDisplayPrivate {
	BoxesMachine* machine;
	SpiceSession* session;
	SpiceGtkSession* gtk_session;
	SpiceAudio* audio;
	gulong channel_new_id;
	gulong channel_destroy_id;
	BoxesBoxConfigSavedProperty* display_saved_properties;
	gint display_saved_properties_length1;
	gint _display_saved_properties_size_;
	BoxesBoxConfigSavedProperty* gtk_session_saved_properties;
	gint gtk_session_saved_properties_length1;
	gint _gtk_session_saved_properties_size_;
	gboolean closed;
	SpicePortChannel* webdav_channel;
	GHashTable* channel_handlers;
	BoxesDisplayOpenFDFunc open_fd;
	gpointer open_fd_target;
	GDestroyNotify open_fd_target_destroy_notify;
	SpiceMainChannel* _main_channel;
	gulong main_event_id;
	gulong main_mouse_mode_id;
	gulong new_file_transfer_id;
	gulong agent_connected_id;
};

struct _BoxesUIIface {
	GTypeInterface parent_iface;
	BoxesUIState (*get_previous_ui_state) (BoxesUI* self);
	void (*set_previous_ui_state) (BoxesUI* self, BoxesUIState value);
	BoxesUIState (*get_ui_state) (BoxesUI* self);
	void (*set_ui_state) (BoxesUI* self, BoxesUIState value);
};

struct _Block44Data {
	int _ref_count_;
	BoxesSpiceDisplay* self;
	SpiceDisplay* display;
};

struct _Block45Data {
	int _ref_count_;
	Block44Data * _data44_;
	GdkWindow* gdk_window;
	gint scale_factor;
};

struct _BoxesApp {
	GtkApplication parent_instance;
	BoxesAppPrivate * priv;
	BoxesCollection* collection;
	BoxesAsyncLauncher* async_launcher;
	BoxesSharedFoldersManager* shared_folders_manager;
};

struct _BoxesAppClass {
	GtkApplicationClass parent_class;
};

struct _BoxesCollectionItem {
	GObject parent_instance;
	BoxesCollectionItemPrivate * priv;
};

struct _BoxesCollectionItemClass {
	GObjectClass parent_class;
	gint (*compare) (BoxesCollectionItem* self, BoxesCollectionItem* other);
};

struct _BoxesMachine {
	BoxesCollectionItem parent_instance;
	BoxesMachinePrivate * priv;
	BoxesCollectionSource* source;
	BoxesBoxConfig* config;
	gboolean stay_on_display;
};

struct _BoxesMachineClass {
	BoxesCollectionItemClass parent_class;
	void (*save_real) (BoxesMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*save_real_finish) (BoxesMachine* self, GAsyncResult* _res_, GError** error);
	void (*take_screenshot) (BoxesMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GdkPixbuf* (*take_screenshot_finish) (BoxesMachine* self, GAsyncResult* _res_, GError** error);
	void (*connect_display) (BoxesMachine* self, BoxesMachineConnectFlags flags, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*connect_display_finish) (BoxesMachine* self, GAsyncResult* _res_, GError** error);
	void (*restart) (BoxesMachine* self);
	void (*clone) (BoxesMachine* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*clone_finish) (BoxesMachine* self, GAsyncResult* _res_);
	void (*disconnect_display) (BoxesMachine* self);
	void (*update_status) (BoxesMachine* self);
	void (*delete) (BoxesMachine* self, gboolean by_user);
	gboolean (*get_suspend_at_exit) (BoxesMachine* self);
	gboolean (*get_can_save) (BoxesMachine* self);
	gboolean (*get_can_restart) (BoxesMachine* self);
	gboolean (*get_can_clone) (BoxesMachine* self);
	gboolean (*get_should_autosave) (BoxesMachine* self);
	gboolean (*get_is_local) (BoxesMachine* self);
};

struct _BoxesAppWindow {
	HdyApplicationWindow parent_instance;
	BoxesAppWindowPrivate * priv;
	BoxesSearchbar* searchbar;
	BoxesTopbar* topbar;
	BoxesToastOverlay* toast_overlay;
	BoxesDisplayPage* display_page;
	HdyStatusPage* empty_boxes;
	BoxesTroubleshootView* troubleshoot_view;
	GtkStack* below_bin;
	GSettings* settings;
};

struct _BoxesAppWindowClass {
	HdyApplicationWindowClass parent_class;
};

struct _Block46Data {
	int _ref_count_;
	BoxesSpiceDisplay* self;
	SpiceUsbDeviceManager* manager;
};

struct _Block47Data {
	int _ref_count_;
	Block46Data * _data46_;
	SpiceUsbDevice* dev;
	BoxesUsbDevice* usb_device;
};

struct _BoxesUsbDevice {
	GObject parent_instance;
	BoxesUsbDevicePrivate * priv;
	gchar* title;
};

struct _BoxesUsbDeviceClass {
	GObjectClass parent_class;
};

struct _BoxesSpiceChannelHandler {
	GObject parent_instance;
	BoxesSpiceChannelHandlerPrivate * priv;
};

struct _BoxesSpiceChannelHandlerClass {
	GObjectClass parent_class;
};

struct _BoxesSpiceChannelHandlerPrivate {
	BoxesSpiceDisplay* display;
	SpiceChannel* channel;
	BoxesDisplayOpenFDFunc open_fd;
	gpointer open_fd_target;
};

static gint BoxesSpiceDisplay_private_offset;
static gpointer boxes_spice_display_parent_class = NULL;
VALA_EXTERN BoxesApp* boxes_app_app;
static gint BoxesSpiceChannelHandler_private_offset;
static gpointer boxes_spice_channel_handler_parent_class = NULL;

VALA_EXTERN GType boxes_display_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesDisplay, g_object_unref)
VALA_EXTERN GType boxes_spice_display_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesSpiceDisplay, g_object_unref)
VALA_EXTERN GType boxes_collection_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesCollectionItem, g_object_unref)
VALA_EXTERN GType boxes_machine_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesMachine, g_object_unref)
VALA_EXTERN GType boxes_spice_channel_handler_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesSpiceChannelHandler, g_object_unref)
VALA_EXTERN GtkWidget* boxes_display_get_display (BoxesDisplay* self,
                                      gint n);
VALA_EXTERN gboolean boxes_display_should_keep_alive (BoxesDisplay* self);
VALA_EXTERN void boxes_display_set_enable_audio (BoxesDisplay* self,
                                     gboolean enable);
VALA_EXTERN GdkPixbuf* boxes_display_get_pixbuf (BoxesDisplay* self,
                                     gint n,
                                     GError** error);
VALA_EXTERN void boxes_display_collect_logs (BoxesDisplay* self,
                                 GString* builder);
VALA_EXTERN void boxes_display_connect_it (BoxesDisplay* self,
                               BoxesDisplayOpenFDFunc open_fd,
                               gpointer open_fd_target,
                               GDestroyNotify open_fd_target_destroy_notify,
                               GError** error);
VALA_EXTERN void boxes_display_disconnect_it (BoxesDisplay* self);
VALA_EXTERN void boxes_display_transfer_files (BoxesDisplay* self,
                                   GList* uris);
VALA_EXTERN void boxes_display_send_keys (BoxesDisplay* self,
                              guint* keyvals,
                              gint keyvals_length1);
VALA_EXTERN const gchar* boxes_display_get_protocol (BoxesDisplay* self);
VALA_EXTERN gchar* boxes_display_get_uri (BoxesDisplay* self);
VALA_EXTERN gboolean boxes_display_get_can_transfer_files (BoxesDisplay* self);
static void boxes_spice_display_main_cleanup (BoxesSpiceDisplay* self);
static void _vala_BoxesBoxConfigSavedProperty_array_free (BoxesBoxConfigSavedProperty * array,
                                                   gssize array_length);
static void boxes_spice_display_ui_state_changed (BoxesSpiceDisplay* self);
VALA_EXTERN GType boxes_ui_state_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType boxes_ui_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesUI, g_object_unref)
VALA_EXTERN BoxesUIState boxes_ui_get_ui_state (BoxesUI* self);
static gchar* boxes_spice_display_get_box_name (BoxesSpiceDisplay* self);
VALA_EXTERN BoxesBoxConfig* boxes_display_get_config (BoxesDisplay* self);
VALA_EXTERN SpiceMainChannel* boxes_spice_display_get_main_channel (BoxesSpiceDisplay* self);
VALA_EXTERN void boxes_spice_display_set_main_channel (BoxesSpiceDisplay* self,
                                           SpiceMainChannel* value);
VALA_EXTERN BoxesSpiceDisplay* boxes_spice_display_new (BoxesMachine* machine,
                                            BoxesBoxConfig* config,
                                            const gchar* host,
                                            gint port,
                                            gint tls_port);
VALA_EXTERN BoxesSpiceDisplay* boxes_spice_display_construct (GType object_type,
                                                  BoxesMachine* machine,
                                                  BoxesBoxConfig* config,
                                                  const gchar* host,
                                                  gint port,
                                                  gint tls_port);
VALA_EXTERN BoxesDisplay* boxes_display_construct (GType object_type);
static void _boxes_spice_display_ui_state_changed_g_object_notify (GObject* _sender,
                                                            GParamSpec* pspec,
                                                            gpointer self);
VALA_EXTERN void boxes_display_set_config (BoxesDisplay* self,
                               BoxesBoxConfig* value);
VALA_EXTERN BoxesSpiceDisplay* boxes_spice_display_new_with_uri (BoxesMachine* machine,
                                                     BoxesBoxConfig* config,
                                                     const gchar* uri);
VALA_EXTERN BoxesSpiceDisplay* boxes_spice_display_construct_with_uri (GType object_type,
                                                           BoxesMachine* machine,
                                                           BoxesBoxConfig* config,
                                                           const gchar* uri);
VALA_EXTERN BoxesSpiceDisplay* boxes_spice_display_new_priv (BoxesMachine* machine,
                                                 BoxesBoxConfig* config);
VALA_EXTERN BoxesSpiceDisplay* boxes_spice_display_construct_priv (GType object_type,
                                                       BoxesMachine* machine,
                                                       BoxesBoxConfig* config);
static GtkWidget* boxes_spice_display_real_get_display (BoxesDisplay* base,
                                                 gint n);
static Block44Data* block44_data_ref (Block44Data* _data44_);
static void block44_data_unref (void * _userdata_);
static Block45Data* block45_data_ref (Block45Data* _data45_);
static void block45_data_unref (void * _userdata_);
static void ___lambda74_ (BoxesSpiceDisplay* self,
                   gint status);
VALA_EXTERN void boxes_display_set_mouse_grabbed (BoxesDisplay* self,
                                      gboolean value);
static void ____lambda74__spice_display_mouse_grab (SpiceDisplay* _sender,
                                             gint status,
                                             gpointer self);
static void ___lambda75_ (BoxesSpiceDisplay* self,
                   gint status);
VALA_EXTERN void boxes_display_set_keyboard_grabbed (BoxesDisplay* self,
                                         gboolean value);
static void ____lambda75__spice_display_keyboard_grab (SpiceDisplay* _sender,
                                                gint status,
                                                gpointer self);
VALA_EXTERN GType boxes_app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesAppWindow, g_object_unref)
VALA_EXTERN BoxesAppWindow* boxes_machine_get_window (BoxesMachine* self);
static gboolean ___lambda76_ (Block45Data* _data45_,
                       GdkEventConfigure* event);
static gboolean ____lambda76__gtk_widget_configure_event (GtkWidget* _sender,
                                                   GdkEventConfigure* event,
                                                   gpointer self);
static gboolean boxes_spice_display_real_should_keep_alive (BoxesDisplay* base);
static GPtrArray* boxes_spice_display_get_usb_devices (BoxesSpiceDisplay* self,
                                                SpiceUsbDeviceManager* manager);
static void boxes_spice_display_real_set_enable_audio (BoxesDisplay* base,
                                                gboolean enable);
static GdkPixbuf* boxes_spice_display_real_get_pixbuf (BoxesDisplay* base,
                                                gint n,
                                                GError** error);
VALA_EXTERN GType boxes_libvirt_machine_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesLibvirtMachine, g_object_unref)
VALA_EXTERN gboolean boxes_libvirt_machine_get_acceleration_3d (BoxesLibvirtMachine* self);
static GdkPixbuf* boxes_spice_display_draw_pixbuf_client_side (BoxesSpiceDisplay* self,
                                                        SpiceDisplay* display);
static void boxes_spice_display_real_collect_logs (BoxesDisplay* base,
                                            GString* builder);
static SpiceUsbDevice* _vala_SpiceUsbDevice_copy (SpiceUsbDevice* self);
static void _vala_SpiceUsbDevice_free (SpiceUsbDevice* self);
static void boxes_spice_display_real_connect_it (BoxesDisplay* base,
                                          BoxesDisplayOpenFDFunc open_fd,
                                          gpointer open_fd_target,
                                          GDestroyNotify open_fd_target_destroy_notify,
                                          GError** error);
static void _g_object_unref0_ (gpointer var);
static void boxes_spice_display_on_channel_new (BoxesSpiceDisplay* self,
                                         SpiceSession* session,
                                         SpiceChannel* channel);
static void _boxes_spice_display_on_channel_new_spice_session_channel_new (SpiceSession* _sender,
                                                                    SpiceChannel* channel,
                                                                    gpointer self);
static void boxes_spice_display_on_channel_destroy (BoxesSpiceDisplay* self,
                                             SpiceSession* session,
                                             SpiceChannel* channel);
static void _boxes_spice_display_on_channel_destroy_spice_session_channel_destroy (SpiceSession* _sender,
                                                                            SpiceChannel* channel,
                                                                            gpointer self);
VALA_EXTERN const gchar* boxes_display_get_password (BoxesDisplay* self);
static void boxes_spice_display_real_disconnect_it (BoxesDisplay* base);
VALA_EXTERN BoxesSpiceChannelHandler* boxes_spice_channel_handler_new (BoxesSpiceDisplay* display,
                                                           SpiceChannel* channel,
                                                           BoxesDisplayOpenFDFunc open_fd,
                                                           gpointer open_fd_target);
VALA_EXTERN BoxesSpiceChannelHandler* boxes_spice_channel_handler_construct (GType object_type,
                                                                 BoxesSpiceDisplay* display,
                                                                 SpiceChannel* channel,
                                                                 BoxesDisplayOpenFDFunc open_fd,
                                                                 gpointer open_fd_target);
VALA_EXTERN void boxes_display_access_start (BoxesDisplay* self);
VALA_EXTERN GType boxes_app_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesApp, g_object_unref)
VALA_EXTERN GType boxes_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesCollection, g_object_unref)
VALA_EXTERN GType boxes_shared_folders_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesSharedFoldersManager, g_object_unref)
VALA_EXTERN GListStore* boxes_shared_folders_manager_get_folders (BoxesSharedFoldersManager* self,
                                                      const gchar* machine_uuid);
VALA_EXTERN GType boxes_machine_connect_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void boxes_display_access_finish (BoxesDisplay* self);
static void boxes_spice_display_main_event (BoxesSpiceDisplay* self,
                                     SpiceChannelEvent event);
static void boxes_spice_display_real_transfer_files (BoxesDisplay* base,
                                              GList* uris);
static void _vala_array_add6 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
static void _vala_array_add7 (GFile** * array,
                       gint* length,
                       gint* size,
                       GFile* value);
static void boxes_spice_display_on_new_file_transfer (BoxesSpiceDisplay* self,
                                               SpiceMainChannel* main_channel,
                                               GObject* transfer_task);
VALA_EXTERN GType boxes_display_page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesDisplayPage, g_object_unref)
VALA_EXTERN GType boxes_searchbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesSearchbar, g_object_unref)
VALA_EXTERN GType boxes_topbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesTopbar, g_object_unref)
VALA_EXTERN GType boxes_toast_overlay_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesToastOverlay, g_object_unref)
VALA_EXTERN GType boxes_troubleshoot_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesTroubleshootView, g_object_unref)
VALA_EXTERN void boxes_display_page_add_transfer (BoxesDisplayPage* self,
                                      GObject* transfer_task);
static void boxes_spice_display_real_send_keys (BoxesDisplay* base,
                                         guint* keyvals,
                                         gint keyvals_length1);
static void __vala_SpiceUsbDevice_free0_ (gpointer var);
static gboolean boxes_spice_display_is_usb_kbd_or_mouse (BoxesSpiceDisplay* self,
                                                  guint8 class,
                                                  guint8 subclass,
                                                  guint8 protocol);
VALA_EXTERN GListStore* boxes_spice_display_get_usb_devices_model (BoxesSpiceDisplay* self);
static Block46Data* block46_data_ref (Block46Data* _data46_);
static void block46_data_unref (void * _userdata_);
VALA_EXTERN GType boxes_usb_device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BoxesUsbDevice, g_object_unref)
static Block47Data* block47_data_ref (Block47Data* _data47_);
static void block47_data_unref (void * _userdata_);
VALA_EXTERN BoxesUsbDevice* boxes_usb_device_new (void);
VALA_EXTERN BoxesUsbDevice* boxes_usb_device_construct (GType object_type);
VALA_EXTERN void boxes_usb_device_set_active (BoxesUsbDevice* self,
                                  gboolean value);
static void _____lambda77_ (Block47Data* _data47_);
VALA_EXTERN gboolean boxes_usb_device_get_active (BoxesUsbDevice* self);
static void __lambda78_ (Block47Data* _data47_,
                  GObject* obj,
                  GAsyncResult* res);
static void ___lambda78__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void ______lambda77__g_object_notify (GObject* _sender,
                                      GParamSpec* pspec,
                                      gpointer self);
VALA_EXTERN GByteArray* boxes_spice_display_get_ca_cert (BoxesSpiceDisplay* self);
VALA_EXTERN void boxes_spice_display_set_ca_cert (BoxesSpiceDisplay* self,
                                      GByteArray* value);
static void _boxes_spice_display_main_event_spice_channel_channel_event (SpiceChannel* _sender,
                                                                  SpiceChannelEvent event,
                                                                  gpointer self);
static void _boxes_spice_display_main_channel___lambda72_ (BoxesSpiceDisplay* self);
VALA_EXTERN void boxes_display_set_can_grab_mouse (BoxesDisplay* self,
                                       gboolean value);
static void __boxes_spice_display_main_channel___lambda72__g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self);
static void _boxes_spice_display_on_new_file_transfer_spice_main_channel_new_file_transfer (SpiceMainChannel* _sender,
                                                                                     GObject* task,
                                                                                     gpointer self);
static void _boxes_spice_display_main_channel___lambda73_ (BoxesSpiceDisplay* self);
VALA_EXTERN void boxes_display_set_is_guest_agent_connected (BoxesDisplay* self,
                                                 gboolean value);
static void __boxes_spice_display_main_channel___lambda73__g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self);
static GObject * boxes_spice_display_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties);
static void _boxes_spice_display____lambda79_ (BoxesSpiceDisplay* self,
                                        SpiceUsbDevice* dev,
                                        GError* err);
static void __boxes_spice_display____lambda79__spice_usb_device_manager_device_error (SpiceUsbDeviceManager* _sender,
                                                                               SpiceUsbDevice* device,
                                                                               GError* _error_,
                                                                               gpointer self);
static void boxes_spice_display_finalize (GObject * obj);
static GType boxes_spice_display_get_type_once (void);
static void _vala_boxes_spice_display_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec);
static void _vala_boxes_spice_display_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec);
static void boxes_spice_channel_handler_on_open_fd (BoxesSpiceChannelHandler* self,
                                             SpiceChannel* channel,
                                             gint with_tls);
static void _boxes_spice_channel_handler_on_open_fd_spice_channel_open_fd (SpiceChannel* _sender,
                                                                    gint with_tls,
                                                                    gpointer self);
static void boxes_spice_channel_handler_on_display_ready (BoxesSpiceChannelHandler* self,
                                                   GObject* object,
                                                   GParamSpec* param_spec);
static void _boxes_spice_channel_handler_on_display_ready_g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self);
static void boxes_spice_channel_handler_finalize (GObject * obj);
static GType boxes_spice_channel_handler_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
boxes_spice_display_get_instance_private (BoxesSpiceDisplay* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesSpiceDisplay_private_offset);
}

static void
_vala_BoxesBoxConfigSavedProperty_array_free (BoxesBoxConfigSavedProperty * array,
                                              gssize array_length)
{
	if (array != NULL) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			boxes_box_config_saved_property_destroy (&array[i]);
		}
	}
	g_free (array);
}

static void
boxes_spice_display_ui_state_changed (BoxesSpiceDisplay* self)
{
	BoxesMachine* _tmp0_;
	BoxesUIState _tmp1_;
	BoxesUIState _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->machine;
	_tmp1_ = boxes_ui_get_ui_state ((BoxesUI*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == BOXES_UI_STATE_DISPLAY) {
		SpiceDisplay* display = NULL;
		GtkWidget* _tmp3_;
		SpiceDisplay* _tmp4_;
		SpiceDisplay* _tmp5_;
		_tmp3_ = boxes_display_get_display ((BoxesDisplay*) self, 0);
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, spice_display_get_type ()) ? ((SpiceDisplay*) _tmp3_) : NULL;
		if (_tmp4_ == NULL) {
			_g_object_unref0 (_tmp3_);
		}
		display = _tmp4_;
		_tmp5_ = display;
		g_object_set (_tmp5_, "resize-guest", TRUE, NULL);
		_g_object_unref0 (display);
	}
}

static gchar*
boxes_spice_display_get_box_name (BoxesSpiceDisplay* self)
{
	gchar* _tmp0_ = NULL;
	BoxesBoxConfig* _tmp1_;
	BoxesBoxConfig* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp6_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = boxes_display_get_config ((BoxesDisplay*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = boxes_box_config_get_last_seen_name (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp0_ = _tmp4_;
	if (_tmp0_ == NULL) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (_ ("Unknown"));
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _tmp0_;
	_tmp0_ = NULL;
	result = _tmp6_;
	_g_free0 (_tmp0_);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
boxes_spice_display_main_cleanup (BoxesSpiceDisplay* self)
{
	SpiceMainChannel* _tmp0_;
	SpiceMainChannel* _tmp1_;
	GObject* o = NULL;
	SpiceMainChannel* _tmp2_;
	SpiceMainChannel* _tmp3_;
	GObject* _tmp4_;
	GObject* _tmp5_;
	GObject* _tmp6_;
	GObject* _tmp7_;
	GObject* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = boxes_spice_display_get_main_channel (self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = boxes_spice_display_get_main_channel (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, G_TYPE_OBJECT) ? ((GObject*) _tmp3_) : NULL);
	o = _tmp4_;
	_tmp5_ = o;
	g_signal_handler_disconnect (_tmp5_, self->priv->main_event_id);
	self->priv->main_event_id = (gulong) 0;
	_tmp6_ = o;
	g_signal_handler_disconnect (_tmp6_, self->priv->main_mouse_mode_id);
	self->priv->main_mouse_mode_id = (gulong) 0;
	_tmp7_ = o;
	g_signal_handler_disconnect (_tmp7_, self->priv->new_file_transfer_id);
	self->priv->new_file_transfer_id = (gulong) 0;
	_tmp8_ = o;
	g_signal_handler_disconnect (_tmp8_, self->priv->agent_connected_id);
	self->priv->agent_connected_id = (gulong) 0;
	boxes_spice_display_set_main_channel (self, NULL);
	_g_object_unref0 (o);
}

static void
_boxes_spice_display_ui_state_changed_g_object_notify (GObject* _sender,
                                                       GParamSpec* pspec,
                                                       gpointer self)
{
	boxes_spice_display_ui_state_changed ((BoxesSpiceDisplay*) self);
}

BoxesSpiceDisplay*
boxes_spice_display_construct (GType object_type,
                               BoxesMachine* machine,
                               BoxesBoxConfig* config,
                               const gchar* host,
                               gint port,
                               gint tls_port)
{
	BoxesSpiceDisplay * self = NULL;
	SpiceSession* _tmp0_;
	SpiceSession* _tmp7_;
	const gchar* _tmp8_;
	SpiceGtkSession* _tmp9_;
	BoxesBoxConfigSavedProperty* _tmp10_;
	gint _tmp10__length1;
	g_return_val_if_fail (machine != NULL, NULL);
	g_return_val_if_fail (config != NULL, NULL);
	g_return_val_if_fail (host != NULL, NULL);
	_vala_return_val_if_fail ((port != 0) || (tls_port != 0), "port != 0 || tls_port != 0", NULL);
	self = (BoxesSpiceDisplay*) boxes_display_construct (object_type);
	self->priv->machine = machine;
	g_signal_connect_object ((GObject*) machine, "notify::ui-state", (GCallback) _boxes_spice_display_ui_state_changed_g_object_notify, self, 0);
	boxes_display_set_config ((BoxesDisplay*) self, config);
	_tmp0_ = self->priv->session;
	g_object_set (_tmp0_, "host", host, NULL);
	if (port != 0) {
		SpiceSession* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp1_ = self->priv->session;
		_tmp2_ = g_strdup_printf ("%i", port);
		_tmp3_ = _tmp2_;
		g_object_set (_tmp1_, "port", _tmp3_, NULL);
		_g_free0 (_tmp3_);
	}
	if (tls_port != 0) {
		SpiceSession* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		_tmp4_ = self->priv->session;
		_tmp5_ = g_strdup_printf ("%i", tls_port);
		_tmp6_ = _tmp5_;
		g_object_set (_tmp4_, "tls-port", _tmp6_, NULL);
		_g_free0 (_tmp6_);
	}
	_tmp7_ = self->priv->session;
	_tmp8_ = g_getenv ("BOXES_SPICE_HOST_SUBJECT");
	g_object_set (_tmp7_, "cert-subject", _tmp8_, NULL);
	_tmp9_ = self->priv->gtk_session;
	_tmp10_ = self->priv->gtk_session_saved_properties;
	_tmp10__length1 = self->priv->gtk_session_saved_properties_length1;
	boxes_box_config_save_properties (config, (GObject*) _tmp9_, _tmp10_, (gint) _tmp10__length1);
	return self;
}

BoxesSpiceDisplay*
boxes_spice_display_new (BoxesMachine* machine,
                         BoxesBoxConfig* config,
                         const gchar* host,
                         gint port,
                         gint tls_port)
{
	return boxes_spice_display_construct (BOXES_TYPE_SPICE_DISPLAY, machine, config, host, port, tls_port);
}

BoxesSpiceDisplay*
boxes_spice_display_construct_with_uri (GType object_type,
                                        BoxesMachine* machine,
                                        BoxesBoxConfig* config,
                                        const gchar* uri)
{
	BoxesSpiceDisplay * self = NULL;
	SpiceSession* _tmp0_;
	SpiceGtkSession* _tmp1_;
	BoxesBoxConfigSavedProperty* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (machine != NULL, NULL);
	g_return_val_if_fail (config != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	self = (BoxesSpiceDisplay*) boxes_display_construct (object_type);
	self->priv->machine = machine;
	g_signal_connect_object ((GObject*) machine, "notify::ui-state", (GCallback) _boxes_spice_display_ui_state_changed_g_object_notify, self, 0);
	boxes_display_set_config ((BoxesDisplay*) self, config);
	_tmp0_ = self->priv->session;
	g_object_set (_tmp0_, "uri", uri, NULL);
	_tmp1_ = self->priv->gtk_session;
	_tmp2_ = self->priv->gtk_session_saved_properties;
	_tmp2__length1 = self->priv->gtk_session_saved_properties_length1;
	boxes_box_config_save_properties (config, (GObject*) _tmp1_, _tmp2_, (gint) _tmp2__length1);
	return self;
}

BoxesSpiceDisplay*
boxes_spice_display_new_with_uri (BoxesMachine* machine,
                                  BoxesBoxConfig* config,
                                  const gchar* uri)
{
	return boxes_spice_display_construct_with_uri (BOXES_TYPE_SPICE_DISPLAY, machine, config, uri);
}

BoxesSpiceDisplay*
boxes_spice_display_construct_priv (GType object_type,
                                    BoxesMachine* machine,
                                    BoxesBoxConfig* config)
{
	BoxesSpiceDisplay * self = NULL;
	SpiceGtkSession* _tmp0_;
	BoxesBoxConfigSavedProperty* _tmp1_;
	gint _tmp1__length1;
	g_return_val_if_fail (machine != NULL, NULL);
	g_return_val_if_fail (config != NULL, NULL);
	self = (BoxesSpiceDisplay*) boxes_display_construct (object_type);
	self->priv->machine = machine;
	g_signal_connect_object ((GObject*) machine, "notify::ui-state", (GCallback) _boxes_spice_display_ui_state_changed_g_object_notify, self, 0);
	boxes_display_set_config ((BoxesDisplay*) self, config);
	_tmp0_ = self->priv->gtk_session;
	_tmp1_ = self->priv->gtk_session_saved_properties;
	_tmp1__length1 = self->priv->gtk_session_saved_properties_length1;
	boxes_box_config_save_properties (config, (GObject*) _tmp0_, _tmp1_, (gint) _tmp1__length1);
	return self;
}

BoxesSpiceDisplay*
boxes_spice_display_new_priv (BoxesMachine* machine,
                              BoxesBoxConfig* config)
{
	return boxes_spice_display_construct_priv (BOXES_TYPE_SPICE_DISPLAY, machine, config);
}

static Block44Data*
block44_data_ref (Block44Data* _data44_)
{
	g_atomic_int_inc (&_data44_->_ref_count_);
	return _data44_;
}

static void
block44_data_unref (void * _userdata_)
{
	Block44Data* _data44_;
	_data44_ = (Block44Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data44_->_ref_count_)) {
		BoxesSpiceDisplay* self;
		self = _data44_->self;
		_g_object_unref0 (_data44_->display);
		_g_object_unref0 (self);
		g_slice_free (Block44Data, _data44_);
	}
}

static Block45Data*
block45_data_ref (Block45Data* _data45_)
{
	g_atomic_int_inc (&_data45_->_ref_count_);
	return _data45_;
}

static void
block45_data_unref (void * _userdata_)
{
	Block45Data* _data45_;
	_data45_ = (Block45Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data45_->_ref_count_)) {
		BoxesSpiceDisplay* self;
		self = _data45_->_data44_->self;
		_g_object_unref0 (_data45_->gdk_window);
		block44_data_unref (_data45_->_data44_);
		_data45_->_data44_ = NULL;
		g_slice_free (Block45Data, _data45_);
	}
}

static void
___lambda74_ (BoxesSpiceDisplay* self,
              gint status)
{
	boxes_display_set_mouse_grabbed ((BoxesDisplay*) self, status != 0);
}

static void
____lambda74__spice_display_mouse_grab (SpiceDisplay* _sender,
                                        gint status,
                                        gpointer self)
{
	___lambda74_ ((BoxesSpiceDisplay*) self, status);
}

static void
___lambda75_ (BoxesSpiceDisplay* self,
              gint status)
{
	boxes_display_set_keyboard_grabbed ((BoxesDisplay*) self, status != 0);
}

static void
____lambda75__spice_display_keyboard_grab (SpiceDisplay* _sender,
                                           gint status,
                                           gpointer self)
{
	___lambda75_ ((BoxesSpiceDisplay*) self, status);
}

static gboolean
___lambda76_ (Block45Data* _data45_,
              GdkEventConfigure* event)
{
	Block44Data* _data44_;
	BoxesSpiceDisplay* self;
	GdkWindow* _tmp0_;
	SpiceDisplay* _tmp1_;
	gboolean result;
	_data44_ = _data45_->_data44_;
	self = _data44_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = _data45_->gdk_window;
	_data45_->scale_factor = gdk_window_get_scale_factor (_tmp0_);
	_tmp1_ = _data44_->display;
	g_object_set (_tmp1_, "zoom-level", 100 * _data45_->scale_factor, NULL);
	result = FALSE;
	return result;
}

static gboolean
____lambda76__gtk_widget_configure_event (GtkWidget* _sender,
                                          GdkEventConfigure* event,
                                          gpointer self)
{
	gboolean result;
	result = ___lambda76_ (self, event);
	return result;
}

static GtkWidget*
boxes_spice_display_real_get_display (BoxesDisplay* base,
                                      gint n)
{
	BoxesSpiceDisplay * self;
	Block44Data* _data44_;
	GHashTable* _tmp0_;
	gconstpointer _tmp1_;
	GtkWidget* _tmp2_;
	SpiceDisplay* _tmp3_;
	SpiceDisplay* _tmp4_;
	SpiceDisplay* _tmp26_;
	GtkWidget* _tmp27_;
	GtkWidget* result;
	self = (BoxesSpiceDisplay*) base;
	_data44_ = g_slice_new0 (Block44Data);
	_data44_->_ref_count_ = 1;
	_data44_->self = g_object_ref (self);
	_tmp0_ = ((BoxesDisplay*) self)->displays;
	_tmp1_ = g_hash_table_lookup (_tmp0_, (gpointer) ((gintptr) n));
	_tmp2_ = (GtkWidget*) _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, spice_display_get_type ()) ? ((SpiceDisplay*) _tmp2_) : NULL);
	_data44_->display = _tmp3_;
	_tmp4_ = _data44_->display;
	if (_tmp4_ == NULL) {
		Block45Data* _data45_;
		SpiceSession* _tmp5_;
		SpiceDisplay* _tmp6_;
		SpiceDisplay* _tmp7_;
		SpiceDisplay* _tmp8_;
		BoxesBoxConfig* _tmp9_;
		BoxesBoxConfig* _tmp10_;
		BoxesBoxConfigSavedProperty* _tmp11_;
		gint _tmp11__length1;
		SpiceDisplay* _tmp12_;
		BoxesMachine* _tmp13_;
		BoxesAppWindow* _tmp14_;
		BoxesAppWindow* _tmp15_;
		GdkWindow* _tmp16_;
		GdkWindow* _tmp17_;
		GdkWindow* _tmp18_;
		SpiceDisplay* _tmp19_;
		BoxesMachine* _tmp20_;
		BoxesAppWindow* _tmp21_;
		BoxesAppWindow* _tmp22_;
		GHashTable* _tmp23_;
		SpiceDisplay* _tmp24_;
		GtkWidget* _tmp25_;
		_data45_ = g_slice_new0 (Block45Data);
		_data45_->_ref_count_ = 1;
		_data45_->_data44_ = block44_data_ref (_data44_);
		_tmp5_ = self->priv->session;
		_tmp6_ = spice_display_new (_tmp5_, n);
		g_object_ref_sink (_tmp6_);
		_g_object_unref0 (_data44_->display);
		_data44_->display = _tmp6_;
		_tmp7_ = _data44_->display;
		g_signal_connect_object (_tmp7_, "mouse-grab", (GCallback) ____lambda74__spice_display_mouse_grab, self, 0);
		_tmp8_ = _data44_->display;
		g_signal_connect_object (_tmp8_, "keyboard-grab", (GCallback) ____lambda75__spice_display_keyboard_grab, self, 0);
		_tmp9_ = boxes_display_get_config ((BoxesDisplay*) self);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->display_saved_properties;
		_tmp11__length1 = self->priv->display_saved_properties_length1;
		boxes_box_config_save_properties (_tmp10_, (GObject*) self, _tmp11_, (gint) _tmp11__length1);
		_tmp12_ = _data44_->display;
		g_object_set (_tmp12_, "scaling", TRUE, NULL);
		_tmp13_ = self->priv->machine;
		_tmp14_ = boxes_machine_get_window (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = gtk_widget_get_window ((GtkWidget*) _tmp15_);
		_tmp17_ = _g_object_ref0 (_tmp16_);
		_data45_->gdk_window = _tmp17_;
		_tmp18_ = _data45_->gdk_window;
		_data45_->scale_factor = gdk_window_get_scale_factor (_tmp18_);
		_tmp19_ = _data44_->display;
		g_object_set (_tmp19_, "zoom-level", 100 * _data45_->scale_factor, NULL);
		_tmp20_ = self->priv->machine;
		_tmp21_ = boxes_machine_get_window (_tmp20_);
		_tmp22_ = _tmp21_;
		g_signal_connect_data ((GtkWidget*) _tmp22_, "configure-event", (GCallback) ____lambda76__gtk_widget_configure_event, block45_data_ref (_data45_), (GClosureNotify) block45_data_unref, 0);
		_tmp23_ = ((BoxesDisplay*) self)->displays;
		_tmp24_ = _data44_->display;
		_tmp25_ = _g_object_ref0 ((GtkWidget*) _tmp24_);
		g_hash_table_replace (_tmp23_, (gpointer) ((gintptr) n), _tmp25_);
		block45_data_unref (_data45_);
		_data45_ = NULL;
	}
	_tmp26_ = _data44_->display;
	_tmp27_ = _g_object_ref0 ((GtkWidget*) _tmp26_);
	result = _tmp27_;
	block44_data_unref (_data44_);
	_data44_ = NULL;
	return result;
}

static gint
vala_g_ptr_array_get_length (GPtrArray* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = (gint) self->len;
	return result;
}

static gboolean
boxes_spice_display_real_should_keep_alive (BoxesDisplay* base)
{
	BoxesSpiceDisplay * self;
	gboolean _tmp8_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	self = (BoxesSpiceDisplay*) base;
	{
		SpiceUsbDeviceManager* manager = NULL;
		SpiceSession* _tmp0_;
		SpiceUsbDeviceManager* _tmp1_;
		SpiceUsbDeviceManager* _tmp2_;
		GPtrArray* devs = NULL;
		GPtrArray* _tmp3_;
		gboolean _tmp4_ = FALSE;
		_tmp0_ = self->priv->session;
		_tmp1_ = spice_usb_device_manager_get (_tmp0_, &_inner_error0_);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		manager = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = boxes_spice_display_get_usb_devices (self, manager);
		devs = _tmp3_;
		if (!self->priv->closed) {
			GPtrArray* _tmp5_;
			gint _tmp6_;
			gint _tmp7_;
			_tmp5_ = devs;
			_tmp6_ = vala_g_ptr_array_get_length (_tmp5_);
			_tmp7_ = _tmp6_;
			_tmp4_ = _tmp7_ > 0;
		} else {
			_tmp4_ = FALSE;
		}
		result = _tmp4_;
		_g_ptr_array_unref0 (devs);
		_g_object_unref0 (manager);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp8_;
}

static void
boxes_spice_display_real_set_enable_audio (BoxesDisplay* base,
                                           gboolean enable)
{
	BoxesSpiceDisplay * self;
	SpiceSession* _tmp0_;
	self = (BoxesSpiceDisplay*) base;
	_tmp0_ = self->priv->session;
	g_object_set (_tmp0_, "enable-audio", enable, NULL);
}

static GdkPixbuf*
boxes_spice_display_real_get_pixbuf (BoxesDisplay* base,
                                     gint n,
                                     GError** error)
{
	BoxesSpiceDisplay * self;
	SpiceDisplay* display = NULL;
	GtkWidget* _tmp0_;
	SpiceDisplay* _tmp1_;
	SpiceDisplay* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	BoxesLibvirtMachine* libvirt_machine = NULL;
	BoxesMachine* _tmp5_;
	BoxesLibvirtMachine* _tmp6_;
	BoxesLibvirtMachine* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	SpiceDisplay* _tmp12_;
	GdkPixbuf* _tmp13_;
	GdkPixbuf* result;
	self = (BoxesSpiceDisplay*) base;
	_tmp0_ = boxes_display_get_display ((BoxesDisplay*) self, n);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, spice_display_get_type ()) ? ((SpiceDisplay*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	display = _tmp1_;
	_tmp2_ = display;
	g_object_get (_tmp2_, "ready", &_tmp3_, NULL);
	_tmp4_ = _tmp3_;
	if (!_tmp4_) {
		result = NULL;
		_g_object_unref0 (display);
		return result;
	}
	_tmp5_ = self->priv->machine;
	_tmp6_ = _g_object_ref0 (BOXES_IS_LIBVIRT_MACHINE (_tmp5_) ? ((BoxesLibvirtMachine*) _tmp5_) : NULL);
	libvirt_machine = _tmp6_;
	_tmp7_ = libvirt_machine;
	_tmp8_ = boxes_libvirt_machine_get_acceleration_3d (_tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		SpiceDisplay* _tmp10_;
		GdkPixbuf* _tmp11_;
		_tmp10_ = display;
		_tmp11_ = boxes_spice_display_draw_pixbuf_client_side (self, _tmp10_);
		result = _tmp11_;
		_g_object_unref0 (libvirt_machine);
		_g_object_unref0 (display);
		return result;
	}
	_tmp12_ = display;
	_tmp13_ = spice_display_get_pixbuf (_tmp12_);
	result = _tmp13_;
	_g_object_unref0 (libvirt_machine);
	_g_object_unref0 (display);
	return result;
}

static GdkPixbuf*
boxes_spice_display_draw_pixbuf_client_side (BoxesSpiceDisplay* self,
                                             SpiceDisplay* display)
{
	GtkAllocation alloc = {0};
	GtkWidget* widget = NULL;
	GtkWidget* _tmp0_;
	GtkAllocation _tmp1_ = {0};
	cairo_surface_t* surface = NULL;
	GtkAllocation _tmp2_;
	GtkAllocation _tmp3_;
	cairo_surface_t* _tmp4_;
	cairo_t* context = NULL;
	cairo_t* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GtkAllocation _tmp7_;
	GtkAllocation _tmp8_;
	GdkPixbuf* _tmp9_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (display != NULL, NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (display, gtk_widget_get_type ()) ? ((GtkWidget*) display) : NULL);
	widget = _tmp0_;
	gtk_widget_get_allocation (widget, &_tmp1_);
	alloc = _tmp1_;
	_tmp2_ = alloc;
	_tmp3_ = alloc;
	_tmp4_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp2_.width, _tmp3_.height);
	surface = _tmp4_;
	_tmp5_ = cairo_create (surface);
	context = _tmp5_;
	g_signal_emit_by_name (widget, "draw", context, &_tmp6_);
	_tmp7_ = alloc;
	_tmp8_ = alloc;
	_tmp9_ = gdk_pixbuf_get_from_surface (surface, 0, 0, _tmp7_.width, _tmp8_.height);
	result = _tmp9_;
	_cairo_destroy0 (context);
	_cairo_surface_destroy0 (surface);
	_g_object_unref0 (widget);
	return result;
}

static SpiceUsbDevice*
_vala_SpiceUsbDevice_copy (SpiceUsbDevice* self)
{
	return g_boxed_copy (spice_usb_device_get_type (), self);
}

static gpointer
__vala_SpiceUsbDevice_copy0 (gpointer self)
{
	return self ? _vala_SpiceUsbDevice_copy (self) : NULL;
}

static void
_vala_SpiceUsbDevice_free (SpiceUsbDevice* self)
{
	g_boxed_free (spice_usb_device_get_type (), self);
}

static void
boxes_spice_display_real_collect_logs (BoxesDisplay* base,
                                       GString* builder)
{
	BoxesSpiceDisplay * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	SpiceGtkSession* _tmp3_;
	SpiceMainChannel* _tmp8_;
	SpiceMainChannel* _tmp9_;
	GError* _inner_error0_ = NULL;
	self = (BoxesSpiceDisplay*) base;
	g_return_if_fail (builder != NULL);
	_tmp0_ = boxes_display_get_uri ((BoxesDisplay*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	g_string_append_printf (builder, "URL: %s\n", _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->gtk_session;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_ = NULL;
		SpiceGtkSession* _tmp5_;
		gboolean _tmp6_;
		gboolean _tmp7_;
		_tmp5_ = self->priv->gtk_session;
		g_object_get (_tmp5_, "auto-clipboard", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		if (_tmp7_) {
			_tmp4_ = "yes";
		} else {
			_tmp4_ = "no";
		}
		g_string_append_printf (builder, "Auto clipboard sync: %s\n", _tmp4_);
	}
	_tmp8_ = boxes_spice_display_get_main_channel (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_ != NULL) {
		const gchar* _tmp10_;
		const gchar* _tmp11_ = NULL;
		SpiceMainChannel* _tmp12_;
		SpiceMainChannel* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		const gchar* _tmp16_ = NULL;
		SpiceMainChannel* _tmp17_;
		SpiceMainChannel* _tmp18_;
		gboolean _tmp19_;
		gboolean _tmp20_;
		_tmp10_ = spice_util_get_version_string ();
		g_string_append_printf (builder, "Spice-gtk version %s\n", _tmp10_);
		_tmp12_ = boxes_spice_display_get_main_channel (self);
		_tmp13_ = _tmp12_;
		g_object_get (_tmp13_, "mouse-mode", &_tmp14_, NULL);
		_tmp15_ = _tmp14_;
		if (_tmp15_ == 1) {
			_tmp11_ = "server";
		} else {
			_tmp11_ = "client";
		}
		g_string_append_printf (builder, "Mouse mode: %s\n", _tmp11_);
		_tmp17_ = boxes_spice_display_get_main_channel (self);
		_tmp18_ = _tmp17_;
		g_object_get (_tmp18_, "agent-connected", &_tmp19_, NULL);
		_tmp20_ = _tmp19_;
		if (_tmp20_) {
			_tmp16_ = "connected";
		} else {
			_tmp16_ = "disconnected";
		}
		g_string_append_printf (builder, "Agent: %s\n", _tmp16_);
	}
	{
		SpiceUsbDeviceManager* manager = NULL;
		SpiceSession* _tmp21_;
		SpiceUsbDeviceManager* _tmp22_;
		SpiceUsbDeviceManager* _tmp23_;
		GPtrArray* devs = NULL;
		SpiceUsbDeviceManager* _tmp24_;
		GPtrArray* _tmp25_;
		_tmp21_ = self->priv->session;
		_tmp22_ = spice_usb_device_manager_get (_tmp21_, &_inner_error0_);
		_tmp23_ = _g_object_ref0 (_tmp22_);
		manager = _tmp23_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp24_ = manager;
		_tmp25_ = spice_usb_device_manager_get_devices (_tmp24_);
		devs = _tmp25_;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp26_ = FALSE;
				_tmp26_ = TRUE;
				while (TRUE) {
					GPtrArray* _tmp28_;
					gint _tmp29_;
					gint _tmp30_;
					SpiceUsbDevice* dev = NULL;
					GPtrArray* _tmp31_;
					gconstpointer _tmp32_;
					SpiceUsbDevice* _tmp33_;
					SpiceUsbDeviceManager* _tmp34_;
					SpiceUsbDevice* _tmp35_;
					if (!_tmp26_) {
						gint _tmp27_;
						_tmp27_ = i;
						i = _tmp27_ + 1;
					}
					_tmp26_ = FALSE;
					_tmp28_ = devs;
					_tmp29_ = vala_g_ptr_array_get_length (_tmp28_);
					_tmp30_ = _tmp29_;
					if (!(i < _tmp30_)) {
						break;
					}
					_tmp31_ = devs;
					_tmp32_ = g_ptr_array_index (_tmp31_, (guint) i);
					_tmp33_ = __vala_SpiceUsbDevice_copy0 ((SpiceUsbDevice*) _tmp32_);
					dev = _tmp33_;
					_tmp34_ = manager;
					_tmp35_ = dev;
					if (spice_usb_device_manager_is_device_connected (_tmp34_, _tmp35_)) {
						SpiceUsbDevice* _tmp36_;
						gchar* _tmp37_;
						gchar* _tmp38_;
						_tmp36_ = dev;
						_tmp37_ = spice_usb_device_get_description (_tmp36_, "%s %s %s at %d-%d");
						_tmp38_ = _tmp37_;
						g_string_append_printf (builder, "USB device redirected: %s\n", _tmp38_);
						_g_free0 (_tmp38_);
					}
					__vala_SpiceUsbDevice_free0 (dev);
				}
			}
		}
		_g_ptr_array_unref0 (devs);
		_g_object_unref0 (manager);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_boxes_spice_display_on_channel_new_spice_session_channel_new (SpiceSession* _sender,
                                                               SpiceChannel* channel,
                                                               gpointer self)
{
	boxes_spice_display_on_channel_new ((BoxesSpiceDisplay*) self, _sender, channel);
}

static void
_boxes_spice_display_on_channel_destroy_spice_session_channel_destroy (SpiceSession* _sender,
                                                                       SpiceChannel* channel,
                                                                       gpointer self)
{
	boxes_spice_display_on_channel_destroy ((BoxesSpiceDisplay*) self, _sender, channel);
}

static void
boxes_spice_display_real_connect_it (BoxesDisplay* base,
                                     BoxesDisplayOpenFDFunc open_fd,
                                     gpointer open_fd_target,
                                     GDestroyNotify open_fd_target_destroy_notify,
                                     GError** error)
{
	BoxesSpiceDisplay * self;
	BoxesDisplayOpenFDFunc _tmp0_;
	gpointer _tmp0__target;
	GDestroyNotify _tmp0__target_destroy_notify;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	SpiceSession* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	BoxesDisplayOpenFDFunc _tmp11_;
	gpointer _tmp11__target;
	self = (BoxesSpiceDisplay*) base;
	if (((BoxesDisplay*) self)->connected) {
		(open_fd_target_destroy_notify == NULL) ? NULL : (open_fd_target_destroy_notify (open_fd_target), NULL);
		open_fd = NULL;
		open_fd_target = NULL;
		open_fd_target_destroy_notify = NULL;
		return;
	}
	((BoxesDisplay*) self)->connected = TRUE;
	_tmp0_ = open_fd;
	_tmp0__target = open_fd_target;
	_tmp0__target_destroy_notify = open_fd_target_destroy_notify;
	open_fd = NULL;
	open_fd_target = NULL;
	open_fd_target_destroy_notify = NULL;
	(self->priv->open_fd_target_destroy_notify == NULL) ? NULL : (self->priv->open_fd_target_destroy_notify (self->priv->open_fd_target), NULL);
	self->priv->open_fd = NULL;
	self->priv->open_fd_target = NULL;
	self->priv->open_fd_target_destroy_notify = NULL;
	self->priv->open_fd = _tmp0_;
	self->priv->open_fd_target = _tmp0__target;
	self->priv->open_fd_target_destroy_notify = _tmp0__target_destroy_notify;
	boxes_spice_display_main_cleanup (self);
	_tmp1_ = g_direct_hash;
	_tmp2_ = g_direct_equal;
	_tmp3_ = g_hash_table_new_full (_tmp1_, _tmp2_, _g_object_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->channel_handlers);
	self->priv->channel_handlers = _tmp3_;
	if (self->priv->channel_new_id == ((gulong) 0)) {
		SpiceSession* _tmp4_;
		gulong _tmp5_;
		_tmp4_ = self->priv->session;
		_tmp5_ = g_signal_connect_object (_tmp4_, "channel-new", (GCallback) _boxes_spice_display_on_channel_new_spice_session_channel_new, self, 0);
		self->priv->channel_new_id = _tmp5_;
	}
	if (self->priv->channel_destroy_id == ((gulong) 0)) {
		SpiceSession* _tmp6_;
		gulong _tmp7_;
		_tmp6_ = self->priv->session;
		_tmp7_ = g_signal_connect_object (_tmp6_, "channel-destroy", (GCallback) _boxes_spice_display_on_channel_destroy_spice_session_channel_destroy, self, 0);
		self->priv->channel_destroy_id = _tmp7_;
	}
	_tmp8_ = self->priv->session;
	_tmp9_ = boxes_display_get_password ((BoxesDisplay*) self);
	_tmp10_ = _tmp9_;
	g_object_set (_tmp8_, "password", _tmp10_, NULL);
	_tmp11_ = self->priv->open_fd;
	_tmp11__target = self->priv->open_fd_target;
	if (_tmp11_ != NULL) {
		SpiceSession* _tmp12_;
		_tmp12_ = self->priv->session;
		spice_session_open_fd (_tmp12_, -1);
	} else {
		SpiceSession* _tmp13_;
		_tmp13_ = self->priv->session;
		spice_session_connect (_tmp13_);
	}
	(open_fd_target_destroy_notify == NULL) ? NULL : (open_fd_target_destroy_notify (open_fd_target), NULL);
	open_fd = NULL;
	open_fd_target = NULL;
	open_fd_target_destroy_notify = NULL;
}

static void
boxes_spice_display_real_disconnect_it (BoxesDisplay* base)
{
	BoxesSpiceDisplay * self;
	GObject* session_object = NULL;
	SpiceSession* _tmp0_;
	GObject* _tmp1_;
	SpiceSession* _tmp4_;
	GHashTable* _tmp5_;
	self = (BoxesSpiceDisplay*) base;
	_tmp0_ = self->priv->session;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, G_TYPE_OBJECT) ? ((GObject*) _tmp0_) : NULL);
	session_object = _tmp1_;
	if (self->priv->channel_new_id > ((gulong) 0)) {
		GObject* _tmp2_;
		_tmp2_ = session_object;
		g_signal_handler_disconnect (_tmp2_, self->priv->channel_new_id);
		self->priv->channel_new_id = (gulong) 0;
	}
	if (self->priv->channel_destroy_id > ((gulong) 0)) {
		GObject* _tmp3_;
		_tmp3_ = session_object;
		g_signal_handler_disconnect (_tmp3_, self->priv->channel_destroy_id);
		self->priv->channel_destroy_id = (gulong) 0;
	}
	_tmp4_ = self->priv->session;
	spice_session_disconnect (_tmp4_);
	boxes_spice_display_main_cleanup (self);
	_g_hash_table_unref0 (self->priv->channel_handlers);
	self->priv->channel_handlers = NULL;
	(self->priv->open_fd_target_destroy_notify == NULL) ? NULL : (self->priv->open_fd_target_destroy_notify (self->priv->open_fd_target), NULL);
	self->priv->open_fd = NULL;
	self->priv->open_fd_target = NULL;
	self->priv->open_fd_target_destroy_notify = NULL;
	self->priv->open_fd = NULL;
	self->priv->open_fd_target = NULL;
	self->priv->open_fd_target_destroy_notify = NULL;
	_tmp5_ = ((BoxesDisplay*) self)->displays;
	g_hash_table_remove_all (_tmp5_);
	_g_object_unref0 (session_object);
}

static void
boxes_spice_display_on_channel_new (BoxesSpiceDisplay* self,
                                    SpiceSession* session,
                                    SpiceChannel* channel)
{
	BoxesSpiceChannelHandler* handler = NULL;
	BoxesDisplayOpenFDFunc _tmp0_;
	gpointer _tmp0__target;
	BoxesSpiceChannelHandler* _tmp1_;
	GHashTable* _tmp2_;
	SpiceChannel* _tmp3_;
	BoxesSpiceChannelHandler* _tmp4_;
	BoxesSpiceChannelHandler* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (session != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = self->priv->open_fd;
	_tmp0__target = self->priv->open_fd_target;
	_tmp1_ = boxes_spice_channel_handler_new (self, channel, _tmp0_, _tmp0__target);
	handler = _tmp1_;
	_tmp2_ = self->priv->channel_handlers;
	_tmp3_ = _g_object_ref0 (channel);
	_tmp4_ = handler;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	g_hash_table_insert (_tmp2_, _tmp3_, _tmp5_);
	if (G_TYPE_CHECK_INSTANCE_TYPE (channel, spice_display_channel_get_type ())) {
		gint _tmp6_;
		gint _tmp7_;
		g_object_get (channel, "channel-id", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		if (_tmp7_ != 0) {
			_g_object_unref0 (handler);
			return;
		}
		boxes_display_access_start ((BoxesDisplay*) self);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (channel, spice_webdav_channel_get_type ())) {
		SpicePortChannel* _tmp8_;
		BoxesApp* _tmp9_;
		BoxesSharedFoldersManager* _tmp10_;
		BoxesMachine* _tmp11_;
		BoxesBoxConfig* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		GListStore* _tmp16_;
		GListStore* _tmp17_;
		BoxesMachine* _tmp18_;
		BoxesBoxConfig* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (channel, spice_port_channel_get_type ()) ? ((SpicePortChannel*) channel) : NULL);
		_g_object_unref0 (self->priv->webdav_channel);
		self->priv->webdav_channel = _tmp8_;
		_tmp9_ = boxes_app_app;
		_tmp10_ = _tmp9_->shared_folders_manager;
		_tmp11_ = self->priv->machine;
		_tmp12_ = _tmp11_->config;
		_tmp13_ = boxes_box_config_get_uuid (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = _tmp14_;
		_tmp16_ = boxes_shared_folders_manager_get_folders (_tmp10_, _tmp15_);
		_tmp17_ = _tmp16_;
		_g_object_unref0 (_tmp17_);
		_g_free0 (_tmp15_);
		_tmp18_ = self->priv->machine;
		_tmp19_ = _tmp18_->config;
		_tmp20_ = boxes_box_config_get_uuid (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp22_ = _tmp21_;
		_tmp23_ = boxes_get_user_pkgconfig (_tmp22_);
		_tmp24_ = _tmp23_;
		g_object_set (session, "shared-dir", _tmp24_, NULL);
		_g_free0 (_tmp24_);
		_g_free0 (_tmp22_);
	}
	_g_object_unref0 (handler);
}

static void
boxes_spice_display_on_channel_destroy (BoxesSpiceDisplay* self,
                                        SpiceSession* session,
                                        SpiceChannel* channel)
{
	SpiceDisplayChannel* display = NULL;
	SpiceDisplayChannel* _tmp0_;
	SpiceDisplayChannel* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (session != NULL);
	g_return_if_fail (channel != NULL);
	if (!G_TYPE_CHECK_INSTANCE_TYPE (channel, spice_display_channel_get_type ())) {
		return;
	}
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (channel, spice_display_channel_get_type ()) ? ((SpiceDisplayChannel*) channel) : NULL);
	display = _tmp0_;
	_tmp1_ = display;
	g_object_get ((SpiceChannel*) _tmp1_, "channel-id", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	g_signal_emit_by_name ((BoxesDisplay*) self, "hide", _tmp3_);
	boxes_display_access_finish ((BoxesDisplay*) self);
	_g_object_unref0 (display);
}

static void
boxes_spice_display_main_event (BoxesSpiceDisplay* self,
                                SpiceChannelEvent event)
{
	g_return_if_fail (self != NULL);
	switch (event) {
		case SPICE_CHANNEL_CLOSED:
		{
			self->priv->closed = TRUE;
			g_signal_emit_by_name ((BoxesDisplay*) self, "disconnected", FALSE);
			break;
		}
		case SPICE_CHANNEL_ERROR_AUTH:
		{
			break;
		}
		case SPICE_CHANNEL_ERROR_CONNECT:
		case SPICE_CHANNEL_ERROR_TLS:
		case SPICE_CHANNEL_ERROR_LINK:
		case SPICE_CHANNEL_ERROR_IO:
		{
			g_debug ("spice-display.vala:337: main SPICE channel error: %d", (gint) event);
			self->priv->closed = TRUE;
			g_signal_emit_by_name ((BoxesDisplay*) self, "disconnected", TRUE);
			break;
		}
		case SPICE_CHANNEL_OPENED:
		{
			break;
		}
		default:
		{
			g_debug ("spice-display.vala:346: unhandled main SPICE channel event: %d", (gint) event);
			break;
		}
	}
}

static void
_vala_array_add6 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add7 (GFile** * array,
                  gint* length,
                  gint* size,
                  GFile* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GFile*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
boxes_spice_display_real_transfer_files (BoxesDisplay* base,
                                         GList* uris)
{
	BoxesSpiceDisplay * self;
	GFile** files = NULL;
	GFile** _tmp0_;
	gint files_length1;
	gint _files_size_;
	SpiceMainChannel* _tmp6_;
	SpiceMainChannel* _tmp7_;
	GFile** _tmp8_;
	gint _tmp8__length1;
	self = (BoxesSpiceDisplay*) base;
	_tmp0_ = g_new0 (GFile*, 0 + 1);
	files = _tmp0_;
	files_length1 = 0;
	_files_size_ = files_length1;
	{
		GList* uri_collection = NULL;
		GList* uri_it = NULL;
		uri_collection = uris;
		for (uri_it = uri_collection; uri_it != NULL; uri_it = uri_it->next) {
			gchar* _tmp1_;
			gchar* uri = NULL;
			_tmp1_ = g_strdup ((const gchar*) uri_it->data);
			uri = _tmp1_;
			{
				GFile* file = NULL;
				const gchar* _tmp2_;
				GFile* _tmp3_;
				GFile* _tmp4_;
				GFile* _tmp5_;
				_tmp2_ = uri;
				_tmp3_ = g_file_new_for_uri (_tmp2_);
				file = _tmp3_;
				_tmp4_ = file;
				_tmp5_ = _g_object_ref0 (_tmp4_);
				_vala_array_add6 (&files, &files_length1, &_files_size_, _tmp5_);
				_g_object_unref0 (file);
				_g_free0 (uri);
			}
		}
	}
	_vala_array_add7 (&files, &files_length1, &_files_size_, NULL);
	_tmp6_ = boxes_spice_display_get_main_channel (self);
	_tmp7_ = _tmp6_;
	_tmp8_ = files;
	_tmp8__length1 = files_length1;
	spice_main_channel_file_copy_async (_tmp7_, _tmp8_, G_FILE_COPY_NONE, NULL, NULL, NULL, NULL, NULL);
	files = (_vala_array_free (files, files_length1, (GDestroyNotify) g_object_unref), NULL);
}

static void
boxes_spice_display_on_new_file_transfer (BoxesSpiceDisplay* self,
                                          SpiceMainChannel* main_channel,
                                          GObject* transfer_task)
{
	BoxesDisplayPage* page = NULL;
	BoxesMachine* _tmp0_;
	BoxesAppWindow* _tmp1_;
	BoxesAppWindow* _tmp2_;
	BoxesDisplayPage* _tmp3_;
	BoxesDisplayPage* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (main_channel != NULL);
	g_return_if_fail (transfer_task != NULL);
	_tmp0_ = self->priv->machine;
	_tmp1_ = boxes_machine_get_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->display_page;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	page = _tmp4_;
	boxes_display_page_add_transfer (page, transfer_task);
	_g_object_unref0 (page);
}

static void
boxes_spice_display_real_send_keys (BoxesDisplay* base,
                                    guint* keyvals,
                                    gint keyvals_length1)
{
	BoxesSpiceDisplay * self;
	SpiceDisplay* display = NULL;
	GtkWidget* _tmp0_;
	SpiceDisplay* _tmp1_;
	self = (BoxesSpiceDisplay*) base;
	_tmp0_ = boxes_display_get_display ((BoxesDisplay*) self, 0);
	_tmp1_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, spice_display_get_type ()) ? ((SpiceDisplay*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (_tmp0_);
	}
	display = _tmp1_;
	spice_display_send_keys (display, keyvals, (gint) keyvals_length1, SPICE_DISPLAY_KEY_EVENT_CLICK);
	_g_object_unref0 (display);
}

static void
__vala_SpiceUsbDevice_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_SpiceUsbDevice_free (var), NULL));
}

static gpointer
_libusb_ref_device0 (gpointer self)
{
	return self ? libusb_ref_device (self) : NULL;
}

static GPtrArray*
boxes_spice_display_get_usb_devices (BoxesSpiceDisplay* self,
                                     SpiceUsbDeviceManager* manager)
{
	GPtrArray* ret = NULL;
	GPtrArray* _tmp0_;
	GPtrArray* devs = NULL;
	GPtrArray* _tmp1_;
	const gchar* _tmp2_;
	GPtrArray* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (manager != NULL, NULL);
	_tmp0_ = g_ptr_array_new_full ((guint) 0, __vala_SpiceUsbDevice_free0_);
	ret = _tmp0_;
	_tmp1_ = spice_usb_device_manager_get_devices (manager);
	devs = _tmp1_;
	_tmp2_ = g_getenv ("BOXES_USB_REDIR_ALL");
	if (_tmp2_ != NULL) {
		result = devs;
		_g_ptr_array_unref0 (ret);
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GPtrArray* _tmp5_;
				gint _tmp6_;
				gint _tmp7_;
				SpiceUsbDevice* dev = NULL;
				GPtrArray* _tmp8_;
				gconstpointer _tmp9_;
				SpiceUsbDevice* _tmp10_;
				libusb_device* libusb_dev = NULL;
				SpiceUsbDevice* _tmp11_;
				void* _tmp12_;
				libusb_device* _tmp13_;
				struct libusb_device_descriptor desc = {0};
				libusb_device* _tmp14_;
				struct libusb_device_descriptor _tmp15_ = {0};
				enum libusb_error _tmp16_;
				struct libusb_device_descriptor _tmp17_;
				struct libusb_device_descriptor _tmp18_;
				struct libusb_device_descriptor _tmp19_;
				struct libusb_device_descriptor _tmp20_;
				GPtrArray* _tmp51_;
				SpiceUsbDevice* _tmp52_;
				SpiceUsbDevice* _tmp53_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = devs;
				_tmp6_ = vala_g_ptr_array_get_length (_tmp5_);
				_tmp7_ = _tmp6_;
				if (!(i < _tmp7_)) {
					break;
				}
				_tmp8_ = devs;
				_tmp9_ = g_ptr_array_index (_tmp8_, (guint) i);
				_tmp10_ = __vala_SpiceUsbDevice_copy0 ((SpiceUsbDevice*) _tmp9_);
				dev = _tmp10_;
				_tmp11_ = dev;
				_tmp12_ = spice_usb_device_get_libusb_device (_tmp11_);
				_tmp13_ = _libusb_ref_device0 ((libusb_device*) _tmp12_);
				libusb_dev = _tmp13_;
				_tmp14_ = libusb_dev;
				_tmp16_ = libusb_get_device_descriptor (_tmp14_, &_tmp15_);
				desc = _tmp15_;
				if (_tmp16_ != 0) {
					_libusb_unref_device0 (libusb_dev);
					__vala_SpiceUsbDevice_free0 (dev);
					continue;
				}
				_tmp17_ = desc;
				_tmp18_ = desc;
				_tmp19_ = desc;
				if (boxes_spice_display_is_usb_kbd_or_mouse (self, _tmp17_.bDeviceClass, _tmp18_.bDeviceSubClass, _tmp19_.bDeviceProtocol)) {
					_libusb_unref_device0 (libusb_dev);
					__vala_SpiceUsbDevice_free0 (dev);
					continue;
				}
				_tmp20_ = desc;
				if (_tmp20_.bDeviceClass == LIBUSB_CLASS_PER_INTERFACE) {
					struct libusb_config_descriptor* config = NULL;
					libusb_device* _tmp21_;
					struct libusb_config_descriptor* _tmp22_ = NULL;
					enum libusb_error _tmp23_;
					gboolean kbd_or_mouse = FALSE;
					_tmp21_ = libusb_dev;
					_tmp23_ = libusb_get_active_config_descriptor (_tmp21_, &_tmp22_);
					_libusb_free_config_descriptor0 (config);
					config = _tmp22_;
					if (_tmp23_ != 0) {
						_libusb_free_config_descriptor0 (config);
						_libusb_unref_device0 (libusb_dev);
						__vala_SpiceUsbDevice_free0 (dev);
						continue;
					}
					kbd_or_mouse = FALSE;
					{
						gint j = 0;
						j = 0;
						{
							gboolean _tmp24_ = FALSE;
							_tmp24_ = TRUE;
							while (TRUE) {
								gboolean _tmp26_ = FALSE;
								struct libusb_config_descriptor* _tmp27_;
								struct libusb_interface* _tmp28_;
								gint _tmp28__length1;
								if (!_tmp24_) {
									gint _tmp25_;
									_tmp25_ = j;
									j = _tmp25_ + 1;
								}
								_tmp24_ = FALSE;
								_tmp27_ = config;
								_tmp28_ = _tmp27_->interface;
								_tmp28__length1 = _tmp27_->bNumInterfaces;
								if (j < _tmp28__length1) {
									_tmp26_ = !kbd_or_mouse;
								} else {
									_tmp26_ = FALSE;
								}
								if (!_tmp26_) {
									break;
								}
								{
									gint k = 0;
									k = 0;
									{
										gboolean _tmp29_ = FALSE;
										_tmp29_ = TRUE;
										while (TRUE) {
											gboolean _tmp31_ = FALSE;
											struct libusb_config_descriptor* _tmp32_;
											struct libusb_interface* _tmp33_;
											gint _tmp33__length1;
											struct libusb_interface _tmp34_;
											struct libusb_interface_descriptor* _tmp35_;
											gint _tmp35__length1;
											guint8 class = 0U;
											struct libusb_config_descriptor* _tmp36_;
											struct libusb_interface* _tmp37_;
											gint _tmp37__length1;
											struct libusb_interface _tmp38_;
											struct libusb_interface_descriptor* _tmp39_;
											gint _tmp39__length1;
											struct libusb_interface_descriptor _tmp40_;
											guint8 subclass = 0U;
											struct libusb_config_descriptor* _tmp41_;
											struct libusb_interface* _tmp42_;
											gint _tmp42__length1;
											struct libusb_interface _tmp43_;
											struct libusb_interface_descriptor* _tmp44_;
											gint _tmp44__length1;
											struct libusb_interface_descriptor _tmp45_;
											guint8 protocol = 0U;
											struct libusb_config_descriptor* _tmp46_;
											struct libusb_interface* _tmp47_;
											gint _tmp47__length1;
											struct libusb_interface _tmp48_;
											struct libusb_interface_descriptor* _tmp49_;
											gint _tmp49__length1;
											struct libusb_interface_descriptor _tmp50_;
											if (!_tmp29_) {
												gint _tmp30_;
												_tmp30_ = k;
												k = _tmp30_ + 1;
											}
											_tmp29_ = FALSE;
											_tmp32_ = config;
											_tmp33_ = _tmp32_->interface;
											_tmp33__length1 = _tmp32_->bNumInterfaces;
											_tmp34_ = _tmp33_[j];
											_tmp35_ = _tmp34_.altsetting;
											_tmp35__length1 = _tmp34_.num_altsetting;
											if (k < _tmp35__length1) {
												_tmp31_ = !kbd_or_mouse;
											} else {
												_tmp31_ = FALSE;
											}
											if (!_tmp31_) {
												break;
											}
											_tmp36_ = config;
											_tmp37_ = _tmp36_->interface;
											_tmp37__length1 = _tmp36_->bNumInterfaces;
											_tmp38_ = _tmp37_[j];
											_tmp39_ = _tmp38_.altsetting;
											_tmp39__length1 = _tmp38_.num_altsetting;
											_tmp40_ = _tmp39_[k];
											class = _tmp40_.bInterfaceClass;
											_tmp41_ = config;
											_tmp42_ = _tmp41_->interface;
											_tmp42__length1 = _tmp41_->bNumInterfaces;
											_tmp43_ = _tmp42_[j];
											_tmp44_ = _tmp43_.altsetting;
											_tmp44__length1 = _tmp43_.num_altsetting;
											_tmp45_ = _tmp44_[k];
											subclass = _tmp45_.bInterfaceSubClass;
											_tmp46_ = config;
											_tmp47_ = _tmp46_->interface;
											_tmp47__length1 = _tmp46_->bNumInterfaces;
											_tmp48_ = _tmp47_[j];
											_tmp49_ = _tmp48_.altsetting;
											_tmp49__length1 = _tmp48_.num_altsetting;
											_tmp50_ = _tmp49_[k];
											protocol = _tmp50_.bInterfaceProtocol;
											kbd_or_mouse = boxes_spice_display_is_usb_kbd_or_mouse (self, class, subclass, protocol);
										}
									}
								}
							}
						}
					}
					if (kbd_or_mouse) {
						_libusb_free_config_descriptor0 (config);
						_libusb_unref_device0 (libusb_dev);
						__vala_SpiceUsbDevice_free0 (dev);
						continue;
					}
					_libusb_free_config_descriptor0 (config);
				}
				_tmp51_ = ret;
				_tmp52_ = dev;
				_tmp53_ = __vala_SpiceUsbDevice_copy0 (_tmp52_);
				g_ptr_array_add (_tmp51_, _tmp53_);
				_libusb_unref_device0 (libusb_dev);
				__vala_SpiceUsbDevice_free0 (dev);
			}
		}
	}
	result = ret;
	_g_ptr_array_unref0 (devs);
	return result;
}

static Block46Data*
block46_data_ref (Block46Data* _data46_)
{
	g_atomic_int_inc (&_data46_->_ref_count_);
	return _data46_;
}

static void
block46_data_unref (void * _userdata_)
{
	Block46Data* _data46_;
	_data46_ = (Block46Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data46_->_ref_count_)) {
		BoxesSpiceDisplay* self;
		self = _data46_->self;
		_g_object_unref0 (_data46_->manager);
		_g_object_unref0 (self);
		g_slice_free (Block46Data, _data46_);
	}
}

static Block47Data*
block47_data_ref (Block47Data* _data47_)
{
	g_atomic_int_inc (&_data47_->_ref_count_);
	return _data47_;
}

static void
block47_data_unref (void * _userdata_)
{
	Block47Data* _data47_;
	_data47_ = (Block47Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data47_->_ref_count_)) {
		BoxesSpiceDisplay* self;
		self = _data47_->_data46_->self;
		_g_object_unref0 (_data47_->usb_device);
		__vala_SpiceUsbDevice_free0 (_data47_->dev);
		block46_data_unref (_data47_->_data46_);
		_data47_->_data46_ = NULL;
		g_slice_free (Block47Data, _data47_);
	}
}

static void
__lambda78_ (Block47Data* _data47_,
             GObject* obj,
             GAsyncResult* res)
{
	Block46Data* _data46_;
	BoxesSpiceDisplay* self;
	GError* _inner_error0_ = NULL;
	_data46_ = _data47_->_data46_;
	self = _data46_->self;
	g_return_if_fail (res != NULL);
	{
		SpiceUsbDeviceManager* _tmp0_;
		_tmp0_ = _data46_->manager;
		spice_usb_device_manager_connect_device_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		BoxesUsbDevice* _tmp1_;
		gchar* device_desc = NULL;
		SpiceUsbDevice* _tmp2_;
		gchar* _tmp3_;
		gchar* box_name = NULL;
		gchar* _tmp4_;
		gchar* msg = NULL;
		gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		GError* _tmp13_;
		const gchar* _tmp14_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = _data47_->usb_device;
		boxes_usb_device_set_active (_tmp1_, FALSE);
		_tmp2_ = _data47_->dev;
		_tmp3_ = spice_usb_device_get_description (_tmp2_, "%1$s %2$s");
		device_desc = _tmp3_;
		_tmp4_ = boxes_spice_display_get_box_name (self);
		box_name = _tmp4_;
		_tmp5_ = g_strdup (_ ("Redirection of USB device “%s” for “%s” failed"));
		msg = _tmp5_;
		_tmp6_ = msg;
		_tmp7_ = device_desc;
		_tmp8_ = box_name;
		_tmp9_ = g_strdup_printf (_tmp6_, _tmp7_, _tmp8_);
		_tmp10_ = _tmp9_;
		g_signal_emit_by_name ((BoxesDisplay*) self, "got-error", _tmp10_);
		_g_free0 (_tmp10_);
		_tmp11_ = device_desc;
		_tmp12_ = box_name;
		_tmp13_ = err;
		_tmp14_ = _tmp13_->message;
		g_debug ("spice-display.vala:459: Error connecting %s to %s: %s", _tmp11_, _tmp12_, _tmp14_);
		_g_free0 (msg);
		_g_free0 (box_name);
		_g_free0 (device_desc);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda78__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda78_ (self, source_object, res);
	block47_data_unref (self);
}

static void
_____lambda77_ (Block47Data* _data47_)
{
	Block46Data* _data46_;
	BoxesSpiceDisplay* self;
	BoxesUsbDevice* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	SpiceUsbDeviceManager* _tmp5_;
	SpiceUsbDevice* _tmp6_;
	_data46_ = _data47_->_data46_;
	self = _data46_->self;
	_tmp0_ = _data47_->usb_device;
	_tmp1_ = boxes_usb_device_get_active (_tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		SpiceUsbDeviceManager* _tmp3_;
		SpiceUsbDevice* _tmp4_;
		_tmp3_ = _data46_->manager;
		_tmp4_ = _data47_->dev;
		spice_usb_device_manager_disconnect_device (_tmp3_, _tmp4_);
		return;
	}
	_tmp5_ = _data46_->manager;
	_tmp6_ = _data47_->dev;
	spice_usb_device_manager_connect_device_async (_tmp5_, _tmp6_, NULL, ___lambda78__gasync_ready_callback, block47_data_ref (_data47_));
}

static void
______lambda77__g_object_notify (GObject* _sender,
                                 GParamSpec* pspec,
                                 gpointer self)
{
	_____lambda77_ (self);
}

GListStore*
boxes_spice_display_get_usb_devices_model (BoxesSpiceDisplay* self)
{
	Block46Data* _data46_;
	GListStore* model = NULL;
	GListStore* _tmp0_;
	GPtrArray* devs = NULL;
	GPtrArray* _tmp1_;
	GError* _inner_error0_ = NULL;
	GListStore* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data46_ = g_slice_new0 (Block46Data);
	_data46_->_ref_count_ = 1;
	_data46_->self = g_object_ref (self);
	_tmp0_ = g_list_store_new (BOXES_TYPE_USB_DEVICE);
	model = _tmp0_;
	_tmp1_ = g_ptr_array_new_full ((guint) 0, __vala_SpiceUsbDevice_free0_);
	devs = _tmp1_;
	{
		SpiceUsbDeviceManager* _tmp2_ = NULL;
		SpiceSession* _tmp3_;
		SpiceUsbDeviceManager* _tmp4_;
		SpiceUsbDeviceManager* _tmp5_;
		SpiceUsbDeviceManager* _tmp6_;
		GPtrArray* _tmp7_;
		_tmp3_ = self->priv->session;
		_tmp4_ = spice_usb_device_manager_get (_tmp3_, &_inner_error0_);
		_tmp2_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _g_object_ref0 (_tmp2_);
		_g_object_unref0 (_data46_->manager);
		_data46_->manager = _tmp5_;
		_tmp6_ = _data46_->manager;
		_tmp7_ = boxes_spice_display_get_usb_devices (self, _tmp6_);
		_g_ptr_array_unref0 (devs);
		devs = _tmp7_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = _error_;
		_tmp9_ = _tmp8_->message;
		g_warning ("spice-display.vala:429: Failed to obtain usb devices list: %s", _tmp9_);
		result = model;
		_g_error_free0 (_error_);
		_g_ptr_array_unref0 (devs);
		block46_data_unref (_data46_);
		_data46_ = NULL;
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_ptr_array_unref0 (devs);
		_g_object_unref0 (model);
		block46_data_unref (_data46_);
		_data46_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				Block47Data* _data47_;
				GPtrArray* _tmp12_;
				gint _tmp13_;
				gint _tmp14_;
				GPtrArray* _tmp15_;
				gconstpointer _tmp16_;
				SpiceUsbDevice* _tmp17_;
				SpiceUsbDevice* _tmp18_;
				gchar* _tmp19_;
				SpiceUsbDeviceManager* _tmp20_;
				SpiceUsbDevice* _tmp21_;
				BoxesUsbDevice* _tmp22_ = NULL;
				BoxesUsbDevice* _tmp23_;
				GListStore* _tmp24_;
				BoxesUsbDevice* _tmp25_;
				_data47_ = g_slice_new0 (Block47Data);
				_data47_->_ref_count_ = 1;
				_data47_->_data46_ = block46_data_ref (_data46_);
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				_tmp12_ = devs;
				_tmp13_ = vala_g_ptr_array_get_length (_tmp12_);
				_tmp14_ = _tmp13_;
				if (!(i < _tmp14_)) {
					block47_data_unref (_data47_);
					_data47_ = NULL;
					break;
				}
				_tmp15_ = devs;
				_tmp16_ = g_ptr_array_index (_tmp15_, (guint) i);
				_tmp17_ = __vala_SpiceUsbDevice_copy0 ((SpiceUsbDevice*) _tmp16_);
				_data47_->dev = _tmp17_;
				_tmp18_ = _data47_->dev;
				_tmp19_ = spice_usb_device_get_description (_tmp18_, "%1$s %2$s");
				_tmp20_ = _data46_->manager;
				_tmp21_ = _data47_->dev;
				_tmp22_ = boxes_usb_device_new ();
				_g_free0 (_tmp22_->title);
				_tmp22_->title = _tmp19_;
				boxes_usb_device_set_active (_tmp22_, spice_usb_device_manager_is_device_connected (_tmp20_, _tmp21_));
				_data47_->usb_device = _tmp22_;
				_tmp23_ = _data47_->usb_device;
				g_signal_connect_data ((GObject*) _tmp23_, "notify::active", (GCallback) ______lambda77__g_object_notify, block47_data_ref (_data47_), (GClosureNotify) block47_data_unref, 0);
				_tmp24_ = model;
				_tmp25_ = _data47_->usb_device;
				g_list_store_append (_tmp24_, (GObject*) _tmp25_);
				block47_data_unref (_data47_);
				_data47_ = NULL;
			}
		}
	}
	result = model;
	_g_ptr_array_unref0 (devs);
	block46_data_unref (_data46_);
	_data46_ = NULL;
	return result;
}

static gboolean
boxes_spice_display_is_usb_kbd_or_mouse (BoxesSpiceDisplay* self,
                                         guint8 class,
                                         guint8 subclass,
                                         guint8 protocol)
{
	gboolean ret = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	ret = FALSE;
	if (class == LIBUSB_CLASS_HID) {
		switch (subclass) {
			case 0x00:
			{
				break;
			}
			case 0x01:
			{
				switch (protocol) {
					case 0x00:
					{
						break;
					}
					case 0x01:
					case 0x02:
					{
						ret = TRUE;
						break;
					}
					default:
					{
						break;
					}
				}
				break;
			}
			default:
			{
				break;
			}
		}
	}
	result = ret;
	return result;
}

static const gchar*
boxes_spice_display_real_get_protocol (BoxesDisplay* base)
{
	const gchar* result;
	BoxesSpiceDisplay* self;
	self = (BoxesSpiceDisplay*) base;
	result = "SPICE";
	return result;
}

static gchar*
boxes_spice_display_real_get_uri (BoxesDisplay* base)
{
	gchar* result;
	BoxesSpiceDisplay* self;
	gboolean _tmp0_ = FALSE;
	SpiceSession* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	SpiceSession* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	self = (BoxesSpiceDisplay*) base;
	_tmp1_ = self->priv->session;
	g_object_get (_tmp1_, "port", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ == NULL;
	_g_free0 (_tmp4_);
	if (_tmp5_) {
		SpiceSession* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp6_ = self->priv->session;
		g_object_get (_tmp6_, "tls-port", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = _tmp8_;
		_tmp0_ = _tmp9_ == NULL;
		_g_free0 (_tmp9_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = NULL;
		return result;
	}
	_tmp10_ = self->priv->session;
	g_object_get (_tmp10_, "uri", &_tmp11_, NULL);
	_tmp12_ = _tmp11_;
	result = _tmp12_;
	return result;
}

static gboolean
boxes_spice_display_real_get_can_transfer_files (BoxesDisplay* base)
{
	gboolean result;
	BoxesSpiceDisplay* self;
	SpiceMainChannel* _tmp0_;
	SpiceMainChannel* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = (BoxesSpiceDisplay*) base;
	_tmp0_ = boxes_spice_display_get_main_channel (self);
	_tmp1_ = _tmp0_;
	g_object_get (_tmp1_, "agent-connected", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}

GByteArray*
boxes_spice_display_get_ca_cert (BoxesSpiceDisplay* self)
{
	GByteArray* result;
	SpiceSession* _tmp0_;
	GByteArray* _tmp1_;
	GByteArray* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->session;
	g_object_get (_tmp0_, "ca", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
boxes_spice_display_set_ca_cert (BoxesSpiceDisplay* self,
                                 GByteArray* value)
{
	SpiceSession* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->session;
	g_object_set (_tmp0_, "ca", value, NULL);
	g_object_notify_by_pspec ((GObject *) self, boxes_spice_display_properties[BOXES_SPICE_DISPLAY_CA_CERT_PROPERTY]);
}

SpiceMainChannel*
boxes_spice_display_get_main_channel (BoxesSpiceDisplay* self)
{
	SpiceMainChannel* result;
	SpiceMainChannel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_main_channel;
	result = _tmp0_;
	return result;
}

static void
_boxes_spice_display_main_event_spice_channel_channel_event (SpiceChannel* _sender,
                                                             SpiceChannelEvent event,
                                                             gpointer self)
{
	boxes_spice_display_main_event ((BoxesSpiceDisplay*) self, event);
}

static void
_boxes_spice_display_main_channel___lambda72_ (BoxesSpiceDisplay* self)
{
	SpiceMainChannel* _tmp0_;
	SpiceMainChannel* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	_tmp0_ = boxes_spice_display_get_main_channel (self);
	_tmp1_ = _tmp0_;
	g_object_get (_tmp1_, "mouse-mode", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	boxes_display_set_can_grab_mouse ((BoxesDisplay*) self, _tmp3_ != 2);
}

static void
__boxes_spice_display_main_channel___lambda72__g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self)
{
	_boxes_spice_display_main_channel___lambda72_ ((BoxesSpiceDisplay*) self);
}

static void
_boxes_spice_display_on_new_file_transfer_spice_main_channel_new_file_transfer (SpiceMainChannel* _sender,
                                                                                GObject* task,
                                                                                gpointer self)
{
	boxes_spice_display_on_new_file_transfer ((BoxesSpiceDisplay*) self, _sender, task);
}

static void
_boxes_spice_display_main_channel___lambda73_ (BoxesSpiceDisplay* self)
{
	SpiceMainChannel* _tmp0_;
	SpiceMainChannel* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = boxes_spice_display_get_main_channel (self);
	_tmp1_ = _tmp0_;
	g_object_get (_tmp1_, "agent-connected", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	boxes_display_set_is_guest_agent_connected ((BoxesDisplay*) self, _tmp3_);
}

static void
__boxes_spice_display_main_channel___lambda73__g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self)
{
	_boxes_spice_display_main_channel___lambda73_ ((BoxesSpiceDisplay*) self);
}

void
boxes_spice_display_set_main_channel (BoxesSpiceDisplay* self,
                                      SpiceMainChannel* value)
{
	SpiceMainChannel* _tmp0_;
	SpiceMainChannel* _tmp1_;
	SpiceMainChannel* _tmp2_;
	SpiceMainChannel* _tmp3_;
	gulong _tmp4_;
	SpiceMainChannel* _tmp5_;
	SpiceMainChannel* _tmp6_;
	gulong _tmp7_;
	SpiceMainChannel* _tmp8_;
	SpiceMainChannel* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	SpiceMainChannel* _tmp12_;
	SpiceMainChannel* _tmp13_;
	gulong _tmp14_;
	SpiceMainChannel* _tmp15_;
	SpiceMainChannel* _tmp16_;
	gulong _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_main_channel);
	self->priv->_main_channel = _tmp0_;
	_tmp1_ = self->priv->_main_channel;
	if (_tmp1_ == NULL) {
		return;
	}
	_tmp2_ = boxes_spice_display_get_main_channel (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_signal_connect_object ((SpiceChannel*) _tmp3_, "channel-event", (GCallback) _boxes_spice_display_main_event_spice_channel_channel_event, self, 0);
	self->priv->main_event_id = _tmp4_;
	_tmp5_ = boxes_spice_display_get_main_channel (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_signal_connect_object ((GObject*) _tmp6_, "notify::mouse-mode", (GCallback) __boxes_spice_display_main_channel___lambda72__g_object_notify, self, 0);
	self->priv->main_mouse_mode_id = _tmp7_;
	_tmp8_ = boxes_spice_display_get_main_channel (self);
	_tmp9_ = _tmp8_;
	g_object_get (_tmp9_, "mouse-mode", &_tmp10_, NULL);
	_tmp11_ = _tmp10_;
	boxes_display_set_can_grab_mouse ((BoxesDisplay*) self, _tmp11_ != 2);
	_tmp12_ = boxes_spice_display_get_main_channel (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_signal_connect_object (_tmp13_, "new-file-transfer", (GCallback) _boxes_spice_display_on_new_file_transfer_spice_main_channel_new_file_transfer, self, 0);
	self->priv->new_file_transfer_id = _tmp14_;
	_tmp15_ = boxes_spice_display_get_main_channel (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_signal_connect_object ((GObject*) _tmp16_, "notify::agent-connected", (GCallback) __boxes_spice_display_main_channel___lambda73__g_object_notify, self, 0);
	self->priv->agent_connected_id = _tmp17_;
	g_object_notify_by_pspec ((GObject *) self, boxes_spice_display_properties[BOXES_SPICE_DISPLAY_MAIN_CHANNEL_PROPERTY]);
}

static void
_boxes_spice_display____lambda79_ (BoxesSpiceDisplay* self,
                                   SpiceUsbDevice* dev,
                                   GError* err)
{
	gchar* device_description = NULL;
	gchar* _tmp0_;
	gchar* box_name = NULL;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	g_return_if_fail (dev != NULL);
	g_return_if_fail (err != NULL);
	_tmp0_ = spice_usb_device_get_description (dev, "%1$s %2$s");
	device_description = _tmp0_;
	_tmp1_ = boxes_spice_display_get_box_name (self);
	box_name = _tmp1_;
	_tmp2_ = device_description;
	_tmp3_ = box_name;
	_tmp4_ = g_strdup_printf (_ ("Redirection of USB device “%s” for “%s” failed"), _tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	g_signal_emit_by_name ((BoxesDisplay*) self, "got-error", _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = device_description;
	_tmp7_ = box_name;
	_tmp8_ = err->message;
	g_debug ("spice-display.vala:62: Error connecting %s to %s: %s", _tmp6_, _tmp7_, _tmp8_);
	_g_free0 (box_name);
	_g_free0 (device_description);
}

static void
__boxes_spice_display____lambda79__spice_usb_device_manager_device_error (SpiceUsbDeviceManager* _sender,
                                                                          SpiceUsbDevice* device,
                                                                          GError* _error_,
                                                                          gpointer self)
{
	_boxes_spice_display____lambda79_ ((BoxesSpiceDisplay*) self, device, _error_);
}

static GObject *
boxes_spice_display_constructor (GType type,
                                 guint n_construct_properties,
                                 GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BoxesSpiceDisplay * self;
	SpiceSession* _tmp0_;
	SpiceSession* _tmp1_;
	SpiceAudio* _tmp2_;
	SpiceSession* _tmp3_;
	SpiceGtkSession* _tmp4_;
	SpiceSession* _tmp5_;
	GError* _inner_error0_ = NULL;
	parent_class = G_OBJECT_CLASS (boxes_spice_display_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplay);
	_tmp0_ = spice_session_new ();
	_g_object_unref0 (self->priv->session);
	self->priv->session = _tmp0_;
	_tmp1_ = self->priv->session;
	_tmp2_ = spice_audio_get (_tmp1_, NULL);
	self->priv->audio = _tmp2_;
	_tmp3_ = self->priv->session;
	_tmp4_ = spice_gtk_session_get (_tmp3_);
	self->priv->gtk_session = _tmp4_;
	_tmp5_ = self->priv->session;
	spice_set_session_option (_tmp5_);
	{
		SpiceUsbDeviceManager* manager = NULL;
		SpiceSession* _tmp6_;
		SpiceUsbDeviceManager* _tmp7_;
		SpiceUsbDeviceManager* _tmp8_;
		SpiceUsbDeviceManager* _tmp9_;
		_tmp6_ = self->priv->session;
		_tmp7_ = spice_usb_device_manager_get (_tmp6_, &_inner_error0_);
		_tmp8_ = _g_object_ref0 (_tmp7_);
		manager = _tmp8_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp9_ = manager;
		g_signal_connect_object (_tmp9_, "device-error", (GCallback) __boxes_spice_display____lambda79__spice_usb_device_manager_device_error, self, 0);
		_g_object_unref0 (manager);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
	}
	return obj;
}

static void
boxes_spice_display_class_init (BoxesSpiceDisplayClass * klass,
                                gpointer klass_data)
{
	boxes_spice_display_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesSpiceDisplay_private_offset);
	((BoxesDisplayClass *) klass)->get_display = (GtkWidget* (*) (BoxesDisplay*, gint)) boxes_spice_display_real_get_display;
	((BoxesDisplayClass *) klass)->should_keep_alive = (gboolean (*) (BoxesDisplay*)) boxes_spice_display_real_should_keep_alive;
	((BoxesDisplayClass *) klass)->set_enable_audio = (void (*) (BoxesDisplay*, gboolean)) boxes_spice_display_real_set_enable_audio;
	((BoxesDisplayClass *) klass)->get_pixbuf = (GdkPixbuf* (*) (BoxesDisplay*, gint, GError**)) boxes_spice_display_real_get_pixbuf;
	((BoxesDisplayClass *) klass)->collect_logs = (void (*) (BoxesDisplay*, GString*)) boxes_spice_display_real_collect_logs;
	((BoxesDisplayClass *) klass)->connect_it = (void (*) (BoxesDisplay*, BoxesDisplayOpenFDFunc, gpointer, GDestroyNotify, GError**)) boxes_spice_display_real_connect_it;
	((BoxesDisplayClass *) klass)->disconnect_it = (void (*) (BoxesDisplay*)) boxes_spice_display_real_disconnect_it;
	((BoxesDisplayClass *) klass)->transfer_files = (void (*) (BoxesDisplay*, GList*)) boxes_spice_display_real_transfer_files;
	((BoxesDisplayClass *) klass)->send_keys = (void (*) (BoxesDisplay*, guint*, gint)) boxes_spice_display_real_send_keys;
	BOXES_DISPLAY_CLASS (klass)->get_protocol = (const gchar* (*) (BoxesDisplay*)) boxes_spice_display_real_get_protocol;
	BOXES_DISPLAY_CLASS (klass)->get_uri = (gchar* (*) (BoxesDisplay*)) boxes_spice_display_real_get_uri;
	BOXES_DISPLAY_CLASS (klass)->get_can_transfer_files = (gboolean (*) (BoxesDisplay*)) boxes_spice_display_real_get_can_transfer_files;
	G_OBJECT_CLASS (klass)->get_property = _vala_boxes_spice_display_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_boxes_spice_display_set_property;
	G_OBJECT_CLASS (klass)->constructor = boxes_spice_display_constructor;
	G_OBJECT_CLASS (klass)->finalize = boxes_spice_display_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_SPICE_DISPLAY_PROTOCOL_PROPERTY, boxes_spice_display_properties[BOXES_SPICE_DISPLAY_PROTOCOL_PROPERTY] = g_param_spec_string ("protocol", "protocol", "protocol", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_SPICE_DISPLAY_URI_PROPERTY, boxes_spice_display_properties[BOXES_SPICE_DISPLAY_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_SPICE_DISPLAY_CAN_TRANSFER_FILES_PROPERTY, boxes_spice_display_properties[BOXES_SPICE_DISPLAY_CAN_TRANSFER_FILES_PROPERTY] = g_param_spec_boolean ("can-transfer-files", "can-transfer-files", "can-transfer-files", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_SPICE_DISPLAY_CA_CERT_PROPERTY, boxes_spice_display_properties[BOXES_SPICE_DISPLAY_CA_CERT_PROPERTY] = g_param_spec_boxed ("ca-cert", "ca-cert", "ca-cert", G_TYPE_BYTE_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BOXES_SPICE_DISPLAY_MAIN_CHANNEL_PROPERTY, boxes_spice_display_properties[BOXES_SPICE_DISPLAY_MAIN_CHANNEL_PROPERTY] = g_param_spec_object ("main-channel", "main-channel", "main-channel", spice_main_channel_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
boxes_spice_display_instance_init (BoxesSpiceDisplay * self,
                                   gpointer klass)
{
	self->priv = boxes_spice_display_get_instance_private (self);
}

static void
boxes_spice_display_finalize (GObject * obj)
{
	BoxesSpiceDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplay);
	boxes_spice_display_main_cleanup (self);
	_g_object_unref0 (self->priv->session);
	self->priv->display_saved_properties = (_vala_BoxesBoxConfigSavedProperty_array_free (self->priv->display_saved_properties, self->priv->display_saved_properties_length1), NULL);
	self->priv->gtk_session_saved_properties = (_vala_BoxesBoxConfigSavedProperty_array_free (self->priv->gtk_session_saved_properties, self->priv->gtk_session_saved_properties_length1), NULL);
	_g_object_unref0 (self->priv->webdav_channel);
	_g_hash_table_unref0 (self->priv->channel_handlers);
	(self->priv->open_fd_target_destroy_notify == NULL) ? NULL : (self->priv->open_fd_target_destroy_notify (self->priv->open_fd_target), NULL);
	self->priv->open_fd = NULL;
	self->priv->open_fd_target = NULL;
	self->priv->open_fd_target_destroy_notify = NULL;
	_g_object_unref0 (self->priv->_main_channel);
	G_OBJECT_CLASS (boxes_spice_display_parent_class)->finalize (obj);
}

static GType
boxes_spice_display_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesSpiceDisplayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_spice_display_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesSpiceDisplay), 0, (GInstanceInitFunc) boxes_spice_display_instance_init, NULL };
	GType boxes_spice_display_type_id;
	boxes_spice_display_type_id = g_type_register_static (BOXES_TYPE_DISPLAY, "BoxesSpiceDisplay", &g_define_type_info, 0);
	BoxesSpiceDisplay_private_offset = g_type_add_instance_private (boxes_spice_display_type_id, sizeof (BoxesSpiceDisplayPrivate));
	return boxes_spice_display_type_id;
}

GType
boxes_spice_display_get_type (void)
{
	static volatile gsize boxes_spice_display_type_id__once = 0;
	if (g_once_init_enter (&boxes_spice_display_type_id__once)) {
		GType boxes_spice_display_type_id;
		boxes_spice_display_type_id = boxes_spice_display_get_type_once ();
		g_once_init_leave (&boxes_spice_display_type_id__once, boxes_spice_display_type_id);
	}
	return boxes_spice_display_type_id__once;
}

static void
_vala_boxes_spice_display_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec)
{
	BoxesSpiceDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplay);
	switch (property_id) {
		case BOXES_SPICE_DISPLAY_PROTOCOL_PROPERTY:
		g_value_set_string (value, boxes_display_get_protocol ((BoxesDisplay*) self));
		break;
		case BOXES_SPICE_DISPLAY_URI_PROPERTY:
		g_value_take_string (value, boxes_display_get_uri ((BoxesDisplay*) self));
		break;
		case BOXES_SPICE_DISPLAY_CAN_TRANSFER_FILES_PROPERTY:
		g_value_set_boolean (value, boxes_display_get_can_transfer_files ((BoxesDisplay*) self));
		break;
		case BOXES_SPICE_DISPLAY_CA_CERT_PROPERTY:
		g_value_take_boxed (value, boxes_spice_display_get_ca_cert (self));
		break;
		case BOXES_SPICE_DISPLAY_MAIN_CHANNEL_PROPERTY:
		g_value_set_object (value, boxes_spice_display_get_main_channel (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_boxes_spice_display_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec)
{
	BoxesSpiceDisplay * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BOXES_TYPE_SPICE_DISPLAY, BoxesSpiceDisplay);
	switch (property_id) {
		case BOXES_SPICE_DISPLAY_CA_CERT_PROPERTY:
		boxes_spice_display_set_ca_cert (self, g_value_get_boxed (value));
		break;
		case BOXES_SPICE_DISPLAY_MAIN_CHANNEL_PROPERTY:
		boxes_spice_display_set_main_channel (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
boxes_spice_channel_handler_get_instance_private (BoxesSpiceChannelHandler* self)
{
	return G_STRUCT_MEMBER_P (self, BoxesSpiceChannelHandler_private_offset);
}

static void
_boxes_spice_channel_handler_on_open_fd_spice_channel_open_fd (SpiceChannel* _sender,
                                                               gint with_tls,
                                                               gpointer self)
{
	boxes_spice_channel_handler_on_open_fd ((BoxesSpiceChannelHandler*) self, _sender, with_tls);
}

static void
_boxes_spice_channel_handler_on_display_ready_g_object_notify (GObject* _sender,
                                                               GParamSpec* pspec,
                                                               gpointer self)
{
	boxes_spice_channel_handler_on_display_ready ((BoxesSpiceChannelHandler*) self, _sender, pspec);
}

BoxesSpiceChannelHandler*
boxes_spice_channel_handler_construct (GType object_type,
                                       BoxesSpiceDisplay* display,
                                       SpiceChannel* channel,
                                       BoxesDisplayOpenFDFunc open_fd,
                                       gpointer open_fd_target)
{
	BoxesSpiceChannelHandler * self = NULL;
	SpiceChannel* _tmp0_;
	gint id = 0;
	gint _tmp1_;
	gint _tmp2_;
	g_return_val_if_fail (display != NULL, NULL);
	g_return_val_if_fail (channel != NULL, NULL);
	self = (BoxesSpiceChannelHandler*) g_object_new (object_type, NULL);
	self->priv->display = display;
	_tmp0_ = _g_object_ref0 (channel);
	_g_object_unref0 (self->priv->channel);
	self->priv->channel = _tmp0_;
	self->priv->open_fd = open_fd;
	self->priv->open_fd_target = open_fd_target;
	g_object_get (channel, "channel-id", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	id = _tmp2_;
	if (open_fd != NULL) {
		g_signal_connect_object (channel, "open-fd", (GCallback) _boxes_spice_channel_handler_on_open_fd_spice_channel_open_fd, self, 0);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (channel, spice_main_channel_get_type ())) {
		boxes_spice_display_set_main_channel (display, G_TYPE_CHECK_INSTANCE_TYPE (channel, spice_main_channel_get_type ()) ? ((SpiceMainChannel*) channel) : NULL);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (channel, spice_display_channel_get_type ())) {
		SpiceDisplay* spice_display = NULL;
		GtkWidget* _tmp3_;
		SpiceDisplay* _tmp4_;
		SpiceDisplay* _tmp5_;
		if (id != 0) {
			return self;
		}
		_tmp3_ = boxes_display_get_display ((BoxesDisplay*) display, id);
		_tmp4_ = G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, spice_display_get_type ()) ? ((SpiceDisplay*) _tmp3_) : NULL;
		if (_tmp4_ == NULL) {
			_g_object_unref0 (_tmp3_);
		}
		spice_display = _tmp4_;
		_tmp5_ = spice_display;
		g_signal_connect_object ((GObject*) _tmp5_, "notify::ready", (GCallback) _boxes_spice_channel_handler_on_display_ready_g_object_notify, self, 0);
		_g_object_unref0 (spice_display);
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (channel, spice_webdav_channel_get_type ())) {
		if (open_fd != NULL) {
			boxes_spice_channel_handler_on_open_fd (self, channel, 0);
		} else {
			spice_channel_connect (channel);
		}
	}
	return self;
}

BoxesSpiceChannelHandler*
boxes_spice_channel_handler_new (BoxesSpiceDisplay* display,
                                 SpiceChannel* channel,
                                 BoxesDisplayOpenFDFunc open_fd,
                                 gpointer open_fd_target)
{
	return boxes_spice_channel_handler_construct (BOXES_TYPE_SPICE_CHANNEL_HANDLER, display, channel, open_fd, open_fd_target);
}

static void
boxes_spice_channel_handler_on_display_ready (BoxesSpiceChannelHandler* self,
                                              GObject* object,
                                              GParamSpec* param_spec)
{
	SpiceDisplay* spice_display = NULL;
	SpiceDisplay* _tmp0_;
	SpiceDisplay* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (object != NULL);
	g_return_if_fail (param_spec != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (object, spice_display_get_type ()) ? ((SpiceDisplay*) object) : NULL);
	spice_display = _tmp0_;
	_tmp1_ = spice_display;
	g_object_get (_tmp1_, "ready", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		BoxesSpiceDisplay* _tmp4_;
		SpiceDisplay* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp4_ = self->priv->display;
		_tmp5_ = spice_display;
		g_object_get (_tmp5_, "channel-id", &_tmp6_, NULL);
		_tmp7_ = _tmp6_;
		g_signal_emit_by_name ((BoxesDisplay*) _tmp4_, "show", _tmp7_);
	} else {
		BoxesSpiceDisplay* _tmp8_;
		SpiceDisplay* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		_tmp8_ = self->priv->display;
		_tmp9_ = spice_display;
		g_object_get (_tmp9_, "channel-id", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		g_signal_emit_by_name ((BoxesDisplay*) _tmp8_, "hide", _tmp11_);
	}
	_g_object_unref0 (spice_display);
}

static void
boxes_spice_channel_handler_on_open_fd (BoxesSpiceChannelHandler* self,
                                        SpiceChannel* channel,
                                        gint with_tls)
{
	gint fd = 0;
	BoxesDisplayOpenFDFunc _tmp0_;
	gpointer _tmp0__target;
	g_return_if_fail (self != NULL);
	g_return_if_fail (channel != NULL);
	_tmp0_ = self->priv->open_fd;
	_tmp0__target = self->priv->open_fd_target;
	fd = _tmp0_ (_tmp0__target);
	spice_channel_open_fd (channel, fd);
}

static void
boxes_spice_channel_handler_class_init (BoxesSpiceChannelHandlerClass * klass,
                                        gpointer klass_data)
{
	boxes_spice_channel_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BoxesSpiceChannelHandler_private_offset);
	G_OBJECT_CLASS (klass)->finalize = boxes_spice_channel_handler_finalize;
}

static void
boxes_spice_channel_handler_instance_init (BoxesSpiceChannelHandler * self,
                                           gpointer klass)
{
	self->priv = boxes_spice_channel_handler_get_instance_private (self);
}

static void
boxes_spice_channel_handler_finalize (GObject * obj)
{
	BoxesSpiceChannelHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_SPICE_CHANNEL_HANDLER, BoxesSpiceChannelHandler);
	_g_object_unref0 (self->priv->channel);
	G_OBJECT_CLASS (boxes_spice_channel_handler_parent_class)->finalize (obj);
}

static GType
boxes_spice_channel_handler_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BoxesSpiceChannelHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_spice_channel_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesSpiceChannelHandler), 0, (GInstanceInitFunc) boxes_spice_channel_handler_instance_init, NULL };
	GType boxes_spice_channel_handler_type_id;
	boxes_spice_channel_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesSpiceChannelHandler", &g_define_type_info, 0);
	BoxesSpiceChannelHandler_private_offset = g_type_add_instance_private (boxes_spice_channel_handler_type_id, sizeof (BoxesSpiceChannelHandlerPrivate));
	return boxes_spice_channel_handler_type_id;
}

GType
boxes_spice_channel_handler_get_type (void)
{
	static volatile gsize boxes_spice_channel_handler_type_id__once = 0;
	if (g_once_init_enter (&boxes_spice_channel_handler_type_id__once)) {
		GType boxes_spice_channel_handler_type_id;
		boxes_spice_channel_handler_type_id = boxes_spice_channel_handler_get_type_once ();
		g_once_init_leave (&boxes_spice_channel_handler_type_id__once, boxes_spice_channel_handler_type_id);
	}
	return boxes_spice_channel_handler_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

