static const char* color_to_alpha_cl_source =
"#define EPSILON 0.00001                                                       \n"
"#define NORMALIZE(d, tt, ot, c) ((d - tt) / (min (ot, c) - tt))               \n"
"                                                                              \n"
"__kernel void cl_color_to_alpha(__global const float4 *in,                    \n"
"                                __global       float4 *out,                   \n"
"                                         const float4  color,                 \n"
"                                         const float   transparency_threshold,\n"
"                                         const float   opacity_threshold)     \n"
"{                                                                             \n"
"  const int    gid         = get_global_id (0);                               \n"
"  const float4 in_v        = in[gid];                                         \n"
"        float4 out_v       = in_v;                                            \n"
"  const float4 d           = fabs (out_v - color);                            \n"
"        float4 a;                                                             \n"
"  const float  input_alpha = out_v.w;                                         \n"
"  const float  tt          = transparency_threshold;                          \n"
"  const float  ot          = opacity_threshold;                               \n"
"        float  alpha       = 0.0f;                                            \n"
"        float  dist        = 0.0f;                                            \n"
"                                                                              \n"
"  a = select (                                                                \n"
"        select (                                                              \n"
"          select (NORMALIZE (d, tt, ot, 1.0f - color),                        \n"
"                  NORMALIZE (d, tt, ot, color), out_v < color),               \n"
"                1.0f, d > ot - (float4)EPSILON),                              \n"
"              0.0f, d < tt + (float4)EPSILON);                                \n"
"                                                                              \n"
"/* The above version could be hardware optimized and essentially does the below\n"
"   loop except for the if a[i] > alpha statements, it's vectorized code so there\n"
"   could be some performance benefits.                                        \n"
"                                                                              \n"
"  for (int i = 0; i < 3; i++)                                                 \n"
"    {                                                                         \n"
"      if (d[i] < tt + EPSILON)                                                \n"
"        a[i] = 0.0f;                                                          \n"
"      else if (d[i] > ot - EPSILON)                                           \n"
"        a[i] = 1.0f;                                                          \n"
"      else if (out_v[i] < color[i])                                           \n"
"        a[i] = NORMALIZE (d[i], tt, ot, color[i]);                            \n"
"      else                                                                    \n"
"        a[i] = NORMALIZE (d[i], tt, ot, 1.0f - color[i]);                     \n"
"                                                                              \n"
"      if (a[i] > alpha)                                                       \n"
"        {                                                                     \n"
"          alpha = a[i];                                                       \n"
"          dist  = d[i];                                                       \n"
"        }                                                                     \n"
"    }                                                                         \n"
"*/                                                                            \n"
"                                                                              \n"
"  if (a[2] > a[1] && a[2] > a[0])                                             \n"
"    {                                                                         \n"
"      alpha = a[2];                                                           \n"
"      dist  = d[2];                                                           \n"
"    }                                                                         \n"
"  else if (a[1] > a[0])                                                       \n"
"    {                                                                         \n"
"      alpha = a[1];                                                           \n"
"      dist  = d[1];                                                           \n"
"    }                                                                         \n"
"  else                                                                        \n"
"    {                                                                         \n"
"      alpha = a[0];                                                           \n"
"      dist  = d[0];                                                           \n"
"    }                                                                         \n"
"                                                                              \n"
"  if (alpha > EPSILON)                                                        \n"
"    {                                                                         \n"
"      const float  ratio     = tt / dist;                                     \n"
"      const float  alpha_inv = 1.0f / alpha;                                  \n"
"      const float4 c         = color + (out_v - color) * ratio;               \n"
"      out_v                  = c + (out_v - c) * alpha_inv;                   \n"
"    }                                                                         \n"
"                                                                              \n"
"  out_v.w  = input_alpha * alpha;                                             \n"
"  out[gid] = out_v;                                                           \n"
"}                                                                             \n"
;
