/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-ccgx-pure-hid-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_ccgx_pure_hid_fw_mode_to_string(FuCcgxPureHidFwMode val)
{
    if (val == FU_CCGX_PURE_HID_FW_MODE_BOOT)
        return "boot";
    if (val == FU_CCGX_PURE_HID_FW_MODE_FW1)
        return "fw1";
    if (val == FU_CCGX_PURE_HID_FW_MODE_FW2)
        return "fw2";
    return NULL;
}

static const gchar *
fu_ccgx_pure_hid_report_id_to_string(FuCcgxPureHidReportId val)
{
    if (val == FU_CCGX_PURE_HID_REPORT_ID_INFO)
        return "info";
    if (val == FU_CCGX_PURE_HID_REPORT_ID_COMMAND)
        return "command";
    if (val == FU_CCGX_PURE_HID_REPORT_ID_WRITE)
        return "write";
    if (val == FU_CCGX_PURE_HID_REPORT_ID_READ)
        return "read";
    if (val == FU_CCGX_PURE_HID_REPORT_ID_CUSTOM)
        return "custom";
    return NULL;
}

/**
 * fu_struct_ccgx_pure_hid_fw_info_ref: (skip):
 **/
FuStructCcgxPureHidFwInfo *
fu_struct_ccgx_pure_hid_fw_info_ref(FuStructCcgxPureHidFwInfo *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ccgx_pure_hid_fw_info_unref: (skip):
 **/
void
fu_struct_ccgx_pure_hid_fw_info_unref(FuStructCcgxPureHidFwInfo *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructCcgxPureHidFwInfo refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_ccgx_pure_hid_fw_info_new_internal: (skip):
 **/
static FuStructCcgxPureHidFwInfo *
fu_struct_ccgx_pure_hid_fw_info_new_internal(void)
{
    FuStructCcgxPureHidFwInfo *st = g_new0(FuStructCcgxPureHidFwInfo, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ccgx_pure_hid_fw_info_get_report_id: (skip):
 **/
static FuCcgxPureHidReportId
fu_struct_ccgx_pure_hid_fw_info_get_report_id(const FuStructCcgxPureHidFwInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_ccgx_pure_hid_fw_info_get_signature: (skip):
 **/
static guint16
fu_struct_ccgx_pure_hid_fw_info_get_signature(const FuStructCcgxPureHidFwInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_pure_hid_fw_info_get_operating_mode: (skip):
 **/
FuCcgxPureHidFwMode
fu_struct_ccgx_pure_hid_fw_info_get_operating_mode(const FuStructCcgxPureHidFwInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}
/**
 * fu_struct_ccgx_pure_hid_fw_info_get_bootloader_info: (skip):
 **/
guint8
fu_struct_ccgx_pure_hid_fw_info_get_bootloader_info(const FuStructCcgxPureHidFwInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[5];
}
/**
 * fu_struct_ccgx_pure_hid_fw_info_get_bootmode_reason: (skip):
 **/
guint8
fu_struct_ccgx_pure_hid_fw_info_get_bootmode_reason(const FuStructCcgxPureHidFwInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[6];
}
/**
 * fu_struct_ccgx_pure_hid_fw_info_get_silicon_id: (skip):
 **/
guint32
fu_struct_ccgx_pure_hid_fw_info_get_silicon_id(const FuStructCcgxPureHidFwInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_pure_hid_fw_info_get_bl_version: (skip):
 **/
guint32
fu_struct_ccgx_pure_hid_fw_info_get_bl_version(const FuStructCcgxPureHidFwInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_pure_hid_fw_info_get_image1_version: (skip):
 **/
guint32
fu_struct_ccgx_pure_hid_fw_info_get_image1_version(const FuStructCcgxPureHidFwInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_pure_hid_fw_info_get_image2_version: (skip):
 **/
guint32
fu_struct_ccgx_pure_hid_fw_info_get_image2_version(const FuStructCcgxPureHidFwInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 28, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_pure_hid_fw_info_get_image1_row: (skip):
 **/
guint32
fu_struct_ccgx_pure_hid_fw_info_get_image1_row(const FuStructCcgxPureHidFwInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 36, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_pure_hid_fw_info_get_image2_row: (skip):
 **/
guint32
fu_struct_ccgx_pure_hid_fw_info_get_image2_row(const FuStructCcgxPureHidFwInfo *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 40, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_pure_hid_fw_info_get_device_uid: (skip):
 **/
const guint8 *
fu_struct_ccgx_pure_hid_fw_info_get_device_uid(const FuStructCcgxPureHidFwInfo *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 6;
    return st->buf->data + 44;
}

/* setters */
/**
 * fu_struct_ccgx_pure_hid_fw_info_to_string: (skip):
 **/
static gchar *
fu_struct_ccgx_pure_hid_fw_info_to_string(const FuStructCcgxPureHidFwInfo *st)
{
    g_autoptr(GString) str = g_string_new("FuStructCcgxPureHidFwInfo:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_ccgx_pure_hid_fw_mode_to_string(fu_struct_ccgx_pure_hid_fw_info_get_operating_mode(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  operating_mode: 0x%x [%s]\n", (guint) fu_struct_ccgx_pure_hid_fw_info_get_operating_mode(st), tmp);
        } else {
            g_string_append_printf(str, "  operating_mode: 0x%x\n", (guint) fu_struct_ccgx_pure_hid_fw_info_get_operating_mode(st));
        }
    }
    g_string_append_printf(str, "  bootloader_info: 0x%x\n",
                           (guint) fu_struct_ccgx_pure_hid_fw_info_get_bootloader_info(st));
    g_string_append_printf(str, "  bootmode_reason: 0x%x\n",
                           (guint) fu_struct_ccgx_pure_hid_fw_info_get_bootmode_reason(st));
    g_string_append_printf(str, "  silicon_id: 0x%x\n",
                           (guint) fu_struct_ccgx_pure_hid_fw_info_get_silicon_id(st));
    g_string_append_printf(str, "  bl_version: 0x%x\n",
                           (guint) fu_struct_ccgx_pure_hid_fw_info_get_bl_version(st));
    g_string_append_printf(str, "  image1_version: 0x%x\n",
                           (guint) fu_struct_ccgx_pure_hid_fw_info_get_image1_version(st));
    g_string_append_printf(str, "  image2_version: 0x%x\n",
                           (guint) fu_struct_ccgx_pure_hid_fw_info_get_image2_version(st));
    g_string_append_printf(str, "  image1_row: 0x%x\n",
                           (guint) fu_struct_ccgx_pure_hid_fw_info_get_image1_row(st));
    g_string_append_printf(str, "  image2_row: 0x%x\n",
                           (guint) fu_struct_ccgx_pure_hid_fw_info_get_image2_row(st));
    {
        gsize bufsz = 0;
        const guint8 *buf = fu_struct_ccgx_pure_hid_fw_info_get_device_uid(st, &bufsz);
        g_autoptr(GString) tmp = g_string_new(NULL);
        for (gsize i = 0; i < bufsz; i++)
            g_string_append_printf(tmp, "%02X", buf[i]);
        g_string_append_printf(str, "  device_uid: 0x%s\n", tmp->str);
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_ccgx_pure_hid_fw_info_validate_internal(FuStructCcgxPureHidFwInfo *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_ccgx_pure_hid_fw_info_get_report_id(st) != FU_CCGX_PURE_HID_REPORT_ID_INFO) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructCcgxPureHidFwInfo.report_id was not valid, "
                    "expected 'FuCcgxPureHidReportId' and got '%s'",
                    fu_ccgx_pure_hid_report_id_to_string(fu_struct_ccgx_pure_hid_fw_info_get_report_id(st)));
        return FALSE;
    }
    if (fu_struct_ccgx_pure_hid_fw_info_get_signature(st) != 0x5943) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructCcgxPureHidFwInfo.signature was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x5943,
                    (guint) fu_struct_ccgx_pure_hid_fw_info_get_signature(st));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_ccgx_pure_hid_fw_info_parse_internal(FuStructCcgxPureHidFwInfo *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_ccgx_pure_hid_fw_info_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_ccgx_pure_hid_fw_info_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_ccgx_pure_hid_fw_info_parse: (skip):
 **/
FuStructCcgxPureHidFwInfo *
fu_struct_ccgx_pure_hid_fw_info_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructCcgxPureHidFwInfo) st = fu_struct_ccgx_pure_hid_fw_info_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 60, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructCcgxPureHidFwInfo: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 60);
    if (!fu_struct_ccgx_pure_hid_fw_info_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_ccgx_pure_hid_command_ref: (skip):
 **/
FuStructCcgxPureHidCommand *
fu_struct_ccgx_pure_hid_command_ref(FuStructCcgxPureHidCommand *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ccgx_pure_hid_command_unref: (skip):
 **/
void
fu_struct_ccgx_pure_hid_command_unref(FuStructCcgxPureHidCommand *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructCcgxPureHidCommand refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_ccgx_pure_hid_command_new_internal: (skip):
 **/
static FuStructCcgxPureHidCommand *
fu_struct_ccgx_pure_hid_command_new_internal(void)
{
    FuStructCcgxPureHidCommand *st = g_new0(FuStructCcgxPureHidCommand, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_ccgx_pure_hid_command_set_report_id: (skip):
 **/
static void
fu_struct_ccgx_pure_hid_command_set_report_id(FuStructCcgxPureHidCommand *st, FuCcgxPureHidReportId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_ccgx_pure_hid_command_set_cmd: (skip):
 **/
void
fu_struct_ccgx_pure_hid_command_set_cmd(FuStructCcgxPureHidCommand *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_ccgx_pure_hid_command_set_opt: (skip):
 **/
void
fu_struct_ccgx_pure_hid_command_set_opt(FuStructCcgxPureHidCommand *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_ccgx_pure_hid_command_set_pad1: (skip):
 **/
void
fu_struct_ccgx_pure_hid_command_set_pad1(FuStructCcgxPureHidCommand *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_ccgx_pure_hid_command_set_pad2: (skip):
 **/
void
fu_struct_ccgx_pure_hid_command_set_pad2(FuStructCcgxPureHidCommand *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_pure_hid_command_new: (skip):
 **/
FuStructCcgxPureHidCommand *
fu_struct_ccgx_pure_hid_command_new(void)
{
    FuStructCcgxPureHidCommand *st = fu_struct_ccgx_pure_hid_command_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    fu_struct_ccgx_pure_hid_command_set_report_id(st, FU_CCGX_PURE_HID_REPORT_ID_COMMAND);
    fu_struct_ccgx_pure_hid_command_set_pad1(st, 0x00);
    fu_struct_ccgx_pure_hid_command_set_pad2(st, 0xCCCCCCCC);
    return st;
}
/**
 * fu_struct_ccgx_pure_hid_write_hdr_ref: (skip):
 **/
FuStructCcgxPureHidWriteHdr *
fu_struct_ccgx_pure_hid_write_hdr_ref(FuStructCcgxPureHidWriteHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ccgx_pure_hid_write_hdr_unref: (skip):
 **/
void
fu_struct_ccgx_pure_hid_write_hdr_unref(FuStructCcgxPureHidWriteHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructCcgxPureHidWriteHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_ccgx_pure_hid_write_hdr_new_internal: (skip):
 **/
static FuStructCcgxPureHidWriteHdr *
fu_struct_ccgx_pure_hid_write_hdr_new_internal(void)
{
    FuStructCcgxPureHidWriteHdr *st = g_new0(FuStructCcgxPureHidWriteHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */

/* setters */
/**
 * fu_struct_ccgx_pure_hid_write_hdr_set_report_id: (skip):
 **/
static void
fu_struct_ccgx_pure_hid_write_hdr_set_report_id(FuStructCcgxPureHidWriteHdr *st, FuCcgxPureHidReportId value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_ccgx_pure_hid_write_hdr_set_pd_resp: (skip):
 **/
void
fu_struct_ccgx_pure_hid_write_hdr_set_pd_resp(FuStructCcgxPureHidWriteHdr *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_ccgx_pure_hid_write_hdr_set_addr: (skip):
 **/
void
fu_struct_ccgx_pure_hid_write_hdr_set_addr(FuStructCcgxPureHidWriteHdr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_ccgx_pure_hid_write_hdr_set_data: (skip):
 **/
gboolean
fu_struct_ccgx_pure_hid_write_hdr_set_data(FuStructCcgxPureHidWriteHdr *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 4, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_ccgx_pure_hid_write_hdr_new: (skip):
 **/
FuStructCcgxPureHidWriteHdr *
fu_struct_ccgx_pure_hid_write_hdr_new(void)
{
    FuStructCcgxPureHidWriteHdr *st = fu_struct_ccgx_pure_hid_write_hdr_new_internal();
    st->buf = g_byte_array_sized_new(132);
    fu_byte_array_set_size(st->buf, 132, 0x0);
    fu_struct_ccgx_pure_hid_write_hdr_set_report_id(st, FU_CCGX_PURE_HID_REPORT_ID_WRITE);
    return st;
}
