/* auto-generated, do not modify */
#include "config.h"

#include "fu-wacom-raw-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

static const gchar *
fu_wacom_raw_operation_mode_to_string(FuWacomRawOperationMode val)
{
    if (val == FU_WACOM_RAW_OPERATION_MODE_RUNTIME)
        return "runtime";
    if (val == FU_WACOM_RAW_OPERATION_MODE_BOOTLOADER)
        return "bootloader";
    return NULL;
}



static const gchar *
fu_wacom_raw_bl_report_id_to_string(FuWacomRawBlReportId val)
{
    if (val == FU_WACOM_RAW_BL_REPORT_ID_TYPE)
        return "type";
    if (val == FU_WACOM_RAW_BL_REPORT_ID_SET)
        return "set";
    if (val == FU_WACOM_RAW_BL_REPORT_ID_GET)
        return "get";
    return NULL;
}

static const gchar *
fu_wacom_raw_bl_cmd_to_string(FuWacomRawBlCmd val)
{
    if (val == FU_WACOM_RAW_BL_CMD_ERASE_FLASH)
        return "erase-flash";
    if (val == FU_WACOM_RAW_BL_CMD_WRITE_FLASH)
        return "write-flash";
    if (val == FU_WACOM_RAW_BL_CMD_VERIFY_FLASH)
        return "verify-flash";
    if (val == FU_WACOM_RAW_BL_CMD_ATTACH)
        return "attach";
    if (val == FU_WACOM_RAW_BL_CMD_GET_BLVER)
        return "get-blver";
    if (val == FU_WACOM_RAW_BL_CMD_GET_MPUTYPE)
        return "get-mputype";
    if (val == FU_WACOM_RAW_BL_CMD_CHECK_MODE)
        return "check-mode";
    if (val == FU_WACOM_RAW_BL_CMD_ERASE_DATAMEM)
        return "erase-datamem";
    if (val == FU_WACOM_RAW_BL_CMD_ALL_ERASE)
        return "all-erase";
    return NULL;
}


/* getters */
/**
 * fu_struct_wacom_raw_request_get_report_id: (skip):
 **/
FuWacomRawBlReportId
fu_struct_wacom_raw_request_get_report_id(const FuStructWacomRawRequest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_wacom_raw_request_get_cmd: (skip):
 **/
guint8
fu_struct_wacom_raw_request_get_cmd(const FuStructWacomRawRequest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_struct_wacom_raw_request_get_echo: (skip):
 **/
guint8
fu_struct_wacom_raw_request_get_echo(const FuStructWacomRawRequest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[2];
}
/**
 * fu_struct_wacom_raw_request_get_addr: (skip):
 **/
guint32
fu_struct_wacom_raw_request_get_addr(const FuStructWacomRawRequest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 3, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_wacom_raw_request_get_size8: (skip):
 **/
guint8
fu_struct_wacom_raw_request_get_size8(const FuStructWacomRawRequest *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[7];
}
/**
 * fu_struct_wacom_raw_request_get_data: (skip):
 **/
const guint8 *
fu_struct_wacom_raw_request_get_data(const FuStructWacomRawRequest *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 128;
    return st->data + 8;
}
/**
 * fu_struct_wacom_raw_request_get_data_unused: (skip):
 **/
const guint8 *
fu_struct_wacom_raw_request_get_data_unused(const FuStructWacomRawRequest *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 121;
    return st->data + 136;
}

/* setters */
/**
 * fu_struct_wacom_raw_request_set_report_id: (skip):
 **/
void
fu_struct_wacom_raw_request_set_report_id(FuStructWacomRawRequest *st, FuWacomRawBlReportId value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_wacom_raw_request_set_cmd: (skip):
 **/
void
fu_struct_wacom_raw_request_set_cmd(FuStructWacomRawRequest *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_struct_wacom_raw_request_set_echo: (skip):
 **/
void
fu_struct_wacom_raw_request_set_echo(FuStructWacomRawRequest *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[2] = value;
}
/**
 * fu_struct_wacom_raw_request_set_addr: (skip):
 **/
void
fu_struct_wacom_raw_request_set_addr(FuStructWacomRawRequest *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 3, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_wacom_raw_request_set_size8: (skip):
 **/
void
fu_struct_wacom_raw_request_set_size8(FuStructWacomRawRequest *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->data[7] = value;
}
/**
 * fu_struct_wacom_raw_request_set_data: (skip):
 **/
gboolean
fu_struct_wacom_raw_request_set_data(FuStructWacomRawRequest *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->data, st->len, 8, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_wacom_raw_request_set_data_unused: (skip):
 **/
gboolean
fu_struct_wacom_raw_request_set_data_unused(FuStructWacomRawRequest *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->data, st->len, 136, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_wacom_raw_request_new: (skip):
 **/
FuStructWacomRawRequest *
fu_struct_wacom_raw_request_new(void)
{
    FuStructWacomRawRequest *st = g_byte_array_sized_new(257);
    fu_byte_array_set_size(st, 257, 0x0);
    return st;
}
/* getters */
/**
 * fu_struct_wacom_raw_response_get_report_id: (skip):
 **/
FuWacomRawBlReportId
fu_struct_wacom_raw_response_get_report_id(const FuStructWacomRawResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_wacom_raw_response_get_cmd: (skip):
 **/
guint8
fu_struct_wacom_raw_response_get_cmd(const FuStructWacomRawResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_struct_wacom_raw_response_get_echo: (skip):
 **/
guint8
fu_struct_wacom_raw_response_get_echo(const FuStructWacomRawResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[2];
}
/**
 * fu_struct_wacom_raw_response_get_resp: (skip):
 **/
guint8
fu_struct_wacom_raw_response_get_resp(const FuStructWacomRawResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[3];
}

/* setters */
/**
 * fu_struct_wacom_raw_response_to_string: (skip):
 **/
static gchar *
fu_struct_wacom_raw_response_to_string(const FuStructWacomRawResponse *st)
{
    g_autoptr(GString) str = g_string_new("FuStructWacomRawResponse:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_wacom_raw_bl_report_id_to_string(fu_struct_wacom_raw_response_get_report_id(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  report_id: 0x%x [%s]\n", (guint) fu_struct_wacom_raw_response_get_report_id(st), tmp);
        } else {
            g_string_append_printf(str, "  report_id: 0x%x\n", (guint) fu_struct_wacom_raw_response_get_report_id(st));
        }
    }
    g_string_append_printf(str, "  cmd: 0x%x\n",
                           (guint) fu_struct_wacom_raw_response_get_cmd(st));
    g_string_append_printf(str, "  echo: 0x%x\n",
                           (guint) fu_struct_wacom_raw_response_get_echo(st));
    g_string_append_printf(str, "  resp: 0x%x\n",
                           (guint) fu_struct_wacom_raw_response_get_resp(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_wacom_raw_response_validate_internal(FuStructWacomRawResponse *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_wacom_raw_response_parse_internal(FuStructWacomRawResponse *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_wacom_raw_response_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_wacom_raw_response_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_wacom_raw_response_parse: (skip):
 **/
FuStructWacomRawResponse *
fu_struct_wacom_raw_response_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 136, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructWacomRawResponse: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 136);
    if (!fu_struct_wacom_raw_response_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_wacom_raw_bl_verify_response_get_report_id: (skip):
 **/
FuWacomRawBlReportId
fu_struct_wacom_raw_bl_verify_response_get_report_id(const FuStructWacomRawBlVerifyResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_wacom_raw_bl_verify_response_get_cmd: (skip):
 **/
FuWacomRawBlCmd
fu_struct_wacom_raw_bl_verify_response_get_cmd(const FuStructWacomRawBlVerifyResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}
/**
 * fu_struct_wacom_raw_bl_verify_response_get_echo: (skip):
 **/
guint8
fu_struct_wacom_raw_bl_verify_response_get_echo(const FuStructWacomRawBlVerifyResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[2];
}
/**
 * fu_struct_wacom_raw_bl_verify_response_get_addr: (skip):
 **/
guint32
fu_struct_wacom_raw_bl_verify_response_get_addr(const FuStructWacomRawBlVerifyResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 3, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_wacom_raw_bl_verify_response_get_size8: (skip):
 **/
guint8
fu_struct_wacom_raw_bl_verify_response_get_size8(const FuStructWacomRawBlVerifyResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[7];
}
/**
 * fu_struct_wacom_raw_bl_verify_response_get_pid: (skip):
 **/
guint16
fu_struct_wacom_raw_bl_verify_response_get_pid(const FuStructWacomRawBlVerifyResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 14, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_wacom_raw_bl_verify_response_to_string: (skip):
 **/
static gchar *
fu_struct_wacom_raw_bl_verify_response_to_string(const FuStructWacomRawBlVerifyResponse *st)
{
    g_autoptr(GString) str = g_string_new("FuStructWacomRawBlVerifyResponse:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_wacom_raw_bl_report_id_to_string(fu_struct_wacom_raw_bl_verify_response_get_report_id(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  report_id: 0x%x [%s]\n", (guint) fu_struct_wacom_raw_bl_verify_response_get_report_id(st), tmp);
        } else {
            g_string_append_printf(str, "  report_id: 0x%x\n", (guint) fu_struct_wacom_raw_bl_verify_response_get_report_id(st));
        }
    }
    {
        const gchar *tmp = fu_wacom_raw_bl_cmd_to_string(fu_struct_wacom_raw_bl_verify_response_get_cmd(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  cmd: 0x%x [%s]\n", (guint) fu_struct_wacom_raw_bl_verify_response_get_cmd(st), tmp);
        } else {
            g_string_append_printf(str, "  cmd: 0x%x\n", (guint) fu_struct_wacom_raw_bl_verify_response_get_cmd(st));
        }
    }
    g_string_append_printf(str, "  echo: 0x%x\n",
                           (guint) fu_struct_wacom_raw_bl_verify_response_get_echo(st));
    g_string_append_printf(str, "  addr: 0x%x\n",
                           (guint) fu_struct_wacom_raw_bl_verify_response_get_addr(st));
    g_string_append_printf(str, "  size8: 0x%x\n",
                           (guint) fu_struct_wacom_raw_bl_verify_response_get_size8(st));
    g_string_append_printf(str, "  pid: 0x%x\n",
                           (guint) fu_struct_wacom_raw_bl_verify_response_get_pid(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_wacom_raw_bl_verify_response_validate_internal(FuStructWacomRawBlVerifyResponse *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_wacom_raw_bl_verify_response_parse_internal(FuStructWacomRawBlVerifyResponse *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_wacom_raw_bl_verify_response_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_wacom_raw_bl_verify_response_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_wacom_raw_bl_verify_response_parse: (skip):
 **/
FuStructWacomRawBlVerifyResponse *
fu_struct_wacom_raw_bl_verify_response_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 136, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructWacomRawBlVerifyResponse: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 136);
    if (!fu_struct_wacom_raw_bl_verify_response_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_wacom_raw_fw_status_request_set_report_id: (skip):
 **/
static void
fu_struct_wacom_raw_fw_status_request_set_report_id(FuStructWacomRawFwStatusRequest *st, FuWacomRawFwReportId value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_wacom_raw_fw_status_request_new: (skip):
 **/
FuStructWacomRawFwStatusRequest *
fu_struct_wacom_raw_fw_status_request_new(void)
{
    FuStructWacomRawFwStatusRequest *st = g_byte_array_sized_new(16);
    fu_byte_array_set_size(st, 16, 0x0);
    fu_struct_wacom_raw_fw_status_request_set_report_id(st, FU_WACOM_RAW_FW_REPORT_ID_STATUS);
    return st;
}
/* getters */
/**
 * fu_struct_wacom_raw_fw_status_response_get_report_id: (skip):
 **/
static FuWacomRawFwReportId
fu_struct_wacom_raw_fw_status_response_get_report_id(const FuStructWacomRawFwStatusResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_wacom_raw_fw_status_response_get_version_major: (skip):
 **/
guint16
fu_struct_wacom_raw_fw_status_response_get_version_major(const FuStructWacomRawFwStatusResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 11, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_wacom_raw_fw_status_response_get_version_minor: (skip):
 **/
guint8
fu_struct_wacom_raw_fw_status_response_get_version_minor(const FuStructWacomRawFwStatusResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[13];
}

/* setters */
/**
 * fu_struct_wacom_raw_fw_status_response_to_string: (skip):
 **/
static gchar *
fu_struct_wacom_raw_fw_status_response_to_string(const FuStructWacomRawFwStatusResponse *st)
{
    g_autoptr(GString) str = g_string_new("FuStructWacomRawFwStatusResponse:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  version_major: 0x%x\n",
                           (guint) fu_struct_wacom_raw_fw_status_response_get_version_major(st));
    g_string_append_printf(str, "  version_minor: 0x%x\n",
                           (guint) fu_struct_wacom_raw_fw_status_response_get_version_minor(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_wacom_raw_fw_status_response_validate_internal(FuStructWacomRawFwStatusResponse *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_wacom_raw_fw_status_response_get_report_id(st) != FU_WACOM_RAW_FW_REPORT_ID_STATUS) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructWacomRawFwStatusResponse.report_id was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_wacom_raw_fw_status_response_parse_internal(FuStructWacomRawFwStatusResponse *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_wacom_raw_fw_status_response_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_wacom_raw_fw_status_response_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_wacom_raw_fw_status_response_parse: (skip):
 **/
FuStructWacomRawFwStatusResponse *
fu_struct_wacom_raw_fw_status_response_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 16, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructWacomRawFwStatusResponse: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 16);
    if (!fu_struct_wacom_raw_fw_status_response_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_wacom_raw_fw_detach_request_set_report_id: (skip):
 **/
static void
fu_struct_wacom_raw_fw_detach_request_set_report_id(FuStructWacomRawFwDetachRequest *st, FuWacomRawFwReportId value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_wacom_raw_fw_detach_request_set_cmd: (skip):
 **/
static void
fu_struct_wacom_raw_fw_detach_request_set_cmd(FuStructWacomRawFwDetachRequest *st, FuWacomRawFwCmd value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_struct_wacom_raw_fw_detach_request_new: (skip):
 **/
FuStructWacomRawFwDetachRequest *
fu_struct_wacom_raw_fw_detach_request_new(void)
{
    FuStructWacomRawFwDetachRequest *st = g_byte_array_sized_new(2);
    fu_byte_array_set_size(st, 2, 0x0);
    fu_struct_wacom_raw_fw_detach_request_set_report_id(st, FU_WACOM_RAW_FW_REPORT_ID_GENERAL);
    fu_struct_wacom_raw_fw_detach_request_set_cmd(st, FU_WACOM_RAW_FW_CMD_DETACH);
    return st;
}
/* getters */

/* setters */
/**
 * fu_struct_wacom_raw_fw_query_mode_request_set_report_id: (skip):
 **/
static void
fu_struct_wacom_raw_fw_query_mode_request_set_report_id(FuStructWacomRawFwQueryModeRequest *st, FuWacomRawFwReportId value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_wacom_raw_fw_query_mode_request_set_cmd: (skip):
 **/
static void
fu_struct_wacom_raw_fw_query_mode_request_set_cmd(FuStructWacomRawFwQueryModeRequest *st, FuWacomRawFwCmd value)
{
    g_return_if_fail(st != NULL);
    st->data[1] = value;
}
/**
 * fu_struct_wacom_raw_fw_query_mode_request_new: (skip):
 **/
FuStructWacomRawFwQueryModeRequest *
fu_struct_wacom_raw_fw_query_mode_request_new(void)
{
    FuStructWacomRawFwQueryModeRequest *st = g_byte_array_sized_new(2);
    fu_byte_array_set_size(st, 2, 0x0);
    fu_struct_wacom_raw_fw_query_mode_request_set_report_id(st, FU_WACOM_RAW_FW_REPORT_ID_GENERAL);
    fu_struct_wacom_raw_fw_query_mode_request_set_cmd(st, FU_WACOM_RAW_FW_CMD_QUERY_MODE);
    return st;
}
/* getters */
/**
 * fu_struct_wacom_raw_fw_query_mode_response_get_report_id: (skip):
 **/
static FuWacomRawFwReportId
fu_struct_wacom_raw_fw_query_mode_response_get_report_id(const FuStructWacomRawFwQueryModeResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_wacom_raw_fw_query_mode_response_get_mode: (skip):
 **/
FuWacomRawOperationMode
fu_struct_wacom_raw_fw_query_mode_response_get_mode(const FuStructWacomRawFwQueryModeResponse *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[1];
}

/* setters */
/**
 * fu_struct_wacom_raw_fw_query_mode_response_to_string: (skip):
 **/
static gchar *
fu_struct_wacom_raw_fw_query_mode_response_to_string(const FuStructWacomRawFwQueryModeResponse *st)
{
    g_autoptr(GString) str = g_string_new("FuStructWacomRawFwQueryModeResponse:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_wacom_raw_operation_mode_to_string(fu_struct_wacom_raw_fw_query_mode_response_get_mode(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  mode: 0x%x [%s]\n", (guint) fu_struct_wacom_raw_fw_query_mode_response_get_mode(st), tmp);
        } else {
            g_string_append_printf(str, "  mode: 0x%x\n", (guint) fu_struct_wacom_raw_fw_query_mode_response_get_mode(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_wacom_raw_fw_query_mode_response_validate_internal(FuStructWacomRawFwQueryModeResponse *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_wacom_raw_fw_query_mode_response_get_report_id(st) != FU_WACOM_RAW_FW_REPORT_ID_GENERAL) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructWacomRawFwQueryModeResponse.report_id was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_wacom_raw_fw_query_mode_response_parse_internal(FuStructWacomRawFwQueryModeResponse *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_wacom_raw_fw_query_mode_response_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_wacom_raw_fw_query_mode_response_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_wacom_raw_fw_query_mode_response_parse: (skip):
 **/
FuStructWacomRawFwQueryModeResponse *
fu_struct_wacom_raw_fw_query_mode_response_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 2, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructWacomRawFwQueryModeResponse: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 2);
    if (!fu_struct_wacom_raw_fw_query_mode_response_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
