/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM RTCTrackEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "DOMMediaStream.h"
#include "EventBinding.h"
#include "RTCTrackEvent.h"
#include "RTCTrackEventBinding.h"
#include "js/Array.h"
#include "js/ForOfIterator.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/MediaStreamTrack.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/RTCRtpReceiver.h"
#include "mozilla/dom/RTCRtpTransceiver.h"
#include "mozilla/dom/RTCTrackEvent.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(RTCTrackEvent)

NS_IMPL_ADDREF_INHERITED(RTCTrackEvent, Event)
NS_IMPL_RELEASE_INHERITED(RTCTrackEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(RTCTrackEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mReceiver)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mTrack)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mStreams)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mTransceiver)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(RTCTrackEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(RTCTrackEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mReceiver)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mTrack)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mStreams)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mTransceiver)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(RTCTrackEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

RTCTrackEvent::RTCTrackEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

RTCTrackEvent::~RTCTrackEvent()
{
}

RTCTrackEvent*
RTCTrackEvent::AsRTCTrackEvent()
{
  return this;
}

JSObject*
RTCTrackEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return RTCTrackEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<RTCTrackEvent>
RTCTrackEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const RTCTrackEventInit& aEventInitDict)
{
  RefPtr<RTCTrackEvent> e = new RTCTrackEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mReceiver = aEventInitDict.mReceiver;
  e->mTrack = aEventInitDict.mTrack;
  e->mStreams.AppendElements(aEventInitDict.mStreams);
  e->mTransceiver = aEventInitDict.mTransceiver;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<RTCTrackEvent>
RTCTrackEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const RTCTrackEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

RTCRtpReceiver*
RTCTrackEvent::Receiver() const
{
  return mReceiver;
}

MediaStreamTrack*
RTCTrackEvent::Track() const
{
  return mTrack;
}

void
RTCTrackEvent::GetStreams(nsTArray<RefPtr<DOMMediaStream>>& aRetVal) const
{
  aRetVal = mStreams.Clone();
}

RTCRtpTransceiver*
RTCTrackEvent::Transceiver() const
{
  return mTransceiver;
}


} // namespace mozilla::dom
