/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM ContentVisibilityAutoStateChangeEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "ContentVisibilityAutoStateChangeEvent.h"
#include "ContentVisibilityAutoStateChangeEventBinding.h"
#include "EventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/ContentVisibilityAutoStateChangeEvent.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


ContentVisibilityAutoStateChangeEvent::ContentVisibilityAutoStateChangeEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

ContentVisibilityAutoStateChangeEvent::~ContentVisibilityAutoStateChangeEvent()
{
}

ContentVisibilityAutoStateChangeEvent*
ContentVisibilityAutoStateChangeEvent::AsContentVisibilityAutoStateChangeEvent()
{
  return this;
}

JSObject*
ContentVisibilityAutoStateChangeEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return ContentVisibilityAutoStateChangeEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<ContentVisibilityAutoStateChangeEvent>
ContentVisibilityAutoStateChangeEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const ContentVisibilityAutoStateChangeEventInit& aEventInitDict)
{
  RefPtr<ContentVisibilityAutoStateChangeEvent> e = new ContentVisibilityAutoStateChangeEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mSkipped = aEventInitDict.mSkipped;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<ContentVisibilityAutoStateChangeEvent>
ContentVisibilityAutoStateChangeEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const ContentVisibilityAutoStateChangeEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

bool
ContentVisibilityAutoStateChangeEvent::Skipped() const
{
  return mSkipped;
}


} // namespace mozilla::dom
