/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM MediaRecorderErrorEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "MediaRecorderErrorEvent.h"
#include "MediaRecorderErrorEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/DOMException.h"
#include "mozilla/dom/MediaRecorderErrorEvent.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(MediaRecorderErrorEvent)

NS_IMPL_ADDREF_INHERITED(MediaRecorderErrorEvent, Event)
NS_IMPL_RELEASE_INHERITED(MediaRecorderErrorEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(MediaRecorderErrorEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mError)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(MediaRecorderErrorEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(MediaRecorderErrorEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mError)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(MediaRecorderErrorEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

MediaRecorderErrorEvent::MediaRecorderErrorEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

MediaRecorderErrorEvent::~MediaRecorderErrorEvent()
{
}

MediaRecorderErrorEvent*
MediaRecorderErrorEvent::AsMediaRecorderErrorEvent()
{
  return this;
}

JSObject*
MediaRecorderErrorEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return MediaRecorderErrorEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<MediaRecorderErrorEvent>
MediaRecorderErrorEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const MediaRecorderErrorEventInit& aEventInitDict)
{
  RefPtr<MediaRecorderErrorEvent> e = new MediaRecorderErrorEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mError = aEventInitDict.mError;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<MediaRecorderErrorEvent>
MediaRecorderErrorEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const MediaRecorderErrorEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

DOMException*
MediaRecorderErrorEvent::Error() const
{
  return mError;
}


} // namespace mozilla::dom
