/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at https://mozilla.org/MPL/2.0/. */

#ifndef mozilla_dom_RustTypes_h
#error "Don't include this file directly, include mozilla/dom/RustTypes.h instead"
#endif


#ifndef mozilla_dom_GeneratedElementDocumentState_h
#define mozilla_dom_GeneratedElementDocumentState_h

/* Generated with cbindgen:0.29.2 */

#include <cstdarg>
#include <cstdint>
#include <cstdlib>
#include <ostream>
#include <new>
#include "mozilla/Assertions.h"

namespace mozilla {
namespace dom {

constexpr static const uintptr_t HEADING_LEVEL_OFFSET = 52;

/// Event-based element states.
struct ElementState {
  uint64_t bits;

  constexpr explicit operator bool() const {
    return !!bits;
  }
  constexpr ElementState operator~() const {
    return ElementState { static_cast<decltype(bits)>(~bits) };
  }
  constexpr ElementState operator|(const ElementState& other) const {
    return ElementState { static_cast<decltype(bits)>(this->bits | other.bits) };
  }
  ElementState& operator|=(const ElementState& other) {
    *this = (*this | other);
    return *this;
  }
  constexpr ElementState operator&(const ElementState& other) const {
    return ElementState { static_cast<decltype(bits)>(this->bits & other.bits) };
  }
  ElementState& operator&=(const ElementState& other) {
    *this = (*this & other);
    return *this;
  }
  constexpr ElementState operator^(const ElementState& other) const {
    return ElementState { static_cast<decltype(bits)>(this->bits ^ other.bits) };
  }
  ElementState& operator^=(const ElementState& other) {
    *this = (*this ^ other);
    return *this;
  }
  bool operator==(const ElementState& other) const {
    return bits == other.bits;
  }
  bool operator!=(const ElementState& other) const {
    return bits != other.bits;
  }
  STATE_HELPERS(ElementState)
  static const ElementState ACTIVE;
  static const ElementState FOCUS;
  static const ElementState HOVER;
  static const ElementState ENABLED;
  static const ElementState DISABLED;
  static const ElementState CHECKED;
  static const ElementState INDETERMINATE;
  static const ElementState PLACEHOLDER_SHOWN;
  static const ElementState URLTARGET;
  static const ElementState FULLSCREEN;
  static const ElementState VALID;
  static const ElementState INVALID;
  static const ElementState USER_VALID;
  static const ElementState USER_INVALID;
  static const ElementState VALIDITY_STATES;
  static const ElementState BROKEN;
  static const ElementState REQUIRED;
  static const ElementState OPTIONAL_;
  static const ElementState DEFINED;
  static const ElementState VISITED;
  static const ElementState UNVISITED;
  static const ElementState VISITED_OR_UNVISITED;
  static const ElementState DRAGOVER;
  static const ElementState INRANGE;
  static const ElementState OUTOFRANGE;
  static const ElementState READONLY;
  static const ElementState READWRITE;
  static const ElementState DEFAULT;
  static const ElementState OPTIMUM;
  static const ElementState SUB_OPTIMUM;
  static const ElementState SUB_SUB_OPTIMUM;
  static const ElementState METER_OPTIMUM_STATES;
  static const ElementState INCREMENT_SCRIPT_LEVEL;
  static const ElementState FOCUSRING;
  static const ElementState FOCUS_WITHIN;
  static const ElementState LTR;
  static const ElementState RTL;
  static const ElementState HAS_DIR_ATTR;
  static const ElementState HAS_DIR_ATTR_LTR;
  static const ElementState HAS_DIR_ATTR_RTL;
  static const ElementState HAS_DIR_ATTR_LIKE_AUTO;
  static const ElementState AUTOFILL;
  static const ElementState AUTOFILL_PREVIEW;
  static const ElementState MODAL;
  static const ElementState INERT;
  static const ElementState TOPMOST_MODAL;
  static const ElementState DEVTOOLS_HIGHLIGHTED;
  static const ElementState STYLEEDITOR_TRANSITIONING;
  static const ElementState VALUE_EMPTY;
  static const ElementState REVEALED;
  static const ElementState POPOVER_OPEN;
  static const ElementState HAS_SLOTTED;
  static const ElementState OPEN;
  static const ElementState ACTIVE_VIEW_TRANSITION;
  static const ElementState SUPPRESS_FOR_PRINT_SELECTION;
  static const ElementState HEADING_LEVEL_BITS;
  static const ElementState DIR_STATES;
  static const ElementState DIR_ATTR_STATES;
  static const ElementState DISABLED_STATES;
  static const ElementState REQUIRED_STATES;
};
/// The mouse is down on this element.
/// <https://html.spec.whatwg.org/multipage/#selector-active>
/// FIXME(#7333): set/unset this when appropriate
constexpr inline const ElementState ElementState::ACTIVE = ElementState{
  /* .bits = */ (uint64_t)(1 << 0)
};
/// This element has focus.
/// <https://html.spec.whatwg.org/multipage/#selector-focus>
constexpr inline const ElementState ElementState::FOCUS = ElementState{
  /* .bits = */ (uint64_t)(1 << 1)
};
/// The mouse is hovering over this element.
/// <https://html.spec.whatwg.org/multipage/#selector-hover>
constexpr inline const ElementState ElementState::HOVER = ElementState{
  /* .bits = */ (uint64_t)(1 << 2)
};
/// Content is enabled (and can be disabled).
/// <http://www.whatwg.org/html/#selector-enabled>
constexpr inline const ElementState ElementState::ENABLED = ElementState{
  /* .bits = */ (uint64_t)(1 << 3)
};
/// Content is disabled.
/// <http://www.whatwg.org/html/#selector-disabled>
constexpr inline const ElementState ElementState::DISABLED = ElementState{
  /* .bits = */ (uint64_t)(1 << 4)
};
/// Content is checked.
/// <https://html.spec.whatwg.org/multipage/#selector-checked>
constexpr inline const ElementState ElementState::CHECKED = ElementState{
  /* .bits = */ (uint64_t)(1 << 5)
};
/// <https://html.spec.whatwg.org/multipage/#selector-indeterminate>
constexpr inline const ElementState ElementState::INDETERMINATE = ElementState{
  /* .bits = */ (uint64_t)(1 << 6)
};
/// <https://html.spec.whatwg.org/multipage/#selector-placeholder-shown>
constexpr inline const ElementState ElementState::PLACEHOLDER_SHOWN = ElementState{
  /* .bits = */ (uint64_t)(1 << 7)
};
/// <https://html.spec.whatwg.org/multipage/#selector-target>
constexpr inline const ElementState ElementState::URLTARGET = ElementState{
  /* .bits = */ (uint64_t)(1 << 8)
};
/// <https://fullscreen.spec.whatwg.org/#%3Afullscreen-pseudo-class>
constexpr inline const ElementState ElementState::FULLSCREEN = ElementState{
  /* .bits = */ (uint64_t)(1 << 9)
};
/// <https://html.spec.whatwg.org/multipage/#selector-valid>
constexpr inline const ElementState ElementState::VALID = ElementState{
  /* .bits = */ (uint64_t)(1 << 10)
};
/// <https://html.spec.whatwg.org/multipage/#selector-invalid>
constexpr inline const ElementState ElementState::INVALID = ElementState{
  /* .bits = */ (uint64_t)(1 << 11)
};
/// <https://drafts.csswg.org/selectors-4/#user-valid-pseudo>
constexpr inline const ElementState ElementState::USER_VALID = ElementState{
  /* .bits = */ (uint64_t)(1 << 12)
};
/// <https://drafts.csswg.org/selectors-4/#user-invalid-pseudo>
constexpr inline const ElementState ElementState::USER_INVALID = ElementState{
  /* .bits = */ (uint64_t)(1 << 13)
};
/// All the validity bits at once.
constexpr inline const ElementState ElementState::VALIDITY_STATES = ElementState{
  /* .bits = */ (uint64_t)((((ElementState::VALID).bits | (ElementState::INVALID).bits) | (ElementState::USER_VALID).bits) | (ElementState::USER_INVALID).bits)
};
/// Non-standard: https://developer.mozilla.org/en-US/docs/Web/CSS/:-moz-broken
constexpr inline const ElementState ElementState::BROKEN = ElementState{
  /* .bits = */ (uint64_t)(1 << 14)
};
/// <https://html.spec.whatwg.org/multipage/#selector-required>
constexpr inline const ElementState ElementState::REQUIRED = ElementState{
  /* .bits = */ (uint64_t)(1 << 15)
};
/// <https://html.spec.whatwg.org/multipage/#selector-optional>
/// We use an underscore to workaround a silly windows.h define.
constexpr inline const ElementState ElementState::OPTIONAL_ = ElementState{
  /* .bits = */ (uint64_t)(1 << 16)
};
/// <https://html.spec.whatwg.org/multipage/#selector-defined>
constexpr inline const ElementState ElementState::DEFINED = ElementState{
  /* .bits = */ (uint64_t)(1 << 17)
};
/// <https://html.spec.whatwg.org/multipage/#selector-visited>
constexpr inline const ElementState ElementState::VISITED = ElementState{
  /* .bits = */ (uint64_t)(1 << 18)
};
/// <https://html.spec.whatwg.org/multipage/#selector-link>
constexpr inline const ElementState ElementState::UNVISITED = ElementState{
  /* .bits = */ (uint64_t)(1 << 19)
};
/// <https://drafts.csswg.org/selectors-4/#the-any-link-pseudo>
constexpr inline const ElementState ElementState::VISITED_OR_UNVISITED = ElementState{
  /* .bits = */ (uint64_t)((ElementState::VISITED).bits | (ElementState::UNVISITED).bits)
};
/// Non-standard: https://developer.mozilla.org/en-US/docs/Web/CSS/:-moz-drag-over
constexpr inline const ElementState ElementState::DRAGOVER = ElementState{
  /* .bits = */ (uint64_t)(1 << 20)
};
/// <https://html.spec.whatwg.org/multipage/#selector-in-range>
constexpr inline const ElementState ElementState::INRANGE = ElementState{
  /* .bits = */ (uint64_t)(1 << 21)
};
/// <https://html.spec.whatwg.org/multipage/#selector-out-of-range>
constexpr inline const ElementState ElementState::OUTOFRANGE = ElementState{
  /* .bits = */ (uint64_t)(1 << 22)
};
/// <https://html.spec.whatwg.org/multipage/#selector-read-only>
constexpr inline const ElementState ElementState::READONLY = ElementState{
  /* .bits = */ (uint64_t)(1 << 23)
};
/// <https://html.spec.whatwg.org/multipage/#selector-read-write>
constexpr inline const ElementState ElementState::READWRITE = ElementState{
  /* .bits = */ (uint64_t)(1 << 24)
};
/// <https://html.spec.whatwg.org/multipage/#selector-default>
constexpr inline const ElementState ElementState::DEFAULT = ElementState{
  /* .bits = */ (uint64_t)(1 << 25)
};
/// Non-standard & undocumented.
constexpr inline const ElementState ElementState::OPTIMUM = ElementState{
  /* .bits = */ (uint64_t)(1 << 26)
};
/// Non-standard & undocumented.
constexpr inline const ElementState ElementState::SUB_OPTIMUM = ElementState{
  /* .bits = */ (uint64_t)(1 << 27)
};
/// Non-standard & undocumented.
constexpr inline const ElementState ElementState::SUB_SUB_OPTIMUM = ElementState{
  /* .bits = */ (uint64_t)(1 << 28)
};
/// All the above <meter> bits in one place.
constexpr inline const ElementState ElementState::METER_OPTIMUM_STATES = ElementState{
  /* .bits = */ (uint64_t)(((ElementState::OPTIMUM).bits | (ElementState::SUB_OPTIMUM).bits) | (ElementState::SUB_SUB_OPTIMUM).bits)
};
/// Non-standard & undocumented.
constexpr inline const ElementState ElementState::INCREMENT_SCRIPT_LEVEL = ElementState{
  /* .bits = */ (uint64_t)(1 << 29)
};
/// <https://drafts.csswg.org/selectors-4/#the-focus-visible-pseudo>
constexpr inline const ElementState ElementState::FOCUSRING = ElementState{
  /* .bits = */ (uint64_t)(1 << 30)
};
/// <https://drafts.csswg.org/selectors-4/#the-focus-within-pseudo>
constexpr inline const ElementState ElementState::FOCUS_WITHIN = ElementState{
  /* .bits = */ (uint64_t)(1ull << 31)
};
/// :dir matching; the states are used for dynamic change detection.
/// State that elements that match :dir(ltr) are in.
constexpr inline const ElementState ElementState::LTR = ElementState{
  /* .bits = */ (uint64_t)(1ull << 32)
};
/// State that elements that match :dir(rtl) are in.
constexpr inline const ElementState ElementState::RTL = ElementState{
  /* .bits = */ (uint64_t)(1ull << 33)
};
/// State that HTML elements that have a "dir" attr are in.
constexpr inline const ElementState ElementState::HAS_DIR_ATTR = ElementState{
  /* .bits = */ (uint64_t)(1ull << 34)
};
/// State that HTML elements with dir="ltr" (or something
/// case-insensitively equal to "ltr") are in.
constexpr inline const ElementState ElementState::HAS_DIR_ATTR_LTR = ElementState{
  /* .bits = */ (uint64_t)(1ull << 35)
};
/// State that HTML elements with dir="rtl" (or something
/// case-insensitively equal to "rtl") are in.
constexpr inline const ElementState ElementState::HAS_DIR_ATTR_RTL = ElementState{
  /* .bits = */ (uint64_t)(1ull << 36)
};
/// State that HTML <bdi> elements without a valid-valued "dir" attr or
/// any HTML elements (including <bdi>) with dir="auto" (or something
/// case-insensitively equal to "auto") are in.
constexpr inline const ElementState ElementState::HAS_DIR_ATTR_LIKE_AUTO = ElementState{
  /* .bits = */ (uint64_t)(1ull << 37)
};
/// Non-standard & undocumented.
constexpr inline const ElementState ElementState::AUTOFILL = ElementState{
  /* .bits = */ (uint64_t)(1ull << 38)
};
/// Non-standard & undocumented.
constexpr inline const ElementState ElementState::AUTOFILL_PREVIEW = ElementState{
  /* .bits = */ (uint64_t)(1ull << 39)
};
/// State for modal elements:
/// <https://drafts.csswg.org/selectors-4/#modal-state>
constexpr inline const ElementState ElementState::MODAL = ElementState{
  /* .bits = */ (uint64_t)(1ull << 40)
};
/// <https://html.spec.whatwg.org/multipage/#inert-subtrees>
constexpr inline const ElementState ElementState::INERT = ElementState{
  /* .bits = */ (uint64_t)(1ull << 41)
};
/// State for the topmost modal element in top layer
constexpr inline const ElementState ElementState::TOPMOST_MODAL = ElementState{
  /* .bits = */ (uint64_t)(1ull << 42)
};
/// Initially used for the devtools highlighter, but now somehow only
/// used for the devtools accessibility inspector.
constexpr inline const ElementState ElementState::DEVTOOLS_HIGHLIGHTED = ElementState{
  /* .bits = */ (uint64_t)(1ull << 43)
};
/// Used for the devtools style editor. Probably should go away.
constexpr inline const ElementState ElementState::STYLEEDITOR_TRANSITIONING = ElementState{
  /* .bits = */ (uint64_t)(1ull << 44)
};
/// For :-moz-value-empty (to show widgets like the reveal password
/// button or the clear button).
constexpr inline const ElementState ElementState::VALUE_EMPTY = ElementState{
  /* .bits = */ (uint64_t)(1ull << 45)
};
/// For :-moz-revealed.
constexpr inline const ElementState ElementState::REVEALED = ElementState{
  /* .bits = */ (uint64_t)(1ull << 46)
};
/// https://html.spec.whatwg.org/#selector-popover-open
/// Match element's popover visibility state of showing
constexpr inline const ElementState ElementState::POPOVER_OPEN = ElementState{
  /* .bits = */ (uint64_t)(1ull << 47)
};
/// https://drafts.csswg.org/css-scoping-1/#the-has-slotted-pseudo
/// Match whether a slot element has assigned nodes
constexpr inline const ElementState ElementState::HAS_SLOTTED = ElementState{
  /* .bits = */ (uint64_t)(1ull << 48)
};
/// https://drafts.csswg.org/selectors-4/#open-state
/// Match whether an openable element is currently open
constexpr inline const ElementState ElementState::OPEN = ElementState{
  /* .bits = */ (uint64_t)(1ull << 49)
};
/// For :active-view-transition.
/// <https://www.w3.org/TR/css-view-transitions-2/#the-active-view-transition-pseudo>
constexpr inline const ElementState ElementState::ACTIVE_VIEW_TRANSITION = ElementState{
  /* .bits = */ (uint64_t)(1ull << 50)
};
/// For :-moz-suppress-for-print-selection.
constexpr inline const ElementState ElementState::SUPPRESS_FOR_PRINT_SELECTION = ElementState{
  /* .bits = */ (uint64_t)(1ull << 51)
};
/// https://drafts.csswg.org/selectors-5/#headings
/// These 4 bits are used to pack the elements heading level into the element state
/// Heading levels can be from 1-9 so 4 bits allows us to express the full range.
constexpr inline const ElementState ElementState::HEADING_LEVEL_BITS = ElementState{
  /* .bits = */ (uint64_t)(15ull << HEADING_LEVEL_OFFSET)
};
/// Some convenience unions.
constexpr inline const ElementState ElementState::DIR_STATES = ElementState{
  /* .bits = */ (uint64_t)((ElementState::LTR).bits | (ElementState::RTL).bits)
};
constexpr inline const ElementState ElementState::DIR_ATTR_STATES = ElementState{
  /* .bits = */ (uint64_t)((((ElementState::HAS_DIR_ATTR).bits | (ElementState::HAS_DIR_ATTR_LTR).bits) | (ElementState::HAS_DIR_ATTR_RTL).bits) | (ElementState::HAS_DIR_ATTR_LIKE_AUTO).bits)
};
constexpr inline const ElementState ElementState::DISABLED_STATES = ElementState{
  /* .bits = */ (uint64_t)((ElementState::DISABLED).bits | (ElementState::ENABLED).bits)
};
constexpr inline const ElementState ElementState::REQUIRED_STATES = ElementState{
  /* .bits = */ (uint64_t)((ElementState::REQUIRED).bits | (ElementState::OPTIONAL_).bits)
};

/// Event-based document states.
struct DocumentState {
  uint64_t bits;

  constexpr explicit operator bool() const {
    return !!bits;
  }
  constexpr DocumentState operator~() const {
    return DocumentState { static_cast<decltype(bits)>(~bits) };
  }
  constexpr DocumentState operator|(const DocumentState& other) const {
    return DocumentState { static_cast<decltype(bits)>(this->bits | other.bits) };
  }
  DocumentState& operator|=(const DocumentState& other) {
    *this = (*this | other);
    return *this;
  }
  constexpr DocumentState operator&(const DocumentState& other) const {
    return DocumentState { static_cast<decltype(bits)>(this->bits & other.bits) };
  }
  DocumentState& operator&=(const DocumentState& other) {
    *this = (*this & other);
    return *this;
  }
  constexpr DocumentState operator^(const DocumentState& other) const {
    return DocumentState { static_cast<decltype(bits)>(this->bits ^ other.bits) };
  }
  DocumentState& operator^=(const DocumentState& other) {
    *this = (*this ^ other);
    return *this;
  }
  bool operator==(const DocumentState& other) const {
    return bits == other.bits;
  }
  bool operator!=(const DocumentState& other) const {
    return bits != other.bits;
  }
  STATE_HELPERS(DocumentState)
  static const DocumentState WINDOW_INACTIVE;
  static const DocumentState RTL_LOCALE;
  static const DocumentState LTR_LOCALE;
  static const DocumentState ALL_LOCALEDIR_BITS;
};
/// Window activation status
constexpr inline const DocumentState DocumentState::WINDOW_INACTIVE = DocumentState{
  /* .bits = */ (uint64_t)(1 << 0)
};
/// RTL locale: specific to the XUL localedir attribute
constexpr inline const DocumentState DocumentState::RTL_LOCALE = DocumentState{
  /* .bits = */ (uint64_t)(1 << 1)
};
/// LTR locale: specific to the XUL localedir attribute
constexpr inline const DocumentState DocumentState::LTR_LOCALE = DocumentState{
  /* .bits = */ (uint64_t)(1 << 2)
};
constexpr inline const DocumentState DocumentState::ALL_LOCALEDIR_BITS = DocumentState{
  /* .bits = */ (uint64_t)((DocumentState::LTR_LOCALE).bits | (DocumentState::RTL_LOCALE).bits)
};

}  // namespace dom
}  // namespace mozilla

#endif  // mozilla_dom_GeneratedElementDocumentState_h
