/* message_storage.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from message_storage.vala, do not modify */

#include "libdino.h"
#include <glib-object.h>
#include <glib.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include "qlite.h"
#include "xmpp-vala.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	DINO_MESSAGE_STORAGE_0_PROPERTY,
	DINO_MESSAGE_STORAGE_ID_PROPERTY,
	DINO_MESSAGE_STORAGE_NUM_PROPERTIES
};
static GParamSpec* dino_message_storage_properties[DINO_MESSAGE_STORAGE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _qlite_database_unref0(var) ((var == NULL) ? NULL : (var = (qlite_database_unref (var), NULL)))
#define _qlite_statement_builder_unref0(var) ((var == NULL) ? NULL : (var = (qlite_statement_builder_unref (var), NULL)))
#define _qlite_row_unref0(var) ((var == NULL) ? NULL : (var = (qlite_row_unref (var), NULL)))
#define _qlite_row_iterator_unref0(var) ((var == NULL) ? NULL : (var = (qlite_row_iterator_unref (var), NULL)))
#define _qlite_row_option_unref0(var) ((var == NULL) ? NULL : (var = (qlite_row_option_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _DinoMessageStoragePrivate {
	DinoStreamInteractor* stream_interactor;
	DinoDatabase* db;
	WeakMap* messages_by_db_id;
	GeeHashMap* messages_by_stanza_id;
	GeeHashMap* messages_by_server_id;
	GeeLinkedList* message_refs;
};

static gint DinoMessageStorage_private_offset;
static gpointer dino_message_storage_parent_class = NULL;
DinoModuleIdentity* dino_message_storage_IDENTITY = NULL;
static DinoStreamInteractionModuleIface * dino_message_storage_dino_stream_interaction_module_parent_iface = NULL;

static guint _dino_entities_conversation_hash_func_gee_hash_data_func (gconstpointer v,
                                                                gpointer self);
static gboolean _dino_entities_conversation_equals_func_gee_equal_data_func (gconstpointer a,
                                                                      gconstpointer b,
                                                                      gpointer self);
static DinoMessageStorage* dino_message_storage_new (DinoStreamInteractor* stream_interactor,
                                              DinoDatabase* db);
static DinoMessageStorage* dino_message_storage_construct (GType object_type,
                                                    DinoStreamInteractor* stream_interactor,
                                                    DinoDatabase* db);
static void dino_message_storage_cache_message (DinoMessageStorage* self,
                                         DinoEntitiesMessage* message,
                                         DinoEntitiesConversation* conversation);
static gboolean _dino_entities_message_equals_func_gee_equal_data_func (gconstpointer a,
                                                                 gconstpointer b,
                                                                 gpointer self);
static DinoEntitiesMessage* dino_message_storage_create_message_from_row (DinoMessageStorage* self,
                                                                   QliteRow* row,
                                                                   DinoEntitiesConversation* conversation);
static DinoEntitiesMessage* dino_message_storage_create_message_from_row_opt (DinoMessageStorage* self,
                                                                       QliteRowOption* row_option,
                                                                       DinoEntitiesConversation* conversation);
static void dino_message_storage_finalize (GObject * obj);
static GType dino_message_storage_get_type_once (void);
static void _vala_dino_message_storage_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
dino_message_storage_get_instance_private (DinoMessageStorage* self)
{
	return G_STRUCT_MEMBER_P (self, DinoMessageStorage_private_offset);
}

static guint
_dino_entities_conversation_hash_func_gee_hash_data_func (gconstpointer v,
                                                          gpointer self)
{
	guint result;
	result = dino_entities_conversation_hash_func ((DinoEntitiesConversation*) v);
	return result;
}

static gboolean
_dino_entities_conversation_equals_func_gee_equal_data_func (gconstpointer a,
                                                             gconstpointer b,
                                                             gpointer self)
{
	gboolean result;
	result = dino_entities_conversation_equals_func ((DinoEntitiesConversation*) a, (DinoEntitiesConversation*) b);
	return result;
}

void
dino_message_storage_start (DinoStreamInteractor* stream_interactor,
                            DinoDatabase* db)
{
	DinoMessageStorage* m = NULL;
	DinoMessageStorage* _tmp0_;
	g_return_if_fail (stream_interactor != NULL);
	g_return_if_fail (db != NULL);
	_tmp0_ = dino_message_storage_new (stream_interactor, db);
	m = _tmp0_;
	dino_stream_interactor_add_module (stream_interactor, (DinoStreamInteractionModule*) m);
	_g_object_unref0 (m);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_qlite_database_ref0 (gpointer self)
{
	return self ? qlite_database_ref (self) : NULL;
}

static DinoMessageStorage*
dino_message_storage_construct (GType object_type,
                                DinoStreamInteractor* stream_interactor,
                                DinoDatabase* db)
{
	DinoMessageStorage * self = NULL;
	DinoStreamInteractor* _tmp0_;
	DinoDatabase* _tmp1_;
	g_return_val_if_fail (stream_interactor != NULL, NULL);
	g_return_val_if_fail (db != NULL, NULL);
	self = (DinoMessageStorage*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (stream_interactor);
	_g_object_unref0 (self->priv->stream_interactor);
	self->priv->stream_interactor = _tmp0_;
	_tmp1_ = _qlite_database_ref0 (db);
	_qlite_database_unref0 (self->priv->db);
	self->priv->db = _tmp1_;
	return self;
}

static DinoMessageStorage*
dino_message_storage_new (DinoStreamInteractor* stream_interactor,
                          DinoDatabase* db)
{
	return dino_message_storage_construct (DINO_TYPE_MESSAGE_STORAGE, stream_interactor, db);
}

void
dino_message_storage_add_message (DinoMessageStorage* self,
                                  DinoEntitiesMessage* message,
                                  DinoEntitiesConversation* conversation)
{
	DinoDatabase* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (conversation != NULL);
	_tmp0_ = self->priv->db;
	dino_entities_message_persist (message, _tmp0_);
	dino_message_storage_cache_message (self, message, conversation);
}

static gboolean
_dino_entities_message_equals_func_gee_equal_data_func (gconstpointer a,
                                                        gconstpointer b,
                                                        gpointer self)
{
	gboolean result;
	result = dino_entities_message_equals_func ((DinoEntitiesMessage*) a, (DinoEntitiesMessage*) b);
	return result;
}

GeeList*
dino_message_storage_get_messages (DinoMessageStorage* self,
                                   DinoEntitiesConversation* conversation,
                                   gint count)
{
	QliteQueryBuilder* query = NULL;
	DinoDatabase* _tmp0_;
	DinoDatabaseMessageTable* _tmp1_;
	DinoDatabaseMessageTable* _tmp2_;
	QliteQueryBuilder* _tmp3_;
	QliteQueryBuilder* _tmp4_;
	DinoDatabase* _tmp5_;
	DinoDatabaseMessageTable* _tmp6_;
	DinoDatabaseMessageTable* _tmp7_;
	QliteColumn* _tmp8_;
	DinoEntitiesAccount* _tmp9_;
	DinoEntitiesAccount* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	QliteQueryBuilder* _tmp13_;
	QliteQueryBuilder* _tmp14_;
	DinoDatabase* _tmp15_;
	DinoDatabaseMessageTable* _tmp16_;
	DinoDatabaseMessageTable* _tmp17_;
	QliteColumn* _tmp18_;
	DinoDatabase* _tmp19_;
	XmppJid* _tmp20_;
	XmppJid* _tmp21_;
	QliteQueryBuilder* _tmp22_;
	QliteQueryBuilder* _tmp23_;
	DinoDatabase* _tmp24_;
	DinoDatabaseMessageTable* _tmp25_;
	DinoDatabaseMessageTable* _tmp26_;
	QliteColumn* _tmp27_;
	QliteQueryBuilder* _tmp28_;
	QliteQueryBuilder* _tmp29_;
	DinoDatabase* _tmp30_;
	DinoDatabaseMessageTable* _tmp31_;
	DinoDatabaseMessageTable* _tmp32_;
	QliteColumn* _tmp33_;
	QliteQueryBuilder* _tmp34_;
	QliteQueryBuilder* _tmp35_;
	DinoDatabase* _tmp36_;
	DinoDatabaseMessageCorrectionTable* _tmp37_;
	DinoDatabaseMessageCorrectionTable* _tmp38_;
	DinoDatabase* _tmp39_;
	DinoDatabaseMessageCorrectionTable* _tmp40_;
	DinoDatabaseMessageCorrectionTable* _tmp41_;
	QliteColumn* _tmp42_;
	DinoDatabase* _tmp43_;
	DinoDatabaseMessageTable* _tmp44_;
	DinoDatabaseMessageTable* _tmp45_;
	QliteColumn* _tmp46_;
	QliteQueryBuilder* _tmp47_;
	QliteQueryBuilder* _tmp48_;
	DinoDatabase* _tmp49_;
	DinoDatabaseReplyTable* _tmp50_;
	DinoDatabaseReplyTable* _tmp51_;
	DinoDatabase* _tmp52_;
	DinoDatabaseReplyTable* _tmp53_;
	DinoDatabaseReplyTable* _tmp54_;
	QliteColumn* _tmp55_;
	DinoDatabase* _tmp56_;
	DinoDatabaseMessageTable* _tmp57_;
	DinoDatabaseMessageTable* _tmp58_;
	QliteColumn* _tmp59_;
	QliteQueryBuilder* _tmp60_;
	QliteQueryBuilder* _tmp61_;
	QliteQueryBuilder* _tmp62_;
	QliteQueryBuilder* _tmp63_;
	GeeList* ret = NULL;
	GeeLinkedList* _tmp64_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (conversation != NULL, NULL);
	_tmp0_ = self->priv->db;
	_tmp1_ = dino_database_get_message (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = qlite_table_select ((QliteTable*) _tmp2_, NULL, (gint) 0);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->priv->db;
	_tmp6_ = dino_database_get_message (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = _tmp7_->account_id;
	_tmp9_ = dino_entities_conversation_get_account (conversation);
	_tmp10_ = _tmp9_;
	_tmp11_ = dino_entities_account_get_id (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = qlite_query_builder_with (_tmp4_, G_TYPE_INT, NULL, NULL, _tmp8_, "=", (gpointer) ((gintptr) _tmp12_));
	_tmp14_ = _tmp13_;
	_tmp15_ = self->priv->db;
	_tmp16_ = dino_database_get_message (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = _tmp17_->counterpart_id;
	_tmp19_ = self->priv->db;
	_tmp20_ = dino_entities_conversation_get_counterpart (conversation);
	_tmp21_ = _tmp20_;
	_tmp22_ = qlite_query_builder_with (_tmp14_, G_TYPE_INT, NULL, NULL, _tmp18_, "=", (gpointer) ((gintptr) dino_database_get_jid_id (_tmp19_, _tmp21_)));
	_tmp23_ = _tmp22_;
	_tmp24_ = self->priv->db;
	_tmp25_ = dino_database_get_message (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = _tmp26_->type_;
	_tmp28_ = qlite_query_builder_with (_tmp23_, G_TYPE_INT, NULL, NULL, _tmp27_, "=", (gpointer) ((gintptr) dino_util_get_message_type_for_conversation (conversation)));
	_tmp29_ = _tmp28_;
	_tmp30_ = self->priv->db;
	_tmp31_ = dino_database_get_message (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = _tmp32_->time;
	_tmp34_ = qlite_query_builder_order_by (_tmp29_, _tmp33_, "DESC");
	_tmp35_ = _tmp34_;
	_tmp36_ = self->priv->db;
	_tmp37_ = dino_database_get_message_correction (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = self->priv->db;
	_tmp40_ = dino_database_get_message_correction (_tmp39_);
	_tmp41_ = _tmp40_;
	_tmp42_ = _tmp41_->message_id;
	_tmp43_ = self->priv->db;
	_tmp44_ = dino_database_get_message (_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = _tmp45_->id;
	_tmp47_ = qlite_query_builder_outer_join_with (_tmp35_, G_TYPE_INT, NULL, NULL, (QliteTable*) _tmp38_, _tmp42_, _tmp46_, NULL);
	_tmp48_ = _tmp47_;
	_tmp49_ = self->priv->db;
	_tmp50_ = dino_database_get_reply (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = self->priv->db;
	_tmp53_ = dino_database_get_reply (_tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = _tmp54_->message_id;
	_tmp56_ = self->priv->db;
	_tmp57_ = dino_database_get_message (_tmp56_);
	_tmp58_ = _tmp57_;
	_tmp59_ = _tmp58_->id;
	_tmp60_ = qlite_query_builder_outer_join_with (_tmp48_, G_TYPE_INT, NULL, NULL, (QliteTable*) _tmp51_, _tmp55_, _tmp59_, NULL);
	_tmp61_ = _tmp60_;
	_tmp62_ = qlite_query_builder_limit (_tmp61_, count);
	_tmp63_ = _tmp62_;
	_qlite_statement_builder_unref0 (_tmp61_);
	_qlite_statement_builder_unref0 (_tmp48_);
	_qlite_statement_builder_unref0 (_tmp35_);
	_qlite_statement_builder_unref0 (_tmp29_);
	_qlite_statement_builder_unref0 (_tmp23_);
	_qlite_statement_builder_unref0 (_tmp14_);
	_qlite_statement_builder_unref0 (_tmp4_);
	query = _tmp63_;
	_tmp64_ = gee_linked_list_new (DINO_ENTITIES_TYPE_MESSAGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _dino_entities_message_equals_func_gee_equal_data_func, NULL, NULL);
	ret = (GeeList*) _tmp64_;
	{
		QliteRowIterator* _row_it = NULL;
		QliteQueryBuilder* _tmp65_;
		QliteRowIterator* _tmp66_;
		_tmp65_ = query;
		_tmp66_ = qlite_query_builder_iterator (_tmp65_);
		_row_it = _tmp66_;
		while (TRUE) {
			QliteRowIterator* _tmp67_;
			QliteRow* row = NULL;
			QliteRowIterator* _tmp68_;
			QliteRow* _tmp69_;
			DinoEntitiesMessage* message = NULL;
			WeakMap* _tmp70_;
			QliteRow* _tmp71_;
			DinoDatabase* _tmp72_;
			DinoDatabaseMessageTable* _tmp73_;
			DinoDatabaseMessageTable* _tmp74_;
			QliteColumn* _tmp75_;
			gpointer _tmp76_;
			gpointer _tmp77_;
			DinoEntitiesMessage* _tmp78_;
			GeeList* _tmp81_;
			DinoEntitiesMessage* _tmp82_;
			_tmp67_ = _row_it;
			if (!qlite_row_iterator_next (_tmp67_)) {
				break;
			}
			_tmp68_ = _row_it;
			_tmp69_ = qlite_row_iterator_get (_tmp68_);
			row = _tmp69_;
			_tmp70_ = self->priv->messages_by_db_id;
			_tmp71_ = row;
			_tmp72_ = self->priv->db;
			_tmp73_ = dino_database_get_message (_tmp72_);
			_tmp74_ = _tmp73_;
			_tmp75_ = _tmp74_->id;
			_tmp76_ = qlite_row_get (_tmp71_, G_TYPE_INT, NULL, NULL, _tmp75_);
			_tmp77_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp70_, (gpointer) ((gintptr) _tmp76_));
			message = (DinoEntitiesMessage*) _tmp77_;
			_tmp78_ = message;
			if (_tmp78_ == NULL) {
				QliteRow* _tmp79_;
				DinoEntitiesMessage* _tmp80_;
				_tmp79_ = row;
				_tmp80_ = dino_message_storage_create_message_from_row (self, _tmp79_, conversation);
				_g_object_unref0 (message);
				message = _tmp80_;
			}
			_tmp81_ = ret;
			_tmp82_ = message;
			gee_list_insert (_tmp81_, 0, _tmp82_);
			_g_object_unref0 (message);
			_qlite_row_unref0 (row);
		}
		_qlite_row_iterator_unref0 (_row_it);
	}
	result = ret;
	_qlite_statement_builder_unref0 (query);
	return result;
}

DinoEntitiesMessage*
dino_message_storage_get_last_message (DinoMessageStorage* self,
                                       DinoEntitiesConversation* conversation)
{
	GeeList* messages = NULL;
	GeeList* _tmp0_;
	GeeList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	DinoEntitiesMessage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (conversation != NULL, NULL);
	_tmp0_ = dino_message_storage_get_messages (self, conversation, 1);
	messages = _tmp0_;
	_tmp1_ = messages;
	_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ > 0) {
		GeeList* _tmp4_;
		gpointer _tmp5_;
		_tmp4_ = messages;
		_tmp5_ = gee_list_get (_tmp4_, 0);
		result = (DinoEntitiesMessage*) _tmp5_;
		_g_object_unref0 (messages);
		return result;
	}
	result = NULL;
	_g_object_unref0 (messages);
	return result;
}

GeeList*
dino_message_storage_get_messages_before_message (DinoMessageStorage* self,
                                                  DinoEntitiesConversation* conversation,
                                                  GDateTime* before,
                                                  gint id,
                                                  gint count)
{
	GeeList* db_messages = NULL;
	DinoDatabase* _tmp0_;
	XmppJid* _tmp1_;
	XmppJid* _tmp2_;
	DinoEntitiesAccount* _tmp3_;
	DinoEntitiesAccount* _tmp4_;
	DinoEntitiesMessageType _tmp5_;
	GeeList* _tmp6_;
	GeeList* ret = NULL;
	GeeArrayList* _tmp7_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (before != NULL, NULL);
	_tmp0_ = self->priv->db;
	_tmp1_ = dino_entities_conversation_get_counterpart (conversation);
	_tmp2_ = _tmp1_;
	_tmp3_ = dino_entities_conversation_get_account (conversation);
	_tmp4_ = _tmp3_;
	_tmp5_ = dino_util_get_message_type_for_conversation (conversation);
	_tmp6_ = dino_database_get_messages (_tmp0_, _tmp2_, _tmp4_, &_tmp5_, count, before, NULL, id);
	db_messages = _tmp6_;
	_tmp7_ = gee_array_list_new (DINO_TYPE_MESSAGE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	ret = (GeeList*) _tmp7_;
	{
		GeeList* _message_list = NULL;
		GeeList* _tmp8_;
		gint _message_size = 0;
		GeeList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _message_index = 0;
		_tmp8_ = db_messages;
		_message_list = _tmp8_;
		_tmp9_ = _message_list;
		_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_message_size = _tmp11_;
		_message_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			DinoEntitiesMessage* message = NULL;
			GeeList* _tmp14_;
			gpointer _tmp15_;
			GeeList* _tmp16_;
			DinoEntitiesMessage* _tmp17_;
			DinoMessageItem* _tmp18_;
			DinoMessageItem* _tmp19_;
			_message_index = _message_index + 1;
			_tmp12_ = _message_index;
			_tmp13_ = _message_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _message_list;
			_tmp15_ = gee_list_get (_tmp14_, _message_index);
			message = (DinoEntitiesMessage*) _tmp15_;
			_tmp16_ = ret;
			_tmp17_ = message;
			_tmp18_ = dino_message_item_new (_tmp17_, conversation, -1);
			_tmp19_ = _tmp18_;
			gee_collection_add ((GeeCollection*) _tmp16_, _tmp19_);
			_g_object_unref0 (_tmp19_);
			_g_object_unref0 (message);
		}
	}
	result = ret;
	_g_object_unref0 (db_messages);
	return result;
}

GeeList*
dino_message_storage_get_messages_after_message (DinoMessageStorage* self,
                                                 DinoEntitiesConversation* conversation,
                                                 GDateTime* after,
                                                 gint id,
                                                 gint count)
{
	GeeList* db_messages = NULL;
	DinoDatabase* _tmp0_;
	XmppJid* _tmp1_;
	XmppJid* _tmp2_;
	DinoEntitiesAccount* _tmp3_;
	DinoEntitiesAccount* _tmp4_;
	DinoEntitiesMessageType _tmp5_;
	GeeList* _tmp6_;
	GeeList* ret = NULL;
	GeeArrayList* _tmp7_;
	GeeList* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (after != NULL, NULL);
	_tmp0_ = self->priv->db;
	_tmp1_ = dino_entities_conversation_get_counterpart (conversation);
	_tmp2_ = _tmp1_;
	_tmp3_ = dino_entities_conversation_get_account (conversation);
	_tmp4_ = _tmp3_;
	_tmp5_ = dino_util_get_message_type_for_conversation (conversation);
	_tmp6_ = dino_database_get_messages (_tmp0_, _tmp2_, _tmp4_, &_tmp5_, count, NULL, after, id);
	db_messages = _tmp6_;
	_tmp7_ = gee_array_list_new (DINO_TYPE_MESSAGE_ITEM, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	ret = (GeeList*) _tmp7_;
	{
		GeeList* _message_list = NULL;
		GeeList* _tmp8_;
		gint _message_size = 0;
		GeeList* _tmp9_;
		gint _tmp10_;
		gint _tmp11_;
		gint _message_index = 0;
		_tmp8_ = db_messages;
		_message_list = _tmp8_;
		_tmp9_ = _message_list;
		_tmp10_ = gee_collection_get_size ((GeeCollection*) _tmp9_);
		_tmp11_ = _tmp10_;
		_message_size = _tmp11_;
		_message_index = -1;
		while (TRUE) {
			gint _tmp12_;
			gint _tmp13_;
			DinoEntitiesMessage* message = NULL;
			GeeList* _tmp14_;
			gpointer _tmp15_;
			GeeList* _tmp16_;
			DinoEntitiesMessage* _tmp17_;
			DinoMessageItem* _tmp18_;
			DinoMessageItem* _tmp19_;
			_message_index = _message_index + 1;
			_tmp12_ = _message_index;
			_tmp13_ = _message_size;
			if (!(_tmp12_ < _tmp13_)) {
				break;
			}
			_tmp14_ = _message_list;
			_tmp15_ = gee_list_get (_tmp14_, _message_index);
			message = (DinoEntitiesMessage*) _tmp15_;
			_tmp16_ = ret;
			_tmp17_ = message;
			_tmp18_ = dino_message_item_new (_tmp17_, conversation, -1);
			_tmp19_ = _tmp18_;
			gee_collection_add ((GeeCollection*) _tmp16_, _tmp19_);
			_g_object_unref0 (_tmp19_);
			_g_object_unref0 (message);
		}
	}
	result = ret;
	_g_object_unref0 (db_messages);
	return result;
}

DinoEntitiesMessage*
dino_message_storage_get_message_by_id (DinoMessageStorage* self,
                                        gint id,
                                        DinoEntitiesConversation* conversation)
{
	DinoEntitiesMessage* message = NULL;
	WeakMap* _tmp0_;
	gpointer _tmp1_;
	DinoEntitiesMessage* _tmp2_;
	QliteRowOption* row_option = NULL;
	DinoDatabase* _tmp3_;
	DinoDatabaseMessageTable* _tmp4_;
	DinoDatabaseMessageTable* _tmp5_;
	QliteQueryBuilder* _tmp6_;
	QliteQueryBuilder* _tmp7_;
	DinoDatabase* _tmp8_;
	DinoDatabaseMessageTable* _tmp9_;
	DinoDatabaseMessageTable* _tmp10_;
	QliteColumn* _tmp11_;
	QliteQueryBuilder* _tmp12_;
	QliteQueryBuilder* _tmp13_;
	DinoDatabase* _tmp14_;
	DinoDatabaseMessageCorrectionTable* _tmp15_;
	DinoDatabaseMessageCorrectionTable* _tmp16_;
	DinoDatabase* _tmp17_;
	DinoDatabaseMessageCorrectionTable* _tmp18_;
	DinoDatabaseMessageCorrectionTable* _tmp19_;
	QliteColumn* _tmp20_;
	DinoDatabase* _tmp21_;
	DinoDatabaseMessageTable* _tmp22_;
	DinoDatabaseMessageTable* _tmp23_;
	QliteColumn* _tmp24_;
	QliteQueryBuilder* _tmp25_;
	QliteQueryBuilder* _tmp26_;
	DinoDatabase* _tmp27_;
	DinoDatabaseReplyTable* _tmp28_;
	DinoDatabaseReplyTable* _tmp29_;
	DinoDatabase* _tmp30_;
	DinoDatabaseReplyTable* _tmp31_;
	DinoDatabaseReplyTable* _tmp32_;
	QliteColumn* _tmp33_;
	DinoDatabase* _tmp34_;
	DinoDatabaseMessageTable* _tmp35_;
	DinoDatabaseMessageTable* _tmp36_;
	QliteColumn* _tmp37_;
	QliteQueryBuilder* _tmp38_;
	QliteQueryBuilder* _tmp39_;
	QliteRowOption* _tmp40_;
	QliteRowOption* _tmp41_;
	QliteRowOption* _tmp42_;
	DinoEntitiesMessage* _tmp43_;
	DinoEntitiesMessage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (conversation != NULL, NULL);
	_tmp0_ = self->priv->messages_by_db_id;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) id));
	message = (DinoEntitiesMessage*) _tmp1_;
	_tmp2_ = message;
	if (_tmp2_ != NULL) {
		result = message;
		return result;
	}
	_tmp3_ = self->priv->db;
	_tmp4_ = dino_database_get_message (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = qlite_table_select ((QliteTable*) _tmp5_, NULL, (gint) 0);
	_tmp7_ = _tmp6_;
	_tmp8_ = self->priv->db;
	_tmp9_ = dino_database_get_message (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_->id;
	_tmp12_ = qlite_query_builder_with (_tmp7_, G_TYPE_INT, NULL, NULL, _tmp11_, "=", (gpointer) ((gintptr) id));
	_tmp13_ = _tmp12_;
	_tmp14_ = self->priv->db;
	_tmp15_ = dino_database_get_message_correction (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = self->priv->db;
	_tmp18_ = dino_database_get_message_correction (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = _tmp19_->message_id;
	_tmp21_ = self->priv->db;
	_tmp22_ = dino_database_get_message (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = _tmp23_->id;
	_tmp25_ = qlite_query_builder_outer_join_with (_tmp13_, G_TYPE_INT, NULL, NULL, (QliteTable*) _tmp16_, _tmp20_, _tmp24_, NULL);
	_tmp26_ = _tmp25_;
	_tmp27_ = self->priv->db;
	_tmp28_ = dino_database_get_reply (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = self->priv->db;
	_tmp31_ = dino_database_get_reply (_tmp30_);
	_tmp32_ = _tmp31_;
	_tmp33_ = _tmp32_->message_id;
	_tmp34_ = self->priv->db;
	_tmp35_ = dino_database_get_message (_tmp34_);
	_tmp36_ = _tmp35_;
	_tmp37_ = _tmp36_->id;
	_tmp38_ = qlite_query_builder_outer_join_with (_tmp26_, G_TYPE_INT, NULL, NULL, (QliteTable*) _tmp29_, _tmp33_, _tmp37_, NULL);
	_tmp39_ = _tmp38_;
	_tmp40_ = qlite_query_builder_row (_tmp39_);
	_tmp41_ = _tmp40_;
	_qlite_statement_builder_unref0 (_tmp39_);
	_qlite_statement_builder_unref0 (_tmp26_);
	_qlite_statement_builder_unref0 (_tmp13_);
	_qlite_statement_builder_unref0 (_tmp7_);
	row_option = _tmp41_;
	_tmp42_ = row_option;
	_tmp43_ = dino_message_storage_create_message_from_row_opt (self, _tmp42_, conversation);
	result = _tmp43_;
	_qlite_row_option_unref0 (row_option);
	_g_object_unref0 (message);
	return result;
}

DinoEntitiesMessage*
dino_message_storage_get_message_by_referencing_id (DinoMessageStorage* self,
                                                    const gchar* id,
                                                    DinoEntitiesConversation* conversation)
{
	DinoEntitiesConversationType _tmp0_;
	DinoEntitiesConversationType _tmp1_;
	DinoEntitiesMessage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (id != NULL, NULL);
	g_return_val_if_fail (conversation != NULL, NULL);
	_tmp0_ = dino_entities_conversation_get_type_ (conversation);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == DINO_ENTITIES_CONVERSATION_TYPE_CHAT) {
		DinoStreamInteractor* _tmp2_;
		DinoModuleIdentity* _tmp3_;
		gpointer _tmp4_;
		DinoMessageStorage* _tmp5_;
		DinoEntitiesMessage* _tmp6_;
		DinoEntitiesMessage* _tmp7_;
		_tmp2_ = self->priv->stream_interactor;
		_tmp3_ = dino_message_storage_IDENTITY;
		_tmp4_ = dino_stream_interactor_get_module (_tmp2_, DINO_TYPE_MESSAGE_STORAGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp3_);
		_tmp5_ = (DinoMessageStorage*) _tmp4_;
		_tmp6_ = dino_message_storage_get_message_by_stanza_id (_tmp5_, id, conversation);
		_tmp7_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
		result = _tmp7_;
		return result;
	} else {
		DinoStreamInteractor* _tmp8_;
		DinoModuleIdentity* _tmp9_;
		gpointer _tmp10_;
		DinoMessageStorage* _tmp11_;
		DinoEntitiesMessage* _tmp12_;
		DinoEntitiesMessage* _tmp13_;
		_tmp8_ = self->priv->stream_interactor;
		_tmp9_ = dino_message_storage_IDENTITY;
		_tmp10_ = dino_stream_interactor_get_module (_tmp8_, DINO_TYPE_MESSAGE_STORAGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _tmp9_);
		_tmp11_ = (DinoMessageStorage*) _tmp10_;
		_tmp12_ = dino_message_storage_get_message_by_server_id (_tmp11_, id, conversation);
		_tmp13_ = _tmp12_;
		_g_object_unref0 (_tmp11_);
		result = _tmp13_;
		return result;
	}
}

DinoEntitiesMessage*
dino_message_storage_get_message_by_stanza_id (DinoMessageStorage* self,
                                               const gchar* stanza_id,
                                               DinoEntitiesConversation* conversation)
{
	GeeHashMap* _tmp0_;
	QliteQueryBuilder* query = NULL;
	DinoDatabase* _tmp7_;
	DinoDatabaseMessageTable* _tmp8_;
	DinoDatabaseMessageTable* _tmp9_;
	QliteQueryBuilder* _tmp10_;
	QliteQueryBuilder* _tmp11_;
	DinoDatabase* _tmp12_;
	DinoDatabaseMessageTable* _tmp13_;
	DinoDatabaseMessageTable* _tmp14_;
	QliteColumn* _tmp15_;
	DinoEntitiesAccount* _tmp16_;
	DinoEntitiesAccount* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	QliteQueryBuilder* _tmp20_;
	QliteQueryBuilder* _tmp21_;
	DinoDatabase* _tmp22_;
	DinoDatabaseMessageTable* _tmp23_;
	DinoDatabaseMessageTable* _tmp24_;
	QliteColumn* _tmp25_;
	DinoDatabase* _tmp26_;
	XmppJid* _tmp27_;
	XmppJid* _tmp28_;
	QliteQueryBuilder* _tmp29_;
	QliteQueryBuilder* _tmp30_;
	DinoDatabase* _tmp31_;
	DinoDatabaseMessageTable* _tmp32_;
	DinoDatabaseMessageTable* _tmp33_;
	QliteColumn* _tmp34_;
	QliteQueryBuilder* _tmp35_;
	QliteQueryBuilder* _tmp36_;
	DinoDatabase* _tmp37_;
	DinoDatabaseMessageTable* _tmp38_;
	DinoDatabaseMessageTable* _tmp39_;
	QliteColumn* _tmp40_;
	QliteQueryBuilder* _tmp41_;
	QliteQueryBuilder* _tmp42_;
	DinoDatabase* _tmp43_;
	DinoDatabaseMessageTable* _tmp44_;
	DinoDatabaseMessageTable* _tmp45_;
	QliteColumn* _tmp46_;
	QliteQueryBuilder* _tmp47_;
	QliteQueryBuilder* _tmp48_;
	DinoDatabase* _tmp49_;
	DinoDatabaseMessageCorrectionTable* _tmp50_;
	DinoDatabaseMessageCorrectionTable* _tmp51_;
	DinoDatabase* _tmp52_;
	DinoDatabaseMessageCorrectionTable* _tmp53_;
	DinoDatabaseMessageCorrectionTable* _tmp54_;
	QliteColumn* _tmp55_;
	DinoDatabase* _tmp56_;
	DinoDatabaseMessageTable* _tmp57_;
	DinoDatabaseMessageTable* _tmp58_;
	QliteColumn* _tmp59_;
	QliteQueryBuilder* _tmp60_;
	QliteQueryBuilder* _tmp61_;
	DinoDatabase* _tmp62_;
	DinoDatabaseReplyTable* _tmp63_;
	DinoDatabaseReplyTable* _tmp64_;
	DinoDatabase* _tmp65_;
	DinoDatabaseReplyTable* _tmp66_;
	DinoDatabaseReplyTable* _tmp67_;
	QliteColumn* _tmp68_;
	DinoDatabase* _tmp69_;
	DinoDatabaseMessageTable* _tmp70_;
	DinoDatabaseMessageTable* _tmp71_;
	QliteColumn* _tmp72_;
	QliteQueryBuilder* _tmp73_;
	QliteQueryBuilder* _tmp74_;
	XmppJid* _tmp75_;
	XmppJid* _tmp76_;
	const gchar* _tmp77_;
	QliteRowOption* row_option = NULL;
	QliteQueryBuilder* _tmp88_;
	QliteQueryBuilder* _tmp89_;
	QliteQueryBuilder* _tmp90_;
	QliteRowOption* _tmp91_;
	QliteRowOption* _tmp92_;
	QliteRowOption* _tmp93_;
	DinoEntitiesMessage* _tmp94_;
	DinoEntitiesMessage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (stanza_id != NULL, NULL);
	g_return_val_if_fail (conversation != NULL, NULL);
	_tmp0_ = self->priv->messages_by_stanza_id;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, conversation)) {
		DinoEntitiesMessage* message = NULL;
		GeeHashMap* _tmp1_;
		gpointer _tmp2_;
		WeakMap* _tmp3_;
		gpointer _tmp4_;
		DinoEntitiesMessage* _tmp5_;
		DinoEntitiesMessage* _tmp6_;
		_tmp1_ = self->priv->messages_by_stanza_id;
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, conversation);
		_tmp3_ = (WeakMap*) _tmp2_;
		_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, stanza_id);
		_tmp5_ = (DinoEntitiesMessage*) _tmp4_;
		_g_object_unref0 (_tmp3_);
		message = _tmp5_;
		_tmp6_ = message;
		if (_tmp6_ != NULL) {
			result = message;
			return result;
		}
		_g_object_unref0 (message);
	}
	_tmp7_ = self->priv->db;
	_tmp8_ = dino_database_get_message (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = qlite_table_select ((QliteTable*) _tmp9_, NULL, (gint) 0);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->db;
	_tmp13_ = dino_database_get_message (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_->account_id;
	_tmp16_ = dino_entities_conversation_get_account (conversation);
	_tmp17_ = _tmp16_;
	_tmp18_ = dino_entities_account_get_id (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = qlite_query_builder_with (_tmp11_, G_TYPE_INT, NULL, NULL, _tmp15_, "=", (gpointer) ((gintptr) _tmp19_));
	_tmp21_ = _tmp20_;
	_tmp22_ = self->priv->db;
	_tmp23_ = dino_database_get_message (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = _tmp24_->counterpart_id;
	_tmp26_ = self->priv->db;
	_tmp27_ = dino_entities_conversation_get_counterpart (conversation);
	_tmp28_ = _tmp27_;
	_tmp29_ = qlite_query_builder_with (_tmp21_, G_TYPE_INT, NULL, NULL, _tmp25_, "=", (gpointer) ((gintptr) dino_database_get_jid_id (_tmp26_, _tmp28_)));
	_tmp30_ = _tmp29_;
	_tmp31_ = self->priv->db;
	_tmp32_ = dino_database_get_message (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp33_->type_;
	_tmp35_ = qlite_query_builder_with (_tmp30_, G_TYPE_INT, NULL, NULL, _tmp34_, "=", (gpointer) ((gintptr) dino_util_get_message_type_for_conversation (conversation)));
	_tmp36_ = _tmp35_;
	_tmp37_ = self->priv->db;
	_tmp38_ = dino_database_get_message (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = _tmp39_->stanza_id;
	_tmp41_ = qlite_query_builder_with (_tmp36_, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp40_, "=", stanza_id);
	_tmp42_ = _tmp41_;
	_tmp43_ = self->priv->db;
	_tmp44_ = dino_database_get_message (_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = _tmp45_->time;
	_tmp47_ = qlite_query_builder_order_by (_tmp42_, _tmp46_, "DESC");
	_tmp48_ = _tmp47_;
	_tmp49_ = self->priv->db;
	_tmp50_ = dino_database_get_message_correction (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = self->priv->db;
	_tmp53_ = dino_database_get_message_correction (_tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = _tmp54_->message_id;
	_tmp56_ = self->priv->db;
	_tmp57_ = dino_database_get_message (_tmp56_);
	_tmp58_ = _tmp57_;
	_tmp59_ = _tmp58_->id;
	_tmp60_ = qlite_query_builder_outer_join_with (_tmp48_, G_TYPE_INT, NULL, NULL, (QliteTable*) _tmp51_, _tmp55_, _tmp59_, NULL);
	_tmp61_ = _tmp60_;
	_tmp62_ = self->priv->db;
	_tmp63_ = dino_database_get_reply (_tmp62_);
	_tmp64_ = _tmp63_;
	_tmp65_ = self->priv->db;
	_tmp66_ = dino_database_get_reply (_tmp65_);
	_tmp67_ = _tmp66_;
	_tmp68_ = _tmp67_->message_id;
	_tmp69_ = self->priv->db;
	_tmp70_ = dino_database_get_message (_tmp69_);
	_tmp71_ = _tmp70_;
	_tmp72_ = _tmp71_->id;
	_tmp73_ = qlite_query_builder_outer_join_with (_tmp61_, G_TYPE_INT, NULL, NULL, (QliteTable*) _tmp64_, _tmp68_, _tmp72_, NULL);
	_tmp74_ = _tmp73_;
	_qlite_statement_builder_unref0 (_tmp61_);
	_qlite_statement_builder_unref0 (_tmp48_);
	_qlite_statement_builder_unref0 (_tmp42_);
	_qlite_statement_builder_unref0 (_tmp36_);
	_qlite_statement_builder_unref0 (_tmp30_);
	_qlite_statement_builder_unref0 (_tmp21_);
	_qlite_statement_builder_unref0 (_tmp11_);
	query = _tmp74_;
	_tmp75_ = dino_entities_conversation_get_counterpart (conversation);
	_tmp76_ = _tmp75_;
	_tmp77_ = _tmp76_->resourcepart;
	if (_tmp77_ != NULL) {
		QliteQueryBuilder* _tmp78_;
		DinoDatabase* _tmp79_;
		DinoDatabaseMessageTable* _tmp80_;
		DinoDatabaseMessageTable* _tmp81_;
		QliteColumn* _tmp82_;
		XmppJid* _tmp83_;
		XmppJid* _tmp84_;
		const gchar* _tmp85_;
		QliteQueryBuilder* _tmp86_;
		QliteQueryBuilder* _tmp87_;
		_tmp78_ = query;
		_tmp79_ = self->priv->db;
		_tmp80_ = dino_database_get_message (_tmp79_);
		_tmp81_ = _tmp80_;
		_tmp82_ = _tmp81_->counterpart_resource;
		_tmp83_ = dino_entities_conversation_get_counterpart (conversation);
		_tmp84_ = _tmp83_;
		_tmp85_ = _tmp84_->resourcepart;
		_tmp86_ = qlite_query_builder_with (_tmp78_, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp82_, "=", _tmp85_);
		_tmp87_ = _tmp86_;
		_qlite_statement_builder_unref0 (_tmp87_);
	}
	_tmp88_ = query;
	_tmp89_ = qlite_query_builder_single (_tmp88_);
	_tmp90_ = _tmp89_;
	_tmp91_ = qlite_query_builder_row (_tmp90_);
	_tmp92_ = _tmp91_;
	_qlite_statement_builder_unref0 (_tmp90_);
	row_option = _tmp92_;
	_tmp93_ = row_option;
	_tmp94_ = dino_message_storage_create_message_from_row_opt (self, _tmp93_, conversation);
	result = _tmp94_;
	_qlite_row_option_unref0 (row_option);
	_qlite_statement_builder_unref0 (query);
	return result;
}

DinoEntitiesMessage*
dino_message_storage_get_message_by_server_id (DinoMessageStorage* self,
                                               const gchar* server_id,
                                               DinoEntitiesConversation* conversation)
{
	GeeHashMap* _tmp0_;
	QliteQueryBuilder* query = NULL;
	DinoDatabase* _tmp7_;
	DinoDatabaseMessageTable* _tmp8_;
	DinoDatabaseMessageTable* _tmp9_;
	QliteQueryBuilder* _tmp10_;
	QliteQueryBuilder* _tmp11_;
	DinoDatabase* _tmp12_;
	DinoDatabaseMessageTable* _tmp13_;
	DinoDatabaseMessageTable* _tmp14_;
	QliteColumn* _tmp15_;
	DinoEntitiesAccount* _tmp16_;
	DinoEntitiesAccount* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	QliteQueryBuilder* _tmp20_;
	QliteQueryBuilder* _tmp21_;
	DinoDatabase* _tmp22_;
	DinoDatabaseMessageTable* _tmp23_;
	DinoDatabaseMessageTable* _tmp24_;
	QliteColumn* _tmp25_;
	DinoDatabase* _tmp26_;
	XmppJid* _tmp27_;
	XmppJid* _tmp28_;
	QliteQueryBuilder* _tmp29_;
	QliteQueryBuilder* _tmp30_;
	DinoDatabase* _tmp31_;
	DinoDatabaseMessageTable* _tmp32_;
	DinoDatabaseMessageTable* _tmp33_;
	QliteColumn* _tmp34_;
	QliteQueryBuilder* _tmp35_;
	QliteQueryBuilder* _tmp36_;
	DinoDatabase* _tmp37_;
	DinoDatabaseMessageTable* _tmp38_;
	DinoDatabaseMessageTable* _tmp39_;
	QliteColumn* _tmp40_;
	QliteQueryBuilder* _tmp41_;
	QliteQueryBuilder* _tmp42_;
	DinoDatabase* _tmp43_;
	DinoDatabaseMessageTable* _tmp44_;
	DinoDatabaseMessageTable* _tmp45_;
	QliteColumn* _tmp46_;
	QliteQueryBuilder* _tmp47_;
	QliteQueryBuilder* _tmp48_;
	DinoDatabase* _tmp49_;
	DinoDatabaseMessageCorrectionTable* _tmp50_;
	DinoDatabaseMessageCorrectionTable* _tmp51_;
	DinoDatabase* _tmp52_;
	DinoDatabaseMessageCorrectionTable* _tmp53_;
	DinoDatabaseMessageCorrectionTable* _tmp54_;
	QliteColumn* _tmp55_;
	DinoDatabase* _tmp56_;
	DinoDatabaseMessageTable* _tmp57_;
	DinoDatabaseMessageTable* _tmp58_;
	QliteColumn* _tmp59_;
	QliteQueryBuilder* _tmp60_;
	QliteQueryBuilder* _tmp61_;
	DinoDatabase* _tmp62_;
	DinoDatabaseReplyTable* _tmp63_;
	DinoDatabaseReplyTable* _tmp64_;
	DinoDatabase* _tmp65_;
	DinoDatabaseReplyTable* _tmp66_;
	DinoDatabaseReplyTable* _tmp67_;
	QliteColumn* _tmp68_;
	DinoDatabase* _tmp69_;
	DinoDatabaseMessageTable* _tmp70_;
	DinoDatabaseMessageTable* _tmp71_;
	QliteColumn* _tmp72_;
	QliteQueryBuilder* _tmp73_;
	QliteQueryBuilder* _tmp74_;
	XmppJid* _tmp75_;
	XmppJid* _tmp76_;
	const gchar* _tmp77_;
	QliteRowOption* row_option = NULL;
	QliteQueryBuilder* _tmp95_;
	QliteQueryBuilder* _tmp96_;
	QliteQueryBuilder* _tmp97_;
	QliteRowOption* _tmp98_;
	QliteRowOption* _tmp99_;
	QliteRowOption* _tmp100_;
	DinoEntitiesMessage* _tmp101_;
	DinoEntitiesMessage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (server_id != NULL, NULL);
	g_return_val_if_fail (conversation != NULL, NULL);
	_tmp0_ = self->priv->messages_by_server_id;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, conversation)) {
		DinoEntitiesMessage* message = NULL;
		GeeHashMap* _tmp1_;
		gpointer _tmp2_;
		WeakMap* _tmp3_;
		gpointer _tmp4_;
		DinoEntitiesMessage* _tmp5_;
		DinoEntitiesMessage* _tmp6_;
		_tmp1_ = self->priv->messages_by_server_id;
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, conversation);
		_tmp3_ = (WeakMap*) _tmp2_;
		_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, server_id);
		_tmp5_ = (DinoEntitiesMessage*) _tmp4_;
		_g_object_unref0 (_tmp3_);
		message = _tmp5_;
		_tmp6_ = message;
		if (_tmp6_ != NULL) {
			result = message;
			return result;
		}
		_g_object_unref0 (message);
	}
	_tmp7_ = self->priv->db;
	_tmp8_ = dino_database_get_message (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = qlite_table_select ((QliteTable*) _tmp9_, NULL, (gint) 0);
	_tmp11_ = _tmp10_;
	_tmp12_ = self->priv->db;
	_tmp13_ = dino_database_get_message (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = _tmp14_->account_id;
	_tmp16_ = dino_entities_conversation_get_account (conversation);
	_tmp17_ = _tmp16_;
	_tmp18_ = dino_entities_account_get_id (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = qlite_query_builder_with (_tmp11_, G_TYPE_INT, NULL, NULL, _tmp15_, "=", (gpointer) ((gintptr) _tmp19_));
	_tmp21_ = _tmp20_;
	_tmp22_ = self->priv->db;
	_tmp23_ = dino_database_get_message (_tmp22_);
	_tmp24_ = _tmp23_;
	_tmp25_ = _tmp24_->counterpart_id;
	_tmp26_ = self->priv->db;
	_tmp27_ = dino_entities_conversation_get_counterpart (conversation);
	_tmp28_ = _tmp27_;
	_tmp29_ = qlite_query_builder_with (_tmp21_, G_TYPE_INT, NULL, NULL, _tmp25_, "=", (gpointer) ((gintptr) dino_database_get_jid_id (_tmp26_, _tmp28_)));
	_tmp30_ = _tmp29_;
	_tmp31_ = self->priv->db;
	_tmp32_ = dino_database_get_message (_tmp31_);
	_tmp33_ = _tmp32_;
	_tmp34_ = _tmp33_->type_;
	_tmp35_ = qlite_query_builder_with (_tmp30_, G_TYPE_INT, NULL, NULL, _tmp34_, "=", (gpointer) ((gintptr) dino_util_get_message_type_for_conversation (conversation)));
	_tmp36_ = _tmp35_;
	_tmp37_ = self->priv->db;
	_tmp38_ = dino_database_get_message (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = _tmp39_->server_id;
	_tmp41_ = qlite_query_builder_with (_tmp36_, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp40_, "=", server_id);
	_tmp42_ = _tmp41_;
	_tmp43_ = self->priv->db;
	_tmp44_ = dino_database_get_message (_tmp43_);
	_tmp45_ = _tmp44_;
	_tmp46_ = _tmp45_->time;
	_tmp47_ = qlite_query_builder_order_by (_tmp42_, _tmp46_, "DESC");
	_tmp48_ = _tmp47_;
	_tmp49_ = self->priv->db;
	_tmp50_ = dino_database_get_message_correction (_tmp49_);
	_tmp51_ = _tmp50_;
	_tmp52_ = self->priv->db;
	_tmp53_ = dino_database_get_message_correction (_tmp52_);
	_tmp54_ = _tmp53_;
	_tmp55_ = _tmp54_->message_id;
	_tmp56_ = self->priv->db;
	_tmp57_ = dino_database_get_message (_tmp56_);
	_tmp58_ = _tmp57_;
	_tmp59_ = _tmp58_->id;
	_tmp60_ = qlite_query_builder_outer_join_with (_tmp48_, G_TYPE_INT, NULL, NULL, (QliteTable*) _tmp51_, _tmp55_, _tmp59_, NULL);
	_tmp61_ = _tmp60_;
	_tmp62_ = self->priv->db;
	_tmp63_ = dino_database_get_reply (_tmp62_);
	_tmp64_ = _tmp63_;
	_tmp65_ = self->priv->db;
	_tmp66_ = dino_database_get_reply (_tmp65_);
	_tmp67_ = _tmp66_;
	_tmp68_ = _tmp67_->message_id;
	_tmp69_ = self->priv->db;
	_tmp70_ = dino_database_get_message (_tmp69_);
	_tmp71_ = _tmp70_;
	_tmp72_ = _tmp71_->id;
	_tmp73_ = qlite_query_builder_outer_join_with (_tmp61_, G_TYPE_INT, NULL, NULL, (QliteTable*) _tmp64_, _tmp68_, _tmp72_, NULL);
	_tmp74_ = _tmp73_;
	_qlite_statement_builder_unref0 (_tmp61_);
	_qlite_statement_builder_unref0 (_tmp48_);
	_qlite_statement_builder_unref0 (_tmp42_);
	_qlite_statement_builder_unref0 (_tmp36_);
	_qlite_statement_builder_unref0 (_tmp30_);
	_qlite_statement_builder_unref0 (_tmp21_);
	_qlite_statement_builder_unref0 (_tmp11_);
	query = _tmp74_;
	_tmp75_ = dino_entities_conversation_get_counterpart (conversation);
	_tmp76_ = _tmp75_;
	_tmp77_ = _tmp76_->resourcepart;
	if (_tmp77_ == NULL) {
		QliteQueryBuilder* _tmp78_;
		DinoDatabase* _tmp79_;
		DinoDatabaseMessageTable* _tmp80_;
		DinoDatabaseMessageTable* _tmp81_;
		QliteColumn* _tmp82_;
		QliteQueryBuilder* _tmp83_;
		QliteQueryBuilder* _tmp84_;
		_tmp78_ = query;
		_tmp79_ = self->priv->db;
		_tmp80_ = dino_database_get_message (_tmp79_);
		_tmp81_ = _tmp80_;
		_tmp82_ = _tmp81_->counterpart_resource;
		_tmp83_ = qlite_query_builder_with_null (_tmp78_, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp82_);
		_tmp84_ = _tmp83_;
		_qlite_statement_builder_unref0 (_tmp84_);
	} else {
		QliteQueryBuilder* _tmp85_;
		DinoDatabase* _tmp86_;
		DinoDatabaseMessageTable* _tmp87_;
		DinoDatabaseMessageTable* _tmp88_;
		QliteColumn* _tmp89_;
		XmppJid* _tmp90_;
		XmppJid* _tmp91_;
		const gchar* _tmp92_;
		QliteQueryBuilder* _tmp93_;
		QliteQueryBuilder* _tmp94_;
		_tmp85_ = query;
		_tmp86_ = self->priv->db;
		_tmp87_ = dino_database_get_message (_tmp86_);
		_tmp88_ = _tmp87_;
		_tmp89_ = _tmp88_->counterpart_resource;
		_tmp90_ = dino_entities_conversation_get_counterpart (conversation);
		_tmp91_ = _tmp90_;
		_tmp92_ = _tmp91_->resourcepart;
		_tmp93_ = qlite_query_builder_with (_tmp85_, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, _tmp89_, "=", _tmp92_);
		_tmp94_ = _tmp93_;
		_qlite_statement_builder_unref0 (_tmp94_);
	}
	_tmp95_ = query;
	_tmp96_ = qlite_query_builder_single (_tmp95_);
	_tmp97_ = _tmp96_;
	_tmp98_ = qlite_query_builder_row (_tmp97_);
	_tmp99_ = _tmp98_;
	_qlite_statement_builder_unref0 (_tmp97_);
	row_option = _tmp99_;
	_tmp100_ = row_option;
	_tmp101_ = dino_message_storage_create_message_from_row_opt (self, _tmp100_, conversation);
	result = _tmp101_;
	_qlite_row_option_unref0 (row_option);
	_qlite_statement_builder_unref0 (query);
	return result;
}

static DinoEntitiesMessage*
dino_message_storage_create_message_from_row_opt (DinoMessageStorage* self,
                                                  QliteRowOption* row_option,
                                                  DinoEntitiesConversation* conversation)
{
	QliteRow* _tmp0_;
	QliteRow* _tmp1_;
	DinoEntitiesMessage* _tmp2_;
	DinoEntitiesMessage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (row_option != NULL, NULL);
	g_return_val_if_fail (conversation != NULL, NULL);
	if (!qlite_row_option_is_present (row_option)) {
		result = NULL;
		return result;
	}
	_tmp0_ = qlite_row_option_get_inner (row_option);
	_tmp1_ = _tmp0_;
	_tmp2_ = dino_message_storage_create_message_from_row (self, _tmp1_, conversation);
	result = _tmp2_;
	return result;
}

static DinoEntitiesMessage*
dino_message_storage_create_message_from_row (DinoMessageStorage* self,
                                              QliteRow* row,
                                              DinoEntitiesConversation* conversation)
{
	GError* _inner_error0_ = NULL;
	DinoEntitiesMessage* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (row != NULL, NULL);
	g_return_val_if_fail (conversation != NULL, NULL);
	{
		DinoEntitiesMessage* message = NULL;
		DinoDatabase* _tmp0_;
		DinoEntitiesMessage* _tmp1_;
		_tmp0_ = self->priv->db;
		_tmp1_ = dino_entities_message_new_from_row (_tmp0_, row, &_inner_error0_);
		message = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == XMPP_INVALID_JID_ERROR) {
				goto __catch0_xmpp_invalid_jid_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		dino_message_storage_cache_message (self, message, conversation);
		result = message;
		return result;
	}
	goto __finally0;
	__catch0_xmpp_invalid_jid_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("message_storage.vala:175: Got message with invalid Jid: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = NULL;
	return result;
}

static void
dino_message_storage_cache_message (DinoMessageStorage* self,
                                    DinoEntitiesMessage* message,
                                    DinoEntitiesConversation* conversation)
{
	WeakMap* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	GeeLinkedList* _tmp25_;
	GeeLinkedList* _tmp26_;
	gint _tmp27_;
	gint _tmp28_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	g_return_if_fail (conversation != NULL);
	_tmp0_ = self->priv->messages_by_db_id;
	_tmp1_ = dino_entities_message_get_id (message);
	_tmp2_ = _tmp1_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) _tmp2_), message);
	_tmp3_ = dino_entities_message_get_stanza_id (message);
	_tmp4_ = _tmp3_;
	if (_tmp4_ != NULL) {
		GeeHashMap* _tmp5_;
		GeeHashMap* _tmp9_;
		gpointer _tmp10_;
		WeakMap* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp5_ = self->priv->messages_by_stanza_id;
		if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp5_, conversation)) {
			GeeHashMap* _tmp6_;
			WeakMap* _tmp7_;
			WeakMap* _tmp8_;
			_tmp6_ = self->priv->messages_by_stanza_id;
			_tmp7_ = weak_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, DINO_ENTITIES_TYPE_MESSAGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
			_tmp8_ = _tmp7_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp6_, conversation, _tmp8_);
			_g_object_unref0 (_tmp8_);
		}
		_tmp9_ = self->priv->messages_by_stanza_id;
		_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, conversation);
		_tmp11_ = (WeakMap*) _tmp10_;
		_tmp12_ = dino_entities_message_get_stanza_id (message);
		_tmp13_ = _tmp12_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp11_, _tmp13_, message);
		_g_object_unref0 (_tmp11_);
	}
	_tmp14_ = dino_entities_message_get_server_id (message);
	_tmp15_ = _tmp14_;
	if (_tmp15_ != NULL) {
		GeeHashMap* _tmp16_;
		GeeHashMap* _tmp20_;
		gpointer _tmp21_;
		WeakMap* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		_tmp16_ = self->priv->messages_by_server_id;
		if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp16_, conversation)) {
			GeeHashMap* _tmp17_;
			WeakMap* _tmp18_;
			WeakMap* _tmp19_;
			_tmp17_ = self->priv->messages_by_server_id;
			_tmp18_ = weak_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, DINO_ENTITIES_TYPE_MESSAGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
			_tmp19_ = _tmp18_;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp17_, conversation, _tmp19_);
			_g_object_unref0 (_tmp19_);
		}
		_tmp20_ = self->priv->messages_by_server_id;
		_tmp21_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp20_, conversation);
		_tmp22_ = (WeakMap*) _tmp21_;
		_tmp23_ = dino_entities_message_get_server_id (message);
		_tmp24_ = _tmp23_;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp22_, _tmp24_, message);
		_g_object_unref0 (_tmp22_);
	}
	_tmp25_ = self->priv->message_refs;
	gee_abstract_list_insert ((GeeAbstractList*) _tmp25_, 0, message);
	_tmp26_ = self->priv->message_refs;
	_tmp27_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp26_);
	_tmp28_ = _tmp27_;
	if (_tmp28_ > 300) {
		GeeLinkedList* _tmp29_;
		GeeLinkedList* _tmp30_;
		gint _tmp31_;
		gint _tmp32_;
		gpointer _tmp33_;
		DinoEntitiesMessage* _tmp34_;
		_tmp29_ = self->priv->message_refs;
		_tmp30_ = self->priv->message_refs;
		_tmp31_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp30_);
		_tmp32_ = _tmp31_;
		_tmp33_ = gee_abstract_list_remove_at ((GeeAbstractList*) _tmp29_, _tmp32_ - 1);
		_tmp34_ = (DinoEntitiesMessage*) _tmp33_;
		_g_object_unref0 (_tmp34_);
	}
}

gchar*
dino_message_storage_get_reference_id (DinoEntitiesMessage* message)
{
	const gchar* _tmp0_;
	DinoEntitiesMessageType _tmp3_;
	DinoEntitiesMessageType _tmp4_;
	gchar* result;
	g_return_val_if_fail (message != NULL, NULL);
	_tmp0_ = message->edit_to;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = message->edit_to;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = dino_entities_message_get_type_ (message);
	_tmp4_ = _tmp3_;
	if (_tmp4_ == DINO_ENTITIES_MESSAGE_TYPE_CHAT) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = dino_entities_message_get_stanza_id (message);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_strdup (_tmp6_);
		result = _tmp7_;
		return result;
	} else {
		const gchar* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = dino_entities_message_get_server_id (message);
		_tmp9_ = _tmp8_;
		_tmp10_ = g_strdup (_tmp9_);
		result = _tmp10_;
		return result;
	}
}

static const gchar*
dino_message_storage_real_get_id (DinoStreamInteractionModule* base)
{
	const gchar* result;
	DinoMessageStorage* self;
	DinoModuleIdentity* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	self = (DinoMessageStorage*) base;
	_tmp0_ = dino_message_storage_IDENTITY;
	_tmp1_ = dino_module_identity_get_id (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static void
dino_message_storage_class_init (DinoMessageStorageClass * klass,
                                 gpointer klass_data)
{
	DinoModuleIdentity* _tmp0_;
	dino_message_storage_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DinoMessageStorage_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_dino_message_storage_get_property;
	G_OBJECT_CLASS (klass)->finalize = dino_message_storage_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DINO_MESSAGE_STORAGE_ID_PROPERTY, dino_message_storage_properties[DINO_MESSAGE_STORAGE_ID_PROPERTY] = g_param_spec_string ("id", "id", "id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	_tmp0_ = dino_module_identity_new (DINO_TYPE_MESSAGE_STORAGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, "message_cache");
	dino_message_storage_IDENTITY = _tmp0_;
}

static void
dino_message_storage_dino_stream_interaction_module_interface_init (DinoStreamInteractionModuleIface * iface,
                                                                    gpointer iface_data)
{
	dino_message_storage_dino_stream_interaction_module_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_id = dino_message_storage_real_get_id;
}

static void
dino_message_storage_instance_init (DinoMessageStorage * self,
                                    gpointer klass)
{
	WeakMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeLinkedList* _tmp3_;
	self->priv = dino_message_storage_get_instance_private (self);
	_tmp0_ = weak_map_new (G_TYPE_INT, NULL, NULL, DINO_ENTITIES_TYPE_MESSAGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->messages_by_db_id = _tmp0_;
	_tmp1_ = gee_hash_map_new (DINO_ENTITIES_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_WEAK_MAP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _dino_entities_conversation_hash_func_gee_hash_data_func, NULL, NULL, _dino_entities_conversation_equals_func_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->messages_by_stanza_id = _tmp1_;
	_tmp2_ = gee_hash_map_new (DINO_ENTITIES_TYPE_CONVERSATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_WEAK_MAP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _dino_entities_conversation_hash_func_gee_hash_data_func, NULL, NULL, _dino_entities_conversation_equals_func_gee_equal_data_func, NULL, NULL, NULL, NULL, NULL);
	self->priv->messages_by_server_id = _tmp2_;
	_tmp3_ = gee_linked_list_new (DINO_ENTITIES_TYPE_MESSAGE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->message_refs = _tmp3_;
}

static void
dino_message_storage_finalize (GObject * obj)
{
	DinoMessageStorage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DINO_TYPE_MESSAGE_STORAGE, DinoMessageStorage);
	_g_object_unref0 (self->priv->stream_interactor);
	_qlite_database_unref0 (self->priv->db);
	_g_object_unref0 (self->priv->messages_by_db_id);
	_g_object_unref0 (self->priv->messages_by_stanza_id);
	_g_object_unref0 (self->priv->messages_by_server_id);
	_g_object_unref0 (self->priv->message_refs);
	G_OBJECT_CLASS (dino_message_storage_parent_class)->finalize (obj);
}

static GType
dino_message_storage_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DinoMessageStorageClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dino_message_storage_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DinoMessageStorage), 0, (GInstanceInitFunc) dino_message_storage_instance_init, NULL };
	static const GInterfaceInfo dino_stream_interaction_module_info = { (GInterfaceInitFunc) dino_message_storage_dino_stream_interaction_module_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType dino_message_storage_type_id;
	dino_message_storage_type_id = g_type_register_static (G_TYPE_OBJECT, "DinoMessageStorage", &g_define_type_info, 0);
	g_type_add_interface_static (dino_message_storage_type_id, DINO_TYPE_STREAM_INTERACTION_MODULE, &dino_stream_interaction_module_info);
	DinoMessageStorage_private_offset = g_type_add_instance_private (dino_message_storage_type_id, sizeof (DinoMessageStoragePrivate));
	return dino_message_storage_type_id;
}

GType
dino_message_storage_get_type (void)
{
	static volatile gsize dino_message_storage_type_id__once = 0;
	if (g_once_init_enter (&dino_message_storage_type_id__once)) {
		GType dino_message_storage_type_id;
		dino_message_storage_type_id = dino_message_storage_get_type_once ();
		g_once_init_leave (&dino_message_storage_type_id__once, dino_message_storage_type_id);
	}
	return dino_message_storage_type_id__once;
}

static void
_vala_dino_message_storage_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	DinoMessageStorage * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DINO_TYPE_MESSAGE_STORAGE, DinoMessageStorage);
	switch (property_id) {
		case DINO_MESSAGE_STORAGE_ID_PROPERTY:
		g_value_set_string (value, dino_stream_interaction_module_get_id ((DinoStreamInteractionModule*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

