/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.Arrays;
import java.util.Locale;
import org.apache.lucene.index.VectorEncoding;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.ByteVectorSimilarityFunction;
import org.apache.lucene.queries.function.valuesource.FloatVectorSimilarityFunction;
import org.apache.solr.common.SolrException;
import org.apache.solr.schema.DenseVectorField;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.FunctionQParser;
import org.apache.solr.search.StrParser;
import org.apache.solr.search.SyntaxError;
import org.apache.solr.search.ValueSourceParser;

public class VectorSimilaritySourceParser
extends ValueSourceParser {
    @Override
    public ValueSource parse(FunctionQParser fp) throws SyntaxError {
        String arg2Str;
        String arg1Str = fp.parseArg();
        if (arg1Str == null || !fp.hasMoreArguments()) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid number of arguments. Please provide either two or four arguments.");
        }
        String string = arg2Str = this.peekIsConstVector(fp) ? null : fp.parseArg();
        if (fp.hasMoreArguments() && arg2Str != null) {
            return this.handle4ArgsVariant(fp, arg1Str, arg2Str);
        }
        return this.handle2ArgsVariant(fp, arg1Str, arg2Str);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean peekIsConstVector(FunctionQParser fp) throws SyntaxError {
        char rawPeek = fp.sp.peek();
        if ('[' == rawPeek) {
            return true;
        }
        if ('$' == rawPeek) {
            int savedPos = fp.sp.pos;
            try {
                String rawParam = fp.parseArg();
                boolean bl = null != rawParam && '[' == new StrParser(rawParam).peek();
                return bl;
            }
            finally {
                fp.sp.pos = savedPos;
            }
        }
        return false;
    }

    private static int buildVectorEncodingFlag(VectorEncoding vectorEncoding) {
        return 1 | (vectorEncoding.equals((Object)VectorEncoding.BYTE) ? 8 : 0);
    }

    private ValueSource handle4ArgsVariant(FunctionQParser fp, String vecEncStr, String vecSimFuncStr) throws SyntaxError {
        VectorEncoding vectorEncoding = VectorSimilaritySourceParser.enumValueOrBadRequest(VectorEncoding.class, vecEncStr);
        VectorSimilarityFunction vectorSimilarityFunction = VectorSimilaritySourceParser.enumValueOrBadRequest(VectorSimilarityFunction.class, vecSimFuncStr);
        int vectorEncodingFlag = VectorSimilaritySourceParser.buildVectorEncodingFlag(vectorEncoding);
        ValueSource v1 = fp.parseValueSource(vectorEncodingFlag);
        ValueSource v2 = fp.parseValueSource(vectorEncodingFlag);
        return this.createSimilarityFunction(vectorSimilarityFunction, vectorEncoding, v1, v2);
    }

    private ValueSource handle2ArgsVariant(FunctionQParser fp, String field1Name, String field2Name) throws SyntaxError {
        ValueSource v2;
        SchemaField field1 = fp.req.getSchema().getField(field1Name);
        DenseVectorField field1Type = this.requireVectorType(field1);
        VectorEncoding vectorEncoding = field1Type.getVectorEncoding();
        VectorSimilarityFunction vectorSimilarityFunction = field1Type.getSimilarityFunction();
        ValueSource v1 = field1Type.getValueSource(field1, fp);
        if (null == field2Name) {
            int vectorEncodingFlag = VectorSimilaritySourceParser.buildVectorEncodingFlag(vectorEncoding);
            v2 = fp.parseValueSource(vectorEncodingFlag);
        } else {
            SchemaField field2 = fp.req.getSchema().getField(field2Name);
            DenseVectorField field2Type = this.requireVectorType(field2);
            if (vectorEncoding != field2Type.getVectorEncoding() || vectorSimilarityFunction != field2Type.getSimilarityFunction()) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Invalid arguments: vector field %s and vector field %s must have the same vectorEncoding and similarityFunction", field1.getName(), field2.getName()));
            }
            v2 = field2Type.getValueSource(field2, fp);
        }
        return this.createSimilarityFunction(vectorSimilarityFunction, vectorEncoding, v1, v2);
    }

    private ValueSource createSimilarityFunction(VectorSimilarityFunction functionName, VectorEncoding vectorEncoding, ValueSource v1, ValueSource v2) throws SyntaxError {
        switch (vectorEncoding) {
            case FLOAT32: {
                return new FloatVectorSimilarityFunction(functionName, v1, v2);
            }
            case BYTE: {
                return new ByteVectorSimilarityFunction(functionName, v1, v2);
            }
        }
        throw new SyntaxError("Invalid vector encoding: " + String.valueOf(vectorEncoding));
    }

    private DenseVectorField requireVectorType(SchemaField field) throws SyntaxError {
        FieldType fieldType = field.getType();
        if (fieldType instanceof DenseVectorField) {
            return (DenseVectorField)field.getType();
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Type mismatch: Expected [%s], but found a different field type for field: [%s]", DenseVectorField.class.getSimpleName(), field.getName()));
    }

    private static <T extends Enum<T>> T enumValueOrBadRequest(Class<T> enumClass, String arg) throws SolrException {
        assert (null != enumClass);
        try {
            return Enum.valueOf(enumClass, arg);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, String.format(Locale.ROOT, "Invalid argument: %s is not a valid %s. Expected one of %s", arg, enumClass.getSimpleName(), Arrays.toString(enumClass.getEnumConstants())));
        }
    }
}

