/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.index;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.NoMergePolicy;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.index.MergePolicyFactory;
import org.apache.solr.index.MergePolicyFactoryArgs;
import org.apache.solr.schema.IndexSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SimpleMergePolicyFactory
extends MergePolicyFactory {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    protected SimpleMergePolicyFactory(SolrResourceLoader resourceLoader, MergePolicyFactoryArgs args, IndexSchema schema) {
        super(resourceLoader, args, schema);
    }

    protected abstract MergePolicy getMergePolicyInstance();

    @Override
    public final MergePolicy getMergePolicy() {
        MergePolicy mp = this.getMergePolicyInstance();
        if (mp instanceof NoMergePolicy) {
            try {
                this.args.invokeSetters(mp);
            }
            catch (RuntimeException e) {
                String msg = e.getMessage();
                if (log.isInfoEnabled()) {
                    log.info("Ignoring unknown config setting for {} : {}", (Object)NoMergePolicy.class.getSimpleName(), (Object)msg);
                }
            }
        } else {
            this.args.invokeSetters(mp);
        }
        return mp;
    }
}

