/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.clustering;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.solr.common.params.SolrParams;

public final class EngineParameters
implements Cloneable {
    private static final String PARAM_PREFIX = "clustering.";
    public static final String PARAM_ALGORITHM = "clustering.algorithm";
    public static final String PARAM_MAX_LABELS = "clustering.maxLabels";
    public static final String PARAM_INCLUDE_SUBCLUSTERS = "clustering.includeSubclusters";
    public static final String PARAM_INCLUDE_OTHER_TOPICS = "clustering.includeOtherTopics";
    public static final String PARAM_LANGUAGE = "clustering.language";
    public static final String PARAM_LANGUAGE_FIELD = "clustering.languageField";
    public static final String PARAM_RESOURCES = "clustering.resources";
    public static final String PARAM_FIELDS = "clustering.fields";
    public static final String PARAM_PREFER_QUERY_CONTEXT = "clustering.preferQueryContext";
    public static final String PARAM_CONTEXT_SIZE = "clustering.contextSize";
    public static final String PARAM_CONTEXT_COUNT = "clustering.contextCount";
    private int maxLabels = Integer.MAX_VALUE;
    private boolean includeSubclusters = true;
    private boolean includeOtherTopics = true;
    private String algorithmName;
    private String resources;
    private String language = "English";
    private String languageField;
    private boolean preferQueryContext;
    private int contextSize = 320;
    private int contextCount = 3;
    private LinkedHashSet<String> fields = new LinkedHashSet();
    private LinkedHashMap<String, String> otherParameters = new LinkedHashMap();
    private String docIdField;

    EngineParameters(SolrParams params) {
        this.extractFrom(params);
    }

    private EngineParameters extractFrom(SolrParams params) {
        params.stream().forEachOrdered(e -> {
            switch ((String)e.getKey()) {
                case "clustering.maxLabels": {
                    this.maxLabels = params.getInt(PARAM_MAX_LABELS);
                    break;
                }
                case "clustering.includeSubclusters": {
                    this.includeSubclusters = params.getBool(PARAM_INCLUDE_SUBCLUSTERS);
                    break;
                }
                case "clustering.includeOtherTopics": {
                    this.includeOtherTopics = params.getBool(PARAM_INCLUDE_OTHER_TOPICS);
                    break;
                }
                case "clustering.algorithm": {
                    this.algorithmName = params.get(PARAM_ALGORITHM);
                    break;
                }
                case "clustering.resources": {
                    this.resources = params.get(PARAM_RESOURCES);
                    break;
                }
                case "clustering.language": {
                    this.language = params.get(PARAM_LANGUAGE);
                    break;
                }
                case "clustering.languageField": {
                    this.languageField = params.get(PARAM_LANGUAGE_FIELD);
                    break;
                }
                case "clustering.preferQueryContext": {
                    this.preferQueryContext = params.getBool(PARAM_PREFER_QUERY_CONTEXT);
                    break;
                }
                case "clustering.contextCount": {
                    this.contextCount = params.getPrimitiveInt(PARAM_CONTEXT_COUNT);
                    break;
                }
                case "clustering.contextSize": {
                    this.contextSize = params.getPrimitiveInt(PARAM_CONTEXT_SIZE);
                    break;
                }
                case "clustering.fields": {
                    this.fields.addAll(Arrays.asList(params.get(PARAM_FIELDS).split("[,]\\s*")));
                    break;
                }
                default: {
                    CharSequence[] value = (String[])e.getValue();
                    if (value == null) break;
                    if (value.length == 1) {
                        this.otherParameters.put((String)e.getKey(), value[0]);
                        break;
                    }
                    this.otherParameters.put((String)e.getKey(), String.join((CharSequence)", ", value));
                }
            }
        });
        return this;
    }

    int maxLabels() {
        return this.maxLabels;
    }

    boolean includeSubclusters() {
        return this.includeSubclusters;
    }

    boolean includeOtherTopics() {
        return this.includeOtherTopics;
    }

    String algorithmName() {
        return this.algorithmName;
    }

    String resources() {
        return this.resources;
    }

    String language() {
        return this.language;
    }

    String languageField() {
        return this.languageField;
    }

    Set<String> fields() {
        return this.fields;
    }

    boolean preferQueryContext() {
        return this.preferQueryContext;
    }

    int contextSize() {
        return this.contextSize;
    }

    int contextCount() {
        return this.contextCount;
    }

    LinkedHashMap<String, String> otherParameters() {
        return this.otherParameters;
    }

    protected EngineParameters clone() {
        try {
            EngineParameters clone = (EngineParameters)super.clone();
            clone.otherParameters = new LinkedHashMap<String, String>(this.otherParameters);
            clone.fields.addAll(this.fields);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    EngineParameters derivedFrom(SolrParams params) {
        EngineParameters cloned = this.clone();
        cloned.extractFrom(params);
        return cloned;
    }

    String docIdField() {
        return Objects.requireNonNull(this.docIdField);
    }

    void setDocIdField(String docIdField) {
        this.docIdField = Objects.requireNonNull(docIdField);
    }

    Set<String> getFieldsToLoad() {
        LinkedHashSet<String> fields = new LinkedHashSet<String>(this.fields());
        fields.add(this.docIdField());
        String languageField = this.languageField();
        if (languageField != null && !languageField.isBlank()) {
            fields.add(languageField);
        }
        return fields;
    }
}

