/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.ext;

import com.fasterxml.jackson.annotation.JsonFormat;
import javax.xml.namespace.QName;
import tools.jackson.core.JsonGenerator;
import tools.jackson.core.JsonToken;
import tools.jackson.core.type.WritableTypeId;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import tools.jackson.databind.jsontype.TypeSerializer;
import tools.jackson.databind.ser.std.StdSerializer;
import tools.jackson.databind.ser.std.ToStringSerializer;

public class QNameSerializer
extends StdSerializer<QName> {
    public static final ValueSerializer<?> instance = new QNameSerializer();

    public QNameSerializer() {
        super(QName.class);
    }

    @Override
    public ValueSerializer<?> createContextual(SerializationContext serializers, BeanProperty property) {
        JsonFormat.Shape shape;
        JsonFormat.Value format = this.findFormatOverrides(serializers, property, this.handledType());
        if (format != null && (shape = format.getShape()) == JsonFormat.Shape.OBJECT) {
            return this;
        }
        return ToStringSerializer.instance;
    }

    @Override
    public void serialize(QName value, JsonGenerator g, SerializationContext ctxt) {
        g.writeStartObject((Object)value);
        this.serializeProperties(value, g, ctxt);
        g.writeEndObject();
    }

    @Override
    public final void serializeWithType(QName value, JsonGenerator g, SerializationContext ctxt, TypeSerializer typeSer) {
        WritableTypeId typeIdDef = typeSer.writeTypePrefix(g, ctxt, typeSer.typeId(value, JsonToken.START_OBJECT));
        this.serializeProperties(value, g, ctxt);
        typeSer.writeTypeSuffix(g, ctxt, typeIdDef);
    }

    private void serializeProperties(QName value, JsonGenerator g, SerializationContext ctxt) {
        g.writeStringProperty("localPart", value.getLocalPart());
        if (!value.getNamespaceURI().isEmpty()) {
            g.writeStringProperty("namespaceURI", value.getNamespaceURI());
        }
        if (!value.getPrefix().isEmpty()) {
            g.writeStringProperty("prefix", value.getPrefix());
        }
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) {
        visitor.expectObjectFormat(typeHint);
    }
}

