/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.databind.deser;

import com.fasterxml.jackson.annotation.ObjectIdGenerator;
import com.fasterxml.jackson.annotation.ObjectIdResolver;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import tools.jackson.core.FormatSchema;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.TokenStreamFactory;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.InjectableValues;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.KeyDeserializer;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.cfg.HandlerInstantiator;
import tools.jackson.databind.deser.DeserializerCache;
import tools.jackson.databind.deser.DeserializerFactory;
import tools.jackson.databind.deser.ReadableObjectId;
import tools.jackson.databind.deser.UnresolvedForwardReference;
import tools.jackson.databind.introspect.Annotated;
import tools.jackson.databind.util.ClassUtil;

public abstract class DeserializationContextExt
extends DeserializationContext {
    protected transient LinkedHashMap<ObjectIdGenerator.IdKey, ReadableObjectId> _objectIds;
    private List<ObjectIdResolver> _objectIdResolvers;

    protected DeserializationContextExt(TokenStreamFactory tsf, DeserializerFactory deserializerFactory, DeserializerCache cache, DeserializationConfig config, FormatSchema schema, InjectableValues values) {
        super(tsf, deserializerFactory, cache, config, schema, values);
    }

    public DeserializationContextExt assignParser(JsonParser p) {
        this._parser = p;
        this._readCapabilities = p.streamReadCapabilities();
        return this;
    }

    public JsonParser assignAndReturnParser(JsonParser p) {
        this._parser = p;
        this._readCapabilities = p.streamReadCapabilities();
        return p;
    }

    @Override
    public ReadableObjectId findObjectId(Object id, ObjectIdGenerator<?> gen, ObjectIdResolver resolverType) {
        if (id == null) {
            return null;
        }
        ObjectIdGenerator.IdKey key = gen.key(id);
        if (this._objectIds == null) {
            this._objectIds = new LinkedHashMap();
        } else {
            ReadableObjectId entry = this._objectIds.get(key);
            if (entry != null) {
                return entry;
            }
        }
        ObjectIdResolver resolver = null;
        if (this._objectIdResolvers == null) {
            this._objectIdResolvers = new ArrayList<ObjectIdResolver>(8);
        } else {
            for (ObjectIdResolver res : this._objectIdResolvers) {
                if (!res.canUseFor(resolverType)) continue;
                resolver = res;
                break;
            }
        }
        if (resolver == null) {
            resolver = resolverType.newForDeserialization((Object)this);
            this._objectIdResolvers.add(resolver);
        }
        ReadableObjectId entry = this.createReadableObjectId(key);
        entry.setResolver(resolver);
        this._objectIds.put(key, entry);
        return entry;
    }

    protected ReadableObjectId createReadableObjectId(ObjectIdGenerator.IdKey key) {
        return new ReadableObjectId(key);
    }

    @Override
    public void checkUnresolvedObjectId() throws UnresolvedForwardReference {
        if (this._objectIds == null) {
            return;
        }
        if (!this.isEnabled(DeserializationFeature.FAIL_ON_UNRESOLVED_OBJECT_IDS)) {
            return;
        }
        UnresolvedForwardReference exception = null;
        for (Map.Entry<ObjectIdGenerator.IdKey, ReadableObjectId> entry : this._objectIds.entrySet()) {
            ReadableObjectId roid = entry.getValue();
            if (!roid.hasReferringProperties() || this.tryToResolveUnresolvedObjectId(roid)) continue;
            if (exception == null) {
                exception = new UnresolvedForwardReference(this.getParser(), "Unresolved forward references for: ").withStackTrace();
            }
            Object key = roid.getKey().key;
            Iterator<ReadableObjectId.Referring> iterator = roid.referringProperties();
            while (iterator.hasNext()) {
                ReadableObjectId.Referring referring = iterator.next();
                exception.addUnresolvedId(key, referring.getBeanType(), referring.getLocation());
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected boolean tryToResolveUnresolvedObjectId(ReadableObjectId roid) {
        return roid.tryToResolveUnresolved(this);
    }

    @Override
    public ValueDeserializer<Object> deserializerInstance(Annotated ann, Object deserDef) {
        ValueDeserializer deser;
        if (deserDef == null) {
            return null;
        }
        if (deserDef instanceof ValueDeserializer) {
            deser = (ValueDeserializer)deserDef;
        } else {
            if (!(deserDef instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned deserializer definition of type " + deserDef.getClass().getName() + "; expected type `ValueDeserializer` or `Class<ValueDeserializer>` instead");
            }
            Class deserClass = (Class)deserDef;
            if (deserClass == ValueDeserializer.None.class || ClassUtil.isBogusClass(deserClass)) {
                return null;
            }
            if (!ValueDeserializer.class.isAssignableFrom(deserClass)) {
                throw new IllegalStateException("AnnotationIntrospector returned `Class<" + deserClass.getName() + ">`; expected `Class<ValueDeserializer>`");
            }
            HandlerInstantiator hi = this._config.getHandlerInstantiator();
            ValueDeserializer valueDeserializer = deser = hi == null ? null : hi.deserializerInstance(this._config, ann, deserClass);
            if (deser == null) {
                deser = (ValueDeserializer)ClassUtil.createInstance(deserClass, this._config.canOverrideAccessModifiers());
            }
        }
        deser.resolve(this);
        return deser;
    }

    @Override
    public final KeyDeserializer keyDeserializerInstance(Annotated ann, Object deserDef) {
        KeyDeserializer deser;
        if (deserDef == null) {
            return null;
        }
        if (deserDef instanceof KeyDeserializer) {
            deser = (KeyDeserializer)deserDef;
        } else {
            if (!(deserDef instanceof Class)) {
                throw new IllegalStateException("AnnotationIntrospector returned key deserializer definition of type " + deserDef.getClass().getName() + "; expected type KeyDeserializer or Class<KeyDeserializer> instead");
            }
            Class deserClass = (Class)deserDef;
            if (deserClass == KeyDeserializer.None.class || ClassUtil.isBogusClass(deserClass)) {
                return null;
            }
            if (!KeyDeserializer.class.isAssignableFrom(deserClass)) {
                throw new IllegalStateException("AnnotationIntrospector returned Class " + deserClass.getName() + "; expected Class<KeyDeserializer>");
            }
            HandlerInstantiator hi = this._config.getHandlerInstantiator();
            KeyDeserializer keyDeserializer = deser = hi == null ? null : hi.keyDeserializerInstance(this._config, ann, deserClass);
            if (deser == null) {
                deser = (KeyDeserializer)ClassUtil.createInstance(deserClass, this._config.canOverrideAccessModifiers());
            }
        }
        deser.resolve(this);
        return deser;
    }

    public Object readRootValue(JsonParser p, JavaType valueType, ValueDeserializer<Object> deser, Object valueToUpdate) throws JacksonException {
        if (this._config.useRootWrapping()) {
            return this._unwrapAndDeserialize(p, valueType, deser, valueToUpdate);
        }
        if (valueToUpdate == null) {
            return deser.deserialize(p, this);
        }
        return deser.deserialize(p, this, valueToUpdate);
    }

    protected Object _unwrapAndDeserialize(JsonParser p, JavaType rootType, ValueDeserializer<Object> deser, Object valueToUpdate) throws JacksonException {
        String actualName;
        PropertyName expRootName = this.findRootName(rootType);
        String expSimpleName = expRootName.getSimpleName();
        if (p.currentToken() != JsonToken.START_OBJECT) {
            this.reportWrongTokenException(rootType, JsonToken.START_OBJECT, "Current token not `JsonToken.START_OBJECT` (needed to unwrap root name %s), but %s", ClassUtil.name(expSimpleName), p.currentToken());
        }
        if (p.nextToken() != JsonToken.PROPERTY_NAME) {
            this.reportWrongTokenException(rootType, JsonToken.PROPERTY_NAME, "Current token not `JsonToken.PROPERTY_NAME` (to contain expected root name %s), but %s", ClassUtil.name(expSimpleName), p.currentToken());
        }
        if (!expSimpleName.equals(actualName = p.currentName())) {
            this.reportPropertyInputMismatch(rootType, actualName, "Root name (%s) does not match expected (%s) for type %s", ClassUtil.name(actualName), ClassUtil.name(expSimpleName), ClassUtil.getTypeDescription(rootType));
        }
        p.nextToken();
        Object result = valueToUpdate == null ? deser.deserialize(p, this) : deser.deserialize(p, this, valueToUpdate);
        if (p.nextToken() != JsonToken.END_OBJECT) {
            this.reportWrongTokenException(rootType, JsonToken.END_OBJECT, "Current token not `JsonToken.END_OBJECT` (to match wrapper object with root name %s), but %s", ClassUtil.name(expSimpleName), p.currentToken());
        }
        return result;
    }

    public static final class Impl
    extends DeserializationContextExt {
        public Impl(TokenStreamFactory tsf, DeserializerFactory deserializerFactory, DeserializerCache cache, DeserializationConfig config, FormatSchema schema, InjectableValues values) {
            super(tsf, deserializerFactory, cache, config, schema, values);
        }
    }
}

