/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.diagnostics;

import java.io.File;
import java.io.FileInputStream;
import java.lang.reflect.Executable;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.diagnostics.Releaser;
import oracle.jdbc.diagnostics.SecuredFileLogHandler;
import oracle.jdbc.diagnostics.SecuredLogger;
import oracle.jdbc.diagnostics.SecuredMemoryLogHandler;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.PropertiesBlinder;

final class SecuredLoggerImpl
implements SecuredLogger,
Monitor {
    private static final AtomicLong ID_GENERATOR;
    private final Monitor.CloseableLock monitorLock = this.newDefaultLock();
    private final String loggerId;
    private String certFile;
    private String certFilePwd;
    private X509Certificate certificate;
    private ConcurrentHashMap<String, String> headers;
    private Level currentLogLevel = Level.ALL;
    private SecuredFileLogHandler fileLogger;
    private SecuredMemoryLogHandler memoryLogger;
    private Properties userProperties = null;
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;
    private static Executable $$$methodRef$$$21;
    private static Logger $$$loggerRef$$$21;
    private static Executable $$$methodRef$$$22;
    private static Logger $$$loggerRef$$$22;
    private static Executable $$$methodRef$$$23;
    private static Logger $$$loggerRef$$$23;
    private static Executable $$$methodRef$$$24;
    private static Logger $$$loggerRef$$$24;
    private static Executable $$$methodRef$$$25;
    private static Logger $$$loggerRef$$$25;
    private static Executable $$$methodRef$$$26;
    private static Logger $$$loggerRef$$$26;
    private static Executable $$$methodRef$$$27;
    private static Logger $$$loggerRef$$$27;
    private static Executable $$$methodRef$$$28;
    private static Logger $$$loggerRef$$$28;

    SecuredLoggerImpl(String loggerId, @Blind(value=PropertiesBlinder.class) Properties usrProps) {
        this.loggerId = loggerId;
        this.userProperties = usrProps;
        this.headers = new ConcurrentHashMap();
        this.configure();
    }

    @Override
    public final Monitor.CloseableLock getMonitorLock() {
        return this.monitorLock;
    }

    @Override
    public boolean isLoggable(Level level) {
        return this.currentLogLevel != Level.OFF && level.intValue() >= this.currentLogLevel.intValue();
    }

    @Override
    public void disableMemoryLogging() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.memoryLogger != null) {
                this.memoryLogger.close();
                this.memoryLogger = null;
            }
        }
    }

    @Override
    public void enableMemoryLogging() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.memoryLogger == null) {
                this.memoryLogger = new SecuredMemoryLogHandler(this);
            }
        }
    }

    @Override
    public void disableFileLogging() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.fileLogger != null) {
                this.fileLogger.close();
                this.fileLogger = null;
            }
        }
    }

    @Override
    public void enableFileLogging() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.fileLogger == null) {
                this.fileLogger = new SecuredFileLogHandler(this);
            }
        }
    }

    @Override
    public void reset() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.fileLogger != null) {
                this.fileLogger.reset();
            }
            if (this.memoryLogger != null) {
                this.memoryLogger.reset();
            }
        }
    }

    @Override
    public String getId() {
        return this.loggerId;
    }

    @Override
    public void dumpLog() {
        if (this.memoryLogger != null) {
            this.memoryLogger.dumpLog();
        }
    }

    @Override
    public void close() {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            if (this.fileLogger != null) {
                this.fileLogger.close();
            }
            if (this.memoryLogger != null) {
                this.memoryLogger.close();
            }
        }
    }

    @Override
    public void setLogLevel(Level newLevel) {
        try (Monitor.CloseableLock lock = this.acquireCloseableLock();){
            this.currentLogLevel = newLevel;
            if (this.fileLogger != null) {
                this.fileLogger.setLevel(newLevel);
            }
            if (this.memoryLogger != null) {
                this.memoryLogger.setLevel(newLevel);
            }
        }
    }

    @Override
    public Level getLogLevel() {
        return this.currentLogLevel;
    }

    @Override
    public void addHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Override
    public void addHeader(@Blind(value=PropertiesBlinder.class) Properties properties) {
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> this.headers.put((String)key, (String)value)));
    }

    @Override
    public void add(Level logLevel, String className, String methodName, String debugMsg) {
        if (!this.isLoggable(logLevel)) {
            return;
        }
        long logTime = System.currentTimeMillis();
        long eventId = ID_GENERATOR.incrementAndGet();
        if (this.memoryLogger != null) {
            this.memoryLogger.add(logLevel, eventId, logTime, className, methodName, debugMsg);
        }
        if (this.fileLogger != null) {
            this.fileLogger.add(logLevel, eventId, logTime, className, methodName, debugMsg);
        }
    }

    @Override
    public void add(Level logLevel, String className, String methodName, String debugMsg, Object debugMsgParam1, Releaser releaser) {
        if (!this.isLoggable(logLevel)) {
            return;
        }
        long logTime = System.currentTimeMillis();
        long eventId = ID_GENERATOR.incrementAndGet();
        if (this.memoryLogger != null) {
            this.memoryLogger.add(logLevel, eventId, logTime, className, methodName, debugMsg, debugMsgParam1, releaser);
        }
        if (this.fileLogger != null) {
            this.fileLogger.add(logLevel, eventId, logTime, className, methodName, debugMsg, debugMsgParam1, null);
        }
    }

    @Override
    public void add(Level logLevel, String className, String methodName, String debugMsg, Object debugMsgParam1, Object debugMsgParam2, Releaser releaser) {
        if (!this.isLoggable(logLevel)) {
            return;
        }
        long logTime = System.currentTimeMillis();
        long eventId = ID_GENERATOR.incrementAndGet();
        if (this.memoryLogger != null) {
            this.memoryLogger.add(logLevel, eventId, logTime, className, methodName, debugMsg, debugMsgParam1, debugMsgParam2, releaser);
        }
        if (this.fileLogger != null) {
            this.fileLogger.add(logLevel, eventId, logTime, className, methodName, debugMsg, debugMsgParam1, debugMsgParam2, null);
        }
    }

    @Override
    public void add(Level logLevel, String className, String methodName, String debugMsg, Object debugMsgParam1, Object debugMsgParam2, Object debugMsgParam3, Releaser releaser) {
        if (!this.isLoggable(logLevel)) {
            return;
        }
        long logTime = System.currentTimeMillis();
        long eventId = ID_GENERATOR.incrementAndGet();
        if (this.memoryLogger != null) {
            this.memoryLogger.add(logLevel, eventId, logTime, className, methodName, debugMsg, debugMsgParam1, debugMsgParam2, debugMsgParam3, releaser);
        }
        if (this.fileLogger != null) {
            this.fileLogger.add(logLevel, eventId, logTime, className, methodName, debugMsg, debugMsgParam1, debugMsgParam2, debugMsgParam3, null);
        }
    }

    @Override
    public void add(Level logLevel, String className, String methodName, String debugMsg, Object debugMsgParam1, Object debugMsgParam2, Object debugMsgParam3, Object debugMsgParam4, Releaser releaser) {
        if (!this.isLoggable(logLevel)) {
            return;
        }
        long logTime = System.currentTimeMillis();
        long eventId = ID_GENERATOR.incrementAndGet();
        if (this.memoryLogger != null) {
            this.memoryLogger.add(logLevel, eventId, logTime, className, methodName, debugMsg, debugMsgParam1, debugMsgParam2, debugMsgParam3, debugMsgParam4, releaser);
        }
        if (this.fileLogger != null) {
            this.fileLogger.add(logLevel, eventId, logTime, className, methodName, debugMsg, debugMsgParam1, debugMsgParam2, debugMsgParam3, debugMsgParam4, null);
        }
    }

    @Override
    public void add(Level logLevel, String className, String methodName, String debugMsg, Releaser releaser, Object ... debugMsgParams) {
        if (!this.isLoggable(logLevel)) {
            return;
        }
        long logTime = System.currentTimeMillis();
        long eventId = ID_GENERATOR.incrementAndGet();
        if (this.memoryLogger != null) {
            this.memoryLogger.add(logLevel, eventId, logTime, className, methodName, debugMsg, releaser, debugMsgParams);
        }
        if (this.fileLogger != null) {
            this.fileLogger.add(logLevel, eventId, logTime, className, methodName, debugMsg, null, debugMsgParams);
        }
    }

    X509Certificate getCertificate() {
        return this.certificate;
    }

    @Blind(value=PropertiesBlinder.class)
    Properties getUserProperties() {
        return this.userProperties;
    }

    ConcurrentHashMap<String, String> getHeaders() {
        return this.headers;
    }

    private void readPublicKeyCertificate() throws RuntimeException {
        if (this.certFile == null) {
            return;
        }
        File certificateFile = new File(this.certFile);
        if (!certificateFile.exists()) {
            throw new RuntimeException("Secure Log Initialization failed : Certificate file " + this.certFile + " does not exist.");
        }
        try {
            this.certificate = this.loadCertificate();
        }
        catch (Exception e2) {
            throw new RuntimeException("Secure Log Initialization failed : Invalid Certificate file : " + this.certFile, e2);
        }
        this.checkPublicAccess(this.certFile);
    }

    private boolean checkPublicAccess(String filePath) throws RuntimeException {
        return true;
    }

    private X509Certificate loadCertificate() throws Exception {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(new FileInputStream(this.certFile), this.certFilePwd.toCharArray());
        while (ks.aliases().hasMoreElements()) {
            Certificate cert = ks.getCertificate(ks.aliases().nextElement());
            if (!(cert instanceof X509Certificate)) continue;
            return (X509Certificate)cert;
        }
        throw new RuntimeException("Unable to retrive public key");
    }

    private void configure() {
        String cname = this.getClass().getName();
        this.certFile = SecuredLogger.getStringProperty(cname + ".certificate", DEFAULT_CERTIFICATE_PATH, this.userProperties);
        this.certFilePwd = SecuredLogger.getStringProperty(cname + ".certificatePassword", DEFAULT_CERTIFICATE_PWD, this.userProperties);
        this.readPublicKeyCertificate();
    }

    static {
        try {
            $$$methodRef$$$28 = SecuredLoggerImpl.class.getDeclaredConstructor(String.class, Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$28 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$27 = SecuredLoggerImpl.class.getDeclaredMethod("lambda$addHeader$0", Object.class, Object.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$27 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$26 = SecuredLoggerImpl.class.getDeclaredMethod("configure", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$26 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$25 = SecuredLoggerImpl.class.getDeclaredMethod("loadCertificate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$25 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$24 = SecuredLoggerImpl.class.getDeclaredMethod("checkPublicAccess", String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$24 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$23 = SecuredLoggerImpl.class.getDeclaredMethod("readPublicKeyCertificate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$23 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$22 = SecuredLoggerImpl.class.getDeclaredMethod("getHeaders", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$22 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$21 = SecuredLoggerImpl.class.getDeclaredMethod("getUserProperties", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$21 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$20 = SecuredLoggerImpl.class.getDeclaredMethod("getCertificate", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$20 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$19 = SecuredLoggerImpl.class.getDeclaredMethod("add", Level.class, String.class, String.class, String.class, Releaser.class, Object[].class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$19 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$18 = SecuredLoggerImpl.class.getDeclaredMethod("add", Level.class, String.class, String.class, String.class, Object.class, Object.class, Object.class, Object.class, Releaser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$18 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$17 = SecuredLoggerImpl.class.getDeclaredMethod("add", Level.class, String.class, String.class, String.class, Object.class, Object.class, Object.class, Releaser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$17 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$16 = SecuredLoggerImpl.class.getDeclaredMethod("add", Level.class, String.class, String.class, String.class, Object.class, Object.class, Releaser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$16 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$15 = SecuredLoggerImpl.class.getDeclaredMethod("add", Level.class, String.class, String.class, String.class, Object.class, Releaser.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$15 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$14 = SecuredLoggerImpl.class.getDeclaredMethod("add", Level.class, String.class, String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$14 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$13 = SecuredLoggerImpl.class.getDeclaredMethod("addHeader", Properties.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$13 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$12 = SecuredLoggerImpl.class.getDeclaredMethod("addHeader", String.class, String.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$12 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$11 = SecuredLoggerImpl.class.getDeclaredMethod("getLogLevel", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$11 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$10 = SecuredLoggerImpl.class.getDeclaredMethod("setLogLevel", Level.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$10 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$9 = SecuredLoggerImpl.class.getDeclaredMethod("close", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$9 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$8 = SecuredLoggerImpl.class.getDeclaredMethod("dumpLog", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$8 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$7 = SecuredLoggerImpl.class.getDeclaredMethod("getId", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$7 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$6 = SecuredLoggerImpl.class.getDeclaredMethod("reset", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$6 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$5 = SecuredLoggerImpl.class.getDeclaredMethod("enableFileLogging", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$5 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$4 = SecuredLoggerImpl.class.getDeclaredMethod("disableFileLogging", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$4 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$3 = SecuredLoggerImpl.class.getDeclaredMethod("enableMemoryLogging", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$3 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$2 = SecuredLoggerImpl.class.getDeclaredMethod("disableMemoryLogging", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$2 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$1 = SecuredLoggerImpl.class.getDeclaredMethod("isLoggable", Level.class);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$1 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        try {
            $$$methodRef$$$0 = SecuredLoggerImpl.class.getDeclaredMethod("getMonitorLock", new Class[0]);
        }
        catch (Throwable throwable) {}
        $$$loggerRef$$$0 = (Logger)Logger.class.getDeclaredMethod("getLogger", String.class).invoke(null, "oracle.jdbc");
        ID_GENERATOR = new AtomicLong(1L);
    }
}

