/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.lint.formatter;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.List;
import java.util.Objects;
import schemacrawler.schema.NamedObjectKey;
import schemacrawler.schemacrawler.exceptions.ExecutionRuntimeException;
import schemacrawler.tools.lint.Lint;
import schemacrawler.tools.lint.Lints;
import schemacrawler.tools.lint.formatter.LintReportGenerator;
import schemacrawler.tools.options.OutputOptions;
import tools.jackson.core.StreamReadFeature;
import tools.jackson.core.StreamWriteFeature;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.PropertyNamingStrategies;
import tools.jackson.databind.SerializationFeature;
import tools.jackson.databind.annotation.JsonNaming;
import tools.jackson.databind.cfg.MapperBuilder;

abstract class BaseLintReportJacksonGenerator
implements LintReportGenerator {
    private final PrintWriter out;

    private static ObjectMapper newConfiguredObjectMapper(MapperBuilder<? extends ObjectMapper, ?> mapperBuilder) {
        Objects.requireNonNull(mapperBuilder, "No mapper builder provided");
        mapperBuilder.enable(new SerializationFeature[]{SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, SerializationFeature.INDENT_OUTPUT, SerializationFeature.USE_EQUALITY_FOR_OBJECT_ID});
        mapperBuilder.enable(new StreamReadFeature[]{StreamReadFeature.INCLUDE_SOURCE_IN_LOCATION, StreamReadFeature.IGNORE_UNDEFINED});
        mapperBuilder.enable(new StreamWriteFeature[]{StreamWriteFeature.IGNORE_UNKNOWN});
        @JsonPropertyOrder(alphabetic=true)
        @JsonNaming(value=PropertyNamingStrategies.KebabCaseStrategy.class)
        abstract class JacksonAnnotationMixIn {
            @JsonIgnore
            public Object value;
            @JsonProperty(value="key")
            private final String[] key = new String[0];

            JacksonAnnotationMixIn() {
            }

            @JsonIgnore
            public abstract List<?> getCatalogLints();

            @JsonProperty(value="value")
            public abstract Object getValueAsString();

            @JsonIgnore
            public abstract boolean isEmpty();
        }
        mapperBuilder.addMixIn(Object.class, JacksonAnnotationMixIn.class);
        mapperBuilder.addMixIn(Lint.class, JacksonAnnotationMixIn.class);
        mapperBuilder.addMixIn(Lints.class, JacksonAnnotationMixIn.class);
        mapperBuilder.addMixIn(NamedObjectKey.class, JacksonAnnotationMixIn.class);
        ObjectMapper objectMapper = mapperBuilder.build();
        return objectMapper;
    }

    BaseLintReportJacksonGenerator(OutputOptions outputOptions) {
        this.out = outputOptions.openNewOutputWriter();
    }

    @Override
    public void generateLintReport(Lints report) {
        Objects.requireNonNull(this.out, "No output stream provided");
        try {
            ObjectMapper mapper = BaseLintReportJacksonGenerator.newConfiguredObjectMapper(this.newMapperBuilder());
            mapper.writeValue((Writer)this.out, (Object)report);
        }
        catch (Exception e) {
            throw new ExecutionRuntimeException("Could not generate lint report", (Throwable)e);
        }
    }

    protected abstract <B extends MapperBuilder<?, B>> B newMapperBuilder();
}

