/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Executable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.jdbc.driver.ClioSupport;
import oracle.jdbc.internal.Monitor;
import oracle.jdbc.logging.annotations.DefaultLogger;
import oracle.jdbc.logging.annotations.Feature;
import oracle.jdbc.logging.annotations.Log;
import oracle.jdbc.logging.annotations.Supports;
import oracle.jdbc.logging.runtime.TraceControllerImpl;
import oracle.net.jdbc.nl.RepConversion;
import oracle.net.ns.NetException;
import oracle.net.ns.SQLnetDef;
import oracle.net.ns.SessionAtts;

@DefaultLogger(value="oracle.net.ns")
@Supports(value={Feature.NET})
public class Packet
implements SQLnetDef {
    private int buffer2send;
    protected int sdu;
    protected int tdu;
    protected int length;
    public int type;
    protected int flags;
    protected int dataLen;
    protected int dataOff;
    protected String data;
    protected byte[] buffer;
    protected int leftOverFromPreviousRead;
    protected int nextPacketOffset;
    public SessionAtts sAtts;
    StringBuilder sb;
    StringBuilder tmpBuf;
    public static final String[] toHex;
    public static final char[] toChar;
    public static final String DIVIDER = "     |";
    public static final String BLANK_SPACE = "   ";
    private static Executable $$$methodRef$$$0;
    private static Logger $$$loggerRef$$$0;
    private static Executable $$$methodRef$$$1;
    private static Logger $$$loggerRef$$$1;
    private static Executable $$$methodRef$$$2;
    private static Logger $$$loggerRef$$$2;
    private static Executable $$$methodRef$$$3;
    private static Logger $$$loggerRef$$$3;
    private static Executable $$$methodRef$$$4;
    private static Logger $$$loggerRef$$$4;
    private static Executable $$$methodRef$$$5;
    private static Logger $$$loggerRef$$$5;
    private static Executable $$$methodRef$$$6;
    private static Logger $$$loggerRef$$$6;
    private static Executable $$$methodRef$$$7;
    private static Logger $$$loggerRef$$$7;
    private static Executable $$$methodRef$$$8;
    private static Logger $$$loggerRef$$$8;
    private static Executable $$$methodRef$$$9;
    private static Logger $$$loggerRef$$$9;
    private static Executable $$$methodRef$$$10;
    private static Logger $$$loggerRef$$$10;
    private static Executable $$$methodRef$$$11;
    private static Logger $$$loggerRef$$$11;
    private static Executable $$$methodRef$$$12;
    private static Logger $$$loggerRef$$$12;
    private static Executable $$$methodRef$$$13;
    private static Logger $$$loggerRef$$$13;
    private static Executable $$$methodRef$$$14;
    private static Logger $$$loggerRef$$$14;
    private static Executable $$$methodRef$$$15;
    private static Logger $$$loggerRef$$$15;
    private static Executable $$$methodRef$$$16;
    private static Logger $$$loggerRef$$$16;
    private static Executable $$$methodRef$$$17;
    private static Logger $$$loggerRef$$$17;
    private static Executable $$$methodRef$$$18;
    private static Logger $$$loggerRef$$$18;
    private static Executable $$$methodRef$$$19;
    private static Logger $$$loggerRef$$$19;
    private static Executable $$$methodRef$$$20;
    private static Logger $$$loggerRef$$$20;

    public Packet(SessionAtts sAtts) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$17, Level.FINEST, Packet.class, $$$methodRef$$$17, null, sAtts);
            }
            this.leftOverFromPreviousRead = 0;
            this.nextPacketOffset = 0;
            this.sb = null;
            this.tmpBuf = null;
            this.sAtts = sAtts;
            this.sdu = sAtts.getSDU();
            this.tdu = sAtts.getTDU();
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$17, Level.FINEST, Packet.class, $$$methodRef$$$17, null);
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, Packet.class, $$$methodRef$$$17, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$17, Level.FINEST, Packet.class, $$$methodRef$$$17, null, throwable2);
            }
            throw throwable;
        }
    }

    public Packet(SessionAtts sAtts, int bufferSize) {
        this(sAtts);
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$18, Level.FINEST, Packet.class, $$$methodRef$$$18, null, sAtts, bufferSize);
            }
            this.createBuffer(bufferSize);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$18, Level.FINEST, Packet.class, $$$methodRef$$$18, null);
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, Packet.class, $$$methodRef$$$18, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$18, Level.FINEST, Packet.class, $$$methodRef$$$18, null, throwable2);
            }
            throw throwable;
        }
    }

    public Packet(SessionAtts sAtts, int bufferSize, int type, int flags) {
        this(sAtts);
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$19, Level.FINEST, Packet.class, $$$methodRef$$$19, null, sAtts, bufferSize, type, flags);
            }
            this.createBuffer(bufferSize, type, flags);
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$19, Level.FINEST, Packet.class, $$$methodRef$$$19, null);
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, Packet.class, $$$methodRef$$$19, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$19, Level.FINEST, Packet.class, $$$methodRef$$$19, null, throwable2);
            }
            throw throwable;
        }
    }

    public Packet(Packet pkt) {
        this(pkt.sAtts);
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$20, Level.FINEST, Packet.class, $$$methodRef$$$20, null, pkt);
            }
            this.length = pkt.length;
            this.type = pkt.type;
            this.flags = pkt.flags;
            this.dataLen = pkt.dataLen;
            this.dataOff = pkt.dataOff;
            this.buffer = pkt.buffer;
            this.leftOverFromPreviousRead = pkt.leftOverFromPreviousRead;
            this.nextPacketOffset = pkt.nextPacketOffset;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$20, Level.FINEST, Packet.class, $$$methodRef$$$20, null);
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, Packet.class, $$$methodRef$$$20, null, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$20, Level.FINEST, Packet.class, $$$methodRef$$$20, null, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void createBuffer(int n2) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void length;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$0, Level.FINEST, Packet.class, $$$methodRef$$$0, this, n2);
            }
            this.buffer = new byte[length];
            if (this.sAtts.isLargeSDU && (this.type == 6 || this.type == 12 || this.type == 15)) {
                this.buffer[3] = (byte)(length & 0xFF);
                this.buffer[2] = (byte)(length >> 8 & 0xFF);
                this.buffer[1] = (byte)(length >> 16 & 0xFF);
                this.buffer[0] = (byte)(length >> 24 & 0xFF);
            } else {
                this.buffer[0] = (byte)(length / 256);
                this.buffer[1] = (byte)(length % 256);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$0, Level.FINEST, Packet.class, $$$methodRef$$$0, this);
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, Packet.class, $$$methodRef$$$0, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$0, Level.FINEST, Packet.class, $$$methodRef$$$0, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void createBuffer(int n2, int n3, int n4) {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void flags;
            void length;
            void type;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$1, Level.FINEST, Packet.class, $$$methodRef$$$1, this, n2, n3, n4);
            }
            this.type = type;
            this.createBuffer((int)length);
            this.buffer[5] = (byte)flags;
            this.buffer[4] = (byte)type;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$1, Level.FINEST, Packet.class, $$$methodRef$$$1, this);
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, Packet.class, $$$methodRef$$$1, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$1, Level.FINEST, Packet.class, $$$methodRef$$$1, this, throwable2);
            }
            throw throwable;
        }
    }

    protected void receive() throws IOException, NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$2, Level.FINEST, Packet.class, $$$methodRef$$$2, this, new Object[0]);
            }
            int bytesRead = 0;
            int nBytes = 0;
            int bytesToRead = this.sdu;
            boolean needToReadHeader = true;
            while (bytesToRead > 0) {
                if (this.leftOverFromPreviousRead > 0) {
                    System.arraycopy(this.buffer, this.nextPacketOffset, this.buffer, 0, this.leftOverFromPreviousRead);
                    bytesRead = this.leftOverFromPreviousRead;
                    if (bytesRead >= 8) {
                        this.processHeader();
                        needToReadHeader = false;
                        if (this.length >= this.leftOverFromPreviousRead) {
                            bytesToRead = this.length - this.leftOverFromPreviousRead;
                            this.leftOverFromPreviousRead = 0;
                            this.nextPacketOffset = 0;
                        } else {
                            this.leftOverFromPreviousRead -= this.length;
                            bytesToRead = 0;
                            this.nextPacketOffset = this.length;
                        }
                    } else {
                        bytesToRead -= bytesRead;
                        this.leftOverFromPreviousRead -= bytesRead;
                        this.nextPacketOffset = 0;
                    }
                }
                try {
                    if (bytesToRead > 0) {
                        nBytes = this.sAtts.ntInputStream.read(this.buffer, bytesRead, bytesToRead);
                        if (nBytes <= 0) {
                            NetException netException = new NetException(0);
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, Packet.class, $$$methodRef$$$2, this, netException);
                            }
                            throw netException;
                        }
                        bytesRead += nBytes;
                    }
                    if (needToReadHeader && bytesRead >= 8) {
                        needToReadHeader = false;
                        this.processHeader();
                        bytesToRead = this.length;
                        if (bytesRead > this.length) {
                            this.leftOverFromPreviousRead = bytesRead - this.length;
                            bytesToRead = 0;
                            this.nextPacketOffset = this.length;
                            continue;
                        }
                        this.leftOverFromPreviousRead = 0;
                        this.nextPacketOffset = 0;
                        bytesToRead -= bytesRead;
                        continue;
                    }
                    bytesToRead -= nBytes;
                }
                catch (InterruptedIOException exp) {
                    try {
                        this.sAtts.cOption.nt.sendUrgentByte(33);
                        this.sAtts.cOption.nt.disconnect();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    NetException netException = new NetException(504);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$2, Level.FINEST, Packet.class, $$$methodRef$$$2, this, netException);
                    }
                    throw netException;
                }
            }
            if (bl) {
                this.debug($$$loggerRef$$$2, Level.FINEST, $$$methodRef$$$2, "type=" + this.type + ", length=" + this.length + ", flags=" + this.flags + "\n" + this.dumpBytes(this.buffer, 0, this.length) + ", sessionTraceId=" + this.sAtts.traceId);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$2, Level.FINEST, Packet.class, $$$methodRef$$$2, this);
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, Packet.class, $$$methodRef$$$2, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$2, Level.FINEST, Packet.class, $$$methodRef$$$2, this, throwable2);
            }
            throw throwable;
        }
    }

    void processHeader() throws IOException, NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$3, Level.FINEST, Packet.class, $$$methodRef$$$3, this, new Object[0]);
            }
            this.length = this.buffer[0] & 0xFF;
            this.length <<= 8;
            this.length |= this.buffer[1] & 0xFF;
            this.type = this.buffer[4];
            this.flags = this.buffer[5];
            if (this.sAtts.isLargeSDU && (this.type == 6 || this.type == 14 || this.type == 12 || this.type == 15)) {
                this.length = Packet.toUb4(this.buffer, 0);
            }
            if (this.type > 19) {
                NetException netException = new NetException(204);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, Packet.class, $$$methodRef$$$3, this, netException);
                }
                throw netException;
            }
            if (this.length > 0x200000 || this.length > this.sdu) {
                NetException netException = new NetException(203);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, Packet.class, $$$methodRef$$$3, this, netException);
                }
                throw netException;
            }
            if (this.length < 8) {
                NetException netException = new NetException(207);
                if (bl) {
                    ClioSupport.throwing($$$loggerRef$$$3, Level.FINEST, Packet.class, $$$methodRef$$$3, this, netException);
                }
                throw netException;
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$3, Level.FINEST, Packet.class, $$$methodRef$$$3, this);
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, Packet.class, $$$methodRef$$$3, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$3, Level.FINEST, Packet.class, $$$methodRef$$$3, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void send() throws IOException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            block19: {
                Monitor.CloseableLock lock;
                block20: {
                    if (bl) {
                        ClioSupport.entering($$$loggerRef$$$4, Level.FINEST, Packet.class, $$$methodRef$$$4, this, new Object[0]);
                    }
                    lock = this.sAtts.ntOutputStreamMonitor.acquireCloseableLock();
                    Throwable throwable = null;
                    try {
                        if (bl) {
                            this.debug($$$loggerRef$$$4, Level.FINEST, $$$methodRef$$$4, "\n" + this.dumpBytes(this.buffer, 0, this.buffer.length) + ", sessionTraceId=" + this.sAtts.traceId);
                        }
                        this.sAtts.ntOutputStream.write(this.buffer, 0, this.buffer.length);
                        if (lock == null) break block19;
                        if (throwable == null) break block20;
                    }
                    catch (Throwable throwable3) {
                        try {
                            throwable = throwable3;
                            Throwable throwable4 = throwable3;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, Packet.class, $$$methodRef$$$4, this, throwable4);
                            }
                            throw throwable4;
                        }
                        catch (Throwable throwable5) {
                            if (lock != null) {
                                if (throwable != null) {
                                    try {
                                        lock.close();
                                    }
                                    catch (Throwable throwable6) {
                                        throwable.addSuppressed(throwable6);
                                    }
                                } else {
                                    lock.close();
                                }
                            }
                            Throwable throwable7 = throwable5;
                            if (bl) {
                                ClioSupport.throwing($$$loggerRef$$$4, Level.FINEST, Packet.class, $$$methodRef$$$4, this, throwable7);
                            }
                            throw throwable7;
                        }
                    }
                    try {
                        lock.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block19;
                }
                lock.close();
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$4, Level.FINEST, Packet.class, $$$methodRef$$$4, this);
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, Packet.class, $$$methodRef$$$4, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable8 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$4, Level.FINEST, Packet.class, $$$methodRef$$$4, this, throwable8);
            }
            throw throwable;
        }
    }

    protected void extractData() throws IOException, NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$5, Level.FINEST, Packet.class, $$$methodRef$$$5, this, new Object[0]);
            }
            if (this.dataLen <= 0) {
                this.data = new String();
            } else if (this.length > this.dataOff) {
                this.data = new String(this.buffer, 0, this.dataOff, this.dataLen);
            } else {
                byte[] tempBuffer = new byte[this.dataLen + 10];
                byte[] dataBuffer = new byte[this.dataLen];
                int count = this.readLocal(tempBuffer, 0, this.dataLen + 10);
                if (count != 0) {
                    if (count >= 10) {
                        System.arraycopy(tempBuffer, 10, dataBuffer, 0, count -= 10);
                    } else {
                        NetException netException = new NetException(207);
                        if (bl) {
                            ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, Packet.class, $$$methodRef$$$5, this, netException);
                        }
                        throw netException;
                    }
                }
                if (count < this.dataLen && this.sAtts.nsInputStream.read(dataBuffer, count, this.dataLen - count) < 0) {
                    NetException netException = new NetException(0);
                    if (bl) {
                        ClioSupport.throwing($$$loggerRef$$$5, Level.FINEST, Packet.class, $$$methodRef$$$5, this, netException);
                    }
                    throw netException;
                }
                this.data = new String(dataBuffer, 0);
            }
            if (bl) {
                this.debug($$$loggerRef$$$5, Level.FINEST, $$$methodRef$$$5, "data=" + this.data + ", sessionTraceId=" + this.sAtts.traceId);
            }
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$5, Level.FINEST, Packet.class, $$$methodRef$$$5, this);
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, Packet.class, $$$methodRef$$$5, this, null);
            }
            return;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$5, Level.FINEST, Packet.class, $$$methodRef$$$5, this, throwable2);
            }
            throw throwable;
        }
    }

    protected String getData() {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$6, Level.FINEST, Packet.class, $$$methodRef$$$6, this, new Object[0]);
            }
            String string = this.data;
            if (bl) {
                ClioSupport.returning($$$loggerRef$$$6, Level.FINEST, Packet.class, $$$methodRef$$$6, this, string);
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, Packet.class, $$$methodRef$$$6, this, null);
            }
            return string;
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (bl) {
                ClioSupport.exiting($$$loggerRef$$$6, Level.FINEST, Packet.class, $$$methodRef$$$6, this, throwable2);
            }
            throw throwable;
        }
    }

    /*
     * WARNING - void declaration
     */
    void setFlags(int n2) throws NetException {
        boolean bl = (0x20000000L & TraceControllerImpl.feature) != 0L;
        try {
            void _flags;
            if (bl) {
                ClioSupport.entering($$$loggerRef$$$7, Level.FINEST, Packet.class, $$$methodRef$$$7, this, n2);
            }
            this.flags = _flags;
            this.buffer[5] = (byte)this.flags;
       