/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.dbencryptionsdk.structuredencryption.model;

import java.util.List;
import java.util.Objects;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.CryptoItem;
import software.amazon.cryptography.dbencryptionsdk.structuredencryption.model.ParsedHeader;

public class DecryptPathStructureOutput {
    private final List<CryptoItem> plaintextStructure;
    private final ParsedHeader parsedHeader;

    protected DecryptPathStructureOutput(BuilderImpl builder) {
        this.plaintextStructure = builder.plaintextStructure();
        this.parsedHeader = builder.parsedHeader();
    }

    public List<CryptoItem> plaintextStructure() {
        return this.plaintextStructure;
    }

    public ParsedHeader parsedHeader() {
        return this.parsedHeader;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected List<CryptoItem> plaintextStructure;
        protected ParsedHeader parsedHeader;

        protected BuilderImpl() {
        }

        protected BuilderImpl(DecryptPathStructureOutput model) {
            this.plaintextStructure = model.plaintextStructure();
            this.parsedHeader = model.parsedHeader();
        }

        @Override
        public Builder plaintextStructure(List<CryptoItem> plaintextStructure) {
            this.plaintextStructure = plaintextStructure;
            return this;
        }

        @Override
        public List<CryptoItem> plaintextStructure() {
            return this.plaintextStructure;
        }

        @Override
        public Builder parsedHeader(ParsedHeader parsedHeader) {
            this.parsedHeader = parsedHeader;
            return this;
        }

        @Override
        public ParsedHeader parsedHeader() {
            return this.parsedHeader;
        }

        @Override
        public DecryptPathStructureOutput build() {
            if (Objects.isNull(this.plaintextStructure())) {
                throw new IllegalArgumentException("Missing value for required field `plaintextStructure`");
            }
            if (Objects.isNull(this.parsedHeader())) {
                throw new IllegalArgumentException("Missing value for required field `parsedHeader`");
            }
            return new DecryptPathStructureOutput(this);
        }
    }

    public static interface Builder {
        public Builder plaintextStructure(List<CryptoItem> var1);

        public List<CryptoItem> plaintextStructure();

        public Builder parsedHeader(ParsedHeader var1);

        public ParsedHeader parsedHeader();

        public DecryptPathStructureOutput build();
    }
}

