/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.commons.notifications.model;

import java.io.IOException;
import java.time.Instant;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.opensearch.commons.notifications.model.BaseModel;
import org.opensearch.commons.notifications.model.NotificationConfig;
import org.opensearch.commons.utils.HelpersKt;
import org.opensearch.core.common.Strings;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 *2\u00020\u0001:\u0001*B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nB\u0011\b\u0016\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\t\u0010\rJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001c\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0016J\t\u0010\u001e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\bH\u00c6\u0003J1\u0010\"\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010#\u001a\u00020$2\b\u0010%\u001a\u0004\u0018\u00010&H\u00d6\u0003J\t\u0010'\u001a\u00020(H\u00d6\u0001J\t\u0010)\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006+"}, d2={"Lorg/opensearch/commons/notifications/model/NotificationConfigInfo;", "Lorg/opensearch/commons/notifications/model/BaseModel;", "configId", "", "lastUpdatedTime", "Ljava/time/Instant;", "createdTime", "notificationConfig", "Lorg/opensearch/commons/notifications/model/NotificationConfig;", "<init>", "(Ljava/lang/String;Ljava/time/Instant;Ljava/time/Instant;Lorg/opensearch/commons/notifications/model/NotificationConfig;)V", "input", "Lorg/opensearch/core/common/io/stream/StreamInput;", "(Lorg/opensearch/core/common/io/stream/StreamInput;)V", "getConfigId", "()Ljava/lang/String;", "getLastUpdatedTime", "()Ljava/time/Instant;", "getCreatedTime", "getNotificationConfig", "()Lorg/opensearch/commons/notifications/model/NotificationConfig;", "writeTo", "", "output", "Lorg/opensearch/core/common/io/stream/StreamOutput;", "toXContent", "Lorg/opensearch/core/xcontent/XContentBuilder;", "builder", "params", "Lorg/opensearch/core/xcontent/ToXContent$Params;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "common-utils"})
@SourceDebugExtension(value={"SMAP\nNotificationConfigInfo.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NotificationConfigInfo.kt\norg/opensearch/commons/notifications/model/NotificationConfigInfo\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
public final class NotificationConfigInfo
implements BaseModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String configId;
    @NotNull
    private final Instant lastUpdatedTime;
    @NotNull
    private final Instant createdTime;
    @NotNull
    private final NotificationConfig notificationConfig;
    @NotNull
    private static final Lazy<Logger> log$delegate = HelpersKt.logger(NotificationConfigInfo.class);
    @NotNull
    private static final Writeable.Reader<NotificationConfigInfo> reader = NotificationConfigInfo::reader$lambda$0;

    public NotificationConfigInfo(@NotNull String configId, @NotNull Instant lastUpdatedTime, @NotNull Instant createdTime, @NotNull NotificationConfig notificationConfig) {
        Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
        Intrinsics.checkNotNullParameter((Object)lastUpdatedTime, (String)"lastUpdatedTime");
        Intrinsics.checkNotNullParameter((Object)createdTime, (String)"createdTime");
        Intrinsics.checkNotNullParameter((Object)notificationConfig, (String)"notificationConfig");
        this.configId = configId;
        this.lastUpdatedTime = lastUpdatedTime;
        this.createdTime = createdTime;
        this.notificationConfig = notificationConfig;
        if (!(!Strings.isNullOrEmpty((String)this.configId))) {
            boolean bl = false;
            String string = "config id is null or empty";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String getConfigId() {
        return this.configId;
    }

    @NotNull
    public final Instant getLastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    @NotNull
    public final Instant getCreatedTime() {
        return this.createdTime;
    }

    @NotNull
    public final NotificationConfig getNotificationConfig() {
        return this.notificationConfig;
    }

    public NotificationConfigInfo(@NotNull StreamInput input) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = input.readString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readString(...)");
        Instant instant = input.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"readInstant(...)");
        Instant instant2 = input.readInstant();
        Intrinsics.checkNotNullExpressionValue((Object)instant2, (String)"readInstant(...)");
        Object object = NotificationConfig.Companion.getReader().read(input);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"read(...)");
        this(string, instant, instant2, (NotificationConfig)object);
    }

    public void writeTo(@NotNull StreamOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeString(this.configId);
        output.writeInstant(this.lastUpdatedTime);
        output.writeInstant(this.createdTime);
        this.notificationConfig.writeTo(output);
    }

    @NotNull
    public XContentBuilder toXContent(@Nullable XContentBuilder builder, @Nullable ToXContent.Params params) {
        Intrinsics.checkNotNull((Object)builder);
        XContentBuilder xContentBuilder = builder.startObject().field("config_id", this.configId).field("last_updated_time_ms", this.lastUpdatedTime.toEpochMilli()).field("created_time_ms", this.createdTime.toEpochMilli()).field("config", (ToXContent)this.notificationConfig).endObject();
        Intrinsics.checkNotNullExpressionValue((Object)xContentBuilder, (String)"endObject(...)");
        return xContentBuilder;
    }

    @NotNull
    public final String component1() {
        return this.configId;
    }

    @NotNull
    public final Instant component2() {
        return this.lastUpdatedTime;
    }

    @NotNull
    public final Instant component3() {
        return this.createdTime;
    }

    @NotNull
    public final NotificationConfig component4() {
        return this.notificationConfig;
    }

    @NotNull
    public final NotificationConfigInfo copy(@NotNull String configId, @NotNull Instant lastUpdatedTime, @NotNull Instant createdTime, @NotNull NotificationConfig notificationConfig) {
        Intrinsics.checkNotNullParameter((Object)configId, (String)"configId");
        Intrinsics.checkNotNullParameter((Object)lastUpdatedTime, (String)"lastUpdatedTime");
        Intrinsics.checkNotNullParameter((Object)createdTime, (String)"createdTime");
        Intrinsics.checkNotNullParameter((Object)notificationConfig, (String)"notificationConfig");
        return new NotificationConfigInfo(configId, lastUpdatedTime, createdTime, notificationConfig);
    }

    public static /* synthetic */ NotificationConfigInfo copy$default(NotificationConfigInfo notificationConfigInfo, String string, Instant instant, Instant instant2, NotificationConfig notificationConfig, int n, Object object) {
        if ((n & 1) != 0) {
            string = notificationConfigInfo.configId;
        }
        if ((n & 2) != 0) {
            instant = notificationConfigInfo.lastUpdatedTime;
        }
        if ((n & 4) != 0) {
            instant2 = notificationConfigInfo.createdTime;
        }
        if ((n & 8) != 0) {
            notificationConfig = notificationConfigInfo.notificationConfig;
        }
        return notificationConfigInfo.copy(string, instant, instant2, notificationConfig);
    }

    @NotNull
    public String toString() {
        return "NotificationConfigInfo(configId=" + this.configId + ", lastUpdatedTime=" + this.lastUpdatedTime + ", createdTime=" + this.createdTime + ", notificationConfig=" + this.notificationConfig + ")";
    }

    public int hashCode() {
        int result = this.configId.hashCode();
        result = result * 31 + this.lastUpdatedTime.hashCode();
        result = result * 31 + this.createdTime.hashCode();
        result = result * 31 + this.notificationConfig.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof NotificationConfigInfo)) {
            return false;
        }
        NotificationConfigInfo notificationConfigInfo = (NotificationConfigInfo)other;
        if (!Intrinsics.areEqual((Object)this.configId, (Object)notificationConfigInfo.configId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastUpdatedTime, (Object)notificationConfigInfo.lastUpdatedTime)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.createdTime, (Object)notificationConfigInfo.createdTime)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.notificationConfig, (Object)notificationConfigInfo.notificationConfig);
    }

    private static final NotificationConfigInfo reader$lambda$0(StreamInput it) {
        Intrinsics.checkNotNull((Object)it);
        return new NotificationConfigInfo(it);
    }

    @JvmStatic
    @NotNull
    public static final NotificationConfigInfo parse(@NotNull XContentParser parser) throws IOException {
        return Companion.parse(parser);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0007R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u001f\u0010\n\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\f0\f0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0013"}, d2={"Lorg/opensearch/commons/notifications/model/NotificationConfigInfo$Companion;", "", "<init>", "()V", "log", "Lorg/apache/logging/log4j/Logger;", "getLog", "()Lorg/apache/logging/log4j/Logger;", "log$delegate", "Lkotlin/Lazy;", "reader", "Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "Lorg/opensearch/commons/notifications/model/NotificationConfigInfo;", "kotlin.jvm.PlatformType", "getReader", "()Lorg/opensearch/core/common/io/stream/Writeable$Reader;", "parse", "parser", "Lorg/opensearch/core/xcontent/XContentParser;", "common-utils"})
    public static final class Companion {
        private Companion() {
        }

        private final Logger getLog() {
            Lazy lazy = log$delegate;
            return (Logger)lazy.getValue();
        }

        @NotNull
        public final Writeable.Reader<NotificationConfigInfo> getReader() {
            return reader;
        }

        @JvmStatic
        @NotNull
        public final NotificationConfigInfo parse(@NotNull XContentParser parser) throws IOException {
            Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
            String configId = null;
            Instant lastUpdatedTime = null;
            Instant createdTime = null;
            NotificationConfig notificationConfig = null;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            block12: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String fieldName;
                block21: {
                    fieldName = parser.currentName();
                    parser.nextToken();
                    String string = fieldName;
                    if (string == null) break block21;
                    int n = -1;
                    switch (string.hashCode()) {
                        case 786082091: {
                            if (string.equals("last_updated_time_ms")) {
                                n = 1;
                            }
                            break;
                        }
                        case 1513344513: {
                            if (string.equals("created_time_ms")) {
                                n = 2;
                            }
                            break;
                        }
                        case -804450504: {
                            if (string.equals("config_id")) {
                                n = 3;
                            }
                            break;
                        }
                        case -1354792126: {
                            if (string.equals("config")) {
                                n = 4;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 3: {
                            configId = parser.text();
                            continue block12;
                        }
                        case 1: {
                            lastUpdatedTime = Instant.ofEpochMilli(parser.longValue());
                            continue block12;
                        }
                        case 2: {
                            createdTime = Instant.ofEpochMilli(parser.longValue());
                            continue block12;
                        }
                        case 4: {
                            notificationConfig = NotificationConfig.Companion.parse(parser);
                            continue block12;
                        }
                    }
                }
                parser.skipChildren();
                this.getLog().info("Unexpected field: " + fieldName + ", while parsing configuration");
            }
            if (configId == null) {
                throw new IllegalArgumentException("config_id field absent");
            }
            if (lastUpdatedTime == null) {
                throw new IllegalArgumentException("last_updated_time_ms field absent");
            }
            if (createdTime == null) {
                throw new IllegalArgumentException("created_time_ms field absent");
            }
            if (notificationConfig == null) {
                throw new IllegalArgumentException("config field absent");
            }
            return new NotificationConfigInfo(configId, lastUpdatedTime, createdTime, notificationConfig);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

