/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.transport.grpc.proto.request.search.query;

import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.geo.GeoBoundingBox;
import org.opensearch.common.geo.GeoPoint;
import org.opensearch.common.geo.GeoUtils;
import org.opensearch.geometry.Geometry;
import org.opensearch.geometry.Rectangle;
import org.opensearch.geometry.ShapeType;
import org.opensearch.geometry.utils.GeometryValidator;
import org.opensearch.geometry.utils.StandardValidator;
import org.opensearch.geometry.utils.WellKnownText;
import org.opensearch.index.query.GeoBoundingBoxQueryBuilder;
import org.opensearch.index.query.GeoExecType;
import org.opensearch.protobufs.CoordsGeoBounds;
import org.opensearch.protobufs.GeoBoundingBoxQuery;
import org.opensearch.protobufs.GeoBounds;
import org.opensearch.protobufs.GeoExecution;
import org.opensearch.protobufs.GeoValidationMethod;
import org.opensearch.protobufs.TopLeftBottomRightGeoBounds;
import org.opensearch.protobufs.TopRightBottomLeftGeoBounds;
import org.opensearch.protobufs.WktGeoBounds;
import org.opensearch.transport.grpc.proto.request.common.GeoPointProtoUtils;

class GeoBoundingBoxQueryBuilderProtoUtils {
    private static final Logger logger = LogManager.getLogger(GeoBoundingBoxQueryBuilderProtoUtils.class);

    private GeoBoundingBoxQueryBuilderProtoUtils() {
    }

    static GeoBoundingBoxQueryBuilder fromProto(GeoBoundingBoxQuery geoBoundingBoxQueryProto) {
        if (geoBoundingBoxQueryProto == null) {
            throw new IllegalArgumentException("GeoBoundingBoxQuery cannot be null");
        }
        if (geoBoundingBoxQueryProto.getBoundingBoxMap().isEmpty()) {
            throw new IllegalArgumentException("GeoBoundingBoxQuery must have at least one bounding box");
        }
        String fieldName = (String)geoBoundingBoxQueryProto.getBoundingBoxMap().keySet().iterator().next();
        GeoBounds geoBounds = (GeoBounds)geoBoundingBoxQueryProto.getBoundingBoxMap().get(fieldName);
        float boost = 1.0f;
        String queryName = null;
        org.opensearch.index.query.GeoValidationMethod validationMethod = null;
        boolean ignoreUnmapped = false;
        GeoBoundingBox bbox = null;
        GeoExecType type = GeoExecType.MEMORY;
        bbox = GeoBoundingBoxQueryBuilderProtoUtils.parseBoundingBox(geoBounds);
        if (geoBoundingBoxQueryProto.hasXName()) {
            queryName = geoBoundingBoxQueryProto.getXName();
        }
        if (geoBoundingBoxQueryProto.hasBoost()) {
            boost = geoBoundingBoxQueryProto.getBoost();
        }
        if (geoBoundingBoxQueryProto.hasValidationMethod()) {
            validationMethod = GeoBoundingBoxQueryBuilderProtoUtils.parseValidationMethod(geoBoundingBoxQueryProto.getValidationMethod());
        }
        if (geoBoundingBoxQueryProto.hasIgnoreUnmapped()) {
            ignoreUnmapped = geoBoundingBoxQueryProto.getIgnoreUnmapped();
        }
        if (geoBoundingBoxQueryProto.hasType()) {
            type = GeoBoundingBoxQueryBuilderProtoUtils.parseExecutionType(geoBoundingBoxQueryProto.getType());
        }
        GeoBoundingBoxQueryBuilder builder = new GeoBoundingBoxQueryBuilder(fieldName);
        builder.setCorners(bbox.topLeft(), bbox.bottomRight());
        builder.queryName(queryName);
        builder.boost(boost);
        builder.type(type);
        builder.ignoreUnmapped(ignoreUnmapped);
        if (validationMethod != null) {
            builder.setValidationMethod(validationMethod);
        }
        return builder;
    }

    private static GeoBoundingBox parseBoundingBox(GeoBounds geoBounds) {
        GeoPoint bottomRight;
        GeoPoint topLeft;
        double top = Double.NaN;
        double bottom = Double.NaN;
        double left = Double.NaN;
        double right = Double.NaN;
        Rectangle envelope = null;
        GeoPoint sparse = new GeoPoint();
        if (geoBounds.hasCoords()) {
            CoordsGeoBounds coords = geoBounds.getCoords();
            top = coords.getTop();
            bottom = coords.getBottom();
            left = coords.getLeft();
            right = coords.getRight();
        } else if (geoBounds.hasTlbr()) {
            TopLeftBottomRightGeoBounds tlbr = geoBounds.getTlbr();
            GeoPointProtoUtils.parseGeoPoint(tlbr.getTopLeft(), sparse, false, GeoUtils.EffectivePoint.BOTTOM_LEFT);
            top = sparse.getLat();
            left = sparse.getLon();
            GeoPointProtoUtils.parseGeoPoint(tlbr.getBottomRight(), sparse, false, GeoUtils.EffectivePoint.BOTTOM_LEFT);
            bottom = sparse.getLat();
            right = sparse.getLon();
        } else if (geoBounds.hasTrbl()) {
            TopRightBottomLeftGeoBounds trbl = geoBounds.getTrbl();
            GeoPointProtoUtils.parseGeoPoint(trbl.getTopRight(), sparse, false, GeoUtils.EffectivePoint.BOTTOM_LEFT);
            top = sparse.getLat();
            right = sparse.getLon();
            GeoPointProtoUtils.parseGeoPoint(trbl.getBottomLeft(), sparse, false, GeoUtils.EffectivePoint.BOTTOM_LEFT);
            bottom = sparse.getLat();
            left = sparse.getLon();
        } else if (geoBounds.hasWkt()) {
            WktGeoBounds wkt = geoBounds.getWkt();
            try {
                WellKnownText wktParser = new WellKnownText(true, (GeometryValidator)new StandardValidator(true));
                Geometry geometry = wktParser.fromWKT(wkt.getWkt());
                if (!ShapeType.ENVELOPE.equals((Object)geometry.type())) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "failed to parse WKT bounding box. [%s] found. expected [%s]", geometry.type(), ShapeType.ENVELOPE));
                }
                envelope = (Rectangle)geometry;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("failed to parse WKT bounding box: " + wkt.getWkt(), e);
            }
        } else {
            throw new IllegalArgumentException("GeoBounds must have one of: coords, tlbr, trbl, or wkt");
        }
        if (envelope != null) {
            if (!(Double.isNaN(top) && Double.isNaN(bottom) && Double.isNaN(left) && Double.isNaN(right))) {
                throw new IllegalArgumentException("failed to parse bounding box. Conflicting definition found using well-known text and explicit corners.");
            }
            topLeft = new GeoPoint(envelope.getMaxLat(), envelope.getMinLon());
            bottomRight = new GeoPoint(envelope.getMinLat(), envelope.getMaxLon());
            return new GeoBoundingBox(topLeft, bottomRight);
        }
        topLeft = new GeoPoint(top, left);
        bottomRight = new GeoPoint(bottom, right);
        return new GeoBoundingBox(topLeft, bottomRight);
    }

    private static GeoExecType parseExecutionType(GeoExecution executionTypeProto) {
        switch (executionTypeProto) {
            case GEO_EXECUTION_MEMORY: {
                return GeoExecType.MEMORY;
            }
            case GEO_EXECUTION_INDEXED: {
                return GeoExecType.INDEXED;
            }
        }
        return GeoExecType.MEMORY;
    }

    private static org.opensearch.index.query.GeoValidationMethod parseValidationMethod(GeoValidationMethod validationMethodProto) {
        switch (validationMethodProto) {
            case GEO_VALIDATION_METHOD_COERCE: {
                return org.opensearch.index.query.GeoValidationMethod.COERCE;
            }
            case GEO_VALIDATION_METHOD_IGNORE_MALFORMED: {
                return org.opensearch.index.query.GeoValidationMethod.IGNORE_MALFORMED;
            }
            case GEO_VALIDATION_METHOD_STRICT: {
                return org.opensearch.index.query.GeoValidationMethod.STRICT;
            }
        }
        return org.opensearch.index.query.GeoValidationMethod.STRICT;
    }
}

