/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.wizards.ui;

import com.sun.star.awt.ActionEvent;
import com.sun.star.awt.FontDescriptor;
import com.sun.star.awt.ItemEvent;
import com.sun.star.awt.XControl;
import com.sun.star.awt.XItemEventBroadcaster;
import com.sun.star.awt.XItemListener;
import com.sun.star.awt.XTopWindow;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.XIndexContainer;
import com.sun.star.frame.TerminationVetoException;
import com.sun.star.frame.XTerminateListener;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.wizards.common.Desktop;
import com.sun.star.wizards.common.HelpIds;
import com.sun.star.wizards.common.Helper;
import com.sun.star.wizards.common.PropertyNames;
import com.sun.star.wizards.common.Resource;
import com.sun.star.wizards.ui.UnoDialog2;
import com.sun.star.wizards.ui.event.XActionListenerAdapter;
import com.sun.star.wizards.ui.event.XItemListenerAdapter;
import java.beans.PropertyChangeEvent;
import java.beans.VetoableChangeListener;

public abstract class WizardDialog
extends UnoDialog2
implements VetoableChangeListener,
XTerminateListener {
    private static final int iButtonWidth = 50;
    private int nNewStep = 1;
    private int nOldStep = 1;
    private int nMaxStep = 1;
    private String[] sRMItemLabels;
    private Object oRoadmap;
    private XSingleServiceFactory xSSFRoadmap;
    protected XIndexContainer xIndexContRoadmap;
    private final Resource oWizardResource;
    private final int hid;
    private boolean bTerminateListenermustberemoved = true;

    public WizardDialog(XMultiServiceFactory xMultiServiceFactory, int n) {
        super(xMultiServiceFactory);
        this.hid = n;
        this.oWizardResource = new Resource(xMultiServiceFactory);
        this.oWizardResource.getResText("RID_DB_COMMON_33");
    }

    @Override
    public Resource getResource() {
        return this.oWizardResource;
    }

    private void activate() {
        try {
            XTopWindow xTopWindow = (XTopWindow)UnoRuntime.queryInterface(XTopWindow.class, (Object)this.xWindow);
            if (xTopWindow != null) {
                xTopWindow.toFront();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setMaxStep(int n) {
        this.nMaxStep = n;
    }

    public int getNewStep() {
        return this.nNewStep;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent propertyChangeEvent) {
        this.nNewStep = this.nOldStep;
    }

    public void setRoadmapInteractive(boolean bl) {
        Helper.setUnoPropertyValue(this.oRoadmap, "Activated", bl);
    }

    public void setRoadmapComplete(boolean bl) {
        Helper.setUnoPropertyValue(this.oRoadmap, "Complete", bl);
    }

    private boolean isRoadmapComplete() {
        try {
            return AnyConverter.toBoolean((Object)Helper.getUnoPropertyValue(this.oRoadmap, "Complete"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(System.err);
            return false;
        }
    }

    public void setCurrentRoadmapItemID(short s) {
        int n;
        if (this.oRoadmap != null && (n = this.getCurrentRoadmapItemID()) != s) {
            Helper.setUnoPropertyValue(this.oRoadmap, "CurrentItemID", s);
        }
    }

    private int getCurrentRoadmapItemID() {
        try {
            return AnyConverter.toInt((Object)Helper.getUnoPropertyValue(this.oRoadmap, "CurrentItemID"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(System.err);
            return -1;
        }
    }

    public void addRoadmap() {
        try {
            int n = (Integer)Helper.getUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_HEIGHT);
            this.oRoadmap = this.insertControlModel("com.sun.star.awt.UnoControlRoadmapModel", "rdmNavi", new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, "Tabstop", PropertyNames.PROPERTY_WIDTH}, new Object[]{n - 26, 0, 0, 0, (short)0, Boolean.TRUE, 85});
            XPropertySet xPropertySet = (XPropertySet)UnoRuntime.queryInterface(XPropertySet.class, (Object)this.oRoadmap);
            xPropertySet.setPropertyValue(PropertyNames.PROPERTY_NAME, (Object)"rdmNavi");
            this.xSSFRoadmap = (XSingleServiceFactory)UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)this.oRoadmap);
            this.xIndexContRoadmap = (XIndexContainer)UnoRuntime.queryInterface(XIndexContainer.class, (Object)this.oRoadmap);
            XControl xControl = this.xDlgContainer.getControl("rdmNavi");
            XItemEventBroadcaster xItemEventBroadcaster = (XItemEventBroadcaster)UnoRuntime.queryInterface(XItemEventBroadcaster.class, (Object)xControl);
            xItemEventBroadcaster.addItemListener((XItemListener)new XItemListenerAdapter(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    try {
                        WizardDialog.this.nNewStep = itemEvent.ItemId;
                        WizardDialog.this.nOldStep = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(WizardDialog.this.xDialogModel, PropertyNames.PROPERTY_STEP));
                        if (WizardDialog.this.nNewStep != WizardDialog.this.nOldStep) {
                            WizardDialog.this.switchToStep();
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        illegalArgumentException.printStackTrace(System.err);
                    }
                }
            });
            Helper.setUnoPropertyValue(this.oRoadmap, "Text", this.oWizardResource.getResText("RID_COMMON_16"));
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void setRMItemLabels(Resource resource) {
        this.sRMItemLabels = new String[this.nMaxStep];
        for (int i = 0; i < this.nMaxStep; ++i) {
            this.sRMItemLabels[i] = resource.getResText("RID_QUERY_" + String.valueOf(i + 80));
        }
    }

    public int insertRoadmapItem(int n, boolean bl, int n2, int n3) {
        return this.insertRoadmapItem(n, bl, this.sRMItemLabels[n2], n3);
    }

    public int insertRoadmapItem(int n, boolean bl, String string, int n2) {
        try {
            Object object = this.xSSFRoadmap.createInstance();
            Helper.setUnoPropertyValue(object, PropertyNames.PROPERTY_LABEL, string);
            Helper.setUnoPropertyValue(object, PropertyNames.PROPERTY_ENABLED, bl);
            Helper.setUnoPropertyValue(object, "ID", n2);
            this.xIndexContRoadmap.insertByIndex(n, object);
            return n + 1;
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
            return -1;
        }
    }

    public int getRMItemCount() {
        return this.xIndexContRoadmap.getCount();
    }

    public XInterface getRoadmapItemByID(int n) {
        try {
            for (int i = 0; i < this.xIndexContRoadmap.getCount(); ++i) {
                XInterface xInterface = (XInterface)this.xIndexContRoadmap.getByIndex(i);
                int n2 = AnyConverter.toInt((Object)Helper.getUnoPropertyValue(xInterface, "ID"));
                if (n2 != n) continue;
                return xInterface;
            }
            return null;
        }
        catch (com.sun.star.uno.Exception exception) {
            exception.printStackTrace(System.err);
            return null;
        }
    }

    public boolean switchToStep(int n, int n2) {
        this.nOldStep = n;
        this.nNewStep = n2;
        return this.switchToStep();
    }

    private boolean switchToStep() {
        this.leaveStep(this.nOldStep, this.nNewStep);
        if (this.nNewStep != this.nOldStep) {
            if (this.nNewStep == this.nMaxStep) {
                this.setControlProperty("btnWizardNext", "DefaultButton", Boolean.FALSE);
                this.setControlProperty("btnWizardFinish", "DefaultButton", Boolean.TRUE);
            } else {
                this.setControlProperty("btnWizardNext", "DefaultButton", Boolean.TRUE);
                this.setControlProperty("btnWizardFinish", "DefaultButton", Boolean.FALSE);
            }
            this.changeToStep(this.nNewStep);
            this.enterStep(this.nOldStep, this.nNewStep);
            return true;
        }
        return false;
    }

    protected abstract void leaveStep(int var1, int var2);

    protected abstract void enterStep(int var1, int var2);

    private void changeToStep(int n) {
        Helper.setUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_STEP, n);
        this.setCurrentRoadmapItemID((short)n);
        this.enableNextButton(this.getNextAvailableStep() > 0);
        this.enableBackButton(n != 1);
    }

    public void drawNaviBar() {
        try {
            short s = 30000;
            Integer n = 50;
            int n2 = 14;
            Integer n3 = n2;
            Integer n4 = 0;
            int n5 = (Integer)Helper.getUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_HEIGHT);
            int n6 = (Integer)Helper.getUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_WIDTH);
            int n7 = 8;
            int n8 = n5 - n2 - 6;
            int n9 = n6 - 50 - 6;
            int n10 = n9 - 6 - 50;
            int n11 = n10 - 6 - 50;
            int n12 = n11 - 3 - 50;
            this.insertControlModel("com.sun.star.awt.UnoControlFixedLineModel", "lnNaviSep", new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.ORIENTATION, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_WIDTH}, new Object[]{1, 0, 0, n5 - 26, n4, n6});
            this.insertControlModel("com.sun.star.awt.UnoControlFixedLineModel", "lnRoadSep", new String[]{PropertyNames.PROPERTY_HEIGHT, PropertyNames.ORIENTATION, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_WIDTH}, new Object[]{n8 - 6, 1, 85, 0, n4, 1});
            String[] stringArray = new String[]{PropertyNames.PROPERTY_ENABLED, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_HELPURL, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, "PushButtonType", PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH};
            Helper.setUnoPropertyValue(this.xDialogModel, PropertyNames.PROPERTY_HELPURL, HelpIds.getHelpIdString(this.hid));
            Object[] objectArray = new Object[9];
            objectArray[0] = true;
            objectArray[1] = n3;
            objectArray[2] = this.oWizardResource.getResText("RID_COMMON_15");
            objectArray[3] = n7;
            objectArray[4] = n8;
            objectArray[5] = (short)3;
            objectArray[6] = n4;
            short s2 = s;
            s = (short)(s + 1);
            objectArray[7] = s2;
            objectArray[8] = n;
            this.insertButton("btnWizardHelp", new XActionListenerAdapter(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WizardDialog.this.callHelp();
                }
            }, new String[]{PropertyNames.PROPERTY_ENABLED, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, "PushButtonType", PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, objectArray);
            Object[] objectArray2 = new Object[10];
            objectArray2[0] = false;
            objectArray2[1] = n3;
            objectArray2[2] = HelpIds.getHelpIdString(this.hid + 2);
            objectArray2[3] = this.oWizardResource.getResText("RID_COMMON_13");
            objectArray2[4] = n12;
            objectArray2[5] = n8;
            objectArray2[6] = (short)0;
            objectArray2[7] = n4;
            short s3 = s;
            s = (short)(s + 1);
            objectArray2[8] = s3;
            objectArray2[9] = n;
            this.insertButton("btnWizardBack", new XActionListenerAdapter(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WizardDialog.this.gotoPreviousAvailableStep();
                }
            }, stringArray, objectArray2);
            Object[] objectArray3 = new Object[10];
            objectArray3[0] = true;
            objectArray3[1] = n3;
            objectArray3[2] = HelpIds.getHelpIdString(this.hid + 3);
            objectArray3[3] = this.oWizardResource.getResText("RID_COMMON_14");
            objectArray3[4] = n11;
            objectArray3[5] = n8;
            objectArray3[6] = (short)0;
            objectArray3[7] = n4;
            short s4 = s;
            s = (short)(s + 1);
            objectArray3[8] = s4;
            objectArray3[9] = n;
            this.insertButton("btnWizardNext", new XActionListenerAdapter(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WizardDialog.this.gotoNextAvailableStep();
                }
            }, stringArray, objectArray3);
            Object[] objectArray4 = new Object[10];
            objectArray4[0] = true;
            objectArray4[1] = n3;
            objectArray4[2] = HelpIds.getHelpIdString(this.hid + 4);
            objectArray4[3] = this.oWizardResource.getResText("RID_COMMON_12");
            objectArray4[4] = n10;
            objectArray4[5] = n8;
            objectArray4[6] = (short)0;
            objectArray4[7] = n4;
            short s5 = s;
            s = (short)(s + 1);
            objectArray4[8] = s5;
            objectArray4[9] = n;
            this.insertButton("btnWizardFinish", new XActionListenerAdapter(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WizardDialog.this.finishWizard_1();
                }
            }, stringArray, objectArray4);
            Object[] objectArray5 = new Object[10];
            objectArray5[0] = true;
            objectArray5[1] = n3;
            objectArray5[2] = HelpIds.getHelpIdString(this.hid + 5);
            objectArray5[3] = this.oWizardResource.getResText("RID_COMMON_11");
            objectArray5[4] = n9;
            objectArray5[5] = n8;
            objectArray5[6] = (short)0;
            objectArray5[7] = n4;
            short s6 = s;
            s = (short)(s + 1);
            objectArray5[8] = s6;
            objectArray5[9] = n;
            this.insertButton("btnWizardCancel", new XActionListenerAdapter(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    WizardDialog.this.cancelWizard_1();
                }
            }, stringArray, objectArray5);
            this.setControlProperty("btnWizardNext", "DefaultButton", Boolean.TRUE);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.err);
        }
    }

    public void enableNavigationButtons(boolean bl, boolean bl2, boolean bl3) {
        this.enableBackButton(bl);
        this.enableNextButton(bl2);
        this.enableFinishButton(bl3);
    }

    private void enableBackButton(boolean bl) {
        this.setControlProperty("btnWizardBack", PropertyNames.PROPERTY_ENABLED, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void enableNextButton(boolean bl) {
        this.setControlProperty("btnWizardNext", PropertyNames.PROPERTY_ENABLED, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void enableFinishButton(boolean bl) {
        this.setControlProperty("btnWizardFinish", PropertyNames.PROPERTY_ENABLED, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void setStepEnabled(int n, boolean bl) {
        XInterface xInterface = this.getRoadmapItemByID(n);
        if (xInterface != null) {
            Helper.setUnoPropertyValue(xInterface, PropertyNames.PROPERTY_ENABLED, bl);
        }
    }

    public void enablefromStep(int n, boolean bl) {
        if (n <= this.nMaxStep) {
            for (int i = n; i <= this.nMaxStep; ++i) {
                this.setStepEnabled(i, bl);
            }
            this.enableFinishButton(bl);
            if (!bl) {
                this.enableNextButton(n > this.getCurrentStep() + 1);
            } else {
                this.enableNextButton(this.getCurrentStep() != this.nMaxStep);
            }
        }
    }

    private boolean isStepEnabled(int n) {
        try {
            XInterface xInterface = this.getRoadmapItemByID(n);
            if (xInterface == null) {
                return false;
            }
            boolean bl = AnyConverter.toBoolean((Object)Helper.getUnoPropertyValue(xInterface, PropertyNames.PROPERTY_ENABLED));
            return bl;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(System.err);
            return false;
        }
    }

    private synchronized void gotoPreviousAvailableStep() {
        if (this.nNewStep > 1) {
            boolean bl;
            this.nOldStep = this.nNewStep--;
            while (this.nNewStep > 0 && !(bl = this.isStepEnabled(this.nNewStep))) {
                --this.nNewStep;
            }
            if (this.nNewStep == 0) {
                this.nNewStep = this.nOldStep;
            }
            this.switchToStep();
        }
    }

    private int getNextAvailableStep() {
        if (this.isRoadmapComplete()) {
            for (int i = this.nNewStep + 1; i <= this.nMaxStep; ++i) {
                if (!this.isStepEnabled(i)) continue;
                return i;
            }
        }
        return -1;
    }

    private synchronized void gotoNextAvailableStep() {
        this.nOldStep = this.nNewStep;
        this.nNewStep = this.getNextAvailableStep();
        if (this.nNewStep > -1) {
            this.switchToStep();
        }
    }

    public abstract boolean finishWizard();

    private void finishWizard_1() {
        this.enableFinishButton(false);
        boolean bl = false;
        try {
            bl = this.finishWizard();
        }
        finally {
            if (!bl) {
                this.enableFinishButton(true);
            }
        }
        if (bl) {
            this.removeTerminateListener();
        }
    }

    public int getCurrentStep() {
        try {
            return AnyConverter.toInt((Object)Helper.getUnoPropertyValue(this.MSFDialogModel, PropertyNames.PROPERTY_STEP));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(System.err);
            return -1;
        }
    }

    public void setCurrentStep(int n) {
        this.nNewStep = n;
        this.changeToStep(this.nNewStep);
    }

    public void setRightPaneHeaders(Resource resource, String string, int n, int n2) {
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            stringArray[i] = resource.getResText(string + String.valueOf(i + n));
        }
        this.setRightPaneHeaders(stringArray);
    }

    public void setRightPaneHeaders(String[] stringArray) {
        this.nMaxStep = stringArray.length;
        FontDescriptor fontDescriptor = new FontDescriptor();
        fontDescriptor.Weight = 150.0f;
        for (int i = 0; i < stringArray.length; ++i) {
            this.insertLabel("lblQueryTitle" + i, new String[]{PropertyNames.FONT_DESCRIPTOR, PropertyNames.PROPERTY_HEIGHT, PropertyNames.PROPERTY_LABEL, PropertyNames.PROPERTY_MULTILINE, PropertyNames.PROPERTY_POSITION_X, PropertyNames.PROPERTY_POSITION_Y, PropertyNames.PROPERTY_STEP, PropertyNames.PROPERTY_TABINDEX, PropertyNames.PROPERTY_WIDTH}, new Object[]{fontDescriptor, 16, stringArray[i], Boolean.TRUE, 91, 8, i + 1, (short)12, 212});
        }
    }

    public void cancelWizard() {
        this.xDialog.endExecute();
    }

    private void callHelp() {
    }

    private void removeTerminateListener() {
        if (this.bTerminateListenermustberemoved) {
            Desktop.getDesktop(this.xMSF).removeTerminateListener((XTerminateListener)this);
            this.bTerminateListenermustberemoved = false;
        }
    }

    private void cancelWizard_1() {
        this.cancelWizard();
        this.removeTerminateListener();
    }

    public void notifyTermination(EventObject eventObject) {
        this.cancelWizard_1();
    }

    public void queryTermination(EventObject eventObject) throws TerminationVetoException {
        this.activate();
        throw new TerminationVetoException();
    }

    public void disposing(EventObject eventObject) {
        this.cancelWizard_1();
    }
}

