/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler.sockjs.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.impl.HttpUtils;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.impl.ConnectionBase;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import io.vertx.ext.web.handler.sockjs.impl.BaseTransport;
import io.vertx.ext.web.handler.sockjs.impl.SockJSSocketBase;
import io.vertx.ext.web.impl.Origin;

class RawWebSocketTransport {
    private final Origin origin;
    private final Vertx vertx;
    private final SockJSHandlerOptions options;
    private final Handler<SockJSSocket> sockHandler;

    RawWebSocketTransport(Vertx vertx, Router router, SockJSHandlerOptions options, Handler<SockJSSocket> sockHandler) {
        this.vertx = vertx;
        this.options = options;
        this.origin = options.getOrigin() != null ? Origin.parse(options.getOrigin()) : null;
        this.sockHandler = sockHandler;
        router.get("/websocket").handler(this::handleGet);
        router.route("/websocket").handler(rc -> rc.response().putHeader(HttpHeaders.ALLOW, (CharSequence)"GET").setStatusCode(405).end());
    }

    private void handleGet(RoutingContext ctx) {
        HttpServerRequest req = ctx.request();
        if (!HttpUtils.canUpgradeToWebSocket((HttpServerRequest)req)) {
            ctx.response().setStatusCode(400);
            ctx.response().end("Can \"Upgrade\" only to \"WebSocket\".");
            return;
        }
        if (!Origin.check(this.origin, ctx)) {
            ctx.fail(403, (Throwable)new VertxException("Invalid Origin", true));
            return;
        }
        req.toWebSocket().onFailure(ctx::fail).onSuccess(socket -> {
            RawWSSockJSSocket sock = new RawWSSockJSSocket(this.vertx, ctx, this.options, (ServerWebSocket)socket);
            this.sockHandler.handle((Object)sock);
        });
    }

    private static class RawWSSockJSSocket
    extends SockJSSocketBase {
        final ServerWebSocket ws;
        MultiMap headers;
        boolean closed;

        RawWSSockJSSocket(Vertx vertx, RoutingContext rc, SockJSHandlerOptions options, ServerWebSocket ws) {
            super(vertx, rc, options);
            this.ws = ws;
            ws.closeHandler(v -> {
                RawWSSockJSSocket rawWSSockJSSocket = this;
                synchronized (rawWSSockJSSocket) {
                    this.closed = true;
                }
                RawWSSockJSSocket.super.close();
            });
        }

        @Override
        public SockJSSocket handler(Handler<Buffer> handler) {
            this.ws.binaryMessageHandler(handler);
            this.ws.textMessageHandler(textMessage -> handler.handle((Object)Buffer.buffer((String)textMessage)));
            return this;
        }

        @Override
        public SockJSSocket pause() {
            this.ws.pause();
            return this;
        }

        @Override
        public SockJSSocket resume() {
            this.ws.resume();
            return this;
        }

        @Override
        public SockJSSocket fetch(long amount) {
            this.ws.fetch(amount);
            return this;
        }

        @Override
        public Future<Void> write(Buffer data) {
            if (!this.closed) {
                return this.ws.writeBinaryMessage(data);
            }
            PromiseInternal promise = ((VertxInternal)this.vertx).promise();
            this.vertx.runOnContext(arg_0 -> RawWSSockJSSocket.lambda$write$2((Promise)promise, arg_0));
            return promise.future();
        }

        @Override
        public Future<Void> write(String data) {
            if (!this.closed) {
                return this.ws.writeTextMessage(data);
            }
            PromiseInternal promise = ((VertxInternal)this.vertx).promise();
            this.vertx.runOnContext(arg_0 -> RawWSSockJSSocket.lambda$write$3((Promise)promise, arg_0));
            return promise.future();
        }

        @Override
        public SockJSSocket setWriteQueueMaxSize(int maxQueueSize) {
            this.ws.setWriteQueueMaxSize(maxQueueSize);
            return this;
        }

        public boolean writeQueueFull() {
            return this.ws.writeQueueFull();
        }

        @Override
        public SockJSSocket drainHandler(Handler<Void> handler) {
            this.ws.drainHandler(handler);
            return this;
        }

        @Override
        public SockJSSocket exceptionHandler(Handler<Throwable> handler) {
            this.ws.exceptionHandler(handler);
            return this;
        }

        @Override
        public SockJSSocket endHandler(Handler<Void> endHandler) {
            this.ws.endHandler(endHandler);
            return this;
        }

        @Override
        public SockJSSocket closeHandler(Handler<Void> closeHandler) {
            this.ws.closeHandler(closeHandler);
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            RawWSSockJSSocket rawWSSockJSSocket = this;
            synchronized (rawWSSockJSSocket) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            super.close();
            this.ws.close();
        }

        @Override
        public void closeAfterSessionExpired() {
            this.close(1001, "Session expired");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close(int statusCode, String reason) {
            RawWSSockJSSocket rawWSSockJSSocket = this;
            synchronized (rawWSSockJSSocket) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            super.close();
            this.ws.close((short)statusCode, reason);
        }

        @Override
        public SocketAddress remoteAddress() {
            return this.ws.remoteAddress();
        }

        @Override
        public SocketAddress localAddress() {
            return this.ws.localAddress();
        }

        @Override
        public MultiMap headers() {
            if (this.headers == null) {
                this.headers = BaseTransport.removeCookieHeaders(this.ws.headers());
            }
            return this.headers;
        }

        @Override
        public String uri() {
            return this.ws.uri();
        }

        private static /* synthetic */ void lambda$write$3(Promise promise, Void v) {
            promise.fail((Throwable)ConnectionBase.CLOSED_EXCEPTION);
        }

        private static /* synthetic */ void lambda$write$2(Promise promise, Void v) {
            promise.fail((Throwable)ConnectionBase.CLOSED_EXCEPTION);
        }
    }
}

