/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.jpa.HibernateHints;
import org.hibernate.jpa.SpecHints;

public class HintsCollector {
    private static final Set<String> HINTS = HintsCollector.buildHintsSet();

    public static Set<String> getDefinedHints() {
        return HINTS;
    }

    private static Set<String> buildHintsSet() {
        HashSet<String> hints = new HashSet<String>();
        HintsCollector.applyHints(hints, HibernateHints.class);
        HintsCollector.applyHints(hints, SpecHints.class);
        return Collections.unmodifiableSet(hints);
    }

    private static void applyHints(HashSet<String> hints, Class<?> hintsClass) {
        Field[] fields = hintsClass.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            if (!field.getName().startsWith("HINT_") || !field.getType().equals(String.class)) continue;
            try {
                hints.add((String)field.get(hintsClass));
                continue;
            }
            catch (IllegalAccessException e) {
                throw new HibernateException("Unable to generate set of all hints - " + hintsClass.getName(), e);
            }
        }
    }
}

