/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.caffeine.runtime.graal;

import java.lang.reflect.Executable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeReflection;

public class CacheConstructorsFeature
implements Feature {
    public static final String REGISTER_RECORD_STATS_IMPLEMENTATIONS = "io.quarkus.caffeine.graalvm.recordStats";
    private static final boolean log = Boolean.getBoolean("io.quarkus.caffeine.graalvm.diagnostics");
    private final AtomicBoolean triggered = new AtomicBoolean(false);

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        Class caffeineCoreClazz = access.findClassByName("com.github.benmanes.caffeine.cache.Caffeine");
        access.registerReachabilityHandler(this::ensureCaffeineSupportEnabled, new Object[]{caffeineCoreClazz});
    }

    private void ensureCaffeineSupportEnabled(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        boolean needsEnablingYet = this.triggered.compareAndSet(false, true);
        if (needsEnablingYet) {
            if (log) {
                System.out.println("Quarkus's automatic feature for GraalVM native images: enabling support for core Caffeine caches");
            }
            this.registerCaffeineReflections(duringAnalysisAccess);
        }
    }

    private void registerCaffeineReflections(Feature.DuringAnalysisAccess duringAnalysisAccess) {
        String[] needsHavingSimpleConstructors;
        for (String className : needsHavingSimpleConstructors = CacheConstructorsFeature.typesNeedingConstructorsRegistered()) {
            this.registerForReflection(className, duringAnalysisAccess);
        }
        if (Boolean.getBoolean(REGISTER_RECORD_STATS_IMPLEMENTATIONS)) {
            for (String className : CacheConstructorsFeature.typesNeedingConstructorsRegisteredWhenRecordingStats()) {
                this.registerForReflection(className, duringAnalysisAccess);
            }
        }
    }

    private void registerForReflection(String className, Feature.DuringAnalysisAccess duringAnalysisAccess) {
        Class aClass = duringAnalysisAccess.findClassByName(className);
        Executable[] z = aClass.getDeclaredConstructors();
        RuntimeReflection.register((Class[])new Class[]{aClass});
        RuntimeReflection.register((Executable[])z);
        RuntimeReflection.registerFieldLookup((Class)aClass, (String)"FACTORY");
    }

    public static String[] typesNeedingConstructorsRegistered() {
        return new String[]{"com.github.benmanes.caffeine.cache.PDMS", "com.github.benmanes.caffeine.cache.PSA", "com.github.benmanes.caffeine.cache.PSAW", "com.github.benmanes.caffeine.cache.PSMS", "com.github.benmanes.caffeine.cache.PSW", "com.github.benmanes.caffeine.cache.PSMW", "com.github.benmanes.caffeine.cache.PSAMW", "com.github.benmanes.caffeine.cache.PSAWMW", "com.github.benmanes.caffeine.cache.PSWMS", "com.github.benmanes.caffeine.cache.PSWMW", "com.github.benmanes.caffeine.cache.SILMS", "com.github.benmanes.caffeine.cache.SSA", "com.github.benmanes.caffeine.cache.SSAW", "com.github.benmanes.caffeine.cache.SSLA", "com.github.benmanes.caffeine.cache.SSLMS", "com.github.benmanes.caffeine.cache.SSMS", "com.github.benmanes.caffeine.cache.SSMSA", "com.github.benmanes.caffeine.cache.SSMSAW", "com.github.benmanes.caffeine.cache.SSMSW", "com.github.benmanes.caffeine.cache.SSW"};
    }

    public static String[] typesNeedingConstructorsRegisteredWhenRecordingStats() {
        return new String[]{"com.github.benmanes.caffeine.cache.SILSMS", "com.github.benmanes.caffeine.cache.SSSA", "com.github.benmanes.caffeine.cache.SSLSA", "com.github.benmanes.caffeine.cache.SSLSMS", "com.github.benmanes.caffeine.cache.SSSMS", "com.github.benmanes.caffeine.cache.SSSMSA", "com.github.benmanes.caffeine.cache.SSSMSW", "com.github.benmanes.caffeine.cache.SSSMSAW", "com.github.benmanes.caffeine.cache.SSSW", "com.github.benmanes.caffeine.cache.SSSAW"};
    }
}

