/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Incubating;
import org.hibernate.Internal;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.relational.QualifiedTableName;
import org.hibernate.boot.model.relational.SqlStringGenerationContext;
import org.hibernate.dialect.Dialect;
import org.hibernate.internal.util.collections.ArrayHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;
import org.hibernate.tool.schema.extract.spi.ColumnInformation;
import org.hibernate.tool.schema.extract.spi.TableInformation;
import org.hibernate.tool.schema.internal.ColumnDefinitions;
import org.hibernate.tool.schema.spi.TableMigrator;
import org.jboss.logging.Logger;

@Incubating
public class StandardTableMigrator
implements TableMigrator {
    private static final Logger log = Logger.getLogger(Table.class);
    protected final Dialect dialect;

    public StandardTableMigrator(Dialect dialect) {
        this.dialect = dialect;
    }

    @Override
    public String[] getSqlAlterStrings(Table table, Metadata metadata, TableInformation tableInfo, SqlStringGenerationContext context) {
        if (table.isView()) {
            return ArrayHelper.EMPTY_STRING_ARRAY;
        }
        return StandardTableMigrator.sqlAlterStrings(table, this.dialect, metadata, tableInfo, context).toArray(ArrayHelper.EMPTY_STRING_ARRAY);
    }

    @Internal
    public static List<String> sqlAlterStrings(Table table, Dialect dialect, Metadata metadata, TableInformation tableInformation, SqlStringGenerationContext context) throws HibernateException {
        String tableName = context.format(new QualifiedTableName(Identifier.toIdentifier(table.getCatalog(), table.isCatalogQuoted()), Identifier.toIdentifier(table.getSchema(), table.isSchemaQuoted()), table.getNameIdentifier()));
        String alterTable = dialect.getAlterTableString(tableName) + " ";
        ArrayList<String> results = new ArrayList<String>();
        for (Column column : table.getColumns()) {
            ColumnInformation columnInformation = tableInformation.getColumn(Identifier.toIdentifier(column.getName(), column.isQuoted()));
            if (columnInformation == null) {
                String addColumn = dialect.getAddColumnString() + " " + ColumnDefinitions.getFullColumnDeclaration(column, table, metadata, dialect, context) + dialect.getAddColumnSuffixString();
                results.add(alterTable + addColumn);
                continue;
            }
            if (!dialect.supportsAlterColumnType() || ColumnDefinitions.hasMatchingType(column, columnInformation, metadata, dialect) && ColumnDefinitions.hasMatchingLength(column, columnInformation, metadata, dialect)) continue;
            String alterColumn = dialect.getAlterColumnTypeString(column.getQuotedName(dialect), column.getSqlType(metadata), ColumnDefinitions.getColumnDefinition(column, metadata, dialect));
            results.add(alterTable + alterColumn);
        }
        if (results.isEmpty()) {
            log.debugf("No alter strings for table : %s", (Object)table.getQuotedName());
        }
        return results;
    }
}

