/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Formatter;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import org.jboss.logmanager.ExtHandler;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.handlers.ClientSocketFactory;
import org.jboss.logmanager.handlers.TcpOutputStream;
import org.jboss.logmanager.handlers.UdpOutputStream;
import org.jboss.logmanager.handlers.UninterruptibleOutputStream;

public class SocketHandler
extends ExtHandler {
    public static final int DEFAULT_PORT = 4560;
    private ClientSocketFactory clientSocketFactory;
    private SocketFactory socketFactory;
    private InetAddress address;
    private int port;
    private Protocol protocol;
    private boolean blockOnReconnect;
    private Writer writer;
    private boolean initialize;

    public SocketHandler() throws UnknownHostException {
        this(InetAddress.getLocalHost(), 4560);
    }

    public SocketHandler(String hostname, int port) throws UnknownHostException {
        this(InetAddress.getByName(hostname), port);
    }

    public SocketHandler(InetAddress address, int port) {
        this(Protocol.TCP, address, port);
    }

    public SocketHandler(Protocol protocol, String hostname, int port) throws UnknownHostException {
        this(protocol, InetAddress.getByName(hostname), port);
    }

    public SocketHandler(Protocol protocol, InetAddress address, int port) {
        this(null, protocol, address, port);
    }

    public SocketHandler(SocketFactory socketFactory, Protocol protocol, String hostname, int port) throws UnknownHostException {
        this(socketFactory, protocol, InetAddress.getByName(hostname), port);
    }

    public SocketHandler(SocketFactory socketFactory, Protocol protocol, InetAddress address, int port) {
        this.socketFactory = socketFactory;
        this.clientSocketFactory = null;
        this.address = address;
        this.port = port;
        this.protocol = protocol == null ? Protocol.TCP : protocol;
        this.initialize = true;
        this.writer = null;
        this.blockOnReconnect = false;
    }

    public SocketHandler(ClientSocketFactory clientSocketFactory, Protocol protocol) {
        this.clientSocketFactory = clientSocketFactory;
        if (clientSocketFactory != null) {
            this.address = clientSocketFactory.getAddress();
            this.port = clientSocketFactory.getPort();
        }
        this.protocol = protocol == null ? Protocol.TCP : protocol;
        this.initialize = true;
        this.writer = null;
        this.blockOnReconnect = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPublish(ExtLogRecord record) {
        String formatted;
        Formatter formatter = this.getFormatter();
        try {
            formatted = formatter.format(record);
        }
        catch (Exception e) {
            this.reportError("Could not format message", e, 5);
            return;
        }
        if (formatted.isEmpty()) {
            return;
        }
        try {
            this.lock.lock();
            try {
                if (this.initialize) {
                    this.initialize();
                    this.initialize = false;
                }
                if (this.writer == null) {
                    return;
                }
                this.writer.write(formatted);
                super.doPublish(record);
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (Exception e) {
            this.reportError("Error writing log message", e, 1);
        }
    }

    @Override
    public void flush() {
        this.lock.lock();
        try {
            this.safeFlush(this.writer);
        }
        finally {
            this.lock.unlock();
        }
        super.flush();
    }

    @Override
    public void close() throws SecurityException {
        SocketHandler.checkAccess();
        this.lock.lock();
        try {
            this.safeClose(this.writer);
            this.writer = null;
            this.initialize = true;
        }
        finally {
            this.lock.unlock();
        }
        super.close();
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public void setAddress(InetAddress address) {
        SocketHandler.checkAccess();
        this.lock.lock();
        try {
            if (!this.address.equals(address)) {
                this.initialize = true;
                this.clientSocketFactory = null;
            }
            this.address = address;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setHostname(String hostname) throws UnknownHostException {
        SocketHandler.checkAccess();
        this.setAddress(InetAddress.getByName(hostname));
    }

    public boolean isBlockOnReconnect() {
        this.lock.lock();
        try {
            boolean bl = this.blockOnReconnect;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setBlockOnReconnect(boolean blockOnReconnect) {
        SocketHandler.checkAccess();
        this.lock.lock();
        try {
            this.blockOnReconnect = blockOnReconnect;
            this.initialize = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Protocol protocol) {
        SocketHandler.checkAccess();
        this.lock.lock();
        try {
            if (protocol == null) {
                this.protocol = Protocol.TCP;
            }
            if (this.protocol != protocol) {
                this.socketFactory = null;
                this.initialize = true;
            }
            this.protocol = protocol;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        SocketHandler.checkAccess();
        this.lock.lock();
        try {
            if (this.port != port) {
                this.initialize = true;
                this.clientSocketFactory = null;
            }
            this.port = port;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setSocketFactory(SocketFactory socketFactory) {
        SocketHandler.checkAccess();
        this.lock.lock();
        try {
            this.socketFactory = socketFactory;
            this.clientSocketFactory = null;
            this.initialize = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void setClientSocketFactory(ClientSocketFactory clientSocketFactory) {
        SocketHandler.checkAccess();
        this.lock.lock();
        try {
            this.clientSocketFactory = clientSocketFactory;
            this.initialize = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialize() {
        Writer current = this.writer;
        boolean okay = false;
        try {
            if (current != null) {
                this.writeTail(current);
                this.safeFlush(current);
            }
            this.safeClose(current);
            OutputStream out = this.createOutputStream();
            if (out == null) {
                return;
            }
            String encoding = this.getEncoding();
            UninterruptibleOutputStream outputStream = new UninterruptibleOutputStream(out);
            this.writer = encoding == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter((OutputStream)outputStream, encoding);
            this.writeHead(this.writer);
            okay = true;
        }
        catch (UnsupportedEncodingException e) {
            this.reportError("Error opening", e, 4);
        }
        finally {
            this.safeClose(current);
            if (!okay) {
                this.safeClose(this.writer);
            }
        }
    }

    private OutputStream createOutputStream() {
        if (this.address != null || this.port >= 0) {
            try {
                ClientSocketFactory socketFactory = this.getClientSocketFactory();
                if (this.protocol == Protocol.UDP) {
                    return new UdpOutputStream(socketFactory);
                }
                return new TcpOutputStream(socketFactory, this.blockOnReconnect);
            }
            catch (IOException e) {
                this.reportError("Failed to create socket output stream", e, 4);
            }
        }
        return null;
    }

    private ClientSocketFactory getClientSocketFactory() {
        this.lock.lock();
        try {
            if (this.clientSocketFactory != null) {
                ClientSocketFactory clientSocketFactory = this.clientSocketFactory;
                return clientSocketFactory;
            }
            if (this.address == null || this.port <= 0) {
                throw new IllegalStateException("An address and port greater than 0 is required.");
            }
            ClientSocketFactory clientSocketFactory = this.socketFactory == null ? (this.protocol == Protocol.SSL_TCP ? ClientSocketFactory.of(SSLSocketFactory.getDefault(), this.address, this.port) : ClientSocketFactory.of(this.address, this.port)) : ClientSocketFactory.of(this.socketFactory, this.address, this.port);
            ClientSocketFactory clientSocketFactory2 = clientSocketFactory;
            return clientSocketFactory2;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void writeHead(Writer writer) {
        try {
            Formatter formatter = this.getFormatter();
            if (formatter != null) {
                writer.write(formatter.getHead(this));
            }
        }
        catch (Exception e) {
            this.reportError("Error writing section header", e, 1);
        }
    }

    private void writeTail(Writer writer) {
        try {
            Formatter formatter = this.getFormatter();
            if (formatter != null) {
                writer.write(formatter.getTail(this));
            }
        }
        catch (Exception ex) {
            this.reportError("Error writing section tail", ex, 1);
        }
    }

    private void safeClose(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (Exception e) {
            this.reportError("Error closing resource", e, 3);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void safeFlush(Flushable f) {
        try {
            if (f != null) {
                f.flush();
            }
        }
        catch (Exception e) {
            this.reportError("Error on flush", e, 2);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static enum Protocol {
        TCP,
        UDP,
        SSL_TCP;

    }
}

